# @HEADER
# *****************************************************************************
#            TriBITS: Tribal Build, Integrate, and Test System
#
# Copyright 2013-2016 NTESS and the TriBITS contributors.
# SPDX-License-Identifier: BSD-3-Clause
# *****************************************************************************
# @HEADER

##############################################################################
#
# CMake variable for use by Trilinos/Shards clients.
#
# Do not edit: This file was generated automatically by CMake.
#
##############################################################################

if(CMAKE_VERSION VERSION_LESS 3.3)
  set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
    "Shards requires CMake 3.3 or later for 'if (... IN_LIST ...)'"
    )
  set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
  return()
endif()
cmake_minimum_required(VERSION 3.3...3.23.0)

## ---------------------------------------------------------------------------
## Compilers used by Trilinos/Shards build
## ---------------------------------------------------------------------------

set(Shards_CXX_COMPILER "D:/M/msys64/ucrt64/bin/g++.exe")

set(Shards_C_COMPILER "D:/M/msys64/ucrt64/bin/gcc.exe")

set(Shards_Fortran_COMPILER "D:/M/msys64/ucrt64/bin/gfortran.exe")
# Deprecated!
set(Shards_FORTRAN_COMPILER "D:/M/msys64/ucrt64/bin/gfortran.exe") 


## ---------------------------------------------------------------------------
## Compiler flags used by Trilinos/Shards build
## ---------------------------------------------------------------------------

## Give the build type
set(Shards_CMAKE_BUILD_TYPE "Release")

## Set compiler flags, including those determined by build type
set(Shards_CXX_FLAGS [[ ]])

set(Shards_C_FLAGS [[  -march=nocona -msahf -mtune=generic -O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong -Wp,-D__USE_MINGW_ANSI_STDIO=1 ]])

set(Shards_Fortran_FLAGS [[ ]])
# Deprecated
set(Shards_FORTRAN_FLAGS [[ ]])

## Extra link flags (e.g., specification of fortran libraries)
set(Shards_EXTRA_LD_FLAGS [[]])

## This is the command-line entry used for setting rpaths. In a build
## with static libraries it will be empty.
set(Shards_SHARED_LIB_RPATH_COMMAND "/ucrt64/lib")
set(Shards_BUILD_SHARED_LIBS "ON")

set(Shards_LINKER D:/M/msys64/ucrt64/bin/ld.exe)
set(Shards_AR D:/M/msys64/ucrt64/bin/ar.exe)

## ---------------------------------------------------------------------------
## Set library specifications and paths
## ---------------------------------------------------------------------------

## Base install location (if not in the build tree)
set(Shards_INSTALL_DIR "/ucrt64")

## List of package libraries
set(Shards_LIBRARIES Shards::all_libs)

## ---------------------------------------------------------------------------
## MPI specific variables
##   These variables are provided to make it easier to get the mpi libraries
##   and includes on systems that do not use the mpi wrappers for compiling
## ---------------------------------------------------------------------------

set(Shards_MPI_LIBRARIES "")
set(Shards_MPI_LIBRARY_DIRS "")
set(Shards_MPI_INCLUDE_DIRS "")
set(Shards_MPI_EXEC "")
set(Shards_MPI_EXEC_MAX_NUMPROCS "")
set(Shards_MPI_EXEC_NUMPROCS_FLAG "")

## ---------------------------------------------------------------------------
## Set useful general variables
## ---------------------------------------------------------------------------

# Enables/Disables for upstream package dependencies

# Exported cache variables

# Include configuration of dependent packages

# Import Shards targets
include("${CMAKE_CURRENT_LIST_DIR}/ShardsTargets.cmake")

# Standard TriBITS-compliant external package variables
set(Shards_IS_TRIBITS_COMPLIANT TRUE)
set(Shards_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE "${CMAKE_CURRENT_LIST_FILE}")
set(Shards_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE_DIR "${CMAKE_CURRENT_LIST_DIR}")


## ----------------------------------------------------------------------------
## Create deprecated non-namespaced library targets for backwards compatibility
## ----------------------------------------------------------------------------

set(Shards_EXPORTED_PACKAGE_LIBS_NAMES "shards")

foreach(libname IN LISTS Shards_EXPORTED_PACKAGE_LIBS_NAMES)
  if (NOT TARGET ${libname})
    add_library(${libname} INTERFACE IMPORTED)
    target_link_libraries(${libname}
       INTERFACE Shards::${libname})
    set(deprecationMessage
      "WARNING: The non-namespaced target '${libname}' is deprecated!"
      "  If always using newer versions of the project 'Trilinos', then use the"
      " new namespaced target 'Shards::${libname}', or better yet,"
      " 'Shards::all_libs' to be less sensitive to changes in the definition"
      " of targets in the package 'Shards'.  Or, to maintain compatibility with"
      " older or newer versions the project 'Trilinos', instead link against the"
      " libraries specified by the variable 'Shards_LIBRARIES'."
      )
    string(REPLACE ";" "" deprecationMessage "${deprecationMessage}")
    set_target_properties(${libname}
      PROPERTIES DEPRECATION "${deprecationMessage}" )
  endif()
endforeach()
