/* This file was automatically generated from tixi.h on 2025-09-30 */

/* 
* Copyright (C) 2007-2012 German Aerospace Center (DLR/SC)
*
* Created: 2012-08-13 Martin Siggel <martin.siggel@dlr.de>
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* Visual Studio C macros */
#ifdef _MSC_VER
  #ifndef _CRT_SECURE_NO_WARNINGS
    #define _CRT_SECURE_NO_WARNINGS
  #endif
  #pragma warning(disable: 4090)
  #if _MSC_VER < 1900
    #define snprintf _snprintf
  #endif
#endif

#include <math.h>
#include <matrix.h>
#include <mex.h>

#include <string.h>
#include <stdio.h>

#include "common.h"

#if defined(WIN32)
  #define MEX_EXPORT __declspec(dllexport)
#endif

/*
 * helping function to convert matlab array into c-string 
 */
int mxToString(const mxArray * mxStr, char ** cstr)
{
  size_t strLen = 0;

       /* Input must be a string. */
  if (mxIsChar(mxStr) != 1) {
    mexErrMsgTxt("Input must be a string.");
    return 1;
  }

  /* Input must be a row vector. */
  if (mxGetM(mxStr) > 1) {
    mexErrMsgTxt("Input must be a row vector.");
    return 1;
  }
    
  /* Get the length of the input string. */
  strLen = mxGetNumberOfElements(mxStr) + 1;

  /* Allocate memory for input and output strings. */
  *cstr = (char*) mxCalloc(strLen, sizeof(char));

  /* Copy the string data from prhs[0] into a C string 
   * input_buf. */
  return mxGetString(mxStr, *cstr, strLen);
}

mwSize mxGetArraySize(const mxArray * mxArr)
{
    mwSize ndims =  mxGetNumberOfDimensions(mxArr);
    mwSize idim;

    mwSize totalSize = 1;
    for (idim = 0; idim < ndims; ++idim) {
        totalSize *= mxGetDimensions(mxArr)[idim];
    }
    
    return totalSize;
}

int mxToInt(const mxArray * mxArr)
{
    double dv = *mxGetPr(mxArr);
    if(!isinteger(dv))
        mexWarnMsgTxt("Argument is not an integer\n");

    return (int)dv;
}

size_t mxToSize_t(const mxArray * mxArr)
{
    double dv = *mxGetPr(mxArr);
    if(!isinteger(dv))
        mexWarnMsgTxt("Argument is not an integer\n");

    return (size_t)dv;
}

void mxToIntArray(const mxArray * mxArr, int ** pIntArray)
{
    mwSize i, totalSize;
    totalSize = mxGetArraySize(mxArr);
    
    *pIntArray = (int*) mxMalloc(sizeof(int)*totalSize);
    for (i = 0; i< totalSize; ++i) {
        (*pIntArray)[i] = (int)mxGetPr(mxArr)[i];
    }
}

mxArray * iArrayToMx(const int * array, int size)
{
    mxArray * out = mxCreateDoubleMatrix(1,size, mxREAL);
    double * rawArray = mxGetPr(out);
    int i;
    for (i = 0; i < size; ++i) {
        rawArray[i] = (double) array[i];
    }
    
    return out;
}

mxArray * dArrayToMx(const double * array, int size)
{
    mxArray * out = mxCreateDoubleMatrix(1,size, mxREAL);
    double *  rawArray = mxGetPr(out);
    int i;
    for (i = 0; i < size; ++i) {
        rawArray[i] = array[i];
    }
    
    return out;
}


#include <tixi.h>

void handleError(const char * funcname, ReturnCode code)
{
    if (code != SUCCESS) {
        char errormsg[1024];
        sprintf(errormsg, "Error: \"%s\" returned code %d", funcname, code);
        mexErrMsgTxt(errormsg);
    }
}

void mex_tixiGetVersion(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    char* ret = NULL;

    /* check for corect number of in and out args */
    if (nrhs != 1) {
        mexErrMsgTxt("tixiGetVersion(): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiGetVersion(): Wrong number of output values. This function returns 1 value(s)\n");
    }


    ret = tixiGetVersion();

    plhs[0] = mxCreateString(ret);
}

void mex_tixiOpenDocument(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    char* xmlFilename = NULL;

    /* output variables */
    TixiDocumentHandle handle;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 2) {
        mexErrMsgTxt("tixiOpenDocument(xmlFilename): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiOpenDocument(xmlFilename): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!mxIsChar(prhs[1])) {
        mexErrMsgTxt("Argument 'xmlFilename' must be a string.\n");
    }

    mxToString(prhs[1], &xmlFilename);

    ret = tixiOpenDocument(xmlFilename, &handle);
    handleError("tixiOpenDocument", ret);

    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = (double)handle;
}

void mex_tixiOpenDocumentRecursive(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    char* xmlFilename = NULL;
    OpenMode oMode;

    /* output variables */
    TixiDocumentHandle handle;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 3) {
        mexErrMsgTxt("tixiOpenDocumentRecursive(xmlFilename, oMode): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiOpenDocumentRecursive(xmlFilename, oMode): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!mxIsChar(prhs[1])) {
        mexErrMsgTxt("Argument 'xmlFilename' must be a string.\n");
    }

    if (!isscalar(prhs[2])) {
        mexErrMsgTxt("Argument 'oMode' must not be an array.\n");
    }

    mxToString(prhs[1], &xmlFilename);
    oMode = mxToInt(prhs[2]);

    ret = tixiOpenDocumentRecursive(xmlFilename, &handle, oMode);
    handleError("tixiOpenDocumentRecursive", ret);

    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = (double)handle;
}

void mex_tixiOpenDocumentFromHTTP(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    char* httpURL = NULL;

    /* output variables */
    TixiDocumentHandle handle;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 2) {
        mexErrMsgTxt("tixiOpenDocumentFromHTTP(httpURL): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiOpenDocumentFromHTTP(httpURL): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!mxIsChar(prhs[1])) {
        mexErrMsgTxt("Argument 'httpURL' must be a string.\n");
    }

    mxToString(prhs[1], &httpURL);

    ret = tixiOpenDocumentFromHTTP(httpURL, &handle);
    handleError("tixiOpenDocumentFromHTTP", ret);

    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = (double)handle;
}

void mex_tixiCreateDocument(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    char* rootElementName = NULL;

    /* output variables */
    TixiDocumentHandle handle;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 2) {
        mexErrMsgTxt("tixiCreateDocument(rootElementName): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiCreateDocument(rootElementName): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!mxIsChar(prhs[1])) {
        mexErrMsgTxt("Argument 'rootElementName' must be a string.\n");
    }

    mxToString(prhs[1], &rootElementName);

    ret = tixiCreateDocument(rootElementName, &handle);
    handleError("tixiCreateDocument", ret);

    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = (double)handle;
}

void mex_tixiGetDocumentPath(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;

    /* output variables */
    char* documentPath = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 2) {
        mexErrMsgTxt("tixiGetDocumentPath(handle): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiGetDocumentPath(handle): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    handle = mxToInt(prhs[1]);

    ret = tixiGetDocumentPath(handle, &documentPath);
    handleError("tixiGetDocumentPath", ret);

    plhs[0] = mxCreateString(documentPath);
}

void mex_tixiSaveDocument(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* xmlFilename = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 3) {
        mexErrMsgTxt("tixiSaveDocument(handle, xmlFilename): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiSaveDocument(handle, xmlFilename): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'xmlFilename' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &xmlFilename);

    ret = tixiSaveDocument(handle, xmlFilename);
    handleError("tixiSaveDocument", ret);

}

void mex_tixiSaveCompleteDocument(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* xmlFilename = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 3) {
        mexErrMsgTxt("tixiSaveCompleteDocument(handle, xmlFilename): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiSaveCompleteDocument(handle, xmlFilename): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'xmlFilename' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &xmlFilename);

    ret = tixiSaveCompleteDocument(handle, xmlFilename);
    handleError("tixiSaveCompleteDocument", ret);

}

void mex_tixiSaveAndRemoveDocument(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* xmlFilename = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 3) {
        mexErrMsgTxt("tixiSaveAndRemoveDocument(handle, xmlFilename): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiSaveAndRemoveDocument(handle, xmlFilename): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'xmlFilename' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &xmlFilename);

    ret = tixiSaveAndRemoveDocument(handle, xmlFilename);
    handleError("tixiSaveAndRemoveDocument", ret);

}

void mex_tixiCloseDocument(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 2) {
        mexErrMsgTxt("tixiCloseDocument(handle): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiCloseDocument(handle): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    handle = mxToInt(prhs[1]);

    ret = tixiCloseDocument(handle);
    handleError("tixiCloseDocument", ret);

}

void mex_tixiCloseAllDocuments(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 1) {
        mexErrMsgTxt("tixiCloseAllDocuments(): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiCloseAllDocuments(): Wrong number of output values. This function returns 0 value(s)\n");
    }


    ret = tixiCloseAllDocuments();
    handleError("tixiCloseAllDocuments", ret);

}

void mex_tixiCleanup(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 1) {
        mexErrMsgTxt("tixiCleanup(): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiCleanup(): Wrong number of output values. This function returns 0 value(s)\n");
    }


    ret = tixiCleanup();
    handleError("tixiCleanup", ret);

}

void mex_tixiExportDocumentAsString(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;

    /* output variables */
    char* text = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 2) {
        mexErrMsgTxt("tixiExportDocumentAsString(handle): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiExportDocumentAsString(handle): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    handle = mxToInt(prhs[1]);

    ret = tixiExportDocumentAsString(handle, &text);
    handleError("tixiExportDocumentAsString", ret);

    plhs[0] = mxCreateString(text);
}

void mex_tixiImportFromString(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    char* xmlImportString = NULL;

    /* output variables */
    TixiDocumentHandle handle;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 2) {
        mexErrMsgTxt("tixiImportFromString(xmlImportString): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiImportFromString(xmlImportString): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!mxIsChar(prhs[1])) {
        mexErrMsgTxt("Argument 'xmlImportString' must be a string.\n");
    }

    mxToString(prhs[1], &xmlImportString);

    ret = tixiImportFromString(xmlImportString, &handle);
    handleError("tixiImportFromString", ret);

    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = (double)handle;
}

void mex_tixiSchemaValidateFromFile(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* xsdFilename = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 3) {
        mexErrMsgTxt("tixiSchemaValidateFromFile(handle, xsdFilename): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiSchemaValidateFromFile(handle, xsdFilename): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'xsdFilename' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &xsdFilename);

    ret = tixiSchemaValidateFromFile(handle, xsdFilename);
    handleError("tixiSchemaValidateFromFile", ret);

}

void mex_tixiSchemaValidateWithDefaultsFromFile(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* xsdFilename = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 3) {
        mexErrMsgTxt("tixiSchemaValidateWithDefaultsFromFile(handle, xsdFilename): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiSchemaValidateWithDefaultsFromFile(handle, xsdFilename): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'xsdFilename' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &xsdFilename);

    ret = tixiSchemaValidateWithDefaultsFromFile(handle, xsdFilename);
    handleError("tixiSchemaValidateWithDefaultsFromFile", ret);

}

void mex_tixiSchemaValidateFromString(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* xsdString = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 3) {
        mexErrMsgTxt("tixiSchemaValidateFromString(handle, xsdString): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiSchemaValidateFromString(handle, xsdString): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'xsdString' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &xsdString);

    ret = tixiSchemaValidateFromString(handle, xsdString);
    handleError("tixiSchemaValidateFromString", ret);

}

void mex_tixiDTDValidate(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* DTDFilename = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 3) {
        mexErrMsgTxt("tixiDTDValidate(handle, DTDFilename): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiDTDValidate(handle, DTDFilename): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'DTDFilename' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &DTDFilename);

    ret = tixiDTDValidate(handle, DTDFilename);
    handleError("tixiDTDValidate", ret);

}

void mex_tixiGetTextElement(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* elementPath = NULL;

    /* output variables */
    char* text = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 3) {
        mexErrMsgTxt("tixiGetTextElement(handle, elementPath): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiGetTextElement(handle, elementPath): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'elementPath' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &elementPath);

    ret = tixiGetTextElement(handle, elementPath, &text);
    handleError("tixiGetTextElement", ret);

    plhs[0] = mxCreateString(text);
}

void mex_tixiGetIntegerElement(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* elementPath = NULL;

    /* output variables */
    int number;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 3) {
        mexErrMsgTxt("tixiGetIntegerElement(handle, elementPath): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiGetIntegerElement(handle, elementPath): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'elementPath' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &elementPath);

    ret = tixiGetIntegerElement(handle, elementPath, &number);
    handleError("tixiGetIntegerElement", ret);

    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = (double)number;
}

void mex_tixiGetDoubleElement(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* elementPath = NULL;

    /* output variables */
    double number;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 3) {
        mexErrMsgTxt("tixiGetDoubleElement(handle, elementPath): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiGetDoubleElement(handle, elementPath): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'elementPath' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &elementPath);

    ret = tixiGetDoubleElement(handle, elementPath, &number);
    handleError("tixiGetDoubleElement", ret);

    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = number;
}

void mex_tixiGetBooleanElement(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* elementPath = NULL;

    /* output variables */
    int boolean;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 3) {
        mexErrMsgTxt("tixiGetBooleanElement(handle, elementPath): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiGetBooleanElement(handle, elementPath): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'elementPath' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &elementPath);

    ret = tixiGetBooleanElement(handle, elementPath, &boolean);
    handleError("tixiGetBooleanElement", ret);

    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = (double)boolean;
}

void mex_tixiUpdateTextElement(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* elementPath = NULL;
    char* text = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 4) {
        mexErrMsgTxt("tixiUpdateTextElement(handle, elementPath, text): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiUpdateTextElement(handle, elementPath, text): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'elementPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'text' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &elementPath);
    mxToString(prhs[3], &text);

    ret = tixiUpdateTextElement(handle, elementPath, text);
    handleError("tixiUpdateTextElement", ret);

}

void mex_tixiUpdateDoubleElement(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* elementPath = NULL;
    double number;
    char* format = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 5) {
        mexErrMsgTxt("tixiUpdateDoubleElement(handle, elementPath, number, format): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiUpdateDoubleElement(handle, elementPath, number, format): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'elementPath' must be a string.\n");
    }

    if (!isscalar(prhs[3])) {
        mexErrMsgTxt("Argument 'number' must not be an array.\n");
    }

    if (!mxIsChar(prhs[4])) {
        mexErrMsgTxt("Argument 'format' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &elementPath);
    number = *mxGetPr(prhs[3]);
    mxToString(prhs[4], &format);

    ret = tixiUpdateDoubleElement(handle, elementPath, number, format);
    handleError("tixiUpdateDoubleElement", ret);

}

void mex_tixiUpdateIntegerElement(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* elementPath = NULL;
    int number;
    char* format = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 5) {
        mexErrMsgTxt("tixiUpdateIntegerElement(handle, elementPath, number, format): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiUpdateIntegerElement(handle, elementPath, number, format): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'elementPath' must be a string.\n");
    }

    if (!isscalar(prhs[3])) {
        mexErrMsgTxt("Argument 'number' must not be an array.\n");
    }

    if (!mxIsChar(prhs[4])) {
        mexErrMsgTxt("Argument 'format' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &elementPath);
    number = mxToInt(prhs[3]);
    mxToString(prhs[4], &format);

    ret = tixiUpdateIntegerElement(handle, elementPath, number, format);
    handleError("tixiUpdateIntegerElement", ret);

}

void mex_tixiUpdateBooleanElement(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* elementPath = NULL;
    int boolean;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 4) {
        mexErrMsgTxt("tixiUpdateBooleanElement(handle, elementPath, boolean): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiUpdateBooleanElement(handle, elementPath, boolean): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'elementPath' must be a string.\n");
    }

    if (!isscalar(prhs[3])) {
        mexErrMsgTxt("Argument 'boolean' must not be an array.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &elementPath);
    boolean = mxToInt(prhs[3]);

    ret = tixiUpdateBooleanElement(handle, elementPath, boolean);
    handleError("tixiUpdateBooleanElement", ret);

}

void mex_tixiAddTextElement(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* parentPath = NULL;
    char* elementName = NULL;
    char* text = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 5) {
        mexErrMsgTxt("tixiAddTextElement(handle, parentPath, elementName, text): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiAddTextElement(handle, parentPath, elementName, text): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'parentPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'elementName' must be a string.\n");
    }

    if (!mxIsChar(prhs[4])) {
        mexErrMsgTxt("Argument 'text' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &parentPath);
    mxToString(prhs[3], &elementName);
    mxToString(prhs[4], &text);

    ret = tixiAddTextElement(handle, parentPath, elementName, text);
    handleError("tixiAddTextElement", ret);

}

void mex_tixiAddTextElementNS(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* parentPath = NULL;
    char* qualifiedName = NULL;
    char* namespaceURI = NULL;
    char* text = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 6) {
        mexErrMsgTxt("tixiAddTextElementNS(handle, parentPath, qualifiedName, namespaceURI, text): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiAddTextElementNS(handle, parentPath, qualifiedName, namespaceURI, text): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'parentPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'qualifiedName' must be a string.\n");
    }

    if (!mxIsChar(prhs[4])) {
        mexErrMsgTxt("Argument 'namespaceURI' must be a string.\n");
    }

    if (!mxIsChar(prhs[5])) {
        mexErrMsgTxt("Argument 'text' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &parentPath);
    mxToString(prhs[3], &qualifiedName);
    mxToString(prhs[4], &namespaceURI);
    mxToString(prhs[5], &text);

    ret = tixiAddTextElementNS(handle, parentPath, qualifiedName, namespaceURI, text);
    handleError("tixiAddTextElementNS", ret);

}

void mex_tixiAddTextElementAtIndex(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* parentPath = NULL;
    char* elementName = NULL;
    char* text = NULL;
    int index;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 6) {
        mexErrMsgTxt("tixiAddTextElementAtIndex(handle, parentPath, elementName, text, index): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiAddTextElementAtIndex(handle, parentPath, elementName, text, index): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'parentPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'elementName' must be a string.\n");
    }

    if (!mxIsChar(prhs[4])) {
        mexErrMsgTxt("Argument 'text' must be a string.\n");
    }

    if (!isscalar(prhs[5])) {
        mexErrMsgTxt("Argument 'index' must not be an array.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &parentPath);
    mxToString(prhs[3], &elementName);
    mxToString(prhs[4], &text);
    index = mxToInt(prhs[5]);

    ret = tixiAddTextElementAtIndex(handle, parentPath, elementName, text, index);
    handleError("tixiAddTextElementAtIndex", ret);

}

void mex_tixiAddTextElementNSAtIndex(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* parentPath = NULL;
    char* qualifiedName = NULL;
    char* namespaceURI = NULL;
    char* text = NULL;
    int index;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 7) {
        mexErrMsgTxt("tixiAddTextElementNSAtIndex(handle, parentPath, qualifiedName, namespaceURI, text, index): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiAddTextElementNSAtIndex(handle, parentPath, qualifiedName, namespaceURI, text, index): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'parentPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'qualifiedName' must be a string.\n");
    }

    if (!mxIsChar(prhs[4])) {
        mexErrMsgTxt("Argument 'namespaceURI' must be a string.\n");
    }

    if (!mxIsChar(prhs[5])) {
        mexErrMsgTxt("Argument 'text' must be a string.\n");
    }

    if (!isscalar(prhs[6])) {
        mexErrMsgTxt("Argument 'index' must not be an array.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &parentPath);
    mxToString(prhs[3], &qualifiedName);
    mxToString(prhs[4], &namespaceURI);
    mxToString(prhs[5], &text);
    index = mxToInt(prhs[6]);

    ret = tixiAddTextElementNSAtIndex(handle, parentPath, qualifiedName, namespaceURI, text, index);
    handleError("tixiAddTextElementNSAtIndex", ret);

}

void mex_tixiAddBooleanElement(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* parentPath = NULL;
    char* elementName = NULL;
    int boolean;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 5) {
        mexErrMsgTxt("tixiAddBooleanElement(handle, parentPath, elementName, boolean): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiAddBooleanElement(handle, parentPath, elementName, boolean): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'parentPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'elementName' must be a string.\n");
    }

    if (!isscalar(prhs[4])) {
        mexErrMsgTxt("Argument 'boolean' must not be an array.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &parentPath);
    mxToString(prhs[3], &elementName);
    boolean = mxToInt(prhs[4]);

    ret = tixiAddBooleanElement(handle, parentPath, elementName, boolean);
    handleError("tixiAddBooleanElement", ret);

}

void mex_tixiAddBooleanElementNS(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* parentPath = NULL;
    char* qualifiedName = NULL;
    char* namespaceURI = NULL;
    int boolean;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 6) {
        mexErrMsgTxt("tixiAddBooleanElementNS(handle, parentPath, qualifiedName, namespaceURI, boolean): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiAddBooleanElementNS(handle, parentPath, qualifiedName, namespaceURI, boolean): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'parentPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'qualifiedName' must be a string.\n");
    }

    if (!mxIsChar(prhs[4])) {
        mexErrMsgTxt("Argument 'namespaceURI' must be a string.\n");
    }

    if (!isscalar(prhs[5])) {
        mexErrMsgTxt("Argument 'boolean' must not be an array.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &parentPath);
    mxToString(prhs[3], &qualifiedName);
    mxToString(prhs[4], &namespaceURI);
    boolean = mxToInt(prhs[5]);

    ret = tixiAddBooleanElementNS(handle, parentPath, qualifiedName, namespaceURI, boolean);
    handleError("tixiAddBooleanElementNS", ret);

}

void mex_tixiAddDoubleElement(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* parentPath = NULL;
    char* elementName = NULL;
    double number;
    char* format = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 6) {
        mexErrMsgTxt("tixiAddDoubleElement(handle, parentPath, elementName, number, format): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiAddDoubleElement(handle, parentPath, elementName, number, format): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'parentPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'elementName' must be a string.\n");
    }

    if (!isscalar(prhs[4])) {
        mexErrMsgTxt("Argument 'number' must not be an array.\n");
    }

    if (!mxIsChar(prhs[5])) {
        mexErrMsgTxt("Argument 'format' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &parentPath);
    mxToString(prhs[3], &elementName);
    number = *mxGetPr(prhs[4]);
    mxToString(prhs[5], &format);

    ret = tixiAddDoubleElement(handle, parentPath, elementName, number, format);
    handleError("tixiAddDoubleElement", ret);

}

void mex_tixiAddDoubleElementNS(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* parentPath = NULL;
    char* qualifiedName = NULL;
    char* namespaceURI = NULL;
    double number;
    char* format = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 7) {
        mexErrMsgTxt("tixiAddDoubleElementNS(handle, parentPath, qualifiedName, namespaceURI, number, format): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiAddDoubleElementNS(handle, parentPath, qualifiedName, namespaceURI, number, format): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'parentPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'qualifiedName' must be a string.\n");
    }

    if (!mxIsChar(prhs[4])) {
        mexErrMsgTxt("Argument 'namespaceURI' must be a string.\n");
    }

    if (!isscalar(prhs[5])) {
        mexErrMsgTxt("Argument 'number' must not be an array.\n");
    }

    if (!mxIsChar(prhs[6])) {
        mexErrMsgTxt("Argument 'format' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &parentPath);
    mxToString(prhs[3], &qualifiedName);
    mxToString(prhs[4], &namespaceURI);
    number = *mxGetPr(prhs[5]);
    mxToString(prhs[6], &format);

    ret = tixiAddDoubleElementNS(handle, parentPath, qualifiedName, namespaceURI, number, format);
    handleError("tixiAddDoubleElementNS", ret);

}

void mex_tixiAddIntegerElement(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* parentPath = NULL;
    char* elementName = NULL;
    int number;
    char* format = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 6) {
        mexErrMsgTxt("tixiAddIntegerElement(handle, parentPath, elementName, number, format): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiAddIntegerElement(handle, parentPath, elementName, number, format): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'parentPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'elementName' must be a string.\n");
    }

    if (!isscalar(prhs[4])) {
        mexErrMsgTxt("Argument 'number' must not be an array.\n");
    }

    if (!mxIsChar(prhs[5])) {
        mexErrMsgTxt("Argument 'format' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &parentPath);
    mxToString(prhs[3], &elementName);
    number = mxToInt(prhs[4]);
    mxToString(prhs[5], &format);

    ret = tixiAddIntegerElement(handle, parentPath, elementName, number, format);
    handleError("tixiAddIntegerElement", ret);

}

void mex_tixiAddIntegerElementNS(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* parentPath = NULL;
    char* qualifiedName = NULL;
    char* namespaceURI = NULL;
    int number;
    char* format = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 7) {
        mexErrMsgTxt("tixiAddIntegerElementNS(handle, parentPath, qualifiedName, namespaceURI, number, format): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiAddIntegerElementNS(handle, parentPath, qualifiedName, namespaceURI, number, format): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'parentPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'qualifiedName' must be a string.\n");
    }

    if (!mxIsChar(prhs[4])) {
        mexErrMsgTxt("Argument 'namespaceURI' must be a string.\n");
    }

    if (!isscalar(prhs[5])) {
        mexErrMsgTxt("Argument 'number' must not be an array.\n");
    }

    if (!mxIsChar(prhs[6])) {
        mexErrMsgTxt("Argument 'format' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &parentPath);
    mxToString(prhs[3], &qualifiedName);
    mxToString(prhs[4], &namespaceURI);
    number = mxToInt(prhs[5]);
    mxToString(prhs[6], &format);

    ret = tixiAddIntegerElementNS(handle, parentPath, qualifiedName, namespaceURI, number, format);
    handleError("tixiAddIntegerElementNS", ret);

}

void mex_tixiAddFloatVector(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* parentPath = NULL;
    char* elementName = NULL;
    double* vector = NULL;
    int numElements;
    char* format = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 6) {
        mexErrMsgTxt("tixiAddFloatVector(handle, parentPath, elementName, vector, format): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiAddFloatVector(handle, parentPath, elementName, vector, format): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'parentPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'elementName' must be a string.\n");
    }

    if (!mxIsChar(prhs[5])) {
        mexErrMsgTxt("Argument 'format' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &parentPath);
    mxToString(prhs[3], &elementName);
    vector = mxGetPr(prhs[4]);
    mxToString(prhs[5], &format);
    numElements = mxGetArraySize(prhs[4]);

    ret = tixiAddFloatVector(handle, parentPath, elementName, vector, numElements, format);
    handleError("tixiAddFloatVector", ret);

}

void mex_tixiUpdateFloatVector(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* path = NULL;
    double* vector = NULL;
    int numElements;
    char* format = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 5) {
        mexErrMsgTxt("tixiUpdateFloatVector(handle, path, vector, format): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiUpdateFloatVector(handle, path, vector, format): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'path' must be a string.\n");
    }

    if (!mxIsChar(prhs[4])) {
        mexErrMsgTxt("Argument 'format' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &path);
    vector = mxGetPr(prhs[3]);
    mxToString(prhs[4], &format);
    numElements = mxGetArraySize(prhs[3]);

    ret = tixiUpdateFloatVector(handle, path, vector, numElements, format);
    handleError("tixiUpdateFloatVector", ret);

}

void mex_tixiCreateElement(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* parentPath = NULL;
    char* elementName = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 4) {
        mexErrMsgTxt("tixiCreateElement(handle, parentPath, elementName): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiCreateElement(handle, parentPath, elementName): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'parentPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'elementName' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &parentPath);
    mxToString(prhs[3], &elementName);

    ret = tixiCreateElement(handle, parentPath, elementName);
    handleError("tixiCreateElement", ret);

}

void mex_tixiCreateElementNS(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* parentPath = NULL;
    char* qualifiedName = NULL;
    char* namespaceURI = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 5) {
        mexErrMsgTxt("tixiCreateElementNS(handle, parentPath, qualifiedName, namespaceURI): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiCreateElementNS(handle, parentPath, qualifiedName, namespaceURI): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'parentPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'qualifiedName' must be a string.\n");
    }

    if (!mxIsChar(prhs[4])) {
        mexErrMsgTxt("Argument 'namespaceURI' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &parentPath);
    mxToString(prhs[3], &qualifiedName);
    mxToString(prhs[4], &namespaceURI);

    ret = tixiCreateElementNS(handle, parentPath, qualifiedName, namespaceURI);
    handleError("tixiCreateElementNS", ret);

}

void mex_tixiCreateElementAtIndex(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* parentPath = NULL;
    char* elementName = NULL;
    int index;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 5) {
        mexErrMsgTxt("tixiCreateElementAtIndex(handle, parentPath, elementName, index): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiCreateElementAtIndex(handle, parentPath, elementName, index): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'parentPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'elementName' must be a string.\n");
    }

    if (!isscalar(prhs[4])) {
        mexErrMsgTxt("Argument 'index' must not be an array.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &parentPath);
    mxToString(prhs[3], &elementName);
    index = mxToInt(prhs[4]);

    ret = tixiCreateElementAtIndex(handle, parentPath, elementName, index);
    handleError("tixiCreateElementAtIndex", ret);

}

void mex_tixiCreateElementNSAtIndex(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* parentPath = NULL;
    char* qualifiedName = NULL;
    int index;
    char* namespaceURI = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 6) {
        mexErrMsgTxt("tixiCreateElementNSAtIndex(handle, parentPath, qualifiedName, index, namespaceURI): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiCreateElementNSAtIndex(handle, parentPath, qualifiedName, index, namespaceURI): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'parentPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'qualifiedName' must be a string.\n");
    }

    if (!isscalar(prhs[4])) {
        mexErrMsgTxt("Argument 'index' must not be an array.\n");
    }

    if (!mxIsChar(prhs[5])) {
        mexErrMsgTxt("Argument 'namespaceURI' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &parentPath);
    mxToString(prhs[3], &qualifiedName);
    index = mxToInt(prhs[4]);
    mxToString(prhs[5], &namespaceURI);

    ret = tixiCreateElementNSAtIndex(handle, parentPath, qualifiedName, index, namespaceURI);
    handleError("tixiCreateElementNSAtIndex", ret);

}

void mex_tixiRenameElement(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* parentPath = NULL;
    char* oldName = NULL;
    char* newName = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 5) {
        mexErrMsgTxt("tixiRenameElement(handle, parentPath, oldName, newName): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiRenameElement(handle, parentPath, oldName, newName): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'parentPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'oldName' must be a string.\n");
    }

    if (!mxIsChar(prhs[4])) {
        mexErrMsgTxt("Argument 'newName' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &parentPath);
    mxToString(prhs[3], &oldName);
    mxToString(prhs[4], &newName);

    ret = tixiRenameElement(handle, parentPath, oldName, newName);
    handleError("tixiRenameElement", ret);

}

void mex_tixiRemoveElement(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* elementPath = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 3) {
        mexErrMsgTxt("tixiRemoveElement(handle, elementPath): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiRemoveElement(handle, elementPath): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'elementPath' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &elementPath);

    ret = tixiRemoveElement(handle, elementPath);
    handleError("tixiRemoveElement", ret);

}

void mex_tixiGetNodeType(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* nodePath = NULL;

    /* output variables */
    char* nodeType = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 3) {
        mexErrMsgTxt("tixiGetNodeType(handle, nodePath): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiGetNodeType(handle, nodePath): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'nodePath' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &nodePath);

    ret = tixiGetNodeType(handle, nodePath, &nodeType);
    handleError("tixiGetNodeType", ret);

    plhs[0] = mxCreateString(nodeType);
}

void mex_tixiGetNamedChildrenCount(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* elementPath = NULL;
    char* childName = NULL;

    /* output variables */
    int count;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 4) {
        mexErrMsgTxt("tixiGetNamedChildrenCount(handle, elementPath, childName): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiGetNamedChildrenCount(handle, elementPath, childName): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'elementPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'childName' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &elementPath);
    mxToString(prhs[3], &childName);

    ret = tixiGetNamedChildrenCount(handle, elementPath, childName, &count);
    handleError("tixiGetNamedChildrenCount", ret);

    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = (double)count;
}

void mex_tixiGetChildNodeName(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* parentElementPath = NULL;
    int index;

    /* output variables */
    char* name = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 4) {
        mexErrMsgTxt("tixiGetChildNodeName(handle, parentElementPath, index): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiGetChildNodeName(handle, parentElementPath, index): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'parentElementPath' must be a string.\n");
    }

    if (!isscalar(prhs[3])) {
        mexErrMsgTxt("Argument 'index' must not be an array.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &parentElementPath);
    index = mxToInt(prhs[3]);

    ret = tixiGetChildNodeName(handle, parentElementPath, index, &name);
    handleError("tixiGetChildNodeName", ret);

    plhs[0] = mxCreateString(name);
}

void mex_tixiGetNumberOfChilds(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* elementPath = NULL;

    /* output variables */
    int nChilds;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 3) {
        mexErrMsgTxt("tixiGetNumberOfChilds(handle, elementPath): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiGetNumberOfChilds(handle, elementPath): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'elementPath' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &elementPath);

    ret = tixiGetNumberOfChilds(handle, elementPath, &nChilds);
    handleError("tixiGetNumberOfChilds", ret);

    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = (double)nChilds;
}

void mex_tixiSwapElements(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* element1Path = NULL;
    char* element2Path = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 4) {
        mexErrMsgTxt("tixiSwapElements(handle, element1Path, element2Path): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiSwapElements(handle, element1Path, element2Path): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'element1Path' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'element2Path' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &element1Path);
    mxToString(prhs[3], &element2Path);

    ret = tixiSwapElements(handle, element1Path, element2Path);
    handleError("tixiSwapElements", ret);

}

void mex_tixiExportElementAsString(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* elementPath = NULL;

    /* output variables */
    char* text = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 3) {
        mexErrMsgTxt("tixiExportElementAsString(handle, elementPath): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiExportElementAsString(handle, elementPath): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'elementPath' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &elementPath);

    ret = tixiExportElementAsString(handle, elementPath, &text);
    handleError("tixiExportElementAsString", ret);

    plhs[0] = mxCreateString(text);
}

void mex_tixiImportElementFromString(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* parentPath = NULL;
    char* xmlImportString = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 4) {
        mexErrMsgTxt("tixiImportElementFromString(handle, parentPath, xmlImportString): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiImportElementFromString(handle, parentPath, xmlImportString): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'parentPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'xmlImportString' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &parentPath);
    mxToString(prhs[3], &xmlImportString);

    ret = tixiImportElementFromString(handle, parentPath, xmlImportString);
    handleError("tixiImportElementFromString", ret);

}

void mex_tixiGetTextAttribute(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* elementPath = NULL;
    char* attributeName = NULL;

    /* output variables */
    char* text = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 4) {
        mexErrMsgTxt("tixiGetTextAttribute(handle, elementPath, attributeName): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiGetTextAttribute(handle, elementPath, attributeName): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'elementPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'attributeName' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &elementPath);
    mxToString(prhs[3], &attributeName);

    ret = tixiGetTextAttribute(handle, elementPath, attributeName, &text);
    handleError("tixiGetTextAttribute", ret);

    plhs[0] = mxCreateString(text);
}

void mex_tixiGetIntegerAttribute(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* elementPath = NULL;
    char* attributeName = NULL;

    /* output variables */
    int number;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 4) {
        mexErrMsgTxt("tixiGetIntegerAttribute(handle, elementPath, attributeName): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiGetIntegerAttribute(handle, elementPath, attributeName): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'elementPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'attributeName' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &elementPath);
    mxToString(prhs[3], &attributeName);

    ret = tixiGetIntegerAttribute(handle, elementPath, attributeName, &number);
    handleError("tixiGetIntegerAttribute", ret);

    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = (double)number;
}

void mex_tixiGetBooleanAttribute(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* elementPath = NULL;
    char* attributeName = NULL;

    /* output variables */
    int boolean;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 4) {
        mexErrMsgTxt("tixiGetBooleanAttribute(handle, elementPath, attributeName): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiGetBooleanAttribute(handle, elementPath, attributeName): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'elementPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'attributeName' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &elementPath);
    mxToString(prhs[3], &attributeName);

    ret = tixiGetBooleanAttribute(handle, elementPath, attributeName, &boolean);
    handleError("tixiGetBooleanAttribute", ret);

    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = (double)boolean;
}

void mex_tixiGetDoubleAttribute(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* elementPath = NULL;
    char* attributeName = NULL;

    /* output variables */
    double number;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 4) {
        mexErrMsgTxt("tixiGetDoubleAttribute(handle, elementPath, attributeName): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiGetDoubleAttribute(handle, elementPath, attributeName): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'elementPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'attributeName' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &elementPath);
    mxToString(prhs[3], &attributeName);

    ret = tixiGetDoubleAttribute(handle, elementPath, attributeName, &number);
    handleError("tixiGetDoubleAttribute", ret);

    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = number;
}

void mex_tixiAddTextAttribute(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* elementPath = NULL;
    char* attributeName = NULL;
    char* attributeValue = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 5) {
        mexErrMsgTxt("tixiAddTextAttribute(handle, elementPath, attributeName, attributeValue): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiAddTextAttribute(handle, elementPath, attributeName, attributeValue): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'elementPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'attributeName' must be a string.\n");
    }

    if (!mxIsChar(prhs[4])) {
        mexErrMsgTxt("Argument 'attributeValue' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &elementPath);
    mxToString(prhs[3], &attributeName);
    mxToString(prhs[4], &attributeValue);

    ret = tixiAddTextAttribute(handle, elementPath, attributeName, attributeValue);
    handleError("tixiAddTextAttribute", ret);

}

void mex_tixiAddDoubleAttribute(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* elementPath = NULL;
    char* attributeName = NULL;
    double number;
    char* format = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 6) {
        mexErrMsgTxt("tixiAddDoubleAttribute(handle, elementPath, attributeName, number, format): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiAddDoubleAttribute(handle, elementPath, attributeName, number, format): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'elementPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'attributeName' must be a string.\n");
    }

    if (!isscalar(prhs[4])) {
        mexErrMsgTxt("Argument 'number' must not be an array.\n");
    }

    if (!mxIsChar(prhs[5])) {
        mexErrMsgTxt("Argument 'format' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &elementPath);
    mxToString(prhs[3], &attributeName);
    number = *mxGetPr(prhs[4]);
    mxToString(prhs[5], &format);

    ret = tixiAddDoubleAttribute(handle, elementPath, attributeName, number, format);
    handleError("tixiAddDoubleAttribute", ret);

}

void mex_tixiAddIntegerAttribute(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* elementPath = NULL;
    char* attributeName = NULL;
    int number;
    char* format = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 6) {
        mexErrMsgTxt("tixiAddIntegerAttribute(handle, elementPath, attributeName, number, format): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiAddIntegerAttribute(handle, elementPath, attributeName, number, format): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'elementPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'attributeName' must be a string.\n");
    }

    if (!isscalar(prhs[4])) {
        mexErrMsgTxt("Argument 'number' must not be an array.\n");
    }

    if (!mxIsChar(prhs[5])) {
        mexErrMsgTxt("Argument 'format' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &elementPath);
    mxToString(prhs[3], &attributeName);
    number = mxToInt(prhs[4]);
    mxToString(prhs[5], &format);

    ret = tixiAddIntegerAttribute(handle, elementPath, attributeName, number, format);
    handleError("tixiAddIntegerAttribute", ret);

}

void mex_tixiRemoveAttribute(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* elementPath = NULL;
    char* attributeName = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 4) {
        mexErrMsgTxt("tixiRemoveAttribute(handle, elementPath, attributeName): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiRemoveAttribute(handle, elementPath, attributeName): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'elementPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'attributeName' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &elementPath);
    mxToString(prhs[3], &attributeName);

    ret = tixiRemoveAttribute(handle, elementPath, attributeName);
    handleError("tixiRemoveAttribute", ret);

}

void mex_tixiGetNumberOfAttributes(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* elementPath = NULL;

    /* output variables */
    int nAttributes;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 3) {
        mexErrMsgTxt("tixiGetNumberOfAttributes(handle, elementPath): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiGetNumberOfAttributes(handle, elementPath): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'elementPath' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &elementPath);

    ret = tixiGetNumberOfAttributes(handle, elementPath, &nAttributes);
    handleError("tixiGetNumberOfAttributes", ret);

    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = (double)nAttributes;
}

void mex_tixiGetAttributeName(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* elementPath = NULL;
    int attrIndex;

    /* output variables */
    char* attrName = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 4) {
        mexErrMsgTxt("tixiGetAttributeName(handle, elementPath, attrIndex): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiGetAttributeName(handle, elementPath, attrIndex): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'elementPath' must be a string.\n");
    }

    if (!isscalar(prhs[3])) {
        mexErrMsgTxt("Argument 'attrIndex' must not be an array.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &elementPath);
    attrIndex = mxToInt(prhs[3]);

    ret = tixiGetAttributeName(handle, elementPath, attrIndex, &attrName);
    handleError("tixiGetAttributeName", ret);

    plhs[0] = mxCreateString(attrName);
}

void mex_tixiRegisterNamespace(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* namespaceURI = NULL;
    char* prefix = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 4) {
        mexErrMsgTxt("tixiRegisterNamespace(handle, namespaceURI, prefix): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiRegisterNamespace(handle, namespaceURI, prefix): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'namespaceURI' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'prefix' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &namespaceURI);
    mxToString(prhs[3], &prefix);

    ret = tixiRegisterNamespace(handle, namespaceURI, prefix);
    handleError("tixiRegisterNamespace", ret);

}

void mex_tixiRegisterNamespacesFromDocument(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 2) {
        mexErrMsgTxt("tixiRegisterNamespacesFromDocument(handle): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiRegisterNamespacesFromDocument(handle): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    handle = mxToInt(prhs[1]);

    ret = tixiRegisterNamespacesFromDocument(handle);
    handleError("tixiRegisterNamespacesFromDocument", ret);

}

void mex_tixiSetElementNamespace(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* elementPath = NULL;
    char* namespaceURI = NULL;
    char* prefix = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 5) {
        mexErrMsgTxt("tixiSetElementNamespace(handle, elementPath, namespaceURI, prefix): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiSetElementNamespace(handle, elementPath, namespaceURI, prefix): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'elementPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'namespaceURI' must be a string.\n");
    }

    if (!mxIsChar(prhs[4])) {
        mexErrMsgTxt("Argument 'prefix' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &elementPath);
    mxToString(prhs[3], &namespaceURI);
    mxToString(prhs[4], &prefix);

    ret = tixiSetElementNamespace(handle, elementPath, namespaceURI, prefix);
    handleError("tixiSetElementNamespace", ret);

}

void mex_tixiDeclareNamespace(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* elementPath = NULL;
    char* namespaceURI = NULL;
    char* prefix = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 5) {
        mexErrMsgTxt("tixiDeclareNamespace(handle, elementPath, namespaceURI, prefix): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiDeclareNamespace(handle, elementPath, namespaceURI, prefix): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'elementPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'namespaceURI' must be a string.\n");
    }

    if (!mxIsChar(prhs[4])) {
        mexErrMsgTxt("Argument 'prefix' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &elementPath);
    mxToString(prhs[3], &namespaceURI);
    mxToString(prhs[4], &prefix);

    ret = tixiDeclareNamespace(handle, elementPath, namespaceURI, prefix);
    handleError("tixiDeclareNamespace", ret);

}

void mex_tixiAddExternalLink(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* parentPath = NULL;
    char* pathOrUrl = NULL;
    char* filename = NULL;
    AddLinkMode mode;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 6) {
        mexErrMsgTxt("tixiAddExternalLink(handle, parentPath, pathOrUrl, filename, mode): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiAddExternalLink(handle, parentPath, pathOrUrl, filename, mode): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'parentPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'pathOrUrl' must be a string.\n");
    }

    if (!mxIsChar(prhs[4])) {
        mexErrMsgTxt("Argument 'filename' must be a string.\n");
    }

    if (!isscalar(prhs[5])) {
        mexErrMsgTxt("Argument 'mode' must not be an array.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &parentPath);
    mxToString(prhs[3], &pathOrUrl);
    mxToString(prhs[4], &filename);
    mode = mxToInt(prhs[5]);

    ret = tixiAddExternalLink(handle, parentPath, pathOrUrl, filename, mode);
    handleError("tixiAddExternalLink", ret);

}

void mex_tixiRemoveExternalLinks(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 2) {
        mexErrMsgTxt("tixiRemoveExternalLinks(handle): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiRemoveExternalLinks(handle): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    handle = mxToInt(prhs[1]);

    ret = tixiRemoveExternalLinks(handle);
    handleError("tixiRemoveExternalLinks", ret);

}

void mex_tixiAddHeader(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* toolName = NULL;
    char* version = NULL;
    char* authorName = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 5) {
        mexErrMsgTxt("tixiAddHeader(handle, toolName, version, authorName): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiAddHeader(handle, toolName, version, authorName): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'toolName' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'version' must be a string.\n");
    }

    if (!mxIsChar(prhs[4])) {
        mexErrMsgTxt("Argument 'authorName' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &toolName);
    mxToString(prhs[3], &version);
    mxToString(prhs[4], &authorName);

    ret = tixiAddHeader(handle, toolName, version, authorName);
    handleError("tixiAddHeader", ret);

}

void mex_tixiAddCpacsHeader(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* name = NULL;
    char* creator = NULL;
    char* version = NULL;
    char* description = NULL;
    char* cpacsVersion = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 7) {
        mexErrMsgTxt("tixiAddCpacsHeader(handle, name, creator, version, description, cpacsVersion): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiAddCpacsHeader(handle, name, creator, version, description, cpacsVersion): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'name' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'creator' must be a string.\n");
    }

    if (!mxIsChar(prhs[4])) {
        mexErrMsgTxt("Argument 'version' must be a string.\n");
    }

    if (!mxIsChar(prhs[5])) {
        mexErrMsgTxt("Argument 'description' must be a string.\n");
    }

    if (!mxIsChar(prhs[6])) {
        mexErrMsgTxt("Argument 'cpacsVersion' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &name);
    mxToString(prhs[3], &creator);
    mxToString(prhs[4], &version);
    mxToString(prhs[5], &description);
    mxToString(prhs[6], &cpacsVersion);

    ret = tixiAddCpacsHeader(handle, name, creator, version, description, cpacsVersion);
    handleError("tixiAddCpacsHeader", ret);

}

void mex_tixiCheckElement(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* elementPath = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 3) {
        mexErrMsgTxt("tixiCheckElement(handle, elementPath): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiCheckElement(handle, elementPath): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'elementPath' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &elementPath);

    ret = tixiCheckElement(handle, elementPath);
    handleError("tixiCheckElement", ret);

}

void mex_tixiCheckDocumentHandle(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 2) {
        mexErrMsgTxt("tixiCheckDocumentHandle(handle): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiCheckDocumentHandle(handle): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    handle = mxToInt(prhs[1]);

    ret = tixiCheckDocumentHandle(handle);
    handleError("tixiCheckDocumentHandle", ret);

}

void mex_tixiUsePrettyPrint(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    int usePrettyPrint;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 3) {
        mexErrMsgTxt("tixiUsePrettyPrint(handle, usePrettyPrint): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiUsePrettyPrint(handle, usePrettyPrint): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!isscalar(prhs[2])) {
        mexErrMsgTxt("Argument 'usePrettyPrint' must not be an array.\n");
    }

    handle = mxToInt(prhs[1]);
    usePrettyPrint = mxToInt(prhs[2]);

    ret = tixiUsePrettyPrint(handle, usePrettyPrint);
    handleError("tixiUsePrettyPrint", ret);

}

void mex_tixiGetPrintMsgFunc(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    TixiPrintMsgFnc ret;

    /* check for corect number of in and out args */
    if (nrhs != 1) {
        mexErrMsgTxt("tixiGetPrintMsgFunc(): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiGetPrintMsgFunc(): Wrong number of output values. This function returns 0 value(s)\n");
    }


    ret = tixiGetPrintMsgFunc();

}

void mex_tixiSetCacheEnabled(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    int enabled;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 3) {
        mexErrMsgTxt("tixiSetCacheEnabled(handle, enabled): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiSetCacheEnabled(handle, enabled): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!isscalar(prhs[2])) {
        mexErrMsgTxt("Argument 'enabled' must not be an array.\n");
    }

    handle = mxToInt(prhs[1]);
    enabled = mxToInt(prhs[2]);

    ret = tixiSetCacheEnabled(handle, enabled);
    handleError("tixiSetCacheEnabled", ret);

}

void mex_tixiGetVectorSize(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* vectorPath = NULL;

    /* output variables */
    int nElements;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 3) {
        mexErrMsgTxt("tixiGetVectorSize(handle, vectorPath): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiGetVectorSize(handle, vectorPath): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'vectorPath' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &vectorPath);

    ret = tixiGetVectorSize(handle, vectorPath, &nElements);
    handleError("tixiGetVectorSize", ret);

    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = (double)nElements;
}

void mex_tixiGetFloatVector(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* vectorPath = NULL;
    int eNumber;

    /* output variables */
    double* vectorArray = NULL;

    int vectorArray_size;
    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 4) {
        mexErrMsgTxt("tixiGetFloatVector(handle, vectorPath, eNumber): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiGetFloatVector(handle, vectorPath, eNumber): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'vectorPath' must be a string.\n");
    }

    if (!isscalar(prhs[3])) {
        mexErrMsgTxt("Argument 'eNumber' must not be an array.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &vectorPath);
    eNumber = mxToInt(prhs[3]);

    ret = tixiGetFloatVector(handle, vectorPath, &vectorArray, eNumber);
    handleError("tixiGetFloatVector", ret);

    vectorArray_size = 1 * eNumber;
    plhs[0] = dArrayToMx(vectorArray, vectorArray_size);
}

void mex_tixiGetArrayDimensions(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* arrayPath = NULL;

    /* output variables */
    int dimensions;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 3) {
        mexErrMsgTxt("tixiGetArrayDimensions(handle, arrayPath): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiGetArrayDimensions(handle, arrayPath): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'arrayPath' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &arrayPath);

    ret = tixiGetArrayDimensions(handle, arrayPath, &dimensions);
    handleError("tixiGetArrayDimensions", ret);

    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = (double)dimensions;
}

void mex_tixiGetArrayDimensionSizes(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* arrayPath = NULL;

    /* output variables */
    int* sizes = NULL;
    int linearArraySize;

    int sizes_size;
    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 4) {
        mexErrMsgTxt("tixiGetArrayDimensionSizes(handle, arrayPath, sizes_size): Wrong number of arguments\n");
    }
    if (nlhs != 2) {
        mexErrMsgTxt("tixiGetArrayDimensionSizes(handle, arrayPath, sizes_size): Wrong number of output values. This function returns 2 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'arrayPath' must be a string.\n");
    }

    if (!isscalar(prhs[3])) {
        mexErrMsgTxt("Argument 'sizes_size' must not be an array.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &arrayPath);
    sizes_size = mxToInt(prhs[3]);

    sizes = mxMalloc(sizeof(int) * sizes_size);
    ret = tixiGetArrayDimensionSizes(handle, arrayPath, sizes, &linearArraySize);
    handleError("tixiGetArrayDimensionSizes", ret);

    plhs[0] = iArrayToMx(sizes, sizes_size);
    plhs[1] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[1]) = (double)linearArraySize;
}

void mex_tixiGetArrayDimensionNames(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* arrayPath = NULL;

    /* output variables */
    char** dimensionNames = NULL;

    int dimensionNames_size;
    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 4) {
        mexErrMsgTxt("tixiGetArrayDimensionNames(handle, arrayPath, dimensionNames_size): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiGetArrayDimensionNames(handle, arrayPath, dimensionNames_size): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'arrayPath' must be a string.\n");
    }

    if (!isscalar(prhs[3])) {
        mexErrMsgTxt("Argument 'dimensionNames_size' must not be an array.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &arrayPath);
    dimensionNames_size = mxToInt(prhs[3]);

    dimensionNames = mxMalloc(sizeof(char*) * dimensionNames_size);
    ret = tixiGetArrayDimensionNames(handle, arrayPath, dimensionNames);
    handleError("tixiGetArrayDimensionNames", ret);

    plhs[0] = mxCreateCharMatrixFromStrings(dimensionNames_size, dimensionNames);
}

void mex_tixiGetArrayDimensionValues(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* arrayPath = NULL;
    int dimension;

    /* output variables */
    double* dimensionValues = NULL;

    int dimensionValues_size;
    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 5) {
        mexErrMsgTxt("tixiGetArrayDimensionValues(handle, arrayPath, dimension, dimensionValues_size): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiGetArrayDimensionValues(handle, arrayPath, dimension, dimensionValues_size): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'arrayPath' must be a string.\n");
    }

    if (!isscalar(prhs[3])) {
        mexErrMsgTxt("Argument 'dimension' must not be an array.\n");
    }

    if (!isscalar(prhs[4])) {
        mexErrMsgTxt("Argument 'dimensionValues_size' must not be an array.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &arrayPath);
    dimension = mxToInt(prhs[3]);
    dimensionValues_size = mxToInt(prhs[4]);

    dimensionValues = mxMalloc(sizeof(double) * dimensionValues_size);
    ret = tixiGetArrayDimensionValues(handle, arrayPath, dimension, dimensionValues);
    handleError("tixiGetArrayDimensionValues", ret);

    plhs[0] = dArrayToMx(dimensionValues, dimensionValues_size);
}

void mex_tixiGetArrayParameters(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* arrayPath = NULL;

    /* output variables */
    int parameters;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 3) {
        mexErrMsgTxt("tixiGetArrayParameters(handle, arrayPath): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiGetArrayParameters(handle, arrayPath): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'arrayPath' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &arrayPath);

    ret = tixiGetArrayParameters(handle, arrayPath, &parameters);
    handleError("tixiGetArrayParameters", ret);

    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = (double)parameters;
}

void mex_tixiGetArrayParameterNames(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* arrayPath = NULL;

    /* output variables */
    char** parameterNames = NULL;

    int parameterNames_size;
    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 4) {
        mexErrMsgTxt("tixiGetArrayParameterNames(handle, arrayPath, parameterNames_size): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiGetArrayParameterNames(handle, arrayPath, parameterNames_size): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'arrayPath' must be a string.\n");
    }

    if (!isscalar(prhs[3])) {
        mexErrMsgTxt("Argument 'parameterNames_size' must not be an array.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &arrayPath);
    parameterNames_size = mxToInt(prhs[3]);

    parameterNames = mxMalloc(sizeof(char*) * parameterNames_size);
    ret = tixiGetArrayParameterNames(handle, arrayPath, parameterNames);
    handleError("tixiGetArrayParameterNames", ret);

    plhs[0] = mxCreateCharMatrixFromStrings(parameterNames_size, parameterNames);
}

void mex_tixiGetArray(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* arrayPath = NULL;
    char* elementName = NULL;
    int arraySize;

    /* output variables */
    double* values = NULL;

    int values_size;
    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 5) {
        mexErrMsgTxt("tixiGetArray(handle, arrayPath, elementName, arraySize): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiGetArray(handle, arrayPath, elementName, arraySize): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'arrayPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'elementName' must be a string.\n");
    }

    if (!isscalar(prhs[4])) {
        mexErrMsgTxt("Argument 'arraySize' must not be an array.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &arrayPath);
    mxToString(prhs[3], &elementName);
    arraySize = mxToInt(prhs[4]);

    ret = tixiGetArray(handle, arrayPath, elementName, arraySize, &values);
    handleError("tixiGetArray", ret);

    values_size = 1 * arraySize;
    plhs[0] = dArrayToMx(values, values_size);
}

void mex_tixiGetArrayValue(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    double* array = NULL;
    int* dimSize = NULL;
    int* dimPos = NULL;
    int dims;

    double ret;

    /* check for corect number of in and out args */
    if (nrhs != 5) {
        mexErrMsgTxt("tixiGetArrayValue(array, dimSize, dimPos, dims): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiGetArrayValue(array, dimSize, dimPos, dims): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[4])) {
        mexErrMsgTxt("Argument 'dims' must not be an array.\n");
    }

    array = mxGetPr(prhs[1]);
    mxToIntArray(prhs[2], &dimSize);
    mxToIntArray(prhs[3], &dimPos);
    dims = mxToInt(prhs[4]);

    ret = tixiGetArrayValue(array, dimSize, dimPos, dims);

    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = ret;
}

void mex_tixiGetArrayElementCount(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* arrayPath = NULL;
    char* elementName = NULL;

    /* output variables */
    int elements;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 4) {
        mexErrMsgTxt("tixiGetArrayElementCount(handle, arrayPath, elementName): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiGetArrayElementCount(handle, arrayPath, elementName): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'arrayPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'elementName' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &arrayPath);
    mxToString(prhs[3], &elementName);

    ret = tixiGetArrayElementCount(handle, arrayPath, elementName, &elements);
    handleError("tixiGetArrayElementCount", ret);

    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = (double)elements;
}

void mex_tixiGetArrayElementNames(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* arrayPath = NULL;
    char* elementType = NULL;

    /* output variables */
    char* elementNames = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 4) {
        mexErrMsgTxt("tixiGetArrayElementNames(handle, arrayPath, elementType): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiGetArrayElementNames(handle, arrayPath, elementType): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'arrayPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'elementType' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &arrayPath);
    mxToString(prhs[3], &elementType);

    ret = tixiGetArrayElementNames(handle, arrayPath, elementType, &elementNames);
    handleError("tixiGetArrayElementNames", ret);

    plhs[0] = mxCreateString(elementNames);
}

void mex_tixiAddPoint(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* pointParentPath = NULL;
    double x;
    double y;
    double z;
    char* format = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 7) {
        mexErrMsgTxt("tixiAddPoint(handle, pointParentPath, x, y, z, format): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiAddPoint(handle, pointParentPath, x, y, z, format): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'pointParentPath' must be a string.\n");
    }

    if (!isscalar(prhs[3])) {
        mexErrMsgTxt("Argument 'x' must not be an array.\n");
    }

    if (!isscalar(prhs[4])) {
        mexErrMsgTxt("Argument 'y' must not be an array.\n");
    }

    if (!isscalar(prhs[5])) {
        mexErrMsgTxt("Argument 'z' must not be an array.\n");
    }

    if (!mxIsChar(prhs[6])) {
        mexErrMsgTxt("Argument 'format' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &pointParentPath);
    x = *mxGetPr(prhs[3]);
    y = *mxGetPr(prhs[4]);
    z = *mxGetPr(prhs[5]);
    mxToString(prhs[6], &format);

    ret = tixiAddPoint(handle, pointParentPath, x, y, z, format);
    handleError("tixiAddPoint", ret);

}

void mex_tixiGetPoint(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* pointParentPath = NULL;

    /* output variables */
    double x;
    double y;
    double z;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 3) {
        mexErrMsgTxt("tixiGetPoint(handle, pointParentPath): Wrong number of arguments\n");
    }
    if (nlhs != 3) {
        mexErrMsgTxt("tixiGetPoint(handle, pointParentPath): Wrong number of output values. This function returns 3 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'pointParentPath' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &pointParentPath);

    ret = tixiGetPoint(handle, pointParentPath, &x, &y, &z);
    handleError("tixiGetPoint", ret);

    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = x;
    plhs[1] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[1]) = y;
    plhs[2] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[2]) = z;
}

void mex_tixiCheckAttribute(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* elementPath = NULL;
    char* attributeName = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 4) {
        mexErrMsgTxt("tixiCheckAttribute(handle, elementPath, attributeName): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiCheckAttribute(handle, elementPath, attributeName): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'elementPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'attributeName' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &elementPath);
    mxToString(prhs[3], &attributeName);

    ret = tixiCheckAttribute(handle, elementPath, attributeName);
    handleError("tixiCheckAttribute", ret);

}

void mex_tixiXSLTransformationToString(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* xslFilename = NULL;

    /* output variables */
    char* resultText = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 3) {
        mexErrMsgTxt("tixiXSLTransformationToString(handle, xslFilename): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiXSLTransformationToString(handle, xslFilename): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'xslFilename' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &xslFilename);

    ret = tixiXSLTransformationToString(handle, xslFilename, &resultText);
    handleError("tixiXSLTransformationToString", ret);

    plhs[0] = mxCreateString(resultText);
}

void mex_tixiXSLTransformationToFile(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* xslFilename = NULL;
    char* resultFilename = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 4) {
        mexErrMsgTxt("tixiXSLTransformationToFile(handle, xslFilename, resultFilename): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiXSLTransformationToFile(handle, xslFilename, resultFilename): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'xslFilename' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'resultFilename' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &xslFilename);
    mxToString(prhs[3], &resultFilename);

    ret = tixiXSLTransformationToFile(handle, xslFilename, resultFilename);
    handleError("tixiXSLTransformationToFile", ret);

}

void mex_tixiXPathEvaluateNodeNumber(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* xPathExpression = NULL;

    /* output variables */
    int number;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 3) {
        mexErrMsgTxt("tixiXPathEvaluateNodeNumber(handle, xPathExpression): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiXPathEvaluateNodeNumber(handle, xPathExpression): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'xPathExpression' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &xPathExpression);

    ret = tixiXPathEvaluateNodeNumber(handle, xPathExpression, &number);
    handleError("tixiXPathEvaluateNodeNumber", ret);

    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = (double)number;
}

void mex_tixiXPathExpressionGetXPath(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* xPathExpression = NULL;
    int index;

    /* output variables */
    char* xPath = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 4) {
        mexErrMsgTxt("tixiXPathExpressionGetXPath(handle, xPathExpression, index): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiXPathExpressionGetXPath(handle, xPathExpression, index): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'xPathExpression' must be a string.\n");
    }

    if (!isscalar(prhs[3])) {
        mexErrMsgTxt("Argument 'index' must not be an array.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &xPathExpression);
    index = mxToInt(prhs[3]);

    ret = tixiXPathExpressionGetXPath(handle, xPathExpression, index, &xPath);
    handleError("tixiXPathExpressionGetXPath", ret);

    plhs[0] = mxCreateString(xPath);
}

void mex_tixiXPathExpressionGetTextByIndex(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* xPathExpression = NULL;
    int elementNumber;

    /* output variables */
    char* text = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 4) {
        mexErrMsgTxt("tixiXPathExpressionGetTextByIndex(handle, xPathExpression, elementNumber): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiXPathExpressionGetTextByIndex(handle, xPathExpression, elementNumber): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'xPathExpression' must be a string.\n");
    }

    if (!isscalar(prhs[3])) {
        mexErrMsgTxt("Argument 'elementNumber' must not be an array.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &xPathExpression);
    elementNumber = mxToInt(prhs[3]);

    ret = tixiXPathExpressionGetTextByIndex(handle, xPathExpression, elementNumber, &text);
    handleError("tixiXPathExpressionGetTextByIndex", ret);

    plhs[0] = mxCreateString(text);
}

void mex_tixiUIDCheckDuplicates(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 2) {
        mexErrMsgTxt("tixiUIDCheckDuplicates(handle): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiUIDCheckDuplicates(handle): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    handle = mxToInt(prhs[1]);

    ret = tixiUIDCheckDuplicates(handle);
    handleError("tixiUIDCheckDuplicates", ret);

}

void mex_tixiUIDCheckLinks(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 2) {
        mexErrMsgTxt("tixiUIDCheckLinks(handle): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiUIDCheckLinks(handle): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    handle = mxToInt(prhs[1]);

    ret = tixiUIDCheckLinks(handle);
    handleError("tixiUIDCheckLinks", ret);

}

void mex_tixiUIDGetXPath(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* uID = NULL;

    /* output variables */
    char* xPath = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 3) {
        mexErrMsgTxt("tixiUIDGetXPath(handle, uID): Wrong number of arguments\n");
    }
    if (nlhs != 1) {
        mexErrMsgTxt("tixiUIDGetXPath(handle, uID): Wrong number of output values. This function returns 1 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'uID' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &uID);

    ret = tixiUIDGetXPath(handle, uID, &xPath);
    handleError("tixiUIDGetXPath", ret);

    plhs[0] = mxCreateString(xPath);
}

void mex_tixiUIDCheckExists(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* uID = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 3) {
        mexErrMsgTxt("tixiUIDCheckExists(handle, uID): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiUIDCheckExists(handle, uID): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'uID' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &uID);

    ret = tixiUIDCheckExists(handle, uID);
    handleError("tixiUIDCheckExists", ret);

}

void mex_tixiUIDSetToXPath(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    /* input arguments */
    TixiDocumentHandle handle;
    char* xPath = NULL;
    char* uID = NULL;

    ReturnCode ret;

    /* check for corect number of in and out args */
    if (nrhs != 4) {
        mexErrMsgTxt("tixiUIDSetToXPath(handle, xPath, uID): Wrong number of arguments\n");
    }
    if (nlhs != 0) {
        mexErrMsgTxt("tixiUIDSetToXPath(handle, xPath, uID): Wrong number of output values. This function returns 0 value(s)\n");
    }

    if (!isscalar(prhs[1])) {
        mexErrMsgTxt("Argument 'handle' must not be an array.\n");
    }

    if (!mxIsChar(prhs[2])) {
        mexErrMsgTxt("Argument 'xPath' must be a string.\n");
    }

    if (!mxIsChar(prhs[3])) {
        mexErrMsgTxt("Argument 'uID' must be a string.\n");
    }

    handle = mxToInt(prhs[1]);
    mxToString(prhs[2], &xPath);
    mxToString(prhs[3], &uID);

    ret = tixiUIDSetToXPath(handle, xPath, uID);
    handleError("tixiUIDSetToXPath", ret);

}


#ifdef __cplusplus
extern "C" {
#endif


/** main entry point of MATLAB, deals as a function dispatcher */
void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

    char * functionName = NULL;
    if (nrhs < 1) {
        mexErrMsgTxt("No function argument given!");
        return;
    }

    mxToString(prhs[0],&functionName);

    if (strcmp(functionName, "tixiGetVersion") == 0) {
        mex_tixiGetVersion(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiOpenDocument") == 0) {
        mex_tixiOpenDocument(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiOpenDocumentRecursive") == 0) {
        mex_tixiOpenDocumentRecursive(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiOpenDocumentFromHTTP") == 0) {
        mex_tixiOpenDocumentFromHTTP(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiCreateDocument") == 0) {
        mex_tixiCreateDocument(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiGetDocumentPath") == 0) {
        mex_tixiGetDocumentPath(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiSaveDocument") == 0) {
        mex_tixiSaveDocument(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiSaveCompleteDocument") == 0) {
        mex_tixiSaveCompleteDocument(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiSaveAndRemoveDocument") == 0) {
        mex_tixiSaveAndRemoveDocument(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiCloseDocument") == 0) {
        mex_tixiCloseDocument(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiCloseAllDocuments") == 0) {
        mex_tixiCloseAllDocuments(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiCleanup") == 0) {
        mex_tixiCleanup(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiExportDocumentAsString") == 0) {
        mex_tixiExportDocumentAsString(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiImportFromString") == 0) {
        mex_tixiImportFromString(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiSchemaValidateFromFile") == 0) {
        mex_tixiSchemaValidateFromFile(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiSchemaValidateWithDefaultsFromFile") == 0) {
        mex_tixiSchemaValidateWithDefaultsFromFile(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiSchemaValidateFromString") == 0) {
        mex_tixiSchemaValidateFromString(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiDTDValidate") == 0) {
        mex_tixiDTDValidate(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiGetTextElement") == 0) {
        mex_tixiGetTextElement(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiGetIntegerElement") == 0) {
        mex_tixiGetIntegerElement(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiGetDoubleElement") == 0) {
        mex_tixiGetDoubleElement(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiGetBooleanElement") == 0) {
        mex_tixiGetBooleanElement(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiUpdateTextElement") == 0) {
        mex_tixiUpdateTextElement(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiUpdateDoubleElement") == 0) {
        mex_tixiUpdateDoubleElement(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiUpdateIntegerElement") == 0) {
        mex_tixiUpdateIntegerElement(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiUpdateBooleanElement") == 0) {
        mex_tixiUpdateBooleanElement(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiAddTextElement") == 0) {
        mex_tixiAddTextElement(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiAddTextElementNS") == 0) {
        mex_tixiAddTextElementNS(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiAddTextElementAtIndex") == 0) {
        mex_tixiAddTextElementAtIndex(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiAddTextElementNSAtIndex") == 0) {
        mex_tixiAddTextElementNSAtIndex(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiAddBooleanElement") == 0) {
        mex_tixiAddBooleanElement(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiAddBooleanElementNS") == 0) {
        mex_tixiAddBooleanElementNS(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiAddDoubleElement") == 0) {
        mex_tixiAddDoubleElement(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiAddDoubleElementNS") == 0) {
        mex_tixiAddDoubleElementNS(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiAddIntegerElement") == 0) {
        mex_tixiAddIntegerElement(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiAddIntegerElementNS") == 0) {
        mex_tixiAddIntegerElementNS(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiAddFloatVector") == 0) {
        mex_tixiAddFloatVector(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiUpdateFloatVector") == 0) {
        mex_tixiUpdateFloatVector(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiCreateElement") == 0) {
        mex_tixiCreateElement(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiCreateElementNS") == 0) {
        mex_tixiCreateElementNS(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiCreateElementAtIndex") == 0) {
        mex_tixiCreateElementAtIndex(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiCreateElementNSAtIndex") == 0) {
        mex_tixiCreateElementNSAtIndex(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiRenameElement") == 0) {
        mex_tixiRenameElement(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiRemoveElement") == 0) {
        mex_tixiRemoveElement(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiGetNodeType") == 0) {
        mex_tixiGetNodeType(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiGetNamedChildrenCount") == 0) {
        mex_tixiGetNamedChildrenCount(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiGetChildNodeName") == 0) {
        mex_tixiGetChildNodeName(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiGetNumberOfChilds") == 0) {
        mex_tixiGetNumberOfChilds(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiSwapElements") == 0) {
        mex_tixiSwapElements(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiExportElementAsString") == 0) {
        mex_tixiExportElementAsString(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiImportElementFromString") == 0) {
        mex_tixiImportElementFromString(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiGetTextAttribute") == 0) {
        mex_tixiGetTextAttribute(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiGetIntegerAttribute") == 0) {
        mex_tixiGetIntegerAttribute(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiGetBooleanAttribute") == 0) {
        mex_tixiGetBooleanAttribute(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiGetDoubleAttribute") == 0) {
        mex_tixiGetDoubleAttribute(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiAddTextAttribute") == 0) {
        mex_tixiAddTextAttribute(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiAddDoubleAttribute") == 0) {
        mex_tixiAddDoubleAttribute(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiAddIntegerAttribute") == 0) {
        mex_tixiAddIntegerAttribute(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiRemoveAttribute") == 0) {
        mex_tixiRemoveAttribute(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiGetNumberOfAttributes") == 0) {
        mex_tixiGetNumberOfAttributes(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiGetAttributeName") == 0) {
        mex_tixiGetAttributeName(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiRegisterNamespace") == 0) {
        mex_tixiRegisterNamespace(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiRegisterNamespacesFromDocument") == 0) {
        mex_tixiRegisterNamespacesFromDocument(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiSetElementNamespace") == 0) {
        mex_tixiSetElementNamespace(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiDeclareNamespace") == 0) {
        mex_tixiDeclareNamespace(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiAddExternalLink") == 0) {
        mex_tixiAddExternalLink(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiRemoveExternalLinks") == 0) {
        mex_tixiRemoveExternalLinks(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiAddHeader") == 0) {
        mex_tixiAddHeader(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiAddCpacsHeader") == 0) {
        mex_tixiAddCpacsHeader(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiCheckElement") == 0) {
        mex_tixiCheckElement(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiCheckDocumentHandle") == 0) {
        mex_tixiCheckDocumentHandle(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiUsePrettyPrint") == 0) {
        mex_tixiUsePrettyPrint(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiGetPrintMsgFunc") == 0) {
        mex_tixiGetPrintMsgFunc(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiSetCacheEnabled") == 0) {
        mex_tixiSetCacheEnabled(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiGetVectorSize") == 0) {
        mex_tixiGetVectorSize(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiGetFloatVector") == 0) {
        mex_tixiGetFloatVector(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiGetArrayDimensions") == 0) {
        mex_tixiGetArrayDimensions(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiGetArrayDimensionSizes") == 0) {
        mex_tixiGetArrayDimensionSizes(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiGetArrayDimensionNames") == 0) {
        mex_tixiGetArrayDimensionNames(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiGetArrayDimensionValues") == 0) {
        mex_tixiGetArrayDimensionValues(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiGetArrayParameters") == 0) {
        mex_tixiGetArrayParameters(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiGetArrayParameterNames") == 0) {
        mex_tixiGetArrayParameterNames(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiGetArray") == 0) {
        mex_tixiGetArray(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiGetArrayValue") == 0) {
        mex_tixiGetArrayValue(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiGetArrayElementCount") == 0) {
        mex_tixiGetArrayElementCount(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiGetArrayElementNames") == 0) {
        mex_tixiGetArrayElementNames(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiAddPoint") == 0) {
        mex_tixiAddPoint(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiGetPoint") == 0) {
        mex_tixiGetPoint(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiCheckAttribute") == 0) {
        mex_tixiCheckAttribute(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiXSLTransformationToString") == 0) {
        mex_tixiXSLTransformationToString(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiXSLTransformationToFile") == 0) {
        mex_tixiXSLTransformationToFile(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiXPathEvaluateNodeNumber") == 0) {
        mex_tixiXPathEvaluateNodeNumber(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiXPathExpressionGetXPath") == 0) {
        mex_tixiXPathExpressionGetXPath(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiXPathExpressionGetTextByIndex") == 0) {
        mex_tixiXPathExpressionGetTextByIndex(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiUIDCheckDuplicates") == 0) {
        mex_tixiUIDCheckDuplicates(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiUIDCheckLinks") == 0) {
        mex_tixiUIDCheckLinks(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiUIDGetXPath") == 0) {
        mex_tixiUIDGetXPath(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiUIDCheckExists") == 0) {
        mex_tixiUIDCheckExists(nlhs, plhs, nrhs, prhs);
    }
    else if (strcmp(functionName, "tixiUIDSetToXPath") == 0) {
        mex_tixiUIDSetToXPath(nlhs, plhs, nrhs, prhs);
    }
    else {
        /* this is only executed if the function could not be identified */
        char text[255];
        snprintf(text, 250, "%s is not a valid tixi3 function!\n", functionName);
        mxFree(functionName);
        mexErrMsgTxt(text);
    }
    mxFree(functionName);
}

#ifdef __cplusplus
} /* extern C */
#endif

