# PyChrono local build.
# The following imports add the binaries to the modules.
# Because of the SWIG 4 import style (from . import _<modulename>), pyd/so files in the 
# PYTHONPATH dir cannot be found and have to be added to the package.

import os
import sys
import pathlib

# Hack for Python > 3.8 on Windows
if sys.platform == 'win32' and sys.version_info >= (3,8):
    path_env = os.environ['PATH']
    for item in path_env.split(os.pathsep):
        item_posix = pathlib.PureWindowsPath(item).as_posix()
        #print(item, '  --->  ', item_posix)
        try:
            os.add_dll_directory(item_posix)
        except:
            pass

try:
    import _core
    import _fea
except:
    pass
try:
    
    import _cascade
except:
    pass
try:
    import _irrlicht
except:
    pass
try:
    import _vehicle
except:
    pass
try:
    import _postprocess
except:
    pass
try:
    import _pardisomkl
except:
    pass
try:
    
    import _sensor
    _sensor.SetSensorShaderDir('/ucrt64/include/chrono_sensor/optix/shaders/')
except:
    pass
try:
    import _robot
except:
    pass
try:
    import _parsers
except:
    pass
try:
    import _ros
except:
    pass

# The following allows the package "pychrono" to be directly
# used as C++ namespace chrono:: ie. you just need to type
#   import pychrono
# instead of 
#   import pychrono.core	
from .core import *

SetChronoDataPath('/ucrt64/share/chrono/data/')
