/* Copyright (c) 2020, Samsung Electronics Co., Ltd.
   All Rights Reserved. */
/*
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:

   - Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

   - Neither the name of the copyright owner, nor the names of its contributors
   may be used to endorse or promote products derived from this software
   without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED.IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE.
*/

#include "xeve_def.h"
#include "xeve_type.h"

#define NA 255 //never split
#define NB 14  //not reach in current setting of max AR 1:4
#define NC 15  //not reach in current setting of max AR 1:4

const u8 xeve_tbl_mpm[6][6][5] =
{
{ { 0, 2, 3, 1, 4 },{ 0, 2, 1, 3, 4 },{ 0, 2, 1, 3, 4 },{ 1, 2, 0, 3, 4 },{ 0, 2, 1, 3, 4 },{ 0, 1, 2, 3, 4 } },
{ { 1, 0, 2, 3, 4 },{ 0, 1, 2, 3, 4 },{ 0, 1, 2, 3, 4 },{ 1, 2, 0, 3, 4 },{ 0, 1, 3, 2, 4 },{ 0, 2, 1, 4, 3 } },
{ { 1, 0, 2, 3, 4 },{ 1, 0, 2, 3, 4 },{ 1, 0, 2, 3, 4 },{ 2, 0, 1, 3, 4 },{ 1, 0, 3, 2, 4 },{ 0, 1, 2, 4, 3 } },
{ { 1, 0, 2, 3, 4 },{ 0, 2, 1, 3, 4 },{ 1, 0, 2, 3, 4 },{ 1, 2, 0, 3, 4 },{ 0, 1, 2, 3, 4 },{ 0, 2, 1, 4, 3 } },
{ { 0, 1, 2, 3, 4 },{ 0, 3, 2, 1, 4 },{ 1, 0, 2, 3, 4 },{ 1, 2, 0, 3, 4 },{ 1, 2, 3, 0, 4 },{ 0, 2, 1, 4, 3 } },
{ { 0, 1, 2, 3, 4 },{ 0, 1, 2, 4, 3 },{ 0, 1, 2, 4, 3 },{ 0, 2, 1, 4, 3 },{ 0, 1, 2, 3, 4 },{ 0, 1, 2, 4, 3 } }
};

const u8 xeve_tbl_log2[257] =
{
    /* 0, 1 */
    0, 0,
    /* 2, 3 */
    1, 1,
    /* 4 ~ 7 */
    2, 2, 2, 2,
    /* 8 ~ 15 */
    3, 3, 3, 3, 3, 3, 3, 3,
    /* 16 ~ 31 */
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    /* 31 ~ 63 */
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    /* 64 ~ 127 */
    6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    /* 128 ~ 255 */
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    /* 256 */
    8
};

const s8 xeve_tbl_tm2[2][2] =
{
    { 64, 64},
    { 64,-64},
};

const s8 xeve_tbl_tm4[4][4] =
{
    { 64, 64, 64, 64},
    { 84, 35,-35,-84},
    { 64,-64,-64, 64},
    { 35,-84, 84,-35}
};

const s8 xeve_tbl_tm8[8][8] =
{
    { 64, 64, 64, 64, 64, 64, 64, 64},
    { 89, 75, 50, 18,-18,-50,-75,-89},
    { 84, 35,-35,-84,-84,-35, 35, 84},
    { 75,-18,-89,-50, 50, 89, 18,-75},
    { 64,-64,-64, 64, 64,-64,-64, 64},
    { 50,-89, 18, 75,-75,-18, 89,-50},
    { 35,-84, 84,-35,-35, 84,-84, 35},
    { 18,-50, 75,-89, 89,-75, 50,-18}
};

const s8 xeve_tbl_tm16[16][16] =
{
    { 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64},
    { 90, 87, 80, 70, 57, 43, 26,  9, -9,-26,-43,-57,-70,-80,-87,-90},
    { 89, 75, 50, 18,-18,-50,-75,-89,-89,-75,-50,-18, 18, 50, 75, 89},
    { 87, 57,  9,-43,-80,-90,-70,-26, 26, 70, 90, 80, 43, -9,-57,-87},
    { 84, 35,-35,-84,-84,-35, 35, 84, 84, 35,-35,-84,-84,-35, 35, 84},
    { 80,  9,-70,-87,-26, 57, 90, 43,-43,-90,-57, 26, 87, 70, -9,-80},
    { 75,-18,-89,-50, 50, 89, 18,-75,-75, 18, 89, 50,-50,-89,-18, 75},
    { 70,-43,-87,  9, 90, 26,-80,-57, 57, 80,-26,-90, -9, 87, 43,-70},
    { 64,-64,-64, 64, 64,-64,-64, 64, 64,-64,-64, 64, 64,-64,-64, 64},
    { 57,-80,-26, 90, -9,-87, 43, 70,-70,-43, 87,  9,-90, 26, 80,-57},
    { 50,-89, 18, 75,-75,-18, 89,-50,-50, 89,-18,-75, 75, 18,-89, 50},
    { 43,-90, 57, 26,-87, 70,  9,-80, 80, -9,-70, 87,-26,-57, 90,-43},
    { 35,-84, 84,-35,-35, 84,-84, 35, 35,-84, 84,-35,-35, 84,-84, 35},
    { 26,-70, 90,-80, 43,  9,-57, 87,-87, 57, -9,-43, 80,-90, 70,-26},
    { 18,-50, 75,-89, 89,-75, 50,-18,-18, 50,-75, 89,-89, 75,-50, 18},
    {  9,-26, 43,-57, 70,-80, 87,-90, 90,-87, 80,-70, 57,-43, 26, -9}

};

const s8 xeve_tbl_tm32[32][32] =
{
    { 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64},
    { 90, 90, 88, 85, 82, 78, 73, 67, 61, 54, 47, 39, 30, 22, 13,  4, -4,-13,-22,-30,-39,-47,-54,-61,-67,-73,-78,-82,-85,-88,-90,-90},
    { 90, 87, 80, 70, 57, 43, 26,  9, -9,-26,-43,-57,-70,-80,-87,-90,-90,-87,-80,-70,-57,-43,-26, -9,  9, 26, 43, 57, 70, 80, 87, 90},
    { 90, 82, 67, 47, 22, -4,-30,-54,-73,-85,-90,-88,-78,-61,-39,-13, 13, 39, 61, 78, 88, 90, 85, 73, 54, 30,  4,-22,-47,-67,-82,-90},
    { 89, 75, 50, 18,-18,-50,-75,-89,-89,-75,-50,-18, 18, 50, 75, 89, 89, 75, 50, 18,-18,-50,-75,-89,-89,-75,-50,-18, 18, 50, 75, 89},
    { 88, 67, 30,-13,-54,-82,-90,-78,-47, -4, 39, 73, 90, 85, 61, 22,-22,-61,-85,-90,-73,-39,  4, 47, 78, 90, 82, 54, 13,-30,-67,-88},
    { 87, 57,  9,-43,-80,-90,-70,-26, 26, 70, 90, 80, 43, -9,-57,-87,-87,-57, -9, 43, 80, 90, 70, 26,-26,-70,-90,-80,-43,  9, 57, 87},
    { 85, 47,-13,-67,-90,-73,-22, 39, 82, 88, 54, -4,-61,-90,-78,-30, 30, 78, 90, 61,  4,-54,-88,-82,-39, 22, 73, 90, 67, 13,-47,-85},
    { 84, 35,-35,-84,-84,-35, 35, 84, 84, 35,-35,-84,-84,-35, 35, 84, 84, 35,-35,-84,-84,-35, 35, 84, 84, 35,-35,-84,-84,-35, 35, 84},
    { 82, 22,-54,-90,-61, 13, 78, 85, 30,-47,-90,-67,  4, 73, 88, 39,-39,-88,-73, -4, 67, 90, 47,-30,-85,-78,-13, 61, 90, 54,-22,-82},
    { 80,  9,-70,-87,-26, 57, 90, 43,-43,-90,-57, 26, 87, 70, -9,-80,-80, -9, 70, 87, 26,-57,-90,-43, 43, 90, 57,-26,-87,-70,  9, 80},
    { 78, -4,-82,-73, 13, 85, 67,-22,-88,-61, 30, 90, 54,-39,-90,-47, 47, 90, 39,-54,-90,-30, 61, 88, 22,-67,-85,-13, 73, 82,  4,-78},
    { 75,-18,-89,-50, 50, 89, 18,-75,-75, 18, 89, 50,-50,-89,-18, 75, 75,-18,-89,-50, 50, 89, 18,-75,-75, 18, 89, 50,-50,-89,-18, 75},
    { 73,-30,-90,-22, 78, 67,-39,-90,-13, 82, 61,-47,-88, -4, 85, 54,-54,-85,  4, 88, 47,-61,-82, 13, 90, 39,-67,-78, 22, 90, 30,-73},
    { 70,-43,-87,  9, 90, 26,-80,-57, 57, 80,-26,-90, -9, 87, 43,-70,-70, 43, 87, -9,-90,-26, 80, 57,-57,-80, 26, 90,  9,-87,-43, 70},
    { 67,-54,-78, 39, 85,-22,-90,  4, 90, 13,-88,-30, 82, 47,-73,-61, 61, 73,-47,-82, 30, 88,-13,-90, -4, 90, 22,-85,-39, 78, 54,-67},
    { 64,-64,-64, 64, 64,-64,-64, 64, 64,-64,-64, 64, 64,-64,-64, 64, 64,-64,-64, 64, 64,-64,-64, 64, 64,-64,-64, 64, 64,-64,-64, 64},
    { 61,-73,-47, 82, 30,-88,-13, 90, -4,-90, 22, 85,-39,-78, 54, 67,-67,-54, 78, 39,-85,-22, 90,  4,-90, 13, 88,-30,-82, 47, 73,-61},
    { 57,-80,-26, 90, -9,-87, 43, 70,-70,-43, 87,  9,-90, 26, 80,-57,-57, 80, 26,-90,  9, 87,-43,-70, 70, 43,-87, -9, 90,-26,-80, 57},
    { 54,-85, -4, 88,-47,-61, 82, 13,-90, 39, 67,-78,-22, 90,-30,-73, 73, 30,-90, 22, 78,-67,-39, 90,-13,-82, 61, 47,-88,  4, 85,-54},
    { 50,-89, 18, 75,-75,-18, 89,-50,-50, 89,-18,-75, 75, 18,-89, 50, 50,-89, 18, 75,-75,-18, 89,-50,-50, 89,-18,-75, 75, 18,-89, 50},
    { 47,-90, 39, 54,-90, 30, 61,-88, 22, 67,-85, 13, 73,-82,  4, 78,-78, -4, 82,-73,-13, 85,-67,-22, 88,-61,-30, 90,-54,-39, 90,-47},
    { 43,-90, 57, 26,-87, 70,  9,-80, 80, -9,-70, 87,-26,-57, 90,-43,-43, 90,-57,-26, 87,-70, -9, 80,-80,  9, 70,-87, 26, 57,-90, 43},
    { 39,-88, 73, -4,-67, 90,-47,-30, 85,-78, 13, 61,-90, 54, 22,-82, 82,-22,-54, 90,-61,-13, 78,-85, 30, 47,-90, 67,  4,-73, 88,-39},
    { 35,-84, 84,-35,-35, 84,-84, 35, 35,-84, 84,-35,-35, 84,-84, 35, 35,-84, 84,-35,-35, 84,-84, 35, 35,-84, 84,-35,-35, 84,-84, 35},
    { 30,-78, 90,-61,  4, 54,-88, 82,-39,-22, 73,-90, 67,-13,-47, 85,-85, 47, 13,-67, 90,-73, 22, 39,-82, 88,-54, -4, 61,-90, 78,-30},
    { 26,-70, 90,-80, 43,  9,-57, 87,-87, 57, -9,-43, 80,-90, 70,-26,-26, 70,-90, 80,-43, -9, 57,-87, 87,-57,  9, 43,-80, 90,-70, 26},
    { 22,-61, 85,-90, 73,-39, -4, 47,-78, 90,-82, 54,-13,-30, 67,-88, 88,-67, 30, 13,-54, 82,-90, 78,-47,  4, 39,-73, 90,-85, 61,-22},
    { 18,-50, 75,-89, 89,-75, 50,-18,-18, 50,-75, 89,-89, 75,-50, 18, 18,-50, 75,-89, 89,-75, 50,-18,-18, 50,-75, 89,-89, 75,-50, 18},
    { 13,-39, 61,-78, 88,-90, 85,-73, 54,-30,  4, 22,-47, 67,-82, 90,-90, 82,-67, 47,-22, -4, 30,-54, 73,-85, 90,-88, 78,-61, 39,-13},
    {  9,-26, 43,-57, 70,-80, 87,-90, 90,-87, 80,-70, 57,-43, 26, -9, -9, 26,-43, 57,-70, 80,-87, 90,-90, 87,-80, 70,-57, 43,-26,  9},
    {  4,-13, 22,-30, 39,-47, 54,-61, 67,-73, 78,-82, 85,-88, 90,-90, 90,-90, 88,-85, 82,-78, 73,-67, 61,-54, 47,-39, 30,-22, 13, -4}

};


const s8 xeve_tbl_tm64[64][64] =
{
    { 64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64, },
    { 90,  90,  90,  89,  88,  87,  86,  84,  83,  81,  79,  76,  74,  71,  69,  66,  62,  59,  56,  52,  48,  45,  41,  37,  33,  28,  24,  20,  15,  11,   7,   2,  -2,  -7, -11, -15, -20, -24, -28, -33, -37, -41, -45, -48, -52, -56, -59, -62, -66, -69, -71, -74, -76, -79, -81, -83, -84, -86, -87, -88, -89, -90, -90, -90, },
    { 90,  90,  88,  85,  82,  78,  73,  67,  61,  54,  47,  39,  30,  22,  13,   4,  -4, -13, -22, -30, -39, -47, -54, -61, -67, -73, -78, -82, -85, -88, -90, -90, -90, -90, -88, -85, -82, -78, -73, -67, -61, -54, -47, -39, -30, -22, -13,  -4,   4,  13,  22,  30,  39,  47,  54,  61,  67,  73,  78,  82,  85,  88,  90,  90, },
    { 90,  88,  84,  79,  71,  62,  52,  41,  28,  15,   2, -11, -24, -37, -48, -59, -69, -76, -83, -87, -90, -90, -89, -86, -81, -74, -66, -56, -45, -33, -20,  -7,   7,  20,  33,  45,  56,  66,  74,  81,  86,  89,  90,  90,  87,  83,  76,  69,  59,  48,  37,  24,  11,  -2, -15, -28, -41, -52, -62, -71, -79, -84, -88, -90, },
    { 90,  87,  80,  70,  57,  43,  26,   9,  -9, -26, -43, -57, -70, -80, -87, -90, -90, -87, -80, -70, -57, -43, -26,  -9,   9,  26,  43,  57,  70,  80,  87,  90,  90,  87,  80,  70,  57,  43,  26,   9,  -9, -26, -43, -57, -70, -80, -87, -90, -90, -87, -80, -70, -57, -43, -26,  -9,   9,  26,  43,  57,  70,  80,  87,  90, },
    { 90,  84,  74,  59,  41,  20,  -2, -24, -45, -62, -76, -86, -90, -89, -83, -71, -56, -37, -15,   7,  28,  48,  66,  79,  87,  90,  88,  81,  69,  52,  33,  11, -11, -33, -52, -69, -81, -88, -90, -87, -79, -66, -48, -28,  -7,  15,  37,  56,  71,  83,  89,  90,  86,  76,  62,  45,  24,   2, -20, -41, -59, -74, -84, -90, },
    { 90,  82,  67,  47,  22,  -4, -30, -54, -73, -85, -90, -88, -78, -61, -39, -13,  13,  39,  61,  78,  88,  90,  85,  73,  54,  30,   4, -22, -47, -67, -82, -90, -90, -82, -67, -47, -22,   4,  30,  54,  73,  85,  90,  88,  78,  61,  39,  13, -13, -39, -61, -78, -88, -90, -85, -73, -54, -30,  -4,  22,  47,  67,  82,  90, },
    { 89,  79,  59,  33,   2, -28, -56, -76, -88, -90, -81, -62, -37,  -7,  24,  52,  74,  87,  90,  83,  66,  41,  11, -20, -48, -71, -86, -90, -84, -69, -45, -15,  15,  45,  69,  84,  90,  86,  71,  48,  20, -11, -41, -66, -83, -90, -87, -74, -52, -24,   7,  37,  62,  81,  90,  88,  76,  56,  28,  -2, -33, -59, -79, -89, },
    { 89,  75,  50,  18, -18, -50, -75, -89, -89, -75, -50, -18,  18,  50,  75,  89,  89,  75,  50,  18, -18, -50, -75, -89, -89, -75, -50, -18,  18,  50,  75,  89,  89,  75,  50,  18, -18, -50, -75, -89, -89, -75, -50, -18,  18,  50,  75,  89,  89,  75,  50,  18, -18, -50, -75, -89, -89, -75, -50, -18,  18,  50,  75,  89, },
    { 88,  71,  41,   2, -37, -69, -87, -89, -74, -45,  -7,  33,  66,  86,  90,  76,  48,  11, -28, -62, -84, -90, -79, -52, -15,  24,  59,  83,  90,  81,  56,  20, -20, -56, -81, -90, -83, -59, -24,  15,  52,  79,  90,  84,  62,  28, -11, -48, -76, -90, -86, -66, -33,   7,  45,  74,  89,  87,  69,  37,  -2, -41, -71, -88, },
    { 88,  67,  30, -13, -54, -82, -90, -78, -47,  -4,  39,  73,  90,  85,  61,  22, -22, -61, -85, -90, -73, -39,   4,  47,  78,  90,  82,  54,  13, -30, -67, -88, -88, -67, -30,  13,  54,  82,  90,  78,  47,   4, -39, -73, -90, -85, -61, -22,  22,  61,  85,  90,  73,  39,  -4, -47, -78, -90, -82, -54, -13,  30,  67,  88, },
    { 87,  62,  20, -28, -69, -89, -84, -56, -11,  37,  74,  90,  81,  48,   2, -45, -79, -90, -76, -41,   7,  52,  83,  90,  71,  33, -15, -59, -86, -88, -66, -24,  24,  66,  88,  86,  59,  15, -33, -71, -90, -83, -52,  -7,  41,  76,  90,  79,  45,  -2, -48, -81, -90, -74, -37,  11,  56,  84,  89,  69,  28, -20, -62, -87, },
    { 87,  57,   9, -43, -80, -90, -70, -26,  26,  70,  90,  80,  43,  -9, -57, -87, -87, -57,  -9,  43,  80,  90,  70,  26, -26, -70, -90, -80, -43,   9,  57,  87,  87,  57,   9, -43, -80, -90, -70, -26,  26,  70,  90,  80,  43,  -9, -57, -87, -87, -57,  -9,  43,  80,  90,  70,  26, -26, -70, -90, -80, -43,   9,  57,  87, },
    { 86,  52,  -2, -56, -87, -84, -48,   7,  59,  88,  83,  45, -11, -62, -89, -81, -41,  15,  66,  90,  79,  37, -20, -69, -90, -76, -33,  24,  71,  90,  74,  28, -28, -74, -90, -71, -24,  33,  76,  90,  69,  20, -37, -79, -90, -66, -15,  41,  81,  89,  62,  11, -45, -83, -88, -59,  -7,  48,  84,  87,  56,   2, -52, -86, },
    { 85,  47, -13, -67, -90, -73, -22,  39,  82,  88,  54,  -4, -61, -90, -78, -30,  30,  78,  90,  61,   4, -54, -88, -82, -39,  22,  73,  90,  67,  13, -47, -85, -85, -47,  13,  67,  90,  73,  22, -39, -82, -88, -54,   4,  61,  90,  78,  30, -30, -78, -90, -61,  -4,  54,  88,  82,  39, -22, -73, -90, -67, -13,  47,  85, },
    { 84,  41, -24, -76, -89, -56,   7,  66,  90,  69,  11, -52, -88, -79, -28,  37,  83,  86,  45, -20, -74, -90, -59,   2,  62,  90,  71,  15, -48, -87, -81, -33,  33,  81,  87,  48, -15, -71, -90, -62,  -2,  59,  90,  74,  20, -45, -86, -83, -37,  28,  79,  88,  52, -11, -69, -90, -66,  -7,  56,  89,  76,  24, -41, -84, },
    { 84,  35, -35, -84, -84, -35,  35,  84,  84,  35, -35, -84, -84, -35,  35,  84,  84,  35, -35, -84, -84, -35,  35,  84,  84,  35, -35, -84, -84, -35,  35,  84,  84,  35, -35, -84, -84, -35,  35,  84,  84,  35, -35, -84, -84, -35,  35,  84,  84,  35, -35, -84, -84, -35,  35,  84,  84,  35, -35, -84, -84, -35,  35,  84, },
    { 83,  28, -45, -88, -74, -11,  59,  90,  62,  -7, -71, -89, -48,  24,  81,  84,  33, -41, -87, -76, -15,  56,  90,  66,  -2, -69, -90, -52,  20,  79,  86,  37, -37, -86, -79, -20,  52,  90,  69,   2, -66, -90, -56,  15,  76,  87,  41, -33, -84, -81, -24,  48,  89,  71,   7, -62, -90, -59,  11,  74,  88,  45, -28, -83, },
    { 82,  22, -54, -90, -61,  13,  78,  85,  30, -47, -90, -67,   4,  73,  88,  39, -39, -88, -73,  -4,  67,  90,  47, -30, -85, -78, -13,  61,  90,  54, -22, -82, -82, -22,  54,  90,  61, -13, -78, -85, -30,  47,  90,  67,  -4, -73, -88, -39,  39,  88,  73,   4, -67, -90, -47,  30,  85,  78,  13, -61, -90, -54,  22,  82, },
    { 81,  15, -62, -90, -45,  37,  88,  69,  -7, -76, -84, -24,  56,  90,  52, -28, -86, -74,  -2,  71,  87,  33, -48, -90, -59,  20,  83,  79,  11, -66, -89, -41,  41,  89,  66, -11, -79, -83, -20,  59,  90,  48, -33, -87, -71,   2,  74,  86,  28, -52, -90, -56,  24,  84,  76,   7, -69, -88, -37,  45,  90,  62, -15, -81, },
    { 80,   9, -70, -87, -26,  57,  90,  43, -43, -90, -57,  26,  87,  70,  -9, -80, -80,  -9,  70,  87,  26, -57, -90, -43,  43,  90,  57, -26, -87, -70,   9,  80,  80,   9, -70, -87, -26,  57,  90,  43, -43, -90, -57,  26,  87,  70,  -9, -80, -80,  -9,  70,  87,  26, -57, -90, -43,  43,  90,  57, -26, -87, -70,   9,  80, },
    { 79,   2, -76, -81,  -7,  74,  83,  11, -71, -84, -15,  69,  86,  20, -66, -87, -24,  62,  88,  28, -59, -89, -33,  56,  90,  37, -52, -90, -41,  48,  90,  45, -45, -90, -48,  41,  90,  52, -37, -90, -56,  33,  89,  59, -28, -88, -62,  24,  87,  66, -20, -86, -69,  15,  84,  71, -11, -83, -74,   7,  81,  76,  -2, -79, },
    { 78,  -4, -82, -73,  13,  85,  67, -22, -88, -61,  30,  90,  54, -39, -90, -47,  47,  90,  39, -54, -90, -30,  61,  88,  22, -67, -85, -13,  73,  82,   4, -78, -78,   4,  82,  73, -13, -85, -67,  22,  88,  61, -30, -90, -54,  39,  90,  47, -47, -90, -39,  54,  90,  30, -61, -88, -22,  67,  85,  13, -73, -82,  -4,  78, },
    { 76, -11, -86, -62,  33,  90,  45, -52, -89, -24,  69,  83,   2, -81, -71,  20,  88,  56, -41, -90, -37,  59,  87,  15, -74, -79,   7,  84,  66, -28, -90, -48,  48,  90,  28, -66, -84,  -7,  79,  74, -15, -87, -59,  37,  90,  41, -56, -88, -20,  71,  81,  -2, -83, -69,  24,  89,  52, -45, -90, -33,  62,  86,  11, -76, },
    { 75, -18, -89, -50,  50,  89,  18, -75, -75,  18,  89,  50, -50, -89, -18,  75,  75, -18, -89, -50,  50,  89,  18, -75, -75,  18,  89,  50, -50, -89, -18,  75,  75, -18, -89, -50,  50,  89,  18, -75, -75,  18,  89,  50, -50, -89, -18,  75,  75, -18, -89, -50,  50,  89,  18, -75, -75,  18,  89,  50, -50, -89, -18,  75, },
    { 74, -24, -90, -37,  66,  81, -11, -88, -48,  56,  86,   2, -84, -59,  45,  89,  15, -79, -69,  33,  90,  28, -71, -76,  20,  90,  41, -62, -83,   7,  87,  52, -52, -87,  -7,  83,  62, -41, -90, -20,  76,  71, -28, -90, -33,  69,  79, -15, -89, -45,  59,  84,  -2, -86, -56,  48,  88,  11, -81, -66,  37,  90,  24, -74, },
    { 73, -30, -90, -22,  78,  67, -39, -90, -13,  82,  61, -47, -88,  -4,  85,  54, -54, -85,   4,  88,  47, -61, -82,  13,  90,  39, -67, -78,  22,  90,  30, -73, -73,  30,  90,  22, -78, -67,  39,  90,  13, -82, -61,  47,  88,   4, -85, -54,  54,  85,  -4, -88, -47,  61,  82, -13, -90, -39,  67,  78, -22, -90, -30,  73, },
    { 71, -37, -89,  -7,  86,  48, -62, -79,  24,  90,  20, -81, -59,  52,  84, -11, -90, -33,  74,  69, -41, -88,  -2,  87,  45, -66, -76,  28,  90,  15, -83, -56,  56,  83, -15, -90, -28,  76,  66, -45, -87,   2,  88,  41, -69, -74,  33,  90,  11, -84, -52,  59,  81, -20, -90, -24,  79,  62, -48, -86,   7,  89,  37, -71, },
    { 70, -43, -87,   9,  90,  26, -80, -57,  57,  80, -26, -90,  -9,  87,  43, -70, -70,  43,  87,  -9, -90, -26,  80,  57, -57, -80,  26,  90,   9, -87, -43,  70,  70, -43, -87,   9,  90,  26, -80, -57,  57,  80, -26, -90,  -9,  87,  43, -70, -70,  43,  87,  -9, -90, -26,  80,  57, -57, -80,  26,  90,   9, -87, -43,  70, },
    { 69, -48, -83,  24,  90,   2, -89, -28,  81,  52, -66, -71,  45,  84, -20, -90,  -7,  88,  33, -79, -56,  62,  74, -41, -86,  15,  90,  11, -87, -37,  76,  59, -59, -76,  37,  87, -11, -90, -15,  86,  41, -74, -62,  56,  79, -33, -88,   7,  90,  20, -84, -45,  71,  66, -52, -81,  28,  89,  -2, -90, -24,  83,  48, -69, },
    { 67, -54, -78,  39,  85, -22, -90,   4,  90,  13, -88, -30,  82,  47, -73, -61,  61,  73, -47, -82,  30,  88, -13, -90,  -4,  90,  22, -85, -39,  78,  54, -67, -67,  54,  78, -39, -85,  22,  90,  -4, -90, -13,  88,  30, -82, -47,  73,  61, -61, -73,  47,  82, -30, -88,  13,  90,   4, -90, -22,  85,  39, -78, -54,  67, },
    { 66, -59, -71,  52,  76, -45, -81,  37,  84, -28, -87,  20,  89, -11, -90,   2,  90,   7, -90, -15,  88,  24, -86, -33,  83,  41, -79, -48,  74,  56, -69, -62,  62,  69, -56, -74,  48,  79, -41, -83,  33,  86, -24, -88,  15,  90,  -7, -90,  -2,  90,  11, -89, -20,  87,  28, -84, -37,  81,  45, -76, -52,  71,  59, -66, },
    { 64, -64, -64,  64,  64, -64, -64,  64,  64, -64, -64,  64,  64, -64, -64,  64,  64, -64, -64,  64,  64, -64, -64,  64,  64, -64, -64,  64,  64, -64, -64,  64,  64, -64, -64,  64,  64, -64, -64,  64,  64, -64, -64,  64,  64, -64, -64,  64,  64, -64, -64,  64,  64, -64, -64,  64,  64, -64, -64,  64,  64, -64, -64,  64, },
    { 62, -69, -56,  74,  48, -79, -41,  83,  33, -86, -24,  88,  15, -90,  -7,  90,  -2, -90,  11,  89, -20, -87,  28,  84, -37, -81,  45,  76, -52, -71,  59,  66, -66, -59,  71,  52, -76, -45,  81,  37, -84, -28,  87,  20, -89, -11,  90,   2, -90,   7,  90, -15, -88,  24,  86, -33, -83,  41,  79, -48, -74,  56,  69, -62, },
    { 61, -73, -47,  82,  30, -88, -13,  90,  -4, -90,  22,  85, -39, -78,  54,  67, -67, -54,  78,  39, -85, -22,  90,   4, -90,  13,  88, -30, -82,  47,  73, -61, -61,  73,  47, -82, -30,  88,  13, -90,   4,  90, -22, -85,  39,  78, -54, -67,  67,  54, -78, -39,  85,  22, -90,  -4,  90, -13, -88,  30,  82, -47, -73,  61, },
    { 59, -76, -37,  87,  11, -90,  15,  86, -41, -74,  62,  56, -79, -33,  88,   7, -90,  20,  84, -45, -71,  66,  52, -81, -28,  89,   2, -90,  24,  83, -48, -69,  69,  48, -83, -24,  90,  -2, -89,  28,  81, -52, -66,  71,  45, -84, -20,  90,  -7, -88,  33,  79, -56, -62,  74,  41, -86, -15,  90, -11, -87,  37,  76, -59, },
    { 57, -80, -26,  90,  -9, -87,  43,  70, -70, -43,  87,   9, -90,  26,  80, -57, -57,  80,  26, -90,   9,  87, -43, -70,  70,  43, -87,  -9,  90, -26, -80,  57,  57, -80, -26,  90,  -9, -87,  43,  70, -70, -43,  87,   9, -90,  26,  80, -57, -57,  80,  26, -90,   9,  87, -43, -70,  70,  43, -87,  -9,  90, -26, -80,  57, },
    { 56, -83, -15,  90, -28, -76,  66,  45, -87,  -2,  88, -41, -69,  74,  33, -90,  11,  84, -52, -59,  81,  20, -90,  24,  79, -62, -48,  86,   7, -89,  37,  71, -71, -37,  89,  -7, -86,  48,  62, -79, -24,  90, -20, -81,  59,  52, -84, -11,  90, -33, -74,  69,  41, -88,   2,  87, -45, -66,  76,  28, -90,  15,  83, -56, },
    { 54, -85,  -4,  88, -47, -61,  82,  13, -90,  39,  67, -78, -22,  90, -30, -73,  73,  30, -90,  22,  78, -67, -39,  90, -13, -82,  61,  47, -88,   4,  85, -54, -54,  85,   4, -88,  47,  61, -82, -13,  90, -39, -67,  78,  22, -90,  30,  73, -73, -30,  90, -22, -78,  67,  39, -90,  13,  82, -61, -47,  88,  -4, -85,  54, },
    { 52, -87,   7,  83, -62, -41,  90, -20, -76,  71,  28, -90,  33,  69, -79, -15,  89, -45, -59,  84,   2, -86,  56,  48, -88,  11,  81, -66, -37,  90, -24, -74,  74,  24, -90,  37,  66, -81, -11,  88, -48, -56,  86,  -2, -84,  59,  45, -89,  15,  79, -69, -33,  90, -28, -71,  76,  20, -90,  41,  62, -83,  -7,  87, -52, },
    { 50, -89,  18,  75, -75, -18,  89, -50, -50,  89, -18, -75,  75,  18, -89,  50,  50, -89,  18,  75, -75, -18,  89, -50, -50,  89, -18, -75,  75,  18, -89,  50,  50, -89,  18,  75, -75, -18,  89, -50, -50,  89, -18, -75,  75,  18, -89,  50,  50, -89,  18,  75, -75, -18,  89, -50, -50,  89, -18, -75,  75,  18, -89,  50, },
    { 48, -90,  28,  66, -84,   7,  79, -74, -15,  87, -59, -37,  90, -41, -56,  88, -20, -71,  81,   2, -83,  69,  24, -89,  52,  45, -90,  33,  62, -86,  11,  76, -76, -11,  86, -62, -33,  90, -45, -52,  89, -24, -69,  83,  -2, -81,  71,  20, -88,  56,  41, -90,  37,  59, -87,  15,  74, -79,  -7,  84, -66, -28,  90, -48, },
    { 47, -90,  39,  54, -90,  30,  61, -88,  22,  67, -85,  13,  73, -82,   4,  78, -78,  -4,  82, -73, -13,  85, -67, -22,  88, -61, -30,  90, -54, -39,  90, -47, -47,  90, -39, -54,  90, -30, -61,  88, -22, -67,  85, -13, -73,  82,  -4, -78,  78,   4, -82,  73,  13, -85,  67,  22, -88,  61,  30, -90,  54,  39, -90,  47, },
    { 45, -90,  48,  41, -90,  52,  37, -90,  56,  33, -89,  59,  28, -88,  62,  24, -87,  66,  20, -86,  69,  15, -84,  71,  11, -83,  74,   7, -81,  76,   2, -79,  79,  -2, -76,  81,  -7, -74,  83, -11, -71,  84, -15, -69,  86, -20, -66,  87, -24, -62,  88, -28, -59,  89, -33, -56,  90, -37, -52,  90, -41, -48,  90, -45, },
    { 43, -90,  57,  26, -87,  70,   9, -80,  80,  -9, -70,  87, -26, -57,  90, -43, -43,  90, -57, -26,  87, -70,  -9,  80, -80,   9,  70, -87,  26,  57, -90,  43,  43, -90,  57,  26, -87,  70,   9, -80,  80,  -9, -70,  87, -26, -57,  90, -43, -43,  90, -57, -26,  87, -70,  -9,  80, -80,   9,  70, -87,  26,  57, -90,  43, },
    { 41, -89,  66,  11, -79,  83, -20, -59,  90, -48, -33,  87, -71,  -2,  74, -86,  28,  52, -90,  56,  24, -84,  76,  -7, -69,  88, -37, -45,  90, -62, -15,  81, -81,  15,  62, -90,  45,  37, -88,  69,   7, -76,  84, -24, -56,  90, -52, -28,  86, -74,   2,  71, -87,  33,  48, -90,  59,  20, -83,  79, -11, -66,  89, -41, },
    { 39, -88,  73,  -4, -67,  90, -47, -30,  85, -78,  13,  61, -90,  54,  22, -82,  82, -22, -54,  90, -61, -13,  78, -85,  30,  47, -90,  67,   4, -73,  88, -39, -39,  88, -73,   4,  67, -90,  47,  30, -85,  78, -13, -61,  90, -54, -22,  82, -82,  22,  54, -90,  61,  13, -78,  85, -30, -47,  90, -67,  -4,  73, -88,  39, },
    { 37, -86,  79, -20, -52,  90, -69,   2,  66, -90,  56,  15, -76,  87, -41, -33,  84, -81,  24,  48, -89,  71,  -7, -62,  90, -59, -11,  74, -88,  45,  28, -83,  83, -28, -45,  88, -74,  11,  59, -90,  62,   7, -71,  89, -48, -24,  81, -84,  33,  41, -87,  76, -15, -56,  90, -66,  -2,  69, -90,  52,  20, -79,  86, -37, },
    { 35, -84,  84, -35, -35,  84, -84,  35,  35, -84,  84, -35, -35,  84, -84,  35,  35, -84,  84, -35, -35,  84, -84,  35,  35, -84,  84, -35, -35,  84, -84,  35,  35, -84,  84, -35, -35,  84, -84,  35,  35, -84,  84, -35, -35,  84, -84,  35,  35, -84,  84, -35, -35,  84, -84,  35,  35, -84,  84, -35, -35,  84, -84,  35, },
    { 33, -81,  87, -48, -15,  71, -90,  62,  -2, -59,  90, -74,  20,  45, -86,  83, -37, -28,  79, -88,  52,  11, -69,  90, -66,   7,  56, -89,  76, -24, -41,  84, -84,  41,  24, -76,  89, -56,  -7,  66, -90,  69, -11, -52,  88, -79,  28,  37, -83,  86, -45, -20,  74, -90,  59,   2, -62,  90, -71,  15,  48, -87,  81, -33, },
    { 30, -78,  90, -61,   4,  54, -88,  82, -39, -22,  73, -90,  67, -13, -47,  85, -85,  47,  13, -67,  90, -73,  22,  39, -82,  88, -54,  -4,  61, -90,  78, -30, -30,  78, -90,  61,  -4, -54,  88, -82,  39,  22, -73,  90, -67,  13,  47, -85,  85, -47, -13,  67, -90,  73, -22, -39,  82, -88,  54,   4, -61,  90, -78,  30, },
    { 28, -74,  90, -71,  24,  33, -76,  90, -69,  20,  37, -79,  90, -66,  15,  41, -81,  89, -62,  11,  45, -83,  88, -59,   7,  48, -84,  87, -56,   2,  52, -86,  86, -52,  -2,  56, -87,  84, -48,  -7,  59, -88,  83, -45, -11,  62, -89,  81, -41, -15,  66, -90,  79, -37, -20,  69, -90,  76, -33, -24,  71, -90,  74, -28, },
    { 26, -70,  90, -80,  43,   9, -57,  87, -87,  57,  -9, -43,  80, -90,  70, -26, -26,  70, -90,  80, -43,  -9,  57, -87,  87, -57,   9,  43, -80,  90, -70,  26,  26, -70,  90, -80,  43,   9, -57,  87, -87,  57,  -9, -43,  80, -90,  70, -26, -26,  70, -90,  80, -43,  -9,  57, -87,  87, -57,   9,  43, -80,  90, -70,  26, },
    { 24, -66,  88, -86,  59, -15, -33,  71, -90,  83, -52,   7,  41, -76,  90, -79,  45,   2, -48,  81, -90,  74, -37, -11,  56, -84,  89, -69,  28,  20, -62,  87, -87,  62, -20, -28,  69, -89,  84, -56,  11,  37, -74,  90, -81,  48,  -2, -45,  79, -90,  76, -41,  -7,  52, -83,  90, -71,  33,  15, -59,  86, -88,  66, -24, },
    { 22, -61,  85, -90,  73, -39,  -4,  47, -78,  90, -82,  54, -13, -30,  67, -88,  88, -67,  30,  13, -54,  82, -90,  78, -47,   4,  39, -73,  90, -85,  61, -22, -22,  61, -85,  90, -73,  39,   4, -47,  78, -90,  82, -54,  13,  30, -67,  88, -88,  67, -30, -13,  54, -82,  90, -78,  47,  -4, -39,  73, -90,  85, -61,  22, },
    { 20, -56,  81, -90,  83, -59,  24,  15, -52,  79, -90,  84, -62,  28,  11, -48,  76, -90,  86, -66,  33,   7, -45,  74, -89,  87, -69,  37,   2, -41,  71, -88,  88, -71,  41,  -2, -37,  69, -87,  89, -74,  45,  -7, -33,  66, -86,  90, -76,  48, -11, -28,  62, -84,  90, -79,  52, -15, -24,  59, -83,  90, -81,  56, -20, },
    { 18, -50,  75, -89,  89, -75,  50, -18, -18,  50, -75,  89, -89,  75, -50,  18,  18, -50,  75, -89,  89, -75,  50, -18, -18,  50, -75,  89, -89,  75, -50,  18,  18, -50,  75, -89,  89, -75,  50, -18, -18,  50, -75,  89, -89,  75, -50,  18,  18, -50,  75, -89,  89, -75,  50, -18, -18,  50, -75,  89, -89,  75, -50,  18, },
    { 15, -45,  69, -84,  90, -86,  71, -48,  20,  11, -41,  66, -83,  90, -87,  74, -52,  24,   7, -37,  62, -81,  90, -88,  76, -56,  28,   2, -33,  59, -79,  89, -89,  79, -59,  33,  -2, -28,  56, -76,  88, -90,  81, -62,  37,  -7, -24,  52, -74,  87, -90,  83, -66,  41, -11, -20,  48, -71,  86, -90,  84, -69,  45, -15, },
    { 13, -39,  61, -78,  88, -90,  85, -73,  54, -30,   4,  22, -47,  67, -82,  90, -90,  82, -67,  47, -22,  -4,  30, -54,  73, -85,  90, -88,  78, -61,  39, -13, -13,  39, -61,  78, -88,  90, -85,  73, -54,  30,  -4, -22,  47, -67,  82, -90,  90, -82,  67, -47,  22,   4, -30,  54, -73,  85, -90,  88, -78,  61, -39,  13, },
    { 11, -33,  52, -69,  81, -88,  90, -87,  79, -66,  48, -28,   7,  15, -37,  56, -71,  83, -89,  90, -86,  76, -62,  45, -24,   2,  20, -41,  59, -74,  84, -90,  90, -84,  74, -59,  41, -20,  -2,  24, -45,  62, -76,  86, -90,  89, -83,  71, -56,  37, -15,  -7,  28, -48,  66, -79,  87, -90,  88, -81,  69, -52,  33, -11, },
    {  9, -26,  43, -57,  70, -80,  87, -90,  90, -87,  80, -70,  57, -43,  26,  -9,  -9,  26, -43,  57, -70,  80, -87,  90, -90,  87, -80,  70, -57,  43, -26,   9,   9, -26,  43, -57,  70, -80,  87, -90,  90, -87,  80, -70,  57, -43,  26,  -9,  -9,  26, -43,  57, -70,  80, -87,  90, -90,  87, -80,  70, -57,  43, -26,   9, },
    {  7, -20,  33, -45,  56, -66,  74, -81,  86, -89,  90, -90,  87, -83,  76, -69,  59, -48,  37, -24,  11,   2, -15,  28, -41,  52, -62,  71, -79,  84, -88,  90, -90,  88, -84,  79, -71,  62, -52,  41, -28,  15,  -2, -11,  24, -37,  48, -59,  69, -76,  83, -87,  90, -90,  89, -86,  81, -74,  66, -56,  45, -33,  20,  -7, },
    {  4, -13,  22, -30,  39, -47,  54, -61,  67, -73,  78, -82,  85, -88,  90, -90,  90, -90,  88, -85,  82, -78,  73, -67,  61, -54,  47, -39,  30, -22,  13,  -4,  -4,  13, -22,  30, -39,  47, -54,  61, -67,  73, -78,  82, -85,  88, -90,  90, -90,  90, -88,  85, -82,  78, -73,  67, -61,  54, -47,  39, -30,  22, -13,   4, },
    {  2,  -7,  11, -15,  20, -24,  28, -33,  37, -41,  45, -48,  52, -56,  59, -62,  66, -69,  71, -74,  76, -79,  81, -83,  84, -86,  87, -88,  89, -90,  90, -90,  90, -90,  90, -89,  88, -87,  86, -84,  83, -81,  79, -76,  74, -71,  69, -66,  62, -59,  56, -52,  48, -45,  41, -37,  33, -28,  24, -20,  15, -11,   7,  -2, },

};

const int xeve_tbl_dq_scale_b[6] = {40, 45, 51, 57, 64, 71};

const u8 xeve_tbl_df_st[4][52] =
{
    /* intra */
    {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7, 8, 9, 10, 11, 12, 12, 12, 12, 12,
    },
    /* non-zero coefficient(s) for luma */
    {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 5, 5, 6, 7, 8,  9, 10, 11, 11, 11, 11, 11,
    },
    /* no non-zero coefficient & mvd >= 4 */
    {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 4, 4, 5, 6, 7,  8,  9, 10, 10, 10, 10, 10,
    },
    /* no deblock */
    {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0,  0,  0,  0,  0,  0,
    },
};

const int xeve_tbl_qp_chroma_ajudst[XEVE_MAX_QP_TABLE_SIZE] =
{
     0,  1,  2,  3,  4,  5,  6,  7,  8,  9,
    10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
    20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
    29, 29, 30, 31, 32, 32, 33, 33, 34, 34,
    35, 35, 36, 36, 36, 37, 37, 37, 38, 38,
    39, 39, 40, 40, 40, 41, 41, 41
};

const int xeve_min_in_group[LAST_SIGNIFICANT_GROUPS] = { 0,1,2,3,4,6,8,12,16,24,32,48,64,96 };
const int xeve_group_idx[MAX_TR_SIZE] = { 0,1,2,3,4,4,5,5,6,6,6,6,7,7,7,7,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9, 10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11 };

const int xeve_go_rice_range[MAX_GR_ORDER_RESIDUAL] =
{
    6, 5, 6, COEF_REMAIN_BIN_REDUCTION, COEF_REMAIN_BIN_REDUCTION, COEF_REMAIN_BIN_REDUCTION, COEF_REMAIN_BIN_REDUCTION, COEF_REMAIN_BIN_REDUCTION, COEF_REMAIN_BIN_REDUCTION, COEF_REMAIN_BIN_REDUCTION
};

const int xeve_go_rice_para_coeff[32] =
{
    0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3
};

/* Offer value to make mv_bits[4096] to be center */
#define MV_BITS_BASE            2047

/* MV cost for ME; Supporting max. search range = +/- 64 q-pel */
static const u8 xeve_tbl_mv_bits_data[4096] =
{
    22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10,  8,  8,  8,  8,  8,  8,  8,  8,  6,  6,  6,  6,  4,  4,
     1,  4,  4,  6,  6,  6,  6,  8,  8,  8,  8,  8,  8,  8,  8, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 12, 12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 24, 24,
};

const u8 *xeve_tbl_mv_bits = xeve_tbl_mv_bits_data + MV_BITS_BASE;

const u8 xeve_tbl_refi_bits[17][16] =
{
     {0,                                                             },
     {0,                                                             },
     {1,  1,                                                         },
     {1,  2,  2,                                                     },
     {1,  2,  3,  3,                                                 },
     {1,  2,  3,  4,  4,                                             },
     {1,  2,  3,  4,  5,  5,                                         },
     {1,  2,  3,  4,  5,  6,  6,                                     },
     {1,  2,  3,  4,  5,  6,  7,  7,                                 },
     {1,  2,  3,  4,  5,  6,  7,  8,  8,                             },
     {1,  2,  3,  4,  5,  6,  7,  8,  9,  9,                         },
     {1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 10,                     },
     {1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 11,                 },
     {1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 12,             },
     {1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 13,         },
     {1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 14,     },
     {1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 15, },
};

const u8 xeve_tbl_mvp_idx_bits[5][4] =
{
    { 0, },
    { 0, },
    { 1,  1, },
    { 1,  2,  2, },
    { 1,  2,  3,  3 }
};

const s8 xeve_tbl_slice_depth_P[5][16] =
{
    /* gop_size = 2 */
    { FRM_DEPTH_2, FRM_DEPTH_1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, \
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },
    /* gop_size = 4 */
    { FRM_DEPTH_3, FRM_DEPTH_2, FRM_DEPTH_3, FRM_DEPTH_1, 0xFF, 0xFF, 0xFF, 0xFF, \
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },
    /* gop_size = 8 */
    { FRM_DEPTH_4, FRM_DEPTH_3, FRM_DEPTH_4, FRM_DEPTH_2, FRM_DEPTH_4, FRM_DEPTH_3, FRM_DEPTH_4, FRM_DEPTH_1,\
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },
    /* gop_size = 12 */
    {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF},
    /* gop_size = 16 */
    { FRM_DEPTH_5, FRM_DEPTH_4, FRM_DEPTH_5, FRM_DEPTH_3, FRM_DEPTH_5, FRM_DEPTH_4, FRM_DEPTH_5, FRM_DEPTH_2, \
      FRM_DEPTH_5, FRM_DEPTH_4, FRM_DEPTH_5, FRM_DEPTH_3, FRM_DEPTH_5, FRM_DEPTH_4, FRM_DEPTH_5, FRM_DEPTH_1 }
};

const s8 xeve_tbl_slice_depth[5][15] =
{
    /* gop_size = 2 */
    { FRM_DEPTH_2, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, \
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },
    /* gop_size = 4 */
    { FRM_DEPTH_2, FRM_DEPTH_3, FRM_DEPTH_3, 0xFF, 0xFF, 0xFF, 0xFF, \
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },
    /* gop_size = 8 */
    { FRM_DEPTH_2, FRM_DEPTH_3, FRM_DEPTH_3, FRM_DEPTH_4, FRM_DEPTH_4, FRM_DEPTH_4, FRM_DEPTH_4,\
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },
    /* gop_size = 12 */
    {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },
    /* gop_size = 16 */
    { FRM_DEPTH_2, FRM_DEPTH_3, FRM_DEPTH_3, FRM_DEPTH_4, FRM_DEPTH_4, FRM_DEPTH_4, FRM_DEPTH_4, FRM_DEPTH_5, \
      FRM_DEPTH_5,  FRM_DEPTH_5, FRM_DEPTH_5, FRM_DEPTH_5, FRM_DEPTH_5, FRM_DEPTH_5, FRM_DEPTH_5 }
};

const QP_ADAPT_PARAM xeve_qp_adapt_param_ra[3][8] =
{
    /* gop size = 4,8 */
    {
        { 0,  0.0000, 0.0000 },
        { 1,  0.0000, 0.4420 },
        { 2,  0.0000, 0.3536 },
        { 3,  0.0000, 0.3536 },
        { 4,  0.0000, 0.6800 },
        { 5,  0.0000, 0.6800 },
        { 6,  0.0000, 0.6800 },
        { 7,  0.0000, 0.6800 },
    },
    /* gop size = 16 */
    {
        {-3,  0.0000, 0.0000 },
        { 1,  0.0000, 0.0000 },
        { 1, -4.8848, 0.2061 },
        { 4, -5.7476, 0.2286 },
        { 5, -5.9000, 0.2333 },
        { 6, -7.1444, 0.3000 },
        { 7, -7.1444, 0.3000 },
        { 8, -7.1444, 0.3000 },
    },
    /* gop size = 32 */
    {
        {-3,  0.0000, 0.0000 },
        {-1,  0.0000, 0.0000 },
        { 0, -4.9309, 0.2265 },
        { 1, -4.5000, 0.1900 },
        { 3, -5.4095, 0.2571 },
        { 5, -4.4895, 0.1947 },
        { 6, -5.4429, 0.2429 },
        { 8, -5.4429, 0.2429 },
    },
};

const QP_ADAPT_PARAM xeve_qp_adapt_param_ld[8] =
{
    {-1,  0.0000, 0.0000 },
    { 1,  0.0000, 0.0000 },
    { 4, -6.5000, 0.2590 },
    { 4, -6.5000, 0.2590 },
    { 5, -6.5000, 0.2590 },
    { 5, -6.5000, 0.2590 },
    { 5, -6.5000, 0.2590 },
    { 5, -6.5000, 0.2590 },
};

const QP_ADAPT_PARAM xeve_qp_adapt_param_ai[8] =
{
    { 0,  0.0000, 0.0000},
    { 0,  0.0000, 0.0000},
    { 0,  0.0000, 0.0000},
    { 0,  0.0000, 0.0000},
    { 0,  0.0000, 0.0000},
    { 0,  0.0000, 0.0000},
    { 0,  0.0000, 0.0000},
    { 0,  0.0000, 0.0000},
};

const u16 xeve_tbl_scan[MAX_TR_LOG2][MAX_TR_LOG2][MAX_TR_DIM] =
{
    {
        {
            0,    1,
            2,    3,
        },
        {
            0,    1,
            2,    4,
            3,    5,
            6,    7,
        },
        {
            0,    1,
            2,    4,
            3,    5,
            6,    8,
            7,    9,
           10,   12,
           11,   13,
           14,   15,
        },
        {
            0,    1,
            2,    4,
            3,    5,
            6,    8,
            7,    9,
           10,   12,
           11,   13,
           14,   16,
           15,   17,
           18,   20,
           19,   21,
           22,   24,
           23,   25,
           26,   28,
           27,   29,
           30,   31,
        },
        {
            0,    1,
            2,    4,
            3,    5,
            6,    8,
            7,    9,
           10,   12,
           11,   13,
           14,   16,
           15,   17,
           18,   20,
           19,   21,
           22,   24,
           23,   25,
           26,   28,
           27,   29,
           30,   32,
           31,   33,
           34,   36,
           35,   37,
           38,   40,
           39,   41,
           42,   44,
           43,   45,
           46,   48,
           47,   49,
           50,   52,
           51,   53,
           54,   56,
           55,   57,
           58,   60,
           59,   61,
           62,   63,
        },
        {
            0,    1,
            2,    4,
            3,    5,
            6,    8,
            7,    9,
           10,   12,
           11,   13,
           14,   16,
           15,   17,
           18,   20,
           19,   21,
           22,   24,
           23,   25,
           26,   28,
           27,   29,
           30,   32,
           31,   33,
           34,   36,
           35,   37,
           38,   40,
           39,   41,
           42,   44,
           43,   45,
           46,   48,
           47,   49,
           50,   52,
           51,   53,
           54,   56,
           55,   57,
           58,   60,
           59,   61,
           62,   64,
           63,   65,
           66,   68,
           67,   69,
           70,   72,
           71,   73,
           74,   76,
           75,   77,
           78,   80,
           79,   81,
           82,   84,
           83,   85,
           86,   88,
           87,   89,
           90,   92,
           91,   93,
           94,   96,
           95,   97,
           98,  100,
           99,  101,
          102,  104,
          103,  105,
          106,  108,
          107,  109,
          110,  112,
          111,  113,
          114,  116,
          115,  117,
          118,  120,
          119,  121,
          122,  124,
          123,  125,
          126,  127,
        },
    },
    {
        {
            0,    1,    4,    5,
            2,    3,    6,    7,
        },
        {
            0,    1,    4,    8,
            5,    2,    3,    6,
            9,   12,   13,   10,
            7,   11,   14,   15,
        },
        {
            0,    1,    4,    8,
            5,    2,    3,    6,
            9,   12,   16,   13,
           10,    7,   11,   14,
           17,   20,   24,   21,
           18,   15,   19,   22,
           25,   28,   29,   26,
           23,   27,   30,   31,
        },
        {
            0,    1,    4,    8,
            5,    2,    3,    6,
            9,   12,   16,   13,
           10,    7,   11,   14,
           17,   20,   24,   21,
           18,   15,   19,   22,
           25,   28,   32,   29,
           26,   23,   27,   30,
           33,   36,   40,   37,
           34,   31,   35,   38,
           41,   44,   48,   45,
           42,   39,   43,   46,
           49,   52,   56,   53,
           50,   47,   51,   54,
           57,   60,   61,   58,
           55,   59,   62,   63,
        },
        {
            0,    1,    4,    8,
            5,    2,    3,    6,
            9,   12,   16,   13,
           10,    7,   11,   14,
           17,   20,   24,   21,
           18,   15,   19,   22,
           25,   28,   32,   29,
           26,   23,   27,   30,
           33,   36,   40,   37,
           34,   31,   35,   38,
           41,   44,   48,   45,
           42,   39,   43,   46,
           49,   52,   56,   53,
           50,   47,   51,   54,
           57,   60,   64,   61,
           58,   55,   59,   62,
           65,   68,   72,   69,
           66,   63,   67,   70,
           73,   76,   80,   77,
           74,   71,   75,   78,
           81,   84,   88,   85,
           82,   79,   83,   86,
           89,   92,   96,   93,
           90,   87,   91,   94,
           97,  100,  104,  101,
           98,   95,   99,  102,
          105,  108,  112,  109,
          106,  103,  107,  110,
          113,  116,  120,  117,
          114,  111,  115,  118,
          121,  124,  125,  122,
          119,  123,  126,  127,
        },
        {
            0,    1,    4,    8,
            5,    2,    3,    6,
            9,   12,   16,   13,
           10,    7,   11,   14,
           17,   20,   24,   21,
           18,   15,   19,   22,
           25,   28,   32,   29,
           26,   23,   27,   30,
           33,   36,   40,   37,
           34,   31,   35,   38,
           41,   44,   48,   45,
           42,   39,   43,   46,
           49,   52,   56,   53,
           50,   47,   51,   54,
           57,   60,   64,   61,
           58,   55,   59,   62,
           65,   68,   72,   69,
           66,   63,   67,   70,
           73,   76,   80,   77,
           74,   71,   75,   78,
           81,   84,   88,   85,
           82,   79,   83,   86,
           89,   92,   96,   93,
           90,   87,   91,   94,
           97,  100,  104,  101,
           98,   95,   99,  102,
          105,  108,  112,  109,
          106,  103,  107,  110,
          113,  116,  120,  117,
          114,  111,  115,  118,
          121,  124,  128,  125,
          122,  119,  123,  126,
          129,  132,  136,  133,
          130,  127,  131,  134,
          137,  140,  144,  141,
          138,  135,  139,  142,
          145,  148,  152,  149,
          146,  143,  147,  150,
          153,  156,  160,  157,
          154,  151,  155,  158,
          161,  164,  168,  165,
          162,  159,  163,  166,
          169,  172,  176,  173,
          170,  167,  171,  174,
          177,  180,  184,  181,
          178,  175,  179,  182,
          185,  188,  192,  189,
          186,  183,  187,  190,
          193,  196,  200,  197,
          194,  191,  195,  198,
          201,  204,  208,  205,
          202,  199,  203,  206,
          209,  212,  216,  213,
          210,  207,  211,  214,
          217,  220,  224,  221,
          218,  215,  219,  222,
          225,  228,  232,  229,
          226,  223,  227,  230,
          233,  236,  240,  237,
          234,  231,  235,  238,
          241,  244,  248,  245,
          242,  239,  243,  246,
          249,  252,  253,  250,
          247,  251,  254,  255,
        },
    },
    {
        {
            0,    1,    8,    9,    2,    3,   10,   11,
            4,    5,   12,   13,    6,    7,   14,   15,
        },
        {
            0,    1,    8,   16,    9,    2,    3,   10,
           17,   24,   25,   18,   11,    4,    5,   12,
           19,   26,   27,   20,   13,    6,    7,   14,
           21,   28,   29,   22,   15,   23,   30,   31,
        },
        {
            0,    1,    8,   16,    9,    2,    3,   10,
           17,   24,   32,   25,   18,   11,    4,    5,
           12,   19,   26,   33,   40,   48,   41,   34,
           27,   20,   13,    6,    7,   14,   21,   28,
           35,   42,   49,   56,   57,   50,   43,   36,
           29,   22,   15,   23,   30,   37,   44,   51,
           58,   59,   52,   45,   38,   31,   39,   46,
           53,   60,   61,   54,   47,   55,   62,   63,
        },
        {
            0,    1,    8,   16,    9,    2,    3,   10,
           17,   24,   32,   25,   18,   11,    4,    5,
           12,   19,   26,   33,   40,   48,   41,   34,
           27,   20,   13,    6,    7,   14,   21,   28,
           35,   42,   49,   56,   64,   57,   50,   43,
           36,   29,   22,   15,   23,   30,   37,   44,
           51,   58,   65,   72,   80,   73,   66,   59,
           52,   45,   38,   31,   39,   46,   53,   60,
           67,   74,   81,   88,   96,   89,   82,   75,
           68,   61,   54,   47,   55,   62,   69,   76,
           83,   90,   97,  104,  112,  105,   98,   91,
           84,   77,   70,   63,   71,   78,   85,   92,
           99,  106,  113,  120,  121,  114,  107,  100,
           93,   86,   79,   87,   94,  101,  108,  115,
          122,  123,  116,  109,  102,   95,  103,  110,
          117,  124,  125,  118,  111,  119,  126,  127,
        },
        {
            0,    1,    8,   16,    9,    2,    3,   10,
           17,   24,   32,   25,   18,   11,    4,    5,
           12,   19,   26,   33,   40,   48,   41,   34,
           27,   20,   13,    6,    7,   14,   21,   28,
           35,   42,   49,   56,   64,   57,   50,   43,
           36,   29,   22,   15,   23,   30,   37,   44,
           51,   58,   65,   72,   80,   73,   66,   59,
           52,   45,   38,   31,   39,   46,   53,   60,
           67,   74,   81,   88,   96,   89,   82,   75,
           68,   61,   54,   47,   55,   62,   69,   76,
           83,   90,   97,  104,  112,  105,   98,   91,
           84,   77,   70,   63,   71,   78,   85,   92,
           99,  106,  113,  120,  128,  121,  114,  107,
          100,   93,   86,   79,   87,   94,  101,  108,
          115,  122,  129,  136,  144,  137,  130,  123,
          116,  109,  102,   95,  103,  110,  117,  124,
          131,  138,  145,  152,  160,  153,  146,  139,
          132,  125,  118,  111,  119,  126,  133,  140,
          147,  154,  161,  168,  176,  169,  162,  155,
          148,  141,  134,  127,  135,  142,  149,  156,
          163,  170,  177,  184,  192,  185,  178,  171,
          164,  157,  150,  143,  151,  158,  165,  172,
          179,  186,  193,  200,  208,  201,  194,  187,
          180,  173,  166,  159,  167,  174,  181,  188,
          195,  202,  209,  216,  224,  217,  210,  203,
          196,  189,  182,  175,  183,  190,  197,  204,
          211,  218,  225,  232,  240,  233,  226,  219,
          212,  205,  198,  191,  199,  206,  213,  220,
          227,  234,  241,  248,  249,  242,  235,  228,
          221,  214,  207,  215,  222,  229,  236,  243,
          250,  251,  244,  237,  230,  223,  231,  238,
          245,  252,  253,  246,  239,  247,  254,  255,
        },
        {
            0,    1,    8,   16,    9,    2,    3,   10,
           17,   24,   32,   25,   18,   11,    4,    5,
           12,   19,   26,   33,   40,   48,   41,   34,
           27,   20,   13,    6,    7,   14,   21,   28,
           35,   42,   49,   56,   64,   57,   50,   43,
           36,   29,   22,   15,   23,   30,   37,   44,
           51,   58,   65,   72,   80,   73,   66,   59,
           52,   45,   38,   31,   39,   46,   53,   60,
           67,   74,   81,   88,   96,   89,   82,   75,
           68,   61,   54,   47,   55,   62,   69,   76,
           83,   90,   97,  104,  112,  105,   98,   91,
           84,   77,   70,   63,   71,   78,   85,   92,
           99,  106,  113,  120,  128,  121,  114,  107,
          100,   93,   86,   79,   87,   94,  101,  108,
          115,  122,  129,  136,  144,  137,  130,  123,
          116,  109,  102,   95,  103,  110,  117,  124,
          131,  138,  145,  152,  160,  153,  146,  139,
          132,  125,  118,  111,  119,  126,  133,  140,
          147,  154,  161,  168,  176,  169,  162,  155,
          148,  141,  134,  127,  135,  142,  149,  156,
          163,  170,  177,  184,  192,  185,  178,  171,
          164,  157,  150,  143,  151,  158,  165,  172,
          179,  186,  193,  200,  208,  201,  194,  187,
          180,  173,  166,  159,  167,  174,  181,  188,
          195,  202,  209,  216,  224,  217,  210,  203,
          196,  189,  182,  175,  183,  190,  197,  204,
          211,  218,  225,  232,  240,  233,  226,  219,
          212,  205,  198,  191,  199,  206,  213,  220,
          227,  234,  241,  248,  256,  249,  242,  235,
          228,  221,  214,  207,  215,  222,  229,  236,
          243,  250,  257,  264,  272,  265,  258,  251,
          244,  237,  230,  223,  231,  238,  245,  252,
          259,  266,  273,  280,  288,  281,  274,  267,
          260,  253,  246,  239,  247,  254,  261,  268,
          275,  282,  289,  296,  304,  297,  290,  283,
          276,  269,  262,  255,  263,  270,  277,  284,
          291,  298,  305,  312,  320,  313,  306,  299,
          292,  285,  278,  271,  279,  286,  293,  300,
          307,  314,  321,  328,  336,  329,  322,  315,
          308,  301,  294,  287,  295,  302,  309,  316,
          323,  330,  337,  344,  352,  345,  338,  331,
          324,  317,  310,  303,  311,  318,  325,  332,
          339,  346,  353,  360,  368,  361,  354,  347,
          340,  333,  326,  319,  327,  334,  341,  348,
          355,  362,  369,  376,  384,  377,  370,  363,
          356,  349,  342,  335,  343,  350,  357,  364,
          371,  378,  385,  392,  400,  393,  386,  379,
          372,  365,  358,  351,  359,  366,  373,  380,
          387,  394,  401,  408,  416,  409,  402,  395,
          388,  381,  374,  367,  375,  382,  389,  396,
          403,  410,  417,  424,  432,  425,  418,  411,
          404,  397,  390,  383,  391,  398,  405,  412,
          419,  426,  433,  440,  448,  441,  434,  427,
          420,  413,  406,  399,  407,  414,  421,  428,
          435,  442,  449,  456,  464,  457,  450,  443,
          436,  429,  422,  415,  423,  430,  437,  444,
          451,  458,  465,  472,  480,  473,  466,  459,
          452,  445,  438,  431,  439,  446,  453,  460,
          467,  474,  481,  488,  496,  489,  482,  475,
          468,  461,  454,  447,  455,  462,  469,  476,
          483,  490,  497,  504,  505,  498,  491,  484,
          477,  470,  463,  471,  478,  485,  492,  499,
          506,  507,  500,  493,  486,  479,  487,  494,
          501,  508,  509,  502,  495,  503,  510,  511,
        },
    },
    {
        {
            0,    1,   16,   17,    2,    3,   18,   19,    4,    5,   20,   21,    6,    7,   22,   23,
            8,    9,   24,   25,   10,   11,   26,   27,   12,   13,   28,   29,   14,   15,   30,   31,
        },
        {
            0,    1,   16,   32,   17,    2,    3,   18,   33,   48,   49,   34,   19,    4,    5,   20,
           35,   50,   51,   36,   21,    6,    7,   22,   37,   52,   53,   38,   23,    8,    9,   24,
           39,   54,   55,   40,   25,   10,   11,   26,   41,   56,   57,   42,   27,   12,   13,   28,
           43,   58,   59,   44,   29,   14,   15,   30,   45,   60,   61,   46,   31,   47,   62,   63,
        },
        {
            0,    1,   16,   32,   17,    2,    3,   18,   33,   48,   64,   49,   34,   19,    4,    5,
           20,   35,   50,   65,   80,   96,   81,   66,   51,   36,   21,    6,    7,   22,   37,   52,
           67,   82,   97,  112,  113,   98,   83,   68,   53,   38,   23,    8,    9,   24,   39,   54,
           69,   84,   99,  114,  115,  100,   85,   70,   55,   40,   25,   10,   11,   26,   41,   56,
           71,   86,  101,  116,  117,  102,   87,   72,   57,   42,   27,   12,   13,   28,   43,   58,
           73,   88,  103,  118,  119,  104,   89,   74,   59,   44,   29,   14,   15,   30,   45,   60,
           75,   90,  105,  120,  121,  106,   91,   76,   61,   46,   31,   47,   62,   77,   92,  107,
          122,  123,  108,   93,   78,   63,   79,   94,  109,  124,  125,  110,   95,  111,  126,  127,
        },
        {
            0,    1,   16,   32,   17,    2,    3,   18,   33,   48,   64,   49,   34,   19,    4,    5,
           20,   35,   50,   65,   80,   96,   81,   66,   51,   36,   21,    6,    7,   22,   37,   52,
           67,   82,   97,  112,  128,  113,   98,   83,   68,   53,   38,   23,    8,    9,   24,   39,
           54,   69,   84,   99,  114,  129,  144,  160,  145,  130,  115,  100,   85,   70,   55,   40,
           25,   10,   11,   26,   41,   56,   71,   86,  101,  116,  131,  146,  161,  176,  192,  177,
          162,  147,  132,  117,  102,   87,   72,   57,   42,   27,   12,   13,   28,   43,   58,   73,
           88,  103,  118,  133,  148,  163,  178,  193,  208,  224,  209,  194,  179,  164,  149,  134,
          119,  104,   89,   74,   59,   44,   29,   14,   15,   30,   45,   60,   75,   90,  105,  120,
          135,  150,  165,  180,  195,  210,  225,  240,  241,  226,  211,  196,  181,  166,  151,  136,
          121,  106,   91,   76,   61,   46,   31,   47,   62,   77,   92,  107,  122,  137,  152,  167,
          182,  197,  212,  227,  242,  243,  228,  213,  198,  183,  168,  153,  138,  123,  108,   93,
           78,   63,   79,   94,  109,  124,  139,  154,  169,  184,  199,  214,  229,  244,  245,  230,
          215,  200,  185,  170,  155,  140,  125,  110,   95,  111,  126,  141,  156,  171,  186,  201,
          216,  231,  246,  247,  232,  217,  202,  187,  172,  157,  142,  127,  143,  158,  173,  188,
          203,  218,  233,  248,  249,  234,  219,  204,  189,  174,  159,  175,  190,  205,  220,  235,
          250,  251,  236,  221,  206,  191,  207,  222,  237,  252,  253,  238,  223,  239,  254,  255,
        },
        {
            0,    1,   16,   32,   17,    2,    3,   18,   33,   48,   64,   49,   34,   19,    4,    5,
           20,   35,   50,   65,   80,   96,   81,   66,   51,   36,   21,    6,    7,   22,   37,   52,
           67,   82,   97,  112,  128,  113,   98,   83,   68,   53,   38,   23,    8,    9,   24,   39,
           54,   69,   84,   99,  114,  129,  144,  160,  145,  130,  115,  100,   85,   70,   55,   40,
           25,   10,   11,   26,   41,   56,   71,   86,  101,  116,  131,  146,  161,  176,  192,  177,
          162,  147,  132,  117,  102,   87,   72,   57,   42,   27,   12,   13,   28,   43,   58,   73,
           88,  103,  118,  133,  148,  163,  178,  193,  208,  224,  209,  194,  179,  164,  149,  134,
          119,  104,   89,   74,   59,   44,   29,   14,   15,   30,   45,   60,   75,   90,  105,  120,
          135,  150,  165,  180,  195,  210,  225,  240,  256,  241,  226,  211,  196,  181,  166,  151,
          136,  121,  106,   91,   76,   61,   46,   31,   47,   62,   77,   92,  107,  122,  137,  152,
          167,  182,  197,  212,  227,  242,  257,  272,  288,  273,  258,  243,  228,  213,  198,  183,
          168,  153,  138,  123,  108,   93,   78,   63,   79,   94,  109,  124,  139,  154,  169,  184,
          199,  214,  229,  244,  259,  274,  289,  304,  320,  305,  290,  275,  260,  245,  230,  215,
          200,  185,  170,  155,  140,  125,  110,   95,  111,  126,  141,  156,  171,  186,  201,  216,
          231,  246,  261,  276,  291,  306,  321,  336,  352,  337,  322,  307,  292,  277,  262,  247,
          232,  217,  202,  187,  172,  157,  142,  127,  143,  158,  173,  188,  203,  218,  233,  248,
          263,  278,  293,  308,  323,  338,  353,  368,  384,  369,  354,  339,  324,  309,  294,  279,
          264,  249,  234,  219,  204,  189,  174,  159,  175,  190,  205,  220,  235,  250,  265,  280,
          295,  310,  325,  340,  355,  370,  385,  400,  416,  401,  386,  371,  356,  341,  326,  311,
          296,  281,  266,  251,  236,  221,  206,  191,  207,  222,  237,  252,  267,  282,  297,  312,
          327,  342,  357,  372,  387,  402,  417,  432,  448,  433,  418,  403,  388,  373,  358,  343,
          328,  313,  298,  283,  268,  253,  238,  223,  239,  254,  269,  284,  299,  314,  329,  344,
          359,  374,  389,  404,  419,  434,  449,  464,  480,  465,  450,  435,  420,  405,  390,  375,
          360,  345,  330,  315,  300,  285,  270,  255,  271,  286,  301,  316,  331,  346,  361,  376,
          391,  406,  421,  436,  451,  466,  481,  496,  497,  482,  467,  452,  437,  422,  407,  392,
          377,  362,  347,  332,  317,  302,  287,  303,  318,  333,  348,  363,  378,  393,  408,  423,
          438,  453,  468,  483,  498,  499,  484,  469,  454,  439,  424,  409,  394,  379,  364,  349,
          334,  319,  335,  350,  365,  380,  395,  410,  425,  440,  455,  470,  485,  500,  501,  486,
          471,  456,  441,  426,  411,  396,  381,  366,  351,  367,  382,  397,  412,  427,  442,  457,
          472,  487,  502,  503,  488,  473,  458,  443,  428,  413,  398,  383,  399,  414,  429,  444,
          459,  474,  489,  504,  505,  490,  475,  460,  445,  430,  415,  431,  446,  461,  476,  491,
          506,  507,  492,  477,  462,  447,  463,  478,  493,  508,  509,  494,  479,  495,  510,  511,
        },
        {
            0,    1,   16,   32,   17,    2,    3,   18,   33,   48,   64,   49,   34,   19,    4,    5,
           20,   35,   50,   65,   80,   96,   81,   66,   51,   36,   21,    6,    7,   22,   37,   52,
           67,   82,   97,  112,  128,  113,   98,   83,   68,   53,   38,   23,    8,    9,   24,   39,
           54,   69,   84,   99,  114,  129,  144,  160,  145,  130,  115,  100,   85,   70,   55,   40,
           25,   10,   11,   26,   41,   56,   71,   86,  101,  116,  131,  146,  161,  176,  192,  177,
          162,  147,  132,  117,  102,   87,   72,   57,   42,   27,   12,   13,   28,   43,   58,   73,
           88,  103,  118,  133,  148,  163,  178,  193,  208,  224,  209,  194,  179,  164,  149,  134,
          119,  104,   89,   74,   59,   44,   29,   14,   15,   30,   45,   60,   75,   90,  105,  120,
          135,  150,  165,  180,  195,  210,  225,  240,  256,  241,  226,  211,  196,  181,  166,  151,
          136,  121,  106,   91,   76,   61,   46,   31,   47,   62,   77,   92,  107,  122,  137,  152,
          167,  182,  197,  212,  227,  242,  257,  272,  288,  273,  258,  243,  228,  213,  198,  183,
          168,  153,  138,  123,  108,   93,   78,   63,   79,   94,  109,  124,  139,  154,  169,  184,
          199,  214,  229,  244,  259,  274,  289,  304,  320,  305,  290,  275,  260,  245,  230,  215,
          200,  185,  170,  155,  140,  125,  110,   95,  111,  126,  141,  156,  171,  186,  201,  216,
          231,  246,  261,  276,  291,  306,  321,  336,  352,  337,  322,  307,  292,  277,  262,  247,
          232,  217,  202,  187,  172,  157,  142,  127,  143,  158,  173,  188,  203,  218,  233,  248,
          263,  278,  293,  308,  323,  338,  353,  368,  384,  369,  354,  339,  324,  309,  294,  279,
          264,  249,  234,  219,  204,  189,  174,  159,  175,  190,  205,  220,  235,  250,  265,  280,
          295,  310,  325,  340,  355,  370,  385,  400,  416,  401,  386,  371,  356,  341,  326,  311,
          296,  281,  266,  251,  236,  221,  206,  191,  207,  222,  237,  252,  267,  282,  297,  312,
          327,  342,  357,  372,  387,  402,  417,  432,  448,  433,  418,  403,  388,  373,  358,  343,
          328,  313,  298,  283,  268,  253,  238,  223,  239,  254,  269,  284,  299,  314,  329,  344,
          359,  374,  389,  404,  419,  434,  449,  464,  480,  465,  450,  435,  420,  405,  390,  375,
          360,  345,  330,  315,  300,  285,  270,  255,  271,  286,  301,  316,  331,  346,  361,  376,
          391,  406,  421,  436,  451,  466,  481,  496,  512,  497,  482,  467,  452,  437,  422,  407,
          392,  377,  362,  347,  332,  317,  302,  287,  303,  318,  333,  348,  363,  378,  393,  408,
          423,  438,  453,  468,  483,  498,  513,  528,  544,  529,  514,  499,  484,  469,  454,  439,
          424,  409,  394,  379,  364,  349,  334,  319,  335,  350,  365,  380,  395,  410,  425,  440,
          455,  470,  485,  500,  515,  530,  545,  560,  576,  561,  546,  531,  516,  501,  486,  471,
          456,  441,  426,  411,  396,  381,  366,  351,  367,  382,  397,  412,  427,  442,  457,  472,
          487,  502,  517,  532,  547,  562,  577,  592,  608,  593,  578,  563,  548,  533,  518,  503,
          488,  473,  458,  443,  428,  413,  398,  383,  399,  414,  429,  444,  459,  474,  489,  504,
          519,  534,  549,  564,  579,  594,  609,  624,  640,  625,  610,  595,  580,  565,  550,  535,
          520,  505,  490,  475,  460,  445,  430,  415,  431,  446,  461,  476,  491,  506,  521,  536,
          551,  566,  581,  596,  611,  626,  641,  656,  672,  657,  642,  627,  612,  597,  582,  567,
          552,  537,  522,  507,  492,  477,  462,  447,  463,  478,  493,  508,  523,  538,  553,  568,
          583,  598,  613,  628,  643,  658,  673,  688,  704,  689,  674,  659,  644,  629,  614,  599,
          584,  569,  554,  539,  524,  509,  494,  479,  495,  510,  525,  540,  555,  570,  585,  600,
          615,  630,  645,  660,  675,  690,  705,  720,  736,  721,  706,  691,  676,  661,  646,  631,
          616,  601,  586,  571,  556,  541,  526,  511,  527,  542,  557,  572,  587,  602,  617,  632,
          647,  662,  677,  692,  707,  722,  737,  752,  768,  753,  738,  723,  708,  693,  678,  663,
          648,  633,  618,  603,  588,  573,  558,  543,  559,  574,  589,  604,  619,  634,  649,  664,
          679,  694,  709,  724,  739,  754,  769,  784,  800,  785,  770,  755,  740,  725,  710,  695,
          680,  665,  650,  635,  620,  605,  590,  575,  591,  606,  621,  636,  651,  666,  681,  696,
          711,  726,  741,  756,  771,  786,  801,  816,  832,  817,  802,  787,  772,  757,  742,  727,
          712,  697,  682,  667,  652,  637,  622,  607,  623,  638,  653,  668,  683,  698,  713,  728,
          743,  758,  773,  788,  803,  818,  833,  848,  864,  849,  834,  819,  804,  789,  774,  759,
          744,  729,  714,  699,  684,  669,  654,  639,  655,  670,  685,  700,  715,  730,  745,  760,
          775,  790,  805,  820,  835,  850,  865,  880,  896,  881,  866,  851,  836,  821,  806,  791,
          776,  761,  746,  731,  716,  701,  686,  671,  687,  702,  717,  732,  747,  762,  777,  792,
          807,  822,  837,  852,  867,  882,  897,  912,  928,  913,  898,  883,  868,  853,  838,  823,
          808,  793,  778,  763,  748,  733,  718,  703,  719,  734,  749,  764,  779,  794,  809,  824,
          839,  854,  869,  884,  899,  914,  929,  944,  960,  945,  930,  915,  900,  885,  870,  855,
          840,  825,  810,  795,  780,  765,  750,  735,  751,  766,  781,  796,  811,  826,  841,  856,
          871,  886,  901,  916,  931,  946,  961,  976,  992,  977,  962,  947,  932,  917,  902,  887,
          872,  857,  842,  827,  812,  797,  782,  767,  783,  798,  813,  828,  843,  858,  873,  888,
          903,  918,  933,  948,  963,  978,  993, 1008, 1009,  994,  979,  964,  949,  934,  919,  904,
          889,  874,  859,  844,  829,  814,  799,  815,  830,  845,  860,  875,  890,  905,  920,  935,
          950,  965,  980,  995, 1010, 1011,  996,  981,  966,  951,  936,  921,  906,  891,  876,  861,
          846,  831,  847,  862,  877,  892,  907,  922,  937,  952,  967,  982,  997, 1012, 1013,  998,
          983,  968,  953,  938,  923,  908,  893,  878,  863,  879,  894,  909,  924,  939,  954,  969,
          984,  999, 1014, 1015, 1000,  985,  970,  955,  940,  925,  910,  895,  911,  926,  941,  956,
          971,  986, 1001, 1016, 1017, 1002,  987,  972,  957,  942,  927,  943,  958,  973,  988, 1003,
         1018, 1019, 1004,  989,  974,  959,  975,  990, 1005, 1020, 1021, 1006,  991, 1007, 1022, 1023,
        },
    },
    {
        {
            0,    1,   32,   33,    2,    3,   34,   35,    4,    5,   36,   37,    6,    7,   38,   39,    8,    9,   40,   41,   10,   11,   42,   43,   12,   13,   44,   45,   14,   15,   46,   47,
           16,   17,   48,   49,   18,   19,   50,   51,   20,   21,   52,   53,   22,   23,   54,   55,   24,   25,   56,   57,   26,   27,   58,   59,   28,   29,   60,   61,   30,   31,   62,   63,
        },
        {
            0,    1,   32,   64,   33,    2,    3,   34,   65,   96,   97,   66,   35,    4,    5,   36,   67,   98,   99,   68,   37,    6,    7,   38,   69,  100,  101,   70,   39,    8,    9,   40,
           71,  102,  103,   72,   41,   10,   11,   42,   73,  104,  105,   74,   43,   12,   13,   44,   75,  106,  107,   76,   45,   14,   15,   46,   77,  108,  109,   78,   47,   16,   17,   48,
           79,  110,  111,   80,   49,   18,   19,   50,   81,  112,  113,   82,   51,   20,   21,   52,   83,  114,  115,   84,   53,   22,   23,   54,   85,  116,  117,   86,   55,   24,   25,   56,
           87,  118,  119,   88,   57,   26,   27,   58,   89,  120,  121,   90,   59,   28,   29,   60,   91,  122,  123,   92,   61,   30,   31,   62,   93,  124,  125,   94,   63,   95,  126,  127,
        },
        {
            0,    1,   32,   64,   33,    2,    3,   34,   65,   96,  128,   97,   66,   35,    4,    5,   36,   67,   98,  129,  160,  192,  161,  130,   99,   68,   37,    6,    7,   38,   69,  100,
          131,  162,  193,  224,  225,  194,  163,  132,  101,   70,   39,    8,    9,   40,   71,  102,  133,  164,  195,  226,  227,  196,  165,  134,  103,   72,   41,   10,   11,   42,   73,  104,
          135,  166,  197,  228,  229,  198,  167,  136,  105,   74,   43,   12,   13,   44,   75,  106,  137,  168,  199,  230,  231,  200,  169,  138,  107,   76,   45,   14,   15,   46,   77,  108,
          139,  170,  201,  232,  233,  202,  171,  140,  109,   78,   47,   16,   17,   48,   79,  110,  141,  172,  203,  234,  235,  204,  173,  142,  111,   80,   49,   18,   19,   50,   81,  112,
          143,  174,  205,  236,  237,  206,  175,  144,  113,   82,   51,   20,   21,   52,   83,  114,  145,  176,  207,  238,  239,  208,  177,  146,  115,   84,   53,   22,   23,   54,   85,  116,
          147,  178,  209,  240,  241,  210,  179,  148,  117,   86,   55,   24,   25,   56,   87,  118,  149,  180,  211,  242,  243,  212,  181,  150,  119,   88,   57,   26,   27,   58,   89,  120,
          151,  182,  213,  244,  245,  214,  183,  152,  121,   90,   59,   28,   29,   60,   91,  122,  153,  184,  215,  246,  247,  216,  185,  154,  123,   92,   61,   30,   31,   62,   93,  124,
          155,  186,  217,  248,  249,  218,  187,  156,  125,   94,   63,   95,  126,  157,  188,  219,  250,  251,  220,  189,  158,  127,  159,  190,  221,  252,  253,  222,  191,  223,  254,  255,
        },
        {
            0,    1,   32,   64,   33,    2,    3,   34,   65,   96,  128,   97,   66,   35,    4,    5,   36,   67,   98,  129,  160,  192,  161,  130,   99,   68,   37,    6,    7,   38,   69,  100,
          131,  162,  193,  224,  256,  225,  194,  163,  132,  101,   70,   39,    8,    9,   40,   71,  102,  133,  164,  195,  226,  257,  288,  320,  289,  258,  227,  196,  165,  134,  103,   72,
           41,   10,   11,   42,   73,  104,  135,  166,  197,  228,  259,  290,  321,  352,  384,  353,  322,  291,  260,  229,  198,  167,  136,  105,   74,   43,   12,   13,   44,   75,  106,  137,
          168,  199,  230,  261,  292,  323,  354,  385,  416,  448,  417,  386,  355,  324,  293,  262,  231,  200,  169,  138,  107,   76,   45,   14,   15,   46,   77,  108,  139,  170,  201,  232,
          263,  294,  325,  356,  387,  418,  449,  480,  481,  450,  419,  388,  357,  326,  295,  264,  233,  202,  171,  140,  109,   78,   47,   16,   17,   48,   79,  110,  141,  172,  203,  234,
          265,  296,  327,  358,  389,  420,  451,  482,  483,  452,  421,  390,  359,  328,  297,  266,  235,  204,  173,  142,  111,   80,   49,   18,   19,   50,   81,  112,  143,  174,  205,  236,
          267,  298,  329,  360,  391,  422,  453,  484,  485,  454,  423,  392,  361,  330,  299,  268,  237,  206,  175,  144,  113,   82,   51,   20,   21,   52,   83,  114,  145,  176,  207,  238,
          269,  300,  331,  362,  393,  424,  455,  486,  487,  456,  425,  394,  363,  332,  301,  270,  239,  208,  177,  146,  115,   84,   53,   22,   23,   54,   85,  116,  147,  178,  209,  240,
          271,  302,  333,  364,  395,  426,  457,  488,  489,  458,  427,  396,  365,  334,  303,  272,  241,  210,  179,  148,  117,   86,   55,   24,   25,   56,   87,  118,  149,  180,  211,  242,
          273,  304,  335,  366,  397,  428,  459,  490,  491,  460,  429,  398,  367,  336,  305,  274,  243,  212,  181,  150,  119,   88,   57,   26,   27,   58,   89,  120,  151,  182,  213,  244,
          275,  306,  337,  368,  399,  430,  461,  492,  493,  462,  431,  400,  369,  338,  307,  276,  245,  214,  183,  152,  121,   90,   59,   28,   29,   60,   91,  122,  153,  184,  215,  246,
          277,  308,  339,  370,  401,  432,  463,  494,  495,  464,  433,  402,  371,  340,  309,  278,  247,  216,  185,  154,  123,   92,   61,   30,   31,   62,   93,  124,  155,  186,  217,  248,
          279,  310,  341,  372,  403,  434,  465,  496,  497,  466,  435,  404,  373,  342,  311,  280,  249,  218,  187,  156,  125,   94,   63,   95,  126,  157,  188,  219,  250,  281,  312,  343,
          374,  405,  436,  467,  498,  499,  468,  437,  406,  375,  344,  313,  282,  251,  220,  189,  158,  127,  159,  190,  221,  252,  283,  314,  345,  376,  407,  438,  469,  500,  501,  470,
          439,  408,  377,  346,  315,  284,  253,  222,  191,  223,  254,  285,  316,  347,  378,  409,  440,  471,  502,  503,  472,  441,  410,  379,  348,  317,  286,  255,  287,  318,  349,  380,
          411,  442,  473,  504,  505,  474,  443,  412,  381,  350,  319,  351,  382,  413,  444,  475,  506,  507,  476,  445,  414,  383,  415,  446,  477,  508,  509,  478,  447,  479,  510,  511,
        },
        {
            0,    1,   32,   64,   33,    2,    3,   34,   65,   96,  128,   97,   66,   35,    4,    5,   36,   67,   98,  129,  160,  192,  161,  130,   99,   68,   37,    6,    7,   38,   69,  100,
          131,  162,  193,  224,  256,  225,  194,  163,  132,  101,   70,   39,    8,    9,   40,   71,  102,  133,  164,  195,  226,  257,  288,  320,  289,  258,  227,  196,  165,  134,  103,   72,
           41,   10,   11,   42,   73,  104,  135,  166,  197,  228,  259,  290,  321,  352,  384,  353,  322,  291,  260,  229,  198,  167,  136,  105,   74,   43,   12,   13,   44,   75,  106,  137,
          168,  199,  230,  261,  292,  323,  354,  385,  416,  448,  417,  386,  355,  324,  293,  262,  231,  200,  169,  138,  107,   76,   45,   14,   15,   46,   77,  108,  139,  170,  201,  232,
          263,  294,  325,  356,  387,  418,  449,  480,  512,  481,  450,  419,  388,  357,  326,  295,  264,  233,  202,  171,  140,  109,   78,   47,   16,   17,   48,   79,  110,  141,  172,  203,
          234,  265,  296,  327,  358,  389,  420,  451,  482,  513,  544,  576,  545,  514,  483,  452,  421,  390,  359,  328,  297,  266,  235,  204,  173,  142,  111,   80,   49,   18,   19,   50,
           81,  112,  143,  174,  205,  236,  267,  298,  329,  360,  391,  422,  453,  484,  515,  546,  577,  608,  640,  609,  578,  547,  516,  485,  454,  423,  392,  361,  330,  299,  268,  237,
          206,  175,  144,  113,   82,   51,   20,   21,   52,   83,  114,  145,  176,  207,  238,  269,  300,  331,  362,  393,  424,  455,  486,  517,  548,  579,  610,  641,  672,  704,  673,  642,
          611,  580,  549,  518,  487,  456,  425,  394,  363,  332,  301,  270,  239,  208,  177,  146,  115,   84,   53,   22,   23,   54,   85,  116,  147,  178,  209,  240,  271,  302,  333,  364,
          395,  426,  457,  488,  519,  550,  581,  612,  643,  674,  705,  736,  768,  737,  706,  675,  644,  613,  582,  551,  520,  489,  458,  427,  396,  365,  334,  303,  272,  241,  210,  179,
          148,  117,   86,   55,   24,   25,   56,   87,  118,  149,  180,  211,  242,  273,  304,  335,  366,  397,  428,  459,  490,  521,  552,  583,  614,  645,  676,  707,  738,  769,  800,  832,
          801,  770,  739,  708,  677,  646,  615,  584,  553,  522,  491,  460,  429,  398,  367,  336,  305,  274,  243,  212,  181,  150,  119,   88,   57,   26,   27,   58,   89,  120,  151,  182,
          213,  244,  275,  306,  337,  368,  399,  430,  461,  492,  523,  554,  585,  616,  647,  678,  709,  740,  771,  802,  833,  864,  896,  865,  834,  803,  772,  741,  710,  679,  648,  617,
          586,  555,  524,  493,  462,  431,  400,  369,  338,  307,  276,  245,  214,  183,  152,  121,   90,   59,   28,   29,   60,   91,  122,  153,  184,  215,  246,  277,  308,  339,  370,  401,
          432,  463,  494,  525,  556,  587,  618,  649,  680,  711,  742,  773,  804,  835,  866,  897,  928,  960,  929,  898,  867,  836,  805,  774,  743,  712,  681,  650,  619,  588,  557,  526,
          495,  464,  433,  402,  371,  340,  309,  278,  247,  216,  185,  154,  123,   92,   61,   30,   31,   62,   93,  124,  155,  186,  217,  248,  279,  310,  341,  372,  403,  434,  465,  496,
          527,  558,  589,  620,  651,  682,  713,  744,  775,  806,  837,  868,  899,  930,  961,  992,  993,  962,  931,  900,  869,  838,  807,  776,  745,  714,  683,  652,  621,  590,  559,  528,
          497,  466,  435,  404,  373,  342,  311,  280,  249,  218,  187,  156,  125,   94,   63,   95,  126,  157,  188,  219,  250,  281,  312,  343,  374,  405,  436,  467,  498,  529,  560,  591,
          622,  653,  684,  715,  746,  777,  808,  839,  870,  901,  932,  963,  994,  995,  964,  933,  902,  871,  840,  809,  778,  747,  716,  685,  654,  623,  592,  561,  530,  499,  468,  437,
          406,  375,  344,  313,  282,  251,  220,  189,  158,  127,  159,  190,  221,  252,  283,  314,  345,  376,  407,  438,  469,  500,  531,  562,  593,  624,  655,  686,  717,  748,  779,  810,
          841,  872,  903,  934,  965,  996,  997,  966,  935,  904,  873,  842,  811,  780,  749,  718,  687,  656,  625,  594,  563,  532,  501,  470,  439,  408,  377,  346,  315,  284,  253,  222,
          191,  223,  254,  285,  316,  347,  378,  409,  440,  471,  502,  533,  564,  595,  626,  657,  688,  719,  750,  781,  812,  843,  874,  905,  936,  967,  998,  999,  968,  937,  906,  875,
          844,  813,  782,  751,  720,  689,  658,  627,  596,  565,  534,  503,  472,  441,  410,  379,  348,  317,  286,  255,  287,  318,  349,  380,  411,  442,  473,  504,  535,  566,  597,  628,
          659,  690,  721,  752,  783,  814,  845,  876,  907,  938,  969, 1000, 1001,  970,  939,  908,  877,  846,  815,  784,  753,  722,  691,  660,  629,  598,  567,  536,  505,  474,  443,  412,
          381,  350,  319,  351,  382,  413,  444,  475,  506,  537,  568,  599,  630,  661,  692,  723,  754,  785,  816,  847,  878,  909,  940,  971, 1002, 1003,  972,  941,  910,  879,  848,  817,
          786,  755,  724,  693,  662,  631,  600,  569,  538,  507,  476,  445,  414,  383,  415,  446,  477,  508,  539,  570,  601,  632,  663,  694,  725,  756,  787,  818,  849,  880,  911,  942,
          973, 1004, 1005,  974,  943,  912,  881,  850,  819,  788,  757,  726,  695,  664,  633,  602,  571,  540,  509,  478,  447,  479,  510,  541,  572,  603,  634,  665,  696,  727,  758,  789,
          820,  851,  882,  913,  944,  975, 1006, 1007,  976,  945,  914,  883,  852,  821,  790,  759,  728,  697,  666,  635,  604,  573,  542,  511,  543,  574,  605,  636,  667,  698,  729,  760,
          791,  822,  853,  884,  915,  946,  977, 1008, 1009,  978,  947,  916,  885,  854,  823,  792,  761,  730,  699,  668,  637,  606,  575,  607,  638,  669,  700,  731,  762,  793,  824,  855,
          886,  917,  948,  979, 1010, 1011,  980,  949,  918,  887,  856,  825,  794,  763,  732,  701,  670,  639,  671,  702,  733,  764,  795,  826,  857,  888,  919,  950,  981, 1012, 1013,  982,
          951,  920,  889,  858,  827,  796,  765,  734,  703,  735,  766,  797,  828,  859,  890,  921,  952,  983, 1014, 1015,  984,  953,  922,  891,  860,  829,  798,  767,  799,  830,  861,  892,
          923,  954,  985, 1016, 1017,  986,  955,  924,  893,  862,  831,  863,  894,  925,  956,  987, 1018, 1019,  988,  957,  926,  895,  927,  958,  989, 1020, 1021,  990,  959,  991, 1022, 1023,
        },
        {
            0,    1,   32,   64,   33,    2,    3,   34,   65,   96,  128,   97,   66,   35,    4,    5,   36,   67,   98,  129,  160,  192,  161,  130,   99,   68,   37,    6,    7,   38,   69,  100,
          131,  162,  193,  224,  256,  225,  194,  163,  132,  101,   70,   39,    8,    9,   40,   71,  102,  133,  164,  195,  226,  257,  288,  320,  289,  258,  227,  196,  165,  134,  103,   72,
           41,   10,   11,   42,   73,  104,  135,  166,  197,  228,  259,  290,  321,  352,  384,  353,  322,  291,  260,  229,  198,  167,  136,  105,   74,   43,   12,   13,   44,   75,  106,  137,
          168,  199,  230,  261,  292,  323,  354,  385,  416,  448,  417,  386,  355,  324,  293,  262,  231,  200,  169,  138,  107,   76,   45,   14,   15,   46,   77,  108,  139,  170,  201,  232,
          263,  294,  325,  356,  387,  418,  449,  480,  512,  481,  450,  419,  388,  357,  326,  295,  264,  233,  202,  171,  140,  109,   78,   47,   16,   17,   48,   79,  110,  141,  172,  203,
          234,  265,  296,  327,  358,  389,  420,  451,  482,  513,  544,  576,  545,  514,  483,  452,  421,  390,  359,  328,  297,  266,  235,  204,  173,  142,  111,   80,   49,   18,   19,   50,
           81,  112,  143,  174,  205,  236,  267,  298,  329,  360,  391,  422,  453,  484,  515,  546,  577,  608,  640,  609,  578,  547,  516,  485,  454,  423,  392,  361,  330,  299,  268,  237,
          206,  175,  144,  113,   82,   51,   20,   21,   52,   83,  114,  145,  176,  207,  238,  269,  300,  331,  362,  393,  424,  455,  486,  517,  548,  579,  610,  641,  672,  704,  673,  642,
          611,  580,  549,  518,  487,  456,  425,  394,  363,  332,  301,  270,  239,  208,  177,  146,  115,   84,   53,   22,   23,   54,   85,  116,  147,  178,  209,  240,  271,  302,  333,  364,
          395,  426,  457,  488,  519,  550,  581,  612,  643,  674,  705,  736,  768,  737,  706,  675,  644,  613,  582,  551,  520,  489,  458,  427,  396,  365,  334,  303,  272,  241,  210,  179,
          148,  117,   86,   55,   24,   25,   56,   87,  118,  149,  180,  211,  242,  273,  304,  335,  366,  397,  428,  459,  490,  521,  552,  583,  614,  645,  676,  707,  738,  769,  800,  832,
          801,  770,  739,  708,  677,  646,  615,  584,  553,  522,  491,  460,  429,  398,  367,  336,  305,  274,  243,  212,  181,  150,  119,   88,   57,   26,   27,   58,   89,  120,  151,  182,
          213,  244,  275,  306,  337,  368,  399,  430,  461,  492,  523,  554,  585,  616,  647,  678,  709,  740,  771,  802,  833,  864,  896,  865,  834,  803,  772,  741,  710,  679,  648,  617,
          586,  555,  524,  493,  462,  431,  400,  369,  338,  307,  276,  245,  214,  183,  152,  121,   90,   59,   28,   29,   60,   91,  122,  153,  184,  215,  246,  277,  308,  339,  370,  401,
          432,  463,  494,  525,  556,  587,  618,  649,  680,  711,  742,  773,  804,  835,  866,  897,  928,  960,  929,  898,  867,  836,  805,  774,  743,  712,  681,  650,  619,  588,  557,  526,
          495,  464,  433,  402,  371,  340,  309,  278,  247,  216,  185,  154,  123,   92,   61,   30,   31,   62,   93,  124,  155,  186,  217,  248,  279,  310,  341,  372,  403,  434,  465,  496,
          527,  558,  589,  620,  651,  682,  713,  744,  775,  806,  837,  868,  899,  930,  961,  992, 1024,  993,  962,  931,  900,  869,  838,  807,  776,  745,  714,  683,  652,  621,  590,  559,
          528,  497,  466,  435,  404,  373,  342,  311,  280,  249,  218,  187,  156,  125,   94,   63,   95,  126,  157,  188,  219,  250,  281,  312,  343,  374,  405,  436,  467,  498,  529,  560,
          591,  622,  653,  684,  715,  746,  777,  808,  839,  870,  901,  932,  963,  994, 1025, 1056, 1088, 1057, 1026,  995,  964,  933,  902,  871,  840,  809,  778,  747,  716,  685,  654,  623,
          592,  561,  530,  499,  468,  437,  406,  375,  344,  313,  282,  251,  220,  189,  158,  127,  159,  190,  221,  252,  283,  314,  345,  376,  407,  438,  469,  500,  531,  562,  593,  624,
          655,  686,  717,  748,  779,  810,  841,  872,  903,  934,  965,  996, 1027, 1058, 1089, 1120, 1152, 1121, 1090, 1059, 1028,  997,  966,  935,  904,  873,  842,  811,  780,  749,  718,  687,
          656,  625,  594,  563,  532,  501,  470,  439,  408,  377,  346,  315,  284,  253,  222,  191,  223,  254,  285,  316,  347,  378,  409,  440,  471,  502,  533,  564,  595,  626,  657,  688,
          719,  750,  781,  812,  843,  874,  905,  936,  967,  998, 1029, 1060, 1091, 1122, 1153, 1184, 1216, 1185, 1154, 1123, 1092, 1061, 1030,  999,  968,  937,  906,  875,  844,  813,  782,  751,
          720,  689,  658,  627,  596,  565,  534,  503,  472,  441,  410,  379,  348,  317,  286,  255,  287,  318,  349,  380,  411,  442,  473,  504,  535,  566,  597,  628,  659,  690,  721,  752,
          783,  814,  845,  876,  907,  938,  969, 1000, 1031, 1062, 1093, 1124, 1155, 1186, 1217, 1248, 1280, 1249, 1218, 1187, 1156, 1125, 1094, 1063, 1032, 1001,  970,  939,  908,  877,  846,  815,
          784,  753,  722,  691,  660,  629,  598,  567,  536,  505,  474,  443,  412,  381,  350,  319,  351,  382,  413,  444,  475,  506,  537,  568,  599,  630,  661,  692,  723,  754,  785,  816,
          847,  878,  909,  940,  971, 1002, 1033, 1064, 1095, 1126, 1157, 1188, 1219, 1250, 1281, 1312, 1344, 1313, 1282, 1251, 1220, 1189, 1158, 1127, 1096, 1065, 1034, 1003,  972,  941,  910,  879,
          848,  817,  786,  755,  724,  693,  662,  631,  600,  569,  538,  507,  476,  445,  414,  383,  415,  446,  477,  508,  539,  570,  601,  632,  663,  694,  725,  756,  787,  818,  849,  880,
          911,  942,  973, 1004, 1035, 1066, 1097, 1128, 1159, 1190, 1221, 1252, 1283, 1314, 1345, 1376, 1408, 1377, 1346, 1315, 1284, 1253, 1222, 1191, 1160, 1129, 1098, 1067, 1036, 1005,  974,  943,
          912,  881,  850,  819,  788,  757,  726,  695,  664,  633,  602,  571,  540,  509,  478,  447,  479,  510,  541,  572,  603,  634,  665,  696,  727,  758,  789,  820,  851,  882,  913,  944,
          975, 1006, 1037, 1068, 1099, 1130, 1161, 1192, 1223, 1254, 1285, 1316, 1347, 1378, 1409, 1440, 1472, 1441, 1410, 1379, 1348, 1317, 1286, 1255, 1224, 1193, 1162, 1131, 1100, 1069, 1038, 1007,
          976,  945,  914,  883,  852,  821,  790,  759,  728,  697,  666,  635,  604,  573,  542,  511,  543,  574,  605,  636,  667,  698,  729,  760,  791,  822,  853,  884,  915,  946,  977, 1008,
         1039, 1070, 1101, 1132, 1163, 1194, 1225, 1256, 1287, 1318, 1349, 1380, 1411, 1442, 1473, 1504, 1536, 1505, 1474, 1443, 1412, 1381, 1350, 1319, 1288, 1257, 1226, 1195, 1164, 1133, 1102, 1071,
         1040, 1009,  978,  947,  916,  885,  854,  823,  792,  761,  730,  699,  668,  637,  606,  575,  607,  638,  669,  700,  731,  762,  793,  824,  855,  886,  917,  948,  979, 1010, 1041, 1072,
         1103, 1134, 1165, 1196, 1227, 1258, 1289, 1320, 1351, 1382, 1413, 1444, 1475, 1506, 1537, 1568, 1600, 1569, 1538, 1507, 1476, 1445, 1414, 1383, 1352, 1321, 1290, 1259, 1228, 1197, 1166, 1135,
         1104, 1073, 1042, 1011,  980,  949,  918,  887,  856,  825,  794,  763,  732,  701,  670,  639,  671,  702,  733,  764,  795,  826,  857,  888,  919,  950,  981, 1012, 1043, 1074, 1105, 1136,
         1167, 1198, 1229, 1260, 1291, 1322, 1353, 1384, 1415, 1446, 1477, 1508, 1539, 1570, 1601, 1632, 1664, 1633, 1602, 1571, 1540, 1509, 1478, 1447, 1416, 1385, 1354, 1323, 1292, 1261, 1230, 1199,
         1168, 1137, 1106, 1075, 1044, 1013,  982,  951,  920,  889,  858,  827,  796,  765,  734,  703,  735,  766,  797,  828,  859,  890,  921,  952,  983, 1014, 1045, 1076, 1107, 1138, 1169, 1200,
         1231, 1262, 1293, 1324, 1355, 1386, 1417, 1448, 1479, 1510, 1541, 1572, 1603, 1634, 1665, 1696, 1728, 1697, 1666, 1635, 1604, 1573, 1542, 1511, 1480, 1449, 1418, 1387, 1356, 1325, 1294, 1263,
         1232, 1201, 1170, 1139, 1108, 1077, 1046, 1015,  984,  953,  922,  891,  860,  829,  798,  767,  799,  830,  861,  892,  923,  954,  985, 1016, 1047, 1078, 1109, 1140, 1171, 1202, 1233, 1264,
         1295, 1326, 1357, 1388, 1419, 1450, 1481, 1512, 1543, 1574, 1605, 1636, 1667, 1698, 1729, 1760, 1792, 1761, 1730, 1699, 1668, 1637, 1606, 1575, 1544, 1513, 1482, 1451, 1420, 1389, 1358, 1327,
         1296, 1265, 1234, 1203, 1172, 1141, 1110, 1079, 1048, 1017,  986,  955,  924,  893,  862,  831,  863,  894,  925,  956,  987, 1018, 1049, 1080, 1111, 1142, 1173, 1204, 1235, 1266, 1297, 1328,
         1359, 1390, 1421, 1452, 1483, 1514, 1545, 1576, 1607, 1638, 1669, 1700, 1731, 1762, 1793, 1824, 1856, 1825, 1794, 1763, 1732, 1701, 1670, 1639, 1608, 1577, 1546, 1515, 1484, 1453, 1422, 1391,
         1360, 1329, 1298, 1267, 1236, 1205, 1174, 1143, 1112, 1081, 1050, 1019,  988,  957,  926,  895,  927,  958,  989, 1020, 1051, 1082, 1113, 1144, 1175, 1206, 1237, 1268, 1299, 1330, 1361, 1392,
         1423, 1454, 1485, 1516, 1547, 1578, 1609, 1640, 1671, 1702, 1733, 1764, 1795, 1826, 1857, 1888, 1920, 1889, 1858, 1827, 1796, 1765, 1734, 1703, 1672, 1641, 1610, 1579, 1548, 1517, 1486, 1455,
         1424, 1393, 1362, 1331, 1300, 1269, 1238, 1207, 1176, 1145, 1114, 1083, 1052, 1021,  990,  959,  991, 1022, 1053, 1084, 1115, 1146, 1177, 1208, 1239, 1270, 1301, 1332, 1363, 1394, 1425, 1456,
         1487, 1518, 1549, 1580, 1611, 1642, 1673, 1704, 1735, 1766, 1797, 1828, 1859, 1890, 1921, 1952, 1984, 1953, 1922, 1891, 1860, 1829, 1798, 1767, 1736, 1705, 1674, 1643, 1612, 1581, 1550, 1519,
         1488, 1457, 1426, 1395, 1364, 1333, 1302, 1271, 1240, 1209, 1178, 1147, 1116, 1085, 1054, 1023, 1055, 1086, 1117, 1148, 1179, 1210, 1241, 1272, 1303, 1334, 1365, 1396, 1427, 1458, 1489, 1520,
         1551, 1582, 1613, 1644, 1675, 1706, 1737, 1768, 1799, 1830, 1861, 1892, 1923, 1954, 1985, 2016, 2017, 1986, 1955, 1924, 1893, 1862, 1831, 1800, 1769, 1738, 1707, 1676, 1645, 1614, 1583, 1552,
         1521, 1490, 1459, 1428, 1397, 1366, 1335, 1304, 1273, 1242, 1211, 1180, 1149, 1118, 1087, 1119, 1150, 1181, 1212, 1243, 1274, 1305, 1336, 1367, 1398, 1429, 1460, 1491, 1522, 1553, 1584, 1615,
         1646, 1677, 1708, 1739, 1770, 1801, 1832, 1863, 1894, 1925, 1956, 1987, 2018, 2019, 1988, 1957, 1926, 1895, 1864, 1833, 1802, 1771, 1740, 1709, 1678, 1647, 1616, 1585, 1554, 1523, 1492, 1461,
         1430, 1399, 1368, 1337, 1306, 1275, 1244, 1213, 1182, 1151, 1183, 1214, 1245, 1276, 1307, 1338, 1369, 1400, 1431, 1462, 1493, 1524, 1555, 1586, 1617, 1648, 1679, 1710, 1741, 1772, 1803, 1834,
         1865, 1896, 1927, 1958, 1989, 2020, 2021, 1990, 1959, 1928, 1897, 1866, 1835, 1804, 1773, 1742, 1711, 1680, 1649, 1618, 1587, 1556, 1525, 1494, 1463, 1432, 1401, 1370, 1339, 1308, 1277, 1246,
         1215, 1247, 1278, 1309, 1340, 1371, 1402, 1433, 1464, 1495, 1526, 1557, 1588, 1619, 1650, 1681, 1712, 1743, 1774, 1805, 1836, 1867, 1898, 1929, 1960, 1991, 2022, 2023, 1992, 1961, 1930, 1899,
         1868, 1837, 1806, 1775, 1744, 1713, 1682, 1651, 1620, 1589, 1558, 1527, 1496, 1465, 1434, 1403, 1372, 1341, 1310, 1279, 1311, 1342, 1373, 1404, 1435, 1466, 1497, 1528, 1559, 1590, 1621, 1652,
         1683, 1714, 1745, 1776, 1807, 1838, 1869, 1900, 1931, 1962, 1993, 2024, 2025, 1994, 1963, 1932, 1901, 1870, 1839, 1808, 1777, 1746, 1715, 1684, 1653, 1622, 1591, 1560, 1529, 1498, 1467, 1436,
         1405, 1374, 1343, 1375, 1406, 1437, 1468, 1499, 1530, 1561, 1592, 1623, 1654, 1685, 1716, 1747, 1778, 1809, 1840, 1871, 1902, 1933, 1964, 1995, 2026, 2027, 1996, 1965, 1934, 1903, 1872, 1841,
         1810, 1779, 1748, 1717, 1686, 1655, 1624, 1593, 1562, 1531, 1500, 1469, 1438, 1407, 1439, 1470, 1501, 1532, 1563, 1594, 1625, 1656, 1687, 1718, 1749, 1780, 1811, 1842, 1873, 1904, 1935, 1966,
         1997, 2028, 2029, 1998, 1967, 1936, 1905, 1874, 1843, 1812, 1781, 1750, 1719, 1688, 1657, 1626, 1595, 1564, 1533, 1502, 1471, 1503, 1534, 1565, 1596, 1627, 1658, 1689, 1720, 1751, 1782, 1813,
         1844, 1875, 1906, 1937, 1968, 1999, 2030, 2031, 2000, 1969, 1938, 1907, 1876, 1845, 1814, 1783, 1752, 1721, 1690, 1659, 1628, 1597, 1566, 1535, 1567, 1598, 1629, 1660, 1691, 1722, 1753, 1784,
         1815, 1846, 1877, 1908, 1939, 1970, 2001, 2032, 2033, 2002, 1971, 1940, 1909, 1878, 1847, 1816, 1785, 1754, 1723, 1692, 1661, 1630, 1599, 1631, 1662, 1693, 1724, 1755, 1786, 1817, 1848, 1879,
         1910, 1941, 1972, 2003, 2034, 2035, 2004, 1973, 1942, 1911, 1880, 1849, 1818, 1787, 1756, 1725, 1694, 1663, 1695, 1726, 1757, 1788, 1819, 1850, 1881, 1912, 1943, 1974, 2005, 2036, 2037, 2006,
         1975, 1944, 1913, 1882, 1851, 1820, 1789, 1758, 1727, 1759, 1790, 1821, 1852, 1883, 1914, 1945, 1976, 2007, 2038, 2039, 2008, 1977, 1946, 1915, 1884, 1853, 1822, 1791, 1823, 1854, 1885, 1916,
         1947, 1978, 2009, 2040, 2041, 2010, 1979, 1948, 1917, 1886, 1855, 1887, 1918, 1949, 1980, 2011, 2042, 2043, 2012, 1981, 1950, 1919, 1951, 1982, 2013, 2044, 2045, 2014, 1983, 2015, 2046, 2047,
        },
    },
    {
        {
            0,    1,   64,   65,    2,    3,   66,   67,    4,    5,   68,   69,    6,    7,   70,   71,    8,    9,   72,   73,   10,   11,   74,   75,   12,   13,   76,   77,   14,   15,   78,   79,   16,   17,   80,   81,   18,   19,   82,   83,   20,   21,   84,   85,   22,   23,   86,   87,   24,   25,   88,   89,   26,   27,   90,   91,   28,   29,   92,   93,   30,   31,   94,   95,
           32,   33,   96,   97,   34,   35,   98,   99,   36,   37,  100,  101,   38,   39,  102,  103,   40,   41,  104,  105,   42,   43,  106,  107,   44,   45,  108,  109,   46,   47,  110,  111,   48,   49,  112,  113,   50,   51,  114,  115,   52,   53,  116,  117,   54,   55,  118,  119,   56,   57,  120,  121,   58,   59,  122,  123,   60,   61,  124,  125,   62,   63,  126,  127,
        },
        {
            0,    1,   64,  128,   65,    2,    3,   66,  129,  192,  193,  130,   67,    4,    5,   68,  131,  194,  195,  132,   69,    6,    7,   70,  133,  196,  197,  134,   71,    8,    9,   72,  135,  198,  199,  136,   73,   10,   11,   74,  137,  200,  201,  138,   75,   12,   13,   76,  139,  202,  203,  140,   77,   14,   15,   78,  141,  204,  205,  142,   79,   16,   17,   80,
          143,  206,  207,  144,   81,   18,   19,   82,  145,  208,  209,  146,   83,   20,   21,   84,  147,  210,  211,  148,   85,   22,   23,   86,  149,  212,  213,  150,   87,   24,   25,   88,  151,  214,  215,  152,   89,   26,   27,   90,  153,  216,  217,  154,   91,   28,   29,   92,  155,  218,  219,  156,   93,   30,   31,   94,  157,  220,  221,  158,   95,   32,   33,   96,
          159,  222,  223,  160,   97,   34,   35,   98,  161,  224,  225,  162,   99,   36,   37,  100,  163,  226,  227,  164,  101,   38,   39,  102,  165,  228,  229,  166,  103,   40,   41,  104,  167,  230,  231,  168,  105,   42,   43,  106,  169,  232,  233,  170,  107,   44,   45,  108,  171,  234,  235,  172,  109,   46,   47,  110,  173,  236,  237,  174,  111,   48,   49,  112,
          175,  238,  239,  176,  113,   50,   51,  114,  177,  240,  241,  178,  115,   52,   53,  116,  179,  242,  243,  180,  117,   54,   55,  118,  181,  244,  245,  182,  119,   56,   57,  120,  183,  246,  247,  184,  121,   58,   59,  122,  185,  248,  249,  186,  123,   60,   61,  124,  187,  250,  251,  188,  125,   62,   63,  126,  189,  252,  253,  190,  127,  191,  254,  255,
        },
        {
            0,    1,   64,  128,   65,    2,    3,   66,  129,  192,  256,  193,  130,   67,    4,    5,   68,  131,  194,  257,  320,  384,  321,  258,  195,  132,   69,    6,    7,   70,  133,  196,  259,  322,  385,  448,  449,  386,  323,  260,  197,  134,   71,    8,    9,   72,  135,  198,  261,  324,  387,  450,  451,  388,  325,  262,  199,  136,   73,   10,   11,   74,  137,  200,
          263,  326,  389,  452,  453,  390,  327,  264,  201,  138,   75,   12,   13,   76,  139,  202,  265,  328,  391,  454,  455,  392,  329,  266,  203,  140,   77,   14,   15,   78,  141,  204,  267,  330,  393,  456,  457,  394,  331,  268,  205,  142,   79,   16,   17,   80,  143,  206,  269,  332,  395,  458,  459,  396,  333,  270,  207,  144,   81,   18,   19,   82,  145,  208,
          271,  334,  397,  460,  461,  398,  335,  272,  209,  146,   83,   20,   21,   84,  147,  210,  273,  336,  399,  462,  463,  400,  337,  274,  211,  148,   85,   22,   23,   86,  149,  212,  275,  338,  401,  464,  465,  402,  339,  276,  213,  150,   87,   24,   25,   88,  151,  214,  277,  340,  403,  466,  467,  404,  341,  278,  215,  152,   89,   26,   27,   90,  153,  216,
          279,  342,  405,  468,  469,  406,  343,  280,  217,  154,   91,   28,   29,   92,  155,  218,  281,  344,  407,  470,  471,  408,  345,  282,  219,  156,   93,   30,   31,   94,  157,  220,  283,  346,  409,  472,  473,  410,  347,  284,  221,  158,   95,   32,   33,   96,  159,  222,  285,  348,  411,  474,  475,  412,  349,  286,  223,  160,   97,   34,   35,   98,  161,  224,
          287,  350,  413,  476,  477,  414,  351,  288,  225,  162,   99,   36,   37,  100,  163,  226,  289,  352,  415,  478,  479,  416,  353,  290,  227,  164,  101,   38,   39,  102,  165,  228,  291,  354,  417,  480,  481,  418,  355,  292,  229,  166,  103,   40,   41,  104,  167,  230,  293,  356,  419,  482,  483,  420,  357,  294,  231,  168,  105,   42,   43,  106,  169,  232,
          295,  358,  421,  484,  485,  422,  359,  296,  233,  170,  107,   44,   45,  108,  171,  234,  297,  360,  423,  486,  487,  424,  361,  298,  235,  172,  109,   46,   47,  110,  173,  236,  299,  362,  425,  488,  489,  426,  363,  300,  237,  174,  111,   48,   49,  112,  175,  238,  301,  364,  427,  490,  491,  428,  365,  302,  239,  176,  113,   50,   51,  114,  177,  240,
          303,  366,  429,  492,  493,  430,  367,  304,  241,  178,  115,   52,   53,  116,  179,  242,  305,  368,  431,  494,  495,  432,  369,  306,  243,  180,  117,   54,   55,  118,  181,  244,  307,  370,  433,  496,  497,  434,  371,  308,  245,  182,  119,   56,   57,  120,  183,  246,  309,  372,  435,  498,  499,  436,  373,  310,  247,  184,  121,   58,   59,  122,  185,  248,
          311,  374,  437,  500,  501,  438,  375,  312,  249,  186,  123,   60,   61,  124,  187,  250,  313,  376,  439,  502,  503,  440,  377,  314,  251,  188,  125,   62,   63,  126,  189,  252,  315,  378,  441,  504,  505,  442,  379,  316,  253,  190,  127,  191,  254,  317,  380,  443,  506,  507,  444,  381,  318,  255,  319,  382,  445,  508,  509,  446,  383,  447,  510,  511,
        },
        {
            0,    1,   64,  128,   65,    2,    3,   66,  129,  192,  256,  193,  130,   67,    4,    5,   68,  131,  194,  257,  320,  384,  321,  258,  195,  132,   69,    6,    7,   70,  133,  196,  259,  322,  385,  448,  512,  449,  386,  323,  260,  197,  134,   71,    8,    9,   72,  135,  198,  261,  324,  387,  450,  513,  576,  640,  577,  514,  451,  388,  325,  262,  199,  136,
           73,   10,   11,   74,  137,  200,  263,  326,  389,  452,  515,  578,  641,  704,  768,  705,  642,  579,  516,  453,  390,  327,  264,  201,  138,   75,   12,   13,   76,  139,  202,  265,  328,  391,  454,  517,  580,  643,  706,  769,  832,  896,  833,  770,  707,  644,  581,  518,  455,  392,  329,  266,  203,  140,   77,   14,   15,   78,  141,  204,  267,  330,  393,  456,
          519,  582,  645,  708,  771,  834,  897,  960,  961,  898,  835,  772,  709,  646,  583,  520,  457,  394,  331,  268,  205,  142,   79,   16,   17,   80,  143,  206,  269,  332,  395,  458,  521,  584,  647,  710,  773,  836,  899,  962,  963,  900,  837,  774,  711,  648,  585,  522,  459,  396,  333,  270,  207,  144,   81,   18,   19,   82,  145,  208,  271,  334,  397,  460,
          523,  586,  649,  712,  775,  838,  901,  964,  965,  902,  839,  776,  713,  650,  587,  524,  461,  398,  335,  272,  209,  146,   83,   20,   21,   84,  147,  210,  273,  336,  399,  462,  525,  588,  651,  714,  777,  840,  903,  966,  967,  904,  841,  778,  715,  652,  589,  526,  463,  400,  337,  274,  211,  148,   85,   22,   23,   86,  149,  212,  275,  338,  401,  464,
          527,  590,  653,  716,  779,  842,  905,  968,  969,  906,  843,  780,  717,  654,  591,  528,  465,  402,  339,  276,  213,  150,   87,   24,   25,   88,  151,  214,  277,  340,  403,  466,  529,  592,  655,  718,  781,  844,  907,  970,  971,  908,  845,  782,  719,  656,  593,  530,  467,  404,  341,  278,  215,  152,   89,   26,   27,   90,  153,  216,  279,  342,  405,  468,
          531,  594,  657,  720,  783,  846,  909,  972,  973,  910,  847,  784,  721,  658,  595,  532,  469,  406,  343,  280,  217,  154,   91,   28,   29,   92,  155,  218,  281,  344,  407,  470,  533,  596,  659,  722,  785,  848,  911,  974,  975,  912,  849,  786,  723,  660,  597,  534,  471,  408,  345,  282,  219,  156,   93,   30,   31,   94,  157,  220,  283,  346,  409,  472,
          535,  598,  661,  724,  787,  850,  913,  976,  977,  914,  851,  788,  725,  662,  599,  536,  473,  410,  347,  284,  221,  158,   95,   32,   33,   96,  159,  222,  285,  348,  411,  474,  537,  600,  663,  726,  789,  852,  915,  978,  979,  916,  853,  790,  727,  664,  601,  538,  475,  412,  349,  286,  223,  160,   97,   34,   35,   98,  161,  224,  287,  350,  413,  476,
          539,  602,  665,  728,  791,  854,  917,  980,  981,  918,  855,  792,  729,  666,  603,  540,  477,  414,  351,  288,  225,  162,   99,   36,   37,  100,  163,  226,  289,  352,  415,  478,  541,  604,  667,  730,  793,  856,  919,  982,  983,  920,  857,  794,  731,  668,  605,  542,  479,  416,  353,  290,  227,  164,  101,   38,   39,  102,  165,  228,  291,  354,  417,  480,
          543,  606,  669,  732,  795,  858,  921,  984,  985,  922,  859,  796,  733,  670,  607,  544,  481,  418,  355,  292,  229,  166,  103,   40,   41,  104,  167,  230,  293,  356,  419,  482,  545,  608,  671,  734,  797,  860,  923,  986,  987,  924,  861,  798,  735,  672,  609,  546,  483,  420,  357,  294,  231,  168,  105,   42,   43,  106,  169,  232,  295,  358,  421,  484,
          547,  610,  673,  736,  799,  862,  925,  988,  989,  926,  863,  800,  737,  674,  611,  548,  485,  422,  359,  296,  233,  170,  107,   44,   45,  108,  171,  234,  297,  360,  423,  486,  549,  612,  675,  738,  801,  864,  927,  990,  991,  928,  865,  802,  739,  676,  613,  550,  487,  424,  361,  298,  235,  172,  109,   46,   47,  110,  173,  236,  299,  362,  425,  488,
          551,  614,  677,  740,  803,  866,  929,  992,  993,  930,  867,  804,  741,  678,  615,  552,  489,  426,  363,  300,  237,  174,  111,   48,   49,  112,  175,  238,  301,  364,  427,  490,  553,  616,  679,  742,  805,  868,  931,  994,  995,  932,  869,  806,  743,  680,  617,  554,  491,  428,  365,  302,  239,  176,  113,   50,   51,  114,  177,  240,  303,  366,  429,  492,
          555,  618,  681,  744,  807,  870,  933,  996,  997,  934,  871,  808,  745,  682,  619,  556,  493,  430,  367,  304,  241,  178,  115,   52,   53,  116,  179,  242,  305,  368,  431,  494,  557,  620,  683,  746,  809,  872,  935,  998,  999,  936,  873,  810,  747,  684,  621,  558,  495,  432,  369,  306,  243,  180,  117,   54,   55,  118,  181,  244,  307,  370,  433,  496,
          559,  622,  685,  748,  811,  874,  937, 1000, 1001,  938,  875,  812,  749,  686,  623,  560,  497,  434,  371,  308,  245,  182,  119,   56,   57,  120,  183,  246,  309,  372,  435,  498,  561,  624,  687,  750,  813,  876,  939, 1002, 1003,  940,  877,  814,  751,  688,  625,  562,  499,  436,  373,  310,  247,  184,  121,   58,   59,  122,  185,  248,  311,  374,  437,  500,
          563,  626,  689,  752,  815,  878,  941, 1004, 1005,  942,  879,  816,  753,  690,  627,  564,  501,  438,  375,  312,  249,  186,  123,   60,   61,  124,  187,  250,  313,  376,  439,  502,  565,  628,  691,  754,  817,  880,  943, 1006, 1007,  944,  881,  818,  755,  692,  629,  566,  503,  440,  377,  314,  251,  188,  125,   62,   63,  126,  189,  252,  315,  378,  441,  504,
          567,  630,  693,  756,  819,  882,  945, 1008, 1009,  946,  883,  820,  757,  694,  631,  568,  505,  442,  379,  316,  253,  190,  127,  191,  254,  317,  380,  443,  506,  569,  632,  695,  758,  821,  884,  947, 1010, 1011,  948,  885,  822,  759,  696,  633,  570,  507,  444,  381,  318,  255,  319,  382,  445,  508,  571,  634,  697,  760,  823,  886,  949, 1012, 1013,  950,
          887,  824,  761,  698,  635,  572,  509,  446,  383,  447,  510,  573,  636,  699,  762,  825,  888,  951, 1014, 1015,  952,  889,  826,  763,  700,  637,  574,  511,  575,  638,  701,  764,  827,  890,  953, 1016, 1017,  954,  891,  828,  765,  702,  639,  703,  766,  829,  892,  955, 1018, 1019,  956,  893,  830,  767,  831,  894,  957, 1020, 1021,  958,  895,  959, 1022, 1023,
        },
        {
            0,    1,   64,  128,   65,    2,    3,   66,  129,  192,  256,  193,  130,   67,    4,    5,   68,  131,  194,  257,  320,  384,  321,  258,  195,  132,   69,    6,    7,   70,  133,  196,  259,  322,  385,  448,  512,  449,  386,  323,  260,  197,  134,   71,    8,    9,   72,  135,  198,  261,  324,  387,  450,  513,  576,  640,  577,  514,  451,  388,  325,  262,  199,  136,
           73,   10,   11,   74,  137,  200,  263,  326,  389,  452,  515,  578,  641,  704,  768,  705,  642,  579,  516,  453,  390,  327,  264,  201,  138,   75,   12,   13,   76,  139,  202,  265,  328,  391,  454,  517,  580,  643,  706,  769,  832,  896,  833,  770,  707,  644,  581,  518,  455,  392,  329,  266,  203,  140,   77,   14,   15,   78,  141,  204,  267,  330,  393,  456,
          519,  582,  645,  708,  771,  834,  897,  960, 1024,  961,  898,  835,  772,  709,  646,  583,  520,  457,  394,  331,  268,  205,  142,   79,   16,   17,   80,  143,  206,  269,  332,  395,  458,  521,  584,  647,  710,  773,  836,  899,  962, 1025, 1088, 1152, 1089, 1026,  963,  900,  837,  774,  711,  648,  585,  522,  459,  396,  333,  270,  207,  144,   81,   18,   19,   82,
          145,  208,  271,  334,  397,  460,  523,  586,  649,  712,  775,  838,  901,  964, 1027, 1090, 1153, 1216, 1280, 1217, 1154, 1091, 1028,  965,  902,  839,  776,  713,  650,  587,  524,  461,  398,  335,  272,  209,  146,   83,   20,   21,   84,  147,  210,  273,  336,  399,  462,  525,  588,  651,  714,  777,  840,  903,  966, 1029, 1092, 1155, 1218, 1281, 1344, 1408, 1345, 1282,
         1219, 1156, 1093, 1030,  967,  904,  841,  778,  715,  652,  589,  526,  463,  400,  337,  274,  211,  148,   85,   22,   23,   86,  149,  212,  275,  338,  401,  464,  527,  590,  653,  716,  779,  842,  905,  968, 1031, 1094, 1157, 1220, 1283, 1346, 1409, 1472, 1536, 1473, 1410, 1347, 1284, 1221, 1158, 1095, 1032,  969,  906,  843,  780,  717,  654,  591,  528,  465,  402,  339,
          276,  213,  150,   87,   24,   25,   88,  151,  214,  277,  340,  403,  466,  529,  592,  655,  718,  781,  844,  907,  970, 1033, 1096, 1159, 1222, 1285, 1348, 1411, 1474, 1537, 1600, 1664, 1601, 1538, 1475, 1412, 1349, 1286, 1223, 1160, 1097, 1034,  971,  908,  845,  782,  719,  656,  593,  530,  467,  404,  341,  278,  215,  152,   89,   26,   27,   90,  153,  216,  279,  342,
          405,  468,  531,  594,  657,  720,  783,  846,  909,  972, 1035, 1098, 1161, 1224, 1287, 1350, 1413, 1476, 1539, 1602, 1665, 1728, 1792, 1729, 1666, 1603, 1540, 1477, 1414, 1351, 1288, 1225, 1162, 1099, 1036,  973,  910,  847,  784,  721,  658,  595,  532,  469,  406,  343,  280,  217,  154,   91,   28,   29,   92,  155,  218,  281,  344,  407,  470,  533,  596,  659,  722,  785,
          848,  911,  974, 1037, 1100, 1163, 1226, 1289, 1352, 1415, 1478, 1541, 1604, 1667, 1730, 1793, 1856, 1920, 1857, 1794, 1731, 1668, 1605, 1542, 1479, 1416, 1353, 1290, 1227, 1164, 1101, 1038,  975,  912,  849,  786,  723,  660,  597,  534,  471,  408,  345,  282,  219,  156,   93,   30,   31,   94,  157,  220,  283,  346,  409,  472,  535,  598,  661,  724,  787,  850,  913,  976,
         1039, 1102, 1165, 1228, 1291, 1354, 1417, 1480, 1543, 1606, 1669, 1732, 1795, 1858, 1921, 1984, 1985, 1922, 1859, 1796, 1733, 1670, 1607, 1544, 1481, 1418, 1355, 1292, 1229, 1166, 1103, 1040,  977,  914,  851,  788,  725,  662,  599,  536,  473,  410,  347,  284,  221,  158,   95,   32,   33,   96,  159,  222,  285,  348,  411,  474,  537,  600,  663,  726,  789,  852,  915,  978,
         1041, 1104, 1167, 1230, 1293, 1356, 1419, 1482, 1545, 1608, 1671, 1734, 1797, 1860, 1923, 1986, 1987, 1924, 1861, 1798, 1735, 1672, 1609, 1546, 1483, 1420, 1357, 1294, 1231, 1168, 1105, 1042,  979,  916,  853,  790,  727,  664,  601,  538,  475,  412,  349,  286,  223,  160,   97,   34,   35,   98,  161,  224,  287,  350,  413,  476,  539,  602,  665,  728,  791,  854,  917,  980,
         1043, 1106, 1169, 1232, 1295, 1358, 1421, 1484, 1547, 1610, 1673, 1736, 1799, 1862, 1925, 1988, 1989, 1926, 1863, 1800, 1737, 1674, 1611, 1548, 1485, 1422, 1359, 1296, 1233, 1170, 1107, 1044,  981,  918,  855,  792,  729,  666,  603,  540,  477,  414,  351,  288,  225,  162,   99,   36,   37,  100,  163,  226,  289,  352,  415,  478,  541,  604,  667,  730,  793,  856,  919,  982,
         1045, 1108, 1171, 1234, 1297, 1360, 1423, 1486, 1549, 1612, 1675, 1738, 1801, 1864, 1927, 1990, 1991, 1928, 1865, 1802, 1739, 1676, 1613, 1550, 1487, 1424, 1361, 1298, 1235, 1172, 1109, 1046,  983,  920,  857,  794,  731,  668,  605,  542,  479,  416,  353,  290,  227,  164,  101,   38,   39,  102,  165,  228,  291,  354,  417,  480,  543,  606,  669,  732,  795,  858,  921,  984,
         1047, 1110, 1173, 1236, 1299, 1362, 1425, 1488, 1551, 1614, 1677, 1740, 1803, 1866, 1929, 1992, 1993, 1930, 1867, 1804, 1741, 1678, 1615, 1552, 1489, 1426, 1363, 1300, 1237, 1174, 1111, 1048,  985,  922,  859,  796,  733,  670,  607,  544,  481,  418,  355,  292,  229,  166,  103,   40,   41,  104,  167,  230,  293,  356,  419,  482,  545,  608,  671,  734,  797,  860,  923,  986,
         1049, 1112, 1175, 1238, 1301, 1364, 1427, 1490, 1553, 1616, 1679, 1742, 1805, 1868, 1931, 1994, 1995, 1932, 1869, 1806, 1743, 1680, 1617, 1554, 1491, 1428, 1365, 1302, 1239, 1176, 1113, 1050,  987,  924,  861,  798,  735,  672,  609,  546,  483,  420,  357,  294,  231,  168,  105,   42,   43,  106,  169,  232,  295,  358,  421,  484,  547,  610,  673,  736,  799,  862,  925,  988,
         1051, 1114, 1177, 1240, 1303, 1366, 1429, 1492, 1555, 1618, 1681, 1744, 1807, 1870, 1933, 1996, 1997, 1934, 1871, 1808, 1745, 1682, 1619, 1556, 1493, 1430, 1367, 1304, 1241, 1178, 1115, 1052,  989,  926,  863,  800,  737,  674,  611,  548,  485,  422,  359,  296,  233,  170,  107,   44,   45,  108,  171,  234,  297,  360,  423,  486,  549,  612,  675,  738,  801,  864,  927,  990,
         1053, 1116, 1179, 1242, 1305, 1368, 1431, 1494, 1557, 1620, 1683, 1746, 1809, 1872, 1935, 1998, 1999, 1936, 1873, 1810, 1747, 1684, 1621, 1558, 1495, 1432, 1369, 1306, 1243, 1180, 1117, 1054,  991,  928,  865,  802,  739,  676,  613,  550,  487,  424,  361,  298,  235,  172,  109,   46,   47,  110,  173,  236,  299,  362,  425,  488,  551,  614,  677,  740,  803,  866,  929,  992,
         1055, 1118, 1181, 1244, 1307, 1370, 1433, 1496, 1559, 1622, 1685, 1748, 1811, 1874, 1937, 2000, 2001, 1938, 1875, 1812, 1749, 1686, 1623, 1560, 1497, 1434, 1371, 1308, 1245, 1182, 1119, 1056,  993,  930,  867,  804,  741,  678,  615,  552,  489,  426,  363,  300,  237,  174,  111,   48,   49,  112,  175,  238,  301,  364,  427,  490,  553,  616,  679,  742,  805,  868,  931,  994,
         1057, 1120, 1183, 1246, 1309, 1372, 1435, 1498, 1561, 1624, 1687, 1750, 1813, 1876, 1939, 2002, 2003, 1940, 1877, 1814, 1751, 1688, 1625, 1562, 1499, 1436, 1373, 1310, 1247, 1184, 1121, 1058,  995,  932,  869,  806,  743,  680,  617,  554,  491,  428,  365,  302,  239,  176,  113,   50,   51,  114,  177,  240,  303,  366,  429,  492,  555,  618,  681,  744,  807,  870,  933,  996,
         1059, 1122, 1185, 1248, 1311, 1374, 1437, 1500, 1563, 1626, 1689, 1752, 1815, 1878, 1941, 2004, 2005, 1942, 1879, 1816, 1753, 1690, 1627, 1564, 1501, 1438, 1375, 1312, 1249, 1186, 1123, 1060,  997,  934,  871,  808,  745,  682,  619,  556,  493,  430,  367,  304,  241,  178,  115,   52,   53,  116,  179,  242,  305,  368,  431,  494,  557,  620,  683,  746,  809,  872,  935,  998,
         1061, 1124, 1187, 1250, 1313, 1376, 1439, 1502, 1565, 1628, 1691, 1754, 1817, 1880, 1943, 2006, 2007, 1944, 1881, 1818, 1755, 1692, 1629, 1566, 1503, 1440, 1377, 1314, 1251, 1188, 1125, 1062,  999,  936,  873,  810,  747,  684,  621,  558,  495,  432,  369,  306,  243,  180,  117,   54,   55,  118,  181,  244,  307,  370,  433,  496,  559,  622,  685,  748,  811,  874,  937, 1000,
         1063, 1126, 1189, 1252, 1315, 1378, 1441, 1504, 1567, 1630, 1693, 1756, 1819, 1882, 1945, 2008, 2009, 1946, 1883, 1820, 1757, 1694, 1631, 1568, 1505, 1442, 1379, 1316, 1253, 1190, 1127, 1064, 1001,  938,  875,  812,  749,  686,  623,  560,  497,  434,  371,  308,  245,  182,  119,   56,   57,  120,  183,  246,  309,  372,  435,  498,  561,  624,  687,  750,  813,  876,  939, 1002,
         1065, 1128, 1191, 1254, 1317, 1380, 1443, 1506, 1569, 1632, 1695, 1758, 1821, 1884, 1947, 2010, 2011, 1948, 1885, 1822, 1759, 1696, 1633, 1570, 1507, 1444, 1381, 1318, 1255, 1192, 1129, 1066, 1003,  940,  877,  814,  751,  688,  625,  562,  499,  436,  373,  310,  247,  184,  121,   58,   59,  122,  185,  248,  311,  374,  437,  500,  563,  626,  689,  752,  815,  878,  941, 1004,
         1067, 1130, 1193, 1256, 1319, 1382, 1445, 1508, 1571, 1634, 1697, 1760, 1823, 1886, 1949, 2012, 2013, 1950, 1887, 1824, 1761, 1698, 1635, 1572, 1509, 1446, 1383, 1320, 1257, 1194, 1131, 1068, 1005,  942,  879,  816,  753,  690,  627,  564,  501,  438,  375,  312,  249,  186,  123,   60,   61,  124,  187,  250,  313,  376,  439,  502,  565,  628,  691,  754,  817,  880,  943, 1006,
         1069, 1132, 1195, 1258, 1321, 1384, 1447, 1510, 1573, 1636, 1699, 1762, 1825, 1888, 1951, 2014, 2015, 1952, 1889, 1826, 1763, 1700, 1637, 1574, 1511, 1448, 1385, 1322, 1259, 1196, 1133, 1070, 1007,  944,  881,  818,  755,  692,  629,  566,  503,  440,  377,  314,  251,  188,  125,   62,   63,  126,  189,  252,  315,  378,  441,  504,  567,  630,  693,  756,  819,  882,  945, 1008,
         1071, 1134, 1197, 1260, 1323, 1386, 1449, 1512, 1575, 1638, 1701, 1764, 1827, 1890, 1953, 2016, 2017, 1954, 1891, 1828, 1765, 1702, 1639, 1576, 1513, 1450, 1387, 1324, 1261, 1198, 1135, 1072, 1009,  946,  883,  820,  757,  694,  631,  568,  505,  442,  379,  316,  253,  190,  127,  191,  254,  317,  380,  443,  506,  569,  632,  695,  758,  821,  884,  947, 1010, 1073, 1136, 1199,
         1262, 1325, 1388, 1451, 1514, 1577, 1640, 1703, 1766, 1829, 1892, 1955, 2018, 2019, 1956, 1893, 1830, 1767, 1704, 1641, 1578, 1515, 1452, 1389, 1326, 1263, 1200, 1137, 1074, 1011,  948,  885,  822,  759,  696,  633,  570,  507,  444,  381,  318,  255,  319,  382,  445,  508,  571,  634,  697,  760,  823,  886,  949, 1012, 1075, 1138, 1201, 1264, 1327, 1390, 1453, 1516, 1579, 1642,
         1705, 1768, 1831, 1894, 1957, 2020, 2021, 1958, 1895, 1832, 1769, 1706, 1643, 1580, 1517, 1454, 1391, 1328, 1265, 1202, 1139, 1076, 1013,  950,  887,  824,  761,  698,  635,  572,  509,  446,  383,  447,  510,  573,  636,  699,  762,  825,  888,  951, 1014, 1077, 1140, 1203, 1266, 1329, 1392, 1455, 1518, 1581, 1644, 1707, 1770, 1833, 1896, 1959, 2022, 2023, 1960, 1897, 1834, 1771,
         1708, 1645, 1582, 1519, 1456, 1393, 1330, 1267, 1204, 1141, 1078, 1015,  952,  889,  826,  763,  700,  637,  574,  511,  575,  638,  701,  764,  827,  890,  953, 1016, 1079, 1142, 1205, 1268, 1331, 1394, 1457, 1520, 1583, 1646, 1709, 1772, 1835, 1898, 1961, 2024, 2025, 1962, 1899, 1836, 1773, 1710, 1647, 1584, 1521, 1458, 1395, 1332, 1269, 1206, 1143, 1080, 1017,  954,  891,  828,
          765,  702,  639,  703,  766,  829,  892,  955, 1018, 1081, 1144, 1207, 1270, 1333, 1396, 1459, 1522, 1585, 1648, 1711, 1774, 1837, 1900, 1963, 2026, 2027, 1964, 1901, 1838, 1775, 1712, 1649, 1586, 1523, 1460, 1397, 1334, 1271, 1208, 1145, 1082, 1019,  956,  893,  830,  767,  831,  894,  957, 1020, 1083, 1146, 1209, 1272, 1335, 1398, 1461, 1524, 1587, 1650, 1713, 1776, 1839, 1902,
         1965, 2028, 2029, 1966, 1903, 1840, 1777, 1714, 1651, 1588, 1525, 1462, 1399, 1336, 1273, 1210, 1147, 1084, 1021,  958,  895,  959, 1022, 1085, 1148, 1211, 1274, 1337, 1400, 1463, 1526, 1589, 1652, 1715, 1778, 1841, 1904, 1967, 2030, 2031, 1968, 1905, 1842, 1779, 1716, 1653, 1590, 1527, 1464, 1401, 1338, 1275, 1212, 1149, 1086, 1023, 1087, 1150, 1213, 1276, 1339, 1402, 1465, 1528,
         1591, 1654, 1717, 1780, 1843, 1906, 1969, 2032, 2033, 1970, 1907, 1844, 1781, 1718, 1655, 1592, 1529, 1466, 1403, 1340, 1277, 1214, 1151, 1215, 1278, 1341, 1404, 1467, 1530, 1593, 1656, 1719, 1782, 1845, 1908, 1971, 2034, 2035, 1972, 1909, 1846, 1783, 1720, 1657, 1594, 1531, 1468, 1405, 1342, 1279, 1343, 1406, 1469, 1532, 1595, 1658, 1721, 1784, 1847, 1910, 1973, 2036, 2037, 1974,
         1911, 1848, 1785, 1722, 1659, 1596, 1533, 1470, 1407, 1471, 1534, 1597, 1660, 1723, 1786, 1849, 1912, 1975, 2038, 2039, 1976, 1913, 1850, 1787, 1724, 1661, 1598, 1535, 1599, 1662, 1725, 1788, 1851, 1914, 1977, 2040, 2041, 1978, 1915, 1852, 1789, 1726, 1663, 1727, 1790, 1853, 1916, 1979, 2042, 2043, 1980, 1917, 1854, 1791, 1855, 1918, 1981, 2044, 2045, 1982, 1919, 1983, 2046, 2047,
        },
        {
            0,    1,   64,  128,   65,    2,    3,   66,  129,  192,  256,  193,  130,   67,    4,    5,   68,  131,  194,  257,  320,  384,  321,  258,  195,  132,   69,    6,    7,   70,  133,  196,  259,  322,  385,  448,  512,  449,  386,  323,  260,  197,  134,   71,    8,    9,   72,  135,  198,  261,  324,  387,  450,  513,  576,  640,  577,  514,  451,  388,  325,  262,  199,  136,
           73,   10,   11,   74,  137,  200,  263,  326,  389,  452,  515,  578,  641,  704,  768,  705,  642,  579,  516,  453,  390,  327,  264,  201,  138,   75,   12,   13,   76,  139,  202,  265,  328,  391,  454,  517,  580,  643,  706,  769,  832,  896,  833,  770,  707,  644,  581,  518,  455,  392,  329,  266,  203,  140,   77,   14,   15,   78,  141,  204,  267,  330,  393,  456,
          519,  582,  645,  708,  771,  834,  897,  960, 1024,  961,  898,  835,  772,  709,  646,  583,  520,  457,  394,  331,  268,  205,  142,   79,   16,   17,   80,  143,  206,  269,  332,  395,  458,  521,  584,  647,  710,  773,  836,  899,  962, 1025, 1088, 1152, 1089, 1026,  963,  900,  837,  774,  711,  648,  585,  522,  459,  396,  333,  270,  207,  144,   81,   18,   19,   82,
          145,  208,  271,  334,  397,  460,  523,  586,  649,  712,  775,  838,  901,  964, 1027, 1090, 1153, 1216, 1280, 1217, 1154, 1091, 1028,  965,  902,  839,  776,  713,  650,  587,  524,  461,  398,  335,  272,  209,  146,   83,   20,   21,   84,  147,  210,  273,  336,  399,  462,  525,  588,  651,  714,  777,  840,  903,  966, 1029, 1092, 1155, 1218, 1281, 1344, 1408, 1345, 1282,
         1219, 1156, 1093, 1030,  967,  904,  841,  778,  715,  652,  589,  526,  463,  400,  337,  274,  211,  148,   85,   22,   23,   86,  149,  212,  275,  338,  401,  464,  527,  590,  653,  716,  779,  842,  905,  968, 1031, 1094, 1157, 1220, 1283, 1346, 1409, 1472, 1536, 1473, 1410, 1347, 1284, 1221, 1158, 1095, 1032,  969,  906,  843,  780,  717,  654,  591,  528,  465,  402,  339,
          276,  213,  150,   87,   24,   25,   88,  151,  214,  277,  340,  403,  466,  529,  592,  655,  718,  781,  844,  907,  970, 1033, 1096, 1159, 1222, 1285, 1348, 1411, 1474, 1537, 1600, 1664, 1601, 1538, 1475, 1412, 1349, 1286, 1223, 1160, 1097, 1034,  971,  908,  845,  782,  719,  656,  593,  530,  467,  404,  341,  278,  215,  152,   89,   26,   27,   90,  153,  216,  279,  342,
          405,  468,  531,  594,  657,  720,  783,  846,  909,  972, 1035, 1098, 1161, 1224, 1287, 1350, 1413, 1476, 1539, 1602, 1665, 1728, 1792, 1729, 1666, 1603, 1540, 1477, 1414, 1351, 1288, 1225, 1162, 1099, 1036,  973,  910,  847,  784,  721,  658,  595,  532,  469,  406,  343,  280,  217,  154,   91,   28,   29,   92,  155,  218,  281,  344,  407,  470,  533,  596,  659,  722,  785,
          848,  911,  974, 1037, 1100, 1163, 1226, 1289, 1352, 1415, 1478, 1541, 1604, 1667, 1730, 1793, 1856, 1920, 1857, 1794, 1731, 1668, 1605, 1542, 1479, 1416, 1353, 1290, 1227, 1164, 1101, 1038,  975,  912,  849,  786,  723,  660,  597,  534,  471,  408,  345,  282,  219,  156,   93,   30,   31,   94,  157,  220,  283,  346,  409,  472,  535,  598,  661,  724,  787,  850,  913,  976,
         1039, 1102, 1165, 1228, 1291, 1354, 1417, 1480, 1543, 1606, 1669, 1732, 1795, 1858, 1921, 1984, 2048, 1985, 1922, 1859, 1796, 1733, 1670, 1607, 1544, 1481, 1418, 1355, 1292, 1229, 1166, 1103, 1040,  977,  914,  851,  788,  725,  662,  599,  536,  473,  410,  347,  284,  221,  158,   95,   32,   33,   96,  159,  222,  285,  348,  411,  474,  537,  600,  663,  726,  789,  852,  915,
          978, 1041, 1104, 1167, 1230, 1293, 1356, 1419, 1482, 1545, 1608, 1671, 1734, 1797, 1860, 1923, 1986, 2049, 2112, 2176, 2113, 2050, 1987, 1924, 1861, 1798, 1735, 1672, 1609, 1546, 1483, 1420, 1357, 1294, 1231, 1168, 1105, 1042,  979,  916,  853,  790,  727,  664,  601,  538,  475,  412,  349,  286,  223,  160,   97,   34,   35,   98,  161,  224,  287,  350,  413,  476,  539,  602,
          665,  728,  791,  854,  917,  980, 1043, 1106, 1169, 1232, 1295, 1358, 1421, 1484, 1547, 1610, 1673, 1736, 1799, 1862, 1925, 1988, 2051, 2114, 2177, 2240, 2304, 2241, 2178, 2115, 2052, 1989, 1926, 1863, 1800, 1737, 1674, 1611, 1548, 1485, 1422, 1359, 1296, 1233, 1170, 1107, 1044,  981,  918,  855,  792,  729,  666,  603,  540,  477,  414,  351,  288,  225,  162,   99,   36,   37,
          100,  163,  226,  289,  352,  415,  478,  541,  604,  667,  730,  793,  856,  919,  982, 1045, 1108, 1171, 1234, 1297, 1360, 1423, 1486, 1549, 1612, 1675, 1738, 1801, 1864, 1927, 1990, 2053, 2116, 2179, 2242, 2305, 2368, 2432, 2369, 2306, 2243, 2180, 2117, 2054, 1991, 1928, 1865, 1802, 1739, 1676, 1613, 1550, 1487, 1424, 1361, 1298, 1235, 1172, 1109, 1046,  983,  920,  857,  794,
          731,  668,  605,  542,  479,  416,  353,  290,  227,  164,  101,   38,   39,  102,  165,  228,  291,  354,  417,  480,  543,  606,  669,  732,  795,  858,  921,  984, 1047, 1110, 1173, 1236, 1299, 1362, 1425, 1488, 1551, 1614, 1677, 1740, 1803, 1866, 1929, 1992, 2055, 2118, 2181, 2244, 2307, 2370, 2433, 2496, 2560, 2497, 2434, 2371, 2308, 2245, 2182, 2119, 2056, 1993, 1930, 1867,
         1804, 1741, 1678, 1615, 1552, 1489, 1426, 1363, 1300, 1237, 1174, 1111, 1048,  985,  922,  859,  796,  733,  670,  607,  544,  481,  418,  355,  292,  229,  166,  103,   40,   41,  104,  167,  230,  293,  356,  419,  482,  545,  608,  671,  734,  797,  860,  923,  986, 1049, 1112, 1175, 1238, 1301, 1364, 1427, 1490, 1553, 1616, 1679, 1742, 1805, 1868, 1931, 1994, 2057, 2120, 2183,
         2246, 2309, 2372, 2435, 2498, 2561, 2624, 2688, 2625, 2562, 2499, 2436, 2373, 2310, 2247, 2184, 2121, 2058, 1995, 1932, 1869, 1806, 1743, 1680, 1617, 1554, 1491, 1428, 1365, 1302, 1239, 1176, 1113, 1050,  987,  924,  861,  798,  735,  672,  609,  546,  483,  420,  357,  294,  231,  168,  105,   42,   43,  106,  169,  232,  295,  358,  421,  484,  547,  610,  673,  736,  799,  862,
          925,  988, 1051, 1114, 1177, 1240, 1303, 1366, 1429, 1492, 1555, 1618, 1681, 1744, 1807, 1870, 1933, 1996, 2059, 2122, 2185, 2248, 2311, 2374, 2437, 2500, 2563, 2626, 2689, 2752, 2816, 2753, 2690, 2627, 2564, 2501, 2438, 2375, 2312, 2249, 2186, 2123, 2060, 1997, 1934, 1871, 1808, 1745, 1682, 1619, 1556, 1493, 1430, 1367, 1304, 1241, 1178, 1115, 1052,  989,  926,  863,  800,  737,
          674,  611,  548,  485,  422,  359,  296,  233,  170,  107,   44,   45,  108,  171,  234,  297,  360,  423,  486,  549,  612,  675,  738,  801,  864,  927,  990, 1053, 1116, 1179, 1242, 1305, 1368, 1431, 1494, 1557, 1620, 1683, 1746, 1809, 1872, 1935, 1998, 2061, 2124, 2187, 2250, 2313, 2376, 2439, 2502, 2565, 2628, 2691, 2754, 2817, 2880, 2944, 2881, 2818, 2755, 2692, 2629, 2566,
         2503, 2440, 2377, 2314, 2251, 2188, 2125, 2062, 1999, 1936, 1873, 1810, 1747, 1684, 1621, 1558, 1495, 1432, 1369, 1306, 1243, 1180, 1117, 1054,  991,  928,  865,  802,  739,  676,  613,  550,  487,  424,  361,  298,  235,  172,  109,   46,   47,  110,  173,  236,  299,  362,  425,  488,  551,  614,  677,  740,  803,  866,  929,  992, 1055, 1118, 1181, 1244, 1307, 1370, 1433, 1496,
         1559, 1622, 1685, 1748, 1811, 1874, 1937, 2000, 2063, 2126, 2189, 2252, 2315, 2378, 2441, 2504, 2567, 2630, 2693, 2756, 2819, 2882, 2945, 3008, 3072, 3009, 2946, 2883, 2820, 2757, 2694, 2631, 2568, 2505, 2442, 2379, 2316, 2253, 2190, 2127, 2064, 2001, 1938, 1875, 1812, 1749, 1686, 1623, 1560, 1497, 1434, 1371, 1308, 1245, 1182, 1119, 1056,  993,  930,  867,  804,  741,  678,  615,
          552,  489,  426,  363,  300,  237,  174,  111,   48,   49,  112,  175,  238,  301,  364,  427,  490,  553,  616,  679,  742,  805,  868,  931,  994, 1057, 1120, 1183, 1246, 1309, 1372, 1435, 1498, 1561, 1624, 1687, 1750, 1813, 1876, 1939, 2002, 2065, 2128, 2191, 2254, 2317, 2380, 2443, 2506, 2569, 2632, 2695, 2758, 2821, 2884, 2947, 3010, 3073, 3136, 3200, 3137, 3074, 3011, 2948,
         2885, 2822, 2759, 2696, 2633, 2570, 2507, 2444, 2381, 2318, 2255, 2192, 2129, 2066, 2003, 1940, 1877, 1814, 1751, 1688, 1625, 1562, 1499, 1436, 1373, 1310, 1247, 1184, 1121, 1058,  995,  932,  869,  806,  743,  680,  617,  554,  491,  428,  365,  302,  239,  176,  113,   50,   51,  114,  177,  240,  303,  366,  429,  492,  555,  618,  681,  744,  807,  870,  933,  996, 1059, 1122,
         1185, 1248, 1311, 1374, 1437, 1500, 1563, 1626, 1689, 1752, 1815, 1878, 1941, 2004, 2067, 2130, 2193, 2256, 2319, 2382, 2445, 2508, 2571, 2634, 2697, 2760, 2823, 2886, 2949, 3012, 3075, 3138, 3201, 3264, 3328, 3265, 3202, 3139, 3076, 3013, 2950, 2887, 2824, 2761, 2698, 2635, 2572, 2509, 2446, 2383, 2320, 2257, 2194, 2131, 2068, 2005, 1942, 1879, 1816, 1753, 1690, 1627, 1564, 1501,
         1438, 1375, 1312, 1249, 1186, 1123, 1060,  997,  934,  871,  808,  745,  682,  619,  556,  493,  430,  367,  304,  241,  178,  115,   52,   53,  116,  179,  242,  305,  368,  431,  494,  557,  620,  683,  746,  809,  872,  935,  998, 1061, 1124, 1187, 1250, 1313, 1376, 1439, 1502, 1565, 1628, 1691, 1754, 1817, 1880, 1943, 2006, 2069, 2132, 2195, 2258, 2321, 2384, 2447, 2510, 2573,
         2636, 2699, 2762, 2825, 2888, 2951, 3014, 3077, 3140, 3203, 3266, 3329, 3392, 3456, 3393, 3330, 3267, 3204, 3141, 3078, 3015, 2952, 2889, 2826, 2763, 2700, 2637, 2574, 2511, 2448, 2385, 2322, 2259, 2196, 2133, 2070, 2007, 1944, 1881, 1818, 1755, 1692, 1629, 1566, 1503, 1440, 1377, 1314, 1251, 1188, 1125, 1062,  999,  936,  873,  810,  747,  684,  621,  558,  495,  432,  369,  306,
          243,  180,  117,   54,   55,  118,  181,  244,  307,  370,  433,  496,  559,  622,  685,  748,  811,  874,  937, 1000, 1063, 1126, 1189, 1252, 1315, 1378, 1441, 1504, 1567, 1630, 1693, 1756, 1819, 1882, 1945, 2008, 2071, 2134, 2197, 2260, 2323, 2386, 2449, 2512, 2575, 2638, 2701, 2764, 2827, 2890, 2953, 3016, 3079, 3142, 3205, 3268, 3331, 3394, 3457, 3520, 3584, 3521, 3458, 3395,
         3332, 3269, 3206, 3143, 3080, 3017, 2954, 2891, 2828, 2765, 2702, 2639, 2576, 2513, 2450, 2387, 2324, 2261, 2198, 2135, 2072, 2009, 1946, 1883, 1820, 1757, 1694, 1631, 1568, 1505, 1442, 1379, 1316, 1253, 1190, 1127, 1064, 1001,  938,  875,  812,  749,  686,  623,  560,  497,  434,  371,  308,  245,  182,  119,   56,   57,  120,  183,  246,  309,  372,  435,  498,  561,  624,  687,
          750,  813,  876,  939, 1002, 1065, 1128, 1191, 1254, 1317, 1380, 1443, 1506, 1569, 1632, 1695, 1758, 1821, 1884, 1947, 2010, 2073, 2136, 2199, 2262, 2325, 2388, 2451, 2514, 2577, 2640, 2703, 2766, 2829, 2892, 2955, 3018, 3081, 3144, 3207, 3270, 3333, 3396, 3459, 3522, 3585, 3648, 3712, 3649, 3586, 3523, 3460, 3397, 3334, 3271, 3208, 3145, 3082, 3019, 2956, 2893, 2830, 2767, 2704,
         2641, 2578, 2515, 2452, 2389, 2326, 2263, 2200, 2137, 2074, 2011, 1948, 1885, 1822, 1759, 1696, 1633, 1570, 1507, 1444, 1381, 1318, 1255, 1192, 1129, 1066, 1003,  940,  877,  814,  751,  688,  625,  562,  499,  436,  373,  310,  247,  184,  121,   58,   59,  122,  185,  248,  311,  374,  437,  500,  563,  626,  689,  752,  815,  878,  941, 1004, 1067, 1130, 1193, 1256, 1319, 1382,
         1445, 1508, 1571, 1634, 1697, 1760, 1823, 1886, 1949, 2012, 2075, 2138, 2201, 2264, 2327, 2390, 2453, 2516, 2579, 2642, 2705, 2768, 2831, 2894, 2957, 3020, 3083, 3146, 3209, 3272, 3335, 3398, 3461, 3524, 3587, 3650, 3713, 3776, 3840, 3777, 3714, 3651, 3588, 3525, 3462, 3399, 3336, 3273, 3210, 3147, 3084, 3021, 2958, 2895, 2832, 2769, 2706, 2643, 2580, 2517, 2454, 2391, 2328, 2265,
         2202, 2139, 2076, 2013, 1950, 1887, 1824, 1761, 1698, 1635, 1572, 1509, 1446, 1383, 1320, 1257, 1194, 1131, 1068, 1005,  942,  879,  816,  753,  690,  627,  564,  501,  438,  375,  312,  249,  186,  123,   60,   61,  124,  187,  250,  313,  376,  439,  502,  565,  628,  691,  754,  817,  880,  943, 1006, 1069, 1132, 1195, 1258, 1321, 1384, 1447, 1510, 1573, 1636, 1699, 1762, 1825,
         1888, 1951, 2014, 2077, 2140, 2203, 2266, 2329, 2392, 2455, 2518, 2581, 2644, 2707, 2770, 2833, 2896, 2959, 3022, 3085, 3148, 3211, 3274, 3337, 3400, 3463, 3526, 3589, 3652, 3715, 3778, 3841, 3904, 3968, 3905, 3842, 3779, 3716, 3653, 3590, 3527, 3464, 3401, 3338, 3275, 3212, 3149, 3086, 3023, 2960, 2897, 2834, 2771, 2708, 2645, 2582, 2519, 2456, 2393, 2330, 2267, 2204, 2141, 2078,
         2015, 1952, 1889, 1826, 1763, 1700, 1637, 1574, 1511, 1448, 1385, 1322, 1259, 1196, 1133, 1070, 1007,  944,  881,  818,  755,  692,  629,  566,  503,  440,  377,  314,  251,  188,  125,   62,   63,  126,  189,  252,  315,  378,  441,  504,  567,  630,  693,  756,  819,  882,  945, 1008, 1071, 1134, 1197, 1260, 1323, 1386, 1449, 1512, 1575, 1638, 1701, 1764, 1827, 1890, 1953, 2016,
         2079, 2142, 2205, 2268, 2331, 2394, 2457, 2520, 2583, 2646, 2709, 2772, 2835, 2898, 2961, 3024, 3087, 3150, 3213, 3276, 3339, 3402, 3465, 3528, 3591, 3654, 3717, 3780, 3843, 3906, 3969, 4032, 4033, 3970, 3907, 3844, 3781, 3718, 3655, 3592, 3529, 3466, 3403, 3340, 3277, 3214, 3151, 3088, 3025, 2962, 2899, 2836, 2773, 2710, 2647, 2584, 2521, 2458, 2395, 2332, 2269, 2206, 2143, 2080,
         2017, 1954, 1891, 1828, 1765, 1702, 1639, 1576, 1513, 1450, 1387, 1324, 1261, 1198, 1135, 1072, 1009,  946,  883,  820,  757,  694,  631,  568,  505,  442,  379,  316,  253,  190,  127,  191,  254,  317,  380,  443,  506,  569,  632,  695,  758,  821,  884,  947, 1010, 1073, 1136, 1199, 1262, 1325, 1388, 1451, 1514, 1577, 1640, 1703, 1766, 1829, 1892, 1955, 2018, 2081, 2144, 2207,
         2270, 2333, 2396, 2459, 2522, 2585, 2648, 2711, 2774, 2837, 2900, 2963, 3026, 3089, 3152, 3215, 3278, 3341, 3404, 3467, 3530, 3593, 3656, 3719, 3782, 3845, 3908, 3971, 4034, 4035, 3972, 3909, 3846, 3783, 3720, 3657, 3594, 3531, 3468, 3405, 3342, 3279, 3216, 3153, 3090, 3027, 2964, 2901, 2838, 2775, 2712, 2649, 2586, 2523, 2460, 2397, 2334, 2271, 2208, 2145, 2082, 2019, 1956, 1893,
         1830, 1767, 1704, 1641, 1578, 1515, 1452, 1389, 1326, 1263, 1200, 1137, 1074, 1011,  948,  885,  822,  759,  696,  633,  570,  507,  444,  381,  318,  255,  319,  382,  445,  508,  571,  634,  697,  760,  823,  886,  949, 1012, 1075, 1138, 1201, 1264, 1327, 1390, 1453, 1516, 1579, 1642, 1705, 1768, 1831, 1894, 1957, 2020, 2083, 2146, 2209, 2272, 2335, 2398, 2461, 2524, 2587, 2650,
         2713, 2776, 2839, 2902, 2965, 3028, 3091, 3154, 3217, 3280, 3343, 3406, 3469, 3532, 3595, 3658, 3721, 3784, 3847, 3910, 3973, 4036, 4037, 3974, 3911, 3848, 3785, 3722, 3659, 3596, 3533, 3470, 3407, 3344, 3281, 3218, 3155, 3092, 3029, 2966, 2903, 2840, 2777, 2714, 2651, 2588, 2525, 2462, 2399, 2336, 2273, 2210, 2147, 2084, 2021, 1958, 1895, 1832, 1769, 1706, 1643, 1580, 1517, 1454,
         1391, 1328, 1265, 1202, 1139, 1076, 1013,  950,  887,  824,  761,  698,  635,  572,  509,  446,  383,  447,  510,  573,  636,  699,  762,  825,  888,  951, 1014, 1077, 1140, 1203, 1266, 1329, 1392, 1455, 1518, 1581, 1644, 1707, 1770, 1833, 1896, 1959, 2022, 2085, 2148, 2211, 2274, 2337, 2400, 2463, 2526, 2589, 2652, 2715, 2778, 2841, 2904, 2967, 3030, 3093, 3156, 3219, 3282, 3345,
         3408, 3471, 3534, 3597, 3660, 3723, 3786, 3849, 3912, 3975, 4038, 4039, 3976, 3913, 3850, 3787, 3724, 3661, 3598, 3535, 3472, 3409, 3346, 3283, 3220, 3157, 3094, 3031, 2968, 2905, 2842, 2779, 2716, 2653, 2590, 2527, 2464, 2401, 2338, 2275, 2212, 2149, 2086, 2023, 1960, 1897, 1834, 1771, 1708, 1645, 1582, 1519, 1456, 1393, 1330, 1267, 1204, 1141, 1078, 1015,  952,  889,  826,  763,
          700,  637,  574,  511,  575,  638,  701,  764,  827,  890,  953, 1016, 1079, 1142, 1205, 1268, 1331, 1394, 1457, 1520, 1583, 1646, 1709, 1772, 1835, 1898, 1961, 2024, 2087, 2150, 2213, 2276, 2339, 2402, 2465, 2528, 2591, 2654, 2717, 2780, 2843, 2906, 2969, 3032, 3095, 3158, 3221, 3284, 3347, 3410, 3473, 3536, 3599, 3662, 3725, 3788, 3851, 3914, 3977, 4040, 4041, 3978, 3915, 3852,
         3789, 3726, 3663, 3600, 3537, 3474, 3411, 3348, 3285, 3222, 3159, 3096, 3033, 2970, 2907, 2844, 2781, 2718, 2655, 2592, 2529, 2466, 2403, 2340, 2277, 2214, 2151, 2088, 2025, 1962, 1899, 1836, 1773, 1710, 1647, 1584, 1521, 1458, 1395, 1332, 1269, 1206, 1143, 1080, 1017,  954,  891,  828,  765,  702,  639,  703,  766,  829,  892,  955, 1018, 1081, 1144, 1207, 1270, 1333, 1396, 1459,
         1522, 1585, 1648, 1711, 1774, 1837, 1900, 1963, 2026, 2089, 2152, 2215, 2278, 2341, 2404, 2467, 2530, 2593, 2656, 2719, 2782, 2845, 2908, 2971, 3034, 3097, 3160, 3223, 3286, 3349, 3412, 3475, 3538, 3601, 3664, 3727, 3790, 3853, 3916, 3979, 4042, 4043, 3980, 3917, 3854, 3791, 3728, 3665, 3602, 3539, 3476, 3413, 3350, 3287, 3224, 3161, 3098, 3035, 2972, 2909, 2846, 2783, 2720, 2657,
         2594, 2531, 2468, 2405, 2342, 2279, 2216, 2153, 2090, 2027, 1964, 1901, 1838, 1775, 1712, 1649, 1586, 1523, 1460, 1397, 1334, 1271, 1208, 1145, 1082, 1019,  956,  893,  830,  767,  831,  894,  957, 1020, 1083, 1146, 1209, 1272, 1335, 1398, 1461, 1524, 1587, 1650, 1713, 1776, 1839, 1902, 1965, 2028, 2091, 2154, 2217, 2280, 2343, 2406, 2469, 2532, 2595, 2658, 2721, 2784, 2847, 2910,
         2973, 3036, 3099, 3162, 3225, 3288, 3351, 3414, 3477, 3540, 3603, 3666, 3729, 3792, 3855, 3918, 3981, 4044, 4045, 3982, 3919, 3856, 3793, 3730, 3667, 3604, 3541, 3478, 3415, 3352, 3289, 3226, 3163, 3100, 3037, 2974, 2911, 2848, 2785, 2722, 2659, 2596, 2533, 2470, 2407, 2344, 2281, 2218, 2155, 2092, 2029, 1966, 1903, 1840, 1777, 1714, 1651, 1588, 1525, 1462, 1399, 1336, 1273, 1210,
         1147, 1084, 1021,  958,  895,  959, 1022, 1085, 1148, 1211, 1274, 1337, 1400, 1463, 1526, 1589, 1652, 1715, 1778, 1841, 1904, 1967, 2030, 2093, 2156, 2219, 2282, 2345, 2408, 2471, 2534, 2597, 2660, 2723, 2786, 2849, 2912, 2975, 3038, 3101, 3164, 3227, 3290, 3353, 3416, 3479, 3542, 3605, 3668, 3731, 3794, 3857, 3920, 3983, 4046, 4047, 3984, 3921, 3858, 3795, 3732, 3669, 3606, 3543,
         3480, 3417, 3354, 3291, 3228, 3165, 3102, 3039, 2976, 2913, 2850, 2787, 2724, 2661, 2598, 2535, 2472, 2409, 2346, 2283, 2220, 2157, 2094, 2031, 1968, 1905, 1842, 1779, 1716, 1653, 1590, 1527, 1464, 1401, 1338, 1275, 1212, 1149, 1086, 1023, 1087, 1150, 1213, 1276, 1339, 1402, 1465, 1528, 1591, 1654, 1717, 1780, 1843, 1906, 1969, 2032, 2095, 2158, 2221, 2284, 2347, 2410, 2473, 2536,
         2599, 2662, 2725, 2788, 2851, 2914, 2977, 3040, 3103, 3166, 3229, 3292, 3355, 3418, 3481, 3544, 3607, 3670, 3733, 3796, 3859, 3922, 3985, 4048, 4049, 3986, 3923, 3860, 3797, 3734, 3671, 3608, 3545, 3482, 3419, 3356, 3293, 3230, 3167, 3104, 3041, 2978, 2915, 2852, 2789, 2726, 2663, 2600, 2537, 2474, 2411, 2348, 2285, 2222, 2159, 2096, 2033, 1970, 1907, 1844, 1781, 1718, 1655, 1592,
         1529, 1466, 1403, 1340, 1277, 1214, 1151, 1215, 1278, 1341, 1404, 1467, 1530, 1593, 1656, 1719, 1782, 1845, 1908, 1971, 2034, 2097, 2160, 2223, 2286, 2349, 2412, 2475, 2538, 2601, 2664, 2727, 2790, 2853, 2916, 2979, 3042, 3105, 3168, 3231, 3294, 3357, 3420, 3483, 3546, 3609, 3672, 3735, 3798, 3861, 3924, 3987, 4050, 4051, 3988, 3925, 3862, 3799, 3736, 3673, 3610, 3547, 3484, 3421,
         3358, 3295, 3232, 3169, 3106, 3043, 2980, 2917, 2854, 2791, 2728, 2665, 2602, 2539, 2476, 2413, 2350, 2287, 2224, 2161, 2098, 2035, 1972, 1909, 1846, 1783, 1720, 1657, 1594, 1531, 1468, 1405, 1342, 1279, 1343, 1406, 1469, 1532, 1595, 1658, 1721, 1784, 1847, 1910, 1973, 2036, 2099, 2162, 2225, 2288, 2351, 2414, 2477, 2540, 2603, 2666, 2729, 2792, 2855, 2918, 2981, 3044, 3107, 3170,
         3233, 3296, 3359, 3422, 3485, 3548, 3611, 3674, 3737, 3800, 3863, 3926, 3989, 4052, 4053, 3990, 3927, 3864, 3801, 3738, 3675, 3612, 3549, 3486, 3423, 3360, 3297, 3234, 3171, 3108, 3045, 2982, 2919, 2856, 2793, 2730, 2667, 2604, 2541, 2478, 2415, 2352, 2289, 2226, 2163, 2100, 2037, 1974, 1911, 1848, 1785, 1722, 1659, 1596, 1533, 1470, 1407, 1471, 1534, 1597, 1660, 1723, 1786, 1849,
         1912, 1975, 2038, 2101, 2164, 2227, 2290, 2353, 2416, 2479, 2542, 2605, 2668, 2731, 2794, 2857, 2920, 2983, 3046, 3109, 3172, 3235, 3298, 3361, 3424, 3487, 3550, 3613, 3676, 3739, 3802, 3865, 3928, 3991, 4054, 4055, 3992, 3929, 3866, 3803, 3740, 3677, 3614, 3551, 3488, 3425, 3362, 3299, 3236, 3173, 3110, 3047, 2984, 2921, 2858, 2795, 2732, 2669, 2606, 2543, 2480, 2417, 2354, 2291,
         2228, 2165, 2102, 2039, 1976, 1913, 1850, 1787, 1724, 1661, 1598, 1535, 1599, 1662, 1725, 1788, 1851, 1914, 1977, 2040, 2103, 2166, 2229, 2292, 2355, 2418, 2481, 2544, 2607, 2670, 2733, 2796, 2859, 2922, 2985, 3048, 3111, 3174, 3237, 3300, 3363, 3426, 3489, 3552, 3615, 3678, 3741, 3804, 3867, 3930, 3993, 4056, 4057, 3994, 3931, 3868, 3805, 3742, 3679, 3616, 3553, 3490, 3427, 3364,
         3301, 3238, 3175, 3112, 3049, 2986, 2923, 2860, 2797, 2734, 2671, 2608, 2545, 2482, 2419, 2356, 2293, 2230, 2167, 2104, 2041, 1978, 1915, 1852, 1789, 1726, 1663, 1727, 1790, 1853, 1916, 1979, 2042, 2105, 2168, 2231, 2294, 2357, 2420, 2483, 2546, 2609, 2672, 2735, 2798, 2861, 2924, 2987, 3050, 3113, 3176, 3239, 3302, 3365, 3428, 3491, 3554, 3617, 3680, 3743, 3806, 3869, 3932, 3995,
         4058, 4059, 3996, 3933, 3870, 3807, 3744, 3681, 3618, 3555, 3492, 3429, 3366, 3303, 3240, 3177, 3114, 3051, 2988, 2925, 2862, 2799, 2736, 2673, 2610, 2547, 2484, 2421, 2358, 2295, 2232, 2169, 2106, 2043, 1980, 1917, 1854, 1791, 1855, 1918, 1981, 2044, 2107, 2170, 2233, 2296, 2359, 2422, 2485, 2548, 2611, 2674, 2737, 2800, 2863, 2926, 2989, 3052, 3115, 3178, 3241, 3304, 3367, 3430,
         3493, 3556, 3619, 3682, 3745, 3808, 3871, 3934, 3997, 4060, 4061, 3998, 3935, 3872, 3809, 3746, 3683, 3620, 3557, 3494, 3431, 3368, 3305, 3242, 3179, 3116, 3053, 2990, 2927, 2864, 2801, 2738, 2675, 2612, 2549, 2486, 2423, 2360, 2297, 2234, 2171, 2108, 2045, 1982, 1919, 1983, 2046, 2109, 2172, 2235, 2298, 2361, 2424, 2487, 2550, 2613, 2676, 2739, 2802, 2865, 2928, 2991, 3054, 3117,
         3180, 3243, 3306, 3369, 3432, 3495, 3558, 3621, 3684, 3747, 3810, 3873, 3936, 3999, 4062, 4063, 4000, 3937, 3874, 3811, 3748, 3685, 3622, 3559, 3496, 3433, 3370, 3307, 3244, 3181, 3118, 3055, 2992, 2929, 2866, 2803, 2740, 2677, 2614, 2551, 2488, 2425, 2362, 2299, 2236, 2173, 2110, 2047, 2111, 2174, 2237, 2300, 2363, 2426, 2489, 2552, 2615, 2678, 2741, 2804, 2867, 2930, 2993, 3056,
         3119, 3182, 3245, 3308, 3371, 3434, 3497, 3560, 3623, 3686, 3749, 3812, 3875, 3938, 4001, 4064, 4065, 4002, 3939, 3876, 3813, 3750, 3687, 3624, 3561, 3498, 3435, 3372, 3309, 3246, 3183, 3120, 3057, 2994, 2931, 2868, 2805, 2742, 2679, 2616, 2553, 2490, 2427, 2364, 2301, 2238, 2175, 2239, 2302, 2365, 2428, 2491, 2554, 2617, 2680, 2743, 2806, 2869, 2932, 2995, 3058, 3121, 3184, 3247,
         3310, 3373, 3436, 3499, 3562, 3625, 3688, 3751, 3814, 3877, 3940, 4003, 4066, 4067, 4004, 3941, 3878, 3815, 3752, 3689, 3626, 3563, 3500, 3437, 3374, 3311, 3248, 3185, 3122, 3059, 2996, 2933, 2870, 2807, 2744, 2681, 2618, 2555, 2492, 2429, 2366, 2303, 2367, 2430, 2493, 2556, 2619, 2682, 2745, 2808, 2871, 2934, 2997, 3060, 3123, 3186, 3249, 3312, 3375, 3438, 3501, 3564, 3627, 3690,
         3753, 3816, 3879, 3942, 4005, 4068, 4069, 4006, 3943, 3880, 3817, 3754, 3691, 3628, 3565, 3502, 3439, 3376, 3313, 3250, 3187, 3124, 3061, 2998, 2935, 2872, 2809, 2746, 2683, 2620, 2557, 2494, 2431, 2495, 2558, 2621, 2684, 2747, 2810, 2873, 2936, 2999, 3062, 3125, 3188, 3251, 3314, 3377, 3440, 3503, 3566, 3629, 3692, 3755, 3818, 3881, 3944, 4007, 4070, 4071, 4008, 3945, 3882, 3819,
         3756, 3693, 3630, 3567, 3504, 3441, 3378, 3315, 3252, 3189, 3126, 3063, 3000, 2937, 2874, 2811, 2748, 2685, 2622, 2559, 2623, 2686, 2749, 2812, 2875, 2938, 3001, 3064, 3127, 3190, 3253, 3316, 3379, 3442, 3505, 3568, 3631, 3694, 3757, 3820, 3883, 3946, 4009, 4072, 4073, 4010, 3947, 3884, 3821, 3758, 3695, 3632, 3569, 3506, 3443, 3380, 3317, 3254, 3191, 3128, 3065, 3002, 2939, 2876,
         2813, 2750, 2687, 2751, 2814, 2877, 2940, 3003, 3066, 3129, 3192, 3255, 3318, 3381, 3444, 3507, 3570, 3633, 3696, 3759, 3822, 3885, 3948, 4011, 4074, 4075, 4012, 3949, 3886, 3823, 3760, 3697, 3634, 3571, 3508, 3445, 3382, 3319, 3256, 3193, 3130, 3067, 3004, 2941, 2878, 2815, 2879, 2942, 3005, 3068, 3131, 3194, 3257, 3320, 3383, 3446, 3509, 3572, 3635, 3698, 3761, 3824, 3887, 3950,
         4013, 4076, 4077, 4014, 3951, 3888, 3825, 3762, 3699, 3636, 3573, 3510, 3447, 3384, 3321, 3258, 3195, 3132, 3069, 3006, 2943, 3007, 3070, 3133, 3196, 3259, 3322, 3385, 3448, 3511, 3574, 3637, 3700, 3763, 3826, 3889, 3952, 4015, 4078, 4079, 4016, 3953, 3890, 3827, 3764, 3701, 3638, 3575, 3512, 3449, 3386, 3323, 3260, 3197, 3134, 3071, 3135, 3198, 3261, 3324, 3387, 3450, 3513, 3576,
         3639, 3702, 3765, 3828, 3891, 3954, 4017, 4080, 4081, 4018, 3955, 3892, 3829, 3766, 3703, 3640, 3577, 3514, 3451, 3388, 3325, 3262, 3199, 3263, 3326, 3389, 3452, 3515, 3578, 3641, 3704, 3767, 3830, 3893, 3956, 4019, 4082, 4083, 4020, 3957, 3894, 3831, 3768, 3705, 3642, 3579, 3516, 3453, 3390, 3327, 3391, 3454, 3517, 3580, 3643, 3706, 3769, 3832, 3895, 3958, 4021, 4084, 4085, 4022,
         3959, 3896, 3833, 3770, 3707, 3644, 3581, 3518, 3455, 3519, 3582, 3645, 3708, 3771, 3834, 3897, 3960, 4023, 4086, 4087, 4024, 3961, 3898, 3835, 3772, 3709, 3646, 3583, 3647, 3710, 3773, 3836, 3899, 3962, 4025, 4088, 4089, 4026, 3963, 3900, 3837, 3774, 3711, 3775, 3838, 3901, 3964, 4027, 4090, 4091, 4028, 3965, 3902, 3839, 3903, 3966, 4029, 4092, 4093, 4030, 3967, 4031, 4094, 4095,
        },
    },
};
