/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.7.9
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/menuitem.h>
        #include <wx/menu.h>
        #include <wx/accel.h>
        #include <wx/colour.h>
        #include <wx/font.h>
        #include <wx/bmpbndl.h>
        #include <wx/bitmap.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>
    wxColour* _wxMenuItem_GetBackgroundColour(const wxMenuItem* self)
    {
        #ifdef __WXMSW__
            return new wxColor(self->GetBackgroundColour());
        #else
            return new wxColour;
        #endif
    }
    wxBitmap* _wxMenuItem_GetBitmap(const wxMenuItem* self, bool checked)
    {
        #ifdef __WXMSW__
            return new wxBitmap(self->GetBitmap(checked));
        #else
            return new wxBitmap(self->GetBitmap()); // no checked arg in this case
        #endif
    }
    wxBitmap* _wxMenuItem_GetDisabledBitmap(const wxMenuItem* self)
    {
        #ifdef __WXMSW__
            return new wxBitmap(self->GetDisabledBitmap());
        #else
            return new wxBitmap;
        #endif
    }
    wxFont* _wxMenuItem_GetFont(const wxMenuItem* self)
    {
        #ifdef __WXMSW__
            return new wxFont(self->GetFont());
        #else
            return new wxFont;
        #endif
    }
    int _wxMenuItem_GetMarginWidth(const wxMenuItem* self)
    {
        #ifdef __WXMSW__
            return self->GetMarginWidth();
        #else
            return -1;
        #endif
    }
    wxColour* _wxMenuItem_GetTextColour(const wxMenuItem* self)
    {
        #ifdef __WXMSW__
            return new wxColour(self->GetTextColour());
        #else
            return new wxColour;
        #endif
    }
    void _wxMenuItem_SetBackgroundColour(wxMenuItem* self, const wxColour *colour)
    {
        #ifdef __WXMSW__
            self->SetBackgroundColour(*colour);
        #endif
    }
    void _wxMenuItem_SetBitmap(wxMenuItem* self, const wxBitmapBundle *bmp, bool checked)
    {
        #ifdef __WXMSW__
            self->SetBitmap(*bmp, checked);
        #else
            self->SetBitmap(*bmp); // no checked arg in this case
        #endif
    }
    void _wxMenuItem_SetBitmaps(wxMenuItem* self, const wxBitmapBundle *checked, const wxBitmapBundle *unchecked)
    {
        #ifdef __WXMSW__
            self->SetBitmaps(*checked, *unchecked);
        #else
            self->SetBitmap(*checked);
        #endif
    }
    void _wxMenuItem_SetDisabledBitmap(wxMenuItem* self, const wxBitmapBundle *disabled)
    {
        #ifdef __WXMSW__
            self->SetDisabledBitmap(*disabled);
        #endif
    }
    void _wxMenuItem_SetFont(wxMenuItem* self, const wxFont *font)
    {
        #ifdef __WXMSW__
            self->SetFont(*font);
        #endif
    }
    void _wxMenuItem_SetMarginWidth(wxMenuItem* self, int width)
    {
        #ifdef __WXMSW__
            self->SetMarginWidth(width);
        #endif
    }
    void _wxMenuItem_SetTextColour(wxMenuItem* self, const wxColour *colour)
    {
        #ifdef __WXMSW__
            self->SetTextColour(*colour);
        #endif
    }


PyDoc_STRVAR(doc_wxMenuItem_GetBackgroundColour, "GetBackgroundColour() -> Colour\n"
"\n"
"Returns the background colour associated with the menu item.");

extern "C" {static PyObject *meth_wxMenuItem_GetBackgroundColour(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetBackgroundColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
             ::wxColour*sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxMenuItem_GetBackgroundColour(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxColour,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetBackgroundColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_GetBitmap, "GetBitmap() -> Bitmap\n"
"GetBitmap(checked) -> Bitmap\n"
"\n"
"Returns the item bitmap.\n"
"");

extern "C" {static PyObject *meth_wxMenuItem_GetBitmap(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetBitmap(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
             ::wxBitmap*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxBitmap(sipCpp->GetBitmap());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxBitmap,SIP_NULLPTR);
        }
    }

    {
        bool checked;
        const  ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_checked,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxMenuItem, &sipCpp, &checked))
        {
             ::wxBitmap*sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxMenuItem_GetBitmap(sipCpp, checked);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxBitmap,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetBitmap, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_GetBitmapBundle, "GetBitmapBundle() -> BitmapBundle\n"
"\n"
"Returns the bitmap bundle containing the bitmap used for this item.");

extern "C" {static PyObject *meth_wxMenuItem_GetBitmapBundle(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetBitmapBundle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
             ::wxBitmapBundle*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxBitmapBundle(sipCpp->GetBitmapBundle());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxBitmapBundle,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetBitmapBundle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_GetDisabledBitmap, "GetDisabledBitmap() -> Bitmap\n"
"\n"
"Returns the bitmap used for disabled items.");

extern "C" {static PyObject *meth_wxMenuItem_GetDisabledBitmap(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetDisabledBitmap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
             ::wxBitmap*sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxMenuItem_GetDisabledBitmap(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxBitmap,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetDisabledBitmap, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_GetFont, "GetFont() -> Font\n"
"\n"
"Returns the font associated with the menu item.");

extern "C" {static PyObject *meth_wxMenuItem_GetFont(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetFont(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
             ::wxFont*sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxMenuItem_GetFont(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxFont,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetFont, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_GetHelp, "GetHelp() -> String\n"
"\n"
"Returns the help string associated with the menu item.");

extern "C" {static PyObject *meth_wxMenuItem_GetHelp(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetHelp(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetHelp());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetHelp, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_GetId, "GetId() -> int\n"
"\n"
"Returns the menu item identifier.");

extern "C" {static PyObject *meth_wxMenuItem_GetId(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetId(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetId();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetId, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_GetItemLabel, "GetItemLabel() -> String\n"
"\n"
"Returns the text associated with the menu item including any\n"
"accelerator characters that were passed to the constructor or\n"
"SetItemLabel().");

extern "C" {static PyObject *meth_wxMenuItem_GetItemLabel(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetItemLabel(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetItemLabel());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetItemLabel, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_GetItemLabelText, "GetItemLabelText() -> String\n"
"\n"
"Returns the text associated with the menu item, without any\n"
"accelerator characters.");

extern "C" {static PyObject *meth_wxMenuItem_GetItemLabelText(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetItemLabelText(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetItemLabelText());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetItemLabelText, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_GetKind, "GetKind() -> ItemKind\n"
"\n"
"Returns the item kind, one of wxITEM_SEPARATOR, wxITEM_NORMAL,\n"
"wxITEM_CHECK or wxITEM_RADIO.");

extern "C" {static PyObject *meth_wxMenuItem_GetKind(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetKind(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
             ::wxItemKind sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetKind();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxItemKind);
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetKind, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_GetMarginWidth, "GetMarginWidth() -> int\n"
"\n"
"Gets the width of the menu item checkmark bitmap.");

extern "C" {static PyObject *meth_wxMenuItem_GetMarginWidth(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetMarginWidth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
            int sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxMenuItem_GetMarginWidth(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetMarginWidth, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_GetMenu, "GetMenu() -> Menu\n"
"\n"
"Returns the menu this menu item is in, or NULL if this menu item is\n"
"not attached.");

extern "C" {static PyObject *meth_wxMenuItem_GetMenu(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetMenu(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
             ::wxMenu*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetMenu();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxMenu,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetMenu, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_GetSubMenu, "GetSubMenu() -> Menu\n"
"\n"
"Returns the submenu associated with the menu item, or NULL if there\n"
"isn't one.");

extern "C" {static PyObject *meth_wxMenuItem_GetSubMenu(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetSubMenu(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
             ::wxMenu*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetSubMenu();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxMenu,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetSubMenu, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_GetTextColour, "GetTextColour() -> Colour\n"
"\n"
"Returns the text colour associated with the menu item.");

extern "C" {static PyObject *meth_wxMenuItem_GetTextColour(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetTextColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
             ::wxColour*sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxMenuItem_GetTextColour(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxColour,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetTextColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_GetAccel, "GetAccel() -> AcceleratorEntry\n"
"\n"
"Get our accelerator or NULL (caller must delete the pointer)");

extern "C" {static PyObject *meth_wxMenuItem_GetAccel(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetAccel(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
             ::wxAcceleratorEntry*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetAccel();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxAcceleratorEntry,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetAccel, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_IsCheck, "IsCheck() -> bool\n"
"\n"
"Returns true if the item is a check item.");

extern "C" {static PyObject *meth_wxMenuItem_IsCheck(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_IsCheck(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsCheck();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_IsCheck, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_IsCheckable, "IsCheckable() -> bool\n"
"\n"
"Returns true if the item is checkable.");

extern "C" {static PyObject *meth_wxMenuItem_IsCheckable(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_IsCheckable(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsCheckable();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_IsCheckable, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_IsChecked, "IsChecked() -> bool\n"
"\n"
"Returns true if the item is checked.");

extern "C" {static PyObject *meth_wxMenuItem_IsChecked(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_IsChecked(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsChecked();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_IsChecked, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_IsEnabled, "IsEnabled() -> bool\n"
"\n"
"Returns true if the item is enabled.");

extern "C" {static PyObject *meth_wxMenuItem_IsEnabled(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_IsEnabled(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsEnabled();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_IsEnabled, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_IsRadio, "IsRadio() -> bool\n"
"\n"
"Returns true if the item is a radio button.");

extern "C" {static PyObject *meth_wxMenuItem_IsRadio(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_IsRadio(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsRadio();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_IsRadio, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_IsSeparator, "IsSeparator() -> bool\n"
"\n"
"Returns true if the item is a separator.");

extern "C" {static PyObject *meth_wxMenuItem_IsSeparator(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_IsSeparator(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsSeparator();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_IsSeparator, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_IsSubMenu, "IsSubMenu() -> bool\n"
"\n"
"Returns true if the item is a submenu.");

extern "C" {static PyObject *meth_wxMenuItem_IsSubMenu(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_IsSubMenu(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsSubMenu();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_IsSubMenu, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_SetBackgroundColour, "SetBackgroundColour(colour)\n"
"\n"
"Sets the background colour associated with the menu item.");

extern "C" {static PyObject *meth_wxMenuItem_SetBackgroundColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_SetBackgroundColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxColour* colour;
        int colourState = 0;
         ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxMenuItem, &sipCpp, sipType_wxColour, &colour, &colourState))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxMenuItem_SetBackgroundColour(sipCpp, colour);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxColour *>(colour), sipType_wxColour, colourState);

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_SetBackgroundColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_SetBitmap, "SetBitmap(bmp)\n"
"SetBitmap(bmp, checked)\n"
"\n"
"Sets the bitmap for the menu item.\n"
"");

extern "C" {static PyObject *meth_wxMenuItem_SetBitmap(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_SetBitmap(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxBitmapBundle* bmp;
        int bmpState = 0;
         ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bmp,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxMenuItem, &sipCpp, sipType_wxBitmapBundle, &bmp, &bmpState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBitmap(*bmp);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxBitmapBundle *>(bmp), sipType_wxBitmapBundle, bmpState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxBitmapBundle* bmp;
        int bmpState = 0;
        bool checked;
         ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bmp,
            sipName_checked,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1b", &sipSelf, sipType_wxMenuItem, &sipCpp, sipType_wxBitmapBundle, &bmp, &bmpState, &checked))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxMenuItem_SetBitmap(sipCpp, bmp, checked);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxBitmapBundle *>(bmp), sipType_wxBitmapBundle, bmpState);

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_SetBitmap, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_SetBitmaps, "SetBitmaps(checked, unchecked=NullBitmap)\n"
"\n"
"Sets the checked/unchecked bitmaps for the menu item.");

extern "C" {static PyObject *meth_wxMenuItem_SetBitmaps(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_SetBitmaps(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxBitmapBundle* checked;
        int checkedState = 0;
        const  ::wxBitmapBundle& uncheckeddef = wxNullBitmap;
        const  ::wxBitmapBundle* unchecked = &uncheckeddef;
        int uncheckedState = 0;
         ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_checked,
            sipName_unchecked,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|J1", &sipSelf, sipType_wxMenuItem, &sipCpp, sipType_wxBitmapBundle, &checked, &checkedState, sipType_wxBitmapBundle, &unchecked, &uncheckedState))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxMenuItem_SetBitmaps(sipCpp, checked, unchecked);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxBitmapBundle *>(checked), sipType_wxBitmapBundle, checkedState);
            sipReleaseType(const_cast< ::wxBitmapBundle *>(unchecked), sipType_wxBitmapBundle, uncheckedState);

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_SetBitmaps, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_SetDisabledBitmap, "SetDisabledBitmap(disabled)\n"
"\n"
"Sets the to be used for disabled menu items.");

extern "C" {static PyObject *meth_wxMenuItem_SetDisabledBitmap(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_SetDisabledBitmap(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxBitmapBundle* disabled;
        int disabledState = 0;
         ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_disabled,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxMenuItem, &sipCpp, sipType_wxBitmapBundle, &disabled, &disabledState))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxMenuItem_SetDisabledBitmap(sipCpp, disabled);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxBitmapBundle *>(disabled), sipType_wxBitmapBundle, disabledState);

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_SetDisabledBitmap, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_SetFont, "SetFont(font)\n"
"\n"
"Sets the font associated with the menu item.");

extern "C" {static PyObject *meth_wxMenuItem_SetFont(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_SetFont(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxFont* font;
         ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_font,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxMenuItem, &sipCpp, sipType_wxFont, &font))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxMenuItem_SetFont(sipCpp, font);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_SetFont, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_SetHelp, "SetHelp(helpString)\n"
"\n"
"Sets the help string.");

extern "C" {static PyObject *meth_wxMenuItem_SetHelp(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_SetHelp(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* helpString;
        int helpStringState = 0;
         ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_helpString,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxMenuItem, &sipCpp, sipType_wxString, &helpString, &helpStringState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetHelp(*helpString);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(helpString), sipType_wxString, helpStringState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_SetHelp, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_SetItemLabel, "SetItemLabel(label)\n"
"\n"
"Sets the label associated with the menu item.");

extern "C" {static PyObject *meth_wxMenuItem_SetItemLabel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_SetItemLabel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* label;
        int labelState = 0;
         ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_label,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxMenuItem, &sipCpp, sipType_wxString, &label, &labelState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetItemLabel(*label);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(label), sipType_wxString, labelState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_SetItemLabel, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_SetMarginWidth, "SetMarginWidth(width)\n"
"\n"
"Sets the width of the menu item checkmark bitmap.");

extern "C" {static PyObject *meth_wxMenuItem_SetMarginWidth(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_SetMarginWidth(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int width;
         ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_width,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxMenuItem, &sipCpp, &width))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxMenuItem_SetMarginWidth(sipCpp, width);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_SetMarginWidth, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_SetMenu, "SetMenu(menu)\n"
"\n"
"Sets the parent menu which will contain this menu item.");

extern "C" {static PyObject *meth_wxMenuItem_SetMenu(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_SetMenu(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxMenu* menu;
         ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_menu,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxMenuItem, &sipCpp, sipType_wxMenu, &menu))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetMenu(menu);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_SetMenu, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_SetSubMenu, "SetSubMenu(menu)\n"
"\n"
"Sets the submenu of this menu item.");

extern "C" {static PyObject *meth_wxMenuItem_SetSubMenu(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_SetSubMenu(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxMenu* menu;
         ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_menu,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ:", &sipSelf, sipType_wxMenuItem, &sipCpp, sipType_wxMenu, &menu))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetSubMenu(menu);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_SetSubMenu, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_SetTextColour, "SetTextColour(colour)\n"
"\n"
"Sets the text colour associated with the menu item.");

extern "C" {static PyObject *meth_wxMenuItem_SetTextColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_SetTextColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxColour* colour;
        int colourState = 0;
         ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxMenuItem, &sipCpp, sipType_wxColour, &colour, &colourState))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxMenuItem_SetTextColour(sipCpp, colour);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxColour *>(colour), sipType_wxColour, colourState);

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_SetTextColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_SetAccel, "SetAccel(accel)\n"
"\n"
"Set the accel for this item - this may also be done indirectly with\n"
"SetText()");

extern "C" {static PyObject *meth_wxMenuItem_SetAccel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_SetAccel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxAcceleratorEntry* accel;
         ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_accel,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxMenuItem, &sipCpp, sipType_wxAcceleratorEntry, &accel))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetAccel(accel);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_SetAccel, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_AddExtraAccel, "AddExtraAccel(accel)\n"
"\n"
"Add an extra accelerator for this menu item.");

extern "C" {static PyObject *meth_wxMenuItem_AddExtraAccel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_AddExtraAccel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxAcceleratorEntry* accel;
         ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_accel,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxMenuItem, &sipCpp, sipType_wxAcceleratorEntry, &accel))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddExtraAccel(*accel);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_AddExtraAccel, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_ClearExtraAccels, "ClearExtraAccels()\n"
"\n"
"Clear the extra accelerators list.");

extern "C" {static PyObject *meth_wxMenuItem_ClearExtraAccels(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_ClearExtraAccels(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->ClearExtraAccels();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_ClearExtraAccels, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_Check, "Check(check=True)\n"
"\n"
"Checks or unchecks the menu item.");

extern "C" {static PyObject *meth_wxMenuItem_Check(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_Check(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool check = 1;
         ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_check,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxMenuItem, &sipCpp, &check))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Check(check);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_Check, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_Enable, "Enable(enable=True)\n"
"\n"
"Enables or disables the menu item.");

extern "C" {static PyObject *meth_wxMenuItem_Enable(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_Enable(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool enable = 1;
         ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_enable,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxMenuItem, &sipCpp, &enable))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Enable(enable);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_Enable, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxMenuItem_GetLabelText, "GetLabelText(text) -> String\n"
"\n"
"Strips all accelerator characters and mnemonics from the given text.");

extern "C" {static PyObject *meth_wxMenuItem_GetLabelText(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetLabelText(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* text;
        int textState = 0;

        static const char *sipKwdList[] = {
            sipName_text,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1", sipType_wxString, &text, &textState))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString( ::wxMenuItem::GetLabelText(*text));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text), sipType_wxString, textState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetLabelText, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxMenuItem(void *, const sipTypeDef *);}
static void *cast_wxMenuItem(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxMenuItem *sipCpp = reinterpret_cast< ::wxMenuItem *>(sipCppV);

    if (targetType == sipType_wxMenuItem)
        return sipCppV;

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxMenuItem(void *, int);}
static void release_wxMenuItem(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxMenuItem *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxMenuItem(Py_ssize_t);}
static void *array_wxMenuItem(Py_ssize_t sipNrElem)
{
    return new  ::wxMenuItem[sipNrElem];
}


extern "C" {static void dealloc_wxMenuItem(sipSimpleWrapper *);}
static void dealloc_wxMenuItem(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxMenuItem(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxMenuItem(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxMenuItem(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxMenuItem *sipCpp = SIP_NULLPTR;

    {
         ::wxMenu* parentMenu = 0;
        int id = wxID_SEPARATOR;
        const  ::wxString& textdef = wxEmptyString;
        const  ::wxString* text = &textdef;
        int textState = 0;
        const  ::wxString& helpStringdef = wxEmptyString;
        const  ::wxString* helpString = &helpStringdef;
        int helpStringState = 0;
         ::wxItemKind kind = wxITEM_NORMAL;
         ::wxMenu* subMenu = 0;

        static const char *sipKwdList[] = {
            sipName_parentMenu,
            sipName_id,
            sipName_text,
            sipName_helpString,
            sipName_kind,
            sipName_subMenu,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "#|J8iJ1J1EJ:", sipSelf, sipType_wxMenu, &parentMenu, &id, sipType_wxString, &text, &textState, sipType_wxString, &helpString, &helpStringState, sipType_wxItemKind, &kind, sipType_wxMenu, &subMenu))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxMenuItem(parentMenu,id,*text,*helpString,kind,subMenu);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text), sipType_wxString, textState);
            sipReleaseType(const_cast< ::wxString *>(helpString), sipType_wxString, helpStringState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxMenuItem[] = {{392, 255, 1}};


static PyMethodDef methods_wxMenuItem[] = {
    {sipName_AddExtraAccel, SIP_MLMETH_CAST(meth_wxMenuItem_AddExtraAccel), METH_VARARGS|METH_KEYWORDS, doc_wxMenuItem_AddExtraAccel},
    {sipName_Check, SIP_MLMETH_CAST(meth_wxMenuItem_Check), METH_VARARGS|METH_KEYWORDS, doc_wxMenuItem_Check},
    {sipName_ClearExtraAccels, meth_wxMenuItem_ClearExtraAccels, METH_VARARGS, doc_wxMenuItem_ClearExtraAccels},
    {sipName_Enable, SIP_MLMETH_CAST(meth_wxMenuItem_Enable), METH_VARARGS|METH_KEYWORDS, doc_wxMenuItem_Enable},
    {sipName_GetAccel, meth_wxMenuItem_GetAccel, METH_VARARGS, doc_wxMenuItem_GetAccel},
    {sipName_GetBackgroundColour, meth_wxMenuItem_GetBackgroundColour, METH_VARARGS, doc_wxMenuItem_GetBackgroundColour},
    {sipName_GetBitmap, SIP_MLMETH_CAST(meth_wxMenuItem_GetBitmap), METH_VARARGS|METH_KEYWORDS, doc_wxMenuItem_GetBitmap},
    {sipName_GetBitmapBundle, meth_wxMenuItem_GetBitmapBundle, METH_VARARGS, doc_wxMenuItem_GetBitmapBundle},
    {sipName_GetDisabledBitmap, meth_wxMenuItem_GetDisabledBitmap, METH_VARARGS, doc_wxMenuItem_GetDisabledBitmap},
    {sipName_GetFont, meth_wxMenuItem_GetFont, METH_VARARGS, doc_wxMenuItem_GetFont},
    {sipName_GetHelp, meth_wxMenuItem_GetHelp, METH_VARARGS, doc_wxMenuItem_GetHelp},
    {sipName_GetId, meth_wxMenuItem_GetId, METH_VARARGS, doc_wxMenuItem_GetId},
    {sipName_GetItemLabel, meth_wxMenuItem_GetItemLabel, METH_VARARGS, doc_wxMenuItem_GetItemLabel},
    {sipName_GetItemLabelText, meth_wxMenuItem_GetItemLabelText, METH_VARARGS, doc_wxMenuItem_GetItemLabelText},
    {sipName_GetKind, meth_wxMenuItem_GetKind, METH_VARARGS, doc_wxMenuItem_GetKind},
    {sipName_GetLabelText, SIP_MLMETH_CAST(meth_wxMenuItem_GetLabelText), METH_VARARGS|METH_KEYWORDS, doc_wxMenuItem_GetLabelText},
    {sipName_GetMarginWidth, meth_wxMenuItem_GetMarginWidth, METH_VARARGS, doc_wxMenuItem_GetMarginWidth},
    {sipName_GetMenu, meth_wxMenuItem_GetMenu, METH_VARARGS, doc_wxMenuItem_GetMenu},
    {sipName_GetSubMenu, meth_wxMenuItem_GetSubMenu, METH_VARARGS, doc_wxMenuItem_GetSubMenu},
    {sipName_GetTextColour, meth_wxMenuItem_GetTextColour, METH_VARARGS, doc_wxMenuItem_GetTextColour},
    {sipName_IsCheck, meth_wxMenuItem_IsCheck, METH_VARARGS, doc_wxMenuItem_IsCheck},
    {sipName_IsCheckable, meth_wxMenuItem_IsCheckable, METH_VARARGS, doc_wxMenuItem_IsCheckable},
    {sipName_IsChecked, meth_wxMenuItem_IsChecked, METH_VARARGS, doc_wxMenuItem_IsChecked},
    {sipName_IsEnabled, meth_wxMenuItem_IsEnabled, METH_VARARGS, doc_wxMenuItem_IsEnabled},
    {sipName_IsRadio, meth_wxMenuItem_IsRadio, METH_VARARGS, doc_wxMenuItem_IsRadio},
    {sipName_IsSeparator, meth_wxMenuItem_IsSeparator, METH_VARARGS, doc_wxMenuItem_IsSeparator},
    {sipName_IsSubMenu, meth_wxMenuItem_IsSubMenu, METH_VARARGS, doc_wxMenuItem_IsSubMenu},
    {sipName_SetAccel, SIP_MLMETH_CAST(meth_wxMenuItem_SetAccel), METH_VARARGS|METH_KEYWORDS, doc_wxMenuItem_SetAccel},
    {sipName_SetBackgroundColour, SIP_MLMETH_CAST(meth_wxMenuItem_SetBackgroundColour), METH_VARARGS|METH_KEYWORDS, doc_wxMenuItem_SetBackgroundColour},
    {sipName_SetBitmap, SIP_MLMETH_CAST(meth_wxMenuItem_SetBitmap), METH_VARARGS|METH_KEYWORDS, doc_wxMenuItem_SetBitmap},
    {sipName_SetBitmaps, SIP_MLMETH_CAST(meth_wxMenuItem_SetBitmaps), METH_VARARGS|METH_KEYWORDS, doc_wxMenuItem_SetBitmaps},
    {sipName_SetDisabledBitmap, SIP_MLMETH_CAST(meth_wxMenuItem_SetDisabledBitmap), METH_VARARGS|METH_KEYWORDS, doc_wxMenuItem_SetDisabledBitmap},
    {sipName_SetFont, SIP_MLMETH_CAST(meth_wxMenuItem_SetFont), METH_VARARGS|METH_KEYWORDS, doc_wxMenuItem_SetFont},
    {sipName_SetHelp, SIP_MLMETH_CAST(meth_wxMenuItem_SetHelp), METH_VARARGS|METH_KEYWORDS, doc_wxMenuItem_SetHelp},
    {sipName_SetItemLabel, SIP_MLMETH_CAST(meth_wxMenuItem_SetItemLabel), METH_VARARGS|METH_KEYWORDS, doc_wxMenuItem_SetItemLabel},
    {sipName_SetMarginWidth, SIP_MLMETH_CAST(meth_wxMenuItem_SetMarginWidth), METH_VARARGS|METH_KEYWORDS, doc_wxMenuItem_SetMarginWidth},
    {sipName_SetMenu, SIP_MLMETH_CAST(meth_wxMenuItem_SetMenu), METH_VARARGS|METH_KEYWORDS, doc_wxMenuItem_SetMenu},
    {sipName_SetSubMenu, SIP_MLMETH_CAST(meth_wxMenuItem_SetSubMenu), METH_VARARGS|METH_KEYWORDS, doc_wxMenuItem_SetSubMenu},
    {sipName_SetTextColour, SIP_MLMETH_CAST(meth_wxMenuItem_SetTextColour), METH_VARARGS|METH_KEYWORDS, doc_wxMenuItem_SetTextColour}
};

sipVariableDef variables_wxMenuItem[] = {
    {PropertyVariable, sipName_Enabled, &methods_wxMenuItem[23], &methods_wxMenuItem[3], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_TextColour, &methods_wxMenuItem[19], &methods_wxMenuItem[38], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_SubMenu, &methods_wxMenuItem[18], &methods_wxMenuItem[37], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Menu, &methods_wxMenuItem[17], &methods_wxMenuItem[36], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_MarginWidth, &methods_wxMenuItem[16], &methods_wxMenuItem[35], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Kind, &methods_wxMenuItem[14], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ItemLabelText, &methods_wxMenuItem[13], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ItemLabel, &methods_wxMenuItem[12], &methods_wxMenuItem[34], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Id, &methods_wxMenuItem[11], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Help, &methods_wxMenuItem[10], &methods_wxMenuItem[33], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Font, &methods_wxMenuItem[9], &methods_wxMenuItem[32], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_DisabledBitmap, &methods_wxMenuItem[8], &methods_wxMenuItem[31], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_BitmapBundle, &methods_wxMenuItem[7], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Bitmap, &methods_wxMenuItem[6], &methods_wxMenuItem[29], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_BackgroundColour, &methods_wxMenuItem[5], &methods_wxMenuItem[28], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Accel, &methods_wxMenuItem[4], &methods_wxMenuItem[27], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxMenuItem, "MenuItem(parentMenu=None, id=ID_SEPARATOR, text=EmptyString, helpString=EmptyString, kind=ITEM_NORMAL, subMenu=None)\n"
"\n"
"A menu item represents an item in a menu.");


sipClassTypeDef sipTypeDef__core_wxMenuItem = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxMenuItem,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_MenuItem,
        {0, 0, 1},
        39, methods_wxMenuItem,
        0, SIP_NULLPTR,
        16, variables_wxMenuItem,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxMenuItem,
    -1,
    -1,
    supers_wxMenuItem,
    SIP_NULLPTR,
    init_type_wxMenuItem,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxMenuItem,
    SIP_NULLPTR,
    array_wxMenuItem,
    SIP_NULLPTR,
    release_wxMenuItem,
    cast_wxMenuItem,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
