[manpage_begin winico n 0.6]
[copyright {1997-1998, Brueckner&Jarosch}]
[moddesc   {winico}]
[titledesc {Windows Icon extension for Tcl/Tk}]
[require Tcl 8.4]
[require winico [opt 0.6]]
[description]
[para]

The Winico extension is an extension that provides enhanced
handling of icons for Tk applications under Window. This includes
loading icons from icon files and from executable resources and also
provides Taskbar icon management.

[section COMMANDS]

[list_begin definitions]

[call [cmd "winico createfrom"] [arg filename]]

Load icons from a .ico file. If successful this command returns an
identifier that should be used to access this resource with other 
[cmd winico] commands.  Icon files often contain several icons for
different color depths of the screen and may contain different sizes
(e.g. 16x16 and 32x32 icons) To obtain information on what has been
loaded, see the [cmd info] subcommand.

[call [cmd "winico load"] [arg resourcename] [opt [arg filename]]]

Load icons from the resource section of an executable file (.exe or .dll).
Only icons for the current colordepth are loaded (unlike the [cmd createfrom]
subcommand). [arg resourcename] may be a string identifier or a number
that identifies the item in the resource file. If no [arg filename] is
given then you may load some standard windows icons (defined for the
LoadIcon Win32 API function). The following names are recognised:
"application", "asterisk", "error", "exclamation", "hand", "question",
"information", "warning", and "winlogo".

[call [cmd "winico info"] [opt [arg id]]]

Returns information about icon resources managed by this extension. If
[arg id] is ommitted then the command returns a list of all the
current icon ids. If an icon [arg id] is specified then the result is
a list option value pairs for each icon in the icon resource For
identifiers created via [cmd "winico load"] the values given are not
relevant.

[list_begin opt]
[opt_def "-pos"]
   position inside the iconresource (beginning from 0)
[opt_def "-width"]
   width of the icon in pixels
[opt_def "-height"]
  height of the icon in pixels
[opt_def "-geometry"]
  widthxheight in pixels (for convenience)
[opt_def "-bpp"]
      color depth in bits per pixel (4 means 16 colors)
[opt_def "-hicon"]
    windows icon handle for this icon (in the actual version
    all hicons of a resource will be immediately created after 
    reading from disk, in later versions this may occur on demand , 
    to economize system load )
[opt_def "-ptr"]
      C-pointer of the internal struct, only interesting for hackers :-)
[list_end]

[call [cmd "winico setwindow"] [arg windowid]\
    [arg id]\
    [opt [arg big|small]]\
    [opt [arg pos]]]

Set the icon for the toplevel window given by [arg windowid] which may
be either the Tk pathname for the window, or a valid Windows HWND
value (for use with non-Tk windows).
[nl]
NOTE: the window MUST BE MAPPED. If not then this may fail or crash.
[list_begin opt]
[opt_def big|small]
   If ?big|small? is "big" (default) the taskbar icon AND the caption icon 
   are set under Win95/WinNT, if it's "small" only the small caption icon
   is set (via WM_SETICON).
   [nl]
   Under Win32s ?big|small? is ignored (setting done via SetClassLong())
   (for setting individual toplevels different Windows-classnames per toplevel
   would be required , TkToplevel0, TkToplevel1 and so on)

[opt_def pos]
   If [arg pos] is set, the icon with that -pos number is used for setting
   the toplevel icon, otherwise winico chooses the first 32x32 16color icon
   (this could be improved)
   [nl]
   This option only has an effect on icons created with the "createfrom"
   subcommand (FIX ME: check this)
[list_end]

[call [cmd "winico delete"] [arg id]]

Free the resource identified by [arg id]. This command is
always successful, even in [arg id] is invalid.

[call [cmd "winico taskbar"] [arg add|modify|delete] [arg id]\
    [opt [arg {-callback procname}]]\
    [opt [arg {-pos num}]]\
    [opt [arg {-text tooltiptext}]]]

   Modify an icon registration with the Windows taskbar. To add and
   icon to the system tray you use the [arg add] command and provide a
   suitable winico [arg id]. You should probably also provide a 
   [arg -text] argument otherwise the icon id will be used for the
   text too (Windows displays the text as a tooltip).
   [nl]
   To modify the text or the icon displayed in the taskbar status area,
   use the [arg -pos] and [arg -text] options to change the current
   settings.
   [nl]
   The remove an icon from the status area use the [arg delete] and
   give the [arg id] provided to the [arg add] command.
   [nl]
   The optional [arg -callback] is for specifying a Tcl procedure to
   be called when events occur on the icon. This includes mouse motion
   and button click events.
   In the callback there are bind-like abbreviations possible :
[list_begin opt]
[opt_def %m] the windows message specifier (see CALLBACK EVENTS)
[opt_def %i] the icon identifier           (ico#1, ico#2 a.s.o)
[opt_def %x] current xposition of the cursor 
[opt_def %y] current yposition of the cursor 
[opt_def %X] xposition of the cursor when the last windows-message was processed
[opt_def %Y] yposition of the cursor when the last windows-message was processed
        (%X,%Y may differ from %x,%y however the difference is marginal )
[opt_def %t] current tickcount of the system
[opt_def %w] wParam of the internal callback message (the integer part of %i)
[opt_def %l] lParam of the internal callback message (integer value of %m)
[opt_def %%] a %-sign
[list_end]

[list_end]

[section "CALLBACK EVENTS"]
[para]
The following Windows events will generate calls to a callback
procedure registered by the [cmd "winico taskbar"] command. The
following lists all the possible values of %m in the callback
substitution. Typically WM_RBUTTONUP is bound to a context menu.
[list_begin opt]
[opt_def WM_MOUSEMOVE]
[opt_def WM_LBUTTONDOWN]
[opt_def WM_LBUTTONUP]
[opt_def WM_LBUTTONDBLCLK]
[opt_def WM_RBUTTONDOWN]
[opt_def WM_RBUTTONUP]
[opt_def WM_RBUTTONDBLCLK]
[opt_def WM_MBUTTONDOWN]
[opt_def WM_MBUTTONUP]
[opt_def WM_MBUTTONDBLCLK]
[list_end]

[section EXAMPLES]

[para]
[example {
% winico createfrom icons/smiley.ico
ico#5
% winico info ico#5
{-pos 0 -width 32 -height 32 -geometry 32x32 -bpp 4 -hicon 0x670081 -ptr 0xf99884} {-pos 1 -width 16 -height 16 -geometry 16x16 -bpp 4 -hicon 0xad01b4 -ptr 0xf99884}
}]

[para]
[example {
set contextmenu [menu .popup -tearoff 0]
...
winico taskbar add ico#1 -pos 1 -text "big tcp server" \
                         -callback "mytclproc $contextmenu %m %i %X %Y"
...
proc mytclproc {contextmenu msg ico x y } {
  if { $msg=="WM_RBUTTONUP" } {
    $contextmenu post $x $y
  }
}
}]
   
[section AUTHORS]
Leo Schubert, Brueckner&Jarosch Ing.-GmbH
[para]
Modifications by Pat Thoyts.

[keywords icons taskbar "system tray"]
[manpage_end]
