# Contributing to `wgsl-analyzer`

Thank you for your interest in contributing to `wgsl-analyzer`!
There are many ways to contribute, and we appreciate all of them.

To get a quick overview of the crates and structure of the project,
take a look at the [Contributing] section of the manual.

If you have any questions, ask them in the [wgsl-analyzer Discord server].
If you are unsure where to start when working on an issue, then comment on the issue itself to ask for help.

## Fixing a bug or improving a feature

Generally, it is fine to just work on these kinds of tasks and create a pull request.
If there is an issue accompanying it, link it in the pull request description.
This allows the issue to be closed afterward or linked for context.

To find work to do, search the issue tracker using label filters such as `C-Bug` and `C-Feature`.

## Implementing a new feature

It is advised to first open an issue for any new feature.
This allows the team to clarify upfront whether the feature is desirable before any implementation begins.

We want to minimize the possibility of someone putting a lot of work into a feature that ends up being discarded.
This may happen if the feature is deemed out of scope — either due to a poor fit with `wgsl-analyzer` or due to limited maintenance capacity.

If a feature issue is already open but it is unclear whether it is considered accepted, feel free to comment and ask.

[Contributing]: https://wgsl-analyzer.github.io/book/contributing
[wgsl-analyzer Discord server]: https://discord.gg/3QUGyyz984
