# Code of Conduct

*This Code of Conduct is based on the [Rust Code of Conduct], itself adapted from the [Node.js Policy on Trolling] and the [Contributor Covenant].*

## Our Pledge

We, as community members, contributors, and leaders, pledge to foster a harassment-free experience for everyone, regardless of:

- age
- body size
- visible or invisible disability
- ethnicity
- sex traits
- gender identity or expression
- skill level
- schooling
- wealth
- nationality
- personal appearance
- race
- religion
- sexual identity or orientation

or any other characteristic not listed above.

We commit to creating and maintaining an open, inclusive, respectful, and healthy community.

## Our Standards

We aim to build a community grounded in respect and empathy.
Technical excellence matters, but not at the expense of kindness or consideration.

Avoid making off-topic or insensitive remarks, especially on potentially divisive subjects.
Such comments can alienate others and erode trust.

If someone raises concerns about your behavior or language:

- Avoid defensiveness.
- Listen, reflect, and adjust where needed.
- Even if misunderstood, consider how your message could have been clearer.

A respectful community benefits everyone. Trust is earned through consistent good intent.

- Use appropriate, non-offensive nicknames.
- Be kind, respectful, and constructive.
- Accept that disagreements are normal and that trade-offs are inherent in design decisions.
- Avoid unstructured critique; propose alternatives through examples or forks.
- Insults, demeaning language, and harassment are strictly prohibited, especially toward marginalized groups.
  Refer to the [Citizen Code of Conduct] for a definition of harassment.
- Private harassment is equally unacceptable—contact maintainers if you feel unsafe.
- Avoid metaphors involving slavery or similar topics; ask if unsure about terminology.
- Spamming, trolling, flaming, or baiting behavior will not be tolerated.

## Moderation

These policies define how we uphold [our standards of conduct](#our-standards). If you witness violations, report them to the maintainers.

- Hateful, hurtful, or exclusionary remarks are not permitted.
  (Swearing is tolerated only when not targeted or hateful.)
- Other inappropriate conduct, even if not explicitly listed here, may also be addressed.
- Typically, moderators begin with a warning.
- Repeated offenses lead to the offender being banned.
- Bans may be lifted for first offenses if a sincere apology is offered.
- Disputes about bans should be addressed privately; public complaints are not allowed in official channels.
- Maintainers are held to higher standards and will face greater consequences for violations.

These guidelines apply to all official community spaces — Discord, GitHub, and any other platforms we use.

[Citizen Code of Conduct]: https://github.com/stumpsyn/policies/blob/master/citizen_code_of_conduct.md
[Node.js Policy on Trolling]: http://blog.izs.me/post/30036893703/policy-on-trolling
[Contributor Covenant]: https://www.contributor-covenant.org
[Rust Code of Conduct]: https://www.rust-lang.org/policies/code-of-conduct
