# shasum

> SHA 암호화 체크섬 계산.
> 더 많은 정보: <https://manned.org/shasum>.

- 하나 이상의 파일에 대해 SHA1 체크섬 계산:

`shasum {{경로/대상/파일1 경로/대상/파일2 ...}}`

- 하나 이상의 파일에 대해 SHA256 체크섬 계산:

`shasum --algorithm 256 {{경로/대상/파일1 경로/대상/파일2 ...}}`

- 하나 이상의 파일에 대해 SHA512 체크섬 계산:

`shasum --algorithm 512 {{경로/대상/파일1 경로/대상/파일2 ...}}`

- `stdin`에서 SHA1 체크섬 계산:

`{{명령어}} | shasum`

- SHA256 체크섬 목록을 파일에 계산 및 저장:

`shasum --algorithm 256 {{경로/대상/파일1 경로/대상/파일2 ...}} > {{경로/대상/파일.sha256}}`

- SHA1 체크섬 및 파일 이름 목록이 포함된 파일을 읽어 모든 파일이 일치하는지 검증:

`shasum --check {{경로/대상/파일}}`

- 누락된 파일 또는 검증 실패 시에만 메시지 표시:

`shasum --check --quiet {{경로/대상/파일}}`

- 누락된 파일은 무시하고 검증 실패 시에만 메시지 표시:

`shasum --ignore-missing --check --quiet {{경로/대상/파일}}`
