[comment {-*- tcl -*- doctools manpage}]
[manpage_begin "Resources" n ""]
[copyright "2010 Ashok P. Nadkarni"]
[moddesc "Resource handling"]
[titledesc "Commands related to Windows file resources"]
[require twapi_resource]
[description]
[para]

Windows resources are binary data that can be added to executable files.
Examples include icons, strings and fonts.
This module provides commands related to manipulation of these
resources.

[section "Windows Resources"]
Resources are stored in Portable Executable format files (exe's and dll's).
A resource has an associated name, type and a language.
The name and type can be either integer values or strings.
To retrieve a particular resource, you must know both the associated
values, the type and the name, for that resource. When a resource type
or name is a string, it must be explicitly enclosed in quotes. For example,
[example "::twapi::read_resource \$h 14 {\"ICON3\"} 0"]
and not
[example "::twapi::read_resource \$h 14 \"ICON3\" 0"]
or
[example "::twapi::read_resource \$h 14 ICON3 0"]

[para]
To support
localization, there can be several resources with the same type and
name, but associated with different languages. These languages are
identified by a 16 bit language identifier ([cmd LANGID]) as 
described in the TWAPI [uri nls.html Internationalization] documentation.

[para]
TWAPI provides commands to retrieve and update resources as binary data.
It does not provide any functionality related to constructing the actual
binary data itself. Each resource type has a specific structure and
it is up to the application to construct it appropriately.

[para]
In addition to the commands to load resources as binary data,
TWAPI also provides commands to load certain resource types -
icons, cursors and bitmaps - as GDI objects accessed through handles
by other functions in the Windows API.

[para]
The [uri \#get_file_version_resource [cmd get_file_version_resource]]
command can be used to directly retrieve various information stored
within the version resource of a file without using the lower level
resource manipulation commands.

[section "Resource Types"]

Windows defines certain standard resource types shown in the table below
along with the corresponding [const #define] values from the SDK.

[list_begin opt]
[opt_def 1] RT_CURSOR - Cursor
[opt_def 2] RT_BITMAP - Bitmap
[opt_def 3] RT_ICON - Icon
[opt_def 4] RT_MENU - Menu
[opt_def 5] RT_DIALOG - Dialog
[opt_def 6] RT_STRING - String (see [uri #stringresources "String Resources"])
[opt_def 7] RT_FONTDIR - Font directory
[opt_def 8] RT_FONT - Font
[opt_def 9] RT_ACCELERATOR - Accelerator
[opt_def 10] RT_RCDATA - Application defined raw data
[opt_def 11] RT_MESSAGETABLE - Message table
[opt_def 12] RT_GROUP_CURSOR - Hardware independent cursor
[opt_def 14] RT_GROUP_ICON - Hardware independent icon
[opt_def 16] RT_VERSION - Version
[opt_def 17] RT_DLGINCLUDE - Name of C include file containing corresponding symbolic names of resources
[opt_def 19] RT_PLUGPLAY - Plug and play
[opt_def 20] RT_VXD - Vxd
[opt_def 21] RT_ANICURSOR - Animated cursor
[opt_def 22] RT_ANIICON - Animated icon
[opt_def 23] RT_HTML - HTML
[opt_def 24] RT_MANIFEST - Executable Manifest
[list_end]

[section "Locating and Loading Resources"]
Manipulating a resource requires a Windows executable module
handle for the corresponding
executable file. The commands will accept [const NULL] or [const 0]
for this handle corresponding the the main executable for the process.
To retrieve resources in other executables or DLL's, the module
must be first loaded through the
[uri base.html#load_library [cmd load_library]] call.
Generally, the [cmd -datafile] option should be passed to the
[cmd load_library] command if the only purpose is to access or update
resources.

[para]
When the resources in a module are no longer required, it must be
released through [uri base.html#free_library [cmd free_library]]
call.

[para]
Once the module is loaded, the content of a particular resource
can be retrieved using [uri #read_resource [cmd read_resource]]
and [uri #read_resource_string [cmd read_resource_string]].

[para]
You can also enumerate resources present in a module using the
[uri #enumerate_resource_types [cmd enumerate_resource_types]]
[uri #enumerate_resource_names [cmd enumerate_resource_names]]
[uri #enumerate_resource_languages [cmd enumerate_resource_languages]]
commands. The entire resource tree can be enumerated, optionally
retrieving the resource values, through the command
[uri #extract_resources [cmd extract_resources]].


[para]
Note that resources themselves do not need to be explicitly freed up.
In particular, [emph "do not try to close the resource handles"] through
the [cmd CloseHandle] or [uri base.html#close_handles [cmd close_handles]].


[section "Updating Resources"]
Updating a resource in a file requires that the file not be in use
by any application (including the current process).
The [uri #begin_resource_update [cmd begin_resource_update]] command
prepares the file for update. One or more
[uri #update_resource [cmd update_resource]] commands can be used to
modify the resources in the file and
[uri #delete_resource [cmd delete_resource]] commands can be used to
delete resources.
Finally, the
the [uri #end_resource_update [cmd end_resource_update]] command
is used to commit or discard the modifications.

[section "String Resources"]
Strings defined through a string table definition in a resource definition
file are not directly stored in the resource binary. They are stored in
string blocks, each containing 16 strings. 
It is therefore not possible
to directly retrieve or update a string based on its string id.

[para]
If you call [uri #read_resource [cmd read_resource]] with a resource type of
[const 6] (STRING), the resource name or id has to actually be the id
of the string block, not the string. The command
[uri #resource_stringid_to_stringblockid [cmd resource_stringid_to_stringblockid]]
will take a string id and return a pair consisting of the id of the 
corresponding block and the index of the string within the block. The block
id can be passed to [uri #read_resource [cmd read_resource]] to read
the string block. Since this is in binary format, it needs to be converted
into a list of strings using
[uri #resource_stringblock_to_strings [cmd resource_stringblock_to_strings]].
The string index returned from 
[uri #resource_stringid_to_stringblockid [cmd resource_stringid_to_stringblockid]] can be used to then pick out the appropriate string from the this list.
[para]
If you are only interested in a single string, the command
[uri #read_resource_string [cmd read_resource_string]] encapsulates this
entire process.
[para]
Updating strings in a resource involves multiple steps for the same reason.
First, the string block has to be retrieved and converted to a list
of strings as described above. The list must then be modified as desired
and converted back to a string block using
[uri #strings_to_resource_stringblock [cmd strings_to_resource_stringblock]]
and then written out using [uri #update_resource [cmd update_resource]].
[para]
Deleting a string resource is similar. Once the list of strings in
the appropriate block is retrieved, set the corresponding element in
the list to an empty string before writing it back using
[uri #update_resource [cmd update_resource]].
[para]
A peculiarity in the storage format for resource strings means it is not
always possible to distinguish between a resource string that is not defined
and a resource string that is defined with an empty value. An attempt
to read an undefined resource string may either result in an error being
generated, or in the return of an empty string.

[section "Loading Resources as GDI objects"]

TWAPI also provides commands to load some resource types as GDI objects
whose handles are opaque but can be passed to other commands in the Windows
API. These include the commands
[uri #load_icon_from_file [cmd load_icon_from_file]],
[uri #load_cursor_from_file [cmd load_cursor_from_file]],
[uri #load_bitmap_from_file [cmd load_bitmap_from_file]],
[uri #load_icon_from_module [cmd load_icon_from_module]],
[uri #load_cursor_from_module [cmd load_cursor_from_module]],
[uri #load_bitmap_from_module [cmd load_bitmap_from_module]],
[uri #load_icon_from_system [cmd load_icon_from_system]],
[uri #load_cursor_from_system [cmd load_cursor_from_system]] and
[uri #load_bitmap_from_system [cmd load_bitmap_from_system]].

[para]
The handles returned by the above commands may be shared or unshared
(as described in the documentation for the specific command).
Unshared handles must be freed using 
[uri #free_icon [cmd free_icon]],
[uri #free_cursor [cmd free_cursor]] and
[uri #free_bitmap [cmd free_bitmap]] respectively. Shared handles
are automatically freed by the system and must not be passed
to the free commands.

[para]
The commands to load these GDI objects share a common set of options:

[list_begin opt]
[opt_def [cmd -createdibsection] [arg BOOLEAN]]
If [const true], returns a DIB section bitmap instead of a compatible
bitmap. Default is [const false]. This option is
only valid for bitmap resources.
[opt_def [cmd -defaultsize] [arg BOOLEAN]]
If [const false] (default) and
options [cmd -height] and [cmd -width] are not specified or
specified as 0, Windows will use the actual resource size. If
[const true], Windows will use the system metric settings.
This option is only valid for cursors and icons.
[opt_def [cmd -height] [arg INTEGER]]
Specifies the desired height of the icon or cursor. Default value is 0
in which case the width is controlled by the [cmd -defaultsize] option.
[opt_def [cmd -loadtransparent] [arg BOOLEAN]]
If specified as [const true], the color of the first pixel is replaced with
the default window color. Should be used only if the color depth is
8 bpp or less. Default is [const false].
[opt_def [cmd -monochrome] [arg BOOLEAN]]
If specified as [const true], returns a monochrome image. Default is 
[const false].
[opt_def [cmd -vgacolor] [arg BOOLEAN]]
If [const true], uses VGA color.
[opt_def [cmd -width] [arg INTEGER]]
Specifies the desired width of the icon or cursor. Default value is 0
in which case the width is controlled by the [cmd -defaultsize] option.
[list_end]

[section Commands]

[list_begin definitions]

[call [cmd begin_resource_update] [arg MODULEPATH] [opt [cmd -deleteall]]]
Returns a handle to the file [arg MODULEPATH] to be updated.
The returned handle must be closed through
the [uri #end_resource_update [cmd end_resource_update]] command.
If the option [cmd -deleteall] is specified, all existing resources
in the file are deleted.

[call [cmd delete_resource] [arg HMODULE] [arg RESTYPE] [arg RESNAME] [arg LANGID]]
Deletes a resource from the specified module
[arg HMODULE] which must be a handle previously retrieved via
[uri #begin_resource_update [cmd begin_resource_update]].
The resource is not actually deleted from the file until
the [uri #end_resource_update [cmd end_resource_update]] command is called.


[call [cmd end_resource_update] [arg HMODULE] [opt [cmd -discard]]]
Closes a handle previously returned by the
[uri #begin_resource_update [cmd begin_resource_update]] command.
Any modifications made through [uri #update_resource [cmd update_resource]]
are written to the file unless the [cmd -discard] option is specified
in which case they are discarded.

[call [cmd enumerate_resource_languages] [arg HMODULE] [arg RESTYPE] [arg RESNAME]]
Returns a list of language identifiers for which the specified
module contains a resource of type [arg RESTYPE] with name [arg RESNAME].
[arg HMODULE] must be a handle previously retrieved via
[uri base.html#load_library [cmd load_library]].


[call [cmd enumerate_resource_names] [arg HMODULE] [arg RESTYPE]]
Returns a list of the names of resources of type [arg RESTYPE] in the specified
module.
[arg HMODULE] must be a handle previously retrieved via
[uri base.html#load_library [cmd load_library]],
[uri process.html#get_module_handle [cmd get_module_handle]], or
[uri process.html#get_module_handle_from_address [cmd get_module_handle_from_address]].


[call [cmd enumerate_resource_types] [arg HMODULE]]
Returns a list of the types of resources in the specified module.
[arg HMODULE] must be a handle previously retrieved via
[uri base.html#load_library [cmd load_library]].

[call [cmd extract_resources] [arg HMODULE] [opt [arg INCLUDEDATA]]]
Extracts all resources from the specified module. The returned data
is a nested dictionary with the first level key being the resource
type, second level key the resource name and the third level key
the language identifier.
[nl]
If [arg INCLUDEDATA] is true, the actual binary data for the resource
is returned as the value for each nested key. If [arg INCLUDEDATA]
is not specified or is false, an empty string is returned as the value.

[call [cmd free_bitmap] [arg HBITMAP]]
Frees a bitmap handle and associated resources. The handle must not be for
be a shared bitmap.

[call [cmd free_cursor] [arg HCURSOR]]
Frees a cursor handle and associated resources. The handle must not be for
be a shared cursor.

[call [cmd free_icon] [arg HBITMAP]]
Frees a icon handle and associated resources. The handle must not be for
be a shared icon.

[call [cmd get_file_version_resource] [arg PATH] [opt [arg options]] [opt "[arg STRINGNAME]..."]]

Returns the information stored within the version resource of a file. The
command will generate a Tcl error if the file specified by [arg PATH] does
not contain a version resource.
[nl]
The version resource consists of two parts. The information in the first
part is in a fixed format and can be retrieved by specifying appropriate
options in [arg options]. The second part is a string table, the entries in
which can be retrieved by specifying the key as a [arg STRINGNAME]
argument.

[nl]
The following options may be used with the command:
[list_begin opt]
[opt_def [cmd -all]]
Returns all information in the fixed part.
[opt_def [cmd -datetime]]
Returns the date and time the file was created (as stored in the
version resource) as a 64 bit number. Refer to
[uri base.html#large_system_time_to_timelist [cmd large_system_time_to_timelist]]
or
 [uri base.html#large_system_time_to_secs_since_1970 [cmd large_system_time_to_secs_since_1970]].

[opt_def [cmd -fileversion]]
Returns the file version as indicated in the version resource. This is
returned in the format [arg MAJOR.MINOR.BUILD.PRIVATE]. Note this is not
necessarily identical to the value specified for the [const FileVersion]
entry in the string table.
[opt_def [cmd -fileos]]
Returns a value specifying the platform for which the file was
designed. This may be one of
[const dos] (MS-DOS),
[const os216] (16-bit OS/2),
[const os232] (16-bit OS/2),
[const nt] (Windows NT),
[const wince] (Windows CE),
[const windows16] (16-bit Windows),
[const pm16] (16-bit Presentation Manager),
[const pm32] (32-bit Presentation Manager),
[const windows32] (32-bit Windows),
[const dos_windows32] (32-bit Windows on MS-DOS),
[const os216_pm16] (16-bit Presentation Manager on 16-bit OS/2),
[const os232_pm32]  (32-bit Presentation Manager on 32-bit OS/2) or
[const nt_windows32] (32-bit Windows on Windows NT).
[opt_def [cmd -filetype]]
Returns the file type which may be one of the following:
[const application],
[const dll],
[const driver.printer],
[const driver.keyboard],
[const driver.language],
[const driver.display],
[const driver.mouse],
[const driver.network],
[const driver.system],
[const driver.installable],
[const driver.sound],
[const driver.comm],
[const driver.inputmethod],
[const driver.versionedprinter],
[const driver.][arg DRIVERSUBTYPENUMBER],
[const font.raster],
[const font.vector],
[const font.truetype],
[const font.][arg FONTSUBTYPENUMBER],
[const vxd.][arg VIRTUALDEVICEID],
[const staticlib] or
[arg FILETYPENUMBER.FILESUBTYPENUMBER]. (Note in cases where the file type
or subtype is not recognized, the actual numeric value is returned.)

[opt_def [cmd -flags]]
Returns a list of symbols corresponding to flags set in the version resource.
The list may contain symbols from the following:
[const debug],
[const prerelease],
[const patched],
[const privatebuild],
[const infoinferred] and
[const specialbuild]. In addition, the list may also contain a numeric value
corresponding to bits that are set but are not recognized as one of the above.

[opt_def [cmd -foundcodepage]]
Returns the code page of the matched string table (see below).

[opt_def [cmd -foundlangid]]
Returns the language of the matched string table (see below). The returned value
is a list of two elements containing the numeric language identifier
and a description string for the corresponding language.

[opt_def [cmd -langid] [arg LANGID]]
Specifies [arg LANGID] as the language identifier to be used for string
table lookup (see below). By default, the language identifier returned
by [uri nls.html\#get_user_ui_langid [cmd get_user_ui_langid]] is used.
[opt_def [cmd -codepage] [arg CODEPAGE]]
Specifies [arg CODEPAGE] as the code page to be used for string table
lookup (see below).
[opt_def [cmd -productversion]]
Returns the product version as indicated in the version resource. This is
returned in the format [arg MAJOR.MINOR.BUILD.PRIVATE]. Note this is not
necessarily identical to the value specified for the [const ProductVersion]
entry in the string table.
[opt_def [cmd -signature]]
Contains a longword that is a signature for the fixed part of the version
resource. Not particularly useful for the application.
[opt_def [cmd -structversion]]
Returns the version of the version resource format.
[list_end]
In addition to the options that retrieve fixed portions of the version
resource, the caller may also specify string names corresponding to
language-specific string tables in the version resource. Each
such [arg STRINGNAME] is looked up in the string table and returned as
a [arg STRINGNAME] [arg VALUE] pair. If a particular string name does
not exist in the string table, an empty string is returned as its value. The
following string names are commonly defined in version resources:
[const Comments], [const InternalName], [const ProductName],
[const CompanyName], [const LegalCopyright], [const ProductVersion],
[const FileDescription], [const LegalTrademarks], [const PrivateBuild],
[const FileVersion], [const OriginalFilename], [const SpecialBuild].


[nl]
The version resource may contain
multiple string tables for different languages and code pages. The caller
can control the string table used through the [cmd -langid] and
[cmd -codepage] options. The command uses the following algorithm in
selecting the string table that is looked up.
[list_begin bullet]
[bullet]
If a string table exactly matches the language id and code page, it is used.
[bullet]
Otherwise, if a string table exactly matches the language id, it is used
irrespective of the code page.
[bullet]
Otherwise, a string table matching the primary language portion
of the language id and the code page is used.
[bullet]
Otherwise, a string table matching the primary language portion
of the language id is used regardless of the code page.
[bullet]
Otherwise, a string table specified as language neutral is used.
[bullet]
Otherwise, a string table specified as [const English] is used.
[bullet]
Finally, the string table corresponding to the first language and code page
specified in the resource is used.
[list_end]
The language identifier and code page corresponding to the actual string
table that was looked up may be optionally be retrieved by passing
the [cmd -foundlangid] and [cmd -foundcodepage] to the command.

[call [cmd load_bitmap_from_file] [arg PATH] [opt [arg options]]]
Returns a handle to a bitmap loaded from a standalone file.
The returned bitmap must be freed when no longer needed by calling
[uri #free_bitmap [cmd free_bitmap]].

[nl]
See [sectref "Loading Resources as GDI objects"] for a list of valid options.


[call [cmd load_bitmap_from_module] [arg HMODULE] [arg NAME] [opt [arg options]]]
Returns a handle to a bitmap from a resource in a module 
that has been loaded into the 
process. The returned bitmap must be freed when no longer needed by calling
[uri #free_bitmap [cmd free_bitmap]].
[nl]
[arg HMODULE] is handle to the module as returned by
[uri base.html#load_library [cmd load_library]],
[uri process.html#get_module_handle [cmd get_module_handle]], or
[uri process.html#get_module_handle_from_address [cmd get_module_handle_from_address]]. [arg NAME] is the resource identifier.
[nl]
See [sectref "Loading Resources as GDI objects"] for a list of valid options.

[call [cmd load_bitmap_from_system] [arg NAME] [opt [arg options]]]
Returns a handle to a bitmap built into Windows. The returned bitmap 
is a shared bitmap. Applications must not attempt to free it
by calling [uri #free_bitmap [cmd free_bitmap]].

[nl]
[arg NAME] must be one of
[const close], [const uparrow], [const dnarrow], [const rgarrow],
[const lfarrow], [const reduce], [const zoom], [const restore],
[const reduced], [const zoomd], [const restored], [const uparrowd],
[const dnarrowd], [const rgarrowd], [const lfarrowd], [const mnarrow],
[const combo], [const uparrowi], [const dnarrowi], [const rgarrowi],
[const lfarrowi], [const size], [const btsize],
[const check], [const checkboxes], [const btncorners].


[nl]
See [sectref "Loading Resources as GDI objects"] for a list of valid options.


[call [cmd load_cursor_from_file] [arg PATH] [opt [arg options]]]
Returns a handle to a cursor loaded from a standalone file.
The returned cursor must be freed when no longer needed by calling
[uri #free_cursor [cmd free_cursor]].

[nl]
See [sectref "Loading Resources as GDI objects"] for a list of valid options.

[call [cmd load_cursor_from_module] [arg HMODULE] [arg NAME] [opt [arg options]]]
Returns a handle to a cursor from a resource in a module 
that has been loaded into the 
process. The returned cursor must be freed when no longer needed by calling
[uri #free_cursor [cmd free_cursor]].

[nl]
[arg HMODULE] is handle to the module as returned by
[uri base.html#load_library [cmd load_library]],
[uri process.html#get_module_handle [cmd get_module_handle]], or
[uri process.html#get_module_handle_from_address [cmd get_module_handle_from_address]]. [arg NAME] is the resource identifier.
[nl]
See [sectref "Loading Resources as GDI objects"] for a list of valid options.

[call [cmd load_cursor_from_system] [arg NAME] [opt [arg options]]]
Returns a handle to a cursor built into Windows. The returned cursor
is a shared cursor. Applications must not attempt to free it
by calling [uri #free_cursor [cmd free_cursor]].
[nl]
[arg NAME] must be one of
[const normal], [const ibeam],
[const wait], [const cross],
[const up], [const sizenwse],
[const sizenesw], [const sizewe],
[const sizens], [const sizeall],
[const no], [const hand] or
[const appstarting].

[nl]
See [sectref "Loading Resources as GDI objects"] for a list of valid options.

[call [cmd load_icon_from_file] [arg PATH] [opt [arg options]]]
Returns a handle to an icon loaded from a standalone file.
The returned icon must be freed when no longer needed by calling
[uri #free_icon [cmd free_icon]].
[nl]
See [sectref "Loading Resources as GDI objects"] for a list of valid options.

[call [cmd load_icon_from_module] [arg HMODULE] [arg NAME] [opt [arg options]]]
Returns a handle to an icon from a resource in a module 
that has been loaded into the 
process. The returned icon must be freed when no longer needed by calling
[uri #free_icon [cmd free_icon]].
[nl]
[arg HMODULE] is handle to the module as returned by
[uri base.html#load_library [cmd load_library]],
[uri process.html#get_module_handle [cmd get_module_handle]], or
[uri process.html#get_module_handle_from_address [cmd get_module_handle_from_address]]. [arg NAME] is the resource identifier.
[nl]
See [sectref "Loading Resources as GDI objects"] for a list of valid options.

[call [cmd load_icon_from_system] [arg NAME] [opt [arg options]]]
Returns a handle to an icon built into Windows. The returned icon
is a shared icon. Applications must not attempt to free it
by calling [uri #free_icon [cmd free_icon]].
[nl]
[arg NAME] must be one of
[const sample], [const hand],
[const ques], [const bang],
[const note], [const winlogo],
[const warning], [const error],
[const information] or [const shield].

[nl]
See [sectref "Loading Resources as GDI objects"] for a list of valid options.


[call [cmd read_resource] [arg HMODULE] [arg RESTYPE] [arg RESNAME] [arg LANGID]]
Returns the content of a resource from the specified module
[arg HMODULE] which must be a handle previously retrieved via
[uri base.html#load_library [cmd load_library]].
[nl]
Note that If [arg RESTYPE] is [const 6], specifying a [const STRING] resource,
[arg RESTYPE] is the id for a string block, not an individual string.
The returned value is the binary data corresponding to the string block.
To retrieve individual strings, use the
[uri #read_resource_string [cmd read_resource_string]] command.

[call [cmd read_resource_string] [arg HMODULE] [arg STRINGID] [arg LANGID]]
Returns the string in the resource table for the module specified by
[arg HMODULE] which must be a handle previously retrieved via
[uri base.html#load_library [cmd load_library]].
[nl]
Because of the storage format used in string resources, it is not always
possible to distinguish between a resource string that is not defined
and a resource string that is defined with an empty value. An attempt
to read an undefined resource string may either result in an error being
generated, or in the return of an empty string.

[call [cmd resource_stringblock_to_strings] [arg BINDATA]]
Converts a binary resource string block to a list of strings. As every
string block contains 16 strings, the returned list as exactly
16 strings.

[call [cmd resource_stringid_to_stringblockid] [arg STRINGID]]
Maps a string resource id to a list containing the id of the
corresponding string block in the resource and the index of the string
within the block as described in [sectref "String Resources"].

[call [cmd strings_to_resource_stringblock] [arg STRINGS]]
Converts the list of strings in [arg STRINGS] to a binary resource string block
that can be passed to [uri #update_resource [cmd update_resource]].
The number of strings in [arg STRINGS] must not be more than 16 which
is the number stored in a single resource string block. If fewer than 16
strings are provided, they are stored as empty strings.

[call [cmd update_resource] [arg HMODULE] [arg RESTYPE] [arg RESNAME] [arg LANGID] [arg RESDATA]]
Updates a resource from the specified module
[arg HMODULE] which must be a handle previously retrieved via
[uri #begin_resource_update [cmd begin_resource_update]].
[arg RESDATA] 
should be the raw binary data for the resource in the type-specific format.
[nl]
The resource is not actually written out to the file until
the [uri #end_resource_update [cmd end_resource_update]] command is called.

[list_end]

[keywords resource icon "string resource" bitmap cursor stringblock \
     "version resource" "resource files" "resource modules"]

[manpage_end]
