AS_INIT

# $Id: m68k-insns-auto.sh,v 1.26 2009/08/29 19:38:23 fredette Exp $

# ic/m68k/m68k-insns-auto.sh - automatically generates C code 
# for many m68k emulation instructions:

#
# Copyright (c) 2002, 2003 Matt Fredette
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#      This product includes software developed by Matt Fredette.
# 4. The name of the author may not be used to endorse or promote products
#    derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
# STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
# ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#

header=false

for option
do
    case $option in
    --header) header=true ;;
    esac
done

PROG=`basename $0`
cat <<EOF
/* automatically generated by $PROG, do not edit! */
_TME_RCSID("\$Id: m68k-insns-auto.sh,v 1.26 2009/08/29 19:38:23 fredette Exp $");

EOF
if $header; then :; else
    cat <<EOF
#include "m68k-impl.h"

EOF
fi

# permute for the three different operand sizes we need to handle:
for size in 8 16 32; do
    
    # the shifts needed to get register contents of a specific size:
    case ${size} in
    8)  reg_size_shift=' << 2' ;;
    16) reg_size_shift=' << 1' ;;
    32) reg_size_shift='' ;;
    esac

    # generate the ALU functions:
    for name in add sub cmp neg or and eor not tst move moveq clr cmpa negx addx subx cmpm; do

	# characterize each operation:
	optype=normal ; src=op0 ; dst=op1 ; res=op1 ; arith=no ; with_x=false ; store_res=true
	case "$name" in
	add) op=' + ' ; arith=add ;;
	sub) op=' - ' ; arith=sub ;;
	cmp) op=' - ' ; arith=sub ; store_res=false ;;
	neg) op=' - ' ; arith=sub ; dst=0 ; src=op1 ;;
	or)  op=' | ' ;;
	and) op=' & ' ;;
	eor) op=' ^ ' ;;
	not) op='~ ' ; dst= ; src=op1 ;;
	tst) op='' ; dst= ; src=op1 ; store_res=false ;;
	move) op='' ; dst= ; src=op1 ; res=op0 ;;
	moveq) op='' ; dst= ; src=opc8 ; if test ${size} != 32; then continue; fi ;;
	clr) op='' ; dst= ; src=0 ;; 
	cmpa) op=' - ' ; arith=sub ; src=op0.16s32 ; store_res=false
	    if test $size != 16; then continue; fi ;;
	negx) op=' - ' ; arith=sub ; with_x=true ; dst=0 ; src=op1 ;;
	addx) op=' + ' ; arith=add ; optype=mathx ; with_x=true ;;
	subx) op=' - ' ; arith=sub ; optype=mathx ; with_x=true ;;
	cmpm) op=' - ' ; arith=sub ; optype=mathx ; store_res=false ;;
	*) AS_ECHO(["$0 internal error: unknown ALU function $name"]) 1>&2 ; exit 1 ;;
	esac

	# placeholder for another permutation:
	:

	    # if we're making the header, just emit a declaration:
	    if $header; then
		AS_ECHO(["TME_M68K_INSN_DECL(tme_m68k_${name}${size});"])
		continue
	    fi

	    # open the function:
	    AS_ECHO([""])
	    AS_ECHO_N(["/* this does a ${size}-bit \"$name "])
	    case "${src}/${dst}" in *op0*) AS_ECHO_N(["SRC, "]) ;; esac
	    AS_ECHO(["DST\": */"])
	    AS_ECHO(["TME_M68K_INSN(tme_m68k_${name}${size})"])
	    AS_ECHO(["{"])

	    # declare our locals:
	    if test $name = cmpa; then size=32; fi
	    AS_ECHO_N(["  tme_uint${size}_t res"])
	    case "${src}/${dst}" in *op0*) AS_ECHO_N([", op0"]) ;; esac
	    case "${src}/${dst}" in *op1*) AS_ECHO_N([", op1"]) ;; esac
	    AS_ECHO([";"])
	    AS_ECHO(["  tme_uint8_t flags;"])

	    # load the operand(s):
	    AS_ECHO([""])
	    AS_ECHO(["  /* load the operand(s): */"])
	    case ${optype} in
	    mathx)
		AS_ECHO(["  unsigned int function_code = TME_M68K_FUNCTION_CODE_DATA(ic);"])

		# NB: in my 68000 Programmer's Manual, the description
		# of subx is a little backwards from addx and cmpm. in
		# subx, the reg field at bits 0-2 is called the "x"
		# field, where in addx and cmpm it's called the "y"
		# field, and similarly for the reg field at bits 9-11.
		# fortunately, the meanings of the two reg fields is
		# always the same despite this - the reg field at bits
		# 0-2 always identifies the source operand, and the
		# reg field at bits 9-11 always identifies the
		# destination operand:
		AS_ECHO(["  int ireg_src = TME_FIELD_EXTRACTU(TME_M68K_INSN_OPCODE, 0, 3);"])
		AS_ECHO(["  int ireg_dst = TME_FIELD_EXTRACTU(TME_M68K_INSN_OPCODE, 9, 3);"])

		# the stack pointer must always be adjusted by a multiple of two.
		# assuming ireg < 8, ((ireg + 1) >> 3) == 1 iff ireg == 7, meaning %a7:
		AS_ECHO_N(["  tme_uint32_t ireg_src_adjust = sizeof(tme_uint${size}_t)";])
		if test ${size} = 8; then
		    AS_ECHO_N([" + ((ireg_src + 1) >> 3)"])
		fi
		AS_ECHO([";"])
		AS_ECHO_N(["  tme_uint32_t ireg_dst_adjust = sizeof(tme_uint${size}_t)";])
		if test ${size} = 8; then
		    AS_ECHO_N([" + ((ireg_dst + 1) >> 3)"])
		fi
		AS_ECHO([";"])

		case ${name} in

		# cmpm always uses memory and is always postincrement:
		cmpm)
		    AS_ECHO([""])
		    AS_ECHO(["  TME_M68K_INSN_CANFAULT;"])
		    AS_ECHO([""])
		    AS_ECHO(["  if (!TME_M68K_SEQUENCE_RESTARTING) {"])
		    AS_ECHO(["    ic->_tme_m68k_ea_function_code = function_code;"])
		    AS_ECHO(["    ic->_tme_m68k_ea_address = ic->tme_m68k_ireg_uint32(TME_M68K_IREG_A0 + ireg_src);"])
		    AS_ECHO(["    ic->tme_m68k_ireg_uint32(TME_M68K_IREG_A0 + ireg_src) += ireg_src_adjust;"])
		    AS_ECHO(["  }"])
		    AS_ECHO(["  tme_m68k_read_mem${size}(ic, TME_M68K_IREG_MEMY${size});"])
		    AS_ECHO(["  if (!TME_M68K_SEQUENCE_RESTARTING) {"])
		    AS_ECHO(["    ic->_tme_m68k_ea_function_code = function_code;"])
		    AS_ECHO(["    ic->_tme_m68k_ea_address = ic->tme_m68k_ireg_uint32(TME_M68K_IREG_A0 + ireg_dst);"])
		    AS_ECHO(["    ic->tme_m68k_ireg_uint32(TME_M68K_IREG_A0 + ireg_dst) += ireg_dst_adjust;"])
		    AS_ECHO(["  }"])
		    AS_ECHO(["  tme_m68k_read_memx${size}(ic);"])
		    AS_ECHO(["  ${dst} = ic->tme_m68k_ireg_memx${size};"])
		    AS_ECHO(["  ${src} = ic->tme_m68k_ireg_memy${size};"])
		    ;;

		# addx and subx use either registers or memory.  if they use memory,
		# they always predecrement:
		addx|subx)
		    AS_ECHO(["  tme_uint16_t memory;"])
		    AS_ECHO([""])
		    AS_ECHO(["  memory = (TME_M68K_INSN_OPCODE & TME_BIT(3));"])
		    AS_ECHO(["  if (memory) {"])
		    AS_ECHO(["    TME_M68K_INSN_CANFAULT;"])
		    AS_ECHO(["    if (!TME_M68K_SEQUENCE_RESTARTING) {"])
		    AS_ECHO(["      ic->tme_m68k_ireg_uint32(TME_M68K_IREG_A0 + ireg_src) -= ireg_src_adjust;"])
		    AS_ECHO(["      ic->_tme_m68k_ea_function_code = function_code;"])
		    AS_ECHO(["      ic->_tme_m68k_ea_address = ic->tme_m68k_ireg_uint32(TME_M68K_IREG_A0 + ireg_src);"])
		    AS_ECHO(["    }"])
		    AS_ECHO(["    tme_m68k_read_mem${size}(ic, TME_M68K_IREG_MEMY${size});"])
		    AS_ECHO(["    if (!TME_M68K_SEQUENCE_RESTARTING) {"])
		    AS_ECHO(["      ic->tme_m68k_ireg_uint32(TME_M68K_IREG_A0 + ireg_dst) -= ireg_dst_adjust;"])
		    AS_ECHO(["      ic->_tme_m68k_ea_function_code = function_code;"])
		    AS_ECHO(["      ic->_tme_m68k_ea_address = ic->tme_m68k_ireg_uint32(TME_M68K_IREG_A0 + ireg_dst);"])
		    AS_ECHO(["    }"])
		    AS_ECHO(["    tme_m68k_read_memx${size}(ic);"])
		    AS_ECHO(["    ${dst} = ic->tme_m68k_ireg_memx${size};"])
		    AS_ECHO(["    ${src} = ic->tme_m68k_ireg_memy${size};"])
		    AS_ECHO(["  }"])
		    AS_ECHO(["  else {"])
		    AS_ECHO(["    ${src} = ic->tme_m68k_ireg_uint${size}((TME_M68K_IREG_D0 + ireg_src)${reg_size_shift});"])
		    AS_ECHO(["    ${dst} = ic->tme_m68k_ireg_uint${size}((TME_M68K_IREG_D0 + ireg_dst)${reg_size_shift});"])
		    AS_ECHO(["  }"])
		    ;;
		*) AS_ECHO(["$0 internal error: unknown mathx ${name}" 1>&2 ; exit 1 ;;])
		esac
		;;
	    normal)
		for which in src dst; do
		    eval 'what=$'${which}
		    case "x${what}" in
		    x|x0) ;;
		    xop[[01]].16s32)
			what=`AS_ECHO([${what} | sed -e 's/\..*//'`
			eval ${which}"=${what}"
			AS_ECHO(["  ${what} = (tme_uint32_t) ((tme_int32_t) *((tme_int16_t *) _${what}));"])
			;;
		    xop[[01]])
			AS_ECHO(["  ${what} = *((tme_uint${size}_t *) _${what});"])
			;;
		    xopc8)
		        eval ${which}"='TME_EXT_S8_U${size}((tme_int8_t) (TME_M68K_INSN_OPCODE & 0xff))'"
			;;
		    *) AS_ECHO(["$0 internal error: unknown what ${what}"]) 1>&2 ; exit 1 ;;
		    esac
		done
		;;
	    *) AS_ECHO(["$0 internal error: unknown optype ${optype}"]) 1>&2 ; exit 1 ;;
	    esac

	    # perform the operation:
	    AS_ECHO([""])
	    AS_ECHO(["  /* perform the operation: */"])
	    AS_ECHO_N(["  res = ${dst}${op}${src}"])
	    if $with_x; then
		AS_ECHO_N(["${op}((ic->tme_m68k_ireg_ccr / TME_M68K_FLAG_X) & 1)"])
	    fi
	    AS_ECHO([";"])

	    # store the result:
	    if $store_res; then
		AS_ECHO([""])
		AS_ECHO(["  /* store the result: */"])
		case ${optype} in
		mathx)
		    AS_ECHO(["  if (memory) {"])
		    AS_ECHO(["    if (!TME_M68K_SEQUENCE_RESTARTING) {"])
		    AS_ECHO(["      ic->tme_m68k_ireg_memx${size} = res;"])
		    AS_ECHO(["      ic->_tme_m68k_ea_function_code = function_code;"])
		    AS_ECHO(["      ic->_tme_m68k_ea_address = ic->tme_m68k_ireg_uint32(TME_M68K_IREG_A0 + ireg_dst);"])
		    AS_ECHO(["    }"])
		    AS_ECHO(["    tme_m68k_write_memx${size}(ic);"])
		    AS_ECHO(["  }"])
		    AS_ECHO(["  else {"])
		    AS_ECHO(["    ic->tme_m68k_ireg_uint${size}((TME_M68K_IREG_D0 + ireg_dst)${reg_size_shift}) = res;"])
		    AS_ECHO(["  }"])
		    ;;
		normal)
		    AS_ECHO(["  *((tme_uint${size}_t *) _${res}) = res;"])
		    ;;
		*) AS_ECHO(["$0 internal error: unknown optype ${optype}" 1>&2 ; exit 1 ;;])
		esac
	    fi

	    # start the status flags, maybe preserving X:
	    AS_ECHO([""])
	    AS_ECHO(["  /* set the flags: */"])
	    case "${name}:${arith}" in
	    cmp*|*:no)
		flag_x=
		;;
	    *)
		flag_x=" | TME_M68K_FLAG_X"
		;;
	    esac

	    # set N.  we cast to tme_uint8_t as soon as we know the
	    # bit we want is within the range of the type, to try
	    # to affect the generated assembly:
	    AS_ECHO(["  flags = ((tme_uint8_t) (((tme_uint${size}_t) res) >> (${size} - 1))) * TME_M68K_FLAG_N;"])
	    
	    # set Z:
	    if $with_x; then
		AS_ECHO(["  if (res == 0) flags |= (ic->tme_m68k_ireg_ccr & TME_M68K_FLAG_Z);"])
	    else
		AS_ECHO(["  if (res == 0) flags |= TME_M68K_FLAG_Z;"])
	    fi

	    # set V and C and maybe X:
	    case $arith in
	    add)
		case $size in
		8) ones="0xff" ;;
		16) ones="0xffff" ;;
		32) ones="0xffffffff" ;;
		esac
		# if the operands are the same sign, and the result has
	        # a different sign, set V.   we cast to tme_uint8_t as 
		# soon as we know the bit we want is within the range 
		# of the type, to try to affect the generated assembly:
		AS_ECHO(["  flags |= ((tme_uint8_t) (((${src} ^ ${dst} ^ ${ones}) & (${dst} ^ res)) >> (${size} - 1))) * TME_M68K_FLAG_V;"])
		# if src is greater than the logical inverse of dst, set C:
		AS_ECHO_N(["  if (${src} > (${dst} ^ ${ones})"])
		if $with_x; then
		    AS_ECHO_N([" || (${src} == (${dst} ^ ${ones}) && (ic->tme_m68k_ireg_ccr & TME_M68K_FLAG_X))"])
		fi
		AS_ECHO([") flags |= TME_M68K_FLAG_C${flag_x};"])
		;;
	    sub) 
		# if the operands are different signs, and the result has
	        # a different sign from the first operand, set V.  we
		# cast to tme_uint8_t as soon as we know the bit we want
		# is within the range of the type, to try to affect the
		# generated assembly:
		AS_ECHO(["  flags |= ((tme_uint8_t) (((${src} ^ ${dst}) & (${dst} ^ res)) >> (${size} - 1))) * TME_M68K_FLAG_V;"])
		# if src is greater than dst, set C:
		AS_ECHO_N(["  if (${src} > ${dst}"])
		if $with_x; then
		    AS_ECHO_N([" || (${src} == ${dst} && (ic->tme_m68k_ireg_ccr & TME_M68K_FLAG_X))"])
		fi
		AS_ECHO([") flags |= TME_M68K_FLAG_C${flag_x};"])
		;;
	    no) ;;
	    esac

	    # preserve X:
	    if test "x${flag_x}" = x; then
		AS_ECHO(["  flags |= (ic->tme_m68k_ireg_ccr & TME_M68K_FLAG_X);"])
	    fi

	    # set the flags:
	    AS_ECHO(["  ic->tme_m68k_ireg_ccr = flags;"])
	    
	    # done:
	    AS_ECHO([""])
	    AS_ECHO(["  TME_M68K_INSN_OK;"])
	    AS_ECHO(["}"])

	    if test $name = cmpa; then size=16; fi
    done

    # generate the wrapper functions for a move of an address register
    # to a predecrement or postincrement EA with that same address
    # register:
    for name in pd pi; do

	# a move of an address registers are only word and long:
	if test $size = 8; then continue; fi

	# if we're making the header, just emit a declaration:
	if $header; then
	    AS_ECHO(["TME_M68K_INSN_DECL(tme_m68k_move_sr${name}${size});"])
	    continue
	fi

	AS_ECHO([""])
	AS_ECHO(["/* a move of an address register to a predecrement or"])
	AS_ECHO(["   postincrement EA with that same address register, must"])
	AS_ECHO(["   store the original value of the address register.  since the"])
	AS_ECHO(["   predecrement and postincrement code in the executer updates"])
	AS_ECHO(["   the address register before the move has happened, we wrap"])
	AS_ECHO(["   the normal move function in this one, that gives an op1"])
	AS_ECHO(["   argument that is the original value of the address register: */"])
	AS_ECHO(["TME_M68K_INSN(tme_m68k_move_sr${name}${size})"])
	AS_ECHO(["{"])
	if test ${name} = pd; then op='+'; else op='-'; fi])
	AS_ECHO(["  /* NB: both this function and tme_m68k_move${size}()"])
	AS_ECHO(["     get the source operand as _op1, and the destination"])
	AS_ECHO(["     operand as _op0: */"])
	AS_ECHO(["  if (!TME_M68K_SEQUENCE_RESTARTING) {"])
	AS_ECHO(["    *((tme_uint${size}_t *) _op0)"])
	AS_ECHO(["      = (*((tme_uint${size}_t *) _op1)"])
	AS_ECHO(["         ${op} sizeof(tme_uint${size}_t));"])
	AS_ECHO(["  }"])
	AS_ECHO(["  tme_m68k_move${size}(ic, _op0, _op0);"])
	AS_ECHO(["}"])
    done

    # generate the address math functions:
    for name in suba adda movea; do

	# the address math functions don't need an 8-bit version:
	if test $size = 8; then continue; fi

	# if we're making the header, just emit a declaration:
	if $header; then
	    AS_ECHO(["TME_M68K_INSN_DECL(tme_m68k_${name}${size});"])
	    continue
	fi

	AS_ECHO([""])
	AS_ECHO(["/* the ${name} function on a ${size}-byte EA: */"])
	AS_ECHO(["TME_M68K_INSN(tme_m68k_${name}${size})"])
	AS_ECHO(["{"])
	case $name in
	suba) op='-' ; src="_op0" ; dst="_op1" ;;
	adda) op='+' ; src="_op0" ; dst="_op1" ;;
	movea) op='' ; src="_op1" ; dst="_op0" ;;
	esac
	AS_ECHO(["  *((tme_int32_t *) ${dst}) ${op}= *((tme_int${size}_t *) ${src});"])
	AS_ECHO(["  TME_M68K_INSN_OK;"])
	AS_ECHO(["}"])
    done
	    
    # generate the bit functions:
    for name in btst bchg bclr bset; do
	
	# the bit functions don't need a 16-bit version:
	if test $size = 16; then continue; fi

	# if we're making the header, just emit a declaration:
	if $header; then
	    AS_ECHO(["TME_M68K_INSN_DECL(tme_m68k_${name}${size});"])
	    continue
	fi

	AS_ECHO([""])
	AS_ECHO(["/* the ${name} function on a ${size}-byte EA: */"])
	AS_ECHO(["TME_M68K_INSN(tme_m68k_${name}${size})"])
	AS_ECHO(["{"])
	AS_ECHO(["  tme_uint${size}_t value, bit;"])
	AS_ECHO(["  bit = _TME_BIT(tme_uint${size}_t, TME_M68K_INSN_OP0(tme_uint8_t) & (${size} - 1));"])
	AS_ECHO(["  value = TME_M68K_INSN_OP1(tme_uint${size}_t);"])
	AS_ECHO(["  if (value & bit) {"])
	AS_ECHO(["    ic->tme_m68k_ireg_ccr &= ~TME_M68K_FLAG_Z;"])
	AS_ECHO(["  }"])
	AS_ECHO(["  else {"])
	AS_ECHO(["    ic->tme_m68k_ireg_ccr |= TME_M68K_FLAG_Z;"])
	AS_ECHO(["  }"])
	case ${name} in
	btst) ;;
	bchg) AS_ECHO(["  TME_M68K_INSN_OP1(tme_uint${size}_t) = value ^ bit;"]) ;;
	bclr) AS_ECHO(["  TME_M68K_INSN_OP1(tme_uint${size}_t) = value & ~bit;"]) ;;
	bset) AS_ECHO(["  TME_M68K_INSN_OP1(tme_uint${size}_t) = value | bit;"]) ;;
	esac
	AS_ECHO(["  TME_M68K_INSN_OK;"])
	AS_ECHO(["}"])
    done

    # generate the shift/rotate functions:
    for func in as ls ro rox; do
	for dir in l r; do
	    name="${func}${dir}"

	    # if we're making the header, just emit a declaration:
	    if $header; then
		AS_ECHO(["TME_M68K_INSN_DECL(tme_m68k_${name}${size});"])
		continue
	    fi

	    AS_ECHO([""])
	    AS_ECHO(["/* the ${name} function on a ${size}-byte EA: */"])
	    AS_ECHO(["TME_M68K_INSN(tme_m68k_${name}${size})"])
	    AS_ECHO(["{"])
	    AS_ECHO(["  unsigned int count;"])
	    sign=u
	    case "${name}" in
	    asr) sign= ;;
	    asl) AS_ECHO(["  tme_uint${size}_t sign_bits, sign_bits_mask;"]) ;;
	    rox[[lr]]) AS_ECHO(["  tme_uint8_t xbit;"]) ;;
	    *) ;;
	    esac
	    AS_ECHO(["  tme_${sign}int${size}_t res;"])
	    AS_ECHO(["  tme_uint8_t flags;"])
	    AS_ECHO([""])
	    AS_ECHO(["  /* get the count and operand: */"])
	    AS_ECHO(["  count = TME_M68K_INSN_OP0(tme_uint8_t) & 63;"])
	    AS_ECHO(["  res = TME_M68K_INSN_OP1(tme_${sign}int${size}_t);"])

	    AS_ECHO([""])
	    AS_ECHO(["  /* generate the X, V, and C flags assuming the count is zero: */"])
	    AS_ECHO(["  flags = ic->tme_m68k_ireg_ccr & TME_M68K_FLAG_X;"])
	    case "${name}" in
	    rox[[lr]])
		AS_ECHO(["  xbit = (flags / TME_M68K_FLAG_X);"])
		AS_ECHO(["  flags |= (xbit * TME_M68K_FLAG_C);"])
		;;
	    esac

	    AS_ECHO([""])
	    AS_ECHO(["  /* if the count is nonzero, update the result and"])
	    AS_ECHO(["     generate the X, V, and C flags: */"])
	    AS_ECHO(["  if (count > 0) {"])
	    case "${name}" in
	    lsr)
		AS_ECHO(["    if (63 > SHIFTMAX_INT${size}_T"])
		AS_ECHO(["        && count > ${size}) {"])
		AS_ECHO(["      res = 0;"])
		AS_ECHO(["    }"])
		AS_ECHO(["    res >>= (count - 1);"])
		AS_ECHO(["    flags = (res & 1);"])
		AS_ECHO(["    flags *= TME_M68K_FLAG_C;"])
		AS_ECHO(["    flags |= (flags * TME_M68K_FLAG_X);"])
		AS_ECHO(["    res >>= 1;"])
		;;
	    asr)
		AS_ECHO(["    if (63 > SHIFTMAX_INT${size}_T"])
		AS_ECHO(["        && count > ${size}) {"])
		AS_ECHO(["      res = 0 - (res < 0);"])
		AS_ECHO(["    }"])
		AS_ECHO(["#ifdef SHIFTSIGNED_INT${size}_T"])
		AS_ECHO(["    res >>= (count - 1);"])
		AS_ECHO(["#else  /* !SHIFTSIGNED_INT${size}_T */"])
		AS_ECHO(["    for (; --count > 0; ) {"])
		AS_ECHO(["      res = (res & ~((tme_${sign}int${size}_t) 1)) / 2;"])
		AS_ECHO(["    }"])
		AS_ECHO(["#endif /* !SHIFTSIGNED_INT${size}_T */"])
		AS_ECHO(["    flags = (res & 1);"])
		AS_ECHO(["    flags *= TME_M68K_FLAG_C;"])
		AS_ECHO(["    flags |= (flags * TME_M68K_FLAG_X);"])
		AS_ECHO(["#ifdef SHIFTSIGNED_INT${size}_T"])
		AS_ECHO(["    res >>= 1;"])
		AS_ECHO(["#else  /* !SHIFTSIGNED_INT${size}_T */"])
		AS_ECHO(["    res = (res & ~((tme_${sign}int${size}_t) 1)) / 2;"])
		AS_ECHO(["#endif /* !SHIFTSIGNED_INT${size}_T */"])
		;;
	    [[al]]sl)
		if test ${name} = asl; then
		    AS_ECHO([""])
		    AS_ECHO(["    /* we need to see how the sign of the result will change during"])
		    AS_ECHO(["       shifting in order to generate V."])
		    AS_ECHO([""])
		    AS_ECHO(["       in general, the idea is to get all of the bits that will ever"])
		    AS_ECHO(["       appear in the sign position into sign_bits, with a mask in"])
		    AS_ECHO(["       sign_bits_mask.  if (sign_bits & sign_bits_mask) is zero or"])
		    AS_ECHO(["       sign_bits_mask, clear V, else set V."])
		    AS_ECHO([""])
		    AS_ECHO(["       start by loading the operand into sign_bits and setting"])
		    AS_ECHO(["       sign_bits_mask to all-bits-one."])
		    AS_ECHO([""])
		    AS_ECHO(["       if the shift count is exactly ${size} - 1, then all of the bits"])
		    AS_ECHO(["       of the operand will appear in the sign position."])
		    AS_ECHO([""])
		    AS_ECHO(["       if the shift count is less than ${size} - 1, then some of the"])
		    AS_ECHO(["       less significant bits of the operand will never appear in the"])
		    AS_ECHO(["       sign position, so we can shift sign_bits_mask to ignore them."])
		    AS_ECHO([""])
		    AS_ECHO(["       if the shift count is greater than ${size} - 1, then all of the"])
		    AS_ECHO(["       bits in the operand, plus at least one zero bit, will appear in"])
		    AS_ECHO(["       the sign position.  the only way that the sign bit will never"])
		    AS_ECHO(["       change during the shift is if the operand was zero to begin with."])
		    AS_ECHO(["       without any changes to sign_bits or sign_bits_mask, the final"])
		    AS_ECHO(["       test will always work, except when sign_bits is all-bits-one."])
		    AS_ECHO(["       the magic below clears the least-significant bit of sign_bits"])
		    AS_ECHO(["       iff sign_bits is all-bits-one: */"])
		    AS_ECHO(["    sign_bits = res;"])
		fi
		AS_ECHO(["    if (63 > SHIFTMAX_INT${size}_T"])
		AS_ECHO(["        && count > ${size}) {"])
		AS_ECHO(["      res = 0;"])
		AS_ECHO(["    }"])
		AS_ECHO(["    res <<= (count - 1);"])
		AS_ECHO(["    flags = (res >> (${size} - 1));"])
		AS_ECHO(["    flags *= TME_M68K_FLAG_C;"])
		AS_ECHO(["    flags |= (flags * TME_M68K_FLAG_X);"])
		AS_ECHO(["    res <<= 1;"])
		if test ${name} = asl; then		
		    AS_ECHO(["    sign_bits_mask = (tme_uint${size}_t) -1;"])
		    AS_ECHO(["    if (count != ${size} - 1) {"])
		    AS_ECHO(["      if (count < ${size}) {"])
		    AS_ECHO(["        sign_bits_mask <<= ((${size} - 1) - count);"])
		    AS_ECHO(["      }"])
		    AS_ECHO(["      else {"])
		    AS_ECHO(["        sign_bits ^= !(sign_bits + 1);"])
		    AS_ECHO(["      }"])
		    AS_ECHO(["    }"		    ])
		    AS_ECHO(["    sign_bits &= sign_bits_mask;"])
		    AS_ECHO(["    if (sign_bits != 0 && sign_bits != sign_bits_mask) {"])
		    AS_ECHO(["      flags |= TME_M68K_FLAG_V;"])
		    AS_ECHO(["    }"])
		fi
		;;
	    ro[[lr]])
		AS_ECHO(["    count &= (${size} - 1);"])
		if test $dir = l; then
		    AS_ECHO(["    res = (res << count) | (res >> (${size} - count));"])
		    AS_ECHO(["    flags |= ((res & 1) * TME_M68K_FLAG_C);"])
		else
		    AS_ECHO(["    res = (res << (${size} - count)) | (res >> count);"])
		    AS_ECHO(["    flags |= ((res >> (${size} - 1)) * TME_M68K_FLAG_C);"])
		fi
		;;
	    rox[[lr]])
		AS_ECHO(["    count %= (${size} + 1);"])
		AS_ECHO(["    flags = xbit;"])
		AS_ECHO(["    if (count > 0) {"])
		if test $dir = l; then
		    AS_ECHO(["      flags = (res >> (${size} - count)) & 1;"])
		    AS_ECHO(["      if (${size} > SHIFTMAX_INT${size}_T"])
		    AS_ECHO(["          && count == ${size}) {"])
		    AS_ECHO(["        res = 0 | (xbit << (${size} - 1)) | (res >> ((${size} + 1) - ${size}));"])
		    AS_ECHO(["      }"])
		    AS_ECHO(["      else if (${size} > SHIFTMAX_INT${size}_T"])
		    AS_ECHO(["               && count == 1) {"])
		    AS_ECHO(["        res = (res << 1) | (xbit << (1 - 1)) | 0;"])
		    AS_ECHO(["      }"])
		    AS_ECHO(["      else {"])
		    AS_ECHO(["        res = (res << count) | (xbit << (count - 1)) | (res >> ((${size} + 1) - count));"])
		    AS_ECHO(["      }"])
		else
		    AS_ECHO(["      flags = (res >> (count - 1)) & 1;"])
		    AS_ECHO(["      if (${size} > SHIFTMAX_INT${size}_T"])
		    AS_ECHO(["          && count == ${size}) {"])
		    AS_ECHO(["        res = (res << ((${size} + 1) - ${size})) | (xbit << (${size} - ${size})) | 0;"])
		    AS_ECHO(["      }"])
		    AS_ECHO(["      else if (${size} > SHIFTMAX_INT${size}_T"])
		    AS_ECHO(["               && count == 1) {"])
		    AS_ECHO(["        res = 0 | (xbit << (${size} - 1)) | (res >> 1);"])
		    AS_ECHO(["      }"])
		    AS_ECHO(["      else {"])
		    AS_ECHO(["        res = (res << ((${size} + 1) - count)) | (xbit << (${size} - count)) | (res >> count);"])
		    AS_ECHO(["      }"])
		fi
		AS_ECHO(["    }"])
		AS_ECHO(["    flags *= TME_M68K_FLAG_C;"])
		AS_ECHO(["    flags |= (flags * TME_M68K_FLAG_X);"])
		;;
	    esac
		AS_ECHO(["  }"])

	    AS_ECHO([""])
	    AS_ECHO(["  /* store the result: */"])
	    AS_ECHO(["  TME_M68K_INSN_OP1(tme_${sign}int${size}_t) = res;"])

	    AS_ECHO([""])
	    AS_ECHO(["  /* generate the N flag.  we cast to tme_uint8_t as soon as we"])
	    AS_ECHO(["     know the bit we want is within the range of the type, to try"])
	    AS_ECHO(["     to affect the generated assembly: */"])
	    AS_ECHO(["  flags |= ((tme_uint8_t) (((tme_uint${size}_t) res) >> (${size} - 1))) * TME_M68K_FLAG_N;"])
	    
	    AS_ECHO([""])
	    AS_ECHO(["  /* generate the Z flag: */"])
	    AS_ECHO(["  if (res == 0) flags |= TME_M68K_FLAG_Z;"])

	    AS_ECHO([""])
	    AS_ECHO(["  /* store the flags: */"])
	    AS_ECHO(["  ic->tme_m68k_ireg_ccr = flags;"])
	    AS_ECHO(["  TME_M68K_INSN_OK;"])
	    AS_ECHO(["}"])
	done
    done

    # movep_rm, movep_mr, movem_rm, and movem_mr:
    for name in rm mr; do
    
	# movep and movem don't need 8-bit versions:
	if test ${size} = 8; then continue; fi

	# if we're making the header, just emit declarations:
	if $header; then
	    AS_ECHO(["TME_M68K_INSN_DECL(tme_m68k_movep_${name}${size});"])
	    AS_ECHO(["TME_M68K_INSN_DECL(tme_m68k_movem_${name}${size});"])
	    continue
	fi

	# emit the movep function:
	AS_ECHO([""])
	AS_ECHO(["/* the movep_${name} function on a ${size}-bit dreg: */"])
	AS_ECHO(["TME_M68K_INSN(tme_m68k_movep_${name}${size})"])
	AS_ECHO(["{"])
	AS_ECHO(["  unsigned int function_code;"])
	AS_ECHO(["  tme_uint32_t linear_address;"])
	if test $name = rm; then
	    AS_ECHO(["  tme_uint${size}_t value;"])
	fi
	AS_ECHO(["  int dreg;"])
	AS_ECHO([""])
	AS_ECHO(["  TME_M68K_INSN_CANFAULT;"])
	AS_ECHO([""])
	AS_ECHO(["  function_code = TME_M68K_FUNCTION_CODE_DATA(ic);"])
	AS_ECHO(["  linear_address = TME_M68K_INSN_OP1(tme_uint32_t);"])
	AS_ECHO(["  linear_address += (tme_int32_t) ((tme_int16_t) TME_M68K_INSN_SPECOP);"])
	AS_ECHO(["  dreg = TME_M68K_IREG_D0 + TME_FIELD_EXTRACTU(TME_M68K_INSN_OPCODE, 9, 3);"])

	# set value:
	if test $name = rm; then
	    AS_ECHO(["  value = ic->tme_m68k_ireg_uint${size}(dreg${reg_size_shift});"])
            value="value"
        else
            value="ic->tme_m68k_ireg_uint${size}(dreg${reg_size_shift})"
	fi
	
	# transfer the bytes:
	pos=${size}
	while test $pos != 0; do
	    pos=`expr ${pos} - 8`
	    AS_ECHO(["  if (!TME_M68K_SEQUENCE_RESTARTING) {"])
	    AS_ECHO(["    ic->_tme_m68k_ea_function_code = function_code;"])
	    AS_ECHO(["    ic->_tme_m68k_ea_address = linear_address;"])
	    if test $name = rm; then
		AS_ECHO(["    ic->tme_m68k_ireg_memx8 = TME_FIELD_EXTRACTU(${value}, ${pos}, 8);"])
		AS_ECHO(["  }"])
		AS_ECHO(["  tme_m68k_write_memx8(ic);"])
	    else
		AS_ECHO(["  }"])
		AS_ECHO(["  tme_m68k_read_memx8(ic);"])
		AS_ECHO(["  if (!TME_M68K_SEQUENCE_RESTARTING) {"])
		AS_ECHO(["    TME_FIELD_DEPOSIT${size}(${value}, ${pos}, 8, ic->tme_m68k_ireg_memx8);"])
		AS_ECHO(["  }"])
	    fi
	    AS_ECHO(["  linear_address += 2;"])
	done

	AS_ECHO(["  TME_M68K_INSN_OK;"])
	AS_ECHO(["}"])

	# emit the movem function:
	AS_ECHO([""])
	AS_ECHO(["/* the movem_${name} function on ${size}-bit registers: */"])
	AS_ECHO(["TME_M68K_INSN(tme_m68k_movem_${name}${size})"])
	AS_ECHO(["{"])
	AS_ECHO(["  int ireg, direction;"])
	AS_ECHO(["  tme_uint16_t mask, bit;"])
	AS_ECHO(["  unsigned int ea_mode;"])
	AS_ECHO(["  tme_uint32_t addend;"])
	AS_ECHO(["  tme_uint32_t total_size;"])

	AS_ECHO(["  /* get the register mask, and figure out the total size"])
	AS_ECHO(["     of the transfer: */"])
	AS_ECHO(["  mask = TME_M68K_INSN_SPECOP;"])
	AS_ECHO(["  total_size = 0;"])
	AS_ECHO(["  if (mask != 0) {"])
	AS_ECHO(["    TME_M68K_INSN_CANFAULT;"])
	AS_ECHO(["    bit = mask;"])
	AS_ECHO(["    do {"])
	AS_ECHO(["      total_size += sizeof(tme_uint${size}_t);"])
	AS_ECHO(["      bit &= (bit - 1);"])
	AS_ECHO(["    } while (bit != 0);"])
	AS_ECHO(["  }"])

	AS_ECHO([""])
	AS_ECHO(["  /* figure out what direction to move in, and where to start from: */"])
	AS_ECHO(["  ea_mode = TME_FIELD_EXTRACTU(TME_M68K_INSN_OPCODE, 3, 3);"])
	AS_ECHO(["  direction = 1;"])
	AS_ECHO(["  ireg = TME_M68K_IREG_D0;"])
	if test $name = rm; then
	    AS_ECHO(["  if (ea_mode == 4) {"])
	    AS_ECHO(["    direction = -1;"])
	    AS_ECHO(["    ireg = TME_M68K_IREG_A7;"])
	    AS_ECHO(["    if (!TME_M68K_SEQUENCE_RESTARTING) {"])
	    AS_ECHO([""])
	    AS_ECHO(["      /* \"For the MC68020, MC68030, MC68040, and CPU32, if"])
	    AS_ECHO(["         the addressing register is also moved to memory, the"])
	    AS_ECHO(["         value written is the initial register value decremented "])
	    AS_ECHO(["         by the size of the operation. The MC68000 and MC68010 "])
	    AS_ECHO(["         write the initial register value (not decremented).\" */"])
	    AS_ECHO(["      if (ic->tme_m68k_type >= TME_M68K_M68020) {"])
	    AS_ECHO(["        ic->tme_m68k_ireg_uint32(TME_M68K_IREG_A0"])
	    AS_ECHO(["                                 + TME_FIELD_EXTRACTU(TME_M68K_INSN_OPCODE, 0, 3))"])
	    AS_ECHO(["          = (ic->_tme_m68k_ea_address - total_size);"])
	    AS_ECHO(["      }"])
	    AS_ECHO([""])
	    AS_ECHO(["      /* predecrement the effective address for the first transfer: */"])
	    AS_ECHO(["      ic->_tme_m68k_ea_address -= sizeof(tme_uint${size}_t);"])
	    AS_ECHO(["    }"])
	    AS_ECHO(["  }"])
	fi
	AS_ECHO(["  addend = (tme_uint32_t) (direction * sizeof(tme_uint${size}_t));"])

	AS_ECHO([""])
	AS_ECHO(["  /* do the transfer: */"])
	AS_ECHO(["  for (bit = 1; bit != 0; bit <<= 1) {"])
	AS_ECHO(["    if (mask & bit) {"])
	if test $name = rm; then
	    AS_ECHO(["      if (!TME_M68K_SEQUENCE_RESTARTING) {"])
	    AS_ECHO(["        ic->tme_m68k_ireg_memx${size} = ic->tme_m68k_ireg_uint${size}(ireg${reg_size_shift});"])
	    AS_ECHO(["      }"])
	    AS_ECHO(["      tme_m68k_write_memx${size}(ic);"])
	    AS_ECHO(["      if (!TME_M68K_SEQUENCE_RESTARTING) {"])
	else
	    AS_ECHO(["      tme_m68k_read_memx${size}(ic);"])
	    AS_ECHO(["      if (!TME_M68K_SEQUENCE_RESTARTING) {"])
	    AS_ECHO_N(["        ic->tme_m68k_ireg_uint32(ireg) = "])
	    if test $size = 32; then
		AS_ECHO(["ic->tme_m68k_ireg_memx${size};"])
	    else
		AS_ECHO(["TME_EXT_S${size}_U32((tme_int${size}_t) ic->tme_m68k_ireg_memx${size});"])
	    fi
	fi
	AS_ECHO(["        ic->_tme_m68k_ea_address += addend;"])
	AS_ECHO(["      }"])
	AS_ECHO(["    }"])
	AS_ECHO(["    ireg += direction;"])
	AS_ECHO(["  }"])
	AS_ECHO([""])

	# for the predecrement and postincrement modes, update the
	# address register:
	if test $name = rm; then 
	    AS_ECHO(["  /* if this is the predecrement mode, update the address register: */"])
	    AS_ECHO(["  /* \"For the MC68020, MC68030, MC68040, and CPU32, if"])
	    AS_ECHO(["     the addressing register is also moved to memory, the"])
	    AS_ECHO(["     value written is the initial register value decremented "])
	    AS_ECHO(["     by the size of the operation. The MC68000 and MC68010 "])
	    AS_ECHO(["     write the initial register value (not decremented).\" */"])
	    AS_ECHO(["  if (ea_mode == 4"])
	    AS_ECHO(["      && ic->tme_m68k_type < TME_M68K_M68020) {"])
	    AS_ECHO(["    ic->tme_m68k_ireg_uint32(TME_M68K_IREG_A0"])
	    AS_ECHO(["                              + TME_FIELD_EXTRACTU(TME_M68K_INSN_OPCODE, 0, 3))"])
	    AS_ECHO(["      = (ic->_tme_m68k_ea_address + sizeof(tme_uint${size}_t));"])
	    AS_ECHO(["  }"])
	else
	    AS_ECHO(["  /* if this is the postincrement mode, update the address register: */"])
	    AS_ECHO(["  if (ea_mode == 3) {"])
	    AS_ECHO(["    ic->tme_m68k_ireg_uint32(TME_M68K_IREG_A0"])
	    AS_ECHO(["                              + TME_FIELD_EXTRACTU(TME_M68K_INSN_OPCODE, 0, 3))"])
	    AS_ECHO(["      = ic->_tme_m68k_ea_address;"])
	    AS_ECHO(["  }"])
	fi
	
	AS_ECHO(["  TME_M68K_INSN_OK;"])
	AS_ECHO(["}"])
    done

    # chk32 and chk16:
    if test $size != 8; then

	# if we're making the header, just emit a declaration:
	if $header; then
	    AS_ECHO(["TME_M68K_INSN_DECL(tme_m68k_chk${size});"])
	else
	    AS_ECHO([""])
	    AS_ECHO(["/* chk${size}: */"])
	    AS_ECHO(["TME_M68K_INSN(tme_m68k_chk${size})"])
	    AS_ECHO(["{"])
	    AS_ECHO(["  if (*((tme_int${size}_t *) _op0) < 0) {"])
	    AS_ECHO(["    ic->tme_m68k_ireg_ccr |= TME_M68K_FLAG_N;"])
	    AS_ECHO(["    ic->tme_m68k_ireg_pc_last = ic->tme_m68k_ireg_pc;"])
	    AS_ECHO(["    ic->tme_m68k_ireg_pc = ic->tme_m68k_ireg_pc_next;"])
	    AS_ECHO(["    TME_M68K_INSN_EXCEPTION(TME_M68K_EXCEPTION_INST(TME_M68K_VECTOR_CHK));"])
	    AS_ECHO(["  }"])
	    AS_ECHO(["  if (*((tme_int${size}_t *) _op0) > *((tme_int${size}_t *) _op1)) {"])
	    AS_ECHO(["    ic->tme_m68k_ireg_ccr &= ~TME_M68K_FLAG_N;"])
	    AS_ECHO(["    ic->tme_m68k_ireg_pc_last = ic->tme_m68k_ireg_pc;"])
	    AS_ECHO(["    ic->tme_m68k_ireg_pc = ic->tme_m68k_ireg_pc_next;"])
	    AS_ECHO(["    TME_M68K_INSN_EXCEPTION(TME_M68K_EXCEPTION_INST(TME_M68K_VECTOR_CHK));"])
	    AS_ECHO(["  }"])
	    AS_ECHO(["  TME_M68K_INSN_OK;"])
	    AS_ECHO(["}"])
	fi
    fi

    # cas:
    name=cas
    if $header; then
	AS_ECHO(["TME_M68K_INSN_DECL(tme_m68k_${name}${size});"])
    else
	AS_ECHO([""])
	AS_ECHO(["/* ${name}${size}: */"])
	AS_ECHO(["TME_M68K_INSN(tme_m68k_${name}${size})"])
	AS_ECHO(["{"])
	AS_ECHO(["  struct tme_m68k_rmw rmw;"])
	AS_ECHO(["  struct tme_m68k_tlb *tlb;"])
	AS_ECHO(["  int ireg_dc, ireg_du;"])
	AS_ECHO(["  tme_uint${size}_t value_dc, value_du, value_mem;"])
	AS_ECHO([""])
	AS_ECHO(["  /* start the read/modify/write cycle: */"])
	AS_ECHO(["  rmw.tme_m68k_rmw_addresses[[0]] = ic->_tme_m68k_ea_address;"])
	AS_ECHO(["  rmw.tme_m68k_rmw_address_count = 1;"])
	AS_ECHO(["  rmw.tme_m68k_rmw_size = sizeof(tme_uint${size}_t);"])
	AS_ECHO(["  if (tme_m68k_rmw_start(ic,"])
	AS_ECHO(["                         &rmw)) {"])
	AS_ECHO(["    TME_M68K_INSN_OK;"])
	AS_ECHO(["  }"])
	AS_ECHO([""])
	AS_ECHO(["  /* get the compare and update registers: */"])
	AS_ECHO(["  ireg_dc = TME_M68K_IREG_D0 + TME_FIELD_EXTRACTU(TME_M68K_INSN_SPECOP, 0, 3);"])
	AS_ECHO(["  ireg_du = TME_M68K_IREG_D0 + TME_FIELD_EXTRACTU(TME_M68K_INSN_SPECOP, 6, 3);"])
	AS_ECHO([""])
	AS_ECHO(["  /* if we can do the fast compare-and-exchange: */"])
	AS_ECHO(["  if (!rmw.tme_m68k_rmw_slow_reads[[0]]) {"])
	AS_ECHO([""])
	AS_ECHO(["    /* get the compare and update values in big-endian byte order: */"])
	AS_ECHO(["    value_dc = ic->tme_m68k_ireg_uint${size}(ireg_dc${reg_size_shift});"])
	AS_ECHO(["    value_du = ic->tme_m68k_ireg_uint${size}(ireg_du${reg_size_shift});"])
	if test ${size} != 8; then
	    AS_ECHO(["    value_dc = tme_htobe_u${size}(value_dc);"])
	    AS_ECHO(["    value_du = tme_htobe_u${size}(value_du);"])
	fi
	AS_ECHO([""])
	AS_ECHO(["    /* get this TLB entry: */"])
	AS_ECHO(["    tlb = rmw.tme_m68k_rmw_tlbs[[0]];"])
	AS_ECHO([""])
	AS_ECHO(["    /* this TLB entry must allow fast reading and fast writing"])
	AS_ECHO(["       to the same memory: */"])
	AS_ECHO(["    assert (tlb->tme_m68k_tlb_emulator_off_read != TME_EMULATOR_OFF_UNDEF"])
	AS_ECHO(["            && tlb->tme_m68k_tlb_emulator_off_write == tlb->tme_m68k_tlb_emulator_off_read);"])
	AS_ECHO([""])
	AS_ECHO(["    /* do the compare-and-exchange: */"])
	AS_ECHO(["    value_mem ="])
	AS_ECHO(["      tme_memory_atomic_cx${size}(((tme_shared tme_uint${size}_t *)"])
	AS_ECHO(["                                   (tlb->tme_m68k_tlb_emulator_off_read"])
	AS_ECHO(["                                    + ic->_tme_m68k_ea_address)),"])
	AS_ECHO(["                                  value_dc,"])
	AS_ECHO(["                                  value_du,"])
	AS_ECHO(["                                  tlb->tme_m68k_tlb_bus_rwlock,"])
	AS_ECHO(["                                  sizeof(tme_uint8_t));"])
   	AS_ECHO_N(["    ic->tme_m68k_ireg_memx${size} = "])
	if test ${size} != 8; then AS_ECHO_N(["tme_betoh_u${size}"]); fi
	AS_ECHO(["(value_mem);"])
	AS_ECHO([""])
	AS_ECHO(["    /* step the transfer count once for the read, and once for the write: */"])
	AS_ECHO(["    TME_M68K_SEQUENCE_TRANSFER_STEP;"])
	AS_ECHO(["    TME_M68K_SEQUENCE_TRANSFER_STEP;"])
	AS_ECHO(["  }"])
	AS_ECHO([""])
	AS_ECHO(["  /* compare the compare operand to the effective address operand: */"])
	AS_ECHO(["  tme_m68k_cmp${size}(ic, &ic->tme_m68k_ireg_uint${size}(ireg_dc${reg_size_shift}), &ic->tme_m68k_ireg_memx${size});"])
	AS_ECHO([""])
	AS_ECHO(["  /* if the comparison succeeded: */"])
	AS_ECHO(["  if (ic->tme_m68k_ireg_ccr & TME_M68K_FLAG_Z) {"])
	AS_ECHO([""])
	AS_ECHO(["    /* write the update operand to the effective address operand: */"])
	AS_ECHO(["    ic->tme_m68k_ireg_memx${size} = ic->tme_m68k_ireg_uint${size}(ireg_du${reg_size_shift});"])
	AS_ECHO(["  }"])
	AS_ECHO([""])
	AS_ECHO(["  /* otherwise, the comparison failed: */"])
	AS_ECHO(["  else {"])
	AS_ECHO([""])
	AS_ECHO(["    /* write the effective address operand to the compare operand: */"])
	AS_ECHO(["    ic->tme_m68k_ireg_uint${size}(ireg_dc${reg_size_shift}) = ic->tme_m68k_ireg_memx${size};"])
	AS_ECHO(["  }"])
	AS_ECHO([""])
	AS_ECHO(["  /* finish the read/modify/write cycle: */"])
	AS_ECHO(["  tme_m68k_rmw_finish(ic,"])
	AS_ECHO(["                      &rmw,"])
	AS_ECHO(["                      (ic->tme_m68k_ireg_ccr & TME_M68K_FLAG_Z) != 0);"])
	AS_ECHO(["  TME_M68K_INSN_OK;"])
	AS_ECHO(["}"])
    fi

    # cas2:
    name=cas2_
    if test $size != 8; then

	if $header; then
	    AS_ECHO(["TME_M68K_INSN_DECL(tme_m68k_${name}${size});"])
	else
	    AS_ECHO([""])
	    AS_ECHO(["/* ${name}${size}: */"])
	    AS_ECHO(["TME_M68K_INSN(tme_m68k_${name}${size})"])
	    AS_ECHO(["{"])
	    AS_ECHO(["  struct tme_m68k_rmw rmw;"])
	    AS_ECHO(["  int ireg_dcx, ireg_dux;"])
	    AS_ECHO(["  int ireg_dcy, ireg_duy;"])
	    AS_ECHO(["  const tme_uint16_t specopx = TME_M68K_INSN_SPECOP;"])
	    AS_ECHO(["  const tme_uint16_t specopy = TME_M68K_INSN_OP0(tme_uint16_t);"])
	    AS_ECHO([""])
	    AS_ECHO(["  /* start the read/modify/write cycle: */"])
	    AS_ECHO(["  ic->_tme_m68k_ea_function_code = TME_M68K_FUNCTION_CODE_DATA(ic);"])
	    AS_ECHO(["  rmw.tme_m68k_rmw_addresses[[0]] = ic->tme_m68k_ireg_uint32(TME_M68K_IREG_D0"])
	    AS_ECHO(["                                                           + TME_FIELD_EXTRACTU(specopx, 12, 4));"])
	    AS_ECHO(["  rmw.tme_m68k_rmw_addresses[[1]] = ic->tme_m68k_ireg_uint32(TME_M68K_IREG_D0"])
	    AS_ECHO(["                                                           + TME_FIELD_EXTRACTU(specopy, 12, 4));"])
	    AS_ECHO(["  rmw.tme_m68k_rmw_address_count = 2;"])
	    AS_ECHO(["  rmw.tme_m68k_rmw_size = sizeof(tme_uint${size}_t);"])
	    AS_ECHO(["  if (tme_m68k_rmw_start(ic,"])
	    AS_ECHO(["                         &rmw)) {"])
	    AS_ECHO(["    TME_M68K_INSN_OK;"])
	    AS_ECHO(["  }"])
	    AS_ECHO([""])
	    AS_ECHO(["  /* do the comparisons: */"])
	    AS_ECHO(["  ireg_dcx = TME_M68K_IREG_D0 + TME_FIELD_EXTRACTU(specopx, 0, 3);"])
	    AS_ECHO(["  ireg_dcy = TME_M68K_IREG_D0 + TME_FIELD_EXTRACTU(specopy, 0, 3);"])
	    AS_ECHO(["  tme_m68k_cmp${size}(ic,"])
	    AS_ECHO(["                 &ic->tme_m68k_ireg_uint${size}(ireg_dcx${reg_size_shift}),"])
	    AS_ECHO(["                 &ic->tme_m68k_ireg_memx${size});"])
	    AS_ECHO(["  if (ic->tme_m68k_ireg_ccr & TME_M68K_FLAG_Z) {"])
	    AS_ECHO(["    tme_m68k_cmp${size}(ic,"])
	    AS_ECHO(["                   &ic->tme_m68k_ireg_uint${size}(ireg_dcy${reg_size_shift}),"])
	    AS_ECHO(["                   &ic->tme_m68k_ireg_memy${size});"])
	    AS_ECHO(["  }"])
	    AS_ECHO([""])
	    AS_ECHO(["  /* if the comparisons succeeded: */"])
	    AS_ECHO(["  if (ic->tme_m68k_ireg_ccr & TME_M68K_FLAG_Z) {"])
	    AS_ECHO([""])
	    AS_ECHO(["    /* write the update operands to the effective address operands: */"])
	    AS_ECHO(["    ireg_dux = TME_M68K_IREG_D0 + TME_FIELD_EXTRACTU(specopx, 6, 3);"])
	    AS_ECHO(["    ireg_duy = TME_M68K_IREG_D0 + TME_FIELD_EXTRACTU(specopy, 6, 3);"])
	    AS_ECHO(["    ic->tme_m68k_ireg_memx${size} = ic->tme_m68k_ireg_uint${size}(ireg_dux${reg_size_shift});"])
	    AS_ECHO(["    ic->tme_m68k_ireg_memy${size} = ic->tme_m68k_ireg_uint${size}(ireg_duy${reg_size_shift});"])
	    AS_ECHO(["  }"])
	    AS_ECHO([""])
	    AS_ECHO(["  /* otherwise, the comparisons failed: */"])
	    AS_ECHO(["  else {"])
	    AS_ECHO([""])
	    AS_ECHO(["    /* write the effective address operands to the compare operands."])
	    AS_ECHO(["       \"If Dc1 and Dc2 specify the same data register and the comparison"])
	    AS_ECHO(["        fails, memory operand 1 is stored in the data register.\" */"])
	    AS_ECHO(["    ic->tme_m68k_ireg_uint${size}(ireg_dcy${reg_size_shift}) = ic->tme_m68k_ireg_memy${size};"])
	    AS_ECHO(["    ic->tme_m68k_ireg_uint${size}(ireg_dcx${reg_size_shift}) = ic->tme_m68k_ireg_memx${size};"])
	    AS_ECHO(["  }"])
	    AS_ECHO([""])
	    AS_ECHO(["  /* finish the read/modify/write cycle: */"])
	    AS_ECHO(["  tme_m68k_rmw_finish(ic,"])
	    AS_ECHO(["                      &rmw,"])
	    AS_ECHO(["                      (ic->tme_m68k_ireg_ccr & TME_M68K_FLAG_Z) != 0);"])
	    AS_ECHO(["  TME_M68K_INSN_OK;"])
	    AS_ECHO(["}"])
	fi
    fi

    # moves:
    if $header; then
	AS_ECHO(["TME_M68K_INSN_DECL(tme_m68k_moves${size});"])
    else
	AS_ECHO([""])
	AS_ECHO(["/* moves${size}: */"])
	AS_ECHO(["TME_M68K_INSN(tme_m68k_moves${size})"])
	AS_ECHO(["{"])
	AS_ECHO(["  int ireg;"])
	AS_ECHO(["  tme_uint${size}_t ireg_value;"])
	AS_ECHO(["  unsigned int ea_reg;"])
	AS_ECHO(["  unsigned int increment;"])
	AS_ECHO(["  TME_M68K_INSN_PRIV;"])
	AS_ECHO(["  TME_M68K_INSN_CANFAULT;"])
	AS_ECHO(["  ireg = TME_M68K_IREG_D0 + TME_FIELD_EXTRACTU(TME_M68K_INSN_SPECOP, 12, 4);"])
	AS_ECHO([""])
	AS_ECHO(["  /* in case we're storing the same address register used in a"])
	AS_ECHO(["     postincrement or predecrement EA, save the current value"])
	AS_ECHO(["     of the register now: */"])
	AS_ECHO(["  ireg_value = ic->tme_m68k_ireg_uint${size}(ireg${reg_size_shift});"])
	AS_ECHO([""])
	AS_ECHO(["  /* we have to handle postincrement and predecrement ourselves: */"])
	AS_ECHO(["  if (!TME_M68K_SEQUENCE_RESTARTING) {"])
	AS_ECHO(["    ea_reg = TME_M68K_IREG_A0 + TME_FIELD_EXTRACTU(TME_M68K_INSN_OPCODE, 0, 3);"])
	AS_ECHO(["    increment = TME_M68K_SIZE_${size};"])
	AS_ECHO(["    if (increment == TME_M68K_SIZE_8 && ea_reg == TME_M68K_IREG_A7) {"])
	AS_ECHO(["      increment = TME_M68K_SIZE_16;"])
	AS_ECHO(["    }"])
	AS_ECHO(["    switch (TME_FIELD_EXTRACTU(TME_M68K_INSN_OPCODE, 3, 3)) {"])
	AS_ECHO(["    case 3: ic->tme_m68k_ireg_uint32(ea_reg) += increment; break;"])
	AS_ECHO(["    case 4: ic->_tme_m68k_ea_address = (ic->tme_m68k_ireg_uint32(ea_reg) -= increment); break;"])
	AS_ECHO(["    default: break;"])
	AS_ECHO(["    }"])
	AS_ECHO(["  }"])
	AS_ECHO([""])
	AS_ECHO(["  if (TME_M68K_INSN_SPECOP & TME_BIT(11)) {"])
	AS_ECHO(["    if (!TME_M68K_SEQUENCE_RESTARTING) {"])
	AS_ECHO(["      ic->tme_m68k_ireg_memx${size} = ireg_value;"])
	AS_ECHO(["      ic->_tme_m68k_ea_function_code = ic->tme_m68k_ireg_dfc;"])
	AS_ECHO(["    }"])
	AS_ECHO(["    tme_m68k_write_memx${size}(ic);"])
	AS_ECHO(["  }"])
	AS_ECHO(["  else {"])
	AS_ECHO(["    if (!TME_M68K_SEQUENCE_RESTARTING) {"])
	AS_ECHO(["      ic->_tme_m68k_ea_function_code = ic->tme_m68k_ireg_sfc;"])
	AS_ECHO(["    }"])
	AS_ECHO(["    tme_m68k_read_memx${size}(ic);"])
	if test ${size} != 32; then
	    AS_ECHO(["    if (ireg >= TME_M68K_IREG_A0) {"])
	    AS_ECHO(["      ic->tme_m68k_ireg_uint32(ireg) = "])
	    AS_ECHO(["        TME_EXT_S${size}_U32((tme_int${size}_t) ic->tme_m68k_ireg_memx${size});"])
	    AS_ECHO(["    }"])
	    AS_ECHO(["    else"])
	    AS_ECHO_N(["  "])
	fi
	AS_ECHO(["    ic->tme_m68k_ireg_uint${size}(ireg${reg_size_shift}) = ic->tme_m68k_ireg_memx${size};"])
	AS_ECHO(["  }"])
	AS_ECHO(["  TME_M68K_INSN_OK;"])
	AS_ECHO(["}"])
    fi
done

# generate the memory read and write functions:

# permute on size:
for size in 8 16 32 any; do

    # permute on read or write:
    for name in read write; do
	capname=`AS_ECHO([$name | tr a-z A-Z`
	if test $name = read; then 
	    from="from"
	else
	    from="to"
	fi

	# permute on the special-purpose what:
	for what in memx mem inst stack; do

	    # placeholder for another permutation:
	    :

		# dispatch on the size:
		_first=_first ; _last=_last
		case "$size" in
		8) _first= ; _last= ;;
		esac

		# set up the details of each special purpose:
		rval="void"
		args=""
		args_proto=""
		fc=""
		addr=""
		count=""
		tlb="TME_M68K_DTLB_ENTRY(ic, bus_context, function_code, linear_address${_first})"
		flags="TME_M68K_BUS_CYCLE_NORMAL"
		case "${name}-${what}-${size}" in
		*-memx-8 | *-memx-16 | *-memx-32)
		    action="${name}_${what}${size}"
		    fcptr="&ic->_tme_m68k_ea_function_code"
		    addrptr="&ic->_tme_m68k_ea_address"
		    reg="ic->tme_m68k_ireg_memx${size}"
		    regptr="&${reg}"
		    ;;
		*-mem-any)
		    action="${name}_${what}"
		    args_proto=", tme_uint8_t *, unsigned int"
		    args=", tme_uint8_t *buffer, unsigned int count"
		    fcptr="&ic->_tme_m68k_ea_function_code"
		    addrptr="&ic->_tme_m68k_ea_address"
		    _last=
		    reg=
		    regptr="buffer"
		    ;;
		*-mem-8 | *-mem-16 | *-mem-32)
		    action="${name}_${what}${size}"
		    args_proto=", int"
		    args="${args_proto} ireg"
		    fcptr="&ic->_tme_m68k_ea_function_code"
		    addrptr="&ic->_tme_m68k_ea_address"
		    reg="ic->tme_m68k_ireg_uint${size}(ireg)"
		    regptr="&${reg}"
		    ;;
		read-stack-16 | read-stack-32)
		    action="pop${size}"
		    args_proto=", tme_uint${size}_t *"
		    args="${args_proto}_value"
		    fc="TME_M68K_FUNCTION_CODE_DATA(ic)"
		    addrptr="&ic->tme_m68k_ireg_a7"
		    regptr="_value"
		    reg="*${regptr}"
		    ;;
		write-stack-16 | write-stack-32)
		    action="push${size}"
		    args_proto=", tme_uint${size}_t "
		    args="${args_proto}value"
		    fc="TME_M68K_FUNCTION_CODE_DATA(ic)"
		    addr="ic->tme_m68k_ireg_a7 - sizeof(tme_uint${size}_t)"
		    reg="value"
		    regptr="&${reg}"
		    ;;
		read-inst-16 | read-inst-32)
		    rval="tme_uint${size}_t"
		    action="fetch${size}"
		    args_proto=", tme_uint32_t"
		    args="${args_proto} pc"
		    fc="TME_M68K_FUNCTION_CODE_PROGRAM(ic)"
		    addrptr="&pc"
		    tlb="&ic->_tme_m68k_itlb"
		    flags="TME_M68K_BUS_CYCLE_FETCH"
		    ;;
		*)
		    continue
		    ;;
		esac

		# if we're making the header, just emit a declaration:
		if $header; then
		    AS_ECHO(["${rval} tme_m68k_${action} _TME_P((struct tme_m68k *${args_proto}));"])
		    continue
		fi

		# start the function:
		AS_ECHO([""])
		AS_ECHO(["/* this ${name}s a ${size}-bit ${what} value: */"])
		AS_ECHO(["${rval}"])
		AS_ECHO(["tme_m68k_${action}(struct tme_m68k *ic${args}) "])
		AS_ECHO(["{"])

		# our locals:
		AS_ECHO(["  tme_bus_context_t bus_context = ic->_tme_m68k_bus_context;"])
		AS_ECHO_N(["  unsigned int function_code = "])
		if test "x${fc}" != x; then
		    AS_ECHO(["${fc};"])
		    fc="function_code"
		    fcptr="&function_code"
		else
		    fc=`AS_ECHO([${fcptr}]) | sed -e 's,^&,,'`
		    AS_ECHO(["${fc};"])
		fi
		AS_ECHO_N(["  tme_uint32_t linear_address${_first} = "])
		if test "x${addr}" != x; then
		    AS_ECHO(["${addr};"])
		    addr="linear_address${_first}"
		    addrptr="&linear_address${_first}"
		else
		    addr=`AS_ECHO([${addrptr} | sed -e 's,^&,,'`
		    AS_ECHO(["${addr};"])
		fi
		if test "x${count}" = x; then
		    if test $size = any; then count=count; else count="sizeof(tme_uint${size}_t)"; fi
		fi
		if test x$_last != x; then
		    AS_ECHO(["  tme_uint32_t linear_address${_last} = linear_address_first + ${count} - 1;";])
		fi
		AS_ECHO(["  struct tme_m68k_tlb *tlb = ${tlb};"])
		if test $size != any; then
		    memtype="tme_uint${size}_t"
		    AS_ECHO(["  ${memtype} mem_value;"])
		    memtype="tme_shared ${memtype} *"
		    if test $name = read; then memtype="const ${memtype}"; fi
		    AS_ECHO(["  ${memtype}mem;"])
		fi
		case "$what" in
		inst)
		    AS_ECHO(["  unsigned int fetch_slow_next = ic->_tme_m68k_insn_fetch_slow_next;"])
		    regptr="((tme_uint${size}_t *) (((tme_uint8_t *) &ic->_tme_m68k_insn_fetch_buffer[[0]]) + fetch_slow_next))"
		    reg="*${regptr}"
		    ;;
		esac

		# track statistics:
		AS_ECHO([""])
		AS_ECHO(["#ifdef _TME_M68K_STATS"])
		AS_ECHO(["  ic->tme_m68k_stats.tme_m68k_stats_memory_total++;"])
		AS_ECHO(["#endif /* _TME_M68K_STATS */"])

		# if this is a write, log the value written:
		if test $name = write; then
		    AS_ECHO([""])
		    AS_ECHO(["  /* log the value written: */"])
		    if test $size != any; then
			AS_ECHO(["  tme_m68k_verify_mem${size}(ic, ${fc}, ${addr}, ${reg}, TME_BUS_CYCLE_WRITE);"])
			AS_ECHO(["  tme_m68k_log(ic, 1000, TME_OK, "])
			AS_ECHO(["               (TME_M68K_LOG_HANDLE(ic),"])
			AS_ECHO(["                _(\"${action}\t%d:0x%08x:\t0x%0"`expr ${size} / 4`"x\"),"])
			AS_ECHO(["                ${fc},"])
			AS_ECHO(["                ${addr},"])
			AS_ECHO(["                ${reg}));"])
		    else
			AS_ECHO(["  tme_m68k_verify_mem_any(ic, ${fc}, ${addr}, ${regptr}, ${count}, TME_BUS_CYCLE_WRITE);"])
			AS_ECHO(["  tme_m68k_log_start(ic, 1000, TME_OK) {"])
			AS_ECHO(["    unsigned int byte_i;"])
			AS_ECHO(["    tme_log_part(TME_M68K_LOG_HANDLE(ic),"])
			AS_ECHO(["                 _(\"${action} %d:0x%08x count %d:\"),"])
			AS_ECHO(["                 ${fc},"])
			AS_ECHO(["                 ${addr},"])
			AS_ECHO(["                 ${count});"])
			AS_ECHO(["    for (byte_i = 0; byte_i < count ; byte_i++) {"])
			AS_ECHO(["      tme_log_part(TME_M68K_LOG_HANDLE(ic), \" 0x%02x\", (${regptr})[[byte_i]]);"])
			AS_ECHO(["    }"])
			AS_ECHO(["  } tme_m68k_log_finish(ic);"])
		    fi
		fi

		AS_ECHO([""])
		AS_ECHO(["  /* busy this TLB entry: */"])
		AS_ECHO(["  tme_m68k_tlb_busy(tlb);"])

		# if this is an any-transfer:
		#
		if test $size = any; then
		    AS_ECHO([""])
		    AS_ECHO(["  /* call the full ${name} function: */"])
		    AS_ECHO(["  tme_m68k_${name}(ic, tlb, ${fcptr}, ${addrptr}, ${regptr}, ${count}, TME_M68K_BUS_CYCLE_RAW);"])

		# otherwise, this is not an any-transfer:
		#
		else

		    # dispatch on the what:
		    #
		    i=
		    case "$what" in
		    inst)
			AS_ECHO([""])
			AS_ECHO(["  /* if this fetch was done by the fast executor: */"])
			AS_ECHO(["  if (__tme_predict_true(fetch_slow_next < ic->_tme_m68k_insn_fetch_slow_count_fast)) {"])
			AS_ECHO([""])
			AS_ECHO(["    /* the entire fetch must be in the instruction buffer, and"])
			AS_ECHO(["       we must be restarting: */"])
			AS_ECHO(["    assert ((fetch_slow_next + sizeof(tme_uint${size}_t))"])
			AS_ECHO(["            <= ic->_tme_m68k_insn_fetch_slow_count_fast);"])
			AS_ECHO(["    assert (TME_M68K_SEQUENCE_RESTARTING);"])
			AS_ECHO(["    mem_value = tme_memory_read${size}(${regptr}, sizeof(tme_uint16_t));"])
			AS_ECHO(["  }"])
			AS_ECHO([""])
			AS_ECHO(["  /* otherwise, this fetch was not done by the fast executor: */"])
			AS_ECHO(["  else {"])
			AS_ECHO([""])
			AS_ECHO(["    /* if we're restarting, but the offset in the instruction buffer"])
			AS_ECHO(["       to fetch into is at the instruction buffer total, this must be"])
			AS_ECHO(["       a fake fault caused by the fast executor.  we confirm this by"])
			AS_ECHO(["       checking that this transfer \"caused\" the fault, and that this"])
			AS_ECHO(["       transfer will be the first slow one after any fast fetches."])
			AS_ECHO(["       in this case, we can cancel the restart for now: */"])
			AS_ECHO(["    if (TME_M68K_SEQUENCE_RESTARTING"])
			AS_ECHO(["        && (fetch_slow_next"])
			AS_ECHO(["            == ic->_tme_m68k_insn_fetch_slow_count_total)) {"])
			AS_ECHO(["      assert ((ic->_tme_m68k_sequence._tme_m68k_sequence_transfer_next"])
			AS_ECHO(["               == ic->_tme_m68k_sequence._tme_m68k_sequence_transfer_faulted)"])
			AS_ECHO(["              && (fetch_slow_next"])
			AS_ECHO(["                  == ic->_tme_m68k_insn_fetch_slow_count_fast));"])
			AS_ECHO(["      ic->_tme_m68k_sequence._tme_m68k_sequence_transfer_faulted--;"])
			AS_ECHO(["    }"])
			AS_ECHO([""])
			AS_ECHO(["    /* if we're not restarting: */"])
			AS_ECHO(["    if (!TME_M68K_SEQUENCE_RESTARTING) {"])
			AS_ECHO([""])
			AS_ECHO(["      /* we advance the instruction buffer total *before* we do"])
			AS_ECHO(["         what may be a slow fetch, because we may transfer a few"])
			AS_ECHO(["         bytes and then fault.  without this, those few bytes"])
			AS_ECHO(["         would not get saved in the exception stack frame and"])
			AS_ECHO(["         restored later before the continuation of the fetch: */"])
			AS_ECHO(["      ic->_tme_m68k_insn_fetch_slow_count_total += sizeof(tme_uint${size}_t);"])
			AS_ECHO(["    }"])
			AS_ECHO([""])
			AS_ECHO(["    /* make sure that if this is a new transfer or if this"])
			AS_ECHO(["       transfer faulted, that we're fetching for the current"])
			AS_ECHO(["       last positions in the instruction buffer: */"])
			AS_ECHO(["    assert ((ic->_tme_m68k_sequence._tme_m68k_sequence_transfer_next"])
			AS_ECHO(["             < ic->_tme_m68k_sequence._tme_m68k_sequence_transfer_faulted)"])
			AS_ECHO(["            || ((fetch_slow_next + sizeof(tme_uint${size}_t))"])
			AS_ECHO(["                == ic->_tme_m68k_insn_fetch_slow_count_total));"])
			i="  "
			;;
		    esac

		    AS_ECHO([""])
		    AS_ECHO(["${i}  /* if we aren't restarting, and this address is properly aligned,"])
		    AS_ECHO(["${i}     and this TLB entry covers the operand and allows fast ${name}s: */"])
		    AS_ECHO(["${i}  if (__tme_predict_true(!TME_M68K_SEQUENCE_RESTARTING"])
		    align_min="sizeof(tme_uint8_t)"
		    if test $size != 8; then
			AS_ECHO_N(["${i}                         && ("])
			if test $what = inst; then
			    align_min="sizeof(tme_uint16_t)"
			    AS_ECHO_N(["(${align_min} - 1)"])
			else
			    AS_ECHO_N(["ic->_tme_m68k_bus_16bit"])
			fi
			AS_ECHO([" & linear_address${_first}) == 0"])
		    fi
		    AS_ECHO(["${i}                         && tme_m68k_tlb_is_valid(tlb)"])
		    AS_ECHO(["${i}                         && tlb->tme_m68k_tlb_bus_context == bus_context"])
		    AS_ECHO(["${i}                         && (tlb->tme_m68k_tlb_function_codes_mask"])
		    AS_ECHO(["${i}                             & TME_BIT(function_code))"])
		    AS_ECHO(["${i}                         && linear_address${_first} >= (tme_bus_addr32_t) tlb->tme_m68k_tlb_linear_first"])
		    AS_ECHO(["${i}                         && linear_address${_last} <= (tme_bus_addr32_t) tlb->tme_m68k_tlb_linear_last"])
		    AS_ECHO(["${i}                         && tlb->tme_m68k_tlb_emulator_off_${name} != TME_EMULATOR_OFF_UNDEF)) {"])

		    AS_ECHO([""])
		    AS_ECHO(["${i}    /* make the emulator memory pointer: */"])
		    AS_ECHO(["${i}    mem = (${memtype}) (tlb->tme_m68k_tlb_emulator_off_${name} + linear_address${_first});"])

		    if test $name = write; then
			if test $size = 8; then
			    AS_ECHO([""])
			    AS_ECHO(["${i}    /* get the value to write: */"])
			    AS_ECHO(["${i}    mem_value = ${reg};"])
			else
			    AS_ECHO([""])
			    AS_ECHO(["${i}    /* get the value to write, in big-endian byte order: */"])
			    AS_ECHO(["${i}    mem_value = tme_htobe_u${size}(${reg});"])
			fi
		    fi

		    AS_ECHO([""])
		    AS_ECHO(["${i}    /* do the ${size}-bit bus ${name}: */"])
		    if test $name = read; then
			AS_ECHO_N(["${i}    mem_value = tme_memory_bus_${name}${size}(mem"])
		    else
			AS_ECHO_N(["${i}    tme_memory_bus_${name}${size}(mem, mem_value"])
		    fi
		    AS_ECHO([", tlb->tme_m68k_tlb_bus_rwlock, ${align_min}, sizeof(tme_uint32_t));"])

		    if test $name = read; then
			if test $what = inst; then
			    AS_ECHO([""])
			    AS_ECHO(["${i}    /* put the value read, in host byte order: */"])
			    AS_ECHO(["${i}    mem_value = tme_betoh_u${size}(mem_value);"])
			    AS_ECHO(["${i}    tme_memory_write${size}(${regptr}, mem_value, sizeof(tme_uint16_t));"])
			elif test $size = 8; then
			    AS_ECHO([""])
			    AS_ECHO(["${i}    /* put the value read: */"])
			    AS_ECHO(["${i}    ${reg} = mem_value;"])
			else
			    AS_ECHO([""])
			    AS_ECHO(["${i}    /* put the value read, in host byte order: */"])
			    AS_ECHO(["${i}    ${reg} = tme_betoh_u${size}(mem_value);"])
			fi
		    fi

		    AS_ECHO([""])
		    AS_ECHO(["${i}    /* step the transfer count: */"])
		    AS_ECHO(["${i}    TME_M68K_SEQUENCE_TRANSFER_STEP;"])
		    AS_ECHO(["${i}  }"])

		    AS_ECHO([""])
		    AS_ECHO(["${i}  /* otherwise, do the bus cycles the slow way: */"])
		    AS_ECHO(["${i}  else {"])
		    AS_ECHO(["${i}    tme_m68k_${name}${size}(ic, tlb,"])
		    AS_ECHO(["${i}                    ${fcptr},"])
		    AS_ECHO(["${i}                    ${addrptr},"])
		    AS_ECHO(["${i}                    ${regptr},"])
		    AS_ECHO(["${i}                    ${flags});"])
		    if test ${what} = inst; then
			AS_ECHO(["${i}    mem_value = tme_memory_read${size}(${regptr}, sizeof(tme_uint16_t));"])
		    fi
		    AS_ECHO(["${i}  }"])
		fi
		if test "x${i}" != x; then
		    AS_ECHO(["  }"])
		fi

		AS_ECHO([""])
		AS_ECHO(["  /* unbusy this TLB entry: */"])
		AS_ECHO(["  tme_m68k_tlb_unbusy(tlb);"])
		
		# if this is a read, log the value read:
		if test $name = read; then
		    AS_ECHO([""])
		    AS_ECHO(["  /* log the value read: */"])
		    if test $size != any; then])
			AS_ECHO(["  tme_m68k_verify_mem${size}(ic, ${fc}, ${addr}, ${reg}, TME_BUS_CYCLE_READ);"])
			AS_ECHO(["  tme_m68k_log(ic, 1000, TME_OK,"])
			AS_ECHO(["               (TME_M68K_LOG_HANDLE(ic),"])
			AS_ECHO(["                _(\"${action}\t%d:0x%08x:\t0x%0"`expr ${size} / 4`"x\"),"])
			AS_ECHO(["                ${fc},"])
			AS_ECHO(["                ${addr},"])
			AS_ECHO(["                ${reg}));"])
		    else
			AS_ECHO(["  tme_m68k_verify_mem_any(ic, ${fc}, ${addr}, ${regptr}, ${count}, TME_BUS_CYCLE_READ);"])
			AS_ECHO(["  tme_m68k_log_start(ic, 1000, TME_OK) {"])
			AS_ECHO(["    unsigned int byte_i;"])
			AS_ECHO(["    tme_log_part(TME_M68K_LOG_HANDLE(ic),"])
			AS_ECHO(["                 _(\"${action} %d:0x%08x count %d:\"),"])
			AS_ECHO(["                 ${fc},"])
			AS_ECHO(["                 ${addr},"])
			AS_ECHO(["                 ${count});"])
			AS_ECHO(["    for (byte_i = 0; byte_i < count ; byte_i++) {"])
			AS_ECHO(["      tme_log_part(TME_M68K_LOG_HANDLE(ic), \" 0x%02x\", (${regptr})[[byte_i]]);"])
			AS_ECHO(["    }"])
			AS_ECHO(["  } tme_m68k_log_finish(ic);"])
		    fi
		fi

		# perform any updating and value returning:
		case "$what" in
		stack)
		    if test $name = read; then dir="+"; else dir="-"; fi
		    AS_ECHO(["  if (!TME_M68K_SEQUENCE_RESTARTING) {"])
		    AS_ECHO(["    ic->tme_m68k_ireg_a7 ${dir}= sizeof(tme_uint${size}_t);"])
		    AS_ECHO(["  }"])
		    ;;
		inst)
		    AS_ECHO([""])
		    AS_ECHO(["  /* advance the offset in the instruction buffer for the next slow fetch: */"])
		    AS_ECHO(["  fetch_slow_next += sizeof(tme_uint${size}_t);"])
		    AS_ECHO(["  ic->_tme_m68k_insn_fetch_slow_next = fetch_slow_next;"])
		    AS_ECHO([""])
		    AS_ECHO(["  /* return the fetched value: */"])
		    AS_ECHO(["  return(mem_value);"])
		    ;;
		esac

		AS_ECHO(["}"])
	    :
	done

	# the general-purpose cycle-making read and write macros:
	if test ${size} != any; then

	    # if we're making the header, emit a macro:
	    if $header; then
		AS_ECHO(["#define tme_m68k_${name}${size}(ic, t, fc, la, _v, f) \\"])
		AS_ECHO(["  tme_m68k_${name}(ic, t, fc, la, (tme_uint8_t *) (_v), sizeof(tme_uint${size}_t), f)"])
	    fi
	else

	    # if we're making the header, just emit a declaration:
	    if $header; then
		AS_ECHO(["void tme_m68k_${name} _TME_P((struct tme_m68k *, struct tme_m68k_tlb *, unsigned int *, tme_uint32_t *, tme_uint8_t *, unsigned int, unsigned int));"])
		continue
	    fi

	    AS_ECHO([""])
	    AS_ECHO(["/* this ${name}s a region of address space using actual bus cycles: */"])
	    AS_ECHO(["void"])
	    AS_ECHO(["tme_m68k_${name}(struct tme_m68k *ic, "])
	    AS_ECHO(["              struct tme_m68k_tlb *tlb,"])
	    AS_ECHO(["              unsigned int *_function_code, "])
	    AS_ECHO(["              tme_uint32_t *_linear_address, "])
	    AS_ECHO(["              tme_uint8_t *reg,"])
	    AS_ECHO(["              unsigned int reg_size,"])
	    AS_ECHO(["              unsigned int flags)"])
	    AS_ECHO(["{"])

	    # our locals:
	    AS_ECHO(["  unsigned int function_code;"])
	    AS_ECHO(["  tme_uint32_t linear_address;"])
	    AS_ECHO(["  tme_bus_addr_t physical_address;"])
	    AS_ECHO(["  int shift;"])
	    AS_ECHO(["  struct tme_bus_cycle cycle;"])
	    AS_ECHO(["  unsigned int transferred, resid, cycle_size;"])
	    AS_ECHO(["  int exception;"])
	    AS_ECHO(["  int err;"])
	    AS_ECHO(["  tme_uint8_t *reg_p;"])
	    AS_ECHO(["  unsigned int buffer_i;"])
	    AS_ECHO(["  tme_uint8_t reg_buffer[[sizeof(tme_uint32_t) * 2]];"])
	    if test ${name} = read; then name_const_mem="const "; else name_const_mem= ; fi
	    AS_ECHO(["  ${name_const_mem}tme_shared tme_uint8_t *mem;"])

	    AS_ECHO([""])
	    AS_ECHO(["  /* if we're not restarting, everything is fresh: */"])
	    AS_ECHO(["  if (!TME_M68K_SEQUENCE_RESTARTING) {"])
	    AS_ECHO(["    function_code = *_function_code;"])
	    AS_ECHO(["    linear_address = *_linear_address;"])
	    AS_ECHO(["    transferred = 0;"])
	    AS_ECHO(["  }"])

	    AS_ECHO([""])
	    AS_ECHO(["  /* otherwise, if this is the transfer that faulted, restore"])
	    AS_ECHO(["     our state to the cycle that faulted, then take into account"])
	    AS_ECHO(["     any data provided by a software rerun of the faulted cycle: */"])
	    AS_ECHO(["  else if (ic->_tme_m68k_sequence._tme_m68k_sequence_transfer_faulted"])
	    AS_ECHO(["           == ic->_tme_m68k_sequence._tme_m68k_sequence_transfer_next) {"])
	    AS_ECHO(["    function_code = *_function_code = ic->_tme_m68k_group0_function_code;"])
	    AS_ECHO(["    linear_address = ic->_tme_m68k_group0_address;"])
	    AS_ECHO(["    transferred = ic->_tme_m68k_sequence._tme_m68k_sequence_transfer_faulted_after;"])
	    AS_ECHO(["    if (transferred >= reg_size) abort();"])
	    AS_ECHO(["    *_linear_address = linear_address - transferred;"])
	    AS_ECHO(["    resid = reg_size - transferred;"])
	    AS_ECHO(["    if (ic->_tme_m68k_group0_buffer_${name}_size > resid) abort();"])
	    AS_ECHO(["    if (ic->_tme_m68k_group0_buffer_${name}_softrr > resid) abort();"])
	    if test $name = read; then cmp=">"; else cmp="=="; fi
	    AS_ECHO(["    if (ic->_tme_m68k_group0_buffer_${name}_softrr ${cmp} 0) {"])
	    AS_ECHO(["#ifdef WORDS_BIGENDIAN"])
	    AS_ECHO(["      memcpy(reg + transferred, "])
	    AS_ECHO(["             ic->_tme_m68k_group0_buffer_${name},"])
	    AS_ECHO(["             ic->_tme_m68k_group0_buffer_${name}_size);"])
	    AS_ECHO(["#else  /* !WORDS_BIGENDIAN */"])
	    AS_ECHO(["      reg_p = (reg + reg_size - 1) - transferred;"])
	    AS_ECHO(["      for (buffer_i = 0;"])
	    AS_ECHO(["           buffer_i < ic->_tme_m68k_group0_buffer_${name}_size;"])
	    AS_ECHO(["           buffer_i++) {"])
	    AS_ECHO(["        *(reg_p--) = ic->_tme_m68k_group0_buffer_${name}[[buffer_i]];"])
	    AS_ECHO(["      }"])
	    AS_ECHO(["#endif /* !WORDS_BIGENDIAN */"])
	    AS_ECHO(["    }"])
	    AS_ECHO(["    transferred += ic->_tme_m68k_group0_buffer_${name}_softrr;"])
	    AS_ECHO(["  }"])

	    AS_ECHO([""])
	    AS_ECHO(["  /* otherwise, a later transfer has faulted.  just step the"])
	    AS_ECHO(["     transfer number and return: */"])
	    AS_ECHO(["  else {"])
	    AS_ECHO(["    TME_M68K_SEQUENCE_TRANSFER_STEP;"])
	    AS_ECHO(["    return;"])
	    AS_ECHO(["  }"])

	    AS_ECHO([""])
	    AS_ECHO(["  /* do as many bus cycles as needed to complete the transfer: */"])
	    AS_ECHO(["  exception = TME_M68K_EXCEPTION_NONE;"])
	    AS_ECHO(["  cycle_size = 0;"])
	    AS_ECHO(["  for(; transferred < reg_size; ) {"])
	    AS_ECHO(["    resid = reg_size - transferred;"])

	    AS_ECHO([""])
	    AS_ECHO(["    /* start the bus cycle structure: */"])
	    AS_ECHO(["    cycle.tme_bus_cycle_type = TME_BUS_CYCLE_${capname};"])
	    AS_ECHO(["    if (TME_ENDIAN_NATIVE == TME_ENDIAN_BIG"])
	    AS_ECHO(["        || (flags & TME_M68K_BUS_CYCLE_RAW)) {"])
	    AS_ECHO(["      cycle.tme_bus_cycle_buffer = reg + transferred;"])
	    AS_ECHO(["      cycle.tme_bus_cycle_buffer_increment = 1;"])
	    AS_ECHO(["    }"])
	    AS_ECHO(["    else {"])
	    AS_ECHO(["      cycle.tme_bus_cycle_buffer = reg + reg_size - (1 + transferred);"])
	    AS_ECHO(["      cycle.tme_bus_cycle_buffer_increment = -1;"])
	    AS_ECHO(["    }"])

	    AS_ECHO([""])
	    AS_ECHO(["    /* if we're emulating a CPU with a 16-bit bus interface: */"])
	    AS_ECHO(["    if (ic->_tme_m68k_bus_16bit) {"])
	    AS_ECHO([""])
	    AS_ECHO(["      /* if we're trying to transfer a non-power-of-two"])
	    AS_ECHO(["         number of bytes, either the CPU is broken (no"])
	    AS_ECHO(["         instructions ever transfer a non-power-of-two"])
	    AS_ECHO(["         number of bytes), or this function allowed an"])
	    AS_ECHO(["         unaligned transfer: */"])
	    AS_ECHO(["      assert((resid & (resid - 1)) == 0"])
	    AS_ECHO(["             || (flags & TME_M68K_BUS_CYCLE_RAW));"])
	    AS_ECHO([""])
	    AS_ECHO(["      /* only byte transfers can be unaligned: */"])
	    AS_ECHO(["      if (resid > sizeof(tme_uint8_t)"])
	    AS_ECHO(["          && (linear_address & 1)) {"])
	    AS_ECHO(["          exception = TME_M68K_EXCEPTION_AERR;"])
	    AS_ECHO(["          break;"])
	    AS_ECHO(["      }"])
	    AS_ECHO([""])
	    AS_ECHO(["      /* set the bus-size specific parts of the bus cycle structure: */"])
	    AS_ECHO(["      cycle_size = TME_MIN(resid, sizeof(tme_uint16_t));"])
	    AS_ECHO(["      cycle.tme_bus_cycle_size = cycle_size;"])
	    AS_ECHO(["      cycle.tme_bus_cycle_port = TME_BUS_CYCLE_PORT(0, TME_BUS16_LOG2);"])
	    AS_ECHO(["      cycle.tme_bus_cycle_lane_routing = "])
	    AS_ECHO(["        &tme_m68k_router_16[[TME_M68K_BUS_ROUTER_INDEX(TME_BUS16_LOG2, cycle_size, linear_address)]];"])
	    AS_ECHO(["    }"])
	    AS_ECHO([""])
	    AS_ECHO(["    /* otherwise we're emulating a CPU with a 32-bit bus interface: */"])
	    AS_ECHO(["    else {"])
	    if test $name = read; then
		AS_ECHO([""])
		AS_ECHO(["      /* an instruction fetch must be aligned: */"])
		AS_ECHO(["      if (flags & TME_M68K_BUS_CYCLE_FETCH) {"])
		AS_ECHO(["        if (linear_address & 1) {"])
		AS_ECHO(["          exception = TME_M68K_EXCEPTION_AERR;"])
		AS_ECHO(["          break;"])
		AS_ECHO(["        }"])
		AS_ECHO(["        assert(!(resid & 1));"])
		AS_ECHO(["      }"])
	    fi
	    AS_ECHO([""])
	    AS_ECHO(["      /* set the bus-size specific parts of the bus cycle structure: */"])
	    AS_ECHO(["      cycle_size = TME_MIN(resid, sizeof(tme_uint32_t) - (linear_address & (sizeof(tme_uint32_t) - 1)));"])
	    AS_ECHO(["      cycle.tme_bus_cycle_size = cycle_size;"])
	    AS_ECHO(["      cycle.tme_bus_cycle_port = TME_BUS_CYCLE_PORT(0, TME_BUS32_LOG2);"])
	    AS_ECHO(["      cycle.tme_bus_cycle_lane_routing = "])
	    AS_ECHO(["        &tme_m68k_router_32[[TME_M68K_BUS_ROUTER_INDEX(TME_BUS32_LOG2, cycle_size, linear_address)]];"])
	    AS_ECHO(["    }"])
	
	    AS_ECHO([""])
	    AS_ECHO(["    /* loop while this TLB entry is invalid or does not apply: */"])
	    AS_ECHO(["    for (; __tme_predict_false(tme_m68k_tlb_is_invalid(tlb)"])
	    AS_ECHO(["                               || tlb->tme_m68k_tlb_bus_context != ic->_tme_m68k_bus_context"])
	    AS_ECHO(["                               || (tlb->tme_m68k_tlb_function_codes_mask & TME_BIT(function_code)) == 0"])
	    AS_ECHO(["                               || linear_address < (tme_bus_addr32_t) tlb->tme_m68k_tlb_linear_first"])
	    AS_ECHO(["                               || linear_address > (tme_bus_addr32_t) tlb->tme_m68k_tlb_linear_last"])
	    AS_ECHO(["                               || (tlb->tme_m68k_tlb_emulator_off_${name} == TME_EMULATOR_OFF_UNDEF"])
	    AS_ECHO(["                                   && (tlb->tme_m68k_tlb_cycles_ok & TME_BUS_CYCLE_${capname}) == 0)); ) {"])
	    AS_ECHO([""])
	    AS_ECHO(["      /* this must not be part of a read/modify/write cycle: */"])
	    AS_ECHO(["      assert(!(flags & TME_M68K_BUS_CYCLE_RMW));"])
	    AS_ECHO([""])
	    AS_ECHO(["      /* fill this TLB entry: */"])
	    AS_ECHO(["      tme_m68k_tlb_fill(ic, tlb,"])
	    AS_ECHO(["                        function_code,"])
	    AS_ECHO(["                        linear_address,"])
	    AS_ECHO(["                        TME_BUS_CYCLE_${capname});"])
	    AS_ECHO(["    }"])
	    AS_ECHO([""])
	    AS_ECHO(["    /* if this TLB entry allows for fast ${name}s: */"])
	    AS_ECHO(["    mem = tlb->tme_m68k_tlb_emulator_off_${name};"])
	    AS_ECHO(["    if (__tme_predict_true(mem != TME_EMULATOR_OFF_UNDEF)) {"])
	    AS_ECHO([""])
	    AS_ECHO(["      /* make the emulator memory pointer: */"])
	    AS_ECHO(["      mem += linear_address;"])
	    AS_ECHO([""])
	    AS_ECHO(["      /* limit the cycle size to addresses covered by the TLB entry: */"])
	    AS_ECHO(["      if (__tme_predict_false((cycle_size - 1)"])
	    AS_ECHO(["                              > (((tme_bus_addr32_t) tlb->tme_m68k_tlb_linear_last) - linear_address))) {"])
	    AS_ECHO(["        cycle_size = (((tme_bus_addr32_t) tlb->tme_m68k_tlb_linear_last) - linear_address) + 1;"])
	    AS_ECHO(["      }"])
	    AS_ECHO([""])
	    AS_ECHO(["      /* if this is a little-endian host, and this isn't a raw ${name}: */"])
	    AS_ECHO(["      if (TME_ENDIAN_NATIVE == TME_ENDIAN_LITTLE"])
	    AS_ECHO(["          && (flags & TME_M68K_BUS_CYCLE_RAW) == 0) {"])
	    if test ${name} = write; then
		AS_ECHO([""])
		AS_ECHO(["        /* byteswap the data to write in the intermediate buffer: */"])
		AS_ECHO(["        reg_p = cycle.tme_bus_cycle_buffer;"])
		AS_ECHO(["        buffer_i = 0;"])
		AS_ECHO(["        do {"])
		AS_ECHO(["          reg_buffer[[buffer_i]] = *(reg_p--);"])
		AS_ECHO(["        } while (++buffer_i != cycle_size);"])
	    fi
	    AS_ECHO([""])
	    AS_ECHO(["        /* use the intermediate buffer for the ${name}: */"])
	    AS_ECHO(["        cycle.tme_bus_cycle_buffer = &reg_buffer[[0]];"])
	    AS_ECHO(["      }"])
	    AS_ECHO([""])
	    AS_ECHO(["      /* do the bus ${name}: */"])
	    AS_ECHO(["      tme_memory_bus_${name}_buffer(mem,"])
	    AS_ECHO(["                                 cycle.tme_bus_cycle_buffer,"])
	    AS_ECHO(["                                 cycle_size,"])
	    AS_ECHO(["                                 tlb->tme_m68k_tlb_bus_rwlock,"])
	    AS_ECHO(["                                 sizeof(tme_uint8_t),"])
	    AS_ECHO(["                                 sizeof(tme_uint32_t));"])
	    if test ${name} = read; then
		AS_ECHO([""])
		AS_ECHO(["      /* if this is a little-endian host, and this isn't a raw ${name}: */"])
		AS_ECHO(["      if (TME_ENDIAN_NATIVE == TME_ENDIAN_LITTLE"])
		AS_ECHO(["          && (flags & TME_M68K_BUS_CYCLE_RAW) == 0) {"])
		AS_ECHO([""])
		AS_ECHO(["        /* byteswap the read data in the intermediate buffer: */"])
		AS_ECHO(["        reg_p = reg + reg_size - (1 + transferred);"])
		AS_ECHO(["        buffer_i = 0;"])
		AS_ECHO(["        do {"])
		AS_ECHO(["          *(reg_p--) = reg_buffer[[buffer_i]];"])
		AS_ECHO(["        } while (++buffer_i != cycle_size);"])
		AS_ECHO(["      }"])
	    fi
	    AS_ECHO([""])
	    AS_ECHO(["      /* update: */"])
	    AS_ECHO(["      linear_address += cycle_size;"])
	    AS_ECHO(["      transferred += cycle_size;"])
	    AS_ECHO(["      continue;"])
	    AS_ECHO(["    }"])
	    AS_ECHO([""])
	    AS_ECHO(["    /* otherwise, this TLB entry does not allow for fast ${name}s: */"])
	    AS_ECHO([""])
	    AS_ECHO(["    /* if this is a part of a read/modify/write cycle: */"])
	    AS_ECHO(["    if (flags & TME_M68K_BUS_CYCLE_RMW) {"])
	    AS_ECHO([""])
	    if test ${name} = read; then
		AS_ECHO(["      /* if this is the first cycle in this read,"])
		AS_ECHO(["         we will establish the new lock, otherwise"])
		AS_ECHO(["         we will continue using the existing lock: */"])
	    else
		AS_ECHO(["      /* we will continue using the existing lock."])
		AS_ECHO(["         the device will automatically unlock after"])
		AS_ECHO(["         the last cycle of this write: */"])
	    fi
	    AS_ECHO(["      cycle.tme_bus_cycle_type"])
	    AS_ECHO(["        |= (TME_BUS_CYCLE_LOCK"])
	    AS_ECHO_N(["            | ("])
	    if test ${name} = read; then
		AS_ECHO_N(["transferred == 0 ? 0 : "])
	    fi
	    AS_ECHO(["TME_BUS_CYCLE_UNLOCK));"])
	    AS_ECHO(["    }"])

	    AS_ECHO([""])
	    AS_ECHO(["    /* form the physical address for the bus cycle handler: */"])
	    AS_ECHO(["    physical_address = tlb->tme_m68k_tlb_addr_offset + linear_address;"])
	    AS_ECHO(["    shift = tlb->tme_m68k_tlb_addr_shift;"])
	    AS_ECHO(["    if (shift < 0) {"])
	    AS_ECHO(["      physical_address <<= (0 - shift);"])
	    AS_ECHO(["    }"])
	    AS_ECHO(["    else if (shift > 0) {"])
	    AS_ECHO(["      physical_address >>= shift;"])
	    AS_ECHO(["    }"])
	    AS_ECHO(["    cycle.tme_bus_cycle_address = physical_address;"])

	    AS_ECHO([""])
	    AS_ECHO(["    /* run the bus cycle: */"])
	    AS_ECHO(["    tme_m68k_tlb_unbusy(tlb);"])
	    AS_ECHO(["    tme_m68k_callout_unlock(ic);"])
	    AS_ECHO(["    err = (*tlb->tme_m68k_tlb_bus_tlb.tme_bus_tlb_cycle)"])
	    AS_ECHO(["         (tlb->tme_m68k_tlb_bus_tlb.tme_bus_tlb_cycle_private, &cycle);"])
	    AS_ECHO(["    tme_m68k_callout_relock(ic);"])
	    AS_ECHO(["    tme_m68k_tlb_busy(tlb);"])
	    AS_ECHO([""])
	    AS_ECHO(["    /* if the TLB entry was invalidated before the ${name}: */"])
	    AS_ECHO(["    if (err == EBADF"])
	    AS_ECHO(["        && tme_m68k_tlb_is_invalid(tlb)) {"])
	    AS_ECHO(["      cycle.tme_bus_cycle_size = 0;"])
	    AS_ECHO(["    }"])
	    AS_ECHO([""])
	    AS_ECHO(["    /* otherwise, if we didn't get a bus error, but some"])
	    AS_ECHO(["       synchronous event has happened: */"])
	    AS_ECHO(["    else if (err == TME_BUS_CYCLE_SYNCHRONOUS_EVENT) {"])
	    AS_ECHO([""])
	    AS_ECHO(["      /* after the currently executing instruction finishes, check"])
	    AS_ECHO(["         for external resets, halts, or interrupts: */"])
	    AS_ECHO(["      ic->_tme_m68k_instruction_burst_remaining = 0;"])
	    AS_ECHO(["    }"])
	    AS_ECHO([""])
	    AS_ECHO(["    /* otherwise, any other error might be a bus error: */"])
	    AS_ECHO(["    else if (err != TME_OK) {"])
	    AS_ECHO(["      err = tme_bus_tlb_fault(&tlb->tme_m68k_tlb_bus_tlb, &cycle, err);"])
	    AS_ECHO(["      if (err != TME_OK) {"])
	    AS_ECHO(["        exception = TME_M68K_EXCEPTION_BERR;"])
	    AS_ECHO(["        break;"])
	    AS_ECHO(["      }"])
	    AS_ECHO(["    }"])
	    AS_ECHO([""])
	    AS_ECHO(["    /* update: */"])
	    AS_ECHO(["    linear_address += cycle.tme_bus_cycle_size;"])
	    AS_ECHO(["    transferred += cycle.tme_bus_cycle_size;"])
	    AS_ECHO(["  }"])
       
	    AS_ECHO([""])
	    AS_ECHO(["  /* NB: there is no need to explicitly unlock"])
	    AS_ECHO(["     a device.  if a locked bus cycle to a device"])
	    AS_ECHO(["     faults, the lock must be automatically unlocked: */"])

	    AS_ECHO([""])
	    AS_ECHO(["  /* if we faulted, stash the information the fault stacker"])
	    AS_ECHO(["     will need and start exception processing: */"])
	    AS_ECHO(["  if (exception != TME_M68K_EXCEPTION_NONE) {"])
	    AS_ECHO_N(["    ic->_tme_m68k_group0_flags = flags"])
	    if test $name = read; then
		AS_ECHO_N([" | TME_M68K_BUS_CYCLE_READ"])
	    fi
	    AS_ECHO([";"])
	    AS_ECHO(["    ic->_tme_m68k_group0_function_code = function_code;"])
	    AS_ECHO(["    ic->_tme_m68k_group0_address = linear_address;"])
	    AS_ECHO(["    ic->_tme_m68k_group0_sequence = ic->_tme_m68k_sequence;"])
	    AS_ECHO(["    ic->_tme_m68k_group0_sequence._tme_m68k_sequence_transfer_faulted_after = transferred;"])
	    AS_ECHO(["    ic->_tme_m68k_group0_buffer_${name}_size = cycle_size;"])
	    if test $name = write; then
		AS_ECHO(["#ifdef WORDS_BIGENDIAN"])
		AS_ECHO(["    memcpy(ic->_tme_m68k_group0_buffer_${name},"])
		AS_ECHO(["           reg + transferred,"])
		AS_ECHO(["           ic->_tme_m68k_group0_buffer_${name}_size);"])
		AS_ECHO(["#else  /* !WORDS_BIGENDIAN */"])
		AS_ECHO(["      reg_p = (reg + reg_size - 1) - transferred;"])
		AS_ECHO(["      for (buffer_i = 0;"])
		AS_ECHO(["           buffer_i < ic->_tme_m68k_group0_buffer_${name}_size;"])
		AS_ECHO(["           buffer_i++) {"])
		AS_ECHO(["        ic->_tme_m68k_group0_buffer_${name}[[buffer_i]] = *(reg_p--);"])
		AS_ECHO(["      }"])
		AS_ECHO(["#endif /* !WORDS_BIGENDIAN */"])
	    fi
	    AS_ECHO(["    if (ic->_tme_m68k_group0_hook != NULL) {"])
	    AS_ECHO(["      (*ic->_tme_m68k_group0_hook)(ic);"])
	    AS_ECHO(["    }"])
	    AS_ECHO(["    ic->_tme_m68k_group0_sequence._tme_m68k_sequence_transfer_faulted = ";])
	    AS_ECHO(["      ic->_tme_m68k_group0_sequence._tme_m68k_sequence_transfer_next;"])
	    AS_ECHO(["    tme_m68k_tlb_unbusy(tlb);"])
	    AS_ECHO(["    tme_m68k_exception(ic, exception);"])
	    AS_ECHO(["  }"])

	    AS_ECHO([""])
	    AS_ECHO(["  /* otherwise, this transfer has now completed: */"])
	    AS_ECHO(["  TME_M68K_SEQUENCE_TRANSFER_STEP;"])

	    AS_ECHO(["}"])
	fi
    done

done

# generate the BCD math functions:
for name in abcd sbcd nbcd; do

    # if we're making the header, just emit a declaration:
    if $header; then
	AS_ECHO(["TME_M68K_INSN_DECL(tme_m68k_${name});"])
	continue
    fi

    # emit the function:
    AS_ECHO([""])
    AS_ECHO(["TME_M68K_INSN(tme_m68k_${name})"])
    AS_ECHO(["{"])
    AS_ECHO(["  tme_uint8_t dst, dst_msd, dst_lsd;"])
    AS_ECHO(["  tme_uint8_t src, src_msd, src_lsd;"])
    AS_ECHO(["  tme_uint8_t res, res_msd, res_lsd;"])
    AS_ECHO(["  tme_uint8_t flags;"])

    # get the operands:
    if test $name != nbcd; then
	AS_ECHO(["  int memory;"])
	AS_ECHO(["  int rx, ry, function_code;"])
	AS_ECHO([""])
	AS_ECHO(["  /* load the operands: */"])
	AS_ECHO(["  rx = TME_FIELD_EXTRACTU(TME_M68K_INSN_OPCODE, 0, 3);"])
	AS_ECHO(["  ry = TME_FIELD_EXTRACTU(TME_M68K_INSN_OPCODE, 9, 3);"])
	AS_ECHO(["  memory = (TME_M68K_INSN_OPCODE & TME_BIT(3)) != 0;"])
	AS_ECHO(["  function_code = TME_M68K_FUNCTION_CODE_DATA(ic);"])
	AS_ECHO(["  if (memory) {"])
	AS_ECHO(["    TME_M68K_INSN_CANFAULT;"])
	AS_ECHO(["    if (!TME_M68K_SEQUENCE_RESTARTING) {"])
	# the stack pointer must always be decremented by a multiple of two.
	# assuming rx < 8, ((rx + 1) >> 3) == 1 iff rx == 7, meaning %a7:
	AS_ECHO(["      ic->tme_m68k_ireg_uint32(TME_M68K_IREG_A0 + rx) -= sizeof(tme_uint8_t) + ((rx + 1) >> 3);"])
	AS_ECHO(["      ic->_tme_m68k_ea_function_code = function_code;"])
	AS_ECHO(["      ic->_tme_m68k_ea_address = ic->tme_m68k_ireg_uint32(TME_M68K_IREG_A0 + rx);"])
	AS_ECHO(["    }"])
	AS_ECHO(["    tme_m68k_read_memx8(ic);"])
	AS_ECHO(["    if (!TME_M68K_SEQUENCE_RESTARTING) {"])
	# the stack pointer must always be incremented by a multiple of two.
	# assuming rx < 8, ((rx + 1) >> 3) == 1 iff rx == 7, meaning %a7:
	AS_ECHO(["      ic->tme_m68k_ireg_uint32(TME_M68K_IREG_A0 + ry) -= sizeof(tme_uint8_t) + ((ry + 1) >> 3);"])
	AS_ECHO(["      ic->_tme_m68k_ea_function_code = function_code;"])
	AS_ECHO(["      ic->_tme_m68k_ea_address = ic->tme_m68k_ireg_uint32(TME_M68K_IREG_A0 + ry);"])
	AS_ECHO(["    }"])
	AS_ECHO(["    tme_m68k_read_mem8(ic, TME_M68K_IREG_MEMY32);"])
	AS_ECHO(["    src = ic->tme_m68k_ireg_memx8;"])
	AS_ECHO(["    dst = ic->tme_m68k_ireg_memy8;"])
	AS_ECHO(["  }"])
	AS_ECHO(["  else {"])
	AS_ECHO(["    src = ic->tme_m68k_ireg_uint8(rx << 2);"])
	AS_ECHO(["    dst = ic->tme_m68k_ireg_uint8(ry << 2);"])
	AS_ECHO(["  }"])
    else
	AS_ECHO([""])
	AS_ECHO(["  dst = 0x00;"])
	AS_ECHO(["  src = TME_M68K_INSN_OP1(tme_uint8_t);"])
    fi
    AS_ECHO(["  dst_lsd = TME_FIELD_EXTRACTU(dst, 0, 4);"])
    AS_ECHO(["  dst_msd = TME_FIELD_EXTRACTU(dst, 4, 4);"])
    AS_ECHO(["  src_lsd = TME_FIELD_EXTRACTU(src, 0, 4);"])
    AS_ECHO(["  src_msd = TME_FIELD_EXTRACTU(src, 4, 4);"])

    # perform the operation:
    AS_ECHO([""])
    AS_ECHO(["  /* perform the operation: */"])
    if test $name = abcd; then op='+' ; opc='-' ; else op='-' ; opc='+' ; fi])
    AS_ECHO(["  res_lsd = dst_lsd ${op} src_lsd ${op} ((ic->tme_m68k_ireg_ccr & TME_M68K_FLAG_X) != 0);"])
    AS_ECHO(["  res_msd = dst_msd ${op} src_msd;"])
    AS_ECHO(["  flags = 0;"])
    AS_ECHO(["  if (res_lsd > 9) {"])
    AS_ECHO(["    res_lsd ${opc}= 10;"])
    AS_ECHO(["    res_msd ${op}= 1;"])
    AS_ECHO(["  }"])
    AS_ECHO(["  if (res_msd > 9) {"])
    AS_ECHO(["    res_msd ${opc}= 10;"])
    AS_ECHO(["    flags |= TME_M68K_FLAG_C | TME_M68K_FLAG_X;"])
    AS_ECHO(["  }"])
    AS_ECHO(["  res = (res_msd << 4) + (res_lsd & 0xf);"])
    AS_ECHO(["  if (res == 0) flags |= TME_M68K_FLAG_N;"])
    AS_ECHO([""])

    # store the result
    AS_ECHO(["  /* store the result and set the flags: */"])
    if test $name != nbcd; then
	AS_ECHO(["  if (memory) {"])
	AS_ECHO(["    if (!TME_M68K_SEQUENCE_RESTARTING) {"])
	AS_ECHO(["      ic->tme_m68k_ireg_memx8 = res;"])
	AS_ECHO(["      ic->_tme_m68k_ea_function_code = function_code;"])
	AS_ECHO(["      ic->_tme_m68k_ea_address = ic->tme_m68k_ireg_uint32(TME_M68K_IREG_A0 + ry);"])
	AS_ECHO(["      ic->tme_m68k_ireg_ccr = flags;"])
	AS_ECHO(["     }"])
	AS_ECHO(["     tme_m68k_write_memx8(ic);"])
	AS_ECHO(["  }"])
	AS_ECHO(["  else {"])
	AS_ECHO(["    ic->tme_m68k_ireg_uint8(ry << 2) = res;"])
	AS_ECHO(["    ic->tme_m68k_ireg_ccr = flags;"])
	AS_ECHO(["  }"])
    else
	AS_ECHO(["  TME_M68K_INSN_OP1(tme_uint8_t) = res;"])
	AS_ECHO(["  ic->tme_m68k_ireg_ccr = flags;"])
    fi
    AS_ECHO([""])
    AS_ECHO(["  TME_M68K_INSN_OK;"])
    AS_ECHO(["}"])
done

# generate the ccr and sr functions:
for reg in ccr sr; do
    for name in ori andi eori move_to; do
	if test $reg = ccr; then size=8 ; else size=16 ; fi

	# if we're making the header, just emit a declaration:
	if $header; then
	    AS_ECHO(["TME_M68K_INSN_DECL(tme_m68k_${name}_${reg});"])
	    continue
	fi

	# emit the function:
	AS_ECHO([""])
	AS_ECHO(["TME_M68K_INSN(tme_m68k_${name}_${reg})"])
	AS_ECHO(["{"])
	AS_ECHO(["  tme_uint${size}_t reg;"])

	# form the new register value:
	src=0
	AS_ECHO_N(["  reg = "])
	case $name in
	ori) AS_ECHO_N(["ic->tme_m68k_ireg_${reg} | "]) ;;
	andi) AS_ECHO_N(["ic->tme_m68k_ireg_${reg} & "]) ;;
	eori) AS_ECHO_N(["ic->tme_m68k_ireg_${reg} ^ "]) ;;
	move_to) size=16 ; src=1 ;;
	esac
	AS_ECHO(["(TME_M68K_INSN_OP${src}(tme_uint${size}_t) & TME_M68K_FLAG_"])`AS_ECHO([$reg | tr a-z A-Z`");"])
	
	# sr changes are special:
	if test $reg = sr; then
	    AS_ECHO(["  TME_M68K_INSN_PRIV;"])
	    AS_ECHO(["  TME_M68K_INSN_CHANGE_SR(reg);"])
	else
	    AS_ECHO(["  ic->tme_m68k_ireg_${reg} = reg;"])
	fi

	AS_ECHO(["  TME_M68K_INSN_OK;"])
	AS_ECHO(["}"])
    done
done

# generate the multiply and divide instructions:

# permute on signed vs. unsigned:
for _sign in u s; do
    if test $_sign = u; then sign=u; else sign=; fi

    # permute on short vs. long:
    for size in s l; do
	if test $size = s; then 
	    _size=
	    small=16
	    large=32
	    reg_size_shift=' << 1'
	else
	    _size=l
	    small=32
	    large=64
	    reg_size_shift=
	fi

	# if we're making the header, just emit declarations:
	if $header; then
	    AS_ECHO(["TME_M68K_INSN_DECL(tme_m68k_mul${_sign}${_size});"])
	    AS_ECHO(["TME_M68K_INSN_DECL(tme_m68k_div${_sign}${_size});"])
	    continue
	fi

	# emit the multiply function:
	AS_ECHO([""])
	AS_ECHO(["TME_M68K_INSN(tme_m68k_mul${_sign}${_size})"])
	AS_ECHO(["{"])
 	if test $large = 64; then
	    AS_ECHO(["#ifndef TME_HAVE_INT${large}_T"])
	    AS_ECHO(["  abort();"])
	    AS_ECHO(["#else /* TME_HAVE_INT${large}_T */"])
	    AS_ECHO(["  unsigned int flag_v;"])
	    AS_ECHO(["  int ireg_dh;"])
	fi
	AS_ECHO(["  int ireg_dl;"])
	AS_ECHO(["  tme_${sign}int${large}_t res;"])
	AS_ECHO(["  tme_uint8_t flags;"])

	AS_ECHO([""])
	AS_ECHO(["  /* get the register containing the factor: */"])
	AS_ECHO_N(["  ireg_dl = TME_M68K_IREG_D0 + "])
	if test $size = s; then
	    AS_ECHO(["TME_M68K_INSN_OP0(tme_uint32_t);"])
	else
	    AS_ECHO(["TME_FIELD_EXTRACTU(TME_M68K_INSN_SPECOP, 12, 3);"])
	fi

	AS_ECHO([""])
	AS_ECHO(["  /* perform the multiplication: */"])
	AS_ECHO(["  res = (((tme_${sign}int${large}_t) ic->tme_m68k_ireg_${sign}int${small}(ireg_dl${reg_size_shift}))"])
	AS_ECHO(["         * TME_M68K_INSN_OP1(tme_${sign}int${small}_t));"])
	
	AS_ECHO([""])
	AS_ECHO(["  /* store the result: */"])
	AS_ECHO(["  ic->tme_m68k_ireg_${sign}int32(ireg_dl) = (tme_${sign}int32_t) res;"])
	if test $large = 64; then
	    AS_ECHO(["  flag_v = TME_M68K_FLAG_V;"])
	    AS_ECHO(["  if (TME_M68K_INSN_SPECOP & TME_BIT(10)) {"])
	    AS_ECHO(["    flag_v = 0;"])
	    AS_ECHO(["    ireg_dh = TME_M68K_IREG_D0 + TME_FIELD_EXTRACTU(TME_M68K_INSN_SPECOP, 0, 3);"])
	    AS_ECHO(["    ic->tme_m68k_ireg_${sign}int32(ireg_dh) = (tme_${sign}int32_t) (res >> 32);"])
	    AS_ECHO(["  }"])
	fi
	
	AS_ECHO([""])
	AS_ECHO(["  /* set the flags: */"])
	AS_ECHO(["  flags = ic->tme_m68k_ireg_ccr & TME_M68K_FLAG_X;"])
	AS_ECHO(["  if (((tme_int${large}_t) res) < 0) flags |= TME_M68K_FLAG_N;"])
	AS_ECHO(["  if (res == 0) flags |= TME_M68K_FLAG_Z;"])
	if test $large = 64; then
	    if test $_sign = s; then
		AS_ECHO_N(["  if (res > 0x7fffffffL || res < ((0L - 0x7fffffffL) - 1L)"])
	    else
		AS_ECHO_N(["  if (res > 0xffffffffUL"])
	    fi
	    AS_ECHO([") flags |= flag_v;"])
	fi
	AS_ECHO(["  ic->tme_m68k_ireg_ccr = flags;"])

	AS_ECHO([""])
	AS_ECHO(["  TME_M68K_INSN_OK;"])
 	if test $large = 64; then
	    AS_ECHO(["#endif /* TME_HAVE_INT${large}_T */"])
	fi
	AS_ECHO(["}"])

	# emit the divide function:
	AS_ECHO([""])
	AS_ECHO(["TME_M68K_INSN(tme_m68k_div${_sign}${_size})"])
	AS_ECHO(["{"])
 	if test $large = 64; then
	    AS_ECHO(["#ifndef TME_HAVE_INT${large}_T"])
	    AS_ECHO(["  abort();"])
	    AS_ECHO(["#else /* TME_HAVE_INT${large}_T */"])
	    AS_ECHO(["  int ireg_dr;"])
	fi
	AS_ECHO(["  int ireg_dq;"])
	AS_ECHO(["  tme_${sign}int${large}_t dividend, quotient;"])
	AS_ECHO(["  tme_${sign}int${small}_t divisor, remainder;"])
	AS_ECHO(["  tme_uint8_t flags;"])

	AS_ECHO([""])
	AS_ECHO(["  /* get the register(s): */"])
	AS_ECHO_N(["  ireg_dq = TME_M68K_IREG_D0 + "])
	if test $size = s; then
	    AS_ECHO(["TME_M68K_INSN_OP0(tme_uint32_t);"])
	else
	    AS_ECHO(["TME_FIELD_EXTRACTU(TME_M68K_INSN_SPECOP, 12, 3);"])
	    AS_ECHO(["  ireg_dr = TME_M68K_IREG_D0 + TME_FIELD_EXTRACTU(TME_M68K_INSN_SPECOP, 0, 3);"])
	fi

	AS_ECHO([""])
	AS_ECHO(["  /* form the dividend and the divisor: */"])
	if test $large = 64; then
	    AS_ECHO(["  if (TME_M68K_INSN_SPECOP & TME_BIT(10)) {"])
	    AS_ECHO(["    dividend = (tme_${sign}int${large}_t)"])
	    AS_ECHO(["               ((((tme_uint${large}_t) ic->tme_m68k_ireg_uint32(ireg_dr)) << 32)"])
	    AS_ECHO(["                | ic->tme_m68k_ireg_uint32(ireg_dq));"])
	    AS_ECHO(["  }"])
	    AS_ECHO(["  else"])
	    AS_ECHO_N(["  "])
	fi
	AS_ECHO(["  dividend = (tme_${sign}int${large}_t) ic->tme_m68k_ireg_${sign}int32(ireg_dq);"])
	AS_ECHO(["  divisor = TME_M68K_INSN_OP1(tme_${sign}int${small}_t);"])
	AS_ECHO(["  if (divisor == 0) {"])
	AS_ECHO(["    ic->tme_m68k_ireg_pc_last = ic->tme_m68k_ireg_pc;"])
	AS_ECHO(["    ic->tme_m68k_ireg_pc = ic->tme_m68k_ireg_pc_next;"])
	AS_ECHO(["    TME_M68K_INSN_EXCEPTION(TME_M68K_EXCEPTION_INST(TME_M68K_VECTOR_DIV0));"])
	AS_ECHO(["  }"])

	AS_ECHO([""])
	AS_ECHO(["  /* do the division: */"])
	AS_ECHO(["  quotient = dividend / divisor;"])
	AS_ECHO(["  remainder = dividend % divisor;"])

	AS_ECHO([""])
	AS_ECHO(["  /* set the flags and return the quotient and remainder: */"])
	AS_ECHO(["  flags = ic->tme_m68k_ireg_ccr & TME_M68K_FLAG_X;"])
	AS_ECHO_N(["  if ("])
	case "${small}${_sign}" in
	16s) AS_ECHO_N(["quotient > 0x7fff || quotient < -32768"]) ;;
	16u) AS_ECHO_N(["quotient > 0xffff"]) ;;
	32s) AS_ECHO_N(["quotient > 0x7fffffffL || quotient < ((0L - 0x7fffffffL) - 1L)"]) ;;
	32u) AS_ECHO_N(["quotient > 0xffffffffUL"]) ;;
	esac
	AS_ECHO([") {"])
	AS_ECHO(["    flags |= TME_M68K_FLAG_V;"])
	AS_ECHO(["  }"])
	AS_ECHO(["  else {"])
	AS_ECHO(["    if (((tme_int${small}_t) quotient) < 0) flags |= TME_M68K_FLAG_N;"])
	AS_ECHO(["    if (quotient == 0) flags |= TME_M68K_FLAG_Z;"])
	AS_ECHO(["    ic->tme_m68k_ireg_${sign}int${small}(ireg_dq${reg_size_shift}) = (tme_${sign}int${small}_t) quotient;"])
	if test $small = 16; then
	    AS_ECHO(["    ic->tme_m68k_ireg_${sign}int${small}((ireg_dq${reg_size_shift}) + 1) = remainder;"])
	else
	    AS_ECHO(["    if (ireg_dr != ireg_dq) {"])
	    AS_ECHO(["      ic->tme_m68k_ireg_${sign}int${small}(ireg_dr) = remainder;"])
	    AS_ECHO(["    }"])
	fi
	AS_ECHO(["  }"])
	AS_ECHO(["  ic->tme_m68k_ireg_ccr = flags;"])

	AS_ECHO([""])
	AS_ECHO(["  TME_M68K_INSN_OK;"])
 	if test $large = 64; then
	    AS_ECHO(["#endif /* TME_HAVE_INT${large}_T */"])
	fi
	AS_ECHO(["}"])

    done
done

# done:
exit 0
