-- Build SQLite3 Multiple Ciphers
--   static or shared library
--   Encryption support for Multiple Ciphers
--   Debug or Release
--   Win32 or Win64

dofile "wx_config.lua"

-- Target directory for the build files generated by premake5
newoption {
  trigger     = "builddir",
  value       = "build",
  description = "Directory for the generated build files"
}

BUILDDIR = _OPTIONS["builddir"] or "build"

-- SQLite3MultipleCiphers workspace

workspace "sqlite3mc"

  if (is_msvc) then
    local wks = workspace()
    wks.filename = "sqlite3mc_" .. vc_with_ver
  end

  wxWorkspaceCommon()

-- SQLite3 static library
project "sqlite3mc_lib"
  language "C++"
  kind "StaticLib"

  if (is_msvc) then
    local prj = project()
    prj.filename = "sqlite3mc_" .. vc_with_ver .. "_lib"
    if (msvc_useProps) then
      wxUseProps(true)
    end
  else
    toolset("gcc")
    buildoptions { "-msse4.2", "-maes" }
--    buildoptions { "-march=native" }
  end
  makesettings { "include config.gcc" }

  files { "src/sqlite3mc.c", "src/*.h" }
  vpaths {
    ["Header Files"] = { "**.h" },
    ["Source Files"] = { "**/sqlite3mc.c", "**.def", "**.rc" }
  }
  characterset ("Unicode")
  staticruntime "On"
  includedirs { "src" }

  location( BUILDDIR )
  targetname "sqlite3mc"

  defines {
    "_LIB",
    "CODEC_TYPE=$(CODEC_TYPE)",
    "SQLITE_ENABLE_DEBUG=$(SQLITE_ENABLE_DEBUG)",
    "SQLITE_THREADSAFE=1",
    "SQLITE_DQS=0",
    "SQLITE_MAX_ATTACHED=10",
    "SQLITE_ENABLE_EXPLAIN_COMMENTS=1",
    "SQLITE_SOUNDEX=1",
    "SQLITE_ENABLE_COLUMN_METADATA=1",
    "SQLITE_SECURE_DELETE=1",
    "SQLITE_ENABLE_DESERIALIZE=1",
    "SQLITE_ENABLE_FTS3=1",
    "SQLITE_ENABLE_FTS3_PARENTHESIS=1",
    "SQLITE_ENABLE_FTS4=1",
    "SQLITE_ENABLE_FTS5=1",
    "SQLITE_ENABLE_RTREE=1",
    "SQLITE_ENABLE_GEOPOLY=1",
    "SQLITE_ENABLE_PREUPDATE_HOOK=1",
    "SQLITE_ENABLE_SESSION=1",
    "SQLITE_CORE=1",
    "SQLITE_ENABLE_EXTFUNC=1",
    "SQLITE_ENABLE_MATH_FUNCTIONS=1",
    "SQLITE_ENABLE_CSV=1",
    "SQLITE_ENABLE_VSV=1",
--    "SQLITE_ENABLE_SHA3=1",
    "SQLITE_ENABLE_CARRAY=1",
--    "SQLITE_ENABLE_FILEIO=1",
--    "SQLITE_ENABLE_SERIES=1",
    "SQLITE_ENABLE_UUID=1",
--    "SQLITE_ENABLE_REGEXP=1",
--    "SQLITE3MC_USE_MINIZ=$(SQLITE3MC_USE_MINIZ)",
--    "SQLITE_ENABLE_COMPRESS=1"
--    "SQLITE_ENABLE_SQLAR=1"
--    "SQLITE_ENABLE_ZIPFILE=1"
    "SQLITE3MC_SECURE_MEMORY=$(SQLITE3MC_SECURE_MEMORY)",
    "SQLITE_TEMP_STORE=2",
    "SQLITE_USE_URI=1",
    "SQLITE_USER_AUTHENTICATION=0",
-- Compatibility with official SQLite3 shell
    "SQLITE_ENABLE_DBPAGE_VTAB=1",
    "SQLITE_ENABLE_DBSTAT_VTAB=1",
    "SQLITE_ENABLE_STMTVTAB=1",
    "SQLITE_ENABLE_UNKNOWN_SQL_FUNCTION=1"
  }

  -- Intermediate directory
  if (is_msvc) then
    objdir (BUILDDIR .. "/obj/" .. vc_with_ver)
  else
    objdir (BUILDDIR .. "/obj/gcc")
  end
  -- Target directory
  filter { "configurations:Debug*" }
    if (is_msvc) then
      targetdir ("bin/" .. vc_with_ver .. "/lib/debug")
    else
      targetdir "bin/gcc/lib/debug"
    end
  filter { "configurations:Release*" }
    if (is_msvc) then
      targetdir ("bin/" .. vc_with_ver .. "/lib/release")
    else
      targetdir "bin/gcc/lib/release"
    end

-- SQLite3 shared library
project "sqlite3mc_dll"
  language "C++"
  kind "SharedLib"

  if (is_msvc) then
    local prj = project()
    prj.filename = "sqlite3mc_" .. vc_with_ver .. "_dll"
    if (msvc_useProps) then
      wxUseProps(true)
    end
  else
    toolset("gcc")
    buildoptions { "-msse4.2", "-maes" }
--    buildoptions { "-march=native" }
  end
  makesettings { "include config.gcc" }

  files { "src/sqlite3mc.c", "src/*.h", "src/sqlite3mc.rc" }
  filter {}
  vpaths {
    ["Header Files"] = { "**.h" },
    ["Source Files"] = { "**/sqlite3mc.c", "**.def", "**.rc" }
  }
  characterset ("Unicode")
  staticruntime "On"
  includedirs { "src" }

  location( BUILDDIR )
  targetname "sqlite3mc"

  defines {
    "_USRDLL",
    "SQLITE_API=__declspec(dllexport)",
    "CODEC_TYPE=$(CODEC_TYPE)",
    "SQLITE_ENABLE_DEBUG=$(SQLITE_ENABLE_DEBUG)",
    "SQLITE_THREADSAFE=1",
    "SQLITE_DQS=0",
    "SQLITE_MAX_ATTACHED=10",
    "SQLITE_SOUNDEX=1",
    "SQLITE_ENABLE_COLUMN_METADATA=1",
    "SQLITE_SECURE_DELETE=1",
    "SQLITE_ENABLE_DESERIALIZE=1",
    "SQLITE_ENABLE_FTS3=1",
    "SQLITE_ENABLE_FTS3_PARENTHESIS=1",
    "SQLITE_ENABLE_FTS4=1",
    "SQLITE_ENABLE_FTS5=1",
    "SQLITE_ENABLE_RTREE=1",
    "SQLITE_ENABLE_GEOPOLY=1",
    "SQLITE_ENABLE_PREUPDATE_HOOK=1",
    "SQLITE_ENABLE_SESSION=1",
    "SQLITE_CORE=1",
    "SQLITE_ENABLE_EXTFUNC=1",
    "SQLITE_ENABLE_MATH_FUNCTIONS=1",
    "SQLITE_ENABLE_CSV=1",
    "SQLITE_ENABLE_VSV=1",
    "SQLITE_ENABLE_SHA3=1",
    "SQLITE_ENABLE_CARRAY=1",
    "SQLITE_ENABLE_FILEIO=1",
    "SQLITE_ENABLE_SERIES=1",
    "SQLITE_ENABLE_UUID=1",
    "SQLITE_ENABLE_REGEXP=1",
--    "SQLITE3MC_USE_MINIZ=$(SQLITE3MC_USE_MINIZ)",
--    "SQLITE_ENABLE_COMPRESS=1"
--    "SQLITE_ENABLE_SQLAR=1"
--    "SQLITE_ENABLE_ZIPFILE=1"
    "SQLITE3MC_SECURE_MEMORY=$(SQLITE3MC_SECURE_MEMORY)",
    "SQLITE_TEMP_STORE=2",
    "SQLITE_USE_URI=1",
    "SQLITE_USER_AUTHENTICATION=0"
  }

  -- Intermediate directory
  if (is_msvc) then
    objdir (BUILDDIR .. "/obj/" .. vc_with_ver)
  else
    objdir (BUILDDIR .. "/obj/gcc")
  end
  -- Target directory
  filter { "configurations:Debug*" }
    if (is_msvc) then
      targetdir ("bin/" .. vc_with_ver .. "/dll/debug")
    else
      targetdir "bin/gcc/dll/debug"
    end
  filter { "configurations:Release*" }
    if (is_msvc) then
      targetdir ("bin/" .. vc_with_ver .. "/dll/release")
    else
      targetdir "bin/gcc/dll/release"
    end

-- SQLite3 Shell
project "sqlite3mc_shell"
  kind "ConsoleApp"
  language "C++"

  if (is_msvc) then
    local prj = project()
    prj.filename = "sqlite3mc_" .. vc_with_ver .. "_shell"
    if (msvc_useProps) then
      wxUseProps(true)
    end
  else
    toolset("gcc")
    buildoptions { "-msse4.2", "-maes" }
--    buildoptions { "-march=native" }
  end
  makesettings { "include config.gcc" }

  vpaths {
    ["Header Files"] = { "**.h" },
    ["Source Files"] = { "**.c", "**.rc" }
  }
  files { "src/sqlite3.h", "src/shell.c", "src/sqlite3mc_shell.rc" }
  characterset ("Unicode")
  staticruntime "On"
  includedirs { "src" }
  links { "sqlite3mc_lib" }

  location( BUILDDIR )

  defines {
    "SQLITE3MC_USE_MINIZ=$(SQLITE3MC_USE_MINIZ)",
    "SQLITE_SHELL_IS_UTF8=1",
    "SQLITE_ENABLE_SESSION=1",
    "SQLITE_ENABLE_DBPAGE_VTAB=1",
    "SQLITE_USER_AUTHENTICATION=0"
  }

  -- Intermediate directory
  if (is_msvc) then
    objdir (BUILDDIR .. "/obj/" .. vc_with_ver)
  else
    objdir (BUILDDIR .. "/obj/gcc")
  end
  -- Target directory
  filter { "configurations:Debug*" }
    if (is_msvc) then
      targetdir ("bin/" .. vc_with_ver .. "/lib/debug")
    else
      targetdir "bin/gcc/lib/debug"
    end
  filter { "configurations:Release*" }
    if (is_msvc) then
      targetdir ("bin/" .. vc_with_ver .. "/lib/release")
    else
      targetdir "bin/gcc/lib/release"
    end

-- ICU support
-- SQLite3 static library with ICU support
project "sqlite3mc_libicu"
  language "C++"
  kind "StaticLib"

  if (is_msvc) then
    local prj = project()
    prj.filename = "sqlite3mc_" .. vc_with_ver .. "_libicu"
    if (msvc_useProps) then
      wxUseProps(true)
    end
  else
    toolset("gcc")
    buildoptions { "-msse4.2", "-maes" }
--    buildoptions { "-march=native" }
  end
  makesettings { "include config.gcc" }

  files { "src/sqlite3mc.c", "src/*.h" }
  vpaths {
    ["Header Files"] = { "**.h" },
    ["Source Files"] = { "**/sqlite3mc.c", "**.def", "**.rc" }
  }
  characterset ("Unicode")
  staticruntime "On"
  includedirs { "src", "$(LIBICU_PATH)/include" }

  location( BUILDDIR )
  targetname "sqlite3mc_icu"

  defines {
    "_LIB",
    "CODEC_TYPE=$(CODEC_TYPE)",
    "SQLITE_ENABLE_DEBUG=$(SQLITE_ENABLE_DEBUG)",
    "SQLITE_THREADSAFE=1",
    "SQLITE_ENABLE_ICU=1",
    "SQLITE_DQS=0",
    "SQLITE_MAX_ATTACHED=10",
    "SQLITE_ENABLE_EXPLAIN_COMMENTS=1",
    "SQLITE_SOUNDEX=1",
    "SQLITE_ENABLE_COLUMN_METADATA=1",
    "SQLITE_SECURE_DELETE=1",
    "SQLITE_ENABLE_DESERIALIZE=1",
    "SQLITE_ENABLE_FTS3=1",
    "SQLITE_ENABLE_FTS3_PARENTHESIS=1",
    "SQLITE_ENABLE_FTS4=1",
    "SQLITE_ENABLE_FTS5=1",
    "SQLITE_ENABLE_RTREE=1",
    "SQLITE_ENABLE_GEOPOLY=1",
    "SQLITE_ENABLE_PREUPDATE_HOOK=1",
    "SQLITE_ENABLE_SESSION=1",
    "SQLITE_CORE=1",
    "SQLITE_ENABLE_EXTFUNC=1",
    "SQLITE_ENABLE_MATH_FUNCTIONS=1",
    "SQLITE_ENABLE_CSV=1",
    "SQLITE_ENABLE_VSV=1",
--    "SQLITE_ENABLE_SHA3=1",
    "SQLITE_ENABLE_CARRAY=1",
--    "SQLITE_ENABLE_FILEIO=1",
--    "SQLITE_ENABLE_SERIES=1",
    "SQLITE_ENABLE_UUID=1",
--    "SQLITE_ENABLE_REGEXP=1",
--    "SQLITE3MC_USE_MINIZ=$(SQLITE3MC_USE_MINIZ)",
--    "SQLITE_ENABLE_COMPRESS=1"
--    "SQLITE_ENABLE_SQLAR=1"
--    "SQLITE_ENABLE_ZIPFILE=1"
    "SQLITE3MC_SECURE_MEMORY=$(SQLITE3MC_SECURE_MEMORY)",
    "SQLITE_TEMP_STORE=2",
    "SQLITE_USE_URI=1",
    "SQLITE_USER_AUTHENTICATION=0",
-- Compatibility with official SQLite3 shell
    "SQLITE_ENABLE_DBPAGE_VTAB=1",
    "SQLITE_ENABLE_DBSTAT_VTAB=1",
    "SQLITE_ENABLE_STMTVTAB=1",
    "SQLITE_ENABLE_UNKNOWN_SQL_FUNCTION=1"
  }

  -- Intermediate directory
  if (is_msvc) then
    objdir (BUILDDIR .. "/obj/" .. vc_with_ver)
  else
    objdir (BUILDDIR .. "/obj/gcc")
  end
  -- Target directory
  filter { "configurations:Debug*" }
    if (is_msvc) then
      targetdir ("bin/" .. vc_with_ver .. "/lib/debug")
    else
      targetdir "bin/gcc/lib/debug"
    end
  filter { "configurations:Release*" }
    if (is_msvc) then
      targetdir ("bin/" .. vc_with_ver .. "/lib/release")
    else
      targetdir "bin/gcc/lib/release"
    end

-- SQLite3 shared library with ICU support
project "sqlite3mc_dllicu"
  language "C++"
  kind "SharedLib"

  if (is_msvc) then
    local prj = project()
    prj.filename = "sqlite3mc_" .. vc_with_ver .. "_dllicu"
    if (msvc_useProps) then
      wxUseProps(true)
    end
  else
    toolset("gcc")
    buildoptions { "-msse4.2", "-maes" }
--    buildoptions { "-march=native" }
  end
  makesettings { "include config.gcc" }

  files { "src/sqlite3mc.c", "src/*.h", "src/sqlite3mc.rc" }
  filter {}
  vpaths {
    ["Header Files"] = { "**.h" },
    ["Source Files"] = { "**/sqlite3mc.c", "**.def", "**.rc" }
  }
  characterset ("Unicode")
  staticruntime "On"
  includedirs { "src", "$(LIBICU_PATH)/include" }

  filter { "platforms:Win32" }
    libdirs { "$(LIBICU_PATH)/lib" }
  filter { "platforms:Win64" }
    libdirs { "$(LIBICU_PATH)/lib64" }
  filter {}

  filter { "configurations:Debug*" }
    links { "icuind", "icuucd" }
  filter { "configurations:Release*" }
    links { "icuin", "icuuc" }
  filter {}

  location( BUILDDIR )
  targetname "sqlite3mc_icu"

  defines {
    "_USRDLL",
    "SQLITE_API=__declspec(dllexport)",
    "CODEC_TYPE=$(CODEC_TYPE)",
    "SQLITE_ENABLE_DEBUG=$(SQLITE_ENABLE_DEBUG)",
    "SQLITE_THREADSAFE=1",
    "SQLITE_ENABLE_ICU=1",
    "SQLITE_DQS=0",
    "SQLITE_MAX_ATTACHED=10",
    "SQLITE_SOUNDEX=1",
    "SQLITE_ENABLE_COLUMN_METADATA=1",
    "SQLITE_SECURE_DELETE=1",
    "SQLITE_ENABLE_DESERIALIZE=1",
    "SQLITE_ENABLE_FTS3=1",
    "SQLITE_ENABLE_FTS3_PARENTHESIS=1",
    "SQLITE_ENABLE_FTS4=1",
    "SQLITE_ENABLE_FTS5=1",
    "SQLITE_ENABLE_RTREE=1",
    "SQLITE_ENABLE_GEOPOLY=1",
    "SQLITE_ENABLE_PREUPDATE_HOOK=1",
    "SQLITE_ENABLE_SESSION=1",
    "SQLITE_CORE=1",
    "SQLITE_ENABLE_EXTFUNC=1",
    "SQLITE_ENABLE_MATH_FUNCTIONS=1",
    "SQLITE_ENABLE_CSV=1",
    "SQLITE_ENABLE_VSV=1",
    "SQLITE_ENABLE_SHA3=1",
    "SQLITE_ENABLE_CARRAY=1",
    "SQLITE_ENABLE_FILEIO=1",
    "SQLITE_ENABLE_SERIES=1",
    "SQLITE_ENABLE_UUID=1",
    "SQLITE_ENABLE_REGEXP=1",
--    "SQLITE3MC_USE_MINIZ=$(SQLITE3MC_USE_MINIZ)",
--    "SQLITE_ENABLE_COMPRESS=1"
--    "SQLITE_ENABLE_SQLAR=1"
--    "SQLITE_ENABLE_ZIPFILE=1"
    "SQLITE3MC_SECURE_MEMORY=$(SQLITE3MC_SECURE_MEMORY)",
    "SQLITE_TEMP_STORE=2",
    "SQLITE_USE_URI=1",
    "SQLITE_USER_AUTHENTICATION=0"
  }

  -- Intermediate directory
  if (is_msvc) then
    objdir (BUILDDIR .. "/obj/" .. vc_with_ver)
  else
    objdir (BUILDDIR .. "/obj/gcc")
  end
  -- Target directory
  filter { "configurations:Debug*" }
    if (is_msvc) then
      targetdir ("bin/" .. vc_with_ver .. "/dll/debug")
    else
      targetdir "bin/gcc/dll/debug"
    end
  filter { "configurations:Release*" }
    if (is_msvc) then
      targetdir ("bin/" .. vc_with_ver .. "/dll/release")
    else
      targetdir "bin/gcc/dll/release"
    end

-- SQLite3 Shell with ICU support
project "sqlite3mc_shellicu"
  kind "ConsoleApp"
  language "C++"

  if (is_msvc) then
    local prj = project()
    prj.filename = "sqlite3mc_" .. vc_with_ver .. "_shellicu"
    if (msvc_useProps) then
      wxUseProps(true)
    end
  else
    toolset("gcc")
    buildoptions { "-msse4.2", "-maes" }
--    buildoptions { "-march=native" }
  end
  makesettings { "include config.gcc" }

  vpaths {
    ["Header Files"] = { "**.h" },
    ["Source Files"] = { "**.c", "**.rc" }
  }
  files { "src/sqlite3.h", "src/shell.c", "src/sqlite3mc_shell.rc" }
  characterset ("Unicode")
  staticruntime "On"
  includedirs { "src" }
  links { "sqlite3mc_libicu" }

  filter { "platforms:Win32" }
    libdirs { "$(LIBICU_PATH)/lib" }
  filter { "platforms:Win64" }
    libdirs { "$(LIBICU_PATH)/lib64" }
  filter {}

  filter { "configurations:Debug*" }
    links { "icuind", "icuucd" }
  filter { "configurations:Release*" }
    links { "icuin", "icuuc" }
  filter {}

  location( BUILDDIR )

  defines {
    "SQLITE3MC_USE_MINIZ=$(SQLITE3MC_USE_MINIZ)",
    "SQLITE_SHELL_IS_UTF8=1",
    "SQLITE_ENABLE_SESSION=1",
    "SQLITE_ENABLE_DBPAGE_VTAB=1",
    "SQLITE_USER_AUTHENTICATION=0"
  }

  -- Intermediate directory
  if (is_msvc) then
    objdir (BUILDDIR .. "/obj/" .. vc_with_ver)
  else
    objdir (BUILDDIR .. "/obj/gcc")
  end
  -- Target directory
  filter { "configurations:Debug*" }
    if (is_msvc) then
      targetdir ("bin/" .. vc_with_ver .. "/lib/debug")
    else
      targetdir "bin/gcc/lib/debug"
    end
  filter { "configurations:Release*" }
    if (is_msvc) then
      targetdir ("bin/" .. vc_with_ver .. "/lib/release")
    else
      targetdir "bin/gcc/lib/release"
    end
