// This node script is meant to pre-compute the named colors.
// node ./htmlcanvas/_namedcolors.js --expose-wasm
// Put the result in color.js
// This should likely never need to be re-run.

const CanvasKitInit = require('../canvaskit/bin/canvaskit.js');

CanvasKitInit({
  locateFile: (file) => __dirname + '/../canvaskit/bin/'+file,
}).then((CanvasKit) => {
  let colorMap = {
    // From https://drafts.csswg.org/css-color/#named-colors
    'aliceblue': CanvasKit.Color(240, 248, 255),
    'antiquewhite': CanvasKit.Color(250, 235, 215),
    'aqua': CanvasKit.Color(0, 255, 255),
    'aquamarine': CanvasKit.Color(127, 255, 212),
    'azure': CanvasKit.Color(240, 255, 255),
    'beige': CanvasKit.Color(245, 245, 220),
    'bisque': CanvasKit.Color(255, 228, 196),
    'black': CanvasKit.Color(0, 0, 0),
    'blanchedalmond': CanvasKit.Color(255, 235, 205),
    'blue': CanvasKit.Color(0, 0, 255),
    'blueviolet': CanvasKit.Color(138, 43, 226),
    'brown': CanvasKit.Color(165, 42, 42),
    'burlywood': CanvasKit.Color(222, 184, 135),
    'cadetblue': CanvasKit.Color(95, 158, 160),
    'chartreuse': CanvasKit.Color(127, 255, 0),
    'chocolate': CanvasKit.Color(210, 105, 30),
    'coral': CanvasKit.Color(255, 127, 80),
    'cornflowerblue': CanvasKit.Color(100, 149, 237),
    'cornsilk': CanvasKit.Color(255, 248, 220),
    'crimson': CanvasKit.Color(220, 20, 60),
    'cyan': CanvasKit.Color(0, 255, 255),
    'darkblue': CanvasKit.Color(0, 0, 139),
    'darkcyan': CanvasKit.Color(0, 139, 139),
    'darkgoldenrod': CanvasKit.Color(184, 134, 11),
    'darkgray': CanvasKit.Color(169, 169, 169),
    'darkgreen': CanvasKit.Color(0, 100, 0),
    'darkgrey': CanvasKit.Color(169, 169, 169),
    'darkkhaki': CanvasKit.Color(189, 183, 107),
    'darkmagenta': CanvasKit.Color(139, 0, 139),
    'darkolivegreen': CanvasKit.Color(85, 107, 47),
    'darkorange': CanvasKit.Color(255, 140, 0),
    'darkorchid': CanvasKit.Color(153, 50, 204),
    'darkred': CanvasKit.Color(139, 0, 0),
    'darksalmon': CanvasKit.Color(233, 150, 122),
    'darkseagreen': CanvasKit.Color(143, 188, 143),
    'darkslateblue': CanvasKit.Color(72, 61, 139),
    'darkslategray': CanvasKit.Color(47, 79, 79),
    'darkslategrey': CanvasKit.Color(47, 79, 79),
    'darkturquoise': CanvasKit.Color(0, 206, 209),
    'darkviolet': CanvasKit.Color(148, 0, 211),
    'deeppink': CanvasKit.Color(255, 20, 147),
    'deepskyblue': CanvasKit.Color(0, 191, 255),
    'dimgray': CanvasKit.Color(105, 105, 105),
    'dimgrey': CanvasKit.Color(105, 105, 105),
    'dodgerblue': CanvasKit.Color(30, 144, 255),
    'firebrick': CanvasKit.Color(178, 34, 34),
    'floralwhite': CanvasKit.Color(255, 250, 240),
    'forestgreen': CanvasKit.Color(34, 139, 34),
    'fuchsia': CanvasKit.Color(255, 0, 255),
    'gainsboro': CanvasKit.Color(220, 220, 220),
    'ghostwhite': CanvasKit.Color(248, 248, 255),
    'gold': CanvasKit.Color(255, 215, 0),
    'goldenrod': CanvasKit.Color(218, 165, 32),
    'gray': CanvasKit.Color(128, 128, 128),
    'green': CanvasKit.Color(0, 128, 0),
    'greenyellow': CanvasKit.Color(173, 255, 47),
    'grey': CanvasKit.Color(128, 128, 128),
    'honeydew': CanvasKit.Color(240, 255, 240),
    'hotpink': CanvasKit.Color(255, 105, 180),
    'indianred': CanvasKit.Color(205, 92, 92),
    'indigo': CanvasKit.Color(75, 0, 130),
    'ivory': CanvasKit.Color(255, 255, 240),
    'khaki': CanvasKit.Color(240, 230, 140),
    'lavender': CanvasKit.Color(230, 230, 250),
    'lavenderblush': CanvasKit.Color(255, 240, 245),
    'lawngreen': CanvasKit.Color(124, 252, 0),
    'lemonchiffon': CanvasKit.Color(255, 250, 205),
    'lightblue': CanvasKit.Color(173, 216, 230),
    'lightcoral': CanvasKit.Color(240, 128, 128),
    'lightcyan': CanvasKit.Color(224, 255, 255),
    'lightgoldenrodyellow': CanvasKit.Color(250, 250, 210),
    'lightgray': CanvasKit.Color(211, 211, 211),
    'lightgreen': CanvasKit.Color(144, 238, 144),
    'lightgrey': CanvasKit.Color(211, 211, 211),
    'lightpink': CanvasKit.Color(255, 182, 193),
    'lightsalmon': CanvasKit.Color(255, 160, 122),
    'lightseagreen': CanvasKit.Color(32, 178, 170),
    'lightskyblue': CanvasKit.Color(135, 206, 250),
    'lightslategray': CanvasKit.Color(119, 136, 153),
    'lightslategrey': CanvasKit.Color(119, 136, 153),
    'lightsteelblue': CanvasKit.Color(176, 196, 222),
    'lightyellow': CanvasKit.Color(255, 255, 224),
    'lime': CanvasKit.Color(0, 255, 0),
    'limegreen': CanvasKit.Color(50, 205, 50),
    'linen': CanvasKit.Color(250, 240, 230),
    'magenta': CanvasKit.Color(255, 0, 255),
    'maroon': CanvasKit.Color(128, 0, 0),
    'mediumaquamarine': CanvasKit.Color(102, 205, 170),
    'mediumblue': CanvasKit.Color(0, 0, 205),
    'mediumorchid': CanvasKit.Color(186, 85, 211),
    'mediumpurple': CanvasKit.Color(147, 112, 219),
    'mediumseagreen': CanvasKit.Color(60, 179, 113),
    'mediumslateblue': CanvasKit.Color(123, 104, 238),
    'mediumspringgreen': CanvasKit.Color(0, 250, 154),
    'mediumturquoise': CanvasKit.Color(72, 209, 204),
    'mediumvioletred': CanvasKit.Color(199, 21, 133),
    'midnightblue': CanvasKit.Color(25, 25, 112),
    'mintcream': CanvasKit.Color(245, 255, 250),
    'mistyrose': CanvasKit.Color(255, 228, 225),
    'moccasin': CanvasKit.Color(255, 228, 181),
    'navajowhite': CanvasKit.Color(255, 222, 173),
    'navy': CanvasKit.Color(0, 0, 128),
    'oldlace': CanvasKit.Color(253, 245, 230),
    'olive': CanvasKit.Color(128, 128, 0),
    'olivedrab': CanvasKit.Color(107, 142, 35),
    'orange': CanvasKit.Color(255, 165, 0),
    'orangered': CanvasKit.Color(255, 69, 0),
    'orchid': CanvasKit.Color(218, 112, 214),
    'palegoldenrod': CanvasKit.Color(238, 232, 170),
    'palegreen': CanvasKit.Color(152, 251, 152),
    'paleturquoise': CanvasKit.Color(175, 238, 238),
    'palevioletred': CanvasKit.Color(219, 112, 147),
    'papayawhip': CanvasKit.Color(255, 239, 213),
    'peachpuff': CanvasKit.Color(255, 218, 185),
    'peru': CanvasKit.Color(205, 133, 63),
    'pink': CanvasKit.Color(255, 192, 203),
    'plum': CanvasKit.Color(221, 160, 221),
    'powderblue': CanvasKit.Color(176, 224, 230),
    'purple': CanvasKit.Color(128, 0, 128),
    'rebeccapurple': CanvasKit.Color(102, 51, 153),
    'red': CanvasKit.Color(255, 0, 0),
    'rosybrown': CanvasKit.Color(188, 143, 143),
    'royalblue': CanvasKit.Color(65, 105, 225),
    'saddlebrown': CanvasKit.Color(139, 69, 19),
    'salmon': CanvasKit.Color(250, 128, 114),
    'sandybrown': CanvasKit.Color(244, 164, 96),
    'seagreen': CanvasKit.Color(46, 139, 87),
    'seashell': CanvasKit.Color(255, 245, 238),
    'sienna': CanvasKit.Color(160, 82, 45),
    'silver': CanvasKit.Color(192, 192, 192),
    'skyblue': CanvasKit.Color(135, 206, 235),
    'slateblue': CanvasKit.Color(106, 90, 205),
    'slategray': CanvasKit.Color(112, 128, 144),
    'slategrey': CanvasKit.Color(112, 128, 144),
    'snow': CanvasKit.Color(255, 250, 250),
    'springgreen': CanvasKit.Color(0, 255, 127),
    'steelblue': CanvasKit.Color(70, 130, 180),
    'tan': CanvasKit.Color(210, 180, 140),
    'teal': CanvasKit.Color(0, 128, 128),
    'thistle': CanvasKit.Color(216, 191, 216),
    'transparent': CanvasKit.Color(0, 0, 0, 0),
    'tomato': CanvasKit.Color(255, 99, 71),
    'turquoise': CanvasKit.Color(64, 224, 208),
    'violet': CanvasKit.Color(238, 130, 238),
    'wheat': CanvasKit.Color(245, 222, 179),
    'white': CanvasKit.Color(255, 255, 255),
    'whitesmoke': CanvasKit.Color(245, 245, 245),
    'yellow': CanvasKit.Color(255, 255, 0),
    'yellowgreen': CanvasKit.Color(154, 205, 50)
  };
  console.log(JSON.stringify(colorMap));

});
