module siesta_qmmm_options
  !! This module has several variables and a single routine in charge of
  !! reading some of the QMMM options.
  implicit none
  private
  public :: read_siesta_qmmm_options

  integer, public :: wricoord    = 1
    !! Write coordinates every wricoord steps.
  integer, public :: mmsteps     = 1
    !! Number of MM steps for every other relaxation step.
  integer, public :: mneigh_freq = 10
    !! Update neighbour lists every mneigh_freq steps.

  logical, public :: launch_siesta_flag    = .false.
    !! Used in fsiesta to indicate whether we launch regular siesta.
  logical, public :: center_qm_system      = .false.
    !! Whether we recenter the center of mass of the QM system as 0.
  logical, public :: siesta_qmmm_usesavexv = .false.
    !! Whether we are restarting from a previous XV file.
  character(len=100), public :: parallel_command = 'mpirun'
    !! Choose the command to run SIESTA in parallel, for cases
    !! when one would like to use mpi_exec or srun.

  logical, public :: opt_idyn         = .false.
    !! Whether we are doing an optimization run.
  logical, public :: fc_idyn          = .false.
    !! Whether we are doing a phonon calculation run.
  logical, public :: therm_idyn       = .false.
    !! Whether we are doing a constant Temperature run.

contains

  subroutine read_siesta_qmmm_options( )
    !! Reads the input QMMM options.
    use fdf, only : fdf_get, leqi
    use sys, only : die

    implicit none
    character(len=80) :: dyntype
    logical           :: default

    ! Write coordinate variable
    wricoord = fdf_get( 'WriteCoordinates', 1 )
    write( 6,'(a,i5,a)' ) &
      'read: Write coordinates each           = ', wricoord, '  steps'

    ! MMxQM steps
    mmsteps = fdf_get( 'MD.MMxQMsteps', 1 )
    write(6,'(a,i5)') &
         'read: MM x QM steps                    = ', mmsteps

    launch_siesta_flag    = fdf_get( 'LaunchSiesta'  , .false. )
    parallel_command      = fdf_get(  'MPICommand'    , 'mpirun')

    ! Options readed here instead of siesta_options
    default               = fdf_get( 'UseSaveData'   , .false. )
    siesta_qmmm_usesavexv = fdf_get( 'MD.UseSaveXV'  , default )
    mneigh_freq           = fdf_get( 'NebListFreq'   , 10      )
    center_qm_system      = fdf_get( 'CenterQmSystem', .false. )
    dyntype               = fdf_get(  'MD.TypeOfRun'  ,'cg'     )

    if ( leqi(dyntype,'cg') .or. leqi(dyntype,'broyden') .or. &
         leqi(dyntype,'fire') ) then
      opt_idyn = .true.
    elseif ( leqi(dyntype,'fc') ) then
      fc_idyn = .true.
    else
      therm_idyn = .true.
    endif

    write(6,'("read: ",73(1h*))')
  end subroutine read_siesta_qmmm_options

end module siesta_qmmm_options

