# Makefile used to run ADMS on a Verilog-A source to emit C++ code.

# PREFIX can be passed as parameter to make:
# $make -f va2lib.make PREFIX='/qucs/prefix/'

######################
## Makefile Parameters
######################

# Module/file name
MODEL=

# Please define Qucs prefix, used to define include path
PREFIX=

# Location of installed Qucs XML files
INC=$(PREFIX)/include/qucsator

# Locate admsXml, typically on the same prefix as Qucs
ADMSXML=$(PREFIX)/bin/admsXml

# file suffix
VA=.va

# handle deletion if Windows cmd.exe or MinGW MSYS terminal
ifeq ($(OS),Windows_NT)
  RM=del
  SHELL=cmd.exe
  ifeq ($(MSYSTEM),MINGW32)
	RM=rm -f
  endif
endif

# Generated sources
GEN_SRC=$(MODEL).cpp $(MODEL).h \
        $(MODEL).*.cpp $(MODEL).*.h

# Required Qucs XML files
XML_FILES=$(INC)/qucsVersion.xml    \
          $(INC)/qucsMODULEcore.xml \
          $(INC)/qucsMODULEdefs.xml \
          $(INC)/analogfunction.xml

# Files generated by admsXml
ADMS_GEN=.adms.implicit.xml .interface.xml .$(MODEL).va.adms

# Default
.PHONY: va2cpp

# Main target
va2cpp: $(MODEL).cpp

# Run admsXml, create C++ out of Verilog-A
# admsXml will take almost any `-[CHAR] command`, each script has to handle the argument parsing
# Include the search path to user vams readers or pick from adms.

.SUFFIXES: .cpp .va

.va.cpp: $(XML_FILES)
	@echo '# va2cpp - Creating C++ sources.'
# BUG: must catch stray spaces in ADMSXML, adding extra quotation
	"$(ADMSXML)" $< \
                           -I "$(INC)"                    \
                           -e "$(INC)/qucsVersion.xml"    \
                           -e "$(INC)/qucsMODULEcore.xml" \
                           -e "$(INC)/qucsMODULEdefs.xml" \
                           -e "$(INC)/analogfunction.xml" \
                           -o $*
clean:
	@echo '# va2cpp - Removing autogenerated files.'
	- $(RM) $(GEN_SRC) $(ADMS_GEN)
	@echo ''
