// Copyright (C) 2023 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only

#version 440

layout(location = 0) in vec3 sampleNearLeft;
layout(location = 1) in vec3 sampleNearRight;

layout(location = 0) out vec4 fragColor;

layout(binding = 1) uniform sampler2D _qt_texture;

layout(std140, binding = 0) uniform buf {
#if QSHADER_VIEW_COUNT >= 2
    mat4 matrix[QSHADER_VIEW_COUNT];
#else
    mat4 matrix;
#endif
    vec2 textureScale;
    vec4 color;
    float alphaMin;
    float alphaMax;
    // up to this point it must match distancefieldtext
    float fontScale;
    vec4 vecDelta;
};

void main()
{
    vec2 n;
    n.x = textureProj(_qt_texture, sampleNearLeft).a;
    n.y = textureProj(_qt_texture, sampleNearRight).a;
    n = smoothstep(alphaMin, alphaMax, n);
    float c = 0.5 * (n.x + n.y);
    fragColor = vec4(n.x, c, n.y, c) * color.w;
}
