include(CheckCXXCompilerFlag)
include(CheckCCompilerFlag)

function(qpdf_maybe_add_flag lang flag var)
  if(${lang} STREQUAL "C")
    check_c_compiler_flag(${flag} ${var})
  elseif(${lang} STREQUAL "CXX")
    check_cxx_compiler_flag(${flag} ${var})
  endif()
  if(${var})
    message(STATUS "Using ${flag}: YES")
    if(${lang} STREQUAL "C")
      # Add for C and C++
      add_compile_options(${flag})
    else()
      add_compile_options($<$<COMPILE_LANGUAGE:CXX>:${flag}>)
    endif()
  else()
    message(STATUS "Using ${flag}: NO")
  endif()
endfunction()
