# Converts a cmvspy.h file to a cmvspy.py file for use in python
# usage: cmvspyconvert.py cmvspy.h cmvspy_python.py
# arguments can be omitted
import sys
import re

file_boiler_plate = (
    """#This file was automatically generated by '%s'
#from a cmvspy.h file.
#Example usage:
#	from cmvspy import data as coremini_data\n\n"""
    % sys.argv[0]
)

if __name__ == "__main__":
    try:
        cmvspy_filename = sys.argv[1]
    except IndexError:
        cmvspy_filename = "cmvspy.h"
    try:
        cmvspy_py_filename = sys.argv[2]
    except IndexError:
        cmvspy_py_filename = "cmvspy.py"
    print("'%s' Will be converted in '%s'" % (cmvspy_filename, cmvspy_py_filename))
    cmvspy_py_file = open(cmvspy_py_filename, "w+")
    cmvspy_py_file.write(file_boiler_plate)
    cmvspy_py_file.write("data = ( \\\n\t")
    hex_regex = re.compile("^\s*0[xX][0-9a-fA-F]+")
    BYTES_PER_LINE = 10
    bytes_current = 0
    with open(cmvspy_filename) as cmvspy_file:
        for line in cmvspy_file:
            matches = hex_regex.match(line)
            if not matches:
                continue
            cmvspy_py_file.write(matches.group() + ", ")
            bytes_current += 1
            if bytes_current >= 10:
                bytes_current = 0
                cmvspy_py_file.write(" \\\n\t")
    cmvspy_py_file.write(")\n")
    cmvspy_py_file.close()
    print("Done.")
