/* Copyright 2022 - 2024 R. Thomas
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef LIEF_ASM_X86_REGISTER_H
#define LIEF_ASM_X86_REGISTER_H
namespace LIEF {
namespace assembly {
namespace x86 {
enum class REG;
const char* get_register_name(REG r);

enum class REG {
  NoRegister = 0,
  AH = 1,
  AL = 2,
  AX = 3,
  BH = 4,
  BL = 5,
  BP = 6,
  BPH = 7,
  BPL = 8,
  BX = 9,
  CH = 10,
  CL = 11,
  CS = 12,
  CX = 13,
  DF = 14,
  DH = 15,
  DI = 16,
  DIH = 17,
  DIL = 18,
  DL = 19,
  DS = 20,
  DX = 21,
  EAX = 22,
  EBP = 23,
  EBX = 24,
  ECX = 25,
  EDI = 26,
  EDX = 27,
  EFLAGS = 28,
  EIP = 29,
  EIZ = 30,
  ES = 31,
  ESI = 32,
  ESP = 33,
  FPCW = 34,
  FPSW = 35,
  FS = 36,
  FS_BASE = 37,
  GS = 38,
  GS_BASE = 39,
  HAX = 40,
  HBP = 41,
  HBX = 42,
  HCX = 43,
  HDI = 44,
  HDX = 45,
  HIP = 46,
  HSI = 47,
  HSP = 48,
  IP = 49,
  MXCSR = 50,
  RAX = 51,
  RBP = 52,
  RBX = 53,
  RCX = 54,
  RDI = 55,
  RDX = 56,
  RFLAGS = 57,
  RIP = 58,
  RIZ = 59,
  RSI = 60,
  RSP = 61,
  SI = 62,
  SIH = 63,
  SIL = 64,
  SP = 65,
  SPH = 66,
  SPL = 67,
  SS = 68,
  SSP = 69,
  _EFLAGS = 70,
  CR0 = 71,
  CR1 = 72,
  CR2 = 73,
  CR3 = 74,
  CR4 = 75,
  CR5 = 76,
  CR6 = 77,
  CR7 = 78,
  CR8 = 79,
  CR9 = 80,
  CR10 = 81,
  CR11 = 82,
  CR12 = 83,
  CR13 = 84,
  CR14 = 85,
  CR15 = 86,
  DR0 = 87,
  DR1 = 88,
  DR2 = 89,
  DR3 = 90,
  DR4 = 91,
  DR5 = 92,
  DR6 = 93,
  DR7 = 94,
  DR8 = 95,
  DR9 = 96,
  DR10 = 97,
  DR11 = 98,
  DR12 = 99,
  DR13 = 100,
  DR14 = 101,
  DR15 = 102,
  FP0 = 103,
  FP1 = 104,
  FP2 = 105,
  FP3 = 106,
  FP4 = 107,
  FP5 = 108,
  FP6 = 109,
  FP7 = 110,
  MM0 = 111,
  MM1 = 112,
  MM2 = 113,
  MM3 = 114,
  MM4 = 115,
  MM5 = 116,
  MM6 = 117,
  MM7 = 118,
  R8 = 119,
  R9 = 120,
  R10 = 121,
  R11 = 122,
  R12 = 123,
  R13 = 124,
  R14 = 125,
  R15 = 126,
  ST0 = 127,
  ST1 = 128,
  ST2 = 129,
  ST3 = 130,
  ST4 = 131,
  ST5 = 132,
  ST6 = 133,
  ST7 = 134,
  XMM0 = 135,
  XMM1 = 136,
  XMM2 = 137,
  XMM3 = 138,
  XMM4 = 139,
  XMM5 = 140,
  XMM6 = 141,
  XMM7 = 142,
  XMM8 = 143,
  XMM9 = 144,
  XMM10 = 145,
  XMM11 = 146,
  XMM12 = 147,
  XMM13 = 148,
  XMM14 = 149,
  XMM15 = 150,
  R8B = 151,
  R9B = 152,
  R10B = 153,
  R11B = 154,
  R12B = 155,
  R13B = 156,
  R14B = 157,
  R15B = 158,
  R8BH = 159,
  R9BH = 160,
  R10BH = 161,
  R11BH = 162,
  R12BH = 163,
  R13BH = 164,
  R14BH = 165,
  R15BH = 166,
  R8D = 167,
  R9D = 168,
  R10D = 169,
  R11D = 170,
  R12D = 171,
  R13D = 172,
  R14D = 173,
  R15D = 174,
  R8W = 175,
  R9W = 176,
  R10W = 177,
  R11W = 178,
  R12W = 179,
  R13W = 180,
  R14W = 181,
  R15W = 182,
  R8WH = 183,
  R9WH = 184,
  R10WH = 185,
  R11WH = 186,
  R12WH = 187,
  R13WH = 188,
  R14WH = 189,
  R15WH = 190,
  YMM0 = 191,
  YMM1 = 192,
  YMM2 = 193,
  YMM3 = 194,
  YMM4 = 195,
  YMM5 = 196,
  YMM6 = 197,
  YMM7 = 198,
  YMM8 = 199,
  YMM9 = 200,
  YMM10 = 201,
  YMM11 = 202,
  YMM12 = 203,
  YMM13 = 204,
  YMM14 = 205,
  YMM15 = 206,
  K0 = 207,
  K1 = 208,
  K2 = 209,
  K3 = 210,
  K4 = 211,
  K5 = 212,
  K6 = 213,
  K7 = 214,
  XMM16 = 215,
  XMM17 = 216,
  XMM18 = 217,
  XMM19 = 218,
  XMM20 = 219,
  XMM21 = 220,
  XMM22 = 221,
  XMM23 = 222,
  XMM24 = 223,
  XMM25 = 224,
  XMM26 = 225,
  XMM27 = 226,
  XMM28 = 227,
  XMM29 = 228,
  XMM30 = 229,
  XMM31 = 230,
  YMM16 = 231,
  YMM17 = 232,
  YMM18 = 233,
  YMM19 = 234,
  YMM20 = 235,
  YMM21 = 236,
  YMM22 = 237,
  YMM23 = 238,
  YMM24 = 239,
  YMM25 = 240,
  YMM26 = 241,
  YMM27 = 242,
  YMM28 = 243,
  YMM29 = 244,
  YMM30 = 245,
  YMM31 = 246,
  ZMM0 = 247,
  ZMM1 = 248,
  ZMM2 = 249,
  ZMM3 = 250,
  ZMM4 = 251,
  ZMM5 = 252,
  ZMM6 = 253,
  ZMM7 = 254,
  ZMM8 = 255,
  ZMM9 = 256,
  ZMM10 = 257,
  ZMM11 = 258,
  ZMM12 = 259,
  ZMM13 = 260,
  ZMM14 = 261,
  ZMM15 = 262,
  ZMM16 = 263,
  ZMM17 = 264,
  ZMM18 = 265,
  ZMM19 = 266,
  ZMM20 = 267,
  ZMM21 = 268,
  ZMM22 = 269,
  ZMM23 = 270,
  ZMM24 = 271,
  ZMM25 = 272,
  ZMM26 = 273,
  ZMM27 = 274,
  ZMM28 = 275,
  ZMM29 = 276,
  ZMM30 = 277,
  ZMM31 = 278,
  K0_K1 = 279,
  K2_K3 = 280,
  K4_K5 = 281,
  K6_K7 = 282,
  TMMCFG = 283,
  TMM0 = 284,
  TMM1 = 285,
  TMM2 = 286,
  TMM3 = 287,
  TMM4 = 288,
  TMM5 = 289,
  TMM6 = 290,
  TMM7 = 291,
  R16 = 292,
  R17 = 293,
  R18 = 294,
  R19 = 295,
  R20 = 296,
  R21 = 297,
  R22 = 298,
  R23 = 299,
  R24 = 300,
  R25 = 301,
  R26 = 302,
  R27 = 303,
  R28 = 304,
  R29 = 305,
  R30 = 306,
  R31 = 307,
  R16B = 308,
  R17B = 309,
  R18B = 310,
  R19B = 311,
  R20B = 312,
  R21B = 313,
  R22B = 314,
  R23B = 315,
  R24B = 316,
  R25B = 317,
  R26B = 318,
  R27B = 319,
  R28B = 320,
  R29B = 321,
  R30B = 322,
  R31B = 323,
  R16BH = 324,
  R17BH = 325,
  R18BH = 326,
  R19BH = 327,
  R20BH = 328,
  R21BH = 329,
  R22BH = 330,
  R23BH = 331,
  R24BH = 332,
  R25BH = 333,
  R26BH = 334,
  R27BH = 335,
  R28BH = 336,
  R29BH = 337,
  R30BH = 338,
  R31BH = 339,
  R16D = 340,
  R17D = 341,
  R18D = 342,
  R19D = 343,
  R20D = 344,
  R21D = 345,
  R22D = 346,
  R23D = 347,
  R24D = 348,
  R25D = 349,
  R26D = 350,
  R27D = 351,
  R28D = 352,
  R29D = 353,
  R30D = 354,
  R31D = 355,
  R16W = 356,
  R17W = 357,
  R18W = 358,
  R19W = 359,
  R20W = 360,
  R21W = 361,
  R22W = 362,
  R23W = 363,
  R24W = 364,
  R25W = 365,
  R26W = 366,
  R27W = 367,
  R28W = 368,
  R29W = 369,
  R30W = 370,
  R31W = 371,
  R16WH = 372,
  R17WH = 373,
  R18WH = 374,
  R19WH = 375,
  R20WH = 376,
  R21WH = 377,
  R22WH = 378,
  R23WH = 379,
  R24WH = 380,
  R25WH = 381,
  R26WH = 382,
  R27WH = 383,
  R28WH = 384,
  R29WH = 385,
  R30WH = 386,
  R31WH = 387,
  NUM_TARGET_REGS = 388,
};

}
}
}
#endif
