/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 */

#undef NDEBUG  // get assert in release mode

#include <array>
#include <cassert>
#include <iostream>

#include "../sh4lt/ipcs/sysv-shm.hpp"
#include "../sh4lt/logger/console.hpp"
#include "../sh4lt/writer.hpp"

using namespace sh4lt;

auto main() -> int {
  using namespace sh4lt;
  auto log = std::make_shared<logger::Console>();
  {
    unsigned long max_size = sysVShm::get_shmmax(log.get());
    // std::cout << max_size << '\n';
    // unsigned long mni = sysVShm::get_shmmni(log.get());
    // std::cout << mni << '\n';
    if (max_size > 268435456) //256MB
      max_size = 268435456;
    Writer w(ShType("application/x-check-sh4lt", "check-shm-size"),
             max_size,
             log);
    assert(w);
  }
  return 0;
}
  
