/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 */

#ifndef SH4LT_UNIX_SOCKET_H_
#define SH4LT_UNIX_SOCKET_H_

#include <string>
#include "../logger/logger.hpp"
#include "../utils/safe-bool-idiom.hpp"

namespace sh4lt {
class UnixSocketServer;
class UnixSocketClient;

class UnixSocket : public SafeBoolIdiom {
  friend UnixSocketServer;
  friend UnixSocketClient;

 public:
  UnixSocket(logger::Logger* log);
  ~UnixSocket() override;
  UnixSocket(const UnixSocket&) = delete;
  UnixSocket(UnixSocket&&) = delete;
  auto operator=(const UnixSocket&) -> UnixSocket& = delete;
  auto operator=(UnixSocket&&) -> UnixSocket& = default;

 private:
  logger::Logger* log_;
  int fd_{-1};
  [[nodiscard]] auto is_valid() const -> bool final;
};

}  // namespace sh4lt
#endif
