/* heatmap - High performance heatmap creation in C.
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2013 Lucas Beyer
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include "heatmap.h"
#include "colorschemes/PuBuGn.h"

static const unsigned char discrete_data[] = {
    0, 0, 0, 0, 1, 70, 54, 255, 1, 108, 89, 255, 2, 129, 138, 255, 54, 144, 192, 255, 103, 169, 207, 255, 166, 189, 219, 255, 208, 209, 230, 255, 236, 226, 240, 255, 255, 247, 251, 255
};
static const heatmap_colorscheme_t discrete = { discrete_data, sizeof(discrete_data)/sizeof(discrete_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_PuBuGn_discrete = &discrete;

static const unsigned char soft_data[] = {
    0, 0, 0, 0, 1, 70, 53, 0, 1, 70, 54, 7, 1, 70, 54, 14, 1, 70, 54, 22, 1, 71, 55, 29, 1, 71, 55, 37, 1, 71, 55, 44, 1, 72, 55, 52, 1, 72, 56, 59, 1, 72, 56, 67, 1, 72, 56, 74, 1, 73, 56, 82, 1, 73, 57, 89, 1, 73, 57, 97, 1, 74, 57, 104, 1, 74, 57, 112, 1, 74, 58, 119, 1, 74, 58, 127, 1, 75, 58, 134, 1, 75, 58, 141, 1, 75, 59, 149, 1, 76, 59, 156, 1, 76, 59, 164, 1, 76, 59, 171, 1, 76, 60, 179, 1, 77, 60, 186, 1, 77, 60, 194, 1, 77, 61, 201, 1, 78, 61, 209, 1, 78, 61, 216, 1, 78, 61, 224, 1, 78, 62, 231, 1, 79, 62, 239, 1, 79, 62, 246, 1, 79, 62, 254, 1, 80, 63, 255, 1, 80, 63, 255, 1, 80, 63, 255, 1, 80, 63, 255, 1, 81, 64, 255, 1, 81, 64, 255, 1, 81, 64, 255, 1, 82, 64, 255, 1, 82, 65, 255, 1, 82, 65, 255, 1, 83, 65, 255, 1, 83, 66, 255, 1, 83, 66, 255, 1, 83, 66, 255, 1, 84, 66, 255, 1, 84, 67, 255, 1, 84, 67, 255, 1, 85, 67, 255, 1, 85, 67, 255, 1, 85, 68, 255, 1, 85, 68, 255, 1, 86, 68, 255, 1, 86, 69, 255, 1, 86, 69, 255, 1, 87, 69, 255, 1, 87, 69, 255, 1, 87, 70, 255, 1, 88, 70, 255, 1, 88, 70, 255, 1, 88, 70, 255, 1, 88, 71, 255, 1, 89, 71, 255, 1, 89, 71, 255, 1, 89, 72, 255, 1, 90, 72, 255, 1, 90, 72, 255, 1, 90, 72, 255, 1, 91, 73, 255, 1, 91, 73, 255, 1, 91, 73, 255, 1, 91, 73, 255, 1, 92, 74, 255, 1, 92, 74, 255, 1, 92, 74, 255, 1, 93, 75, 255, 1, 93, 75, 255, 1, 93, 75, 255, 1, 94, 75, 255, 1, 94, 76, 255, 1, 94, 76, 255, 1, 94, 76, 255, 1, 95, 77, 255, 1, 95, 77, 255, 1, 95, 77, 255, 1, 96, 77, 255, 1, 96, 78, 255, 1, 96, 78, 255, 1, 97, 78, 255, 1, 97, 78, 255, 1, 97, 79, 255, 1, 97, 79, 255, 1, 98, 79, 255, 1, 98, 80, 255, 1, 98, 80, 255, 1, 99, 80, 255, 1, 99, 80, 255, 1, 99, 81, 255, 1, 100, 81, 255, 1, 100, 81, 255, 1, 100, 82, 255, 1, 100, 82, 255, 1, 101, 82, 255, 1, 101, 82, 255, 1, 101, 83, 255, 1, 102, 83, 255, 1, 102, 83, 255, 1, 102, 84, 255, 1, 103, 84, 255, 1, 103, 84, 255, 1, 103, 84, 255, 1, 104, 85, 255, 1, 104, 85, 255, 1, 104, 85, 255, 1, 104, 86, 255, 1, 105, 86, 255, 1, 105, 86, 255, 1, 105, 86, 255, 1, 106, 87, 255, 1, 106, 87, 255, 1, 106, 87, 255, 1, 107, 88, 255, 1, 107, 88, 255, 1, 107, 88, 255, 1, 108, 88, 255, 0, 108, 89, 255, 0, 108, 89, 255, 0, 108, 90, 255, 0, 108, 90, 255, 0, 108, 90, 255, 0, 109, 91, 255, 0, 109, 91, 255, 0, 109, 92, 255, 0, 109, 92, 255, 0, 109, 92, 255, 0, 109, 93, 255, 0, 110, 93, 255, 0, 110, 94, 255, 0, 110, 94, 255, 0, 110, 94, 255, 0, 110, 95, 255, 0, 110, 95, 255, 0, 111, 96, 255, 0, 111, 96, 255, 0, 111, 96, 255, 0, 111, 97, 255, 0, 111, 97, 255, 0, 111, 98, 255, 0, 112, 98, 255, 0, 112, 98, 255, 0, 112, 99, 255, 0, 112, 99, 255, 0, 112, 100, 255, 0, 113, 100, 255, 0, 113, 100, 255, 0, 113, 101, 255, 0, 113, 101, 255, 0, 113, 102, 255, 0, 113, 102, 255, 0, 114, 102, 255, 0, 114, 103, 255, 0, 114, 103, 255, 0, 114, 103, 255, 0, 114, 104, 255, 0, 114, 104, 255, 0, 115, 105, 255, 0, 115, 105, 255, 0, 115, 105, 255, 0, 115, 106, 255, 0, 115, 106, 255, 0, 115, 107, 255, 0, 116, 107, 255, 0, 116, 107, 255, 0, 116, 108, 255, 0, 116, 108, 255, 0, 116, 109, 255, 0, 116, 109, 255, 0, 117, 109, 255, 0, 117, 110, 255, 0, 117, 110, 255, 0, 117, 111, 255, 0, 117, 111, 255, 0, 117, 111, 255, 0, 118, 112, 255, 0, 118, 112, 255, 0, 118, 112, 255, 0, 118, 113, 255, 0, 118, 113, 255, 0, 118, 114, 255, 0, 119, 114, 255, 0, 119, 114, 255, 0, 119, 115, 255, 0, 119, 115, 255, 0, 119, 116, 255, 0, 119, 116, 255, 0, 120, 116, 255, 0, 120, 117, 255, 0, 120, 117, 255, 0, 120, 117, 255, 0, 120, 118, 255, 0, 120, 118, 255, 0, 121, 119, 255, 0, 121, 119, 255, 0, 121, 119, 255, 0, 121, 120, 255, 0, 121, 120, 255, 0, 121, 121, 255, 0, 121, 121, 255, 0, 122, 121, 255, 0, 122, 122, 255, 0, 122, 122, 255, 0, 122, 122, 255, 0, 122, 123, 255, 0, 122, 123, 255, 0, 123, 124, 255, 0, 123, 124, 255, 0, 123, 124, 255, 0, 123, 125, 255, 0, 123, 125, 255, 0, 123, 125, 255, 0, 124, 126, 255, 0, 124, 126, 255, 0, 124, 127, 255, 0, 124, 127, 255, 0, 124, 127, 255, 0, 124, 128, 255, 0, 124, 128, 255, 0, 125, 128, 255, 0, 125, 129, 255, 0, 125, 129, 255, 0, 125, 130, 255, 0, 125, 130, 255, 0, 125, 130, 255, 0, 126, 131, 255, 0, 126, 131, 255, 0, 126, 131, 255, 0, 126, 132, 255, 0, 126, 132, 255, 0, 126, 132, 255, 0, 127, 133, 255, 0, 127, 133, 255, 0, 127, 134, 255, 0, 127, 134, 255, 0, 127, 134, 255, 0, 127, 135, 255, 0, 127, 135, 255, 0, 128, 135, 255, 0, 128, 136, 255, 0, 128, 136, 255, 0, 128, 136, 255, 0, 128, 137, 255, 1, 128, 137, 255, 2, 129, 137, 255, 1, 129, 138, 255, 0, 129, 138, 255, 0, 129, 139, 255, 0, 129, 139, 255, 0, 129, 140, 255, 0, 129, 140, 255, 0, 130, 141, 255, 0, 130, 141, 255, 0, 130, 142, 255, 0, 130, 142, 255, 0, 130, 142, 255, 0, 130, 143, 255, 0, 130, 143, 255, 0, 131, 144, 255, 0, 131, 144, 255, 0, 131, 145, 255, 0, 131, 145, 255, 0, 131, 146, 255, 0, 131, 146, 255, 0, 131, 147, 255, 0, 132, 147, 255, 0, 132, 147, 255, 0, 132, 148, 255, 0, 132, 148, 255, 0, 132, 149, 255, 0, 132, 149, 255, 0, 132, 150, 255, 0, 133, 150, 255, 0, 133, 151, 255, 0, 133, 151, 255, 0, 133, 152, 255, 0, 133, 152, 255, 0, 133, 152, 255, 0, 133, 153, 255, 0, 133, 153, 255, 0, 134, 154, 255, 0, 134, 154, 255, 0, 134, 155, 255, 0, 134, 155, 255, 0, 134, 156, 255, 0, 134, 156, 255, 0, 134, 156, 255, 0, 135, 157, 255, 0, 135, 157, 255, 0, 135, 158, 255, 0, 135, 158, 255, 0, 135, 159, 255, 0, 135, 159, 255, 0, 135, 160, 255, 0, 135, 160, 255, 0, 136, 160, 255, 0, 136, 161, 255, 0, 136, 161, 255, 0, 136, 162, 255, 0, 136, 162, 255, 0, 136, 163, 255, 0, 136, 163, 255, 0, 136, 164, 255, 0, 137, 164, 255, 0, 137, 164, 255, 0, 137, 165, 255, 0, 137, 165, 255, 0, 137, 166, 255, 0, 137, 166, 255, 0, 137, 167, 255, 0, 137, 167, 255, 0, 138, 167, 255, 1, 138, 168, 255, 2, 138, 168, 255, 3, 138, 169, 255, 4, 138, 169, 255, 5, 138, 170, 255, 6, 138, 170, 255, 7, 138, 170, 255, 8, 138, 171, 255, 9, 139, 171, 255, 10, 139, 172, 255, 11, 139, 172, 255, 12, 139, 173, 255, 13, 139, 173, 255, 14, 139, 173, 255, 15, 139, 174, 255, 16, 139, 174, 255, 17, 139, 175, 255, 18, 140, 175, 255, 19, 140, 175, 255, 20, 140, 176, 255, 21, 140, 176, 255, 22, 140, 177, 255, 23, 140, 177, 255, 24, 140, 177, 255, 24, 140, 178, 255, 25, 140, 178, 255, 26, 140, 179, 255, 27, 141, 179, 255, 28, 141, 179, 255, 29, 141, 180, 255, 30, 141, 180, 255, 30, 141, 181, 255, 31, 141, 181, 255, 32, 141, 181, 255, 33, 141, 182, 255, 34, 141, 182, 255, 34, 141, 183, 255, 35, 142, 183, 255, 36, 142, 183, 255, 37, 142, 184, 255, 38, 142, 184, 255, 39, 142, 185, 255, 39, 142, 185, 255, 40, 142, 185, 255, 41, 142, 186, 255, 42, 142, 186, 255, 42, 142, 186, 255, 43, 142, 187, 255, 44, 143, 187, 255, 45, 143, 188, 255, 46, 143, 188, 255, 46, 143, 188, 255, 47, 143, 189, 255, 48, 143, 189, 255, 49, 143, 189, 255, 50, 143, 190, 255, 50, 143, 190, 255, 51, 143, 190, 255, 52, 143, 191, 255, 53, 143, 191, 255, 54, 144, 192, 255, 54, 144, 192, 255, 54, 144, 192, 255, 55, 144, 192, 255, 55, 144, 192, 255, 56, 144, 192, 255, 56, 145, 192, 255, 57, 145, 192, 255, 57, 145, 192, 255, 58, 145, 193, 255, 58, 145, 193, 255, 59, 146, 193, 255, 59, 146, 193, 255, 59, 146, 193, 255, 60, 146, 193, 255, 60, 146, 193, 255, 61, 147, 193, 255, 61, 147, 193, 255, 62, 147, 194, 255, 62, 147, 194, 255, 62, 147, 194, 255, 63, 148, 194, 255, 63, 148, 194, 255, 64, 148, 194, 255, 64, 148, 194, 255, 65, 148, 194, 255, 65, 149, 195, 255, 65, 149, 195, 255, 66, 149, 195, 255, 66, 149, 195, 255, 67, 149, 195, 255, 67, 150, 195, 255, 68, 150, 195, 255, 68, 150, 195, 255, 68, 150, 195, 255, 69, 150, 196, 255, 69, 150, 196, 255, 70, 151, 196, 255, 70, 151, 196, 255, 70, 151, 196, 255, 71, 151, 196, 255, 71, 151, 196, 255, 72, 152, 196, 255, 72, 152, 197, 255, 72, 152, 197, 255, 73, 152, 197, 255, 73, 152, 197, 255, 73, 153, 197, 255, 74, 153, 197, 255, 74, 153, 197, 255, 75, 153, 197, 255, 75, 153, 197, 255, 75, 154, 198, 255, 76, 154, 198, 255, 76, 154, 198, 255, 77, 154, 198, 255, 77, 154, 198, 255, 77, 155, 198, 255, 78, 155, 198, 255, 78, 155, 198, 255, 78, 155, 198, 255, 79, 155, 199, 255, 79, 156, 199, 255, 80, 156, 199, 255, 80, 156, 199, 255, 80, 156, 199, 255, 81, 156, 199, 255, 81, 157, 199, 255, 81, 157, 199, 255, 82, 157, 200, 255, 82, 157, 200, 255, 83, 157, 200, 255, 83, 158, 200, 255, 83, 158, 200, 255, 84, 158, 200, 255, 84, 158, 200, 255, 84, 158, 200, 255, 85, 158, 200, 255, 85, 159, 201, 255, 85, 159, 201, 255, 86, 159, 201, 255, 86, 159, 201, 255, 87, 159, 201, 255, 87, 160, 201, 255, 87, 160, 201, 255, 88, 160, 201, 255, 88, 160, 202, 255, 88, 160, 202, 255, 89, 161, 202, 255, 89, 161, 202, 255, 89, 161, 202, 255, 90, 161, 202, 255, 90, 161, 202, 255, 90, 162, 202, 255, 91, 162, 202, 255, 91, 162, 203, 255, 92, 162, 203, 255, 92, 162, 203, 255, 92, 163, 203, 255, 93, 163, 203, 255, 93, 163, 203, 255, 93, 163, 203, 255, 94, 163, 203, 255, 94, 164, 204, 255, 94, 164, 204, 255, 95, 164, 204, 255, 95, 164, 204, 255, 95, 164, 204, 255, 96, 165, 204, 255, 96, 165, 204, 255, 96, 165, 204, 255, 97, 165, 204, 255, 97, 165, 205, 255, 97, 166, 205, 255, 98, 166, 205, 255, 98, 166, 205, 255, 98, 166, 205, 255, 99, 166, 205, 255, 99, 167, 205, 255, 99, 167, 205, 255, 100, 167, 206, 255, 100, 167, 206, 255, 100, 167, 206, 255, 101, 168, 206, 255, 101, 168, 206, 255, 101, 168, 206, 255, 102, 168, 206, 255, 102, 168, 206, 255, 103, 169, 207, 255, 103, 169, 207, 255, 104, 169, 207, 255, 104, 169, 207, 255, 105, 169, 207, 255, 105, 169, 207, 255, 106, 169, 207, 255, 107, 170, 207, 255, 107, 170, 207, 255, 108, 170, 208, 255, 108, 170, 208, 255, 109, 170, 208, 255, 110, 170, 208, 255, 110, 170, 208, 255, 111, 171, 208, 255, 111, 171, 208, 255, 112, 171, 208, 255, 112, 171, 209, 255, 113, 171, 209, 255, 114, 171, 209, 255, 114, 171, 209, 255, 115, 172, 209, 255, 115, 172, 209, 255, 116, 172, 209, 255, 116, 172, 209, 255, 117, 172, 209, 255, 117, 172, 210, 255, 118, 173, 210, 255, 119, 173, 210, 255, 119, 173, 210, 255, 120, 173, 210, 255, 120, 173, 210, 255, 121, 173, 210, 255, 121, 173, 210, 255, 122, 174, 210, 255, 122, 174, 210, 255, 123, 174, 211, 255, 123, 174, 211, 255, 124, 174, 211, 255, 124, 174, 211, 255, 125, 174, 211, 255, 125, 175, 211, 255, 126, 175, 211, 255, 126, 175, 211, 255, 127, 175, 211, 255, 128, 175, 212, 255, 128, 175, 212, 255, 129, 176, 212, 255, 129, 176, 212, 255, 130, 176, 212, 255, 130, 176, 212, 255, 131, 176, 212, 255, 131, 176, 212, 255, 132, 176, 212, 255, 132, 177, 212, 255, 133, 177, 213, 255, 133, 177, 213, 255, 134, 177, 213, 255, 134, 177, 213, 255, 135, 177, 213, 255, 135, 178, 213, 255, 136, 178, 213, 255, 136, 178, 213, 255, 137, 178, 213, 255, 137, 178, 213, 255, 137, 178, 213, 255, 138, 178, 214, 255, 138, 179, 214, 255, 139, 179, 214, 255, 139, 179, 214, 255, 140, 179, 214, 255, 140, 179, 214, 255, 141, 179, 214, 255, 141, 180, 214, 255, 142, 180, 214, 255, 142, 180, 214, 255, 143, 180, 214, 255, 143, 180, 215, 255, 144, 180, 215, 255, 144, 181, 215, 255, 145, 181, 215, 255, 145, 181, 215, 255, 146, 181, 215, 255, 146, 181, 215, 255, 146, 181, 215, 255, 147, 181, 215, 255, 147, 182, 215, 255, 148, 182, 215, 255, 148, 182, 215, 255, 149, 182, 216, 255, 149, 182, 216, 255, 150, 182, 216, 255, 150, 183, 216, 255, 151, 183, 216, 255, 151, 183, 216, 255, 151, 183, 216, 255, 152, 183, 216, 255, 152, 183, 216, 255, 153, 184, 216, 255, 153, 184, 216, 255, 154, 184, 216, 255, 154, 184, 217, 255, 155, 184, 217, 255, 155, 184, 217, 255, 155, 185, 217, 255, 156, 185, 217, 255, 156, 185, 217, 255, 157, 185, 217, 255, 157, 185, 217, 255, 158, 185, 217, 255, 158, 186, 217, 255, 158, 186, 217, 255, 159, 186, 217, 255, 159, 186, 217, 255, 160, 186, 217, 255, 160, 186, 218, 255, 161, 186, 218, 255, 161, 187, 218, 255, 161, 187, 218, 255, 162, 187, 218, 255, 162, 187, 218, 255, 163, 187, 218, 255, 163, 187, 218, 255, 163, 188, 218, 255, 164, 188, 218, 255, 164, 188, 218, 255, 165, 188, 218, 255, 165, 188, 218, 255, 165, 189, 218, 255, 166, 189, 219, 255, 166, 189, 219, 255, 167, 189, 219, 255, 167, 189, 219, 255, 167, 189, 219, 255, 168, 189, 219, 255, 168, 190, 219, 255, 168, 190, 219, 255, 169, 190, 219, 255, 169, 190, 220, 255, 170, 190, 220, 255, 170, 190, 220, 255, 170, 190, 220, 255, 171, 191, 220, 255, 171, 191, 220, 255, 171, 191, 220, 255, 172, 191, 220, 255, 172, 191, 220, 255, 172, 191, 220, 255, 173, 191, 220, 255, 173, 192, 221, 255, 174, 192, 221, 255, 174, 192, 221, 255, 174, 192, 221, 255, 175, 192, 221, 255, 175, 192, 221, 255, 175, 192, 221, 255, 176, 193, 221, 255, 176, 193, 221, 255, 176, 193, 221, 255, 177, 193, 222, 255, 177, 193, 222, 255, 177, 193, 222, 255, 178, 193, 222, 255, 178, 194, 222, 255, 179, 194, 222, 255, 179, 194, 222, 255, 179, 194, 222, 255, 180, 194, 222, 255, 180, 194, 222, 255, 180, 195, 222, 255, 181, 195, 223, 255, 181, 195, 223, 255, 181, 195, 223, 255, 182, 195, 223, 255, 182, 195, 223, 255, 182, 195, 223, 255, 183, 196, 223, 255, 183, 196, 223, 255, 183, 196, 223, 255, 184, 196, 223, 255, 184, 196, 223, 255, 184, 196, 223, 255, 185, 197, 224, 255, 185, 197, 224, 255, 185, 197, 224, 255, 186, 197, 224, 255, 186, 197, 224, 255, 186, 197, 224, 255, 187, 197, 224, 255, 187, 198, 224, 255, 187, 198, 224, 255, 188, 198, 224, 255, 188, 198, 224, 255, 188, 198, 224, 255, 189, 198, 225, 255, 189, 199, 225, 255, 189, 199, 225, 255, 190, 199, 225, 255, 190, 199, 225, 255, 190, 199, 225, 255, 191, 199, 225, 255, 191, 199, 225, 255, 191, 200, 225, 255, 192, 200, 225, 255, 192, 200, 225, 255, 192, 200, 225, 255, 193, 200, 226, 255, 193, 200, 226, 255, 193, 201, 226, 255, 193, 201, 226, 255, 194, 201, 226, 255, 194, 201, 226, 255, 194, 201, 226, 255, 195, 201, 226, 255, 195, 202, 226, 255, 195, 202, 226, 255, 196, 202, 226, 255, 196, 202, 226, 255, 196, 202, 227, 255, 197, 202, 227, 255, 197, 203, 227, 255, 197, 203, 227, 255, 198, 203, 227, 255, 198, 203, 227, 255, 198, 203, 227, 255, 198, 203, 227, 255, 199, 203, 227, 255, 199, 204, 227, 255, 199, 204, 227, 255, 200, 204, 227, 255, 200, 204, 227, 255, 200, 204, 228, 255, 201, 204, 228, 255, 201, 205, 228, 255, 201, 205, 228, 255, 201, 205, 228, 255, 202, 205, 228, 255, 202, 205, 228, 255, 202, 205, 228, 255, 203, 206, 228, 255, 203, 206, 228, 255, 203, 206, 228, 255, 204, 206, 228, 255, 204, 206, 228, 255, 204, 206, 229, 255, 204, 207, 229, 255, 205, 207, 229, 255, 205, 207, 229, 255, 205, 207, 229, 255, 206, 207, 229, 255, 206, 207, 229, 255, 206, 208, 229, 255, 206, 208, 229, 255, 207, 208, 229, 255, 207, 208, 229, 255, 207, 208, 229, 255, 207, 209, 229, 255, 208, 209, 230, 255, 208, 209, 230, 255, 208, 209, 230, 255, 208, 209, 230, 255, 209, 209, 230, 255, 209, 209, 230, 255, 209, 209, 230, 255, 209, 209, 230, 255, 210, 210, 230, 255, 210, 210, 230, 255, 210, 210, 230, 255, 210, 210, 230, 255, 211, 210, 231, 255, 211, 210, 231, 255, 211, 210, 231, 255, 211, 210, 231, 255, 212, 211, 231, 255, 212, 211, 231, 255, 212, 211, 231, 255, 212, 211, 231, 255, 213, 211, 231, 255, 213, 211, 231, 255, 213, 211, 231, 255, 213, 212, 231, 255, 214, 212, 232, 255, 214, 212, 232, 255, 214, 212, 232, 255, 214, 212, 232, 255, 214, 212, 232, 255, 215, 212, 232, 255, 215, 212, 232, 255, 215, 213, 232, 255, 215, 213, 232, 255, 216, 213, 232, 255, 216, 213, 232, 255, 216, 213, 232, 255, 216, 213, 232, 255, 217, 213, 233, 255, 217, 213, 233, 255, 217, 214, 233, 255, 217, 214, 233, 255, 217, 214, 233, 255, 218, 214, 233, 255, 218, 214, 233, 255, 218, 214, 233, 255, 218, 214, 233, 255, 219, 214, 233, 255, 219, 215, 233, 255, 219, 215, 233, 255, 219, 215, 234, 255, 219, 215, 234, 255, 220, 215, 234, 255, 220, 215, 234, 255, 220, 215, 234, 255, 220, 216, 234, 255, 221, 216, 234, 255, 221, 216, 234, 255, 221, 216, 234, 255, 221, 216, 234, 255, 221, 216, 234, 255, 222, 216, 234, 255, 222, 216, 234, 255, 222, 217, 235, 255, 222, 217, 235, 255, 223, 217, 235, 255, 223, 217, 235, 255, 223, 217, 235, 255, 223, 217, 235, 255, 223, 217, 235, 255, 224, 217, 235, 255, 224, 218, 235, 255, 224, 218, 235, 255, 224, 218, 235, 255, 225, 218, 235, 255, 225, 218, 235, 255, 225, 218, 235, 255, 225, 218, 236, 255, 225, 219, 236, 255, 226, 219, 236, 255, 226, 219, 236, 255, 226, 219, 236, 255, 226, 219, 236, 255, 226, 219, 236, 255, 227, 219, 236, 255, 227, 220, 236, 255, 227, 220, 236, 255, 227, 220, 236, 255, 228, 220, 236, 255, 228, 220, 236, 255, 228, 220, 237, 255, 228, 220, 237, 255, 228, 220, 237, 255, 229, 221, 237, 255, 229, 221, 237, 255, 229, 221, 237, 255, 229, 221, 237, 255, 229, 221, 237, 255, 230, 221, 237, 255, 230, 221, 237, 255, 230, 222, 237, 255, 230, 222, 237, 255, 230, 222, 237, 255, 231, 222, 238, 255, 231, 222, 238, 255, 231, 222, 238, 255, 231, 222, 238, 255, 231, 223, 238, 255, 232, 223, 238, 255, 232, 223, 238, 255, 232, 223, 238, 255, 232, 223, 238, 255, 232, 223, 238, 255, 233, 223, 238, 255, 233, 224, 238, 255, 233, 224, 238, 255, 233, 224, 239, 255, 233, 224, 239, 255, 234, 224, 239, 255, 234, 224, 239, 255, 234, 224, 239, 255, 234, 225, 239, 255, 234, 225, 239, 255, 235, 225, 239, 255, 235, 225, 239, 255, 235, 225, 239, 255, 235, 225, 239, 255, 235, 225, 239, 255, 235, 226, 239, 255, 236, 226, 240, 255, 236, 226, 240, 255, 236, 226, 240, 255, 236, 226, 240, 255, 236, 226, 240, 255, 237, 226, 240, 255, 237, 227, 240, 255, 237, 227, 240, 255, 237, 227, 240, 255, 237, 227, 240, 255, 238, 227, 240, 255, 238, 227, 240, 255, 238, 228, 240, 255, 238, 228, 240, 255, 238, 228, 241, 255, 238, 228, 241, 255, 239, 228, 241, 255, 239, 228, 241, 255, 239, 228, 241, 255, 239, 229, 241, 255, 239, 229, 241, 255, 239, 229, 241, 255, 240, 229, 241, 255, 240, 229, 241, 255, 240, 229, 241, 255, 240, 230, 241, 255, 240, 230, 241, 255, 240, 230, 241, 255, 241, 230, 242, 255, 241, 230, 242, 255, 241, 230, 242, 255, 241, 230, 242, 255, 241, 231, 242, 255, 241, 231, 242, 255, 242, 231, 242, 255, 242, 231, 242, 255, 242, 231, 242, 255, 242, 231, 242, 255, 242, 232, 242, 255, 242, 232, 242, 255, 243, 232, 242, 255, 243, 232, 242, 255, 243, 232, 243, 255, 243, 232, 243, 255, 243, 233, 243, 255, 243, 233, 243, 255, 244, 233, 243, 255, 244, 233, 243, 255, 244, 233, 243, 255, 244, 233, 243, 255, 244, 234, 243, 255, 244, 234, 243, 255, 245, 234, 243, 255, 245, 234, 243, 255, 245, 234, 244, 255, 245, 234, 244, 255, 245, 235, 244, 255, 245, 235, 244, 255, 245, 235, 244, 255, 246, 235, 244, 255, 246, 235, 244, 255, 246, 235, 244, 255, 246, 235, 244, 255, 246, 236, 244, 255, 246, 236, 244, 255, 246, 236, 244, 255, 247, 236, 245, 255, 247, 236, 245, 255, 247, 236, 245, 255, 247, 237, 245, 255, 247, 237, 245, 255, 247, 237, 245, 255, 247, 237, 245, 255, 248, 237, 245, 255, 248, 237, 245, 255, 248, 238, 245, 255, 248, 238, 245, 255, 248, 238, 245, 255, 248, 238, 246, 255, 248, 238, 246, 255, 249, 238, 246, 255, 249, 239, 246, 255, 249, 239, 246, 255, 249, 239, 246, 255, 249, 239, 246, 255, 249, 239, 246, 255, 249, 239, 246, 255, 250, 240, 246, 255, 250, 240, 246, 255, 250, 240, 247, 255, 250, 240, 247, 255, 250, 240, 247, 255, 250, 241, 247, 255, 250, 241, 247, 255, 250, 241, 247, 255, 251, 241, 247, 255, 251, 241, 247, 255, 251, 241, 247, 255, 251, 242, 247, 255, 251, 242, 248, 255, 251, 242, 248, 255, 251, 242, 248, 255, 252, 242, 248, 255, 252, 242, 248, 255, 252, 243, 248, 255, 252, 243, 248, 255, 252, 243, 248, 255, 252, 243, 248, 255, 252, 243, 248, 255, 252, 243, 249, 255, 252, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255
};
static const heatmap_colorscheme_t soft = { soft_data, sizeof(soft_data)/sizeof(soft_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_PuBuGn_soft = &soft;

static const unsigned char mixed_data[] = {
    0, 0, 0, 0, 1, 70, 53, 0, 1, 70, 54, 7, 1, 70, 54, 14, 1, 70, 54, 22, 1, 70, 54, 29, 1, 71, 55, 37, 1, 71, 55, 44, 1, 71, 55, 52, 1, 71, 55, 59, 1, 72, 55, 67, 1, 72, 56, 74, 1, 72, 56, 82, 1, 72, 56, 89, 1, 72, 56, 97, 1, 73, 56, 104, 1, 73, 57, 112, 1, 73, 57, 119, 1, 73, 57, 127, 1, 74, 57, 134, 1, 74, 57, 141, 1, 74, 58, 149, 1, 74, 58, 156, 1, 75, 58, 164, 1, 75, 58, 171, 1, 75, 58, 179, 1, 75, 59, 186, 1, 75, 59, 194, 1, 76, 59, 201, 1, 76, 59, 209, 1, 76, 60, 216, 1, 76, 60, 224, 1, 77, 60, 231, 1, 77, 60, 239, 1, 77, 60, 246, 1, 77, 61, 254, 1, 78, 61, 255, 1, 78, 61, 255, 1, 78, 61, 255, 1, 78, 61, 255, 1, 79, 62, 255, 1, 79, 62, 255, 1, 79, 62, 255, 1, 79, 62, 255, 1, 79, 63, 255, 1, 80, 63, 255, 1, 80, 63, 255, 1, 80, 63, 255, 1, 80, 63, 255, 1, 81, 64, 255, 1, 81, 64, 255, 1, 81, 64, 255, 1, 81, 64, 255, 1, 82, 64, 255, 1, 82, 65, 255, 1, 82, 65, 255, 1, 82, 65, 255, 1, 83, 65, 255, 1, 83, 66, 255, 1, 83, 66, 255, 1, 83, 66, 255, 1, 83, 66, 255, 1, 84, 66, 255, 1, 84, 67, 255, 1, 84, 67, 255, 1, 92, 74, 255, 1, 92, 74, 255, 1, 92, 74, 255, 1, 93, 75, 255, 1, 93, 75, 255, 1, 93, 75, 255, 1, 93, 75, 255, 1, 94, 76, 255, 1, 94, 76, 255, 1, 94, 76, 255, 1, 94, 76, 255, 1, 95, 76, 255, 1, 95, 77, 255, 1, 95, 77, 255, 1, 95, 77, 255, 1, 96, 77, 255, 1, 96, 78, 255, 1, 96, 78, 255, 1, 96, 78, 255, 1, 97, 78, 255, 1, 97, 78, 255, 1, 97, 79, 255, 1, 97, 79, 255, 1, 98, 79, 255, 1, 98, 79, 255, 1, 98, 80, 255, 1, 98, 80, 255, 1, 98, 80, 255, 1, 99, 80, 255, 1, 99, 80, 255, 1, 99, 81, 255, 1, 99, 81, 255, 1, 100, 81, 255, 1, 100, 81, 255, 1, 100, 82, 255, 1, 100, 82, 255, 1, 101, 82, 255, 1, 101, 82, 255, 1, 101, 83, 255, 1, 101, 83, 255, 1, 102, 83, 255, 1, 102, 83, 255, 1, 102, 83, 255, 1, 102, 84, 255, 1, 103, 84, 255, 1, 103, 84, 255, 1, 103, 84, 255, 1, 103, 85, 255, 1, 104, 85, 255, 1, 104, 85, 255, 1, 104, 85, 255, 1, 104, 85, 255, 1, 105, 86, 255, 1, 105, 86, 255, 1, 105, 86, 255, 1, 105, 86, 255, 1, 106, 87, 255, 1, 106, 87, 255, 1, 106, 87, 255, 1, 106, 87, 255, 1, 107, 88, 255, 1, 107, 88, 255, 1, 107, 88, 255, 1, 107, 88, 255, 1, 108, 88, 255, 0, 108, 89, 255, 0, 108, 89, 255, 0, 108, 89, 255, 0, 108, 90, 255, 0, 108, 90, 255, 0, 108, 90, 255, 0, 108, 91, 255, 0, 109, 91, 255, 0, 109, 91, 255, 0, 109, 92, 255, 0, 109, 92, 255, 0, 109, 92, 255, 0, 109, 93, 255, 0, 109, 93, 255, 0, 110, 93, 255, 0, 110, 94, 255, 0, 110, 94, 255, 0, 110, 94, 255, 0, 110, 95, 255, 0, 110, 95, 255, 0, 110, 95, 255, 0, 111, 95, 255, 0, 111, 96, 255, 0, 111, 96, 255, 0, 111, 96, 255, 0, 111, 97, 255, 0, 111, 97, 255, 0, 111, 97, 255, 0, 112, 98, 255, 0, 112, 98, 255, 0, 112, 98, 255, 0, 112, 99, 255, 0, 112, 99, 255, 0, 112, 99, 255, 0, 112, 100, 255, 0, 112, 100, 255, 0, 113, 100, 255, 0, 113, 100, 255, 0, 113, 101, 255, 0, 113, 101, 255, 0, 113, 101, 255, 0, 113, 102, 255, 0, 113, 102, 255, 0, 114, 102, 255, 0, 114, 103, 255, 0, 114, 103, 255, 0, 114, 103, 255, 0, 114, 104, 255, 0, 114, 104, 255, 0, 114, 104, 255, 0, 114, 105, 255, 0, 115, 105, 255, 0, 115, 105, 255, 0, 115, 105, 255, 0, 115, 106, 255, 0, 115, 106, 255, 0, 115, 106, 255, 0, 115, 107, 255, 0, 116, 107, 255, 0, 116, 107, 255, 0, 116, 108, 255, 0, 116, 108, 255, 0, 116, 108, 255, 0, 120, 118, 255, 0, 121, 119, 255, 0, 121, 119, 255, 0, 121, 119, 255, 0, 121, 120, 255, 0, 121, 120, 255, 0, 121, 120, 255, 0, 121, 121, 255, 0, 121, 121, 255, 0, 122, 121, 255, 0, 122, 121, 255, 0, 122, 122, 255, 0, 122, 122, 255, 0, 122, 122, 255, 0, 122, 123, 255, 0, 122, 123, 255, 0, 122, 123, 255, 0, 123, 124, 255, 0, 123, 124, 255, 0, 123, 124, 255, 0, 123, 125, 255, 0, 123, 125, 255, 0, 123, 125, 255, 0, 123, 125, 255, 0, 124, 126, 255, 0, 124, 126, 255, 0, 124, 126, 255, 0, 124, 127, 255, 0, 124, 127, 255, 0, 124, 127, 255, 0, 124, 128, 255, 0, 124, 128, 255, 0, 125, 128, 255, 0, 125, 128, 255, 0, 125, 129, 255, 0, 125, 129, 255, 0, 125, 129, 255, 0, 125, 130, 255, 0, 125, 130, 255, 0, 125, 130, 255, 0, 126, 131, 255, 0, 126, 131, 255, 0, 126, 131, 255, 0, 126, 131, 255, 0, 126, 132, 255, 0, 126, 132, 255, 0, 126, 132, 255, 0, 126, 133, 255, 0, 127, 133, 255, 0, 127, 133, 255, 0, 127, 133, 255, 0, 127, 134, 255, 0, 127, 134, 255, 0, 127, 134, 255, 0, 127, 135, 255, 0, 127, 135, 255, 0, 128, 135, 255, 0, 128, 135, 255, 0, 128, 136, 255, 0, 128, 136, 255, 0, 128, 136, 255, 0, 128, 137, 255, 0, 128, 137, 255, 1, 128, 137, 255, 2, 129, 137, 255, 1, 129, 138, 255, 1, 129, 138, 255, 0, 129, 139, 255, 0, 129, 139, 255, 0, 129, 139, 255, 0, 129, 140, 255, 0, 129, 140, 255, 0, 129, 140, 255, 0, 130, 141, 255, 0, 130, 141, 255, 0, 130, 141, 255, 0, 130, 142, 255, 0, 130, 142, 255, 0, 130, 143, 255, 0, 130, 143, 255, 0, 130, 143, 255, 0, 130, 144, 255, 0, 131, 144, 255, 0, 131, 144, 255, 0, 131, 145, 255, 0, 131, 145, 255, 0, 131, 145, 255, 0, 131, 146, 255, 0, 131, 146, 255, 0, 131, 147, 255, 0, 132, 147, 255, 0, 132, 147, 255, 0, 132, 148, 255, 0, 132, 148, 255, 0, 132, 148, 255, 0, 132, 149, 255, 0, 132, 149, 255, 0, 132, 149, 255, 0, 132, 150, 255, 0, 132, 150, 255, 0, 133, 151, 255, 0, 133, 151, 255, 0, 133, 151, 255, 0, 133, 152, 255, 0, 133, 152, 255, 0, 133, 152, 255, 0, 133, 153, 255, 0, 133, 153, 255, 0, 133, 153, 255, 0, 134, 154, 255, 0, 134, 154, 255, 0, 134, 154, 255, 0, 134, 155, 255, 0, 134, 155, 255, 0, 134, 156, 255, 0, 134, 156, 255, 0, 134, 156, 255, 0, 134, 157, 255, 0, 134, 157, 255, 0, 135, 157, 255, 0, 135, 158, 255, 0, 135, 158, 255, 0, 135, 158, 255, 0, 135, 159, 255, 0, 135, 159, 255, 0, 135, 159, 255, 0, 135, 160, 255, 0, 135, 160, 255, 10, 138, 171, 255, 10, 139, 172, 255, 10, 139, 172, 255, 11, 139, 172, 255, 12, 139, 173, 255, 12, 139, 173, 255, 13, 139, 173, 255, 14, 139, 174, 255, 15, 139, 174, 255, 15, 139, 174, 255, 16, 139, 175, 255, 17, 139, 175, 255, 18, 140, 175, 255, 19, 140, 176, 255, 20, 140, 176, 255, 21, 140, 176, 255, 21, 140, 177, 255, 22, 140, 177, 255, 23, 140, 177, 255, 24, 140, 178, 255, 25, 140, 178, 255, 25, 140, 178, 255, 26, 140, 179, 255, 27, 140, 179, 255, 27, 141, 179, 255, 28, 141, 180, 255, 29, 141, 180, 255, 30, 141, 180, 255, 30, 141, 181, 255, 31, 141, 181, 255, 32, 141, 181, 255, 32, 141, 182, 255, 33, 141, 182, 255, 34, 141, 182, 255, 34, 141, 183, 255, 35, 141, 183, 255, 36, 142, 183, 255, 36, 142, 183, 255, 37, 142, 184, 255, 38, 142, 184, 255, 38, 142, 184, 255, 39, 142, 185, 255, 40, 142, 185, 255, 40, 142, 185, 255, 41, 142, 186, 255, 42, 142, 186, 255, 42, 142, 186, 255, 43, 142, 187, 255, 43, 142, 187, 255, 44, 143, 187, 255, 45, 143, 187, 255, 45, 143, 188, 255, 46, 143, 188, 255, 47, 143, 188, 255, 47, 143, 189, 255, 48, 143, 189, 255, 48, 143, 189, 255, 49, 143, 190, 255, 50, 143, 190, 255, 50, 143, 190, 255, 51, 143, 190, 255, 52, 143, 191, 255, 52, 143, 191, 255, 53, 143, 191, 255, 54, 144, 192, 255, 54, 144, 192, 255, 54, 144, 192, 255, 55, 144, 192, 255, 55, 144, 192, 255, 55, 144, 192, 255, 56, 144, 192, 255, 56, 145, 192, 255, 56, 145, 192, 255, 57, 145, 192, 255, 57, 145, 192, 255, 58, 145, 193, 255, 58, 145, 193, 255, 58, 146, 193, 255, 59, 146, 193, 255, 59, 146, 193, 255, 59, 146, 193, 255, 60, 146, 193, 255, 60, 146, 193, 255, 60, 146, 193, 255, 61, 147, 193, 255, 61, 147, 193, 255, 61, 147, 194, 255, 62, 147, 194, 255, 62, 147, 194, 255, 62, 147, 194, 255, 63, 148, 194, 255, 63, 148, 194, 255, 63, 148, 194, 255, 64, 148, 194, 255, 64, 148, 194, 255, 64, 148, 194, 255, 65, 148, 194, 255, 65, 149, 195, 255, 65, 149, 195, 255, 66, 149, 195, 255, 66, 149, 195, 255, 66, 149, 195, 255, 67, 149, 195, 255, 67, 150, 195, 255, 67, 150, 195, 255, 68, 150, 195, 255, 68, 150, 195, 255, 68, 150, 196, 255, 69, 150, 196, 255, 69, 150, 196, 255, 69, 151, 196, 255, 69, 151, 196, 255, 70, 151, 196, 255, 70, 151, 196, 255, 70, 151, 196, 255, 71, 151, 196, 255, 71, 152, 196, 255, 71, 152, 196, 255, 72, 152, 197, 255, 72, 152, 197, 255, 72, 152, 197, 255, 73, 152, 197, 255, 73, 153, 197, 255, 73, 153, 197, 255, 73, 153, 197, 255, 74, 153, 197, 255, 74, 153, 197, 255, 74, 153, 197, 255, 84, 158, 200, 255, 85, 159, 201, 255, 85, 159, 201, 255, 85, 159, 201, 255, 86, 159, 201, 255, 86, 159, 201, 255, 86, 159, 201, 255, 87, 160, 201, 255, 87, 160, 201, 255, 87, 160, 201, 255, 87, 160, 201, 255, 88, 160, 201, 255, 88, 160, 202, 255, 88, 160, 202, 255, 89, 161, 202, 255, 89, 161, 202, 255, 89, 161, 202, 255, 89, 161, 202, 255, 90, 161, 202, 255, 90, 161, 202, 255, 90, 162, 202, 255, 91, 162, 202, 255, 91, 162, 203, 255, 91, 162, 203, 255, 91, 162, 203, 255, 92, 162, 203, 255, 92, 163, 203, 255, 92, 163, 203, 255, 93, 163, 203, 255, 93, 163, 203, 255, 93, 163, 203, 255, 93, 163, 203, 255, 94, 163, 203, 255, 94, 164, 204, 255, 94, 164, 204, 255, 95, 164, 204, 255, 95, 164, 204, 255, 95, 164, 204, 255, 95, 164, 204, 255, 96, 165, 204, 255, 96, 165, 204, 255, 96, 165, 204, 255, 96, 165, 204, 255, 97, 165, 205, 255, 97, 165, 205, 255, 97, 166, 205, 255, 98, 166, 205, 255, 98, 166, 205, 255, 98, 166, 205, 255, 98, 166, 205, 255, 99, 166, 205, 255, 99, 166, 205, 255, 99, 167, 205, 255, 100, 167, 205, 255, 100, 167, 206, 255, 100, 167, 206, 255, 100, 167, 206, 255, 101, 167, 206, 255, 101, 168, 206, 255, 101, 168, 206, 255, 101, 168, 206, 255, 102, 168, 206, 255, 102, 168, 206, 255, 102, 168, 206, 255, 103, 169, 207, 255, 103, 169, 207, 255, 103, 169, 207, 255, 104, 169, 207, 255, 104, 169, 207, 255, 105, 169, 207, 255, 105, 169, 207, 255, 106, 169, 207, 255, 106, 169, 207, 255, 107, 170, 207, 255, 107, 170, 207, 255, 108, 170, 208, 255, 108, 170, 208, 255, 109, 170, 208, 255, 109, 170, 208, 255, 110, 170, 208, 255, 110, 170, 208, 255, 110, 171, 208, 255, 111, 171, 208, 255, 111, 171, 208, 255, 112, 171, 208, 255, 112, 171, 208, 255, 113, 171, 209, 255, 113, 171, 209, 255, 114, 171, 209, 255, 114, 171, 209, 255, 114, 172, 209, 255, 115, 172, 209, 255, 115, 172, 209, 255, 116, 172, 209, 255, 116, 172, 209, 255, 117, 172, 209, 255, 117, 172, 209, 255, 117, 172, 210, 255, 118, 173, 210, 255, 118, 173, 210, 255, 119, 173, 210, 255, 119, 173, 210, 255, 120, 173, 210, 255, 120, 173, 210, 255, 120, 173, 210, 255, 121, 173, 210, 255, 121, 174, 210, 255, 122, 174, 210, 255, 122, 174, 210, 255, 123, 174, 211, 255, 123, 174, 211, 255, 123, 174, 211, 255, 124, 174, 211, 255, 124, 174, 211, 255, 125, 175, 211, 255, 125, 175, 211, 255, 125, 175, 211, 255, 126, 175, 211, 255, 126, 175, 211, 255, 127, 175, 211, 255, 127, 175, 211, 255, 127, 175, 211, 255, 128, 175, 212, 255, 128, 176, 212, 255, 129, 176, 212, 255, 129, 176, 212, 255, 129, 176, 212, 255, 130, 176, 212, 255, 143, 180, 214, 255, 143, 180, 214, 255, 143, 180, 215, 255, 144, 181, 215, 255, 144, 181, 215, 255, 145, 181, 215, 255, 145, 181, 215, 255, 145, 181, 215, 255, 146, 181, 215, 255, 146, 181, 215, 255, 147, 181, 215, 255, 147, 182, 215, 255, 147, 182, 215, 255, 148, 182, 215, 255, 148, 182, 215, 255, 148, 182, 215, 255, 149, 182, 216, 255, 149, 182, 216, 255, 150, 182, 216, 255, 150, 183, 216, 255, 150, 183, 216, 255, 151, 183, 216, 255, 151, 183, 216, 255, 151, 183, 216, 255, 152, 183, 216, 255, 152, 183, 216, 255, 152, 184, 216, 255, 153, 184, 216, 255, 153, 184, 216, 255, 154, 184, 216, 255, 154, 184, 216, 255, 154, 184, 217, 255, 155, 184, 217, 255, 155, 184, 217, 255, 155, 185, 217, 255, 156, 185, 217, 255, 156, 185, 217, 255, 156, 185, 217, 255, 157, 185, 217, 255, 157, 185, 217, 255, 157, 185, 217, 255, 158, 185, 217, 255, 158, 186, 217, 255, 158, 186, 217, 255, 159, 186, 217, 255, 159, 186, 217, 255, 159, 186, 217, 255, 160, 186, 218, 255, 160, 186, 218, 255, 160, 187, 218, 255, 161, 187, 218, 255, 161, 187, 218, 255, 162, 187, 218, 255, 162, 187, 218, 255, 162, 187, 218, 255, 163, 187, 218, 255, 163, 187, 218, 255, 163, 188, 218, 255, 164, 188, 218, 255, 164, 188, 218, 255, 164, 188, 218, 255, 165, 188, 218, 255, 165, 188, 218, 255, 165, 188, 218, 255, 165, 189, 218, 255, 166, 189, 219, 255, 166, 189, 219, 255, 166, 189, 219, 255, 167, 189, 219, 255, 167, 189, 219, 255, 167, 189, 219, 255, 168, 189, 219, 255, 168, 189, 219, 255, 168, 190, 219, 255, 168, 190, 219, 255, 169, 190, 219, 255, 169, 190, 219, 255, 169, 190, 220, 255, 170, 190, 220, 255, 170, 190, 220, 255, 170, 190, 220, 255, 171, 190, 220, 255, 171, 191, 220, 255, 171, 191, 220, 255, 171, 191, 220, 255, 172, 191, 220, 255, 172, 191, 220, 255, 172, 191, 220, 255, 173, 191, 220, 255, 173, 191, 220, 255, 173, 192, 221, 255, 173, 192, 221, 255, 174, 192, 221, 255, 174, 192, 221, 255, 174, 192, 221, 255, 175, 192, 221, 255, 175, 192, 221, 255, 175, 192, 221, 255, 175, 192, 221, 255, 176, 193, 221, 255, 176, 193, 221, 255, 176, 193, 221, 255, 176, 193, 221, 255, 177, 193, 221, 255, 177, 193, 222, 255, 177, 193, 222, 255, 178, 193, 222, 255, 178, 194, 222, 255, 178, 194, 222, 255, 178, 194, 222, 255, 179, 194, 222, 255, 179, 194, 222, 255, 179, 194, 222, 255, 180, 194, 222, 255, 180, 194, 222, 255, 180, 195, 222, 255, 180, 195, 222, 255, 181, 195, 222, 255, 181, 195, 223, 255, 181, 195, 223, 255, 181, 195, 223, 255, 182, 195, 223, 255, 182, 195, 223, 255, 182, 196, 223, 255, 182, 196, 223, 255, 183, 196, 223, 255, 183, 196, 223, 255, 183, 196, 223, 255, 192, 200, 225, 255, 192, 200, 225, 255, 192, 200, 226, 255, 193, 201, 226, 255, 193, 201, 226, 255, 193, 201, 226, 255, 193, 201, 226, 255, 194, 201, 226, 255, 194, 201, 226, 255, 194, 201, 226, 255, 195, 201, 226, 255, 195, 202, 226, 255, 195, 202, 226, 255, 195, 202, 226, 255, 196, 202, 226, 255, 196, 202, 226, 255, 196, 202, 226, 255, 196, 202, 227, 255, 197, 202, 227, 255, 197, 203, 227, 255, 197, 203, 227, 255, 197, 203, 227, 255, 198, 203, 227, 255, 198, 203, 227, 255, 198, 203, 227, 255, 198, 203, 227, 255, 199, 203, 227, 255, 199, 204, 227, 255, 199, 204, 227, 255, 199, 204, 227, 255, 200, 204, 227, 255, 200, 204, 227, 255, 200, 204, 228, 255, 200, 204, 228, 255, 201, 204, 228, 255, 201, 205, 228, 255, 201, 205, 228, 255, 201, 205, 228, 255, 201, 205, 228, 255, 202, 205, 228, 255, 202, 205, 228, 255, 202, 205, 228, 255, 202, 206, 228, 255, 203, 206, 228, 255, 203, 206, 228, 255, 203, 206, 228, 255, 203, 206, 228, 255, 204, 206, 228, 255, 204, 206, 229, 255, 204, 206, 229, 255, 204, 207, 229, 255, 205, 207, 229, 255, 205, 207, 229, 255, 205, 207, 229, 255, 205, 207, 229, 255, 205, 207, 229, 255, 206, 207, 229, 255, 206, 208, 229, 255, 206, 208, 229, 255, 206, 208, 229, 255, 207, 208, 229, 255, 207, 208, 229, 255, 207, 208, 229, 255, 207, 208, 229, 255, 207, 209, 229, 255, 208, 209, 230, 255, 208, 209, 230, 255, 208, 209, 230, 255, 208, 209, 230, 255, 208, 209, 230, 255, 209, 209, 230, 255, 209, 209, 230, 255, 209, 209, 230, 255, 209, 209, 230, 255, 209, 209, 230, 255, 210, 210, 230, 255, 210, 210, 230, 255, 210, 210, 230, 255, 210, 210, 230, 255, 210, 210, 230, 255, 211, 210, 231, 255, 211, 210, 231, 255, 211, 210, 231, 255, 211, 210, 231, 255, 211, 211, 231, 255, 212, 211, 231, 255, 212, 211, 231, 255, 212, 211, 231, 255, 212, 211, 231, 255, 212, 211, 231, 255, 212, 211, 231, 255, 213, 211, 231, 255, 213, 211, 231, 255, 213, 211, 231, 255, 213, 212, 231, 255, 213, 212, 232, 255, 214, 212, 232, 255, 214, 212, 232, 255, 214, 212, 232, 255, 214, 212, 232, 255, 214, 212, 232, 255, 215, 212, 232, 255, 215, 212, 232, 255, 215, 212, 232, 255, 215, 213, 232, 255, 215, 213, 232, 255, 215, 213, 232, 255, 216, 213, 232, 255, 216, 213, 232, 255, 216, 213, 232, 255, 216, 213, 232, 255, 216, 213, 233, 255, 217, 213, 233, 255, 217, 213, 233, 255, 217, 214, 233, 255, 217, 214, 233, 255, 217, 214, 233, 255, 217, 214, 233, 255, 218, 214, 233, 255, 218, 214, 233, 255, 218, 214, 233, 255, 218, 214, 233, 255, 218, 214, 233, 255, 219, 215, 233, 255, 219, 215, 233, 255, 219, 215, 233, 255, 219, 215, 233, 255, 219, 215, 234, 255, 225, 218, 236, 255, 225, 219, 236, 255, 225, 219, 236, 255, 226, 219, 236, 255, 226, 219, 236, 255, 226, 219, 236, 255, 226, 219, 236, 255, 226, 219, 236, 255, 226, 219, 236, 255, 227, 219, 236, 255, 227, 220, 236, 255, 227, 220, 236, 255, 227, 220, 236, 255, 227, 220, 236, 255, 227, 220, 236, 255, 228, 220, 236, 255, 228, 220, 237, 255, 228, 220, 237, 255, 228, 220, 237, 255, 228, 220, 237, 255, 228, 221, 237, 255, 229, 221, 237, 255, 229, 221, 237, 255, 229, 221, 237, 255, 229, 221, 237, 255, 229, 221, 237, 255, 229, 221, 237, 255, 230, 221, 237, 255, 230, 221, 237, 255, 230, 222, 237, 255, 230, 222, 237, 255, 230, 222, 237, 255, 230, 222, 238, 255, 231, 222, 238, 255, 231, 222, 238, 255, 231, 222, 238, 255, 231, 222, 238, 255, 231, 222, 238, 255, 231, 223, 238, 255, 232, 223, 238, 255, 232, 223, 238, 255, 232, 223, 238, 255, 232, 223, 238, 255, 232, 223, 238, 255, 232, 223, 238, 255, 233, 223, 238, 255, 233, 223, 238, 255, 233, 224, 238, 255, 233, 224, 239, 255, 233, 224, 239, 255, 233, 224, 239, 255, 233, 224, 239, 255, 234, 224, 239, 255, 234, 224, 239, 255, 234, 224, 239, 255, 234, 224, 239, 255, 234, 225, 239, 255, 234, 225, 239, 255, 235, 225, 239, 255, 235, 225, 239, 255, 235, 225, 239, 255, 235, 225, 239, 255, 235, 225, 239, 255, 235, 225, 239, 255, 235, 226, 239, 255, 236, 226, 240, 255, 236, 226, 240, 255, 236, 226, 240, 255, 236, 226, 240, 255, 236, 226, 240, 255, 236, 226, 240, 255, 237, 226, 240, 255, 237, 226, 240, 255, 237, 227, 240, 255, 237, 227, 240, 255, 237, 227, 240, 255, 237, 227, 240, 255, 237, 227, 240, 255, 238, 227, 240, 255, 238, 227, 240, 255, 238, 227, 240, 255, 238, 228, 240, 255, 238, 228, 240, 255, 238, 228, 241, 255, 238, 228, 241, 255, 239, 228, 241, 255, 239, 228, 241, 255, 239, 228, 241, 255, 239, 228, 241, 255, 239, 229, 241, 255, 239, 229, 241, 255, 239, 229, 241, 255, 239, 229, 241, 255, 240, 229, 241, 255, 240, 229, 241, 255, 240, 229, 241, 255, 240, 229, 241, 255, 240, 230, 241, 255, 240, 230, 241, 255, 240, 230, 241, 255, 241, 230, 242, 255, 241, 230, 242, 255, 241, 230, 242, 255, 241, 230, 242, 255, 241, 231, 242, 255, 241, 231, 242, 255, 241, 231, 242, 255, 241, 231, 242, 255, 242, 231, 242, 255, 242, 231, 242, 255, 242, 231, 242, 255, 242, 231, 242, 255, 242, 232, 242, 255, 242, 232, 242, 255, 242, 232, 242, 255, 242, 232, 242, 255, 243, 232, 243, 255, 243, 232, 243, 255, 243, 232, 243, 255, 243, 232, 243, 255, 243, 233, 243, 255, 243, 233, 243, 255, 243, 233, 243, 255, 243, 233, 243, 255, 244, 233, 243, 255, 244, 233, 243, 255, 244, 233, 243, 255, 244, 233, 243, 255, 248, 238, 246, 255, 248, 238, 246, 255, 248, 238, 246, 255, 248, 238, 246, 255, 248, 238, 246, 255, 248, 238, 246, 255, 249, 239, 246, 255, 249, 239, 246, 255, 249, 239, 246, 255, 249, 239, 246, 255, 249, 239, 246, 255, 249, 239, 246, 255, 249, 239, 246, 255, 249, 240, 246, 255, 249, 240, 246, 255, 250, 240, 247, 255, 250, 240, 247, 255, 250, 240, 247, 255, 250, 240, 247, 255, 250, 240, 247, 255, 250, 240, 247, 255, 250, 241, 247, 255, 250, 241, 247, 255, 250, 241, 247, 255, 251, 241, 247, 255, 251, 241, 247, 255, 251, 241, 247, 255, 251, 241, 247, 255, 251, 242, 248, 255, 251, 242, 248, 255, 251, 242, 248, 255, 251, 242, 248, 255, 251, 242, 248, 255, 251, 242, 248, 255, 252, 242, 248, 255, 252, 243, 248, 255, 252, 243, 248, 255, 252, 243, 248, 255, 252, 243, 248, 255, 252, 243, 248, 255, 252, 243, 248, 255, 252, 243, 249, 255, 252, 243, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255
};
static const heatmap_colorscheme_t mixed = { mixed_data, sizeof(mixed_data)/sizeof(mixed_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_PuBuGn_mixed = &mixed;

static const unsigned char mixed_exp_data[] = {
    0, 0, 0, 0, 1, 70, 53, 0, 1, 72, 56, 24, 1, 74, 58, 49, 1, 76, 60, 74, 1, 79, 62, 99, 1, 81, 64, 124, 1, 83, 66, 149, 1, 93, 75, 174, 1, 95, 77, 199, 1, 97, 79, 224, 1, 100, 81, 249, 1, 102, 83, 255, 1, 104, 85, 255, 1, 106, 87, 255, 0, 108, 90, 255, 0, 109, 92, 255, 0, 110, 95, 255, 0, 112, 98, 255, 0, 113, 101, 255, 0, 114, 103, 255, 0, 115, 106, 255, 0, 116, 108, 255, 0, 121, 121, 255, 0, 123, 123, 255, 0, 124, 126, 255, 0, 125, 128, 255, 0, 126, 131, 255, 0, 127, 133, 255, 0, 128, 135, 255, 1, 128, 137, 255, 0, 129, 140, 255, 0, 130, 143, 255, 0, 131, 146, 255, 0, 132, 148, 255, 0, 133, 151, 255, 0, 134, 154, 255, 0, 134, 156, 255, 0, 135, 159, 255, 11, 139, 172, 255, 16, 139, 174, 255, 22, 140, 177, 255, 27, 141, 179, 255, 32, 141, 181, 255, 36, 142, 184, 255, 41, 142, 186, 255, 45, 143, 188, 255, 49, 143, 190, 255, 53, 143, 191, 255, 56, 144, 192, 255, 58, 145, 193, 255, 60, 146, 193, 255, 63, 147, 194, 255, 65, 148, 194, 255, 67, 149, 195, 255, 69, 150, 196, 255, 71, 151, 196, 255, 72, 152, 197, 255, 74, 153, 197, 255, 86, 159, 201, 255, 88, 160, 201, 255, 89, 161, 202, 255, 91, 162, 203, 255, 92, 163, 203, 255, 94, 164, 204, 255, 96, 165, 204, 255, 97, 165, 205, 255, 99, 166, 205, 255, 100, 167, 206, 255, 102, 168, 206, 255, 104, 169, 207, 255, 106, 169, 207, 255, 109, 170, 208, 255, 111, 171, 208, 255, 113, 171, 209, 255, 115, 172, 209, 255, 118, 172, 210, 255, 120, 173, 210, 255, 122, 174, 210, 255, 124, 174, 211, 255, 126, 175, 211, 255, 128, 175, 212, 255, 130, 176, 212, 255, 144, 181, 215, 255, 146, 181, 215, 255, 148, 182, 215, 255, 149, 182, 216, 255, 151, 183, 216, 255, 153, 184, 216, 255, 154, 184, 217, 255, 156, 185, 217, 255, 157, 185, 217, 255, 159, 186, 217, 255, 160, 186, 218, 255, 162, 187, 218, 255, 163, 188, 218, 255, 165, 188, 218, 255, 166, 189, 219, 255, 167, 189, 219, 255, 168, 190, 219, 255, 170, 190, 220, 255, 171, 191, 220, 255, 172, 191, 220, 255, 173, 191, 220, 255, 174, 192, 221, 255, 175, 192, 221, 255, 176, 193, 221, 255, 177, 193, 222, 255, 178, 194, 222, 255, 179, 194, 222, 255, 180, 195, 222, 255, 181, 195, 223, 255, 182, 196, 223, 255, 183, 196, 223, 255, 192, 200, 226, 255, 193, 201, 226, 255, 194, 201, 226, 255, 195, 202, 226, 255, 196, 202, 226, 255, 197, 203, 227, 255, 198, 203, 227, 255, 198, 203, 227, 255, 199, 204, 227, 255, 200, 204, 228, 255, 201, 205, 228, 255, 202, 205, 228, 255, 202, 205, 228, 255, 203, 206, 228, 255, 204, 206, 228, 255, 204, 207, 229, 255, 205, 207, 229, 255, 206, 207, 229, 255, 206, 208, 229, 255, 207, 208, 229, 255, 208, 209, 230, 255, 208, 209, 230, 255, 209, 209, 230, 255, 209, 209, 230, 255, 210, 210, 230, 255, 210, 210, 230, 255, 211, 210, 231, 255, 211, 211, 231, 255, 212, 211, 231, 255, 212, 211, 231, 255, 213, 211, 231, 255, 213, 212, 232, 255, 214, 212, 232, 255, 214, 212, 232, 255, 215, 212, 232, 255, 215, 213, 232, 255, 216, 213, 232, 255, 216, 213, 232, 255, 217, 213, 233, 255, 217, 214, 233, 255, 217, 214, 233, 255, 218, 214, 233, 255, 218, 214, 233, 255, 219, 215, 233, 255, 219, 215, 233, 255, 225, 218, 236, 255, 225, 219, 236, 255, 226, 219, 236, 255, 226, 219, 236, 255, 227, 219, 236, 255, 227, 220, 236, 255, 227, 220, 236, 255, 228, 220, 237, 255, 228, 220, 237, 255, 228, 221, 237, 255, 229, 221, 237, 255, 229, 221, 237, 255, 229, 221, 237, 255, 230, 221, 237, 255, 230, 222, 237, 255, 230, 222, 237, 255, 231, 222, 238, 255, 231, 222, 238, 255, 231, 222, 238, 255, 231, 223, 238, 255, 232, 223, 238, 255, 232, 223, 238, 255, 232, 223, 238, 255, 233, 223, 238, 255, 233, 224, 238, 255, 233, 224, 239, 255, 233, 224, 239, 255, 234, 224, 239, 255, 234, 224, 239, 255, 234, 225, 239, 255, 234, 225, 239, 255, 235, 225, 239, 255, 235, 225, 239, 255, 235, 225, 239, 255, 235, 225, 239, 255, 236, 226, 240, 255, 236, 226, 240, 255, 236, 226, 240, 255, 236, 226, 240, 255, 237, 226, 240, 255, 237, 227, 240, 255, 237, 227, 240, 255, 237, 227, 240, 255, 237, 227, 240, 255, 238, 227, 240, 255, 238, 227, 240, 255, 238, 228, 240, 255, 238, 228, 240, 255, 238, 228, 241, 255, 239, 228, 241, 255, 239, 228, 241, 255, 239, 228, 241, 255, 239, 229, 241, 255, 239, 229, 241, 255, 239, 229, 241, 255, 240, 229, 241, 255, 240, 229, 241, 255, 240, 229, 241, 255, 240, 230, 241, 255, 240, 230, 241, 255, 240, 230, 241, 255, 241, 230, 242, 255, 241, 230, 242, 255, 241, 230, 242, 255, 241, 230, 242, 255, 241, 231, 242, 255, 241, 231, 242, 255, 241, 231, 242, 255, 242, 231, 242, 255, 242, 231, 242, 255, 242, 231, 242, 255, 242, 231, 242, 255, 242, 231, 242, 255, 242, 232, 242, 255, 242, 232, 242, 255, 242, 232, 242, 255, 243, 232, 242, 255, 243, 232, 243, 255, 243, 232, 243, 255, 243, 232, 243, 255, 243, 232, 243, 255, 243, 233, 243, 255, 243, 233, 243, 255, 243, 233, 243, 255, 243, 233, 243, 255, 244, 233, 243, 255, 244, 233, 243, 255, 244, 233, 243, 255, 244, 233, 243, 255, 244, 234, 243, 255, 248, 238, 246, 255, 248, 238, 246, 255, 248, 238, 246, 255, 248, 238, 246, 255, 248, 238, 246, 255, 248, 238, 246, 255, 248, 238, 246, 255, 248, 239, 246, 255, 249, 239, 246, 255, 249, 239, 246, 255, 249, 239, 246, 255, 249, 239, 246, 255, 249, 239, 246, 255, 249, 239, 246, 255, 249, 239, 246, 255, 249, 239, 246, 255, 249, 239, 246, 255, 249, 240, 246, 255, 249, 240, 246, 255, 249, 240, 246, 255, 250, 240, 247, 255, 250, 240, 247, 255, 250, 240, 247, 255, 250, 240, 247, 255, 250, 240, 247, 255, 250, 240, 247, 255, 250, 240, 247, 255, 250, 240, 247, 255, 250, 240, 247, 255, 250, 241, 247, 255, 250, 241, 247, 255, 250, 241, 247, 255, 250, 241, 247, 255, 250, 241, 247, 255, 250, 241, 247, 255, 251, 241, 247, 255, 251, 241, 247, 255, 251, 241, 247, 255, 251, 241, 247, 255, 251, 241, 247, 255, 251, 241, 247, 255, 251, 241, 247, 255, 251, 241, 247, 255, 251, 242, 248, 255, 251, 242, 248, 255, 251, 242, 248, 255, 251, 242, 248, 255, 251, 242, 248, 255, 251, 242, 248, 255, 251, 242, 248, 255, 251, 242, 248, 255, 251, 242, 248, 255, 251, 242, 248, 255, 251, 242, 248, 255, 251, 242, 248, 255, 252, 242, 248, 255, 252, 242, 248, 255, 252, 242, 248, 255, 252, 242, 248, 255, 252, 243, 248, 255, 252, 243, 248, 255, 252, 243, 248, 255, 252, 243, 248, 255, 252, 243, 248, 255, 252, 243, 248, 255, 252, 243, 248, 255, 252, 243, 248, 255, 252, 243, 248, 255, 252, 243, 248, 255, 252, 243, 248, 255, 252, 243, 248, 255, 252, 243, 248, 255, 252, 243, 248, 255, 252, 243, 248, 255, 252, 243, 249, 255, 252, 243, 249, 255, 252, 243, 249, 255, 252, 243, 249, 255, 252, 243, 249, 255, 252, 243, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 250, 255, 253, 245, 250, 255, 253, 245, 250, 255, 253, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255
};
static const heatmap_colorscheme_t mixed_exp = { mixed_exp_data, sizeof(mixed_exp_data)/sizeof(mixed_exp_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_PuBuGn_mixed_exp = &mixed_exp;

#ifdef __cplusplus
}
#endif
