/* heatmap - High performance heatmap creation in C.
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2013 Lucas Beyer
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include "heatmap.h"
#include "colorschemes/OrRd.h"

static const unsigned char discrete_data[] = {
    0, 0, 0, 0, 127, 0, 0, 255, 179, 0, 0, 255, 215, 48, 31, 255, 239, 101, 72, 255, 252, 141, 89, 255, 253, 187, 132, 255, 253, 212, 158, 255, 254, 232, 200, 255, 255, 247, 236, 255
};
static const heatmap_colorscheme_t discrete = { discrete_data, sizeof(discrete_data)/sizeof(discrete_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_OrRd_discrete = &discrete;

static const unsigned char soft_data[] = {
    0, 0, 0, 0, 126, 0, 0, 0, 127, 0, 0, 7, 127, 0, 0, 14, 128, 0, 0, 22, 128, 0, 0, 29, 128, 0, 0, 37, 129, 0, 0, 44, 129, 0, 0, 52, 130, 0, 0, 59, 130, 0, 0, 67, 130, 0, 0, 74, 131, 0, 0, 82, 131, 0, 0, 89, 132, 0, 0, 97, 132, 0, 0, 104, 132, 0, 0, 112, 133, 0, 0, 119, 133, 0, 0, 127, 134, 0, 0, 134, 134, 0, 0, 141, 134, 0, 0, 149, 135, 0, 0, 156, 135, 0, 0, 164, 136, 0, 0, 171, 136, 0, 0, 179, 136, 0, 0, 186, 137, 0, 0, 194, 137, 0, 0, 201, 138, 0, 0, 209, 138, 0, 0, 216, 138, 0, 0, 224, 139, 0, 0, 231, 139, 0, 0, 239, 140, 0, 0, 246, 140, 0, 0, 254, 140, 0, 0, 255, 141, 0, 1, 255, 141, 0, 1, 255, 142, 0, 1, 255, 142, 0, 1, 255, 142, 0, 1, 255, 143, 0, 1, 255, 143, 0, 1, 255, 144, 0, 1, 255, 144, 0, 1, 255, 144, 0, 1, 255, 145, 0, 1, 255, 145, 0, 1, 255, 146, 0, 1, 255, 146, 0, 1, 255, 146, 0, 1, 255, 147, 0, 1, 255, 147, 0, 1, 255, 148, 0, 1, 255, 148, 0, 1, 255, 149, 0, 1, 255, 149, 0, 1, 255, 149, 0, 1, 255, 150, 0, 1, 255, 150, 0, 1, 255, 151, 0, 1, 255, 151, 0, 1, 255, 151, 0, 1, 255, 152, 0, 1, 255, 152, 0, 1, 255, 153, 0, 1, 255, 153, 0, 1, 255, 153, 0, 1, 255, 154, 0, 1, 255, 154, 0, 1, 255, 155, 0, 1, 255, 155, 0, 1, 255, 155, 0, 1, 255, 156, 0, 1, 255, 156, 0, 1, 255, 157, 0, 1, 255, 157, 0, 1, 255, 157, 0, 1, 255, 158, 0, 1, 255, 158, 0, 1, 255, 159, 0, 1, 255, 159, 0, 1, 255, 160, 0, 1, 255, 160, 0, 1, 255, 160, 0, 1, 255, 161, 0, 1, 255, 161, 0, 1, 255, 162, 0, 1, 255, 162, 0, 1, 255, 162, 0, 1, 255, 163, 0, 1, 255, 163, 0, 1, 255, 164, 0, 1, 255, 164, 0, 1, 255, 164, 0, 1, 255, 165, 0, 0, 255, 165, 0, 0, 255, 166, 0, 0, 255, 166, 0, 0, 255, 166, 0, 0, 255, 167, 0, 0, 255, 167, 0, 0, 255, 168, 0, 0, 255, 168, 0, 0, 255, 169, 0, 0, 255, 169, 0, 0, 255, 169, 0, 0, 255, 170, 0, 0, 255, 170, 0, 0, 255, 171, 0, 0, 255, 171, 0, 0, 255, 171, 0, 0, 255, 172, 0, 0, 255, 172, 0, 0, 255, 173, 0, 0, 255, 173, 0, 0, 255, 174, 0, 0, 255, 174, 0, 0, 255, 174, 0, 0, 255, 175, 0, 0, 255, 175, 0, 0, 255, 176, 0, 0, 255, 176, 0, 0, 255, 176, 0, 0, 255, 177, 0, 0, 255, 177, 0, 0, 255, 178, 0, 0, 255, 178, 0, 0, 255, 178, 0, 0, 255, 179, 0, 0, 255, 179, 1, 0, 255, 179, 1, 0, 255, 180, 2, 0, 255, 180, 2, 1, 255, 180, 3, 1, 255, 180, 3, 1, 255, 181, 4, 1, 255, 181, 4, 1, 255, 181, 5, 2, 255, 182, 6, 2, 255, 182, 6, 2, 255, 182, 7, 2, 255, 182, 7, 2, 255, 183, 8, 3, 255, 183, 9, 3, 255, 183, 9, 3, 255, 184, 10, 3, 255, 184, 10, 4, 255, 184, 11, 4, 255, 184, 11, 4, 255, 185, 12, 4, 255, 185, 13, 4, 255, 185, 13, 5, 255, 186, 14, 5, 255, 186, 14, 5, 255, 186, 15, 5, 255, 186, 15, 6, 255, 187, 15, 6, 255, 187, 16, 6, 255, 187, 16, 6, 255, 187, 17, 7, 255, 188, 17, 7, 255, 188, 18, 7, 255, 188, 18, 7, 255, 189, 19, 8, 255, 189, 19, 8, 255, 189, 19, 8, 255, 189, 20, 9, 255, 190, 20, 9, 255, 190, 21, 9, 255, 190, 21, 9, 255, 191, 21, 10, 255, 191, 22, 10, 255, 191, 22, 10, 255, 191, 23, 11, 255, 192, 23, 11, 255, 192, 23, 11, 255, 192, 24, 11, 255, 193, 24, 12, 255, 193, 24, 12, 255, 193, 25, 12, 255, 193, 25, 12, 255, 194, 25, 13, 255, 194, 26, 13, 255, 194, 26, 13, 255, 194, 26, 14, 255, 195, 27, 14, 255, 195, 27, 14, 255, 195, 28, 14, 255, 196, 28, 15, 255, 196, 28, 15, 255, 196, 29, 15, 255, 196, 29, 15, 255, 197, 29, 16, 255, 197, 30, 16, 255, 197, 30, 16, 255, 198, 30, 16, 255, 198, 30, 17, 255, 198, 31, 17, 255, 198, 31, 17, 255, 199, 31, 17, 255, 199, 32, 18, 255, 199, 32, 18, 255, 200, 32, 18, 255, 200, 33, 18, 255, 200, 33, 19, 255, 200, 33, 19, 255, 201, 34, 19, 255, 201, 34, 19, 255, 201, 34, 20, 255, 202, 35, 20, 255, 202, 35, 20, 255, 202, 35, 20, 255, 202, 35, 20, 255, 203, 36, 21, 255, 203, 36, 21, 255, 203, 36, 21, 255, 203, 37, 21, 255, 204, 37, 22, 255, 204, 37, 22, 255, 204, 38, 22, 255, 205, 38, 22, 255, 205, 38, 23, 255, 205, 38, 23, 255, 205, 39, 23, 255, 206, 39, 23, 255, 206, 39, 24, 255, 206, 40, 24, 255, 207, 40, 24, 255, 207, 40, 24, 255, 207, 40, 25, 255, 207, 41, 25, 255, 208, 41, 25, 255, 208, 41, 25, 255, 208, 42, 25, 255, 209, 42, 26, 255, 209, 42, 26, 255, 209, 42, 26, 255, 209, 43, 26, 255, 210, 43, 27, 255, 210, 43, 27, 255, 210, 43, 27, 255, 211, 44, 27, 255, 211, 44, 28, 255, 211, 44, 28, 255, 211, 45, 28, 255, 212, 45, 28, 255, 212, 45, 28, 255, 212, 45, 29, 255, 213, 46, 29, 255, 213, 46, 29, 255, 213, 46, 29, 255, 213, 46, 30, 255, 214, 47, 30, 255, 214, 47, 30, 255, 214, 47, 30, 255, 214, 48, 30, 255, 215, 48, 31, 255, 215, 49, 31, 255, 215, 49, 31, 255, 215, 50, 32, 255, 215, 50, 32, 255, 216, 51, 32, 255, 216, 51, 33, 255, 216, 52, 33, 255, 216, 52, 33, 255, 216, 53, 34, 255, 217, 53, 34, 255, 217, 54, 34, 255, 217, 54, 35, 255, 217, 55, 35, 255, 217, 55, 35, 255, 218, 55, 36, 255, 218, 56, 36, 255, 218, 56, 36, 255, 218, 57, 37, 255, 218, 57, 37, 255, 219, 58, 37, 255, 219, 58, 38, 255, 219, 59, 38, 255, 219, 59, 38, 255, 219, 60, 38, 255, 220, 60, 39, 255, 220, 61, 39, 255, 220, 61, 39, 255, 220, 61, 40, 255, 220, 62, 40, 255, 221, 62, 40, 255, 221, 63, 41, 255, 221, 63, 41, 255, 221, 64, 41, 255, 221, 64, 42, 255, 221, 65, 42, 255, 222, 65, 42, 255, 222, 65, 43, 255, 222, 66, 43, 255, 222, 66, 43, 255, 222, 67, 44, 255, 223, 67, 44, 255, 223, 68, 44, 255, 223, 68, 45, 255, 223, 68, 45, 255, 223, 69, 45, 255, 224, 69, 45, 255, 224, 70, 46, 255, 224, 70, 46, 255, 224, 71, 46, 255, 224, 71, 47, 255, 225, 71, 47, 255, 225, 72, 47, 255, 225, 72, 48, 255, 225, 73, 48, 255, 225, 73, 48, 255, 225, 73, 49, 255, 226, 74, 49, 255, 226, 74, 49, 255, 226, 75, 50, 255, 226, 75, 50, 255, 226, 75, 50, 255, 227, 76, 51, 255, 227, 76, 51, 255, 227, 77, 51, 255, 227, 77, 52, 255, 227, 77, 52, 255, 228, 78, 52, 255, 228, 78, 52, 255, 228, 79, 53, 255, 228, 79, 53, 255, 228, 79, 53, 255, 228, 80, 54, 255, 229, 80, 54, 255, 229, 81, 54, 255, 229, 81, 55, 255, 229, 81, 55, 255, 229, 82, 55, 255, 230, 82, 56, 255, 230, 83, 56, 255, 230, 83, 56, 255, 230, 83, 57, 255, 230, 84, 57, 255, 231, 84, 57, 255, 231, 84, 58, 255, 231, 85, 58, 255, 231, 85, 58, 255, 231, 86, 59, 255, 231, 86, 59, 255, 232, 86, 59, 255, 232, 87, 60, 255, 232, 87, 60, 255, 232, 88, 60, 255, 232, 88, 60, 255, 233, 88, 61, 255, 233, 89, 61, 255, 233, 89, 61, 255, 233, 89, 62, 255, 233, 90, 62, 255, 233, 90, 62, 255, 234, 91, 63, 255, 234, 91, 63, 255, 234, 91, 63, 255, 234, 92, 64, 255, 234, 92, 64, 255, 235, 92, 64, 255, 235, 93, 65, 255, 235, 93, 65, 255, 235, 94, 65, 255, 235, 94, 66, 255, 235, 94, 66, 255, 236, 95, 66, 255, 236, 95, 67, 255, 236, 95, 67, 255, 236, 96, 67, 255, 236, 96, 68, 255, 237, 96, 68, 255, 237, 97, 68, 255, 237, 97, 69, 255, 237, 98, 69, 255, 237, 98, 69, 255, 237, 98, 70, 255, 238, 99, 70, 255, 238, 99, 70, 255, 238, 99, 71, 255, 238, 100, 71, 255, 238, 100, 71, 255, 238, 101, 71, 255, 239, 101, 72, 255, 239, 101, 72, 255, 239, 101, 72, 255, 239, 102, 72, 255, 239, 102, 72, 255, 239, 102, 72, 255, 239, 103, 72, 255, 239, 103, 72, 255, 239, 103, 72, 255, 240, 104, 73, 255, 240, 104, 73, 255, 240, 104, 73, 255, 240, 105, 73, 255, 240, 105, 73, 255, 240, 105, 73, 255, 240, 106, 73, 255, 240, 106, 73, 255, 240, 106, 73, 255, 241, 107, 74, 255, 241, 107, 74, 255, 241, 107, 74, 255, 241, 108, 74, 255, 241, 108, 74, 255, 241, 108, 74, 255, 241, 109, 74, 255, 241, 109, 74, 255, 241, 109, 74, 255, 242, 110, 75, 255, 242, 110, 75, 255, 242, 110, 75, 255, 242, 111, 75, 255, 242, 111, 75, 255, 242, 111, 75, 255, 242, 112, 75, 255, 242, 112, 75, 255, 242, 112, 75, 255, 242, 113, 76, 255, 243, 113, 76, 255, 243, 113, 76, 255, 243, 113, 76, 255, 243, 114, 76, 255, 243, 114, 76, 255, 243, 114, 76, 255, 243, 115, 76, 255, 243, 115, 77, 255, 243, 115, 77, 255, 243, 116, 77, 255, 244, 116, 77, 255, 244, 116, 77, 255, 244, 117, 77, 255, 244, 117, 77, 255, 244, 117, 77, 255, 244, 118, 78, 255, 244, 118, 78, 255, 244, 118, 78, 255, 244, 119, 78, 255, 245, 119, 78, 255, 245, 119, 78, 255, 245, 119, 78, 255, 245, 120, 78, 255, 245, 120, 79, 255, 245, 120, 79, 255, 245, 121, 79, 255, 245, 121, 79, 255, 245, 121, 79, 255, 245, 122, 79, 255, 246, 122, 79, 255, 246, 122, 80, 255, 246, 123, 80, 255, 246, 123, 80, 255, 246, 123, 80, 255, 246, 124, 80, 255, 246, 124, 80, 255, 246, 124, 80, 255, 246, 124, 81, 255, 246, 125, 81, 255, 247, 125, 81, 255, 247, 125, 81, 255, 247, 126, 81, 255, 247, 126, 81, 255, 247, 126, 81, 255, 247, 127, 81, 255, 247, 127, 82, 255, 247, 127, 82, 255, 247, 128, 82, 255, 247, 128, 82, 255, 248, 128, 82, 255, 248, 128, 82, 255, 248, 129, 82, 255, 248, 129, 83, 255, 248, 129, 83, 255, 248, 130, 83, 255, 248, 130, 83, 255, 248, 130, 83, 255, 248, 131, 83, 255, 248, 131, 84, 255, 249, 131, 84, 255, 249, 131, 84, 255, 249, 132, 84, 255, 249, 132, 84, 255, 249, 132, 84, 255, 249, 133, 84, 255, 249, 133, 85, 255, 249, 133, 85, 255, 249, 134, 85, 255, 249, 134, 85, 255, 249, 134, 85, 255, 250, 135, 85, 255, 250, 135, 85, 255, 250, 135, 86, 255, 250, 135, 86, 255, 250, 136, 86, 255, 250, 136, 86, 255, 250, 136, 86, 255, 250, 137, 86, 255, 250, 137, 87, 255, 250, 137, 87, 255, 251, 138, 87, 255, 251, 138, 87, 255, 251, 138, 87, 255, 251, 138, 87, 255, 251, 139, 88, 255, 251, 139, 88, 255, 251, 139, 88, 255, 251, 140, 88, 255, 251, 140, 88, 255, 251, 140, 88, 255, 251, 141, 88, 255, 252, 141, 89, 255, 252, 141, 89, 255, 252, 142, 89, 255, 252, 142, 90, 255, 252, 142, 90, 255, 252, 143, 90, 255, 252, 143, 90, 255, 252, 144, 91, 255, 252, 144, 91, 255, 252, 144, 91, 255, 252, 145, 92, 255, 252, 145, 92, 255, 252, 146, 92, 255, 252, 146, 92, 255, 252, 146, 93, 255, 252, 147, 93, 255, 252, 147, 93, 255, 252, 147, 94, 255, 252, 148, 94, 255, 252, 148, 94, 255, 252, 149, 94, 255, 252, 149, 95, 255, 252, 149, 95, 255, 252, 150, 95, 255, 252, 150, 96, 255, 252, 150, 96, 255, 252, 151, 96, 255, 252, 151, 96, 255, 252, 152, 97, 255, 252, 152, 97, 255, 252, 152, 97, 255, 252, 153, 98, 255, 252, 153, 98, 255, 252, 153, 98, 255, 252, 154, 99, 255, 252, 154, 99, 255, 252, 155, 99, 255, 252, 155, 100, 255, 252, 155, 100, 255, 252, 156, 100, 255, 252, 156, 100, 255, 252, 156, 101, 255, 252, 157, 101, 255, 252, 157, 101, 255, 252, 158, 102, 255, 252, 158, 102, 255, 252, 158, 102, 255, 252, 159, 103, 255, 252, 159, 103, 255, 252, 159, 103, 255, 252, 160, 104, 255, 252, 160, 104, 255, 252, 160, 104, 255, 252, 161, 105, 255, 252, 161, 105, 255, 252, 162, 105, 255, 252, 162, 106, 255, 252, 162, 106, 255, 252, 163, 106, 255, 252, 163, 107, 255, 252, 163, 107, 255, 252, 164, 107, 255, 252, 164, 108, 255, 252, 164, 108, 255, 252, 165, 108, 255, 252, 165, 109, 255, 252, 165, 109, 255, 252, 166, 109, 255, 252, 166, 110, 255, 252, 167, 110, 255, 252, 167, 110, 255, 252, 167, 111, 255, 252, 168, 111, 255, 252, 168, 111, 255, 252, 168, 112, 255, 252, 169, 112, 255, 252, 169, 112, 255, 252, 169, 113, 255, 252, 170, 113, 255, 252, 170, 113, 255, 252, 170, 114, 255, 252, 171, 114, 255, 252, 171, 115, 255, 252, 171, 115, 255, 252, 172, 115, 255, 252, 172, 116, 255, 252, 173, 116, 255, 252, 173, 116, 255, 252, 173, 117, 255, 252, 174, 117, 255, 252, 174, 117, 255, 252, 174, 118, 255, 252, 175, 118, 255, 252, 175, 119, 255, 252, 175, 119, 255, 252, 176, 119, 255, 252, 176, 120, 255, 252, 176, 120, 255, 252, 177, 120, 255, 252, 177, 121, 255, 252, 177, 121, 255, 252, 178, 121, 255, 252, 178, 122, 255, 252, 178, 122, 255, 252, 179, 123, 255, 252, 179, 123, 255, 252, 179, 123, 255, 252, 180, 124, 255, 252, 180, 124, 255, 252, 180, 124, 255, 252, 181, 125, 255, 252, 181, 125, 255, 252, 181, 126, 255, 252, 182, 126, 255, 252, 182, 126, 255, 252, 182, 127, 255, 252, 183, 127, 255, 252, 183, 128, 255, 252, 183, 128, 255, 252, 184, 128, 255, 252, 184, 129, 255, 252, 184, 129, 255, 252, 185, 130, 255, 252, 185, 130, 255, 252, 185, 130, 255, 252, 186, 131, 255, 252, 186, 131, 255, 252, 187, 131, 255, 252, 187, 132, 255, 252, 187, 132, 255, 252, 187, 132, 255, 252, 187, 132, 255, 252, 188, 132, 255, 252, 188, 133, 255, 252, 188, 133, 255, 252, 188, 133, 255, 252, 188, 133, 255, 252, 189, 133, 255, 252, 189, 133, 255, 252, 189, 134, 255, 252, 189, 134, 255, 252, 189, 134, 255, 252, 190, 134, 255, 252, 190, 134, 255, 252, 190, 135, 255, 252, 190, 135, 255, 252, 190, 135, 255, 252, 191, 135, 255, 252, 191, 135, 255, 252, 191, 136, 255, 252, 191, 136, 255, 252, 191, 136, 255, 252, 192, 136, 255, 252, 192, 136, 255, 252, 192, 136, 255, 252, 192, 137, 255, 252, 192, 137, 255, 252, 193, 137, 255, 252, 193, 137, 255, 252, 193, 137, 255, 252, 193, 138, 255, 252, 193, 138, 255, 252, 194, 138, 255, 252, 194, 138, 255, 252, 194, 138, 255, 252, 194, 139, 255, 252, 194, 139, 255, 252, 195, 139, 255, 252, 195, 139, 255, 252, 195, 139, 255, 252, 195, 140, 255, 252, 195, 140, 255, 252, 196, 140, 255, 252, 196, 140, 255, 252, 196, 140, 255, 252, 196, 141, 255, 252, 196, 141, 255, 252, 197, 141, 255, 252, 197, 141, 255, 252, 197, 141, 255, 252, 197, 141, 255, 252, 197, 142, 255, 252, 197, 142, 255, 252, 198, 142, 255, 252, 198, 142, 255, 252, 198, 143, 255, 252, 198, 143, 255, 252, 198, 143, 255, 252, 199, 143, 255, 252, 199, 143, 255, 252, 199, 144, 255, 252, 199, 144, 255, 252, 199, 144, 255, 252, 200, 144, 255, 252, 200, 144, 255, 252, 200, 145, 255, 252, 200, 145, 255, 252, 200, 145, 255, 252, 201, 145, 255, 252, 201, 145, 255, 252, 201, 146, 255, 252, 201, 146, 255, 252, 201, 146, 255, 252, 202, 146, 255, 252, 202, 146, 255, 252, 202, 147, 255, 252, 202, 147, 255, 252, 202, 147, 255, 252, 203, 147, 255, 252, 203, 147, 255, 252, 203, 148, 255, 252, 203, 148, 255, 252, 203, 148, 255, 252, 204, 148, 255, 252, 204, 149, 255, 252, 204, 149, 255, 252, 204, 149, 255, 252, 204, 149, 255, 252, 204, 149, 255, 252, 205, 150, 255, 252, 205, 150, 255, 252, 205, 150, 255, 252, 205, 150, 255, 252, 205, 150, 255, 252, 206, 151, 255, 252, 206, 151, 255, 252, 206, 151, 255, 252, 206, 151, 255, 252, 206, 152, 255, 252, 207, 152, 255, 252, 207, 152, 255, 252, 207, 152, 255, 252, 207, 152, 255, 252, 207, 153, 255, 252, 208, 153, 255, 252, 208, 153, 255, 252, 208, 153, 255, 252, 208, 153, 255, 252, 208, 154, 255, 252, 208, 154, 255, 252, 209, 154, 255, 252, 209, 154, 255, 252, 209, 155, 255, 252, 209, 155, 255, 252, 209, 155, 255, 252, 210, 155, 255, 252, 210, 155, 255, 252, 210, 156, 255, 252, 210, 156, 255, 252, 210, 156, 255, 252, 211, 156, 255, 252, 211, 157, 255, 252, 211, 157, 255, 252, 211, 157, 255, 252, 211, 157, 255, 252, 212, 157, 255, 253, 212, 158, 255, 253, 212, 158, 255, 253, 212, 158, 255, 253, 212, 159, 255, 253, 212, 159, 255, 253, 212, 159, 255, 253, 213, 160, 255, 253, 213, 160, 255, 253, 213, 160, 255, 253, 213, 161, 255, 253, 213, 161, 255, 253, 213, 161, 255, 253, 214, 162, 255, 253, 214, 162, 255, 253, 214, 162, 255, 253, 214, 163, 255, 253, 214, 163, 255, 253, 214, 163, 255, 253, 215, 164, 255, 253, 215, 164, 255, 253, 215, 164, 255, 253, 215, 165, 255, 253, 215, 165, 255, 253, 215, 165, 255, 253, 215, 166, 255, 253, 216, 166, 255, 253, 216, 166, 255, 253, 216, 167, 255, 253, 216, 167, 255, 253, 216, 167, 255, 253, 216, 168, 255, 253, 217, 168, 255, 253, 217, 168, 255, 253, 217, 168, 255, 253, 217, 169, 255, 253, 217, 169, 255, 253, 217, 169, 255, 253, 218, 170, 255, 253, 218, 170, 255, 253, 218, 170, 255, 253, 218, 171, 255, 253, 218, 171, 255, 253, 218, 171, 255, 253, 218, 172, 255, 253, 219, 172, 255, 253, 219, 172, 255, 253, 219, 173, 255, 253, 219, 173, 255, 253, 219, 173, 255, 253, 219, 174, 255, 253, 220, 174, 255, 253, 220, 174, 255, 253, 220, 175, 255, 253, 220, 175, 255, 253, 220, 175, 255, 253, 220, 176, 255, 253, 221, 176, 255, 253, 221, 176, 255, 253, 221, 177, 255, 253, 221, 177, 255, 253, 221, 177, 255, 253, 221, 178, 255, 253, 221, 178, 255, 253, 222, 178, 255, 253, 222, 179, 255, 253, 222, 179, 255, 253, 222, 179, 255, 253, 222, 180, 255, 253, 222, 180, 255, 253, 223, 180, 255, 253, 223, 181, 255, 253, 223, 181, 255, 253, 223, 181, 255, 253, 223, 182, 255, 253, 223, 182, 255, 253, 223, 182, 255, 253, 224, 183, 255, 253, 224, 183, 255, 253, 224, 183, 255, 253, 224, 184, 255, 253, 224, 184, 255, 253, 224, 184, 255, 253, 225, 185, 255, 253, 225, 185, 255, 253, 225, 185, 255, 253, 225, 186, 255, 253, 225, 186, 255, 253, 225, 186, 255, 253, 226, 187, 255, 253, 226, 187, 255, 253, 226, 187, 255, 253, 226, 188, 255, 253, 226, 188, 255, 253, 226, 188, 255, 253, 226, 189, 255, 253, 227, 189, 255, 253, 227, 189, 255, 253, 227, 190, 255, 253, 227, 190, 255, 253, 227, 190, 255, 253, 227, 191, 255, 253, 228, 191, 255, 253, 228, 191, 255, 253, 228, 191, 255, 253, 228, 192, 255, 253, 228, 192, 255, 253, 228, 192, 255, 253, 228, 193, 255, 253, 229, 193, 255, 253, 229, 193, 255, 253, 229, 194, 255, 253, 229, 194, 255, 253, 229, 194, 255, 253, 229, 195, 255, 253, 230, 195, 255, 253, 230, 195, 255, 253, 230, 196, 255, 253, 230, 196, 255, 253, 230, 196, 255, 253, 230, 197, 255, 253, 230, 197, 255, 253, 231, 197, 255, 253, 231, 198, 255, 253, 231, 198, 255, 253, 231, 198, 255, 253, 231, 199, 255, 253, 231, 199, 255, 253, 232, 199, 255, 254, 232, 200, 255, 254, 232, 200, 255, 254, 232, 200, 255, 254, 232, 201, 255, 254, 232, 201, 255, 254, 232, 201, 255, 254, 232, 201, 255, 254, 232, 202, 255, 254, 233, 202, 255, 254, 233, 202, 255, 254, 233, 203, 255, 254, 233, 203, 255, 254, 233, 203, 255, 254, 233, 203, 255, 254, 233, 204, 255, 254, 233, 204, 255, 254, 233, 204, 255, 254, 234, 205, 255, 254, 234, 205, 255, 254, 234, 205, 255, 254, 234, 205, 255, 254, 234, 206, 255, 254, 234, 206, 255, 254, 234, 206, 255, 254, 234, 206, 255, 254, 235, 207, 255, 254, 235, 207, 255, 254, 235, 207, 255, 254, 235, 208, 255, 254, 235, 208, 255, 254, 235, 208, 255, 254, 235, 208, 255, 254, 235, 209, 255, 254, 235, 209, 255, 254, 236, 209, 255, 254, 236, 210, 255, 254, 236, 210, 255, 254, 236, 210, 255, 254, 236, 210, 255, 254, 236, 211, 255, 254, 236, 211, 255, 254, 236, 211, 255, 254, 237, 212, 255, 254, 237, 212, 255, 254, 237, 212, 255, 254, 237, 212, 255, 254, 237, 213, 255, 254, 237, 213, 255, 254, 237, 213, 255, 254, 237, 213, 255, 254, 237, 214, 255, 254, 238, 214, 255, 254, 238, 214, 255, 254, 238, 215, 255, 254, 238, 215, 255, 254, 238, 215, 255, 254, 238, 215, 255, 254, 238, 216, 255, 254, 238, 216, 255, 254, 239, 216, 255, 254, 239, 217, 255, 254, 239, 217, 255, 254, 239, 217, 255, 254, 239, 217, 255, 254, 239, 218, 255, 254, 239, 218, 255, 254, 239, 218, 255, 254, 239, 219, 255, 254, 240, 219, 255, 254, 240, 219, 255, 254, 240, 219, 255, 254, 240, 220, 255, 254, 240, 220, 255, 254, 240, 220, 255, 254, 240, 221, 255, 254, 240, 221, 255, 254, 241, 221, 255, 254, 241, 221, 255, 254, 241, 222, 255, 254, 241, 222, 255, 254, 241, 222, 255, 254, 241, 222, 255, 254, 241, 223, 255, 254, 241, 223, 255, 254, 241, 223, 255, 254, 242, 224, 255, 254, 242, 224, 255, 254, 242, 224, 255, 254, 242, 224, 255, 254, 242, 225, 255, 254, 242, 225, 255, 254, 242, 225, 255, 254, 242, 226, 255, 254, 243, 226, 255, 254, 243, 226, 255, 254, 243, 226, 255, 254, 243, 227, 255, 254, 243, 227, 255, 254, 243, 227, 255, 254, 243, 228, 255, 254, 243, 228, 255, 254, 243, 228, 255, 254, 244, 228, 255, 254, 244, 229, 255, 254, 244, 229, 255, 254, 244, 229, 255, 254, 244, 230, 255, 254, 244, 230, 255, 254, 244, 230, 255, 254, 244, 230, 255, 254, 245, 231, 255, 254, 245, 231, 255, 254, 245, 231, 255, 254, 245, 232, 255, 254, 245, 232, 255, 254, 245, 232, 255, 254, 245, 232, 255, 254, 245, 233, 255, 254, 245, 233, 255, 254, 246, 233, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255
};
static const heatmap_colorscheme_t soft = { soft_data, sizeof(soft_data)/sizeof(soft_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_OrRd_soft = &soft;

static const unsigned char mixed_data[] = {
    0, 0, 0, 0, 126, 0, 0, 0, 127, 0, 0, 7, 127, 0, 0, 14, 127, 0, 0, 22, 128, 0, 0, 29, 128, 0, 0, 37, 128, 0, 0, 44, 129, 0, 0, 52, 129, 0, 0, 59, 129, 0, 0, 67, 130, 0, 0, 74, 130, 0, 0, 82, 130, 0, 0, 89, 131, 0, 0, 97, 131, 0, 0, 104, 131, 0, 0, 112, 132, 0, 0, 119, 132, 0, 0, 127, 132, 0, 0, 134, 133, 0, 0, 141, 133, 0, 0, 149, 133, 0, 0, 156, 133, 0, 0, 164, 134, 0, 0, 171, 134, 0, 0, 179, 134, 0, 0, 186, 135, 0, 0, 194, 135, 0, 0, 201, 135, 0, 0, 209, 136, 0, 0, 216, 136, 0, 0, 224, 136, 0, 0, 231, 137, 0, 0, 239, 137, 0, 0, 246, 137, 0, 0, 254, 138, 0, 0, 255, 138, 0, 0, 255, 138, 0, 0, 255, 139, 0, 0, 255, 139, 0, 0, 255, 139, 0, 0, 255, 140, 0, 0, 255, 140, 0, 0, 255, 140, 0, 0, 255, 141, 0, 0, 255, 141, 0, 0, 255, 141, 0, 0, 255, 142, 0, 0, 255, 142, 0, 0, 255, 142, 0, 0, 255, 142, 0, 0, 255, 143, 0, 0, 255, 143, 0, 0, 255, 143, 0, 0, 255, 144, 0, 0, 255, 144, 0, 0, 255, 144, 0, 0, 255, 145, 0, 1, 255, 145, 0, 1, 255, 145, 0, 1, 255, 146, 0, 1, 255, 146, 0, 1, 255, 146, 0, 1, 255, 147, 0, 1, 255, 157, 0, 1, 255, 158, 0, 1, 255, 158, 0, 1, 255, 158, 0, 1, 255, 159, 0, 1, 255, 159, 0, 1, 255, 159, 0, 1, 255, 160, 0, 1, 255, 160, 0, 1, 255, 160, 0, 1, 255, 161, 0, 1, 255, 161, 0, 0, 255, 161, 0, 0, 255, 162, 0, 0, 255, 162, 0, 0, 255, 162, 0, 0, 255, 163, 0, 0, 255, 163, 0, 0, 255, 163, 0, 0, 255, 164, 0, 0, 255, 164, 0, 0, 255, 164, 0, 0, 255, 165, 0, 0, 255, 165, 0, 0, 255, 165, 0, 0, 255, 166, 0, 0, 255, 166, 0, 0, 255, 166, 0, 0, 255, 167, 0, 0, 255, 167, 0, 0, 255, 167, 0, 0, 255, 168, 0, 0, 255, 168, 0, 0, 255, 168, 0, 0, 255, 169, 0, 0, 255, 169, 0, 0, 255, 169, 0, 0, 255, 170, 0, 0, 255, 170, 0, 0, 255, 170, 0, 0, 255, 171, 0, 0, 255, 171, 0, 0, 255, 171, 0, 0, 255, 172, 0, 0, 255, 172, 0, 0, 255, 172, 0, 0, 255, 173, 0, 0, 255, 173, 0, 0, 255, 173, 0, 0, 255, 174, 0, 0, 255, 174, 0, 0, 255, 174, 0, 0, 255, 175, 0, 0, 255, 175, 0, 0, 255, 175, 0, 0, 255, 176, 0, 0, 255, 176, 0, 0, 255, 176, 0, 0, 255, 177, 0, 0, 255, 177, 0, 0, 255, 177, 0, 0, 255, 178, 0, 0, 255, 178, 0, 0, 255, 178, 0, 0, 255, 178, 0, 0, 255, 179, 0, 0, 255, 179, 0, 0, 255, 179, 1, 0, 255, 179, 1, 0, 255, 180, 2, 0, 255, 180, 2, 0, 255, 180, 3, 1, 255, 180, 3, 1, 255, 181, 3, 1, 255, 181, 4, 1, 255, 181, 4, 1, 255, 181, 5, 1, 255, 181, 5, 2, 255, 182, 6, 2, 255, 182, 6, 2, 255, 182, 7, 2, 255, 182, 7, 2, 255, 183, 8, 3, 255, 183, 8, 3, 255, 183, 9, 3, 255, 183, 9, 3, 255, 183, 9, 3, 255, 184, 10, 3, 255, 184, 10, 4, 255, 184, 11, 4, 255, 184, 11, 4, 255, 185, 12, 4, 255, 185, 12, 4, 255, 185, 12, 5, 255, 185, 13, 5, 255, 185, 13, 5, 255, 186, 13, 5, 255, 186, 14, 5, 255, 186, 14, 6, 255, 186, 14, 6, 255, 187, 15, 6, 255, 187, 15, 6, 255, 187, 15, 7, 255, 187, 16, 7, 255, 187, 16, 7, 255, 188, 16, 7, 255, 188, 17, 7, 255, 188, 17, 8, 255, 188, 17, 8, 255, 189, 18, 8, 255, 189, 18, 8, 255, 189, 18, 9, 255, 189, 19, 9, 255, 189, 19, 9, 255, 190, 19, 9, 255, 190, 19, 9, 255, 190, 20, 10, 255, 190, 20, 10, 255, 191, 20, 10, 255, 191, 21, 10, 255, 191, 21, 10, 255, 191, 21, 11, 255, 192, 21, 11, 255, 192, 22, 11, 255, 192, 22, 11, 255, 192, 22, 12, 255, 192, 22, 12, 255, 193, 23, 12, 255, 200, 33, 18, 255, 200, 33, 19, 255, 201, 33, 19, 255, 201, 33, 19, 255, 201, 34, 19, 255, 201, 34, 19, 255, 201, 34, 20, 255, 202, 34, 20, 255, 202, 35, 20, 255, 202, 35, 20, 255, 202, 35, 20, 255, 203, 35, 21, 255, 203, 36, 21, 255, 203, 36, 21, 255, 203, 36, 21, 255, 203, 36, 21, 255, 204, 37, 22, 255, 204, 37, 22, 255, 204, 37, 22, 255, 204, 37, 22, 255, 205, 38, 22, 255, 205, 38, 22, 255, 205, 38, 23, 255, 205, 38, 23, 255, 205, 39, 23, 255, 206, 39, 23, 255, 206, 39, 23, 255, 206, 39, 24, 255, 206, 40, 24, 255, 207, 40, 24, 255, 207, 40, 24, 255, 207, 40, 24, 255, 207, 40, 25, 255, 207, 41, 25, 255, 208, 41, 25, 255, 208, 41, 25, 255, 208, 41, 25, 255, 208, 42, 26, 255, 209, 42, 26, 255, 209, 42, 26, 255, 209, 42, 26, 255, 209, 42, 26, 255, 210, 43, 26, 255, 210, 43, 27, 255, 210, 43, 27, 255, 210, 43, 27, 255, 210, 44, 27, 255, 211, 44, 27, 255, 211, 44, 28, 255, 211, 44, 28, 255, 211, 44, 28, 255, 212, 45, 28, 255, 212, 45, 28, 255, 212, 45, 28, 255, 212, 45, 29, 255, 212, 46, 29, 255, 213, 46, 29, 255, 213, 46, 29, 255, 213, 46, 29, 255, 213, 46, 30, 255, 214, 47, 30, 255, 214, 47, 30, 255, 214, 47, 30, 255, 214, 47, 30, 255, 214, 48, 30, 255, 215, 48, 31, 255, 215, 48, 31, 255, 215, 49, 31, 255, 215, 49, 32, 255, 215, 50, 32, 255, 215, 50, 32, 255, 216, 50, 32, 255, 216, 51, 33, 255, 216, 51, 33, 255, 216, 52, 33, 255, 216, 52, 33, 255, 216, 52, 34, 255, 217, 53, 34, 255, 217, 53, 34, 255, 217, 54, 34, 255, 217, 54, 35, 255, 217, 54, 35, 255, 217, 55, 35, 255, 217, 55, 35, 255, 218, 55, 36, 255, 218, 56, 36, 255, 218, 56, 36, 255, 218, 57, 36, 255, 218, 57, 37, 255, 218, 57, 37, 255, 219, 58, 37, 255, 219, 58, 37, 255, 219, 58, 38, 255, 219, 59, 38, 255, 219, 59, 38, 255, 219, 59, 38, 255, 219, 60, 39, 255, 220, 60, 39, 255, 220, 60, 39, 255, 220, 61, 39, 255, 220, 61, 40, 255, 220, 62, 40, 255, 220, 62, 40, 255, 221, 62, 40, 255, 221, 63, 41, 255, 221, 63, 41, 255, 221, 63, 41, 255, 221, 64, 41, 255, 221, 64, 42, 255, 221, 64, 42, 255, 222, 65, 42, 255, 222, 65, 42, 255, 222, 65, 43, 255, 222, 66, 43, 255, 222, 66, 43, 255, 222, 66, 44, 255, 223, 67, 44, 255, 223, 67, 44, 255, 223, 67, 44, 255, 223, 68, 45, 255, 223, 68, 45, 255, 223, 68, 45, 255, 223, 69, 45, 255, 224, 69, 46, 255, 224, 69, 46, 255, 224, 70, 46, 255, 224, 70, 46, 255, 224, 70, 47, 255, 229, 81, 55, 255, 229, 81, 55, 255, 229, 82, 56, 255, 230, 82, 56, 255, 230, 82, 56, 255, 230, 83, 56, 255, 230, 83, 57, 255, 230, 83, 57, 255, 230, 84, 57, 255, 230, 84, 57, 255, 231, 84, 58, 255, 231, 85, 58, 255, 231, 85, 58, 255, 231, 85, 58, 255, 231, 86, 59, 255, 231, 86, 59, 255, 232, 86, 59, 255, 232, 86, 59, 255, 232, 87, 60, 255, 232, 87, 60, 255, 232, 87, 60, 255, 232, 88, 60, 255, 232, 88, 61, 255, 233, 88, 61, 255, 233, 89, 61, 255, 233, 89, 61, 255, 233, 89, 62, 255, 233, 90, 62, 255, 233, 90, 62, 255, 233, 90, 62, 255, 234, 90, 63, 255, 234, 91, 63, 255, 234, 91, 63, 255, 234, 91, 63, 255, 234, 92, 64, 255, 234, 92, 64, 255, 234, 92, 64, 255, 235, 93, 64, 255, 235, 93, 65, 255, 235, 93, 65, 255, 235, 93, 65, 255, 235, 94, 66, 255, 235, 94, 66, 255, 235, 94, 66, 255, 236, 95, 66, 255, 236, 95, 67, 255, 236, 95, 67, 255, 236, 96, 67, 255, 236, 96, 67, 255, 236, 96, 68, 255, 236, 96, 68, 255, 237, 97, 68, 255, 237, 97, 68, 255, 237, 97, 69, 255, 237, 98, 69, 255, 237, 98, 69, 255, 237, 98, 69, 255, 237, 98, 70, 255, 238, 99, 70, 255, 238, 99, 70, 255, 238, 99, 70, 255, 238, 100, 71, 255, 238, 100, 71, 255, 238, 100, 71, 255, 238, 101, 71, 255, 239, 101, 72, 255, 239, 101, 72, 255, 239, 101, 72, 255, 239, 102, 72, 255, 239, 102, 72, 255, 239, 102, 72, 255, 239, 102, 72, 255, 239, 103, 72, 255, 239, 103, 72, 255, 239, 103, 72, 255, 239, 103, 72, 255, 240, 104, 73, 255, 240, 104, 73, 255, 240, 104, 73, 255, 240, 104, 73, 255, 240, 105, 73, 255, 240, 105, 73, 255, 240, 105, 73, 255, 240, 105, 73, 255, 240, 106, 73, 255, 240, 106, 73, 255, 240, 106, 73, 255, 240, 107, 73, 255, 241, 107, 74, 255, 241, 107, 74, 255, 241, 107, 74, 255, 241, 108, 74, 255, 241, 108, 74, 255, 241, 108, 74, 255, 241, 108, 74, 255, 241, 109, 74, 255, 241, 109, 74, 255, 241, 109, 74, 255, 241, 109, 75, 255, 241, 110, 75, 255, 242, 110, 75, 255, 242, 110, 75, 255, 242, 110, 75, 255, 242, 111, 75, 255, 242, 111, 75, 255, 242, 111, 75, 255, 242, 111, 75, 255, 242, 112, 75, 255, 242, 112, 75, 255, 242, 112, 76, 255, 242, 112, 76, 255, 242, 113, 76, 255, 243, 113, 76, 255, 243, 113, 76, 255, 243, 113, 76, 255, 243, 114, 76, 255, 243, 114, 76, 255, 243, 114, 76, 255, 243, 114, 76, 255, 243, 115, 77, 255, 243, 115, 77, 255, 243, 115, 77, 255, 243, 115, 77, 255, 243, 116, 77, 255, 244, 116, 77, 255, 244, 116, 77, 255, 244, 116, 77, 255, 244, 117, 77, 255, 246, 125, 81, 255, 247, 125, 81, 255, 247, 125, 81, 255, 247, 126, 81, 255, 247, 126, 81, 255, 247, 126, 81, 255, 247, 126, 82, 255, 247, 127, 82, 255, 247, 127, 82, 255, 247, 127, 82, 255, 247, 127, 82, 255, 247, 128, 82, 255, 247, 128, 82, 255, 248, 128, 82, 255, 248, 128, 82, 255, 248, 129, 83, 255, 248, 129, 83, 255, 248, 129, 83, 255, 248, 129, 83, 255, 248, 130, 83, 255, 248, 130, 83, 255, 248, 130, 83, 255, 248, 130, 83, 255, 248, 131, 83, 255, 248, 131, 84, 255, 248, 131, 84, 255, 249, 131, 84, 255, 249, 132, 84, 255, 249, 132, 84, 255, 249, 132, 84, 255, 249, 132, 84, 255, 249, 133, 84, 255, 249, 133, 85, 255, 249, 133, 85, 255, 249, 133, 85, 255, 249, 134, 85, 255, 249, 134, 85, 255, 249, 134, 85, 255, 249, 134, 85, 255, 250, 134, 85, 255, 250, 135, 85, 255, 250, 135, 86, 255, 250, 135, 86, 255, 250, 135, 86, 255, 250, 136, 86, 255, 250, 136, 86, 255, 250, 136, 86, 255, 250, 136, 86, 255, 250, 137, 86, 255, 250, 137, 87, 255, 250, 137, 87, 255, 251, 137, 87, 255, 251, 138, 87, 255, 251, 138, 87, 255, 251, 138, 87, 255, 251, 138, 87, 255, 251, 139, 87, 255, 251, 139, 88, 255, 251, 139, 88, 255, 251, 139, 88, 255, 251, 140, 88, 255, 251, 140, 88, 255, 251, 140, 88, 255, 251, 140, 88, 255, 251, 141, 88, 255, 252, 141, 89, 255, 252, 141, 89, 255, 252, 141, 89, 255, 252, 142, 89, 255, 252, 142, 90, 255, 252, 142, 90, 255, 252, 143, 90, 255, 252, 143, 90, 255, 252, 143, 90, 255, 252, 144, 91, 255, 252, 144, 91, 255, 252, 144, 91, 255, 252, 145, 91, 255, 252, 145, 92, 255, 252, 145, 92, 255, 252, 145, 92, 255, 252, 146, 92, 255, 252, 146, 93, 255, 252, 146, 93, 255, 252, 147, 93, 255, 252, 147, 93, 255, 252, 147, 93, 255, 252, 148, 94, 255, 252, 148, 94, 255, 252, 148, 94, 255, 252, 148, 94, 255, 252, 149, 95, 255, 252, 149, 95, 255, 252, 149, 95, 255, 252, 150, 95, 255, 252, 150, 96, 255, 252, 150, 96, 255, 252, 151, 96, 255, 252, 151, 96, 255, 252, 151, 97, 255, 252, 151, 97, 255, 252, 152, 97, 255, 252, 152, 97, 255, 252, 152, 98, 255, 252, 153, 98, 255, 252, 153, 98, 255, 252, 153, 98, 255, 252, 154, 99, 255, 252, 154, 99, 255, 252, 154, 99, 255, 252, 154, 99, 255, 252, 155, 100, 255, 252, 155, 100, 255, 252, 155, 100, 255, 252, 156, 100, 255, 252, 156, 101, 255, 252, 156, 101, 255, 252, 156, 101, 255, 252, 157, 101, 255, 252, 157, 102, 255, 252, 157, 102, 255, 252, 158, 102, 255, 252, 158, 102, 255, 252, 158, 103, 255, 252, 158, 103, 255, 252, 159, 103, 255, 252, 159, 104, 255, 252, 159, 104, 255, 252, 169, 113, 255, 252, 169, 113, 255, 252, 169, 113, 255, 252, 170, 113, 255, 252, 170, 114, 255, 252, 170, 114, 255, 252, 171, 114, 255, 252, 171, 115, 255, 252, 171, 115, 255, 252, 171, 115, 255, 252, 172, 115, 255, 252, 172, 116, 255, 252, 172, 116, 255, 252, 173, 116, 255, 252, 173, 117, 255, 252, 173, 117, 255, 252, 173, 117, 255, 252, 174, 117, 255, 252, 174, 118, 255, 252, 174, 118, 255, 252, 174, 118, 255, 252, 175, 118, 255, 252, 175, 119, 255, 252, 175, 119, 255, 252, 176, 119, 255, 252, 176, 120, 255, 252, 176, 120, 255, 252, 176, 120, 255, 252, 177, 121, 255, 252, 177, 121, 255, 252, 177, 121, 255, 252, 178, 121, 255, 252, 178, 122, 255, 252, 178, 122, 255, 252, 178, 122, 255, 252, 179, 123, 255, 252, 179, 123, 255, 252, 179, 123, 255, 252, 179, 123, 255, 252, 180, 124, 255, 252, 180, 124, 255, 252, 180, 124, 255, 252, 181, 125, 255, 252, 181, 125, 255, 252, 181, 125, 255, 252, 181, 126, 255, 252, 182, 126, 255, 252, 182, 126, 255, 252, 182, 127, 255, 252, 182, 127, 255, 252, 183, 127, 255, 252, 183, 127, 255, 252, 183, 128, 255, 252, 184, 128, 255, 252, 184, 128, 255, 252, 184, 129, 255, 252, 184, 129, 255, 252, 185, 129, 255, 252, 185, 130, 255, 252, 185, 130, 255, 252, 185, 130, 255, 252, 186, 131, 255, 252, 186, 131, 255, 252, 186, 131, 255, 252, 187, 131, 255, 252, 187, 132, 255, 252, 187, 132, 255, 252, 187, 132, 255, 252, 187, 132, 255, 252, 187, 132, 255, 252, 187, 132, 255, 252, 188, 133, 255, 252, 188, 133, 255, 252, 188, 133, 255, 252, 188, 133, 255, 252, 188, 133, 255, 252, 188, 133, 255, 252, 189, 133, 255, 252, 189, 134, 255, 252, 189, 134, 255, 252, 189, 134, 255, 252, 189, 134, 255, 252, 189, 134, 255, 252, 190, 134, 255, 252, 190, 134, 255, 252, 190, 135, 255, 252, 190, 135, 255, 252, 190, 135, 255, 252, 190, 135, 255, 252, 191, 135, 255, 252, 191, 135, 255, 252, 191, 135, 255, 252, 191, 136, 255, 252, 191, 136, 255, 252, 191, 136, 255, 252, 191, 136, 255, 252, 192, 136, 255, 252, 192, 136, 255, 252, 192, 137, 255, 252, 192, 137, 255, 252, 192, 137, 255, 252, 192, 137, 255, 252, 193, 137, 255, 252, 193, 137, 255, 252, 193, 137, 255, 252, 193, 138, 255, 252, 193, 138, 255, 252, 193, 138, 255, 252, 194, 138, 255, 252, 194, 138, 255, 252, 194, 138, 255, 252, 194, 139, 255, 252, 194, 139, 255, 252, 194, 139, 255, 252, 195, 139, 255, 252, 195, 139, 255, 252, 195, 139, 255, 252, 195, 139, 255, 252, 195, 140, 255, 252, 195, 140, 255, 252, 195, 140, 255, 252, 196, 140, 255, 252, 196, 140, 255, 252, 196, 140, 255, 252, 196, 141, 255, 252, 196, 141, 255, 252, 196, 141, 255, 252, 197, 141, 255, 252, 202, 146, 255, 252, 202, 147, 255, 252, 202, 147, 255, 252, 202, 147, 255, 252, 202, 147, 255, 252, 202, 147, 255, 252, 203, 147, 255, 252, 203, 148, 255, 252, 203, 148, 255, 252, 203, 148, 255, 252, 203, 148, 255, 252, 203, 148, 255, 252, 204, 148, 255, 252, 204, 149, 255, 252, 204, 149, 255, 252, 204, 149, 255, 252, 204, 149, 255, 252, 204, 149, 255, 252, 204, 149, 255, 252, 205, 150, 255, 252, 205, 150, 255, 252, 205, 150, 255, 252, 205, 150, 255, 252, 205, 150, 255, 252, 205, 150, 255, 252, 206, 151, 255, 252, 206, 151, 255, 252, 206, 151, 255, 252, 206, 151, 255, 252, 206, 151, 255, 252, 206, 151, 255, 252, 206, 152, 255, 252, 207, 152, 255, 252, 207, 152, 255, 252, 207, 152, 255, 252, 207, 152, 255, 252, 207, 153, 255, 252, 207, 153, 255, 252, 208, 153, 255, 252, 208, 153, 255, 252, 208, 153, 255, 252, 208, 153, 255, 252, 208, 154, 255, 252, 208, 154, 255, 252, 208, 154, 255, 252, 209, 154, 255, 252, 209, 154, 255, 252, 209, 154, 255, 252, 209, 155, 255, 252, 209, 155, 255, 252, 209, 155, 255, 252, 210, 155, 255, 252, 210, 155, 255, 252, 210, 156, 255, 252, 210, 156, 255, 252, 210, 156, 255, 252, 210, 156, 255, 252, 210, 156, 255, 252, 211, 156, 255, 252, 211, 157, 255, 252, 211, 157, 255, 252, 211, 157, 255, 252, 211, 157, 255, 252, 211, 157, 255, 252, 212, 157, 255, 253, 212, 158, 255, 253, 212, 158, 255, 253, 212, 158, 255, 253, 212, 159, 255, 253, 212, 159, 255, 253, 212, 159, 255, 253, 212, 159, 255, 253, 213, 160, 255, 253, 213, 160, 255, 253, 213, 160, 255, 253, 213, 160, 255, 253, 213, 161, 255, 253, 213, 161, 255, 253, 213, 161, 255, 253, 213, 161, 255, 253, 214, 162, 255, 253, 214, 162, 255, 253, 214, 162, 255, 253, 214, 162, 255, 253, 214, 163, 255, 253, 214, 163, 255, 253, 214, 163, 255, 253, 214, 163, 255, 253, 215, 164, 255, 253, 215, 164, 255, 253, 215, 164, 255, 253, 215, 164, 255, 253, 215, 165, 255, 253, 215, 165, 255, 253, 215, 165, 255, 253, 215, 166, 255, 253, 216, 166, 255, 253, 216, 166, 255, 253, 216, 166, 255, 253, 216, 167, 255, 253, 216, 167, 255, 253, 216, 167, 255, 253, 216, 167, 255, 253, 216, 168, 255, 253, 217, 168, 255, 253, 217, 168, 255, 253, 217, 168, 255, 253, 217, 169, 255, 253, 217, 169, 255, 253, 217, 169, 255, 253, 217, 169, 255, 253, 217, 170, 255, 253, 218, 170, 255, 253, 218, 170, 255, 253, 218, 170, 255, 253, 218, 171, 255, 253, 218, 171, 255, 253, 218, 171, 255, 253, 218, 172, 255, 253, 218, 172, 255, 253, 219, 172, 255, 253, 219, 172, 255, 253, 219, 173, 255, 253, 219, 173, 255, 253, 219, 173, 255, 253, 219, 173, 255, 253, 219, 174, 255, 253, 219, 174, 255, 253, 224, 183, 255, 253, 224, 183, 255, 253, 224, 183, 255, 253, 224, 183, 255, 253, 224, 184, 255, 253, 224, 184, 255, 253, 224, 184, 255, 253, 224, 184, 255, 253, 225, 185, 255, 253, 225, 185, 255, 253, 225, 185, 255, 253, 225, 185, 255, 253, 225, 186, 255, 253, 225, 186, 255, 253, 225, 186, 255, 253, 225, 186, 255, 253, 226, 187, 255, 253, 226, 187, 255, 253, 226, 187, 255, 253, 226, 188, 255, 253, 226, 188, 255, 253, 226, 188, 255, 253, 226, 188, 255, 253, 226, 189, 255, 253, 227, 189, 255, 253, 227, 189, 255, 253, 227, 189, 255, 253, 227, 190, 255, 253, 227, 190, 255, 253, 227, 190, 255, 253, 227, 190, 255, 253, 227, 191, 255, 253, 228, 191, 255, 253, 228, 191, 255, 253, 228, 192, 255, 253, 228, 192, 255, 253, 228, 192, 255, 253, 228, 192, 255, 253, 228, 193, 255, 253, 228, 193, 255, 253, 229, 193, 255, 253, 229, 193, 255, 253, 229, 194, 255, 253, 229, 194, 255, 253, 229, 194, 255, 253, 229, 194, 255, 253, 229, 195, 255, 253, 229, 195, 255, 253, 230, 195, 255, 253, 230, 195, 255, 253, 230, 196, 255, 253, 230, 196, 255, 253, 230, 196, 255, 253, 230, 197, 255, 253, 230, 197, 255, 253, 230, 197, 255, 253, 231, 197, 255, 253, 231, 198, 255, 253, 231, 198, 255, 253, 231, 198, 255, 253, 231, 198, 255, 253, 231, 199, 255, 253, 231, 199, 255, 253, 231, 199, 255, 253, 232, 199, 255, 254, 232, 200, 255, 254, 232, 200, 255, 254, 232, 200, 255, 254, 232, 200, 255, 254, 232, 201, 255, 254, 232, 201, 255, 254, 232, 201, 255, 254, 232, 201, 255, 254, 232, 202, 255, 254, 232, 202, 255, 254, 233, 202, 255, 254, 233, 202, 255, 254, 233, 202, 255, 254, 233, 203, 255, 254, 233, 203, 255, 254, 233, 203, 255, 254, 233, 203, 255, 254, 233, 204, 255, 254, 233, 204, 255, 254, 233, 204, 255, 254, 233, 204, 255, 254, 234, 204, 255, 254, 234, 205, 255, 254, 234, 205, 255, 254, 234, 205, 255, 254, 234, 205, 255, 254, 234, 206, 255, 254, 234, 206, 255, 254, 234, 206, 255, 254, 234, 206, 255, 254, 234, 206, 255, 254, 234, 207, 255, 254, 235, 207, 255, 254, 235, 207, 255, 254, 235, 207, 255, 254, 235, 208, 255, 254, 235, 208, 255, 254, 235, 208, 255, 254, 235, 208, 255, 254, 235, 208, 255, 254, 235, 209, 255, 254, 235, 209, 255, 254, 236, 209, 255, 254, 236, 209, 255, 254, 236, 210, 255, 254, 236, 210, 255, 254, 236, 210, 255, 254, 236, 210, 255, 254, 236, 210, 255, 254, 236, 211, 255, 254, 236, 211, 255, 254, 236, 211, 255, 254, 236, 211, 255, 254, 237, 212, 255, 254, 237, 212, 255, 254, 237, 212, 255, 254, 237, 212, 255, 254, 237, 212, 255, 254, 237, 213, 255, 254, 237, 213, 255, 254, 237, 213, 255, 254, 237, 213, 255, 254, 237, 214, 255, 254, 240, 221, 255, 254, 241, 221, 255, 254, 241, 221, 255, 254, 241, 222, 255, 254, 241, 222, 255, 254, 241, 222, 255, 254, 241, 222, 255, 254, 241, 223, 255, 254, 241, 223, 255, 254, 241, 223, 255, 254, 241, 223, 255, 254, 242, 224, 255, 254, 242, 224, 255, 254, 242, 224, 255, 254, 242, 224, 255, 254, 242, 224, 255, 254, 242, 225, 255, 254, 242, 225, 255, 254, 242, 225, 255, 254, 242, 225, 255, 254, 242, 226, 255, 254, 242, 226, 255, 254, 243, 226, 255, 254, 243, 226, 255, 254, 243, 226, 255, 254, 243, 227, 255, 254, 243, 227, 255, 254, 243, 227, 255, 254, 243, 227, 255, 254, 243, 228, 255, 254, 243, 228, 255, 254, 243, 228, 255, 254, 243, 228, 255, 254, 244, 228, 255, 254, 244, 229, 255, 254, 244, 229, 255, 254, 244, 229, 255, 254, 244, 229, 255, 254, 244, 230, 255, 254, 244, 230, 255, 254, 244, 230, 255, 254, 244, 230, 255, 254, 244, 231, 255, 254, 245, 231, 255, 254, 245, 231, 255, 254, 245, 231, 255, 254, 245, 231, 255, 254, 245, 232, 255, 254, 245, 232, 255, 254, 245, 232, 255, 254, 245, 232, 255, 254, 245, 233, 255, 254, 245, 233, 255, 254, 245, 233, 255, 254, 246, 233, 255, 254, 246, 233, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255
};
static const heatmap_colorscheme_t mixed = { mixed_data, sizeof(mixed_data)/sizeof(mixed_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_OrRd_mixed = &mixed;

static const unsigned char mixed_exp_data[] = {
    0, 0, 0, 0, 126, 0, 0, 0, 130, 0, 0, 24, 133, 0, 0, 49, 136, 0, 0, 74, 139, 0, 0, 99, 142, 0, 0, 124, 145, 0, 1, 149, 159, 0, 1, 174, 162, 0, 0, 199, 165, 0, 0, 224, 168, 0, 0, 249, 171, 0, 0, 255, 174, 0, 0, 255, 177, 0, 0, 255, 179, 1, 0, 255, 181, 5, 2, 255, 183, 9, 3, 255, 185, 13, 5, 255, 187, 16, 7, 255, 189, 18, 9, 255, 191, 21, 10, 255, 193, 23, 12, 255, 202, 35, 20, 255, 204, 37, 22, 255, 206, 39, 23, 255, 207, 40, 25, 255, 209, 42, 26, 255, 211, 44, 28, 255, 213, 46, 29, 255, 214, 47, 30, 255, 216, 51, 32, 255, 217, 54, 34, 255, 218, 56, 36, 255, 219, 59, 38, 255, 220, 62, 40, 255, 221, 64, 42, 255, 223, 67, 44, 255, 224, 69, 46, 255, 230, 82, 56, 255, 231, 84, 57, 255, 232, 86, 59, 255, 233, 88, 61, 255, 234, 91, 63, 255, 235, 93, 65, 255, 236, 95, 66, 255, 237, 97, 68, 255, 238, 99, 70, 255, 238, 100, 71, 255, 239, 102, 72, 255, 240, 104, 73, 255, 240, 106, 73, 255, 241, 107, 74, 255, 241, 109, 74, 255, 242, 110, 75, 255, 242, 112, 76, 255, 243, 114, 76, 255, 243, 115, 77, 255, 244, 117, 77, 255, 247, 126, 81, 255, 247, 127, 82, 255, 248, 129, 83, 255, 248, 130, 83, 255, 249, 132, 84, 255, 249, 133, 85, 255, 250, 134, 85, 255, 250, 136, 86, 255, 250, 137, 87, 255, 251, 138, 87, 255, 251, 140, 88, 255, 252, 141, 89, 255, 252, 143, 90, 255, 252, 144, 91, 255, 252, 146, 93, 255, 252, 148, 94, 255, 252, 149, 95, 255, 252, 151, 96, 255, 252, 152, 97, 255, 252, 154, 99, 255, 252, 155, 100, 255, 252, 157, 101, 255, 252, 158, 102, 255, 252, 159, 104, 255, 252, 170, 114, 255, 252, 171, 115, 255, 252, 172, 116, 255, 252, 174, 117, 255, 252, 175, 119, 255, 252, 176, 120, 255, 252, 178, 121, 255, 252, 179, 123, 255, 252, 180, 124, 255, 252, 181, 125, 255, 252, 182, 127, 255, 252, 183, 128, 255, 252, 185, 129, 255, 252, 186, 131, 255, 252, 187, 132, 255, 252, 187, 132, 255, 252, 188, 133, 255, 252, 189, 133, 255, 252, 189, 134, 255, 252, 190, 135, 255, 252, 191, 135, 255, 252, 191, 136, 255, 252, 192, 136, 255, 252, 192, 137, 255, 252, 193, 138, 255, 252, 194, 138, 255, 252, 194, 139, 255, 252, 195, 139, 255, 252, 195, 140, 255, 252, 196, 140, 255, 252, 196, 141, 255, 252, 202, 147, 255, 252, 203, 147, 255, 252, 203, 148, 255, 252, 204, 148, 255, 252, 204, 149, 255, 252, 205, 150, 255, 252, 205, 150, 255, 252, 206, 151, 255, 252, 206, 151, 255, 252, 207, 152, 255, 252, 207, 152, 255, 252, 208, 153, 255, 252, 208, 153, 255, 252, 209, 154, 255, 252, 209, 155, 255, 252, 209, 155, 255, 252, 210, 156, 255, 252, 210, 156, 255, 252, 211, 157, 255, 252, 211, 157, 255, 253, 212, 158, 255, 253, 212, 159, 255, 253, 212, 159, 255, 253, 213, 160, 255, 253, 213, 161, 255, 253, 213, 161, 255, 253, 214, 162, 255, 253, 214, 163, 255, 253, 214, 163, 255, 253, 215, 164, 255, 253, 215, 165, 255, 253, 215, 166, 255, 253, 216, 166, 255, 253, 216, 167, 255, 253, 216, 167, 255, 253, 217, 168, 255, 253, 217, 169, 255, 253, 217, 169, 255, 253, 218, 170, 255, 253, 218, 171, 255, 253, 218, 171, 255, 253, 219, 172, 255, 253, 219, 172, 255, 253, 219, 173, 255, 253, 219, 174, 255, 253, 224, 183, 255, 253, 224, 183, 255, 253, 224, 184, 255, 253, 224, 184, 255, 253, 225, 185, 255, 253, 225, 185, 255, 253, 225, 186, 255, 253, 226, 187, 255, 253, 226, 187, 255, 253, 226, 188, 255, 253, 226, 188, 255, 253, 227, 189, 255, 253, 227, 189, 255, 253, 227, 190, 255, 253, 227, 190, 255, 253, 227, 191, 255, 253, 228, 191, 255, 253, 228, 192, 255, 253, 228, 192, 255, 253, 228, 193, 255, 253, 229, 193, 255, 253, 229, 194, 255, 253, 229, 194, 255, 253, 229, 195, 255, 253, 229, 195, 255, 253, 230, 195, 255, 253, 230, 196, 255, 253, 230, 196, 255, 253, 230, 197, 255, 253, 230, 197, 255, 253, 231, 198, 255, 253, 231, 198, 255, 253, 231, 199, 255, 253, 231, 199, 255, 253, 231, 199, 255, 254, 232, 200, 255, 254, 232, 200, 255, 254, 232, 200, 255, 254, 232, 201, 255, 254, 232, 201, 255, 254, 232, 201, 255, 254, 232, 202, 255, 254, 233, 202, 255, 254, 233, 202, 255, 254, 233, 203, 255, 254, 233, 203, 255, 254, 233, 203, 255, 254, 233, 204, 255, 254, 233, 204, 255, 254, 233, 204, 255, 254, 234, 204, 255, 254, 234, 205, 255, 254, 234, 205, 255, 254, 234, 205, 255, 254, 234, 206, 255, 254, 234, 206, 255, 254, 234, 206, 255, 254, 234, 206, 255, 254, 235, 207, 255, 254, 235, 207, 255, 254, 235, 207, 255, 254, 235, 207, 255, 254, 235, 208, 255, 254, 235, 208, 255, 254, 235, 208, 255, 254, 235, 208, 255, 254, 235, 209, 255, 254, 235, 209, 255, 254, 236, 209, 255, 254, 236, 209, 255, 254, 236, 210, 255, 254, 236, 210, 255, 254, 236, 210, 255, 254, 236, 210, 255, 254, 236, 211, 255, 254, 236, 211, 255, 254, 236, 211, 255, 254, 236, 211, 255, 254, 236, 211, 255, 254, 237, 212, 255, 254, 237, 212, 255, 254, 237, 212, 255, 254, 237, 212, 255, 254, 237, 213, 255, 254, 237, 213, 255, 254, 237, 213, 255, 254, 237, 213, 255, 254, 237, 213, 255, 254, 237, 213, 255, 254, 237, 214, 255, 254, 240, 221, 255, 254, 241, 221, 255, 254, 241, 221, 255, 254, 241, 222, 255, 254, 241, 222, 255, 254, 241, 222, 255, 254, 241, 222, 255, 254, 241, 222, 255, 254, 241, 222, 255, 254, 241, 223, 255, 254, 241, 223, 255, 254, 241, 223, 255, 254, 241, 223, 255, 254, 241, 223, 255, 254, 241, 223, 255, 254, 242, 224, 255, 254, 242, 224, 255, 254, 242, 224, 255, 254, 242, 224, 255, 254, 242, 224, 255, 254, 242, 224, 255, 254, 242, 225, 255, 254, 242, 225, 255, 254, 242, 225, 255, 254, 242, 225, 255, 254, 242, 225, 255, 254, 242, 225, 255, 254, 242, 225, 255, 254, 242, 225, 255, 254, 242, 226, 255, 254, 242, 226, 255, 254, 243, 226, 255, 254, 243, 226, 255, 254, 243, 226, 255, 254, 243, 226, 255, 254, 243, 226, 255, 254, 243, 227, 255, 254, 243, 227, 255, 254, 243, 227, 255, 254, 243, 227, 255, 254, 243, 227, 255, 254, 243, 227, 255, 254, 243, 227, 255, 254, 243, 227, 255, 254, 243, 227, 255, 254, 243, 228, 255, 254, 243, 228, 255, 254, 243, 228, 255, 254, 243, 228, 255, 254, 243, 228, 255, 254, 243, 228, 255, 254, 243, 228, 255, 254, 243, 228, 255, 254, 244, 228, 255, 254, 244, 228, 255, 254, 244, 229, 255, 254, 244, 229, 255, 254, 244, 229, 255, 254, 244, 229, 255, 254, 244, 229, 255, 254, 244, 229, 255, 254, 244, 229, 255, 254, 244, 229, 255, 254, 244, 229, 255, 254, 244, 229, 255, 254, 244, 229, 255, 254, 244, 230, 255, 254, 244, 230, 255, 254, 244, 230, 255, 254, 244, 230, 255, 254, 244, 230, 255, 254, 244, 230, 255, 254, 244, 230, 255, 254, 244, 230, 255, 254, 244, 230, 255, 254, 244, 230, 255, 254, 244, 230, 255, 254, 244, 230, 255, 254, 244, 230, 255, 254, 244, 231, 255, 254, 244, 231, 255, 254, 245, 231, 255, 254, 245, 231, 255, 254, 245, 231, 255, 254, 245, 231, 255, 254, 245, 231, 255, 254, 245, 231, 255, 254, 245, 231, 255, 254, 245, 231, 255, 254, 245, 231, 255, 254, 245, 231, 255, 254, 245, 231, 255, 254, 245, 231, 255, 254, 245, 231, 255, 254, 245, 232, 255, 254, 245, 232, 255, 254, 245, 232, 255, 254, 245, 232, 255, 254, 245, 232, 255, 254, 245, 232, 255, 254, 245, 232, 255, 254, 245, 232, 255, 254, 245, 232, 255, 254, 245, 232, 255, 254, 245, 232, 255, 254, 245, 232, 255, 254, 245, 232, 255, 254, 245, 232, 255, 254, 245, 232, 255, 254, 245, 232, 255, 254, 245, 232, 255, 254, 245, 232, 255, 254, 245, 232, 255, 254, 245, 232, 255, 254, 245, 233, 255, 254, 245, 233, 255, 254, 245, 233, 255, 254, 245, 233, 255, 254, 245, 233, 255, 254, 245, 233, 255, 254, 245, 233, 255, 254, 245, 233, 255, 254, 245, 233, 255, 254, 245, 233, 255, 254, 245, 233, 255, 254, 245, 233, 255, 254, 245, 233, 255, 254, 245, 233, 255, 254, 246, 233, 255, 254, 246, 233, 255, 254, 246, 233, 255, 254, 246, 233, 255, 254, 246, 233, 255, 254, 246, 233, 255, 254, 246, 233, 255, 254, 246, 233, 255, 254, 246, 233, 255, 254, 246, 233, 255, 254, 246, 233, 255, 254, 246, 233, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 234, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 246, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255, 254, 247, 235, 255
};
static const heatmap_colorscheme_t mixed_exp = { mixed_exp_data, sizeof(mixed_exp_data)/sizeof(mixed_exp_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_OrRd_mixed_exp = &mixed_exp;

#ifdef __cplusplus
}
#endif
