<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

OCIO v2 WORKING GROUP MEETING  
2020-06-18  
via Zoom  

Participants:
  * Remi Achard (DNeg)
  * Dennis Adams (Sony)
  * Mark Boorer (ILM)
  * Sean Cooper (DNeg)
  * Joseph Goldstone (ARRI)
  * Bernard Lefebvre (Autodesk)
  * Thomas Mansencal (Weta)
  * Carol Payne (Netflix)
  * Matthias Scharfenberg (ILM)
  * Troy Sobotka
  * Kevin Wheatley (Framestore)

Apologies:
  * Michael Dolan (Epic)

Hosts:
  * Doug Walker (Autodesk)
  * Patrick Hodoul (Autodesk)

Recording on Zoom cloud:  
<https://autodesk.zoom.us/rec/play/SVOjCcbCMoICkYjdvECGQhcrZpmFTyz7hxr1KM4szTZP7-MsroN9-5NWU1Heu1flvfe3lW6TGxngnvf5.C0EX9xta8CAtF_E0?autoplay=true>


**DISPLAY/VIEW UPGRADES, PR #1038**

   - Doug: Bernard has pushed PR #1038 which implements one of the main
discussion topics from last meeting.  I've created issues on GitHub to describe
the work, so even if you don't have time to review the PR, you could review the
issues and provide comments there.
   - Troy: Is it possible to get display transfer functions.  Doug: It's not
part of this PR.

**VERSION HANDLING**

   - Doug: There is not much version handling code in place, since there has
only been one major version so far.  We propose adding a checkVersionConsistency
function that will check that new features are not used in v1 configs.  It will
be called when loading and saving Yaml and by SanityCheck.  New configs will be
v2 by default.
   - Mark: Sounds good. Need to make sure to handle necessary roles.
   - Doug: Yes, those are mostly handled in ociocheck curretly.  The default
role is used by default by the new File Rules, and SanityCheck will validate
that all rules are valid.  The other roles are only needed by the app-helpers,
tools, and plug-ins and are done in ociocheck.
   - Troy: I've seen some role errors pop up from the Python SanityCheck.
   - Doug/Patrick: The Python is just a binding on the C++ version.  It checks
that the existing roles are valid but not that desired roles are present (except
for default).
   - Mark: I don't think it matters too much if they're all in one function. 
Perhaps ociocheck should just call SanityCheck and exit.
   - Kevin: There is a Python unit test ConstantsTest.py that checks constants
for roles exist but not the actual roles exist in the config.
   - Patrick: If you load a v1 config and save it, it will save as v1.  But
there is also a new method that will update a config to the latest version, if
you want to.

**VIRTUAL DISPLAYS FOR ICC PROFILES**

   - Doug: We would like to allow people to use the ICC monitor profile.  There
is already code in v2 to load an ICC profile in FileTransform if the file name
is known but missing a way to reference the "current" monitor profile as
identified in the OS system settings.
   - Doug: The original v2 proposal document proposed implementing this as a new
Transform type.  However a profile may not be available on a given system and we
never want Transforms to throw.  Also the color space name should be unique per
monitor.  So we propose introducing the concept of a "virtual display."
   - Doug: The virtual display allows the config author to describe how the ICC
profile would be utilized by the config.  It is a placeholder in the config,
with the desired views, that will be instantiated by OCIO at runtime using the
user's ICC profile.  A side benefit of this approach is that it handles the case
of multiple monitors elegantly.
   - Doug: This is an opt-in feature for the config author.  If the config
author does not add this section to their config, OCIO will not be able to add
support for a user's ICC profile.
   - Mark: Why can't the people that want to use ICC profiles just create a
transform, why is a virtual display needed?
   - Doug: Yes, a config author could already do that, but the config author
won't know in advance the path to that file.
   - Mark: Why wouldn't they put the ICC profile in the luts folder for the
config?  Doug: Because the ICC profiles are not stored there by the operating
systems.
   - Mark: Is the existing capability loading from the luts folder or from
OS-specific folders?  Doug:  The existing capability is just ICC format support
for FileTransform, so it loads the file using the same mechanism as any other
LUT.
   - Mark: We need to be careful in regard to referencing transforms that are
not part of the OCIO package of lut directories.  Doug: When the virtual display
is instantiated, a FileTransform would be created that points to the ICC
profile.
   - Mark: Why would we encourage people to work that way rather than keeping
everything in the package?  Doug: Yes, Patrick and I were discussing that and
wondering if we should make a copy of the profile or add the path to the search
path.
   - Doug: But the core issue is that the config author can't anticipate where
the profile will be.  Mark: Why not?  Kevin: Because it may be in the display
itself, etc.
   - Kevin: What happens with displays that change the profile when the user
hits a button to put it into a different mode?  Joseph: Will there be a
call-back to know if it's been changed (it may cause the device to send back a
new EDID which will be used to synthesize a new profile)?  
   - Doug: The operating systems that support ICC allow for a call-back.  This
does not present a problem for the proposed approach, the application would just
ask OCIO to instantiate another display based on the new profile.
   - Kevin: The profile may not exist on disk, it may just be an EDID.  I would
probably not use this feature at work but I understand the need and the
motivation.  I have a problem with the naming however.
   - Joseph: What if there is a 'vcgt' tag?  If you make that profile active, it
changes the behavior.  Is this to allow us to emulate what the profile would be
doing or would you use this on top of an existing color management system.
   - Doug: The high-level use-case is that some applications want to be able to
emulate, for example, what the Adobe applications such as Photoshop do.  They
would like their viewport in a DCC to be able to display an image in the same
way, when necessary.  The missing piece is just how to create the display color
space on the fly.  OCIO color management is intended to be used instead of
rather than on top of the OS color management.  Mark: Thank god!
   - Mark: Do we need to do a conversion from the display the user picks to the
ICC profile?  The design of OCIO is so that the user picks the display, not so
that it interfaces with the OS color management.  
   - Doug: Right, and it would still stay that way.  When the app calls the new
function to instantiate the virtual display, the user would then have in their
display list a new display based on the ICC profile in addition to the other
displays the config author included.
   - Mark: I understand the goal, but not why the virtual display is needed. 
Kevin: Without some feature like this, the application could not add a display
since it would not understand what views might be relevant.  That's the key,
isn't it?  So this is a template for adding a display dynamically.  Doug:
Exactly!
   - Sean: Instead of a dynamic display popping in and out of existance, could
it be a dynamic transform that the config uses under a regular display?  So the
config author could add a display called "ICC" and use the new transform in the
views, since we may want to concatenate things together.
   - Doug: That was the original proposal but after starting work on it Patrick
and I realized that there are a lot of edge cases and potential complexity
around that approach.  We feel the current approach is much cleaner.
Sean: When the new display comes into existance, how are the views used?  Doug:
It's controlled by the config author via the display/view syntax.
   - Kevin: I'd definitely want to control that display name for the user menus.
 I think RV uses the name returned by the EDID.  Different OSs provide different
naming schemes.  I'd rather not have random apps picking different ways of
naming it.  Mark: OCIO would decide the name.  Doug: Exactly, OCIO would pick
the name. But the application would be able to override that, as it can already
do with any color space.  Mark: Perhaps add a table in the config to allow
remapping of names?
   - Mark: I'm vaguely on board, now that you've explained it.
   - Thomas: If I have a window on one display and I move it to another display,
would it pick up the new color space, like Photoshop?
   - Doug: That would be very window-system-specific code to be able to do that.
 Patrick and I were discussing it and agree it would be nice to have but feel
that it is out of scope for now.  The new feature would allow instantiating a
color space for both displays, but for now it would be up to the application to
worry where a window is.  Kevin: Agree, it would be up to the application to do
that part.  Mark: Agree, would be difficult to make that robust and
cross-platform.
   - Sean: I think the idea makes sense, but what about portability?  For
example, if someone makes a Quicktime using the new space and gives it to
someone else.
   - Doug: Exactly, and that was one of the factors that led us to the proposed
design since each monitor gets a new display color space created for it.  It
would probably not be a good workflow for someone to bake out something in their
ICC display color space, but there is nothing that would prevent an application
from generating a config that included that space for others, if there was a
need to.
   - Sean: But now there is this dependency on this new part of the config. 
Mark: It also kind of goes against the original vibe of OCIO, where we did not
like the way the OS was managing things dynamically. It's nice to have a fixed
set of calibrated displays and just provide color spaces based on those and
named after the calibration standard.
   - Troy: Yeah, but on macOS the display description is in the ICC profile, so
it's a critical component.  The vcgt is not something you can characterize and
that is in the ICC profile.  Mark: The calibration standard is independent of
that.
   - Doug: Agree that the best scenario is where there are a fixed set of
high-end displays (e.g. Eizo monitors) that are independently calibrated to a
set of standard calibration aims.  In that case, you don't need the new feature
and you would continue using OCIO as is.  The new feature allows OCIO to be used
in a new scenario, such as a laptop or some other case where the monitor cannot
be calibrated to an external standard and its only description is in an ICC
profile.  Mark: Right, ok.
   - Sean: I can see the utility of it, I'm just raising the fact that
portability is a concern.  
   - Thomas: And it is opt-in.  I think it could be useful in certain scenarios.
   - Doug: Right, if the config doesn't include the virtual display, the
application cannot add it.
   - Troy: Alex Fry has brought up the scenario in the ACES forum about some
displays being calibrated to a 2.2 EOTF rather than sRGB and are not seeing the
correct results. There are scenarios where the config author does not anticipate
how all displays are calibrated.  Mark: That's the config author's
responsibility to handle that.
   - Doug: I'll create an issue on GitHub for this feature and we can pick up
the discussion there or at the next meeting.
   - Joseph: The vcgt is needed to fully correct the monitor. How to include
that if the app is bypassing OS color management?  Doug:  Agreed, but the steps
needed to bypass OS color management successfully are different on each OS and
are a bit out of scope for this discussion.  Joseph: Would be nice to document
it.
   - Sean: Alternate idea: could we define an ICC Transform and have it behave
the same way as FileTransform, namely look in a list of predefined locations? 
So there would always be a fall-back?
   - Doug: You still have the problems I mentioned, the config author does not
know in advance how many monitors there are -- it could be 0, 1, 2, etc.  If
it's 0, you probably don't want that display in the list of options, if it's 2,
you might like a color space for each, etc.  Sean: OK, let's continue the
discussion on the ticket.
   - *UPDATE:* Issue now created as #1082.

**CONTEXT ENVIRONMENT**

   - Doug: As you know, OCIO has a feature to use, e.g. $FOO in the config and
set the value of that dynamically at runtime via an environment variable.  This
is usually used to handle per-shot behavior.  We have been looking at some
performance issues and want to validate some things.
   - Doug: Currently OCIO brings in the user's entire environment into the
Context object.  We have customers that may have very large environments and it
could be a performance issue.  Malcolm Humphries implemented a feature that
allows config authors to define an environment section in the config (PR #322,
Issue # 149).  Then only the listed variables from the environment get loaded. 
This keeps the context cleaner and speeds up the context cacheID computation and
also makes the configs easier to read.  This was optional for v1 and we'd like
to make it mandatory for v2 configs.
   - Mark: Does anyone use the environment section currently?  Kevin: I didn't
know it existed.  Mark: Me too.
   - Kevin: But I was going to write an RFC to add something similar.
   - Mark: Why do all the environment variables get put into the context, surely
it should only be constructed with the ones that are used.  It should parse the
config and find the list of used variables.
   - Patrick: OCIO does not currently do that.  Also, don't forget that an app
may create a context without necessarily parsing a config.  There is currently
no function to get the context variables.  Given the current rules, parsing will
be tricky.
   - Kevin: The reason I was going to propose something like this is so that the
config could declare defaults and also so that the app could know what variables
to potentially expose in the UI.  It's interesting that it already exists.
   - Mark: I don't like the idea of having to declare them before they're used.
   - Kevin: It's to provide defaults and also to be able to validate the config
without needing the environment.
   - Mark: I'm not opposed to defaults but don't want to declare variables that
don't have a default.
   - Joseph: Maybe there could be an option to ociocheck.  Patrick: We are
working on adding that to SanityCheck.
   - Kevin: The current behavior is not good since you cannot validate without a
known context.  It's easy to make a typo on a context variable and there is no
way to catch that.  I would like a really strict option.
   - Mark: It would probably fail in ociocheck when the LUTs could not be
loaded.  Kevin: It was not, but there are some new checks in v2 around looks, so
maybe it would now.  Patrick: Yes, we have added a bunch of new checks.
   - Doug: A related issue is about where the $ and % context variable tokens
may be used.  Currently it appears to work to use these in color space names. 
This is one of the problems with trying to write a function that tries to
automatically extract the context variables from a config (e.g. as a src for a
ColorSpaceTransform).  We'd like to disallow those characters in names.
   - Mark: Lower-case ASCII only would be fine with me.
   - Matthias: Alphanumeric only and no spaces.  Even common separators like
commas, tabs, colons, semi-colons, newlines should also not be allowed.
   - Thomas: In web contexts, spaces are replaced with special tokens, etc.
   - Doug: Do people really feel it is important to allow these characters?
   - Mark: Not $, but perhaps %.
   - Joseph: I don't feel it is essential, even if you wanted those characters I
think you could find a legal alternative.
   - Doug: I'll create an issue on GitHub for further discussion.
   - *UPDATE:* Issues #1064 and #1084 were created.

**CONFIG CACHEID**

   - Doug: The config cacheID was broken on Windows (surprising no one noticed
this in v1).  We want to validate our understanding of the intended behavior. 
Our understanding is that OCIO is not trying to detect any changes to LUTs that
happen while it is running.  The design seems to be to require applications to
manage this and call ClearAllCaches manually if it wants to to handle updated
files.  Is there any disagreement on that?
   - Mark: That's correct, OCIO it's not designed to have stuff change out from
under it while it's running.  But it would be nice to have an "is dirty" feature
to avoid apps from having to do the checking themselves.
   - Thomas: How does that play with the new ICC feature?  Doug: If a new color
space is added to the config (as would happen in that case) there should be no
issue for anything that is already cached.
   - Mark: We should not support changes to a config while OCIO is running. 
Applications should not be adding color spaces to configs.  
   - Doug: The public API has always supported that.
   - Mark: Isn't a config const?  Patrick: There are const and non-const
versions.
   - Mark: I would consider an application that did that to not be using OCIO
correctly.

**PROCESSOR CACHE**

   - Doug: Some applications will need to cache Processor objects for
performance reasons.  We are looking at adding caches for Processor,
CPUProcessor, and GPUProcessor objects.  The cache key would likely leverage the
Config cacheID and Context cacheID.  But it needs to be fast enough for
real-time playback applications.  The cache would likely be associated to a
config object rather than be global.
   - Mark: How would the cache be cleared?  Patrick: There is the global cache
for files, but the processor cache would not be global and it would be possible
to clear it and disable it for debugging purpses.
   - Mark: Sounds great.  We already need to do this for our tools, so it would
be nice to have it in the library.
   - Sean: Would the optimization parameters also affect the key?  Patrick: Yes.
   - Doug: Please provide feedback on your ideas and requirements.
   - *UPDATE:* Issue #1084 was created.

**LOOKS**

   - Doug: What look-related features is OCIO missing?  Also, what look-features
are applications typically not implementing correctly?
   - Sean: Looks should not be exposed as a separate thing, as they are in some
applications.
   - Kevin: We'd like to allow the look to change the color space rather than
always having the process space on both input and output.  For example, we
sometimes get a grade that changes the space.  It's possible to add more
conversions to convert back to the process space, but then that becomes a
challenge to integrate into the views.
   - Mark: An important missing feature for us is that you cannot tell at the
time the look is being applied the color space the source file had all the way
back at the start of the chain.  There's no way for the DCC to tell you that it
loaded an image in this color space and now I want to apply a look to it.  For
example, if you are loading EXRs, you would like to convert them to ACEScct
before applying the look, but for DPX files you just want them to go through in
their original color space.  The process space is going to be different
depending on what the input file was.  We need to bake out configs on the fly to
work around this, it is a big problem.
   - Kevin: I think Mark's example is perhaps similar to mine, which is
basically that OCIO does not track the image state.  For example, if I have a
Quicktime, it's already got something baked into it and if I've got an EXR, it
doesn't.  I want to show both images with the look applied, but I need to know
if it was already applied.  Mark: Yes.
   - *UPDATE:* I did not mention this during the meeting, but the new viewing
rules feature potentially enables applications to solve this problem if they
keep track of the color space since config authors can define separate views
based on color space encoding, which is essentially image state.  Please let me
know!
   - Kevin: I've also wanted to be able to use role names as the process space.
   - Mark: It would be great if there were a chain of metadata that follows the
image around that describes everything that was done to it. What I care about is
the original image color space.  What usually happens is the file space gets
converted into the working space and from that point on OCIO only knows it as
being in the working space, it doesn't know what the original space was.  We
don't use looks at all now because we can't do that.
   - Kevin: We track image state completely independently of OCIO.  Looks are
almost good, they're usable but they don't do everything that people would like.
   - Mark: I think image state is a good description, perhaps make an API call
to allow DCC applications to inject what the original image state was.
   - Kevin: I remember you discussed this aspect of image state in a paper you
wrote many years ago Doug, back when you were with Kodak.
   - Doug: Well there is now an encoding attribute available on a color space,
which is a very similar concept to image state (and allows finer distinctions
than pure ISO 22028-1 image state) so that should help.
   - Mark: What is that?  Doug: It allows you to describe the type of encoding
used for a color space, such as scene-linear vs. log vs. video.
   - Mark: Is that not what family is for?  Doug: No, take a look at issue #1031
for a discussion of the encoding feature and why it required a new attribute
rather than reusing family.
   - Doug: Sean, so you were saying that apps should not expose looks?  Sean:
Yes, if a look is part of a view, that is essentially an implementation detail
and not something that should be selectable from the UI.  Looks were never very
thoroughly described as what they were intended to do.  It would be nice to have
more clarity on their intent from an implementor's stand point.
   - Doug: But if a config has a Looks section, it's ok for apps to offer to
apply those as a LookTransform, right?  Kevin: Definitely, but you should not be
allowed to take apart a display/view combo.
   - Sean: The creation of the views may be intricate and when you try to expose
the look part as a separate option, it may break things.
   - Kevin: Especially when they are chained.  Looks may be used for purposes
other than looks.  For example, it may be used to convert a provided LUT from
one color space to another.  Because of the way process spaces work, you need to
construct it very carefully otherwise it breaks.  You cannot arbitrarily turn on
and off the looks, or reorder them.
   - Mark: We don't use looks, we make custom color spaces for each combination.
   - Kevin: And then hide the extra color spaces!  Mark: Yes, we have a family
to indicate "here be dragons".
   - Carol: For debugging, it is useful to have it exposed.
   - Troy: Doesn't it come out of the look scene-linear?  Carol: No, it goes out
back in the process space, like ACES looks.
   - Sean: Can the process space be a context variable?  It would be useful to
be able to switch the process space that way, perhaps it's similar to the
requests from Mark and Kevin.
