#ifndef BACKENDS_LOOPBACK_H
#define BACKENDS_LOOPBACK_H

#include "base.h"

struct LoopbackBackendFactory final : public BackendFactory {
public:
    auto init() -> bool final;

    auto querySupport(BackendType type) -> bool final;

    auto enumerate(BackendType type) -> std::vector<std::string> final;

    auto createBackend(DeviceBase *device, BackendType type) -> BackendPtr final;

    static auto getFactory() -> BackendFactory&;
};

#endif /* BACKENDS_LOOPBACK_H */
