---
id: share
title: Share theme
sidebar_label: 📸 Share theme
---

You can export your prompt to an image which you can share online. You have the ability to align
it correctly and add your name for credits too.

:::caution
Some glyphs aren't rendered correctly, that's not you but the limitations of the renderer.
Depending on your config, you might have to tweak the output a little bit.
:::

The oh-my-posh executable has the `config export image` command to export your current theme configuration
to a PNG image file (if no other options are specified this will be the name of the config file, or `prompt.png`).

```powershell
oh-my-posh config export image
```

## Settings File

The `--settings` flag allows you to provide a JSON file to customize the exported image. This file lets you
override colors, set the author name, and specify the background color.

```json title="~/.image.settings.json"
{
  "colors": {
    "red": "#FF6B6B",
    "blue": "#4ECDC4",
    "green": "#45B7D1",
    "yellow": "#FFA07A",
    "magenta": "#98D8C8",
    "cyan": "#F7DC6F"
  },
  "fonts": {
    "regular": "C:/Users/user/Downloads/BigBlueTerminal/BigBlueTerm437NerdFont-Regular.ttf",
    "bold": "C:/Users/user/Downloads/BigBlueTerminal/BigBlueTerm437NerdFont-Regular.ttf",
    "italic": "C:/Users/user/Downloads/BigBlueTerminal/BigBlueTerm437NerdFont-Regular.ttf"
  },
  "author": "Your Name",
  "background_color": "#282828",
  "cursor": "\udb81\udde7"
}
```

### Settings Options

<!-- markdownlint-disable MD013 -->

| Name               | Type     | Default   | Description                                                                   |
| ------------------ | -------- | --------- | ----------------------------------------------------------------------------- |
| `colors`           | `object` |           | Map of ANSI color names to hex color codes. See [16 ANSI color names][colors] |
| `author`           | `string` |           | Your name or credit to display on the image                                   |
| `background_color` | `string` | `#151515` | Hex code for the image background                                             |
| `fonts`            | `object` |           | Font settings for the image, including regular, bold, and italic styles       |
| `cursor`           | `string` | `_`       | A custom cursor                                                               |

<!-- markdownlint-enable MD013 -->

### Usage

```powershell
oh-my-posh config export image --settings ~/.image.settings.json
```

This will export your prompt image using the custom colors and settings from the file.

[colors]: /docs/configuration/colors#standard-colors
