; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 5
; RUN: opt < %s -disable-output "-passes=print<scalar-evolution>" 2>&1 | FileCheck %s

; Check that we convert
;   trunc(C * a) -> trunc(C) * trunc(a)
; if C is a constant.
define i8 @trunc_of_mul(i32 %a) {
; CHECK-LABEL: 'trunc_of_mul'
; CHECK-NEXT:  Classifying expressions for: @trunc_of_mul
; CHECK-NEXT:    %b = mul i32 %a, 100
; CHECK-NEXT:    --> (100 * %a) U: [0,-3) S: [-2147483648,2147483645)
; CHECK-NEXT:    %c = trunc i32 %b to i8
; CHECK-NEXT:    --> (100 * (trunc i32 %a to i8)) U: [0,-3) S: [-128,125)
; CHECK-NEXT:  Determining loop execution counts for: @trunc_of_mul
;
  %b = mul i32 %a, 100
  %c = trunc i32 %b to i8
  ret i8 %c
}

; Check that we convert
;   trunc(C + a) -> trunc(C) + trunc(a)
; if C is a constant.
define i8 @trunc_of_add(i32 %a) {
; CHECK-LABEL: 'trunc_of_add'
; CHECK-NEXT:  Classifying expressions for: @trunc_of_add
; CHECK-NEXT:    %b = add i32 %a, 100
; CHECK-NEXT:    --> (100 + %a) U: full-set S: full-set
; CHECK-NEXT:    %c = trunc i32 %b to i8
; CHECK-NEXT:    --> (100 + (trunc i32 %a to i8)) U: full-set S: full-set
; CHECK-NEXT:  Determining loop execution counts for: @trunc_of_add
;
  %b = add i32 %a, 100
  %c = trunc i32 %b to i8
  ret i8 %c
}

; Check that we truncate to zero values assumed to have at least as many
; trailing zeros as the target type.
define i8 @trunc_to_assumed_zeros(ptr %p) {
; CHECK-LABEL: 'trunc_to_assumed_zeros'
; CHECK-NEXT:  Classifying expressions for: @trunc_to_assumed_zeros
; CHECK-NEXT:    %a = load i32, ptr %p, align 4
; CHECK-NEXT:    --> %a U: [0,-255) S: [-2147483648,2147483393)
; CHECK-NEXT:    %and = and i32 %a, 255
; CHECK-NEXT:    --> 0 U: [0,1) S: [0,1)
; CHECK-NEXT:    %c = trunc i32 %a to i8
; CHECK-NEXT:    --> 0 U: [0,1) S: [0,1)
; CHECK-NEXT:    %d = trunc i32 %a to i1
; CHECK-NEXT:    --> false U: [0,-1) S: [0,-1)
; CHECK-NEXT:    %e = trunc i32 %a to i16
; CHECK-NEXT:    --> (trunc i32 %a to i16) U: [0,-255) S: [-32768,32513)
; CHECK-NEXT:  Determining loop execution counts for: @trunc_to_assumed_zeros
;
  %a = load i32, ptr %p
  %and = and i32 %a, 255
  %cmp = icmp eq i32 %and, 0
  tail call void @llvm.assume(i1 %cmp)
  %c = trunc i32 %a to i8
  %d = trunc i32 %a to i1
  %e = trunc i32 %a to i16
  ret i8 %c
}

declare void @llvm.assume(i1 noundef) nofree nosync nounwind willreturn
