; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -p vector-combine -mtriple=arm64-apple-macosx -S %s | FileCheck %s

declare void @use.i32(i32)
declare void @use.i64(i64)
declare void @use.v4i32(<4 x i32>)

define void @zext_v4i8_all_lanes_used(<4 x i8> %src) {
; CHECK-LABEL: define void @zext_v4i8_all_lanes_used(
; CHECK-SAME: <4 x i8> [[SRC:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TMP0:%.*]] = freeze <4 x i8> [[SRC]]
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast <4 x i8> [[TMP0]] to i32
; CHECK-NEXT:    [[TMP2:%.*]] = lshr i32 [[TMP1]], 24
; CHECK-NEXT:    [[TMP4:%.*]] = lshr i32 [[TMP1]], 16
; CHECK-NEXT:    [[TMP5:%.*]] = and i32 [[TMP4]], 255
; CHECK-NEXT:    [[TMP6:%.*]] = lshr i32 [[TMP1]], 8
; CHECK-NEXT:    [[TMP7:%.*]] = and i32 [[TMP6]], 255
; CHECK-NEXT:    [[TMP9:%.*]] = and i32 [[TMP1]], 255
; CHECK-NEXT:    [[EXT9:%.*]] = zext nneg <4 x i8> [[SRC]] to <4 x i32>
; CHECK-NEXT:    [[EXT_0:%.*]] = extractelement <4 x i32> [[EXT9]], i64 0
; CHECK-NEXT:    [[EXT_1:%.*]] = extractelement <4 x i32> [[EXT9]], i64 1
; CHECK-NEXT:    [[EXT_2:%.*]] = extractelement <4 x i32> [[EXT9]], i64 2
; CHECK-NEXT:    [[EXT_3:%.*]] = extractelement <4 x i32> [[EXT9]], i64 3
; CHECK-NEXT:    call void @use.i32(i32 [[TMP9]])
; CHECK-NEXT:    call void @use.i32(i32 [[TMP7]])
; CHECK-NEXT:    call void @use.i32(i32 [[TMP5]])
; CHECK-NEXT:    call void @use.i32(i32 [[TMP2]])
; CHECK-NEXT:    ret void
;
entry:
  %ext9 = zext nneg <4 x i8> %src to <4 x i32>
  %ext.0 = extractelement <4 x i32> %ext9, i64 0
  %ext.1 = extractelement <4 x i32> %ext9, i64 1
  %ext.2 = extractelement <4 x i32> %ext9, i64 2
  %ext.3 = extractelement <4 x i32> %ext9, i64 3

  call void @use.i32(i32 %ext.0)
  call void @use.i32(i32 %ext.1)
  call void @use.i32(i32 %ext.2)
  call void @use.i32(i32 %ext.3)
  ret void
}

define void @sext_v4i8_all_lanes_used(<4 x i8> %src) {
; CHECK-LABEL: define void @sext_v4i8_all_lanes_used(
; CHECK-SAME: <4 x i8> [[SRC:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[EXT9:%.*]] = sext <4 x i8> [[SRC]] to <4 x i32>
; CHECK-NEXT:    [[EXT_0:%.*]] = extractelement <4 x i32> [[EXT9]], i64 0
; CHECK-NEXT:    [[EXT_1:%.*]] = extractelement <4 x i32> [[EXT9]], i64 1
; CHECK-NEXT:    [[EXT_2:%.*]] = extractelement <4 x i32> [[EXT9]], i64 2
; CHECK-NEXT:    [[EXT_3:%.*]] = extractelement <4 x i32> [[EXT9]], i64 3
; CHECK-NEXT:    call void @use.i32(i32 [[EXT_0]])
; CHECK-NEXT:    call void @use.i32(i32 [[EXT_1]])
; CHECK-NEXT:    call void @use.i32(i32 [[EXT_2]])
; CHECK-NEXT:    call void @use.i32(i32 [[EXT_3]])
; CHECK-NEXT:    ret void
;
entry:
  %ext9 = sext <4 x i8> %src to <4 x i32>
  %ext.0 = extractelement <4 x i32> %ext9, i64 0
  %ext.1 = extractelement <4 x i32> %ext9, i64 1
  %ext.2 = extractelement <4 x i32> %ext9, i64 2
  %ext.3 = extractelement <4 x i32> %ext9, i64 3

  call void @use.i32(i32 %ext.0)
  call void @use.i32(i32 %ext.1)
  call void @use.i32(i32 %ext.2)
  call void @use.i32(i32 %ext.3)
  ret void
}


define void @zext_v4i8_3_lanes_used_1(<4 x i8> %src) {
; CHECK-LABEL: define void @zext_v4i8_3_lanes_used_1(
; CHECK-SAME: <4 x i8> [[SRC:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TMP0:%.*]] = freeze <4 x i8> [[SRC]]
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast <4 x i8> [[TMP0]] to i32
; CHECK-NEXT:    [[TMP2:%.*]] = lshr i32 [[TMP1]], 24
; CHECK-NEXT:    [[TMP4:%.*]] = lshr i32 [[TMP1]], 16
; CHECK-NEXT:    [[TMP5:%.*]] = and i32 [[TMP4]], 255
; CHECK-NEXT:    [[TMP6:%.*]] = lshr i32 [[TMP1]], 8
; CHECK-NEXT:    [[TMP7:%.*]] = and i32 [[TMP6]], 255
; CHECK-NEXT:    [[EXT9:%.*]] = zext nneg <4 x i8> [[SRC]] to <4 x i32>
; CHECK-NEXT:    [[EXT_1:%.*]] = extractelement <4 x i32> [[EXT9]], i64 1
; CHECK-NEXT:    [[EXT_2:%.*]] = extractelement <4 x i32> [[EXT9]], i64 2
; CHECK-NEXT:    [[EXT_3:%.*]] = extractelement <4 x i32> [[EXT9]], i64 3
; CHECK-NEXT:    call void @use.i32(i32 [[TMP7]])
; CHECK-NEXT:    call void @use.i32(i32 [[TMP5]])
; CHECK-NEXT:    call void @use.i32(i32 [[TMP2]])
; CHECK-NEXT:    ret void
;
entry:
  %ext9 = zext nneg <4 x i8> %src to <4 x i32>
  %ext.1 = extractelement <4 x i32> %ext9, i64 1
  %ext.2 = extractelement <4 x i32> %ext9, i64 2
  %ext.3 = extractelement <4 x i32> %ext9, i64 3

  call void @use.i32(i32 %ext.1)
  call void @use.i32(i32 %ext.2)
  call void @use.i32(i32 %ext.3)
  ret void
}

define void @zext_v4i8_3_lanes_used_2(<4 x i8> %src) {
; CHECK-LABEL: define void @zext_v4i8_3_lanes_used_2(
; CHECK-SAME: <4 x i8> [[SRC:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TMP0:%.*]] = freeze <4 x i8> [[SRC]]
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast <4 x i8> [[TMP0]] to i32
; CHECK-NEXT:    [[TMP2:%.*]] = lshr i32 [[TMP1]], 24
; CHECK-NEXT:    [[TMP4:%.*]] = lshr i32 [[TMP1]], 8
; CHECK-NEXT:    [[TMP5:%.*]] = and i32 [[TMP4]], 255
; CHECK-NEXT:    [[TMP7:%.*]] = and i32 [[TMP1]], 255
; CHECK-NEXT:    [[EXT9:%.*]] = zext nneg <4 x i8> [[SRC]] to <4 x i32>
; CHECK-NEXT:    [[EXT_0:%.*]] = extractelement <4 x i32> [[EXT9]], i64 0
; CHECK-NEXT:    [[EXT_1:%.*]] = extractelement <4 x i32> [[EXT9]], i64 1
; CHECK-NEXT:    [[EXT_3:%.*]] = extractelement <4 x i32> [[EXT9]], i64 3
; CHECK-NEXT:    call void @use.i32(i32 [[TMP7]])
; CHECK-NEXT:    call void @use.i32(i32 [[TMP5]])
; CHECK-NEXT:    call void @use.i32(i32 [[TMP2]])
; CHECK-NEXT:    ret void
;
entry:
  %ext9 = zext nneg <4 x i8> %src to <4 x i32>
  %ext.0 = extractelement <4 x i32> %ext9, i64 0
  %ext.1 = extractelement <4 x i32> %ext9, i64 1
  %ext.3 = extractelement <4 x i32> %ext9, i64 3

  call void @use.i32(i32 %ext.0)
  call void @use.i32(i32 %ext.1)
  call void @use.i32(i32 %ext.3)
  ret void
}

define void @zext_v4i8_2_lanes_used_1(<4 x i8> %src) {
; CHECK-LABEL: define void @zext_v4i8_2_lanes_used_1(
; CHECK-SAME: <4 x i8> [[SRC:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TMP0:%.*]] = freeze <4 x i8> [[SRC]]
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast <4 x i8> [[TMP0]] to i32
; CHECK-NEXT:    [[TMP2:%.*]] = lshr i32 [[TMP1]], 16
; CHECK-NEXT:    [[TMP3:%.*]] = and i32 [[TMP2]], 255
; CHECK-NEXT:    [[TMP4:%.*]] = lshr i32 [[TMP1]], 8
; CHECK-NEXT:    [[TMP5:%.*]] = and i32 [[TMP4]], 255
; CHECK-NEXT:    [[EXT9:%.*]] = zext nneg <4 x i8> [[SRC]] to <4 x i32>
; CHECK-NEXT:    [[EXT_1:%.*]] = extractelement <4 x i32> [[EXT9]], i64 1
; CHECK-NEXT:    [[EXT_2:%.*]] = extractelement <4 x i32> [[EXT9]], i64 2
; CHECK-NEXT:    call void @use.i32(i32 [[TMP5]])
; CHECK-NEXT:    call void @use.i32(i32 [[TMP3]])
; CHECK-NEXT:    ret void
;
entry:
  %ext9 = zext nneg <4 x i8> %src to <4 x i32>
  %ext.1 = extractelement <4 x i32> %ext9, i64 1
  %ext.2 = extractelement <4 x i32> %ext9, i64 2

  call void @use.i32(i32 %ext.1)
  call void @use.i32(i32 %ext.2)
  ret void
}

define void @zext_v4i8_2_lanes_used_2(<4 x i8> %src) {
; CHECK-LABEL: define void @zext_v4i8_2_lanes_used_2(
; CHECK-SAME: <4 x i8> [[SRC:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TMP0:%.*]] = freeze <4 x i8> [[SRC]]
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast <4 x i8> [[TMP0]] to i32
; CHECK-NEXT:    [[TMP2:%.*]] = lshr i32 [[TMP1]], 16
; CHECK-NEXT:    [[TMP3:%.*]] = and i32 [[TMP2]], 255
; CHECK-NEXT:    [[TMP5:%.*]] = and i32 [[TMP1]], 255
; CHECK-NEXT:    [[EXT9:%.*]] = zext nneg <4 x i8> [[SRC]] to <4 x i32>
; CHECK-NEXT:    [[EXT_0:%.*]] = extractelement <4 x i32> [[EXT9]], i64 0
; CHECK-NEXT:    [[EXT_2:%.*]] = extractelement <4 x i32> [[EXT9]], i64 2
; CHECK-NEXT:    call void @use.i32(i32 [[TMP5]])
; CHECK-NEXT:    call void @use.i32(i32 [[TMP3]])
; CHECK-NEXT:    ret void
;
entry:
  %ext9 = zext nneg <4 x i8> %src to <4 x i32>
  %ext.0 = extractelement <4 x i32> %ext9, i64 0
  %ext.2 = extractelement <4 x i32> %ext9, i64 2

  call void @use.i32(i32 %ext.0)
  call void @use.i32(i32 %ext.2)
  ret void
}

define void @zext_v4i8_all_lanes_used_noundef(<4 x i8> noundef %src) {
; CHECK-LABEL: define void @zext_v4i8_all_lanes_used_noundef(
; CHECK-SAME: <4 x i8> noundef [[SRC:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast <4 x i8> [[SRC]] to i32
; CHECK-NEXT:    [[TMP1:%.*]] = lshr i32 [[TMP0]], 24
; CHECK-NEXT:    [[TMP3:%.*]] = lshr i32 [[TMP0]], 16
; CHECK-NEXT:    [[TMP4:%.*]] = and i32 [[TMP3]], 255
; CHECK-NEXT:    [[TMP5:%.*]] = lshr i32 [[TMP0]], 8
; CHECK-NEXT:    [[TMP6:%.*]] = and i32 [[TMP5]], 255
; CHECK-NEXT:    [[TMP8:%.*]] = and i32 [[TMP0]], 255
; CHECK-NEXT:    [[EXT9:%.*]] = zext nneg <4 x i8> [[SRC]] to <4 x i32>
; CHECK-NEXT:    [[EXT_0:%.*]] = extractelement <4 x i32> [[EXT9]], i64 0
; CHECK-NEXT:    [[EXT_1:%.*]] = extractelement <4 x i32> [[EXT9]], i64 1
; CHECK-NEXT:    [[EXT_2:%.*]] = extractelement <4 x i32> [[EXT9]], i64 2
; CHECK-NEXT:    [[EXT_3:%.*]] = extractelement <4 x i32> [[EXT9]], i64 3
; CHECK-NEXT:    call void @use.i32(i32 [[TMP8]])
; CHECK-NEXT:    call void @use.i32(i32 [[TMP6]])
; CHECK-NEXT:    call void @use.i32(i32 [[TMP4]])
; CHECK-NEXT:    call void @use.i32(i32 [[TMP1]])
; CHECK-NEXT:    ret void
;
entry:
  %ext9 = zext nneg <4 x i8> %src to <4 x i32>
  %ext.0 = extractelement <4 x i32> %ext9, i64 0
  %ext.1 = extractelement <4 x i32> %ext9, i64 1
  %ext.2 = extractelement <4 x i32> %ext9, i64 2
  %ext.3 = extractelement <4 x i32> %ext9, i64 3

  call void @use.i32(i32 %ext.0)
  call void @use.i32(i32 %ext.1)
  call void @use.i32(i32 %ext.2)
  call void @use.i32(i32 %ext.3)
  ret void
}

define void @zext_v4i8_all_lanes_used_zext_other_users(<4 x i8> %src) {
; CHECK-LABEL: define void @zext_v4i8_all_lanes_used_zext_other_users(
; CHECK-SAME: <4 x i8> [[SRC:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[EXT9:%.*]] = zext nneg <4 x i8> [[SRC]] to <4 x i32>
; CHECK-NEXT:    [[EXT_0:%.*]] = extractelement <4 x i32> [[EXT9]], i64 0
; CHECK-NEXT:    [[EXT_1:%.*]] = extractelement <4 x i32> [[EXT9]], i64 1
; CHECK-NEXT:    [[EXT_2:%.*]] = extractelement <4 x i32> [[EXT9]], i64 2
; CHECK-NEXT:    [[EXT_3:%.*]] = extractelement <4 x i32> [[EXT9]], i64 3
; CHECK-NEXT:    call void @use.v4i32(<4 x i32> [[EXT9]])
; CHECK-NEXT:    call void @use.i32(i32 [[EXT_0]])
; CHECK-NEXT:    call void @use.i32(i32 [[EXT_1]])
; CHECK-NEXT:    call void @use.i32(i32 [[EXT_2]])
; CHECK-NEXT:    call void @use.i32(i32 [[EXT_3]])
; CHECK-NEXT:    ret void
;
entry:
  %ext9 = zext nneg <4 x i8> %src to <4 x i32>
  %ext.0 = extractelement <4 x i32> %ext9, i64 0
  %ext.1 = extractelement <4 x i32> %ext9, i64 1
  %ext.2 = extractelement <4 x i32> %ext9, i64 2
  %ext.3 = extractelement <4 x i32> %ext9, i64 3

  call void @use.v4i32(<4 x i32> %ext9)

  call void @use.i32(i32 %ext.0)
  call void @use.i32(i32 %ext.1)
  call void @use.i32(i32 %ext.2)
  call void @use.i32(i32 %ext.3)
  ret void
}

define void @zext_v4i16_all_lanes_used(<4 x i16> %src) {
; CHECK-LABEL: define void @zext_v4i16_all_lanes_used(
; CHECK-SAME: <4 x i16> [[SRC:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TMP0:%.*]] = freeze <4 x i16> [[SRC]]
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast <4 x i16> [[TMP0]] to i64
; CHECK-NEXT:    [[TMP2:%.*]] = lshr i64 [[TMP1]], 48
; CHECK-NEXT:    [[TMP4:%.*]] = lshr i64 [[TMP1]], 32
; CHECK-NEXT:    [[TMP5:%.*]] = and i64 [[TMP4]], 65535
; CHECK-NEXT:    [[TMP6:%.*]] = lshr i64 [[TMP1]], 16
; CHECK-NEXT:    [[TMP7:%.*]] = and i64 [[TMP6]], 65535
; CHECK-NEXT:    [[TMP9:%.*]] = and i64 [[TMP1]], 65535
; CHECK-NEXT:    [[EXT9:%.*]] = zext nneg <4 x i16> [[SRC]] to <4 x i64>
; CHECK-NEXT:    [[EXT_0:%.*]] = extractelement <4 x i64> [[EXT9]], i64 0
; CHECK-NEXT:    [[EXT_1:%.*]] = extractelement <4 x i64> [[EXT9]], i64 1
; CHECK-NEXT:    [[EXT_2:%.*]] = extractelement <4 x i64> [[EXT9]], i64 2
; CHECK-NEXT:    [[EXT_3:%.*]] = extractelement <4 x i64> [[EXT9]], i64 3
; CHECK-NEXT:    call void @use.i64(i64 [[TMP9]])
; CHECK-NEXT:    call void @use.i64(i64 [[TMP7]])
; CHECK-NEXT:    call void @use.i64(i64 [[TMP5]])
; CHECK-NEXT:    call void @use.i64(i64 [[TMP2]])
; CHECK-NEXT:    ret void
;
entry:
  %ext9 = zext nneg <4 x i16> %src to <4 x i64>
  %ext.0 = extractelement <4 x i64> %ext9, i64 0
  %ext.1 = extractelement <4 x i64> %ext9, i64 1
  %ext.2 = extractelement <4 x i64> %ext9, i64 2
  %ext.3 = extractelement <4 x i64> %ext9, i64 3

  call void @use.i64(i64 %ext.0)
  call void @use.i64(i64 %ext.1)
  call void @use.i64(i64 %ext.2)
  call void @use.i64(i64 %ext.3)
  ret void
}

define void @zext_v2i32_all_lanes_used(<2 x i32> %src) {
; CHECK-LABEL: define void @zext_v2i32_all_lanes_used(
; CHECK-SAME: <2 x i32> [[SRC:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TMP0:%.*]] = freeze <2 x i32> [[SRC]]
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast <2 x i32> [[TMP0]] to i64
; CHECK-NEXT:    [[TMP2:%.*]] = lshr i64 [[TMP1]], 32
; CHECK-NEXT:    [[TMP5:%.*]] = and i64 [[TMP1]], 4294967295
; CHECK-NEXT:    [[EXT9:%.*]] = zext nneg <2 x i32> [[SRC]] to <2 x i64>
; CHECK-NEXT:    [[EXT_0:%.*]] = extractelement <2 x i64> [[EXT9]], i64 0
; CHECK-NEXT:    [[EXT_1:%.*]] = extractelement <2 x i64> [[EXT9]], i64 1
; CHECK-NEXT:    call void @use.i64(i64 [[TMP5]])
; CHECK-NEXT:    call void @use.i64(i64 [[TMP2]])
; CHECK-NEXT:    ret void
;
entry:
  %ext9 = zext nneg <2 x i32> %src to <2 x i64>
  %ext.0 = extractelement <2 x i64> %ext9, i64 0
  %ext.1 = extractelement <2 x i64> %ext9, i64 1

  call void @use.i64(i64 %ext.0)
  call void @use.i64(i64 %ext.1)
  ret void
}

define void @zext_nxv4i8_all_lanes_used(<vscale x 4 x i8> %src) {
; CHECK-LABEL: define void @zext_nxv4i8_all_lanes_used(
; CHECK-SAME: <vscale x 4 x i8> [[SRC:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[EXT9:%.*]] = zext nneg <vscale x 4 x i8> [[SRC]] to <vscale x 4 x i32>
; CHECK-NEXT:    [[EXT_0:%.*]] = extractelement <vscale x 4 x i32> [[EXT9]], i64 0
; CHECK-NEXT:    [[EXT_1:%.*]] = extractelement <vscale x 4 x i32> [[EXT9]], i64 1
; CHECK-NEXT:    [[EXT_2:%.*]] = extractelement <vscale x 4 x i32> [[EXT9]], i64 2
; CHECK-NEXT:    [[EXT_3:%.*]] = extractelement <vscale x 4 x i32> [[EXT9]], i64 3
; CHECK-NEXT:    call void @use.i32(i32 [[EXT_0]])
; CHECK-NEXT:    call void @use.i32(i32 [[EXT_1]])
; CHECK-NEXT:    call void @use.i32(i32 [[EXT_2]])
; CHECK-NEXT:    call void @use.i32(i32 [[EXT_3]])
; CHECK-NEXT:    ret void
;
entry:
  %ext9 = zext nneg <vscale x 4 x i8> %src to <vscale x 4 x i32>
  %ext.0 = extractelement <vscale x 4 x i32> %ext9, i64 0
  %ext.1 = extractelement <vscale x 4 x i32> %ext9, i64 1
  %ext.2 = extractelement <vscale x 4 x i32> %ext9, i64 2
  %ext.3 = extractelement <vscale x 4 x i32> %ext9, i64 3

  call void @use.i32(i32 %ext.0)
  call void @use.i32(i32 %ext.1)
  call void @use.i32(i32 %ext.2)
  call void @use.i32(i32 %ext.3)
  ret void
}
