; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx10.2-256 | FileCheck %s --check-prefix=X64
; RUN: llc < %s -mtriple=i386-unknown-unknown -mattr=+avx10.2-256 | FileCheck %s --check-prefix=X86

define i1 @hoeq(half %x, half %y) {
; X64-LABEL: hoeq:
; X64:       # %bb.0:
; X64-NEXT:    vucomxsh %xmm1, %xmm0
; X64-NEXT:    sete %al
; X64-NEXT:    retq
;
; X86-LABEL: hoeq:
; X86:       # %bb.0:
; X86-NEXT:    vmovsh {{.*#+}} xmm0 = mem[0],zero,zero,zero,zero,zero,zero,zero
; X86-NEXT:    vucomxsh {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    sete %al
; X86-NEXT:    retl
    %1 = fcmp oeq half %x, %y
    ret i1 %1
}

define i1 @hune(half %x, half %y) {
; X64-LABEL: hune:
; X64:       # %bb.0:
; X64-NEXT:    vucomxsh %xmm1, %xmm0
; X64-NEXT:    setne %al
; X64-NEXT:    retq
;
; X86-LABEL: hune:
; X86:       # %bb.0:
; X86-NEXT:    vmovsh {{.*#+}} xmm0 = mem[0],zero,zero,zero,zero,zero,zero,zero
; X86-NEXT:    vucomxsh {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    setne %al
; X86-NEXT:    retl
    %1 = fcmp une half %x, %y
    ret i1 %1
}

define i1 @hoeq_mem(ptr %xp, ptr %yp) {
; X64-LABEL: hoeq_mem:
; X64:       # %bb.0:
; X64-NEXT:    vmovsh {{.*#+}} xmm0 = mem[0],zero,zero,zero,zero,zero,zero,zero
; X64-NEXT:    vucomxsh (%rsi), %xmm0
; X64-NEXT:    sete %al
; X64-NEXT:    retq
;
; X86-LABEL: hoeq_mem:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    vmovsh {{.*#+}} xmm0 = mem[0],zero,zero,zero,zero,zero,zero,zero
; X86-NEXT:    vucomxsh (%eax), %xmm0
; X86-NEXT:    sete %al
; X86-NEXT:    retl
    %x = load half, ptr %xp
    %y = load half, ptr %yp
    %1 = fcmp oeq half %x, %y
    ret i1 %1
}

define i1 @hune_mem(ptr %xp, ptr %yp) {
; X64-LABEL: hune_mem:
; X64:       # %bb.0:
; X64-NEXT:    vmovsh {{.*#+}} xmm0 = mem[0],zero,zero,zero,zero,zero,zero,zero
; X64-NEXT:    vucomxsh (%rsi), %xmm0
; X64-NEXT:    setne %al
; X64-NEXT:    retq
;
; X86-LABEL: hune_mem:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    vmovsh {{.*#+}} xmm0 = mem[0],zero,zero,zero,zero,zero,zero,zero
; X86-NEXT:    vucomxsh (%eax), %xmm0
; X86-NEXT:    setne %al
; X86-NEXT:    retl
    %x = load half, ptr %xp
    %y = load half, ptr %yp
    %1 = fcmp une half %x, %y
    ret i1 %1
}

define i1 @foeq(float %x, float %y) {
; X64-LABEL: foeq:
; X64:       # %bb.0:
; X64-NEXT:    vucomxss %xmm1, %xmm0
; X64-NEXT:    sete %al
; X64-NEXT:    retq
;
; X86-LABEL: foeq:
; X86:       # %bb.0:
; X86-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-NEXT:    vucomxss {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    sete %al
; X86-NEXT:    retl
    %1 = fcmp oeq float %x, %y
    ret i1 %1
}

define i1 @fune(float %x, float %y) {
; X64-LABEL: fune:
; X64:       # %bb.0:
; X64-NEXT:    vucomxss %xmm1, %xmm0
; X64-NEXT:    setne %al
; X64-NEXT:    retq
;
; X86-LABEL: fune:
; X86:       # %bb.0:
; X86-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-NEXT:    vucomxss {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    setne %al
; X86-NEXT:    retl
    %1 = fcmp une float %x, %y
    ret i1 %1
}

define i1 @foeq_mem(ptr %xp, ptr %yp) {
; X64-LABEL: foeq_mem:
; X64:       # %bb.0:
; X64-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X64-NEXT:    vucomxss (%rsi), %xmm0
; X64-NEXT:    sete %al
; X64-NEXT:    retq
;
; X86-LABEL: foeq_mem:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-NEXT:    vucomxss (%eax), %xmm0
; X86-NEXT:    sete %al
; X86-NEXT:    retl
    %x = load float, ptr %xp
    %y = load float, ptr %yp
    %1 = fcmp oeq float %x, %y
    ret i1 %1
}

define i1 @fune_mem(ptr %xp, ptr %yp) {
; X64-LABEL: fune_mem:
; X64:       # %bb.0:
; X64-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X64-NEXT:    vucomxss (%rsi), %xmm0
; X64-NEXT:    setne %al
; X64-NEXT:    retq
;
; X86-LABEL: fune_mem:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-NEXT:    vucomxss (%eax), %xmm0
; X86-NEXT:    setne %al
; X86-NEXT:    retl
    %x = load float, ptr %xp
    %y = load float, ptr %yp
    %1 = fcmp une float %x, %y
    ret i1 %1
}

define i1 @doeq(double %x, double %y) {
; X64-LABEL: doeq:
; X64:       # %bb.0:
; X64-NEXT:    vucomxsd %xmm1, %xmm0
; X64-NEXT:    sete %al
; X64-NEXT:    retq
;
; X86-LABEL: doeq:
; X86:       # %bb.0:
; X86-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; X86-NEXT:    vucomxsd {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    sete %al
; X86-NEXT:    retl
    %1 = fcmp oeq double %x, %y
    ret i1 %1
}

define i1 @dune(double %x, double %y) {
; X64-LABEL: dune:
; X64:       # %bb.0:
; X64-NEXT:    vucomxsd %xmm1, %xmm0
; X64-NEXT:    setne %al
; X64-NEXT:    retq
;
; X86-LABEL: dune:
; X86:       # %bb.0:
; X86-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; X86-NEXT:    vucomxsd {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    setne %al
; X86-NEXT:    retl
    %1 = fcmp une double %x, %y
    ret i1 %1
}

define i1 @doeq_mem(ptr %xp, ptr %yp) {
; X64-LABEL: doeq_mem:
; X64:       # %bb.0:
; X64-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; X64-NEXT:    vucomxsd (%rsi), %xmm0
; X64-NEXT:    sete %al
; X64-NEXT:    retq
;
; X86-LABEL: doeq_mem:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; X86-NEXT:    vucomxsd (%eax), %xmm0
; X86-NEXT:    sete %al
; X86-NEXT:    retl
    %x = load double, ptr %xp
    %y = load double, ptr %yp
    %1 = fcmp oeq double %x, %y
    ret i1 %1
}

define i1 @dune_mem(ptr %xp, ptr %yp) {
; X64-LABEL: dune_mem:
; X64:       # %bb.0:
; X64-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; X64-NEXT:    vucomxsd (%rsi), %xmm0
; X64-NEXT:    setne %al
; X64-NEXT:    retq
;
; X86-LABEL: dune_mem:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; X86-NEXT:    vucomxsd (%eax), %xmm0
; X86-NEXT:    setne %al
; X86-NEXT:    retl
    %x = load double, ptr %xp
    %y = load double, ptr %yp
    %1 = fcmp une double %x, %y
    ret i1 %1
}

define i32 @PR118606(x86_fp80 %val1) #0 {
; X64-LABEL: PR118606:
; X64:       # %bb.0: # %entry
; X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; X64-NEXT:    fldz
; X64-NEXT:    fucomi %st(1), %st
; X64-NEXT:    fstp %st(1)
; X64-NEXT:    fld1
; X64-NEXT:    fcmovne %st(1), %st
; X64-NEXT:    fcmovu %st(1), %st
; X64-NEXT:    fucompi %st(1), %st
; X64-NEXT:    fstp %st(0)
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
;
; X86-LABEL: PR118606:
; X86:       # %bb.0: # %entry
; X86-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-NEXT:    fldz
; X86-NEXT:    fucomi %st(1), %st
; X86-NEXT:    fstp %st(1)
; X86-NEXT:    fld1
; X86-NEXT:    fcmovne %st(1), %st
; X86-NEXT:    fcmovu %st(1), %st
; X86-NEXT:    fucompi %st(1), %st
; X86-NEXT:    fstp %st(0)
; X86-NEXT:    xorl %eax, %eax
; X86-NEXT:    retl
entry:
  %cmp8 = fcmp oeq x86_fp80 %val1, 0xK00000000000000000000
  %0 = select i1 %cmp8, x86_fp80 0xK3FFF8000000000000000, x86_fp80 0xK00000000000000000000
  %cmp64 = fcmp ogt x86_fp80 %0, 0xK00000000000000000000
  br i1 %cmp64, label %if.then66, label %if.end70

if.then66:                                        ; preds = %entry
  ret i32 0

if.end70:                                         ; preds = %entry
  ret i32 0
}

define i1 @constrained_fcmp() {
; X64-LABEL: constrained_fcmp:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vxorpd %xmm0, %xmm0, %xmm0
; X64-NEXT:    vucomxsd %xmm0, %xmm0
; X64-NEXT:    setne %al
; X64-NEXT:    retq
;
; X86-LABEL: constrained_fcmp:
; X86:       # %bb.0: # %entry
; X86-NEXT:    vxorpd %xmm0, %xmm0, %xmm0
; X86-NEXT:    vucomxsd %xmm0, %xmm0
; X86-NEXT:    setne %al
; X86-NEXT:    retl
entry:
  %0 = tail call i1 @llvm.experimental.constrained.fcmps.f64(double 0.000000e+00, double 0.000000e+00, metadata !"une", metadata !"fpexcept.strict")
  ret i1 %0
}

declare i1 @llvm.experimental.constrained.fcmps.f64(double, double, metadata, metadata)
