; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; Test removal of AND operations that don't affect last 6 bits of rotate amount
; operand.
;
; RUN: llc < %s -mtriple=s390x-linux-gnu | FileCheck %s
; RUN: llc < %s -mtriple=s390x-linux-gnu -early-live-intervals | FileCheck %s

; Test that AND is not removed when some lower 5 bits are not set.
define i32 @f1(i32 %val, i32 %amt) {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    nill %r3, 15
; CHECK-NEXT:    rll %r2, %r2, 0(%r3)
; CHECK-NEXT:    br %r14
  %and = and i32 %amt, 15

  %inv = sub i32 32, %and
  %parta = shl i32 %val, %and
  %partb = lshr i32 %val, %inv

  %rotl = or i32 %parta, %partb

  ret i32 %rotl
}

; Test removal of AND mask with only bottom 6 bits set.
define i32 @f2(i32 %val, i32 %amt) {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    rll %r2, %r2, 0(%r3)
; CHECK-NEXT:    br %r14
  %and = and i32 %amt, 63

  %inv = sub i32 32, %and
  %parta = shl i32 %val, %and
  %partb = lshr i32 %val, %inv

  %rotl = or i32 %parta, %partb

  ret i32 %rotl
}

; Test removal of AND mask including but not limited to bottom 6 bits.
define i32 @f3(i32 %val, i32 %amt) {
; CHECK-LABEL: f3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    rll %r2, %r2, 0(%r3)
; CHECK-NEXT:    br %r14
  %and = and i32 %amt, 255

  %inv = sub i32 32, %and
  %parta = shl i32 %val, %and
  %partb = lshr i32 %val, %inv

  %rotl = or i32 %parta, %partb

  ret i32 %rotl
}

; Test removal of AND mask from RLLG.
define i64 @f4(i64 %val, i64 %amt) {
; CHECK-LABEL: f4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    rllg %r2, %r2, 0(%r3)
; CHECK-NEXT:    br %r14
  %and = and i64 %amt, 63

  %inv = sub i64 64, %and
  %parta = shl i64 %val, %and
  %partb = lshr i64 %val, %inv

  %rotl = or i64 %parta, %partb

  ret i64 %rotl
}

; Test that AND is not entirely removed if the result is reused.
define i32 @f5(i32 %val, i32 %amt) {
; CHECK-LABEL: f5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    rll %r2, %r2, 0(%r3)
; CHECK-NEXT:    nilf %r3, 63
; CHECK-NEXT:    ar %r2, %r3
; CHECK-NEXT:    br %r14
  %and = and i32 %amt, 63

  %inv = sub i32 32, %and
  %parta = shl i32 %val, %and
  %partb = lshr i32 %val, %inv

  %rotl = or i32 %parta, %partb

  %reuse = add i32 %and, %rotl
  ret i32 %reuse
}
