; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -O3 -S -mtriple=x86_64-- -mcpu=x86-64    | FileCheck %s --check-prefixes=CHECK,SSE,SSE2
; RUN: opt < %s -O3 -S -mtriple=x86_64-- -mcpu=x86-64-v2 | FileCheck %s --check-prefixes=CHECK,SSE,SSE4
; RUN: opt < %s -O3 -S -mtriple=x86_64-- -mcpu=bdver2    | FileCheck %s --check-prefixes=CHECK,AVX,AVX_FMA,AVX_FMA4
; RUN: opt < %s -O3 -S -mtriple=x86_64-- -mcpu=x86-64-v3 | FileCheck %s --check-prefixes=CHECK,AVX,AVX_FMA,AVX_FMA3
; RUN: opt < %s -O3 -S -mtriple=x86_64-- -mcpu=x86-64-v4 | FileCheck %s --check-prefixes=CHECK,AVX,AVX512
; RUN: opt < %s -passes="default<O3>" -S -mtriple=x86_64-- -mcpu=x86-64    | FileCheck %s --check-prefixes=CHECK,SSE,SSE2
; RUN: opt < %s -passes="default<O3>" -S -mtriple=x86_64-- -mcpu=x86-64-v2 | FileCheck %s --check-prefixes=CHECK,SSE,SSE4
; RUN: opt < %s -passes="default<O3>" -S -mtriple=x86_64-- -mcpu=bdver2    | FileCheck %s --check-prefixes=CHECK,AVX,AVX_FMA,AVX_FMA4
; RUN: opt < %s -passes="default<O3>" -S -mtriple=x86_64-- -mcpu=x86-64-v3 | FileCheck %s --check-prefixes=CHECK,AVX,AVX_FMA,AVX_FMA3
; RUN: opt < %s -passes="default<O3>" -S -mtriple=x86_64-- -mcpu=x86-64-v4 | FileCheck %s --check-prefixes=CHECK,AVX,AVX512

; This test checks the vectorisation of FMUL+ADDSUB/FMADDSUB patterns, including cases with undef elements.

; Ideally, this should reach the backend with 1 fmul, 1 fsub, 1 fadd, and 1 shuffle.
; That may require some coordination between VectorCombine, SLP, and other passes.

define <4 x float> @buildvector_mul_addsub_ps128(<4 x float> %C, <4 x float> %D, <4 x float> %B) #0 {
; CHECK-LABEL: @buildvector_mul_addsub_ps128(
; CHECK-NEXT:    [[A:%.*]] = fmul <4 x float> [[C:%.*]], [[D:%.*]]
; CHECK-NEXT:    [[TMP0:%.*]] = fsub <4 x float> [[A]], [[B:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = fadd <4 x float> [[A]], [[B]]
; CHECK-NEXT:    [[TMP2:%.*]] = shufflevector <4 x float> [[TMP0]], <4 x float> [[TMP1]], <4 x i32> <i32 0, i32 5, i32 2, i32 7>
; CHECK-NEXT:    ret <4 x float> [[TMP2]]
;
  %A = fmul <4 x float> %C, %D
  %A0 = extractelement <4 x float> %A, i32 0
  %B0 = extractelement <4 x float> %B, i32 0
  %sub0 = fsub float %A0, %B0
  %A2 = extractelement <4 x float> %A, i32 2
  %B2 = extractelement <4 x float> %B, i32 2
  %sub2 = fsub float %A2, %B2
  %A1 = extractelement <4 x float> %A, i32 1
  %B1 = extractelement <4 x float> %B, i32 1
  %add1 = fadd float %A1, %B1
  %A3 = extractelement <4 x float> %A, i32 3
  %B3 = extractelement <4 x float> %B, i32 3
  %add3 = fadd float %A3, %B3
  %vecinsert1 = insertelement <4 x float> undef, float %sub0, i32 0
  %vecinsert2 = insertelement <4 x float> %vecinsert1, float %add1, i32 1
  %vecinsert3 = insertelement <4 x float> %vecinsert2, float %sub2, i32 2
  %vecinsert4 = insertelement <4 x float> %vecinsert3, float %add3, i32 3
  ret <4 x float> %vecinsert4
}

define <2 x double> @buildvector_mul_addsub_pd128(<2 x double> %C, <2 x double> %D, <2 x double> %B) #0 {
; CHECK-LABEL: @buildvector_mul_addsub_pd128(
; CHECK-NEXT:    [[A:%.*]] = fmul <2 x double> [[C:%.*]], [[D:%.*]]
; CHECK-NEXT:    [[TMP0:%.*]] = fsub <2 x double> [[A]], [[B:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = fadd <2 x double> [[A]], [[B]]
; CHECK-NEXT:    [[TMP2:%.*]] = shufflevector <2 x double> [[TMP0]], <2 x double> [[TMP1]], <2 x i32> <i32 0, i32 3>
; CHECK-NEXT:    ret <2 x double> [[TMP2]]
;
  %A = fmul <2 x double> %C, %D
  %A0 = extractelement <2 x double> %A, i32 0
  %B0 = extractelement <2 x double> %B, i32 0
  %sub0 = fsub double %A0, %B0
  %A1 = extractelement <2 x double> %A, i32 1
  %B1 = extractelement <2 x double> %B, i32 1
  %add1 = fadd double %A1, %B1
  %vecinsert1 = insertelement <2 x double> undef, double %sub0, i32 0
  %vecinsert2 = insertelement <2 x double> %vecinsert1, double %add1, i32 1
  ret <2 x double> %vecinsert2
}

define <8 x float> @buildvector_mul_addsub_ps256(<8 x float> %C, <8 x float> %D, <8 x float> %B) #0 {
; SSE2-LABEL: @buildvector_mul_addsub_ps256(
; SSE2-NEXT:    [[A:%.*]] = fmul <8 x float> [[C:%.*]], [[D:%.*]]
; SSE2-NEXT:    [[TMP0:%.*]] = fsub <8 x float> [[A]], [[B:%.*]]
; SSE2-NEXT:    [[TMP1:%.*]] = shufflevector <8 x float> [[TMP0]], <8 x float> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
; SSE2-NEXT:    [[TMP2:%.*]] = fadd <8 x float> [[A]], [[B]]
; SSE2-NEXT:    [[TMP3:%.*]] = shufflevector <8 x float> [[TMP2]], <8 x float> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
; SSE2-NEXT:    [[TMP4:%.*]] = shufflevector <4 x float> [[TMP1]], <4 x float> [[TMP3]], <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
; SSE2-NEXT:    ret <8 x float> [[TMP4]]
;
; SSE4-LABEL: @buildvector_mul_addsub_ps256(
; SSE4-NEXT:    [[A:%.*]] = fmul <8 x float> [[C:%.*]], [[D:%.*]]
; SSE4-NEXT:    [[TMP0:%.*]] = fsub <8 x float> [[A]], [[B:%.*]]
; SSE4-NEXT:    [[TMP1:%.*]] = fadd <8 x float> [[A]], [[B]]
; SSE4-NEXT:    [[TMP2:%.*]] = shufflevector <8 x float> [[TMP0]], <8 x float> [[TMP1]], <8 x i32> <i32 0, i32 9, i32 2, i32 11, i32 4, i32 13, i32 6, i32 15>
; SSE4-NEXT:    ret <8 x float> [[TMP2]]
;
; AVX-LABEL: @buildvector_mul_addsub_ps256(
; AVX-NEXT:    [[A:%.*]] = fmul <8 x float> [[C:%.*]], [[D:%.*]]
; AVX-NEXT:    [[TMP0:%.*]] = fsub <8 x float> [[A]], [[B:%.*]]
; AVX-NEXT:    [[TMP1:%.*]] = fadd <8 x float> [[A]], [[B]]
; AVX-NEXT:    [[TMP2:%.*]] = shufflevector <8 x float> [[TMP0]], <8 x float> [[TMP1]], <8 x i32> <i32 0, i32 9, i32 2, i32 11, i32 4, i32 13, i32 6, i32 15>
; AVX-NEXT:    ret <8 x float> [[TMP2]]
;
  %A = fmul <8 x float> %C, %D
  %A0 = extractelement <8 x float> %A, i32 0
  %B0 = extractelement <8 x float> %B, i32 0
  %sub0 = fsub float %A0, %B0
  %A2 = extractelement <8 x float> %A, i32 2
  %B2 = extractelement <8 x float> %B, i32 2
  %sub2 = fsub float %A2, %B2
  %A4 = extractelement <8 x float> %A, i32 4
  %B4 = extractelement <8 x float> %B, i32 4
  %sub4 = fsub float %A4, %B4
  %A6 = extractelement <8 x float> %A, i32 6
  %B6 = extractelement <8 x float> %B, i32 6
  %sub6 = fsub float %A6, %B6
  %A1 = extractelement <8 x float> %A, i32 1
  %B1 = extractelement <8 x float> %B, i32 1
  %add1 = fadd float %A1, %B1
  %A3 = extractelement <8 x float> %A, i32 3
  %B3 = extractelement <8 x float> %B, i32 3
  %add3 = fadd float %A3, %B3
  %A5 = extractelement <8 x float> %A, i32 5
  %B5 = extractelement <8 x float> %B, i32 5
  %add5 = fadd float %A5, %B5
  %A7 = extractelement <8 x float> %A, i32 7
  %B7 = extractelement <8 x float> %B, i32 7
  %add7 = fadd float %A7, %B7
  %vecinsert1 = insertelement <8 x float> undef, float %sub0, i32 0
  %vecinsert2 = insertelement <8 x float> %vecinsert1, float %add1, i32 1
  %vecinsert3 = insertelement <8 x float> %vecinsert2, float %sub2, i32 2
  %vecinsert4 = insertelement <8 x float> %vecinsert3, float %add3, i32 3
  %vecinsert5 = insertelement <8 x float> %vecinsert4, float %sub4, i32 4
  %vecinsert6 = insertelement <8 x float> %vecinsert5, float %add5, i32 5
  %vecinsert7 = insertelement <8 x float> %vecinsert6, float %sub6, i32 6
  %vecinsert8 = insertelement <8 x float> %vecinsert7, float %add7, i32 7
  ret <8 x float> %vecinsert8
}

define <4 x double> @buildvector_mul_addsub_pd256(<4 x double> %C, <4 x double> %D, <4 x double> %B) #0 {
; CHECK-LABEL: @buildvector_mul_addsub_pd256(
; CHECK-NEXT:    [[A:%.*]] = fmul <4 x double> [[C:%.*]], [[D:%.*]]
; CHECK-NEXT:    [[TMP0:%.*]] = fsub <4 x double> [[A]], [[B:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = fadd <4 x double> [[A]], [[B]]
; CHECK-NEXT:    [[TMP2:%.*]] = shufflevector <4 x double> [[TMP0]], <4 x double> [[TMP1]], <4 x i32> <i32 0, i32 5, i32 2, i32 7>
; CHECK-NEXT:    ret <4 x double> [[TMP2]]
;
  %A = fmul <4 x double> %C, %D
  %A0 = extractelement <4 x double> %A, i32 0
  %B0 = extractelement <4 x double> %B, i32 0
  %sub0 = fsub double %A0, %B0
  %A2 = extractelement <4 x double> %A, i32 2
  %B2 = extractelement <4 x double> %B, i32 2
  %sub2 = fsub double %A2, %B2
  %A1 = extractelement <4 x double> %A, i32 1
  %B1 = extractelement <4 x double> %B, i32 1
  %add1 = fadd double %A1, %B1
  %A3 = extractelement <4 x double> %A, i32 3
  %B3 = extractelement <4 x double> %B, i32 3
  %add3 = fadd double %A3, %B3
  %vecinsert1 = insertelement <4 x double> undef, double %sub0, i32 0
  %vecinsert2 = insertelement <4 x double> %vecinsert1, double %add1, i32 1
  %vecinsert3 = insertelement <4 x double> %vecinsert2, double %sub2, i32 2
  %vecinsert4 = insertelement <4 x double> %vecinsert3, double %add3, i32 3
  ret <4 x double> %vecinsert4
}

define <16 x float> @buildvector_mul_addsub_ps512(<16 x float> %C, <16 x float> %D, <16 x float> %B) #0 {
; SSE2-LABEL: @buildvector_mul_addsub_ps512(
; SSE2-NEXT:    [[A:%.*]] = fmul <16 x float> [[C:%.*]], [[D:%.*]]
; SSE2-NEXT:    [[TMP1:%.*]] = fsub <16 x float> [[A]], [[B:%.*]]
; SSE2-NEXT:    [[TMP2:%.*]] = shufflevector <16 x float> [[TMP1]], <16 x float> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
; SSE2-NEXT:    [[TMP3:%.*]] = fadd <16 x float> [[A]], [[B]]
; SSE2-NEXT:    [[TMP4:%.*]] = shufflevector <16 x float> [[TMP3]], <16 x float> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; SSE2-NEXT:    [[TMP5:%.*]] = shufflevector <8 x float> [[TMP2]], <8 x float> [[TMP4]], <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; SSE2-NEXT:    ret <16 x float> [[TMP5]]
;
; SSE4-LABEL: @buildvector_mul_addsub_ps512(
; SSE4-NEXT:    [[A:%.*]] = fmul <16 x float> [[C:%.*]], [[D:%.*]]
; SSE4-NEXT:    [[TMP1:%.*]] = fsub <16 x float> [[A]], [[B:%.*]]
; SSE4-NEXT:    [[TMP2:%.*]] = fadd <16 x float> [[A]], [[B]]
; SSE4-NEXT:    [[TMP3:%.*]] = shufflevector <16 x float> [[TMP1]], <16 x float> [[TMP2]], <16 x i32> <i32 0, i32 17, i32 2, i32 19, i32 4, i32 21, i32 6, i32 23, i32 8, i32 25, i32 10, i32 27, i32 12, i32 29, i32 14, i32 31>
; SSE4-NEXT:    ret <16 x float> [[TMP3]]
;
; AVX-LABEL: @buildvector_mul_addsub_ps512(
; AVX-NEXT:    [[A:%.*]] = fmul <16 x float> [[C:%.*]], [[D:%.*]]
; AVX-NEXT:    [[TMP1:%.*]] = fsub <16 x float> [[A]], [[B:%.*]]
; AVX-NEXT:    [[TMP2:%.*]] = fadd <16 x float> [[A]], [[B]]
; AVX-NEXT:    [[VECINSERT162:%.*]] = shufflevector <16 x float> [[TMP1]], <16 x float> [[TMP2]], <16 x i32> <i32 0, i32 17, i32 2, i32 19, i32 4, i32 21, i32 6, i32 23, i32 8, i32 25, i32 10, i32 27, i32 12, i32 29, i32 14, i32 31>
; AVX-NEXT:    ret <16 x float> [[VECINSERT162]]
;
  %A = fmul <16 x float> %C, %D
  %A0 = extractelement <16 x float> %A, i32 0
  %B0 = extractelement <16 x float> %B, i32 0
  %sub0 = fsub float %A0, %B0
  %A2 = extractelement <16 x float> %A, i32 2
  %B2 = extractelement <16 x float> %B, i32 2
  %sub2 = fsub float %A2, %B2
  %A4 = extractelement <16 x float> %A, i32 4
  %B4 = extractelement <16 x float> %B, i32 4
  %sub4 = fsub float %A4, %B4
  %A6 = extractelement <16 x float> %A, i32 6
  %B6 = extractelement <16 x float> %B, i32 6
  %sub6 = fsub float %A6, %B6
  %A8 = extractelement <16 x float> %A, i32 8
  %B8 = extractelement <16 x float> %B, i32 8
  %sub8 = fsub float %A8, %B8
  %A10 = extractelement <16 x float> %A, i32 10
  %B10 = extractelement <16 x float> %B, i32 10
  %sub10 = fsub float %A10, %B10
  %A12 = extractelement <16 x float> %A, i32 12
  %B12 = extractelement <16 x float> %B, i32 12
  %sub12 = fsub float %A12, %B12
  %A14 = extractelement <16 x float> %A, i32 14
  %B14 = extractelement <16 x float> %B, i32 14
  %sub14 = fsub float %A14, %B14
  %A1 = extractelement <16 x float> %A, i32 1
  %B1 = extractelement <16 x float> %B, i32 1
  %add1 = fadd float %A1, %B1
  %A3 = extractelement <16 x float> %A, i32 3
  %B3 = extractelement <16 x float> %B, i32 3
  %add3 = fadd float %A3, %B3
  %A5 = extractelement <16 x float> %A, i32 5
  %B5 = extractelement <16 x float> %B, i32 5
  %add5 = fadd float %A5, %B5
  %A7 = extractelement <16 x float> %A, i32 7
  %B7 = extractelement <16 x float> %B, i32 7
  %add7 = fadd float %A7, %B7
  %A9 = extractelement <16 x float> %A, i32 9
  %B9 = extractelement <16 x float> %B, i32 9
  %add9 = fadd float %A9, %B9
  %A11 = extractelement <16 x float> %A, i32 11
  %B11 = extractelement <16 x float> %B, i32 11
  %add11 = fadd float %A11, %B11
  %A13 = extractelement <16 x float> %A, i32 13
  %B13 = extractelement <16 x float> %B, i32 13
  %add13 = fadd float %A13, %B13
  %A15 = extractelement <16 x float> %A, i32 15
  %B15 = extractelement <16 x float> %B, i32 15
  %add15 = fadd float %A15, %B15
  %vecinsert1 = insertelement <16 x float> undef, float %sub0, i32 0
  %vecinsert2 = insertelement <16 x float> %vecinsert1, float %add1, i32 1
  %vecinsert3 = insertelement <16 x float> %vecinsert2, float %sub2, i32 2
  %vecinsert4 = insertelement <16 x float> %vecinsert3, float %add3, i32 3
  %vecinsert5 = insertelement <16 x float> %vecinsert4, float %sub4, i32 4
  %vecinsert6 = insertelement <16 x float> %vecinsert5, float %add5, i32 5
  %vecinsert7 = insertelement <16 x float> %vecinsert6, float %sub6, i32 6
  %vecinsert8 = insertelement <16 x float> %vecinsert7, float %add7, i32 7
  %vecinsert9 = insertelement <16 x float> %vecinsert8, float %sub8, i32 8
  %vecinsert10 = insertelement <16 x float> %vecinsert9, float %add9, i32 9
  %vecinsert11 = insertelement <16 x float> %vecinsert10, float %sub10, i32 10
  %vecinsert12 = insertelement <16 x float> %vecinsert11, float %add11, i32 11
  %vecinsert13 = insertelement <16 x float> %vecinsert12, float %sub12, i32 12
  %vecinsert14 = insertelement <16 x float> %vecinsert13, float %add13, i32 13
  %vecinsert15 = insertelement <16 x float> %vecinsert14, float %sub14, i32 14
  %vecinsert16 = insertelement <16 x float> %vecinsert15, float %add15, i32 15
  ret <16 x float> %vecinsert16
}

define <16 x float> @buildvector_mul_addsub_ps512_partial(<16 x float> %C, <16 x float> %D, <16 x float> %B) #0 {
; SSE-LABEL: @buildvector_mul_addsub_ps512_partial(
; SSE-NEXT:    [[A:%.*]] = fmul <16 x float> [[C:%.*]], [[D:%.*]]
; SSE-NEXT:    [[TMP1:%.*]] = shufflevector <16 x float> [[A]], <16 x float> poison, <12 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 13>
; SSE-NEXT:    [[TMP2:%.*]] = shufflevector <16 x float> [[B:%.*]], <16 x float> poison, <12 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 13>
; SSE-NEXT:    [[TMP3:%.*]] = fsub <12 x float> [[TMP1]], [[TMP2]]
; SSE-NEXT:    [[TMP4:%.*]] = fadd <12 x float> [[TMP1]], [[TMP2]]
; SSE-NEXT:    [[TMP5:%.*]] = shufflevector <12 x float> [[TMP3]], <12 x float> [[TMP4]], <12 x i32> <i32 0, i32 13, i32 2, i32 15, i32 4, i32 5, i32 18, i32 7, i32 20, i32 9, i32 22, i32 23>
; SSE-NEXT:    [[TMP6:%.*]] = shufflevector <16 x float> [[A]], <16 x float> poison, <2 x i32> <i32 14, i32 15>
; SSE-NEXT:    [[TMP7:%.*]] = shufflevector <16 x float> [[B]], <16 x float> poison, <2 x i32> <i32 14, i32 15>
; SSE-NEXT:    [[TMP8:%.*]] = fsub <2 x float> [[TMP6]], [[TMP7]]
; SSE-NEXT:    [[TMP9:%.*]] = fadd <2 x float> [[TMP6]], [[TMP7]]
; SSE-NEXT:    [[TMP10:%.*]] = shufflevector <12 x float> [[TMP5]], <12 x float> <float undef, float undef, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison>, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 12, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 13, i32 11, i32 poison, i32 poison>
; SSE-NEXT:    [[TMP11:%.*]] = shufflevector <2 x float> [[TMP8]], <2 x float> [[TMP9]], <16 x i32> <i32 0, i32 3, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
; SSE-NEXT:    [[VECINSERT161:%.*]] = shufflevector <16 x float> [[TMP10]], <16 x float> [[TMP11]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 16, i32 17>
; SSE-NEXT:    ret <16 x float> [[VECINSERT161]]
;
; AVX-LABEL: @buildvector_mul_addsub_ps512_partial(
; AVX-NEXT:    [[A:%.*]] = fmul <16 x float> [[C:%.*]], [[D:%.*]]
; AVX-NEXT:    [[TMP1:%.*]] = shufflevector <16 x float> [[A]], <16 x float> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 6, i32 7, i32 8>
; AVX-NEXT:    [[TMP2:%.*]] = shufflevector <16 x float> [[B:%.*]], <16 x float> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 6, i32 7, i32 8>
; AVX-NEXT:    [[TMP3:%.*]] = fsub <8 x float> [[TMP1]], [[TMP2]]
; AVX-NEXT:    [[TMP4:%.*]] = fadd <8 x float> [[TMP1]], [[TMP2]]
; AVX-NEXT:    [[TMP5:%.*]] = shufflevector <8 x float> [[TMP3]], <8 x float> [[TMP4]], <8 x i32> <i32 0, i32 9, i32 2, i32 11, i32 4, i32 5, i32 14, i32 7>
; AVX-NEXT:    [[TMP6:%.*]] = shufflevector <16 x float> [[A]], <16 x float> poison, <4 x i32> <i32 9, i32 10, i32 11, i32 13>
; AVX-NEXT:    [[TMP7:%.*]] = shufflevector <16 x float> [[B]], <16 x float> poison, <4 x i32> <i32 9, i32 10, i32 11, i32 13>
; AVX-NEXT:    [[TMP8:%.*]] = fadd <4 x float> [[TMP6]], [[TMP7]]
; AVX-NEXT:    [[TMP9:%.*]] = fsub <4 x float> [[TMP6]], [[TMP7]]
; AVX-NEXT:    [[TMP10:%.*]] = shufflevector <16 x float> [[A]], <16 x float> poison, <2 x i32> <i32 14, i32 15>
; AVX-NEXT:    [[TMP11:%.*]] = shufflevector <16 x float> [[B]], <16 x float> poison, <2 x i32> <i32 14, i32 15>
; AVX-NEXT:    [[TMP12:%.*]] = fsub <2 x float> [[TMP10]], [[TMP11]]
; AVX-NEXT:    [[TMP13:%.*]] = fadd <2 x float> [[TMP10]], [[TMP11]]
; AVX-NEXT:    [[TMP14:%.*]] = shufflevector <8 x float> [[TMP5]], <8 x float> <float undef, float undef, float poison, float poison, float poison, float poison, float poison, float poison>, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 8, i32 5, i32 6, i32 7, i32 poison, i32 poison, i32 poison, i32 9, i32 poison, i32 poison, i32 poison>
; AVX-NEXT:    [[TMP15:%.*]] = shufflevector <4 x float> [[TMP8]], <4 x float> [[TMP9]], <16 x i32> <i32 0, i32 5, i32 2, i32 poison, i32 3, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
; AVX-NEXT:    [[VECINSERT141:%.*]] = shufflevector <16 x float> [[TMP14]], <16 x float> [[TMP15]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 16, i32 17, i32 18, i32 12, i32 20, i32 poison, i32 poison>
; AVX-NEXT:    [[TMP16:%.*]] = shufflevector <2 x float> [[TMP12]], <2 x float> [[TMP13]], <16 x i32> <i32 0, i32 3, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
; AVX-NEXT:    [[VECINSERT162:%.*]] = shufflevector <16 x float> [[VECINSERT141]], <16 x float> [[TMP16]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 16, i32 17>
; AVX-NEXT:    ret <16 x float> [[VECINSERT162]]
;
  %A = fmul <16 x float> %C, %D
  %A0 = extractelement <16 x float> %A, i32 0
  %B0 = extractelement <16 x float> %B, i32 0
  %sub0 = fsub float %A0, %B0
  %A2 = extractelement <16 x float> %A, i32 2
  %B2 = extractelement <16 x float> %B, i32 2
  %sub2 = fsub float %A2, %B2
  %A4 = extractelement <16 x float> %A, i32 4
  %B4 = extractelement <16 x float> %B, i32 4
  %sub4 = fsub float %A4, %B4
  %A6 = extractelement <16 x float> %A, i32 6
  %B6 = extractelement <16 x float> %B, i32 6
  %sub6 = fsub float %A6, %B6
  %A8 = extractelement <16 x float> %A, i32 8
  %B8 = extractelement <16 x float> %B, i32 8
  %sub8 = fsub float %A8, %B8
  %A10 = extractelement <16 x float> %A, i32 10
  %B10 = extractelement <16 x float> %B, i32 10
  %sub10 = fsub float %A10, %B10
  %A12 = extractelement <16 x float> %A, i32 12
  %B12 = extractelement <16 x float> %B, i32 12
  %sub12 = fsub float %A12, %B12
  %A14 = extractelement <16 x float> %A, i32 14
  %B14 = extractelement <16 x float> %B, i32 14
  %sub14 = fsub float %A14, %B14
  %A1 = extractelement <16 x float> %A, i32 1
  %B1 = extractelement <16 x float> %B, i32 1
  %add1 = fadd float %A1, %B1
  %A3 = extractelement <16 x float> %A, i32 3
  %B3 = extractelement <16 x float> %B, i32 3
  %add3 = fadd float %A3, %B3
  %A5 = extractelement <16 x float> %A, i32 5
  %B5 = extractelement <16 x float> %B, i32 5
  %add5 = fadd float %A5, %B5
  %A7 = extractelement <16 x float> %A, i32 7
  %B7 = extractelement <16 x float> %B, i32 7
  %add7 = fadd float %A7, %B7
  %A9 = extractelement <16 x float> %A, i32 9
  %B9 = extractelement <16 x float> %B, i32 9
  %add9 = fadd float %A9, %B9
  %A11 = extractelement <16 x float> %A, i32 11
  %B11 = extractelement <16 x float> %B, i32 11
  %add11 = fadd float %A11, %B11
  %A13 = extractelement <16 x float> %A, i32 13
  %B13 = extractelement <16 x float> %B, i32 13
  %add13 = fadd float %A13, %B13
  %A15 = extractelement <16 x float> %A, i32 15
  %B15 = extractelement <16 x float> %B, i32 15
  %add15 = fadd float %A15, %B15
  %vecinsert1 = insertelement <16 x float> undef, float %sub0, i32 0
  %vecinsert2 = insertelement <16 x float> %vecinsert1, float %add1, i32 1
  %vecinsert3 = insertelement <16 x float> %vecinsert2, float %sub2, i32 2
  %vecinsert4 = insertelement <16 x float> %vecinsert3, float %add3, i32 3
  %vecinsert5 = insertelement <16 x float> %vecinsert4, float %sub4, i32 4
  ; element 5 is undef
  %vecinsert7 = insertelement <16 x float> %vecinsert5, float %sub6, i32 6
  %vecinsert8 = insertelement <16 x float> %vecinsert7, float %add7, i32 7
  %vecinsert9 = insertelement <16 x float> %vecinsert8, float %sub8, i32 8
  %vecinsert10 = insertelement <16 x float> %vecinsert9, float %add9, i32 9
  %vecinsert11 = insertelement <16 x float> %vecinsert10, float %sub10, i32 10
  %vecinsert12 = insertelement <16 x float> %vecinsert11, float %add11, i32 11
  ; element 12 is undef
  %vecinsert14 = insertelement <16 x float> %vecinsert12, float %add13, i32 13
  %vecinsert15 = insertelement <16 x float> %vecinsert14, float %sub14, i32 14
  %vecinsert16 = insertelement <16 x float> %vecinsert15, float %add15, i32 15
  ret <16 x float> %vecinsert16
}

define <8 x double> @buildvector_mul_addsub_pd512(<8 x double> %C, <8 x double> %D, <8 x double> %B) #0 {
; SSE2-LABEL: @buildvector_mul_addsub_pd512(
; SSE2-NEXT:    [[A:%.*]] = fmul <8 x double> [[C:%.*]], [[D:%.*]]
; SSE2-NEXT:    [[TMP1:%.*]] = fsub <8 x double> [[A]], [[B:%.*]]
; SSE2-NEXT:    [[TMP2:%.*]] = shufflevector <8 x double> [[TMP1]], <8 x double> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
; SSE2-NEXT:    [[TMP3:%.*]] = fadd <8 x double> [[A]], [[B]]
; SSE2-NEXT:    [[TMP4:%.*]] = shufflevector <8 x double> [[TMP3]], <8 x double> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
; SSE2-NEXT:    [[TMP5:%.*]] = shufflevector <4 x double> [[TMP2]], <4 x double> [[TMP4]], <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
; SSE2-NEXT:    ret <8 x double> [[TMP5]]
;
; SSE4-LABEL: @buildvector_mul_addsub_pd512(
; SSE4-NEXT:    [[A:%.*]] = fmul <8 x double> [[C:%.*]], [[D:%.*]]
; SSE4-NEXT:    [[TMP1:%.*]] = fsub <8 x double> [[A]], [[B:%.*]]
; SSE4-NEXT:    [[TMP2:%.*]] = fadd <8 x double> [[A]], [[B]]
; SSE4-NEXT:    [[TMP3:%.*]] = shufflevector <8 x double> [[TMP1]], <8 x double> [[TMP2]], <8 x i32> <i32 0, i32 9, i32 2, i32 11, i32 4, i32 13, i32 6, i32 15>
; SSE4-NEXT:    ret <8 x double> [[TMP3]]
;
; AVX-LABEL: @buildvector_mul_addsub_pd512(
; AVX-NEXT:    [[A:%.*]] = fmul <8 x double> [[C:%.*]], [[D:%.*]]
; AVX-NEXT:    [[TMP1:%.*]] = fsub <8 x double> [[A]], [[B:%.*]]
; AVX-NEXT:    [[TMP2:%.*]] = fadd <8 x double> [[A]], [[B]]
; AVX-NEXT:    [[TMP3:%.*]] = shufflevector <8 x double> [[TMP1]], <8 x double> [[TMP2]], <8 x i32> <i32 0, i32 9, i32 2, i32 11, i32 4, i32 13, i32 6, i32 15>
; AVX-NEXT:    ret <8 x double> [[TMP3]]
;
  %A = fmul <8 x double> %C, %D
  %A0 = extractelement <8 x double> %A, i32 0
  %B0 = extractelement <8 x double> %B, i32 0
  %sub0 = fsub double %A0, %B0
  %A2 = extractelement <8 x double> %A, i32 2
  %B2 = extractelement <8 x double> %B, i32 2
  %sub2 = fsub double %A2, %B2
  %A4 = extractelement <8 x double> %A, i32 4
  %B4 = extractelement <8 x double> %B, i32 4
  %sub4 = fsub double %A4, %B4
  %A6 = extractelement <8 x double> %A, i32 6
  %B6 = extractelement <8 x double> %B, i32 6
  %sub6 = fsub double %A6, %B6
  %A1 = extractelement <8 x double> %A, i32 1
  %B1 = extractelement <8 x double> %B, i32 1
  %add1 = fadd double %A1, %B1
  %A3 = extractelement <8 x double> %A, i32 3
  %B3 = extractelement <8 x double> %B, i32 3
  %add3 = fadd double %A3, %B3
  %A5 = extractelement <8 x double> %A, i32 5
  %B5 = extractelement <8 x double> %B, i32 5
  %add5 = fadd double %A5, %B5
  %A7 = extractelement <8 x double> %A, i32 7
  %B7 = extractelement <8 x double> %B, i32 7
  %add7 = fadd double %A7, %B7
  %vecinsert1 = insertelement <8 x double> undef, double %sub0, i32 0
  %vecinsert2 = insertelement <8 x double> %vecinsert1, double %add1, i32 1
  %vecinsert3 = insertelement <8 x double> %vecinsert2, double %sub2, i32 2
  %vecinsert4 = insertelement <8 x double> %vecinsert3, double %add3, i32 3
  %vecinsert5 = insertelement <8 x double> %vecinsert4, double %sub4, i32 4
  %vecinsert6 = insertelement <8 x double> %vecinsert5, double %add5, i32 5
  %vecinsert7 = insertelement <8 x double> %vecinsert6, double %sub6, i32 6
  %vecinsert8 = insertelement <8 x double> %vecinsert7, double %add7, i32 7
  ret <8 x double> %vecinsert8
}

define <8 x double> @buildvector_mul_addsub_pd512_partial(<8 x double> %C, <8 x double> %D, <8 x double> %B) #0 {
; SSE-LABEL: @buildvector_mul_addsub_pd512_partial(
; SSE-NEXT:    [[A:%.*]] = fmul <8 x double> [[C:%.*]], [[D:%.*]]
; SSE-NEXT:    [[TMP1:%.*]] = fsub <8 x double> [[A]], [[B:%.*]]
; SSE-NEXT:    [[TMP2:%.*]] = shufflevector <8 x double> [[TMP1]], <8 x double> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
; SSE-NEXT:    [[TMP3:%.*]] = fadd <8 x double> [[A]], [[B]]
; SSE-NEXT:    [[TMP4:%.*]] = shufflevector <8 x double> [[TMP3]], <8 x double> poison, <2 x i32> <i32 1, i32 3>
; SSE-NEXT:    [[TMP5:%.*]] = shufflevector <4 x double> [[TMP2]], <4 x double> poison, <6 x i32> <i32 0, i32 1, i32 2, i32 3, i32 poison, i32 poison>
; SSE-NEXT:    [[TMP6:%.*]] = shufflevector <2 x double> [[TMP4]], <2 x double> poison, <6 x i32> <i32 0, i32 1, i32 poison, i32 poison, i32 poison, i32 poison>
; SSE-NEXT:    [[TMP7:%.*]] = shufflevector <6 x double> [[TMP5]], <6 x double> [[TMP6]], <6 x i32> <i32 0, i32 1, i32 2, i32 3, i32 6, i32 7>
; SSE-NEXT:    [[A7:%.*]] = extractelement <8 x double> [[A]], i64 7
; SSE-NEXT:    [[B7:%.*]] = extractelement <8 x double> [[B]], i64 7
; SSE-NEXT:    [[ADD7:%.*]] = fadd double [[A7]], [[B7]]
; SSE-NEXT:    [[TMP8:%.*]] = shufflevector <6 x double> [[TMP7]], <6 x double> <double undef, double poison, double poison, double poison, double poison, double poison>, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 poison>
; SSE-NEXT:    [[VECINSERT8:%.*]] = insertelement <8 x double> [[TMP8]], double [[ADD7]], i64 7
; SSE-NEXT:    ret <8 x double> [[VECINSERT8]]
;
; AVX_FMA4-LABEL: @buildvector_mul_addsub_pd512_partial(
; AVX_FMA4-NEXT:    [[A:%.*]] = fmul <8 x double> [[C:%.*]], [[D:%.*]]
; AVX_FMA4-NEXT:    [[TMP1:%.*]] = shufflevector <8 x double> [[A]], <8 x double> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; AVX_FMA4-NEXT:    [[TMP2:%.*]] = shufflevector <8 x double> [[B:%.*]], <8 x double> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; AVX_FMA4-NEXT:    [[TMP3:%.*]] = fsub <4 x double> [[TMP1]], [[TMP2]]
; AVX_FMA4-NEXT:    [[TMP4:%.*]] = fadd <4 x double> [[TMP1]], [[TMP2]]
; AVX_FMA4-NEXT:    [[TMP5:%.*]] = shufflevector <4 x double> [[TMP3]], <4 x double> [[TMP4]], <4 x i32> <i32 0, i32 5, i32 2, i32 7>
; AVX_FMA4-NEXT:    [[A7:%.*]] = extractelement <8 x double> [[A]], i64 7
; AVX_FMA4-NEXT:    [[B7:%.*]] = extractelement <8 x double> [[B]], i64 7
; AVX_FMA4-NEXT:    [[ADD7:%.*]] = fadd double [[A7]], [[B7]]
; AVX_FMA4-NEXT:    [[TMP6:%.*]] = shufflevector <4 x double> [[TMP5]], <4 x double> <double undef, double poison, double poison, double poison>, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 poison, i32 4, i32 poison, i32 poison>
; AVX_FMA4-NEXT:    [[TMP7:%.*]] = fsub <8 x double> [[A]], [[B]]
; AVX_FMA4-NEXT:    [[TMP8:%.*]] = shufflevector <8 x double> [[TMP7]], <8 x double> poison, <8 x i32> <i32 4, i32 poison, i32 6, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
; AVX_FMA4-NEXT:    [[VECINSERT71:%.*]] = shufflevector <8 x double> [[TMP6]], <8 x double> [[TMP8]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 8, i32 5, i32 10, i32 poison>
; AVX_FMA4-NEXT:    [[VECINSERT8:%.*]] = insertelement <8 x double> [[VECINSERT71]], double [[ADD7]], i64 7
; AVX_FMA4-NEXT:    ret <8 x double> [[VECINSERT8]]
;
; AVX_FMA3-LABEL: @buildvector_mul_addsub_pd512_partial(
; AVX_FMA3-NEXT:    [[A:%.*]] = fmul <8 x double> [[C:%.*]], [[D:%.*]]
; AVX_FMA3-NEXT:    [[TMP1:%.*]] = shufflevector <8 x double> [[A]], <8 x double> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; AVX_FMA3-NEXT:    [[TMP2:%.*]] = shufflevector <8 x double> [[B:%.*]], <8 x double> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; AVX_FMA3-NEXT:    [[TMP3:%.*]] = fsub <4 x double> [[TMP1]], [[TMP2]]
; AVX_FMA3-NEXT:    [[TMP4:%.*]] = fadd <4 x double> [[TMP1]], [[TMP2]]
; AVX_FMA3-NEXT:    [[TMP5:%.*]] = shufflevector <4 x double> [[TMP3]], <4 x double> [[TMP4]], <4 x i32> <i32 0, i32 5, i32 2, i32 7>
; AVX_FMA3-NEXT:    [[TMP6:%.*]] = fadd <8 x double> [[A]], [[B]]
; AVX_FMA3-NEXT:    [[TMP7:%.*]] = shufflevector <4 x double> [[TMP5]], <4 x double> <double undef, double poison, double poison, double poison>, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 poison, i32 4, i32 poison, i32 poison>
; AVX_FMA3-NEXT:    [[TMP8:%.*]] = fsub <8 x double> [[A]], [[B]]
; AVX_FMA3-NEXT:    [[TMP9:%.*]] = shufflevector <8 x double> [[TMP8]], <8 x double> poison, <8 x i32> <i32 4, i32 poison, i32 6, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
; AVX_FMA3-NEXT:    [[VECINSERT71:%.*]] = shufflevector <8 x double> [[TMP7]], <8 x double> [[TMP9]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 8, i32 5, i32 10, i32 poison>
; AVX_FMA3-NEXT:    [[VECINSERT8:%.*]] = shufflevector <8 x double> [[VECINSERT71]], <8 x double> [[TMP6]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 15>
; AVX_FMA3-NEXT:    ret <8 x double> [[VECINSERT8]]
;
; AVX512-LABEL: @buildvector_mul_addsub_pd512_partial(
; AVX512-NEXT:    [[A:%.*]] = fmul <8 x double> [[C:%.*]], [[D:%.*]]
; AVX512-NEXT:    [[TMP1:%.*]] = shufflevector <8 x double> [[A]], <8 x double> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; AVX512-NEXT:    [[TMP2:%.*]] = shufflevector <8 x double> [[B:%.*]], <8 x double> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; AVX512-NEXT:    [[TMP3:%.*]] = fsub <4 x double> [[TMP1]], [[TMP2]]
; AVX512-NEXT:    [[TMP4:%.*]] = fadd <4 x double> [[TMP1]], [[TMP2]]
; AVX512-NEXT:    [[TMP5:%.*]] = shufflevector <4 x double> [[TMP3]], <4 x double> [[TMP4]], <4 x i32> <i32 0, i32 5, i32 2, i32 7>
; AVX512-NEXT:    [[TMP6:%.*]] = fadd <8 x double> [[A]], [[B]]
; AVX512-NEXT:    [[TMP7:%.*]] = shufflevector <4 x double> [[TMP5]], <4 x double> <double undef, double poison, double poison, double poison>, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 poison, i32 4, i32 poison, i32 poison>
; AVX512-NEXT:    [[TMP8:%.*]] = fsub <8 x double> [[A]], [[B]]
; AVX512-NEXT:    [[TMP9:%.*]] = shufflevector <8 x double> [[TMP8]], <8 x double> poison, <8 x i32> <i32 4, i32 poison, i32 6, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
; AVX512-NEXT:    [[VECINSERT71:%.*]] = shufflevector <8 x double> [[TMP7]], <8 x double> [[TMP9]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 8, i32 5, i32 10, i32 poison>
; AVX512-NEXT:    [[VECINSERT8:%.*]] = shufflevector <8 x double> [[VECINSERT71]], <8 x double> [[TMP6]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 15>
; AVX512-NEXT:    ret <8 x double> [[VECINSERT8]]
;
  %A = fmul <8 x double> %C, %D
  %A0 = extractelement <8 x double> %A, i32 0
  %B0 = extractelement <8 x double> %B, i32 0
  %sub0 = fsub double %A0, %B0
  %A2 = extractelement <8 x double> %A, i32 2
  %B2 = extractelement <8 x double> %B, i32 2
  %sub2 = fsub double %A2, %B2
  %A4 = extractelement <8 x double> %A, i32 4
  %B4 = extractelement <8 x double> %B, i32 4
  %sub4 = fsub double %A4, %B4
  %A6 = extractelement <8 x double> %A, i32 6
  %B6 = extractelement <8 x double> %B, i32 6
  %sub6 = fsub double %A6, %B6
  %A1 = extractelement <8 x double> %A, i32 1
  %B1 = extractelement <8 x double> %B, i32 1
  %add1 = fadd double %A1, %B1
  %A3 = extractelement <8 x double> %A, i32 3
  %B3 = extractelement <8 x double> %B, i32 3
  %add3 = fadd double %A3, %B3
  %A7 = extractelement <8 x double> %A, i32 7
  %B7 = extractelement <8 x double> %B, i32 7
  %add7 = fadd double %A7, %B7
  %vecinsert1 = insertelement <8 x double> undef, double %sub0, i32 0
  %vecinsert2 = insertelement <8 x double> %vecinsert1, double %add1, i32 1
  %vecinsert3 = insertelement <8 x double> %vecinsert2, double %sub2, i32 2
  %vecinsert4 = insertelement <8 x double> %vecinsert3, double %add3, i32 3
  %vecinsert5 = insertelement <8 x double> %vecinsert4, double %sub4, i32 4
  ; element 5 is undef
  %vecinsert7 = insertelement <8 x double> %vecinsert5, double %sub6, i32 6
  %vecinsert8 = insertelement <8 x double> %vecinsert7, double %add7, i32 7
  ret <8 x double> %vecinsert8
}

define <4 x float> @buildvector_mul_subadd_ps128(<4 x float> %C, <4 x float> %D, <4 x float> %B) #0 {
; CHECK-LABEL: @buildvector_mul_subadd_ps128(
; CHECK-NEXT:    [[A:%.*]] = fmul <4 x float> [[C:%.*]], [[D:%.*]]
; CHECK-NEXT:    [[TMP0:%.*]] = fadd <4 x float> [[A]], [[B:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = fsub <4 x float> [[A]], [[B]]
; CHECK-NEXT:    [[TMP2:%.*]] = shufflevector <4 x float> [[TMP0]], <4 x float> [[TMP1]], <4 x i32> <i32 0, i32 5, i32 2, i32 7>
; CHECK-NEXT:    ret <4 x float> [[TMP2]]
;
  %A = fmul <4 x float> %C, %D
  %A0 = extractelement <4 x float> %A, i32 0
  %B0 = extractelement <4 x float> %B, i32 0
  %sub0 = fadd float %A0, %B0
  %A2 = extractelement <4 x float> %A, i32 2
  %B2 = extractelement <4 x float> %B, i32 2
  %sub2 = fadd float %A2, %B2
  %A1 = extractelement <4 x float> %A, i32 1
  %B1 = extractelement <4 x float> %B, i32 1
  %add1 = fsub float %A1, %B1
  %A3 = extractelement <4 x float> %A, i32 3
  %B3 = extractelement <4 x float> %B, i32 3
  %add3 = fsub float %A3, %B3
  %vecinsert1 = insertelement <4 x float> undef, float %sub0, i32 0
  %vecinsert2 = insertelement <4 x float> %vecinsert1, float %add1, i32 1
  %vecinsert3 = insertelement <4 x float> %vecinsert2, float %sub2, i32 2
  %vecinsert4 = insertelement <4 x float> %vecinsert3, float %add3, i32 3
  ret <4 x float> %vecinsert4
}

define <2 x double> @buildvector_mul_subadd_pd128(<2 x double> %C, <2 x double> %D, <2 x double> %B) #0 {
; CHECK-LABEL: @buildvector_mul_subadd_pd128(
; CHECK-NEXT:    [[A:%.*]] = fmul <2 x double> [[C:%.*]], [[D:%.*]]
; CHECK-NEXT:    [[TMP0:%.*]] = fadd <2 x double> [[A]], [[B:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = fsub <2 x double> [[A]], [[B]]
; CHECK-NEXT:    [[TMP2:%.*]] = shufflevector <2 x double> [[TMP0]], <2 x double> [[TMP1]], <2 x i32> <i32 0, i32 3>
; CHECK-NEXT:    ret <2 x double> [[TMP2]]
;
  %A = fmul <2 x double> %C, %D
  %A0 = extractelement <2 x double> %A, i32 0
  %B0 = extractelement <2 x double> %B, i32 0
  %sub0 = fadd double %A0, %B0
  %A1 = extractelement <2 x double> %A, i32 1
  %B1 = extractelement <2 x double> %B, i32 1
  %add1 = fsub double %A1, %B1
  %vecinsert1 = insertelement <2 x double> undef, double %sub0, i32 0
  %vecinsert2 = insertelement <2 x double> %vecinsert1, double %add1, i32 1
  ret <2 x double> %vecinsert2
}

define <8 x float> @buildvector_mul_subadd_ps256(<8 x float> %C, <8 x float> %D, <8 x float> %B) #0 {
; SSE2-LABEL: @buildvector_mul_subadd_ps256(
; SSE2-NEXT:    [[A:%.*]] = fmul <8 x float> [[C:%.*]], [[D:%.*]]
; SSE2-NEXT:    [[TMP0:%.*]] = fadd <8 x float> [[A]], [[B:%.*]]
; SSE2-NEXT:    [[TMP1:%.*]] = shufflevector <8 x float> [[TMP0]], <8 x float> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
; SSE2-NEXT:    [[TMP2:%.*]] = fsub <8 x float> [[A]], [[B]]
; SSE2-NEXT:    [[TMP3:%.*]] = shufflevector <8 x float> [[TMP2]], <8 x float> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
; SSE2-NEXT:    [[TMP4:%.*]] = shufflevector <4 x float> [[TMP1]], <4 x float> [[TMP3]], <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
; SSE2-NEXT:    ret <8 x float> [[TMP4]]
;
; SSE4-LABEL: @buildvector_mul_subadd_ps256(
; SSE4-NEXT:    [[A:%.*]] = fmul <8 x float> [[C:%.*]], [[D:%.*]]
; SSE4-NEXT:    [[TMP2:%.*]] = fadd <8 x float> [[A]], [[B:%.*]]
; SSE4-NEXT:    [[TMP3:%.*]] = shufflevector <8 x float> [[TMP2]], <8 x float> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 poison, i32 poison, i32 poison, i32 poison>
; SSE4-NEXT:    [[TMP5:%.*]] = fsub <8 x float> [[A]], [[B]]
; SSE4-NEXT:    [[TMP4:%.*]] = shufflevector <8 x float> [[TMP5]], <8 x float> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 poison, i32 poison, i32 poison, i32 poison>
; SSE4-NEXT:    [[TMP6:%.*]] = shufflevector <8 x float> [[TMP3]], <8 x float> [[TMP4]], <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11>
; SSE4-NEXT:    ret <8 x float> [[TMP6]]
;
; AVX_FMA4-LABEL: @buildvector_mul_subadd_ps256(
; AVX_FMA4-NEXT:    [[A:%.*]] = fmul <8 x float> [[C:%.*]], [[D:%.*]]
; AVX_FMA4-NEXT:    [[TMP2:%.*]] = fadd <8 x float> [[A]], [[B:%.*]]
; AVX_FMA4-NEXT:    [[TMP3:%.*]] = shufflevector <8 x float> [[TMP2]], <8 x float> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 poison, i32 poison, i32 poison, i32 poison>
; AVX_FMA4-NEXT:    [[TMP7:%.*]] = fsub <8 x float> [[A]], [[B]]
; AVX_FMA4-NEXT:    [[TMP4:%.*]] = shufflevector <8 x float> [[TMP7]], <8 x float> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 poison, i32 poison, i32 poison, i32 poison>
; AVX_FMA4-NEXT:    [[TMP5:%.*]] = shufflevector <8 x float> [[TMP3]], <8 x float> [[TMP4]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 8, i32 9, i32 10, i32 11>
; AVX_FMA4-NEXT:    [[TMP6:%.*]] = shufflevector <8 x float> [[TMP5]], <8 x float> poison, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
; AVX_FMA4-NEXT:    ret <8 x float> [[TMP6]]
;
; AVX_FMA3-LABEL: @buildvector_mul_subadd_ps256(
; AVX_FMA3-NEXT:    [[A:%.*]] = fmul <8 x float> [[C:%.*]], [[D:%.*]]
; AVX_FMA3-NEXT:    [[TMP0:%.*]] = fadd <8 x float> [[A]], [[B:%.*]]
; AVX_FMA3-NEXT:    [[TMP1:%.*]] = fsub <8 x float> [[A]], [[B]]
; AVX_FMA3-NEXT:    [[TMP2:%.*]] = shufflevector <8 x float> [[TMP0]], <8 x float> [[TMP1]], <8 x i32> <i32 0, i32 9, i32 2, i32 11, i32 4, i32 13, i32 6, i32 15>
; AVX_FMA3-NEXT:    ret <8 x float> [[TMP2]]
;
; AVX512-LABEL: @buildvector_mul_subadd_ps256(
; AVX512-NEXT:    [[A:%.*]] = fmul <8 x float> [[C:%.*]], [[D:%.*]]
; AVX512-NEXT:    [[TMP0:%.*]] = fadd <8 x float> [[A]], [[B:%.*]]
; AVX512-NEXT:    [[TMP1:%.*]] = fsub <8 x float> [[A]], [[B]]
; AVX512-NEXT:    [[TMP2:%.*]] = shufflevector <8 x float> [[TMP0]], <8 x float> [[TMP1]], <8 x i32> <i32 0, i32 9, i32 2, i32 11, i32 4, i32 13, i32 6, i32 15>
; AVX512-NEXT:    ret <8 x float> [[TMP2]]
;
  %A = fmul <8 x float> %C, %D
  %A0 = extractelement <8 x float> %A, i32 0
  %B0 = extractelement <8 x float> %B, i32 0
  %sub0 = fadd float %A0, %B0
  %A2 = extractelement <8 x float> %A, i32 2
  %B2 = extractelement <8 x float> %B, i32 2
  %sub2 = fadd float %A2, %B2
  %A4 = extractelement <8 x float> %A, i32 4
  %B4 = extractelement <8 x float> %B, i32 4
  %sub4 = fadd float %A4, %B4
  %A6 = extractelement <8 x float> %A, i32 6
  %B6 = extractelement <8 x float> %B, i32 6
  %sub6 = fadd float %A6, %B6
  %A1 = extractelement <8 x float> %A, i32 1
  %B1 = extractelement <8 x float> %B, i32 1
  %add1 = fsub float %A1, %B1
  %A3 = extractelement <8 x float> %A, i32 3
  %B3 = extractelement <8 x float> %B, i32 3
  %add3 = fsub float %A3, %B3
  %A5 = extractelement <8 x float> %A, i32 5
  %B5 = extractelement <8 x float> %B, i32 5
  %add5 = fsub float %A5, %B5
  %A7 = extractelement <8 x float> %A, i32 7
  %B7 = extractelement <8 x float> %B, i32 7
  %add7 = fsub float %A7, %B7
  %vecinsert1 = insertelement <8 x float> undef, float %sub0, i32 0
  %vecinsert2 = insertelement <8 x float> %vecinsert1, float %add1, i32 1
  %vecinsert3 = insertelement <8 x float> %vecinsert2, float %sub2, i32 2
  %vecinsert4 = insertelement <8 x float> %vecinsert3, float %add3, i32 3
  %vecinsert5 = insertelement <8 x float> %vecinsert4, float %sub4, i32 4
  %vecinsert6 = insertelement <8 x float> %vecinsert5, float %add5, i32 5
  %vecinsert7 = insertelement <8 x float> %vecinsert6, float %sub6, i32 6
  %vecinsert8 = insertelement <8 x float> %vecinsert7, float %add7, i32 7
  ret <8 x float> %vecinsert8
}

define <4 x double> @buildvector_mul_subadd_pd256(<4 x double> %C, <4 x double> %D, <4 x double> %B) #0 {
; CHECK-LABEL: @buildvector_mul_subadd_pd256(
; CHECK-NEXT:    [[A:%.*]] = fmul <4 x double> [[C:%.*]], [[D:%.*]]
; CHECK-NEXT:    [[TMP0:%.*]] = fadd <4 x double> [[A]], [[B:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = fsub <4 x double> [[A]], [[B]]
; CHECK-NEXT:    [[TMP2:%.*]] = shufflevector <4 x double> [[TMP0]], <4 x double> [[TMP1]], <4 x i32> <i32 0, i32 5, i32 2, i32 7>
; CHECK-NEXT:    ret <4 x double> [[TMP2]]
;
  %A = fmul <4 x double> %C, %D
  %A0 = extractelement <4 x double> %A, i32 0
  %B0 = extractelement <4 x double> %B, i32 0
  %sub0 = fadd double %A0, %B0
  %A2 = extractelement <4 x double> %A, i32 2
  %B2 = extractelement <4 x double> %B, i32 2
  %sub2 = fadd double %A2, %B2
  %A1 = extractelement <4 x double> %A, i32 1
  %B1 = extractelement <4 x double> %B, i32 1
  %add1 = fsub double %A1, %B1
  %A3 = extractelement <4 x double> %A, i32 3
  %B3 = extractelement <4 x double> %B, i32 3
  %add3 = fsub double %A3, %B3
  %vecinsert1 = insertelement <4 x double> undef, double %sub0, i32 0
  %vecinsert2 = insertelement <4 x double> %vecinsert1, double %add1, i32 1
  %vecinsert3 = insertelement <4 x double> %vecinsert2, double %sub2, i32 2
  %vecinsert4 = insertelement <4 x double> %vecinsert3, double %add3, i32 3
  ret <4 x double> %vecinsert4
}

define <16 x float> @buildvector_mul_subadd_ps512(<16 x float> %C, <16 x float> %D, <16 x float> %B) #0 {
; SSE-LABEL: @buildvector_mul_subadd_ps512(
; SSE-NEXT:    [[A:%.*]] = fmul <16 x float> [[C:%.*]], [[D:%.*]]
; SSE-NEXT:    [[TMP1:%.*]] = fadd <16 x float> [[A]], [[B:%.*]]
; SSE-NEXT:    [[TMP2:%.*]] = shufflevector <16 x float> [[TMP1]], <16 x float> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
; SSE-NEXT:    [[TMP3:%.*]] = fsub <16 x float> [[A]], [[B]]
; SSE-NEXT:    [[TMP4:%.*]] = shufflevector <16 x float> [[TMP3]], <16 x float> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; SSE-NEXT:    [[VECINSERT161:%.*]] = shufflevector <8 x float> [[TMP2]], <8 x float> [[TMP4]], <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; SSE-NEXT:    ret <16 x float> [[VECINSERT161]]
;
; AVX_FMA-LABEL: @buildvector_mul_subadd_ps512(
; AVX_FMA-NEXT:    [[A:%.*]] = fmul <16 x float> [[C:%.*]], [[D:%.*]]
; AVX_FMA-NEXT:    [[TMP3:%.*]] = fadd <16 x float> [[A]], [[B:%.*]]
; AVX_FMA-NEXT:    [[TMP4:%.*]] = shufflevector <16 x float> [[TMP3]], <16 x float> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
; AVX_FMA-NEXT:    [[TMP5:%.*]] = fsub <16 x float> [[A]], [[B]]
; AVX_FMA-NEXT:    [[TMP6:%.*]] = shufflevector <16 x float> [[TMP5]], <16 x float> poison, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
; AVX_FMA-NEXT:    [[TMP7:%.*]] = shufflevector <16 x float> [[TMP4]], <16 x float> [[TMP6]], <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23>
; AVX_FMA-NEXT:    ret <16 x float> [[TMP7]]
;
; AVX512-LABEL: @buildvector_mul_subadd_ps512(
; AVX512-NEXT:    [[A:%.*]] = fmul <16 x float> [[C:%.*]], [[D:%.*]]
; AVX512-NEXT:    [[TMP1:%.*]] = fadd <16 x float> [[A]], [[B:%.*]]
; AVX512-NEXT:    [[TMP10:%.*]] = fsub <16 x float> [[A]], [[B]]
; AVX512-NEXT:    [[VECINSERT162:%.*]] = shufflevector <16 x float> [[TMP1]], <16 x float> [[TMP10]], <16 x i32> <i32 0, i32 17, i32 2, i32 19, i32 4, i32 21, i32 6, i32 23, i32 8, i32 25, i32 10, i32 27, i32 12, i32 29, i32 14, i32 31>
; AVX512-NEXT:    ret <16 x float> [[VECINSERT162]]
;
  %A = fmul <16 x float> %C, %D
  %A0 = extractelement <16 x float> %A, i32 0
  %B0 = extractelement <16 x float> %B, i32 0
  %sub0 = fadd float %A0, %B0
  %A2 = extractelement <16 x float> %A, i32 2
  %B2 = extractelement <16 x float> %B, i32 2
  %sub2 = fadd float %A2, %B2
  %A4 = extractelement <16 x float> %A, i32 4
  %B4 = extractelement <16 x float> %B, i32 4
  %sub4 = fadd float %A4, %B4
  %A6 = extractelement <16 x float> %A, i32 6
  %B6 = extractelement <16 x float> %B, i32 6
  %sub6 = fadd float %A6, %B6
  %A8 = extractelement <16 x float> %A, i32 8
  %B8 = extractelement <16 x float> %B, i32 8
  %sub8 = fadd float %A8, %B8
  %A10 = extractelement <16 x float> %A, i32 10
  %B10 = extractelement <16 x float> %B, i32 10
  %sub10 = fadd float %A10, %B10
  %A12 = extractelement <16 x float> %A, i32 12
  %B12 = extractelement <16 x float> %B, i32 12
  %sub12 = fadd float %A12, %B12
  %A14 = extractelement <16 x float> %A, i32 14
  %B14 = extractelement <16 x float> %B, i32 14
  %sub14 = fadd float %A14, %B14
  %A1 = extractelement <16 x float> %A, i32 1
  %B1 = extractelement <16 x float> %B, i32 1
  %add1 = fsub float %A1, %B1
  %A3 = extractelement <16 x float> %A, i32 3
  %B3 = extractelement <16 x float> %B, i32 3
  %add3 = fsub float %A3, %B3
  %A5 = extractelement <16 x float> %A, i32 5
  %B5 = extractelement <16 x float> %B, i32 5
  %add5 = fsub float %A5, %B5
  %A7 = extractelement <16 x float> %A, i32 7
  %B7 = extractelement <16 x float> %B, i32 7
  %add7 = fsub float %A7, %B7
  %A9 = extractelement <16 x float> %A, i32 9
  %B9 = extractelement <16 x float> %B, i32 9
  %add9 = fsub float %A9, %B9
  %A11 = extractelement <16 x float> %A, i32 11
  %B11 = extractelement <16 x float> %B, i32 11
  %add11 = fsub float %A11, %B11
  %A13 = extractelement <16 x float> %A, i32 13
  %B13 = extractelement <16 x float> %B, i32 13
  %add13 = fsub float %A13, %B13
  %A15 = extractelement <16 x float> %A, i32 15
  %B15 = extractelement <16 x float> %B, i32 15
  %add15 = fsub float %A15, %B15
  %vecinsert1 = insertelement <16 x float> undef, float %sub0, i32 0
  %vecinsert2 = insertelement <16 x float> %vecinsert1, float %add1, i32 1
  %vecinsert3 = insertelement <16 x float> %vecinsert2, float %sub2, i32 2
  %vecinsert4 = insertelement <16 x float> %vecinsert3, float %add3, i32 3
  %vecinsert5 = insertelement <16 x float> %vecinsert4, float %sub4, i32 4
  %vecinsert6 = insertelement <16 x float> %vecinsert5, float %add5, i32 5
  %vecinsert7 = insertelement <16 x float> %vecinsert6, float %sub6, i32 6
  %vecinsert8 = insertelement <16 x float> %vecinsert7, float %add7, i32 7
  %vecinsert9 = insertelement <16 x float> %vecinsert8, float %sub8, i32 8
  %vecinsert10 = insertelement <16 x float> %vecinsert9, float %add9, i32 9
  %vecinsert11 = insertelement <16 x float> %vecinsert10, float %sub10, i32 10
  %vecinsert12 = insertelement <16 x float> %vecinsert11, float %add11, i32 11
  %vecinsert13 = insertelement <16 x float> %vecinsert12, float %sub12, i32 12
  %vecinsert14 = insertelement <16 x float> %vecinsert13, float %add13, i32 13
  %vecinsert15 = insertelement <16 x float> %vecinsert14, float %sub14, i32 14
  %vecinsert16 = insertelement <16 x float> %vecinsert15, float %add15, i32 15
  ret <16 x float> %vecinsert16
}

define <16 x float> @buildvector_mul_subadd_ps512_partial(<16 x float> %C, <16 x float> %D, <16 x float> %B) #0 {
; SSE-LABEL: @buildvector_mul_subadd_ps512_partial(
; SSE-NEXT:    [[A:%.*]] = fmul <16 x float> [[C:%.*]], [[D:%.*]]
; SSE-NEXT:    [[TMP1:%.*]] = shufflevector <16 x float> [[A]], <16 x float> poison, <12 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 13>
; SSE-NEXT:    [[TMP2:%.*]] = shufflevector <16 x float> [[B:%.*]], <16 x float> poison, <12 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 13>
; SSE-NEXT:    [[TMP3:%.*]] = fadd <12 x float> [[TMP1]], [[TMP2]]
; SSE-NEXT:    [[TMP4:%.*]] = fsub <12 x float> [[TMP1]], [[TMP2]]
; SSE-NEXT:    [[TMP5:%.*]] = shufflevector <12 x float> [[TMP3]], <12 x float> [[TMP4]], <12 x i32> <i32 0, i32 13, i32 2, i32 15, i32 4, i32 5, i32 18, i32 7, i32 20, i32 9, i32 22, i32 23>
; SSE-NEXT:    [[TMP6:%.*]] = shufflevector <16 x float> [[A]], <16 x float> poison, <2 x i32> <i32 14, i32 15>
; SSE-NEXT:    [[TMP7:%.*]] = shufflevector <16 x float> [[B]], <16 x float> poison, <2 x i32> <i32 14, i32 15>
; SSE-NEXT:    [[TMP8:%.*]] = fadd <2 x float> [[TMP6]], [[TMP7]]
; SSE-NEXT:    [[TMP9:%.*]] = fsub <2 x float> [[TMP6]], [[TMP7]]
; SSE-NEXT:    [[TMP10:%.*]] = shufflevector <12 x float> [[TMP5]], <12 x float> <float undef, float undef, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison, float poison>, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 12, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 13, i32 11, i32 poison, i32 poison>
; SSE-NEXT:    [[TMP11:%.*]] = shufflevector <2 x float> [[TMP8]], <2 x float> [[TMP9]], <16 x i32> <i32 0, i32 3, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
; SSE-NEXT:    [[VECINSERT161:%.*]] = shufflevector <16 x float> [[TMP10]], <16 x float> [[TMP11]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 16, i32 17>
; SSE-NEXT:    ret <16 x float> [[VECINSERT161]]
;
; AVX-LABEL: @buildvector_mul_subadd_ps512_partial(
; AVX-NEXT:    [[A:%.*]] = fmul <16 x float> [[C:%.*]], [[D:%.*]]
; AVX-NEXT:    [[TMP1:%.*]] = shufflevector <16 x float> [[A]], <16 x float> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 6, i32 7, i32 8>
; AVX-NEXT:    [[TMP2:%.*]] = shufflevector <16 x float> [[B:%.*]], <16 x float> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 6, i32 7, i32 8>
; AVX-NEXT:    [[TMP3:%.*]] = fadd <8 x float> [[TMP1]], [[TMP2]]
; AVX-NEXT:    [[TMP4:%.*]] = fsub <8 x float> [[TMP1]], [[TMP2]]
; AVX-NEXT:    [[TMP5:%.*]] = shufflevector <8 x float> [[TMP3]], <8 x float> [[TMP4]], <8 x i32> <i32 0, i32 9, i32 2, i32 11, i32 4, i32 5, i32 14, i32 7>
; AVX-NEXT:    [[TMP6:%.*]] = shufflevector <16 x float> [[A]], <16 x float> poison, <4 x i32> <i32 9, i32 10, i32 11, i32 13>
; AVX-NEXT:    [[TMP7:%.*]] = shufflevector <16 x float> [[B]], <16 x float> poison, <4 x i32> <i32 9, i32 10, i32 11, i32 13>
; AVX-NEXT:    [[TMP8:%.*]] = fsub <4 x float> [[TMP6]], [[TMP7]]
; AVX-NEXT:    [[TMP9:%.*]] = fadd <4 x float> [[TMP6]], [[TMP7]]
; AVX-NEXT:    [[TMP10:%.*]] = shufflevector <16 x float> [[A]], <16 x float> poison, <2 x i32> <i32 14, i32 15>
; AVX-NEXT:    [[TMP11:%.*]] = shufflevector <16 x float> [[B]], <16 x float> poison, <2 x i32> <i32 14, i32 15>
; AVX-NEXT:    [[TMP12:%.*]] = fadd <2 x float> [[TMP10]], [[TMP11]]
; AVX-NEXT:    [[TMP13:%.*]] = fsub <2 x float> [[TMP10]], [[TMP11]]
; AVX-NEXT:    [[TMP14:%.*]] = shufflevector <8 x float> [[TMP5]], <8 x float> <float undef, float undef, float poison, float poison, float poison, float poison, float poison, float poison>, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 8, i32 5, i32 6, i32 7, i32 poison, i32 poison, i32 poison, i32 9, i32 poison, i32 poison, i32 poison>
; AVX-NEXT:    [[TMP15:%.*]] = shufflevector <4 x float> [[TMP8]], <4 x float> [[TMP9]], <16 x i32> <i32 0, i32 5, i32 2, i32 poison, i32 3, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
; AVX-NEXT:    [[VECINSERT141:%.*]] = shufflevector <16 x float> [[TMP14]], <16 x float> [[TMP15]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 16, i32 17, i32 18, i32 12, i32 20, i32 poison, i32 poison>
; AVX-NEXT:    [[TMP16:%.*]] = shufflevector <2 x float> [[TMP12]], <2 x float> [[TMP13]], <16 x i32> <i32 0, i32 3, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
; AVX-NEXT:    [[VECINSERT162:%.*]] = shufflevector <16 x float> [[VECINSERT141]], <16 x float> [[TMP16]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 16, i32 17>
; AVX-NEXT:    ret <16 x float> [[VECINSERT162]]
;
  %A = fmul <16 x float> %C, %D
  %A0 = extractelement <16 x float> %A, i32 0
  %B0 = extractelement <16 x float> %B, i32 0
  %sub0 = fadd float %A0, %B0
  %A2 = extractelement <16 x float> %A, i32 2
  %B2 = extractelement <16 x float> %B, i32 2
  %sub2 = fadd float %A2, %B2
  %A4 = extractelement <16 x float> %A, i32 4
  %B4 = extractelement <16 x float> %B, i32 4
  %sub4 = fadd float %A4, %B4
  %A6 = extractelement <16 x float> %A, i32 6
  %B6 = extractelement <16 x float> %B, i32 6
  %sub6 = fadd float %A6, %B6
  %A8 = extractelement <16 x float> %A, i32 8
  %B8 = extractelement <16 x float> %B, i32 8
  %sub8 = fadd float %A8, %B8
  %A10 = extractelement <16 x float> %A, i32 10
  %B10 = extractelement <16 x float> %B, i32 10
  %sub10 = fadd float %A10, %B10
  %A12 = extractelement <16 x float> %A, i32 12
  %B12 = extractelement <16 x float> %B, i32 12
  %sub12 = fadd float %A12, %B12
  %A14 = extractelement <16 x float> %A, i32 14
  %B14 = extractelement <16 x float> %B, i32 14
  %sub14 = fadd float %A14, %B14
  %A1 = extractelement <16 x float> %A, i32 1
  %B1 = extractelement <16 x float> %B, i32 1
  %add1 = fsub float %A1, %B1
  %A3 = extractelement <16 x float> %A, i32 3
  %B3 = extractelement <16 x float> %B, i32 3
  %add3 = fsub float %A3, %B3
  %A5 = extractelement <16 x float> %A, i32 5
  %B5 = extractelement <16 x float> %B, i32 5
  %add5 = fsub float %A5, %B5
  %A7 = extractelement <16 x float> %A, i32 7
  %B7 = extractelement <16 x float> %B, i32 7
  %add7 = fsub float %A7, %B7
  %A9 = extractelement <16 x float> %A, i32 9
  %B9 = extractelement <16 x float> %B, i32 9
  %add9 = fsub float %A9, %B9
  %A11 = extractelement <16 x float> %A, i32 11
  %B11 = extractelement <16 x float> %B, i32 11
  %add11 = fsub float %A11, %B11
  %A13 = extractelement <16 x float> %A, i32 13
  %B13 = extractelement <16 x float> %B, i32 13
  %add13 = fsub float %A13, %B13
  %A15 = extractelement <16 x float> %A, i32 15
  %B15 = extractelement <16 x float> %B, i32 15
  %add15 = fsub float %A15, %B15
  %vecinsert1 = insertelement <16 x float> undef, float %sub0, i32 0
  %vecinsert2 = insertelement <16 x float> %vecinsert1, float %add1, i32 1
  %vecinsert3 = insertelement <16 x float> %vecinsert2, float %sub2, i32 2
  %vecinsert4 = insertelement <16 x float> %vecinsert3, float %add3, i32 3
  %vecinsert5 = insertelement <16 x float> %vecinsert4, float %sub4, i32 4
  ; element 5 is undef
  %vecinsert7 = insertelement <16 x float> %vecinsert5, float %sub6, i32 6
  %vecinsert8 = insertelement <16 x float> %vecinsert7, float %add7, i32 7
  %vecinsert9 = insertelement <16 x float> %vecinsert8, float %sub8, i32 8
  %vecinsert10 = insertelement <16 x float> %vecinsert9, float %add9, i32 9
  %vecinsert11 = insertelement <16 x float> %vecinsert10, float %sub10, i32 10
  %vecinsert12 = insertelement <16 x float> %vecinsert11, float %add11, i32 11
  ; element 12 is undef
  %vecinsert14 = insertelement <16 x float> %vecinsert12, float %add13, i32 13
  %vecinsert15 = insertelement <16 x float> %vecinsert14, float %sub14, i32 14
  %vecinsert16 = insertelement <16 x float> %vecinsert15, float %add15, i32 15
  ret <16 x float> %vecinsert16
}

define <8 x double> @buildvector_mul_subadd_pd512(<8 x double> %C, <8 x double> %D, <8 x double> %B) #0 {
; SSE-LABEL: @buildvector_mul_subadd_pd512(
; SSE-NEXT:    [[A:%.*]] = fmul <8 x double> [[C:%.*]], [[D:%.*]]
; SSE-NEXT:    [[TMP0:%.*]] = fadd <8 x double> [[A]], [[B:%.*]]
; SSE-NEXT:    [[TMP1:%.*]] = shufflevector <8 x double> [[TMP0]], <8 x double> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
; SSE-NEXT:    [[TMP2:%.*]] = fsub <8 x double> [[A]], [[B]]
; SSE-NEXT:    [[TMP4:%.*]] = shufflevector <8 x double> [[TMP2]], <8 x double> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
; SSE-NEXT:    [[VECINSERT8:%.*]] = shufflevector <4 x double> [[TMP1]], <4 x double> [[TMP4]], <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
; SSE-NEXT:    ret <8 x double> [[VECINSERT8]]
;
; AVX_FMA-LABEL: @buildvector_mul_subadd_pd512(
; AVX_FMA-NEXT:    [[A:%.*]] = fmul <8 x double> [[C:%.*]], [[D:%.*]]
; AVX_FMA-NEXT:    [[TMP3:%.*]] = fadd <8 x double> [[A]], [[B:%.*]]
; AVX_FMA-NEXT:    [[TMP4:%.*]] = shufflevector <8 x double> [[TMP3]], <8 x double> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 poison, i32 poison, i32 poison, i32 poison>
; AVX_FMA-NEXT:    [[TMP5:%.*]] = fsub <8 x double> [[A]], [[B]]
; AVX_FMA-NEXT:    [[TMP6:%.*]] = shufflevector <8 x double> [[TMP5]], <8 x double> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 poison, i32 poison, i32 poison, i32 poison>
; AVX_FMA-NEXT:    [[TMP7:%.*]] = shufflevector <8 x double> [[TMP4]], <8 x double> [[TMP6]], <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11>
; AVX_FMA-NEXT:    ret <8 x double> [[TMP7]]
;
; AVX512-LABEL: @buildvector_mul_subadd_pd512(
; AVX512-NEXT:    [[A:%.*]] = fmul <8 x double> [[C:%.*]], [[D:%.*]]
; AVX512-NEXT:    [[TMP7:%.*]] = fadd <8 x double> [[A]], [[B:%.*]]
; AVX512-NEXT:    [[TMP2:%.*]] = fsub <8 x double> [[A]], [[B]]
; AVX512-NEXT:    [[VECINSERT8:%.*]] = shufflevector <8 x double> [[TMP7]], <8 x double> [[TMP2]], <8 x i32> <i32 0, i32 9, i32 2, i32 11, i32 4, i32 13, i32 6, i32 15>
; AVX512-NEXT:    ret <8 x double> [[VECINSERT8]]
;
  %A = fmul <8 x double> %C, %D
  %A0 = extractelement <8 x double> %A, i32 0
  %B0 = extractelement <8 x double> %B, i32 0
  %sub0 = fadd double %A0, %B0
  %A2 = extractelement <8 x double> %A, i32 2
  %B2 = extractelement <8 x double> %B, i32 2
  %sub2 = fadd double %A2, %B2
  %A4 = extractelement <8 x double> %A, i32 4
  %B4 = extractelement <8 x double> %B, i32 4
  %sub4 = fadd double %A4, %B4
  %A6 = extractelement <8 x double> %A, i32 6
  %B6 = extractelement <8 x double> %B, i32 6
  %sub6 = fadd double %A6, %B6
  %A1 = extractelement <8 x double> %A, i32 1
  %B1 = extractelement <8 x double> %B, i32 1
  %add1 = fsub double %A1, %B1
  %A3 = extractelement <8 x double> %A, i32 3
  %B3 = extractelement <8 x double> %B, i32 3
  %add3 = fsub double %A3, %B3
  %A5 = extractelement <8 x double> %A, i52 5
  %B5 = extractelement <8 x double> %B, i52 5
  %add5 = fsub double %A5, %B5
  %A7 = extractelement <8 x double> %A, i32 7
  %B7 = extractelement <8 x double> %B, i32 7
  %add7 = fsub double %A7, %B7
  %vecinsert1 = insertelement <8 x double> undef, double %sub0, i32 0
  %vecinsert2 = insertelement <8 x double> %vecinsert1, double %add1, i32 1
  %vecinsert3 = insertelement <8 x double> %vecinsert2, double %sub2, i32 2
  %vecinsert4 = insertelement <8 x double> %vecinsert3, double %add3, i32 3
  %vecinsert5 = insertelement <8 x double> %vecinsert4, double %sub4, i32 4
  %vecinsert6 = insertelement <8 x double> %vecinsert5, double %add5, i32 5
  %vecinsert7 = insertelement <8 x double> %vecinsert6, double %sub6, i32 6
  %vecinsert8 = insertelement <8 x double> %vecinsert7, double %add7, i32 7
  ret <8 x double> %vecinsert8
}

define <8 x double> @buildvector_mul_subadd_pd512_partial(<8 x double> %C, <8 x double> %D, <8 x double> %B) #0 {
; SSE-LABEL: @buildvector_mul_subadd_pd512_partial(
; SSE-NEXT:    [[A:%.*]] = fmul <8 x double> [[C:%.*]], [[D:%.*]]
; SSE-NEXT:    [[TMP1:%.*]] = fadd <8 x double> [[A]], [[B:%.*]]
; SSE-NEXT:    [[TMP2:%.*]] = shufflevector <8 x double> [[TMP1]], <8 x double> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
; SSE-NEXT:    [[TMP3:%.*]] = fsub <8 x double> [[A]], [[B]]
; SSE-NEXT:    [[TMP4:%.*]] = shufflevector <8 x double> [[TMP3]], <8 x double> poison, <2 x i32> <i32 1, i32 3>
; SSE-NEXT:    [[TMP5:%.*]] = shufflevector <4 x double> [[TMP2]], <4 x double> poison, <6 x i32> <i32 0, i32 1, i32 2, i32 3, i32 poison, i32 poison>
; SSE-NEXT:    [[TMP6:%.*]] = shufflevector <2 x double> [[TMP4]], <2 x double> poison, <6 x i32> <i32 0, i32 1, i32 poison, i32 poison, i32 poison, i32 poison>
; SSE-NEXT:    [[TMP7:%.*]] = shufflevector <6 x double> [[TMP5]], <6 x double> [[TMP6]], <6 x i32> <i32 0, i32 1, i32 2, i32 3, i32 6, i32 7>
; SSE-NEXT:    [[A7:%.*]] = extractelement <8 x double> [[A]], i64 7
; SSE-NEXT:    [[B7:%.*]] = extractelement <8 x double> [[B]], i64 7
; SSE-NEXT:    [[ADD7:%.*]] = fsub double [[A7]], [[B7]]
; SSE-NEXT:    [[TMP8:%.*]] = shufflevector <6 x double> [[TMP7]], <6 x double> <double undef, double poison, double poison, double poison, double poison, double poison>, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 poison>
; SSE-NEXT:    [[VECINSERT8:%.*]] = insertelement <8 x double> [[TMP8]], double [[ADD7]], i64 7
; SSE-NEXT:    ret <8 x double> [[VECINSERT8]]
;
; AVX_FMA4-LABEL: @buildvector_mul_subadd_pd512_partial(
; AVX_FMA4-NEXT:    [[A:%.*]] = fmul <8 x double> [[C:%.*]], [[D:%.*]]
; AVX_FMA4-NEXT:    [[TMP1:%.*]] = shufflevector <8 x double> [[A]], <8 x double> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; AVX_FMA4-NEXT:    [[TMP2:%.*]] = shufflevector <8 x double> [[B:%.*]], <8 x double> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; AVX_FMA4-NEXT:    [[TMP3:%.*]] = fadd <4 x double> [[TMP1]], [[TMP2]]
; AVX_FMA4-NEXT:    [[TMP4:%.*]] = fsub <4 x double> [[TMP1]], [[TMP2]]
; AVX_FMA4-NEXT:    [[TMP5:%.*]] = shufflevector <4 x double> [[TMP3]], <4 x double> [[TMP4]], <4 x i32> <i32 0, i32 5, i32 2, i32 7>
; AVX_FMA4-NEXT:    [[A7:%.*]] = extractelement <8 x double> [[A]], i64 7
; AVX_FMA4-NEXT:    [[B7:%.*]] = extractelement <8 x double> [[B]], i64 7
; AVX_FMA4-NEXT:    [[ADD7:%.*]] = fsub double [[A7]], [[B7]]
; AVX_FMA4-NEXT:    [[TMP6:%.*]] = shufflevector <4 x double> [[TMP5]], <4 x double> <double undef, double poison, double poison, double poison>, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 poison, i32 4, i32 poison, i32 poison>
; AVX_FMA4-NEXT:    [[TMP7:%.*]] = fadd <8 x double> [[A]], [[B]]
; AVX_FMA4-NEXT:    [[TMP8:%.*]] = shufflevector <8 x double> [[TMP7]], <8 x double> poison, <8 x i32> <i32 4, i32 poison, i32 6, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
; AVX_FMA4-NEXT:    [[VECINSERT71:%.*]] = shufflevector <8 x double> [[TMP6]], <8 x double> [[TMP8]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 8, i32 5, i32 10, i32 poison>
; AVX_FMA4-NEXT:    [[VECINSERT8:%.*]] = insertelement <8 x double> [[VECINSERT71]], double [[ADD7]], i64 7
; AVX_FMA4-NEXT:    ret <8 x double> [[VECINSERT8]]
;
; AVX_FMA3-LABEL: @buildvector_mul_subadd_pd512_partial(
; AVX_FMA3-NEXT:    [[A:%.*]] = fmul <8 x double> [[C:%.*]], [[D:%.*]]
; AVX_FMA3-NEXT:    [[TMP1:%.*]] = shufflevector <8 x double> [[A]], <8 x double> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; AVX_FMA3-NEXT:    [[TMP2:%.*]] = shufflevector <8 x double> [[B:%.*]], <8 x double> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; AVX_FMA3-NEXT:    [[TMP3:%.*]] = fadd <4 x double> [[TMP1]], [[TMP2]]
; AVX_FMA3-NEXT:    [[TMP4:%.*]] = fsub <4 x double> [[TMP1]], [[TMP2]]
; AVX_FMA3-NEXT:    [[TMP5:%.*]] = shufflevector <4 x double> [[TMP3]], <4 x double> [[TMP4]], <4 x i32> <i32 0, i32 5, i32 2, i32 7>
; AVX_FMA3-NEXT:    [[TMP6:%.*]] = fsub <8 x double> [[A]], [[B]]
; AVX_FMA3-NEXT:    [[TMP7:%.*]] = shufflevector <4 x double> [[TMP5]], <4 x double> <double undef, double poison, double poison, double poison>, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 poison, i32 4, i32 poison, i32 poison>
; AVX_FMA3-NEXT:    [[TMP8:%.*]] = fadd <8 x double> [[A]], [[B]]
; AVX_FMA3-NEXT:    [[TMP9:%.*]] = shufflevector <8 x double> [[TMP8]], <8 x double> poison, <8 x i32> <i32 4, i32 poison, i32 6, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
; AVX_FMA3-NEXT:    [[VECINSERT71:%.*]] = shufflevector <8 x double> [[TMP7]], <8 x double> [[TMP9]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 8, i32 5, i32 10, i32 poison>
; AVX_FMA3-NEXT:    [[VECINSERT8:%.*]] = shufflevector <8 x double> [[VECINSERT71]], <8 x double> [[TMP6]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 15>
; AVX_FMA3-NEXT:    ret <8 x double> [[VECINSERT8]]
;
; AVX512-LABEL: @buildvector_mul_subadd_pd512_partial(
; AVX512-NEXT:    [[A:%.*]] = fmul <8 x double> [[C:%.*]], [[D:%.*]]
; AVX512-NEXT:    [[TMP1:%.*]] = shufflevector <8 x double> [[A]], <8 x double> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; AVX512-NEXT:    [[TMP2:%.*]] = shufflevector <8 x double> [[B:%.*]], <8 x double> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; AVX512-NEXT:    [[TMP3:%.*]] = fadd <4 x double> [[TMP1]], [[TMP2]]
; AVX512-NEXT:    [[TMP4:%.*]] = fsub <4 x double> [[TMP1]], [[TMP2]]
; AVX512-NEXT:    [[TMP5:%.*]] = shufflevector <4 x double> [[TMP3]], <4 x double> [[TMP4]], <4 x i32> <i32 0, i32 5, i32 2, i32 7>
; AVX512-NEXT:    [[TMP6:%.*]] = fsub <8 x double> [[A]], [[B]]
; AVX512-NEXT:    [[TMP7:%.*]] = shufflevector <4 x double> [[TMP5]], <4 x double> <double undef, double poison, double poison, double poison>, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 poison, i32 4, i32 poison, i32 poison>
; AVX512-NEXT:    [[TMP8:%.*]] = fadd <8 x double> [[A]], [[B]]
; AVX512-NEXT:    [[TMP9:%.*]] = shufflevector <8 x double> [[TMP8]], <8 x double> poison, <8 x i32> <i32 4, i32 poison, i32 6, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
; AVX512-NEXT:    [[VECINSERT71:%.*]] = shufflevector <8 x double> [[TMP7]], <8 x double> [[TMP9]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 8, i32 5, i32 10, i32 poison>
; AVX512-NEXT:    [[VECINSERT8:%.*]] = shufflevector <8 x double> [[VECINSERT71]], <8 x double> [[TMP6]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 15>
; AVX512-NEXT:    ret <8 x double> [[VECINSERT8]]
;
  %A = fmul <8 x double> %C, %D
  %A0 = extractelement <8 x double> %A, i32 0
  %B0 = extractelement <8 x double> %B, i32 0
  %sub0 = fadd double %A0, %B0
  %A2 = extractelement <8 x double> %A, i32 2
  %B2 = extractelement <8 x double> %B, i32 2
  %sub2 = fadd double %A2, %B2
  %A4 = extractelement <8 x double> %A, i32 4
  %B4 = extractelement <8 x double> %B, i32 4
  %sub4 = fadd double %A4, %B4
  %A6 = extractelement <8 x double> %A, i32 6
  %B6 = extractelement <8 x double> %B, i32 6
  %sub6 = fadd double %A6, %B6
  %A1 = extractelement <8 x double> %A, i32 1
  %B1 = extractelement <8 x double> %B, i32 1
  %add1 = fsub double %A1, %B1
  %A3 = extractelement <8 x double> %A, i32 3
  %B3 = extractelement <8 x double> %B, i32 3
  %add3 = fsub double %A3, %B3
  %A7 = extractelement <8 x double> %A, i32 7
  %B7 = extractelement <8 x double> %B, i32 7
  %add7 = fsub double %A7, %B7
  %vecinsert1 = insertelement <8 x double> undef, double %sub0, i32 0
  %vecinsert2 = insertelement <8 x double> %vecinsert1, double %add1, i32 1
  %vecinsert3 = insertelement <8 x double> %vecinsert2, double %sub2, i32 2
  %vecinsert4 = insertelement <8 x double> %vecinsert3, double %add3, i32 3
  %vecinsert5 = insertelement <8 x double> %vecinsert4, double %sub4, i32 4
  ; element 5 is undef
  %vecinsert7 = insertelement <8 x double> %vecinsert5, double %sub6, i32 6
  %vecinsert8 = insertelement <8 x double> %vecinsert7, double %add7, i32 7
  ret <8 x double> %vecinsert8
}

attributes #0 = { nounwind "unsafe-fp-math"="true" }
