; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

declare void @use_ptr(ptr)

define i1 @inttoptr(i64 %x, i64 %y) {
; CHECK-LABEL: @inttoptr(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i64 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %xptr = inttoptr i64 %x to ptr
  %yptr = inttoptr i64 %y to ptr
  %cmp = icmp eq ptr %xptr, %yptr
  ret i1 %cmp
}

define i1 @inttoptr_constant(i64 %x) {
; CHECK-LABEL: @inttoptr_constant(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i64 [[X:%.*]], 42
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %xptr = inttoptr i64 %x to ptr
  %cmp = icmp eq ptr %xptr, inttoptr (i64 42 to ptr)
  ret i1 %cmp
}

define <2 x i1> @inttoptr_vector(<2 x i64> %x, <2 x i64> %y) {
; CHECK-LABEL: @inttoptr_vector(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq <2 x i64> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %xptr = inttoptr <2 x i64> %x to <2 x ptr>
  %yptr = inttoptr <2 x i64> %y to <2 x ptr>
  %cmp = icmp eq <2 x ptr> %xptr, %yptr
  ret <2 x i1> %cmp
}

define <2 x i1> @inttoptr_vector_constant(<2 x i64> %x) {
; CHECK-LABEL: @inttoptr_vector_constant(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq <2 x i64> [[X:%.*]], <i64 42, i64 123>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %xptr = inttoptr <2 x i64> %x to <2 x ptr>
  %cmp = icmp eq <2 x ptr> %xptr, inttoptr (<2 x i64> <i64 42, i64 123> to <2 x ptr>)
  ret <2 x i1> %cmp
}

define i1 @inttoptr_size_mismatch(i200 %x, i64 %y) {
; CHECK-LABEL: @inttoptr_size_mismatch(
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i200 [[X:%.*]] to i64
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i64 [[Y:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %xptr = inttoptr i200 %x to ptr
  %yptr = inttoptr i64 %y to ptr
  %cmp = icmp eq ptr %xptr, %yptr
  ret i1 %cmp
}

define <2 x i1> @inttoptr_vector_constant_size_mismatch(<2 x i64> %x) {
; CHECK-LABEL: @inttoptr_vector_constant_size_mismatch(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq <2 x i64> [[X:%.*]], <i64 42, i64 123>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %xptr = inttoptr <2 x i64> %x to <2 x ptr>
  %cmp = icmp eq <2 x ptr> %xptr, inttoptr (<2x i9> <i9 42, i9 123> to <2 x ptr>)
  ret <2 x i1> %cmp
}

define i1 @inttoptr_oneside(i64 %x, ptr %y) {
; CHECK-LABEL: @inttoptr_oneside(
; CHECK-NEXT:    [[XPTR:%.*]] = inttoptr i64 [[X:%.*]] to ptr
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq ptr [[Y:%.*]], [[XPTR]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %xptr = inttoptr i64 %x to ptr
  %cmp = icmp eq ptr %xptr, %y
  ret i1 %cmp
}

define i1 @inttoptr_used(i64 %x, i64 %y) {
; CHECK-LABEL: @inttoptr_used(
; CHECK-NEXT:    [[XPTR:%.*]] = inttoptr i64 [[X:%.*]] to ptr
; CHECK-NEXT:    [[YPTR:%.*]] = inttoptr i64 [[Y:%.*]] to ptr
; CHECK-NEXT:    call void @use_ptr(ptr [[XPTR]])
; CHECK-NEXT:    call void @use_ptr(ptr [[YPTR]])
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i64 [[X]], [[Y]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %xptr = inttoptr i64 %x to ptr
  %yptr = inttoptr i64 %y to ptr
  call void @use_ptr(ptr %xptr)
  call void @use_ptr(ptr %yptr)
  %cmp = icmp ugt ptr %xptr, %yptr
  ret i1 %cmp
}

