; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv8.1m.main-none-none-eabi -mattr=+mve.fp,+fp64 -verify-machineinstrs %s -o - | FileCheck %s

; i32

define void @vld2_v2i32(ptr %src, ptr %dst) {
; CHECK-LABEL: vld2_v2i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vrev64.32 q1, q0
; CHECK-NEXT:    vmov r2, s2
; CHECK-NEXT:    vmov r0, s6
; CHECK-NEXT:    vmov r3, s0
; CHECK-NEXT:    add r0, r2
; CHECK-NEXT:    vmov r2, s4
; CHECK-NEXT:    add r2, r3
; CHECK-NEXT:    strd r2, r0, [r1]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <4 x i32>, ptr %src, align 4
  %s1 = shufflevector <4 x i32> %l1, <4 x i32> undef, <2 x i32> <i32 0, i32 2>
  %s2 = shufflevector <4 x i32> %l1, <4 x i32> undef, <2 x i32> <i32 1, i32 3>
  %a = add <2 x i32> %s1, %s2
  store <2 x i32> %a, ptr %dst
  ret void
}

define void @vld2_v4i32(ptr %src, ptr %dst) {
; CHECK-LABEL: vld2_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vld20.32 {q0, q1}, [r0]
; CHECK-NEXT:    vld21.32 {q0, q1}, [r0]
; CHECK-NEXT:    vadd.i32 q0, q0, q1
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <8 x i32>, ptr %src, align 4
  %s1 = shufflevector <8 x i32> %l1, <8 x i32> undef, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %s2 = shufflevector <8 x i32> %l1, <8 x i32> undef, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %a = add <4 x i32> %s1, %s2
  store <4 x i32> %a, ptr %dst
  ret void
}

define void @vld2_v8i32(ptr %src, ptr %dst) {
; CHECK-LABEL: vld2_v8i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vld20.32 {q0, q1}, [r0]
; CHECK-NEXT:    vld21.32 {q0, q1}, [r0]!
; CHECK-NEXT:    vld20.32 {q2, q3}, [r0]
; CHECK-NEXT:    vadd.i32 q0, q0, q1
; CHECK-NEXT:    vld21.32 {q2, q3}, [r0]
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    vadd.i32 q1, q2, q3
; CHECK-NEXT:    vstrw.32 q1, [r1, #16]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <16 x i32>, ptr %src, align 4
  %s1 = shufflevector <16 x i32> %l1, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %s2 = shufflevector <16 x i32> %l1, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %a = add <8 x i32> %s1, %s2
  store <8 x i32> %a, ptr %dst
  ret void
}

define void @vld2_v16i32(ptr %src, ptr %dst) {
; CHECK-LABEL: vld2_v16i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vld20.32 {q0, q1}, [r0]
; CHECK-NEXT:    add.w r2, r0, #96
; CHECK-NEXT:    add.w r3, r0, #64
; CHECK-NEXT:    vld20.32 {q3, q4}, [r2]
; CHECK-NEXT:    vld21.32 {q0, q1}, [r0]!
; CHECK-NEXT:    vld21.32 {q3, q4}, [r2]
; CHECK-NEXT:    vld20.32 {q5, q6}, [r0]
; CHECK-NEXT:    vadd.i32 q0, q0, q1
; CHECK-NEXT:    vld20.32 {q1, q2}, [r3]
; CHECK-NEXT:    vadd.i32 q3, q3, q4
; CHECK-NEXT:    vld21.32 {q5, q6}, [r0]
; CHECK-NEXT:    vld21.32 {q1, q2}, [r3]
; CHECK-NEXT:    vstrw.32 q3, [r1, #48]
; CHECK-NEXT:    vadd.i32 q5, q5, q6
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    vadd.i32 q1, q1, q2
; CHECK-NEXT:    vstrw.32 q5, [r1, #16]
; CHECK-NEXT:    vstrw.32 q1, [r1, #32]
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <32 x i32>, ptr %src, align 4
  %s1 = shufflevector <32 x i32> %l1, <32 x i32> undef, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
  %s2 = shufflevector <32 x i32> %l1, <32 x i32> undef, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
  %a = add <16 x i32> %s1, %s2
  store <16 x i32> %a, ptr %dst
  ret void
}

define void @vld2_v4i32_align1(ptr %src, ptr %dst) {
; CHECK-LABEL: vld2_v4i32_align1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrb.u8 q0, [r0, #16]
; CHECK-NEXT:    vldrb.u8 q1, [r0]
; CHECK-NEXT:    vmov.f32 s8, s5
; CHECK-NEXT:    vmov.f32 s9, s7
; CHECK-NEXT:    vmov.f32 s5, s6
; CHECK-NEXT:    vmov.f32 s10, s1
; CHECK-NEXT:    vmov.f32 s11, s3
; CHECK-NEXT:    vmov.f32 s6, s0
; CHECK-NEXT:    vmov.f32 s7, s2
; CHECK-NEXT:    vadd.i32 q0, q1, q2
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <8 x i32>, ptr %src, align 1
  %s1 = shufflevector <8 x i32> %l1, <8 x i32> undef, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %s2 = shufflevector <8 x i32> %l1, <8 x i32> undef, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %a = add <4 x i32> %s1, %s2
  store <4 x i32> %a, ptr %dst
  ret void
}

; i16

define void @vld2_v2i16(ptr %src, ptr %dst) {
; CHECK-LABEL: vld2_v2i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrh.u32 q0, [r0]
; CHECK-NEXT:    vrev64.32 q1, q0
; CHECK-NEXT:    vmov r2, s2
; CHECK-NEXT:    vmov r0, s6
; CHECK-NEXT:    add r0, r2
; CHECK-NEXT:    strh r0, [r1, #2]
; CHECK-NEXT:    vmov r0, s4
; CHECK-NEXT:    vmov r2, s0
; CHECK-NEXT:    add r0, r2
; CHECK-NEXT:    strh r0, [r1]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <4 x i16>, ptr %src, align 2
  %s1 = shufflevector <4 x i16> %l1, <4 x i16> undef, <2 x i32> <i32 0, i32 2>
  %s2 = shufflevector <4 x i16> %l1, <4 x i16> undef, <2 x i32> <i32 1, i32 3>
  %a = add <2 x i16> %s1, %s2
  store <2 x i16> %a, ptr %dst
  ret void
}

define void @vld2_v4i16(ptr %src, ptr %dst) {
; CHECK-LABEL: vld2_v4i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrh.u16 q0, [r0]
; CHECK-NEXT:    vrev32.16 q1, q0
; CHECK-NEXT:    vadd.i32 q0, q0, q1
; CHECK-NEXT:    vstrh.32 q0, [r1]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <8 x i16>, ptr %src, align 2
  %s1 = shufflevector <8 x i16> %l1, <8 x i16> undef, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %s2 = shufflevector <8 x i16> %l1, <8 x i16> undef, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %a = add <4 x i16> %s1, %s2
  store <4 x i16> %a, ptr %dst
  ret void
}

define void @vld2_v8i16(ptr %src, ptr %dst) {
; CHECK-LABEL: vld2_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vld20.16 {q0, q1}, [r0]
; CHECK-NEXT:    vld21.16 {q0, q1}, [r0]
; CHECK-NEXT:    vadd.i16 q0, q0, q1
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <16 x i16>, ptr %src, align 2
  %s1 = shufflevector <16 x i16> %l1, <16 x i16> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %s2 = shufflevector <16 x i16> %l1, <16 x i16> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %a = add <8 x i16> %s1, %s2
  store <8 x i16> %a, ptr %dst
  ret void
}

define void @vld2_v16i16(ptr %src, ptr %dst) {
; CHECK-LABEL: vld2_v16i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vld20.16 {q0, q1}, [r0]
; CHECK-NEXT:    vld21.16 {q0, q1}, [r0]!
; CHECK-NEXT:    vld20.16 {q2, q3}, [r0]
; CHECK-NEXT:    vadd.i16 q0, q0, q1
; CHECK-NEXT:    vld21.16 {q2, q3}, [r0]
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    vadd.i16 q1, q2, q3
; CHECK-NEXT:    vstrw.32 q1, [r1, #16]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <32 x i16>, ptr %src, align 2
  %s1 = shufflevector <32 x i16> %l1, <32 x i16> undef, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
  %s2 = shufflevector <32 x i16> %l1, <32 x i16> undef, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
  %a = add <16 x i16> %s1, %s2
  store <16 x i16> %a, ptr %dst
  ret void
}

define void @vld2_v8i16_align1(ptr %src, ptr %dst) {
; CHECK-LABEL: vld2_v8i16_align1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .pad #32
; CHECK-NEXT:    sub sp, #32
; CHECK-NEXT:    vldrb.u8 q0, [r0, #16]
; CHECK-NEXT:    add r2, sp, #16
; CHECK-NEXT:    vshr.u32 q1, q0, #16
; CHECK-NEXT:    vstrh.32 q1, [r2, #8]
; CHECK-NEXT:    vldrb.u8 q1, [r0]
; CHECK-NEXT:    mov r0, sp
; CHECK-NEXT:    vshr.u32 q2, q1, #16
; CHECK-NEXT:    vstrh.32 q2, [r2]
; CHECK-NEXT:    vstrh.32 q0, [r0, #8]
; CHECK-NEXT:    vstrh.32 q1, [r0]
; CHECK-NEXT:    vldrw.u32 q0, [r2]
; CHECK-NEXT:    vldrw.u32 q1, [r0]
; CHECK-NEXT:    vadd.i16 q0, q1, q0
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    add sp, #32
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <16 x i16>, ptr %src, align 1
  %s1 = shufflevector <16 x i16> %l1, <16 x i16> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %s2 = shufflevector <16 x i16> %l1, <16 x i16> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %a = add <8 x i16> %s1, %s2
  store <8 x i16> %a, ptr %dst
  ret void
}

; i8

define void @vld2_v2i8(ptr %src, ptr %dst) {
; CHECK-LABEL: vld2_v2i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrb.u32 q0, [r0]
; CHECK-NEXT:    vrev64.32 q1, q0
; CHECK-NEXT:    vmov r2, s2
; CHECK-NEXT:    vmov r0, s6
; CHECK-NEXT:    add r0, r2
; CHECK-NEXT:    strb r0, [r1, #1]
; CHECK-NEXT:    vmov r0, s4
; CHECK-NEXT:    vmov r2, s0
; CHECK-NEXT:    add r0, r2
; CHECK-NEXT:    strb r0, [r1]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <4 x i8>, ptr %src, align 1
  %s1 = shufflevector <4 x i8> %l1, <4 x i8> undef, <2 x i32> <i32 0, i32 2>
  %s2 = shufflevector <4 x i8> %l1, <4 x i8> undef, <2 x i32> <i32 1, i32 3>
  %a = add <2 x i8> %s1, %s2
  store <2 x i8> %a, ptr %dst
  ret void
}

define void @vld2_v4i8(ptr %src, ptr %dst) {
; CHECK-LABEL: vld2_v4i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrb.u16 q0, [r0]
; CHECK-NEXT:    vrev32.16 q1, q0
; CHECK-NEXT:    vadd.i32 q0, q0, q1
; CHECK-NEXT:    vstrb.32 q0, [r1]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <8 x i8>, ptr %src, align 1
  %s1 = shufflevector <8 x i8> %l1, <8 x i8> undef, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %s2 = shufflevector <8 x i8> %l1, <8 x i8> undef, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %a = add <4 x i8> %s1, %s2
  store <4 x i8> %a, ptr %dst
  ret void
}

define void @vld2_v8i8(ptr %src, ptr %dst) {
; CHECK-LABEL: vld2_v8i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrb.u8 q0, [r0]
; CHECK-NEXT:    vrev16.8 q1, q0
; CHECK-NEXT:    vadd.i16 q0, q0, q1
; CHECK-NEXT:    vstrb.16 q0, [r1]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <16 x i8>, ptr %src, align 1
  %s1 = shufflevector <16 x i8> %l1, <16 x i8> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %s2 = shufflevector <16 x i8> %l1, <16 x i8> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %a = add <8 x i8> %s1, %s2
  store <8 x i8> %a, ptr %dst
  ret void
}

define void @vld2_v16i8(ptr %src, ptr %dst) {
; CHECK-LABEL: vld2_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vld20.8 {q0, q1}, [r0]
; CHECK-NEXT:    vld21.8 {q0, q1}, [r0]
; CHECK-NEXT:    vadd.i8 q0, q0, q1
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <32 x i8>, ptr %src, align 1
  %s1 = shufflevector <32 x i8> %l1, <32 x i8> undef, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
  %s2 = shufflevector <32 x i8> %l1, <32 x i8> undef, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
  %a = add <16 x i8> %s1, %s2
  store <16 x i8> %a, ptr %dst
  ret void
}

; i64

define void @vld2_v2i64(ptr %src, ptr %dst) {
; CHECK-LABEL: vld2_v2i64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5, r6, lr}
; CHECK-NEXT:    push {r4, r5, r6, lr}
; CHECK-NEXT:    vldrw.u32 q0, [r0, #16]
; CHECK-NEXT:    vmov lr, r12, d1
; CHECK-NEXT:    vmov r3, r2, d0
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vmov r0, r4, d1
; CHECK-NEXT:    vmov r5, r6, d0
; CHECK-NEXT:    adds.w r3, r3, lr
; CHECK-NEXT:    adc.w r2, r2, r12
; CHECK-NEXT:    adds r0, r0, r5
; CHECK-NEXT:    adcs r6, r4
; CHECK-NEXT:    vmov q0[2], q0[0], r0, r3
; CHECK-NEXT:    vmov q0[3], q0[1], r6, r2
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    pop {r4, r5, r6, pc}
entry:
  %l1 = load <4 x i64>, ptr %src, align 8
  %s1 = shufflevector <4 x i64> %l1, <4 x i64> undef, <2 x i32> <i32 0, i32 2>
  %s2 = shufflevector <4 x i64> %l1, <4 x i64> undef, <2 x i32> <i32 1, i32 3>
  %a = add <2 x i64> %s1, %s2
  store <2 x i64> %a, ptr %dst
  ret void
}

define void @vld2_v4i64(ptr %src, ptr %dst) {
; CHECK-LABEL: vld2_v4i64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5, r6, r7, r8, lr}
; CHECK-NEXT:    push.w {r4, r5, r6, r7, r8, lr}
; CHECK-NEXT:    .vsave {d8}
; CHECK-NEXT:    vpush {d8}
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q3, [r0, #32]
; CHECK-NEXT:    vmov.f32 s4, s2
; CHECK-NEXT:    vmov.f32 s5, s3
; CHECK-NEXT:    vmov.f32 s2, s8
; CHECK-NEXT:    vmov.f32 s3, s9
; CHECK-NEXT:    vmov.f32 s16, s14
; CHECK-NEXT:    vmov.f32 s17, s15
; CHECK-NEXT:    vmov lr, r12, d5
; CHECK-NEXT:    vldrw.u32 q2, [r0, #48]
; CHECK-NEXT:    vmov r5, r6, d6
; CHECK-NEXT:    vmov r2, r3, d1
; CHECK-NEXT:    vmov.f32 s2, s8
; CHECK-NEXT:    vmov r0, r7, d8
; CHECK-NEXT:    vmov.f32 s3, s9
; CHECK-NEXT:    adds.w lr, lr, r2
; CHECK-NEXT:    adc.w r12, r12, r3
; CHECK-NEXT:    vmov r3, r4, d5
; CHECK-NEXT:    adds r0, r0, r5
; CHECK-NEXT:    adc.w r8, r6, r7
; CHECK-NEXT:    vmov r6, r5, d1
; CHECK-NEXT:    vmov r2, r7, d0
; CHECK-NEXT:    adds r3, r3, r6
; CHECK-NEXT:    adc.w r6, r5, r4
; CHECK-NEXT:    vmov r5, r4, d2
; CHECK-NEXT:    vmov q1[2], q1[0], r0, r3
; CHECK-NEXT:    vmov q1[3], q1[1], r8, r6
; CHECK-NEXT:    vstrw.32 q1, [r1, #16]
; CHECK-NEXT:    adds r2, r2, r5
; CHECK-NEXT:    vmov q0[2], q0[0], r2, lr
; CHECK-NEXT:    adc.w r0, r7, r4
; CHECK-NEXT:    vmov q0[3], q0[1], r0, r12
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    vpop {d8}
; CHECK-NEXT:    pop.w {r4, r5, r6, r7, r8, pc}
entry:
  %l1 = load <8 x i64>, ptr %src, align 8
  %s1 = shufflevector <8 x i64> %l1, <8 x i64> undef, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %s2 = shufflevector <8 x i64> %l1, <8 x i64> undef, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %a = add <4 x i64> %s1, %s2
  store <4 x i64> %a, ptr %dst
  ret void
}

; f32

define void @vld2_v2f32(ptr %src, ptr %dst) {
; CHECK-LABEL: vld2_v2f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vmov.f32 s4, s1
; CHECK-NEXT:    vmov.f32 s5, s3
; CHECK-NEXT:    vmov.f32 s1, s2
; CHECK-NEXT:    vadd.f32 q0, q0, q1
; CHECK-NEXT:    vstmia r1, {s0, s1}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <4 x float>, ptr %src, align 4
  %s1 = shufflevector <4 x float> %l1, <4 x float> undef, <2 x i32> <i32 0, i32 2>
  %s2 = shufflevector <4 x float> %l1, <4 x float> undef, <2 x i32> <i32 1, i32 3>
  %a = fadd <2 x float> %s1, %s2
  store <2 x float> %a, ptr %dst
  ret void
}

define void @vld2_v4f32(ptr %src, ptr %dst) {
; CHECK-LABEL: vld2_v4f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vld20.32 {q0, q1}, [r0]
; CHECK-NEXT:    vld21.32 {q0, q1}, [r0]
; CHECK-NEXT:    vadd.f32 q0, q0, q1
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <8 x float>, ptr %src, align 4
  %s1 = shufflevector <8 x float> %l1, <8 x float> undef, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %s2 = shufflevector <8 x float> %l1, <8 x float> undef, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %a = fadd <4 x float> %s1, %s2
  store <4 x float> %a, ptr %dst
  ret void
}

define void @vld2_v8f32(ptr %src, ptr %dst) {
; CHECK-LABEL: vld2_v8f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vld20.32 {q0, q1}, [r0]
; CHECK-NEXT:    vld21.32 {q0, q1}, [r0]!
; CHECK-NEXT:    vld20.32 {q2, q3}, [r0]
; CHECK-NEXT:    vadd.f32 q0, q0, q1
; CHECK-NEXT:    vld21.32 {q2, q3}, [r0]
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    vadd.f32 q1, q2, q3
; CHECK-NEXT:    vstrw.32 q1, [r1, #16]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <16 x float>, ptr %src, align 4
  %s1 = shufflevector <16 x float> %l1, <16 x float> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %s2 = shufflevector <16 x float> %l1, <16 x float> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %a = fadd <8 x float> %s1, %s2
  store <8 x float> %a, ptr %dst
  ret void
}

define void @vld2_v16f32(ptr %src, ptr %dst) {
; CHECK-LABEL: vld2_v16f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vld20.32 {q0, q1}, [r0]
; CHECK-NEXT:    add.w r2, r0, #96
; CHECK-NEXT:    add.w r3, r0, #64
; CHECK-NEXT:    vld20.32 {q3, q4}, [r2]
; CHECK-NEXT:    vld21.32 {q0, q1}, [r0]!
; CHECK-NEXT:    vld21.32 {q3, q4}, [r2]
; CHECK-NEXT:    vld20.32 {q5, q6}, [r0]
; CHECK-NEXT:    vadd.f32 q0, q0, q1
; CHECK-NEXT:    vld20.32 {q1, q2}, [r3]
; CHECK-NEXT:    vadd.f32 q3, q3, q4
; CHECK-NEXT:    vld21.32 {q5, q6}, [r0]
; CHECK-NEXT:    vld21.32 {q1, q2}, [r3]
; CHECK-NEXT:    vstrw.32 q3, [r1, #48]
; CHECK-NEXT:    vadd.f32 q5, q5, q6
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    vadd.f32 q1, q1, q2
; CHECK-NEXT:    vstrw.32 q5, [r1, #16]
; CHECK-NEXT:    vstrw.32 q1, [r1, #32]
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <32 x float>, ptr %src, align 4
  %s1 = shufflevector <32 x float> %l1, <32 x float> undef, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
  %s2 = shufflevector <32 x float> %l1, <32 x float> undef, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
  %a = fadd <16 x float> %s1, %s2
  store <16 x float> %a, ptr %dst
  ret void
}

define void @vld2_v4f32_align1(ptr %src, ptr %dst) {
; CHECK-LABEL: vld2_v4f32_align1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrb.u8 q0, [r0, #16]
; CHECK-NEXT:    vldrb.u8 q1, [r0]
; CHECK-NEXT:    vmov.f32 s8, s5
; CHECK-NEXT:    vmov.f32 s9, s7
; CHECK-NEXT:    vmov.f32 s5, s6
; CHECK-NEXT:    vmov.f32 s10, s1
; CHECK-NEXT:    vmov.f32 s11, s3
; CHECK-NEXT:    vmov.f32 s6, s0
; CHECK-NEXT:    vmov.f32 s7, s2
; CHECK-NEXT:    vadd.f32 q0, q1, q2
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <8 x float>, ptr %src, align 1
  %s1 = shufflevector <8 x float> %l1, <8 x float> undef, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %s2 = shufflevector <8 x float> %l1, <8 x float> undef, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %a = fadd <4 x float> %s1, %s2
  store <4 x float> %a, ptr %dst
  ret void
}

; f16

define void @vld2_v2f16(ptr %src, ptr %dst) {
; CHECK-LABEL: vld2_v2f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    ldr r2, [r0]
; CHECK-NEXT:    ldr r0, [r0, #4]
; CHECK-NEXT:    vmov.32 q0[0], r2
; CHECK-NEXT:    vmov q1, q0
; CHECK-NEXT:    vmov.32 q1[1], r0
; CHECK-NEXT:    vmovx.f16 s4, s0
; CHECK-NEXT:    vmovx.f16 s2, s5
; CHECK-NEXT:    vins.f16 s4, s2
; CHECK-NEXT:    vins.f16 s0, s5
; CHECK-NEXT:    vadd.f16 q0, q0, q1
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    str r0, [r1]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <4 x half>, ptr %src, align 2
  %s1 = shufflevector <4 x half> %l1, <4 x half> undef, <2 x i32> <i32 0, i32 2>
  %s2 = shufflevector <4 x half> %l1, <4 x half> undef, <2 x i32> <i32 1, i32 3>
  %a = fadd <2 x half> %s1, %s2
  store <2 x half> %a, ptr %dst
  ret void
}

define void @vld2_v4f16(ptr %src, ptr %dst) {
; CHECK-LABEL: vld2_v4f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrh.u16 q0, [r0]
; CHECK-NEXT:    vmovx.f16 s4, s0
; CHECK-NEXT:    vmovx.f16 s6, s1
; CHECK-NEXT:    vins.f16 s4, s6
; CHECK-NEXT:    vmovx.f16 s5, s2
; CHECK-NEXT:    vmovx.f16 s6, s3
; CHECK-NEXT:    vins.f16 s2, s3
; CHECK-NEXT:    vins.f16 s0, s1
; CHECK-NEXT:    vins.f16 s5, s6
; CHECK-NEXT:    vmov.f32 s1, s2
; CHECK-NEXT:    vadd.f16 q0, q0, q1
; CHECK-NEXT:    vmov r0, r2, d0
; CHECK-NEXT:    strd r0, r2, [r1]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <8 x half>, ptr %src, align 2
  %s1 = shufflevector <8 x half> %l1, <8 x half> undef, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %s2 = shufflevector <8 x half> %l1, <8 x half> undef, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %a = fadd <4 x half> %s1, %s2
  store <4 x half> %a, ptr %dst
  ret void
}

define void @vld2_v8f16(ptr %src, ptr %dst) {
; CHECK-LABEL: vld2_v8f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vld20.16 {q0, q1}, [r0]
; CHECK-NEXT:    vld21.16 {q0, q1}, [r0]
; CHECK-NEXT:    vadd.f16 q0, q0, q1
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <16 x half>, ptr %src, align 2
  %s1 = shufflevector <16 x half> %l1, <16 x half> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %s2 = shufflevector <16 x half> %l1, <16 x half> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %a = fadd <8 x half> %s1, %s2
  store <8 x half> %a, ptr %dst
  ret void
}

define void @vld2_v16f16(ptr %src, ptr %dst) {
; CHECK-LABEL: vld2_v16f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vld20.16 {q0, q1}, [r0]
; CHECK-NEXT:    vld21.16 {q0, q1}, [r0]!
; CHECK-NEXT:    vld20.16 {q2, q3}, [r0]
; CHECK-NEXT:    vadd.f16 q0, q0, q1
; CHECK-NEXT:    vld21.16 {q2, q3}, [r0]
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    vadd.f16 q2, q2, q3
; CHECK-NEXT:    vstrw.32 q2, [r1, #16]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <32 x half>, ptr %src, align 2
  %s1 = shufflevector <32 x half> %l1, <32 x half> undef, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
  %s2 = shufflevector <32 x half> %l1, <32 x half> undef, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
  %a = fadd <16 x half> %s1, %s2
  store <16 x half> %a, ptr %dst
  ret void
}

define void @vld2_v8f16_align1(ptr %src, ptr %dst) {
; CHECK-LABEL: vld2_v8f16_align1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrb.u8 q0, [r0]
; CHECK-NEXT:    vldrb.u8 q2, [r0, #16]
; CHECK-NEXT:    vmovx.f16 s4, s0
; CHECK-NEXT:    vmovx.f16 s6, s1
; CHECK-NEXT:    vins.f16 s4, s6
; CHECK-NEXT:    vmovx.f16 s5, s2
; CHECK-NEXT:    vmovx.f16 s6, s3
; CHECK-NEXT:    vmovx.f16 s12, s9
; CHECK-NEXT:    vins.f16 s5, s6
; CHECK-NEXT:    vmovx.f16 s6, s8
; CHECK-NEXT:    vins.f16 s6, s12
; CHECK-NEXT:    vmovx.f16 s7, s10
; CHECK-NEXT:    vmovx.f16 s12, s11
; CHECK-NEXT:    vins.f16 s2, s3
; CHECK-NEXT:    vins.f16 s10, s11
; CHECK-NEXT:    vins.f16 s8, s9
; CHECK-NEXT:    vins.f16 s0, s1
; CHECK-NEXT:    vmov.f32 s1, s2
; CHECK-NEXT:    vins.f16 s7, s12
; CHECK-NEXT:    vmov.f32 s2, s8
; CHECK-NEXT:    vmov.f32 s3, s10
; CHECK-NEXT:    vadd.f16 q0, q0, q1
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <16 x half>, ptr %src, align 1
  %s1 = shufflevector <16 x half> %l1, <16 x half> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %s2 = shufflevector <16 x half> %l1, <16 x half> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %a = fadd <8 x half> %s1, %s2
  store <8 x half> %a, ptr %dst
  ret void
}

; f64

define void @vld2_v2f64(ptr %src, ptr %dst) {
; CHECK-LABEL: vld2_v2f64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q0, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q1, [r0]
; CHECK-NEXT:    vadd.f64 d1, d0, d1
; CHECK-NEXT:    vadd.f64 d0, d2, d3
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <4 x double>, ptr %src, align 8
  %s1 = shufflevector <4 x double> %l1, <4 x double> undef, <2 x i32> <i32 0, i32 2>
  %s2 = shufflevector <4 x double> %l1, <4 x double> undef, <2 x i32> <i32 1, i32 3>
  %a = fadd <2 x double> %s1, %s2
  store <2 x double> %a, ptr %dst
  ret void
}

define void @vld2_v4f64(ptr %src, ptr %dst) {
; CHECK-LABEL: vld2_v4f64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q0, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q2, [r0]
; CHECK-NEXT:    vadd.f64 d1, d0, d1
; CHECK-NEXT:    vadd.f64 d0, d2, d3
; CHECK-NEXT:    vldrw.u32 q1, [r0, #16]
; CHECK-NEXT:    vadd.f64 d3, d2, d3
; CHECK-NEXT:    vstrw.32 q0, [r1, #16]
; CHECK-NEXT:    vadd.f64 d2, d4, d5
; CHECK-NEXT:    vstrw.32 q1, [r1]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <8 x double>, ptr %src, align 8
  %s1 = shufflevector <8 x double> %l1, <8 x double> undef, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %s2 = shufflevector <8 x double> %l1, <8 x double> undef, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %a = fadd <4 x double> %s1, %s2
  store <4 x double> %a, ptr %dst
  ret void
}
