; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s  -passes="print<cost-model>" 2>&1 -disable-output -mtriple=x86_64-apple-macosx10.8.0 -mattr=+sse2 | FileCheck %s --check-prefixes=SSE2
; RUN: opt < %s  -passes="print<cost-model>" 2>&1 -disable-output -mtriple=x86_64-apple-macosx10.8.0 -mattr=+sse4.1 | FileCheck %s --check-prefixes=SSE41
; RUN: opt < %s  -passes="print<cost-model>" 2>&1 -disable-output -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx  | FileCheck %s --check-prefixes=AVX
; RUN: opt < %s  -passes="print<cost-model>" 2>&1 -disable-output -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512bw | FileCheck %s --check-prefixes=AVX512

target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64-S128"
target triple = "x86_64-apple-macosx10.8.0"

define i32 @stores_align4(i32 %arg) {
  ; Scalars
; SSE2-LABEL: 'stores_align4'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i8 undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i16 undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i32 undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i64 undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store i128 undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store i256 undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store i512 undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store float undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store double undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store ptr undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i1 undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <128 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i16> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i32> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i64> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <1 x i128> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x float> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x double> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x ptr> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <256 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <32 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <16 x i16> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <8 x i32> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <4 x i64> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <2 x i128> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <1 x i256> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <8 x float> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <4 x double> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <4 x ptr> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <32 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <512 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <64 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <32 x i16> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <16 x i32> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <8 x i64> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <4 x i128> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <2 x i256> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <1 x i512> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <16 x float> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <8 x double> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <8 x ptr> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <64 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SSE41-LABEL: 'stores_align4'
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i8 undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i16 undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i32 undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i64 undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store i128 undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store i256 undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store i512 undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store float undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store double undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store ptr undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i1 undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <128 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i16> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i32> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i64> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <1 x i128> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x float> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x double> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x ptr> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <256 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <32 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <16 x i16> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <8 x i32> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <4 x i64> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <2 x i128> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <1 x i256> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <8 x float> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <4 x double> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <4 x ptr> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <32 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <512 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <64 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <32 x i16> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <16 x i32> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <8 x i64> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <4 x i128> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <2 x i256> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <1 x i512> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <16 x float> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <8 x double> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <8 x ptr> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <64 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX-LABEL: 'stores_align4'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i8 undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i16 undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i32 undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i64 undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store i128 undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store i256 undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store i512 undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store float undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store double undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store ptr undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i1 undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <128 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i16> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i32> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i64> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <1 x i128> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x float> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x double> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x ptr> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <256 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <32 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i16> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i32> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i64> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <2 x i128> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <1 x i256> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x float> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x double> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x ptr> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <32 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <512 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <64 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <32 x i16> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <16 x i32> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <8 x i64> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <4 x i128> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <2 x i256> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <1 x i512> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <16 x float> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <8 x double> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <8 x ptr> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <64 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512-LABEL: 'stores_align4'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i8 undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i16 undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i32 undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i64 undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store i128 undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store i256 undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store i512 undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store float undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store double undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store ptr undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i1 undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <128 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i16> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i32> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i64> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <1 x i128> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x float> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x double> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x ptr> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <256 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <32 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i16> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i32> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i64> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <2 x i128> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <1 x i256> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x float> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x double> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x ptr> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <32 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <512 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <64 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <32 x i16> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i32> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i64> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <4 x i128> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <2 x i256> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <1 x i512> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x float> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x double> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x ptr> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <64 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  store i8 undef, ptr undef, align 4
  store i16 undef, ptr undef, align 4
  store i32 undef, ptr undef, align 4
  store i64 undef, ptr undef, align 4
  store i128 undef, ptr undef, align 4
  store i256 undef, ptr undef, align 4
  store i512 undef, ptr undef, align 4

  store float undef, ptr undef, align 4
  store double undef, ptr undef, align 4

  store ptr undef, ptr undef, align 4

  store i1 undef, ptr undef, align 4

  ; XMM (128-bit) vectors
  store <128 x i1> undef, ptr undef, align 4
  store <16 x i8> undef, ptr undef, align 4
  store <8 x i16> undef, ptr undef, align 4
  store <4 x i32> undef, ptr undef, align 4
  store <2 x i64> undef, ptr undef, align 4
  store <1 x i128> undef, ptr undef, align 4

  store <4 x float> undef, ptr undef, align 4
  store <2 x double> undef, ptr undef, align 4

  store <2 x ptr> undef, ptr undef, align 4

  store <16 x i1> undef, ptr undef, align 4
  store <8 x i1> undef, ptr undef, align 4
  store <4 x i1> undef, ptr undef, align 4
  store <2 x i1> undef, ptr undef, align 4
  store <1 x i1> undef, ptr undef, align 4

  ; YMM (256-bit) vectors
  store <256 x i1> undef, ptr undef, align 4
  store <32 x i8> undef, ptr undef, align 4
  store <16 x i16> undef, ptr undef, align 4
  store <8 x i32> undef, ptr undef, align 4
  store <4 x i64> undef, ptr undef, align 4
  store <2 x i128> undef, ptr undef, align 4
  store <1 x i256> undef, ptr undef, align 4

  store <8 x float> undef, ptr undef, align 4
  store <4 x double> undef, ptr undef, align 4

  store <4 x ptr> undef, ptr undef, align 4

  store <32 x i1> undef, ptr undef, align 4

  ; ZMM (512-bit) vectors
  store <512 x i1> undef, ptr undef, align 4
  store <64 x i8> undef, ptr undef, align 4
  store <32 x i16> undef, ptr undef, align 4
  store <16 x i32> undef, ptr undef, align 4
  store <8 x i64> undef, ptr undef, align 4
  store <4 x i128> undef, ptr undef, align 4
  store <2 x i256> undef, ptr undef, align 4
  store <1 x i512> undef, ptr undef, align 4

  store <16 x float> undef, ptr undef, align 4
  store <8 x double> undef, ptr undef, align 4

  store <8 x ptr> undef, ptr undef, align 4

  store <64 x i1> undef, ptr undef, align 4

  ret i32 undef
}

define i32 @stores_partial_align4(i32 %arg) {
  ; Partial vectors with i64 elements (doubles as pointer-sized tests))
; SSE2-LABEL: 'stores_partial_align4'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i64> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <3 x i64> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x i64> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i64> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <7 x i64> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x double> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <3 x double> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x double> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x double> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <7 x double> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i32> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i32> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <3 x i32> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <5 x i32> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <6 x i32> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x i32> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x i32> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x i32> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <11 x i32> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i32> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <13 x i32> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <14 x i32> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <15 x i32> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x float> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x float> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x float> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <5 x float> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <6 x float> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <7 x float> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x float> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x float> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <11 x float> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x float> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <13 x float> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <14 x float> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <15 x float> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i16> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i16> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i16> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i16> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x i16> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <6 x i16> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <7 x i16> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <9 x i16> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <10 x i16> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <11 x i16> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <12 x i16> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <13 x i16> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <14 x i16> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <15 x i16> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <17 x i16> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <18 x i16> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <19 x i16> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <20 x i16> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <21 x i16> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <22 x i16> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <23 x i16> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <24 x i16> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <25 x i16> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <26 x i16> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <27 x i16> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <28 x i16> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <29 x i16> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <30 x i16> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <31 x i16> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <3 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <5 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <7 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <9 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <11 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <12 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <13 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <14 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <15 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <17 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <18 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <19 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <20 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <21 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <22 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <23 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <24 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <25 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <26 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <27 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <28 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <29 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <30 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: store <31 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <33 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <34 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <35 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <36 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <37 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <38 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <39 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <40 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <41 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <42 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <43 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <44 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <45 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <46 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: store <47 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <48 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <49 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <50 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <51 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <52 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <53 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <54 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <55 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <56 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <57 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <58 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <59 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <60 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: store <61 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <62 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: store <63 x i8> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <3 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <5 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <6 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <7 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <9 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <10 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <11 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <12 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <13 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <14 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <15 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <17 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <18 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <19 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <20 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <21 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <22 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <23 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <24 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <25 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <26 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <27 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <28 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <29 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <30 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <31 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <33 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <34 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <35 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <36 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <37 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <38 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <39 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <40 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <41 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <42 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <43 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <44 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <45 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <46 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <47 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <48 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <49 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <50 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <51 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <52 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <53 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <54 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <55 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <56 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <57 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <58 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <59 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <60 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <61 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <62 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <63 x i1> undef, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SSE41-LABEL: 'stores_partial_align4'
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i64> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <3 x i64> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x i64> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i64> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <7 x i64> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x double> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <3 x double> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x double> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x double> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <7 x double> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i32> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i32> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i32> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <5 x i32> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <6 x i32> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <7 x i32> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x i32> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x i32> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <11 x i32> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i32> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <13 x i32> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <14 x i32> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <15 x i32> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x float> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x float> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x float> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <5 x float> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <6 x float> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <7 x float> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x float> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x float> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <11 x float> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x float> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <13 x float> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <14 x float> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <15 x float> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i16> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i16> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i16> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i16> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x i16> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i16> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x i16> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <9 x i16> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <10 x i16> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <11 x i16> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <12 x i16> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <13 x i16> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <14 x i16> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <15 x i16> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <17 x i16> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <18 x i16> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <19 x i16> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <20 x i16> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <21 x i16> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <22 x i16> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <23 x i16> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <24 x i16> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <25 x i16> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <26 x i16> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <27 x i16> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <28 x i16> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <29 x i16> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <30 x i16> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <31 x i16> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <11 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <13 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <14 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <15 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <17 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <18 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <19 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <20 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <21 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <22 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <23 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <24 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <25 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <26 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <27 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <28 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <29 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <30 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <31 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <33 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <34 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <35 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <36 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <37 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <38 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <39 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <40 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <41 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <42 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <43 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <44 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <45 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <46 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <47 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <48 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <49 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <50 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <51 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <52 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <53 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <54 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <55 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <56 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <57 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <58 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <59 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <60 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <61 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <62 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: store <63 x i8> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <3 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <5 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <6 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <7 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <11 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <13 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <14 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <15 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <17 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <18 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <19 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <20 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <21 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <22 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <23 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <24 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <25 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <26 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <27 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <28 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <29 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <30 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <31 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <33 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <34 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <35 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <36 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <37 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <38 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <39 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <40 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <41 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <42 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <43 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <44 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <45 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <46 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <47 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <48 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <49 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <50 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <51 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <52 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <53 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <54 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <55 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <56 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <57 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <58 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <59 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <60 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <61 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <62 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <63 x i1> undef, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX-LABEL: 'stores_partial_align4'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i64> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i64> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <5 x i64> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <6 x i64> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <7 x i64> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x double> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x double> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <5 x double> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <6 x double> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <7 x double> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i32> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i32> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i32> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <5 x i32> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i32> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x i32> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <9 x i32> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <10 x i32> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <11 x i32> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <12 x i32> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <13 x i32> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <14 x i32> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <15 x i32> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x float> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x float> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x float> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x float> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x float> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x float> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <9 x float> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <10 x float> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <11 x float> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <12 x float> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <13 x float> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <14 x float> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <15 x float> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i16> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i16> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i16> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i16> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x i16> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i16> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x i16> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <9 x i16> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <10 x i16> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <11 x i16> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i16> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <13 x i16> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <14 x i16> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <15 x i16> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <17 x i16> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <18 x i16> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <19 x i16> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <20 x i16> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <21 x i16> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <22 x i16> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <23 x i16> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <24 x i16> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <25 x i16> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <26 x i16> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <27 x i16> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <28 x i16> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <29 x i16> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <30 x i16> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <31 x i16> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <11 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <13 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <14 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <15 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <17 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <18 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <19 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <20 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <21 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <22 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <23 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <24 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <25 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <26 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <27 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <28 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <29 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <30 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <31 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <33 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <34 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <35 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <36 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <37 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <38 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <39 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <40 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <41 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <42 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <43 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <44 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <45 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <46 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <47 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <48 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <49 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <50 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <51 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <52 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <53 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <54 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <55 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <56 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <57 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <58 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <59 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <60 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <61 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <62 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: store <63 x i8> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <3 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <5 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <6 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <7 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <11 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <13 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <14 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <15 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <17 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <18 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <19 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <20 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <21 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <22 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <23 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <24 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <25 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <26 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <27 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <28 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <29 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <30 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <31 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <33 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <34 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <35 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <36 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <37 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <38 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <39 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <40 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <41 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <42 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <43 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <44 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <45 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <46 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <47 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <48 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <49 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <50 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <51 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <52 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <53 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <54 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <55 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <56 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <57 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <58 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <59 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <60 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <61 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <62 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <63 x i1> undef, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512-LABEL: 'stores_partial_align4'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i64> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i64> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x i64> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i64> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x i64> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x double> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x double> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x double> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x double> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x double> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i32> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i32> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i32> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <5 x i32> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i32> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x i32> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <9 x i32> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x i32> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <11 x i32> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i32> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <13 x i32> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <14 x i32> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <15 x i32> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x float> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x float> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x float> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x float> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x float> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x float> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x float> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x float> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <11 x float> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x float> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <13 x float> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <14 x float> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <15 x float> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i16> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i16> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i16> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i16> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x i16> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i16> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x i16> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <9 x i16> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <10 x i16> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <11 x i16> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i16> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <13 x i16> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <14 x i16> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <15 x i16> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <17 x i16> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <18 x i16> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <19 x i16> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <20 x i16> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <21 x i16> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <22 x i16> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <23 x i16> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <24 x i16> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <25 x i16> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <26 x i16> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <27 x i16> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <28 x i16> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <29 x i16> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <30 x i16> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <31 x i16> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <11 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <13 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <14 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <15 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <17 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <18 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <19 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <20 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <21 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <22 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <23 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <24 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <25 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <26 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <27 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <28 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <29 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <30 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <31 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <33 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <34 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <35 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <36 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <37 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <38 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <39 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <40 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <41 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <42 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <43 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <44 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <45 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <46 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <47 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <48 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <49 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <50 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <51 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <52 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <53 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <54 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: store <55 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <56 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <57 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <58 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <59 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <60 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <61 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <62 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: store <63 x i8> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <3 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <5 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <6 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <7 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <11 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <13 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <14 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <15 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <17 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <18 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <19 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <20 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <21 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <22 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <23 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <24 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <25 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <26 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <27 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <28 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <29 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <30 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <31 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <33 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <34 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <35 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <36 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <37 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <38 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <39 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <40 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <41 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <42 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <43 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <44 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <45 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <46 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <47 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <48 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <49 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <50 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <51 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <52 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <53 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <54 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <55 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <56 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <57 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <58 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <59 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <60 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <61 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <62 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <63 x i1> undef, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  store <1 x i64> undef, ptr undef, align 4
  ; <2 x i64> is XMM
  store <3 x i64> undef, ptr undef, align 4
  ; <4 x i64> is YMM
  store <5 x i64> undef, ptr undef, align 4
  store <6 x i64> undef, ptr undef, align 4
  store <7 x i64> undef, ptr undef, align 4
  ; <8 x i64> is ZMM

  ; Partial vectors with double elements
  store <1 x double> undef, ptr undef, align 4
  ; <2 x double> is XMM
  store <3 x double> undef, ptr undef, align 4
  ; <4 x double> is YMM
  store <5 x double> undef, ptr undef, align 4
  store <6 x double> undef, ptr undef, align 4
  store <7 x double> undef, ptr undef, align 4
  ; <8 x double> is ZMM

  ; Partial vectors with i32 elements
  store <1 x i32> undef, ptr undef, align 4
  store <2 x i32> undef, ptr undef, align 4
  store <3 x i32> undef, ptr undef, align 4
  ; <4 x i32> is XMM
  store <5 x i32> undef, ptr undef, align 4
  store <6 x i32> undef, ptr undef, align 4
  store <7 x i32> undef, ptr undef, align 4
  ; <8 x i32> is YMM
  store <9 x i32> undef, ptr undef, align 4
  store <10 x i32> undef, ptr undef, align 4
  store <11 x i32> undef, ptr undef, align 4
  store <12 x i32> undef, ptr undef, align 4
  store <13 x i32> undef, ptr undef, align 4
  store <14 x i32> undef, ptr undef, align 4
  store <15 x i32> undef, ptr undef, align 4
  ; <16 x i32> is ZMM

  ; Partial vectors with float elements
  store <1 x float> undef, ptr undef, align 4
  store <2 x float> undef, ptr undef, align 4
  store <3 x float> undef, ptr undef, align 4
  ; <4 x float> is XMM
  store <5 x float> undef, ptr undef, align 4
  store <6 x float> undef, ptr undef, align 4
  store <7 x float> undef, ptr undef, align 4
  ; <8 x float> is YMM
  store <9 x float> undef, ptr undef, align 4
  store <10 x float> undef, ptr undef, align 4
  store <11 x float> undef, ptr undef, align 4
  store <12 x float> undef, ptr undef, align 4
  store <13 x float> undef, ptr undef, align 4
  store <14 x float> undef, ptr undef, align 4
  store <15 x float> undef, ptr undef, align 4
  ; <16 x float> is ZMM

  ; Partial vectors with i16 elements
  store <1 x i16> undef, ptr undef, align 4
  store <2 x i16> undef, ptr undef, align 4
  store <3 x i16> undef, ptr undef, align 4
  store <4 x i16> undef, ptr undef, align 4
  store <5 x i16> undef, ptr undef, align 4
  store <6 x i16> undef, ptr undef, align 4
  store <7 x i16> undef, ptr undef, align 4
  ; <8 x i16> is XMM
  store <9 x i16> undef, ptr undef, align 4
  store <10 x i16> undef, ptr undef, align 4
  store <11 x i16> undef, ptr undef, align 4
  store <12 x i16> undef, ptr undef, align 4
  store <13 x i16> undef, ptr undef, align 4
  store <14 x i16> undef, ptr undef, align 4
  store <15 x i16> undef, ptr undef, align 4
  ; <16 x i16> is YMM
  store <17 x i16> undef, ptr undef, align 4
  store <18 x i16> undef, ptr undef, align 4
  store <19 x i16> undef, ptr undef, align 4
  store <20 x i16> undef, ptr undef, align 4
  store <21 x i16> undef, ptr undef, align 4
  store <22 x i16> undef, ptr undef, align 4
  store <23 x i16> undef, ptr undef, align 4
  store <24 x i16> undef, ptr undef, align 4
  store <25 x i16> undef, ptr undef, align 4
  store <26 x i16> undef, ptr undef, align 4
  store <27 x i16> undef, ptr undef, align 4
  store <28 x i16> undef, ptr undef, align 4
  store <29 x i16> undef, ptr undef, align 4
  store <30 x i16> undef, ptr undef, align 4
  store <31 x i16> undef, ptr undef, align 4
  ; <32 x i16> is ZMM

  ; Partial vectors with i8 elements
  store <1 x i8> undef, ptr undef, align 4
  store <2 x i8> undef, ptr undef, align 4
  store <3 x i8> undef, ptr undef, align 4
  store <4 x i8> undef, ptr undef, align 4
  store <5 x i8> undef, ptr undef, align 4
  store <6 x i8> undef, ptr undef, align 4
  store <7 x i8> undef, ptr undef, align 4
  store <8 x i8> undef, ptr undef, align 4
  store <9 x i8> undef, ptr undef, align 4
  store <10 x i8> undef, ptr undef, align 4
  store <11 x i8> undef, ptr undef, align 4
  store <12 x i8> undef, ptr undef, align 4
  store <13 x i8> undef, ptr undef, align 4
  store <14 x i8> undef, ptr undef, align 4
  store <15 x i8> undef, ptr undef, align 4
  ; <16 x i8> is XMM
  store <17 x i8> undef, ptr undef, align 4
  store <18 x i8> undef, ptr undef, align 4
  store <19 x i8> undef, ptr undef, align 4
  store <20 x i8> undef, ptr undef, align 4
  store <21 x i8> undef, ptr undef, align 4
  store <22 x i8> undef, ptr undef, align 4
  store <23 x i8> undef, ptr undef, align 4
  store <24 x i8> undef, ptr undef, align 4
  store <25 x i8> undef, ptr undef, align 4
  store <26 x i8> undef, ptr undef, align 4
  store <27 x i8> undef, ptr undef, align 4
  store <28 x i8> undef, ptr undef, align 4
  store <29 x i8> undef, ptr undef, align 4
  store <30 x i8> undef, ptr undef, align 4
  store <31 x i8> undef, ptr undef, align 4
  ; <32 x i8> is YMM
  store <33 x i8> undef, ptr undef, align 4
  store <34 x i8> undef, ptr undef, align 4
  store <35 x i8> undef, ptr undef, align 4
  store <36 x i8> undef, ptr undef, align 4
  store <37 x i8> undef, ptr undef, align 4
  store <38 x i8> undef, ptr undef, align 4
  store <39 x i8> undef, ptr undef, align 4
  store <40 x i8> undef, ptr undef, align 4
  store <41 x i8> undef, ptr undef, align 4
  store <42 x i8> undef, ptr undef, align 4
  store <43 x i8> undef, ptr undef, align 4
  store <44 x i8> undef, ptr undef, align 4
  store <45 x i8> undef, ptr undef, align 4
  store <46 x i8> undef, ptr undef, align 4
  store <47 x i8> undef, ptr undef, align 4
  store <48 x i8> undef, ptr undef, align 4
  store <49 x i8> undef, ptr undef, align 4
  store <50 x i8> undef, ptr undef, align 4
  store <51 x i8> undef, ptr undef, align 4
  store <52 x i8> undef, ptr undef, align 4
  store <53 x i8> undef, ptr undef, align 4
  store <54 x i8> undef, ptr undef, align 4
  store <55 x i8> undef, ptr undef, align 4
  store <56 x i8> undef, ptr undef, align 4
  store <57 x i8> undef, ptr undef, align 4
  store <58 x i8> undef, ptr undef, align 4
  store <59 x i8> undef, ptr undef, align 4
  store <60 x i8> undef, ptr undef, align 4
  store <61 x i8> undef, ptr undef, align 4
  store <62 x i8> undef, ptr undef, align 4
  store <63 x i8> undef, ptr undef, align 4
  ; <64 x i8> is ZMM

  ; Partial vectors with i1 elements
  ; <1 x i1> is XMM
  ; <2 x i1> is XMM
  store <3 x i1> undef, ptr undef, align 4
  ; <4 x i1> is XMM
  store <5 x i1> undef, ptr undef, align 4
  store <6 x i1> undef, ptr undef, align 4
  store <7 x i1> undef, ptr undef, align 4
  ; <8 x i1> is XMM
  store <9 x i1> undef, ptr undef, align 4
  store <10 x i1> undef, ptr undef, align 4
  store <11 x i1> undef, ptr undef, align 4
  store <12 x i1> undef, ptr undef, align 4
  store <13 x i1> undef, ptr undef, align 4
  store <14 x i1> undef, ptr undef, align 4
  store <15 x i1> undef, ptr undef, align 4
  ; <16 x i1> is XMM
  store <17 x i1> undef, ptr undef, align 4
  store <18 x i1> undef, ptr undef, align 4
  store <19 x i1> undef, ptr undef, align 4
  store <20 x i1> undef, ptr undef, align 4
  store <21 x i1> undef, ptr undef, align 4
  store <22 x i1> undef, ptr undef, align 4
  store <23 x i1> undef, ptr undef, align 4
  store <24 x i1> undef, ptr undef, align 4
  store <25 x i1> undef, ptr undef, align 4
  store <26 x i1> undef, ptr undef, align 4
  store <27 x i1> undef, ptr undef, align 4
  store <28 x i1> undef, ptr undef, align 4
  store <29 x i1> undef, ptr undef, align 4
  store <30 x i1> undef, ptr undef, align 4
  store <31 x i1> undef, ptr undef, align 4
  ; <32 x i1> is YMM
  store <33 x i1> undef, ptr undef, align 4
  store <34 x i1> undef, ptr undef, align 4
  store <35 x i1> undef, ptr undef, align 4
  store <36 x i1> undef, ptr undef, align 4
  store <37 x i1> undef, ptr undef, align 4
  store <38 x i1> undef, ptr undef, align 4
  store <39 x i1> undef, ptr undef, align 4
  store <40 x i1> undef, ptr undef, align 4
  store <41 x i1> undef, ptr undef, align 4
  store <42 x i1> undef, ptr undef, align 4
  store <43 x i1> undef, ptr undef, align 4
  store <44 x i1> undef, ptr undef, align 4
  store <45 x i1> undef, ptr undef, align 4
  store <46 x i1> undef, ptr undef, align 4
  store <47 x i1> undef, ptr undef, align 4
  store <48 x i1> undef, ptr undef, align 4
  store <49 x i1> undef, ptr undef, align 4
  store <50 x i1> undef, ptr undef, align 4
  store <51 x i1> undef, ptr undef, align 4
  store <52 x i1> undef, ptr undef, align 4
  store <53 x i1> undef, ptr undef, align 4
  store <54 x i1> undef, ptr undef, align 4
  store <55 x i1> undef, ptr undef, align 4
  store <56 x i1> undef, ptr undef, align 4
  store <57 x i1> undef, ptr undef, align 4
  store <58 x i1> undef, ptr undef, align 4
  store <59 x i1> undef, ptr undef, align 4
  store <60 x i1> undef, ptr undef, align 4
  store <61 x i1> undef, ptr undef, align 4
  store <62 x i1> undef, ptr undef, align 4
  store <63 x i1> undef, ptr undef, align 4
  ; <64 x i1> is ZMM

  ret i32 undef
}

define i32 @stores_align1(i32 %arg) {
  ; Scalars
; SSE2-LABEL: 'stores_align1'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i8 undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i16 undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i32 undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i64 undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store i128 undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store i256 undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store i512 undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store float undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store double undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store ptr undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i1 undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <128 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i16> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i32> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i64> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <1 x i128> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x float> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x double> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x ptr> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <256 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <32 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <16 x i16> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <8 x i32> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <4 x i64> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <2 x i128> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <1 x i256> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <8 x float> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <4 x double> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <4 x ptr> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <32 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <512 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <64 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <32 x i16> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <16 x i32> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <8 x i64> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <4 x i128> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <2 x i256> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <1 x i512> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <16 x float> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <8 x double> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <8 x ptr> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <64 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SSE41-LABEL: 'stores_align1'
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i8 undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i16 undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i32 undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i64 undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store i128 undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store i256 undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store i512 undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store float undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store double undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store ptr undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i1 undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <128 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i16> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i32> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i64> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <1 x i128> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x float> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x double> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x ptr> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <256 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <32 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <16 x i16> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <8 x i32> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <4 x i64> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <2 x i128> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <1 x i256> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <8 x float> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <4 x double> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <4 x ptr> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <32 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <512 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <64 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <32 x i16> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <16 x i32> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <8 x i64> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <4 x i128> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <2 x i256> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <1 x i512> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <16 x float> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <8 x double> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <8 x ptr> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <64 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX-LABEL: 'stores_align1'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i8 undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i16 undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i32 undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i64 undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store i128 undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store i256 undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store i512 undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store float undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store double undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store ptr undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i1 undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <128 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i16> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i32> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i64> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <1 x i128> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x float> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x double> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x ptr> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <256 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <32 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i16> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i32> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i64> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <2 x i128> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <1 x i256> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x float> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x double> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x ptr> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <32 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <512 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <64 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <32 x i16> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <16 x i32> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <8 x i64> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <4 x i128> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <2 x i256> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <1 x i512> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <16 x float> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <8 x double> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <8 x ptr> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <64 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512-LABEL: 'stores_align1'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i8 undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i16 undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i32 undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i64 undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store i128 undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store i256 undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store i512 undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store float undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store double undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store ptr undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i1 undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <128 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i16> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i32> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i64> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <1 x i128> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x float> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x double> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x ptr> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <256 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <32 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i16> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i32> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i64> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <2 x i128> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <1 x i256> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x float> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x double> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x ptr> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <32 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <512 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <64 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <32 x i16> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i32> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i64> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <4 x i128> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <2 x i256> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <1 x i512> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x float> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x double> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x ptr> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <64 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  store i8 undef, ptr undef, align 1
  store i16 undef, ptr undef, align 1
  store i32 undef, ptr undef, align 1
  store i64 undef, ptr undef, align 1
  store i128 undef, ptr undef, align 1
  store i256 undef, ptr undef, align 1
  store i512 undef, ptr undef, align 1

  store float undef, ptr undef, align 1
  store double undef, ptr undef, align 1

  store ptr undef, ptr undef, align 1

  store i1 undef, ptr undef, align 1

  ; XMM (128-bit) vectors
  store <128 x i1> undef, ptr undef, align 1
  store <16 x i8> undef, ptr undef, align 1
  store <8 x i16> undef, ptr undef, align 1
  store <4 x i32> undef, ptr undef, align 1
  store <2 x i64> undef, ptr undef, align 1
  store <1 x i128> undef, ptr undef, align 1

  store <4 x float> undef, ptr undef, align 1
  store <2 x double> undef, ptr undef, align 1

  store <2 x ptr> undef, ptr undef, align 1

  store <16 x i1> undef, ptr undef, align 1
  store <8 x i1> undef, ptr undef, align 1
  store <4 x i1> undef, ptr undef, align 1
  store <2 x i1> undef, ptr undef, align 1
  store <1 x i1> undef, ptr undef, align 1

  ; YMM (256-bit) vectors
  store <256 x i1> undef, ptr undef, align 1
  store <32 x i8> undef, ptr undef, align 1
  store <16 x i16> undef, ptr undef, align 1
  store <8 x i32> undef, ptr undef, align 1
  store <4 x i64> undef, ptr undef, align 1
  store <2 x i128> undef, ptr undef, align 1
  store <1 x i256> undef, ptr undef, align 1

  store <8 x float> undef, ptr undef, align 1
  store <4 x double> undef, ptr undef, align 1

  store <4 x ptr> undef, ptr undef, align 1

  store <32 x i1> undef, ptr undef, align 1

  ; ZMM (512-bit) vectors
  store <512 x i1> undef, ptr undef, align 1
  store <64 x i8> undef, ptr undef, align 1
  store <32 x i16> undef, ptr undef, align 1
  store <16 x i32> undef, ptr undef, align 1
  store <8 x i64> undef, ptr undef, align 1
  store <4 x i128> undef, ptr undef, align 1
  store <2 x i256> undef, ptr undef, align 1
  store <1 x i512> undef, ptr undef, align 1

  store <16 x float> undef, ptr undef, align 1
  store <8 x double> undef, ptr undef, align 1

  store <8 x ptr> undef, ptr undef, align 1

  store <64 x i1> undef, ptr undef, align 1

  ret i32 undef
}

define i32 @stores_partial_align1(i32 %arg) {
  ; Partial vectors with i64 elements (doubles as pointer-sized tests))
; SSE2-LABEL: 'stores_partial_align1'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i64> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <3 x i64> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x i64> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i64> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <7 x i64> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x double> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <3 x double> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x double> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x double> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <7 x double> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i32> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i32> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <3 x i32> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <5 x i32> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <6 x i32> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x i32> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x i32> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x i32> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <11 x i32> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i32> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <13 x i32> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <14 x i32> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <15 x i32> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x float> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x float> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x float> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <5 x float> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <6 x float> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <7 x float> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x float> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x float> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <11 x float> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x float> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <13 x float> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <14 x float> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <15 x float> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i16> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i16> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i16> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i16> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x i16> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <6 x i16> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <7 x i16> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <9 x i16> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <10 x i16> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <11 x i16> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <12 x i16> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <13 x i16> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <14 x i16> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <15 x i16> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <17 x i16> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <18 x i16> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <19 x i16> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <20 x i16> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <21 x i16> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <22 x i16> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <23 x i16> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <24 x i16> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <25 x i16> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <26 x i16> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <27 x i16> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <28 x i16> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <29 x i16> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <30 x i16> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <31 x i16> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <3 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <5 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <7 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <9 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <11 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <12 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <13 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <14 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <15 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <17 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <18 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <19 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <20 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <21 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <22 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <23 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <24 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <25 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <26 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <27 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <28 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <29 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <30 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: store <31 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <33 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <34 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <35 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <36 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <37 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <38 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <39 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <40 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <41 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <42 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <43 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <44 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <45 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <46 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: store <47 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <48 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <49 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <50 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <51 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <52 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <53 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <54 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <55 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <56 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <57 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <58 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <59 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <60 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: store <61 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <62 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: store <63 x i8> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <3 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <5 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <6 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <7 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <9 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <10 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <11 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <12 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <13 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <14 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <15 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <17 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <18 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <19 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <20 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <21 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <22 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <23 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <24 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <25 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <26 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <27 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <28 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <29 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <30 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <31 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <33 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <34 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <35 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <36 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <37 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <38 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <39 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <40 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <41 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <42 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <43 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <44 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <45 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <46 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <47 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <48 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <49 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <50 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <51 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <52 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <53 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <54 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <55 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <56 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <57 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <58 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <59 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <60 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <61 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <62 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <63 x i1> undef, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SSE41-LABEL: 'stores_partial_align1'
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i64> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <3 x i64> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x i64> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i64> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <7 x i64> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x double> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <3 x double> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x double> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x double> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <7 x double> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i32> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i32> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i32> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <5 x i32> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <6 x i32> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <7 x i32> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x i32> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x i32> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <11 x i32> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i32> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <13 x i32> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <14 x i32> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <15 x i32> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x float> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x float> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x float> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <5 x float> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <6 x float> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <7 x float> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x float> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x float> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <11 x float> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x float> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <13 x float> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <14 x float> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <15 x float> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i16> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i16> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i16> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i16> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x i16> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i16> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x i16> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <9 x i16> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <10 x i16> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <11 x i16> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <12 x i16> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <13 x i16> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <14 x i16> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <15 x i16> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <17 x i16> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <18 x i16> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <19 x i16> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <20 x i16> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <21 x i16> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <22 x i16> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <23 x i16> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <24 x i16> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <25 x i16> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <26 x i16> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <27 x i16> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <28 x i16> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <29 x i16> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <30 x i16> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <31 x i16> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <11 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <13 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <14 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <15 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <17 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <18 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <19 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <20 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <21 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <22 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <23 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <24 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <25 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <26 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <27 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <28 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <29 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <30 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <31 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <33 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <34 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <35 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <36 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <37 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <38 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <39 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <40 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <41 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <42 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <43 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <44 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <45 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <46 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <47 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <48 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <49 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <50 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <51 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <52 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <53 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <54 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <55 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <56 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <57 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <58 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <59 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <60 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <61 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <62 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: store <63 x i8> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <3 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <5 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <6 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <7 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <11 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <13 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <14 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <15 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <17 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <18 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <19 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <20 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <21 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <22 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <23 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <24 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <25 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <26 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <27 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <28 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <29 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <30 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <31 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <33 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <34 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <35 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <36 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <37 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <38 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <39 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <40 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <41 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <42 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <43 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <44 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <45 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <46 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <47 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <48 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <49 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <50 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <51 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <52 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <53 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <54 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <55 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <56 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <57 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <58 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <59 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <60 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <61 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <62 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <63 x i1> undef, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX-LABEL: 'stores_partial_align1'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i64> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i64> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <5 x i64> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <6 x i64> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <7 x i64> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x double> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x double> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <5 x double> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <6 x double> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <7 x double> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i32> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i32> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i32> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <5 x i32> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i32> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x i32> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <9 x i32> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <10 x i32> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <11 x i32> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <12 x i32> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <13 x i32> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <14 x i32> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <15 x i32> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x float> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x float> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x float> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x float> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x float> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x float> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <9 x float> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <10 x float> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <11 x float> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <12 x float> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <13 x float> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <14 x float> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <15 x float> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i16> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i16> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i16> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i16> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x i16> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i16> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x i16> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <9 x i16> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <10 x i16> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <11 x i16> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i16> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <13 x i16> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <14 x i16> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <15 x i16> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <17 x i16> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <18 x i16> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <19 x i16> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <20 x i16> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <21 x i16> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <22 x i16> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <23 x i16> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <24 x i16> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <25 x i16> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <26 x i16> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <27 x i16> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <28 x i16> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <29 x i16> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <30 x i16> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <31 x i16> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <11 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <13 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <14 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <15 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <17 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <18 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <19 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <20 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <21 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <22 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <23 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <24 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <25 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <26 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <27 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <28 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <29 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <30 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <31 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <33 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <34 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <35 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <36 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <37 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <38 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <39 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <40 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <41 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <42 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <43 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <44 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <45 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <46 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <47 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <48 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <49 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <50 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <51 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <52 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <53 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <54 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <55 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <56 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <57 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <58 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <59 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <60 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <61 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <62 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: store <63 x i8> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <3 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <5 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <6 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <7 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <11 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <13 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <14 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <15 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <17 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <18 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <19 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <20 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <21 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <22 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <23 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <24 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <25 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <26 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <27 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <28 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <29 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <30 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <31 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <33 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <34 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <35 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <36 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <37 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <38 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <39 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <40 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <41 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <42 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <43 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <44 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <45 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <46 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <47 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <48 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <49 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <50 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <51 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <52 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <53 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <54 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <55 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <56 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <57 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <58 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <59 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <60 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <61 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <62 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <63 x i1> undef, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512-LABEL: 'stores_partial_align1'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i64> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i64> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x i64> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i64> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x i64> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x double> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x double> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x double> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x double> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x double> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i32> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i32> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i32> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <5 x i32> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i32> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x i32> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <9 x i32> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x i32> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <11 x i32> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i32> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <13 x i32> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <14 x i32> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <15 x i32> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x float> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x float> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x float> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x float> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x float> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x float> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x float> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x float> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <11 x float> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x float> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <13 x float> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <14 x float> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <15 x float> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i16> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i16> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i16> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i16> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x i16> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i16> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x i16> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <9 x i16> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <10 x i16> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <11 x i16> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i16> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <13 x i16> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <14 x i16> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <15 x i16> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <17 x i16> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <18 x i16> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <19 x i16> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <20 x i16> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <21 x i16> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <22 x i16> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <23 x i16> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <24 x i16> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <25 x i16> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <26 x i16> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <27 x i16> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <28 x i16> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <29 x i16> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <30 x i16> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <31 x i16> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <11 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <13 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <14 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <15 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <17 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <18 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <19 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <20 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <21 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <22 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <23 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <24 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <25 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <26 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <27 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <28 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <29 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <30 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <31 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <33 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <34 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <35 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <36 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <37 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <38 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <39 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <40 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <41 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <42 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <43 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <44 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <45 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <46 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <47 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <48 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <49 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <50 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <51 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <52 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <53 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <54 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: store <55 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <56 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <57 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <58 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <59 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <60 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <61 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <62 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: store <63 x i8> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <3 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <5 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <6 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <7 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <11 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <13 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <14 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <15 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <17 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <18 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <19 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <20 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <21 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <22 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <23 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <24 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <25 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <26 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <27 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <28 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <29 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <30 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <31 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <33 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <34 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <35 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <36 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <37 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <38 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <39 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <40 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <41 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <42 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <43 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <44 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <45 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <46 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <47 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <48 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <49 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <50 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <51 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <52 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <53 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <54 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <55 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <56 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <57 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <58 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <59 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <60 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <61 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <62 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <63 x i1> undef, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  store <1 x i64> undef, ptr undef, align 1
  ; <2 x i64> is XMM
  store <3 x i64> undef, ptr undef, align 1
  ; <4 x i64> is YMM
  store <5 x i64> undef, ptr undef, align 1
  store <6 x i64> undef, ptr undef, align 1
  store <7 x i64> undef, ptr undef, align 1
  ; <8 x i64> is ZMM

  ; Partial vectors with double elements
  store <1 x double> undef, ptr undef, align 1
  ; <2 x double> is XMM
  store <3 x double> undef, ptr undef, align 1
  ; <4 x double> is YMM
  store <5 x double> undef, ptr undef, align 1
  store <6 x double> undef, ptr undef, align 1
  store <7 x double> undef, ptr undef, align 1
  ; <8 x double> is ZMM

  ; Partial vectors with i32 elements
  store <1 x i32> undef, ptr undef, align 1
  store <2 x i32> undef, ptr undef, align 1
  store <3 x i32> undef, ptr undef, align 1
  ; <4 x i32> is XMM
  store <5 x i32> undef, ptr undef, align 1
  store <6 x i32> undef, ptr undef, align 1
  store <7 x i32> undef, ptr undef, align 1
  ; <8 x i32> is YMM
  store <9 x i32> undef, ptr undef, align 1
  store <10 x i32> undef, ptr undef, align 1
  store <11 x i32> undef, ptr undef, align 1
  store <12 x i32> undef, ptr undef, align 1
  store <13 x i32> undef, ptr undef, align 1
  store <14 x i32> undef, ptr undef, align 1
  store <15 x i32> undef, ptr undef, align 1
  ; <16 x i32> is ZMM

  ; Partial vectors with float elements
  store <1 x float> undef, ptr undef, align 1
  store <2 x float> undef, ptr undef, align 1
  store <3 x float> undef, ptr undef, align 1
  ; <4 x float> is XMM
  store <5 x float> undef, ptr undef, align 1
  store <6 x float> undef, ptr undef, align 1
  store <7 x float> undef, ptr undef, align 1
  ; <8 x float> is YMM
  store <9 x float> undef, ptr undef, align 1
  store <10 x float> undef, ptr undef, align 1
  store <11 x float> undef, ptr undef, align 1
  store <12 x float> undef, ptr undef, align 1
  store <13 x float> undef, ptr undef, align 1
  store <14 x float> undef, ptr undef, align 1
  store <15 x float> undef, ptr undef, align 1
  ; <16 x float> is ZMM

  ; Partial vectors with i16 elements
  store <1 x i16> undef, ptr undef, align 1
  store <2 x i16> undef, ptr undef, align 1
  store <3 x i16> undef, ptr undef, align 1
  store <4 x i16> undef, ptr undef, align 1
  store <5 x i16> undef, ptr undef, align 1
  store <6 x i16> undef, ptr undef, align 1
  store <7 x i16> undef, ptr undef, align 1
  ; <8 x i16> is XMM
  store <9 x i16> undef, ptr undef, align 1
  store <10 x i16> undef, ptr undef, align 1
  store <11 x i16> undef, ptr undef, align 1
  store <12 x i16> undef, ptr undef, align 1
  store <13 x i16> undef, ptr undef, align 1
  store <14 x i16> undef, ptr undef, align 1
  store <15 x i16> undef, ptr undef, align 1
  ; <16 x i16> is YMM
  store <17 x i16> undef, ptr undef, align 1
  store <18 x i16> undef, ptr undef, align 1
  store <19 x i16> undef, ptr undef, align 1
  store <20 x i16> undef, ptr undef, align 1
  store <21 x i16> undef, ptr undef, align 1
  store <22 x i16> undef, ptr undef, align 1
  store <23 x i16> undef, ptr undef, align 1
  store <24 x i16> undef, ptr undef, align 1
  store <25 x i16> undef, ptr undef, align 1
  store <26 x i16> undef, ptr undef, align 1
  store <27 x i16> undef, ptr undef, align 1
  store <28 x i16> undef, ptr undef, align 1
  store <29 x i16> undef, ptr undef, align 1
  store <30 x i16> undef, ptr undef, align 1
  store <31 x i16> undef, ptr undef, align 1
  ; <32 x i16> is ZMM

  ; Partial vectors with i8 elements
  store <1 x i8> undef, ptr undef, align 1
  store <2 x i8> undef, ptr undef, align 1
  store <3 x i8> undef, ptr undef, align 1
  store <4 x i8> undef, ptr undef, align 1
  store <5 x i8> undef, ptr undef, align 1
  store <6 x i8> undef, ptr undef, align 1
  store <7 x i8> undef, ptr undef, align 1
  store <8 x i8> undef, ptr undef, align 1
  store <9 x i8> undef, ptr undef, align 1
  store <10 x i8> undef, ptr undef, align 1
  store <11 x i8> undef, ptr undef, align 1
  store <12 x i8> undef, ptr undef, align 1
  store <13 x i8> undef, ptr undef, align 1
  store <14 x i8> undef, ptr undef, align 1
  store <15 x i8> undef, ptr undef, align 1
  ; <16 x i8> is XMM
  store <17 x i8> undef, ptr undef, align 1
  store <18 x i8> undef, ptr undef, align 1
  store <19 x i8> undef, ptr undef, align 1
  store <20 x i8> undef, ptr undef, align 1
  store <21 x i8> undef, ptr undef, align 1
  store <22 x i8> undef, ptr undef, align 1
  store <23 x i8> undef, ptr undef, align 1
  store <24 x i8> undef, ptr undef, align 1
  store <25 x i8> undef, ptr undef, align 1
  store <26 x i8> undef, ptr undef, align 1
  store <27 x i8> undef, ptr undef, align 1
  store <28 x i8> undef, ptr undef, align 1
  store <29 x i8> undef, ptr undef, align 1
  store <30 x i8> undef, ptr undef, align 1
  store <31 x i8> undef, ptr undef, align 1
  ; <32 x i8> is YMM
  store <33 x i8> undef, ptr undef, align 1
  store <34 x i8> undef, ptr undef, align 1
  store <35 x i8> undef, ptr undef, align 1
  store <36 x i8> undef, ptr undef, align 1
  store <37 x i8> undef, ptr undef, align 1
  store <38 x i8> undef, ptr undef, align 1
  store <39 x i8> undef, ptr undef, align 1
  store <40 x i8> undef, ptr undef, align 1
  store <41 x i8> undef, ptr undef, align 1
  store <42 x i8> undef, ptr undef, align 1
  store <43 x i8> undef, ptr undef, align 1
  store <44 x i8> undef, ptr undef, align 1
  store <45 x i8> undef, ptr undef, align 1
  store <46 x i8> undef, ptr undef, align 1
  store <47 x i8> undef, ptr undef, align 1
  store <48 x i8> undef, ptr undef, align 1
  store <49 x i8> undef, ptr undef, align 1
  store <50 x i8> undef, ptr undef, align 1
  store <51 x i8> undef, ptr undef, align 1
  store <52 x i8> undef, ptr undef, align 1
  store <53 x i8> undef, ptr undef, align 1
  store <54 x i8> undef, ptr undef, align 1
  store <55 x i8> undef, ptr undef, align 1
  store <56 x i8> undef, ptr undef, align 1
  store <57 x i8> undef, ptr undef, align 1
  store <58 x i8> undef, ptr undef, align 1
  store <59 x i8> undef, ptr undef, align 1
  store <60 x i8> undef, ptr undef, align 1
  store <61 x i8> undef, ptr undef, align 1
  store <62 x i8> undef, ptr undef, align 1
  store <63 x i8> undef, ptr undef, align 1
  ; <64 x i8> is ZMM

  ; Partial vectors with i1 elements
  ; <1 x i1> is XMM
  ; <2 x i1> is XMM
  store <3 x i1> undef, ptr undef, align 1
  ; <4 x i1> is XMM
  store <5 x i1> undef, ptr undef, align 1
  store <6 x i1> undef, ptr undef, align 1
  store <7 x i1> undef, ptr undef, align 1
  ; <8 x i1> is XMM
  store <9 x i1> undef, ptr undef, align 1
  store <10 x i1> undef, ptr undef, align 1
  store <11 x i1> undef, ptr undef, align 1
  store <12 x i1> undef, ptr undef, align 1
  store <13 x i1> undef, ptr undef, align 1
  store <14 x i1> undef, ptr undef, align 1
  store <15 x i1> undef, ptr undef, align 1
  ; <16 x i1> is XMM
  store <17 x i1> undef, ptr undef, align 1
  store <18 x i1> undef, ptr undef, align 1
  store <19 x i1> undef, ptr undef, align 1
  store <20 x i1> undef, ptr undef, align 1
  store <21 x i1> undef, ptr undef, align 1
  store <22 x i1> undef, ptr undef, align 1
  store <23 x i1> undef, ptr undef, align 1
  store <24 x i1> undef, ptr undef, align 1
  store <25 x i1> undef, ptr undef, align 1
  store <26 x i1> undef, ptr undef, align 1
  store <27 x i1> undef, ptr undef, align 1
  store <28 x i1> undef, ptr undef, align 1
  store <29 x i1> undef, ptr undef, align 1
  store <30 x i1> undef, ptr undef, align 1
  store <31 x i1> undef, ptr undef, align 1
  ; <32 x i1> is YMM
  store <33 x i1> undef, ptr undef, align 1
  store <34 x i1> undef, ptr undef, align 1
  store <35 x i1> undef, ptr undef, align 1
  store <36 x i1> undef, ptr undef, align 1
  store <37 x i1> undef, ptr undef, align 1
  store <38 x i1> undef, ptr undef, align 1
  store <39 x i1> undef, ptr undef, align 1
  store <40 x i1> undef, ptr undef, align 1
  store <41 x i1> undef, ptr undef, align 1
  store <42 x i1> undef, ptr undef, align 1
  store <43 x i1> undef, ptr undef, align 1
  store <44 x i1> undef, ptr undef, align 1
  store <45 x i1> undef, ptr undef, align 1
  store <46 x i1> undef, ptr undef, align 1
  store <47 x i1> undef, ptr undef, align 1
  store <48 x i1> undef, ptr undef, align 1
  store <49 x i1> undef, ptr undef, align 1
  store <50 x i1> undef, ptr undef, align 1
  store <51 x i1> undef, ptr undef, align 1
  store <52 x i1> undef, ptr undef, align 1
  store <53 x i1> undef, ptr undef, align 1
  store <54 x i1> undef, ptr undef, align 1
  store <55 x i1> undef, ptr undef, align 1
  store <56 x i1> undef, ptr undef, align 1
  store <57 x i1> undef, ptr undef, align 1
  store <58 x i1> undef, ptr undef, align 1
  store <59 x i1> undef, ptr undef, align 1
  store <60 x i1> undef, ptr undef, align 1
  store <61 x i1> undef, ptr undef, align 1
  store <62 x i1> undef, ptr undef, align 1
  store <63 x i1> undef, ptr undef, align 1
  ; <64 x i1> is ZMM

  ret i32 undef
}

define i32 @stores_align64(i32 %arg) {
  ; Scalars
; SSE2-LABEL: 'stores_align64'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i8 undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i16 undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i32 undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i64 undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store i128 undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store i256 undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store i512 undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store float undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store double undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store ptr undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i1 undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <128 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i16> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i32> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i64> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <1 x i128> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x float> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x double> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x ptr> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <256 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <32 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <16 x i16> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <8 x i32> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <4 x i64> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <2 x i128> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <1 x i256> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <8 x float> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <4 x double> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <4 x ptr> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <32 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <512 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <64 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <32 x i16> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <16 x i32> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <8 x i64> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <4 x i128> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <2 x i256> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <1 x i512> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <16 x float> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <8 x double> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <8 x ptr> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <64 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SSE41-LABEL: 'stores_align64'
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i8 undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i16 undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i32 undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i64 undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store i128 undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store i256 undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store i512 undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store float undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store double undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store ptr undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i1 undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <128 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i16> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i32> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i64> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <1 x i128> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x float> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x double> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x ptr> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <256 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <32 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <16 x i16> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <8 x i32> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <4 x i64> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <2 x i128> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <1 x i256> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <8 x float> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <4 x double> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <4 x ptr> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <32 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <512 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <64 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <32 x i16> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <16 x i32> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <8 x i64> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <4 x i128> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <2 x i256> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <1 x i512> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <16 x float> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <8 x double> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <8 x ptr> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <64 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX-LABEL: 'stores_align64'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i8 undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i16 undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i32 undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i64 undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store i128 undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store i256 undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store i512 undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store float undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store double undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store ptr undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i1 undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <128 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i16> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i32> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i64> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <1 x i128> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x float> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x double> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x ptr> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <256 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <32 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i16> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i32> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i64> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <2 x i128> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <1 x i256> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x float> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x double> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x ptr> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <32 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <512 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <64 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <32 x i16> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <16 x i32> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <8 x i64> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <4 x i128> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <2 x i256> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <1 x i512> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <16 x float> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <8 x double> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <8 x ptr> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <64 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512-LABEL: 'stores_align64'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i8 undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i16 undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i32 undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i64 undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store i128 undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store i256 undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store i512 undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store float undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store double undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store ptr undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i1 undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <128 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i16> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i32> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i64> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <1 x i128> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x float> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x double> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x ptr> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <256 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <32 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i16> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i32> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i64> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <2 x i128> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <1 x i256> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x float> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x double> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x ptr> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <32 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <512 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <64 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <32 x i16> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x i32> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i64> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <4 x i128> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <2 x i256> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <1 x i512> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <16 x float> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x double> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x ptr> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <64 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  store i8 undef, ptr undef, align 64
  store i16 undef, ptr undef, align 64
  store i32 undef, ptr undef, align 64
  store i64 undef, ptr undef, align 64
  store i128 undef, ptr undef, align 64
  store i256 undef, ptr undef, align 64
  store i512 undef, ptr undef, align 64

  store float undef, ptr undef, align 64
  store double undef, ptr undef, align 64

  store ptr undef, ptr undef, align 64

  store i1 undef, ptr undef, align 64

  ; XMM (128-bit) vectors
  store <128 x i1> undef, ptr undef, align 64
  store <16 x i8> undef, ptr undef, align 64
  store <8 x i16> undef, ptr undef, align 64
  store <4 x i32> undef, ptr undef, align 64
  store <2 x i64> undef, ptr undef, align 64
  store <1 x i128> undef, ptr undef, align 64

  store <4 x float> undef, ptr undef, align 64
  store <2 x double> undef, ptr undef, align 64

  store <2 x ptr> undef, ptr undef, align 64

  store <16 x i1> undef, ptr undef, align 64
  store <8 x i1> undef, ptr undef, align 64
  store <4 x i1> undef, ptr undef, align 64
  store <2 x i1> undef, ptr undef, align 64
  store <1 x i1> undef, ptr undef, align 64

  ; YMM (256-bit) vectors
  store <256 x i1> undef, ptr undef, align 64
  store <32 x i8> undef, ptr undef, align 64
  store <16 x i16> undef, ptr undef, align 64
  store <8 x i32> undef, ptr undef, align 64
  store <4 x i64> undef, ptr undef, align 64
  store <2 x i128> undef, ptr undef, align 64
  store <1 x i256> undef, ptr undef, align 64

  store <8 x float> undef, ptr undef, align 64
  store <4 x double> undef, ptr undef, align 64

  store <4 x ptr> undef, ptr undef, align 64

  store <32 x i1> undef, ptr undef, align 64

  ; ZMM (512-bit) vectors
  store <512 x i1> undef, ptr undef, align 64
  store <64 x i8> undef, ptr undef, align 64
  store <32 x i16> undef, ptr undef, align 64
  store <16 x i32> undef, ptr undef, align 64
  store <8 x i64> undef, ptr undef, align 64
  store <4 x i128> undef, ptr undef, align 64
  store <2 x i256> undef, ptr undef, align 64
  store <1 x i512> undef, ptr undef, align 64

  store <16 x float> undef, ptr undef, align 64
  store <8 x double> undef, ptr undef, align 64

  store <8 x ptr> undef, ptr undef, align 64

  store <64 x i1> undef, ptr undef, align 64

  ret i32 undef
}

define i32 @stores_partial_align64(i32 %arg) {
  ; Partial vectors with i64 elements (doubles as pointer-sized tests))
; SSE2-LABEL: 'stores_partial_align64'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i64> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <3 x i64> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x i64> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i64> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <7 x i64> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x double> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <3 x double> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x double> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x double> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <7 x double> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i32> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i32> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <3 x i32> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <5 x i32> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <6 x i32> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x i32> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x i32> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x i32> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <11 x i32> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i32> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <13 x i32> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <14 x i32> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <15 x i32> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x float> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x float> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x float> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <5 x float> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <6 x float> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <7 x float> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x float> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x float> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <11 x float> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x float> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <13 x float> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <14 x float> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <15 x float> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i16> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i16> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i16> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i16> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x i16> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <6 x i16> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <7 x i16> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <9 x i16> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <10 x i16> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <11 x i16> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <12 x i16> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <13 x i16> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <14 x i16> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <15 x i16> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <17 x i16> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <18 x i16> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <19 x i16> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <20 x i16> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <21 x i16> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <22 x i16> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <23 x i16> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <24 x i16> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <25 x i16> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <26 x i16> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <27 x i16> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <28 x i16> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <29 x i16> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <30 x i16> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <31 x i16> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <3 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <5 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <7 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <9 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <11 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <12 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <13 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <14 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <15 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <17 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <18 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <19 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <20 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <21 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <22 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <23 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <24 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <25 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <26 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <27 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <28 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <29 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <30 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: store <31 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <33 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <34 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <35 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <36 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <37 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <38 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <39 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <40 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <41 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <42 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <43 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <44 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <45 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <46 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: store <47 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <48 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <49 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <50 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <51 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <52 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <53 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <54 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <55 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <56 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <57 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <58 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <59 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <60 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: store <61 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <62 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: store <63 x i8> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <3 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <5 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <6 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <7 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <9 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <10 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <11 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <12 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <13 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <14 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <15 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <17 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <18 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <19 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <20 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <21 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <22 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <23 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <24 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <25 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <26 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <27 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <28 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <29 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <30 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <31 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <33 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <34 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <35 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <36 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <37 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <38 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <39 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <40 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <41 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <42 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <43 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <44 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <45 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <46 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <47 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <48 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <49 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <50 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <51 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <52 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <53 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <54 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <55 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <56 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <57 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <58 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <59 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <60 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <61 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <62 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <63 x i1> undef, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SSE41-LABEL: 'stores_partial_align64'
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i64> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <3 x i64> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x i64> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i64> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <7 x i64> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x double> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <3 x double> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x double> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x double> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <7 x double> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i32> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i32> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i32> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <5 x i32> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <6 x i32> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <7 x i32> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x i32> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x i32> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <11 x i32> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i32> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <13 x i32> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <14 x i32> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <15 x i32> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x float> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x float> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x float> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <5 x float> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <6 x float> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <7 x float> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x float> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x float> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <11 x float> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x float> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <13 x float> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <14 x float> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <15 x float> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i16> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i16> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i16> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i16> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x i16> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i16> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x i16> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <9 x i16> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <10 x i16> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <11 x i16> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <12 x i16> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <13 x i16> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <14 x i16> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <15 x i16> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <17 x i16> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <18 x i16> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <19 x i16> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <20 x i16> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <21 x i16> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <22 x i16> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <23 x i16> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <24 x i16> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <25 x i16> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <26 x i16> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <27 x i16> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <28 x i16> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <29 x i16> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <30 x i16> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <31 x i16> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <11 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <13 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <14 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <15 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <17 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <18 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <19 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <20 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <21 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <22 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <23 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <24 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <25 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <26 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <27 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <28 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <29 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <30 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <31 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <33 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <34 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <35 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <36 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <37 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <38 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <39 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <40 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <41 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <42 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <43 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <44 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <45 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <46 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <47 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <48 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <49 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <50 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <51 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <52 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <53 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <54 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <55 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <56 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <57 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <58 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <59 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <60 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <61 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <62 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: store <63 x i8> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <3 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <5 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <6 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <7 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <11 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <13 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <14 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <15 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <17 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <18 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <19 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <20 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <21 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <22 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <23 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <24 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <25 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <26 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <27 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <28 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <29 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <30 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <31 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <33 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <34 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <35 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <36 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <37 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <38 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <39 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <40 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <41 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <42 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <43 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <44 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <45 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <46 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <47 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <48 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <49 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <50 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <51 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <52 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <53 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <54 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <55 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <56 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <57 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <58 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <59 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <60 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <61 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <62 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <63 x i1> undef, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX-LABEL: 'stores_partial_align64'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i64> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i64> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <5 x i64> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <6 x i64> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <7 x i64> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x double> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x double> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <5 x double> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <6 x double> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <7 x double> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i32> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i32> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i32> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <5 x i32> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i32> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x i32> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <9 x i32> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <10 x i32> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <11 x i32> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <12 x i32> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <13 x i32> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <14 x i32> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <15 x i32> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x float> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x float> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x float> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x float> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x float> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x float> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <9 x float> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <10 x float> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <11 x float> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <12 x float> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <13 x float> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <14 x float> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <15 x float> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i16> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i16> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i16> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i16> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x i16> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i16> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x i16> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <9 x i16> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <10 x i16> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <11 x i16> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i16> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <13 x i16> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <14 x i16> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <15 x i16> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <17 x i16> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <18 x i16> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <19 x i16> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <20 x i16> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <21 x i16> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <22 x i16> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <23 x i16> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <24 x i16> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <25 x i16> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <26 x i16> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <27 x i16> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <28 x i16> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <29 x i16> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <30 x i16> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <31 x i16> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <11 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <13 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <14 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <15 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <17 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <18 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <19 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <20 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <21 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <22 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <23 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <24 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <25 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <26 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <27 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <28 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <29 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <30 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <31 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <33 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <34 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <35 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <36 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <37 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <38 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <39 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <40 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <41 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <42 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <43 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <44 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <45 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <46 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <47 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <48 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <49 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <50 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <51 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <52 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <53 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <54 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <55 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <56 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <57 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <58 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <59 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <60 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <61 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <62 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: store <63 x i8> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <3 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <5 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <6 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <7 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <11 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <13 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <14 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <15 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <17 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <18 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <19 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <20 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <21 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <22 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <23 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <24 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <25 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <26 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <27 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <28 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <29 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <30 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <31 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <33 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <34 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <35 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <36 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <37 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <38 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <39 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <40 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <41 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <42 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <43 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <44 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <45 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <46 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <47 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <48 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <49 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <50 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <51 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <52 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <53 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <54 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <55 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <56 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <57 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <58 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <59 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <60 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <61 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <62 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <63 x i1> undef, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512-LABEL: 'stores_partial_align64'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i64> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i64> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x i64> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i64> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x i64> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x double> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x double> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x double> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x double> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x double> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i32> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i32> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i32> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <5 x i32> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i32> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x i32> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <9 x i32> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x i32> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <11 x i32> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i32> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <13 x i32> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <14 x i32> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <15 x i32> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x float> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x float> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x float> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x float> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x float> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x float> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x float> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x float> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <11 x float> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x float> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <13 x float> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <14 x float> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <15 x float> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i16> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i16> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i16> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i16> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x i16> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i16> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x i16> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <9 x i16> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <10 x i16> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <11 x i16> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i16> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <13 x i16> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <14 x i16> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <15 x i16> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <17 x i16> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <18 x i16> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <19 x i16> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <20 x i16> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <21 x i16> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <22 x i16> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <23 x i16> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <24 x i16> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <25 x i16> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <26 x i16> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <27 x i16> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <28 x i16> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <29 x i16> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <30 x i16> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <31 x i16> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <1 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <2 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <3 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <4 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <5 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <6 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <7 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <8 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <11 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <13 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <14 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <15 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <17 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <18 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <19 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <20 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <21 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <22 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <23 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <24 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <25 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <26 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <27 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <28 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <29 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <30 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <31 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <33 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <34 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <35 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: store <36 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <37 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <38 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <39 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <40 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <41 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <42 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <43 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <44 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <45 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <46 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <47 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <48 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <49 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <50 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <51 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: store <52 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <53 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: store <54 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: store <55 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <56 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <57 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <58 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <59 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <60 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <61 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: store <62 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: store <63 x i8> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <3 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <5 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <6 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store <7 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <9 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <10 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <11 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <12 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <13 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <14 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <15 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <17 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <18 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <19 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <20 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <21 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <22 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <23 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <24 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <25 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <26 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <27 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <28 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <29 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <30 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <31 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <33 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <34 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <35 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <36 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <37 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <38 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <39 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <40 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <41 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <42 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <43 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <44 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <45 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <46 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <47 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: store <48 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <49 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <50 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <51 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <52 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <53 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <54 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <55 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: store <56 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <57 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <58 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <59 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <60 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <61 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <62 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: store <63 x i1> undef, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  store <1 x i64> undef, ptr undef, align 64
  ; <2 x i64> is XMM
  store <3 x i64> undef, ptr undef, align 64
  ; <4 x i64> is YMM
  store <5 x i64> undef, ptr undef, align 64
  store <6 x i64> undef, ptr undef, align 64
  store <7 x i64> undef, ptr undef, align 64
  ; <8 x i64> is ZMM

  ; Partial vectors with double elements
  store <1 x double> undef, ptr undef, align 64
  ; <2 x double> is XMM
  store <3 x double> undef, ptr undef, align 64
  ; <4 x double> is YMM
  store <5 x double> undef, ptr undef, align 64
  store <6 x double> undef, ptr undef, align 64
  store <7 x double> undef, ptr undef, align 64
  ; <8 x double> is ZMM

  ; Partial vectors with i32 elements
  store <1 x i32> undef, ptr undef, align 64
  store <2 x i32> undef, ptr undef, align 64
  store <3 x i32> undef, ptr undef, align 64
  ; <4 x i32> is XMM
  store <5 x i32> undef, ptr undef, align 64
  store <6 x i32> undef, ptr undef, align 64
  store <7 x i32> undef, ptr undef, align 64
  ; <8 x i32> is YMM
  store <9 x i32> undef, ptr undef, align 64
  store <10 x i32> undef, ptr undef, align 64
  store <11 x i32> undef, ptr undef, align 64
  store <12 x i32> undef, ptr undef, align 64
  store <13 x i32> undef, ptr undef, align 64
  store <14 x i32> undef, ptr undef, align 64
  store <15 x i32> undef, ptr undef, align 64
  ; <16 x i32> is ZMM

  ; Partial vectors with float elements
  store <1 x float> undef, ptr undef, align 64
  store <2 x float> undef, ptr undef, align 64
  store <3 x float> undef, ptr undef, align 64
  ; <4 x float> is XMM
  store <5 x float> undef, ptr undef, align 64
  store <6 x float> undef, ptr undef, align 64
  store <7 x float> undef, ptr undef, align 64
  ; <8 x float> is YMM
  store <9 x float> undef, ptr undef, align 64
  store <10 x float> undef, ptr undef, align 64
  store <11 x float> undef, ptr undef, align 64
  store <12 x float> undef, ptr undef, align 64
  store <13 x float> undef, ptr undef, align 64
  store <14 x float> undef, ptr undef, align 64
  store <15 x float> undef, ptr undef, align 64
  ; <16 x float> is ZMM

  ; Partial vectors with i16 elements
  store <1 x i16> undef, ptr undef, align 64
  store <2 x i16> undef, ptr undef, align 64
  store <3 x i16> undef, ptr undef, align 64
  store <4 x i16> undef, ptr undef, align 64
  store <5 x i16> undef, ptr undef, align 64
  store <6 x i16> undef, ptr undef, align 64
  store <7 x i16> undef, ptr undef, align 64
  ; <8 x i16> is XMM
  store <9 x i16> undef, ptr undef, align 64
  store <10 x i16> undef, ptr undef, align 64
  store <11 x i16> undef, ptr undef, align 64
  store <12 x i16> undef, ptr undef, align 64
  store <13 x i16> undef, ptr undef, align 64
  store <14 x i16> undef, ptr undef, align 64
  store <15 x i16> undef, ptr undef, align 64
  ; <16 x i16> is YMM
  store <17 x i16> undef, ptr undef, align 64
  store <18 x i16> undef, ptr undef, align 64
  store <19 x i16> undef, ptr undef, align 64
  store <20 x i16> undef, ptr undef, align 64
  store <21 x i16> undef, ptr undef, align 64
  store <22 x i16> undef, ptr undef, align 64
  store <23 x i16> undef, ptr undef, align 64
  store <24 x i16> undef, ptr undef, align 64
  store <25 x i16> undef, ptr undef, align 64
  store <26 x i16> undef, ptr undef, align 64
  store <27 x i16> undef, ptr undef, align 64
  store <28 x i16> undef, ptr undef, align 64
  store <29 x i16> undef, ptr undef, align 64
  store <30 x i16> undef, ptr undef, align 64
  store <31 x i16> undef, ptr undef, align 64
  ; <32 x i16> is ZMM

  ; Partial vectors with i8 elements
  store <1 x i8> undef, ptr undef, align 64
  store <2 x i8> undef, ptr undef, align 64
  store <3 x i8> undef, ptr undef, align 64
  store <4 x i8> undef, ptr undef, align 64
  store <5 x i8> undef, ptr undef, align 64
  store <6 x i8> undef, ptr undef, align 64
  store <7 x i8> undef, ptr undef, align 64
  store <8 x i8> undef, ptr undef, align 64
  store <9 x i8> undef, ptr undef, align 64
  store <10 x i8> undef, ptr undef, align 64
  store <11 x i8> undef, ptr undef, align 64
  store <12 x i8> undef, ptr undef, align 64
  store <13 x i8> undef, ptr undef, align 64
  store <14 x i8> undef, ptr undef, align 64
  store <15 x i8> undef, ptr undef, align 64
  ; <16 x i8> is XMM
  store <17 x i8> undef, ptr undef, align 64
  store <18 x i8> undef, ptr undef, align 64
  store <19 x i8> undef, ptr undef, align 64
  store <20 x i8> undef, ptr undef, align 64
  store <21 x i8> undef, ptr undef, align 64
  store <22 x i8> undef, ptr undef, align 64
  store <23 x i8> undef, ptr undef, align 64
  store <24 x i8> undef, ptr undef, align 64
  store <25 x i8> undef, ptr undef, align 64
  store <26 x i8> undef, ptr undef, align 64
  store <27 x i8> undef, ptr undef, align 64
  store <28 x i8> undef, ptr undef, align 64
  store <29 x i8> undef, ptr undef, align 64
  store <30 x i8> undef, ptr undef, align 64
  store <31 x i8> undef, ptr undef, align 64
  ; <32 x i8> is YMM
  store <33 x i8> undef, ptr undef, align 64
  store <34 x i8> undef, ptr undef, align 64
  store <35 x i8> undef, ptr undef, align 64
  store <36 x i8> undef, ptr undef, align 64
  store <37 x i8> undef, ptr undef, align 64
  store <38 x i8> undef, ptr undef, align 64
  store <39 x i8> undef, ptr undef, align 64
  store <40 x i8> undef, ptr undef, align 64
  store <41 x i8> undef, ptr undef, align 64
  store <42 x i8> undef, ptr undef, align 64
  store <43 x i8> undef, ptr undef, align 64
  store <44 x i8> undef, ptr undef, align 64
  store <45 x i8> undef, ptr undef, align 64
  store <46 x i8> undef, ptr undef, align 64
  store <47 x i8> undef, ptr undef, align 64
  store <48 x i8> undef, ptr undef, align 64
  store <49 x i8> undef, ptr undef, align 64
  store <50 x i8> undef, ptr undef, align 64
  store <51 x i8> undef, ptr undef, align 64
  store <52 x i8> undef, ptr undef, align 64
  store <53 x i8> undef, ptr undef, align 64
  store <54 x i8> undef, ptr undef, align 64
  store <55 x i8> undef, ptr undef, align 64
  store <56 x i8> undef, ptr undef, align 64
  store <57 x i8> undef, ptr undef, align 64
  store <58 x i8> undef, ptr undef, align 64
  store <59 x i8> undef, ptr undef, align 64
  store <60 x i8> undef, ptr undef, align 64
  store <61 x i8> undef, ptr undef, align 64
  store <62 x i8> undef, ptr undef, align 64
  store <63 x i8> undef, ptr undef, align 64
  ; <64 x i8> is ZMM

  ; Partial vectors with i1 elements
  ; <1 x i1> is XMM
  ; <2 x i1> is XMM
  store <3 x i1> undef, ptr undef, align 64
  ; <4 x i1> is XMM
  store <5 x i1> undef, ptr undef, align 64
  store <6 x i1> undef, ptr undef, align 64
  store <7 x i1> undef, ptr undef, align 64
  ; <8 x i1> is XMM
  store <9 x i1> undef, ptr undef, align 64
  store <10 x i1> undef, ptr undef, align 64
  store <11 x i1> undef, ptr undef, align 64
  store <12 x i1> undef, ptr undef, align 64
  store <13 x i1> undef, ptr undef, align 64
  store <14 x i1> undef, ptr undef, align 64
  store <15 x i1> undef, ptr undef, align 64
  ; <16 x i1> is XMM
  store <17 x i1> undef, ptr undef, align 64
  store <18 x i1> undef, ptr undef, align 64
  store <19 x i1> undef, ptr undef, align 64
  store <20 x i1> undef, ptr undef, align 64
  store <21 x i1> undef, ptr undef, align 64
  store <22 x i1> undef, ptr undef, align 64
  store <23 x i1> undef, ptr undef, align 64
  store <24 x i1> undef, ptr undef, align 64
  store <25 x i1> undef, ptr undef, align 64
  store <26 x i1> undef, ptr undef, align 64
  store <27 x i1> undef, ptr undef, align 64
  store <28 x i1> undef, ptr undef, align 64
  store <29 x i1> undef, ptr undef, align 64
  store <30 x i1> undef, ptr undef, align 64
  store <31 x i1> undef, ptr undef, align 64
  ; <32 x i1> is YMM
  store <33 x i1> undef, ptr undef, align 64
  store <34 x i1> undef, ptr undef, align 64
  store <35 x i1> undef, ptr undef, align 64
  store <36 x i1> undef, ptr undef, align 64
  store <37 x i1> undef, ptr undef, align 64
  store <38 x i1> undef, ptr undef, align 64
  store <39 x i1> undef, ptr undef, align 64
  store <40 x i1> undef, ptr undef, align 64
  store <41 x i1> undef, ptr undef, align 64
  store <42 x i1> undef, ptr undef, align 64
  store <43 x i1> undef, ptr undef, align 64
  store <44 x i1> undef, ptr undef, align 64
  store <45 x i1> undef, ptr undef, align 64
  store <46 x i1> undef, ptr undef, align 64
  store <47 x i1> undef, ptr undef, align 64
  store <48 x i1> undef, ptr undef, align 64
  store <49 x i1> undef, ptr undef, align 64
  store <50 x i1> undef, ptr undef, align 64
  store <51 x i1> undef, ptr undef, align 64
  store <52 x i1> undef, ptr undef, align 64
  store <53 x i1> undef, ptr undef, align 64
  store <54 x i1> undef, ptr undef, align 64
  store <55 x i1> undef, ptr undef, align 64
  store <56 x i1> undef, ptr undef, align 64
  store <57 x i1> undef, ptr undef, align 64
  store <58 x i1> undef, ptr undef, align 64
  store <59 x i1> undef, ptr undef, align 64
  store <60 x i1> undef, ptr undef, align 64
  store <61 x i1> undef, ptr undef, align 64
  store <62 x i1> undef, ptr undef, align 64
  store <63 x i1> undef, ptr undef, align 64
  ; <64 x i1> is ZMM

  ret i32 undef
}

define i32 @loads_align4(i32 %arg) {
  ; Scalars
; SSE2-LABEL: 'loads_align4'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = load i8, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %2 = load i16, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %3 = load i32, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %4 = load i64, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %5 = load i128, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %6 = load i256, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %7 = load i512, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %8 = load float, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %9 = load double, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %10 = load ptr, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %11 = load ptr, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %12 = load <128 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %13 = load <16 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %14 = load <8 x i16>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %15 = load <4 x i32>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %16 = load <2 x i64>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %17 = load <1 x i128>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %18 = load <4 x float>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %19 = load <2 x double>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %20 = load <2 x ptr>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %21 = load <16 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %22 = load <8 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %23 = load <4 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %24 = load <2 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %25 = load <1 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %26 = load <256 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %27 = load <32 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %28 = load <16 x i16>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %29 = load <8 x i32>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %30 = load <4 x i64>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %31 = load <2 x i128>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %32 = load <1 x i256>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %33 = load <8 x float>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %34 = load <4 x double>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %35 = load <4 x ptr>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %36 = load <32 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %37 = load <512 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %38 = load <64 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %39 = load <32 x i16>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %40 = load <16 x i32>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %41 = load <8 x i64>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %42 = load <4 x i128>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %43 = load <2 x i256>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %44 = load <1 x i512>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %45 = load <16 x float>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %46 = load <8 x double>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %47 = load <8 x ptr>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %48 = load <64 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SSE41-LABEL: 'loads_align4'
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = load i8, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %2 = load i16, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %3 = load i32, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %4 = load i64, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %5 = load i128, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %6 = load i256, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %7 = load i512, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %8 = load float, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %9 = load double, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %10 = load ptr, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %11 = load ptr, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %12 = load <128 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %13 = load <16 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %14 = load <8 x i16>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %15 = load <4 x i32>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %16 = load <2 x i64>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %17 = load <1 x i128>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %18 = load <4 x float>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %19 = load <2 x double>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %20 = load <2 x ptr>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %21 = load <16 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %22 = load <8 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %23 = load <4 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %24 = load <2 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %25 = load <1 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %26 = load <256 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %27 = load <32 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %28 = load <16 x i16>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %29 = load <8 x i32>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %30 = load <4 x i64>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %31 = load <2 x i128>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %32 = load <1 x i256>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %33 = load <8 x float>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %34 = load <4 x double>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %35 = load <4 x ptr>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %36 = load <32 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %37 = load <512 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %38 = load <64 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %39 = load <32 x i16>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %40 = load <16 x i32>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %41 = load <8 x i64>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %42 = load <4 x i128>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %43 = load <2 x i256>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %44 = load <1 x i512>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %45 = load <16 x float>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %46 = load <8 x double>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %47 = load <8 x ptr>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %48 = load <64 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX-LABEL: 'loads_align4'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = load i8, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %2 = load i16, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %3 = load i32, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %4 = load i64, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %5 = load i128, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %6 = load i256, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %7 = load i512, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %8 = load float, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %9 = load double, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %10 = load ptr, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %11 = load ptr, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %12 = load <128 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %13 = load <16 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %14 = load <8 x i16>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %15 = load <4 x i32>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %16 = load <2 x i64>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %17 = load <1 x i128>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %18 = load <4 x float>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %19 = load <2 x double>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %20 = load <2 x ptr>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %21 = load <16 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %22 = load <8 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %23 = load <4 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %24 = load <2 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %25 = load <1 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %26 = load <256 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %27 = load <32 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %28 = load <16 x i16>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %29 = load <8 x i32>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %30 = load <4 x i64>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %31 = load <2 x i128>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %32 = load <1 x i256>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %33 = load <8 x float>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %34 = load <4 x double>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %35 = load <4 x ptr>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %36 = load <32 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %37 = load <512 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %38 = load <64 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %39 = load <32 x i16>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %40 = load <16 x i32>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %41 = load <8 x i64>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %42 = load <4 x i128>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %43 = load <2 x i256>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %44 = load <1 x i512>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %45 = load <16 x float>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %46 = load <8 x double>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %47 = load <8 x ptr>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %48 = load <64 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512-LABEL: 'loads_align4'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = load i8, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %2 = load i16, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %3 = load i32, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %4 = load i64, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %5 = load i128, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %6 = load i256, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %7 = load i512, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %8 = load float, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %9 = load double, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %10 = load ptr, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %11 = load ptr, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %12 = load <128 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %13 = load <16 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %14 = load <8 x i16>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %15 = load <4 x i32>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %16 = load <2 x i64>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %17 = load <1 x i128>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %18 = load <4 x float>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %19 = load <2 x double>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %20 = load <2 x ptr>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %21 = load <16 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %22 = load <8 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %23 = load <4 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %24 = load <2 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %25 = load <1 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %26 = load <256 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %27 = load <32 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %28 = load <16 x i16>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %29 = load <8 x i32>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %30 = load <4 x i64>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %31 = load <2 x i128>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %32 = load <1 x i256>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %33 = load <8 x float>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %34 = load <4 x double>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %35 = load <4 x ptr>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %36 = load <32 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %37 = load <512 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %38 = load <64 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %39 = load <32 x i16>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %40 = load <16 x i32>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %41 = load <8 x i64>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %42 = load <4 x i128>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %43 = load <2 x i256>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %44 = load <1 x i512>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %45 = load <16 x float>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %46 = load <8 x double>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %47 = load <8 x ptr>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %48 = load <64 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  load i8, ptr undef, align 4
  load i16, ptr undef, align 4
  load i32, ptr undef, align 4
  load i64, ptr undef, align 4
  load i128, ptr undef, align 4
  load i256, ptr undef, align 4
  load i512, ptr undef, align 4

  load float, ptr undef, align 4
  load double, ptr undef, align 4

  load ptr, ptr undef, align 4

  load ptr, ptr undef, align 4

  ; XMM (128-bit) vectors
  load <128 x i1>, ptr undef, align 4
  load <16 x i8>, ptr undef, align 4
  load <8 x i16>, ptr undef, align 4
  load <4 x i32>, ptr undef, align 4
  load <2 x i64>, ptr undef, align 4
  load <1 x i128>, ptr undef, align 4

  load <4 x float>, ptr undef, align 4
  load <2 x double>, ptr undef, align 4

  load <2 x ptr>, ptr undef, align 4

  load <16 x i1>, ptr undef, align 4
  load <8 x i1>, ptr undef, align 4
  load <4 x i1>, ptr undef, align 4
  load <2 x i1>, ptr undef, align 4
  load <1 x i1>, ptr undef, align 4

  ; YMM (256-bit) vectors
  load <256 x i1>, ptr undef, align 4
  load <32 x i8>, ptr undef, align 4
  load <16 x i16>, ptr undef, align 4
  load <8 x i32>, ptr undef, align 4
  load <4 x i64>, ptr undef, align 4
  load <2 x i128>, ptr undef, align 4
  load <1 x i256>, ptr undef, align 4

  load <8 x float>, ptr undef, align 4
  load <4 x double>, ptr undef, align 4

  load <4 x ptr>, ptr undef, align 4

  load <32 x i1>, ptr undef, align 4

  ; ZMM (512-bit) vectors
  load <512 x i1>, ptr undef, align 4
  load <64 x i8>, ptr undef, align 4
  load <32 x i16>, ptr undef, align 4
  load <16 x i32>, ptr undef, align 4
  load <8 x i64>, ptr undef, align 4
  load <4 x i128>, ptr undef, align 4
  load <2 x i256>, ptr undef, align 4
  load <1 x i512>, ptr undef, align 4

  load <16 x float>, ptr undef, align 4
  load <8 x double>, ptr undef, align 4

  load <8 x ptr>, ptr undef, align 4

  load <64 x i1>, ptr undef, align 4

  ret i32 undef
}

define i32 @loads_partial_align4(i32 %arg) {
  ; Partial vectors with i64 elements (doubles as pointer-sized tests))
; SSE2-LABEL: 'loads_partial_align4'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = load <1 x i64>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %2 = load <3 x i64>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %3 = load <5 x i64>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %4 = load <6 x i64>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %5 = load <7 x i64>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %6 = load <1 x double>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %7 = load <3 x double>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %8 = load <5 x double>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %9 = load <6 x double>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %10 = load <7 x double>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %11 = load <1 x i32>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %12 = load <2 x i32>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %13 = load <3 x i32>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %14 = load <5 x i32>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %15 = load <6 x i32>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %16 = load <7 x i32>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %17 = load <9 x i32>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %18 = load <10 x i32>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %19 = load <11 x i32>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %20 = load <12 x i32>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %21 = load <13 x i32>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %22 = load <14 x i32>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %23 = load <15 x i32>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %24 = load <1 x float>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %25 = load <2 x float>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %26 = load <3 x float>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %27 = load <5 x float>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %28 = load <6 x float>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %29 = load <7 x float>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %30 = load <9 x float>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %31 = load <10 x float>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %32 = load <11 x float>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %33 = load <12 x float>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %34 = load <13 x float>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %35 = load <14 x float>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %36 = load <15 x float>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %37 = load <1 x i16>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %38 = load <2 x i16>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %39 = load <3 x i16>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %40 = load <4 x i16>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %41 = load <5 x i16>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %42 = load <6 x i16>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %43 = load <7 x i16>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %44 = load <9 x i16>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %45 = load <10 x i16>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %46 = load <11 x i16>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %47 = load <12 x i16>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %48 = load <13 x i16>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %49 = load <14 x i16>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %50 = load <15 x i16>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %51 = load <17 x i16>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %52 = load <18 x i16>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %53 = load <19 x i16>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %54 = load <20 x i16>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %55 = load <21 x i16>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %56 = load <22 x i16>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %57 = load <23 x i16>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %58 = load <24 x i16>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %59 = load <25 x i16>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %60 = load <26 x i16>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %61 = load <27 x i16>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %62 = load <28 x i16>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %63 = load <29 x i16>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %64 = load <30 x i16>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %65 = load <31 x i16>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %66 = load <1 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %67 = load <2 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %68 = load <3 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %69 = load <4 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %70 = load <5 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %71 = load <6 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %72 = load <7 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %73 = load <8 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %74 = load <9 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %75 = load <10 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %76 = load <11 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %77 = load <12 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %78 = load <13 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %79 = load <14 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %80 = load <15 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %81 = load <17 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %82 = load <18 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %83 = load <19 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %84 = load <20 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %85 = load <21 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %86 = load <22 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %87 = load <23 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %88 = load <24 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %89 = load <25 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %90 = load <26 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %91 = load <27 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %92 = load <28 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %93 = load <29 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %94 = load <30 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %95 = load <31 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %96 = load <33 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %97 = load <34 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %98 = load <35 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %99 = load <36 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %100 = load <37 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %101 = load <38 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %102 = load <39 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %103 = load <40 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %104 = load <41 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %105 = load <42 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %106 = load <43 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %107 = load <44 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %108 = load <45 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %109 = load <46 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %110 = load <47 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %111 = load <48 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %112 = load <49 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %113 = load <50 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %114 = load <51 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %115 = load <52 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %116 = load <53 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %117 = load <54 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %118 = load <55 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %119 = load <56 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %120 = load <57 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %121 = load <58 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %122 = load <59 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %123 = load <60 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %124 = load <61 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %125 = load <62 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %126 = load <63 x i8>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %127 = load <3 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %128 = load <5 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %129 = load <6 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %130 = load <7 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %131 = load <9 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %132 = load <10 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %133 = load <11 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %134 = load <12 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %135 = load <13 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %136 = load <14 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %137 = load <15 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %138 = load <17 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %139 = load <18 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %140 = load <19 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %141 = load <20 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %142 = load <21 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %143 = load <22 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %144 = load <23 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %145 = load <24 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %146 = load <25 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %147 = load <26 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %148 = load <27 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %149 = load <28 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %150 = load <29 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %151 = load <30 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %152 = load <31 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %153 = load <33 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %154 = load <34 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %155 = load <35 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %156 = load <36 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %157 = load <37 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %158 = load <38 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %159 = load <39 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %160 = load <40 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %161 = load <41 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %162 = load <42 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %163 = load <43 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %164 = load <44 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %165 = load <45 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %166 = load <46 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %167 = load <47 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %168 = load <48 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %169 = load <49 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %170 = load <50 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %171 = load <51 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %172 = load <52 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %173 = load <53 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %174 = load <54 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %175 = load <55 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %176 = load <56 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %177 = load <57 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %178 = load <58 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %179 = load <59 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %180 = load <60 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %181 = load <61 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %182 = load <62 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %183 = load <63 x i1>, ptr undef, align 4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SSE41-LABEL: 'loads_partial_align4'
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = load <1 x i64>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %2 = load <3 x i64>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %3 = load <5 x i64>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %4 = load <6 x i64>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %5 = load <7 x i64>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %6 = load <1 x double>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %7 = load <3 x double>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %8 = load <5 x double>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %9 = load <6 x double>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %10 = load <7 x double>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %11 = load <1 x i32>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %12 = load <2 x i32>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %13 = load <3 x i32>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %14 = load <5 x i32>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %15 = load <6 x i32>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %16 = load <7 x i32>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %17 = load <9 x i32>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %18 = load <10 x i32>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %19 = load <11 x i32>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %20 = load <12 x i32>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %21 = load <13 x i32>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %22 = load <14 x i32>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %23 = load <15 x i32>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %24 = load <1 x float>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %25 = load <2 x float>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %26 = load <3 x float>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %27 = load <5 x float>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %28 = load <6 x float>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %29 = load <7 x float>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %30 = load <9 x float>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %31 = load <10 x float>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %32 = load <11 x float>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %33 = load <12 x float>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %34 = load <13 x float>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %35 = load <14 x float>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %36 = load <15 x float>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %37 = load <1 x i16>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %38 = load <2 x i16>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %39 = load <3 x i16>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %40 = load <4 x i16>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %41 = load <5 x i16>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %42 = load <6 x i16>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %43 = load <7 x i16>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %44 = load <9 x i16>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %45 = load <10 x i16>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %46 = load <11 x i16>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %47 = load <12 x i16>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %48 = load <13 x i16>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %49 = load <14 x i16>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %50 = load <15 x i16>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %51 = load <17 x i16>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %52 = load <18 x i16>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %53 = load <19 x i16>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %54 = load <20 x i16>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %55 = load <21 x i16>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %56 = load <22 x i16>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %57 = load <23 x i16>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %58 = load <24 x i16>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %59 = load <25 x i16>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %60 = load <26 x i16>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %61 = load <27 x i16>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %62 = load <28 x i16>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %63 = load <29 x i16>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %64 = load <30 x i16>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %65 = load <31 x i16>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %66 = load <1 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %67 = load <2 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %68 = load <3 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %69 = load <4 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %70 = load <5 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %71 = load <6 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %72 = load <7 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %73 = load <8 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %74 = load <9 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %75 = load <10 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %76 = load <11 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %77 = load <12 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %78 = load <13 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %79 = load <14 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %80 = load <15 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %81 = load <17 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %82 = load <18 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %83 = load <19 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %84 = load <20 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %85 = load <21 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %86 = load <22 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %87 = load <23 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %88 = load <24 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %89 = load <25 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %90 = load <26 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %91 = load <27 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %92 = load <28 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %93 = load <29 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %94 = load <30 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %95 = load <31 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %96 = load <33 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %97 = load <34 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %98 = load <35 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %99 = load <36 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %100 = load <37 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %101 = load <38 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %102 = load <39 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %103 = load <40 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %104 = load <41 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %105 = load <42 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %106 = load <43 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %107 = load <44 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %108 = load <45 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %109 = load <46 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %110 = load <47 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %111 = load <48 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %112 = load <49 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %113 = load <50 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %114 = load <51 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %115 = load <52 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %116 = load <53 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %117 = load <54 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %118 = load <55 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %119 = load <56 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %120 = load <57 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %121 = load <58 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %122 = load <59 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %123 = load <60 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %124 = load <61 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %125 = load <62 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %126 = load <63 x i8>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %127 = load <3 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %128 = load <5 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %129 = load <6 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %130 = load <7 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %131 = load <9 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %132 = load <10 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %133 = load <11 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %134 = load <12 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %135 = load <13 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %136 = load <14 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %137 = load <15 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %138 = load <17 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %139 = load <18 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %140 = load <19 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %141 = load <20 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %142 = load <21 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %143 = load <22 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %144 = load <23 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %145 = load <24 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %146 = load <25 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %147 = load <26 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %148 = load <27 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %149 = load <28 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %150 = load <29 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %151 = load <30 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %152 = load <31 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %153 = load <33 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %154 = load <34 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %155 = load <35 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %156 = load <36 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %157 = load <37 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %158 = load <38 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %159 = load <39 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %160 = load <40 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %161 = load <41 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %162 = load <42 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %163 = load <43 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %164 = load <44 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %165 = load <45 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %166 = load <46 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %167 = load <47 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %168 = load <48 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %169 = load <49 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %170 = load <50 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %171 = load <51 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %172 = load <52 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %173 = load <53 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %174 = load <54 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %175 = load <55 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %176 = load <56 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %177 = load <57 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %178 = load <58 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %179 = load <59 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %180 = load <60 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %181 = load <61 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %182 = load <62 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %183 = load <63 x i1>, ptr undef, align 4
; SSE41-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX-LABEL: 'loads_partial_align4'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = load <1 x i64>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %2 = load <3 x i64>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %3 = load <5 x i64>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %4 = load <6 x i64>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %5 = load <7 x i64>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %6 = load <1 x double>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %7 = load <3 x double>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %8 = load <5 x double>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %9 = load <6 x double>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %10 = load <7 x double>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %11 = load <1 x i32>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %12 = load <2 x i32>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %13 = load <3 x i32>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %14 = load <5 x i32>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %15 = load <6 x i32>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %16 = load <7 x i32>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %17 = load <9 x i32>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %18 = load <10 x i32>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %19 = load <11 x i32>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %20 = load <12 x i32>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %21 = load <13 x i32>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %22 = load <14 x i32>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %23 = load <15 x i32>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %24 = load <1 x float>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %25 = load <2 x float>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %26 = load <3 x float>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %27 = load <5 x float>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %28 = load <6 x float>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %29 = load <7 x float>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %30 = load <9 x float>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %31 = load <10 x float>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %32 = load <11 x float>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %33 = load <12 x float>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %34 = load <13 x float>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %35 = load <14 x float>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %36 = load <15 x float>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %37 = load <1 x i16>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %38 = load <2 x i16>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %39 = load <3 x i16>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %40 = load <4 x i16>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %41 = load <5 x i16>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %42 = load <6 x i16>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %43 = load <7 x i16>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %44 = load <9 x i16>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %45 = load <10 x i16>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %46 = load <11 x i16>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %47 = load <12 x i16>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %48 = load <13 x i16>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %49 = load <14 x i16>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %50 = load <15 x i16>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %51 = load <17 x i16>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %52 = load <18 x i16>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %53 = load <19 x i16>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %54 = load <20 x i16>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %55 = load <21 x i16>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %56 = load <22 x i16>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %57 = load <23 x i16>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %58 = load <24 x i16>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %59 = load <25 x i16>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %60 = load <26 x i16>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %61 = load <27 x i16>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %62 = load <28 x i16>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %63 = load <29 x i16>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %64 = load <30 x i16>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %65 = load <31 x i16>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %66 = load <1 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %67 = load <2 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %68 = load <3 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %69 = load <4 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %70 = load <5 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %71 = load <6 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %72 = load <7 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %73 = load <8 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %74 = load <9 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %75 = load <10 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %76 = load <11 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %77 = load <12 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %78 = load <13 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %79 = load <14 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %80 = load <15 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %81 = load <17 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %82 = load <18 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %83 = load <19 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %84 = load <20 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %85 = load <21 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %86 = load <22 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %87 = load <23 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %88 = load <24 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %89 = load <25 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %90 = load <26 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %91 = load <27 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %92 = load <28 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %93 = load <29 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %94 = load <30 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %95 = load <31 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %96 = load <33 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %97 = load <34 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %98 = load <35 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %99 = load <36 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %100 = load <37 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %101 = load <38 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %102 = load <39 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %103 = load <40 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %104 = load <41 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %105 = load <42 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %106 = load <43 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %107 = load <44 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %108 = load <45 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %109 = load <46 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %110 = load <47 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %111 = load <48 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %112 = load <49 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %113 = load <50 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %114 = load <51 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %115 = load <52 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %116 = load <53 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %117 = load <54 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %118 = load <55 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %119 = load <56 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %120 = load <57 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %121 = load <58 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %122 = load <59 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %123 = load <60 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %124 = load <61 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %125 = load <62 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %126 = load <63 x i8>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %127 = load <3 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %128 = load <5 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %129 = load <6 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %130 = load <7 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %131 = load <9 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %132 = load <10 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %133 = load <11 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %134 = load <12 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %135 = load <13 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %136 = load <14 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %137 = load <15 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %138 = load <17 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %139 = load <18 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %140 = load <19 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %141 = load <20 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %142 = load <21 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %143 = load <22 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %144 = load <23 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %145 = load <24 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %146 = load <25 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %147 = load <26 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %148 = load <27 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %149 = load <28 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %150 = load <29 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %151 = load <30 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %152 = load <31 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %153 = load <33 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %154 = load <34 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %155 = load <35 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %156 = load <36 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %157 = load <37 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %158 = load <38 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %159 = load <39 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %160 = load <40 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %161 = load <41 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %162 = load <42 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %163 = load <43 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %164 = load <44 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %165 = load <45 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %166 = load <46 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %167 = load <47 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %168 = load <48 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %169 = load <49 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %170 = load <50 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %171 = load <51 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %172 = load <52 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %173 = load <53 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %174 = load <54 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %175 = load <55 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %176 = load <56 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %177 = load <57 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %178 = load <58 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %179 = load <59 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %180 = load <60 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %181 = load <61 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %182 = load <62 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %183 = load <63 x i1>, ptr undef, align 4
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512-LABEL: 'loads_partial_align4'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = load <1 x i64>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %2 = load <3 x i64>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %3 = load <5 x i64>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %4 = load <6 x i64>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %5 = load <7 x i64>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %6 = load <1 x double>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %7 = load <3 x double>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %8 = load <5 x double>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %9 = load <6 x double>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %10 = load <7 x double>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %11 = load <1 x i32>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %12 = load <2 x i32>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %13 = load <3 x i32>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %14 = load <5 x i32>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %15 = load <6 x i32>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %16 = load <7 x i32>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %17 = load <9 x i32>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %18 = load <10 x i32>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %19 = load <11 x i32>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %20 = load <12 x i32>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %21 = load <13 x i32>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %22 = load <14 x i32>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %23 = load <15 x i32>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %24 = load <1 x float>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %25 = load <2 x float>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %26 = load <3 x float>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %27 = load <5 x float>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %28 = load <6 x float>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %29 = load <7 x float>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %30 = load <9 x float>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %31 = load <10 x float>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %32 = load <11 x float>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %33 = load <12 x float>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %34 = load <13 x float>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %35 = load <14 x float>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %36 = load <15 x float>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %37 = load <1 x i16>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %38 = load <2 x i16>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %39 = load <3 x i16>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %40 = load <4 x i16>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %41 = load <5 x i16>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %42 = load <6 x i16>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %43 = load <7 x i16>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %44 = load <9 x i16>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %45 = load <10 x i16>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %46 = load <11 x i16>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %47 = load <12 x i16>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %48 = load <13 x i16>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %49 = load <14 x i16>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %50 = load <15 x i16>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %51 = load <17 x i16>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %52 = load <18 x i16>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %53 = load <19 x i16>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %54 = load <20 x i16>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %55 = load <21 x i16>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %56 = load <22 x i16>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %57 = load <23 x i16>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %58 = load <24 x i16>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %59 = load <25 x i16>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %60 = load <26 x i16>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %61 = load <27 x i16>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %62 = load <28 x i16>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %63 = load <29 x i16>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %64 = load <30 x i16>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %65 = load <31 x i16>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %66 = load <1 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %67 = load <2 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %68 = load <3 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %69 = load <4 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %70 = load <5 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %71 = load <6 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %72 = load <7 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %73 = load <8 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %74 = load <9 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %75 = load <10 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %76 = load <11 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %77 = load <12 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %78 = load <13 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %79 = load <14 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %80 = load <15 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %81 = load <17 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %82 = load <18 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %83 = load <19 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %84 = load <20 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %85 = load <21 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %86 = load <22 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %87 = load <23 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %88 = load <24 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %89 = load <25 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %90 = load <26 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %91 = load <27 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %92 = load <28 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %93 = load <29 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %94 = load <30 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %95 = load <31 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %96 = load <33 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %97 = load <34 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %98 = load <35 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %99 = load <36 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %100 = load <37 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %101 = load <38 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %102 = load <39 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %103 = load <40 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %104 = load <41 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %105 = load <42 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %106 = load <43 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %107 = load <44 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %108 = load <45 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %109 = load <46 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %110 = load <47 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %111 = load <48 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %112 = load <49 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %113 = load <50 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %114 = load <51 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %115 = load <52 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %116 = load <53 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %117 = load <54 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %118 = load <55 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %119 = load <56 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %120 = load <57 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %121 = load <58 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %122 = load <59 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %123 = load <60 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %124 = load <61 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %125 = load <62 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %126 = load <63 x i8>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %127 = load <3 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %128 = load <5 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %129 = load <6 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %130 = load <7 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %131 = load <9 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %132 = load <10 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %133 = load <11 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %134 = load <12 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %135 = load <13 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %136 = load <14 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %137 = load <15 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %138 = load <17 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %139 = load <18 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %140 = load <19 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %141 = load <20 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %142 = load <21 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %143 = load <22 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %144 = load <23 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %145 = load <24 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %146 = load <25 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %147 = load <26 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %148 = load <27 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %149 = load <28 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %150 = load <29 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %151 = load <30 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %152 = load <31 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %153 = load <33 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %154 = load <34 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %155 = load <35 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %156 = load <36 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %157 = load <37 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %158 = load <38 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %159 = load <39 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %160 = load <40 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %161 = load <41 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %162 = load <42 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %163 = load <43 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %164 = load <44 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %165 = load <45 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %166 = load <46 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %167 = load <47 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %168 = load <48 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %169 = load <49 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %170 = load <50 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %171 = load <51 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %172 = load <52 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %173 = load <53 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %174 = load <54 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %175 = load <55 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %176 = load <56 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %177 = load <57 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %178 = load <58 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %179 = load <59 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %180 = load <60 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %181 = load <61 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %182 = load <62 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %183 = load <63 x i1>, ptr undef, align 4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  load <1 x i64>, ptr undef, align 4
  ; <2 x i64> is XMM
  load <3 x i64>, ptr undef, align 4
  ; <4 x i64> is YMM
  load <5 x i64>, ptr undef, align 4
  load <6 x i64>, ptr undef, align 4
  load <7 x i64>, ptr undef, align 4
  ; <8 x i64> is ZMM

  ; Partial vectors with double elements
  load <1 x double>, ptr undef, align 4
  ; <2 x double> is XMM
  load <3 x double>, ptr undef, align 4
  ; <4 x double> is YMM
  load <5 x double>, ptr undef, align 4
  load <6 x double>, ptr undef, align 4
  load <7 x double>, ptr undef, align 4
  ; <8 x double> is ZMM

  ; Partial vectors with i32 elements
  load <1 x i32>, ptr undef, align 4
  load <2 x i32>, ptr undef, align 4
  load <3 x i32>, ptr undef, align 4
  ; <4 x i32> is XMM
  load <5 x i32>, ptr undef, align 4
  load <6 x i32>, ptr undef, align 4
  load <7 x i32>, ptr undef, align 4
  ; <8 x i32> is YMM
  load <9 x i32>, ptr undef, align 4
  load <10 x i32>, ptr undef, align 4
  load <11 x i32>, ptr undef, align 4
  load <12 x i32>, ptr undef, align 4
  load <13 x i32>, ptr undef, align 4
  load <14 x i32>, ptr undef, align 4
  load <15 x i32>, ptr undef, align 4
  ; <16 x i32> is ZMM

  ; Partial vectors with float elements
  load <1 x float>, ptr undef, align 4
  load <2 x float>, ptr undef, align 4
  load <3 x float>, ptr undef, align 4
  ; <4 x float> is XMM
  load <5 x float>, ptr undef, align 4
  load <6 x float>, ptr undef, align 4
  load <7 x float>, ptr undef, align 4
  ; <8 x float> is YMM
  load <9 x float>, ptr undef, align 4
  load <10 x float>, ptr undef, align 4
  load <11 x float>, ptr undef, align 4
  load <12 x float>, ptr undef, align 4
  load <13 x float>, ptr undef, align 4
  load <14 x float>, ptr undef, align 4
  load <15 x float>, ptr undef, align 4
  ; <16 x float> is ZMM

  ; Partial vectors with i16 elements
  load <1 x i16>, ptr undef, align 4
  load <2 x i16>, ptr undef, align 4
  load <3 x i16>, ptr undef, align 4
  load <4 x i16>, ptr undef, align 4
  load <5 x i16>, ptr undef, align 4
  load <6 x i16>, ptr undef, align 4
  load <7 x i16>, ptr undef, align 4
  ; <8 x i16> is XMM
  load <9 x i16>, ptr undef, align 4
  load <10 x i16>, ptr undef, align 4
  load <11 x i16>, ptr undef, align 4
  load <12 x i16>, ptr undef, align 4
  load <13 x i16>, ptr undef, align 4
  load <14 x i16>, ptr undef, align 4
  load <15 x i16>, ptr undef, align 4
  ; <16 x i16> is YMM
  load <17 x i16>, ptr undef, align 4
  load <18 x i16>, ptr undef, align 4
  load <19 x i16>, ptr undef, align 4
  load <20 x i16>, ptr undef, align 4
  load <21 x i16>, ptr undef, align 4
  load <22 x i16>, ptr undef, align 4
  load <23 x i16>, ptr undef, align 4
  load <24 x i16>, ptr undef, align 4
  load <25 x i16>, ptr undef, align 4
  load <26 x i16>, ptr undef, align 4
  load <27 x i16>, ptr undef, align 4
  load <28 x i16>, ptr undef, align 4
  load <29 x i16>, ptr undef, align 4
  load <30 x i16>, ptr undef, align 4
  load <31 x i16>, ptr undef, align 4
  ; <32 x i16> is ZMM

  ; Partial vectors with i8 elements
  load <1 x i8>, ptr undef, align 4
  load <2 x i8>, ptr undef, align 4
  load <3 x i8>, ptr undef, align 4
  load <4 x i8>, ptr undef, align 4
  load <5 x i8>, ptr undef, align 4
  load <6 x i8>, ptr undef, align 4
  load <7 x i8>, ptr undef, align 4
  load <8 x i8>, ptr undef, align 4
  load <9 x i8>, ptr undef, align 4
  load <10 x i8>, ptr undef, align 4
  load <11 x i8>, ptr undef, align 4
  load <12 x i8>, ptr undef, align 4
  load <13 x i8>, ptr undef, align 4
  load <14 x i8>, ptr undef, align 4
  load <15 x i8>, ptr undef, align 4
  ; <16 x i8> is XMM
  load <17 x i8>, ptr undef, align 4
  load <18 x i8>, ptr undef, align 4
  load <19 x i8>, ptr undef, align 4
  load <20 x i8>, ptr undef, align 4
  load <21 x i8>, ptr undef, align 4
  load <22 x i8>, ptr undef, align 4
  load <23 x i8>, ptr undef, align 4
  load <24 x i8>, ptr undef, align 4
  load <25 x i8>, ptr undef, align 4
  load <26 x i8>, ptr undef, align 4
  load <27 x i8>, ptr undef, align 4
  load <28 x i8>, ptr undef, align 4
  load <29 x i8>, ptr undef, align 4
  load <30 x i8>, ptr undef, align 4
  load <31 x i8>, ptr undef, align 4
  ; <32 x i8> is YMM
  load <33 x i8>, ptr undef, align 4
  load <34 x i8>, ptr undef, align 4
  load <35 x i8>, ptr undef, align 4
  load <36 x i8>, ptr undef, align 4
  load <37 x i8>, ptr undef, align 4
  load <38 x i8>, ptr undef, align 4
  load <39 x i8>, ptr undef, align 4
  load <40 x i8>, ptr undef, align 4
  load <41 x i8>, ptr undef, align 4
  load <42 x i8>, ptr undef, align 4
  load <43 x i8>, ptr undef, align 4
  load <44 x i8>, ptr undef, align 4
  load <45 x i8>, ptr undef, align 4
  load <46 x i8>, ptr undef, align 4
  load <47 x i8>, ptr undef, align 4
  load <48 x i8>, ptr undef, align 4
  load <49 x i8>, ptr undef, align 4
  load <50 x i8>, ptr undef, align 4
  load <51 x i8>, ptr undef, align 4
  load <52 x i8>, ptr undef, align 4
  load <53 x i8>, ptr undef, align 4
  load <54 x i8>, ptr undef, align 4
  load <55 x i8>, ptr undef, align 4
  load <56 x i8>, ptr undef, align 4
  load <57 x i8>, ptr undef, align 4
  load <58 x i8>, ptr undef, align 4
  load <59 x i8>, ptr undef, align 4
  load <60 x i8>, ptr undef, align 4
  load <61 x i8>, ptr undef, align 4
  load <62 x i8>, ptr undef, align 4
  load <63 x i8>, ptr undef, align 4
  ; <64 x i8> is ZMM

  ; Partial vectors with i1 elements
  ; <1 x i1> is XMM
  ; <2 x i1> is XMM
  load <3 x i1>, ptr undef, align 4
  ; <4 x i1> is XMM
  load <5 x i1>, ptr undef, align 4
  load <6 x i1>, ptr undef, align 4
  load <7 x i1>, ptr undef, align 4
  ; <8 x i1> is XMM
  load <9 x i1>, ptr undef, align 4
  load <10 x i1>, ptr undef, align 4
  load <11 x i1>, ptr undef, align 4
  load <12 x i1>, ptr undef, align 4
  load <13 x i1>, ptr undef, align 4
  load <14 x i1>, ptr undef, align 4
  load <15 x i1>, ptr undef, align 4
  ; <16 x i1> is XMM
  load <17 x i1>, ptr undef, align 4
  load <18 x i1>, ptr undef, align 4
  load <19 x i1>, ptr undef, align 4
  load <20 x i1>, ptr undef, align 4
  load <21 x i1>, ptr undef, align 4
  load <22 x i1>, ptr undef, align 4
  load <23 x i1>, ptr undef, align 4
  load <24 x i1>, ptr undef, align 4
  load <25 x i1>, ptr undef, align 4
  load <26 x i1>, ptr undef, align 4
  load <27 x i1>, ptr undef, align 4
  load <28 x i1>, ptr undef, align 4
  load <29 x i1>, ptr undef, align 4
  load <30 x i1>, ptr undef, align 4
  load <31 x i1>, ptr undef, align 4
  ; <32 x i1> is YMM
  load <33 x i1>, ptr undef, align 4
  load <34 x i1>, ptr undef, align 4
  load <35 x i1>, ptr undef, align 4
  load <36 x i1>, ptr undef, align 4
  load <37 x i1>, ptr undef, align 4
  load <38 x i1>, ptr undef, align 4
  load <39 x i1>, ptr undef, align 4
  load <40 x i1>, ptr undef, align 4
  load <41 x i1>, ptr undef, align 4
  load <42 x i1>, ptr undef, align 4
  load <43 x i1>, ptr undef, align 4
  load <44 x i1>, ptr undef, align 4
  load <45 x i1>, ptr undef, align 4
  load <46 x i1>, ptr undef, align 4
  load <47 x i1>, ptr undef, align 4
  load <48 x i1>, ptr undef, align 4
  load <49 x i1>, ptr undef, align 4
  load <50 x i1>, ptr undef, align 4
  load <51 x i1>, ptr undef, align 4
  load <52 x i1>, ptr undef, align 4
  load <53 x i1>, ptr undef, align 4
  load <54 x i1>, ptr undef, align 4
  load <55 x i1>, ptr undef, align 4
  load <56 x i1>, ptr undef, align 4
  load <57 x i1>, ptr undef, align 4
  load <58 x i1>, ptr undef, align 4
  load <59 x i1>, ptr undef, align 4
  load <60 x i1>, ptr undef, align 4
  load <61 x i1>, ptr undef, align 4
  load <62 x i1>, ptr undef, align 4
  load <63 x i1>, ptr undef, align 4
  ; <64 x i1> is ZMM

  ret i32 undef
}

define i32 @loads_align1(i32 %arg) {
  ; Scalars
; SSE2-LABEL: 'loads_align1'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = load i8, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %2 = load i16, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %3 = load i32, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %4 = load i64, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %5 = load i128, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %6 = load i256, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %7 = load i512, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %8 = load float, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %9 = load double, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %10 = load ptr, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %11 = load ptr, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %12 = load <128 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %13 = load <16 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %14 = load <8 x i16>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %15 = load <4 x i32>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %16 = load <2 x i64>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %17 = load <1 x i128>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %18 = load <4 x float>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %19 = load <2 x double>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %20 = load <2 x ptr>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %21 = load <16 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %22 = load <8 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %23 = load <4 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %24 = load <2 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %25 = load <1 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %26 = load <256 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %27 = load <32 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %28 = load <16 x i16>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %29 = load <8 x i32>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %30 = load <4 x i64>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %31 = load <2 x i128>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %32 = load <1 x i256>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %33 = load <8 x float>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %34 = load <4 x double>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %35 = load <4 x ptr>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %36 = load <32 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %37 = load <512 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %38 = load <64 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %39 = load <32 x i16>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %40 = load <16 x i32>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %41 = load <8 x i64>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %42 = load <4 x i128>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %43 = load <2 x i256>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %44 = load <1 x i512>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %45 = load <16 x float>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %46 = load <8 x double>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %47 = load <8 x ptr>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %48 = load <64 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SSE41-LABEL: 'loads_align1'
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = load i8, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %2 = load i16, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %3 = load i32, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %4 = load i64, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %5 = load i128, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %6 = load i256, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %7 = load i512, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %8 = load float, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %9 = load double, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %10 = load ptr, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %11 = load ptr, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %12 = load <128 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %13 = load <16 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %14 = load <8 x i16>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %15 = load <4 x i32>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %16 = load <2 x i64>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %17 = load <1 x i128>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %18 = load <4 x float>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %19 = load <2 x double>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %20 = load <2 x ptr>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %21 = load <16 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %22 = load <8 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %23 = load <4 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %24 = load <2 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %25 = load <1 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %26 = load <256 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %27 = load <32 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %28 = load <16 x i16>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %29 = load <8 x i32>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %30 = load <4 x i64>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %31 = load <2 x i128>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %32 = load <1 x i256>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %33 = load <8 x float>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %34 = load <4 x double>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %35 = load <4 x ptr>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %36 = load <32 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %37 = load <512 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %38 = load <64 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %39 = load <32 x i16>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %40 = load <16 x i32>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %41 = load <8 x i64>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %42 = load <4 x i128>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %43 = load <2 x i256>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %44 = load <1 x i512>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %45 = load <16 x float>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %46 = load <8 x double>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %47 = load <8 x ptr>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %48 = load <64 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX-LABEL: 'loads_align1'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = load i8, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %2 = load i16, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %3 = load i32, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %4 = load i64, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %5 = load i128, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %6 = load i256, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %7 = load i512, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %8 = load float, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %9 = load double, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %10 = load ptr, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %11 = load ptr, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %12 = load <128 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %13 = load <16 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %14 = load <8 x i16>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %15 = load <4 x i32>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %16 = load <2 x i64>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %17 = load <1 x i128>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %18 = load <4 x float>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %19 = load <2 x double>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %20 = load <2 x ptr>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %21 = load <16 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %22 = load <8 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %23 = load <4 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %24 = load <2 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %25 = load <1 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %26 = load <256 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %27 = load <32 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %28 = load <16 x i16>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %29 = load <8 x i32>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %30 = load <4 x i64>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %31 = load <2 x i128>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %32 = load <1 x i256>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %33 = load <8 x float>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %34 = load <4 x double>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %35 = load <4 x ptr>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %36 = load <32 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %37 = load <512 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %38 = load <64 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %39 = load <32 x i16>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %40 = load <16 x i32>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %41 = load <8 x i64>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %42 = load <4 x i128>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %43 = load <2 x i256>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %44 = load <1 x i512>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %45 = load <16 x float>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %46 = load <8 x double>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %47 = load <8 x ptr>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %48 = load <64 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512-LABEL: 'loads_align1'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = load i8, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %2 = load i16, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %3 = load i32, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %4 = load i64, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %5 = load i128, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %6 = load i256, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %7 = load i512, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %8 = load float, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %9 = load double, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %10 = load ptr, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %11 = load ptr, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %12 = load <128 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %13 = load <16 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %14 = load <8 x i16>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %15 = load <4 x i32>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %16 = load <2 x i64>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %17 = load <1 x i128>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %18 = load <4 x float>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %19 = load <2 x double>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %20 = load <2 x ptr>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %21 = load <16 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %22 = load <8 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %23 = load <4 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %24 = load <2 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %25 = load <1 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %26 = load <256 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %27 = load <32 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %28 = load <16 x i16>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %29 = load <8 x i32>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %30 = load <4 x i64>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %31 = load <2 x i128>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %32 = load <1 x i256>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %33 = load <8 x float>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %34 = load <4 x double>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %35 = load <4 x ptr>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %36 = load <32 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %37 = load <512 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %38 = load <64 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %39 = load <32 x i16>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %40 = load <16 x i32>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %41 = load <8 x i64>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %42 = load <4 x i128>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %43 = load <2 x i256>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %44 = load <1 x i512>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %45 = load <16 x float>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %46 = load <8 x double>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %47 = load <8 x ptr>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %48 = load <64 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  load i8, ptr undef, align 1
  load i16, ptr undef, align 1
  load i32, ptr undef, align 1
  load i64, ptr undef, align 1
  load i128, ptr undef, align 1
  load i256, ptr undef, align 1
  load i512, ptr undef, align 1

  load float, ptr undef, align 1
  load double, ptr undef, align 1

  load ptr, ptr undef, align 1

  load ptr, ptr undef, align 1

  ; XMM (128-bit) vectors
  load <128 x i1>, ptr undef, align 1
  load <16 x i8>, ptr undef, align 1
  load <8 x i16>, ptr undef, align 1
  load <4 x i32>, ptr undef, align 1
  load <2 x i64>, ptr undef, align 1
  load <1 x i128>, ptr undef, align 1

  load <4 x float>, ptr undef, align 1
  load <2 x double>, ptr undef, align 1

  load <2 x ptr>, ptr undef, align 1

  load <16 x i1>, ptr undef, align 1
  load <8 x i1>, ptr undef, align 1
  load <4 x i1>, ptr undef, align 1
  load <2 x i1>, ptr undef, align 1
  load <1 x i1>, ptr undef, align 1

  ; YMM (256-bit) vectors
  load <256 x i1>, ptr undef, align 1
  load <32 x i8>, ptr undef, align 1
  load <16 x i16>, ptr undef, align 1
  load <8 x i32>, ptr undef, align 1
  load <4 x i64>, ptr undef, align 1
  load <2 x i128>, ptr undef, align 1
  load <1 x i256>, ptr undef, align 1

  load <8 x float>, ptr undef, align 1
  load <4 x double>, ptr undef, align 1

  load <4 x ptr>, ptr undef, align 1

  load <32 x i1>, ptr undef, align 1

  ; ZMM (512-bit) vectors
  load <512 x i1>, ptr undef, align 1
  load <64 x i8>, ptr undef, align 1
  load <32 x i16>, ptr undef, align 1
  load <16 x i32>, ptr undef, align 1
  load <8 x i64>, ptr undef, align 1
  load <4 x i128>, ptr undef, align 1
  load <2 x i256>, ptr undef, align 1
  load <1 x i512>, ptr undef, align 1

  load <16 x float>, ptr undef, align 1
  load <8 x double>, ptr undef, align 1

  load <8 x ptr>, ptr undef, align 1

  load <64 x i1>, ptr undef, align 1

  ret i32 undef
}

define i32 @loads_partial_align1(i32 %arg) {
  ; Partial vectors with i64 elements (doubles as pointer-sized tests))
; SSE2-LABEL: 'loads_partial_align1'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = load <1 x i64>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %2 = load <3 x i64>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %3 = load <5 x i64>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %4 = load <6 x i64>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %5 = load <7 x i64>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %6 = load <1 x double>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %7 = load <3 x double>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %8 = load <5 x double>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %9 = load <6 x double>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %10 = load <7 x double>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %11 = load <1 x i32>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %12 = load <2 x i32>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %13 = load <3 x i32>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %14 = load <5 x i32>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %15 = load <6 x i32>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %16 = load <7 x i32>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %17 = load <9 x i32>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %18 = load <10 x i32>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %19 = load <11 x i32>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %20 = load <12 x i32>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %21 = load <13 x i32>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %22 = load <14 x i32>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %23 = load <15 x i32>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %24 = load <1 x float>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %25 = load <2 x float>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %26 = load <3 x float>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %27 = load <5 x float>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %28 = load <6 x float>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %29 = load <7 x float>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %30 = load <9 x float>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %31 = load <10 x float>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %32 = load <11 x float>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %33 = load <12 x float>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %34 = load <13 x float>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %35 = load <14 x float>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %36 = load <15 x float>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %37 = load <1 x i16>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %38 = load <2 x i16>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %39 = load <3 x i16>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %40 = load <4 x i16>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %41 = load <5 x i16>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %42 = load <6 x i16>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %43 = load <7 x i16>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %44 = load <9 x i16>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %45 = load <10 x i16>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %46 = load <11 x i16>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %47 = load <12 x i16>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %48 = load <13 x i16>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %49 = load <14 x i16>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %50 = load <15 x i16>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %51 = load <17 x i16>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %52 = load <18 x i16>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %53 = load <19 x i16>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %54 = load <20 x i16>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %55 = load <21 x i16>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %56 = load <22 x i16>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %57 = load <23 x i16>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %58 = load <24 x i16>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %59 = load <25 x i16>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %60 = load <26 x i16>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %61 = load <27 x i16>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %62 = load <28 x i16>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %63 = load <29 x i16>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %64 = load <30 x i16>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %65 = load <31 x i16>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %66 = load <1 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %67 = load <2 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %68 = load <3 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %69 = load <4 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %70 = load <5 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %71 = load <6 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %72 = load <7 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %73 = load <8 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %74 = load <9 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %75 = load <10 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %76 = load <11 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %77 = load <12 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %78 = load <13 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %79 = load <14 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %80 = load <15 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %81 = load <17 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %82 = load <18 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %83 = load <19 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %84 = load <20 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %85 = load <21 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %86 = load <22 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 21 for instruction: %87 = load <23 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %88 = load <24 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %89 = load <25 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %90 = load <26 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 21 for instruction: %91 = load <27 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %92 = load <28 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %93 = load <29 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %94 = load <30 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %95 = load <31 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %96 = load <33 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %97 = load <34 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %98 = load <35 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %99 = load <36 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %100 = load <37 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %101 = load <38 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %102 = load <39 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %103 = load <40 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %104 = load <41 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %105 = load <42 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %106 = load <43 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %107 = load <44 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %108 = load <45 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %109 = load <46 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 27 for instruction: %110 = load <47 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %111 = load <48 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %112 = load <49 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %113 = load <50 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 21 for instruction: %114 = load <51 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %115 = load <52 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 21 for instruction: %116 = load <53 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %117 = load <54 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %118 = load <55 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %119 = load <56 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 21 for instruction: %120 = load <57 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %121 = load <58 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %122 = load <59 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %123 = load <60 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %124 = load <61 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %125 = load <62 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %126 = load <63 x i8>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %127 = load <3 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %128 = load <5 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %129 = load <6 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %130 = load <7 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %131 = load <9 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %132 = load <10 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %133 = load <11 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %134 = load <12 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %135 = load <13 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %136 = load <14 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %137 = load <15 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %138 = load <17 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %139 = load <18 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %140 = load <19 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %141 = load <20 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %142 = load <21 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %143 = load <22 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %144 = load <23 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %145 = load <24 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %146 = load <25 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %147 = load <26 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %148 = load <27 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %149 = load <28 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %150 = load <29 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %151 = load <30 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %152 = load <31 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %153 = load <33 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %154 = load <34 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %155 = load <35 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %156 = load <36 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %157 = load <37 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %158 = load <38 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %159 = load <39 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %160 = load <40 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %161 = load <41 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %162 = load <42 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %163 = load <43 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %164 = load <44 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %165 = load <45 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %166 = load <46 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %167 = load <47 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %168 = load <48 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %169 = load <49 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %170 = load <50 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %171 = load <51 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %172 = load <52 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %173 = load <53 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %174 = load <54 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %175 = load <55 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %176 = load <56 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %177 = load <57 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %178 = load <58 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %179 = load <59 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %180 = load <60 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %181 = load <61 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %182 = load <62 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %183 = load <63 x i1>, ptr undef, align 1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SSE41-LABEL: 'loads_partial_align1'
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = load <1 x i64>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %2 = load <3 x i64>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %3 = load <5 x i64>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %4 = load <6 x i64>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %5 = load <7 x i64>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %6 = load <1 x double>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %7 = load <3 x double>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %8 = load <5 x double>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %9 = load <6 x double>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %10 = load <7 x double>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %11 = load <1 x i32>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %12 = load <2 x i32>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %13 = load <3 x i32>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %14 = load <5 x i32>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %15 = load <6 x i32>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %16 = load <7 x i32>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %17 = load <9 x i32>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %18 = load <10 x i32>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %19 = load <11 x i32>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %20 = load <12 x i32>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %21 = load <13 x i32>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %22 = load <14 x i32>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %23 = load <15 x i32>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %24 = load <1 x float>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %25 = load <2 x float>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %26 = load <3 x float>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %27 = load <5 x float>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %28 = load <6 x float>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %29 = load <7 x float>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %30 = load <9 x float>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %31 = load <10 x float>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %32 = load <11 x float>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %33 = load <12 x float>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %34 = load <13 x float>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %35 = load <14 x float>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %36 = load <15 x float>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %37 = load <1 x i16>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %38 = load <2 x i16>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %39 = load <3 x i16>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %40 = load <4 x i16>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %41 = load <5 x i16>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %42 = load <6 x i16>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %43 = load <7 x i16>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %44 = load <9 x i16>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %45 = load <10 x i16>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %46 = load <11 x i16>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %47 = load <12 x i16>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %48 = load <13 x i16>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %49 = load <14 x i16>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %50 = load <15 x i16>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %51 = load <17 x i16>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %52 = load <18 x i16>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %53 = load <19 x i16>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %54 = load <20 x i16>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %55 = load <21 x i16>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %56 = load <22 x i16>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %57 = load <23 x i16>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %58 = load <24 x i16>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %59 = load <25 x i16>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %60 = load <26 x i16>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %61 = load <27 x i16>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %62 = load <28 x i16>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %63 = load <29 x i16>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %64 = load <30 x i16>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %65 = load <31 x i16>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %66 = load <1 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %67 = load <2 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %68 = load <3 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %69 = load <4 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %70 = load <5 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %71 = load <6 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %72 = load <7 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %73 = load <8 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %74 = load <9 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %75 = load <10 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %76 = load <11 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %77 = load <12 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %78 = load <13 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %79 = load <14 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %80 = load <15 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %81 = load <17 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %82 = load <18 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %83 = load <19 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %84 = load <20 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %85 = load <21 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %86 = load <22 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %87 = load <23 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %88 = load <24 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %89 = load <25 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %90 = load <26 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %91 = load <27 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %92 = load <28 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %93 = load <29 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %94 = load <30 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %95 = load <31 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %96 = load <33 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %97 = load <34 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %98 = load <35 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %99 = load <36 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %100 = load <37 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %101 = load <38 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %102 = load <39 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %103 = load <40 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %104 = load <41 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %105 = load <42 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %106 = load <43 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %107 = load <44 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %108 = load <45 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %109 = load <46 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %110 = load <47 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %111 = load <48 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %112 = load <49 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %113 = load <50 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %114 = load <51 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %115 = load <52 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %116 = load <53 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %117 = load <54 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %118 = load <55 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %119 = load <56 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %120 = load <57 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %121 = load <58 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %122 = load <59 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %123 = load <60 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %124 = load <61 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %125 = load <62 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %126 = load <63 x i8>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %127 = load <3 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %128 = load <5 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %129 = load <6 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %130 = load <7 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %131 = load <9 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %132 = load <10 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %133 = load <11 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %134 = load <12 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %135 = load <13 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %136 = load <14 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %137 = load <15 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %138 = load <17 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %139 = load <18 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %140 = load <19 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %141 = load <20 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %142 = load <21 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %143 = load <22 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %144 = load <23 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %145 = load <24 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %146 = load <25 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %147 = load <26 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %148 = load <27 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %149 = load <28 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %150 = load <29 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %151 = load <30 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %152 = load <31 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %153 = load <33 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %154 = load <34 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %155 = load <35 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %156 = load <36 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %157 = load <37 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %158 = load <38 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %159 = load <39 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %160 = load <40 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %161 = load <41 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %162 = load <42 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %163 = load <43 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %164 = load <44 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %165 = load <45 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %166 = load <46 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %167 = load <47 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %168 = load <48 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %169 = load <49 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %170 = load <50 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %171 = load <51 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %172 = load <52 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %173 = load <53 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %174 = load <54 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %175 = load <55 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %176 = load <56 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %177 = load <57 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %178 = load <58 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %179 = load <59 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %180 = load <60 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %181 = load <61 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %182 = load <62 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %183 = load <63 x i1>, ptr undef, align 1
; SSE41-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX-LABEL: 'loads_partial_align1'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = load <1 x i64>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %2 = load <3 x i64>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %3 = load <5 x i64>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %4 = load <6 x i64>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %5 = load <7 x i64>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %6 = load <1 x double>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %7 = load <3 x double>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %8 = load <5 x double>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %9 = load <6 x double>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %10 = load <7 x double>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %11 = load <1 x i32>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %12 = load <2 x i32>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %13 = load <3 x i32>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %14 = load <5 x i32>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %15 = load <6 x i32>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %16 = load <7 x i32>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %17 = load <9 x i32>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %18 = load <10 x i32>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %19 = load <11 x i32>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %20 = load <12 x i32>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %21 = load <13 x i32>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %22 = load <14 x i32>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %23 = load <15 x i32>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %24 = load <1 x float>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %25 = load <2 x float>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %26 = load <3 x float>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %27 = load <5 x float>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %28 = load <6 x float>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %29 = load <7 x float>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %30 = load <9 x float>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %31 = load <10 x float>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %32 = load <11 x float>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %33 = load <12 x float>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %34 = load <13 x float>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %35 = load <14 x float>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %36 = load <15 x float>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %37 = load <1 x i16>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %38 = load <2 x i16>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %39 = load <3 x i16>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %40 = load <4 x i16>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %41 = load <5 x i16>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %42 = load <6 x i16>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %43 = load <7 x i16>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %44 = load <9 x i16>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %45 = load <10 x i16>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %46 = load <11 x i16>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %47 = load <12 x i16>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %48 = load <13 x i16>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %49 = load <14 x i16>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %50 = load <15 x i16>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %51 = load <17 x i16>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %52 = load <18 x i16>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %53 = load <19 x i16>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %54 = load <20 x i16>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %55 = load <21 x i16>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %56 = load <22 x i16>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %57 = load <23 x i16>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %58 = load <24 x i16>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %59 = load <25 x i16>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %60 = load <26 x i16>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %61 = load <27 x i16>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %62 = load <28 x i16>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %63 = load <29 x i16>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %64 = load <30 x i16>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %65 = load <31 x i16>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %66 = load <1 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %67 = load <2 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %68 = load <3 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %69 = load <4 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %70 = load <5 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %71 = load <6 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %72 = load <7 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %73 = load <8 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %74 = load <9 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %75 = load <10 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %76 = load <11 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %77 = load <12 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %78 = load <13 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %79 = load <14 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %80 = load <15 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %81 = load <17 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %82 = load <18 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %83 = load <19 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %84 = load <20 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %85 = load <21 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %86 = load <22 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %87 = load <23 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %88 = load <24 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %89 = load <25 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %90 = load <26 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %91 = load <27 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %92 = load <28 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %93 = load <29 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %94 = load <30 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %95 = load <31 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %96 = load <33 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %97 = load <34 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %98 = load <35 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %99 = load <36 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %100 = load <37 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %101 = load <38 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %102 = load <39 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %103 = load <40 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %104 = load <41 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %105 = load <42 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %106 = load <43 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %107 = load <44 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %108 = load <45 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %109 = load <46 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %110 = load <47 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %111 = load <48 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %112 = load <49 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %113 = load <50 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %114 = load <51 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %115 = load <52 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %116 = load <53 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %117 = load <54 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %118 = load <55 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %119 = load <56 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %120 = load <57 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %121 = load <58 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %122 = load <59 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %123 = load <60 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %124 = load <61 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %125 = load <62 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %126 = load <63 x i8>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %127 = load <3 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %128 = load <5 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %129 = load <6 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %130 = load <7 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %131 = load <9 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %132 = load <10 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %133 = load <11 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %134 = load <12 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %135 = load <13 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %136 = load <14 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %137 = load <15 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %138 = load <17 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %139 = load <18 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %140 = load <19 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %141 = load <20 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %142 = load <21 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %143 = load <22 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %144 = load <23 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %145 = load <24 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %146 = load <25 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %147 = load <26 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %148 = load <27 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %149 = load <28 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %150 = load <29 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %151 = load <30 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %152 = load <31 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %153 = load <33 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %154 = load <34 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %155 = load <35 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %156 = load <36 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %157 = load <37 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %158 = load <38 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %159 = load <39 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %160 = load <40 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %161 = load <41 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %162 = load <42 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %163 = load <43 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %164 = load <44 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %165 = load <45 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %166 = load <46 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %167 = load <47 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %168 = load <48 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %169 = load <49 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %170 = load <50 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %171 = load <51 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %172 = load <52 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %173 = load <53 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %174 = load <54 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %175 = load <55 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %176 = load <56 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %177 = load <57 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %178 = load <58 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %179 = load <59 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %180 = load <60 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %181 = load <61 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %182 = load <62 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %183 = load <63 x i1>, ptr undef, align 1
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512-LABEL: 'loads_partial_align1'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = load <1 x i64>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %2 = load <3 x i64>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %3 = load <5 x i64>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %4 = load <6 x i64>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %5 = load <7 x i64>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %6 = load <1 x double>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %7 = load <3 x double>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %8 = load <5 x double>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %9 = load <6 x double>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %10 = load <7 x double>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %11 = load <1 x i32>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %12 = load <2 x i32>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %13 = load <3 x i32>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %14 = load <5 x i32>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %15 = load <6 x i32>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %16 = load <7 x i32>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %17 = load <9 x i32>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %18 = load <10 x i32>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %19 = load <11 x i32>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %20 = load <12 x i32>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %21 = load <13 x i32>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %22 = load <14 x i32>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %23 = load <15 x i32>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %24 = load <1 x float>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %25 = load <2 x float>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %26 = load <3 x float>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %27 = load <5 x float>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %28 = load <6 x float>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %29 = load <7 x float>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %30 = load <9 x float>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %31 = load <10 x float>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %32 = load <11 x float>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %33 = load <12 x float>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %34 = load <13 x float>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %35 = load <14 x float>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %36 = load <15 x float>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %37 = load <1 x i16>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %38 = load <2 x i16>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %39 = load <3 x i16>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %40 = load <4 x i16>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %41 = load <5 x i16>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %42 = load <6 x i16>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %43 = load <7 x i16>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %44 = load <9 x i16>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %45 = load <10 x i16>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %46 = load <11 x i16>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %47 = load <12 x i16>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %48 = load <13 x i16>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %49 = load <14 x i16>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %50 = load <15 x i16>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %51 = load <17 x i16>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %52 = load <18 x i16>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %53 = load <19 x i16>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %54 = load <20 x i16>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %55 = load <21 x i16>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %56 = load <22 x i16>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %57 = load <23 x i16>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %58 = load <24 x i16>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %59 = load <25 x i16>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %60 = load <26 x i16>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %61 = load <27 x i16>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %62 = load <28 x i16>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %63 = load <29 x i16>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %64 = load <30 x i16>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %65 = load <31 x i16>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %66 = load <1 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %67 = load <2 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %68 = load <3 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %69 = load <4 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %70 = load <5 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %71 = load <6 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %72 = load <7 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %73 = load <8 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %74 = load <9 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %75 = load <10 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %76 = load <11 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %77 = load <12 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %78 = load <13 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %79 = load <14 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %80 = load <15 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %81 = load <17 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %82 = load <18 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %83 = load <19 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %84 = load <20 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %85 = load <21 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %86 = load <22 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %87 = load <23 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %88 = load <24 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %89 = load <25 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %90 = load <26 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %91 = load <27 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %92 = load <28 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %93 = load <29 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %94 = load <30 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %95 = load <31 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %96 = load <33 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %97 = load <34 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %98 = load <35 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %99 = load <36 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %100 = load <37 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %101 = load <38 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %102 = load <39 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %103 = load <40 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %104 = load <41 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %105 = load <42 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %106 = load <43 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %107 = load <44 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %108 = load <45 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %109 = load <46 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %110 = load <47 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %111 = load <48 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %112 = load <49 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %113 = load <50 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %114 = load <51 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %115 = load <52 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %116 = load <53 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %117 = load <54 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %118 = load <55 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %119 = load <56 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %120 = load <57 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %121 = load <58 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %122 = load <59 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %123 = load <60 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %124 = load <61 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %125 = load <62 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %126 = load <63 x i8>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %127 = load <3 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %128 = load <5 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %129 = load <6 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %130 = load <7 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %131 = load <9 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %132 = load <10 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %133 = load <11 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %134 = load <12 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %135 = load <13 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %136 = load <14 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %137 = load <15 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %138 = load <17 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %139 = load <18 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %140 = load <19 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %141 = load <20 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %142 = load <21 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %143 = load <22 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %144 = load <23 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %145 = load <24 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %146 = load <25 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %147 = load <26 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %148 = load <27 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %149 = load <28 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %150 = load <29 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %151 = load <30 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %152 = load <31 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %153 = load <33 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %154 = load <34 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %155 = load <35 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %156 = load <36 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %157 = load <37 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %158 = load <38 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %159 = load <39 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %160 = load <40 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %161 = load <41 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %162 = load <42 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %163 = load <43 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %164 = load <44 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %165 = load <45 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %166 = load <46 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %167 = load <47 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %168 = load <48 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %169 = load <49 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %170 = load <50 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %171 = load <51 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %172 = load <52 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %173 = load <53 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %174 = load <54 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %175 = load <55 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %176 = load <56 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %177 = load <57 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %178 = load <58 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %179 = load <59 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %180 = load <60 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %181 = load <61 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %182 = load <62 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %183 = load <63 x i1>, ptr undef, align 1
; AVX512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  load <1 x i64>, ptr undef, align 1
  ; <2 x i64> is XMM
  load <3 x i64>, ptr undef, align 1
  ; <4 x i64> is YMM
  load <5 x i64>, ptr undef, align 1
  load <6 x i64>, ptr undef, align 1
  load <7 x i64>, ptr undef, align 1
  ; <8 x i64> is ZMM

  ; Partial vectors with double elements
  load <1 x double>, ptr undef, align 1
  ; <2 x double> is XMM
  load <3 x double>, ptr undef, align 1
  ; <4 x double> is YMM
  load <5 x double>, ptr undef, align 1
  load <6 x double>, ptr undef, align 1
  load <7 x double>, ptr undef, align 1
  ; <8 x double> is ZMM

  ; Partial vectors with i32 elements
  load <1 x i32>, ptr undef, align 1
  load <2 x i32>, ptr undef, align 1
  load <3 x i32>, ptr undef, align 1
  ; <4 x i32> is XMM
  load <5 x i32>, ptr undef, align 1
  load <6 x i32>, ptr undef, align 1
  load <7 x i32>, ptr undef, align 1
  ; <8 x i32> is YMM
  load <9 x i32>, ptr undef, align 1
  load <10 x i32>, ptr undef, align 1
  load <11 x i32>, ptr undef, align 1
  load <12 x i32>, ptr undef, align 1
  load <13 x i32>, ptr undef, align 1
  load <14 x i32>, ptr undef, align 1
  load <15 x i32>, ptr undef, align 1
  ; <16 x i32> is ZMM

  ; Partial vectors with float elements
  load <1 x float>, ptr undef, align 1
  load <2 x float>, ptr undef, align 1
  load <3 x float>, ptr undef, align 1
  ; <4 x float> is XMM
  load <5 x float>, ptr undef, align 1
  load <6 x float>, ptr undef, align 1
  load <7 x float>, ptr undef, align 1
  ; <8 x float> is YMM
  load <9 x float>, ptr undef, align 1
  load <10 x float>, ptr undef, align 1
  load <11 x float>, ptr undef, align 1
  load <12 x float>, ptr undef, align 1
  load <13 x float>, ptr undef, align 1
  load <14 x float>, ptr undef, align 1
  load <15 x float>, ptr undef, align 1
  ; <16 x float> is ZMM

  ; Partial vectors with i16 elements
  load <1 x i16>, ptr undef, align 1
  load <2 x i16>, ptr undef, align 1
  load <3 x i16>, ptr undef, align 1
  load <4 x i16>, ptr undef, align 1
  load <5 x i16>, ptr undef, align 1
  load <6 x i16>, ptr undef, align 1
  load <7 x i16>, ptr undef, align 1
  ; <8 x i16> is XMM
  load <9 x i16>, ptr undef, align 1
  load <10 x i16>, ptr undef, align 1
  load <11 x i16>, ptr undef, align 1
  load <12 x i16>, ptr undef, align 1
  load <13 x i16>, ptr undef, align 1
  load <14 x i16>, ptr undef, align 1
  load <15 x i16>, ptr undef, align 1
  ; <16 x i16> is YMM
  load <17 x i16>, ptr undef, align 1
  load <18 x i16>, ptr undef, align 1
  load <19 x i16>, ptr undef, align 1
  load <20 x i16>, ptr undef, align 1
  load <21 x i16>, ptr undef, align 1
  load <22 x i16>, ptr undef, align 1
  load <23 x i16>, ptr undef, align 1
  load <24 x i16>, ptr undef, align 1
  load <25 x i16>, ptr undef, align 1
  load <26 x i16>, ptr undef, align 1
  load <27 x i16>, ptr undef, align 1
  load <28 x i16>, ptr undef, align 1
  load <29 x i16>, ptr undef, align 1
  load <30 x i16>, ptr undef, align 1
  load <31 x i16>, ptr undef, align 1
  ; <32 x i16> is ZMM

  ; Partial vectors with i8 elements
  load <1 x i8>, ptr undef, align 1
  load <2 x i8>, ptr undef, align 1
  load <3 x i8>, ptr undef, align 1
  load <4 x i8>, ptr undef, align 1
  load <5 x i8>, ptr undef, align 1
  load <6 x i8>, ptr undef, align 1
  load <7 x i8>, ptr undef, align 1
  load <8 x i8>, ptr undef, align 1
  load <9 x i8>, ptr undef, align 1
  load <10 x i8>, ptr undef, align 1
  load <11 x i8>, ptr undef, align 1
  load <12 x i8>, ptr undef, align 1
  load <13 x i8>, ptr undef, align 1
  load <14 x i8>, ptr undef, align 1
  load <15 x i8>, ptr undef, align 1
  ; <16 x i8> is XMM
  load <17 x i8>, ptr undef, align 1
  load <18 x i8>, ptr undef, align 1
  load <19 x i8>, ptr undef, align 1
  load <20 x i8>, ptr undef, align 1
  load <21 x i8>, ptr undef, align 1
  load <22 x i8>, ptr undef, align 1
  load <23 x i8>, ptr undef, align 1
  load <24 x i8>, ptr undef, align 1
  load <25 x i8>, ptr undef, align 1
  load <26 x i8>, ptr undef, align 1
  load <27 x i8>, ptr undef, align 1
  load <28 x i8>, ptr undef, align 1
  load <29 x i8>, ptr undef, align 1
  load <30 x i8>, ptr undef, align 1
  load <31 x i8>, ptr undef, align 1
  ; <32 x i8> is YMM
  load <33 x i8>, ptr undef, align 1
  load <34 x i8>, ptr undef, align 1
  load <35 x i8>, ptr undef, align 1
  load <36 x i8>, ptr undef, align 1
  load <37 x i8>, ptr undef, align 1
  load <38 x i8>, ptr undef, align 1
  load <39 x i8>, ptr undef, align 1
  load <40 x i8>, ptr undef, align 1
  load <41 x i8>, ptr undef, align 1
  load <42 x i8>, ptr undef, align 1
  load <43 x i8>, ptr undef, align 1
  load <44 x i8>, ptr undef, align 1
  load <45 x i8>, ptr undef, align 1
  load <46 x i8>, ptr undef, align 1
  load <47 x i8>, ptr undef, align 1
  load <48 x i8>, ptr undef, align 1
  load <49 x i8>, ptr undef, align 1
  load <50 x i8>, ptr undef, align 1
  load <51 x i8>, ptr undef, align 1
  load <52 x i8>, ptr undef, align 1
  load <53 x i8>, ptr undef, align 1
  load <54 x i8>, ptr undef, align 1
  load <55 x i8>, ptr undef, align 1
  load <56 x i8>, ptr undef, align 1
  load <57 x i8>, ptr undef, align 1
  load <58 x i8>, ptr undef, align 1
  load <59 x i8>, ptr undef, align 1
  load <60 x i8>, ptr undef, align 1
  load <61 x i8>, ptr undef, align 1
  load <62 x i8>, ptr undef, align 1
  load <63 x i8>, ptr undef, align 1
  ; <64 x i8> is ZMM

  ; Partial vectors with i1 elements
  ; <1 x i1> is XMM
  ; <2 x i1> is XMM
  load <3 x i1>, ptr undef, align 1
  ; <4 x i1> is XMM
  load <5 x i1>, ptr undef, align 1
  load <6 x i1>, ptr undef, align 1
  load <7 x i1>, ptr undef, align 1
  ; <8 x i1> is XMM
  load <9 x i1>, ptr undef, align 1
  load <10 x i1>, ptr undef, align 1
  load <11 x i1>, ptr undef, align 1
  load <12 x i1>, ptr undef, align 1
  load <13 x i1>, ptr undef, align 1
  load <14 x i1>, ptr undef, align 1
  load <15 x i1>, ptr undef, align 1
  ; <16 x i1> is XMM
  load <17 x i1>, ptr undef, align 1
  load <18 x i1>, ptr undef, align 1
  load <19 x i1>, ptr undef, align 1
  load <20 x i1>, ptr undef, align 1
  load <21 x i1>, ptr undef, align 1
  load <22 x i1>, ptr undef, align 1
  load <23 x i1>, ptr undef, align 1
  load <24 x i1>, ptr undef, align 1
  load <25 x i1>, ptr undef, align 1
  load <26 x i1>, ptr undef, align 1
  load <27 x i1>, ptr undef, align 1
  load <28 x i1>, ptr undef, align 1
  load <29 x i1>, ptr undef, align 1
  load <30 x i1>, ptr undef, align 1
  load <31 x i1>, ptr undef, align 1
  ; <32 x i1> is YMM
  load <33 x i1>, ptr undef, align 1
  load <34 x i1>, ptr undef, align 1
  load <35 x i1>, ptr undef, align 1
  load <36 x i1>, ptr undef, align 1
  load <37 x i1>, ptr undef, align 1
  load <38 x i1>, ptr undef, align 1
  load <39 x i1>, ptr undef, align 1
  load <40 x i1>, ptr undef, align 1
  load <41 x i1>, ptr undef, align 1
  load <42 x i1>, ptr undef, align 1
  load <43 x i1>, ptr undef, align 1
  load <44 x i1>, ptr undef, align 1
  load <45 x i1>, ptr undef, align 1
  load <46 x i1>, ptr undef, align 1
  load <47 x i1>, ptr undef, align 1
  load <48 x i1>, ptr undef, align 1
  load <49 x i1>, ptr undef, align 1
  load <50 x i1>, ptr undef, align 1
  load <51 x i1>, ptr undef, align 1
  load <52 x i1>, ptr undef, align 1
  load <53 x i1>, ptr undef, align 1
  load <54 x i1>, ptr undef, align 1
  load <55 x i1>, ptr undef, align 1
  load <56 x i1>, ptr undef, align 1
  load <57 x i1>, ptr undef, align 1
  load <58 x i1>, ptr undef, align 1
  load <59 x i1>, ptr undef, align 1
  load <60 x i1>, ptr undef, align 1
  load <61 x i1>, ptr undef, align 1
  load <62 x i1>, ptr undef, align 1
  load <63 x i1>, ptr undef, align 1
  ; <64 x i1> is ZMM

  ret i32 undef
}

define i32 @loads_align64(i32 %arg) {
  ; Scalars
; SSE2-LABEL: 'loads_align64'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = load i8, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %2 = load i16, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %3 = load i32, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %4 = load i64, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %5 = load i128, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %6 = load i256, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %7 = load i512, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %8 = load float, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %9 = load double, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %10 = load ptr, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %11 = load ptr, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %12 = load <128 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %13 = load <16 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %14 = load <8 x i16>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %15 = load <4 x i32>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %16 = load <2 x i64>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %17 = load <1 x i128>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %18 = load <4 x float>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %19 = load <2 x double>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %20 = load <2 x ptr>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %21 = load <16 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %22 = load <8 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %23 = load <4 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %24 = load <2 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %25 = load <1 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %26 = load <256 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %27 = load <32 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %28 = load <16 x i16>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %29 = load <8 x i32>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %30 = load <4 x i64>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %31 = load <2 x i128>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %32 = load <1 x i256>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %33 = load <8 x float>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %34 = load <4 x double>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %35 = load <4 x ptr>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %36 = load <32 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %37 = load <512 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %38 = load <64 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %39 = load <32 x i16>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %40 = load <16 x i32>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %41 = load <8 x i64>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %42 = load <4 x i128>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %43 = load <2 x i256>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %44 = load <1 x i512>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %45 = load <16 x float>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %46 = load <8 x double>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %47 = load <8 x ptr>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %48 = load <64 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SSE41-LABEL: 'loads_align64'
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = load i8, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %2 = load i16, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %3 = load i32, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %4 = load i64, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %5 = load i128, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %6 = load i256, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %7 = load i512, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %8 = load float, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %9 = load double, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %10 = load ptr, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %11 = load ptr, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %12 = load <128 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %13 = load <16 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %14 = load <8 x i16>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %15 = load <4 x i32>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %16 = load <2 x i64>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %17 = load <1 x i128>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %18 = load <4 x float>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %19 = load <2 x double>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %20 = load <2 x ptr>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %21 = load <16 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %22 = load <8 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %23 = load <4 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %24 = load <2 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %25 = load <1 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %26 = load <256 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %27 = load <32 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %28 = load <16 x i16>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %29 = load <8 x i32>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %30 = load <4 x i64>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %31 = load <2 x i128>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %32 = load <1 x i256>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %33 = load <8 x float>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %34 = load <4 x double>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %35 = load <4 x ptr>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %36 = load <32 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %37 = load <512 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %38 = load <64 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %39 = load <32 x i16>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %40 = load <16 x i32>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %41 = load <8 x i64>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %42 = load <4 x i128>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %43 = load <2 x i256>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %44 = load <1 x i512>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %45 = load <16 x float>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %46 = load <8 x double>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %47 = load <8 x ptr>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %48 = load <64 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX-LABEL: 'loads_align64'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = load i8, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %2 = load i16, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %3 = load i32, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %4 = load i64, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %5 = load i128, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %6 = load i256, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %7 = load i512, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %8 = load float, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %9 = load double, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %10 = load ptr, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %11 = load ptr, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %12 = load <128 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %13 = load <16 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %14 = load <8 x i16>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %15 = load <4 x i32>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %16 = load <2 x i64>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %17 = load <1 x i128>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %18 = load <4 x float>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %19 = load <2 x double>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %20 = load <2 x ptr>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %21 = load <16 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %22 = load <8 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %23 = load <4 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %24 = load <2 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %25 = load <1 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %26 = load <256 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %27 = load <32 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %28 = load <16 x i16>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %29 = load <8 x i32>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %30 = load <4 x i64>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %31 = load <2 x i128>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %32 = load <1 x i256>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %33 = load <8 x float>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %34 = load <4 x double>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %35 = load <4 x ptr>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %36 = load <32 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %37 = load <512 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %38 = load <64 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %39 = load <32 x i16>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %40 = load <16 x i32>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %41 = load <8 x i64>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %42 = load <4 x i128>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %43 = load <2 x i256>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %44 = load <1 x i512>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %45 = load <16 x float>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %46 = load <8 x double>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %47 = load <8 x ptr>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %48 = load <64 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512-LABEL: 'loads_align64'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = load i8, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %2 = load i16, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %3 = load i32, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %4 = load i64, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %5 = load i128, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %6 = load i256, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %7 = load i512, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %8 = load float, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %9 = load double, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %10 = load ptr, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %11 = load ptr, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %12 = load <128 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %13 = load <16 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %14 = load <8 x i16>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %15 = load <4 x i32>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %16 = load <2 x i64>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %17 = load <1 x i128>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %18 = load <4 x float>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %19 = load <2 x double>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %20 = load <2 x ptr>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %21 = load <16 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %22 = load <8 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %23 = load <4 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %24 = load <2 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %25 = load <1 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %26 = load <256 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %27 = load <32 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %28 = load <16 x i16>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %29 = load <8 x i32>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %30 = load <4 x i64>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %31 = load <2 x i128>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %32 = load <1 x i256>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %33 = load <8 x float>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %34 = load <4 x double>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %35 = load <4 x ptr>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %36 = load <32 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %37 = load <512 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %38 = load <64 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %39 = load <32 x i16>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %40 = load <16 x i32>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %41 = load <8 x i64>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %42 = load <4 x i128>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %43 = load <2 x i256>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %44 = load <1 x i512>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %45 = load <16 x float>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %46 = load <8 x double>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %47 = load <8 x ptr>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %48 = load <64 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  load i8, ptr undef, align 64
  load i16, ptr undef, align 64
  load i32, ptr undef, align 64
  load i64, ptr undef, align 64
  load i128, ptr undef, align 64
  load i256, ptr undef, align 64
  load i512, ptr undef, align 64

  load float, ptr undef, align 64
  load double, ptr undef, align 64

  load ptr, ptr undef, align 64

  load ptr, ptr undef, align 64

  ; XMM (128-bit) vectors
  load <128 x i1>, ptr undef, align 64
  load <16 x i8>, ptr undef, align 64
  load <8 x i16>, ptr undef, align 64
  load <4 x i32>, ptr undef, align 64
  load <2 x i64>, ptr undef, align 64
  load <1 x i128>, ptr undef, align 64

  load <4 x float>, ptr undef, align 64
  load <2 x double>, ptr undef, align 64

  load <2 x ptr>, ptr undef, align 64

  load <16 x i1>, ptr undef, align 64
  load <8 x i1>, ptr undef, align 64
  load <4 x i1>, ptr undef, align 64
  load <2 x i1>, ptr undef, align 64
  load <1 x i1>, ptr undef, align 64

  ; YMM (256-bit) vectors
  load <256 x i1>, ptr undef, align 64
  load <32 x i8>, ptr undef, align 64
  load <16 x i16>, ptr undef, align 64
  load <8 x i32>, ptr undef, align 64
  load <4 x i64>, ptr undef, align 64
  load <2 x i128>, ptr undef, align 64
  load <1 x i256>, ptr undef, align 64

  load <8 x float>, ptr undef, align 64
  load <4 x double>, ptr undef, align 64

  load <4 x ptr>, ptr undef, align 64

  load <32 x i1>, ptr undef, align 64

  ; ZMM (512-bit) vectors
  load <512 x i1>, ptr undef, align 64
  load <64 x i8>, ptr undef, align 64
  load <32 x i16>, ptr undef, align 64
  load <16 x i32>, ptr undef, align 64
  load <8 x i64>, ptr undef, align 64
  load <4 x i128>, ptr undef, align 64
  load <2 x i256>, ptr undef, align 64
  load <1 x i512>, ptr undef, align 64

  load <16 x float>, ptr undef, align 64
  load <8 x double>, ptr undef, align 64

  load <8 x ptr>, ptr undef, align 64

  load <64 x i1>, ptr undef, align 64

  ret i32 undef
}

define i32 @loads_partial_align64(i32 %arg) {
  ; Partial vectors with i64 elements (doubles as pointer-sized tests))
; SSE2-LABEL: 'loads_partial_align64'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = load <1 x i64>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %2 = load <3 x i64>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %3 = load <5 x i64>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %4 = load <6 x i64>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %5 = load <7 x i64>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %6 = load <1 x double>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %7 = load <3 x double>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %8 = load <5 x double>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %9 = load <6 x double>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %10 = load <7 x double>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %11 = load <1 x i32>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %12 = load <2 x i32>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %13 = load <3 x i32>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %14 = load <5 x i32>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %15 = load <6 x i32>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %16 = load <7 x i32>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %17 = load <9 x i32>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %18 = load <10 x i32>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %19 = load <11 x i32>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %20 = load <12 x i32>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %21 = load <13 x i32>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %22 = load <14 x i32>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %23 = load <15 x i32>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %24 = load <1 x float>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %25 = load <2 x float>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %26 = load <3 x float>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %27 = load <5 x float>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %28 = load <6 x float>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %29 = load <7 x float>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %30 = load <9 x float>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %31 = load <10 x float>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %32 = load <11 x float>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %33 = load <12 x float>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %34 = load <13 x float>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %35 = load <14 x float>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %36 = load <15 x float>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %37 = load <1 x i16>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %38 = load <2 x i16>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %39 = load <3 x i16>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %40 = load <4 x i16>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %41 = load <5 x i16>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %42 = load <6 x i16>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %43 = load <7 x i16>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %44 = load <9 x i16>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %45 = load <10 x i16>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %46 = load <11 x i16>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %47 = load <12 x i16>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %48 = load <13 x i16>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %49 = load <14 x i16>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %50 = load <15 x i16>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %51 = load <17 x i16>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %52 = load <18 x i16>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %53 = load <19 x i16>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %54 = load <20 x i16>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %55 = load <21 x i16>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %56 = load <22 x i16>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %57 = load <23 x i16>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %58 = load <24 x i16>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %59 = load <25 x i16>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %60 = load <26 x i16>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %61 = load <27 x i16>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %62 = load <28 x i16>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %63 = load <29 x i16>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %64 = load <30 x i16>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %65 = load <31 x i16>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %66 = load <1 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %67 = load <2 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %68 = load <3 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %69 = load <4 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %70 = load <5 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %71 = load <6 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %72 = load <7 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %73 = load <8 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %74 = load <9 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %75 = load <10 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %76 = load <11 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %77 = load <12 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %78 = load <13 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %79 = load <14 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %80 = load <15 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %81 = load <17 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %82 = load <18 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %83 = load <19 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %84 = load <20 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %85 = load <21 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %86 = load <22 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %87 = load <23 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %88 = load <24 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %89 = load <25 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %90 = load <26 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %91 = load <27 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %92 = load <28 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %93 = load <29 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %94 = load <30 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %95 = load <31 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %96 = load <33 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %97 = load <34 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %98 = load <35 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %99 = load <36 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %100 = load <37 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %101 = load <38 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %102 = load <39 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %103 = load <40 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %104 = load <41 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %105 = load <42 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %106 = load <43 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %107 = load <44 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %108 = load <45 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %109 = load <46 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %110 = load <47 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %111 = load <48 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %112 = load <49 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %113 = load <50 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %114 = load <51 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %115 = load <52 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %116 = load <53 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %117 = load <54 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %118 = load <55 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %119 = load <56 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %120 = load <57 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %121 = load <58 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %122 = load <59 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %123 = load <60 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %124 = load <61 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %125 = load <62 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %126 = load <63 x i8>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %127 = load <3 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %128 = load <5 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %129 = load <6 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %130 = load <7 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %131 = load <9 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %132 = load <10 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %133 = load <11 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %134 = load <12 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %135 = load <13 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %136 = load <14 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %137 = load <15 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %138 = load <17 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %139 = load <18 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %140 = load <19 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %141 = load <20 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %142 = load <21 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %143 = load <22 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %144 = load <23 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %145 = load <24 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %146 = load <25 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %147 = load <26 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %148 = load <27 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %149 = load <28 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %150 = load <29 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %151 = load <30 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %152 = load <31 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %153 = load <33 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %154 = load <34 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %155 = load <35 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %156 = load <36 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %157 = load <37 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %158 = load <38 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %159 = load <39 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %160 = load <40 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %161 = load <41 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %162 = load <42 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %163 = load <43 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %164 = load <44 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %165 = load <45 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %166 = load <46 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %167 = load <47 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %168 = load <48 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %169 = load <49 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %170 = load <50 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %171 = load <51 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %172 = load <52 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %173 = load <53 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %174 = load <54 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %175 = load <55 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %176 = load <56 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %177 = load <57 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %178 = load <58 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %179 = load <59 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %180 = load <60 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %181 = load <61 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %182 = load <62 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %183 = load <63 x i1>, ptr undef, align 64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SSE41-LABEL: 'loads_partial_align64'
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = load <1 x i64>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %2 = load <3 x i64>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %3 = load <5 x i64>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %4 = load <6 x i64>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %5 = load <7 x i64>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %6 = load <1 x double>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %7 = load <3 x double>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %8 = load <5 x double>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %9 = load <6 x double>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %10 = load <7 x double>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %11 = load <1 x i32>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %12 = load <2 x i32>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %13 = load <3 x i32>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %14 = load <5 x i32>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %15 = load <6 x i32>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %16 = load <7 x i32>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %17 = load <9 x i32>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %18 = load <10 x i32>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %19 = load <11 x i32>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %20 = load <12 x i32>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %21 = load <13 x i32>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %22 = load <14 x i32>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %23 = load <15 x i32>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %24 = load <1 x float>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %25 = load <2 x float>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %26 = load <3 x float>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %27 = load <5 x float>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %28 = load <6 x float>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %29 = load <7 x float>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %30 = load <9 x float>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %31 = load <10 x float>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %32 = load <11 x float>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %33 = load <12 x float>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %34 = load <13 x float>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %35 = load <14 x float>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %36 = load <15 x float>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %37 = load <1 x i16>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %38 = load <2 x i16>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %39 = load <3 x i16>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %40 = load <4 x i16>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %41 = load <5 x i16>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %42 = load <6 x i16>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %43 = load <7 x i16>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %44 = load <9 x i16>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %45 = load <10 x i16>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %46 = load <11 x i16>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %47 = load <12 x i16>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %48 = load <13 x i16>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %49 = load <14 x i16>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %50 = load <15 x i16>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %51 = load <17 x i16>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %52 = load <18 x i16>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %53 = load <19 x i16>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %54 = load <20 x i16>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %55 = load <21 x i16>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %56 = load <22 x i16>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %57 = load <23 x i16>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %58 = load <24 x i16>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %59 = load <25 x i16>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %60 = load <26 x i16>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %61 = load <27 x i16>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %62 = load <28 x i16>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %63 = load <29 x i16>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %64 = load <30 x i16>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %65 = load <31 x i16>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %66 = load <1 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %67 = load <2 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %68 = load <3 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %69 = load <4 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %70 = load <5 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %71 = load <6 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %72 = load <7 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %73 = load <8 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %74 = load <9 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %75 = load <10 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %76 = load <11 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %77 = load <12 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %78 = load <13 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %79 = load <14 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %80 = load <15 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %81 = load <17 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %82 = load <18 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %83 = load <19 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %84 = load <20 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %85 = load <21 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %86 = load <22 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %87 = load <23 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %88 = load <24 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %89 = load <25 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %90 = load <26 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %91 = load <27 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %92 = load <28 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %93 = load <29 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %94 = load <30 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %95 = load <31 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %96 = load <33 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %97 = load <34 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %98 = load <35 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %99 = load <36 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %100 = load <37 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %101 = load <38 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %102 = load <39 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %103 = load <40 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %104 = load <41 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %105 = load <42 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %106 = load <43 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %107 = load <44 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %108 = load <45 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %109 = load <46 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %110 = load <47 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %111 = load <48 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %112 = load <49 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %113 = load <50 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %114 = load <51 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %115 = load <52 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %116 = load <53 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %117 = load <54 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %118 = load <55 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %119 = load <56 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %120 = load <57 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %121 = load <58 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %122 = load <59 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %123 = load <60 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %124 = load <61 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %125 = load <62 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %126 = load <63 x i8>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %127 = load <3 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %128 = load <5 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %129 = load <6 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %130 = load <7 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %131 = load <9 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %132 = load <10 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %133 = load <11 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %134 = load <12 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %135 = load <13 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %136 = load <14 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %137 = load <15 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %138 = load <17 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %139 = load <18 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %140 = load <19 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %141 = load <20 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %142 = load <21 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %143 = load <22 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %144 = load <23 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %145 = load <24 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %146 = load <25 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %147 = load <26 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %148 = load <27 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %149 = load <28 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %150 = load <29 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %151 = load <30 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %152 = load <31 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %153 = load <33 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %154 = load <34 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %155 = load <35 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %156 = load <36 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %157 = load <37 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %158 = load <38 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %159 = load <39 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %160 = load <40 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %161 = load <41 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %162 = load <42 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %163 = load <43 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %164 = load <44 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %165 = load <45 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %166 = load <46 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %167 = load <47 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %168 = load <48 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %169 = load <49 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %170 = load <50 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %171 = load <51 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %172 = load <52 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %173 = load <53 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %174 = load <54 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %175 = load <55 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %176 = load <56 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %177 = load <57 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %178 = load <58 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %179 = load <59 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %180 = load <60 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %181 = load <61 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %182 = load <62 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %183 = load <63 x i1>, ptr undef, align 64
; SSE41-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX-LABEL: 'loads_partial_align64'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = load <1 x i64>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %2 = load <3 x i64>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %3 = load <5 x i64>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %4 = load <6 x i64>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %5 = load <7 x i64>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %6 = load <1 x double>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %7 = load <3 x double>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %8 = load <5 x double>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %9 = load <6 x double>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %10 = load <7 x double>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %11 = load <1 x i32>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %12 = load <2 x i32>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %13 = load <3 x i32>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %14 = load <5 x i32>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %15 = load <6 x i32>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %16 = load <7 x i32>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %17 = load <9 x i32>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %18 = load <10 x i32>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %19 = load <11 x i32>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %20 = load <12 x i32>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %21 = load <13 x i32>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %22 = load <14 x i32>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %23 = load <15 x i32>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %24 = load <1 x float>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %25 = load <2 x float>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %26 = load <3 x float>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %27 = load <5 x float>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %28 = load <6 x float>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %29 = load <7 x float>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %30 = load <9 x float>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %31 = load <10 x float>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %32 = load <11 x float>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %33 = load <12 x float>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %34 = load <13 x float>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %35 = load <14 x float>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %36 = load <15 x float>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %37 = load <1 x i16>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %38 = load <2 x i16>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %39 = load <3 x i16>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %40 = load <4 x i16>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %41 = load <5 x i16>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %42 = load <6 x i16>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %43 = load <7 x i16>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %44 = load <9 x i16>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %45 = load <10 x i16>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %46 = load <11 x i16>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %47 = load <12 x i16>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %48 = load <13 x i16>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %49 = load <14 x i16>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %50 = load <15 x i16>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %51 = load <17 x i16>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %52 = load <18 x i16>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %53 = load <19 x i16>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %54 = load <20 x i16>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %55 = load <21 x i16>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %56 = load <22 x i16>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %57 = load <23 x i16>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %58 = load <24 x i16>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %59 = load <25 x i16>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %60 = load <26 x i16>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %61 = load <27 x i16>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %62 = load <28 x i16>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %63 = load <29 x i16>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %64 = load <30 x i16>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %65 = load <31 x i16>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %66 = load <1 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %67 = load <2 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %68 = load <3 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %69 = load <4 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %70 = load <5 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %71 = load <6 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %72 = load <7 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %73 = load <8 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %74 = load <9 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %75 = load <10 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %76 = load <11 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %77 = load <12 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %78 = load <13 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %79 = load <14 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %80 = load <15 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %81 = load <17 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %82 = load <18 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %83 = load <19 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %84 = load <20 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %85 = load <21 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %86 = load <22 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %87 = load <23 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %88 = load <24 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %89 = load <25 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %90 = load <26 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %91 = load <27 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %92 = load <28 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %93 = load <29 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %94 = load <30 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %95 = load <31 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %96 = load <33 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %97 = load <34 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %98 = load <35 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %99 = load <36 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %100 = load <37 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %101 = load <38 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %102 = load <39 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %103 = load <40 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %104 = load <41 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %105 = load <42 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %106 = load <43 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %107 = load <44 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %108 = load <45 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %109 = load <46 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %110 = load <47 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %111 = load <48 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %112 = load <49 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %113 = load <50 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %114 = load <51 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %115 = load <52 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %116 = load <53 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %117 = load <54 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %118 = load <55 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %119 = load <56 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %120 = load <57 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %121 = load <58 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %122 = load <59 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %123 = load <60 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %124 = load <61 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %125 = load <62 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %126 = load <63 x i8>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %127 = load <3 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %128 = load <5 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %129 = load <6 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %130 = load <7 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %131 = load <9 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %132 = load <10 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %133 = load <11 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %134 = load <12 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %135 = load <13 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %136 = load <14 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %137 = load <15 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %138 = load <17 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %139 = load <18 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %140 = load <19 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %141 = load <20 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %142 = load <21 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %143 = load <22 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %144 = load <23 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %145 = load <24 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %146 = load <25 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %147 = load <26 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %148 = load <27 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %149 = load <28 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %150 = load <29 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %151 = load <30 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %152 = load <31 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %153 = load <33 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %154 = load <34 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %155 = load <35 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %156 = load <36 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %157 = load <37 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %158 = load <38 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %159 = load <39 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %160 = load <40 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %161 = load <41 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %162 = load <42 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %163 = load <43 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %164 = load <44 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %165 = load <45 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %166 = load <46 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %167 = load <47 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %168 = load <48 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %169 = load <49 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %170 = load <50 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %171 = load <51 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %172 = load <52 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %173 = load <53 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %174 = load <54 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %175 = load <55 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %176 = load <56 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %177 = load <57 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %178 = load <58 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %179 = load <59 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %180 = load <60 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %181 = load <61 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %182 = load <62 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %183 = load <63 x i1>, ptr undef, align 64
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512-LABEL: 'loads_partial_align64'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = load <1 x i64>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %2 = load <3 x i64>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %3 = load <5 x i64>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %4 = load <6 x i64>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %5 = load <7 x i64>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %6 = load <1 x double>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %7 = load <3 x double>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %8 = load <5 x double>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %9 = load <6 x double>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %10 = load <7 x double>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %11 = load <1 x i32>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %12 = load <2 x i32>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %13 = load <3 x i32>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %14 = load <5 x i32>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %15 = load <6 x i32>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %16 = load <7 x i32>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %17 = load <9 x i32>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %18 = load <10 x i32>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %19 = load <11 x i32>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %20 = load <12 x i32>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %21 = load <13 x i32>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %22 = load <14 x i32>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %23 = load <15 x i32>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %24 = load <1 x float>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %25 = load <2 x float>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %26 = load <3 x float>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %27 = load <5 x float>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %28 = load <6 x float>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %29 = load <7 x float>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %30 = load <9 x float>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %31 = load <10 x float>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %32 = load <11 x float>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %33 = load <12 x float>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %34 = load <13 x float>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %35 = load <14 x float>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %36 = load <15 x float>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %37 = load <1 x i16>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %38 = load <2 x i16>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %39 = load <3 x i16>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %40 = load <4 x i16>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %41 = load <5 x i16>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %42 = load <6 x i16>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %43 = load <7 x i16>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %44 = load <9 x i16>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %45 = load <10 x i16>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %46 = load <11 x i16>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %47 = load <12 x i16>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %48 = load <13 x i16>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %49 = load <14 x i16>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %50 = load <15 x i16>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %51 = load <17 x i16>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %52 = load <18 x i16>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %53 = load <19 x i16>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %54 = load <20 x i16>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %55 = load <21 x i16>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %56 = load <22 x i16>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %57 = load <23 x i16>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %58 = load <24 x i16>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %59 = load <25 x i16>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %60 = load <26 x i16>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %61 = load <27 x i16>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %62 = load <28 x i16>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %63 = load <29 x i16>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %64 = load <30 x i16>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %65 = load <31 x i16>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %66 = load <1 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %67 = load <2 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %68 = load <3 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %69 = load <4 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %70 = load <5 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %71 = load <6 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %72 = load <7 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %73 = load <8 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %74 = load <9 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %75 = load <10 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %76 = load <11 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %77 = load <12 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %78 = load <13 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %79 = load <14 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %80 = load <15 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %81 = load <17 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %82 = load <18 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %83 = load <19 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %84 = load <20 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %85 = load <21 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %86 = load <22 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %87 = load <23 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %88 = load <24 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %89 = load <25 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %90 = load <26 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %91 = load <27 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %92 = load <28 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %93 = load <29 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %94 = load <30 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %95 = load <31 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %96 = load <33 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %97 = load <34 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %98 = load <35 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %99 = load <36 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %100 = load <37 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %101 = load <38 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %102 = load <39 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %103 = load <40 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %104 = load <41 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %105 = load <42 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %106 = load <43 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %107 = load <44 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %108 = load <45 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %109 = load <46 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %110 = load <47 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %111 = load <48 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %112 = load <49 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %113 = load <50 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %114 = load <51 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %115 = load <52 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %116 = load <53 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %117 = load <54 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %118 = load <55 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %119 = load <56 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %120 = load <57 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %121 = load <58 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %122 = load <59 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %123 = load <60 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %124 = load <61 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %125 = load <62 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %126 = load <63 x i8>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %127 = load <3 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %128 = load <5 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %129 = load <6 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %130 = load <7 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %131 = load <9 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %132 = load <10 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %133 = load <11 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %134 = load <12 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %135 = load <13 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %136 = load <14 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %137 = load <15 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %138 = load <17 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %139 = load <18 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %140 = load <19 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %141 = load <20 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %142 = load <21 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %143 = load <22 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %144 = load <23 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %145 = load <24 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %146 = load <25 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %147 = load <26 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %148 = load <27 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %149 = load <28 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %150 = load <29 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %151 = load <30 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %152 = load <31 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %153 = load <33 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %154 = load <34 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %155 = load <35 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %156 = load <36 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %157 = load <37 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %158 = load <38 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %159 = load <39 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %160 = load <40 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %161 = load <41 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %162 = load <42 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %163 = load <43 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %164 = load <44 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %165 = load <45 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %166 = load <46 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %167 = load <47 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %168 = load <48 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %169 = load <49 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %170 = load <50 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %171 = load <51 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %172 = load <52 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %173 = load <53 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %174 = load <54 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %175 = load <55 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %176 = load <56 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %177 = load <57 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %178 = load <58 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %179 = load <59 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %180 = load <60 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %181 = load <61 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %182 = load <62 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %183 = load <63 x i1>, ptr undef, align 64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  load <1 x i64>, ptr undef, align 64
  ; <2 x i64> is XMM
  load <3 x i64>, ptr undef, align 64
  ; <4 x i64> is YMM
  load <5 x i64>, ptr undef, align 64
  load <6 x i64>, ptr undef, align 64
  load <7 x i64>, ptr undef, align 64
  ; <8 x i64> is ZMM

  ; Partial vectors with double elements
  load <1 x double>, ptr undef, align 64
  ; <2 x double> is XMM
  load <3 x double>, ptr undef, align 64
  ; <4 x double> is YMM
  load <5 x double>, ptr undef, align 64
  load <6 x double>, ptr undef, align 64
  load <7 x double>, ptr undef, align 64
  ; <8 x double> is ZMM

  ; Partial vectors with i32 elements
  load <1 x i32>, ptr undef, align 64
  load <2 x i32>, ptr undef, align 64
  load <3 x i32>, ptr undef, align 64
  ; <4 x i32> is XMM
  load <5 x i32>, ptr undef, align 64
  load <6 x i32>, ptr undef, align 64
  load <7 x i32>, ptr undef, align 64
  ; <8 x i32> is YMM
  load <9 x i32>, ptr undef, align 64
  load <10 x i32>, ptr undef, align 64
  load <11 x i32>, ptr undef, align 64
  load <12 x i32>, ptr undef, align 64
  load <13 x i32>, ptr undef, align 64
  load <14 x i32>, ptr undef, align 64
  load <15 x i32>, ptr undef, align 64
  ; <16 x i32> is ZMM

  ; Partial vectors with float elements
  load <1 x float>, ptr undef, align 64
  load <2 x float>, ptr undef, align 64
  load <3 x float>, ptr undef, align 64
  ; <4 x float> is XMM
  load <5 x float>, ptr undef, align 64
  load <6 x float>, ptr undef, align 64
  load <7 x float>, ptr undef, align 64
  ; <8 x float> is YMM
  load <9 x float>, ptr undef, align 64
  load <10 x float>, ptr undef, align 64
  load <11 x float>, ptr undef, align 64
  load <12 x float>, ptr undef, align 64
  load <13 x float>, ptr undef, align 64
  load <14 x float>, ptr undef, align 64
  load <15 x float>, ptr undef, align 64
  ; <16 x float> is ZMM

  ; Partial vectors with i16 elements
  load <1 x i16>, ptr undef, align 64
  load <2 x i16>, ptr undef, align 64
  load <3 x i16>, ptr undef, align 64
  load <4 x i16>, ptr undef, align 64
  load <5 x i16>, ptr undef, align 64
  load <6 x i16>, ptr undef, align 64
  load <7 x i16>, ptr undef, align 64
  ; <8 x i16> is XMM
  load <9 x i16>, ptr undef, align 64
  load <10 x i16>, ptr undef, align 64
  load <11 x i16>, ptr undef, align 64
  load <12 x i16>, ptr undef, align 64
  load <13 x i16>, ptr undef, align 64
  load <14 x i16>, ptr undef, align 64
  load <15 x i16>, ptr undef, align 64
  ; <16 x i16> is YMM
  load <17 x i16>, ptr undef, align 64
  load <18 x i16>, ptr undef, align 64
  load <19 x i16>, ptr undef, align 64
  load <20 x i16>, ptr undef, align 64
  load <21 x i16>, ptr undef, align 64
  load <22 x i16>, ptr undef, align 64
  load <23 x i16>, ptr undef, align 64
  load <24 x i16>, ptr undef, align 64
  load <25 x i16>, ptr undef, align 64
  load <26 x i16>, ptr undef, align 64
  load <27 x i16>, ptr undef, align 64
  load <28 x i16>, ptr undef, align 64
  load <29 x i16>, ptr undef, align 64
  load <30 x i16>, ptr undef, align 64
  load <31 x i16>, ptr undef, align 64
  ; <32 x i16> is ZMM

  ; Partial vectors with i8 elements
  load <1 x i8>, ptr undef, align 64
  load <2 x i8>, ptr undef, align 64
  load <3 x i8>, ptr undef, align 64
  load <4 x i8>, ptr undef, align 64
  load <5 x i8>, ptr undef, align 64
  load <6 x i8>, ptr undef, align 64
  load <7 x i8>, ptr undef, align 64
  load <8 x i8>, ptr undef, align 64
  load <9 x i8>, ptr undef, align 64
  load <10 x i8>, ptr undef, align 64
  load <11 x i8>, ptr undef, align 64
  load <12 x i8>, ptr undef, align 64
  load <13 x i8>, ptr undef, align 64
  load <14 x i8>, ptr undef, align 64
  load <15 x i8>, ptr undef, align 64
  ; <16 x i8> is XMM
  load <17 x i8>, ptr undef, align 64
  load <18 x i8>, ptr undef, align 64
  load <19 x i8>, ptr undef, align 64
  load <20 x i8>, ptr undef, align 64
  load <21 x i8>, ptr undef, align 64
  load <22 x i8>, ptr undef, align 64
  load <23 x i8>, ptr undef, align 64
  load <24 x i8>, ptr undef, align 64
  load <25 x i8>, ptr undef, align 64
  load <26 x i8>, ptr undef, align 64
  load <27 x i8>, ptr undef, align 64
  load <28 x i8>, ptr undef, align 64
  load <29 x i8>, ptr undef, align 64
  load <30 x i8>, ptr undef, align 64
  load <31 x i8>, ptr undef, align 64
  ; <32 x i8> is YMM
  load <33 x i8>, ptr undef, align 64
  load <34 x i8>, ptr undef, align 64
  load <35 x i8>, ptr undef, align 64
  load <36 x i8>, ptr undef, align 64
  load <37 x i8>, ptr undef, align 64
  load <38 x i8>, ptr undef, align 64
  load <39 x i8>, ptr undef, align 64
  load <40 x i8>, ptr undef, align 64
  load <41 x i8>, ptr undef, align 64
  load <42 x i8>, ptr undef, align 64
  load <43 x i8>, ptr undef, align 64
  load <44 x i8>, ptr undef, align 64
  load <45 x i8>, ptr undef, align 64
  load <46 x i8>, ptr undef, align 64
  load <47 x i8>, ptr undef, align 64
  load <48 x i8>, ptr undef, align 64
  load <49 x i8>, ptr undef, align 64
  load <50 x i8>, ptr undef, align 64
  load <51 x i8>, ptr undef, align 64
  load <52 x i8>, ptr undef, align 64
  load <53 x i8>, ptr undef, align 64
  load <54 x i8>, ptr undef, align 64
  load <55 x i8>, ptr undef, align 64
  load <56 x i8>, ptr undef, align 64
  load <57 x i8>, ptr undef, align 64
  load <58 x i8>, ptr undef, align 64
  load <59 x i8>, ptr undef, align 64
  load <60 x i8>, ptr undef, align 64
  load <61 x i8>, ptr undef, align 64
  load <62 x i8>, ptr undef, align 64
  load <63 x i8>, ptr undef, align 64
  ; <64 x i8> is ZMM

  ; Partial vectors with i1 elements
  ; <1 x i1> is XMM
  ; <2 x i1> is XMM
  load <3 x i1>, ptr undef, align 64
  ; <4 x i1> is XMM
  load <5 x i1>, ptr undef, align 64
  load <6 x i1>, ptr undef, align 64
  load <7 x i1>, ptr undef, align 64
  ; <8 x i1> is XMM
  load <9 x i1>, ptr undef, align 64
  load <10 x i1>, ptr undef, align 64
  load <11 x i1>, ptr undef, align 64
  load <12 x i1>, ptr undef, align 64
  load <13 x i1>, ptr undef, align 64
  load <14 x i1>, ptr undef, align 64
  load <15 x i1>, ptr undef, align 64
  ; <16 x i1> is XMM
  load <17 x i1>, ptr undef, align 64
  load <18 x i1>, ptr undef, align 64
  load <19 x i1>, ptr undef, align 64
  load <20 x i1>, ptr undef, align 64
  load <21 x i1>, ptr undef, align 64
  load <22 x i1>, ptr undef, align 64
  load <23 x i1>, ptr undef, align 64
  load <24 x i1>, ptr undef, align 64
  load <25 x i1>, ptr undef, align 64
  load <26 x i1>, ptr undef, align 64
  load <27 x i1>, ptr undef, align 64
  load <28 x i1>, ptr undef, align 64
  load <29 x i1>, ptr undef, align 64
  load <30 x i1>, ptr undef, align 64
  load <31 x i1>, ptr undef, align 64
  ; <32 x i1> is YMM
  load <33 x i1>, ptr undef, align 64
  load <34 x i1>, ptr undef, align 64
  load <35 x i1>, ptr undef, align 64
  load <36 x i1>, ptr undef, align 64
  load <37 x i1>, ptr undef, align 64
  load <38 x i1>, ptr undef, align 64
  load <39 x i1>, ptr undef, align 64
  load <40 x i1>, ptr undef, align 64
  load <41 x i1>, ptr undef, align 64
  load <42 x i1>, ptr undef, align 64
  load <43 x i1>, ptr undef, align 64
  load <44 x i1>, ptr undef, align 64
  load <45 x i1>, ptr undef, align 64
  load <46 x i1>, ptr undef, align 64
  load <47 x i1>, ptr undef, align 64
  load <48 x i1>, ptr undef, align 64
  load <49 x i1>, ptr undef, align 64
  load <50 x i1>, ptr undef, align 64
  load <51 x i1>, ptr undef, align 64
  load <52 x i1>, ptr undef, align 64
  load <53 x i1>, ptr undef, align 64
  load <54 x i1>, ptr undef, align 64
  load <55 x i1>, ptr undef, align 64
  load <56 x i1>, ptr undef, align 64
  load <57 x i1>, ptr undef, align 64
  load <58 x i1>, ptr undef, align 64
  load <59 x i1>, ptr undef, align 64
  load <60 x i1>, ptr undef, align 64
  load <61 x i1>, ptr undef, align 64
  load <62 x i1>, ptr undef, align 64
  load <63 x i1>, ptr undef, align 64
  ; <64 x i1> is ZMM

  ret i32 undef
}
