/*  Copyright (c) MediaArea.net SARL. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license that can
 *  be found in the License.html file in the root of the source tree.
 */

//---------------------------------------------------------------------------
// Pre-compilation
#include "MediaInfo/PreComp.h"
#ifdef __BORLANDC__
    #pragma hdrstop
#endif
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include "MediaInfo/Setup.h"
using namespace ZenLib;
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#if defined(MEDIAINFO_MXF_YES)
//---------------------------------------------------------------------------

namespace MediaInfoLib
{

//---------------------------------------------------------------------------
#define U(VALUE, NAME) const int64u NAME=0x##VALUE##LL;                         // UUID
#define C(VALUE, DEF) case 0x##VALUE##LL: return DEF;                           //
#define T(VALUE, DEF) case 0x##VALUE##LL: return File_Mxf::Type_##DEF;          // TYPE

//---------------------------------------------------------------------------
// BEGIN
const char* Mxf_Param_Info_Elements(int64u Value)
{
    switch (Value)
    {
C(0000000000000000, "Elements")
C(0100000000000000, "Identification and location")
C(0101000000000000, "Globally Unique Identifiers")
C(0101050000000000, "UMID Picture")
C(0101060000000000, "UMID Multi Picture")
C(0101080000000000, "UMID Sound")
C(0101090000000000, "UMID Multi Sound")
C(01010B0000000000, "UMID Single Data")
C(01010C0000000000, "UMID Multi Data")
C(01010D0000000000, "UMID Mixed")
C(01010F0000000000, "UMID General")
C(0101100000000000, "International Broadcasting Organization Identifiers")
C(0101100100000000, "Organization ID")
C(0101100101000000, "Organization ID")
C(0101100200000000, "Organization ID Kind")
C(0101100201000000, "Organization ID Kind")
C(0101100300000000, "Program Identifiers")
C(0101100301000000, "UPID")
C(0101100302000000, "UPN")
C(0101100303000000, "Program Number")
C(0101100400000000, "Physical Media Identifiers")
C(0101100401000000, "Tape Identifiers")
C(0101100401010000, "IBTN")
C(0101110000000000, "International Standard Identifiers")
C(0101110100000000, "ISAN")
C(0101110200000000, "ISBN")
C(0101110300000000, "ISSN")
C(0101110400000000, "ISWC")
C(0101110500000000, "ISMN")
C(0101110600000000, "ISCI")
C(0101110700000000, "ISRC")
C(0101110800000000, "ISRN")
C(0101110900000000, "ISBD")
C(0101110A00000000, "ISTC")
C(0101110B00000000, "Canonical Full Ad-ID Identifier")
C(0101110C00000000, "Canonical DOI Name")
C(0101110D00000000, "Canonical EIDR Identifier")
C(0101110E00000000, "Compact Ad-ID Identifier")
C(0101130000000000, "International Standard Compound Identifiers")
C(0101130100000000, "SICI")
C(0101130200000000, "BICI")
C(0101130300000000, "AICI")
C(0101130400000000, "PII")
C(0101150000000000, "Object Identifiers")
C(0101150100000000, "DOI")
C(0101150200000000, "Instance ID")
C(0101150300000000, "Definition Object ID")
C(0101150400000000, "Global Number")
C(0101150800000000, "Clip ID")
C(0101150900000000, "Extended Clip ID")
C(0101150A00000000, "Clip ID Array")
C(0101150B00000000, "Extended Clip ID Array")
C(0101151000000000, "Package ID")
C(0101151100000000, "Cryptographic Context ID")
C(0101151200000000, "Resource ID")
C(0101151300000000, "Ancillary Resource ID")
C(0101151400000000, "EIDR DMS Essence ID")
C(0101154000000000, "Globally Unique Object Identifiers")
C(0101154001000000, "Globally Unique Human Identifiers")
C(0101154001010000, "Participant ID")
C(0101154001020000, "Contact ID")
C(0101200000000000, "Device Identifiers")
C(0101200100000000, "Device Designation")
C(0101200300000000, "Device Model")
C(0101200400000000, "Device Serial Number")
C(0101200500000000, "IEEE Device ID")
C(0101200700000000, "Device ID Kind")
C(0101200800000000, "Device Kind")
C(0101200801000000, "Device Kind")
C(0101200802000000, "Device Kind Code")
C(0101200C00000000, "Device Asset Number")
C(0101210000000000, "Platform Identifiers")
C(0101210100000000, "Platform Designation")
C(0101210101000000, "Platform Designation")
C(0101210200000000, "Platform Model")
C(0101210300000000, "Platform Serial Number")
C(0102000000000000, "Globally Unique Locators")
C(0102010000000000, "Uniform Resource Locators")
C(0102010100000000, "URL")
C(0102010101000000, "URL")
C(0102010200000000, "PURL")
C(0102010300000000, "URN")
C(0102010400000000, "Default Namespace URI")
C(0102010401000000, "Default Namespace URI")
C(0102010500000000, "Namespace URI")
C(0102010501000000, "Namespace URI")
C(0102010600000000, "Namespace URIs")
C(0102010601000000, "Namespace URIs")
C(0102010802000000, "Camera Setting File URI")
C(0102020000000000, "Registry Locators")
C(0102020100000000, "SMPTE UL")
C(0102020200000000, "Identification UL")
C(0102020300000000, "Operational Pattern UL")
C(0102021000000000, "Registry Locator Groups")
C(0102021001000000, "Registry Locator Ordered Group (Arrays)")
C(0102021001010000, "Essence Container Array")
C(0102021002000000, "Registry Locator Unordered Groups")
C(0102021002010000, "Essence Containers")
C(0102021002020000, "Descriptive Metadata Schemes")
C(0102021002030000, "Application Scheme Batch")
C(0102021002040000, "Conforms To Specifications")
C(0103000000000000, "Locally Unique Identifiers")
C(0103010000000000, "Administrative Identifiers")
C(0103010100000000, "Transmission ID")
C(0103010200000000, "Archive ID")
C(0103010300000000, "Item ID")
C(0103010400000000, "Accounting Reference Number")
C(0103010500000000, "Traffic ID")
C(0103010600000000, "Project Number")
C(0103010700000000, "Local Target ID")
C(0103010701000000, "Local Target ID")
C(0103010800000000, "Project Name")
C(0103010801000000, "Project Name")
C(0103010900000000, "NITF Layer Target ID")
C(0103010901000000, "NITF Layer Target ID")
C(0103020000000000, "Local Physical Media Identifiers")
C(0103020100000000, "Local Film ID")
C(0103020101000000, "Reel or Roll Number")
C(0103020102000000, "Edge Code Header")
C(0103020200000000, "Local Tape Identifiers")
C(0103020201000000, "Local Tape Number")
C(0103020300000000, "Disk Identifiers")
C(0103020301000000, "Magnetic Disks")
C(0103020301010000, "Magnetic Disk Number")
C(0103020302000000, "Optical Discs")
C(0103020302010000, "Optical Disc Number")
C(0103030000000000, "Local Object Identifiers")
C(0103030100000000, "LUID")
C(0103030200000000, "Package Name")
C(0103030201000000, "Package Name")
C(0103040000000000, "Network and Stream Identifiers")
C(0103040100000000, "Channel Handle")
C(0103040200000000, "Stream ID")
C(0103040300000000, "Transport Stream ID")
C(0103040400000000, "Essence Stream ID")
C(0103040500000000, "Index Stream ID")
C(0103040600000000, "RP217 Data Stream PID")
C(0103040700000000, "RP217 Video Stream PID")
C(0103040800000000, "Generic Stream ID")
C(0103040A00000000, "MCA Channel ID")
C(0103040B00000000, "Data Stream ID")
C(0103050000000000, "Organizational Program Identifiers")
C(0103050100000000, "Organizational Program Number")
C(0103050101000000, "Organizational Program Number")
C(0103060000000000, "Metadata Identifiers")
C(0103060100000000, "Item Designator ID")
C(0103060200000000, "Local Tag Value")
C(0103060300000000, "Local Tag Unique ID")
C(0103060400000000, "HTML DOCTYPE")
C(0103060401000000, "HTML DOCTYPE")
C(0103060500000000, "Namespace Prefix")
C(0103060501000000, "Namespace Prefix")
C(0103060600000000, "Namespace Prefixes")
C(0103060601000000, "Namespace Prefixes")
C(0103070000000000, "Channel Identifiers")
C(0103070100000000, "Audio Channel Identifiers")
C(0103070101000000, "MCA Label Dictionary ID")
C(0103070102000000, "MCA Tag Symbol")
C(0103070103000000, "MCA Tag Name")
C(0103070104000000, "Group of Soundfield Groups Link ID")
C(0103070105000000, "MCA Link ID")
C(0103070106000000, "Soundfield Group Link ID")
C(0103070300000000, "Stereoscopic Channel Identifiers")
C(0103070301000000, "Stereoscopic Eye ID")
C(0103070302000000, "Stereoscopic Data Essence Coding")
C(0103080000000000, "Operation Message Identifiers")
C(0103080100000000, "Security Message Identifiers")
C(0103080101000000, "ASM Request ID")
C(0103080102000000, "ASM Event ID")
C(0103080103000000, "ASM Link Encryption Key ID")
C(0104000000000000, "Locally Unique Locators")
C(0104010000000000, "Media Locators")
C(0104010100000000, "Local File Path")
C(0104010101000000, "Local File Path")
C(0104010200000000, "Physical Media Location")
C(0104010201000000, "Media Location")
C(0104010300000000, "Track Number")
C(0104010400000000, "Track Number Batch")
C(0104010500000000, "MCA Partition Kind")
C(0104010600000000, "MCA Partition Number")
C(0104070000000000, "Film Locators")
C(0104070100000000, "Edge Code")
C(0104070200000000, "Frame Code")
C(0104070300000000, "Key Code")
C(0104070400000000, "Ink Number")
C(0104090000000000, "Synchronization Locators")
C(0104090100000000, "Edge Code Start")
C(0104100000000000, "Proxy Locators")
C(0104100100000000, "Key Text")
C(0104100200000000, "Key Frame")
C(0104100300000000, "Key Sound")
C(0104100400000000, "Key Data or Program")
C(0105000000000000, "Titles")
C(0105010000000000, "Title Kind")
C(0105010100000000, "Title Kind")
C(0105020000000000, "Main Title")
C(0105020100000000, "Main Title")
C(0105030000000000, "Secondary Title")
C(0105030100000000, "Secondary Title")
C(0105040000000000, "Series Number")
C(0105040100000000, "Series Number")
C(0105050000000000, "Episode Number")
C(0105050100000000, "Episode Number")
C(0105060000000000, "Scene Number")
C(0105060100000000, "Scene Number")
C(0105070000000000, "Take Number")
C(0105080000000000, "Version Title")
C(0105080100000000, "Version Title")
C(0105090000000000, "Mission ID")
C(0105090100000000, "Mission ID")
C(01050A0000000000, "Working Title")
C(01050A0100000000, "Working Title")
C(01050B0000000000, "Original Title")
C(01050B0100000000, "Original Title")
C(01050C0000000000, "Clip Number")
C(01050C0100000000, "Clip Number")
C(01050D0000000000, "Brand Main Title")
C(01050D0100000000, "Brand Main Title")
C(01050E0000000000, "Brand Original Title")
C(01050E0100000000, "Brand Original Title")
C(01050F0000000000, "Framework Title")
C(01050F0100000000, "Framework Title")
C(0105100000000000, "MCA Title")
C(0105110000000000, "MCA Title Version")
C(0105120000000000, "MCA Title Sub-Version")
C(0105130000000000, "MCA Episode")
C(0107000000000000, "Local Identifiers")
C(0107010000000000, "Package Identifiers")
C(0107010100000000, "Track ID")
C(0107010200000000, "Track Name")
C(0107010201000000, "Track Name")
C(0107010203000000, "Definition Object Name")
C(0107010203010000, "Definition Object Name")
C(0107010300000000, "Content Package Metadata Link")
C(0107010400000000, "Defined Name")
C(0107010401000000, "Defined Name")
C(0107010500000000, "Described Track IDs")
C(0107010600000000, "Descriptive Clip Described Track IDs")
C(0107010700000000, "Shot Track IDs")
C(0108000000000000, "Generic Identifiers")
C(0108010000000000, "Identifier Kind")
C(0108020000000000, "Identifier Value")
C(010A000000000000, "Organization Identifiers")
C(010A010000000000, "Manufacturing Organization Identifiers")
C(010A010100000000, "Manufacturer Identifiers")
C(010A010101000000, "Device Manufacturer Name")
C(010A010101010000, "Device Manufacturer Name")
C(010A010103000000, "Manufacturer ID")
C(010A010200000000, "IEEE Manufacturer ID")
C(010A010300000000, "AAF Manufacturer ID")
C(010A020000000000, "General Organization Identifiers")
C(010A020100000000, "Organization Code")
C(010A020101000000, "Organization Code")
C(0110000000000000, "Intellectual Property Rights Identifiers")
C(0110010000000000, "SUISA CISAC IPI")
C(0110010100000000, "CISAC Legal Entity ID")
C(0110020000000000, "AGICOA Identifers")
C(0110020100000000, "AGICOA ID")
C(0110030000000000, "Music Industry Identifiers")
C(0110030100000000, "Recording Label Name")
C(0110030101000000, "Recording Label Name")
C(0110030200000000, "Collection Name")
C(0110030201000000, "Collection Name")
C(0110030300000000, "Origin Code")
C(0110030400000000, "Main Catalog Number")
C(0110030500000000, "Catalog Prefix Number")
C(0110030600000000, "Side Number")
C(0110030700000000, "Recorded Track Number")
C(0200000000000000, "ADMINISTRATION")
C(0201000000000000, "Supplier")
C(0201010000000000, "Source Organization")
C(0201010100000000, "Source Organization")
C(0201020000000000, "Supply Contract Number")
C(0201030000000000, "Original Producer Name")
C(0201030100000000, "Original Producer Name")
C(0201040000000000, "Supplying Department Name")
C(0201050000000000, "Supplier Identification Kind")
C(0201060000000000, "Supplier Identification Value")
C(0201070000000000, "Supplier Account Number")
C(0201080000000000, "Supplier Account Name")
C(0201080100000000, "Supplier Account Name")
C(0202000000000000, "Product")
C(0202010000000000, "Total Episode Count")
C(0202020000000000, "Series in a Series Group Count")
C(0202030000000000, "Programming Group Kind")
C(0202030100000000, "Programming Group Kind")
C(0202040000000000, "Episode Start Number")
C(0202050000000000, "Episode End Number")
C(0202060000000000, "Programming Group Title")
C(0202060100000000, "Programming Group Title")
C(0203000000000000, "Purchaser")
C(0203010000000000, "Purchasing Organization Name")
C(0203020000000000, "Sales Contract Number")
C(0203040000000000, "Purchasing Department")
C(0203050000000000, "Purchaser Identification Kind")
C(0203060000000000, "Purchaser Identification Value")
C(0203070000000000, "Purchaser Account Number")
C(0203080000000000, "Purchaser Account Name")
C(0203080100000000, "Purchaser Account Name")
C(0204000000000000, "Contract Descriptions")
C(0204010000000000, "Contract Type")
C(0204010100000000, "Contract Type Code")
C(0204010200000000, "Contract Type")
C(0204020000000000, "Contract Clause Description")
C(0204020100000000, "Contract Clause Description")
C(0204030000000000, "Contract Line Code")
C(0204030100000000, "Contract Line Name")
C(0204030200000000, "Contract Line Name")
C(0204040000000000, "Contract Terms of Business")
C(0204040100000000, "Contract Terms of Business")
C(0204050000000000, "Contract Installment Percentage")
C(0204060000000000, "Jurisdiction")
C(0204060100000000, "Jurisdiction")
C(0205000000000000, "Rights")
C(0205010000000000, "Copyright")
C(0205010100000000, "Copyright Status")
C(0205010101000000, "Copyright Status")
C(0205010200000000, "Copyright Owner Name")
C(0205010201000000, "Copyright Owner Name")
C(0205020000000000, "Intellectual Rights")
C(0205020100000000, "Intellectual Property Description")
C(0205020101000000, "Intellectual Property Description")
C(0205020200000000, "Intellectual Property Rights")
C(0205020201000000, "Intellectual Property Rights")
C(0205030000000000, "Legal Personalities")
C(0205030100000000, "Rightsholder")
C(0205030101000000, "Rightsholder")
C(0205030200000000, "Rights Management Authority")
C(0205030201000000, "Rights Management Authority")
C(0205030300000000, "Interested Party Name")
C(0205040000000000, "Intellectual Property Rights Options")
C(0205040100000000, "Maximum Use Count")
C(0205040200000000, "License Options Description")
C(0205040300000000, "Rights Condition Description")
C(0205040301000000, "Rights Condition Description")
C(0205040400000000, "Rights Comment")
C(0205040401000000, "Rights Comment")
C(0206000000000000, "Financial Information")
C(0206010000000000, "Currencies")
C(0206010100000000, "Currency Code")
C(0206010101000000, "Currency Name")
C(0206010200000000, "Total Currency Amount")
C(0206010300000000, "Installment Number")
C(0206020000000000, "Payments and Costs")
C(0206020100000000, "Royalty Payment Information")
C(0206020200000000, "Total Payment")
C(0206020300000000, "Payee Account Name")
C(0206020400000000, "Payee Account Number")
C(0206020500000000, "Payee Account Sort Code")
C(0206030000000000, "Income")
C(0206030100000000, "Royalty Income Information")
C(0206030200000000, "Total Income")
C(0206030300000000, "Payer Account Name")
C(0206030400000000, "Payer Account Number")
C(0206030500000000, "Payer Account Sort Code")
C(0207000000000000, "Access Control")
C(0207010000000000, "Restrictions on Use")
C(0207020000000000, "ExCCI Data")
C(0207030000000000, "ASM Bad Request Copy")
C(0207040000000000, "ASM Response")
C(0207050000000000, "ASM Log Record")
C(0207060000000000, "ASM Protocol Version")
C(0207070000000000, "ASM Playout Status")
C(0207080000000000, "ASM Buffer Overflow Flag")
C(0207090000000000, "ASM Key Present Flag")
C(02070A0000000000, "ASM Key Not Present Flag")
C(02070E0000000000, "ASM Projector Certificate Data")
C(0208000000000000, "Security")
C(0208010000000000, "System Access")
C(0208010100000000, "Username")
C(0208010101000000, "Username")
C(0208010200000000, "Password")
C(0208010201000000, "Password")
C(0208020000000000, "Classification")
C(0208020100000000, "Security Classification")
C(0208020101000000, "Security Classification")
C(0208020200000000, "Security Classification Caveats")
C(0208020201000000, "Security Classification Caveats")
C(0208020300000000, "Classified By")
C(0208020400000000, "Classification Reason")
C(0208020500000000, "Declassification Date")
C(0208020600000000, "Derived From")
C(0208020700000000, "Classification Comment")
C(0208020701000000, "Classification Comment")
C(0208020800000000, "Classification and Marking System")
C(0209000000000000, "Encryption")
C(0209010000000000, "Film Encryption")
C(0209010100000000, "Scrambling Keys")
C(0209010101000000, "Scrambling Key Kind")
C(0209010102000000, "Scrambling Key Value")
C(0209020000000000, "Data Encryption")
C(0209020100000000, "Data Encryption Algorithms")
C(0209020200000000, "Data Hashing Algorithms")
C(0209030000000000, "Digital Cinema Encryption")
C(0209030100000000, "Digital Cinema Encryption Algorithms")
C(0209030101000000, "Cipher Algorithm")
C(0209030102000000, "Cryptographic Key ID")
C(0209030103000000, "Encrypted Source Value")
C(0209030200000000, "Digital Cinema Hashing Algorithms")
C(0209030201000000, "MIC Algorithm")
C(0209030202000000, "MIC")
C(020A000000000000, "Identifiers and Locators Administration Authorities")
C(020A010000000000, "Identifier Issuing Authority")
C(020A010100000000, "Identifier Issuing Authority")
C(0210000000000000, "Publication Outlet")
C(0210010000000000, "Broadcast")
C(0210010100000000, "Broadcaster")
C(0210010101000000, "Broadcast Organization Name")
C(0210010101010000, "Broadcast Organization Name")
C(0210010102000000, "Broadcast Channel")
C(0210010102010000, "Broadcast Service Name")
C(0210010103000000, "Broadcast Medium Kind")
C(0210010103020000, "Broadcast Medium Code")
C(0210010104010000, "Broadcast Region")
C(0210010105000000, "Broadcast Region")
C(0210020000000000, "Publication")
C(0210020100000000, "General Publication")
C(0210020101000000, "Publishing Organization Name")
C(0210020101010000, "Publishing Organization Name")
C(0210020102000000, "Publishing Service Name")
C(0210020102010000, "Publishing Service Name")
C(0210020103000000, "Publishing Medium Name")
C(0210020103010000, "Publishing Medium Name")
C(0210020104000000, "Publishing Region Name")
C(0210020104010000, "Publishing Region Name")
C(0210020200000000, "Register Publication Information")
C(0210020201000000, "Register Kind")
C(0210020202000000, "Register Version")
C(0210020203000000, "Register Editor Name")
C(0210020204000000, "Register Status Kind")
C(0210020300000000, "Register Item")
C(0210020301000000, "Register Item Name")
C(0210020302000000, "Register Item Definition")
C(0210020303000000, "Register Item Symbol")
C(0210020304000000, "Register Item Defining Document Name")
C(0210020305000000, "Register Item UL")
C(0210020306000000, "Register Item Notes")
C(0210020307000000, "Register Item Introduction Version")
C(0210020308000000, "Register Item Hierarchy Level")
C(0210020309000000, "Register Node Wildcard Flag")
C(021002030A000000, "Register Entry Status")
C(0210020400000000, "Register Administration")
C(0210020401000000, "Register Action")
C(0210020402000000, "Register Approver Name")
C(0210020403000000, "Register Creation Time")
C(0210020404000000, "Registrant Name")
C(0210020405000000, "Register Item Originator Name")
C(0210020406000000, "Register User Name")
C(0210020407000000, "Register User Time")
C(0210020408000000, "Register Administration Notes")
C(0220000000000000, "Broadcast and Repeat Information")
C(0220010000000000, "Broadcast Flags")
C(0220010100000000, "First Broadcast Flag")
C(0220020000000000, "Repeat Numbers")
C(0220020100000000, "Current Repeat Number")
C(0220020200000000, "Previous Repeat Number")
C(0220030000000000, "Ratings")
C(0220030100000000, "Audience Rating")
C(0220030200000000, "Audience Reach")
C(0220030300000000, "Audience Share")
C(0220030400000000, "Audience Appreciation")
C(0230000000000000, "Participating Parties")
C(0230010000000000, "Individuals and Groups")
C(0230010100000000, "Nature of Personality (Individual or Group)")
C(0230010101000000, "Nature of Personality (Individual or Group)")
C(0230010200000000, "Production")
C(0230010201000000, "Contribution Status")
C(0230010201010000, "Contribution Status")
C(0230010300000000, "Support and Administration Details")
C(0230010301000000, "Support or Administration Status")
C(0230010301010000, "Support or Administration Status")
C(0230020000000000, "Organizations and Public Bodies")
C(0230020100000000, "Organization Kind")
C(0230020101000000, "Organization Kind")
C(0230020200000000, "Production Organization or Public Body")
C(0230020201000000, "Production Organization Role")
C(0230020201010000, "Production Organization Role")
C(0230020300000000, "Support and Administration Organization or Public Body")
C(0230020301000000, "Support Organization Role")
C(0230020301010000, "Support Organization Role")
C(0230050000000000, "Job Function Information")
C(0230050100000000, "Job Function Name")
C(0230050101000000, "Job Function Name")
C(0230050102000000, "Job Function Code")
C(0230050200000000, "Role Name")
C(0230050201000000, "Role Name")
C(0230050300000000, "Job Title")
C(0230050301000000, "Job Title")
C(0230060000000000, "Contact Information")
C(0230060100000000, "Contact Kind")
C(0230060101000000, "Contact Kind")
C(0230060200000000, "Contact Department Name")
C(0230060201000000, "Contact Department Name")
C(0230060300000000, "Person or Organization Details")
C(0230060301000000, "Person Names")
C(0230060301010000, "Family Name")
C(0230060301010100, "Family Name")
C(0230060301020000, "First Given Name")
C(0230060301020100, "First Given Name")
C(0230060301030000, "Second Given Name")
C(0230060301030100, "Second Given Name")
C(0230060301040000, "Third Given Name")
C(0230060301040100, "Third Given Name")
C(0230060301050000, "Salutation")
C(0230060301050100, "Salutation")
C(0230060301060000, "Honors and Qualifications")
C(0230060301060100, "Honors and Qualifications")
C(0230060301070000, "Person Description")
C(0230060301070100, "Person Description")
C(0230060301080000, "Other Given Names")
C(0230060301080100, "Other Given Names")
C(0230060301090000, "Alternate Name")
C(0230060301090100, "Alternate Name")
C(02300603010A0000, "Linking Name")
C(02300603010A0100, "Linking Name")
C(02300603010B0000, "Name Suffix")
C(02300603010B0100, "Name Suffix")
C(02300603010C0000, "Former Family Name")
C(02300603010C0100, "Former Family Name")
C(02300603010D0000, "Nationality")
C(02300603010D0100, "Nationality")
C(02300603010E0000, "Citizenship")
C(02300603010E0100, "Citizenship")
C(0230060302000000, "Group Names")
C(0230060302010000, "Main Name")
C(0230060302010100, "Main Name")
C(0230060302020000, "Supplementary Name")
C(0230060302020100, "Supplementary Name")
C(0230060303000000, "Organization Names")
C(0230060303010000, "Organization Main Name")
C(0230060303010100, "Organization Main Name")
C(0230060303020000, "Supplementary Organization Name")
C(0230060303020100, "Supplementary Organization Name")
C(0240000000000000, "Protocols")
C(0240010000000000, "Aux Data Transfer Protocol")
C(0240010100000000, "Aux Data Edit Unit Range Start Index")
C(0240010200000000, "Aux Edit Unit Range Count")
C(0240010300000000, "Aux Data Block Edit Unit Index")
C(0240010400000000, "Aux Data Block Edit Unit Edit Rate")
C(0240010500000000, "Aux Data Block Source Data Essence Coding UL")
C(0240010600000000, "Aux Data Block Source Data Item Length")
C(0240010700000000, "Aux Data Block Source Data Item")
C(0240010800000000, "Aux Data Block Source Cryptographic Context Length")
C(0240010900000000, "Aux Data Block Source Cryptographic Context")
C(0240020000000000, "SMS-OMB Communications Protocol")
C(0240020100000000, "Status Response")
C(0240020200000000, "Request ID")
C(0240020300000000, "Certificate Kind")
C(0240020400000000, "getCertificate Status")
C(0240020500000000, "Certificate Length")
C(0240020600000000, "Certificate Data")
C(0240020700000000, "Offset")
C(0240020800000000, "AuthId Text Length")
C(0240020900000000, "AuthId Text")
C(0240020A00000000, "Adjustment Status")
C(0240020B00000000, "Secure Clock Time")
C(0240020C00000000, "getSecureTime Status")
C(0240020D00000000, "CPL XML Data Length")
C(0240020E00000000, "CPL XML Data")
C(0240020F00000000, "AssetIntegrityHash Batch")
C(0240021000000000, "validateCPL Status")
C(0240021100000000, "CPL ID")
C(0240021200000000, "getCPLValidationResult Status")
C(0240021300000000, "KDM XML Data Length")
C(0240021400000000, "KDM XML Data")
C(0240021500000000, "validateKdm Status")
C(0240021600000000, "KDM ID")
C(0240021700000000, "getKDMValidationResult Status")
C(0240021800000000, "CplValidation Batch")
C(0240021900000000, "CPLProcessed Report Delinquency Time")
C(0240021A00000000, "Identifier Text Length")
C(0240021B00000000, "Identifier Text")
C(0240021C00000000, "Version Text Length")
C(0240021D00000000, "Version Text")
C(0240021E00000000, "Supported DataEssenceCoding ULs")
C(0240021F00000000, "Protocol Version")
C(0240022000000000, "OMB Status")
C(0240022100000000, "Start Time")
C(0240022200000000, "End Time")
C(0240022300000000, "Generation Status")
C(0240022400000000, "Export Status")
C(0240022500000000, "Next Report Start Time")
C(0240022600000000, "XML Report Data Length")
C(0240022700000000, "XML Report Data")
C(0300000000000000, "Interpretive")
C(0301000000000000, "Fundamental")
C(0301010000000000, "Countries and Languages")
C(0301010100000000, "Country and Region Codes")
C(0301010101000000, "ISO 3166 Country Code")
C(0301010102000000, "Region Code")
C(0301010110000000, "Country and Region Names")
C(0301010110010000, "Country Name")
C(0301010110010100, "Country Name")
C(0301010110020000, "Region Name")
C(0301010110020100, "Region Name")
C(0301010200000000, "Language Codes")
C(0301010201000000, "ISO 639-1 Language Code")
C(0301010201010000, "ISO 639-1 Language Code")
C(0301010202000000, "Text Language Codes")
C(0301010202010000, "ISO 639 Text Language Code")
C(0301010202020000, "ISO 639 Captions Language Code")
C(0301010202030000, "Framework Text Language Code")
C(0301010202110000, "Extended Text Language Code")
C(0301010202120000, "Extended Captions Language Code")
C(0301010202130000, "Framework Extended Text Language Code")
C(0301010202140000, "RFC 5646 Text Language Code")
C(0301010202150000, "Event Text Language Code")
C(0301010202160000, "RFC 5646 Language Tag List")
C(0301010203000000, "Spoken Language Codes")
C(0301010203010000, "Primary Spoken Language Code")
C(0301010203020000, "Secondary Spoken Language Code")
C(0301010203030000, "Primary Original Language Code")
C(0301010203040000, "Secondary Original Language Code")
C(0301010203110000, "Primary Extended Spoken Language Code")
C(0301010203120000, "Secondary Extended Spoken Language Code")
C(0301010203130000, "Original Extended Spoken Primary Language Code")
C(0301010203140000, "Secondary Original Extended Spoken Language Code")
C(0301010203150000, "RFC 5646 Spoken Language")
C(0301010210000000, "Language Names")
C(0301010210010000, "Language Name")
C(0301010210010100, "Language Name")
C(0301020000000000, "Data Interpretations and Definitions")
C(0301020100000000, "System Interpretations")
C(0301020101000000, "Operating System Interpretations")
C(0301020102000000, "Byte Order")
C(0301020103000000, "Essence Is Identified")
C(0301020104000000, "Object Model Version")
C(0301020105000000, "Format Version")
C(0301020106000000, "Major Version")
C(0301020107000000, "Minor Version")
C(0301020108000000, "Sector Size")
C(0301020109000000, "KAG Size")
C(030102010A000000, "Reversed Byte Order")
C(0301020200000000, "Property Definitions")
C(0301020201000000, "Is Optional")
C(0301020202000000, "Is Searchable")
C(0301020203000000, "Property Defaults")
C(0301020203010000, "Use Default Value")
C(0301020203020000, "Default Data Value")
C(0301020300000000, "Type Definition")
C(0301020301000000, "Size")
C(0301020302000000, "Is Signed")
C(0301020303000000, "Element Count")
C(0301020304000000, "Element Name List")
C(0301020305000000, "Type Definition Element Value List")
C(0301020306000000, "Member Name List")
C(0301020307000000, "Extendible Element Name List")
C(0301020308000000, "Type Definition Extendible Element Values")
C(0301020309000000, "Element Length")
C(030102030B000000, "Target Set")
C(0301020A00000000, "Name-Value Construct Interpretations")
C(0301020A01000000, "Item Name")
C(0301020A01010000, "Item Name")
C(0301020A02000000, "Item Value")
C(0301020A02010000, "Item Value")
C(0301021000000000, "KLV Interpretations")
C(0301021001000000, "Filler Data")
C(0301021002000000, "KLV Data Value")
C(0301021003000000, "Package KLV Data")
C(0301021004000000, "Component KLV Data")
C(0301021005000000, "Terminating Filler Data")
C(0301021006000000, "KLV Metadata Sequence")
C(0301021007000000, "Package Attributes")
C(0301021008000000, "Component Attributes")
C(0301022000000000, "XML Constructs and Interpretations")
C(0301022001000000, "XML Document Text")
C(0301022001010000, "XML Document Text")
C(0301022001020000, "XML Document Text")
C(0301022001030000, "XML Document Text")
C(0301022002000000, "XML BiM Constructs in Multiple Streams")
C(0301022002010000, "MPEG-7 BiM Decoder Init Frames")
C(0301022002010100, "MPEG-7 BiM Decoder Init Frame (Stream 1)")
C(0301022002010200, "MPEG-7 BiM Decoder Init Frame (Stream 2)")
C(0301022002010300, "MPEG-7 BiM Decoder Init Frame (Stream 3)")
C(0301022002010400, "MPEG-7 BiM Decoder Init Frame (Stream 4)")
C(0301022002010500, "MPEG-7 BiM Decoder Init Frame (Stream 5)")
C(0301022002010600, "MPEG-7 BiM Decoder Init Frame (Stream 6)")
C(0301022002010700, "MPEG-7 BiM Decoder Init Frame (Stream 7)")
C(0301022002010800, "MPEG-7 BiM Decoder Init Frame (Stream 8)")
C(0301022002020000, "MPEG-7 BiM Access Unit Frames")
C(0301022002020100, "MPEG-7 BiM Access Unit Frame (Stream 1)")
C(0301022002020200, "MPEG-7 BiM Access Unit Frame (Stream 2)")
C(0301022002020300, "MPEG-7 BiM Access Unit Frame (Stream 3)")
C(0301022002020400, "MPEG-7 BiM Access Unit Frame (Stream 4)")
C(0301022002020500, "MPEG-7 BiM Access Unit Frame (Stream 5)")
C(0301022002020600, "MPEG-7 BiM Access Unit Frame (Stream 6)")
C(0301022002020700, "MPEG-7 BiM Access Unit Frame (Stream 7)")
C(0301022002020800, "MPEG-7 BiM Access Unit Frame (Stream 8)")
C(0301022003000000, "Text Data")
C(0301022003010000, "UTF-8 Text Data")
C(0301022003020000, "UTF-16 Text Data")
C(0301030000000000, "Fundamental Dimensions")
C(0301030100000000, "Length")
C(0301030101000000, "Length System Name")
C(0301030102000000, "Length Unit Kind")
C(0301030200000000, "Angles")
C(0301030201000000, "Angular Unit Kind")
C(0301030300000000, "Time")
C(0301030301000000, "Time System Offset")
C(0301030302000000, "Time Unit Kind")
C(0301030303000000, "Timing Bias Correction")
C(0301030304000000, "Timing Bias Correction Description")
C(0301030400000000, "Mass")
C(0301030500000000, "Energy")
C(0302000000000000, "Human Assigned Descriptors")
C(0302010000000000, "Categorization")
C(0302010100000000, "Content Classification")
C(0302010101000000, "Content Coding System")
C(0302010102000000, "Program Kind")
C(0302010103000000, "Genre")
C(0302010103010000, "Genre")
C(0302010104000000, "Target Audience")
C(0302010104010000, "Target Audience")
C(0302010110000000, "Program Material Classification Code")
C(0302010200000000, "Cataloging and Indexing")
C(0302010201000000, "Catalog Data Status")
C(0302010202000000, "Thesaurus Name")
C(0302010202010000, "Thesaurus Name")
C(0302010203000000, "Theme")
C(0302010203010000, "Theme")
C(0302010204000000, "Content Classification")
C(0302010204010000, "Subject Name")
C(0302010204020000, "Subject Name")
C(0302010205000000, "Keywords")
C(0302010205010000, "Keywords")
C(0302010206000000, "Key Frames")
C(0302010207000000, "Key Sounds")
C(0302010208000000, "Key Data")
C(0302010209000000, "Assigned Category Name")
C(0302010209010000, "Assigned Category Name")
C(030201020A000000, "Assigned Category Value")
C(030201020A010000, "Assigned Category Value")
C(030201020B000000, "Shot List")
C(030201020C000000, "Package User Comments")
C(030201020D000000, "Cue-In Words")
C(030201020D010000, "Cue-In Words")
C(030201020E000000, "Cue-Out Words")
C(030201020E010000, "Cue-Out Words")
C(030201020F000000, "Key Frame Sample Count")
C(0302010210000000, "Keypoint Kind")
C(0302010210010000, "Keypoint Kind")
C(0302010211000000, "Keypoint Value")
C(0302010211010000, "Keypoint Value")
C(0302010215000000, "Framework Thesaurus Name")
C(0302010215010000, "Framework Thesaurus Name")
C(0302010216000000, "Component User Comments")
C(0302010220000000, "MCA Audio Content Kind")
C(0302010221000000, "MCA Audio Element Kind")
C(0302010222000000, "MCA Content")
C(0302010223000000, "MCA Use Class")
C(0302010224000000, "MCA Content Subtype")
C(0302010225000000, "MCA Content Differentiator")
C(0302010226000000, "MCA Spoken Language Attribute")
C(0302010227000000, "RFC 5646 Additional Spoken Languages")
C(0302010228000000, "MCA Additional Language Attributes")
C(0302010600000000, "Textual Description")
C(0302010601000000, "Abstract")
C(0302010601010000, "Abstract")
C(0302010602000000, "Purpose")
C(0302010602010000, "Purpose")
C(0302010603000000, "Description")
C(0302010603010000, "Description")
C(0302010603020000, "Text Data Description")
C(0302010604000000, "Color Descriptor")
C(0302010604010000, "Color Descriptor")
C(0302010605000000, "Format Descriptor")
C(0302010605010000, "Format Descriptor")
C(0302010606000000, "Intent Descriptor")
C(0302010606010000, "Intent Descriptor")
C(0302010607000000, "Textual Description Kind")
C(0302010607010000, "Textual Description Kind")
C(0302010608000000, "Group Synopsis")
C(0302010608010000, "Group Synopsis")
C(0302010609000000, "Annotation Synopsis")
C(0302010609010000, "Annotation Synopsis")
C(030201060A000000, "Annotation Description")
C(030201060A010000, "Annotation Description")
C(030201060B000000, "Scripting Kind")
C(030201060B010000, "Scripting Kind")
C(030201060C000000, "Scripting Text")
C(030201060C010000, "Scripting Text")
C(030201060D000000, "Shot Description")
C(030201060D010000, "Shot Description")
C(030201060E000000, "Annotation Kind")
C(030201060E010000, "Annotation Kind")
C(030201060F000000, "Related Material Description")
C(030201060F010000, "Related Material Description")
C(0302010610000000, "JFIF Marker Description")
C(0302010610010000, "JFIF Marker Description")
C(0302010611000000, "HTML Meta Description")
C(0302010611010000, "HTML Meta Description")
C(0302010700000000, "Stratum")
C(0302010701000000, "Stratum Kind")
C(0302010800000000, "Subtitling")
C(0302010801000000, "Event Text Kind")
C(0302010802000000, "STL Line Number")
C(0302020000000000, "Assessments")
C(0302020100000000, "Awards")
C(0302020101000000, "Individual Award Name")
C(0302020102000000, "Program Award Name")
C(0302020103000000, "Festival Name")
C(0302020103010000, "Festival Name")
C(0302020104000000, "Award Name")
C(0302020104010000, "Award Name")
C(0302020105000000, "Award Category")
C(0302020105010000, "Award Category")
C(0302020106000000, "Nomination Category")
C(0302020106010000, "Nomination Category")
C(0302020200000000, "Qualitative Values")
C(0302020201000000, "Asset Value")
C(0302020202000000, "Content Value")
C(0302020203000000, "Cultural Value")
C(0302020204000000, "Aesthetic Value")
C(0302020205000000, "Historical Value")
C(0302020206000000, "Technical Value")
C(0302020207000000, "Other Values")
C(0302030000000000, "Technical Comments and Descriptions")
C(0302030100000000, "Object Comments and Descriptions")
C(0302030101000000, "Object Kind")
C(0302030101010000, "Object Kind")
C(0302030102000000, "Object Description")
C(0302030102010000, "Object Description")
C(0302030102020000, "Object Description Code")
C(0302030200000000, "General Comments")
C(0302030201000000, "Description Kind")
C(0302030201010000, "Description Kind")
C(0302030202000000, "Descriptive Comment")
C(0302030202010000, "Descriptive Comment")
C(0302030202100000, "Descriptive Comment for a Device")
C(0302030202100100, "Lens Attributes")
C(0302030202100200, "Camera Attributes")
C(0302040000000000, "Descriptive Names")
C(0302040100000000, "Object Names")
C(0302040101000000, "Generic Object Names")
C(0302040101010000, "Object Name")
C(0302040102000000, "MetaDefinition Name")
C(0302040102010000, "MetaDefinition Name")
C(0302050000000000, "Editorial Comments and Descriptions")
C(0302050100000000, "Shot Comment Kind")
C(0302050101000000, "Shot Comment Kind")
C(0302050200000000, "Shot Comment")
C(0302050201000000, "Shot Comment")
C(0302050300000000, "Slate Information")
C(0302050400000000, "Clip Kind")
C(0302060000000000, "Human-Assigned Context Descriptions")
C(0302060100000000, "Context Description")
C(0303000000000000, "Machine-Assigned or Computed Descriptions")
C(0303010000000000, "Automated Categorization")
C(0303010100000000, "Automated Content Classification")
C(0303010200000000, "Automated Cataloging and Indexing")
C(0303010201000000, "Catalog Data Status")
C(0303010202000000, "Cataloging System Name")
C(0303010206000000, "Computed Keywords")
C(0303010206010000, "Computed Keywords")
C(0303010207000000, "Computed Key Frames")
C(0303010208000000, "Computed Key Sounds")
C(0303010209000000, "Computed Key Data")
C(0303010600000000, "Computed Textual Description")
C(0303010700000000, "Automated Stratum")
C(0303010701000000, "Computed Stratum Kind")
C(0303030000000000, "Computed Technical Comments and Descriptions")
C(0303030100000000, "Computed Object Comments and Descriptions")
C(0303030101000000, "Computed Object Kind")
C(0303030101010000, "Computed Object Kind")
C(0303030102000000, "Version Number String")
C(0303030102010000, "Version Number String")
C(0303030103000000, "Version Number")
C(0303030104000000, "Object Identification Confidence")
C(0303030105000000, "Object Horizontal Average Dimension")
C(0303030106000000, "Object Vertical Average Dimension")
C(0303030107000000, "Object Area Dimension")
C(0303030200000000, "Derived Summary Information")
C(0303030201000000, "WAVE Summary")
C(0303030202000000, "AIFC Summary")
C(0303030203000000, "TIFF Summary")
C(0303031000000000, "Device Comments and Descriptions")
C(0303031001000000, "Device Usage Description")
C(0303031001010000, "Device Usage Description")
C(0400000000000000, "Parametric")
C(0401000000000000, "Video and Image Essence Characteristics")
C(0401010000000000, "Fundamental Image Characteristics")
C(0401010100000000, "Aspect Ratios")
C(0401010101000000, "Presentation Aspect Ratio")
C(0401010102000000, "Capture Aspect Ratio")
C(0401010103000000, "Viewport Aspect Ratio")
C(0401010104000000, "Horizontal Action Safe Percentage")
C(0401010105000000, "Vertical Action Safe Percentage")
C(0401010106000000, "Horizontal Graphics Safe Percentage")
C(0401010107000000, "Vertical Graphics Safe Percentage")
C(0401010108000000, "Perceived Display Format Name")
C(0401010108010000, "Perceived Display Format Code")
C(0401010109000000, "AFD and Bar Data")
C(040101010A000000, "Pan Scan Information")
C(0401020000000000, "Image Source Characteristics")
C(0401020100000000, "Opto-Electronic Formulation")
C(0401020101000000, "Transfer Characteristics")
C(0401020101010000, "Capture Gamma Equation")
C(0401020101010100, "Capture Gamma Equation")
C(0401020101010200, "Transfer Characteristic")
C(0401020101020000, "Luma Equation")
C(0401020101030000, "Colorimetry Code")
C(0401020101030100, "Coding Equations")
C(0401020101040000, "Signal Form Code")
C(0401020101050000, "Video Color Kind")
C(0401020101060000, "Color Primaries")
C(0401020101060100, "Color Primaries")
C(0401020101100000, "Presentation Gamma Equation")
C(0401020101100100, "Presentation Gamma Equation")
C(0401020200000000, "Sensor Parameters")
C(0401020201000000, "Sensor Mode")
C(0401030000000000, "Video and Image Scanning Parameters")
C(0401030100000000, "Temporal Parameters")
C(0401030101000000, "Color Field Code")
C(0401030102000000, "Field Rate")
C(0401030103000000, "Frame Rate")
C(0401030103010000, "Capture Frame Rate")
C(0401030104000000, "Frame Layout")
C(0401030105000000, "Sampling Structure Code")
C(0401030106000000, "Field Dominance")
C(0401030107000000, "Picture Display Rate")
C(0401030200000000, "Vertical Parameters")
C(0401030201000000, "Total Lines per Frame")
C(0401030202000000, "Active Lines per Frame")
C(0401030203000000, "Leading Lines")
C(0401030204000000, "Trailing Lines")
C(0401030205000000, "Video Line Map")
C(0401030207000000, "Display F2 Offset")
C(0401030208000000, "Stored F2 Offset")
C(0401030209000000, "Active Format Descriptor")
C(040103020A000000, "Line Number")
C(040103020B000000, "Alternative Center Cuts")
C(0401030300000000, "Horizontal Parameters")
C(0401040000000000, "Analog Video Coding Characteristics")
C(0401040100000000, "Analog Video System Name")
C(0401040101000000, "Video Signal")
C(0401040400000000, "Video Scanning Characteristics")
C(0401040401000000, "Scanning Direction")
C(0401050000000000, "Digital Video and Image Coding Parameters")
C(0401050100000000, "Digital Video and Image Sampling Parameters")
C(0401050101000000, "Luminance Sample Rate")
C(0401050102000000, "Active Samples per Line")
C(0401050103000000, "Total Samples per Line")
C(0401050104000000, "Sampling Hierarchy Code")
C(0401050105000000, "Horizontal Sub-sampling")
C(0401050106000000, "Color Siting")
C(0401050107000000, "Sampled Height")
C(0401050108000000, "Sampled Width")
C(0401050109000000, "Sampled X-Offset")
C(040105010A000000, "Sampled Y-Offset")
C(040105010B000000, "Display Height")
C(040105010C000000, "Display Width")
C(040105010D000000, "Display X-Offset")
C(040105010E000000, "Display Y-Offset")
C(040105010F000000, "Filtering Code")
C(0401050110000000, "Vertical Sub-sampling")
C(0401050111000000, "Video Average Bit Rate")
C(0401050112000000, "Video Fixed Bit Rate")
C(0401050113000000, "Active Height")
C(0401050114000000, "Active Width")
C(0401050115000000, "Active X Offset")
C(0401050116000000, "Active Y Offset")
C(0401050200000000, "Digital Video and Image Storage Parameters")
C(0401050201000000, "Stored Height")
C(0401050202000000, "Stored Width")
C(0401050203000000, "VBI Line Count")
C(0401050204000000, "Stored VBI Line Number")
C(0401050205000000, "VBI Wrapping Type")
C(0401050206000000, "VBI Payload Sample Count")
C(0401050207000000, "VBI Payload Byte Array")
C(0401050208000000, "ANC Packet Count")
C(0401050209000000, "Stored ANC Line Number")
C(040105020A000000, "ANC Wrapping Type")
C(040105020B000000, "ANC Payload Sample Count")
C(040105020C000000, "ANC Payload Byte Array")
C(0401050300000000, "Digital Quantization and Level Parameters")
C(0401050301000000, "Bits per Pixel")
C(0401050301010000, "Bits per Pixel")
C(0401050302000000, "Rounding Method Code")
C(0401050303000000, "Black Reference Level")
C(0401050304000000, "White Reference Level")
C(0401050305000000, "Color Range Levels")
C(0401050306000000, "Pixel Layout")
C(0401050307000000, "Alpha Sample Depth")
C(0401050308000000, "Palette")
C(0401050309000000, "Palette Layout")
C(040105030A000000, "Component Depth")
C(040105030B000000, "Component Maximum Ref")
C(040105030C000000, "Component Minimum Ref")
C(040105030D000000, "Alpha Maximum Ref")
C(040105030E000000, "Alpha Minimum Ref")
C(040105030F000000, "VBI Payload Sample Coding")
C(0401050310000000, "ANC Payload Sample Coding")
C(0401050400000000, "Digital Video and Image Signal Type Identifiers")
C(0401050401000000, "Video Payload Identifier")
C(0401050402000000, "Video Payload Identifier 2002")
C(0401060000000000, "Digital Video and Image Compression Parameters")
C(0401060100000000, "Video Coding Scheme ID")
C(0401060200000000, "MPEG Coding Parameters")
C(0401060201000000, "MPEG-2 Coding Parameters")
C(0401060201010000, "Field Frame Type Code")
C(0401060201020000, "Single Sequence Flag")
C(0401060201030000, "Constant B Picture Flag")
C(0401060201040000, "Coded Content Scanning Kind")
C(0401060201050000, "Low Delay Indicator")
C(0401060201060000, "Closed GOP Indicator")
C(0401060201070000, "Identical GOP Indicator")
C(0401060201080000, "Maximum GOP Size")
C(0401060201090000, "Maximum B Picture Count")
C(04010602010A0000, "Profile And Level")
C(04010602010B0000, "Bit Rate")
C(0401060202000000, "MPEG-4 Visual Coding Parameters")
C(0401060202010000, "MPEG-4 Visual VOP Coding Type")
C(0401060202020000, "MPEG-4 Visual Single Sequence")
C(0401060202030000, "MPEG-4 Visual Constant B-VOPs")
C(0401060202040000, "MPEG-4 Visual Coded Content Type")
C(0401060202050000, "MPEG-4 Visual Low Delay")
C(0401060202060000, "MPEG-4 Visual Closed GOP")
C(0401060202070000, "MPEG-4 Visual Identical GOP")
C(0401060202080000, "MPEG-4 Visual Max GOP")
C(0401060202090000, "MPEG-4 Visual B-VOP Count")
C(04010602020A0000, "MPEG-4 Visual Profile And Level")
C(04010602020B0000, "MPEG-4 Visual Bit Rate")
C(0401060300000000, "JPEG 2000 Coding Parameters")
C(0401060301000000, "Rsiz - Decoder capabilities")
C(0401060302000000, "Xsiz - Width")
C(0401060303000000, "Ysiz - Height")
C(0401060304000000, "XOsiz - Horizontal offset")
C(0401060305000000, "YOsiz - Vertical offset")
C(0401060306000000, "XTsiz - Width of one reference tile")
C(0401060307000000, "YTsiz - Height of one reference tile")
C(0401060308000000, "XTOsiz - Horizontal offset of the first tile")
C(0401060309000000, "YTOsiz - Vertical offset of the first tile")
C(040106030A000000, "Csiz - Number of components in the picture")
C(040106030B000000, "Picture Component Sizing")
C(040106030C000000, "Coding Style Default")
C(040106030D000000, "Quantization Default")
C(040106030E000000, "J2C Layout")
C(040106030F000000, "J2K Extended Capabilities")
C(0401060310000000, "J2K Profile")
C(0401060311000000, "J2K Corresponding Profile")
C(0401060400000000, "VC-1 Picture Essence Descriptors")
C(0401060401000000, "VC-1 Initialization Metadata")
C(0401060402000000, "VC-1 Single Sequence")
C(0401060403000000, "VC-1 Coded Content Type")
C(0401060404000000, "VC-1 Identical GOP")
C(0401060405000000, "VC-1 Maximum GOP")
C(0401060406000000, "VC-1 B Picture Count")
C(0401060407000000, "VC-1 Average Bit Rate")
C(0401060408000000, "VC-1 Maximum Bit Rate")
C(0401060409000000, "VC-1 Profile")
C(040106040A000000, "VC-1 Level")
C(0401060500000000, "TIFF Coding Parameters")
C(0401060501000000, "TIFF Byte Order")
C(0401060502000000, "TIFF Bits Per Sample  Array")
C(0401060503000000, "TIFF Compression Kind")
C(0401060504000000, "TIFF Photometric Interpretation Kind")
C(0401060505000000, "TIFF Orientation")
C(0401060506000000, "TIFF Samples Per Pixel")
C(0401060507000000, "TIFF Light Source Kind")
C(0401060601000000, "AVC Parameters")
C(0401060601030000, "AVC Constant B Picture Flag")
C(0401060601040000, "AVC Coded Content Kind")
C(0401060601060000, "AVC Closed GOP Indicator")
C(0401060601070000, "AVC Identical GOP Indicator")
C(0401060601080000, "AVC Maximum GOP Size")
C(0401060601090000, "AVC Maximum B-Picture Count")
C(04010606010A0000, "AVC Profile")
C(04010606010B0000, "AVC Maximum Bit Rate")
C(04010606010C0000, "AVC Profile Constraint")
C(04010606010D0000, "AVC Level")
C(04010606010E0000, "AVC Decoding Delay")
C(04010606010F0000, "AVC Maximum Ref Frames")
C(0401060601100000, "AVC Sequence Parameter Set Flag")
C(0401060601110000, "AVC Picture Parameter Set Flag")
C(0401060601140000, "AVC Average Bit Rate")
C(0401060602000000, "HEVC Parameters")
C(0401060602030000, "HEVC Constant B Picture Flag")
C(0401060602040000, "HEVC Coded Content Kind")
C(0401060602060000, "HEVC Closed GOP Indicator")
C(0401060602070000, "HEVC Identical GOP Indicator")
C(0401060602080000, "HEVC Maximum GOP Size")
C(0401060602090000, "HEVC Maximum B-Picture Count")
C(04010606020A0000, "HEVC Profile")
C(04010606020B0000, "HEVC Maximum Bit Rate")
C(04010606020C0000, "HEVC Profile Constraint")
C(04010606020D0000, "HEVC Level")
C(04010606020E0000, "HEVC Decoding Delay")
C(04010606020F0000, "HEVC Maximum Ref Frames")
C(0401060602100000, "HEVC Sequence Parameter Set Flag")
C(0401060602110000, "HEVC Picture Parameter Set Flag")
C(0401060602120000, "HEVC Tier")
C(0401060602130000, "HEVC Video Parameter Set Flag")
C(0401060602140000, "HEVC Average Bit Rate")
C(0401060602150000, "HEVC CTU Size")
C(0401060602160000, "HEVC Tile Uniform Spacing Flag")
C(0401060602170000, "HEVC Tile Columns Minus 1")
C(0401060602180000, "HEVC Tile Rows Minus 1")
C(0401060602190000, "HEVC Tile Width Minus 1")
C(04010606021A0000, "HEVC Tile Height Minus 1")
C(04010606021B0000, "HEVC Number of PPSs")
C(0401060700000000, "VC-2 Properties")
C(0401060701000000, "VC-2 Major Version")
C(0401060702000000, "VC-2 Minor Version")
C(0401060703000000, "VC-2 Profile")
C(0401060704000000, "VC-2 Level")
C(0401060705000000, "VC-2 Wavelet Filters")
C(0401060706000000, "VC-2 Sequence Headers Identical")
C(0401060707000000, "VC-2 Edit Units Are Complete Sequences")
C(0401060800000000, "VC-5 Parameters")
C(0401060801000000, "VC-5 Alpha Sampling")
C(0401060802000000, "VC-5 Bayer Component Pattern")
C(0401060803000000, "VC-5 Bayer Component Black Level")
C(0401060804000000, "VC-5 Bayer Component White Level")
C(0401060900000000, "Target Frame Parameters")
C(0401060901000000, "Target Frame Ancillary ResourceID")
C(0401060902000000, "Media Type")
C(0401060903000000, "Target Frame Index")
C(0401060904000000, "Target Frame Transfer Characteristic")
C(0401060905000000, "Target Frame Color Primaries")
C(0401060906000000, "Target Frame Component Max Ref")
C(0401060907000000, "Target Frame Component Min Ref")
C(0401060908000000, "Target Frame Essence StreamID")
C(0401060909000000, "ACES Picture SubDescriptor Instance ID")
C(040106090A000000, "Target Frame Viewing Environment")
C(0401060A00000000, "ACES Coding Parameters")
C(0401060A01000000, "ACES Authoring Information")
C(0401060A02000000, "ACES Mastering Display Primaries")
C(0401060A03000000, "ACES Mastering Display White Point Chromaticity")
C(0401060A04000000, "ACES Mastering Display Maximum Luminance")
C(0401060A05000000, "ACES Mastering Display Minimum Luminance")
C(0401060B00000000, "JPEG XS Coding Parameters")
C(0401060B01000000, "JPEG XS Ppih")
C(0401060B02000000, "JPEG XS Plev")
C(0401060B03000000, "JPEG XS Wf")
C(0401060B04000000, "JPEG XS Hf")
C(0401060B05000000, "JPEG XS Nc")
C(0401060B06000000, "JPEG XS Component Table")
C(0401060B07000000, "JPEG XS Cw")
C(0401060B08000000, "JPEG XS Hsl")
C(0401060B09000000, "JPEG XS Maximum Bit Rate")
C(0401060C00000000, "FFV1CodingParameters")
C(0401060C01000000, "FFV1InitializationMetadata")
C(0401060C02000000, "FFV1IdenticalGOP")
C(0401060C03000000, "FFV1MaxGOP")
C(0401060C04000000, "FFV1MaximumBitRate")
C(0401060C05000000, "FFV1Version")
C(0401060C06000000, "FFV1MicroVersion")
C(0401080000000000, "Film-to-Video Characteristics")
C(0401080100000000, "Film Pulldown Characteristics")
C(0401080101000000, "Pulldown Sequence")
C(0401080102000000, "Pulldown Field Dominance")
C(0401080103000000, "Video and Film Frame Relationship")
C(0401080200000000, "Film Frame Rates")
C(0401080201000000, "Capture Film Frame Rate")
C(0401080202000000, "Transfer Film Frame Rate")
C(0401080203000000, "Rounded Capture Film Frame Rate")
C(04010B0000000000, "Video File Formats")
C(04010B0100000000, "Digital Video File Format")
C(0401100000000000, "Image Test Parameters")
C(0401100100000000, "Video Test Parameters")
C(0401100101000000, "Video Test Parameter")
C(0401100102000000, "Video Test Result")
C(0401100103000000, "Video Test Result")
C(0401100200000000, "Film Test Parameters")
C(0401100201000000, "Film Test Parameter")
C(0401100202000000, "Film Test Result")
C(0401100203000000, "Film Test Result")
C(0402000000000000, "Audio Essence Characteristics")
C(0402010000000000, "Fundamental  Audio Characteristics")
C(0402010100000000, "Audio Formulation")
C(0402010101000000, "Electrospatial Formulation")
C(0402010102000000, "Filtering Applied")
C(0402010103000000, "Audio Reference Level")
C(0402010104000000, "Channel Count")
C(0402010105000000, "Channel Assignment")
C(0402010106000000, "Reference Image Edit Rate")
C(0402010107000000, "Reference Audio Alignment Level")
C(0402010110000000, "Audio Mix")
C(0402010110010000, "Audio Mono Channel Count")
C(0402010110020000, "Audio Stereo Channel Count")
C(0402020000000000, "Analog Audio Coding Parameters")
C(0402020100000000, "Analog System")
C(0402030000000000, "Digital Audio Coding Parameters")
C(0402030100000000, "Digital Sampling Parameters")
C(0402030101000000, "Audio Sample Rate")
C(0402030101010000, "Audio Sample Rate")
C(0402030102000000, "Audio Average Bit Rate")
C(0402030103000000, "Audio Fixed Bit Rate Flag")
C(0402030104000000, "Locked Indicator")
C(0402030105000000, "Peak Envelope")
C(0402030106000000, "Peak Envelope Version")
C(0402030107000000, "Peak Envelope Format")
C(0402030108000000, "Points Per Peak Value")
C(0402030109000000, "Peak Envelope Block Size")
C(040203010A000000, "Peak Channel Count")
C(040203010B000000, "Peak Frame Count")
C(040203010C000000, "Peak Of Peaks Position")
C(040203010D000000, "Peak Envelope Timestamp")
C(040203010E000000, "Peak Envelope Data")
C(040203010F000000, "IAB Sample Rate")
C(0402030200000000, "Digital Audio Storage Parameters")
C(0402030201000000, "Block Align")
C(0402030202000000, "Sequence Offset")
C(0402030203000000, "Block Start Offset")
C(0402030205000000, "File Security Report")
C(0402030206000000, "File Security Wave")
C(0402030300000000, "Digital Audio Quantization and Level Parameters")
C(0402030301000000, "Bits Per Sample")
C(0402030302000000, "Rounding Law")
C(0402030303000000, "Dither")
C(0402030304000000, "Bits Per Audio Sample")
C(0402030305000000, "Average Bytes Per Second")
C(0402030400000000, "MGA Sound Essence Coding Parameters")
C(0402030401000000, "MGA Sound Essence Block Align")
C(0402030402000000, "MGA Sound Essence Average Bytes Per Second")
C(0402030403000000, "MGA Sound Essence Sequence Offset")
C(0402030500000000, "MGA Audio Metadata Coding Parameters")
C(0402030501000000, "MGA Link ID")
C(0402030502000000, "MGA Audio Metadata Index")
C(0402030503000000, "MGA Audio Metadata Identifier")
C(0402030504000000, "MGA Audio Metadata Payload UL Array")
C(0402030600000000, "MGA Soundfield Group Label Coding Parameters")
C(0402030601000000, "MGA Metadata Section Link ID")
C(0402030602000000, "ADM Audio Programme ID")
C(0402030603000000, "ADM Audio Content ID")
C(0402030604000000, "ADM Audio Object ID")
C(0402030700000000, "S-ADM Audio Metadata Coding Parameters")
C(0402030701000000, "S-ADM Metadata Section Link ID")
C(0402030702000000, "S-ADM Profile Level UL Batch")
C(0402030800000000, "")
C(0402030801000000, "RIFF Chunk Stream ID")
C(0402030802000000, "RIFF Chunk ID")
C(0402030803000000, "RIFF Chunk UUID")
C(0402030804000000, "RIFF Chunk Hash SHA-1")
C(0402030806000000, "RIFF Chunk Stream IDs Array")
C(0402030900000000, "")
C(0402030901000000, "Num Local Channels")
C(0402030902000000, "Num ADM audioTrackUIDs")
C(0402030903000000, "ADM Channel Mappings Array")
C(0402030904000000, "Local Channel ID")
C(0402030905000000, "ADM audioTrackUID")
C(0402030906000000, "ADM audioTrackChannelFormatID")
C(0402030907000000, "ADM audioPackFormatID")
C(0402030A00000000, "")
C(0402030A01000000, "RIFF Chunk Stream ID (link 1)")
C(0402030A02000000, "ADM Profile and Level UL Batch")
C(0402030B00000000, "")
C(0402030B01000000, "RIFF Chunk Stream ID (link 2)")
C(0402030B02000000, "ADM audioProgrammeID (SMPTE ST 2131)")
C(0402030B03000000, "ADM audioContentID (SMPTE ST 2131)")
C(0402030B04000000, "ADM audioObjectID (SMPTE ST 2131)")
C(0402040000000000, "Digital Audio Compression Parameters")
C(0402040100000000, "Coding Law Kind")
C(0402040101000000, "Coding Law Name")
C(0402040200000000, "Audio Coding Scheme ID")
C(0402040201000000, "Audio Coding Scheme Code")
C(0402040202000000, "Audio Coding Scheme Name")
C(0402040300000000, "MPEG Audio Coding Parameters")
C(0402040301000000, "MPEG-1 Audio Coding Parameters")
C(0402040301010000, "Layer Number")
C(0402040301020000, "MPEG Audio Bit Rate")
C(0402040301030000, "AAC Channel Configuration")
C(0402040301040000, "AAC Sampling Frequency")
C(0402040301050000, "MPEG Audio Channel Assignment")
C(0402050000000000, "Digital Audio Processing Parameters")
C(0402050100000000, "AES-3 Processing Parameters")
C(0402050101000000, "Auxiliary Bits Mode")
C(0402050102000000, "Channel Status Mode")
C(0402050103000000, "Fixed Channel Status Data")
C(0402050104000000, "User Data Mode")
C(0402050105000000, "Fixed User Data")
C(0402050106000000, "Emphasis")
C(0402050107000000, "Linked Timecode Track ID")
C(0402050108000000, "SMPTE 337M Data Stream Number")
C(0402050200000000, "BWF Processing Parameters")
C(0402050201000000, "Bext Coding History")
C(0402050201010000, "Bext Coding History")
C(0402050202000000, "Qlty Basic Data")
C(0402050202010000, "Qlty Basic Data")
C(0402050203000000, "Qlty Start Of Modulation")
C(0402050203010000, "Qlty Start Of Modulation")
C(0402050204000000, "Qlty Quality Event")
C(0402050204010000, "Qlty Quality Event")
C(0402050205000000, "Qlty End Of Modulation")
C(0402050205010000, "Qlty End Of Modulation")
C(0402050206000000, "Qlty Quality Parameter")
C(0402050206010000, "Qlty Quality Parameter")
C(0402050207000000, "Qlty Operator Comment")
C(0402050207010000, "Qlty Operator Comment")
C(0402050208000000, "Qlty Cue Sheet")
C(0402050208010000, "Qlty Cue Sheet")
C(0402070000000000, "General Processing Parameters")
C(0402070100000000, "Dial Norm")
C(0402080000000000, "Film Sound Source")
C(0402080100000000, "Optical Track")
C(0402080200000000, "Magnetic Track")
C(0402090000000000, "Audio Metadata Elements")
C(0402090100000000, "ST 2109 Audio Metadata")
C(0402100000000000, "Audio Test Parameters")
C(0402100100000000, "Signal-to-Noise Ratio")
C(0402100200000000, "Weighting")
C(0403000000000000, "Data Essence Characteristics")
C(0403010000000000, "Fundamental Data Essence Parameters")
C(0403010100000000, "Caption Kind")
C(0403010101000000, "Caption Kind")
C(0403020000000000, "Analog Data Essence Coding Parameters")
C(0403020100000000, "Analog Data Coding Kind")
C(0403030000000000, "Digital Data Essence Coding Parameters")
C(0403030100000000, "Digital Encoding Bit Rate")
C(0403030200000000, "Data Essence Coding ID")
C(0403100000000000, "Data Essence Test Parameters")
C(0404000000000000, "Metadata Characteristics")
C(0404010000000000, "Fundamental Metadata Characteristics")
C(0404010100000000, "Timecode Characteristics")
C(0404010101000000, "Timecode Kind")
C(0404010102000000, "Timecode Timebase")
C(0404010102010000, "Timecode Timebase")
C(0404010102060000, "Rounded Timecode Timebase")
C(0404010103000000, "Timecode User Bits Flag")
C(0404010104000000, "Include Sync")
C(0404010105000000, "Drop Frame")
C(0404010200000000, "General Date-Time Coding Characteristics")
C(0404010201000000, "Date-Time Rate")
C(0404010202000000, "Date-Time Drop Frame Flag")
C(0404010203000000, "Date-Time Embedded Flag")
C(0404010204000000, "Date-Time Kind")
C(0404020000000000, "Analog Metadata Coding Characteristics")
C(0404020100000000, "Timecode Source Kind")
C(0404020200000000, "Analog Metadata Carrier")
C(0404030000000000, "Digital Metadata Coding Characteristics")
C(0404030100000000, "Digital Metadata Carrier")
C(0404040000000000, "Indexing Metadata Coding Characteristics")
C(0404040100000000, "Intra Edit Unit Indexing")
C(0404040101000000, "Slice Count")
C(0404040102000000, "Slice Number")
C(0404040103000000, "Element Delta")
C(0404040104000000, "Position Table Indexing")
C(0404040105000000, "Slice Offset List")
C(0404040106000000, "Delta Entry Array")
C(0404040107000000, "Position Table Count")
C(0404040108000000, "Position Table")
C(0404040200000000, "Inter Edit Unit Indexing")
C(0404040201000000, "Stream Offset")
C(0404040202000000, "Edit Unit Flags")
C(0404040203000000, "Temporal Offset")
C(0404040204000000, "Anchor Offset")
C(0404040205000000, "Index Entry Array")
C(0404040206000000, "Content Package Index Array")
C(0404040300000000, "Video Index Parameters")
C(0404040301000000, "Video Index Array")
C(0404050000000000, "Index Locations")
C(0404050100000000, "Single Index Location")
C(0404050200000000, "Forward Index Direction")
C(0404050300000000, "Is RIP Present")
C(0404050400000000, "Preceding Index Table")
C(0404050500000000, "Following Index Table")
C(0404050600000000, "Is Sparse")
C(0404100000000000, "Metadata Test Parameters")
C(0405000000000000, "Monitoring and Control Characteristics")
C(0405010000000000, "Fundamental Monitoring and Control Characteristics")
C(0405011300000000, "Signal Standard")
C(0405020000000000, "Analog Monitoring and Control Coding Characteristics")
C(0405020100000000, "Analog Monitoring and Control Coding Kind")
C(0405030000000000, "Digital Monitoring and Control Coding Parameters")
C(0405030100000000, "Digital Monitoring and Control Sampling Parameters")
C(0405100000000000, "Monitoring and Control Test Parameters")
C(0406000000000000, "General Coding Characteristics")
C(0406010000000000, "General Essence Coding Characteristics")
C(0406010100000000, "Sample Rate")
C(0406010200000000, "Essence Length")
C(0406010300000000, "Data Stream Sample Rate")
C(0406020000000000, "General Essence Container Characteristics")
C(0406020100000000, "Edit Unit Byte Count")
C(0406020200000000, "Approximate Image Container Size")
C(0406020300000000, "Product Format")
C(0406020301000000, "Product Format")
C(0406020400000000, "Ext Start Offset")
C(0406020500000000, "VBE Byte Count")
C(0406020600000000, "Single Essence Location")
C(0406020700000000, "Singular Partition Usage")
C(0406080000000000, "General Metadata Coding Characteristics")
C(0406080100000000, "Metadata Encoding Scheme Code")
C(0406080200000000, "RIFF Chunk ID")
C(0406080300000000, "Application Scheme")
C(0406080400000000, "Descriptive Metadata Scheme")
C(0406080500000000, "UDAM Set Identifier")
C(0406080600000000, "Text-Based Metadata Payload Scheme Identifier")
C(0406080700000000, "UDAM Set Version")
C(0406090000000000, "General Metadata Container Characteristics")
C(0406090100000000, "Header Byte Count")
C(0406090200000000, "Index Byte Count")
C(0406090300000000, "RIFF Chunk Length")
C(0406100000000000, "General Data Coding Characteristics")
C(0406100100000000, "Pack Length")
C(0406100200000000, "Source Length")
C(0406100300000000, "Data Stream Scheme URI")
C(0407000000000000, "General Essence and Data Parameters")
C(0407010000000000, "Component Data Definition")
C(0407010100000000, "Data Definition")
C(0407020000000000, "Essence Stream")
C(0407030000000000, "Timecode Stream Data")
C(0407040000000000, "RIFF Chunk Data")
C(0408000000000000, "Object Characteristics")
C(0409000000000000, "Format Characteristics")
C(0409010000000000, "Recorded Format")
C(0409010100000000, "Recorded Format")
C(0409020000000000, "MIME Media Type")
C(0409020100000000, "MIME Media Type")
C(0409020200000000, "Text MIME Media Type")
C(0409030000000000, "MIME Char Set")
C(0409030100000000, "MIME Char Set")
C(0409040000000000, "MIME Encoding")
C(0409040100000000, "MIME Encoding")
C(0409050000000000, "UCS Encoding")
C(040F000000000000, "Storage Characteristics")
C(040F010000000000, "Storage Kind")
C(040F010100000000, "Storage Kind")
C(040F010200000000, "Storage Kind Code")
C(0410000000000000, "Medium Characteristics")
C(0410010000000000, "Storage Medium Parameters")
C(0410010100000000, "Tape Medium Parameters")
C(0410010101000000, "Tape Shell Kind")
C(0410010101010000, "Tape Shell Kind")
C(0410010102000000, "Tape Formulation")
C(0410010102010000, "Tape Formulation")
C(0410010103000000, "Tape Capacity")
C(0410010104000000, "Tape Manufacturer")
C(0410010104010000, "Tape Manufacturer")
C(0410010105000000, "Tape Stock")
C(0410010105010000, "Tape Stock")
C(0410010106000000, "Tape Batch Number")
C(0410010106010000, "Tape Batch Number")
C(0410010110000000, "Tape Medium Fundamental Parameters")
C(0410010110010000, "Tape Partition Capacity")
C(0410010200000000, "Disc Medium Parameters")
C(0410010201000000, "Disc Medium Fundamental Parameters")
C(0410010202000000, "Disc Partition Capacity")
C(0410010300000000, "Film Medium Parameters")
C(0410010301000000, "Generic Film Medium Parameters")
C(0410010301010000, "Film Color Process")
C(0410010301020000, "Edge Code Format")
C(0410010301030000, "Perforations Per Frame")
C(0410010301030100, "Perforations Per Frame")
C(0410010301040000, "Film Format Name")
C(0410010301040100, "Film Format Name")
C(0410010301040200, "Film Format Name")
C(0410010301050000, "Film Stock Kind")
C(0410010301050100, "Film Stock Kind")
C(0410010301060000, "Film Stock Manufacturer Name")
C(0410010301060100, "Film Stock Manufacturer Name")
C(0410010301070000, "Film Batch Number")
C(0410010301070100, "Film Batch Number")
C(0410010301080000, "Film Gauge")
C(0410010301090000, "Edge Code Film Gauge")
C(0410010302000000, "Specific Film Medium Parameters")
C(0410010302010000, "Physical Media Length")
C(0410010302020000, "Film Capture Aperture")
C(0410010302030000, "Exposed Aspect Ratio")
C(0418000000000000, "Memory Storage Characteristics")
C(0418010000000000, "Memory Storage Alignment Characteristics")
C(0418010100000000, "Image Alignment Offset")
C(0418010200000000, "Image Start Offset")
C(0418010300000000, "Image End Offset")
C(0418010400000000, "Padding Bits")
C(0420000000000000, "Device Characteristics")
C(0420010000000000, "Camera Characteristics")
C(0420010100000000, "Image Characteristics")
C(0420010101000000, "Image Category")
C(0420010200000000, "Imager Characteristics")
C(0420010201000000, "Image Devices")
C(0420010201010000, "Image Source Device Kind")
C(0420010201010100, "Image Source Device Kind")
C(0420010300000000, "Acquisition Characteristics")
C(0420010301000000, "CameraOperation")
C(0420010301010000, "Auto Exposure Mode")
C(0420010301020000, "Auto Focus Sensing Area Setting")
C(0420010301030000, "Color Correction Filter Wheel Setting")
C(0420010301040000, "Neutral Density Filter Wheel Setting")
C(0420010301050000, "Image Sensor Dimension Effective Width")
C(0420010301060000, "Image Sensor Dimension Effective Height")
C(0420010301070000, "Image Sensor Readout Mode")
C(0420010301080000, "Shutter Speed (Angle)")
C(0420010301080100, "Shutter Speed (Time)")
C(0420010301090000, "Camera Master Gain Adjustment")
C(04200103010A0000, "ISO Sensitivity")
C(04200103010A0100, "ISO Sensitivity in Long Integer")
C(04200103010B0000, "Electrical Extender Magnification")
C(04200103010C0000, "Exposure Index of Photo Meter")
C(04200103010C0100, "Exposure Index of Photo Meter in Long Integer")
C(04200103010D0000, "Color Matrix")
C(04200103010E0000, "Rotary Shutter")
C(04200103010F0000, "Optical Anti-Aliasing Filter")
C(0420010301100000, "Image Sensor Decimation Ratio")
C(0420010301110000, "Image Scan Direction")
C(0420010301120000, "Luminance Code Range")
C(0420010301130000, "Acquisition Setting Procedure")
C(0420010302000000, "Adjustment")
C(0420010302010000, "Auto White Balance Mode")
C(0420010302020000, "White Balance")
C(0420010302030000, "Camera Master Black Level")
C(0420010302040000, "Camera Knee Point")
C(0420010302050000, "Camera Knee Slope")
C(0420010302060000, "Camera Luminance Dynamic Range")
C(0420010302070000, "Gamma for CDL")
C(0420010302080000, "ASC CDL V1.2")
C(0420010302090000, "Tint Correction")
C(04200103020A0000, "Color for CDL")
C(0420020000000000, "Optical Characteristics")
C(0420020100000000, "Optical Test Parameters")
C(0420020101000000, "Optical Device Parameters")
C(0420020101010000, "Optical Test Parameter Name")
C(0420020101020000, "Optical Test Result")
C(0420020101030000, "Optical Test Result")
C(0420020101040000, "Focal Length")
C(0420020101040100, "Focal Length")
C(0420020101050000, "Sensor Size")
C(0420020101060000, "Lens Aperture")
C(0420020101070000, "Sensor Type Code")
C(0420020101080000, "Field of View (FOV-Horizontal)")
C(0420020101080100, "Field of View (FOV-Horizontal)")
C(0420020101090000, "Anamorphic Lens Characteristic")
C(04200201010A0000, "Field of View (FOV-Vertical)")
C(04200201010A0100, "Field of View (FOV-Vertical FP-4)")
C(0420020200000000, "Optical Shooting Parameters")
C(0420020201000000, "Iris F-Number")
C(0420020202000000, "Focus Position From Image Plane")
C(0420020203000000, "Focus Position From Front Lens Vertex")
C(0420020204000000, "Macro Setting")
C(0420020205000000, "Lens Zoom 35mm Still Camera Equivalent")
C(0420020206000000, "Lens Zoom Actual Focal Length")
C(0420020207000000, "Optical Extender Magnification")
C(0420020208000000, "Iris T-Number")
C(0420020209000000, "Iris Ring Position")
C(042002020A000000, "Focus Ring Position")
C(042002020B000000, "Zoom Ring Position")
C(042002020C000000, "Anamorphic Lens Squeeze Ratio")
C(042002020D000000, "Optical Inversion")
C(0420030000000000, "Microphone Characteristics")
C(0420030100000000, "Sensor Type")
C(0420030200000000, "Polar Characteristic")
C(0420040000000000, "Display Characteristics")
C(0420040100000000, "Mastering Display Characteristics")
C(0420040101000000, "Mastering Display Color Volume")
C(0420040101010000, "Mastering Display Primaries")
C(0420040101020000, "Mastering Display White Point Chromaticity")
C(0420040101030000, "Mastering Display Maximum Luminance")
C(0420040101040000, "Mastering Display Minimum Luminance")
C(0420040102000000, "MD Color Volume")
C(0420040102010000, "MD Primaries")
C(0420040102020000, "MD White Point Chromaticity")
C(0420040102030000, "MD Maximum Luminance")
C(0420040102040000, "MD Minimum Luminance")
C(0430000000000000, "System Characteristics")
C(0430010000000000, "System Name or Number")
C(0500000000000000, "Process")
C(0501000000000000, "General Process Indicators")
C(0501010000000000, "Process Fundamentals")
C(0501010100000000, "Integration Indication")
C(0501010101000000, "Integration Indication")
C(0501010200000000, "Event Indication")
C(0501010201000000, "Event Indication")
C(0501010300000000, "Quality Flag")
C(0501010400000000, "Logo Flag")
C(0501010500000000, "Physical Instance Kind")
C(0501010600000000, "Graphic Kind")
C(0501010700000000, "Graphic Usage Kind")
C(0501010701000000, "Graphic Usage Kind")
C(0501010800000000, "Package Usage Kind")
C(0501020000000000, "Content Capture")
C(0501020100000000, "Digital or Analog Origination")
C(0501020200000000, "Video or Image Capture Process")
C(0501020300000000, "Film Capture Process")
C(0501020400000000, "Audio Capture Process")
C(0501020401000000, "Microphone Placement Techniques")
C(0501020500000000, "Data Capture Process")
C(0501020601000000, "Device Creator Name")
C(0501020602000000, "Device Product Name")
C(0501020603000000, "Device Version")
C(0501020604000000, "Device Instance Identifier")
C(0501030000000000, "Manipulation")
C(0501030100000000, "Simple Flagging Count")
C(0501030200000000, "Copy Count")
C(0501030201000000, "Generation Copy Number")
C(0501030300000000, "Clone Count")
C(0501030301000000, "Generation Clone Number")
C(0501030400000000, "Work-in-Progress Flag")
C(0501040000000000, "Music Flags")
C(0501040100000000, "Signature Tune Flag")
C(0501040200000000, "Background Music Flag")
C(0501040300000000, "Theme Music Flag")
C(0501040400000000, "Insert Music Flag")
C(0502000000000000, "Compression Processing")
C(0502010000000000, "Video or Image Compression")
C(0502010100000000, "Video or Image Compression Algorithm")
C(0502010200000000, "MPEG Processing")
C(0502010201000000, "MPEG-2 Processing")
C(0502010201010000, "Splicing Metadata")
C(0502010300000000, "JPEG Processing")
C(0502010301000000, "TIFF JPEG Processing")
C(0502010301010000, "Uniform Data Flag")
C(0502010301020000, "JPEG Table ID")
C(0502010302000000, "JFIF JPEG Processing")
C(0502020000000000, "Audio Compression")
C(0502020100000000, "Audio Compression Algorithm")
C(0502030000000000, "Data Essence Compression")
C(0502040000000000, "Metadata Compression")
C(0503000000000000, "Noise Reduction Processing")
C(0503010000000000, "Video Noise Reduction")
C(0503010100000000, "Video Noise Reduction Algorithm")
C(0503020000000000, "Audio Noise Reduction")
C(0503020100000000, "Audio Noise Reduction Algorithm")
C(0520000000000000, "Enhancement or Modification")
C(0520010000000000, "Image Essence Processing")
C(0520010100000000, "Enhancement or Modification Description")
C(0520010200000000, "Alpha Transparency")
C(0520020000000000, "Video Processor Settings")
C(0520020100000000, "Video Device Kind")
C(0520020200000000, "Video Device Parameter Name")
C(0520020300000000, "Video Device Parameter Setting")
C(0520030000000000, "Audio Essence Processing")
C(0520030100000000, "Audio Enhancement or Modification Description")
C(0520030200000000, "Audio First Mix-Down Process")
C(0520040000000000, "Audio Processor Settings")
C(0520040100000000, "Audio Device Kind")
C(0520040200000000, "Audio Device Parameter")
C(0520040300000000, "Audio Device Parameter Setting")
C(0520050000000000, "Data Essence Processing")
C(0520050100000000, "Data Enhancement or Modification Description")
C(0520060000000000, "Data Processor Settings")
C(0520060100000000, "Data Device Kind")
C(0520060200000000, "Data Device Parameter Name")
C(0520060300000000, "Data Device Parameter Setting")
C(0520070000000000, "Metadata Processing")
C(0520070100000000, "Modification Information")
C(0520070101000000, "Generation ID")
C(0520070102000000, "Application Supplier Name")
C(0520070102010000, "Application Supplier Name")
C(0520070103000000, "Application Name")
C(0520070103010000, "Application Name")
C(0520070104000000, "Application Version Number")
C(0520070105000000, "Application Version String")
C(0520070105010000, "Application Version String")
C(0520070106000000, "Application Platform")
C(0520070106010000, "Application Platform")
C(0520070107000000, "Application Product ID")
C(0520070108000000, "Linked Generation ID")
C(0520070109000000, "Container Version")
C(052007010A000000, "Toolkit Version")
C(052007010B000000, "Linked Application Plug-In Instance ID")
C(052007010C000000, "Linked Descriptive Framework Plug-In ID")
C(052007010D000000, "Application Plug-In Instance ID")
C(052007010E000000, "Descriptive Metadata Plug-In ID")
C(052007010F000000, "Application Environment ID")
C(0520070110000000, "Descriptive Metadata Application Environment ID")
C(0520070111000000, "Linked Descriptive Object Plug-In ID")
C(0520080000000000, "Metadata Processor Settings")
C(0520090000000000, "Code Processor Settings")
C(0520090100000000, "Plug-In Category ID")
C(0520090200000000, "Plug-In Platform ID")
C(0520090300000000, "Minimum Supported Platform Version")
C(0520090400000000, "Maximum Supported Platform Version")
C(0520090500000000, "Plug-In Engine ID")
C(0520090600000000, "Minimum Supported Engine Version")
C(0520090700000000, "Maximum Supported Engine Version")
C(0520090800000000, "Plug-In API ID")
C(0520090900000000, "Minimum API Version")
C(0520090A00000000, "Maximum API Version")
C(0520090B00000000, "Software-Only Support Flag")
C(0520090C00000000, "Hardware Accelerator Flag")
C(0520090D00000000, "Plug-In Locator Set")
C(0520090E00000000, "Authentication Flag")
C(0520090F00000000, "Associated Metadata Definition")
C(0530000000000000, "Editing Information")
C(0530010000000000, "Editing Version Information")
C(0530020000000000, "Editing Decision Information")
C(0530020100000000, "Default Fade Type")
C(0530030000000000, "Editing Matte Information")
C(0530040000000000, "Editing Event Information")
C(0530040100000000, "Active State")
C(0530040200000000, "Event Track Edit Rate")
C(0530040300000000, "Default Fade Edit Rate")
C(0530040400000000, "Event Comment")
C(0530040401000000, "Event Comment")
C(0530040500000000, "Timeline Edit Rate")
C(0530040600000000, "Index Edit Rate")
C(0530050000000000, "Editing Effect Information")
C(0530050100000000, "Fade-In Type")
C(0530050200000000, "Fade-Out Type")
C(0530050300000000, "Speed Change Effect Flag")
C(0530050400000000, "Input Segment Count")
C(0530050500000000, "Bypass")
C(0530050600000000, "Operation")
C(0530050700000000, "Value")
C(0530050800000000, "Edit Hint")
C(0530050900000000, "Operation Data Definition")
C(0530050A00000000, "Operation Category")
C(0530050B00000000, "Display Units")
C(0530050B01000000, "Display Units")
C(0530050C00000000, "Bypass Override")
C(0530050D00000000, "Control Point Value")
C(0530060000000000, "Editing Web Information")
C(0530060100000000, "Begin Anchor")
C(0530060101000000, "Begin Anchor")
C(0530060200000000, "End Anchor")
C(0530060201000000, "End Anchor")
C(0530070000000000, "Editing User Notes")
C(0531000000000000, "Color Transform Information")
C(0531010000000000, "DMCVT Essence Items")
C(0531010100000000, "Application Identifier")
C(0531010200000000, "Application Version Number")
C(0531010300000000, "Backwards Version")
C(0531010400000000, "Time Interval Start")
C(0531010500000000, "Time Interval Duration")
C(0531010600000000, "Upper Left Corner")
C(0531010700000000, "Lower Right Corner")
C(0531010800000000, "Window Number")
C(0531010900000000, "Targeted System Display Primaries")
C(0531010A00000000, "Targeted System Display White Point Chromaticity")
C(0531010B00000000, "Targeted System Display Maximum Luminance")
C(0531010C00000000, "Targeted System Display Minimum Luminance")
C(0531010D00000000, "Minimum PQ-encoded maxRGB")
C(0531010E00000000, "Average PQ-encoded maxRGB")
C(0531010F00000000, "Maximum PQ-encoded maxRGB")
C(0531011000000000, "Minimum PQ-encoded maxRGB Offset")
C(0531011100000000, "Average PQ-encoded maxRGB Offset")
C(0531011200000000, "Maximum PQ-encoded maxRGB Offset")
C(0531011300000000, "Tone Mapping Offset")
C(0531011400000000, "Tone Mapping Gain")
C(0531011500000000, "Tone Mapping Gamma")
C(0531011600000000, "Chroma Compensation Weight")
C(0531011700000000, "Saturation Gain")
C(0531011800000000, "Tone Detail Factor")
C(0531011900000000, "Luminance Lower Bound")
C(0531011A00000000, "Luminance Upper Bound")
C(0531011B00000000, "Luminance Range Selector")
C(0531011C00000000, "Chromaticity Disk Center")
C(0531011D00000000, "Chromaticity Disk Radius")
C(0531011E00000000, "Chromaticity Area Selector")
C(0531011F00000000, "Saturation Gain Function")
C(0531012000000000, "Tone Mapping Input Signal Weights")
C(0531012100000000, "Tone Mapping Input Signal Black Level Offset")
C(0531012200000000, "Tone Mapping Input Signal White Level Offset")
C(0531012300000000, "Shadow Gain Control")
C(0531012400000000, "Highlight Gain Control")
C(0531012500000000, "Mid-Tone Width Adjustment Factor")
C(0531012600000000, "Tone Mapping Output Fine Tuning Function")
C(0531012700000000, "Targeted System Display Signal Format")
C(0531012800000000, "Metadata Color Coding Workspace")
C(0531012900000000, "Pre-Matrix Tone Mapping 1")
C(0531012A00000000, "Pre-Matrix Tone Mapping 2")
C(0531012B00000000, "Pre-Matrix Tone Mapping 3")
C(0531012C00000000, "Color Remapping Matrix")
C(0531012D00000000, "Post-Matrix Tone Mapping 1")
C(0531012E00000000, "Post-Matrix Tone Mapping 2")
C(0531012F00000000, "Post-Matrix Tone Mapping 3")
C(0531013000000000, "Center Of Ellipse")
C(0531013100000000, "Rotation Angle")
C(0531013200000000, "Semi-Major Axis Internal Ellipse")
C(0531013300000000, "Semi-Major Axis External Ellipse")
C(0531013400000000, "Semi-Minor Axis External Ellipse")
C(0531013500000000, "Overlap Process Option")
C(0531013600000000, "Targeted System Display Actual Peak Luminance")
C(0531013700000000, "Rows In Targeted System Display Actual Peak Luminance")
C(0531013800000000, "Mastering Display Actual Peak Luminance")
C(0531013900000000, "Rows In Mastering Display Actual Peak Luminance")
C(0531013A00000000, "Maximum Scene Color Component Levels")
C(0531013B00000000, "Average MaxRGB")
C(0531013C00000000, "Distribution MaxRGB Percentages")
C(0531013D00000000, "Distribution MaxRGB Percentiles")
C(0531013E00000000, "Fraction Bright Pixels")
C(0531013F00000000, "Knee Point")
C(0531014000000000, "Bezier Curve Anchors")
C(0531014100000000, "Color Saturation Weight")
C(0531014200000000, "Maximum Content Light Level")
C(0531014300000000, "Maximum Frame Average Light Level")
C(0531020000000000, "DMCVT SubDescriptor Items")
C(0531020100000000, "DMCVT Application Identifier")
C(0531020200000000, "DMCVT Application Version Number")
C(0531020300000000, "DMCVT Backwards Version")
C(0531020900000000, "DMCVT Targeted System Display Primaries")
C(0531020A00000000, "DMCVT Targeted System Display White Point Chromaticity")
C(0531020B00000000, "DMCVT Targeted System Display Maximum Luminance")
C(0531020C00000000, "DMCVT Targeted System Display Minimum Luminance")
C(0531022700000000, "DMCVT Targeted System Display Signal Format")
C(0531023600000000, "DMCVT Targeted System Display Actual Peak Luminance")
C(0531023700000000, "DMCVT Rows In Targeted System Display Actual Peak Luminance")
C(0540000000000000, "Processing History")
C(0540010000000000, "Video Compression History")
C(0540010100000000, "Video Compression Algorithm")
C(0540010200000000, "MPEG Video Recoding Dataset")
C(0540020000000000, "Audio Compression History")
C(0540020100000000, "Upstream Audio Compression Algorithm")
C(0540020200000000, "MPEG Audio Recoding Dataset")
C(0540030000000000, "Data Compression History")
C(0540040000000000, "Metadata Compression History")
C(0540100000000000, "Transfer History")
C(0540100100000000, "Image Transfer History")
C(0540100101000000, "Film-to-Video Transfer Direction")
C(0540100102000000, "Film-to-Video Transfer Kind")
C(0540100103000000, "Film to Video Transfer Phase")
C(0600000000000000, "Relational")
C(0601000000000000, "Generic Relationships")
C(0601010000000000, "Essence and Metadata Relationships")
C(0601010100000000, "Essence to Essence Relationships")
C(0601010101000000, "Teletext Subtitles Flag")
C(0601010102000000, "Subtitle Datafile Flag")
C(0601010103000000, "Closed Caption Subtitles Flag")
C(0601010200000000, "Metadata to Essence Relationships")
C(0601010201000000, "Sample Index")
C(0601010202000000, "Source Container Format")
C(0601010203000000, "Source Key")
C(0601010204000000, "Display Type")
C(0601010205000000, "Intrinsic Picture Resolution")
C(0601010206000000, "Z-Position In Use")
C(0601010207000000, "Linked Data Stream ID")
C(0601010300000000, "Metadata to Metadata Relationships")
C(0601010301000000, "Source Package ID")
C(0601010302000000, "Source Track ID")
C(0601010303000000, "Relative Scope")
C(0601010304000000, "Relative Track")
C(0601010305000000, "Linked Track ID")
C(0601010306000000, "Channel ID")
C(0601010307000000, "Channel IDs")
C(0601010308000000, "Mono Source Track IDs")
C(0601010309000000, "Dynamic Source Package ID")
C(060101030A000000, "Dynamic Source Track IDs")
C(060101030B000000, "Source Index")
C(060101030C000000, "Source Species")
C(060101030D000000, "Source Value")
C(060101030E000000, "Timebase Reference Track ID")
C(060101030F000000, "ASM Event ID Batch")
C(0601010310000000, "ASM Link Encryption Key Batch")
C(0601010311000000, "ASM Link Encryption Key ID Batch")
C(0601010400000000, "Object to Object Relationships")
C(0601010401000000, "Weak References")
C(0601010401010000, "Object Class")
C(0601010401020000, "Essence Container Format")
C(0601010401020100, "Essence Container Format")
C(0601010401030000, "Codec Definition")
C(0601010401030100, "Codec Definition")
C(0601010401040000, "Parameter Definition")
C(0601010401050000, "Interpolation")
C(0601010401060000, "Parameter Data Type")
C(0601010401070000, "Codec Essence Descriptor")
C(0601010401080000, "Primary Package")
C(0601010401090000, "KLV Data Type")
C(06010104010A0000, "Composition Rendering")
C(06010104010B0000, "Base Class")
C(0601010402000000, "Strong References")
C(0601010402010000, "Content")
C(0601010402020000, "Dictionary")
C(0601010402030000, "Essence Description")
C(0601010402040000, "Segment")
C(0601010402050000, "Transition Effect")
C(0601010402060000, "Effect Rendering")
C(0601010402070000, "Input Segment")
C(0601010402080000, "Still Frame")
C(0601010402090000, "Selected")
C(06010104020A0000, "Annotation")
C(06010104020B0000, "Manufacturer Information Object")
C(06010104020C0000, "Descriptive Metadata Framework")
C(06010104020D0000, "Cryptographic Context Object")
C(06010104020E0000, "Application Plug-In Batch")
C(06010104020F0000, "Package Marker Object")
C(0601010402100000, "Package Timeline Marker Object")
C(0601010402110000, "Register Administration Object")
C(0601010402120000, "Register Entry Administration Object")
C(0601010402400000, "Strong Referencing to Descriptive Metadata Sets")
C(0601010402400500, "Group Set")
C(0601010402401C00, "Bank Details Set")
C(0601010402401D00, "Image Format Set")
C(0601010402402000, "Processing Set")
C(0601010402402100, "Project Set")
C(0601010402402200, "Contacts List Set")
C(0601010402402300, "Cue Words Sets")
C(0601010402402301, "Annotation Cue Words Set")
C(0601010402402302, "Shot Cue Words Set")
C(0601010403000000, "Weak References Batches")
C(0601010403010000, "Codec Essence Kinds")
C(0601010403020000, "Operation Parameters")
C(0601010403030000, "Descriptive Metadata Sets")
C(0601010403040000, "KLV Data Parent Properties")
C(0601010403050000, "Tagged Value Parent Properties")
C(0601010403060000, "Generic Payloads")
C(0601010403400000, "Weak Referencing to Descriptive Metadata Sets")
C(0601010403401300, "Participant Role Sets")
C(0601010403401301, "Award Participant Sets")
C(0601010403401302, "Contract Participant Sets")
C(0601010403401303, "Annotation Participant Sets")
C(0601010403401304, "Captions Description Participant Sets")
C(0601010403401400, "Person Sets")
C(0601010403401500, "Organization Sets")
C(0601010403401501, "Participant Organization Sets")
C(0601010403401502, "Person Organization Sets")
C(0601010403401600, "Location Sets")
C(0601010404000000, "Weak References Arrays")
C(0601010404010000, "Degraded Effects")
C(0601010404020000, "Descriptive Metadata Set References")
C(0601010405000000, "Strong References Batches")
C(0601010405010000, "Packages")
C(0601010405020000, "Essence Data")
C(0601010405030000, "Operation Definitions")
C(0601010405040000, "Parameter Definitions")
C(0601010405050000, "Data Definitions")
C(0601010405060000, "Plug-In Definitions")
C(0601010405070000, "Codec Definitions")
C(0601010405080000, "Container Definitions")
C(0601010405090000, "Interpolation Definitions")
C(06010104050A0000, "KLV Data Definitions")
C(06010104050B0000, "Tagged Value Definitions")
C(0601010405400000, "Strong References to Descriptive Metadata Batches")
C(0601010405400400, "Titles Sets")
C(0601010405400500, "Group Sets")
C(0601010405400600, "Identification Sets")
C(0601010405400700, "Episodic Item Sets")
C(0601010405400800, "Branding Sets")
C(0601010405400900, "Event Sets")
C(0601010405400A00, "Publication Sets")
C(0601010405400B00, "Award Sets")
C(0601010405400C00, "Caption Description Sets")
C(0601010405400D00, "Annotation Sets")
C(0601010405400D01, "Event Annotation Sets")
C(0601010405400E00, "Setting Period Sets")
C(0601010405400E01, "Production Setting Period Sets")
C(0601010405400E02, "Scene Setting Period Sets")
C(0601010405400F00, "Scripting Sets")
C(0601010405401000, "Classification Sets")
C(0601010405401100, "Shot Sets")
C(0601010405401101, "Scene Shot Sets")
C(0601010405401102, "Clip Shot Sets")
C(0601010405401200, "Key Point Sets")
C(0601010405401300, "Shot Participant Role Sets")
C(0601010405401400, "Shot Person Sets")
C(0601010405401500, "Organization Sets")
C(0601010405401600, "Shot Location Sets")
C(0601010405401700, "Address Sets")
C(0601010405401800, "Communication Sets")
C(0601010405401900, "Contract Sets")
C(0601010405401A00, "Rights Sets")
C(0601010405401B00, "Payments Sets")
C(0601010405401E00, "Device Parameters Sets")
C(0601010405401F00, "Name-Value Sets")
C(0601010405401F01, "Classification Name-Value Sets")
C(0601010405401F02, "Contact Name-Value Sets")
C(0601010405401F03, "Device Parameter Name-Value Sets")
C(0601010405401F04, "Address Name-Value Sets")
C(0601010405410000, "Text-Based Descriptive Metadata Sets")
C(0601010405410100, "Text-Based Object")
C(0601010406000000, "Strong References Arrays")
C(0601010406010000, "Available Representations")
C(0601010406020000, "Input Segments")
C(0601010406030000, "Essence Locators")
C(0601010406040000, "Identification List")
C(0601010406050000, "Package Tracks")
C(0601010406060000, "Control Point List")
C(0601010406070000, "Nested Scope Tracks")
C(0601010406080000, "Alternates")
C(0601010406090000, "Components")
C(06010104060A0000, "Parameters")
C(06010104060B0000, "File Descriptors")
C(06010104060C0000, "Metadata Server Locators")
C(06010104060D0000, "Related Material Locators")
C(06010104060E0000, "Scripting Locators")
C(06010104060F0000, "Unknown BWF Chunks")
C(0601010406100000, "Sub-descriptors")
C(0601010406110000, "Register Entry Array")
C(0601010406120000, "Register Administration Array")
C(0601010406130000, "Application Information Array")
C(0601010406140000, "Register Child Entry Array")
C(0601010500000000, "Metadata to Object Relationships")
C(0601010600000000, "Essence to Object Relationships")
C(0601010601000000, "Linked Package ID")
C(0601010602000000, "Encrypted Track File ID")
C(0601010603000000, "Cryptographic Context Link")
C(0601010700000000, "Object Dictionary to Metadata Relationships")
C(0601010701000000, "Parent Class")
C(0601010702000000, "Properties")
C(0601010703000000, "Is Concrete")
C(0601010704000000, "Property Type")
C(0601010705000000, "Local ID")
C(0601010706000000, "Is Unique Identifier")
C(0601010707000000, "Class Definitions")
C(0601010708000000, "Type Definitions")
C(0601010709000000, "Target Class of Strong Reference")
C(060101070A000000, "Target Class of Weak Reference")
C(060101070B000000, "Enumeration Underlying Integer Type")
C(060101070C000000, "Fixed Array Element Type")
C(060101070D000000, "Variable Array Element Type")
C(060101070E000000, "Set Element Type")
C(060101070F000000, "String Element Type")
C(0601010710000000, "Stream Element Type")
C(0601010711000000, "Member Types")
C(0601010712000000, "Renamed Type")
C(0601010713000000, "MetaDefinition Identification")
C(0601010714000000, "Dictionary Description")
C(0601010714010000, "MetaDefinition Description")
C(0601010715000000, "Local Tag Entries")
C(0601010716000000, "Root Meta Dictionary")
C(0601010717000000, "Root Preface")
C(0601010718000000, "Root Object Directory")
C(0601010719000000, "Root Format Version")
C(060101071A000000, "Root Extensions")
C(060101071B000000, "Extension Scheme ID")
C(060101071C000000, "Symbol Space URI")
C(060101071D000000, "Preferred Prefix")
C(060101071E000000, "Extension Description")
C(060101071F000000, "Meta-Definitions")
C(0601010720000000, "Original Property")
C(0601010721000000, "Element Of")
C(0601010722000000, "Member Of")
C(0602000000000000, "Related Production Material")
C(0602010000000000, "Program Support Material Reference")
C(0602020000000000, "Advertising Material Reference")
C(0602030000000000, "Program Commercial Material Reference")
C(0603000000000000, "Related Production Content")
C(0603050000000000, "Related Textual Content")
C(0603050100000000, "Production Script Reference")
C(0603050101000000, "Production Script Reference")
C(0603050200000000, "Transcript Reference")
C(0603050201000000, "Transcript Reference")
C(0608000000000000, "Stream and Storage Relationships")
C(0608010000000000, "Stream Relationships")
C(0608010100000000, "Continuity Counts")
C(0608010101000000, "Block Continuity Count")
C(0608010200000000, "Stream Positional Relationships")
C(0608010201000000, "Stream Position Indicator")
C(0608010201010000, "Stream Position Indicator")
C(0608010201020000, "Stream Position Indicator")
C(0608010201030000, "Body Offset")
C(0608020000000000, "Storage Relationships")
C(0608020100000000, "Contiguous Data Flag")
C(0608020200000000, "Storage Offsets")
C(0608020201000000, "Offset to Metadata")
C(0608020201010000, "Offset to Metadata")
C(0608020202000000, "Offset to Index Table")
C(0608020202010000, "Offset to Index Table")
C(0609000000000000, "Data Relationships")
C(0609020000000000, "Local Data Relationships")
C(0609020100000000, "Data Offsets")
C(0609020101000000, "Byte Offset")
C(0609020102000000, "Reverse Play")
C(0609020103000000, "Plaintext Offset")
C(0610000000000000, "Numerical Sequence")
C(0610010000000000, "Position in Sequence")
C(0610020000000000, "Relative Position in Sequence Offset")
C(0610030000000000, "Relative Position in Sequence Name")
C(0610040000000000, "Total Number in Sequence")
C(0610050000000000, "Triplet Sequence Number")
C(0610100000000000, "Relative Numerical Sequences")
C(0610100100000000, "First Number in Sequence")
C(0610100101000000, "First Number in Sequence")
C(0610100200000000, "Previous Number in Sequence")
C(0610100201000000, "Previous Partition")
C(0610100300000000, "Current Number in Sequence")
C(0610100301000000, "This Partition")
C(0610100400000000, "Next Number in Sequence")
C(0610100401000000, "Next Number in Sequence")
C(0610100500000000, "Last Number in Sequence")
C(0610100501000000, "Footer Partition")
C(0700000000000000, "Spatio-temporal")
C(0701000000000000, "Position and Space Vectors")
C(0701010000000000, "Positional System Information")
C(0701010100000000, "Image Coordinate System")
C(0701010200000000, "Map Datum Used")
C(0701010300000000, "Horizontal Datum")
C(0701010400000000, "Vertical Datum")
C(0701020000000000, "Positional Information")
C(0701020100000000, "Absolute Position")
C(0701020101000000, "Local Datum Absolute Position")
C(0701020101010000, "Local Datum Absolute Position Accuracy")
C(0701020102000000, "Device Absolute Position")
C(0701020102010000, "Device Absolute Positional Accuracy")
C(0701020102020000, "Device Altitude")
C(0701020102020100, "Device Altitude (Concise)")
C(0701020102040000, "Device Latitude")
C(0701020102040100, "Device Latitude (Degrees, Concise)")
C(0701020102040200, "Device Latitude")
C(0701020102060000, "Device Longitude")
C(0701020102060100, "Device Longitude (Degrees, Concise)")
C(0701020102060200, "Device Longitude")
C(0701020102100000, "Device X Dimension")
C(0701020102110000, "Device Y Dimension")
C(0701020102300000, "NMEA-0183 GPS Document Text")
C(0701020103000000, "Subject Absolute Position")
C(0701020103010000, "Frame Positional Accuracy")
C(0701020103020000, "Frame Center Latitude")
C(0701020103020200, "Frame Center Latitude")
C(0701020103030000, "Frame Center Latitude (Degrees, Concise)")
C(0701020103040000, "Frame Center Longitude")
C(0701020103040200, "Frame Center Longitude")
C(0701020103050000, "Frame Center Longitude (Degrees, Concise)")
C(0701020103060000, "Frame Center Latitude-Longitude")
C(0701020103070000, "Corner Latitude Point 1")
C(0701020103070100, "Corner Latitude Point 1 (Decimal Degrees)")
C(0701020103080000, "Corner Latitude Point 2")
C(0701020103080100, "Corner Latitude Point 2 (Decimal Degrees)")
C(0701020103090000, "Corner Latitude Point 3")
C(0701020103090100, "Corner Latitude Point 3 (Decimal Degrees)")
C(07010201030A0000, "Corner Latitude Point 4")
C(07010201030A0100, "Corner Latitude Point 4 (Decimal Degrees)")
C(07010201030B0000, "Corner Longitude Point 1")
C(07010201030B0100, "Corner Longitude Point 1 (Decimal Degrees)")
C(07010201030C0000, "Corner Longitude Point 2")
C(07010201030C0100, "Corner Longitude Point 2 (Decimal Degrees)")
C(07010201030D0000, "Corner Longitude Point 3")
C(07010201030D0100, "Corner Longitude Point 3 (Decimal Degrees)")
C(07010201030E0000, "Corner Longitude Point 4")
C(07010201030E0100, "Corner Longitude Point 4 (Decimal Degrees)")
C(07010201030F0000, "Bounding Rectangle")
C(0701020103100000, "Geographic Location")
C(0701020103110000, "Geographic Polygon Coordinates")
C(0701020103120000, "Geographic Area Northwest")
C(0701020103130000, "Geographic Area Southeast")
C(0701020103140000, "Geographic Area Source Datum")
C(0701020103150000, "Geographic Polygon Source Datum")
C(0701020103160000, "Frame Center Elevation")
C(0701020200000000, "Relative Position")
C(0701020201000000, "Local Datum Relative Position")
C(0701020201010000, "Local Datum Relative Position Accuracy")
C(0701020202000000, "Device Relative Position")
C(0701020202010000, "Device Relative Positional Accuracy")
C(0701020202020000, "Device Relative Position X")
C(0701020202030000, "Device Relative Position Y")
C(0701020202040000, "Device Relative Position Z")
C(0701020203000000, "Subject Relative Position")
C(0701020203010000, "Subject Relative Positional Accuracy")
C(0701020300000000, "Image Positional Information")
C(0701020301000000, "Position Within Viewport Image X Coordinate (Pixels)")
C(0701020302000000, "Position Within Viewport Image Y Coordinate (Pixels)")
C(0701020303000000, "Source Image Center X Coordinate (Pixels)")
C(0701020304000000, "Source Image Center Y Coordinate (Pixels)")
C(0701020305000000, "Viewport Image Center C Coordinate (Pixels)")
C(0701020306000000, "Viewport Image Center Y Coordinate (Pixels)")
C(0701030000000000, "Rate and Direction of Positional Change")
C(0701030100000000, "Absolute Rate and Direction of Positional Change")
C(0701030101000000, "Device Rate and Direction of Positional Change")
C(0701030101010000, "Device Absolute Speed")
C(0701030101020000, "Device Absolute Heading")
C(0701030102000000, "Subject Rate and Direction of Positional Change")
C(0701030102010000, "Subject Absolute Speed")
C(0701030102020000, "Subject Absolute Heading")
C(0701030200000000, "Relative Rate and Direction of Positional Change")
C(0701030201000000, "Device Relative Rate and Direction of Positional Change")
C(0701030201010000, "Device Relative Speed")
C(0701030201020000, "Device Relative Heading")
C(0701030202000000, "Subject Relative Rate and Direction of Positional Change")
C(0701030202010000, "Subject Relative Speed")
C(0701030202020000, "Subject Relative Heading")
C(0701080000000000, "Distance Measurements")
C(0701080100000000, "Device to Subject Distance")
C(0701080101000000, "Slant Range")
C(0701080102000000, "Subject Distance")
C(0701090000000000, "Dimensions")
C(0701090100000000, "Device Dimensions")
C(0701090200000000, "Subject Dimensions")
C(0701090201000000, "Target Width")
C(0701090300000000, "Location Dimensions")
C(0701090400000000, "Media Dimensions")
C(0701090401000000, "Image Dimensions")
C(0701090401010000, "Pan-and-Scan Image Dimensions")
C(0701090401010100, "Viewport Height")
C(0701090401010200, "Viewport Width")
C(0701100000000000, "Angular Specifications")
C(0701100100000000, "Device Angles")
C(0701100101000000, "Sensor Roll Angle")
C(0701100102000000, "Angle to North")
C(0701100103000000, "Obliquity Angle")
C(0701100104000000, "Platform Roll Angle")
C(0701100105000000, "Platform Pitch Angle")
C(0701100106000000, "Platform Heading Angle")
C(0701100200000000, "Subject Angles")
C(0701200000000000, "Abstract Locations")
C(0701200100000000, "Place Names")
C(0701200101000000, "Abstract Names")
C(0701200101010000, "Place Keyword")
C(0701200101010100, "Place Keyword")
C(0701200102000000, "Country Codes")
C(0701200102010000, "Object Country Code")
C(0701200102010100, "Object Country Code")
C(0701200102020000, "Shooting Country Code")
C(0701200102030000, "Setting Country Code")
C(0701200102040000, "Copyright License Country Code")
C(0701200102050000, "Intellectual Property License Country Code")
C(0701200102060000, "Object Country Code Method")
C(0701200102070000, "Country Code Method")
C(0701200102070100, "Country Code Method")
C(0701200102080000, "Non-US Classifying Country Code")
C(0701200102080100, "Classifying Country Code")
C(0701200102090000, "Releasable Country Code")
C(0701200102090100, "Releasable Country Code")
C(0701200103000000, "Regions")
C(0701200103010000, "Object Region Code")
C(0701200103010100, "Object Region Name")
C(0701200103020000, "Shooting Region Code")
C(0701200103020100, "Shooting Region Name")
C(0701200103030000, "Setting Region Code")
C(0701200103030100, "Setting Region Name")
C(0701200103040000, "Copyright License Region Code")
C(0701200103040100, "Copyright License Region Name")
C(0701200103050000, "Intellectual Property License Region Code")
C(0701200103050100, "Intellectual Property License Region Name")
C(0701200104000000, "Addresses")
C(0701200104010000, "Postal Addresses")
C(0701200104010100, "Room Number")
C(0701200104010101, "Room Number")
C(0701200104010200, "Street Number")
C(0701200104010201, "Street Number")
C(0701200104010300, "Street Name")
C(0701200104010301, "Street Name")
C(0701200104010400, "Postal Town")
C(0701200104010401, "Postal Town")
C(0701200104010500, "City Name")
C(0701200104010501, "City Name")
C(0701200104010600, "State or Province or County Name")
C(0701200104010601, "State or Province or County Name")
C(0701200104010700, "Postal Code")
C(0701200104010701, "Postal Code")
C(0701200104010800, "Country Name")
C(0701200104010801, "Country Name")
C(0701200104011100, "Room or Suite Name")
C(0701200104011101, "Room or Suite Name")
C(0701200104011200, "Building Name")
C(0701200104011201, "Building Name")
C(0701200104011300, "Address Line")
C(0701200104011301, "Address Line")
C(0701200104011400, "Place Name")
C(0701200104011401, "Place Name")
C(0701200104011500, "Geographical Coordinates")
C(0701200104011600, "Astronomical Body Name")
C(0701200104011601, "Astronomical Body Name")
C(0701200104020000, "Setting Addresses")
C(0701200104020100, "Setting Room Number")
C(0701200104020101, "Setting Room Number")
C(0701200104020200, "Setting Street Number or Building Name")
C(0701200104020201, "Setting Street Number or Building Name")
C(0701200104020300, "Setting Street Name")
C(0701200104020301, "Setting Street Name")
C(0701200104020400, "Setting Town Name")
C(0701200104020401, "Setting Town Name")
C(0701200104020500, "Setting City Name")
C(0701200104020501, "Setting City Name")
C(0701200104020600, "Setting State or Province or County Name")
C(0701200104020601, "Setting State or Province or County Name")
C(0701200104020700, "Setting Postal Code")
C(0701200104020701, "Setting Postal Code")
C(0701200104020800, "Setting Country Name")
C(0701200104020801, "Setting Country Name")
C(0701200110000000, "Electronic Address Varieties")
C(0701200110030000, "Electronic Address Information")
C(0701200110030100, "Telephone Number")
C(0701200110030101, "Telephone Number")
C(0701200110030200, "Fax Number")
C(0701200110030201, "Fax Number")
C(0701200110030300, "E-Mail Address")
C(0701200110030301, "E-Mail Address")
C(0701200110030400, "Central Telephone Number")
C(0701200110030500, "Mobile Telephone Number")
C(0701200110030600, "URL")
C(0701200110030601, "URL")
C(0701200200000000, "Place Descriptions")
C(0701200201000000, "Setting Description")
C(0701200201010000, "Setting Description")
C(0701200202000000, "Location Description")
C(0701200202010000, "Location Description")
C(0701200203000000, "Location Kind")
C(0701200203010000, "Location Kind")
C(0702000000000000, "Temporal")
C(0702010000000000, "Dates and Times")
C(0702010100000000, "General Dates and Times")
C(0702010101000000, "User Date-Time")
C(0702010101010000, "UTC User Date-Time")
C(0702010101020000, "Local User Date-Time")
C(0702010101030000, "SMPTE 309M User Date-Time")
C(0702010101040000, "SMPTE 12M User Date-Time")
C(0702010101050000, "POSIX Microseconds")
C(0702010101060000, "Register Release Date-Time")
C(0702010101070000, "Register Item Status Change Date-Time")
C(0702010101080000, "ASM Current Time")
C(0702010101090000, "PTP Timestamp Time")
C(07020101010A0000, "SMPTE 12-3 Time Code")
C(0702010200000000, "Absolute Dates and Times")
C(0702010201000000, "Material Start True Date-Time")
C(0702010201010000, "UTC Start Date-Time")
C(0702010201010100, "UTC Start Date-Time")
C(0702010201020000, "Local Start Date-Time")
C(0702010201030000, "UTC Instant Date-Time")
C(0702010201030100, "UTC Instant Date-Time")
C(0702010202000000, "Material Start Time Address")
C(0702010202010000, "Timecode Start Date-Time")
C(0702010202020000, "STL Reference Point Timecode")
C(0702010203000000, "Material End True Date-Time")
C(0702010203010000, "UTC End Date-Time")
C(0702010203020000, "Local End Date-Time")
C(0702010204000000, "Material End Time Address")
C(0702010204010000, "Timecode End Date-Time")
C(0702010205000000, "Material Occurrence True Date-Time")
C(0702010205010000, "UTC Last Modification Date-Time")
C(0702010205010100, "UTC Last Modification Date-Time")
C(0702010205020000, "Local Last Modification Date-Time")
C(0702010206000000, "Material Occurrence Time Address")
C(0702010206010000, "Timecode Last Modification Date-Time")
C(0702010207000000, "Event Start True Date-Time")
C(0702010207010000, "UTC Event Start Date-Time")
C(0702010207010100, "UTC Event Start Date-Time")
C(0702010207020000, "Local Event Start Date-Time")
C(0702010207020100, "Local Event Start Date-Time")
C(0702010207030000, "ASM Event List Start Time")
C(0702010207100000, "Defined Event Start True Date-Time")
C(0702010207100100, "Local Festival Date-Time")
C(0702010208000000, "Event Start Time Address")
C(0702010208010000, "Timecode Event Start Date-Time")
C(0702010208020000, "Timecode Array")
C(0702010209000000, "Event End True Date-Time")
C(0702010209010000, "UTC Event End Date-Time")
C(0702010209010100, "UTC Event End Date-Time")
C(0702010209020000, "Local Event End Date-Time")
C(0702010209020100, "Local Event End Date-Time")
C(070201020A000000, "Event End Time Address")
C(070201020A010000, "Timecode Event End Date-Time")
C(070201020A020000, "ASM Event List Stop Time")
C(0702010300000000, "Relative Times")
C(0702010301000000, "Material Start Relative Times")
C(0702010301010000, "Start Time Relative to Reference")
C(0702010301020000, "Start Timecode Relative to Reference")
C(0702010301030000, "Origin")
C(0702010301040000, "Start Time Relative to Reference")
C(0702010301050000, "Start Timecode")
C(0702010301060000, "Cut Point")
C(0702010301070000, "Key Time Point")
C(0702010301090000, "Shot Start Position")
C(07020103010A0000, "Indexing Start Position")
C(07020103010B0000, "Event Origin")
C(07020103010C0000, "Mark In")
C(07020103010D0000, "User Position")
C(07020103010E0000, "Package Mark In Position")
C(0702010302000000, "Material End Relative Times")
C(0702010302010000, "Material End Time Offset")
C(0702010302020000, "Material End Timecode Offset")
C(0702010302030000, "Mark Out")
C(0702010302040000, "Package Mark Out Position")
C(0702010303000000, "Event Start Relative Times")
C(0702010303010000, "Event Start Time Offset")
C(0702010303020000, "Event Start Timecode Offset")
C(0702010303030000, "Event Start")
C(0702010304000000, "Event End Relative Times")
C(0702010304010000, "Event End Time Offset")
C(0702010304020000, "Event End Timecode Offset")
C(0702010310000000, "Offsets")
C(0702010310010000, "Material Offsets")
C(0702010310010100, "Frame Count Offset")
C(0702010310020000, "Edit Offsets")
C(0702010310020100, "Control Point Time")
C(0702010310030000, "Event Offsets")
C(0702010310030100, "Event Elapsed Time to Start")
C(0702010310030200, "Event Elapsed Time to End")
C(0702010800000000, "Setting Date and Time")
C(0702010801000000, "Time Period Name")
C(0702010801010000, "Time Period Name")
C(0702010802000000, "Setting Date-Time")
C(0702010803000000, "Setting Period Description")
C(0702010803010000, "Setting Period Description")
C(0702011000000000, "Process Date-Time")
C(0702011001000000, "Creation Date-Time")
C(0702011001010000, "Local Creation Date-Time")
C(0702011001020000, "Timecode Creation Date-Time")
C(0702011001030000, "Creation Date-Time")
C(0702011001040000, "Clip Creation Date-Time")
C(0702011001050000, "Creation Timestamp")
C(0702011002000000, "Modification Date-Time")
C(0702011002010000, "Local Modification Date-Time")
C(0702011002020000, "Timecode Modification Date-Time")
C(0702011002030000, "Modification Date-Time")
C(0702011002040000, "Container Last Modification Date-Time")
C(0702011002050000, "Package Last Modification Date-Time")
C(0702012000000000, "Administrative Date-Time")
C(0702012001000000, "Contract Date-Time")
C(0702012002000000, "Rights Start Date-Time")
C(0702012003000000, "Rights Stop Date-Time")
C(0702012004000000, "Payment Due Date-Time")
C(0702020000000000, "Durations")
C(0702020100000000, "Absolute Durations")
C(0702020101000000, "Edit Timeline Durations")
C(0702020101010000, "Frame Count")
C(0702020101020000, "Index Duration")
C(0702020101030000, "Component Length")
C(0702020101040000, "Video Durations")
C(0702020101050000, "Audio Durations")
C(0702020101050100, "Default Fade Duration")
C(0702020101050200, "Fade-In Duration")
C(0702020101050300, "Fade-Out Duration")
C(0702020102000000, "Material Absolute Durations")
C(0702020102010000, "Material Absolute Duration")
C(0702020102020000, "Material Absolute Duration")
C(0702020102030000, "Textless Black Duration")
C(0702020102040000, "Shot Duration")
C(0702020102050000, "Video Clip Duration")
C(0702020103000000, "Event Absolute Durations")
C(0702020103010000, "Event Absolute Duration Frame Count")
C(0702020103020000, "Event Absolute Duration")
C(0702020103030000, "Event Absolute Duration")
C(0702020200000000, "Relative Scaling Durations")
C(0702030000000000, "Delay")
C(0702030100000000, "Encoding and Decoding")
C(0702030101000000, "Codec Delay")
C(0702030102000000, "Encoding Delay")
C(0702030103000000, "Decoding Delay")
C(0702030103010000, "Buffer Delay")
C(0702050000000000, "Latency")
C(0702050100000000, "Tolerance Mode")
C(0702050200000000, "Tolerance Window")
C(0702050300000000, "Tolerance Interpolation Method")
C(0702060000000000, "Temporal Characteristics")
C(0702060100000000, "Shutter Characteristics")
C(0702060101000000, "Shutter Speed")
C(0702060102000000, "Shutter Gating")
C(0D00000000000000, "Organizationally Registered for Public Use")
C(0D01000000000000, "AAF Association")
C(0D01010000000000, "AAF Attributes")
C(0D01010100000000, "AAF Information Attributes")
C(0D01010101000000, "AAF Information Attributes Version 1.x")
C(0D01010101010000, "Enumerated Attributes")
C(0D01010101010100, "Tape Format")
C(0D01040000000000, "MXF Descriptive Metadata Schemes")
C(0D01040100000000, "MXF-DMS Structure Version-1")
C(0D01040103000000, "DMS AS-03")
C(0D01040103010000, "DMS AS-03 Framework")
C(0D01040103010100, "AS-03 Identifier Kind")
C(0D01040103010200, "AS-03 Identifier")
C(0D01040103010300, "AS-03 Shim Name")
C(0D01040103010400, "AS-03 Signal Standard")
C(0D01040103010500, "AS-03 Intended AFD")
C(0D01040103010600, "AS-03 Slate Title")
C(0D01040103010700, "AS-03 NOLA Code")
C(0D01040103010800, "AS-03 Rating")
C(0D01040103010900, "AS-03 Nielsen Stream Identifier")
C(0D01050000000000, "MXF Generic Stream Data Element Key")
C(0D01070000000000, "AMWA Application Specifications")
C(0D01070100000000, "Application Specifications Version 1")
C(0D01070107000000, "AS_07")
C(0D0107010A000000, "AS-10")
C(0D0107010A010000, "DMS AS-10 Core")
C(0D0107010A010100, "DMS AS-10 Core Framework")
C(0D0107010A010101, "AS-10 Shim Name")
C(0D0107010A010102, "AS-10 Type")
C(0D0107010A010103, "AS-10 Main Title")
C(0D0107010A010104, "AS-10 Sub Title")
C(0D0107010A010105, "AS-10 Title Description")
C(0D0107010A010106, "AS-10 Organization Name")
C(0D0107010A010107, "AS-10 Person Name")
C(0D0107010A010108, "AS-10 Location Description")
C(0D0107010A010109, "AS-10 Common Spanning ID")
C(0D0107010A01010A, "AS-10 Spanning Number")
C(0D0107010A01010B, "AS-10 Cumulative Duration")
C(0D0107010B000000, "AS-11")
C(0D0107010B010000, "AS-11 Core")
C(0D0107010B010100, "AS-11 Core Framework")
C(0D0107010B010101, "Series Title")
C(0D0107010B010102, "Programme Title")
C(0D0107010B010103, "Episode Title/Episode No.")
C(0D0107010B010104, "Shim Name")
C(0D0107010B010105, "Audio Track Layout")
C(0D0107010B010106, "Primary Audio Language")
C(0D0107010B010107, "Closed Captions Present")
C(0D0107010B010108, "Closed Captions Type")
C(0D0107010B010109, "Closed Captions Language")
C(0D0107010B01010A, "Shim Version")
C(0D0107010B020000, "AS-11 Segmentation")
C(0D0107010B020100, "AS-11 Segmentation Framework")
C(0D0107010B020101, "Part Number")
C(0D0107010B020102, "Part Total")
C(0D0107010C000000, "AS-12")
C(0D0107010C010000, "DMS_AS_12")
C(0D0107010C010100, "DMS_AS_12_Framework")
C(0D0107010C010101, "AS_12_ShimName")
C(0D0107010C010102, "AS_12_Slate")
C(0D01080000000000, "AMWA Rules Based Specifications")
C(0D01080100000000, "Rules Based Specifications Version 1")
C(0D01080101000000, "Specification Identification")
C(0D01080101010000, "Specification Identifiers")
C(0D02000000000000, "EBU/UER")
C(0D02010000000000, "EBUCore")
C(0D02010100000000, "EBU Core Main Framework")
C(0D02010101000000, "Document Locator")
C(0D02010102000000, "Document ID")
C(0D02010103000000, "Core Metadata Set")
C(0D02010104000000, "Metadata  Schema Information Set")
C(0D02010200000000, "Core Metadata")
C(0D02010201000000, "Identifier Sets")
C(0D02010202000000, "Title Sets")
C(0D02010203000000, "Alternative Title Sets")
C(0D02010204000000, "Creator Entity Sets")
C(0D02010205000000, "Subject Sets")
C(0D02010206000000, "Description Sets")
C(0D02010207000000, "Publisher Entity Sets")
C(0D02010208000000, "Contributor Entity Sets")
C(0D02010209000000, "Date Sets")
C(0D0201020A000000, "Type Sets")
C(0D0201020B000000, "Language Sets")
C(0D0201020C000000, "Coverage Sets")
C(0D0201020D000000, "Rights Sets")
C(0D0201020E000000, "Rating Sets")
C(0D0201020F000000, "Version Set")
C(0D02010210000000, "Publication History Set")
C(0D02010211000000, "Planning Set")
C(0D02010212000000, "Custom Relation Sets")
C(0D02010213000000, "Basic Relation Sets")
C(0D02010214000000, "Format  Sets")
C(0D02010215000000, "Part Sets")
C(0D02010216000000, "Audience Rating Sets")
C(0D02010217000000, "Event Sets")
C(0D02010300000000, "Metadata  Schema Information")
C(0D02010301000000, "Metadata Schema")
C(0D02010302000000, "Metadata Schema Version")
C(0D02010303000000, "Metadata Framework Text Language")
C(0D02010304000000, "Metadata Namespace Prefix")
C(0D02010305000000, "Metadata Namespace")
C(0D02010306000000, "Metadata Provider Entity Set")
C(0D02010307000000, "Metadata Date Last Modified")
C(0D02010308000000, "Metadata Time Last Modified")
C(0D02010400000000, "Identifier")
C(0D02010401000000, "Identifier Value")
C(0D02010402000000, "Identifier Note")
C(0D02010403000000, "Identifier Type Group Set")
C(0D02010404000000, "Identifier Format  Group Set")
C(0D02010405000000, "Identifier Attributor Entity Set")
C(0D02010500000000, "Title")
C(0D02010501000000, "Title Attribution Date")
C(0D02010502000000, "Title Note")
C(0D02010503000000, "Title Value Sets")
C(0D02010504000000, "Title Length")
C(0D02010505000000, "Title Geographical Scope")
C(0D02010506000000, "Title Geographical Exclusion Scope")
C(0D02010507000000, "Title Type Group Set")
C(0D02010600000000, "Alternative Title")
C(0D02010601000000, "Alternative Title Attribution Date")
C(0D02010602000000, "Alternative Title Note")
C(0D02010603000000, "Alternative Title Value Sets")
C(0D02010604000000, "Alternative Title Type Group Set")
C(0D02010605000000, "Alternative Title Status Group Set")
C(0D02010606000000, "Alternative Title Length")
C(0D02010607000000, "Alternative Title Geographical Scope")
C(0D02010608000000, "Alternative Title Geographical Exclusion Scope")
C(0D02010700000000, "Creator")
C(0D02010800000000, "Subject")
C(0D02010801000000, "Subject Code")
C(0D02010802000000, "Subject Note")
C(0D02010803000000, "Subject Value Sets")
C(0D02010804000000, "Subject Definition Sets")
C(0D02010805000000, "Subject Type Group Set")
C(0D02010806000000, "Subject Attributor Entity Set")
C(0D02010900000000, "Description")
C(0D02010901000000, "Description Note")
C(0D02010902000000, "Description Value Sets")
C(0D02010903000000, "Description Type Group Set")
C(0D02010904000000, "DescriptionAttributorEntity Set")
C(0D02010905000000, "DescriptionLength")
C(0D02010906000000, "DescriptionGeographicalScope")
C(0D02010907000000, "DescriptionGeographicalExclusionScope")
C(0D02010908000000, "DescriptionAttributionDate")
C(0D02010909000000, "DescriptionCastFlag")
C(0D02010A00000000, "Publisher")
C(0D02010B00000000, "Contributor")
C(0D02010C00000000, "Date")
C(0D02010C01000000, "Date Created")
C(0D02010C02000000, "Year Created")
C(0D02010C03000000, "Date Issued")
C(0D02010C04000000, "Year Issued")
C(0D02010C05000000, "Date Modified")
C(0D02010C06000000, "Year Modified")
C(0D02010C07000000, "Date Digitized")
C(0D02010C08000000, "Year Digitized")
C(0D02010C09000000, "Date Released")
C(0D02010C0A000000, "Year Released")
C(0D02010C0B000000, "Date Copyrighted")
C(0D02010C0C000000, "Year Copyrighted")
C(0D02010C0D000000, "Date Note")
C(0D02010C0E000000, "Alternative Date Sets")
C(0D02010C0F000000, "Precision")
C(0D02010D00000000, "Date Type")
C(0D02010D01000000, "Date Value")
C(0D02010D02000000, "Textual Date Sets")
C(0D02010D03000000, "Date Type Group Set")
C(0D02010D04000000, "Date Format Group Set")
C(0D02010E00000000, "Type")
C(0D02010E01000000, "Type Note")
C(0D02010E02000000, "Type Value Sets")
C(0D02010E03000000, "Object Type Sets")
C(0D02010E04000000, "Genre Sets")
C(0D02010E05000000, "Target Audience Sets")
C(0D02010E06000000, "Type Type Group Set")
C(0D02010E07000000, "Audience Level Sets")
C(0D02010F00000000, "Object Type")
C(0D02010F01000000, "Object Type Group Set")
C(0D02011000000000, "Genre")
C(0D02011001000000, "Genre Type Group Set")
C(0D02011002000000, "Genre Level")
C(0D02011100000000, "Target Audience")
C(0D02011101000000, "Target Audience Reason")
C(0D02011102000000, "Target Audience Link To Logo")
C(0D02011103000000, "Target Audience Not Rated Flag")
C(0D02011104000000, "Target Audience Adult Content Flag")
C(0D02011105000000, "Target Audience Type Group Set")
C(0D02011106000000, "Target Audience Region Sets")
C(0D02011107000000, "Target Audience Exclusion Region Sets")
C(0D02011108000000, "Target Audience Format Group Set")
C(0D02011200000000, "Language")
C(0D02011201000000, "Language Code")
C(0D02011202000000, "Language Value Object")
C(0D02011203000000, "Language Note")
C(0D02011204000000, "Language Purpose Set")
C(0D02011300000000, "Coverage")
C(0D02011301000000, "Coverage Value Set")
C(0D02011302000000, "Spatial Set")
C(0D02011303000000, "Temporal Set")
C(0D02011304000000, "Coverage Type Group Set")
C(0D02011400000000, "Spatial")
C(0D02011401000000, "Location Sets")
C(0D02011500000000, "Location")
C(0D02011501000000, "Location ID")
C(0D02011502000000, "Location Code")
C(0D02011503000000, "Location Definition Note")
C(0D02011504000000, "Location Name Sets")
C(0D02011505000000, "Location Region Set")
C(0D02011506000000, "Location Type Group Set")
C(0D02011507000000, "Location Coordinates Set")
C(0D02011600000000, "Coordinates")
C(0D02011601000000, "PosX")
C(0D02011602000000, "PosY")
C(0D02011603000000, "Coordinates Format Group Set")
C(0D02011700000000, "Temporal")
C(0D02011701000000, "Temporal Definition Note")
C(0D02011702000000, "Period Of Time Sets")
C(0D02011703000000, "Temporal Type Group Set")
C(0D02011800000000, "Period Of Time")
C(0D02011801000000, "Period ID")
C(0D02011802000000, "Period Start Year")
C(0D02011803000000, "Period Start Date")
C(0D02011804000000, "Period Start Time")
C(0D02011805000000, "Period End Year")
C(0D02011806000000, "Period End Date")
C(0D02011807000000, "Period End Time")
C(0D02011808000000, "Period Name Sets")
C(0D02011900000000, "Rights")
C(0D02011901000000, "Rights ID")
C(0D02011902000000, "Rights Link")
C(0D02011903000000, "Rights Clearance Flag")
C(0D02011904000000, "Rights Note")
C(0D02011905000000, "Rights Value Sets")
C(0D02011906000000, "Exploitation Issues Sets")
C(0D02011907000000, "Copyright Statement Sets")
C(0D02011908000000, "Rights Coverage Set")
C(0D02011909000000, "Rights Holder Entity Sets")
C(0D0201190A000000, "Rights Contact Sets")
C(0D0201190B000000, "Rights Type Group Set")
C(0D0201190C000000, "Rights Attributed ID Sets")
C(0D0201190D000000, "Rights Format  Reference Sets")
C(0D0201190E000000, "Processing Restriction Flag")
C(0D0201190F000000, "Disclaimer Sets")
C(0D02011910000000, "Rights Coverage Sets")
C(0D02011A00000000, "Version")
C(0D02011A01000000, "Version Value Sets")
C(0D02011A02000000, "Version Type Group Set")
C(0D02011B00000000, "Rating")
C(0D02011B01000000, "Rating Reason")
C(0D02011B02000000, "Rating Link To Logo")
C(0D02011B03000000, "Rating Not Rated Flag")
C(0D02011B04000000, "Rating Adult Content Flag")
C(0D02011B05000000, "Rating Value Sets")
C(0D02011B06000000, "Rating Scale Min Value Sets")
C(0D02011B07000000, "Rating Scale Max Value Sets")
C(0D02011B08000000, "Rating Type Group Set")
C(0D02011B09000000, "Rating Format  Group Set")
C(0D02011B0A000000, "Rating Provider Entity Set")
C(0D02011B0B000000, "Rating Region Set")
C(0D02011B0C000000, "Rating System")
C(0D02011B0D000000, "Rating Environment")
C(0D02011B0E000000, "Rating Link")
C(0D02011B0F000000, "Rating Exclusion Region Sets")
C(0D02011B10000000, "Rating Region Sets")
C(0D02011C00000000, "Publication Event")
C(0D02011C01000000, "Publication Event Name")
C(0D02011C02000000, "Publication Event Identifier")
C(0D02011C03000000, "First Showing Flag")
C(0D02011C04000000, "Last Showing Flag")
C(0D02011C05000000, "Publication Date")
C(0D02011C06000000, "Publication Time")
C(0D02011C07000000, "Schedule date")
C(0D02011C08000000, "Free Publication Flag")
C(0D02011C09000000, "Live Publication Flag")
C(0D02011C0A000000, "Publication Note")
C(0D02011C0B000000, "Publication Format  Reference Set")
C(0D02011C0C000000, "Publication Rights Reference Sets")
C(0D02011C0D000000, "Publication Region Sets")
C(0D02011C0E000000, "Publication Medium Set")
C(0D02011C0F000000, "Publication Channel Set")
C(0D02011C10000000, "Publication Service Set")
C(0D02011C11000000, "Live Production Flag")
C(0D02011D00000000, "Publication History")
C(0D02011D01000000, "Publication Event Sets")
C(0D02011D02000000, "Publication History Id")
C(0D02011E00000000, "Publication Channel")
C(0D02011E01000000, "Publication Channel Name")
C(0D02011E02000000, "Publication Channel Identifier")
C(0D02011E03000000, "Publication Channel Link To Logo")
C(0D02011E04000000, "Publication Channel Type Set")
C(0D02011F00000000, "Publication Medium")
C(0D02011F01000000, "Publication Channel Name")
C(0D02011F02000000, "Publication Medium Identifier")
C(0D02011F03000000, "Publication Medium Type Set")
C(0D02012000000000, "Publication Service")
C(0D02012001000000, "Publication Service Name")
C(0D02012002000000, "Publication Service Link To Logo")
C(0D02012003000000, "Publication Service Source Set")
C(0D02012004000000, "Publication Service Id")
C(0D02012005000000, "Publication Service Type Group Set")
C(0D02012100000000, "Entity")
C(0D02012101000000, "Entity ID")
C(0D02012102000000, "Entity Contact Sets")
C(0D02012103000000, "Entity Organization Sets")
C(0D02012104000000, "Entity Role Sets")
C(0D02012105000000, "Entity Award Sets")
C(0D02012106000000, "Entity Event Sets")
C(0D02012200000000, "Contact")
C(0D02012201000000, "Contact ID")
C(0D02012202000000, "Family Name")
C(0D02012203000000, "Given Name")
C(0D02012204000000, "Salutation")
C(0D02012205000000, "Suffix")
C(0D02012206000000, "Occupation")
C(0D02012207000000, "Username")
C(0D02012208000000, "Guest Flag")
C(0D02012209000000, "Contact Name Sets")
C(0D0201220A000000, "Contact Type Group Set")
C(0D0201220B000000, "Contact Details Sets")
C(0D0201220C000000, "Contact Related Contact Sets")
C(0D0201220D000000, "Stage Name Sets")
C(0D0201220E000000, "Gender Set")
C(0D0201220F000000, "Contact Related Information Link Sets")
C(0D02012210000000, "Other Given Name")
C(0D02012211000000, "Birth date")
C(0D02012212000000, "Death Date")
C(0D02012213000000, "Birth Place")
C(0D02012214000000, "Nationality")
C(0D02012215000000, "Nickname")
C(0D02012216000000, "Skill")
C(0D02012217000000, "Contact Last Update")
C(0D02012218000000, "Death Place")
C(0D02012219000000, "Affiliation Sets")
C(0D02012300000000, "Organization")
C(0D02012301000000, "Organization ID")
C(0D02012302000000, "Organization Link To Logo")
C(0D02012303000000, "Organization Code Sets")
C(0D02012304000000, "Organization Related Information Link Sets")
C(0D02012305000000, "Organization Name Sets")
C(0D02012306000000, "Organization Department Set")
C(0D02012307000000, "Organization Type Group Set")
C(0D02012308000000, "Organization Details Sets")
C(0D02012309000000, "Organization Related Contact Sets")
C(0D0201230A000000, "Organization Description")
C(0D0201230B000000, "Organization Nationality")
C(0D0201230C000000, "Organization Last Update")
C(0D02012400000000, "Department")
C(0D02012401000000, "Department ID")
C(0D02012402000000, "Department Name")
C(0D02012500000000, "Details")
C(0D02012501000000, "Web Address")
C(0D02012502000000, "Telephone Number")
C(0D02012503000000, "Mobile Telephone Number")
C(0D02012504000000, "Email Address")
C(0D02012505000000, "Details Type Group Set")
C(0D02012506000000, "Address Set")
C(0D02012600000000, "Address")
C(0D02012601000000, "Delivery Code")
C(0D02012602000000, "Town City Sets")
C(0D02012603000000, "County State Sets")
C(0D02012604000000, "Country Name Sets")
C(0D02012605000000, "Address Line Sets")
C(0D02012700000000, "Region")
C(0D02012701000000, "Country Set")
C(0D02012702000000, "Country Region Set")
C(0D02012800000000, "Compound Name")
C(0D02012801000000, "Compound Name Value")
C(0D02012802000000, "Compound Name Type Group Set")
C(0D02012803000000, "Compound Name Format Group Set")
C(0D02012900000000, "Role")
C(0D02012901000000, "Cost Center Reference")
C(0D02012902000000, "Role Type Group Set")
C(0D02012A00000000, "Country Type")
C(0D02012A01000000, "Country Type Group Set")
C(0D02012B00000000, "Relations")
C(0D02012B01000000, "Custom Relation")
C(0D02012B01010000, "Relation By Name")
C(0D02012B01020000, "Relation Link")
C(0D02012B01030000, "Running Order Number")
C(0D02012B01040000, "Total Number Of Group Members")
C(0D02012B01050000, "Ordered Group Flag")
C(0D02012B01060000, "Custom relation Note")
C(0D02012B01070000, "Custom Relation Type Group Set")
C(0D02012B01080000, "Custom Relation Identifier Set")
C(0D02012B02000000, "Basic Relation")
C(0D02012B02010000, "Is Version Of")
C(0D02012B02020000, "Has Version")
C(0D02012B02030000, "Is Replaced By")
C(0D02012B02040000, "Replaces")
C(0D02012B02050000, "Is Required By")
C(0D02012B02060000, "Requires")
C(0D02012B02070000, "Is Part  Of")
C(0D02012B02080000, "Has Part")
C(0D02012B02090000, "Is Referenced By")
C(0D02012B020A0000, "References")
C(0D02012B020B0000, "Is Format  Of")
C(0D02012B020C0000, "Has Format")
C(0D02012B020D0000, "Is Episode Of")
C(0D02012B020E0000, "Is Member Of")
C(0D02012B020F0000, "Has Member")
C(0D02012B02100000, "Has Episode")
C(0D02012B02110000, "Is Season Of")
C(0D02012B02120000, "Has Season")
C(0D02012B02130000, "Is Next In Sequence")
C(0D02012B02140000, "Follows In Sequence")
C(0D02012B02150000, "Is Related To")
C(0D02012B02160000, "Same As")
C(0D02012B02170000, "Has Series")
C(0D02012B02180000, "Is Series Of")
C(0D02012C00000000, "Planning")
C(0D02012C01000000, "Planning Event Objects")
C(0D02012C02000000, "Planning Id")
C(0D02012D00000000, "Attribute groups")
C(0D02012D01000000, "Type Group")
C(0D02012D01010000, "Type Group Thesaurus")
C(0D02012D01020000, "Type Group Label")
C(0D02012D01030000, "Type Group Link")
C(0D02012D01040000, "Type Group UL")
C(0D02012D01050000, "Type Group Definition")
C(0D02012D01060000, "Type Group Language Code")
C(0D02012D01070000, "Type Group Namespace")
C(0D02012D01080000, "Type Group Source")
C(0D02012D02000000, "Format Group")
C(0D02012D02010000, "Format  Group Thesaurus")
C(0D02012D02020000, "Format  Group Label")
C(0D02012D02030000, "Format Group Link")
C(0D02012D02040000, "Format  Group UL")
C(0D02012D02050000, "Format  Group Definition")
C(0D02012D02060000, "Format  Group Language Code")
C(0D02012D02070000, "Format Group Namespace")
C(0D02012D02080000, "Format Group Source")
C(0D02012D03000000, "Status Group")
C(0D02012D03010000, "Status Group Thesaurus")
C(0D02012D03020000, "Status Group Label")
C(0D02012D03030000, "Status Group Link")
C(0D02012D03040000, "Status Group UL")
C(0D02012D03050000, "Status Group Definition")
C(0D02012D03060000, "Status Group Language Code")
C(0D02012D03070000, "Status Group Namespace")
C(0D02012D03080000, "Status Group Source")
C(0D02012E00000000, "Textual Annotation")
C(0D02012E01000000, "Text")
C(0D02012E02000000, "Text Language Code")
C(0D02012F00000000, "Basic Link")
C(0D02012F01000000, "Basic Link Uri")
C(0D02013000000000, "Format")
C(0D02013001000000, "Format ID")
C(0D02013002000000, "Format Version ID")
C(0D02013003000000, "Format Name")
C(0D02013004000000, "Format Definition")
C(0D02013005000000, "Format Year Created")
C(0D02013006000000, "Format Date Created")
C(0D02013007000000, "Format Overall Duration Set")
C(0D02013008000000, "Format Edit Rate Set")
C(0D02013009000000, "Format Container Format  Set")
C(0D0201300A000000, "Format Medium Set")
C(0D0201300B000000, "Format Package Info Set")
C(0D0201300C000000, "Format Audio  Format  Sets")
C(0D0201300D000000, "Format Video  Format  Sets")
C(0D0201300E000000, "Format Image  Format  Sets")
C(0D0201300F000000, "Format Data  Format  Sets")
C(0D02013010000000, "Format Signing  Format  Sets")
C(0D02013011000000, "Format Technical Attribute String Sets")
C(0D02013012000000, "Format Technical Attribute Int8 Sets")
C(0D02013013000000, "Format Technical Attribute Int16 Sets")
C(0D02013014000000, "Format Technical Attribute Int32 Sets")
C(0D02013015000000, "Format Technical Attribute Int64 Sets")
C(0D02013016000000, "Format Technical Attribute UInt8 Sets")
C(0D02013017000000, "Format Technical Attribute UInt16 Sets")
C(0D02013018000000, "Format Technical Attribute UInt32 Sets")
C(0D02013019000000, "Format Technical Attribute UInt64 Sets")
C(0D0201301A000000, "Format Technical Attribute Float Sets")
C(0D0201301B000000, "Format Technical Attribute Rational Sets")
C(0D0201301C000000, "Format Technical Attribute AnyURI Sets")
C(0D0201301D000000, "Format Technical Attribute Boolean Sets")
C(0D0201301E000000, "Format Modified Date")
C(0D0201301F000000, "Format Value Set")
C(0D02013020000000, "Format Type Group Set")
C(0D02013021000000, "Format Audio Format Extended Sets")
C(0D02013022000000, "Format Start Time Sets")
C(0D02013023000000, "Format End Time Sets")
C(0D02013024000000, "Format Duration Sets")
C(0D02013025000000, "Format Metadata Format Sets")
C(0D02013026000000, "Format Duration Sets")
C(0D02013027000000, "Format Medium Sets")
C(0D02013100000000, "Video Format")
C(0D02013101000000, "Video Format ID")
C(0D02013102000000, "Video Format Version ID")
C(0D02013103000000, "Video Format Name")
C(0D02013104000000, "Video Format Definition")
C(0D02013105000000, "Video Bit Rate Set")
C(0D02013106000000, "Video Max Bit Rate Set")
C(0D02013107000000, "Video Bit Rate Mode")
C(0D02013108000000, "Video Scanning Format")
C(0D02013109000000, "Video Scanning Order")
C(0D0201310A000000, "Video Active Lines")
C(0D0201310B000000, "Video Noise Filter Flag")
C(0D0201310C000000, "Video Noise Filter Vendor Id")
C(0D0201310D000000, "Video 3D Flag")
C(0D0201310E000000, "Video Aspect Ratio Sets")
C(0D0201310F000000, "Video Frame Rate Set")
C(0D02013110000000, "Video Height Sets")
C(0D02013111000000, "Video Width Sets")
C(0D02013112000000, "Video Encoding Set")
C(0D02013113000000, "Video Codec Set")
C(0D02013114000000, "Video Track  Sets")
C(0D02013115000000, "Video Presence Flag")
C(0D02013116000000, "Video Region Delim X Set")
C(0D02013117000000, "Video Region Delim Y Set")
C(0D02013118000000, "Video Format Profile")
C(0D02013119000000, "Video Format Profile level")
C(0D0201311A000000, "Video Note")
C(0D0201311B000000, "Video Technical Attribute String Sets")
C(0D0201311C000000, "Video Technical Attribute Int8 Sets")
C(0D0201311D000000, "Video Technical Attribute Int16 Sets")
C(0D0201311E000000, "Video Technical Attribute Int32 Sets")
C(0D0201311F000000, "Video Technical Attribute Int64 Sets")
C(0D02013120000000, "Video Technical Attribute UInt8 Sets")
C(0D02013121000000, "Video Technical Attribute UInt16 Sets")
C(0D02013122000000, "Video Technical Attribute UInt32 Sets")
C(0D02013123000000, "Video Technical Attribute UInt64 Sets")
C(0D02013124000000, "Video Technical Attribute Float Sets")
C(0D02013125000000, "Video Technical Attribute Rational Sets")
C(0D02013126000000, "Video Technical Attribute AnyURI Sets")
C(0D02013127000000, "Video Technical Attribute Boolean Sets")
C(0D02013128000000, "Video Filter Sets")
C(0D02013200000000, "Image Format")
C(0D02013201000000, "Image Format ID")
C(0D02013202000000, "Image Format Version ID")
C(0D02013203000000, "Image Format Name")
C(0D02013204000000, "Image Format Definition")
C(0D02013205000000, "Image Orientation")
C(0D02013206000000, "Image Aspect Ratio Set")
C(0D02013207000000, "Image Encoding Set")
C(0D02013208000000, "Image Codec Set")
C(0D02013209000000, "Image Height Set")
C(0D0201320A000000, "Image Width Set")
C(0D0201320B000000, "Image Presence Flag")
C(0D0201320C000000, "Image Region Delim X Set")
C(0D0201320D000000, "Image region Delim Y Set")
C(0D0201320E000000, "Image Format Profile")
C(0D0201320F000000, "Image Format Profile Level")
C(0D02013210000000, "Image Note")
C(0D02013211000000, "Image Technical Attribute String Sets")
C(0D02013212000000, "Image Technical Attribute Int8 Sets")
C(0D02013213000000, "Image Technical Attribute Int16 Sets")
C(0D02013214000000, "Image Technical Attribute Int32 Sets")
C(0D02013215000000, "Image Technical Attribute Int64 Sets")
C(0D02013216000000, "Image Technical Attribute UInt8 Sets")
C(0D02013217000000, "Image Technical Attribute UInt16 Sets")
C(0D02013218000000, "Image Technical Attribute UInt32 Sets")
C(0D02013219000000, "Image Technical Attribute UInt64 Sets")
C(0D0201321A000000, "Image Technical Attribute Float Sets")
C(0D0201321B000000, "Image Technical Attribute Rational Sets")
C(0D0201321C000000, "Image Technical Attribute AnyURI Sets")
C(0D0201321D000000, "Image Technical Attribute Boolean Sets")
C(0D02013300000000, "Audio Format")
C(0D02013301000000, "Audio Format ID")
C(0D02013302000000, "Audio Format Version ID")
C(0D02013303000000, "Audio Format Name")
C(0D02013304000000, "Audio Format Definition")
C(0D02013305000000, "Audio Track  Configuration")
C(0D02013306000000, "Audio Sampling Size")
C(0D02013307000000, "Audio Sampling Type")
C(0D02013308000000, "Audio Total Number Of Channels")
C(0D02013309000000, "Audio Bit Rate Set")
C(0D0201330A000000, "Audio Max Bit Rate Set")
C(0D0201330B000000, "Audio Bit Rate Mode")
C(0D0201330C000000, "Audio Sampling Rate Set")
C(0D0201330D000000, "Audio Encoding Set")
C(0D0201330E000000, "Audio Codec Set")
C(0D0201330F000000, "Audio Track  Sets")
C(0D02013310000000, "Audio Presence Flag")
C(0D02013311000000, "Audio Format Profile")
C(0D02013312000000, "Audio Format Profile Level")
C(0D02013313000000, "Audio Note")
C(0D02013314000000, "Audio Technical Attribute String Sets")
C(0D02013315000000, "Audio Technical Attribute Int8 Sets")
C(0D02013316000000, "Audio Technical Attribute Int16 Sets")
C(0D02013317000000, "Audio Technical Attribute Int32 Sets")
C(0D02013318000000, "Audio Technical Attribute Int64 Sets")
C(0D02013319000000, "Audio Technical Attribute UInt8 Sets")
C(0D0201331A000000, "Audio Technical Attribute UInt16 Sets")
C(0D0201331B000000, "Audio Technical Attribute UInt32 Sets")
C(0D0201331C000000, "Audio Technical Attribute UInt64 Sets")
C(0D0201331D000000, "Audio Technical Attribute Float Sets")
C(0D0201331E000000, "Audio Technical Attribute Rational Sets")
C(0D0201331F000000, "Audio Technical Attribute AnyURI Sets")
C(0D02013320000000, "Audio Technical Attribute Boolean Sets")
C(0D02013321000000, "Audio Description Presence Flag")
C(0D02013322000000, "Audio Filter Sets")
C(0D02013400000000, "Track")
C(0D02013401000000, "Track ID")
C(0D02013402000000, "Track Name")
C(0D02013403000000, "Track Language Code")
C(0D02013404000000, "Track Type Group Set")
C(0D02013500000000, "Data Format")
C(0D02013501000000, "Data Format ID")
C(0D02013502000000, "Data Format Version ID")
C(0D02013503000000, "Data Format Name")
C(0D02013504000000, "Data Format Definition")
C(0D02013505000000, "Data Track ID")
C(0D02013506000000, "Data Track Name")
C(0D02013507000000, "Data Track Language Code")
C(0D02013508000000, "Data Presence Flag")
C(0D02013509000000, "Captioning  Sets")
C(0D0201350A000000, "Subtitling  Sets")
C(0D0201350B000000, "Ancillary Data  Sets")
C(0D0201350C000000, "Data Codec Object")
C(0D0201350D000000, "Data Format Profile")
C(0D0201350E000000, "Data Format Profile Level")
C(0D0201350F000000, "Data Note")
C(0D02013510000000, "Data Technical Attribute String Sets")
C(0D02013511000000, "Data Technical Attribute Int8 Sets")
C(0D02013512000000, "Data Technical Attribute Int16 Sets")
C(0D02013513000000, "Data Technical Attribute Int32 Sets")
C(0D02013514000000, "Data Technical Attribute Int64 Sets")
C(0D02013515000000, "Data Technical Attribute UInt8 Sets")
C(0D02013516000000, "Data Technical Attribute UInt16 Sets")
C(0D02013517000000, "Data Technical Attribute UInt32 Sets")
C(0D02013518000000, "Data Technical Attribute UInt64 Sets")
C(0D02013519000000, "Data Technical Attribute Float Sets")
C(0D0201351A000000, "Data Technical Attribute Rational Sets")
C(0D0201351B000000, "Data Technical Attribute AnyURI Sets")
C(0D0201351C000000, "Data Technical Attribute Boolean Sets")
C(0D02013600000000, "Captioning")
C(0D02013601000000, "Captioning Format ID")
C(0D02013602000000, "Captioning Format Name")
C(0D02013603000000, "Captioning Source Uri")
C(0D02013604000000, "Captioning Track ID")
C(0D02013605000000, "Captioning Track Name")
C(0D02013606000000, "Captioning Language Code")
C(0D02013607000000, "Closed Captioning Flag")
C(0D02013608000000, "Captioning Type Group Set")
C(0D02013609000000, "Captioning Format Group Set")
C(0D0201360A000000, "Captioning Presence Flag")
C(0D0201360B000000, "Captioning Format Profile")
C(0D02013700000000, "Subtitling")
C(0D02013701000000, "Subtitling Format ID")
C(0D02013702000000, "Subtitling Format Name")
C(0D02013703000000, "Subtitling Source Uri")
C(0D02013704000000, "Subtitling Track ID")
C(0D02013705000000, "Subtitling Track Name")
C(0D02013706000000, "Subtitling Language Code")
C(0D02013707000000, "Closed Subtitling Flag")
C(0D02013708000000, "Subtitling Type Group Set")
C(0D02013709000000, "Subtitling Format Group Set")
C(0D0201370A000000, "Subtitling Presence Flag")
C(0D0201370B000000, "Subtitling Format Profile")
C(0D02013800000000, "Ancillary Data")
C(0D02013801000000, "Ancillary Data Format Id")
C(0D02013802000000, "Ancillary Data Format Name")
C(0D02013803000000, "DID")
C(0D02013804000000, "SDID")
C(0D02013805000000, "Line Number")
C(0D02013806000000, "ANC Wrapping Type Set")
C(0D02013807000000, "Ancillary Data Format Profile")
C(0D02013900000000, "Signing  Format")
C(0D02013901000000, "Signing Format ID")
C(0D02013902000000, "Signing Format Version ID")
C(0D02013903000000, "Signing Format Name")
C(0D02013904000000, "Signing Track ID")
C(0D02013905000000, "Signing Track Name")
C(0D02013906000000, "Signing Track Language Code")
C(0D02013907000000, "Signing Source Uri")
C(0D02013908000000, "Signing Type Group Set")
C(0D02013909000000, "Signing Format Group Set")
C(0D0201390A000000, "Signing Presence Flag")
C(0D02013A00000000, "Technical Basic Attributes")
C(0D02013A01000000, "Technical Attribute String")
C(0D02013A01010000, "Technical Attribute StringValue")
C(0D02013A01020000, "Technical Attribute String Type Group Set")
C(0D02013A01030000, "Technical Attribute String Format Group Set")
C(0D02013A02000000, "Technical Attribute Int8")
C(0D02013A02010000, "Technical Attribute Int8Value")
C(0D02013A02020000, "Technical Attribute Int8 Type Group Set")
C(0D02013A02030000, "Technical Attribute Int8 Unit")
C(0D02013A03000000, "Technical Attribute Int16")
C(0D02013A03010000, "Technical Attribute Int16Value")
C(0D02013A03020000, "Technical Attribute Int16 Type Group Set")
C(0D02013A03030000, "Technical Attribute Int16 Unit")
C(0D02013A04000000, "Technical Attribute Int32")
C(0D02013A04010000, "Technical Attribute Int32Value")
C(0D02013A04020000, "Technical Attribute Int32 Type Group Set")
C(0D02013A04030000, "Technical Attribute Int32 Unit")
C(0D02013A05000000, "Technical Attribute Int64")
C(0D02013A05010000, "Technical Attribute Int64Value")
C(0D02013A05020000, "Technical Attribute Int64 Type Group Set")
C(0D02013A05030000, "Technical Attribute Int64 Unit")
C(0D02013A06000000, "Technical Attribute UInt8")
C(0D02013A06010000, "Technical Attribute UInt8Value")
C(0D02013A06020000, "Technical Attribute UInt8 Type Group Set")
C(0D02013A06030000, "Technical Attribute UInt8 Unit")
C(0D02013A07000000, "Technical Attribute UInt16")
C(0D02013A07010000, "Technical Attribute UInt16Value")
C(0D02013A07020000, "Technical Attribute UInt16 Type Group Set")
C(0D02013A07030000, "Technical Attribute UInt16 Unit")
C(0D02013A08000000, "Technical Attribute UInt32")
C(0D02013A08010000, "Technical Attribute UInt32Value")
C(0D02013A08020000, "Technical Attribute UInt32 Type Group Set")
C(0D02013A08030000, "Technical Attribute UInt32 Unit")
C(0D02013A09000000, "Technical Attribute UInt64")
C(0D02013A09010000, "Technical Attribute UInt64Value")
C(0D02013A09020000, "Technical Attribute UInt64 Type Group Set")
C(0D02013A09030000, "Technical Attribute UInt64 Unit")
C(0D02013A0A000000, "Technical Attribute Float")
C(0D02013A0A010000, "Technical Attribute FloatValue")
C(0D02013A0A020000, "Technical Attribute Float Type Group Set")
C(0D02013A0A030000, "Technical Attribute Float Unit")
C(0D02013A0B000000, "Technical Attribute Rational")
C(0D02013A0B010000, "Technical Attribute Rational Type Group Set")
C(0D02013A0B020000, "Technical Attribute Rational Value")
C(0D02013A0C000000, "Technical Attribute AnyURI")
C(0D02013A0C010000, "Technical Attribute AnyURIValue")
C(0D02013A0C020000, "Technical Attribute AnyURI Type Group Set")
C(0D02013A0D000000, "Technical Attribute Boolean")
C(0D02013A0D010000, "Technical Attribute BooleanValue")
C(0D02013A0D020000, "Technical Attribute Boolean Type Group Set")
C(0D02013B00000000, "Dimension")
C(0D02013B01000000, "Dimension Value")
C(0D02013B02000000, "Dimension Unit")
C(0D02013C00000000, "Package Info")
C(0D02013C01000000, "Package Size")
C(0D02013C02000000, "Package Name")
C(0D02013C03000000, "Package Locator")
C(0D02013C04000000, "Mime Type Set")
C(0D02013C05000000, "Hash Set")
C(0D02013C06000000, "Package Overall Bitrate Set")
C(0D02013D00000000, "Medium")
C(0D02013D01000000, "MediumIID")
C(0D02013D02000000, "Medium Type Group Set")
C(0D02013E00000000, "Codec")
C(0D02013E01000000, "Codec Name")
C(0D02013E02000000, "Codec Vendor")
C(0D02013E03000000, "Codec Version")
C(0D02013E04000000, "Codec Family")
C(0D02013E05000000, "Codec Identifier")
C(0D02013E06000000, "Codec URL")
C(0D02013E07000000, "Codec Type Group Set")
C(0D02013F00000000, "Rational")
C(0D02013F01000000, "Nominal Value")
C(0D02013F02000000, "Factor Numerator")
C(0D02013F03000000, "Factor Denominator")
C(0D02014000000000, "Aspect Ratio")
C(0D02014001000000, "Aspect Ratio Factor Numerator")
C(0D02014002000000, "Aspect Ratio Factor Denominator")
C(0D02014003000000, "Aspect Ratio Type Group Set")
C(0D02014100000000, "Height")
C(0D02014101000000, "Height Value Set")
C(0D02014102000000, "Height Type Group Set")
C(0D02014200000000, "Width")
C(0D02014201000000, "Width Value Set")
C(0D02014202000000, "Width Type Group Set")
C(0D02014300000000, "Part")
C(0D02014301000000, "Part  Metadata  Set")
C(0D02014400000000, "Part Metadata")
C(0D02014401000000, "Part ID")
C(0D02014402000000, "Part Name")
C(0D02014403000000, "Part Definition")
C(0D02014404000000, "Part Start Time Object")
C(0D02014405000000, "Part Duration Object")
C(0D02014406000000, "Part Number")
C(0D02014407000000, "Part Total Number")
C(0D02014408000000, "Part Type Group Set")
C(0D02014409000000, "Part Meta Set")
C(0D02014500000000, "EBUCore Set")
C(0D02014600000000, "Hash")
C(0D02014601000000, "Hash Value Set")
C(0D02014602000000, "Hash Function Type Group Set")
C(0D02014700000000, "Locator")
C(0D02014701000000, "Locator Value Set")
C(0D02014702000000, "Locator Type Group Set")
C(0D02014800000000, "Container Format")
C(0D02014801000000, "Container Format Id")
C(0D02014802000000, "Container Format Name")
C(0D02014803000000, "Container Codec Set")
C(0D02014804000000, "Container Format Version Id")
C(0D02014805000000, "Container Format Profile")
C(0D02014806000000, "Container Format Profile Level")
C(0D02014807000000, "Container Note")
C(0D02014808000000, "Container Technical Attribute String Sets")
C(0D02014809000000, "Container Technical Attribute Int8 Sets")
C(0D0201480A000000, "Container Technical Attribute Int16 Sets")
C(0D0201480B000000, "Container Technical Attribute Int32 Sets")
C(0D0201480C000000, "Container Technical Attribute Int64 Sets")
C(0D0201480D000000, "Container Technical Attribute UInt8 Sets")
C(0D0201480E000000, "Container Technical Attribute UInt16 Sets")
C(0D0201480F000000, "Container Technical Attribute UInt32 Sets")
C(0D02014810000000, "Container Technical Attribute UInt64 Sets")
C(0D02014811000000, "Container Technical Attribute Float Sets")
C(0D02014812000000, "Container Technical Attribute Rational Sets")
C(0D02014813000000, "Container Technical Attribute AnyURI Sets")
C(0D02014814000000, "Container Technical Attribute Boolean Sets")
C(0D02014815000000, "Container Encoding Format Group Set")
C(0D02014900000000, "Audio Format Extended")
C(0D02014901000000, "Audio Format Extended Id")
C(0D02014902000000, "Audio Format Extended Name")
C(0D02014903000000, "Audio Format Extended Definition")
C(0D02014904000000, "Audio Format Extended Version")
C(0D02014905000000, "Audio Format Extended Presence Flag")
C(0D02014906000000, "Audio Programme Sets")
C(0D02014907000000, "Audio Content Sets")
C(0D02014908000000, "Audio Object Sets")
C(0D02014909000000, "Audio Pack Format Sets")
C(0D0201490A000000, "Audio Channel Format Sets")
C(0D0201490B000000, "Audio Block Format Sets")
C(0D0201490C000000, "Audio Stream Format Sets")
C(0D0201490D000000, "Audio Track Format Sets")
C(0D0201490E000000, "Audio Track UID Sets")
C(0D02014A00000000, "Audio Programme")
C(0D02014A01000000, "Audio Programme Id")
C(0D02014A02000000, "Audio Programme Name")
C(0D02014A03000000, "Audio Programme Language Code")
C(0D02014A04000000, "Audio Programme Start Timecode")
C(0D02014A05000000, "Audio Programme End Timecode")
C(0D02014A06000000, "Audio Programme Type Group Set")
C(0D02014A07000000, "Audio Programme Format Group Set")
C(0D02014A08000000, "Audio Programme Audio Content IDRef Sets")
C(0D02014A09000000, "Audio Programme Loudness Metadata Set")
C(0D02014A0A000000, "Audio Programme Max Ducking Depth")
C(0D02014A0B000000, "Audio Programme Reference Screen Set")
C(0D02014B00000000, "IDRef")
C(0D02014B01000000, "IDRef Value")
C(0D02014C00000000, "Loudness Metadata")
C(0D02014C01000000, "Loudness Method")
C(0D02014C02000000, "Integrated Loudness")
C(0D02014C03000000, "Loudness Range")
C(0D02014C04000000, "Loudness Max True Peak")
C(0D02014C05000000, "Loudness Max Momentary")
C(0D02014C06000000, "Loudness Max Short Term")
C(0D02014C07000000, "Loudness Recommendation Type")
C(0D02014C08000000, "Loudness Correction Type")
C(0D02014C09000000, "Dialogue Loudness")
C(0D02014D00000000, "Audio Content")
C(0D02014D01000000, "Audio Content Id")
C(0D02014D02000000, "Audio Content Name")
C(0D02014D03000000, "Audio Content Language Code")
C(0D02014D04000000, "Audio Content Dialogue Indicator")
C(0D02014D05000000, "Audio Content Audio Object IDRef Sets")
C(0D02014D06000000, "Audio Content Loudness Metadata Set")
C(0D02014D07000000, "Audio Content Dialogue Set")
C(0D02014E00000000, "Audio Object")
C(0D02014E01000000, "Audio Object Id")
C(0D02014E02000000, "Audio Object Name")
C(0D02014E03000000, "Audio Object Start Timecode")
C(0D02014E04000000, "Audio Object Duration Timecode")
C(0D02014E05000000, "Audio Object Dialogue Indicator")
C(0D02014E06000000, "Audio Object Importance")
C(0D02014E07000000, "Audio Object Interact")
C(0D02014E08000000, "Audio Object Audio Pack Format IDRef Sets")
C(0D02014E09000000, "Audio Object Audio Object IDRef Sets")
C(0D02014E0A000000, "Audio Object Audio Track UIDRef Sets")
C(0D02014E0B000000, "Audio Object Interaction Sets")
C(0D02014E0C000000, "Audio Complementary Object IDREF Sets")
C(0D02014E0D000000, "Audio Object Disable Ducking")
C(0D02014F00000000, "Audio Pack Format")
C(0D02014F01000000, "Audio Pack Format Id")
C(0D02014F02000000, "Audio Pack Format Name")
C(0D02014F03000000, "Audio Pack Absolute Distance")
C(0D02014F04000000, "Audio Pack Type Group Set")
C(0D02014F05000000, "Audio Pack Importance")
C(0D02014F06000000, "Audio Pack Audio Channel Format IDRef Sets")
C(0D02014F07000000, "Audio Pack Audio Pack Format IDRef Sets")
C(0D02015000000000, "Audio Channel Format")
C(0D02015001000000, "Audio Channel Format Id")
C(0D02015002000000, "Audio Channel Format Name")
C(0D02015003000000, "Audio Channel Type Group Set")
C(0D02015004000000, "Audio Channel Frequency")
C(0D02015005000000, "Audio Channel Audio Block Format IDRef Sets")
C(0D02015100000000, "Audio Block Format")
C(0D02015101000000, "Audio Block Format Id")
C(0D02015102000000, "Audio Block RTimecode")
C(0D02015103000000, "Audio Block Duration Timecode")
C(0D02015104000000, "Audio Block Speaker Label")
C(0D02015105000000, "Audio Block Position")
C(0D02015106000000, "Audio Block Matrix Set")
C(0D02015107000000, "Audio Block Gain")
C(0D02015108000000, "Audio Block Diffuse")
C(0D02015109000000, "Audio Block Width")
C(0D0201510A000000, "Audio Block Height")
C(0D0201510B000000, "Audio Block Depth")
C(0D0201510C000000, "Audio Block Channel Lock")
C(0D0201510D000000, "Audio Block Jump Position")
C(0D0201510E000000, "Audio Block Equation")
C(0D0201510F000000, "Audio Block Degree")
C(0D02015110000000, "Audio Block Order")
C(0D02015111000000, "Audio Block Cartesian")
C(0D02015112000000, "Audio Block Object Divergence Set")
C(0D02015113000000, "Audio Block Zone Exclusion Set")
C(0D02015114000000, "Audio Block Screen reference Flag")
C(0D02015115000000, "Audio Block Importance")
C(0D02015116000000, "Audio Block Position Sets")
C(0D02015117000000, "Audio Blcok Jump Position Set")
C(0D02015200000000, "Audio Block Matrix Coefficient")
C(0D02015201000000, "Audio Block Matrix Coefficient Value")
C(0D02015202000000, "Audio Block Matrix Coefficient Gain")
C(0D02015203000000, "Audio Block Matrix Coefficient Gain Var")
C(0D02015204000000, "Audio Block Matrix Coefficient Phase")
C(0D02015205000000, "Audio Block Matrix Coefficient Phase Var")
C(0D02015206000000, "Audio Block Matrix Coefficient Channel Format IDRef Set")
C(0D02015300000000, "Audio Stream Format")
C(0D02015301000000, "Audio Stream Format Id")
C(0D02015302000000, "Audio Stream Format Name")
C(0D02015303000000, "Audio Stream Format Group Set")
C(0D02015304000000, "Audio Stream Audio Channel Format IDRef Sets")
C(0D02015305000000, "Audio Stream Format IDRef Sets")
C(0D02015306000000, "Audio Stream Audio Track Format IDRef Sets")
C(0D02015400000000, "Audio Track Format")
C(0D02015401000000, "Audio Track Format Id")
C(0D02015402000000, "Audio Track Format Name")
C(0D02015403000000, "Audio Track Format Format Group Set")
C(0D02015404000000, "Audio Track Audio Stream Format IDRef Sets")
C(0D02015500000000, "Audio Track UID")
C(0D02015501000000, "Audio Track UID Value")
C(0D02015502000000, "Audio Track UID Sample Rate")
C(0D02015503000000, "Audio Track UID Bit Depth")
C(0D02015504000000, "Audio Track MXF Lookup Set")
C(0D02015505000000, "Audio Track Audio Track Format IDRef Sets")
C(0D02015506000000, "Audio Track Audio Pack Format IDRef Sets")
C(0D02015600000000, "Audio MXF Lookup")
C(0D02015601000000, "Audio MXF Lookup Package UIDRef Set")
C(0D02015602000000, "Audio MXF LookupTrack IDRef Set")
C(0D02015603000000, "Audio MXF Lookup Channel IDRef Set")
C(0D02015700000000, "Audio Block Matrix")
C(0D02015701000000, "Audio Block Matrix Coefficient Sets")
C(0D02015800000000, "Time")
C(0D02015801000000, "Timecode")
C(0D02015802000000, "Normal Play Time")
C(0D02015803000000, "Edit Unit")
C(0D02015804000000, "Text Time")
C(0D02015805000000, "Time Type Group Set")
C(0D02015900000000, "Metadata Format")
C(0D02015901000000, "Metadata Format Id")
C(0D02015902000000, "Metadata Format Name")
C(0D02015903000000, "Metadata Format Version Id")
C(0D02015904000000, "Metadata Format Definition")
C(0D02015905000000, "Metadata Track Sets")
C(0D02015906000000, "Metadata Technical Attribute String Sets")
C(0D02015907000000, "Metadata Technical Attribute Int8 Sets")
C(0D02015908000000, "Metadata Technical Attribute Int16 Sets")
C(0D02015909000000, "Metadata Technical Attribute Int32 Sets")
C(0D0201590A000000, "Metadata Technical Attribute Int64 Sets")
C(0D0201590B000000, "Metadata Technical Attribute UInt8 Sets")
C(0D0201590C000000, "Metadata Technical Attribute UInt16 Sets")
C(0D0201590D000000, "Metadata Technical Attribute UInt32 Sets")
C(0D0201590E000000, "Metadata Technical Attribute UInt64 Sets")
C(0D0201590F000000, "Metadata Technical Attribute Float Sets")
C(0D02015910000000, "Metadata Technical Attribute Rational Sets")
C(0D02015911000000, "Metadata Technical Attribute AnyURI Sets")
C(0D02015912000000, "Metadata Technical Attribute Boolean Sets")
C(0D02015A00000000, "Timecode Format")
C(0D02015A01000000, "Timecode Format Id")
C(0D02015A02000000, "Timecode Format Name")
C(0D02015A03000000, "Timecode Format Version Id")
C(0D02015A04000000, "Timecode Format Definition")
C(0D02015A05000000, "Timecode Start Time Set")
C(0D02015A06000000, "Timecode Track Sets")
C(0D02015A07000000, "Timecode Technical Attribute String Sets")
C(0D02015A08000000, "Timecode Technical Attribute Int8 Sets")
C(0D02015A09000000, "Timecode Technical Attribute Int16 Sets")
C(0D02015A0A000000, "Timecode Technical Attribute Int32 Sets")
C(0D02015A0B000000, "Timecode Technical Attribute Int64 Sets")
C(0D02015A0C000000, "Timecode Technical Attribute UInt8 Sets")
C(0D02015A0D000000, "Timecode Technical Attribute UInt16 Sets")
C(0D02015A0E000000, "Timecode Technical Attribute UInt32 Sets")
C(0D02015A0F000000, "Timecode Technical Attribute UInt64 Sets")
C(0D02015A10000000, "Timecode Technical Attribute Float Sets")
C(0D02015A11000000, "Timecode Technical Attribute Rational Sets")
C(0D02015A12000000, "Timecode Technical Attribute AnyURI Sets")
C(0D02015A13000000, "Timecode Technical Attribute Boolean Sets")
C(0D02015B00000000, "Video Noise Filter")
C(0D02015B01000000, "Video Noise Filter Vendor Id")
C(0D02015B02000000, "Video Noise Filter Type Group Set")
C(0D02015D00000000, "Audience")
C(0D02015D01000000, "Audience Reason")
C(0D02015D02000000, "Audience Link To Logo")
C(0D02015D03000000, "Audience Not rated Flag")
C(0D02015D04000000, "Audience Adult Content Flag")
C(0D02015D05000000, "Audience Type Group Set")
C(0D02015D06000000, "Audience Region Sets")
C(0D02015D07000000, "Audience Exclusion Region Sets")
C(0D02015D08000000, "Audience Format group Set")
C(0D02015E00000000, "Filter")
C(0D02015E01000000, "Filter Order")
C(0D02015E02000000, "Filter Type Group Set")
C(0D02015E03000000, "Filter Track IDRef Sets")
C(0D02015E04000000, "Filter Profile Type Group Set")
C(0D02015E05000000, "Filter Setting Sets")
C(0D02015F00000000, "Filter Setting")
C(0D02015F01000000, "Filter Setting Attribute Order")
C(0D02015F02000000, "Filter Setting Type group Set")
C(0D02015F03000000, "Filter Setting Technical String Sets")
C(0D02015F04000000, "Filter Setting Technical Byte Sets")
C(0D02015F05000000, "Filter Setting Technical Short Sets")
C(0D02015F06000000, "Filter Setting Technical Integer Sets")
C(0D02015F07000000, "Filter Setting Technical Long Sets")
C(0D02015F08000000, "Filter Setting Technical Unsigned Byte Sets")
C(0D02015F09000000, "Filter Setting Technical Unsigned Short Sets")
C(0D02015F0A000000, "Filter Setting Technical Unsigned Integer Sets")
C(0D02015F0B000000, "Filter Setting Technical Unsigned Long Sets")
C(0D02015F0C000000, "Filter Setting Technical Float Sets")
C(0D02015F0D000000, "Filter Setting Technical Rational Sets")
C(0D02015F0E000000, "Filter Setting Technical anyURI Sets")
C(0D02015F0F000000, "Filter Setting Technical Boolean Sets")
C(0D02016000000000, "Reference Screen")
C(0D02016001000000, "Reference Screen Aspect Ratio")
C(0D02016002000000, "Reference Screen Reference Centre Set")
C(0D02016003000000, "Reference Screen Wiidth Set")
C(0D02016100000000, "Reference Screen Centre Position")
C(0D02016101000000, "Reference Screen Centre Position Value")
C(0D02016102000000, "Reference Screen Azimuth")
C(0D02016103000000, "Reference Screen Elevation")
C(0D02016104000000, "Reference Screen Distance")
C(0D02016105000000, "Reference Screen X")
C(0D02016106000000, "Reference Screen Y")
C(0D02016107000000, "Reference Screen Z")
C(0D02016200000000, "Reference Screen Width")
C(0D02016201000000, "Reference Screen Width Value")
C(0D02016202000000, "Reference Screen Width Azimuth")
C(0D02016203000000, "Reference Screen Width X")
C(0D02016300000000, "Audio Content Dialogue")
C(0D02016301000000, "Audio Content Dialogue Value")
C(0D02016302000000, "Non Dialogue Content Kind")
C(0D02016303000000, "Dialogue Content Kind")
C(0D02016304000000, "Mixed Content Kind")
C(0D02016400000000, "Audio Object Interaction")
C(0D02016401000000, "On Off Interact")
C(0D02016402000000, "Gain Interact")
C(0D02016403000000, "Position Interact")
C(0D02016404000000, "Gain Interact Range Sets")
C(0D02016405000000, "Position Interaction Range Sets")
C(0D02016500000000, "Gain Interaction Range")
C(0D02016501000000, "Gain Interaction Range Value")
C(0D02016502000000, "Gain Interaction Range Bound")
C(0D02016600000000, "Position Interaction Range")
C(0D02016601000000, "Position Interaction Range Value")
C(0D02016602000000, "Position Interaction Range Coordinate")
C(0D02016603000000, "Position Interaction Range Bound")
C(0D02016700000000, "Audio Block Position")
C(0D02016701000000, "Audio Block Position Value")
C(0D02016702000000, "Audio Block Position Coordinate")
C(0D02016703000000, "Audio Block Position Bound")
C(0D02016704000000, "Audio Block Position Edge Lock")
C(0D02016800000000, "Audio Block Divergence")
C(0D02016801000000, "Audio Block Divergence Value")
C(0D02016802000000, "Audio Block Divergence Azimuth Range")
C(0D02016900000000, "Audio Block Zone Exclusion")
C(0D02016901000000, "Audio Block Zone Sets")
C(0D02016A00000000, "Audio Block Zone")
C(0D02016A01000000, "Audio Block Zone Value")
C(0D02016A02000000, "Audio Block Zone Min X")
C(0D02016A03000000, "Audio Block Zone Max X")
C(0D02016A04000000, "Audio Block Zone Min Y")
C(0D02016A05000000, "Audio Block Zone Max Y")
C(0D02016A06000000, "Audio Block Zone Min Z")
C(0D02016A07000000, "Audio Block Zone Max Z")
C(0D02016B00000000, "Audio Block Jump Position")
C(0D02016B01000000, "Audio Block Jump Position Flag")
C(0D02016B02000000, "Audio Block Jump Position Interpolation Length")
C(0D02016C00000000, "Event")
C(0D02016C01000000, "Event ID")
C(0D02016C02000000, "Event Type Group Set")
C(0D02016C03000000, "Event Note")
C(0D02016C04000000, "Event Name Sets")
C(0D02016C05000000, "Event Description Sets")
C(0D02016C06000000, "Event Location Sets")
C(0D02016C07000000, "Event Start")
C(0D02016C08000000, "Event End")
C(0D02016D00000000, "Award")
C(0D02016D01000000, "Award ID")
C(0D02016D02000000, "Award Name Sets")
C(0D02016D03000000, "Award Description Sets")
C(0D02016D04000000, "Award Category Sets")
C(0D02016D05000000, "Award Ceremony Sets")
C(0D02016D06000000, "Award Official Sets")
C(0D02016D07000000, "Award Date Sets")
C(0D02016E00000000, "Affiliation")
C(0D02016E01000000, "Affiliation Organization Set")
C(0D02016E02000000, "Affiliation Period Of Time Set")
C(0D03000000000000, "Pro-MPEG Forum")
C(0D04000000000000, "BBC")
C(0D04010000000000, "Archive Preservation Project")
C(0D04010100000000, "Archive Preservation Project Version 1")
C(0D04010101000000, "APP Descriptive Frameworks")
C(0D04010101010000, "APP Infax Framework")
C(0D04010101010100, "APP Format")
C(0D04010101010200, "APP Programme Title")
C(0D04010101010300, "APP Episode Title")
C(0D04010101010400, "APP Transmission Date")
C(0D04010101010500, "APP Magazine Prefix")
C(0D04010101010600, "APP Programme  Number")
C(0D04010101010700, "APP Spool Status")
C(0D04010101010800, "APP Stock Date")
C(0D04010101010900, "APP Spool Descriptor")
C(0D04010101010A00, "APP Memo")
C(0D04010101010B00, "APP Duration")
C(0D04010101010C00, "APP Spool Number")
C(0D04010101010D00, "APP Accession Number")
C(0D04010101010E00, "APP Catalogue Detail")
C(0D04010101010F00, "APP Production Code")
C(0D04010101011000, "APP Item Number")
C(0D04010101020000, "APP PSE Analysis Framework")
C(0D04010101020100, "APP Red Flash")
C(0D04010101020200, "APP Spatial Pattern")
C(0D04010101020300, "APP Luminance Flash")
C(0D04010101020400, "APP Extended Failure")
C(0D04010101030000, "APP VTR Replay Error Framework")
C(0D04010101030100, "APP VTR Error Code")
C(0D04010101040000, "APP DigiBeta Dropout Framework")
C(0D04010101040100, "APP Strength")
C(0D04010101050000, "APP Timecode Break Framework")
C(0D04010101050100, "APP Timecode Type")
C(0D04010140000000, "APP Preface Additions")
C(0D04010140010000, "APP Preface Additions Version 1")
C(0D04010140010100, "APP VTR Error Count")
C(0D04010140010200, "APP PSE Failure Count")
C(0D04010140010300, "APP DigiBeta Dropout Count")
C(0D04010140010400, "APP Timecode Break Count")
C(0D05000000000000, "IRT")
C(0D06000000000000, "ARIB")
C(0D07000000000000, "AMIA")
C(0D08000000000000, "PBS")
C(0D09000000000000, "ASC")
C(0D0A000000000000, "AES")
C(0D0B000000000000, "Dutch Guild")
C(0D0B010000000000, "Production Framework")
C(0D0B010100000000, "Is Recording")
C(0D0B010200000000, "Is Live Production")
C(0D0B010300000000, "Is Live Transmission")
C(0D0B010400000000, "Is Dubbed")
C(0D0B010500000000, "Is Voiceover")
C(0D0B010600000000, "Has Audio Watermark")
C(0D0B010700000000, "Audio Watermark Kind")
C(0D0B010800000000, "Has Video Watermark")
C(0D0B010900000000, "Video Watermark Kind")
C(0D0B020000000000, "Subtitling")
C(0D0B020100000000, "Subtitles Present")
C(0D0B030000000000, "Caption Titles")
C(0D0B030100000000, "Caption Titles")
C(0D0B030200000000, "Captions Via Teletext")
C(0D0B030300000000, "Textless Material")
C(0D0B040000000000, "Audio Parameters")
C(0D0B040100000000, "Audio Reference Level")
C(0D0B050000000000, "Storage Media")
C(0D0B050100000000, "Storage Device Kind")
C(0D0B050200000000, "Storage Media Kind")
C(0D0B050300000000, "Storage Media ID")
C(0D0B060000000000, "Broadcast Schedule Information")
C(0D0B060100000000, "Broadcast Date")
C(0D0B060200000000, "Broadcast Time")
C(0D0B060300000000, "Is Repeat")
C(0D0B060400000000, "First Transmission Date-Time, Channel, and Broadcaster")
C(0D0B060500000000, "Teletext Subtitles Available")
C(0D0B060600000000, "Season Episode Number")
C(0D0B060700000000, "Season Episode Title")
C(0D0B060800000000, "EPG Program Synopsis")
C(0D0B070000000000, "Classification")
C(0D0B070100000000, "Content Classification")
C(0D0B070200000000, "DVB Parental Rating")
C(0D0B070300000000, "Content Maturity Rating")
C(0D0B070400000000, "Content Maturity Description")
C(0D0B070500000000, "Content Maturity Graphic")
C(0D0B080000000000, "Contract")
C(0D0B080100000000, "Contract Entity")
C(0D0B080200000000, "Contract Type Link")
C(0D0B090000000000, "Rights")
C(0D0B090100000000, "Consumer Rights to Copy")
C(0D0B090200000000, "Broadcaster Rights to Copy")
C(0D0B0A0000000000, "Production Key People")
C(0D0B0A0100000000, "Director Name")
C(0D0B0A0200000000, "Producer Name")
C(0D0B0A0300000000, "Female Lead Actress Name")
C(0D0B0A0400000000, "Male Lead Actor Name")
C(0D0B0A0500000000, "Presenter Name")
C(0D0B0A0600000000, "Main Sponsor Name")
C(0D0B0A0700000000, "Voice Talent Name")
C(0D0B0B0000000000, "Address")
C(0D0B0B0100000000, "Postbox Number")
C(0D0B0B0200000000, "Post Code for Postbox")
C(0D0C000000000000, "DPP")
C(0D0C010000000000, "DPP Schemes")
C(0D0C010100000000, "AS-11 UKDPP")
C(0D0C010101000000, "DPP Groups")
C(0D0C010101010000, "AS-11 UKDPP Framework")
C(0D0C010101010100, "Production Number")
C(0D0C010101010200, "Synopsis")
C(0D0C010101010300, "Originator")
C(0D0C010101010400, "Copyright Year")
C(0D0C010101010500, "Other Identifier")
C(0D0C010101010600, "Other Identifier type")
C(0D0C010101010700, "Genre")
C(0D0C010101010800, "Distributor")
C(0D0C010101010900, "Picture Ratio")
C(0D0C010101010A00, "3D")
C(0D0C010101010B00, "3D Type")
C(0D0C010101010C00, "Product Placement")
C(0D0C010101010D00, "PSE Pass")
C(0D0C010101010E00, "PSE Manufacturer")
C(0D0C010101010F00, "PSE Version")
C(0D0C010101011000, "Video Comments")
C(0D0C010101011100, "Secondary Audio Language")
C(0D0C010101011200, "Tertiary Audio Language")
C(0D0C010101011300, "Audio Loudness Standard")
C(0D0C010101011400, "Audio Comments")
C(0D0C010101011500, "Line Up Start")
C(0D0C010101011600, "Ident Clock Start")
C(0D0C010101011700, "Total Number Of Parts")
C(0D0C010101011800, "Total Programme Duration")
C(0D0C010101011900, "Audio Description Present")
C(0D0C010101011A00, "Audio Description Type")
C(0D0C010101011B00, "Open Captions Present")
C(0D0C010101011C00, "Open Captions Type")
C(0D0C010101011D00, "Open Captions Language")
C(0D0C010101011E00, "Signing Present")
C(0D0C010101011F00, "Sign Language")
C(0D0C010101012000, "Completion Date")
C(0D0C010101012100, "Textless Elements Exist")
C(0D0C010101012200, "Programme Has Text")
C(0D0C010101012300, "Programme Text Language")
C(0D0C010101012400, "Contact Email")
C(0D0C010101012500, "Contact Telephone No.")
C(0D0D000000000000, "Ad-ID")
C(0D0D010000000000, "DMS_AS_12_AdID_Slate")
C(0D0D010100000000, "adid_prefix")
C(0D0D010200000000, "adid_code")
C(0D0D010300000000, "ad_title")
C(0D0D010400000000, "Brand")
C(0D0D010500000000, "Product")
C(0D0D010600000000, "Advertiser")
C(0D0D010700000000, "agency_office_location")
C(0D0D010800000000, "Length")
C(0D0D010900000000, "Medium")
C(0D0D010A00000000, "sd_flag")
C(0D0D010B00000000, "Parent")
C(0D0E000000000000, "LOC_Elements")
C(0D0E010000000000, "LOC_ApplicationSpecifications_Elements")
C(0D0E010100000000, "LOC_ApplicationSpecifications_Elements_V1")
C(0D0E010107000000, "AS_07_Elements")
C(0D0E010107010000, "AS_07_DMS_Elements")
C(0D0E010107010101, "AS_07_Core_DMS_ShimName")
C(0D0E010107010102, "AS_07_Core_DMS_Identifiers")
C(0D0E010107010103, "AS_07_Core_DMS_ResponsibleOrganizationName")
C(0D0E010107010105, "AS_07_Core_DMS_ResponsibleOrganizationCode")
C(0D0E010107010106, "AS_07_Core_DMS_NatureOfOrganization")
C(0D0E010107010107, "AS_07_Core_DMS_WorkingTitle")
C(0D0E010107010108, "AS_07_Core_DMS_SecondaryTitle")
C(0D0E010107010109, "AS_07_Core_DMS_PictureFormat")
C(0D0E01010701010A, "AS_07_Core_DMS_IntendedAFD")
C(0D0E01010701010B, "AS_07_Core_DMS_Captions")
C(0D0E01010701010C, "AS_07_Core_DMS_AudioTrackPrimaryLanguage")
C(0D0E01010701010D, "AS_07_Core_DMS_AudioTrackSecondaryLanguage")
C(0D0E01010701010E, "AS_07_Core_DMS_AudioTrackLayout")
C(0D0E01010701010F, "AS_07_Core_DMS_AudioTrackLayoutComment")
C(0D0E010107010110, "AS_07_Core_DMS_Devices")
C(0D0E010107010202, "AS_07_Core_DMS_DeviceType")
C(0D0E010107010203, "AS_07_Core_DMS_DeviceManufacturer")
C(0D0E010107010204, "AS_07_Core_DMS_DeviceModel")
C(0D0E010107010205, "AS_07_Core_DMS_DeviceSerialNumber")
C(0D0E010107010206, "AS_07_Core_DMS_DeviceUsageDescription")
C(0D0E010107010302, "AS_07_DMS_IdentifierValue")
C(0D0E010107010303, "AS_07_DMS_IdentifierRole")
C(0D0E010107010304, "AS_07_DMS_IdentifierType")
C(0D0E010107010305, "AS_07_DMS_IdentifierComment")
C(0D0E010107010401, "AS_07_GSP_DMS_Identifiers")
C(0D0E010107010402, "AS_07_GSP_DMS_MIMEMediaType")
C(0D0E010107010403, "AS_07_GSP_DMS_DataDescription")
C(0D0E010107010404, "AS_07_GSP_DMS_Note")
C(0D0E010107020000, "AS_07_GSP_Elements")
C(0D0E010107020301, "AS_07_GSP_TD_DMS_PrimaryRFC5646LanguageCode")
C(0D0E010107020302, "AS_07_GSP_TD_DMS_SecondaryRFC5646LanguageCode")
C(0D0E010107030000, "AS_07_Segmentation_Elements")
C(0D0E010107030101, "AS_07_Segmentation_DMS_PartNumber")
C(0D0E010107030102, "AS_07_Segmentation_DMS_PartTotal")
C(0D0E010107040101, "AS_07_DateTimeSymbol")
C(0D0E010107040102, "AS_07_DateTimeEssenceTrackID")
C(0D0E010107040103, "AS_07_DateTimeChannelID")
C(0D0E010107040104, "AS_07_DateTimeDescription")
C(0D0E010107040300, "MICCarriage")
C(0D0F000000000000, "Inter-Society Digital Cinema Forum")
C(0E00000000000000, "Organizationally Registered as Private")
C(0E01000000000000, "MISB Systems")
C(0E02000000000000, "ASPA")
C(0E03000000000000, "MISB Classified")
C(0E04000000000000, "Avid Technology, Inc.")
C(0E05000000000000, "CNN")
C(0E06000000000000, "Sony Corporation")
C(0E07000000000000, "IdeasUnlimited.TV")
C(0E08000000000000, "IPV Ltd")
C(0E09000000000000, "Dolby Laboratories Inc.")
C(0E09040000000000, "Namespace URI")
C(0E09050600000000, "Immersive Audio Version")
C(0E09050700000000, "Max Channel Count")
C(0E09050800000000, "Max Object Count")
C(0E09050900000000, "Immersive Audio ID")
C(0E09050A00000000, "First Frame")
C(0E09060701010104, "Data Definition")
C(0E09060701010105, "Source Track ID")
C(0E09060701010106, "Simple Payload SID")
C(0E0A000000000000, "Snell & Wilcox")
C(0E0B000000000000, "Omneon Video Networks")
C(0E0B010000000000, "Omneon Video Networks 01")
C(0E0B010300000000, "Omneon Video Networks 0103")
C(0E0B010301000000, "Omneon Video Networks 0103.01")
C(0E0B010301010000, "Omneon Video Networks 0103.0101")
C(0E0B010301010100, "Omneon Video Networks 0103.010101")
C(0E0B010301010101, "Omneon Video Networks Descriptive Metadata Items")
C(0E0C000000000000, "Ascent Media Group, Inc.")
C(0E0D000000000000, "Quantel Ltd")
C(0E0E000000000000, "Panasonic")
C(0E0F000000000000, "Grass Valley, Inc.")
C(0E10000000000000, "Doremi Labs, Inc.")
C(0E11000000000000, "EVS Broadcast Equipment")
C(0E12000000000000, "Turner Broadcasting System, Inc.")
C(0E13000000000000, "NL Technology, LLC")
C(0E14000000000000, "Harris Corporation")
C(0E15000000000000, "Canon, Inc.")
C(0E16000000000000, "D-BOX Technologies")
C(0E17000000000000, "ARRI")
C(0E18000000000000, "JVC")
C(0E19000000000000, "3ality Technica")
C(0E1A000000000000, "NHK")
C(0E1B000000000000, "HBO")
C(0E1D000000000000, "DTS, Inc.")
C(0E1E000000000000, "FLIR Systems, Inc.")
C(0E1F000000000000, "Barco")
C(0E20000000000000, "Apple Inc.")
C(0E21000000000000, "Fraunhofer")
C(0E22000000000000, "RED")
C(0E23000000000000, "CRIFST")
C(0E23060701010104, "Data Definition")
C(0E23060701010105, "Source Track ID")
C(0E23060701010106, "Simple Payload SID")
C(0F00000000000000, "Experimental")
C(4300000000000000, "Legacy (315M)")
    default: return {};
    }
}

const char* Mxf_Param_Info_Essences(int64u Value)
{
    switch (Value)
    {
C(0000000000000000, "Elements")
C(0D00000000000000, "Organizationally Registered for Public Use")
C(0D01000000000000, "AAF Association")
C(0D01030000000000, "MXF Generic Container Keys")
C(0D01030100000000, "MXF Generic Container Keys Version 1")
C(0D01030101000000, "MXF Generic Container - Deprecated")
C(0D01030102000000, "MXF Generic Container")
C(0D01030104000000, "CP-Compatible System Item")
C(0D01030105000000, "CP Picture")
C(0D01030105000100, "D-10 Video")
C(0D01030106000000, "CP Sound")
C(0D01030106001000, "D10Audio")
C(0D01030107000000, "CP Data")
C(0D01030114000000, "GC-Compatible System Item")
C(0D01030114000100, "Uncompressed picture system scheme")
C(0D01030115000000, "GC Picture")
C(0D01030115000100, "D-11 Video")
C(0D01030115000200, "Uncompressed")
C(0D01030115000300, "Uncompressed")
C(0D01030115000400, "Uncompressed")
C(0D01030115000500, "MPEG stream")
C(0D01030115000600, "MPEG stream")
C(0D01030115000700, "MPEG stream")
C(0D01030115000800, "JPEG 2000")
C(0D01030115000A00, "VC-1")
C(0D01030115000B00, "VC-1")
C(0D01030115000C00, "VC-3")
C(0D01030115000D00, "VC-3")
C(0D01030115001700, "ProRes")
C(0D01030115001D00, "FFV1")
C(0D01030115001E00, "FFV1")
C(0D01030116000000, "GC Sound")
C(0D01030116000100, "PCM")
C(0D01030116000200, "PCM")
C(0D01030116000300, "PCM")
C(0D01030116000400, "PCM")
C(0D01030116000500, "MPEG Audio / AAC")
C(0D01030116000600, "MPEG Audio / AAC")
C(0D01030116000700, "MPEG Audio / AAC")
C(0D01030116000800, "A-law")
C(0D01030116000900, "A-law")
C(0D01030116000A00, "A-law")
C(0D01030116000D00, "IAB")
C(0D01030116000E00, "MGA")
C(0D01030116000F00, "MGA")
C(0D01030116001000, "IAB")
C(0D010301167F107F, "IAB")
C(0D01030117000000, "GC Data")
C(0D01030117000100, "VBI")
C(0D01030117000200, "ANC")
C(0D01030117000800, "ANC")
C(0D01030117000900, "VANC Data")
C(0D01030117000A00, "HANC Data")
C(0D01030117000B00, "Timed Text")
C(0D01030118000000, "GC Compound")
C(0D01030118000100, "DV-DIF")
C(0D01030118000200, "DV-DIF")
C(0E00000000000000, "Organizationally Registered as Private")
C(0E04000000000000, "Avid Technology, Inc.")
C(0E04030000000000, "Avid Technology, Inc. MXF Generic Container Keys")
C(0E04030015000000, "Avid Technology, Inc. MXF Generic Container Keys")
C(0E04030100000000, "Avid Technology, Inc. MXF Generic Container Keys Version 1")
C(0E04030115000500, "VC-3")
C(0E04030115000600, "VC-3")
C(0E04030115000700, "VC-3")
C(0E06000000000000, "Sony Corporation")
C(0E067F0300000000, "Sony Corporation MXF Generic Container Keys Version 1")
C(0E09000000000000, "Dolby Laboratories Inc.")
C(0E09050201000100, "ISXD Data")
C(0E09050217000100, "ISXD Data")
C(0E09060701000100, "PHDR Image Metadata Item")
C(0E23060701010103, "HDR Vivid Metadata Item")
    default: return {};
    }
}

const char* Mxf_Param_Info_Groups(int64u Value)
{
    switch (Value)
    {
C(0000000000000000, "Groups")
C(0100000000000000, "Identification and location")
C(0200000000000000, "Administrative")
C(0207000000000000, "Access Control")
C(0207010000000000, "Auditorium Security")
C(0207010100000000, "Error")
C(0207010101000000, "Bad Request Response")
C(0207010200000000, "General purpose")
C(0207010210000000, "Time Request")
C(0207010211000000, "Time Response")
C(0207010212000000, "Event List Request")
C(0207010213000000, "Event List Response")
C(0207010214000000, "Event ID Request")
C(0207010215000000, "Event ID Response")
C(0207010216000000, "Secure Processing Block Query Request")
C(0207010217000000, "Secure Processing Block Query Response")
C(0207010218000000, "Projector Certificate Request")
C(0207010219000000, "Projector Certificate Response")
C(0207010300000000, "Link encryption")
C(0207010320000000, "Link Encryption Key Load Request")
C(0207010321000000, "Link Encryption Key Load Response")
C(0207010322000000, "Link Encryption Key Query ID Request")
C(0207010323000000, "Link Encryption Key Query ID Response")
C(0207010324000000, "Link Encryption Key Query All Request")
C(0207010325000000, "Link Encryption Key Query All Response")
C(0207010326000000, "Link Encryption Purge ID Request")
C(0207010327000000, "Link Encryption Purge ID Response")
C(0207010328000000, "Link Encryption Purge All Request")
C(0207010329000000, "Link Encryption Purge All Response")
C(0300000000000000, "Interpretive")
C(0400000000000000, "Parametric")
C(0500000000000000, "Process")
C(0531000000000000, "Color Transform Sets")
C(0531010000000000, "DMCVT Generic Sets")
C(0531010100000000, "DMCVT Generic Set 1")
C(0531020000000000, "DMCVT Application Sets")
C(0531020100000000, "DMCVT App1 Set")
C(0531020200000000, "DMCVT App2 Set")
C(0531020300000000, "DMCVT App3 Set")
C(0531020400000000, "DMCVT App4 Set")
C(0532000000000000, "Color Transform Packs")
C(0532010000000000, "MD Color Volume Metadata")
C(0532020000000000, "Maximum Light Level Metadata")
C(0600000000000000, "Relational")
C(0700000000000000, "Spatio-temporal")
C(0C00000000000000, "Compound")
C(0C01000000000000, "Data Models")
C(0C01010000000000, "Dictionary Representation")
C(0C01010100000000, "Registry Interchange Format (RIF)")
C(0C01010101000000, "RIF Version 1 Compatible Classes")
C(0C01010101010100, "Administrative Base Class")
C(0C01010101010200, "Compound Entry Element Base Class")
C(0C01010101010300, "Entry")
C(0C01010101010400, "Entry Administration")
C(0C01010101010500, "Leaf")
C(0C01010101010600, "Node")
C(0C01010101010700, "Register")
C(0C01010101010800, "Register Administration")
C(0C01010101010900, "Rif Base Class")
C(0C02000000000000, "Production Metadata")
C(0C02010000000000, "Acquisition")
C(0C02010100000000, "Frame based")
C(0C02010101010000, "Lens Unit Acquisition Metadata")
C(0C02010102010000, "Camera Unit Acquisition Metadata")
C(0C0201017F010000, "UserDefinedAcquisitionMetadata")
C(0C03000000000000, "Messages")
C(0C03010000000000, "Aux Data Transfer Protocol")
C(0C03010100000000, "Aux Data Block Transfer Header")
C(0C03010200000000, "Aux Data Block")
C(0C03020000000000, "SMS-OMB Communications Protocol")
C(0C03020100000000, "Bad Request Response")
C(0C03020200000000, "Get Certificate Request")
C(0C03020300000000, "Get Certificate Response")
C(0C03020400000000, "Adjust Secure Time Request")
C(0C03020500000000, "Adjust Secure Time Response")
C(0C03020600000000, "Get Secure Time Request")
C(0C03020700000000, "Get Secure Time Response")
C(0C03020800000000, "Validate CPL Request")
C(0C03020900000000, "Validate CPL Response")
C(0C03020A00000000, "Get CPL Validation Result Request")
C(0C03020B00000000, "Get CPL Validation Result Response")
C(0C03020C00000000, "Validate KDM Request")
C(0C03020D00000000, "Validate KDM Response")
C(0C03020E00000000, "Get KDM Validation Result Request")
C(0C03020F00000000, "Get KDM Validation Result Response")
C(0C03021000000000, "Validate Playback Request")
C(0C03021100000000, "Validate Playback Response")
C(0C03021200000000, "Invalidate Playback Request")
C(0C03021300000000, "Invalidate Playback Response")
C(0C03021400000000, "Get Device Info Request")
C(0C03021500000000, "Get Device Info Response")
C(0C03021600000000, "Get Status Request")
C(0C03021700000000, "Get Status Response")
C(0C03021800000000, "Generate Security Log Report Request")
C(0C03021900000000, "Generate Security Log Report Response")
C(0C03021A00000000, "Get Security Log Report Request")
C(0C03021B00000000, "Get Security Log Report Response")
C(0C03021C00000000, "Cancel Security Log Report Request")
C(0C03021D00000000, "Cancel Security Log Report Response")
C(0C03021E00000000, "Generate CPLProcessed Log Report Request")
C(0C03021F00000000, "Generate CPLProcessed Log Report Response")
C(0C03022000000000, "Get CPLProcessed Log Report Request")
C(0C03022100000000, "Get CPLProcessed Log Report Response")
C(0C03022200000000, "Cancel CPLProcessed Log Report Request")
C(0C03022300000000, "Cancel CPLProcessed Log Report Response")
C(0C04000000000000, "Audio Metadata")
C(0C04010000000000, "Audio Metadata Pack")
C(0C05000000000000, "Data Sets")
C(0C05010100000000, "Streaming Data")
C(0D00000000000000, "Organizationally Registered for Public Use")
C(0D01000000000000, "AAF Association")
C(0D01010000000000, "AAF Association Structural Metadata")
C(0D01010100000000, "AAF Version 1.x Classes")
C(0D01010101000000, "Standard Classes")
C(0D01010101010000, "Class")
C(0D01010101010100, "Interchange Object")
C(0D01010101010200, "Component")
C(0D01010101010300, "Segment")
C(0D01010101010400, "Edge Code")
C(0D01010101010500, "Essence Group")
C(0D01010101010600, "Event")
C(0D01010101010700, "GPI Trigger")
C(0D01010101010800, "Comment Marker")
C(0D01010101010900, "Filler")
C(0D01010101010A00, "Operation Group")
C(0D01010101010B00, "Nested Scope")
C(0D01010101010C00, "Pulldown")
C(0D01010101010D00, "Scope Reference")
C(0D01010101010E00, "Selector")
C(0D01010101010F00, "Sequence")
C(0D01010101011000, "Source Reference")
C(0D01010101011100, "Source Clip")
C(0D01010101011200, "Text Clip")
C(0D01010101011300, "HTML Clip")
C(0D01010101011400, "Timecode")
C(0D01010101011500, "Timecode Stream")
C(0D01010101011600, "Timecode Stream 12M")
C(0D01010101011700, "Transition")
C(0D01010101011800, "Content Storage")
C(0D01010101011900, "Control Point")
C(0D01010101011A00, "Definition Object")
C(0D01010101011B00, "Data Definition")
C(0D01010101011C00, "Operation Definition")
C(0D01010101011D00, "Parameter Definition")
C(0D01010101011E00, "Plugin Definition")
C(0D01010101011F00, "Codec Definition")
C(0D01010101012000, "Container Definition")
C(0D01010101012100, "Interpolation Definition")
C(0D01010101012200, "Dictionary")
C(0D01010101012300, "Essence Data")
C(0D01010101012400, "Essence Descriptor")
C(0D01010101012500, "File Descriptor")
C(0D01010101012600, "AIFC Descriptor")
C(0D01010101012700, "Picture Descriptor")
C(0D01010101012800, "CDCI Descriptor")
C(0D01010101012900, "RGBA Descriptor")
C(0D01010101012A00, "HTML Descriptor")
C(0D01010101012B00, "TIFF Descriptor")
C(0D01010101012C00, "WAVE Descriptor")
C(0D01010101012D00, "Film Descriptor")
C(0D01010101012E00, "Tape Descriptor")
C(0D01010101012F00, "Preface")
C(0D01010101013000, "Identification")
C(0D01010101013100, "Locator")
C(0D01010101013200, "Network Locator")
C(0D01010101013300, "Text Locator")
C(0D01010101013400, "Package")
C(0D01010101013500, "Composition Package")
C(0D01010101013600, "Material Package")
C(0D01010101013700, "Source Package")
C(0D01010101013800, "Track")
C(0D01010101013900, "Event Package")
C(0D01010101013A00, "Static Track")
C(0D01010101013B00, "Timeline Track")
C(0D01010101013C00, "Parameter")
C(0D01010101013D00, "Constant Value")
C(0D01010101013E00, "Varying Value")
C(0D01010101013F00, "Tagged Value")
C(0D01010101014000, "KLV Data")
C(0D01010101014100, "Descriptive Marker")
C(0D01010101014200, "Sound Descriptor")
C(0D01010101014300, "Data Essence Descriptor")
C(0D01010101014400, "Multiple Descriptor")
C(0D01010101014500, "Descriptive Clip")
C(0D01010101014600, "Date Time Descriptor")
C(0D01010101014700, "AES3 PCM Descriptor")
C(0D01010101014800, "WAVE PCM Descriptor")
C(0D01010101014900, "Physical Descriptor")
C(0D01010101014A00, "Import Descriptor")
C(0D01010101014B00, "Recording Descriptor")
C(0D01010101014C00, "Tagged Value Definition")
C(0D01010101014D00, "KLV Data Definition")
C(0D01010101014E00, "Auxiliary Descriptor")
C(0D01010101014F00, "RIFF Chunk")
C(0D01010101015000, "BWF Import Descriptor")
C(0D01010101015100, "MPEG Video Descriptor")
C(0D01010101015200, "Parsed Text Descriptor")
C(0D01010101015300, "SGML Descriptor")
C(0D01010101015400, "XML Descriptor")
C(0D01010101015500, "HTML Parsed Text Descriptor")
C(0D01010101015600, "RP217 Descriptor")
C(0D01010101015700, "Dynamic Marker")
C(0D01010101015800, "Dynamic Clip")
C(0D01010101015900, "Sub-Descriptor")
C(0D01010101015A00, "JPEG 2000 Sub-Descriptor")
C(0D01010101015B00, "VBI Data Descriptor")
C(0D01010101015C00, "ANC Data Descriptor")
C(0D01010101015D00, "DC PCM Sound Descriptor")
C(0D01010101015E00, "MPEG Audio Descriptor")
C(0D01010101015F00, "VC-1 Video Descriptor")
C(0D01010101016000, "Package Marker")
C(0D01010101016100, "Application Plug-In Object")
C(0D01010101016200, "Application Referenced Object")
C(0D01010101016300, "Stereoscopic Picture Sub-Descriptor")
C(0D01010101016400, "DC Timed Text Descriptor")
C(0D01010101016500, "DC Timed Text Resource Sub-Descriptor")
C(0D01010101016600, "Application Object")
C(0D01010101016700, "Container Constraints Sub-Descriptor")
C(0D01010101016800, "MPEG-4 Visual Sub-Descriptor")
C(0D01010101016900, "TIFF Picture Essence Descriptor")
C(0D01010101016A00, "MCA Label Sub-Descriptor")
C(0D01010101016B00, "Audio Channel Label Sub-Descriptor")
C(0D01010101016C00, "Soundfield Group Label Sub-Descriptor")
C(0D01010101016D00, "Group Of Soundfield Groups Label Sub-Descriptor")
C(0D01010101016E00, "AVC Sub-Descriptor")
C(0D01010101016F00, "Event Text Descriptor")
C(0D01010101017000, "STL Descriptor")
C(0D01010101017100, "STL Sub-Descriptor")
C(0D01010101017200, "Operations Stereoscopic Sub-Descriptor")
C(0D01010101017300, "Aux Data Essence Descriptor")
C(0D01010101017400, "VC-2 Sub-Descriptor")
C(0D01010101017500, "DMCVT Target SubDescriptor")
C(0D01010101017600, "VC-5 Bayer Picture Essence Sub-Descriptor")
C(0D01010101017700, "VC-5 CDCI Picture Essence Sub-Descriptor")
C(0D01010101017800, "AAC SubDescriptor")
C(0D01010101017900, "ACES Picture SubDescriptor")
C(0D01010101017A00, "Target Frame SubDescriptor")
C(0D01010101017B00, "IAB Essence Descriptor")
C(0D01010101017C00, "IAB Soundfield Label SubDescriptor")
C(0D01010101017D00, "Operational Pattern Definition")
C(0D01010101017E00, "Compression Definition")
C(0D01010101017F00, "Abstract Object")
C(0D01010101018101, "HEVC Sub-Descriptor")
C(0D01010101018102, "JPEG XS SubDescriptor")
C(0D01010101018103, "FFV1PictureSubDescriptor")
C(0D01010101018106, "MGA Sound Essence Descriptor")
C(0D01010101018107, "MGA Audio Metadata SubDescriptor")
C(0D01010101018108, "MGA Soundfield Group Label SubDescriptor")
C(0D01010101018109, "S-ADM Audio Metadata SubDescriptor")
C(0D0101010101810A, "Supplemental Data Essence Descriptor")
C(0D0101010101810B, "Data Stream SubDescriptor")
C(0D0101010101810C, "Data Stream Device SubDescriptor")
C(0D0101010101810D, "RIFF Chunk Definition Sub-Descriptor")
C(0D0101010101810E, "ADM CHNA Sub-Descriptor")
C(0D0101010101810F, "ADM Channel Mapping")
C(0D01010101018110, "RIFF Chunk References Sub-Descriptor")
C(0D01010101018111, "ADM Audio Metadata Sub-Descriptor")
C(0D01010101018112, "ADM Soundfield GroupLabel Sub-Descriptor")
C(0D01010102000000, "Meta-Definitions")
C(0D01010102010000, "Class Definition")
C(0D01010102020000, "Property Definition")
C(0D01010102030000, "Type Definition")
C(0D01010102040000, "Type Definition Integer")
C(0D01010102050000, "Type Definition Strong Object Reference")
C(0D01010102060000, "Type Definition Weak Object Reference")
C(0D01010102070000, "Type Definition Enumeration")
C(0D01010102080000, "Type Definition Fixed Array")
C(0D01010102090000, "Type Definition Variable Array")
C(0D010101020A0000, "Type Definition Set")
C(0D010101020B0000, "Type Definition String")
C(0D010101020C0000, "Type Definition Stream")
C(0D010101020D0000, "Type Definition Record")
C(0D010101020E0000, "Type Definition Rename")
C(0D01010102200000, "Type Definition Extendible Enumeration")
C(0D01010102210000, "Type Definition Indirect")
C(0D01010102220000, "Type Definition Opaque")
C(0D01010102230000, "Type Definition Character")
C(0D01010102240000, "Meta-Definition")
C(0D01010102250000, "Meta-Dictionary")
C(0D01010102260000, "Extension Scheme")
C(0D01010102270000, "Property Alias Definition")
C(0D01010102280000, "Extendible Enumeration Element")
C(0D01010103000000, "Root")
C(0D01020000000000, "MXF File Structure")
C(0D01020100000000, "MXF File Structure Version 1")
C(0D01020101000000, "MXF File Structure Sets and Packs")
C(0D01020101010000, "Partition Pack")
C(0D01020101020000, "Header Partition Pack")
C(0D01020101020100, "Header Partition Open Incomplete")
C(0D01020101020200, "Header Partition Closed Incomplete")
C(0D01020101020300, "Header Partition Open Complete")
C(0D01020101020400, "Header Partition Closed Complete")
C(0D01020101030000, "Body Partition Pack")
C(0D01020101030100, "Body Partition Open Incomplete")
C(0D01020101030200, "Body Partition Closed Incomplete")
C(0D01020101030300, "Body Partition Open Complete")
C(0D01020101030400, "Body Partition Closed Complete")
C(0D01020101031100, "Generic Stream Partition")
C(0D01020101040000, "Footer Partition Pack")
C(0D01020101040200, "Footer Partition Closed Incomplete")
C(0D01020101040400, "Footer Partition Closed Complete")
C(0D01020101050000, "Primer Pack")
C(0D01020101050100, "Primer Pack Version 1")
C(0D01020101100000, "Index Tables")
C(0D01020101100100, "Index Table Segment")
C(0D01020101110000, "Other MXF Packs")
C(0D01020101110100, "Random Index Pack")
C(0D01030000000000, "Essence Container Labels")
C(0D01030100000000, "Essence Container Labels Version 1")
C(0D01030101000000, "Generic Container Labels - Deprecated")
C(0D01030102000000, "Generic Container Labels")
C(0D010301027E0000, "EncryptedEssence")
C(0D010301027E0100, "Encrypted Triplet")
C(0D01030104000000, "CP-Compatible System Item")
C(0D01030104010000, "SDTI")
C(0D01030104010100, "SDTI System Metadata Pack")
C(0D01030104010200, "SDTI Package Metadata Set")
C(0D01030104010300, "SDTI Picture Metadata Set")
C(0D01030104010400, "SDTI Sound Metadata Set")
C(0D01030104010500, "SDTI Data Metadata Set")
C(0D01030104010600, "SDTI Control Metadata Set")
C(0D01030114000000, "GC-Compatible System Item")
C(0D01030114020000, "System Scheme 1")
C(0D01030114020100, "System Scheme 1 First Element")
C(0D01030114020200, "System Scheme 1 Subsequent Element")
C(0D01030114020300, "System Scheme 1 Picture Item Descriptor")
C(0D01030114020400, "System Scheme 1 Sound Item Descriptor")
C(0D01030114020500, "System Scheme 1 Data Item Descriptor")
C(0D01030114020600, "System Scheme 1 Control Data Set")
C(0D01030114020700, "System Scheme 1 Compound Item Descriptor")
C(0D01040000000000, "Descriptive Object")
C(0D01040100000000, "Descriptive Framework")
C(0D01040101000000, "DMS-1 Descriptive Metadata Scheme")
C(0D01040101010000, "DMS-1 Frameworks")
C(0D01040101010100, "Production Framework")
C(0D01040101010200, "Clip Framework")
C(0D01040101010300, "Scene Framework")
C(0D01040101100000, "DMS-1 Title Sets")
C(0D01040101100100, "Titles Set")
C(0D01040101110000, "DMS-1 Identification Sets")
C(0D01040101110100, "Identification Set")
C(0D01040101120000, "DMS-1 Relationship Sets")
C(0D01040101120100, "Episodic Item Set")
C(0D01040101130000, "DMS-1 Branding Sets")
C(0D01040101130100, "Branding Set")
C(0D01040101140000, "DMS-1 Publication Sets")
C(0D01040101140100, "Event Set")
C(0D01040101140200, "Publication Set")
C(0D01040101150000, "DMS-1 Awards Sets")
C(0D01040101150100, "Award Set")
C(0D01040101160000, "DMS-1 Captions Sets")
C(0D01040101160100, "Captions Description Set")
C(0D01040101170000, "DMS-1 Interpretive Sets")
C(0D01040101170100, "Annotation Set")
C(0D01040101170200, "Setting Period Set")
C(0D01040101170300, "Scripting Set")
C(0D01040101170400, "Classification Set")
C(0D01040101170500, "Shot Set")
C(0D01040101170600, "Key Point Set")
C(0D01040101170800, "Cue Words Set")
C(0D01040101180000, "DMS-1 Role Sets")
C(0D01040101180100, "Participant Role Set")
C(0D01040101190000, "DMS-1 Contact Collections")
C(0D01040101190100, "Contacts List Set")
C(0D010401011A0000, "DMS-1 Contact Sets")
C(0D010401011A0200, "Person Set")
C(0D010401011A0300, "Organisation Set")
C(0D010401011A0400, "Location Set")
C(0D010401011B0000, "DMS-1 Contact Information Sets")
C(0D010401011B0100, "Address Set")
C(0D010401011B0200, "Communications Set")
C(0D010401011C0000, "DMS-1 Rights Sets")
C(0D010401011C0100, "Contract Set")
C(0D010401011C0200, "Rights Set")
C(0D010401011D0000, "DMS-1 Format Sets")
C(0D010401011D0100, "Picture Format Set")
C(0D010401011E0000, "DMS-1 Parametric Sets")
C(0D010401011E0100, "Device Parameters Set")
C(0D010401011F0000, "DMS-1 Name-Value Sets")
C(0D010401011F0100, "Name-Value Set")
C(0D01040101200000, "DMS-1 Project Sets")
C(0D01040101200100, "Processing Set")
C(0D01040101200200, "Project Set")
C(0D010401017F0000, "DMS-1 Abstract Sets")
C(0D010401017F0100, "DMS-1 Framework")
C(0D010401017F0200, "Production/Clip Framework")
C(0D010401017F1000, "DMS-1 Set")
C(0D010401017F1100, "TextLanguage")
C(0D010401017F1200, "Thesaurus")
C(0D010401017F1A00, "Contact")
C(0D01040102000000, "DMS-Crypto Descriptive Sets")
C(0D01040102010000, "Cryptographic Framework")
C(0D01040102020000, "Cryptographic Context")
C(0D01040103000000, "DMS AS-03")
C(0D01040103010000, "DMS AS-03 Framework")
C(0D01040104000000, "Text-based Descriptive Metadata Scheme")
C(0D01040104010000, "Text-based Frameworks")
C(0D01040104010100, "Text-based Framework")
C(0D01040104020000, "Text-based Descriptive Metadata Sets")
C(0D01040104020100, "Generic Stream Text-based Set")
C(0D01040104020200, "UTF-8 Text-based Set")
C(0D01040104020300, "UTF-16 Text-based Set")
C(0D01040104030000, "Text-based Objects")
C(0D01040104030100, "Text-based Object")
C(0D01040105000000, "EIDR Descriptive Metadata Scheme")
C(0D01040105010000, "EIDR Framework")
C(0D01070000000000, "AMWA Application Specifications")
C(0D01070100000000, "Application Specifications Version 1")
C(0D01070101000000, "Application Specifications Common")
C(0D01070101010000, "Segmentation")
C(0D01070101010100, "DM_Segmentation_Framework")
C(0D01070107000000, "AS_07")
C(0D0107010A000000, "AS-10")
C(0D0107010A010000, "DMS AS-10 Core")
C(0D0107010A010100, "DMS AS-10 Core Framework")
C(0D0107010B000000, "AS-11")
C(0D0107010B010000, "AS-11 Core")
C(0D0107010B010100, "DM_AS_11_Core_Framework")
C(0D0107010B020000, "AS-11 Segmentation")
C(0D0107010B020100, "DM_AS_11_Segmentation_Framework")
C(0D0107010C000000, "AS-12")
C(0D0107010C010000, "DMS_AS_12")
C(0D0107010C010100, "DMS_AS_12_Framework")
C(0D0107010C010200, "AS_12_DescriptiveObject")
C(0D01080000000000, "AMWA Rules Based Specifications")
C(0D01080100000000, "Rules Based Specifications Version 1")
C(0D02000000000000, "EBU/UER")
C(0D02010000000000, "EBUCore")
C(0D02010100000000, "EBU Core Main Framework")
C(0D02010200000000, "Core Metadata")
C(0D02010300000000, "Metadata  Schema Information")
C(0D02010400000000, "Identifier")
C(0D02010500000000, "Title")
C(0D02010600000000, "Alternative Title")
C(0D02010800000000, "Subject")
C(0D02010900000000, "Description")
C(0D02010C00000000, "Date")
C(0D02010D00000000, "Date Type")
C(0D02010E00000000, "Type")
C(0D02010F00000000, "Object Type")
C(0D02011000000000, "Genre")
C(0D02011100000000, "Target Audience")
C(0D02011200000000, "Language")
C(0D02011300000000, "Coverage")
C(0D02011400000000, "Spatial")
C(0D02011500000000, "Location")
C(0D02011600000000, "Coordinates")
C(0D02011700000000, "Temporal")
C(0D02011800000000, "Period Of Time")
C(0D02011900000000, "Rights")
C(0D02011A00000000, "Version")
C(0D02011B00000000, "Rating")
C(0D02011C00000000, "Publication Event")
C(0D02011D00000000, "Publication History")
C(0D02011E00000000, "Publication Channel")
C(0D02011F00000000, "Publication Medium")
C(0D02012000000000, "Publication Service")
C(0D02012100000000, "Entity")
C(0D02012200000000, "Contact")
C(0D02012300000000, "Organization")
C(0D02012400000000, "Department")
C(0D02012500000000, "Details")
C(0D02012600000000, "Address")
C(0D02012700000000, "Region")
C(0D02012800000000, "Compound Name")
C(0D02012900000000, "Role")
C(0D02012A00000000, "Country Type")
C(0D02012B01000000, "Custom Relation")
C(0D02012B02000000, "basicRelation")
C(0D02012C00000000, "Planning")
C(0D02012D01000000, "Type Group")
C(0D02012D02000000, "Format  Group")
C(0D02012D03000000, "Status Group")
C(0D02012E00000000, "Textual Annotation")
C(0D02012F00000000, "Basic Link")
C(0D02013000000000, "Format")
C(0D02013100000000, "Video Format")
C(0D02013200000000, "Image Format")
C(0D02013300000000, "Audio Format")
C(0D02013400000000, "Track")
C(0D02013500000000, "Data Format")
C(0D02013600000000, "Captioning")
C(0D02013700000000, "Subtitling")
C(0D02013800000000, "Ancillary Data")
C(0D02013900000000, "Signing  Format")
C(0D02013A01000000, "Technical Attribute String")
C(0D02013A02000000, "Technical Attribute Int8")
C(0D02013A03000000, "Technical Attribute Int16")
C(0D02013A04000000, "Technical Attribute Int32")
C(0D02013A05000000, "Technical Attribute Int64")
C(0D02013A06000000, "Technical Attribute UInt8")
C(0D02013A07000000, "Technical Attribute UInt16")
C(0D02013A08000000, "Technical Attribute UInt32")
C(0D02013A09000000, "Technical Attribute UInt64")
C(0D02013A0A000000, "Technical Attribute Float")
C(0D02013A0B000000, "Technical Attribute Rational")
C(0D02013A0C000000, "Technical Attribute AnyURI")
C(0D02013A0D000000, "Technical Attribute Boolean")
C(0D02013B00000000, "Dimension")
C(0D02013C00000000, "Package Info")
C(0D02013D00000000, "Medium")
C(0D02013E00000000, "Codec")
C(0D02013F00000000, "Rational")
C(0D02014000000000, "Aspect Ratio")
C(0D02014100000000, "Height")
C(0D02014200000000, "Width")
C(0D02014300000000, "Part")
C(0D02014400000000, "Part  Metadata")
C(0D02014600000000, "Hash")
C(0D02014700000000, "Locator")
C(0D02014800000000, "Container Format")
C(0D02014900000000, "Audio Format Extended")
C(0D02014A00000000, "Audio Programme")
C(0D02014B00000000, "IDRef")
C(0D02014C00000000, "Loudness Metadata")
C(0D02014D00000000, "Audio Content")
C(0D02014E00000000, "Audio Object")
C(0D02014F00000000, "Audio Pack Format")
C(0D02015000000000, "Audio Channel Format")
C(0D02015100000000, "Audio Block Format")
C(0D02015200000000, "Audio Block Matrix Coefficient")
C(0D02015300000000, "Audio Stream Format")
C(0D02015400000000, "Audio Track Format")
C(0D02015500000000, "Audio Track UID")
C(0D02015600000000, "Audio MXF Lookup")
C(0D02015700000000, "Audio Block Matrix")
C(0D02015800000000, "Time")
C(0D02015900000000, "Metadata Format")
C(0D02015A00000000, "Timecode Format")
C(0D02015B00000000, "Video Noise Filter")
C(0D02015C00000000, "EBU Core Object")
C(0D02015D00000000, "Audience")
C(0D02015E00000000, "Filter")
C(0D02015F00000000, "Filter Setting")
C(0D02016000000000, "Reference screen")
C(0D02016100000000, "Reference Screen Centre Position")
C(0D02016200000000, "Reference Screen Width")
C(0D02016300000000, "Audio Content Dialogue")
C(0D02016400000000, "Audio Content Interaction")
C(0D02016500000000, "Gain Interaction Range")
C(0D02016600000000, "Position Interaction Range")
C(0D02016700000000, "Audio Block Position")
C(0D02016800000000, "Audio Block Divergence")
C(0D02016900000000, "Audio Block Zone Exclusion")
C(0D02016A00000000, "Audio Block Zone")
C(0D02016B00000000, "Audio Block Jump Position")
C(0D02016C00000000, "Event")
C(0D02016D00000000, "Award")
C(0D02016E00000000, "Affiliation")
C(0D03000000000000, "Pro-MPEG Forum")
C(0D04000000000000, "BBC")
C(0D04010000000000, "Archive Preservation Project")
C(0D04010100000000, "Archive Preservation Project Version 1")
C(0D04010101000000, "APP Descriptive Frameworks")
C(0D04010101010000, "APP Infax Framework")
C(0D04010101020000, "APP PSE Analysis Framework")
C(0D04010101030000, "APP VTR Replay Error Framework")
C(0D04010101040000, "APP DigiBeta Dropout Framework")
C(0D04010101050000, "APP Timecode Break Framework")
C(0D05000000000000, "IRT")
C(0D06000000000000, "ARIB")
C(0D07000000000000, "AMIA")
C(0D08000000000000, "PBS")
C(0D09000000000000, "ASC")
C(0D0A000000000000, "AES")
C(0D0B000000000000, "Dutch Guild")
C(0D0C000000000000, "DPP")
C(0D0C010000000000, "DPP Schemes")
C(0D0C010100000000, "AS-11 UKDPP")
C(0D0C010101000000, "DPP Groups")
C(0D0C010101010000, "DM_AS_11_UKDPP_Framework")
C(0D0D000000000000, "Ad-ID")
C(0D0D010000000000, "DMS_AS_12_AdID_Slate")
C(0D0E000000000000, "LOC_Groups")
C(0D0E010000000000, "LOC_ApplicationSpecifications_Groups")
C(0D0E010100000000, "LOC_ApplicationSpecifications_Groups_V1")
C(0D0E010107000000, "AS_07_Groups")
C(0D0E010107010000, "AS_07_DMS_Groups")
C(0D0E010107010100, "AS_07_Core_DMS_Framework")
C(0D0E010107010200, "AS_07_DMS_Device")
C(0D0E010107010300, "AS_07_DMS_Identifier")
C(0D0E010107010400, "AS_07_GSP_DMS_Object")
C(0D0E010107020000, "AS_07_GSP_Groups")
C(0D0E010107020100, "AS_07_GSP_DMS_Framework")
C(0D0E010107020200, "AS_07_GSP_BD_DMS_Framework")
C(0D0E010107020300, "AS_07_GSP_TD_DMS_Framework")
C(0D0E010107030000, "AS_07_Segmentation_Groups")
C(0D0E010107030100, "AS_07_Segmentation_DMS_Framework")
C(0D0E010107040000, "AS_07_Timecode_Groups")
C(0D0E010107040100, "AS_07_TimecodeLabelSubdescriptor")
C(0D0F000000000000, "Inter-Society Digital Cinema Forum")
C(0E00000000000000, "Organizationally Registered as Private")
C(0E01000000000000, "MISB Systems")
C(0E02000000000000, "ASPA")
C(0E03000000000000, "MISB Classified")
C(0E04000000000000, "Avid Technology, Inc.")
C(0E05000000000000, "CNN")
C(0E06000000000000, "Sony Corporation")
C(0E07000000000000, "IdeasUnlimited.TV")
C(0E08000000000000, "IPV Ltd")
C(0E09000000000000, "Dolby Laboratories Inc.")
C(0E09050000000000, "Dolby Laboratories Inc. 05")
C(0E09050200000000, "ISXD Data Essence Descriptor")
C(0E09060300000000, "Immersive Audio Data Essence Descriptor")
C(0E09060600000000, "IA Data Essence SubDescriptor")
C(0E09060701010103, "PHDR Metadata Track Sub Descriptor")
C(0E0A000000000000, "Snell & Wilcox")
C(0E0B000000000000, "Omneon Video Networks")
C(0E0B010000000000, "Omneon Video Networks 01")
C(0E0B010200000000, "Omneon Video Networks 0102")
C(0E0B010201000000, "Omneon Video Networks 0102.01")
C(0E0B010201010000, "Omneon Video Networks 0102.0101")
C(0E0B010201010100, "Omneon Video Networks Descriptive Metadata Links")
C(0E0B010201020000, "Omneon Video Networks 0102.0101")
C(0E0B010201020100, "Omneon Video Networks Descriptive Metadata Data")
C(0E0C000000000000, "Ascent Media Group, Inc.")
C(0E0D000000000000, "Quantel Ltd")
C(0E0E000000000000, "Panasonic")
C(0E0F000000000000, "Grass Valley, Inc.")
C(0E10000000000000, "Doremi Labs, Inc.")
C(0E11000000000000, "EVS Broadcast Equipment")
C(0E12000000000000, "Turner Broadcasting System, Inc.")
C(0E13000000000000, "NL Technology, LLC")
C(0E14000000000000, "Harris Corporation")
C(0E15000000000000, "Canon, Inc.")
C(0E16000000000000, "D-BOX Technologies")
C(0E17000000000000, "ARRI")
C(0E18000000000000, "JVC")
C(0E19000000000000, "3ality Technica")
C(0E1A000000000000, "NHK")
C(0E1B000000000000, "HBO")
C(0E1D000000000000, "DTS, Inc.")
C(0E1E000000000000, "FLIR Systems, Inc.")
C(0E1F000000000000, "Barco")
C(0E20000000000000, "Apple Inc.")
C(0E21000000000000, "Fraunhofer")
C(0E22000000000000, "RED")
C(0E23000000000000, "CRIFST")
C(0E23060701010103, "HDR Vivid Track Sub Descriptor")
C(0F00000000000000, "Experimental")
    default: return {};
    }
}

const char* Mxf_Param_Info_Labels(int64u Value)
{
    switch (Value)
    {
C(0000000000000000, "Labels")
C(0100000000000000, "Identification and location")
C(0101000000000000, "Globally Unique Identifiers")
C(0101010000000000, "SDTI Payload Identifiers")
C(0101010100000000, "SDTI-CP Identifiers")
C(0101010101000000, "SDTI-CP MPEG Payloads")
C(0101010101010000, "SDTI-CP MPEG-2 Baseline Template")
C(0101010101010100, "SDTI-CP MPEG-2 Extended Template")
C(0101020000000000, "File Format Identifiers")
C(0101020100000000, "File Format Identifiers Unstructured Node")
C(0101020101000000, "Unknown File Format")
C(0101020102000000, "IMF IAB Track File Level 0")
C(0101030000000000, "Definition Identifiers")
C(0101030100000000, "Reg-XML Definition Identifiers")
C(0101030101000000, "Reg-XML Meta-Dictionary Identifiers")
C(0101030101010000, "Reg-XML Baseline Meta-Dictionary Identifiers")
C(0101030101010100, "Reg-XML ST xxx--2 Meta-Dictionary Baseline")
C(0102000000000000, "Globally Unique Locators")
C(0103000000000000, "Locally Unique Identifiers")
C(0103010000000000, "For Information Only Do Not Use")
C(0103020000000000, "Track Identifiers")
C(0103020100000000, "Metadata Track Kinds")
C(0103020101000000, "SMPTE-12M Timecode Track Inactive User Bits")
C(0103020102000000, "SMPTE-12M Timecode Track Active User Bits")
C(0103020103000000, "SMPTE-309M Timecode Track Datecode User Bits")
C(0103020110000000, "Descriptive Metadata Track")
C(0103020200000000, "Essence Track Kinds")
C(0103020201000000, "Picture Essence Track")
C(0103020202000000, "Sound Essence Track")
C(0103020203000000, "Data Essence Track")
C(0103020300000000, "Other Track Kinds")
C(0103020301000000, "Auxiliary Data Track")
C(0103020302000000, "Parsed Text Track")
C(0200000000000000, "Administrative")
C(0209000000000000, "Encryption Identifiers")
C(0209020000000000, "Data Encryption Identifiers")
C(0209020100000000, "Data Encryption Algorithm Identifiers")
C(0209020101000000, "AES-128 CBC Identifier")
C(0209020200000000, "Data Hashing Algorithms")
C(0209020201000000, "HMAC-SHA1 128-bit Identifier")
C(0209020202000000, "HMAC-SHA1 128")
C(0300000000000000, "Interpretive")
C(0301000000000000, "Picture Essence")
C(0302000000000000, "Sound Essence")
C(0302010000000000, "Audio Channel")
C(0302010100000000, "Left Audio Channel")
C(0302010200000000, "Right Audio Channel")
C(0302010300000000, "Center Audio Channel")
C(0302010400000000, "LFE Audio Channel")
C(0302010500000000, "Left Surround Audio Channel")
C(0302010600000000, "Right Surround Audio Channel")
C(0302010700000000, "Left Side Surround Audio Channel")
C(0302010800000000, "Right Side Surround Audio Channel")
C(0302010900000000, "Left Rear Surround Audio Channel")
C(0302010A00000000, "Right Rear Surround Audio Channel")
C(0302010B00000000, "Left Center Audio Channel")
C(0302010C00000000, "Right Center Audio Channel")
C(0302010D00000000, "Center Surround Audio Channel")
C(0302010E00000000, "Hearing Impaired Audio Channel")
C(0302010F00000000, "Visually Impaired Narrative Audio Channel")
C(0302011000000000, "FSK Sync Signal Channel")
C(0302012000000000, "Audio Channels for SMPTE ST 2067-8")
C(0302012001000000, "SMPTE ST 2067-8 Mono One")
C(0302012002000000, "SMPTE ST 2067-8 Mono Two")
C(0302012003000000, "SMPTE ST 2067-8 Left Total")
C(0302012004000000, "SMPTE ST 2067-8 Right Total")
C(0302012005000000, "SMPTE ST 2067-8 Left Surround Total")
C(0302012006000000, "SMPTE ST 2067-8 Right Surround Total")
C(0302012007000000, "SMPTE ST 2067-8 Surround")
C(0302012008000000, "Numbered Source Channel for SMPTE ST 2067-8")
C(0302013001000000, "Audio Channels")
C(0302013001010000, "Left Height")
C(0302013001020000, "Right Height")
C(0302013001030000, "Center Height")
C(0302013001040000, "Left Surround Height")
C(0302013001050000, "Right Surround Height")
C(0302013001060000, "Left Side Surround Height")
C(0302013001070000, "Right Side Surround Height")
C(0302013001080000, "Left Rear Surround Height")
C(0302013001090000, "Right Rear Surround Height")
C(03020130010A0000, "Left Top Surround")
C(03020130010B0000, "Right Top Surround")
C(03020130010C0000, "Top Surround")
C(03020130010D0000, "LFE1")
C(03020130010E0000, "LFE2")
C(03020130010F0000, "Center Rear Height")
C(0302013001100000, "Center Rear")
C(0302013001110000, "Left Below")
C(0302013001120000, "Right Below")
C(0302013001130000, "Center Below")
C(0302020000000000, "Soundfield Group")
C(0302020100000000, "5.1 Soundfield Group")
C(0302020200000000, "7.1DS Soundfield Group")
C(0302020300000000, "7.1SDS Soundfield Group")
C(0302020400000000, "6.1 Soundfield Group")
C(0302020500000000, "1.0 Monaural Soundfield Group")
C(0302022000000000, "Soundfield Groups for SMPTE ST 2067-8")
C(0302022001000000, "SMPTE ST 2067-8 Standard Stereo")
C(0302022002000000, "SMPTE ST 2067-8 Dual Mono")
C(0302022003000000, "SMPTE ST 2067-8 Discrete Numbered Sources")
C(0302022004000000, "SMPTE ST 2067-8 3.0")
C(0302022005000000, "SMPTE ST 2067-8 4.0")
C(0302022006000000, "SMPTE ST 2067-8 5.0")
C(0302022007000000, "SMPTE ST 2067-8 6.0")
C(0302022008000000, "SMPTE ST 2067-8 7.0DS")
C(0302022009000000, "SMPTE ST 2067-8 Lt-Rt")
C(030202200A000000, "SMPTE ST 2067-8 5.1EX")
C(030202200B000000, "SMPTE ST 2067-8 Hearing Accessibility")
C(030202200C000000, "SMPTE ST 2067-8 Visual Accessibility")
C(0302022100000000, "IAB Soundfield")
C(0302022200000000, "MGA Soundfield")
C(0302023001000000, "ST377-42 Soundfield Groups")
C(0302023001010000, "6.0 Height")
C(0302023001020000, "8.0 Height")
C(0302023001030000, "9.1 Overhead")
C(0302023001040000, "9.1 Height")
C(0302023001050000, "10.1 Height")
C(0302023001060000, "11.1 Height")
C(0302023001070000, "13.1 Height")
C(0302023001080000, "15.1 Height")
C(0302023001090000, "12.0 Center Height")
C(03020230010A0000, "12.1	Center Height")
C(03020230010B0000, "6.0 Center Height")
C(03020230010C0000, "6.1 Center Height")
C(03020230010D0000, "22.2 UHDTV")
C(0302030000000000, "Group of Soundfield Groups")
C(0302032000000000, "Group of Soundfield Groups for SMPTE ST 2067-8")
C(0302032001000000, "SMPTE ST 2067-8 Main Program")
C(0302032002000000, "SMPTE ST 2067-8 Descriptive Video Service")
C(0302032003000000, "SMPTE ST 2067-8 Dialog Centric Mix")
C(0302033001000000, "ST377-42 Group of Soundfield Groups")
C(0302033001010000, "Music and Effects with Optional")
C(0302033001020000, "DME")
C(0302033001030000, "NDME")
C(0400000000000000, "Parametric")
C(0401000000000000, "Picture Essence")
C(0401010000000000, "Fundamental Picture Characteristics")
C(0401010100000000, "Picture Source Characteristics")
C(0401010101000000, "Transfer Characteristic")
C(0401010101010000, "ITU-R BT.470 Transfer Characteristic")
C(0401010101020000, "ITU-R BT.709 Transfer Characteristic")
C(0401010101030000, "SMPTE 240M Transfer Characteristic")
C(0401010101040000, "SMPTE 274/296M Gamma")
C(0401010101050000, "ITU-R BT.1361 Transfer Characteristic")
C(0401010101060000, "Linear Transfer Characteristic")
C(0401010101070000, "SMPTE-DC28 DCDM Transfer Characteristic")
C(0401010101080000, "IEC 61966-2-4 xvYCC Transfer Characteristic")
C(0401010101090000, "ITU-R BT.2020 Transfer Characteristic")
C(04010101010A0000, "SMPTE ST 2084 Transfer Characteristic")
C(04010101010B0000, "Hybrid Log-Gamma OETF Transfer Characteristic")
C(04010101010C0000, "Gamma 2.6 Transfer Characteristic")
C(04010101010D0000, "sRGB Transfer Characteristic")
C(04010101010E0000, "SMPTE ST 2115 Camera Log S3 Transfer Characteristic")
C(04010101010F0000, "SMPTE ST 2115 Camera Log V Transfer Characteristic")
C(0401010101100000, "SMPTE ST 2115 Camera Log C2 Transfer Characteristic")
C(0401010101110000, "SMPTE ST 2115 Camera Log C3 Transfer Characteristic")
C(0401010101120000, "Cinema Mezzanine Linear Transfer Characteristic")
C(0401010101130000, "Cinema Mezzanine DCDM Transfer Characteristic")
C(0401010102000000, "Coding Equations")
C(0401010102010000, "ITU-R BT.601 Coding Equations")
C(0401010102020000, "ITU-R BT.709 Coding Equations")
C(0401010102030000, "SMPTE 240M Coding Equations")
C(0401010102040000, "YCgCo Coding Equations")
C(0401010102050000, "GBR Coding Equations")
C(0401010102060000, "ITU-R BT.2020 Non-Constant Luminance Coding Equations")
C(0401010102070000, "ITU-R BT.2100 ICtCp Coding Equations")
C(0401010103000000, "Color Primaries")
C(0401010103010000, "SMPTE 170M Color Primaries")
C(0401010103020000, "ITU-R BT.470 PAL Color Primaries")
C(0401010103030000, "ITU-R BT.709 Color Primaries")
C(0401010103040000, "ITU-R BT.2020 Color Primaries")
C(0401010103050000, "SMPTE-DC28 DCDM Color Primaries")
C(0401010103060000, "P3D65 Color Primaries")
C(0401010103070000, "ACES Color Primaries")
C(0401010103080000, "Cinema Mezzanine Color Primaries")
C(0401010103090000, "P3D60 Color Primaries")
C(04010101030A0000, "P3DCI Color Primaries")
C(04010101030B0000, "SMPTE ST 2115 Camera Gamut S3 Color Primaries")
C(04010101030C0000, "SMPTE ST 2115 Camera Gamut SC Color Primaries")
C(04010101030D0000, "SMPTE ST 2115 Camera Gamut V Color Primaries")
C(04010101030E0000, "SMPTE ST 2115 Camera Gamut C Color Primaries")
C(0401010104000000, "Alternative Center Cut")
C(0401010104010000, "4:3 Alternative Center Cut")
C(0401010104020000, "14:9 Alternative Center Cut")
C(0401020000000000, "Picture Coding Characteristics")
C(0401020100000000, "Uncompressed Picture Coding")
C(0401020200000000, "Compressed Picture Coding")
C(0401020201000000, "MPEG Compression")
C(0401020201010000, "MPEG-2 MP-ML")
C(0401020201020000, "MPEG-2 422P-ML")
C(0401020201030000, "MPEG-2 MP-HL")
C(0401020201040000, "MPEG-2 422P-HL")
C(0401020201050000, "MPEG-2 MP-H14")
C(0401020201060000, "MPEG-2 HP-ML")
C(0401020201070000, "MPEG-2 HP-HL")
C(0401020201080000, "MPEG-2 HP-H14")
C(0401020201090000, "MPEG-2 Other")
C(0401020201100000, "MPEG-1 Video")
C(0401020201200000, "MPEG-4 Part2 Video")
C(0401020201300000, "H.264/MPEG-4 AVC Video")
C(0401020201310000, "H.264/MPEG-4 AVC Predictive Profiles")
C(0401020201320000, "H.264/MPEG-4 AVC Intra Profiles")
C(0401020201400000, "H.265/HEVC Video")
C(0401020201410000, "H.265/HEVC Main Profiles")
C(0401020201420000, "H.265/HEVC Main 4:2:2 Profiles")
C(0401020201430000, "H.265/HEVC Main 4:4:4 Profiles")
C(0401020201440000, "H.265/HEVC Main Intra Profiles")
C(0401020201450000, "H.265/HEVC Main 4:2:2 Intra Profiles")
C(0401020201460000, "H.265/HEVC Main 4:4:4 Intra Profiles")
C(0401020202000000, "DV Video Compression")
C(0401020203000000, "Individual Picture Coding Schemes")
C(0401020203010000, "JPEG 2000 Picture Coding Scheme")
C(0401020203020000, "TIFF/EP Picture Coding Scheme")
C(0401020203030000, "VC-2 Picture Coding Scheme")
C(0401020203040000, "ACES Picture Coding Schemes")
C(0401020203050000, "VC-5 Picture Coding Scheme")
C(0401020203060000, "ProRes Picture Coding Scheme")
C(0401020203070000, "DNxUncompressed Picture Coding")
C(0401020203080000, "JPEG XS Picture Coding Schemes")
C(0401020203090000, "FFV1PictureCoding")
C(0401020270000000, "Specialised Compression Schemes")
C(0401020270010000, "SMPTE D-11 Compression")
C(0401020271000000, "SMPTE VC-3 Compression")
C(0401020272000000, "SMPTE VC-1 Compression")
C(0402000000000000, "Sound Essence")
C(0402020000000000, "Sound Coding Characteristics")
C(0402020100000000, "Uncompressed Sound Coding")
C(0402020101000000, "SMPTE-382M Default Uncompressed Sound Coding")
C(0402020102000000, "MGA Audio Essence Sound Coding Schemes")
C(0402020102010000, "MGA Audio Essence Uncompressed Sound Coding")
C(040202017E000000, "AIFF Uncompressed Coding")
C(040202017F000000, "Undefined Sound Coding")
C(0402020200000000, "Compressed Sound Coding")
C(0402020203000000, "Compressed Audio Coding")
C(0402020203010000, "Companded Audio Coding")
C(0402020203010100, "A-law Coded Audio default")
C(0402020203011000, "DV Compressed Audio")
C(0402020203020000, "SMPTE ST 338 Audio per ST 337 Coding")
C(0402020203020100, "ATSC A-52 Compressed Audio")
C(0402020203020400, "MPEG-1 Layer-1 Compressed Audio")
C(0402020203020500, "MPEG-1 Layer-1 or 2 Compressed Audio")
C(0402020203020600, "MPEG-2 Layer-1 Compressed Audio")
C(0402020203021C00, "Dolby-E Compressed Audio")
C(0402020203030000, "Non SMPTE ST 338 MPEG-2 Coding")
C(0402020203030100, "MPEG-2 AAC Compressed Audio")
C(0402020204000000, "MPEG Audio Compression")
C(0402020204010000, "MPEG-1 Audio Coding")
C(0402020204020000, "MPEG-2 Audio Coding")
C(0402020204030000, "MPEG-2 Advanced Audio Coding")
C(0402020204040000, "MPEG-4 Advanced Audio Coding")
C(0403000000000000, "Data Essence")
C(0403010000000000, "Generic Event Text Essence")
C(0403010100000000, "Generic Subtitle  Essence")
C(0403010101000000, "EBU-t3264 STL Subtitle Essence")
C(0403010200000000, "Generic Captions Essence")
C(0403010201000000, "EBU-t3264 STL Captions Essence")
C(0403020000000000, "Data Essence Coding Characteristics")
C(0403021000000000, "Data Track Labeling")
C(0403021001000000, "Data Track Labeling SMPTE ST 2070")
C(0403021001010000, "Left Eye Data Track")
C(0403021001020000, "Right Eye Data Track")
C(0403030100000000, "Data Stream Data Essence Coding")
C(0404000000000000, "Metadata")
C(0404010000000000, "Fundamental Metadata Characteristics")
C(0404010100000000, "Static Metadata")
C(0404010200000000, "Dynamic Metadata")
C(0404010201000000, "Repetitive Timing Metadata")
C(0404010201010000, "SMPTE-12M Inactive User Bits")
C(0404010201010100, "SMPTE-12M 23.98fps Inactive User Bits Drop Frame Inactive")
C(0404010201010101, "SMPTE-12M 23.98fps Inactive User Bits Drop Frame Active")
C(0404010201010200, "SMPTE-12M 24fps Inactive User Bits No Drop Frame")
C(0404010201010300, "SMPTE-12M 25fps Inactive User Bits No Drop Frame")
C(0404010201010400, "SMPTE-12M 29.97fps Inactive User Bits Drop Frame Inactive")
C(0404010201010401, "SMPTE-12M 29.97fps Inactive User Bits Drop Frame Active")
C(0404010201010500, "SMPTE-12M 30fps Inactive User Bits No Drop Frame")
C(0404010201020000, "SMPTE-12M Active User Bits")
C(0404010201020100, "SMPTE-12M 23.98fps Active User Bits Drop Frame Inactive")
C(0404010201020101, "SMPTE-12M 23.98fps Active User Bits Drop Frame Active")
C(0404010201020200, "SMPTE-12M 24fps Active User Bits No Drop Frame")
C(0404010201020300, "SMPTE-12M 25fps Active User Bits No Drop Frame")
C(0404010201020400, "SMPTE-12M 29.97fps Active User Bits Drop Frame Inactive")
C(0404010201020401, "SMPTE-12M 29.97fps Active User Bits Drop Frame Active")
C(0404010201020500, "SMPTE-12M 30fps Active User Bits No Drop Frame")
C(0404010201030000, "SMPTE-12M Datecode User Bits")
C(0404010201030100, "SMPTE-12M 23.98fps Datecode User Bits Drop Frame Inactive")
C(0404010201030101, "SMPTE-12M 23.98fps Datecode User Bits Drop Frame Active")
C(0404010201030200, "SMPTE-12M 24fps Datecode User Bits No Drop Frame")
C(0404010201030300, "SMPTE-12M 25fps Datecode User Bits No Drop Frame")
C(0404010201030400, "SMPTE-12M 29.97fps Datecode User Bits Drop Frame Inactive")
C(0404010201030401, "SMPTE-12M 29.97fps Datecode User Bits Drop Frame Active")
C(0404010201030500, "SMPTE-12M 30fps Datecode User Bits No Drop Frame")
C(0404010202000000, "DMCVT Data Coding")
C(0404010202010000, "DMCVT Application 1")
C(0404010202020000, "DMCVT Application 2")
C(0404010202030000, "DMCVT Application 3")
C(0404010202040000, "DMCVT Application 4")
C(0404020000000000, "Audio Metadata")
C(0404020100000000, "Config Payload")
C(0404020200000000, "Sync Payload")
C(0404020300000000, "CRC Payload")
C(0404020400000000, "PMD Version")
C(0404020500000000, "Audio Bed Description")
C(0404020600000000, "Audio Object Description")
C(0404020700000000, "Audio Presentation Description")
C(0404020800000000, "Audio Presentation Names")
C(0404020900000000, "Audio Element Names")
C(0404020A00000000, "ED2 Substream Description")
C(0404020B00000000, "ED2 Substream Names")
C(0404020C00000000, "EAC3 Encoding Parameters")
C(0404020D00000000, "Dynamic Position Update")
C(0404020E00000000, "Identity And Timing")
C(0404020F00000000, "Presentation Loudness Description")
C(0404021000000000, "ED2 Turnaround Description")
C(0404021100000000, "Headphone Element Description")
C(0404021200000000, "Serial Audio Definition Model Metadata Payload")
C(0405000000000000, "Compound Essence")
C(0410000000000000, "General Data")
C(0410010101000000, "Viewing Environment")
C(0410010101010000, "Theatrical Viewing Environment")
C(0410010101020000, "HDTV Reference Viewing Environment")
C(0410010101030000, "HDR Reference Viewing Environment")
C(0500000000000000, "Process")
C(0510000000000000, "Settings")
C(0510010000000000, "Device Settings")
C(0510010100000000, "Camera Settings")
C(0510010101000000, "Exposure Settings")
C(0510010101010000, "Manual Exposure")
C(0510010101020000, "Full Auto Exposure")
C(0510010101030000, "Gain Priority Auto Exposure")
C(0510010101040000, "Iris Priority Auto Exposure")
C(0510010101050000, "Shutter Priority Auto Exposure")
C(0600000000000000, "Relational")
C(0700000000000000, "Spatio-temporal")
C(0C00000000000000, "Compound")
C(0D00000000000000, "Organizationally Registered for Public Use")
C(0D01000000000000, "AAF Association")
C(0D01010000000000, "AAF Structural Metadata")
C(0D01010100000000, "AAF Structural Metadata Version 1")
C(0D01010101000000, "AAF Version 1 Standard")
C(0D01010101010000, "AAF Version 1 Standard Kinds")
C(0D01010201010100, "OperationCategory Effect")
C(0D01010201010200, "PluginCategory Effect")
C(0D01010201010300, "PluginCategory Codec")
C(0D01010201010400, "PluginCategory Interpolation")
C(0D01010201010500, "Usage SubClip")
C(0D01010201010600, "Usage AdjustedClip")
C(0D01010201010700, "Usage TopLevel")
C(0D01010201010800, "Usage LowerLevel")
C(0D01010201010900, "Usage Template")
C(0D01020000000000, "MXF Operational Pattern Application")
C(0D01020100000000, "MXF OP Structure Version 1")
C(0D01020101000000, "MXF OP1x SingleItem")
C(0D01020101010000, "MXF OP1a SingleItem SinglePackage")
C(0D01020101020000, "MXF OP1b SingleItem GangedPackages")
C(0D01020101030000, "MXF OP1c SingleItem AlternatePackages")
C(0D01020102000000, "MXF OP2x PlaylistItems")
C(0D01020102010000, "MXF OP2a PlaylistItems SinglePackage")
C(0D01020102020000, "MXF OP2b PlaylistItems GangedPackages")
C(0D01020102030000, "MXF OP2c PlaylistItems AlternatePackages")
C(0D01020103000000, "MXF OP3x EditItems")
C(0D01020103010000, "MXF OP3a EditItems SinglePackage")
C(0D01020103020000, "MXF OP3b EditItems GangedPackages")
C(0D01020103030000, "MXF OP3c EditItems AlternatePackages")
C(0D01020110000000, "MXF-OP Atom 1 Track 1 SourceClip")
C(0D01020110010000, "MXF-OP Atom 1 Track N SourceClips")
C(0D01020110020000, "MXF-OP Atom N Tracks 1 SourceClip")
C(0D01020110030000, "MXF-OP Atom N Tracks N SourceClips")
C(0D01030000000000, "MXF Essence Containers")
C(0D01030100000000, "MXF Essence Containers Version 1")
C(0D01030101000000, "MXF Generic Container (Deprecated)")
C(0D01030102000000, "MXF Generic Container")
C(0D01030102010000, "MXF-GC SMPTE D-10 Mappings")
C(0D01030102020000, "MXF-GC DV-DIF Mappings")
C(0D01030102030000, "MXF-GC SMPTE D-11 Mappings")
C(0D01030102040000, "MXF-GC MPEG ES")
C(0D01030102050000, "MXF-GC Uncompressed Pictures")
C(0D01030102060000, "MXF-GC AES-BWF Audio")
C(0D01030102070000, "MXF-GC MPEG PES")
C(0D01030102080000, "MXF-GC MPEG PS")
C(0D01030102090000, "MXF-GC MPEG TS")
C(0D010301020A0000, "MXF-GC A-law Audio Mappings")
C(0D010301020B0000, "MXF-GC Encrypted Data Mappings")
C(0D010301020C0000, "MXF-GC JPEG-2000 Picture Mappings")
C(0D010301020D0000, "MXF-GC Generic VBI Data Mapping Undefined Payload")
C(0D010301020E0000, "MXF-GC Generic ANC Data Mapping Undefined Payload")
C(0D010301020F0000, "MXF-GC AVC NAL Unit Stream")
C(0D01030102100000, "MXF-GC AVC Byte Stream")
C(0D01030102110000, "MXF-GC VC-3 Pictures")
C(0D01030102120000, "MXF-GC VC-1 Pictures")
C(0D01030102130000, "MXF-GC Generic Data")
C(0D01030102140000, "MXF-GC TIFF/EP")
C(0D01030102150000, "MXF-GC VC-2 Pictures")
C(0D01030102160000, "MXF-GC AAC ADIF")
C(0D01030102170000, "MXF-GC AAC ADTS")
C(0D01030102180000, "MXF-GC AAC LATM-LOAS")
C(0D01030102190000, "MXF-GC ACES Pictures")
C(0D010301021A0000, "MXF-GC DMCVT Data")
C(0D010301021B0000, "MXF-GC VC-5 Essence Container Label (SMPTE ST 2073-10)")
C(0D010301021C0000, "MXF-GC Essence Container ProRes Picture")
C(0D010301021D0000, "MXF-GC Immersive Audio")
C(0D010301021E0000, "MXF-GC Essence Container DNxPacked")
C(0D010301021F0000, "MXF-GC HEVC NAL Unit Stream")
C(0D01030102200000, "MXF-GC HEVC Byte Stream")
C(0D01030102210000, "MXF-GC JPEG XS Pictures")
C(0D01030102230000, "MXFGCFFV1Pictures")
C(0D01030102250000, "MXF-GC MGA Audio Mappings")
C(0D010301027F0000, "MXF-GC Generic Essence Mappings")
C(0D01030103000000, "MXF Generic Stream Essence Mappings")
C(0D01030103010000, "MXF-GS EBU-t3264 STL Byte Stream")
C(0D01040000000000, "MXF Descriptive Metadata Schemes")
C(0D01040100000000, "MXF-DMS Structure Version 1")
C(0D01040101000000, "MXF DMS-1")
C(0D01040101010000, "MXF DMS-1 Version 1")
C(0D01040101010100, "MXF DMS-1 Version 1 constrained")
C(0D01040101010200, "MXF DMS-1 Version 1 extended")
C(0D01040101020000, "MXF DMS-1 Version-2")
C(0D01040101020100, "DMS-1 Framework Identifier")
C(0D01040101020101, "MXF DMS-1 Production Framework standard")
C(0D01040101020102, "MXF DMS-1 Production Framework extended")
C(0D01040101020201, "MXF DMS-1 Clip Framework standard")
C(0D01040101020202, "MXF DMS-1 Clip Framework extended")
C(0D01040101020301, "MXF DMS-1 Scene Framework standard")
C(0D01040101020302, "MXF DMS-1 Scene Framework extended")
C(0D01040102000000, "MXF Cryptographic DM Scheme")
C(0D01040102010000, "MXF Cryptographic Scheme Version 1")
C(0D01040102010100, "MXF Cryptographic Framework Label")
C(0D01040103000000, "DMS AS-03")
C(0D01040104000000, "MXF Text-Based DM Scheme")
C(0D01040104010000, "MXF Text-Based DM Scheme Version 1")
C(0D01040104010100, "MXF Text-Based Framework")
C(0D01040105000000, "MXF EIDR DM Scheme")
C(0D01040105010000, "MXF EIDR DM Scheme Version 1")
C(0D01050000000000, "MXF Generic Stream Metadata Mappings")
C(0D01050100000000, "MXF Generic Stream Metadata Version 1 Mappings")
C(0D01060000000000, "MXF Application Metadata Schemes")
C(0D01060100000000, "Application Metadata Schemes Version 1")
C(0D01070000000000, "AMWA Application Specifications")
C(0D01070100000000, "Application Specifications Version 1")
C(0D01070107000000, "AS_07")
C(0D01070107010000, "AS_07_Core_DMS")
C(0D01070107020000, "AS_07_GSP_DMS")
C(0D01070107030000, "AS_07_Segmentation_DMS")
C(0D0107010A000000, "AS-10")
C(0D0107010A010000, "DMS AS-10 Core")
C(0D0107010B000000, "AS-11")
C(0D0107010B010000, "DM_AS_11_Core")
C(0D0107010B020000, "DM_AS_11_Segmentation")
C(0D0107010C000000, "AS-12")
C(0D0107010C010000, "DMS_AS_12")
C(0D01080000000000, "AMWA Rules Based Specifications")
C(0D01080100000000, "Rules Based Specifications Version 1")
C(0D01080101000000, "Sound Essence")
C(0D01080101010000, "Audio Channel")
C(0D01080101010100, "Audio Description Studio Signal Data Channel")
C(0D01080101020000, "Soundfield Group")
C(0D01080101020100, "Audio Description Studio Signal")
C(0D01080101030000, "Group of Soundfield Groups")
C(0D01080101030100, "Alternative Program")
C(0D01080101030200, "Audio Description Program Mix")
C(0D01080101030300, "Audio Description")
C(0D01080101030400, "Music and Effects")
C(0D01080101030500, "Unused Audio")
C(0D01080102000000, "Labels for Sound Channel Labeling")
C(0D01080102010000, "Constrained Multichannel Audio Labeling Framework")
C(0D01080102020000, "ConstrainedMultichannelAudioLabelingFramework with Default Audio Layout A")
C(0D01080102030000, "Default Audio Layout A without MCA Labeling")
C(0D01080103000000, "Specification Identification (Work In Progress)")
C(0D01080103010000, "Blocks File Format 0 WIP")
C(0D01080103020000, "Blocks File Format 1 WIP")
C(0D01080103030000, "Blocks File Format 2 WIP")
C(0D01080103040000, "Blocks File Format 8 WIP")
C(0D01080103050000, "Blocks File Format 12 WIP")
C(0D01080103060000, "Blocks File Format 5 WIP")
C(0D01080103070000, "Blocks File Format 6 WIP")
C(0D01080103080000, "Blocks File Format 7 WIP")
C(0D01080103090000, "Blocks File Format 10 WIP")
C(0D010801030A0000, "Blocks File Format 9 WIP")
C(0D010801030B0000, "Blocks File Format 11 WIP")
C(0D010801030C0000, "Blocks File Format 13 WIP")
C(0D010801030E0000, "Blocks File Format 14 WIP")
C(0D01080104000000, "Metadata Payload Schemes")
C(0D01080104010000, "DM_XML_Document")
C(0D01080105000000, "Specification Identification")
C(0D01080105010000, "Blocks File Format 0")
C(0D01080105020000, "Blocks File Format 1")
C(0D01080105030000, "Blocks File Format 2")
C(0D01080105050000, "Blocks File Format 12")
C(0D01080105080000, "Blocks File Format 7")
C(0D01080105090000, "Blocks File Format X9")
C(0D010801050E0000, "Blocks File Format 14")
C(0D01120000000000, "Operational Pattern Application")
C(0D01120100000000, "AAF OP-Structure Version")
C(0D01120101000000, "AAF Edit Protocol")
C(0D01120102000000, "AAF Unconstrained OP")
C(0D01130000000000, "AAF Containers")
C(0D01130100000000, "AAF Containers Version 1")
C(0D01130101000000, "AAF Containers V1-Physical")
C(0D01130101010000, "AAF RIFF Container")
C(0D01130101010100, "RIFF WAVE Container")
C(0D01130101020000, "AAF JFIF Container")
C(0D01130101020100, "AAF Frame-wrapped JFIF Container")
C(0D01130101020200, "AAF Clip-wrapped JFIF Container")
C(0D01130101030000, "AAF NITF Container")
C(0D01130101030200, "AAF Clip-wrapped NITF Container")
C(0D01130101040000, "AAF AIFF-AIFC Container")
C(0D01130101040100, "AAF AIFF-AIFC Audio Container")
C(0D02000000000000, "EBU/UER")
C(0D02010000000000, "EBUCore")
C(0D03000000000000, "Pro-MPEG Forum")
C(0D04000000000000, "BBC")
C(0D04010000000000, "Archive Preservation Project")
C(0D04010100000000, "Archive Preservation Project Version 1")
C(0D04010101000000, "APP Descriptive Schemes")
C(0D04010101010000, "APP Descriptive Schemes Version 1")
C(0D04010101010100, "APP Preservation Descriptive Scheme")
C(0D05000000000000, "IRT")
C(0D06000000000000, "ARIB")
C(0D07000000000000, "AMIA")
C(0D08000000000000, "PBS")
C(0D09000000000000, "ASC")
C(0D0A000000000000, "AES")
C(0D0A010000000000, "AES file exchange")
C(0D0A010100000000, "AES ADL")
C(0D0B000000000000, "Dutch Guild")
C(0D0C000000000000, "DPP")
C(0D0C010000000000, "DPP Schemes")
C(0D0C010100000000, "AS-11 UKDPP")
C(0D0C010101000000, "DM_AS_11_UKDPP")
C(0D0D000000000000, "Ad-ID")
C(0D0E000000000000, "LOC_Labels")
C(0D0E010000000000, "LOC_ApplicationSpecifications_Labels")
C(0D0E010100000000, "LOC_ApplicationSpecifications_Labels_V1")
C(0D0E010107000000, "AS_07_Labels")
C(0D0E010107020000, "AS_07_AudioLabels")
C(0D0E010107020400, "AS_07_AudioLayouts")
C(0D0E010107020401, "AS_07_AudioLayoutSilence")
C(0D0E010107020402, "AS_07_AudioLayoutUnknown")
C(0D0E010107020403, "AS_07_AudioLayout1TrackUndef")
C(0D0E010107020404, "AS_07_AudioLayout2TrackUndef")
C(0D0E010107020405, "AS_07_AudioLayout3TrackUndef")
C(0D0E010107020406, "AS_07_AudioLayout4TrackUndef")
C(0D0E010107020407, "AS_07_AudioLayout1TrackAudio")
C(0D0E010107020408, "AS_07_AudioLayout2TracksAudio")
C(0D0E010107020409, "AS_07_AudioLayout1TrackAudio1TrackTimecode")
C(0D0E01010702040A, "AS_07_AudioLayout3TracksAudio")
C(0D0E01010702040B, "AS_07_AudioLayout2TrackAudio1TrackTimecode")
C(0D0E01010702040C, "AS_07_AudioLayout4TrackAudio")
C(0D0E01010702040D, "AS_07_AudioLayout3TrackAudio1TrackTimecode")
C(0D0E010107020410, "AS_07_AudioLayoutEBU48_2a")
C(0D0E010107020411, "AS_07_AudioLayoutEBU123_4b")
C(0D0E010107020412, "AS_07_AudioLayoutEBU123_4c")
C(0D0E010107020413, "AS_07_AudioLayoutEBU123_16c")
C(0D0E010107020414, "AS_07_AudioLayoutEBU123_16d")
C(0D0E010107020415, "AS_07_AudioLayoutEBU123_16f")
C(0D0E010107020420, "AS_07_AudioLayoutST377_4MCA")
C(0D0E010107040000, "AS_07_Modal_Labels")
C(0D0E010107040100, "AS_07_MICCarriage_Labels")
C(0D0E010107040101, "MICCarriage_SystemItem")
C(0D0E010107040200, "AS_07_MICCarriage_Algorithms")
C(0D0E010107040201, "MIC Algorithm CRC32C")
C(0D0F000000000000, "Inter-Society Digital Cinema Forum")
C(0D0F030000000000, "Interpretive")
C(0D0F030200000000, "Sound Essence")
C(0D0F030201000000, "Audio Channel")
C(0D0F030201010000, "Sign Language Video Stream")
C(0E00000000000000, "Organizationally Registered as Private")
C(0E01000000000000, "MISB Systems")
C(0E02000000000000, "ASPA")
C(0E03000000000000, "MISB Classified")
C(0E04000000000000, "Avid Technology, Inc.")
C(0E04030102060000, "")
C(0E05000000000000, "CNN")
C(0E06000000000000, "Sony Corporation")
C(0E060D0302010000, "Sony RAW SQ")
C(0E07000000000000, "IdeasUnlimited.TV")
C(0E08000000000000, "IPV Ltd")
C(0E09000000000000, "Dolby Laboratories Inc.")
C(0E09010104010000, "Audio Channel Left Wide")
C(0E09010104020000, "Audio Channel Right Wide")
C(0E09010104030000, "Audio Channel Left Top Front")
C(0E09010104040000, "Audio Channel Right Top Front")
C(0E09010104050000, "Audio Channel Top Side Left")
C(0E09010104060000, "Audio Channel Top Side Right")
C(0E09010104070000, "Audio Channel Left Top Back")
C(0E09010104080000, "Audio Channel Right Top Back")
C(0E09010105020000, "Soundfield Group 5.1.4")
C(0E09010105040000, "Soundfield Group 7.1.4")
C(0E09010105060000, "Soundfield Group 9.1.4")
C(0E09010105070000, "Soundfield Group 9.1.6")
C(0E09060400000000, "Immersive Audio Coding")
C(0E09060500000000, "MXF-GC IAData Frame Wrapped")
C(0E09060600000000, "UTF-8 Text Data Essence Coding")
C(0E09060701010101, "PHDR Image Metadata Wrapping Frame")
C(0E09060701010103, "Frame Wrapped ISXD Container")
C(0E0A000000000000, "Snell & Wilcox")
C(0E0B000000000000, "Omneon Video Networks")
C(0E0C000000000000, "Ascent Media Group, Inc.")
C(0E0D000000000000, "Quantel Ltd")
C(0E0E000000000000, "Panasonic")
C(0E0F000000000000, "Grass Valley, Inc.")
C(0E10000000000000, "Doremi Labs, Inc.")
C(0E11000000000000, "EVS Broadcast Equipment")
C(0E12000000000000, "Turner Broadcasting System, Inc.")
C(0E13000000000000, "NL Technology, LLC")
C(0E14000000000000, "Harris Corporation")
C(0E15000000000000, "Canon, Inc.")
C(0E16000000000000, "D-BOX Technologies")
C(0E17000000000000, "ARRI")
C(0E18000000000000, "JVC")
C(0E19000000000000, "3ality Technica")
C(0E1A000000000000, "NHK")
C(0E1B000000000000, "HBO")
C(0E1D000000000000, "DTS, Inc.")
C(0E1E000000000000, "FLIR Systems, Inc.")
C(0E1F000000000000, "Barco")
C(0E20000000000000, "Apple Inc.")
C(0E21000000000000, "Fraunhofer")
C(0E22000000000000, "RED")
C(0E23000000000000, "CRIFST")
C(0E23060701010103, "HDR Vivid Metadata Wrapping Frame")
C(0F00000000000000, "Experimental")
    default: return {};
    }
}

const char* Mxf_Param_Info(int32u CategoryRegistryStructureVersion, int64u Value)
{
    switch (CategoryRegistryStructureVersion >> 8)
    {
    case 0x010101: return Mxf_Param_Info_Elements(Value);
    case 0x010201: return Mxf_Param_Info_Essences(Value);
    case 0x020401:
    case 0x020501:
    case 0x024301:
    case 0x025301:
    case 0x026301:
    case 0x027301: return Mxf_Param_Info_Groups(Value);
    case 0x040101: return Mxf_Param_Info_Labels(Value);
    default: return {};
    }
}
const char* Mxf_Param_Name_Elements(int64u Value)
{
    switch (Value)
    {
C(0000000000000000, "Item Designator")
C(0D00000000000000, "Organization")
C(0D01000000000000, "Application")
C(0D01040100000000, "Scheme Kind")
C(0E00000000000000, "Organization")
    default: return {};
    }
}

const char* Mxf_Param_Name_Essences(int64u Value)
{
    switch (Value)
    {
C(0000000000000000, "Item Designator")
C(0D00000000000000, "Organization")
C(0D01000000000000, "Application")
C(0D01030000000000, "Version")
C(0D01030100000000, "Item Type identifier")
C(0E00000000000000, "Organization")
    default: return {};
    }
}

const char* Mxf_Param_Name_Groups(int64u Value)
{
    switch (Value)
    {
C(0000000000000000, "Item Designator")
C(0D00000000000000, "Organization")
C(0D01000000000000, "Application")
C(0D01020000000000, "Version")
C(0D01020100000000, "Kind")
C(0D01020101000000, "Set / Pack Kind")
C(0D01020101010000, "Partition Status")
C(0D01020101020000, "Partition Status")
C(0D01020101020100, "Partition Status")
C(0D01020101020200, "Partition Status")
C(0D01020101020300, "Partition Status")
C(0D01020101020400, "Partition Status")
C(0D01020101030000, "Partition Status")
C(0D01020101030100, "Partition Status")
C(0D01020101030200, "Partition Status")
C(0D01020101030300, "Partition Status")
C(0D01020101030400, "Partition Status")
C(0D01020101031100, "Partition Status")
C(0D01020101040000, "Partition Status")
C(0D01020101040200, "Partition Status")
C(0D01020101040400, "Partition Status")
C(0D01020101050000, "Version of the Primer Pack")
C(0D01030000000000, "Version")
C(0D01030100000000, "Item Type Identifier")
C(0D01030104000000, "System Scheme Identifier")
C(0D01030104010000, "Metadata Element Identifier")
C(0D01030104010200, "Metadata Block Count")
C(0D01030104010300, "Metadata Block Count")
C(0D01030104010400, "Metadata Block Count")
C(0D01030104010500, "Metadata Block Count")
C(0D01030104010600, "Metadata Block Count")
C(0E00000000000000, "Organization")
    default: return {};
    }
}

const char* Mxf_Param_Name_Labels(int64u Value)
{
    switch (Value)
    {
C(0000000000000000, "Item Designator")
C(0D00000000000000, "Organization")
C(0D01000000000000, "Application")
C(0D01020000000000, "Version")
C(0D01020100000000, "Item Complexity")
C(0D01020101000000, "Package Complexity")
C(0D01020101010000, "Qualifier")
C(0D01020101020000, "Qualifier")
C(0D01020101030000, "Qualifier")
C(0D01020102000000, "Package Complexity")
C(0D01020102010000, "Qualifier")
C(0D01020102020000, "Qualifier")
C(0D01020102030000, "Qualifier")
C(0D01020103000000, "Package Complexity")
C(0D01020103010000, "Qualifier")
C(0D01020103020000, "Qualifier")
C(0D01020103030000, "Qualifier")
C(0D01030000000000, "Structure Version")
C(0D01030100000000, "Essence container Kind")
C(0D01030102000000, "Mapping Kind")
C(0D01030102060000, "Wrapping Kind")
C(0E00000000000000, "Organization")
    default: return {};
    }
}

const char* Mxf_Param_Name_Defaults[] = {
    "Code (0)",
    "Code (1)",
    "Code (2)",
    "Code (3)",
    "Code (4)",
    "Code (5)",
    "Code (6)",
    "Code (7)",
};
const char* Mxf_Param_Name(int32u CategoryRegistryStructureVersion, int64u Value)
{
    const char* Result;
    switch (CategoryRegistryStructureVersion >> 8)
    {
    case 0x010101: Result = Mxf_Param_Name_Elements(Value); break;
    case 0x010201: Result = Mxf_Param_Name_Essences(Value); break;
    case 0x020401:
    case 0x020501:
    case 0x024301:
    case 0x025301:
    case 0x026301:
    case 0x027301: Result = Mxf_Param_Name_Groups(Value); break;
    case 0x040101: Result = Mxf_Param_Name_Labels(Value); break;
    default: Result = {};
    }
    if (!Result) {
        int Offset = 0;
        while (Value) {
            Value <<= 8;
            Offset++;
        }
        Result = Mxf_Param_Name_Defaults[Offset];
    }
    return Result;
}
namespace Elements
{
//      00 - Elements
//      01 - Identification and location
//        01 - Globally Unique Identifiers
//          05 - UMID Picture
//          06 - UMID Multi Picture
//          08 - UMID Sound
//          09 - UMID Multi Sound
//          0B - UMID Single Data
//          0C - UMID Multi Data
//          0D - UMID Mixed
//          0F - UMID General
//          10 - International Broadcasting Organization Identifiers
U(0101100100000000, OrganizationID_ISO7)
U(0101100101000000, OrganizationID)
U(0101100200000000, OrganizationIDKind_ISO7)
U(0101100201000000, OrganizationIDKind)
//            03 - Program Identifiers
U(0101100301000000, UPID)
U(0101100302000000, UPN)
U(0101100303000000, ProgramNumber_ISO7)
//            04 - Physical Media Identifiers
//              01 - Tape Identifiers
U(0101100401010000, IBTN)
//          11 - International Standard Identifiers
U(0101110100000000, ISAN)
U(0101110200000000, ISBN)
U(0101110300000000, ISSN)
U(0101110400000000, ISWC)
U(0101110500000000, ISMN)
U(0101110600000000, ISCI)
U(0101110700000000, ISRC)
U(0101110800000000, ISRN)
U(0101110900000000, ISBD)
U(0101110A00000000, ISTC)
U(0101110B00000000, CanonicalFullAdIDIdentifier)
U(0101110C00000000, CanonicalDOIName)
U(0101110D00000000, CanonicalEIDRIdentifier)
U(0101110E00000000, CompactAdIDIdentifier)
//          13 - International Standard Compound Identifiers
U(0101130100000000, SICI)
U(0101130200000000, BICI)
U(0101130300000000, AICI)
U(0101130400000000, PII)
//          15 - Object Identifiers
U(0101150100000000, DOI)
U(0101150200000000, InstanceID)
U(0101150300000000, DefinitionObjectIdentification)
U(0101150400000000, GlobalNumber_ISO7)
U(0101150800000000, ClipID)
U(0101150900000000, ExtendedClipID)
U(0101150A00000000, ClipIDArray)
U(0101150B00000000, ExtendedClipIDArray)
U(0101151000000000, PackageID)
U(0101151100000000, CryptographicContextID)
U(0101151200000000, ResourceID)
U(0101151300000000, AncillaryResourceID)
U(0101151400000000, EIDRDMSEssenceID)
//            40 - Globally Unique Object Identifiers
//              01 - Globally Unique Human Identifiers
U(0101154001010000, ParticipantID)
U(0101154001020000, ContactID)
//          20 - Device Identifiers
U(0101200100000000, DeviceDesignation)
U(0101200300000000, DeviceModel)
U(0101200400000000, DeviceSerialNumber)
U(0101200500000000, IEEEDeviceIdentifier)
U(0101200700000000, DeviceIDKind_ISO7)
U(0101200800000000, DeviceKind_ISO7)
U(0101200801000000, DeviceKind)
U(0101200802000000, DeviceKindCode)
U(0101200C00000000, DeviceAssetNumber)
//          21 - Platform Identifiers
U(0101210100000000, PlatformDesignation_ISO7)
U(0101210101000000, PlatformDesignation)
U(0101210200000000, PlatformModel_ISO7)
U(0101210300000000, PlatformSerialNumber_ISO7)
//        02 - Globally Unique Locators
//          01 - Uniform Resource Locators
U(0102010100000000, URL_ISO7)
U(0102010101000000, URL)
U(0102010200000000, PURL_ISO7)
U(0102010300000000, URN_ISO7)
U(0102010400000000, DefaultNamespaceURI_ISO7)
U(0102010401000000, DefaultNamespaceURI)
U(0102010500000000, NamespaceURI_ISO7)
U(0102010501000000, NamespaceURI)
U(0102010600000000, NamespaceURIs_ISO7)
U(0102010601000000, NamespaceURIs)
U(0102010802000000, CameraSettingFileURI)
//          02 - Registry Locators
U(0102020100000000, SMPTEUniversalLabelLocator)
U(0102020200000000, IdentificationLocator)
U(0102020300000000, OperationalPattern)
//            10 - Registry Locator Groups
//              01 - Registry Locator Ordered Group (Arrays)
U(0102021001010000, EssenceContainerArray)
//              02 - Registry Locator Unordered Groups
U(0102021002010000, EssenceContainers)
U(0102021002020000, DescriptiveSchemes)
U(0102021002030000, ApplicationSchemes)
U(0102021002040000, ConformsToSpecifications)
//        03 - Locally Unique Identifiers
//          01 - Administrative Identifiers
U(0103010100000000, TransmissionID_ISO7)
U(0103010200000000, ArchiveID_ISO7)
U(0103010300000000, ItemID_ISO7)
U(0103010400000000, AccountingReferenceNumber_ISO7)
U(0103010500000000, TrafficID_ISO7)
U(0103010600000000, ProjectNumber)
U(0103010700000000, LocalTargetID_ISO7)
U(0103010701000000, LocalTargetID)
U(0103010800000000, ProjectName_ISO7)
U(0103010801000000, ProjectName)
U(0103010900000000, NITFLayerTargetID_ISO7)
U(0103010901000000, NITFLayerTargetID)
//          02 - Local Physical Media Identifiers
//            01 - Local Film ID
U(0103020101000000, ReelOrRollNumber_ISO7)
U(0103020102000000, EdgeCodeHeader)
//            02 - Local Tape Identifiers
U(0103020201000000, LocalTapeNumber_ISO7)
//            03 - Disk Identifiers
//              01 - Magnetic Disks
U(0103020301010000, MagneticDiskNumber_ISO7)
//              02 - Optical Discs
U(0103020302010000, OpticalDiscNumber_ISO7)
//          03 - Local Object Identifiers
U(0103030100000000, LUID)
U(0103030200000000, PackageName_ISO7)
U(0103030201000000, PackageName)
//          04 - Network and Stream Identifiers
U(0103040100000000, ChannelHandle)
U(0103040200000000, StreamID)
U(0103040300000000, TransportStreamID)
U(0103040400000000, EssenceStreamID)
U(0103040500000000, IndexStreamID)
U(0103040600000000, RP217DataStreamPID)
U(0103040700000000, RP217VideoStreamPID)
U(0103040800000000, GenericStreamID)
U(0103040A00000000, MCAChannelID)
U(0103040B00000000, DataStreamID)
//          05 - Organizational Program Identifiers
U(0103050100000000, OrganizationalProgramNumber_ISO7)
U(0103050101000000, OrganizationalProgramNumber)
//          06 - Metadata Identifiers
U(0103060100000000, ItemDesignatorID)
U(0103060200000000, LocalTag)
U(0103060300000000, LocalTagUniqueID)
U(0103060400000000, HTMLDOCTYPE_ISO7)
U(0103060401000000, HTMLDOCTYPE)
U(0103060500000000, NamespacePrefix_ISO7)
U(0103060501000000, NamespacePrefix)
U(0103060600000000, NamespacePrefixes_ISO7)
U(0103060601000000, NamespacePrefixes)
//          07 - Channel Identifiers
//            01 - Audio Channel Identifiers
U(0103070101000000, MCALabelDictionaryID)
U(0103070102000000, MCATagSymbol)
U(0103070103000000, MCATagName)
U(0103070104000000, GroupOfSoundfieldGroupsLinkID)
U(0103070105000000, MCALinkID)
U(0103070106000000, SoundfieldGroupLinkID)
//            03 - Stereoscopic Channel Identifiers
U(0103070301000000, StereoscopicEyeID)
U(0103070302000000, StereoscopicDataEssenceCoding)
//          08 - Operation Message Identifiers
//            01 - Security Message Identifiers
U(0103080101000000, ASMRequestID)
U(0103080102000000, ASMEventID)
U(0103080103000000, ASMLinkEncryptionKeyID)
//        04 - Locally Unique Locators
//          01 - Media Locators
U(0104010100000000, LocalFilePath_ISO7)
U(0104010101000000, LocalFilePath)
U(0104010200000000, LocationName_ISO7)
U(0104010201000000, LocationName)
U(0104010300000000, EssenceTrackNumber)
U(0104010400000000, TrackNumberBatch)
U(0104010500000000, MCAPartitionKind)
U(0104010600000000, MCAPartitionNumber)
//          07 - Film Locators
U(0104070100000000, EdgeCode_ISO7)
U(0104070200000000, FrameCode_ISO7)
U(0104070300000000, KeyCode)
U(0104070400000000, InkNumber_ISO7)
//          09 - Synchronization Locators
U(0104090100000000, EdgeCodeStart)
//          10 - Proxy Locators
U(0104100100000000, KeyText_ISO7)
U(0104100200000000, KeyFrame_ISO7)
U(0104100300000000, KeySound_ISO7)
U(0104100400000000, KeyDataOrProgram_ISO7)
//        05 - Titles
U(0105010000000000, TitleKind_ISO7)
U(0105010100000000, TitleKind)
U(0105020000000000, MainTitle_ISO7)
U(0105020100000000, MainTitle)
U(0105030000000000, SecondaryTitle_ISO7)
U(0105030100000000, SecondaryTitle)
U(0105040000000000, SeriesNumber_ISO7)
U(0105040100000000, SeriesNumber)
U(0105050000000000, EpisodeNumber_ISO7)
U(0105050100000000, EpisodeNumber)
U(0105060000000000, SceneNumber)
U(0105060100000000, SceneNumber_UTF16String)
U(0105070000000000, TakeNumber)
U(0105080000000000, VersionTitle_ISO7)
U(0105080100000000, VersionTitle)
U(0105090000000000, MissionIdentifier_ISO7)
U(0105090100000000, MissionIdentifier)
U(01050A0000000000, WorkingTitle_ISO7)
U(01050A0100000000, WorkingTitle)
U(01050B0000000000, OriginalTitle_ISO7)
U(01050B0100000000, OriginalTitle)
U(01050C0000000000, ClipNumber)
U(01050C0100000000, ClipNumber_UTF16String)
U(01050D0000000000, BrandMainTitle_ISO7)
U(01050D0100000000, BrandMainTitle)
U(01050E0000000000, BrandOriginalTitle_ISO7)
U(01050E0100000000, BrandOriginalTitle)
U(01050F0000000000, FrameworkTitle_ISO7)
U(01050F0100000000, FrameworkTitle)
U(0105100000000000, MCATitle)
U(0105110000000000, MCATitleVersion)
U(0105120000000000, MCATitleSubVersion)
U(0105130000000000, MCAEpisode)
//        07 - Local Identifiers
//          01 - Package Identifiers
U(0107010100000000, TrackID)
U(0107010200000000, TrackName_ISO7)
U(0107010201000000, TrackName)
U(0107010203000000, DefinitionObjectName_ISO7)
U(0107010203010000, DefinitionObjectName)
U(0107010300000000, ContentPackageMetadataLink)
U(0107010400000000, DefinedName_ISO7)
U(0107010401000000, DefinedName)
U(0107010500000000, DescribedTrackIDs)
U(0107010600000000, DescriptiveClipDescribedTrackIDs)
U(0107010700000000, ShotTrackIDs)
//        08 - Generic Identifiers
U(0108010000000000, IdentifierKind)
U(0108020000000000, IdentifierValue)
//        0A - Organization Identifiers
//          01 - Manufacturing Organization Identifiers
//            01 - Manufacturer Identifiers
U(010A010101000000, DeviceManufacturerName_ISO7)
U(010A010101010000, DeviceManufacturerName)
U(010A010103000000, ManufacturerID)
U(010A010200000000, IEEEManufacturerID)
U(010A010300000000, AAFManufacturerID)
//          02 - General Organization Identifiers
U(010A020100000000, OrganizationCode_ISO7)
U(010A020101000000, OrganizationCode)
//        10 - Intellectual Property Rights Identifiers
//          01 - SUISA CISAC IPI
U(0110010100000000, CISACLegalEntityID)
//          02 - AGICOA Identifers
U(0110020100000000, AGICOAID)
//          03 - Music Industry Identifiers
U(0110030100000000, RecordingLabelName_ISO7)
U(0110030101000000, RecordingLabelName)
U(0110030200000000, CollectionName_ISO7)
U(0110030201000000, CollectionName)
U(0110030300000000, OriginCode_ISO7)
U(0110030400000000, MainCatalogNumber_ISO7)
U(0110030500000000, CatalogPrefixNumber_ISO7)
U(0110030600000000, SideNumber_ISO7)
U(0110030700000000, RecordedTrackNumber_ISO7)
//      02 - ADMINISTRATION
//        01 - Supplier
U(0201010000000000, SourceOrganization_ISO7)
U(0201010100000000, SourceOrganization)
U(0201020000000000, SupplyContractNumber)
U(0201030000000000, OriginalProducerName_ISO7)
U(0201030100000000, OriginalProducerName)
U(0201040000000000, SupplyingDepartmentName_ISO7)
U(0201050000000000, SupplierIdentificationKind_ISO7)
U(0201060000000000, SupplierIdentificationValue_ISO7)
U(0201070000000000, SupplierAccountNumber_ISO7)
U(0201080000000000, SupplierAccountName_ISO7)
U(0201080100000000, SupplierAccountName)
//        02 - Product
U(0202010000000000, TotalEpisodeCount)
U(0202020000000000, SeriesInASeriesGroupCount)
U(0202030000000000, ProgrammingGroupKind_ISO7)
U(0202030100000000, ProgrammingGroupKind)
U(0202040000000000, EpisodicStartNumber)
U(0202050000000000, EpisodicEndNumber)
U(0202060000000000, ProgrammingGroupTitle_ISO7)
U(0202060100000000, ProgrammingGroupTitle)
//        03 - Purchaser
U(0203010000000000, PurchasingOrganizationName_ISO7)
U(0203020000000000, SalesContractNumber_ISO7)
U(0203040000000000, PurchasingDepartment_ISO7)
U(0203050000000000, PurchaserIdentificationKind_ISO7)
U(0203060000000000, PurchaserIdentificationValue_ISO7)
U(0203070000000000, PurchaserAccountNumber_ISO7)
U(0203080000000000, PurchaserAccountName_ISO7)
U(0203080100000000, PurchaserAccountName)
//        04 - Contract Descriptions
U(0204010000000000, ContractType_ISO7)
U(0204010100000000, ContractTypeCode)
U(0204010200000000, ContractType)
U(0204020000000000, ContractClauseDescription_ISO7)
U(0204020100000000, ContractClauseDescription)
U(0204030000000000, ContractLineCode)
U(0204030100000000, ContractLineName_ISO7)
U(0204030200000000, ContractLineName)
U(0204040000000000, ContractTermsOfBusiness_ISO7)
U(0204040100000000, ContractTermsOfBusiness)
U(0204050000000000, ContractInstallmentPercentage)
U(0204060000000000, Jurisdiction_ISO7)
U(0204060100000000, Jurisdiction)
//        05 - Rights
//          01 - Copyright
U(0205010100000000, CopyrightStatus_ISO7)
U(0205010101000000, CopyrightStatus)
U(0205010200000000, CopyrightOwnerName_ISO7)
U(0205010201000000, CopyrightOwner)
//          02 - Intellectual Rights
U(0205020100000000, IntellectualPropertyDescription_ISO7)
U(0205020101000000, IntellectualPropertyDescription)
U(0205020200000000, IntellectualPropertyRight_ISO7)
U(0205020201000000, IntellectualPropertyRight)
//          03 - Legal Personalities
U(0205030100000000, Rightsholder_ISO7)
U(0205030101000000, Rightsholder)
U(0205030200000000, RightsManagementAuthority_ISO7)
U(0205030201000000, RightsManagementAuthority)
U(0205030300000000, InterestedPartyName_ISO7)
//          04 - Intellectual Property Rights Options
U(0205040100000000, MaxNumberOfUsages)
U(0205040200000000, LicenseOptionsDescription_ISO7)
U(0205040300000000, RightsConditionDescription_ISO7)
U(0205040301000000, RightsCondition)
U(0205040400000000, RightsComment_ISO7)
U(0205040401000000, RightsComment)
//        06 - Financial Information
//          01 - Currencies
U(0206010100000000, CurrencyCode_ISO7)
U(0206010101000000, CurrencyName_ISO7)
U(0206010200000000, TotalCurrencyAmount)
U(0206010300000000, InstallmentNumber)
//          02 - Payments and Costs
U(0206020100000000, RoyaltyPaymentInformation_ISO7)
U(0206020200000000, TotalPayment_ISO7)
U(0206020300000000, PayeeAccountName_ISO7)
U(0206020400000000, PayeeAccountNumber_ISO7)
U(0206020500000000, PayeeAccountSortCode_ISO7)
//          03 - Income
U(0206030100000000, RoyaltyIncomeInformation_ISO7)
U(0206030200000000, TotalIncome_ISO7)
U(0206030300000000, PayerAccountName_ISO7)
U(0206030400000000, PayerAccountNumber_ISO7)
U(0206030500000000, PayerAccountSortCode_ISO7)
//        07 - Access Control
U(0207010000000000, RestrictionsOnUse_ISO7)
U(0207020000000000, ExCCIData)
U(0207030000000000, ASMBadRequestCopy)
U(0207040000000000, ASMResponse)
U(0207050000000000, ASMLogRecord)
U(0207060000000000, ASMProtocolVersion)
U(0207070000000000, ASMPlayoutStatus)
U(0207080000000000, ASMBufferOverflowFlag)
U(0207090000000000, ASMKeyPresentFlag)
U(02070A0000000000, ASMKeyNotPresentFlag)
U(02070E0000000000, ASMProjectorCertificateData)
//        08 - Security
//          01 - System Access
U(0208010100000000, Username_ISO7)
U(0208010101000000, Username)
U(0208010200000000, Password_ISO7)
U(0208010201000000, Password)
//          02 - Classification
U(0208020100000000, SecurityClassification_ISO7)
U(0208020101000000, SecurityClassification)
U(0208020200000000, Caveats)
U(0208020201000000, SecurityClassificationCaveats)
U(0208020300000000, ClassifiedBy_ISO7)
U(0208020400000000, ClassificationReason_ISO7)
U(0208020500000000, Declassification)
U(0208020600000000, DerivedFrom_ISO7)
U(0208020700000000, ClassificationComment_ISO7)
U(0208020701000000, ClassificationComment)
U(0208020800000000, ClassificationAndMarkingSystem_ISO7)
//        09 - Encryption
//          01 - Film Encryption
//            01 - Scrambling Keys
U(0209010101000000, ScramblingKeyKind_ISO7)
U(0209010102000000, ScramblingKeyValue)
//          02 - Data Encryption
//            01 - Data Encryption Algorithms
//            02 - Data Hashing Algorithms
//          03 - Digital Cinema Encryption
//            01 - Digital Cinema Encryption Algorithms
U(0209030101000000, CipherAlgorithm)
U(0209030102000000, CryptographicKeyID)
U(0209030103000000, EncryptedSourceValue)
//            02 - Digital Cinema Hashing Algorithms
U(0209030201000000, MICAlgorithm)
U(0209030202000000, MIC)
//        0A - Identifiers and Locators Administration Authorities
U(020A010000000000, IdentifierIssuingAuthority_ISO7)
U(020A010100000000, IdentificationIssuingAuthority)
//        10 - Publication Outlet
//          01 - Broadcast
//            01 - Broadcaster
U(0210010101000000, BroadcastOrganizationName_ISO7)
U(0210010101010000, BroadcastOrganizationName)
U(0210010102000000, BroadcastChannel_ISO7)
U(0210010102010000, BroadcastServiceName)
U(0210010103000000, BroadcastMediumKind_ISO7)
U(0210010103020000, BroadcastMediumCode)
U(0210010104010000, BroadcastRegion)
U(0210010105000000, BroadcastRegion_ISO7)
//          02 - Publication
//            01 - General Publication
U(0210020101000000, PublishingOrganizationName_ISO7)
U(0210020101010000, PublishingOrganizationName)
U(0210020102000000, PublishingServiceName_ISO7)
U(0210020102010000, PublishingServiceName)
U(0210020103000000, PublishingMediumName_ISO7)
U(0210020103010000, PublishingMediumName)
U(0210020104000000, PublishingRegionName_ISO7)
U(0210020104010000, PublishingRegionName)
//            02 - Register Publication Information
U(0210020201000000, RegisterKind_ISO7)
U(0210020202000000, RegisterVersion_ISO7)
U(0210020203000000, RegisterEditorName_ISO7)
U(0210020204000000, RegisterStatusKind_ISO7)
//            03 - Register Item
U(0210020301000000, RegisterItemName_ISO7)
U(0210020302000000, RegisterItemDefinition_ISO7)
U(0210020303000000, RegisterItemSymbol_ISO7)
U(0210020304000000, RegisterItemDefiningDocumentName_ISO7)
U(0210020305000000, RegisterItemUL_ISO7)
U(0210020306000000, RegisterItemNotes_ISO7)
U(0210020307000000, RegisterItemIntroductionVersion_ISO7)
U(0210020308000000, RegisterItemHierarchyLevel_ISO7)
U(0210020309000000, RegisterNodeWildcardFlag_ISO7)
U(021002030A000000, RegisterEntryStatus_ISO7)
//            04 - Register Administration
U(0210020401000000, RegisterAction_ISO7)
U(0210020402000000, RegisterApproverName_ISO7)
U(0210020403000000, RegisterCreationTime_ISO7)
U(0210020404000000, RegistrantName_ISO7)
U(0210020405000000, RegisterItemOriginatorName_ISO7)
U(0210020406000000, RegisterUserName_ISO7)
U(0210020407000000, RegisterUserTime_ISO7)
U(0210020408000000, RegisterAdministrationNotes_ISO7)
//        20 - Broadcast and Repeat Information
//          01 - Broadcast Flags
U(0220010100000000, FirstBroadcastFlag)
//          02 - Repeat Numbers
U(0220020100000000, CurrentRepeatNumber)
U(0220020200000000, PreviousRepeatNumber)
//          03 - Ratings
U(0220030100000000, AudienceRating)
U(0220030200000000, AudienceReach)
U(0220030300000000, AudienceShare)
U(0220030400000000, AudienceAppreciation)
//        30 - Participating Parties
//          01 - Individuals and Groups
U(0230010100000000, NatureOfPersonalityIndividualOrGroup_ISO7)
U(0230010101000000, NatureOfPersonalityIndividualOrGroup)
//            02 - Production
U(0230010201000000, ContributionStatus_ISO7)
U(0230010201010000, ContributionStatus)
//            03 - Support and Administration Details
U(0230010301000000, SupportOrAdministrationStatus_ISO7)
U(0230010301010000, SupportOrAdministrationStatus)
//          02 - Organizations and Public Bodies
U(0230020100000000, OrganizationKind_ISO7)
U(0230020101000000, OrganizationKind)
//            02 - Production Organization or Public Body
U(0230020201000000, ProductionOrganizationRole_ISO7)
U(0230020201010000, ProductionOrganizationRole)
//            03 - Support and Administration Organization or Public Body
U(0230020301000000, SupportOrganizationRole_ISO7)
U(0230020301010000, SupportOrganizationRole)
//          05 - Job Function Information
U(0230050100000000, JobFunctionName_ISO7)
U(0230050101000000, JobFunction)
U(0230050102000000, JobFunctionCode)
U(0230050200000000, RoleName_ISO7)
U(0230050201000000, RoleName)
U(0230050300000000, JobTitle_ISO7)
U(0230050301000000, JobTitle)
//          06 - Contact Information
U(0230060100000000, ContactKind_ISO7)
U(0230060101000000, ContactKind)
U(0230060200000000, ContactDepartmentName_ISO7)
U(0230060201000000, ContactDepartment)
//            03 - Person or Organization Details
//              01 - Person Names
U(0230060301010000, FamilyName_ISO7)
U(0230060301010100, FamilyName)
U(0230060301020000, FirstGivenName_ISO7)
U(0230060301020100, FirstGivenName)
U(0230060301030000, SecondGivenName_ISO7)
U(0230060301030100, SecondGivenName)
U(0230060301040000, ThirdGivenName_ISO7)
U(0230060301040100, ThirdGivenName)
U(0230060301050000, Salutation_ISO7)
U(0230060301050100, Salutation)
U(0230060301060000, HonorsQualifications_ISO7)
U(0230060301060100, HonorsQualifications)
U(0230060301070000, PersonDescription_ISO7)
U(0230060301070100, PersonDescription)
U(0230060301080000, OtherGivenNames_ISO7)
U(0230060301080100, OtherGivenNames)
U(0230060301090000, AlternateName_ISO7)
U(0230060301090100, AlternateName)
U(02300603010A0000, LinkingName_ISO7)
U(02300603010A0100, LinkingName)
U(02300603010B0000, NameSuffix_ISO7)
U(02300603010B0100, NameSuffix)
U(02300603010C0000, FormerFamilyName_ISO7)
U(02300603010C0100, FormerFamilyName)
U(02300603010D0000, Nationality_ISO7)
U(02300603010D0100, Nationality)
U(02300603010E0000, Citizenship_ISO7)
U(02300603010E0100, Citizenship)
//              02 - Group Names
U(0230060302010000, MainName_ISO7)
U(0230060302010100, MainName)
U(0230060302020000, SupplementaryName_ISO7)
U(0230060302020100, SupplementaryName)
//              03 - Organization Names
U(0230060303010000, OrganizationMainName_ISO7)
U(0230060303010100, OrganizationMainName)
U(0230060303020000, SupplementaryOrganizationName_ISO7)
U(0230060303020100, SupplementaryOrganizationName)
//        40 - Protocols
//          01 - Aux Data Transfer Protocol
U(0240010100000000, AuxDataEditUnitRangeStartIndex)
U(0240010200000000, AuxEditUnitRangeCount)
U(0240010300000000, AuxDataBlockEditUnitIndex)
U(0240010400000000, AuxDataBlockEditUnitEditRate)
U(0240010500000000, AuxDataBlockSourceDataEssenceCodingUL)
U(0240010600000000, AuxDataBlockSourceDataItemLength)
U(0240010700000000, AuxDataBlockSourceDataItem)
U(0240010800000000, AuxDataBlockSourceCryptographicContextLength)
U(0240010900000000, AuxDataBlockSourceCryptographicContext)
//          02 - SMS-OMB Communications Protocol
U(0240020100000000, StatusResponse)
U(0240020200000000, RequestID)
U(0240020300000000, CertificateKind)
U(0240020400000000, getCertificateStatus)
U(0240020500000000, CertificateLength)
U(0240020600000000, CertificateData)
U(0240020700000000, Offset)
U(0240020800000000, AuthIdTextLength)
U(0240020900000000, AuthIdText)
U(0240020A00000000, AdjustmentStatus)
U(0240020B00000000, SecureClockTime)
U(0240020C00000000, getSecureTimeStatus)
U(0240020D00000000, CPLXMLDataLength)
U(0240020E00000000, CPLXMLData)
U(0240020F00000000, AssetIntegrityHashBatch)
U(0240021000000000, validateCPLStatus)
U(0240021100000000, CPLID)
U(0240021200000000, getCPLValidationResultStatus)
U(0240021300000000, KDMXMLDataLength)
U(0240021400000000, KDMXMLData)
U(0240021500000000, validateKdmStatus)
U(0240021600000000, KDMID)
U(0240021700000000, getKDMValidationResultStatus)
U(0240021800000000, CplValidationBatch)
U(0240021900000000, CPLProcessedReportDelinquencyTime)
U(0240021A00000000, IdentifierTextLength)
U(0240021B00000000, IdentifierText)
U(0240021C00000000, VersionTextLength)
U(0240021D00000000, VersionText)
U(0240021E00000000, SupportedDataEssenceCodingULs)
U(0240021F00000000, ProtocolVersion)
U(0240022000000000, OMBStatus)
U(0240022100000000, StartTime)
U(0240022200000000, EndTime)
U(0240022300000000, GenerationStatus)
U(0240022400000000, ExportStatus)
U(0240022500000000, NextReportStartTime)
U(0240022600000000, XMLReportDataLength)
U(0240022700000000, XMLReportData)
//      03 - Interpretive
//        01 - Fundamental
//          01 - Countries and Languages
//            01 - Country and Region Codes
U(0301010101000000, ISO3166CountryCode)
U(0301010102000000, RegionCode)
//              10 - Country and Region Names
U(0301010110010000, CountryName_ISO7)
U(0301010110010100, CountryName)
U(0301010110020000, RegionName_ISO7)
U(0301010110020100, RegionName)
//            02 - Language Codes
U(0301010201000000, ISO6391LanguageCode_ISO639)
U(0301010201010000, ISO6391LanguageCode)
//              02 - Text Language Codes
U(0301010202010000, ISO639TextLanguageCode)
U(0301010202020000, ISO639CaptionsLanguageCode)
U(0301010202030000, FrameworkTextLanguageCode)
U(0301010202110000, ExtendedTextLanguageCode)
U(0301010202120000, ExtendedCaptionsLanguageCode)
U(0301010202130000, FrameworkExtendedTextLanguageCode)
U(0301010202140000, RFC5646TextLanguageCode)
U(0301010202150000, EventTextLanguageCode)
U(0301010202160000, RFC5646LanguageTagList)
//              03 - Spoken Language Codes
U(0301010203010000, PrimarySpokenLanguageCode)
U(0301010203020000, SecondarySpokenLanguageCode)
U(0301010203030000, PrimaryOriginalLanguageCode)
U(0301010203040000, SecondaryOriginalSpokenLanguageCode)
U(0301010203110000, PrimaryExtendedSpokenLanguageCode)
U(0301010203120000, SecondaryExtendedSpokenLanguageCode)
U(0301010203130000, OriginalExtendedSpokenLanguageCode)
U(0301010203140000, SecondaryOriginalExtendedSpokenLanguageCode)
U(0301010203150000, RFC5646SpokenLanguage)
//              10 - Language Names
U(0301010210010000, LanguageName_ISO7)
U(0301010210010100, LanguageName)
//          02 - Data Interpretations and Definitions
//            01 - System Interpretations
U(0301020101000000, OperatingSystemInterpretations)
U(0301020102000000, ByteOrder)
U(0301020103000000, EssenceIsIdentified)
U(0301020104000000, ObjectModelVersion)
U(0301020105000000, FormatVersion)
U(0301020106000000, MajorVersion)
U(0301020107000000, MinorVersion)
U(0301020108000000, SectorSize)
U(0301020109000000, KAGSize)
U(030102010A000000, ReversedByteOrder)
//            02 - Property Definitions
U(0301020201000000, IsOptional)
U(0301020202000000, IsSearchable)
//              03 - Property Defaults
U(0301020203010000, UseDefaultValue)
U(0301020203020000, DefaultDataValue)
//            03 - Type Definition
U(0301020301000000, Size)
U(0301020302000000, IsSigned)
U(0301020303000000, ElementCount)
U(0301020304000000, ElementNames)
U(0301020305000000, ElementValues)
U(0301020306000000, MemberNames)
U(0301020307000000, ExtendibleEnumerationElementNames)
U(0301020308000000, ExtendibleEnumerationElementValues)
U(0301020309000000, ElementLength)
U(030102030B000000, TargetSet)
//            0A - Name-Value Construct Interpretations
U(0301020A01000000, ItemName_ISO7)
U(0301020A01010000, ItemName)
U(0301020A02000000, ItemValue_ISO7)
U(0301020A02010000, ItemValue)
//            10 - KLV Interpretations
U(0301021001000000, FillerData)
U(0301021002000000, KLVDataValue)
U(0301021003000000, PackageKLVData)
U(0301021004000000, ComponentKLVData)
U(0301021005000000, TerminatingFillerData)
U(0301021006000000, KLVMetadataSequence)
U(0301021007000000, PackageAttributes)
U(0301021008000000, ComponentAttributes)
//            20 - XML Constructs and Interpretations
U(0301022001000000, XMLDocumentText_Indirect)
U(0301022001010000, XMLDocumentText_UTF7)
U(0301022001020000, XMLDocumentText)
U(0301022001030000, XMLDocumentText_BiM)
//              02 - XML BiM Constructs in Multiple Streams
//                01 - MPEG-7 BiM Decoder Init Frames
U(0301022002010100, MPEG7BiMDecoderInitFrameStream1)
U(0301022002010200, MPEG7BiMDecoderInitFrameStream2)
U(0301022002010300, MPEG7BiMDecoderInitFrameStream3)
U(0301022002010400, MPEG7BiMDecoderInitFrameStream4)
U(0301022002010500, MPEG7BiMDecoderInitFrameStream5)
U(0301022002010600, MPEG7BiMDecoderInitFrameStream6)
U(0301022002010700, MPEG7BiMDecoderInitFrameStream7)
U(0301022002010800, MPEG7BiMDecoderInitFrameStream8)
//                02 - MPEG-7 BiM Access Unit Frames
U(0301022002020100, MPEG7BiMAccessUnitFrameStream1)
U(0301022002020200, MPEG7BiMAccessUnitFrameStream2)
U(0301022002020300, MPEG7BiMAccessUnitFrameStream3)
U(0301022002020400, MPEG7BiMAccessUnitFrameStream4)
U(0301022002020500, MPEG7BiMAccessUnitFrameStream5)
U(0301022002020600, MPEG7BiMAccessUnitFrameStream6)
U(0301022002020700, MPEG7BiMAccessUnitFrameStream7)
U(0301022002020800, MPEG7BiMAccessUnitFrameStream8)
//              03 - Text Data
U(0301022003010000, UTF8TextData)
U(0301022003020000, UTF16TextData)
//          03 - Fundamental Dimensions
//            01 - Length
U(0301030101000000, LengthSystemName_ISO7)
U(0301030102000000, LengthUnitKind_ISO7)
//            02 - Angles
U(0301030201000000, AngularUnitKind_ISO7)
//            03 - Time
U(0301030301000000, TimeSystemOffset_ISO7)
U(0301030302000000, TimeUnitKind_ISO7)
U(0301030303000000, TimingBiasCorrection)
U(0301030304000000, TimingBiasCorrectionDescription_ISO7)
//            04 - Mass
//            05 - Energy
//        02 - Human Assigned Descriptors
//          01 - Categorization
//            01 - Content Classification
U(0302010101000000, ContentCodingSystem_ISO7)
U(0302010102000000, ProgramKind_ISO7)
U(0302010103000000, Genre_ISO7)
U(0302010103010000, Genre)
U(0302010104000000, TargetAudience_ISO7)
U(0302010104010000, TargetAudience)
U(0302010110000000, ProgramMaterialClassificationCode_ISO7)
//            02 - Cataloging and Indexing
U(0302010201000000, CatalogDataStatus_ISO7)
U(0302010202000000, ThesaurusName_ISO7)
U(0302010202010000, ThesaurusName)
U(0302010203000000, Theme_ISO7)
U(0302010203010000, Theme)
U(0302010204000000, ContentClassification)
U(0302010204010000, SubjectName_ISO7)
U(0302010204020000, SubjectName)
U(0302010205000000, Keywords_ISO7)
U(0302010205010000, Keywords)
U(0302010206000000, KeyFrames_ISO7)
U(0302010207000000, KeySounds_ISO7)
U(0302010208000000, KeyData_ISO7)
U(0302010209000000, AssignedCategoryName_ISO7)
U(0302010209010000, Tag)
U(030201020A000000, AssignedCategoryValue_ISO7)
U(030201020A010000, IndirectValue)
U(030201020B000000, ShotList_ISO7)
U(030201020C000000, PackageUserComments)
U(030201020D000000, CueInWords_ISO7)
U(030201020D010000, InCueWords)
U(030201020E000000, CueOutWords_ISO7)
U(030201020E010000, OutCueWords)
U(030201020F000000, KeyFrameSampleCount)
U(0302010210000000, KeypointKind_ISO7)
U(0302010210010000, KeypointKind)
U(0302010211000000, KeypointValue_ISO7)
U(0302010211010000, KeypointValue)
U(0302010215000000, FrameworkThesaurusName_ISO7)
U(0302010215010000, FrameworkThesaurusName)
U(0302010216000000, ComponentUserComments)
U(0302010220000000, MCAAudioContentKind)
U(0302010221000000, MCAAudioElementKind)
U(0302010222000000, MCAContent)
U(0302010223000000, MCAUseClass)
U(0302010224000000, MCAContentSubtype)
U(0302010225000000, MCAContentDifferentiator)
U(0302010226000000, MCASpokenLanguageAttribute)
U(0302010227000000, RFC5646AdditionalSpokenLanguages)
U(0302010228000000, MCAAdditionalLanguageAttributes)
//            06 - Textual Description
U(0302010601000000, Abstract_ISO7)
U(0302010601010000, Abstract)
U(0302010602000000, Purpose_ISO7)
U(0302010602010000, Purpose)
U(0302010603000000, Description_ISO7)
U(0302010603010000, Description)
U(0302010603020000, TextDataDescription)
U(0302010604000000, ColorDescriptor_ISO7)
U(0302010604010000, ColorDescriptor)
U(0302010605000000, FormatDescriptor_ISO7)
U(0302010605010000, FormatDescriptor)
U(0302010606000000, IntentDescriptor_ISO7)
U(0302010606010000, IntentDescriptor)
U(0302010607000000, TextualDescriptionKind_ISO7)
U(0302010607010000, TextualDescriptionKind)
U(0302010608000000, GroupSynopsis_ISO7)
U(0302010608010000, GroupSynopsis)
U(0302010609000000, AnnotationSynopsis_ISO7)
U(0302010609010000, AnnotationSynopsis)
U(030201060A000000, AnnotationDescription_ISO7)
U(030201060A010000, AnnotationDescription)
U(030201060B000000, ScriptingKind_ISO7)
U(030201060B010000, ScriptingKind)
U(030201060C000000, ScriptingText_ISO7)
U(030201060C010000, ScriptingText)
U(030201060D000000, ShotDescription_ISO7)
U(030201060D010000, ShotDescription)
U(030201060E000000, AnnotationKind_ISO7)
U(030201060E010000, AnnotationKind)
U(030201060F000000, RelatedMaterialDescription_ISO7)
U(030201060F010000, RelatedMaterialDescription)
U(0302010610000000, JFIFMarkerDescription_ISO7)
U(0302010610010000, JFIFMarkerDescription)
U(0302010611000000, HTMLMetaDescription_ISO7)
U(0302010611010000, HTMLMetaDescription)
//            07 - Stratum
U(0302010701000000, StratumKind_ISO7)
//            08 - Subtitling
U(0302010801000000, EventTextKind)
U(0302010802000000, STLLineNumber)
//          02 - Assessments
//            01 - Awards
U(0302020101000000, IndividualAwardName_ISO7)
U(0302020102000000, ProgramAwardName_ISO7)
U(0302020103000000, FestivalName_ISO7)
U(0302020103010000, FestivalName)
U(0302020104000000, AwardName_ISO7)
U(0302020104010000, AwardName)
U(0302020105000000, AwardCategory_ISO7)
U(0302020105010000, AwardCategory)
U(0302020106000000, NominationCategory_ISO7)
U(0302020106010000, NominationCategory)
//            02 - Qualitative Values
U(0302020201000000, AssetValue_ISO7)
U(0302020202000000, ContentValue_ISO7)
U(0302020203000000, CulturalValue_ISO7)
U(0302020204000000, AestheticValue_ISO7)
U(0302020205000000, HistoricalValue_ISO7)
U(0302020206000000, TechnicalValue_ISO7)
U(0302020207000000, OtherValues_ISO7)
//          03 - Technical Comments and Descriptions
//            01 - Object Comments and Descriptions
U(0302030101000000, ObjectKind_ISO7)
U(0302030101010000, ObjectKind)
U(0302030102000000, ObjectDescription_ISO7)
U(0302030102010000, DefinitionObjectDescription)
U(0302030102020000, ObjectDescriptionCode)
//            02 - General Comments
U(0302030201000000, DescriptionKind_ISO7)
U(0302030201010000, DescriptionKind)
U(0302030202000000, DescriptiveComment_ISO7)
U(0302030202010000, DescriptiveComment)
//                10 - Descriptive Comment for a Device
U(0302030202100100, LensAttributes)
U(0302030202100200, CameraAttributes)
//          04 - Descriptive Names
//            01 - Object Names
//              01 - Generic Object Names
U(0302040101010000, ObjectName_ISO7)
U(0302040102000000, MetaDefinitionName_ISO7)
U(0302040102010000, MetaDefinitionName)
//          05 - Editorial Comments and Descriptions
U(0302050100000000, ShotCommentKind_ISO7)
U(0302050101000000, ShotCommentKind)
U(0302050200000000, ShotComment_ISO7)
U(0302050201000000, ShotComment)
U(0302050300000000, SlateInformation)
U(0302050400000000, ClipKind)
//          06 - Human-Assigned Context Descriptions
U(0302060100000000, ContextDescription_ISO7)
//        03 - Machine-Assigned or Computed Descriptions
//          01 - Automated Categorization
//            01 - Automated Content Classification
//            02 - Automated Cataloging and Indexing
U(0303010201000000, AutomatedCatalogingCatalogDataStatus_ISO7)
U(0303010202000000, CatalogingSystemName_ISO7)
U(0303010206000000, ComputedKeywords_ISO7)
U(0303010206010000, ComputedKeywords)
U(0303010207000000, ComputedKeyFrames_ISO7)
U(0303010208000000, ComputedKeySounds_ISO7)
U(0303010209000000, ComputedKeyData_ISO7)
//            06 - Computed Textual Description
//            07 - Automated Stratum
U(0303010701000000, ComputedStratumKind_ISO7)
//          03 - Computed Technical Comments and Descriptions
//            01 - Computed Object Comments and Descriptions
U(0303030101000000, ComputedObjectKind_ISO7)
U(0303030101010000, ComputedObjectKind)
U(0303030102000000, PluginVersionString_ISO7)
U(0303030102010000, PluginVersionString)
U(0303030103000000, PluginVersion)
U(0303030104000000, ObjectIdentificationConfidence)
U(0303030105000000, ObjectHorizontalAverageDimension)
U(0303030106000000, ObjectVerticalAverageDimension)
U(0303030107000000, ObjectAreaDimension)
//            02 - Derived Summary Information
U(0303030201000000, WAVESummary)
U(0303030202000000, AIFCSummary)
U(0303030203000000, TIFFSummary)
//            10 - Device Comments and Descriptions
U(0303031001000000, DeviceUsageDescription_ISO7)
U(0303031001010000, DeviceUsageDescription)
//      04 - Parametric
//        01 - Video and Image Essence Characteristics
//          01 - Fundamental Image Characteristics
//            01 - Aspect Ratios
U(0401010101000000, ImageAspectRatio)
U(0401010102000000, CaptureAspectRatio_ISO7)
U(0401010103000000, ViewportAspectRatio)
U(0401010104000000, HorizontalActionSafePercentage)
U(0401010105000000, VerticalActionSafePercentage)
U(0401010106000000, HorizontalGraphicsSafePercentage)
U(0401010107000000, VerticalGraphicsSafePercentage)
U(0401010108000000, PerceivedDisplayFormat)
U(0401010108010000, PerceivedDisplayFormatCode_ISO7)
U(0401010109000000, AFDBarData)
U(040101010A000000, PanScanInformation)
//          02 - Image Source Characteristics
//            01 - Opto-Electronic Formulation
//              01 - Transfer Characteristics
U(0401020101010000, CaptureGammaEquation_ISO7)
U(0401020101010100, CaptureGammaEquation_Rational)
U(0401020101010200, TransferCharacteristic)
U(0401020101020000, LumaEquation_ISO7)
U(0401020101030000, ColorimetryCode_ISO7)
U(0401020101030100, CodingEquations)
U(0401020101040000, SignalFormCode_ISO7)
U(0401020101050000, VideoColorKind_ISO7)
U(0401020101060000, ColorPrimaries_ISO7)
U(0401020101060100, ColorPrimaries)
U(0401020101100000, PresentationGammaEquation_GammaCode)
U(0401020101100100, PresentationGammaEquation)
//            02 - Sensor Parameters
U(0401020201000000, SensorMode_ISO7)
//          03 - Video and Image Scanning Parameters
//            01 - Temporal Parameters
U(0401030101000000, ColorFieldCode)
U(0401030102000000, FieldRate)
U(0401030103000000, FrameRate_UInt16)
U(0401030103010000, CaptureFrameRate)
U(0401030104000000, FrameLayout)
U(0401030105000000, SamplingStructureCode)
U(0401030106000000, FieldDominance)
U(0401030107000000, PictureDisplayRate)
//            02 - Vertical Parameters
U(0401030201000000, TotalLinesPerFrame)
U(0401030202000000, ActiveLinesPerFrame)
U(0401030203000000, LeadingLines)
U(0401030204000000, TrailingLines)
U(0401030205000000, VideoLineMap)
U(0401030207000000, DisplayF2Offset)
U(0401030208000000, StoredF2Offset)
U(0401030209000000, ActiveFormatDescriptor)
U(040103020A000000, LineNumber)
U(040103020B000000, AlternativeCenterCuts)
//            03 - Horizontal Parameters
//          04 - Analog Video Coding Characteristics
U(0401040100000000, AnalogVideoSystemName_ISO7)
U(0401040101000000, VideoSignal)
//            04 - Video Scanning Characteristics
U(0401040401000000, ScanningDirection)
//          05 - Digital Video and Image Coding Parameters
//            01 - Digital Video and Image Sampling Parameters
U(0401050101000000, LuminanceSampleRate)
U(0401050102000000, ActiveSamplesPerLine)
U(0401050103000000, TotalSamplesPerLine)
U(0401050104000000, SamplingHierarchyCode_ISO7)
U(0401050105000000, HorizontalSubsampling)
U(0401050106000000, ColorSiting)
U(0401050107000000, SampledHeight)
U(0401050108000000, SampledWidth)
U(0401050109000000, SampledXOffset)
U(040105010A000000, SampledYOffset)
U(040105010B000000, DisplayHeight)
U(040105010C000000, DisplayWidth)
U(040105010D000000, DisplayXOffset)
U(040105010E000000, DisplayYOffset)
U(040105010F000000, FilteringCode_ISO7)
U(0401050110000000, VerticalSubsampling)
U(0401050111000000, VideoAverageBitRate)
U(0401050112000000, VideoFixedBitRate)
U(0401050113000000, ActiveHeight)
U(0401050114000000, ActiveWidth)
U(0401050115000000, ActiveXOffset)
U(0401050116000000, ActiveYOffset)
//            02 - Digital Video and Image Storage Parameters
U(0401050201000000, StoredHeight)
U(0401050202000000, StoredWidth)
U(0401050203000000, VBILineCount)
U(0401050204000000, StoredVBILineNumber)
U(0401050205000000, VBIWrappingType)
U(0401050206000000, VBIPayloadSampleCount)
U(0401050207000000, VBIPayloadByteArray)
U(0401050208000000, ANCPacketCount)
U(0401050209000000, StoredANCLineNumber)
U(040105020A000000, ANCWrappingType)
U(040105020B000000, ANCPayloadSampleCount)
U(040105020C000000, ANCPayloadByteArray)
//            03 - Digital Quantization and Level Parameters
U(0401050301000000, BitsPerPixel_UInt8)
U(0401050301010000, BitsPerPixel)
U(0401050302000000, RoundingMethodCode_ISO7)
U(0401050303000000, BlackRefLevel)
U(0401050304000000, WhiteRefLevel)
U(0401050305000000, ColorRange)
U(0401050306000000, PixelLayout)
U(0401050307000000, AlphaSampleDepth)
U(0401050308000000, Palette)
U(0401050309000000, PaletteLayout)
U(040105030A000000, ComponentDepth)
U(040105030B000000, ComponentMaxRef)
U(040105030C000000, ComponentMinRef)
U(040105030D000000, AlphaMaxRef)
U(040105030E000000, AlphaMinRef)
U(040105030F000000, VBIPayloadSampleCoding)
U(0401050310000000, ANCPayloadSampleCoding)
//            04 - Digital Video and Image Signal Type Identifiers
U(0401050401000000, VideoPayloadIdentifier)
U(0401050402000000, VideoPayloadIdentifier2002)
//          06 - Digital Video and Image Compression Parameters
U(0401060100000000, PictureCompression)
//            02 - MPEG Coding Parameters
//              01 - MPEG-2 Coding Parameters
U(0401060201010000, FieldFrameTypeCode_ISO7)
U(0401060201020000, SingleSequence)
U(0401060201030000, ConstantBPictureCount)
U(0401060201040000, CodedContentScanning)
U(0401060201050000, LowDelay)
U(0401060201060000, ClosedGOP)
U(0401060201070000, IdenticalGOP)
U(0401060201080000, MaxGOP)
U(0401060201090000, MaxBPictureCount)
U(04010602010A0000, ProfileAndLevel)
U(04010602010B0000, BitRate)
//              02 - MPEG-4 Visual Coding Parameters
U(0401060202010000, MPEG4VisualVOPCodingType)
U(0401060202020000, MPEG4VisualSingleSequence)
U(0401060202030000, MPEG4VisualConstantBVOPs)
U(0401060202040000, MPEG4VisualCodedContentType)
U(0401060202050000, MPEG4VisualLowDelay)
U(0401060202060000, MPEG4VisualClosedGOP)
U(0401060202070000, MPEG4VisualIdenticalGOP)
U(0401060202080000, MPEG4VisualMaxGOP)
U(0401060202090000, MPEG4VisualBVOPCount)
U(04010602020A0000, MPEG4VisualProfileAndLevel)
U(04010602020B0000, MPEG4VisualBitRate)
//            03 - JPEG 2000 Coding Parameters
U(0401060301000000, Rsiz)
U(0401060302000000, Xsiz)
U(0401060303000000, Ysiz)
U(0401060304000000, XOsiz)
U(0401060305000000, YOsiz)
U(0401060306000000, XTsiz)
U(0401060307000000, YTsiz)
U(0401060308000000, XTOsiz)
U(0401060309000000, YTOsiz)
U(040106030A000000, Csiz)
U(040106030B000000, PictureComponentSizing)
U(040106030C000000, CodingStyleDefault)
U(040106030D000000, QuantizationDefault)
U(040106030E000000, J2CLayout)
U(040106030F000000, J2KExtendedCapabilities)
U(0401060310000000, J2KProfile)
U(0401060311000000, J2KCorrespondingProfile)
//            04 - VC-1 Picture Essence Descriptors
U(0401060401000000, VC1InitializationMetadata)
U(0401060402000000, VC1SingleSequence)
U(0401060403000000, VC1CodedContentType)
U(0401060404000000, VC1IdenticalGOP)
U(0401060405000000, VC1MaxGOP)
U(0401060406000000, VC1BPictureCount)
U(0401060407000000, VC1AverageBitRate)
U(0401060408000000, VC1MaximumBitRate)
U(0401060409000000, VC1Profile)
U(040106040A000000, VC1Level)
//            05 - TIFF Coding Parameters
U(0401060501000000, TIFFByteOrder)
U(0401060502000000, TIFFBitsPerSampleArray)
U(0401060503000000, TIFFCompressionKind)
U(0401060504000000, TIFFPhotometricInterpretationKind)
U(0401060505000000, TIFFOrientation)
U(0401060506000000, TIFFSamplesPerPixel)
U(0401060507000000, TIFFLightSourceKind)
//              01 - AVC Parameters
U(0401060601030000, AVCConstantBPictureFlag)
U(0401060601040000, AVCCodedContentKind)
U(0401060601060000, AVCClosedGOPIndicator)
U(0401060601070000, AVCIdenticalGOPIndicator)
U(0401060601080000, AVCMaximumGOPSize)
U(0401060601090000, AVCMaximumBPictureCount)
U(04010606010A0000, AVCProfile)
U(04010606010B0000, AVCMaximumBitRate)
U(04010606010C0000, AVCProfileConstraint)
U(04010606010D0000, AVCLevel)
U(04010606010E0000, AVCDecodingDelay)
U(04010606010F0000, AVCMaximumRefFrames)
U(0401060601100000, AVCSequenceParameterSetFlag)
U(0401060601110000, AVCPictureParameterSetFlag)
U(0401060601140000, AVCAverageBitRate)
//              02 - HEVC Parameters
U(0401060602030000, HEVCConstantBPictureFlag)
U(0401060602040000, HEVCCodedContentKind)
U(0401060602060000, HEVCClosedGOPIndicator)
U(0401060602070000, HEVCIdenticalGOPIndicator)
U(0401060602080000, HEVCMaximumGOPSize)
U(0401060602090000, HEVCMaximumBPictureCount)
U(04010606020A0000, HEVCProfile)
U(04010606020B0000, HEVCMaximumBitRate)
U(04010606020C0000, HEVCProfileConstraint)
U(04010606020D0000, HEVCLevel)
U(04010606020E0000, HEVCDecodingDelay)
U(04010606020F0000, HEVCMaximumRefFrames)
U(0401060602100000, HEVCSequenceParameterSetFlag)
U(0401060602110000, HEVCPictureParameterSetFlag)
U(0401060602120000, HEVCTier)
U(0401060602130000, HEVCVideoParameterSetFlag)
U(0401060602140000, HEVCAverageBitRate)
U(0401060602150000, HEVCCTUSize)
U(0401060602160000, HEVCTileUniformSpacingFlag)
U(0401060602170000, HEVCTileColumnsMinus1)
U(0401060602180000, HEVCTileRowsMinus1)
U(0401060602190000, HEVCTileWidthMinus1)
U(04010606021A0000, HEVCTileHeightMinus1)
U(04010606021B0000, HEVCNumberOfPPSs)
//            07 - VC-2 Properties
U(0401060701000000, VC2MajorVersion)
U(0401060702000000, VC2MinorVersion)
U(0401060703000000, VC2Profile)
U(0401060704000000, VC2Level)
U(0401060705000000, VC2WaveletFilters)
U(0401060706000000, VC2SequenceHeadersIdentical)
U(0401060707000000, VC2EditUnitsAreCompleteSequences)
//            08 - VC-5 Parameters
U(0401060801000000, VC5AlphaSampling)
U(0401060802000000, VC5BayerComponentPattern)
U(0401060803000000, VC5BayerComponentBlackLevel)
U(0401060804000000, VC5BayerComponentWhiteLevel)
//            09 - Target Frame Parameters
U(0401060901000000, TargetFrameAncillaryResourceID)
U(0401060902000000, MediaType)
U(0401060903000000, TargetFrameIndex)
U(0401060904000000, TargetFrameTransferCharacteristic)
U(0401060905000000, TargetFrameColorPrimaries)
U(0401060906000000, TargetFrameComponentMaxRef)
U(0401060907000000, TargetFrameComponentMinRef)
U(0401060908000000, TargetFrameEssenceStreamID)
U(0401060909000000, ACESPictureSubDescriptorInstanceID)
U(040106090A000000, TargetFrameViewingEnvironment)
//            0A - ACES Coding Parameters
U(0401060A01000000, ACESAuthoringInformation)
U(0401060A02000000, ACESMasteringDisplayPrimaries)
U(0401060A03000000, ACESMasteringDisplayWhitePointChromaticity)
U(0401060A04000000, ACESMasteringDisplayMaximumLuminance)
U(0401060A05000000, ACESMasteringDisplayMinimumLuminance)
//            0B - JPEG XS Coding Parameters
U(0401060B01000000, JPEGXSPpih)
U(0401060B02000000, JPEGXSPlev)
U(0401060B03000000, JPEGXSWf)
U(0401060B04000000, JPEGXSHf)
U(0401060B05000000, JPEGXSNc)
U(0401060B06000000, JPEGXSComponentTable)
U(0401060B07000000, JPEGXSCw)
U(0401060B08000000, JPEGXSHsl)
U(0401060B09000000, JPEGXSMaximumBitrate)
//            0C - FFV1CodingParameters
U(0401060C01000000, FFV1InitializationMetadata)
U(0401060C02000000, FFV1IdenticalGOP)
U(0401060C03000000, FFV1MaxGOP)
U(0401060C04000000, FFV1MaximumBitRate)
U(0401060C05000000, FFV1Version)
U(0401060C06000000, FFV1MicroVersion)
//          08 - Film-to-Video Characteristics
//            01 - Film Pulldown Characteristics
U(0401080101000000, PulldownSequence)
U(0401080102000000, PulldownFieldDominance)
U(0401080103000000, VideoAndFilmFrameRelationship)
//            02 - Film Frame Rates
U(0401080201000000, CaptureFilmFrameRate_ISO7)
U(0401080202000000, TransferFilmFrameRate_ISO7)
U(0401080203000000, FrameRate)
//          0B - Video File Formats
U(04010B0100000000, DigitalVideoFileFormat_ISO7)
//          10 - Image Test Parameters
//            01 - Video Test Parameters
U(0401100101000000, VideoTestParameter_ISO7)
U(0401100102000000, VideoTestResult_Float)
U(0401100103000000, VideoTestResult_Int32)
//            02 - Film Test Parameters
U(0401100201000000, FilmTestParameter_ISO7)
U(0401100202000000, FilmTestResult)
U(0401100203000000, FilmTestResult_Int32)
//        02 - Audio Essence Characteristics
//          01 - Fundamental  Audio Characteristics
//            01 - Audio Formulation
U(0402010101000000, ElectrospatialFormulation)
U(0402010102000000, FilteringApplied_ISO7)
U(0402010103000000, AudioReferenceLevel)
U(0402010104000000, ChannelCount)
U(0402010105000000, ChannelAssignment)
U(0402010106000000, ReferenceImageEditRate)
U(0402010107000000, ReferenceAudioAlignmentLevel)
//              10 - Audio Mix
U(0402010110010000, AudioMonoChannelCount)
U(0402010110020000, AudioStereoChannelCount)
//          02 - Analog Audio Coding Parameters
U(0402020100000000, AnalogSystem_ISO7)
//          03 - Digital Audio Coding Parameters
//            01 - Digital Sampling Parameters
U(0402030101000000, AudioSampleRate_UInt8)
U(0402030101010000, AudioSampleRate)
U(0402030102000000, AudioAverageBitRate)
U(0402030103000000, AudioFixedBitRateFlag)
U(0402030104000000, Locked)
U(0402030105000000, PeakEnvelope)
U(0402030106000000, PeakEnvelopeVersion)
U(0402030107000000, PeakEnvelopeFormat)
U(0402030108000000, PointsPerPeakValue)
U(0402030109000000, PeakEnvelopeBlockSize)
U(040203010A000000, PeakChannels)
U(040203010B000000, PeakFrames)
U(040203010C000000, PeakOfPeaksPosition)
U(040203010D000000, PeakEnvelopeTimestamp)
U(040203010E000000, PeakEnvelopeData)
U(040203010F000000, IABSampleRate)
//            02 - Digital Audio Storage Parameters
U(0402030201000000, BlockAlign)
U(0402030202000000, SequenceOffset)
U(0402030203000000, BlockStartOffset)
U(0402030205000000, QltyFileSecurityReport)
U(0402030206000000, QltyFileSecurityWave)
//            03 - Digital Audio Quantization and Level Parameters
U(0402030301000000, BitsPerSample)
U(0402030302000000, RoundingLaw_ISO7)
U(0402030303000000, Dither_ISO7)
U(0402030304000000, QuantizationBits)
U(0402030305000000, AverageBytesPerSecond)
//            04 - MGA Sound Essence Coding Parameters
U(0402030401000000, MGASoundEssenceBlockAlign)
U(0402030402000000, MGASoundEssenceAverageBytesPerSecond)
U(0402030403000000, MGASoundEssenceSequenceOffset)
//            05 - MGA Audio Metadata Coding Parameters
U(0402030501000000, MGALinkID)
U(0402030502000000, MGAAudioMetadataIndex)
U(0402030503000000, MGAAudioMetadataIdentifier)
U(0402030504000000, MGAAudioMetadataPayloadULArray)
//            06 - MGA Soundfield Group Label Coding Parameters
U(0402030601000000, MGAMetadataSectionLinkID)
U(0402030602000000, ADMAudioProgrammeID)
U(0402030603000000, ADMAudioContentID)
U(0402030604000000, ADMAudioObjectID)
//            07 - S-ADM Audio Metadata Coding Parameters
U(0402030701000000, SADMMetadataSectionLinkID)
U(0402030702000000, SADMProfileLevelULBatch)
//            08 - 
U(0402030801000000, RIFFChunkStreamID)
U(0402030802000000, RIFFChunkID)
U(0402030803000000, RIFFChunkUUID)
U(0402030804000000, RIFFChunkHashSHA1)
U(0402030806000000, RIFFChunkStreamIDsArray)
//            09 - 
U(0402030901000000, NumLocalChannels)
U(0402030902000000, NumADMAudioTrackUIDs)
U(0402030903000000, ADMChannelMappingsArray)
U(0402030904000000, LocalChannelID)
U(0402030905000000, ADMAudioTrackUID)
U(0402030906000000, ADMAudioTrackChannelFormatID)
U(0402030907000000, ADMAudioPackFormatID)
//            0A - 
U(0402030A01000000, RIFFChunkStreamID_link1)
U(0402030A02000000, ADMProfileLevelULBatch)
//            0B - 
U(0402030B01000000, RIFFChunkStreamID_link2)
U(0402030B02000000, ADMAudioProgrammeID_ST2131)
U(0402030B03000000, ADMAudioContentID_ST2131)
U(0402030B04000000, ADMAudioObjectID_ST2131)
//          04 - Digital Audio Compression Parameters
U(0402040100000000, CodingLawKind_ISO7)
U(0402040101000000, CodingLawName_ISO7)
U(0402040200000000, SoundCompression)
U(0402040201000000, AudioCodingSchemeCode_ISO7)
U(0402040202000000, AudioCodingSchemeName_ISO7)
//            03 - MPEG Audio Coding Parameters
//              01 - MPEG-1 Audio Coding Parameters
U(0402040301010000, LayerNumber)
U(0402040301020000, MPEGAudioBitRate)
U(0402040301030000, AACChannelConfiguration)
U(0402040301040000, AACSamplingFrequency)
U(0402040301050000, MPEGAudioChannelAssignment)
//          05 - Digital Audio Processing Parameters
//            01 - AES-3 Processing Parameters
U(0402050101000000, AuxBitsMode)
U(0402050102000000, ChannelStatusMode)
U(0402050103000000, FixedChannelStatusData)
U(0402050104000000, UserDataMode)
U(0402050105000000, FixedUserData)
U(0402050106000000, Emphasis)
U(0402050107000000, LinkedTimecodeTrackID)
U(0402050108000000, DataStreamNumber)
//            02 - BWF Processing Parameters
U(0402050201000000, CodingHistory)
U(0402050201010000, BextCodingHistory)
U(0402050202000000, BasicData)
U(0402050202010000, QltyBasicData)
U(0402050203000000, StartModulation)
U(0402050203010000, QltyStartOfModulation)
U(0402050204000000, QualityEvent)
U(0402050204010000, QltyQualityEvent)
U(0402050205000000, EndModulation)
U(0402050205010000, QltyEndOfModulation)
U(0402050206000000, QualityParameter)
U(0402050206010000, QltyQualityParameter)
U(0402050207000000, OperatorComment)
U(0402050207010000, QltyOperatorComment)
U(0402050208000000, CueSheet)
U(0402050208010000, QltyCueSheet)
//          07 - General Processing Parameters
U(0402070100000000, DialNorm)
//          08 - Film Sound Source
U(0402080100000000, OpticalTrack_ISO7)
U(0402080200000000, MagneticTrack_ISO7)
//          09 - Audio Metadata Elements
U(0402090100000000, ST2109AudioMetadata)
//          10 - Audio Test Parameters
U(0402100100000000, SignalToNoiseRatio)
U(0402100200000000, Weighting_ISO7)
//        03 - Data Essence Characteristics
//          01 - Fundamental Data Essence Parameters
U(0403010100000000, CaptionKind_ISO7)
U(0403010101000000, CaptionKind)
//          02 - Analog Data Essence Coding Parameters
U(0403020100000000, AnalogDataCodingKind_ISO7)
//          03 - Digital Data Essence Coding Parameters
U(0403030100000000, DigitalEncodingBitRate)
U(0403030200000000, DataEssenceCoding)
//          10 - Data Essence Test Parameters
//        04 - Metadata Characteristics
//          01 - Fundamental Metadata Characteristics
//            01 - Timecode Characteristics
U(0404010101000000, TimecodeKind_ISO7)
U(0404010102000000, TimecodeTimebase)
U(0404010102010000, TimecodeStreamSampleRate)
U(0404010102060000, FramesPerSecond)
U(0404010103000000, TimecodeUserBitsFlag)
U(0404010104000000, IncludeSync)
U(0404010105000000, DropFrame)
//            02 - General Date-Time Coding Characteristics
U(0404010201000000, DateTimeRate)
U(0404010202000000, DateTimeDropFrame)
U(0404010203000000, DateTimeEmbedded)
U(0404010204000000, DateTimeKind)
//          02 - Analog Metadata Coding Characteristics
U(0404020100000000, TimecodeSource)
U(0404020200000000, AnalogMetadataCarrier_ISO7)
//          03 - Digital Metadata Coding Characteristics
U(0404030100000000, DigitalMetadataCarrier_ISO7)
//          04 - Indexing Metadata Coding Characteristics
//            01 - Intra Edit Unit Indexing
U(0404040101000000, SliceCount)
U(0404040102000000, Slice)
U(0404040103000000, ElementDelta)
U(0404040104000000, PositionTableIndex)
U(0404040105000000, SliceOffset)
U(0404040106000000, DeltaEntryArray)
U(0404040107000000, PositionTableCount)
U(0404040108000000, PositionTable)
//            02 - Inter Edit Unit Indexing
U(0404040201000000, StreamOffset)
U(0404040202000000, Flags)
U(0404040203000000, TemporalOffset)
U(0404040204000000, KeyFrameOffset)
U(0404040205000000, IndexEntryArray)
U(0404040206000000, ContentPackageIndexArray)
//            03 - Video Index Parameters
U(0404040301000000, VideoIndexArray)
//          05 - Index Locations
U(0404050100000000, SingleIndexLocation)
U(0404050200000000, ForwardIndexDirection)
U(0404050300000000, IsRIPPresent)
U(0404050400000000, PrecedingIndexTable)
U(0404050500000000, FollowingIndexTable)
U(0404050600000000, IsSparse)
//          10 - Metadata Test Parameters
//        05 - Monitoring and Control Characteristics
//          01 - Fundamental Monitoring and Control Characteristics
U(0405011300000000, SignalStandard)
//          02 - Analog Monitoring and Control Coding Characteristics
U(0405020100000000, AnalogMonitoringAndControlCodingKind_ISO7)
//          03 - Digital Monitoring and Control Coding Parameters
//            01 - Digital Monitoring and Control Sampling Parameters
//          10 - Monitoring and Control Test Parameters
//        06 - General Coding Characteristics
//          01 - General Essence Coding Characteristics
U(0406010100000000, SampleRate)
U(0406010200000000, EssenceLength)
U(0406010300000000, DataStreamSampleRate)
//          02 - General Essence Container Characteristics
U(0406020100000000, EditUnitByteCount)
U(0406020200000000, ApproxImageContainerSize)
U(0406020300000000, ProductFormat_ISO7)
U(0406020301000000, ProductFormat)
U(0406020400000000, ExtStartOffset)
U(0406020500000000, VBEByteCount)
U(0406020600000000, SingleEssenceLocation)
U(0406020700000000, SingularPartitionUsage)
//          08 - General Metadata Coding Characteristics
U(0406080100000000, MetadataEncodingSchemeCode_ISO7)
U(0406080200000000, ChunkID)
U(0406080300000000, ApplicationScheme)
U(0406080400000000, DescriptiveMetadataScheme)
U(0406080500000000, UDAMSetIdentifier)
U(0406080600000000, TextBasedMetadataPayloadSchemeID)
U(0406080700000000, UDAMSetVersion)
//          09 - General Metadata Container Characteristics
U(0406090100000000, HeaderByteCount)
U(0406090200000000, IndexByteCount)
U(0406090300000000, ChunkLength)
//          10 - General Data Coding Characteristics
U(0406100100000000, PackLength)
U(0406100200000000, SourceLength)
U(0406100300000000, DataStreamSchemeURI)
//        07 - General Essence and Data Parameters
U(0407010000000000, ComponentDataDefinition)
U(0407010100000000, DataDefinition)
U(0407020000000000, EssenceStream)
U(0407030000000000, TimecodeStreamData)
U(0407040000000000, ChunkData)
//        08 - Object Characteristics
//        09 - Format Characteristics
U(0409010000000000, RecordedFormat_ISO7)
U(0409010100000000, RecordedFormat)
U(0409020000000000, MIMEMediaType_ISO7)
U(0409020100000000, MIMEType)
U(0409020200000000, TextMIMEMediaType)
U(0409030000000000, CharSet)
U(0409030100000000, MIMECharSet_ISO7)
U(0409040000000000, MIMEEncoding_ISO7)
U(0409040100000000, MIMEEncoding)
U(0409050000000000, UCSEncoding)
//        0F - Storage Characteristics
U(040F010000000000, StorageKind_ISO7)
U(040F010100000000, StorageKind)
U(040F010200000000, StorageKindCode_ISO7)
//        10 - Medium Characteristics
//          01 - Storage Medium Parameters
//            01 - Tape Medium Parameters
U(0410010101000000, TapeShellKind_ISO7)
U(0410010101010000, TapeFormFactor)
U(0410010102000000, TapeFormulation_ISO7)
U(0410010102010000, TapeFormulation)
U(0410010103000000, TapeCapacity)
U(0410010104000000, TapeManufacturer_ISO7)
U(0410010104010000, TapeManufacturer)
U(0410010105000000, TapeStock_ISO7)
U(0410010105010000, TapeStock)
U(0410010106000000, TapeBatchNumber_ISO7)
U(0410010106010000, TapeBatchNumber)
//              10 - Tape Medium Fundamental Parameters
U(0410010110010000, TapePartitionCapacity)
//            02 - Disc Medium Parameters
//              01 - Disc Medium Fundamental Parameters
U(0410010202000000, DiscPartitionCapacity)
//            03 - Film Medium Parameters
//              01 - Generic Film Medium Parameters
U(0410010301010000, FilmColorProcess_ISO7)
U(0410010301020000, EdgeCodeFormat)
U(0410010301030000, PerforationsPerFrame)
U(0410010301030100, PerforationsPerFrame_Rational)
U(0410010301040000, FilmFormatName_ISO7)
U(0410010301040100, FilmFormatName)
U(0410010301040200, FilmFormatName_FilmType)
U(0410010301050000, FilmStockKind_ISO7)
U(0410010301050100, FilmStockKind)
U(0410010301060000, FilmStockManufacturerName_ISO7)
U(0410010301060100, FilmStockManufacturer)
U(0410010301070000, FilmBatchNumber_ISO7)
U(0410010301070100, FilmBatchNumber)
U(0410010301080000, FilmFormat)
U(0410010301090000, EdgeCodeFilmFormat)
//              02 - Specific Film Medium Parameters
U(0410010302010000, PhysicalMediaLength)
U(0410010302020000, FilmCaptureAperture_ISO7)
U(0410010302030000, FilmAspectRatio)
//        18 - Memory Storage Characteristics
//          01 - Memory Storage Alignment Characteristics
U(0418010100000000, ImageAlignmentFactor)
U(0418010200000000, ImageStartOffset)
U(0418010300000000, ImageEndOffset)
U(0418010400000000, PaddingBits)
//        20 - Device Characteristics
//          01 - Camera Characteristics
//            01 - Image Characteristics
U(0420010101000000, ImageCategory_ISO7)
//            02 - Imager Characteristics
//              01 - Image Devices
U(0420010201010000, ImageSourceDeviceKind_ISO7)
U(0420010201010100, ImageSourceDeviceKind)
//            03 - Acquisition Characteristics
//              01 - CameraOperation
U(0420010301010000, AutoExposureMode)
U(0420010301020000, AutoFocusSensingAreaSetting)
U(0420010301030000, ColorCorrectionFilterWheelSetting)
U(0420010301040000, NeutralDensityFilterWheelSetting)
U(0420010301050000, ImageSensorDimensionEffectiveWidth)
U(0420010301060000, ImageSensorDimensionEffectiveHeight)
U(0420010301070000, ImageSensorReadoutMode)
U(0420010301080000, ShutterSpeedAngle)
U(0420010301080100, ShutterSpeedTime)
U(0420010301090000, CameraMasterGainAdjustment)
U(04200103010A0000, ISOSensitivity)
U(04200103010A0100, ISOSensitivityLongInteger)
U(04200103010B0000, ElectricalExtenderMagnification)
U(04200103010C0000, ExposureIndexOfPhotoMeter)
U(04200103010C0100, ExposureIndexOfPhotoMeterLongInteger)
U(04200103010D0000, ColorMatrix)
U(04200103010E0000, RotaryShutter)
U(04200103010F0000, OpticalAntiAliasingFilter)
U(0420010301100000, ImageSensorDecimationRatio)
U(0420010301110000, ImageScanDirection)
U(0420010301120000, LuminanceCodeRange)
U(0420010301130000, AcquisitionSettingProcedure)
//              02 - Adjustment
U(0420010302010000, AutoWhiteBalanceMode)
U(0420010302020000, WhiteBalance)
U(0420010302030000, CameraMasterBlackLevel)
U(0420010302040000, CameraKneePoint)
U(0420010302050000, CameraKneeSlope)
U(0420010302060000, CameraLuminanceDynamicRange)
U(0420010302070000, GammaForCDL)
U(0420010302080000, ASCCDLV12)
U(0420010302090000, TintCorrection)
U(04200103020A0000, ColorForCDL)
//          02 - Optical Characteristics
//            01 - Optical Test Parameters
//              01 - Optical Device Parameters
U(0420020101010000, OpticalTestParameterName_ISO7)
U(0420020101020000, OpticalTestResult_Float)
U(0420020101030000, OpticalTestResult)
U(0420020101040000, FocalLength_Float)
U(0420020101040100, FocalLength)
U(0420020101050000, SensorSize_ISO7)
U(0420020101060000, LensAperture)
U(0420020101070000, SensorTypeCode_ISO7)
U(0420020101080000, FieldOfViewFOVHorizontal)
U(0420020101080100, FieldOfViewFOVHorizontalFP4)
U(0420020101090000, AnamorphicLensCharacteristic_ISO7)
U(04200201010A0000, FieldOfViewFOVVertical)
U(04200201010A0100, FieldOfViewFOVVerticalFP4)
//            02 - Optical Shooting Parameters
U(0420020201000000, IrisFNumber)
U(0420020202000000, FocusPositionFromImagePlane)
U(0420020203000000, FocusPositionFromFrontLensVertex)
U(0420020204000000, MacroSetting)
U(0420020205000000, LensZoom35mmStillCameraEquivalent)
U(0420020206000000, LensZoomActualFocalLength)
U(0420020207000000, OpticalExtenderMagnification)
U(0420020208000000, IrisTNumber)
U(0420020209000000, IrisRingPosition)
U(042002020A000000, FocusRingPosition)
U(042002020B000000, ZoomRingPosition)
U(042002020C000000, AnamorphicLensSqueezeRatio)
U(042002020D000000, OpticalInversion)
//          03 - Microphone Characteristics
U(0420030100000000, SensorType_ISO7)
U(0420030200000000, PolarCharacteristic_ISO7)
//          04 - Display Characteristics
//            01 - Mastering Display Characteristics
//              01 - Mastering Display Color Volume
U(0420040101010000, MasteringDisplayPrimaries)
U(0420040101020000, MasteringDisplayWhitePointChromaticity)
U(0420040101030000, MasteringDisplayMaximumLuminance)
U(0420040101040000, MasteringDisplayMinimumLuminance)
//              02 - MD Color Volume
U(0420040102010000, MDPrimaries)
U(0420040102020000, MDWhitePointChromaticity)
U(0420040102030000, MDMaximumLuminance)
U(0420040102040000, MDMinimumLuminance)
//        30 - System Characteristics
U(0430010000000000, SystemNameOrNumber_ISO7)
//      05 - Process
//        01 - General Process Indicators
//          01 - Process Fundamentals
U(0501010100000000, IntegrationIndication_ISO7)
U(0501010101000000, IntegrationIndication)
U(0501010200000000, EventIndication_ISO7)
U(0501010201000000, EventIndication)
U(0501010300000000, QualityFlag)
U(0501010400000000, LogoFlag)
U(0501010500000000, PhysicalInstanceKind_ISO7)
U(0501010600000000, GraphicKind_ISO7)
U(0501010700000000, GraphicUsageKind_ISO7)
U(0501010701000000, GraphicUsage)
U(0501010800000000, PackageUsage)
//          02 - Content Capture
U(0501020100000000, DigitalOrAnalogOrigination_ISO7)
//            02 - Video or Image Capture Process
//            03 - Film Capture Process
//            04 - Audio Capture Process
U(0501020401000000, MicrophonePlacementTechniques_ISO7)
//            05 - Data Capture Process
U(0501020601000000, DeviceCreatorName)
U(0501020602000000, DeviceProductName)
U(0501020603000000, DeviceVersion)
U(0501020604000000, DeviceInstanceIdentifier)
//          03 - Manipulation
U(0501030100000000, SimpleFlagging)
U(0501030200000000, CopyCount)
U(0501030201000000, GenerationCopyNumber)
U(0501030300000000, CloneCount)
U(0501030301000000, GenerationCloneNumber)
U(0501030400000000, WorkInProgressFlag)
//          04 - Music Flags
U(0501040100000000, SignatureTuneFlag)
U(0501040200000000, BackgroundMusicFlag)
U(0501040300000000, ThemeMusicFlag)
U(0501040400000000, InsertMusicFlag)
//        02 - Compression Processing
//          01 - Video or Image Compression
U(0502010100000000, VideoOrImageCompressionAlgorithm_ISO7)
//            02 - MPEG Processing
//              01 - MPEG-2 Processing
U(0502010201010000, SplicingMetadata)
//            03 - JPEG Processing
//              01 - TIFF JPEG Processing
U(0502010301010000, IsUniform)
U(0502010301020000, JPEGTableID)
//              02 - JFIF JPEG Processing
//          02 - Audio Compression
U(0502020100000000, AudioCompressionAlgorithm_ISO7)
//          03 - Data Essence Compression
//          04 - Metadata Compression
//        03 - Noise Reduction Processing
//          01 - Video Noise Reduction
U(0503010100000000, VideoNoiseReductionAlgorithm_ISO7)
//          02 - Audio Noise Reduction
U(0503020100000000, AudioNoiseReductionAlgorithm_ISO7)
//        20 - Enhancement or Modification
//          01 - Image Essence Processing
U(0520010100000000, EnhancementOrModificationDescription_ISO7)
U(0520010200000000, AlphaTransparency)
//          02 - Video Processor Settings
U(0520020100000000, VideoDeviceKind_ISO7)
U(0520020200000000, VideoDeviceParameterName_ISO7)
U(0520020300000000, VideoDeviceParameterSetting_ISO7)
//          03 - Audio Essence Processing
U(0520030100000000, AudioEnhancementOrModificationDescription_ISO7)
U(0520030200000000, AudioFirstMixDownProcess_ISO7)
//          04 - Audio Processor Settings
U(0520040100000000, AudioDeviceKind_ISO7)
U(0520040200000000, AudioDeviceParameter_ISO7)
U(0520040300000000, AudioDeviceParameterSetting_ISO7)
//          05 - Data Essence Processing
U(0520050100000000, DataEnhancementOrModificationDescription_ISO7)
//          06 - Data Processor Settings
U(0520060100000000, DataDeviceKind_ISO7)
U(0520060200000000, DataDeviceParameterName_ISO7)
U(0520060300000000, DataDeviceParameterSetting_ISO7)
//          07 - Metadata Processing
//            01 - Modification Information
U(0520070101000000, GenerationID)
U(0520070102000000, ApplicationSupplierName_ISO7)
U(0520070102010000, ApplicationSupplierName)
U(0520070103000000, ApplicationName_ISO7)
U(0520070103010000, ApplicationName)
U(0520070104000000, ApplicationVersion)
U(0520070105000000, ApplicationVersionString_ISO7)
U(0520070105010000, ApplicationVersionString)
U(0520070106000000, ApplicationPlatform_ISO7)
U(0520070106010000, ApplicationPlatform)
U(0520070107000000, ApplicationProductID)
U(0520070108000000, LinkedGenerationID)
U(0520070109000000, ContainerVersion)
U(052007010A000000, ToolkitVersion)
U(052007010B000000, LinkedApplicationPluginInstanceID)
U(052007010C000000, LinkedDescriptiveFrameworkPluginID)
U(052007010D000000, ApplicationPluginInstanceID)
U(052007010E000000, DescriptiveMetadataPlugInID)
U(052007010F000000, ApplicationEnvironmentID)
U(0520070110000000, DescriptiveMetadataApplicationEnvironmentID)
U(0520070111000000, LinkedDescriptiveObjectPluginID)
//          08 - Metadata Processor Settings
//          09 - Code Processor Settings
U(0520090100000000, PluginCategory)
U(0520090200000000, PluginPlatform)
U(0520090300000000, MinPlatformVersion)
U(0520090400000000, MaxPlatformVersion)
U(0520090500000000, Engine)
U(0520090600000000, MinEngineVersion)
U(0520090700000000, MaxEngineVersion)
U(0520090800000000, PluginAPI)
U(0520090900000000, MinPluginAPI)
U(0520090A00000000, MaxPluginAPI)
U(0520090B00000000, SoftwareOnly)
U(0520090C00000000, Accelerator)
U(0520090D00000000, PluginLocators)
U(0520090E00000000, Authentication)
U(0520090F00000000, ImplementedClass)
//        30 - Editing Information
//          01 - Editing Version Information
//          02 - Editing Decision Information
U(0530020100000000, DefaultFadeType)
//          03 - Editing Matte Information
//          04 - Editing Event Information
U(0530040100000000, ActiveState)
U(0530040200000000, EventTrackEditRate)
U(0530040300000000, DefaultFadeEditUnit)
U(0530040400000000, EventComment_ISO7)
U(0530040401000000, EventComment)
U(0530040500000000, EditRate)
U(0530040600000000, IndexEditRate)
//          05 - Editing Effect Information
U(0530050100000000, FadeInType)
U(0530050200000000, FadeOutType)
U(0530050300000000, IsTimeWarp)
U(0530050400000000, OperationInputCount)
U(0530050500000000, Bypass)
U(0530050600000000, Operation)
U(0530050700000000, Value)
U(0530050800000000, EditHint)
U(0530050900000000, OperationDataDefinition)
U(0530050A00000000, OperationCategory)
U(0530050B00000000, DisplayUnits_ISO7)
U(0530050B01000000, ParameterDisplayUnits)
U(0530050C00000000, BypassOverride)
U(0530050D00000000, ControlPointValue)
//          06 - Editing Web Information
U(0530060100000000, BeginAnchor_ISO7)
U(0530060101000000, BeginAnchor)
U(0530060200000000, EndAnchor_ISO7)
U(0530060201000000, EndAnchor)
//          07 - Editing User Notes
//        31 - Color Transform Information
//          01 - DMCVT Essence Items
U(0531010100000000, ApplicationIdentifier)
U(0531010200000000, ApplicationVersionNumber)
U(0531010300000000, BackwardsVersion)
U(0531010400000000, TimeIntervalStart)
U(0531010500000000, TimeIntervalDuration)
U(0531010600000000, UpperLeftCorner)
U(0531010700000000, LowerRightCorner)
U(0531010800000000, WindowNumber)
U(0531010900000000, TargetedSystemDisplayPrimaries)
U(0531010A00000000, TargetedSystemDisplayWhitePointChromaticity)
U(0531010B00000000, TargetedSystemDisplayMaximumLuminance)
U(0531010C00000000, TargetedSystemDisplayMinimumLuminance)
U(0531010D00000000, MinimumPqencodedMaxrgb)
U(0531010E00000000, AveragePqencodedMaxrgb)
U(0531010F00000000, MaximumPqencodedMaxrgb)
U(0531011000000000, MinimumPqencodedMaxrgbOffset)
U(0531011100000000, AveragePqencodedMaxrgbOffset)
U(0531011200000000, MaximumPqencodedMaxrgbOffset)
U(0531011300000000, ToneMappingOffset)
U(0531011400000000, ToneMappingGain)
U(0531011500000000, ToneMappingGamma)
U(0531011600000000, ChromaCompensationWeight)
U(0531011700000000, SaturationGain)
U(0531011800000000, ToneDetailFactor)
U(0531011900000000, LuminanceLowerBound)
U(0531011A00000000, LuminanceUpperBound)
U(0531011B00000000, LuminanceRangeSelector)
U(0531011C00000000, ChromaticityDiskCenter)
U(0531011D00000000, ChromaticityDiskRadius)
U(0531011E00000000, ChromaticityAreaSelector)
U(0531011F00000000, SaturationGainFunction)
U(0531012000000000, ToneMappingInputSignalWeights)
U(0531012100000000, ToneMappingInputSignalBlackLevelOffset)
U(0531012200000000, ToneMappingInputSignalWhiteLevelOffset)
U(0531012300000000, ShadowGainControl)
U(0531012400000000, HighlightGainControl)
U(0531012500000000, MidToneWidthAdjustmentFactor)
U(0531012600000000, ToneMappingOutputFineTuningFunction)
U(0531012700000000, TargetedSystemDisplaySignalFormat)
U(0531012800000000, MetadataColorCodingWorkspace)
U(0531012900000000, PreMatrixToneMapping1)
U(0531012A00000000, PreMatrixToneMapping2)
U(0531012B00000000, PreMatrixToneMapping3)
U(0531012C00000000, ColorRemappingMatrix)
U(0531012D00000000, PostMatrixToneMapping1)
U(0531012E00000000, PostMatrixToneMapping2)
U(0531012F00000000, PostMatrixToneMapping3)
U(0531013000000000, CenterOfEllipse)
U(0531013100000000, RotationAngle)
U(0531013200000000, SemiMajorAxisInternalEllipse)
U(0531013300000000, SemiMajorAxisExternalEllipse)
U(0531013400000000, SemiMinorAxisExternalEllipse)
U(0531013500000000, OverlapProcessOption)
U(0531013600000000, TargetedSystemDisplayActualPeakLuminance)
U(0531013700000000, RowsInTargetedSystemDisplayActualPeakLuminance)
U(0531013800000000, MasteringDisplayActualPeakLuminance)
U(0531013900000000, RowsInMasteringDisplayActualPeakLuminance)
U(0531013A00000000, MaxSCL)
U(0531013B00000000, AverageMaxRGB)
U(0531013C00000000, DistributionMaxRGBPercentages)
U(0531013D00000000, DistributionMaxRGBPercentiles)
U(0531013E00000000, FractionBrightPixels)
U(0531013F00000000, KneePoint)
U(0531014000000000, BezierCurveAnchors)
U(0531014100000000, ColorSaturationWeight)
U(0531014200000000, MaximumContentLightLevel)
U(0531014300000000, MaximumFrameAverageLightLevel)
//          02 - DMCVT SubDescriptor Items
U(0531020100000000, DMCVTApplicationIdentifier)
U(0531020200000000, DMCVTApplicationVersionNumber)
U(0531020300000000, DMCVTBackwardsVersion)
U(0531020900000000, DMCVTTargetedSystemDisplayPrimaries)
U(0531020A00000000, DMCVTTargetedSystemDisplayWhitePointChromaticity)
U(0531020B00000000, DMCVTTargetedSystemDisplayMaximumLuminance)
U(0531020C00000000, DMCVTTargetedSystemDisplayMinimumLuminance)
U(0531022700000000, DMCVTTargetedSystemDisplaySignalFormat)
U(0531023600000000, DMCVTTargetedSystemDisplayActualPeakLuminance)
U(0531023700000000, DMCVTRowsInTargetedSystemDisplayActualPeakLuminance)
//        40 - Processing History
//          01 - Video Compression History
U(0540010100000000, VideoCompressionAlgorithm_ISO7)
U(0540010200000000, MPEGVideoRecodingDataset)
//          02 - Audio Compression History
U(0540020100000000, UpstreamAudioCompressionAlgorithm_ISO7)
U(0540020200000000, MPEGAudioRecodingDataset)
//          03 - Data Compression History
//          04 - Metadata Compression History
//          10 - Transfer History
//            01 - Image Transfer History
U(0540100101000000, PulldownDirection)
U(0540100102000000, PulldownKind)
U(0540100103000000, PhaseFrame)
//      06 - Relational
//        01 - Generic Relationships
//          01 - Essence and Metadata Relationships
//            01 - Essence to Essence Relationships
U(0601010101000000, TeletextSubtitlesFlag)
U(0601010102000000, SubtitleDatafileFlag)
U(0601010103000000, ClosedCaptionSubtitlesFlag)
//            02 - Metadata to Essence Relationships
U(0601010201000000, SampleIndex)
U(0601010202000000, SourceContainerFormat)
U(0601010203000000, SourceKey)
U(0601010204000000, DisplayType)
U(0601010205000000, IntrinsicPictureResolution)
U(0601010206000000, ZpositionInUse)
U(0601010207000000, LinkedDataStreamID)
//            03 - Metadata to Metadata Relationships
U(0601010301000000, SourcePackageID)
U(0601010302000000, SourceTrackID)
U(0601010303000000, RelativeScope)
U(0601010304000000, RelativeTrack)
U(0601010305000000, LinkedTrackID)
U(0601010306000000, ChannelID)
U(0601010307000000, ChannelIDs)
U(0601010308000000, MonoSourceTrackIDs)
U(0601010309000000, DynamicSourcePackageID)
U(060101030A000000, DynamicSourceTrackIDs)
U(060101030B000000, SourceIndex)
U(060101030C000000, SourceSpecies)
U(060101030D000000, SourceValue)
U(060101030E000000, TimebaseReferenceTrackID)
U(060101030F000000, ASMEventIDBatch)
U(0601010310000000, ASMLinkEncryptionKeyBatch)
U(0601010311000000, ASMLinkEncryptionKeyIDBatch)
//            04 - Object to Object Relationships
//              01 - Weak References
U(0601010401010000, ObjectClass)
U(0601010401020000, ContainerFormat)
U(0601010401020100, EssenceContainerFormat)
U(0601010401030000, Codec)
U(0601010401030100, RP224CodecDefinition)
U(0601010401040000, ParameterDefinitionReference)
U(0601010401050000, Interpolation)
U(0601010401060000, ParameterType)
U(0601010401070000, FileDescriptorClass)
U(0601010401080000, PrimaryPackage)
U(0601010401090000, KLVDataType)
U(06010104010A0000, CompositionRendering)
U(06010104010B0000, BaseClass)
//              02 - Strong References
U(0601010402010000, ContentStorageObject)
U(0601010402020000, DictionaryReference)
U(0601010402030000, EssenceDescription)
U(0601010402040000, TrackSegment)
U(0601010402050000, TransitionOperation)
U(0601010402060000, Rendering)
U(0601010402070000, InputSegment)
U(0601010402080000, StillFrame)
U(0601010402090000, SelectedSegment)
U(06010104020A0000, AnnotationSource)
U(06010104020B0000, ManufacturerInfo)
U(06010104020C0000, DescriptiveFrameworkObject)
U(06010104020D0000, CryptographicContextObject)
U(06010104020E0000, ApplicationPlugInObjects)
U(06010104020F0000, PackageMarkerObject)
U(0601010402100000, PackageTimelineMarkerObject)
U(0601010402110000, RegisterAdministrationObject)
U(0601010402120000, RegisterEntryAdministrationObject)
//                40 - Strong Referencing to Descriptive Metadata Sets
U(0601010402400500, GroupSet)
U(0601010402401C00, BankDetailsSet)
U(0601010402401D00, PictureFormatObject)
U(0601010402402000, ProcessingObject)
U(0601010402402100, ProjectObject)
U(0601010402402200, ContactsListObject)
//                  23 - Cue Words Sets
U(0601010402402301, AnnotationCueWordsObject)
U(0601010402402302, ShotCueWordsObject)
//              03 - Weak References Batches
U(0601010403010000, CodecDataDefinitions)
U(0601010403020000, OperationParametersDefined)
U(0601010403030000, DescriptiveMetadataSets)
U(0601010403040000, KLVDataParentProperties)
U(0601010403050000, TaggedValueParentProperties)
U(0601010403060000, GenericPayloads)
//                40 - Weak Referencing to Descriptive Metadata Sets
//                  13 - Participant Role Sets
U(0601010403401301, AwardParticipants)
U(0601010403401302, ContractParticipants)
U(0601010403401303, AnnotationParticipants)
U(0601010403401304, CaptionsDescriptionParticipantSets)
U(0601010403401400, Persons)
//                  15 - Organization Sets
U(0601010403401501, ParticipantOrganizations)
U(0601010403401502, PersonOrganizations)
U(0601010403401600, Locations)
//              04 - Weak References Arrays
U(0601010404010000, DegradeTo)
U(0601010404020000, DescriptiveMetadataSetReferences)
//              05 - Strong References Batches
U(0601010405010000, Packages)
U(0601010405020000, EssenceDataObjects)
U(0601010405030000, OperationDefinitions)
U(0601010405040000, ParameterDefinitions)
U(0601010405050000, DataDefinitions)
U(0601010405060000, PluginDefinitions)
U(0601010405070000, CodecDefinitions)
U(0601010405080000, ContainerDefinitions)
U(0601010405090000, InterpolationDefinitions)
U(06010104050A0000, KLVDataDefinitions)
U(06010104050B0000, TaggedValueDefinitions)
//                40 - Strong References to Descriptive Metadata Batches
U(0601010405400400, TitlesObjects)
U(0601010405400500, GroupRelationshipObjects)
U(0601010405400600, IdentificationObjects)
U(0601010405400700, EpisodicItemSets)
U(0601010405400800, BrandingObjects)
U(0601010405400900, EventObjects)
U(0601010405400A00, PublicationObjects)
U(0601010405400B00, AwardObjects)
U(0601010405400C00, CaptionsDescriptionObjects)
U(0601010405400D00, AnnotationObjects)
U(0601010405400D01, EventAnnotationObjects)
//                  0E - Setting Period Sets
U(0601010405400E01, ProductionSettingPeriodObjects)
U(0601010405400E02, SceneSettingPeriodObjects)
U(0601010405400F00, ScriptingObjects)
U(0601010405401000, ClassificationObjects)
//                  11 - Shot Sets
U(0601010405401101, SceneShotObjects)
U(0601010405401102, ClipShotObjects)
U(0601010405401200, KeyPointObjects)
U(0601010405401300, ParticipantObjects)
U(0601010405401400, PersonObjects)
U(0601010405401500, OrganizationObjects)
U(0601010405401600, LocationObjects)
U(0601010405401700, AddressObjects)
U(0601010405401800, CommunicationsObjects)
U(0601010405401900, ContractObjects)
U(0601010405401A00, RightsObjects)
U(0601010405401B00, PaymentsSets)
U(0601010405401E00, DeviceParametersObjects)
//                  1F - Name-Value Sets
U(0601010405401F01, ClassificationNameValueObjects)
U(0601010405401F02, ContactNameValueObjects)
U(0601010405401F03, DeviceParametersNameValueObjects)
U(0601010405401F04, AddressNameValueObjects)
//                41 - Text-Based Descriptive Metadata Sets
U(0601010405410100, TextBasedObject)
//              06 - Strong References Arrays
U(0601010406010000, Choices)
U(0601010406020000, InputSegments)
U(0601010406030000, Locators)
U(0601010406040000, IdentificationList)
U(0601010406050000, PackageTracks)
U(0601010406060000, PointList)
U(0601010406070000, NestedScopeTracks)
U(0601010406080000, AlternateSegments)
U(0601010406090000, ComponentObjects)
U(06010104060A0000, Parameters)
U(06010104060B0000, FileDescriptors)
U(06010104060C0000, MetadataServerLocators)
U(06010104060D0000, RelatedMaterialLocators)
U(06010104060E0000, ScriptingLocators)
U(06010104060F0000, UnknownBWFChunks)
U(0601010406100000, SubDescriptors)
U(0601010406110000, RegisterEntryArray)
U(0601010406120000, RegisterAdministrationArray)
U(0601010406130000, ApplicationInformationArray)
U(0601010406140000, RegisterChildEntryArray)
//            05 - Metadata to Object Relationships
//            06 - Essence to Object Relationships
U(0601010601000000, LinkedPackageID)
U(0601010602000000, EncryptedTrackFileID)
U(0601010603000000, CryptographicContextLink)
//            07 - Object Dictionary to Metadata Relationships
U(0601010701000000, ParentClass)
U(0601010702000000, Properties)
U(0601010703000000, IsConcrete)
U(0601010704000000, PropertyType)
U(0601010705000000, LocalIdentification)
U(0601010706000000, IsUniqueIdentifier)
U(0601010707000000, ClassDefinitions)
U(0601010708000000, TypeDefinitions)
U(0601010709000000, ReferencedType)
U(060101070A000000, WeakReferencedType)
U(060101070B000000, ElementType)
U(060101070C000000, FixedArrayElementType)
U(060101070D000000, VariableArrayElementType)
U(060101070E000000, SetElementType)
U(060101070F000000, StringElementType)
U(0601010710000000, StreamElementType)
U(0601010711000000, MemberTypes)
U(0601010712000000, RenamedType)
U(0601010713000000, MetaDefinitionIdentification)
U(0601010714000000, DictionaryDescription_ISO7)
U(0601010714010000, MetaDefinitionDescription)
U(0601010715000000, LocalTagEntries)
U(0601010716000000, RootMetaDictionary)
U(0601010717000000, RootPreface)
U(0601010718000000, RootObjectDirectory)
U(0601010719000000, RootFormatVersion)
U(060101071A000000, RootExtensions)
U(060101071B000000, ExtensionSchemeID)
U(060101071C000000, SymbolSpaceURI)
U(060101071D000000, PreferredPrefix)
U(060101071E000000, ExtensionDescription)
U(060101071F000000, MetaDefinitions)
U(0601010720000000, OriginalProperty)
U(0601010721000000, ElementOf)
U(0601010722000000, MemberOf)
//        02 - Related Production Material
U(0602010000000000, ProgramSupportMaterialReference_ISO7)
U(0602020000000000, AdvertisingMaterialReference_ISO7)
U(0602030000000000, ProgramCommercialMaterialReference_ISO7)
//        03 - Related Production Content
//          05 - Related Textual Content
U(0603050100000000, ProductionScriptReference_ISO7)
U(0603050101000000, ProductionScriptReference)
U(0603050200000000, TranscriptReference_ISO7)
U(0603050201000000, TranscriptReference)
//        08 - Stream and Storage Relationships
//          01 - Stream Relationships
//            01 - Continuity Counts
U(0608010101000000, BlockContinuityCount)
//            02 - Stream Positional Relationships
U(0608010201000000, StreamPositionIndicator_UInt8)
U(0608010201010000, StreamPositionIndicator_UInt16)
U(0608010201020000, StreamPositionIndicator_UInt32)
U(0608010201030000, BodyOffset)
//          02 - Storage Relationships
U(0608020100000000, IsContiguous)
//            02 - Storage Offsets
U(0608020201000000, OffsetToMetadata_Int32)
U(0608020201010000, OffsetToMetadata)
U(0608020202000000, OffsetToIndexTable_Int32)
U(0608020202010000, OffsetToIndexTable)
//        09 - Data Relationships
//          02 - Local Data Relationships
//            01 - Data Offsets
U(0609020101000000, ByteOffset)
U(0609020102000000, ReversePlay)
U(0609020103000000, PlaintextOffset)
//        10 - Numerical Sequence
U(0610010000000000, PositionInSequence)
U(0610020000000000, RelativePositionInSequenceOffset)
U(0610030000000000, RelativePositionInSequenceName_ISO7)
U(0610040000000000, TotalNumberInSequence)
U(0610050000000000, TripletSequenceNumber)
//          10 - Relative Numerical Sequences
U(0610100100000000, FirstNumberInSequence_UInt32)
U(0610100101000000, FirstNumberInSequence)
U(0610100200000000, PreviousNumberInSequence)
U(0610100201000000, PreviousPartition)
U(0610100300000000, CurrentNumberInSequence)
U(0610100301000000, ThisPartition)
U(0610100400000000, NextNumberInSequence_Int32)
U(0610100401000000, NextNumberInSequence)
U(0610100500000000, LastNumberInSequence)
U(0610100501000000, FooterPartition)
//      07 - Spatio-temporal
//        01 - Position and Space Vectors
//          01 - Positional System Information
U(0701010100000000, ImageCoordinateSystem_ISO7)
U(0701010200000000, MapDatumUsed_ISO7)
U(0701010300000000, HorizontalDatum_ISO7)
U(0701010400000000, VerticalDatum_ISO7)
//          02 - Positional Information
//            01 - Absolute Position
//              01 - Local Datum Absolute Position
U(0701020101010000, LocalDatumAbsolutePositionAccuracy)
//              02 - Device Absolute Position
U(0701020102010000, DeviceAbsolutePositionalAccuracy)
U(0701020102020000, DeviceAltitude)
U(0701020102020100, DeviceAltitudeConcise)
U(0701020102040000, DeviceLatitude_Float)
U(0701020102040100, DeviceLatitudeDegreesConcise)
U(0701020102040200, DeviceLatitude)
U(0701020102060000, DeviceLongitude_Float)
U(0701020102060100, DeviceLongitudeDegreesConcise)
U(0701020102060200, DeviceLongitude)
U(0701020102100000, DeviceXDimension)
U(0701020102110000, DeviceYDimension)
U(0701020102300000, NMEA0183GPSDocumentText_ISO7)
//              03 - Subject Absolute Position
U(0701020103010000, FramePositionalAccuracy)
U(0701020103020000, FrameCenterLatitude)
U(0701020103020200, FrameCenterLatitude02)
U(0701020103030000, FrameCenterLatitudeDegreesConcise)
U(0701020103040000, FrameCenterLongitude)
U(0701020103040200, FrameCenterLongitude02)
U(0701020103050000, FrameCenterLongitudeDegreesConcise)
U(0701020103060000, FrameCenterLatLong)
U(0701020103070000, CornerLatitudePoint1_ISO7)
U(0701020103070100, CornerLatitudePoint1DecimalDegrees)
U(0701020103080000, CornerLatitudePoint2_ISO7)
U(0701020103080100, CornerLatitudePoint2DecimalDegrees)
U(0701020103090000, CornerLatitudePoint3_ISO7)
U(0701020103090100, CornerLatitudePoint3DecimalDegrees)
U(07010201030A0000, CornerLatitudePoint4_ISO7)
U(07010201030A0100, CornerLatitudePoint4DecimalDegrees)
U(07010201030B0000, CornerLongitudePoint1_ISO7)
U(07010201030B0100, CornerLongitudePoint1DecimalDegrees)
U(07010201030C0000, CornerLongitudePoint2_ISO7)
U(07010201030C0100, CornerLongitudePoint2DecimalDegrees)
U(07010201030D0000, CornerLongitudePoint3_ISO7)
U(07010201030D0100, CornerLongitudePoint3DecimalDegrees)
U(07010201030E0000, CornerLongitudePoint4_ISO7)
U(07010201030E0100, CornerLongitudePoint4DecimalDegrees)
U(07010201030F0000, Bounding_Rectangle)
U(0701020103100000, Geographic_Location)
U(0701020103110000, GeographicPolygon_Coords)
U(0701020103120000, GeographicArea_NorthWest)
U(0701020103130000, GeographicArea_SouthEast)
U(0701020103140000, GeographicArea_SourceDatum)
U(0701020103150000, GeographicPolygon_SourceDatum)
U(0701020103160000, FrameCenterElevation)
//            02 - Relative Position
//              01 - Local Datum Relative Position
U(0701020201010000, LocalDatumRelativePositionAccuracy)
//              02 - Device Relative Position
U(0701020202010000, DeviceRelativePositionalAccuracy)
U(0701020202020000, DeviceRelativePositionX)
U(0701020202030000, DeviceRelativePositionY)
U(0701020202040000, DeviceRelativePositionZ)
//              03 - Subject Relative Position
U(0701020203010000, SubjectRelativePositionalAccuracy)
//            03 - Image Positional Information
U(0701020301000000, PositionWithinViewportImageXCoordinatePixels)
U(0701020302000000, PositionWithinViewportImageYCoordinatePixels)
U(0701020303000000, SourceImageCenterXCoordinatePixels)
U(0701020304000000, SourceImageCenterYCoordinatePixels)
U(0701020305000000, ViewportImageCenterCCoordinatePixels)
U(0701020306000000, ViewportImageCenterYCoordinatePixels)
//          03 - Rate and Direction of Positional Change
//            01 - Absolute Rate and Direction of Positional Change
//              01 - Device Rate and Direction of Positional Change
U(0701030101010000, DeviceAbsoluteSpeed)
U(0701030101020000, DeviceAbsoluteHeading)
//              02 - Subject Rate and Direction of Positional Change
U(0701030102010000, SubjectAbsoluteSpeed)
U(0701030102020000, SubjectAbsoluteHeading)
//            02 - Relative Rate and Direction of Positional Change
//              01 - Device Relative Rate and Direction of Positional Change
U(0701030201010000, DeviceRelativeSpeed)
U(0701030201020000, DeviceRelativeHeading)
//              02 - Subject Relative Rate and Direction of Positional Change
U(0701030202010000, SubjectRelativeSpeed)
U(0701030202020000, SubjectRelativeHeading)
//          08 - Distance Measurements
//            01 - Device to Subject Distance
U(0701080101000000, SlantRange)
U(0701080102000000, SubjectDistance)
//          09 - Dimensions
//            01 - Device Dimensions
//            02 - Subject Dimensions
U(0701090201000000, TargetWidth)
//            03 - Location Dimensions
//            04 - Media Dimensions
//              01 - Image Dimensions
//                01 - Pan-and-Scan Image Dimensions
U(0701090401010100, ViewportHeight)
U(0701090401010200, ViewportWidth)
//          10 - Angular Specifications
//            01 - Device Angles
U(0701100101000000, SensorRollAngle)
U(0701100102000000, AngleToNorth)
U(0701100103000000, ObliquityAngle)
U(0701100104000000, PlatformRollAngle)
U(0701100105000000, PlatformPitchAngle)
U(0701100106000000, PlatformHeadingAngle)
//            02 - Subject Angles
//          20 - Abstract Locations
//            01 - Place Names
//              01 - Abstract Names
U(0701200101010000, PlaceKeyword_ISO7)
U(0701200101010100, PlaceKeyword)
//              02 - Country Codes
U(0701200102010000, ObjectCountryCode_ISO7)
U(0701200102010100, ObjectCountryCode)
U(0701200102020000, ShootingCountryCode_ISO7)
U(0701200102030000, SettingCountryCode_ISO7)
U(0701200102040000, CopyrightLicenseCountryCode_ISO7)
U(0701200102050000, IntellectualPropertyLicenseCountryCode_ISO7)
U(0701200102060000, ObjectCountryCodeMethod_ISO7)
U(0701200102070000, NonUSClassifyingCountryAndReleasingInstructionsCountryCodeMethod)
U(0701200102070100, CountryCodeMethod)
U(0701200102080000, NonUSClassifyingCountry)
U(0701200102080100, ClassifyingCountryCode)
U(0701200102090000, ReleaseInstructions)
U(0701200102090100, ReleasableCountryCode)
//              03 - Regions
U(0701200103010000, ObjectRegionCode_ISO7)
U(0701200103010100, ObjectRegionName)
U(0701200103020000, ShootingRegionCode_ISO7)
U(0701200103020100, ShootingRegionName)
U(0701200103030000, SettingRegionCode_ISO7)
U(0701200103030100, SettingRegionName)
U(0701200103040000, CopyrightLicenseRegionCode_ISO7)
U(0701200103040100, CopyrightLicenseRegionName)
U(0701200103050000, IntellectualPropertyLicenseRegionCode_ISO7)
U(0701200103050100, RegionAreaOfIPLicense)
//              04 - Addresses
//                01 - Postal Addresses
U(0701200104010100, RoomNumber_ISO7)
U(0701200104010101, RoomSuiteNumber)
U(0701200104010200, StreetNumber_ISO7)
U(0701200104010201, StreetNumber)
U(0701200104010300, StreetName_ISO7)
U(0701200104010301, StreetName)
U(0701200104010400, PostalTown_ISO7)
U(0701200104010401, PostalTown)
U(0701200104010500, CityName_ISO7)
U(0701200104010501, City)
U(0701200104010600, StateProvinceCounty_ISO7)
U(0701200104010601, StateProvinceCounty)
U(0701200104010700, PostalCode_ISO7)
U(0701200104010701, PostalCode)
U(0701200104010800, Country_ISO7)
U(0701200104010801, Country)
U(0701200104011100, RoomSuiteName_ISO7)
U(0701200104011101, RoomSuiteName)
U(0701200104011200, BuildingName_ISO7)
U(0701200104011201, BuildingName)
U(0701200104011300, AddressLine_ISO7)
U(0701200104011301, AddressLine)
U(0701200104011400, PlaceName_ISO7)
U(0701200104011401, PlaceName)
U(0701200104011500, GeographicalCoordinates)
U(0701200104011600, AstronomicalBodyName_ISO7)
U(0701200104011601, AstronomicalBodyName)
//                02 - Setting Addresses
U(0701200104020100, SettingRoomNumber_ISO7)
U(0701200104020101, SettingRoomNumber)
U(0701200104020200, SettingStreetNumberOrBuildingName_ISO7)
U(0701200104020201, SettingStreetNumberOrBuildingName)
U(0701200104020300, SettingStreetName_ISO7)
U(0701200104020301, SettingStreetName)
U(0701200104020400, SettingTownName_ISO7)
U(0701200104020401, SettingTownName)
U(0701200104020500, SettingCityName_ISO7)
U(0701200104020501, SettingCityName)
U(0701200104020600, SettingStateOrProvinceOrCountyName_ISO7)
U(0701200104020601, SettingStateOrProvinceOrCountyName)
U(0701200104020700, SettingPostalCode_ISO7)
U(0701200104020701, SettingPostalCode)
U(0701200104020800, SettingCountryName_ISO7)
U(0701200104020801, SettingCountryName)
//              10 - Electronic Address Varieties
//                03 - Electronic Address Information
U(0701200110030100, TelephoneNumber)
U(0701200110030101, TelephoneNumber_UTF16String)
U(0701200110030200, FaxNumber)
U(0701200110030201, FaxNumber_UTF16String)
U(0701200110030300, EmailAddress_ISO7)
U(0701200110030301, EmailAddress)
U(0701200110030400, CentralTelephoneNumber)
U(0701200110030500, MobileTelephoneNumber)
U(0701200110030600, ContactWebPage_ISO7)
U(0701200110030601, ContactWebPage)
//            02 - Place Descriptions
U(0701200201000000, SettingDescription_ISO7)
U(0701200201010000, SettingDescription)
U(0701200202000000, LocationDescription_ISO7)
U(0701200202010000, LocationDescription)
U(0701200203000000, LocationKind_ISO7)
U(0701200203010000, LocationKind)
//        02 - Temporal
//          01 - Dates and Times
//            01 - General Dates and Times
//              01 - User Date-Time
U(0702010101010000, UTCUserDateTime_ISO7)
U(0702010101020000, LocalUserDateTime_ISO7)
U(0702010101030000, SMPTE309MUserDateTime)
U(0702010101040000, SMPTE12MUserDateTime)
U(0702010101050000, POSIXMicroseconds)
U(0702010101060000, RegisterReleaseDateTime)
U(0702010101070000, RegisterItemStatusChangeDateTime)
U(0702010101080000, ASMCurrentTime)
U(0702010101090000, PTPTimestampTime)
U(07020101010A0000, SMPTE12_3TimeCode)
//            02 - Absolute Dates and Times
//              01 - Material Start True Date-Time
U(0702010201010000, UTCStartDateTime_ISO7)
U(0702010201010100, UTCStartDateTime)
U(0702010201020000, LocalStartDateTime_ISO7)
U(0702010201030000, UTCInstantDateTime_UTCmilliseconds)
U(0702010201030100, UTCInstantDateTime)
//              02 - Material Start Time Address
U(0702010202010000, TimecodeStartDateTime)
U(0702010202020000, STLReferencePointTimecode)
//              03 - Material End True Date-Time
U(0702010203010000, UTCEndDateTime_ISO7)
U(0702010203020000, LocalEndDateTime_ISO7)
//              04 - Material End Time Address
U(0702010204010000, TimecodeEndDateTime)
//              05 - Material Occurrence True Date-Time
U(0702010205010000, UTCLastModificationDateTime_ISO7)
U(0702010205010100, UTCLastModificationDateTime)
U(0702010205020000, LocalLastModificationDateTime_ISO7)
//              06 - Material Occurrence Time Address
U(0702010206010000, TimecodeLastModificationDateTime)
//              07 - Event Start True Date-Time
U(0702010207010000, UTCEventStartDateTime_ISO7)
U(0702010207010100, UTCEventStartDateTime)
U(0702010207020000, EventStartDateTime)
U(0702010207020100, LocalEventStartDateTime)
U(0702010207030000, ASMEventListStartTime)
//                10 - Defined Event Start True Date-Time
U(0702010207100100, FestivalDateTime)
//              08 - Event Start Time Address
U(0702010208010000, TimecodeEventStartDateTime)
U(0702010208020000, TimecodeArray)
//              09 - Event End True Date-Time
U(0702010209010000, UTCEventEndDateTime_ISO7)
U(0702010209010100, UTCEventEndDateTime)
U(0702010209020000, EventEndDateTime)
U(0702010209020100, LocalEventEndDateTime)
//              0A - Event End Time Address
U(070201020A010000, TimecodeEventEndDateTime)
U(070201020A020000, ASMEventListStopTime)
//            03 - Relative Times
//              01 - Material Start Relative Times
U(0702010301010000, StartTimeRelativeToReference_ISO7)
U(0702010301020000, StartTimecodeRelativeToReference)
U(0702010301030000, Origin)
U(0702010301040000, StartPosition)
U(0702010301050000, StartTimecode)
U(0702010301060000, CutPoint)
U(0702010301070000, KeypointPosition)
U(0702010301090000, ShotStartPosition)
U(07020103010A0000, IndexStartPosition)
U(07020103010B0000, EventTrackOrigin)
U(07020103010C0000, MarkIn)
U(07020103010D0000, UserPosition)
U(07020103010E0000, PackageMarkInPosition)
//              02 - Material End Relative Times
U(0702010302010000, MaterialEndTimeOffset_ISO7)
U(0702010302020000, MaterialEndTimecodeOffset)
U(0702010302030000, MarkOut)
U(0702010302040000, PackageMarkOutPosition)
//              03 - Event Start Relative Times
U(0702010303010000, EventStartTimeOffset_ISO7)
U(0702010303020000, EventStartTimecodeOffset)
U(0702010303030000, EventPosition)
//              04 - Event End Relative Times
U(0702010304010000, EventEndTimeOffset_ISO7)
U(0702010304020000, EventEndTimecodeOffset)
//              10 - Offsets
//                01 - Material Offsets
U(0702010310010100, FrameCountOffset)
//                02 - Edit Offsets
U(0702010310020100, ControlPointTime)
//                03 - Event Offsets
U(0702010310030100, EventElapsedTimeToStart_ISO7)
U(0702010310030200, EventElapsedTimeToEnd_ISO7)
//            08 - Setting Date and Time
U(0702010801000000, TimePeriodKeyword_ISO7)
U(0702010801010000, TimePeriodKeyword)
U(0702010802000000, SettingDateTime)
U(0702010803000000, SettingPeriodDescription_ISO7)
U(0702010803010000, SettingPeriodDescription)
//            10 - Process Date-Time
//              01 - Creation Date-Time
U(0702011001010000, LocalCreationDateTime_ISO7)
U(0702011001020000, TimecodeCreationDateTime)
U(0702011001030000, CreationTime)
U(0702011001040000, ClipCreationDateTime)
U(0702011001050000, CreationTimestamp)
//              02 - Modification Date-Time
U(0702011002010000, LocalModificationDateTime_ISO7)
U(0702011002020000, TimecodeModificationDateTime)
U(0702011002030000, FileModificationDate)
U(0702011002040000, FileLastModified)
U(0702011002050000, PackageLastModified)
//            20 - Administrative Date-Time
U(0702012001000000, ContractDateTime)
U(0702012002000000, RightsStartDateTime)
U(0702012003000000, RightsStopDateTime)
U(0702012004000000, PaymentDueDateTime)
//          02 - Durations
//            01 - Absolute Durations
//              01 - Edit Timeline Durations
U(0702020101010000, FrameCount)
U(0702020101020000, IndexDuration)
U(0702020101030000, ComponentLength)
//                04 - Video Durations
//                05 - Audio Durations
U(0702020101050100, DefaultFadeLength)
U(0702020101050200, FadeInLength)
U(0702020101050300, FadeOutLength)
//              02 - Material Absolute Durations
U(0702020102010000, MaterialAbsoluteDuration_ISO7)
U(0702020102020000, MaterialAbsoluteDuration)
U(0702020102030000, TextlessBlackDuration)
U(0702020102040000, ShotDuration)
U(0702020102050000, VideoClipDuration)
//              03 - Event Absolute Durations
U(0702020103010000, EventAbsoluteDurationFrameCount)
U(0702020103020000, EventAbsoluteDuration_ISO7)
U(0702020103030000, EventAbsoluteDuration)
//            02 - Relative Scaling Durations
//          03 - Delay
//            01 - Encoding and Decoding
//              01 - Codec Delay
//              02 - Encoding Delay
//              03 - Decoding Delay
U(0702030103010000, BufferDelay)
//          05 - Latency
U(0702050100000000, ToleranceMode)
U(0702050200000000, ToleranceWindow)
U(0702050300000000, ToleranceInterpolationMethod)
//          06 - Temporal Characteristics
//            01 - Shutter Characteristics
//              01 - Shutter Speed
//              02 - Shutter Gating
//      0D - Organizationally Registered for Public Use
//        01 - AAF Association
//          01 - AAF Attributes
//            01 - AAF Information Attributes
//              01 - AAF Information Attributes Version 1.x
//                01 - Enumerated Attributes
U(0D01010101010100, TapeFormat)
//          04 - MXF Descriptive Metadata Schemes
//            01 - MXF-DMS Structure Version-1
//              03 - DMS AS-03
//                01 - DMS AS-03 Framework
U(0D01040103010100, AS_03_IdentifierKind)
U(0D01040103010200, AS_03_Identifier)
U(0D01040103010300, AS_03_ShimName)
U(0D01040103010400, AS_03_SignalStandard)
U(0D01040103010500, AS_03_IntendedAFD)
U(0D01040103010600, AS_03_SlateTitle)
U(0D01040103010700, AS_03_NOLACode)
U(0D01040103010800, AS_03_Rating)
U(0D01040103010900, AS_03_NielsenStreamIdentifier)
U(0D01050000000000, MXFGenericStreamDataElementKey)
//          07 - AMWA Application Specifications
//            01 - Application Specifications Version 1
//              07 - AS_07
//              0A - AS-10
//                01 - DMS AS-10 Core
//                  01 - DMS AS-10 Core Framework
U(0D0107010A010101, AS_10_Shim_Name)
U(0D0107010A010102, AS_10_Type)
U(0D0107010A010103, AS_10_Main_Title)
U(0D0107010A010104, AS_10_Sub_Title)
U(0D0107010A010105, AS_10_Title_Description)
U(0D0107010A010106, AS_10_Organization_Name)
U(0D0107010A010107, AS_10_Person_Name)
U(0D0107010A010108, AS_10_Location_Description)
U(0D0107010A010109, AS_10_Common_Spanning_ID)
U(0D0107010A01010A, AS_10_Spanning_Number)
U(0D0107010A01010B, AS_10_Cumulative_Duration)
//              0B - AS-11
//                01 - AS-11 Core
//                  01 - AS-11 Core Framework
U(0D0107010B010101, AS_11_Series_Title)
U(0D0107010B010102, AS_11_Programme_Title)
U(0D0107010B010103, AS_11_Episode_Title_Number)
U(0D0107010B010104, AS_11_Shim_Name)
U(0D0107010B010105, AS_11_Audio_Track_Layout)
U(0D0107010B010106, AS_11_Primary_Audio_Language)
U(0D0107010B010107, AS_11_Closed_Captions_Present)
U(0D0107010B010108, AS_11_Closed_Captions_Type)
U(0D0107010B010109, AS_11_Caption_Language)
U(0D0107010B01010A, AS_11_Shim_Version)
//                02 - AS-11 Segmentation
//                  01 - AS-11 Segmentation Framework
U(0D0107010B020101, AS_11_Part_Number)
U(0D0107010B020102, AS_11_Part_Total)
//              0C - AS-12
//                01 - DMS_AS_12
//                  01 - DMS_AS_12_Framework
U(0D0107010C010101, AS_12_ShimName)
U(0D0107010C010102, AS_12_Slate)
//          08 - AMWA Rules Based Specifications
//            01 - Rules Based Specifications Version 1
//              01 - Specification Identification
U(0D01080101010000, Specification_Identifiers)
//        02 - EBU/UER
//          01 - EBUCore
//            01 - EBU Core Main Framework
U(0D02010101000000, documentLocator)
U(0D02010102000000, documentId)
U(0D02010103000000, coreMetadataObject)
U(0D02010104000000, metadataSchemaInformationObject)
//            02 - Core Metadata
U(0D02010201000000, identifierObjects)
U(0D02010202000000, titleObjects)
U(0D02010203000000, alternativeTitleObjects)
U(0D02010204000000, creatorEntityObjects)
U(0D02010205000000, subjectObjects)
U(0D02010206000000, descriptionObjects)
U(0D02010207000000, publisherEntityObjects)
U(0D02010208000000, contributorEntityObjects)
U(0D02010209000000, dateObjects)
U(0D0201020A000000, typeObjects)
U(0D0201020B000000, languageObjects)
U(0D0201020C000000, coverageObjects)
U(0D0201020D000000, rightsObjects)
U(0D0201020E000000, ratingObjects)
U(0D0201020F000000, versionObject)
U(0D02010210000000, publicationHistoryObject)
U(0D02010211000000, planningObject)
U(0D02010212000000, customRelationObjects)
U(0D02010213000000, basicRelationObjects)
U(0D02010214000000, formatObjects)
U(0D02010215000000, partObjects)
U(0D02010216000000, audienceRatingObjects)
U(0D02010217000000, eventObjects)
//            03 - Metadata  Schema Information
U(0D02010301000000, metadataSchema)
U(0D02010302000000, metadataSchemaVersion)
U(0D02010303000000, metadataFrameworkTextLanguageCode)
U(0D02010304000000, metadataNamespacePrefix)
U(0D02010305000000, metadataNamespace)
U(0D02010306000000, metadataProviderEntityObject)
U(0D02010307000000, metadataDateLastModified)
U(0D02010308000000, metadataTimeLastModified)
//            04 - Identifier
U(0D02010401000000, identifierValue)
U(0D02010402000000, identifierNote)
U(0D02010403000000, identifierTypeGroupObject)
U(0D02010404000000, identifierFormatGroupObject)
U(0D02010405000000, identifierAttributorEntityObject)
//            05 - Title
U(0D02010501000000, titleAttributionDate)
U(0D02010502000000, titleNote)
U(0D02010503000000, titleValueObjects)
U(0D02010504000000, titleLength)
U(0D02010505000000, titleGeographicalScope)
U(0D02010506000000, titleGeographicalExclusionScope)
U(0D02010507000000, titleTypeGroupObject)
//            06 - Alternative Title
U(0D02010601000000, alternativeTitleAttributionDate)
U(0D02010602000000, alternativeTitleNote)
U(0D02010603000000, alternativeTitleValueObjects)
U(0D02010604000000, alternativeTitleTypeGroupObject)
U(0D02010605000000, alternativeTitleStatusGroupObject)
U(0D02010606000000, alternativeTitleLength)
U(0D02010607000000, alternativeTitleGeographicalScope)
U(0D02010608000000, alternativeTitleGeographicalExclusionScope)
//            07 - Creator
//            08 - Subject
U(0D02010801000000, subjectCode)
U(0D02010802000000, subjectNote)
U(0D02010803000000, subjectValueObjects)
U(0D02010804000000, subjectDefinitionObjects)
U(0D02010805000000, subjectTypeGroupObject)
U(0D02010806000000, subjectAttributorEntityObject)
//            09 - Description
U(0D02010901000000, descriptionNote)
U(0D02010902000000, descriptionValueObjects)
U(0D02010903000000, descriptionTypeGroupObject)
U(0D02010904000000, descriptionAttributorEntityObject)
U(0D02010905000000, descriptionLength)
U(0D02010906000000, descriptionGeographicalScope)
U(0D02010907000000, descriptionGeographicalExclusionScope)
U(0D02010908000000, descriptionAttributionDate)
U(0D02010909000000, descriptionCastFlag)
//            0A - Publisher
//            0B - Contributor
//            0C - Date
U(0D02010C01000000, dateCreated)
U(0D02010C02000000, yearCreated)
U(0D02010C03000000, dateIssued)
U(0D02010C04000000, yearIssued)
U(0D02010C05000000, dateModified)
U(0D02010C06000000, yearModified)
U(0D02010C07000000, dateDigitized)
U(0D02010C08000000, yearDigitized)
U(0D02010C09000000, dateReleased)
U(0D02010C0A000000, yearReleased)
U(0D02010C0B000000, dateCopyrighted)
U(0D02010C0C000000, yearCopyrighted)
U(0D02010C0D000000, dateNote)
U(0D02010C0E000000, alternativeDateObjects)
U(0D02010C0F000000, precision)
//            0D - Date Type
U(0D02010D01000000, dateValue)
U(0D02010D02000000, textualDateObjects)
U(0D02010D03000000, dateTypeGroupObject)
U(0D02010D04000000, dateFormatGroupObject)
//            0E - Type
U(0D02010E01000000, typeNote)
U(0D02010E02000000, typeValueObjects)
U(0D02010E03000000, objectTypeObjects)
U(0D02010E04000000, genreObjects)
U(0D02010E05000000, targetAudienceObjects)
U(0D02010E06000000, typeTypeGroupObject)
U(0D02010E07000000, audienceLevelObjects)
//            0F - Object Type
U(0D02010F01000000, objectTypeGroupObject)
//            10 - Genre
U(0D02011001000000, genreTypeGroupObject)
U(0D02011002000000, genreLevel)
//            11 - Target Audience
U(0D02011101000000, targetAudienceReason)
U(0D02011102000000, targetAudienceLinkToLogo)
U(0D02011103000000, targetAudienceNotRatedFlag)
U(0D02011104000000, targetAudienceAdultContentFlag)
U(0D02011105000000, targetAudienceTypeGroupObject)
U(0D02011106000000, targetAudienceRegionObjects)
U(0D02011107000000, targetAudienceExclusionRegionObjects)
U(0D02011108000000, targetAudienceFormatGroupObject)
//            12 - Language
U(0D02011201000000, languageCode)
U(0D02011202000000, languageValueObject)
U(0D02011203000000, languageNote)
U(0D02011204000000, languagePurposeObject)
//            13 - Coverage
U(0D02011301000000, coverageValueObject)
U(0D02011302000000, spatialObject)
U(0D02011303000000, temporalObject)
U(0D02011304000000, coverageTypeGroupObject)
//            14 - Spatial
U(0D02011401000000, locationObjects)
//            15 - Location
U(0D02011501000000, locationID)
U(0D02011502000000, locationCode)
U(0D02011503000000, locationDefinitionNote)
U(0D02011504000000, locationNameObjects)
U(0D02011505000000, locationRegionObject)
U(0D02011506000000, locationTypeGroupObject)
U(0D02011507000000, locationCoordinatesObject)
//            16 - Coordinates
U(0D02011601000000, posX)
U(0D02011602000000, posY)
U(0D02011603000000, coordinatesFormatGroupObject)
//            17 - Temporal
U(0D02011701000000, temporalDefinitionNote)
U(0D02011702000000, periodOfTimeObjects)
U(0D02011703000000, temporalTypeGroupObject)
//            18 - Period Of Time
U(0D02011801000000, periodID)
U(0D02011802000000, periodStartYear)
U(0D02011803000000, periodStartDate)
U(0D02011804000000, periodStartTime)
U(0D02011805000000, periodEndYear)
U(0D02011806000000, periodEndDate)
U(0D02011807000000, periodEndTime)
U(0D02011808000000, periodNameObjects)
//            19 - Rights
U(0D02011901000000, rightsID)
U(0D02011902000000, rightsLink)
U(0D02011903000000, rightsClearanceFlag)
U(0D02011904000000, rightsNote)
U(0D02011905000000, rightsValueObjects)
U(0D02011906000000, exploitationIssuesObjects)
U(0D02011907000000, copyrightStatementObjects)
U(0D02011908000000, rightsCoverageObject)
U(0D02011909000000, rightsHolderEntityObjects)
U(0D0201190A000000, rightsContactObjects)
U(0D0201190B000000, rightsTypeGroupObject)
U(0D0201190C000000, rightsAttributedIDObjects)
U(0D0201190D000000, rightsFormatReferenceObjects)
U(0D0201190E000000, processingRestrictionFlag)
U(0D0201190F000000, disclaimerObjects)
U(0D02011910000000, rightsCoverageObjects)
//            1A - Version
U(0D02011A01000000, versionValueObjects)
U(0D02011A02000000, versionTypeGroupObject)
//            1B - Rating
U(0D02011B01000000, ratingReason)
U(0D02011B02000000, ratingLinkToLogo)
U(0D02011B03000000, ratingNotRatedFlag)
U(0D02011B04000000, ratingAdultContentFlag)
U(0D02011B05000000, ratingValueObjects)
U(0D02011B06000000, ratingScaleMinValueObjects)
U(0D02011B07000000, ratingScaleMaxValueObjects)
U(0D02011B08000000, ratingTypeGroupObject)
U(0D02011B09000000, ratingFormatGroupObject)
U(0D02011B0A000000, ratingProviderEntityObject)
U(0D02011B0B000000, ratingRegionObject)
U(0D02011B0C000000, ratingSystem)
U(0D02011B0D000000, ratingEnvironment)
U(0D02011B0E000000, ratingLink)
U(0D02011B0F000000, ratingExclusionRegionObjects)
U(0D02011B10000000, ratingRegionObjects)
//            1C - Publication Event
U(0D02011C01000000, publicationEventName)
U(0D02011C02000000, publicationEventId)
U(0D02011C03000000, firstShowingFlag)
U(0D02011C04000000, lastShowingFlag)
U(0D02011C05000000, publicationDate)
U(0D02011C06000000, publicationTime)
U(0D02011C07000000, scheduleDate)
U(0D02011C08000000, freePublicationFlag)
U(0D02011C09000000, livePublicationFlag)
U(0D02011C0A000000, publicationNote)
U(0D02011C0B000000, publicationFormatReferenceObject)
U(0D02011C0C000000, publicationRightsReferenceObjects)
U(0D02011C0D000000, publicationRegionObjects)
U(0D02011C0E000000, publicationMediumObject)
U(0D02011C0F000000, publicationChannelObject)
U(0D02011C10000000, publicationServiceObject)
U(0D02011C11000000, liveProductionFlag)
//            1D - Publication History
U(0D02011D01000000, publicationEventObjects)
U(0D02011D02000000, publicationHistoryId)
//            1E - Publication Channel
U(0D02011E01000000, publicationChannelName)
U(0D02011E02000000, publicationChannelId)
U(0D02011E03000000, publicationChannelLinkToLogo)
U(0D02011E04000000, publicationChannelTypeGroupObject)
//            1F - Publication Medium
U(0D02011F01000000, publicationMediumName)
U(0D02011F02000000, publicationMediumId)
U(0D02011F03000000, publicationMediumTypeGroupObject)
//            20 - Publication Service
U(0D02012001000000, publicationServiceName)
U(0D02012002000000, publicationServiceLinkToLogo)
U(0D02012003000000, publicationServiceSourceObject)
U(0D02012004000000, publicationServiceId)
U(0D02012005000000, publicationServiceTypeGroupObject)
//            21 - Entity
U(0D02012101000000, entityID)
U(0D02012102000000, entityContactObjects)
U(0D02012103000000, entityOrganizationObjects)
U(0D02012104000000, entityRoleObjects)
U(0D02012105000000, entityAwardObjects)
U(0D02012106000000, entityEventObjects)
//            22 - Contact
U(0D02012201000000, contactID)
U(0D02012202000000, familiyName)
U(0D02012203000000, givenName)
U(0D02012204000000, salutation)
U(0D02012205000000, suffix)
U(0D02012206000000, occupation)
U(0D02012207000000, username)
U(0D02012208000000, guestFlag)
U(0D02012209000000, contactNameObjects)
U(0D0201220A000000, contactTypeGroupObject)
U(0D0201220B000000, contactDetailsObjects)
U(0D0201220C000000, contactRelatedContactObjects)
U(0D0201220D000000, stageNameObjects)
U(0D0201220E000000, genderObject)
U(0D0201220F000000, contactRelatedInformationLinkObjects)
U(0D02012210000000, otherGivenName)
U(0D02012211000000, birthDate)
U(0D02012212000000, deathDate)
U(0D02012213000000, birthPlace)
U(0D02012214000000, nationality)
U(0D02012215000000, nickname)
U(0D02012216000000, skill)
U(0D02012217000000, contactLastUpdate)
U(0D02012218000000, deathPlace)
U(0D02012219000000, affiliationObjects)
//            23 - Organization
U(0D02012301000000, organizationID)
U(0D02012302000000, organizationLinkToLogo)
U(0D02012303000000, organizationCodeObjects)
U(0D02012304000000, organizationRelatedInformationLinkObjects)
U(0D02012305000000, organizationNameObjects)
U(0D02012306000000, organizationDepartmentObject)
U(0D02012307000000, organizationTypeGroupObject)
U(0D02012308000000, organizationDetailsObjects)
U(0D02012309000000, organizationRelatedContactObjects)
U(0D0201230A000000, organizationDescription)
U(0D0201230B000000, organizationNationality)
U(0D0201230C000000, organizationLastUpdate)
//            24 - Department
U(0D02012401000000, departmentID)
U(0D02012402000000, departmentName)
//            25 - Details
U(0D02012501000000, webAddress)
U(0D02012502000000, telephoneNumber)
U(0D02012503000000, mobileTelephoneNumber)
U(0D02012504000000, emailAddress)
U(0D02012505000000, detailsTypeGroupObject)
U(0D02012506000000, addressObject)
//            26 - Address
U(0D02012601000000, deliveryCode)
U(0D02012602000000, townCityObjects)
U(0D02012603000000, countyStateObjects)
U(0D02012604000000, countryObjects)
U(0D02012605000000, addressLineObjects)
//            27 - Region
U(0D02012701000000, countryObject)
U(0D02012702000000, countryRegionObject)
//            28 - Compound Name
U(0D02012801000000, compoundNameValue)
U(0D02012802000000, compoundNameTypeGroupObject)
U(0D02012803000000, compoundNameFormatGroupObject)
//            29 - Role
U(0D02012901000000, costCenterReference)
U(0D02012902000000, roleTypeGroupObject)
//            2A - Country Type
U(0D02012A01000000, countryTypeGroupObject)
//            2B - Relations
//              01 - Custom Relation
U(0D02012B01010000, customRelationByName)
U(0D02012B01020000, customRelationLink)
U(0D02012B01030000, runningOrderNumber)
U(0D02012B01040000, totalNumberOfGroupMembers)
U(0D02012B01050000, orderedGroupFlag)
U(0D02012B01060000, customRelationNote)
U(0D02012B01070000, customRelationTypeGroupObject)
U(0D02012B01080000, customRelationIdentifierObject)
//              02 - Basic Relation
U(0D02012B02010000, isVersionOf)
U(0D02012B02020000, hasVersion)
U(0D02012B02030000, isReplacedBy)
U(0D02012B02040000, replaces)
U(0D02012B02050000, isRequiredBy)
U(0D02012B02060000, requires_)
U(0D02012B02070000, isPartOf)
U(0D02012B02080000, hasPart)
U(0D02012B02090000, isReferencedBy)
U(0D02012B020A0000, references)
U(0D02012B020B0000, isFormatOf)
U(0D02012B020C0000, hasFormat)
U(0D02012B020D0000, isEpisodeOf)
U(0D02012B020E0000, isMemberOf)
U(0D02012B020F0000, hasMember)
U(0D02012B02100000, hasEpisode)
U(0D02012B02110000, isSeasonOf)
U(0D02012B02120000, hasSeason)
U(0D02012B02130000, isNextInSequence)
U(0D02012B02140000, followsInSequence)
U(0D02012B02150000, isRelatedTo)
U(0D02012B02160000, sameAs)
U(0D02012B02170000, hasSeries)
U(0D02012B02180000, isSeriesOf)
//            2C - Planning
U(0D02012C01000000, planningEventObjects)
U(0D02012C02000000, planningId)
//            2D - Attribute groups
//              01 - Type Group
U(0D02012D01010000, typeGroupThesaurus)
U(0D02012D01020000, typeGroupLabel)
U(0D02012D01030000, typeGroupLink)
U(0D02012D01040000, typeGroupUL)
U(0D02012D01050000, typeGroupDefinition)
U(0D02012D01060000, typeGroupLanguageCode)
U(0D02012D01070000, typeGroupNamespace)
U(0D02012D01080000, typeGroupSource)
//              02 - Format Group
U(0D02012D02010000, formatGroupThesaurus)
U(0D02012D02020000, formatGroupLabel)
U(0D02012D02030000, formatGroupLink)
U(0D02012D02040000, formatGroupUL)
U(0D02012D02050000, formatGroupDefinition)
U(0D02012D02060000, formatGroupLanguageCode)
U(0D02012D02070000, formatGroupNamespace)
U(0D02012D02080000, formatGroupSource)
//              03 - Status Group
U(0D02012D03010000, statusGroupThesaurus)
U(0D02012D03020000, statusGroupLabel)
U(0D02012D03030000, statusGroupLink)
U(0D02012D03040000, statusGroupUL)
U(0D02012D03050000, statusGroupDefinition)
U(0D02012D03060000, statusGroupLanguageCode)
U(0D02012D03070000, statusGroupNamespace)
U(0D02012D03080000, statusGroupSource)
//            2E - Textual Annotation
U(0D02012E01000000, text)
U(0D02012E02000000, textLanguageCode)
//            2F - Basic Link
U(0D02012F01000000, basicLinkUri)
//            30 - Format
U(0D02013001000000, formatID)
U(0D02013002000000, formatVersionID)
U(0D02013003000000, formatName)
U(0D02013004000000, formatDefinition)
U(0D02013005000000, formatYearCreated)
U(0D02013006000000, formatDateCreated)
U(0D02013007000000, formatOverallDurationTimeObject)
U(0D02013008000000, formatEditRateObject)
U(0D02013009000000, formatContainerFormatObject)
U(0D0201300A000000, formatMediumObject)
U(0D0201300B000000, formatPackageInfoObject)
U(0D0201300C000000, formatAudioFormatObjects)
U(0D0201300D000000, formatVideoFormatObjects)
U(0D0201300E000000, formatImageFormatObjects)
U(0D0201300F000000, formatDataFormatObjects)
U(0D02013010000000, formatSigningFormatObjects)
U(0D02013011000000, formatTechnicalAttributeStringObjects)
U(0D02013012000000, formatTechnicalAttributeInt8Objects)
U(0D02013013000000, formatTechnicalAttributeInt16Objects)
U(0D02013014000000, formatTechnicalAttributeInt32Objects)
U(0D02013015000000, formatTechnicalAttributeInt64Objects)
U(0D02013016000000, formatTechnicalAttributeUInt8Objects)
U(0D02013017000000, formatTechnicalAttributeUInt16Objects)
U(0D02013018000000, formatTechnicalAttributeUInt32Objects)
U(0D02013019000000, formatTechnicalAttributeUInt64Objects)
U(0D0201301A000000, formatTechnicalAttributeFloatObjects)
U(0D0201301B000000, formatTechnicalAttributeRationalObjects)
U(0D0201301C000000, formatTechnicalAttributeAnyURIObjects)
U(0D0201301D000000, formatTechnicalAttributeBooleanObjects)
U(0D0201301E000000, formatDateModifiedObject)
U(0D0201301F000000, formatValueObject)
U(0D02013020000000, formatTypeGroupObject)
U(0D02013021000000, formatAudioFormatExtendedObjects)
U(0D02013022000000, formatStartTimeObjects)
U(0D02013023000000, formatEndTimeObjects)
U(0D02013024000000, formatDurationTimeObjects)
U(0D02013025000000, formatMetadataFormatObjects)
U(0D02013026000000, formatTimecodeFormatObjects)
U(0D02013027000000, formatMediumObjects)
//            31 - Video Format
U(0D02013101000000, videoFormatID)
U(0D02013102000000, videoFormatVersionId)
U(0D02013103000000, videoFormatName)
U(0D02013104000000, videoFormatDefinition)
U(0D02013105000000, videoBitRateObject)
U(0D02013106000000, videoMaxBitRateObject)
U(0D02013107000000, videoBitRateMode)
U(0D02013108000000, videoScanningFormat)
U(0D02013109000000, videoScanningOrder)
U(0D0201310A000000, videoActiveLines)
U(0D0201310B000000, videoNoiseFilterFlag)
U(0D0201310C000000, videoNoiseFilterObject)
U(0D0201310D000000, video3DFlag)
U(0D0201310E000000, videoAspectRatioObjects)
U(0D0201310F000000, videoFrameRateObject)
U(0D02013110000000, videoHeightObjects)
U(0D02013111000000, videoWidthObjects)
U(0D02013112000000, videoEncodingObject)
U(0D02013113000000, videoCodecObject)
U(0D02013114000000, videoTrackObjects)
U(0D02013115000000, videoPresenceFlag)
U(0D02013116000000, videoRegionDelimXObject)
U(0D02013117000000, videoRegionDelimYObject)
U(0D02013118000000, videoFormatProfile)
U(0D02013119000000, videoFormatProfileLevel)
U(0D0201311A000000, videoNote)
U(0D0201311B000000, videoTechnicalAttributeStringObjects)
U(0D0201311C000000, videoTechnicalAttributeInt8Objects)
U(0D0201311D000000, videoTechnicalAttributeInt16Objects)
U(0D0201311E000000, videoTechnicalAttributeInt32Objects)
U(0D0201311F000000, videoTechnicalAttributeInt64Objects)
U(0D02013120000000, videoTechnicalAttributeUInt8Objects)
U(0D02013121000000, videoTechnicalAttributeUInt16Objects)
U(0D02013122000000, videoTechnicalAttributeUInt32Objects)
U(0D02013123000000, videoTechnicalAttributeUInt64Objects)
U(0D02013124000000, videoTechnicalAttributeFloatObjects)
U(0D02013125000000, videoTechnicalAttributeRationalObjects)
U(0D02013126000000, videoTechnicalAttributeAnyURIObjects)
U(0D02013127000000, videoTechnicalAttributeBooleanObjects)
U(0D02013128000000, videoFilterObjects)
//            32 - Image Format
U(0D02013201000000, imageFormatID)
U(0D02013202000000, imageFormatVersionId)
U(0D02013203000000, imageFormatName)
U(0D02013204000000, imageFormatDefinition)
U(0D02013205000000, imageOrientation)
U(0D02013206000000, imageAspectRatioObject)
U(0D02013207000000, imageEncodingObject)
U(0D02013208000000, imageCodecObject)
U(0D02013209000000, imageHeightObject)
U(0D0201320A000000, imageWidthObject)
U(0D0201320B000000, imagePresenceFlag)
U(0D0201320C000000, imageRegionDelimXObject)
U(0D0201320D000000, imageRegionDelimYObject)
U(0D0201320E000000, imageFormatProfile)
U(0D0201320F000000, imageFormatProfileLevel)
U(0D02013210000000, imageNote)
U(0D02013211000000, imageTechnicalAttributeStringObjects)
U(0D02013212000000, imageTechnicalAttributeInt8Objects)
U(0D02013213000000, imageTechnicalAttributeInt16Objects)
U(0D02013214000000, imageTechnicalAttributeInt32Objects)
U(0D02013215000000, imageTechnicalAttributeInt64Objects)
U(0D02013216000000, imageTechnicalAttributeUInt8Objects)
U(0D02013217000000, imageTechnicalAttributeUInt16Objects)
U(0D02013218000000, imageTechnicalAttributeUInt32Objects)
U(0D02013219000000, imageTechnicalAttributeUInt64Objects)
U(0D0201321A000000, imageTechnicalAttributeFloatObjects)
U(0D0201321B000000, imageTechnicalAttributeRationalObjects)
U(0D0201321C000000, imageTechnicalAttributeAnyURIObjects)
U(0D0201321D000000, imageTechnicalAttributeBooleanObjects)
//            33 - Audio Format
U(0D02013301000000, audioFormatID)
U(0D02013302000000, audioFormatVersionId)
U(0D02013303000000, audioFormatName)
U(0D02013304000000, audioFormatDefinition)
U(0D02013305000000, audioTrackConfiguration)
U(0D02013306000000, audioSamplingSize)
U(0D02013307000000, audioSamplingType)
U(0D02013308000000, audioTotalNumberOfChannels)
U(0D02013309000000, audioBitRateObject)
U(0D0201330A000000, audioMaxBitRateObject)
U(0D0201330B000000, audioBitRateMode)
U(0D0201330C000000, audioSamplingRateObject)
U(0D0201330D000000, audioEncodingObject)
U(0D0201330E000000, audioCodecObject)
U(0D0201330F000000, audioTrackObjects)
U(0D02013310000000, audioPresenceFlag)
U(0D02013311000000, audioFormatProfile)
U(0D02013312000000, audioFormatProfileLevel)
U(0D02013313000000, audioNote)
U(0D02013314000000, audioTechnicalAttributeStringObjects)
U(0D02013315000000, audioTechnicalAttributeInt8Objects)
U(0D02013316000000, audioTechnicalAttributeInt16Objects)
U(0D02013317000000, audioTechnicalAttributeInt32Objects)
U(0D02013318000000, audioTechnicalAttributeInt64Objects)
U(0D02013319000000, audioTechnicalAttributeUInt8Objects)
U(0D0201331A000000, audioTechnicalAttributeUInt16Objects)
U(0D0201331B000000, audioTechnicalAttributeUInt32Objects)
U(0D0201331C000000, audioTechnicalAttributeUInt64Objects)
U(0D0201331D000000, audioTechnicalAttributeFloatObjects)
U(0D0201331E000000, audioTechnicalAttributeRationalObjects)
U(0D0201331F000000, audioTechnicalAttributeAnyURIObjects)
U(0D02013320000000, audioTechnicalAttributeBooleanObjects)
U(0D02013321000000, audioDescriptionPresenceFlag)
U(0D02013322000000, audioFilterObjects)
//            34 - Track
U(0D02013401000000, trackID)
U(0D02013402000000, trackName)
U(0D02013403000000, trackLanguageCode)
U(0D02013404000000, trackTypeGroupObject)
//            35 - Data Format
U(0D02013501000000, dataFormatID)
U(0D02013502000000, dataFormatVersionID)
U(0D02013503000000, dataFormatName)
U(0D02013504000000, dataFormatDefinition)
U(0D02013505000000, dataTrackId)
U(0D02013506000000, dataTrackName)
U(0D02013507000000, dataTrackLanguageCode)
U(0D02013508000000, dataPresenceFlag)
U(0D02013509000000, captioningObjects)
U(0D0201350A000000, subtitlingObjects)
U(0D0201350B000000, ancillaryDataObjects)
U(0D0201350C000000, dataCodecObject)
U(0D0201350D000000, dataFormatProfile)
U(0D0201350E000000, dataFormatProfileLevel)
U(0D0201350F000000, dataNote)
U(0D02013510000000, dataTechnicalAttributeStringObjects)
U(0D02013511000000, dataTechnicalAttributeInt8Objects)
U(0D02013512000000, dataTechnicalAttributeInt16Objects)
U(0D02013513000000, dataTechnicalAttributeInt32Objects)
U(0D02013514000000, dataTechnicalAttributeInt64Objects)
U(0D02013515000000, dataTechnicalAttributeUInt8Objects)
U(0D02013516000000, dataTechnicalAttributeUInt16Objects)
U(0D02013517000000, dataTechnicalAttributeUInt32Objects)
U(0D02013518000000, dataTechnicalAttributeUInt64Objects)
U(0D02013519000000, dataTechnicalAttributeFloatObjects)
U(0D0201351A000000, dataTechnicalAttributeRationalObjects)
U(0D0201351B000000, dataTechnicalAttributeAnyURIObjects)
U(0D0201351C000000, dataTechnicalAttributeBooleanObjects)
//            36 - Captioning
U(0D02013601000000, captioningFormatID)
U(0D02013602000000, captioningFormatName)
U(0D02013603000000, captioningSourceUri)
U(0D02013604000000, captioningTrackID)
U(0D02013605000000, captioningTrackName)
U(0D02013606000000, captioningLanguageCode)
U(0D02013607000000, closedCaptioningFlag)
U(0D02013608000000, captioningTypeGroupObject)
U(0D02013609000000, captioningFormatGroupObject)
U(0D0201360A000000, captioningPresenceFlag)
U(0D0201360B000000, captioningFormatProfile)
//            37 - Subtitling
U(0D02013701000000, subtitlingFormatID)
U(0D02013702000000, subtitlingFormatName)
U(0D02013703000000, subtitlingSourceUri)
U(0D02013704000000, subtitlingTrackID)
U(0D02013705000000, subtitlingTrackName)
U(0D02013706000000, subtitlingLanguageCode)
U(0D02013707000000, closedSubtitlingFlag)
U(0D02013708000000, subtitlingTypeGroupObject)
U(0D02013709000000, subtitlingFormatGroupObject)
U(0D0201370A000000, subtitlingPresenceFlag)
U(0D0201370B000000, subtitlingFormatProfile)
//            38 - Ancillary Data
U(0D02013801000000, ancillaryDataFormatId)
U(0D02013802000000, ancillaryDataFormatName)
U(0D02013803000000, DID)
U(0D02013804000000, SDID)
U(0D02013805000000, lineNumber)
U(0D02013806000000, ANCWrappingTypeObject)
U(0D02013807000000, ancillaryDataFormatProfile)
//            39 - Signing  Format
U(0D02013901000000, signingFormatID)
U(0D02013902000000, signingFormatVersionID)
U(0D02013903000000, signingFormatName)
U(0D02013904000000, signingTrackID)
U(0D02013905000000, signingTrackName)
U(0D02013906000000, signingTrackLanguageCode)
U(0D02013907000000, signingSourceUri)
U(0D02013908000000, signingTypeGroupObject)
U(0D02013909000000, signingFormatGroupObject)
U(0D0201390A000000, signingPresenceFlag)
//            3A - Technical Basic Attributes
//              01 - Technical Attribute String
U(0D02013A01010000, technicalAttributeStringValue)
U(0D02013A01020000, technicalAttributeStringTypeGroupObject)
U(0D02013A01030000, technicalAttributeStringFormatGroupObject)
//              02 - Technical Attribute Int8
U(0D02013A02010000, technicalAttributeInt8Value)
U(0D02013A02020000, technicalAttributeInt8TypeGroupObject)
U(0D02013A02030000, technicalAttributeInt8Unit)
//              03 - Technical Attribute Int16
U(0D02013A03010000, technicalAttributeInt16Value)
U(0D02013A03020000, technicalAttributeInt16TypeGroupObject)
U(0D02013A03030000, technicalAttributeInt16Unit)
//              04 - Technical Attribute Int32
U(0D02013A04010000, technicalAttributeInt32Value)
U(0D02013A04020000, technicalAttributeInt32TypeGroupObject)
U(0D02013A04030000, technicalAttributeInt32Unit)
//              05 - Technical Attribute Int64
U(0D02013A05010000, technicalAttributeInt64Value)
U(0D02013A05020000, technicalAttributeInt64TypeGroupObject)
U(0D02013A05030000, technicalAttributeInt64Unit)
//              06 - Technical Attribute UInt8
U(0D02013A06010000, technicalAttributeUInt8Value)
U(0D02013A06020000, technicalAttributeUInt8TypeGroupObject)
U(0D02013A06030000, technicalAttributeUInt8Unit)
//              07 - Technical Attribute UInt16
U(0D02013A07010000, technicalAttributeUInt16Value)
U(0D02013A07020000, technicalAttributeUInt16TypeGroupObject)
U(0D02013A07030000, technicalAttributeUInt16Unit)
//              08 - Technical Attribute UInt32
U(0D02013A08010000, technicalAttributeUInt32Value)
U(0D02013A08020000, technicalAttributeUInt32TypeGroupObject)
U(0D02013A08030000, technicalAttributeUInt32Unit)
//              09 - Technical Attribute UInt64
U(0D02013A09010000, technicalAttributeUInt64Value)
U(0D02013A09020000, technicalAttributeUInt64TypeGroupObject)
U(0D02013A09030000, technicalAttributeUInt64Unit)
//              0A - Technical Attribute Float
U(0D02013A0A010000, technicalAttributeFloatValue)
U(0D02013A0A020000, technicalAttributeFloatTypeGroupObject)
U(0D02013A0A030000, technicalAttributeFloatUnit)
//              0B - Technical Attribute Rational
U(0D02013A0B010000, technicalAttributeRationalTypeGroupObject)
U(0D02013A0B020000, technicalAttributeRationalValueObject)
//              0C - Technical Attribute AnyURI
U(0D02013A0C010000, technicalAttributeAnyURIValue)
U(0D02013A0C020000, technicalAttributeAnyURITypeGroupObject)
//              0D - Technical Attribute Boolean
U(0D02013A0D010000, technicalAttributeBooleanValue)
U(0D02013A0D020000, technicalAttributeBooleanTypeGroupObject)
//            3B - Dimension
U(0D02013B01000000, dimensionValue)
U(0D02013B02000000, dimensionUnit)
//            3C - Package Info
U(0D02013C01000000, packageSize)
U(0D02013C02000000, packageName)
U(0D02013C03000000, packageLocatorObject)
U(0D02013C04000000, mimeTypeObject)
U(0D02013C05000000, hashObject)
U(0D02013C06000000, packageOverallBitRateObject)
//            3D - Medium
U(0D02013D01000000, mediumID)
U(0D02013D02000000, mediumTypeGroupObject)
//            3E - Codec
U(0D02013E01000000, codecName)
U(0D02013E02000000, codecVendor)
U(0D02013E03000000, codecVersion)
U(0D02013E04000000, codecfamily)
U(0D02013E05000000, codecIdentifier)
U(0D02013E06000000, codecUrl)
U(0D02013E07000000, codecTypeGroupObject)
//            3F - Rational
U(0D02013F01000000, nominalValue)
U(0D02013F02000000, factorNumerator)
U(0D02013F03000000, factorDenominator)
//            40 - Aspect Ratio
U(0D02014001000000, aspectRatioNumerator)
U(0D02014002000000, aspectRatioDenominator)
U(0D02014003000000, aspectRatioTypeGroupObject)
//            41 - Height
U(0D02014101000000, heightValueObject)
U(0D02014102000000, heightTypeGroupObject)
//            42 - Width
U(0D02014201000000, widthValueObject)
U(0D02014202000000, widthTypeGroupObject)
//            43 - Part
U(0D02014301000000, partMetadataObject)
//            44 - Part Metadata
U(0D02014401000000, partID)
U(0D02014402000000, partName)
U(0D02014403000000, partDefinition)
U(0D02014404000000, partStartTimeObject)
U(0D02014405000000, partDurationTimeObject)
U(0D02014406000000, partNumber)
U(0D02014407000000, partTotalNumber)
U(0D02014408000000, partTypeGroupObject)
U(0D02014409000000, partMetaObject)
//            45 - EBUCore Set
//            46 - Hash
U(0D02014601000000, hashValueObject)
U(0D02014602000000, hashFunctionTypeGroupObject)
//            47 - Locator
U(0D02014701000000, locatorValueObject)
U(0D02014702000000, locatorTypeGroupObject)
//            48 - Container Format
U(0D02014801000000, containerFormatId)
U(0D02014802000000, containerFormatName)
U(0D02014803000000, containerCodecObject)
U(0D02014804000000, containerFormatVersionId)
U(0D02014805000000, containerFormatProfile)
U(0D02014806000000, containerFormatProfileLevel)
U(0D02014807000000, containerNote)
U(0D02014808000000, containerTechnicalAttributeStringObjects)
U(0D02014809000000, containerTechnicalAttributeInt8Objects)
U(0D0201480A000000, containerTechnicalAttributeInt16Objects)
U(0D0201480B000000, containerTechnicalAttributeInt32Objects)
U(0D0201480C000000, containerTechnicalAttributeInt64Objects)
U(0D0201480D000000, containerTechnicalAttributeUInt8Objects)
U(0D0201480E000000, containerTechnicalAttributeUInt16Objects)
U(0D0201480F000000, containerTechnicalAttributeUInt32Objects)
U(0D02014810000000, containerTechnicalAttributeUInt64Objects)
U(0D02014811000000, containerTechnicalAttributeFloatObjects)
U(0D02014812000000, containerTechnicalAttributeRationalObjects)
U(0D02014813000000, containerTechnicalAttributeAnyURIObjects)
U(0D02014814000000, containerTechnicalAttributeBooleanObjects)
U(0D02014815000000, containerEncodingFormatGroupObject)
//            49 - Audio Format Extended
U(0D02014901000000, audioFormatExtendedId)
U(0D02014902000000, audioFormatExtendedName)
U(0D02014903000000, audioFormatExtendedDefinition)
U(0D02014904000000, audioFormatExtendedVersion)
U(0D02014905000000, audioFormatExtendedPresenceFlag)
U(0D02014906000000, audioProgrammeObjects)
U(0D02014907000000, audioContentObjects)
U(0D02014908000000, audioObjectObjects)
U(0D02014909000000, audioPackFormatObjects)
U(0D0201490A000000, audioChannelFormatObjects)
U(0D0201490B000000, audioBlockFormatObjects)
U(0D0201490C000000, audioStreamFormatObjects)
U(0D0201490D000000, audioTrackFormatObjects)
U(0D0201490E000000, audioTrackUIDObjects)
//            4A - Audio Programme
U(0D02014A01000000, audioProgrammeId)
U(0D02014A02000000, audioProgrammeName)
U(0D02014A03000000, audioProgrammeLanguageCode)
U(0D02014A04000000, audioProgrammeStartTimecode)
U(0D02014A05000000, audioProgrammeEndTimecode)
U(0D02014A06000000, audioProgrammeTypeGroupObject)
U(0D02014A07000000, audioProgrammeFormatGroupObject)
U(0D02014A08000000, audioProgrammeAudioContentIDRefObjects)
U(0D02014A09000000, audioProgrammeLoudnessMetadataObject)
U(0D02014A0A000000, audioProgrammeMaxDuckingDepth)
U(0D02014A0B000000, audioProgrammeReferenceScreenObject)
//            4B - IDRef
U(0D02014B01000000, IDRefValue)
//            4C - Loudness Metadata
U(0D02014C01000000, loudnessMethod)
U(0D02014C02000000, integratedLoudness)
U(0D02014C03000000, loudnessRange)
U(0D02014C04000000, loudnessMaxTruePeak)
U(0D02014C05000000, loudnessMaxMomentary)
U(0D02014C06000000, loudnessMaxShortTerm)
U(0D02014C07000000, loudnessRecType)
U(0D02014C08000000, loudnessCorrectionType)
U(0D02014C09000000, dialogueLoudness)
//            4D - Audio Content
U(0D02014D01000000, audioContentId)
U(0D02014D02000000, audioContentName)
U(0D02014D03000000, audioContentLanguageCode)
U(0D02014D04000000, audioContentDialogueIndicator)
U(0D02014D05000000, audioContentAudioObjectIDRefObjects)
U(0D02014D06000000, audioContentLoudnessMetadataObject)
U(0D02014D07000000, audioContentDialogueObject)
//            4E - Audio Object
U(0D02014E01000000, audioObjectId)
U(0D02014E02000000, audioObjectName)
U(0D02014E03000000, audioObjectStartTimecode)
U(0D02014E04000000, audioObjectDurationTimecode)
U(0D02014E05000000, audioObjectDialogueIndicator)
U(0D02014E06000000, audioObjectImportance)
U(0D02014E07000000, audioObjectInteract)
U(0D02014E08000000, audioObjectAudioPackFormatIDRefObjects)
U(0D02014E09000000, audioObjectAudioObjectIDRefObjects)
U(0D02014E0A000000, audioObjectAudioTrackUIDRefObjects)
U(0D02014E0B000000, audioObjectInteractionObjects)
U(0D02014E0C000000, audioComplementaryObjectIDRefObjects)
U(0D02014E0D000000, audioObjectDisableDucking)
//            4F - Audio Pack Format
U(0D02014F01000000, audioPackFormatId)
U(0D02014F02000000, audioPackFormatName)
U(0D02014F03000000, audioPackAbsoluteDistance)
U(0D02014F04000000, audioPackTypeGroupObject)
U(0D02014F05000000, audioPackImportance)
U(0D02014F06000000, audioPackAudioChannelFormatIDRefObjects)
U(0D02014F07000000, audioPackAudioPackFormatIDRefObjects)
//            50 - Audio Channel Format
U(0D02015001000000, audioChannelFormatId)
U(0D02015002000000, audioChannelFormatName)
U(0D02015003000000, audioChannelTypeGroupObject)
U(0D02015004000000, audioChannelFrequency)
U(0D02015005000000, audioChannelAudioBlockFormatObjects)
//            51 - Audio Block Format
U(0D02015101000000, audioBlockFormatId)
U(0D02015102000000, audioBlockRTimecode)
U(0D02015103000000, audioBlockDurationTimecode)
U(0D02015104000000, audioBlockSpeakerLabel)
U(0D02015105000000, audioBlockPosition)
U(0D02015106000000, audioBlockMatrixObject)
U(0D02015107000000, audioBlockGain)
U(0D02015108000000, audioBlockDiffuse)
U(0D02015109000000, audioBlockWidth)
U(0D0201510A000000, audioBlockHeight)
U(0D0201510B000000, audioBlockDepth)
U(0D0201510C000000, audioBlockChannelLock)
U(0D0201510D000000, audioBlockJumpPosition)
U(0D0201510E000000, audioBlockEquation)
U(0D0201510F000000, audioBlockDegree)
U(0D02015110000000, audioBlockOrder)
U(0D02015111000000, audioBlockCartesian)
U(0D02015112000000, audioBlockDivergenceObject)
U(0D02015113000000, audioBlockZoneExclusionObject)
U(0D02015114000000, audioBlockScreenReferenceFlag)
U(0D02015115000000, audioBlockImportance)
U(0D02015116000000, audioBlockPositionObjects)
U(0D02015117000000, audioBlockJumpPositionObject)
//            52 - Audio Block Matrix Coefficient
U(0D02015201000000, audioBlockMatrixCoefficientValue)
U(0D02015202000000, audioBlockMatrixCoefficientGain)
U(0D02015203000000, audioBlockMatrixCoefficientGainVar)
U(0D02015204000000, audioBlockMatrixCoefficientPhase)
U(0D02015205000000, audioBlockMatrixCoefficientPhaseVar)
U(0D02015206000000, audioBlockMatrixCoefficientChannelFormatIDRefObject)
//            53 - Audio Stream Format
U(0D02015301000000, audioStreamFormatId)
U(0D02015302000000, audioStreamFormatName)
U(0D02015303000000, audioStreamFormatFormatGroupObject)
U(0D02015304000000, audioStreamAudioChannelFormatIDRefObjects)
U(0D02015305000000, audioStreamAudioPackFormatIDRefObjects)
U(0D02015306000000, audioStreamAudioTrackFormatIDRefObjects)
//            54 - Audio Track Format
U(0D02015401000000, audioTrackFormatId)
U(0D02015402000000, audioTrackFormatName)
U(0D02015403000000, audioTrackFormatFormatGroupObject)
U(0D02015404000000, audioTrackAudioStreamFormatIDRefObjects)
//            55 - Audio Track UID
U(0D02015501000000, audioTrackUIDValue)
U(0D02015502000000, audioTrackUIDSampleRate)
U(0D02015503000000, audioTrackUIDBitDepth)
U(0D02015504000000, audioTrackMXFLookupObject)
U(0D02015505000000, audioTrackAudioTrackFormatIDRefObjects)
U(0D02015506000000, audioTrackAudioPackFormatIDRefObjects)
//            56 - Audio MXF Lookup
U(0D02015601000000, audioMXFLookupPackageUIDRefObject)
U(0D02015602000000, audioMXFLookupTrackIDRefObject)
U(0D02015603000000, audioMXFLookupChannelIDRefObject)
//            57 - Audio Block Matrix
U(0D02015701000000, audioBlockMatrixCoefficientObjects)
//            58 - Time
U(0D02015801000000, timecode)
U(0D02015802000000, normalPlayTime)
U(0D02015803000000, editUnit)
U(0D02015804000000, textTime)
U(0D02015805000000, timeTypeGroupObject)
//            59 - Metadata Format
U(0D02015901000000, metadataFormatId)
U(0D02015902000000, metadataFormatName)
U(0D02015903000000, metadataFormatVersionId)
U(0D02015904000000, metadataFormatDefinition)
U(0D02015905000000, metadataTrackObjects)
U(0D02015906000000, metadataTechnicalAttributeStringObjects)
U(0D02015907000000, metadataTechnicalAttributeInt8Objects)
U(0D02015908000000, metadataTechnicalAttributeInt16Objects)
U(0D02015909000000, metadataTechnicalAttributeInt32Objects)
U(0D0201590A000000, metadataTechnicalAttributeInt64Objects)
U(0D0201590B000000, metadataTechnicalAttributeUInt8Objects)
U(0D0201590C000000, metadataTechnicalAttributeUInt16Objects)
U(0D0201590D000000, metadataTechnicalAttributeUInt32Objects)
U(0D0201590E000000, metadataTechnicalAttributeUInt64Objects)
U(0D0201590F000000, metadataTechnicalAttributeFloatObjects)
U(0D02015910000000, metadataTechnicalAttributeRationalObjects)
U(0D02015911000000, metadataTechnicalAttributeAnyURIObjects)
U(0D02015912000000, metadataTechnicalAttributeBooleanObjects)
//            5A - Timecode Format
U(0D02015A01000000, timecodeFormatId)
U(0D02015A02000000, timecodeFormatName)
U(0D02015A03000000, timecodeFormatVersionId)
U(0D02015A04000000, timecodeFormatDefinition)
U(0D02015A05000000, timecodeStartTimeObject)
U(0D02015A06000000, timecodeTrackObjects)
U(0D02015A07000000, timecodeTechnicalAttributeStringObjects)
U(0D02015A08000000, timecodeTechnicalAttributeInt8Objects)
U(0D02015A09000000, timecodeTechnicalAttributeInt16Objects)
U(0D02015A0A000000, timecodeTechnicalAttributeInt32Objects)
U(0D02015A0B000000, timecodeTechnicalAttributeInt64Objects)
U(0D02015A0C000000, timecodeTechnicalAttributeUInt8Objects)
U(0D02015A0D000000, timecodeTechnicalAttributeUInt16Objects)
U(0D02015A0E000000, timecodeTechnicalAttributeUInt32Objects)
U(0D02015A0F000000, timecodeTechnicalAttributeUInt64Objects)
U(0D02015A10000000, timecodeTechnicalAttributeFloatObjects)
U(0D02015A11000000, timecodeTechnicalAttributeRationalObjects)
U(0D02015A12000000, timecodeTechnicalAttributeAnyURIObjects)
U(0D02015A13000000, timecodeTechnicalAttributeBooleanObjects)
//            5B - Video Noise Filter
U(0D02015B01000000, videoNoiseFilterVendorId)
U(0D02015B02000000, videoNoiseFilterTypeGroupObject)
//            5D - Audience
U(0D02015D01000000, audienceReason)
U(0D02015D02000000, audienceLinkToLogo)
U(0D02015D03000000, audienceNotRatedFlag)
U(0D02015D04000000, audienceAdultContentFlag)
U(0D02015D05000000, audienceTypeGroupObject)
U(0D02015D06000000, audienceRegionObjects)
U(0D02015D07000000, audienceExclusionRegionObjects)
U(0D02015D08000000, audienceFormatGroupObject)
//            5E - Filter
U(0D02015E01000000, filterOrder)
U(0D02015E02000000, filterTypeGroupObject)
U(0D02015E03000000, filterTrackIDRefObjects)
U(0D02015E04000000, filterProfileTypeGroupObject)
U(0D02015E05000000, filterSettingObjects)
//            5F - Filter Setting
U(0D02015F01000000, filterSettingAttributeOrder)
U(0D02015F02000000, filterSettingTypeGroupObject)
U(0D02015F03000000, filterSettingTechnicalAttributeStringObjects)
U(0D02015F04000000, filterSettingTechnicalAttributeInt8Objects)
U(0D02015F05000000, filterSettingTechnicalAttributeInt16Objects)
U(0D02015F06000000, filterSettingTechnicalAttributeInt32Objects)
U(0D02015F07000000, filterSettingTechnicalAttributeInt64Objects)
U(0D02015F08000000, filterSettingTechnicalAttributeUInt8Objects)
U(0D02015F09000000, filterSettingTechnicalAttributeUInt16Objects)
U(0D02015F0A000000, filterSettingTechnicalAttributeUInt32Objects)
U(0D02015F0B000000, filterSettingTechnicalAttributeUInt64Objects)
U(0D02015F0C000000, filterSettingTechnicalAttributeFloatObjects)
U(0D02015F0D000000, filterSettingTechnicalAttributeRationalObjects)
U(0D02015F0E000000, filterSettingTechnicalAttributeAnyURIObjects)
U(0D02015F0F000000, filterSettingTechnicalAttributeBooleanObjects)
//            60 - Reference Screen
U(0D02016001000000, referenceScreenAspectRatio)
U(0D02016002000000, referenceScreenCentrePositionObject)
U(0D02016003000000, referenceScreenWidthObject)
//            61 - Reference Screen Centre Position
U(0D02016101000000, referenceScreenCentrePositionValue)
U(0D02016102000000, referenceScreenAzimuth)
U(0D02016103000000, referenceScreenElevation)
U(0D02016104000000, referenceScreenDistance)
U(0D02016105000000, referenceScreenX)
U(0D02016106000000, referenceScreenY)
U(0D02016107000000, referenceScreenZ)
//            62 - Reference Screen Width
U(0D02016201000000, referenceScreenWidthValue)
U(0D02016202000000, referenceScreenWidthAzimuth)
U(0D02016203000000, referenceScreenWidthX)
//            63 - Audio Content Dialogue
U(0D02016301000000, audioContentDialogueValue)
U(0D02016302000000, nonDialogueContentKind)
U(0D02016303000000, dialogueContentKind)
U(0D02016304000000, mixedContentkind)
//            64 - Audio Object Interaction
U(0D02016401000000, onOffInteract)
U(0D02016402000000, gainInteract)
U(0D02016403000000, positionInteract)
U(0D02016404000000, gainInteractionRangeObjects)
U(0D02016405000000, positionInteractionRangeObjects)
//            65 - Gain Interaction Range
U(0D02016501000000, gainInteractionRangeValue)
U(0D02016502000000, gainInteractionRangeBound)
//            66 - Position Interaction Range
U(0D02016601000000, positionInteractionRangeValue)
U(0D02016602000000, positionInteractionRangeCoordinate)
U(0D02016603000000, positionInteractionRangeBound)
//            67 - Audio Block Position
U(0D02016701000000, audioBlockPositionValue)
U(0D02016702000000, audioBlockPositionCoordinate)
U(0D02016703000000, audioBlockPositionBound)
U(0D02016704000000, audioBlockPositionScreenEdgeLock)
//            68 - Audio Block Divergence
U(0D02016801000000, audioBlockDivergenceValue)
U(0D02016802000000, audioBlockDivergenceAzimuthRange)
//            69 - Audio Block Zone Exclusion
U(0D02016901000000, audioBlockZoneObjects)
//            6A - Audio Block Zone
U(0D02016A01000000, audioBlockZoneValue)
U(0D02016A02000000, audioBlockZoneMinX)
U(0D02016A03000000, audioBlockZoneMaxX)
U(0D02016A04000000, audioBlockZoneMinY)
U(0D02016A05000000, audioBlockZoneMaxY)
U(0D02016A06000000, audioBlockZoneMinZ)
U(0D02016A07000000, audioBlockZoneMaxZ)
//            6B - Audio Block Jump Position
U(0D02016B01000000, audioBlockJumPositionFlag)
U(0D02016B02000000, audioBlockJumPositionInterpolationLength)
//            6C - Event
U(0D02016C01000000, eventId)
U(0D02016C02000000, eventTypeGroupObject)
U(0D02016C03000000, eventNote)
U(0D02016C04000000, eventNameObjects)
U(0D02016C05000000, eventDescriptionObjects)
U(0D02016C06000000, eventLocationObjects)
U(0D02016C07000000, eventStart)
U(0D02016C08000000, eventEnd)
//            6D - Award
U(0D02016D01000000, awardId)
U(0D02016D02000000, awardNameObjects)
U(0D02016D03000000, awardDescriptionObjects)
U(0D02016D04000000, awardCategoryObjects)
U(0D02016D05000000, awardCeremonyObjects)
U(0D02016D06000000, awardOfficialObjects)
U(0D02016D07000000, awardDateObjects)
//            6E - Affiliation
U(0D02016E01000000, affiliationOrganizationObject)
U(0D02016E02000000, affiliationPeriodOfTimeObject)
//        03 - Pro-MPEG Forum
//        04 - BBC
//          01 - Archive Preservation Project
//            01 - Archive Preservation Project Version 1
//              01 - APP Descriptive Frameworks
//                01 - APP Infax Framework
U(0D04010101010100, APP_Format)
U(0D04010101010200, APP_ProgrammeTitle)
U(0D04010101010300, APP_EpisodeTitle)
U(0D04010101010400, APP_TransmissionDate)
U(0D04010101010500, APP_MagazinePrefix)
U(0D04010101010600, APP_ProgrammeNumber)
U(0D04010101010700, APP_SpoolStatus)
U(0D04010101010800, APP_StockDate)
U(0D04010101010900, APP_SpoolDescriptor)
U(0D04010101010A00, APP_Memo)
U(0D04010101010B00, APP_Duration)
U(0D04010101010C00, APP_SpoolNumber)
U(0D04010101010D00, APP_AccessionNumber)
U(0D04010101010E00, APP_CatalogueDetail)
U(0D04010101010F00, APP_ProductionCode)
U(0D04010101011000, APP_ItemNumber)
//                02 - APP PSE Analysis Framework
U(0D04010101020100, APP_RedFlash)
U(0D04010101020200, APP_SpatialPattern)
U(0D04010101020300, APP_LuminanceFlash)
U(0D04010101020400, APP_ExtendedFailure)
//                03 - APP VTR Replay Error Framework
U(0D04010101030100, APP_VTRErrorCode)
//                04 - APP DigiBeta Dropout Framework
U(0D04010101040100, APP_Strength)
//                05 - APP Timecode Break Framework
U(0D04010101050100, APP_TimecodeType)
//              40 - APP Preface Additions
//                01 - APP Preface Additions Version 1
U(0D04010140010100, APP_VTRErrorCount)
U(0D04010140010200, APP_PSEFailureCount)
U(0D04010140010300, APP_DigiBetaDropoutCount)
U(0D04010140010400, APP_TimecodeBreakCount)
//        05 - IRT
//        06 - ARIB
//        07 - AMIA
//        08 - PBS
//        09 - ASC
//        0A - AES
//        0B - Dutch Guild
//          01 - Production Framework
U(0D0B010100000000, IsRecording)
U(0D0B010200000000, IsLiveProduction)
U(0D0B010300000000, IsLiveTransmission)
U(0D0B010400000000, IsDubbed)
U(0D0B010500000000, IsVoiceover)
U(0D0B010600000000, HasAudioWatermark)
U(0D0B010700000000, AudioWatermarkKind)
U(0D0B010800000000, HasVideoWatermark)
U(0D0B010900000000, VideoWatermarkKind)
//          02 - Subtitling
U(0D0B020100000000, SubtitlesPresent)
//          03 - Caption Titles
U(0D0B030100000000, CaptionTitles)
U(0D0B030200000000, CaptionsViaTeletext)
U(0D0B030300000000, TextlessMaterial)
//          04 - Audio Parameters
U(0D0B040100000000, AudioReferenceLevel_)
//          05 - Storage Media
U(0D0B050100000000, StorageDeviceKind)
U(0D0B050200000000, StorageMediaKind)
U(0D0B050300000000, StorageMediaID)
//          06 - Broadcast Schedule Information
U(0D0B060100000000, BroadcastDate)
U(0D0B060200000000, BroadcastTime)
U(0D0B060300000000, IsRepeat)
U(0D0B060400000000, FirstTransmissionDateTimeChannelAndBroadcaster)
U(0D0B060500000000, TeletextSubtitlesAvailable)
U(0D0B060600000000, SeasonEpisodeNumber)
U(0D0B060700000000, SeasonEpisodeTitle)
U(0D0B060800000000, EPGProgramSynopsis)
//          07 - Classification
U(0D0B070100000000, ContentClassification_)
U(0D0B070200000000, DVBParentalRating)
U(0D0B070300000000, ContentMaturityRating)
U(0D0B070400000000, ContentMaturityDescription)
U(0D0B070500000000, ContentMaturityGraphic)
//          08 - Contract
U(0D0B080100000000, ContractEntity)
U(0D0B080200000000, ContractTypeLink)
//          09 - Rights
U(0D0B090100000000, ConsumerRightsToCopy)
U(0D0B090200000000, BroadcasterRightsToCopy)
//          0A - Production Key People
U(0D0B0A0100000000, DirectorName)
U(0D0B0A0200000000, ProducerName)
U(0D0B0A0300000000, FemaleLeadActressName)
U(0D0B0A0400000000, MaleLeadActorName)
U(0D0B0A0500000000, PresenterName)
U(0D0B0A0600000000, MainSponsorName)
U(0D0B0A0700000000, VoiceTalentName)
//          0B - Address
U(0D0B0B0100000000, PostboxNumber)
U(0D0B0B0200000000, PostCodeForPostbox)
//        0C - DPP
//          01 - DPP Schemes
//            01 - AS-11 UKDPP
//              01 - DPP Groups
//                01 - AS-11 UKDPP Framework
U(0D0C010101010100, UKDPP_Production_Number)
U(0D0C010101010200, UKDPP_Synopsis)
U(0D0C010101010300, UKDPP_Originator)
U(0D0C010101010400, UKDPP_Copyright_Year)
U(0D0C010101010500, UKDPP_Other_Identifier)
U(0D0C010101010600, UKDPP_Other_Identifier_Type)
U(0D0C010101010700, UKDPP_Genre)
U(0D0C010101010800, UKDPP_Distributor)
U(0D0C010101010900, UKDPP_Picture_Ratio)
U(0D0C010101010A00, UKDPP_3D)
U(0D0C010101010B00, UKDPP_3D_Type)
U(0D0C010101010C00, UKDPP_Product_Placement)
U(0D0C010101010D00, UKDPP_PSE_Pass)
U(0D0C010101010E00, UKDPP_PSE_Manufacturer)
U(0D0C010101010F00, UKDPP_PSE_Version)
U(0D0C010101011000, UKDPP_Video_Comments)
U(0D0C010101011100, UKDPP_Secondary_Audio_Language)
U(0D0C010101011200, UKDPP_Tertiary_Audio_Language)
U(0D0C010101011300, UKDPP_Audio_Loudness_Standard)
U(0D0C010101011400, UKDPP_Audio_Comments)
U(0D0C010101011500, UKDPP_Line_Up_Start)
U(0D0C010101011600, UKDPP_Ident_Clock_Start)
U(0D0C010101011700, UKDPP_Total_Number_Of_Parts)
U(0D0C010101011800, UKDPP_Total_Programme_Duration)
U(0D0C010101011900, UKDPP_Audio_Description_Present)
U(0D0C010101011A00, UKDPP_Audio_Description_Type)
U(0D0C010101011B00, UKDPP_Open_Captions_Present)
U(0D0C010101011C00, UKDPP_Open_Captions_Type)
U(0D0C010101011D00, UKDPP_Open_Captions_Language)
U(0D0C010101011E00, UKDPP_Signing_Present)
U(0D0C010101011F00, UKDPP_Sign_Language)
U(0D0C010101012000, UKDPP_Completion_Date)
U(0D0C010101012100, UKDPP_Textless_Elements_Exist)
U(0D0C010101012200, UKDPP_Programme_Has_Text)
U(0D0C010101012300, UKDPP_Programme_Text_Language)
U(0D0C010101012400, UKDPP_Contact_Email)
U(0D0C010101012500, UKDPP_Contact_Telephone_Number)
//        0D - Ad-ID
//          01 - DMS_AS_12_AdID_Slate
U(0D0D010100000000, adid_prefix)
U(0D0D010200000000, adid_code)
U(0D0D010300000000, ad_title)
U(0D0D010400000000, brand)
U(0D0D010500000000, product)
U(0D0D010600000000, advertiser)
U(0D0D010700000000, agency_office_location)
U(0D0D010800000000, length)
U(0D0D010900000000, medium_)
U(0D0D010A00000000, sd_flag)
U(0D0D010B00000000, parent)
//        0E - LOC_Elements
//          01 - LOC_ApplicationSpecifications_Elements
//            01 - LOC_ApplicationSpecifications_Elements_V1
//              07 - AS_07_Elements
//                01 - AS_07_DMS_Elements
U(0D0E010107010101, AS_07_Core_DMS_ShimName)
U(0D0E010107010102, AS_07_Core_DMS_Identifiers)
U(0D0E010107010103, AS_07_Core_DMS_ResponsibleOrganizationName)
U(0D0E010107010105, AS_07_Core_DMS_ResponsibleOrganizationCode)
U(0D0E010107010106, AS_07_Core_DMS_NatureOfOrganization)
U(0D0E010107010107, AS_07_Core_DMS_WorkingTitle)
U(0D0E010107010108, AS_07_Core_DMS_SecondaryTitle)
U(0D0E010107010109, AS_07_Core_DMS_PictureFormat)
U(0D0E01010701010A, AS_07_Core_DMS_IntendedAFD)
U(0D0E01010701010B, AS_07_Core_DMS_Captions)
U(0D0E01010701010C, AS_07_Core_DMS_AudioTrackPrimaryLanguage)
U(0D0E01010701010D, AS_07_Core_DMS_AudioTrackSecondaryLanguage)
U(0D0E01010701010E, AS_07_Core_DMS_AudioTrackLayout)
U(0D0E01010701010F, AS_07_Core_DMS_AudioTrackLayoutComment)
U(0D0E010107010110, AS_07_Core_DMS_Devices)
U(0D0E010107010202, AS_07_Core_DMS_DeviceType)
U(0D0E010107010203, AS_07_Core_DMS_DeviceManufacturer)
U(0D0E010107010204, AS_07_Core_DMS_DeviceModel)
U(0D0E010107010205, AS_07_Core_DMS_DeviceSerialNumber)
U(0D0E010107010206, AS_07_Core_DMS_DeviceUsageDescription)
U(0D0E010107010302, AS_07_DMS_IdentifierValue)
U(0D0E010107010303, AS_07_DMS_IdentifierRole)
U(0D0E010107010304, AS_07_DMS_IdentifierType)
U(0D0E010107010305, AS_07_DMS_IdentifierComment)
U(0D0E010107010401, AS_07_GSP_DMS_Identifiers)
U(0D0E010107010402, AS_07_GSP_DMS_MIMEMediaType)
U(0D0E010107010403, AS_07_GSP_DMS_DataDescription)
U(0D0E010107010404, AS_07_GSP_DMS_Note)
//                02 - AS_07_GSP_Elements
U(0D0E010107020301, AS_07_GSP_TD_DMS_PrimaryRFC5646LanguageCode)
U(0D0E010107020302, AS_07_GSP_TD_DMS_SecondaryRFC5646LanguageCode)
//                03 - AS_07_Segmentation_Elements
U(0D0E010107030101, AS_07_Segmentation_DMS_PartNumber)
U(0D0E010107030102, AS_07_Segmentation_DMS_PartTotal)
U(0D0E010107040101, AS_07_DateTimeSymbol)
U(0D0E010107040102, AS_07_DateTimeEssenceTrackID)
U(0D0E010107040103, AS_07_DateTimeChannelID)
U(0D0E010107040104, AS_07_DateTimeDescription)
U(0D0E010107040300, MICCarriage)
//        0F - Inter-Society Digital Cinema Forum
//      0E - Organizationally Registered as Private
//        01 - MISB Systems
//        02 - ASPA
//        03 - MISB Classified
//        04 - Avid Technology, Inc.
//        05 - CNN
//        06 - Sony Corporation
//        07 - IdeasUnlimited.TV
//        08 - IPV Ltd
//        09 - Dolby Laboratories Inc.
U(0E09040000000000, DolbyNamespaceURI)
U(0E09050600000000, ImmersiveAudioVersion)
U(0E09050700000000, MaxChannelCount)
U(0E09050800000000, MaxObjectCount)
U(0E09050900000000, ImmersiveAudioID)
U(0E09050A00000000, FirstFrame)
U(0E09060701010104, PHDRDataDefinition)
U(0E09060701010105, PHDRSourceTrackID)
U(0E09060701010106, PHDRSimplePayloadSID)
//        0A - Snell & Wilcox
//        0B - Omneon Video Networks
//          01 - Omneon Video Networks 01
//            03 - Omneon Video Networks 0103
//              01 - Omneon Video Networks 0103.01
//                01 - Omneon Video Networks 0103.0101
//                  01 - Omneon Video Networks 0103.010101
U(0E0B010301010101, OmneonVideoNetworksDescriptiveMetadataItems)
//        0C - Ascent Media Group, Inc.
//        0D - Quantel Ltd
//        0E - Panasonic
//        0F - Grass Valley, Inc.
//        10 - Doremi Labs, Inc.
//        11 - EVS Broadcast Equipment
//        12 - Turner Broadcasting System, Inc.
//        13 - NL Technology, LLC
//        14 - Harris Corporation
//        15 - Canon, Inc.
//        16 - D-BOX Technologies
//        17 - ARRI
//        18 - JVC
//        19 - 3ality Technica
//        1A - NHK
//        1B - HBO
//        1D - DTS, Inc.
//        1E - FLIR Systems, Inc.
//        1F - Barco
//        20 - Apple Inc.
//        21 - Fraunhofer
//        22 - RED
//        23 - CRIFST
//          06 - CRIFST 06
//            07 - CRIFST 0607
//              01 - CRIFST 0607.01
//                01 - CRIFST 0607.0101
//                  01 - CRIFST 0607.010101
U(0E23060701010104, HdrVividDataDefinition)
U(0E23060701010105, HdrVividSourceTrackID)
U(0E23060701010106, HdrVividSimplePayloadSID)
//      0F - Experimental
//      43 - Legacy (315M)
}

namespace Essences
{
//      00 - Elements
//      0D - Organizationally Registered for Public Use
//        01 - AAF Association
//          03 - MXF Generic Container Keys
//            01 - MXF Generic Container Keys Version 1
//              01 - MXF Generic Container - Deprecated
//              02 - MXF Generic Container
//              04 - CP-Compatible System Item
//              05 - CP Picture
U(0D01030105000100, D10Video)
//              06 - CP Sound
U(0D01030106001000, D10Audio)
//              07 - CP Data
//              14 - GC-Compatible System Item
U(0D01030114000100, UncompressedSystem_Line)
//              15 - GC Picture
U(0D01030115000100, D11Video)
U(0D01030115000200, Uncompressed_Frame)
U(0D01030115000300, Uncompressed_Clip)
U(0D01030115000400, Uncompressed_Line)
U(0D01030115000500, MPEG_Frame)
U(0D01030115000600, MPEG_Clip)
U(0D01030115000700, MPEG_Custom)
U(0D01030115000800, JPEG2000)
U(0D01030115000A00, VC1_Frame)
U(0D01030115000B00, VC1_Clip)
U(0D01030115000C00, VC3_Frame)
U(0D01030115000D00, VC3_Clip)
U(0D01030115001700, ProRes)
U(0D01030115001D00, FFV1_Frame)
U(0D01030115001E00, FFV1_Clip)
//              16 - GC Sound
U(0D01030116000100, PCM1)
U(0D01030116000200, PCM2)
U(0D01030116000300, DVAudio)
U(0D01030116000400, PCM_P2)
U(0D01030116000500, MPEGA_Frame)
U(0D01030116000600, MPEGA_Clip)
U(0D01030116000700, MPEGA_Custom)
U(0D01030116000800, ALaw_Frame)
U(0D01030116000900, ALaw_Clip)
U(0D01030116000A00, ALaw_Custom)
U(0D01030116000D00, IAB_Clip)
U(0D01030116000E00, MGA_Frame)
U(0D01030116000F00, MGA_Clip)
U(0D01030116001000, IAB_Frame)
U(0D010301167F107F, IAB_Temp)
//              17 - GC Data
U(0D01030117000100, VBI_Frame)
U(0D01030117000200, ANC_Frame)
U(0D01030117000800, xANC_Line)
U(0D01030117000900, VANC_Line)
U(0D01030117000A00, HANC_Line)
U(0D01030117000B00, TimedText)
//              18 - GC Compound
U(0D01030118000100, DVDIF_Frame)
U(0D01030118000200, DVDIF_Clip)
//      0E - Organizationally Registered as Private
//        04 - Avid Technology, Inc.
//          03 - Avid Technology, Inc. MXF Generic Container Keys
//              15 - Avid Technology, Inc. MXF Generic Container Keys
//            01 - Avid Technology, Inc. MXF Generic Container Keys Version 1
U(0E04030115000500, AvidTechnologyInc_VC3_Frame)
U(0E04030115000600, AvidTechnologyInc_VC3_Clip)
U(0E04030115000700, AvidTechnologyInc_VC3_Custom)
//        06 - Sony Corporation
//            03 - Sony Corporation MXF Generic Container Keys Version 1
//        09 - Dolby Laboratories Inc.
U(0E09050201000100, FrameWrappedISXDData)
U(0E09050217000100, FrameWrappedISXDData2)
U(0E09060701000100, PHDRImageMetadataItem)
//        23 - CRIFST
U(0E23060701000100, HdrVividMetadataItem)
}

namespace GroupsPacks
{
U(0532010000000000, MDColorVolumeMetadata)
U(0532020000000000, MaximumLightLevelMetadata)
//          02
U(0C03020100000000, OMBBadRequestResponse)
U(0C03020200000000, GetCertificateRequest)
U(0C03020300000000, GetCertificateResponse)
U(0C03020400000000, AdjustSecureTimeRequest)
U(0C03020500000000, AdjustSecureTimeResponse)
U(0C03020600000000, GetSecureTimeRequest)
U(0C03020700000000, GetSecureTimeResponse)
U(0C03020800000000, ValidateCPLRequest)
U(0C03020900000000, ValidateCPLResponse)
U(0C03020A00000000, GetCPLValidationResultRequest)
U(0C03020B00000000, GetCPLValidationResultResponse)
U(0C03020C00000000, ValidateKDMRequest)
U(0C03020D00000000, ValidateKDMResponse)
U(0C03020E00000000, GetKDMValidationResultRequest)
U(0C03020F00000000, GetKDMValidationResultResponse)
U(0C03021000000000, ValidatePlaybackRequest)
U(0C03021100000000, ValidatePlaybackResponse)
U(0C03021200000000, InvalidatePlaybackRequest)
U(0C03021300000000, InvalidatePlaybackResponse)
U(0C03021400000000, GetDeviceInfoRequest)
U(0C03021500000000, GetDeviceInfoResponse)
U(0C03021600000000, GetStatusRequest)
U(0C03021700000000, GetStatusResponse)
U(0C03021800000000, GenerateSecurityLogReportRequest)
U(0C03021900000000, GenerateSecurityLogReportResponse)
U(0C03021A00000000, GetSecurityLogReportRequest)
U(0C03021B00000000, GetSecurityLogReportResponse)
U(0C03021C00000000, CancelSecurityLogReportRequest)
U(0C03021D00000000, CancelSecurityLogReportResponse)
U(0C03021E00000000, GenerateCPLProcessedLogReportRequest)
U(0C03021F00000000, GenerateCPLProcessedLogReportResponse)
U(0C03022000000000, GetCPLProcessedLogReportRequest)
U(0C03022100000000, GetCPLProcessedLogReportResponse)
U(0C03022200000000, CancelCPLProcessedLogReportRequest)
U(0C03022300000000, CancelCPLProcessedLogReportResponse)
U(0C04010000000000, AudioMetadataPack)
//          02
//            01
//              01
U(0D01020101010000, PartitionPack)
U(0D01020101020000, HeaderPartitionPack)
U(0D01020101020100, HeaderPartitionOpenIncomplete)
U(0D01020101020200, HeaderPartitionClosedIncomplete)
U(0D01020101020300, HeaderPartitionOpenComplete)
U(0D01020101020400, HeaderPartitionClosedComplete)
U(0D01020101030000, BodyPartitionPack)
U(0D01020101030100, BodyPartitionOpenIncomplete)
U(0D01020101030200, BodyPartitionClosedIncomplete)
U(0D01020101030300, BodyPartitionOpenComplete)
U(0D01020101030400, BodyPartitionClosedComplete)
U(0D01020101031100, GenericStreamPartition)
U(0D01020101040000, FooterPartitionPack)
U(0D01020101040200, FooterPartitionClosedIncomplete)
U(0D01020101040400, FooterPartitionClosedComplete)
U(0D01020101050100, PrimerPack)
U(0D01020101110100, RandomIndexPack)
}
namespace Groups
{
//      00 - Groups
//      01 - Identification and location
//      02 - Administrative
//        07 - Access Control
//          01 - Auditorium Security
//            01 - Error
U(0207010101000000, BadRequestResponse)
//            02 - General purpose
U(0207010210000000, TimeRequest)
U(0207010211000000, TimeResponse)
U(0207010212000000, EventListRequest)
U(0207010213000000, EventListResponse)
U(0207010214000000, EventIDRequest)
U(0207010215000000, EventIDResponse)
U(0207010216000000, SecureProcessingBlockQueryRequest)
U(0207010217000000, SecureProcessingBlockQueryResponse)
U(0207010218000000, ProjectorCertificateRequest)
U(0207010219000000, ProjectorCertificateResponse)
//            03 - Link encryption
U(0207010320000000, LinkEncryptionKeyLoadRequest)
U(0207010321000000, LinkEncryptionKeyLoadResponse)
U(0207010322000000, LinkEncryptionKeyQueryIDRequest)
U(0207010323000000, LinkEncryptionKeyQueryIDResponse)
U(0207010324000000, LinkEncryptionKeyQueryAllRequest)
U(0207010325000000, LinkEncryptionKeyQueryAllResponse)
U(0207010326000000, LinkEncryptionPurgeIDRequest)
U(0207010327000000, LinkEncryptionPurgeIDResponse)
U(0207010328000000, LinkEncryptionPurgeAllRequest)
U(0207010329000000, LinkEncryptionPurgeAllResponse)
//      03 - Interpretive
//      04 - Parametric
//      05 - Process
//        31 - Color Transform Sets
//          01 - DMCVT Generic Sets
U(0531010100000000, DMCVTGenericSet1)
//          02 - DMCVT Application Sets
U(0531020100000000, DMCVTApp1Set)
U(0531020200000000, DMCVTApp2Set)
U(0531020300000000, DMCVTApp3Set)
U(0531020400000000, DMCVTApp4Set)
//        32 - Color Transform Packs
//      06 - Relational
//      07 - Spatio-temporal
//      0C - Compound
//        01 - Data Models
//          01 - Dictionary Representation
//            01 - Registry Interchange Format (RIF)
//              01 - RIF Version 1 Compatible Classes
U(0C01010101010100, AdministrativeBaseClass)
U(0C01010101010200, CompoundEntryElementBaseClass)
U(0C01010101010300, Entry)
U(0C01010101010400, EntryAdministration)
U(0C01010101010500, Leaf)
U(0C01010101010600, Node)
U(0C01010101010700, Register)
U(0C01010101010800, RegisterAdministration)
U(0C01010101010900, RifBaseClass)
//        02 - Production Metadata
//          01 - Acquisition
//            01 - Frame based
U(0C02010101010000, LensUnitAcquisitionMetadata)
U(0C02010102010000, CameraUnitAcquisitionMetadata)
U(0C0201017F010000, UserDefinedAcquisitionMetadata)
//        03 - Messages
//          01 - Aux Data Transfer Protocol
U(0C03010100000000, AuxDataBlockTransferHeader)
U(0C03010200000000, AuxDataBlock)
//          02 - SMS-OMB Communications Protocol
//        04 - Audio Metadata
//        05 - Data Sets
U(0C05010100000000, StreamingData)
//      0D - Organizationally Registered for Public Use
//        01 - AAF Association
//          01 - AAF Association Structural Metadata
//            01 - AAF Version 1.x Classes
//              01 - Standard Classes
//                01 - Class
U(0D01010101010100, InterchangeObject)
U(0D01010101010200, Component)
U(0D01010101010300, Segment)
U(0D01010101010400, EdgeCode)
U(0D01010101010500, EssenceGroup)
U(0D01010101010600, Event)
U(0D01010101010700, GPITrigger)
U(0D01010101010800, CommentMarker)
U(0D01010101010900, FillerGroup)
U(0D01010101010A00, OperationGroup)
U(0D01010101010B00, NestedScope)
U(0D01010101010C00, Pulldown)
U(0D01010101010D00, ScopeReference)
U(0D01010101010E00, Selector)
U(0D01010101010F00, Sequence)
U(0D01010101011000, SourceReference)
U(0D01010101011100, SourceClip)
U(0D01010101011200, TextClip)
U(0D01010101011300, HTMLClip)
U(0D01010101011400, TimecodeGroup)
U(0D01010101011500, TimecodeStream)
U(0D01010101011600, TimecodeStream12M)
U(0D01010101011700, Transition)
U(0D01010101011800, ContentStorage)
U(0D01010101011900, ControlPoint)
U(0D01010101011A00, DefinitionObject)
U(0D01010101011B00, DataDefinitionGroup)
U(0D01010101011C00, OperationDefinition)
U(0D01010101011D00, ParameterDefinition)
U(0D01010101011E00, PluginDefinition)
U(0D01010101011F00, CodecDefinition)
U(0D01010101012000, ContainerDefinition)
U(0D01010101012100, InterpolationDefinition)
U(0D01010101012200, Dictionary)
U(0D01010101012300, EssenceData)
U(0D01010101012400, EssenceDescriptor)
U(0D01010101012500, FileDescriptor)
U(0D01010101012600, AIFCDescriptor)
U(0D01010101012700, PictureDescriptor)
U(0D01010101012800, CDCIDescriptor)
U(0D01010101012900, RGBADescriptor)
U(0D01010101012A00, HTMLDescriptor)
U(0D01010101012B00, TIFFDescriptor)
U(0D01010101012C00, WAVEDescriptor)
U(0D01010101012D00, FilmDescriptor)
U(0D01010101012E00, TapeDescriptor)
U(0D01010101012F00, Preface)
U(0D01010101013000, Identification)
U(0D01010101013100, Locator)
U(0D01010101013200, NetworkLocator)
U(0D01010101013300, TextLocator)
U(0D01010101013400, Package)
U(0D01010101013500, CompositionPackage)
U(0D01010101013600, MaterialPackage)
U(0D01010101013700, SourcePackage)
U(0D01010101013800, Track)
U(0D01010101013900, EventTrack)
U(0D01010101013A00, StaticTrack)
U(0D01010101013B00, TimelineTrack)
U(0D01010101013C00, Parameter)
U(0D01010101013D00, ConstantValue)
U(0D01010101013E00, VaryingValue)
U(0D01010101013F00, TaggedValue)
U(0D01010101014000, KLVData)
U(0D01010101014100, DescriptiveMarker)
U(0D01010101014200, SoundDescriptor)
U(0D01010101014300, DataEssenceDescriptor)
U(0D01010101014400, MultipleDescriptor)
U(0D01010101014500, DescriptiveClip)
U(0D01010101014600, DateTimeDescriptor)
U(0D01010101014700, AES3PCMDescriptor)
U(0D01010101014800, WAVEPCMDescriptor)
U(0D01010101014900, PhysicalDescriptor)
U(0D01010101014A00, ImportDescriptor)
U(0D01010101014B00, RecordingDescriptor)
U(0D01010101014C00, TaggedValueDefinition)
U(0D01010101014D00, KLVDataDefinition)
U(0D01010101014E00, AuxiliaryDescriptor)
U(0D01010101014F00, RIFFChunk)
U(0D01010101015000, BWFImportDescriptor)
U(0D01010101015100, MPEGVideoDescriptor)
U(0D01010101015200, ParsedTextDescriptor)
U(0D01010101015300, SGMLDescriptor)
U(0D01010101015400, XMLDescriptor)
U(0D01010101015500, HTMLParsedTextDescriptor)
U(0D01010101015600, RP217Descriptor)
U(0D01010101015700, DynamicMarker)
U(0D01010101015800, DynamicClip)
U(0D01010101015900, SubDescriptor)
U(0D01010101015A00, JPEG2000SubDescriptor)
U(0D01010101015B00, VBIDataDescriptor)
U(0D01010101015C00, ANCDataDescriptor)
U(0D01010101015D00, DCPCMSoundDescriptor)
U(0D01010101015E00, MPEGAudioDescriptor)
U(0D01010101015F00, VC1VideoDescriptor)
U(0D01010101016000, PackageMarker)
U(0D01010101016100, ApplicationPlugInObject)
U(0D01010101016200, ApplicationReferencedObject)
U(0D01010101016300, StereoscopicPictureSubDescriptor)
U(0D01010101016400, DCTimedTextDescriptor)
U(0D01010101016500, DCTimedTextResourceSubDescriptor)
U(0D01010101016600, ApplicationObject)
U(0D01010101016700, ContainerConstraintsSubDescriptor)
U(0D01010101016800, MPEG4VisualSubDescriptor)
U(0D01010101016900, TIFFPictureEssenceDescriptor)
U(0D01010101016A00, MCALabelSubDescriptor)
U(0D01010101016B00, AudioChannelLabelSubDescriptor)
U(0D01010101016C00, SoundfieldGroupLabelSubDescriptor)
U(0D01010101016D00, GroupOfSoundfieldGroupsLabelSubDescriptor)
U(0D01010101016E00, AVCSubDescriptor)
U(0D01010101016F00, EventTextDescriptor)
U(0D01010101017000, STLDescriptor)
U(0D01010101017100, STLSubDescriptor)
U(0D01010101017200, OperationsStereoscopicSubDescriptor)
U(0D01010101017300, AuxDataEssenceDescriptor)
U(0D01010101017400, VC2SubDescriptor)
U(0D01010101017500, DMCVTTargetSubDescriptor)
U(0D01010101017600, VC5BayerPictureEssenceSubDescriptor)
U(0D01010101017700, VC5CDCIPictureEssenceSubDescriptor)
U(0D01010101017800, AACSubDescriptor)
U(0D01010101017900, ACESPictureSubDescriptor)
U(0D01010101017A00, TargetFrameSubDescriptor)
U(0D01010101017B00, IABEssenceDescriptor)
U(0D01010101017C00, IABSoundfieldLabelSubDescriptor)
U(0D01010101017D00, OPDefinition)
U(0D01010101017E00, CompressionDefinition)
U(0D01010101017F00, AbstractObject)
//                  81
U(0D01010101018101, HEVCSubDescriptor)
U(0D01010101018102, JPEGXSSubDescriptor)
U(0D01010101018103, FFV1PictureSubDescriptor)
U(0D01010101018106, MGASoundEssenceDescriptor)
U(0D01010101018107, MGAAudioMetadataSubDescriptor)
U(0D01010101018108, MGASoundfieldGroupLabelSubDescriptor)
U(0D01010101018109, SADMAudioMetadataSubDescriptor)
U(0D0101010101810A, SupplementalDataEssenceDescriptor)
U(0D0101010101810B, DataStreamSubDescriptor)
U(0D0101010101810C, DataStreamDeviceSubDescriptor)
U(0D0101010101810D, RIFFChunkDefinitionSubDescriptor)
U(0D0101010101810E, ADM_CHNASubDescriptor)
U(0D0101010101810F, ADMChannelMapping)
U(0D01010101018110, RIFFChunkReferencesSubDescriptor)
U(0D01010101018111, ADMAudioMetadataSubDescriptor)
U(0D01010101018112, ADMSoundfieldGroupLabelSubDescriptor)
//              02 - Meta-Definitions
U(0D01010102010000, ClassDefinition)
U(0D01010102020000, PropertyDefinition)
U(0D01010102030000, TypeDefinition)
U(0D01010102040000, TypeDefinitionInteger)
U(0D01010102050000, TypeDefinitionStrongObjectReference)
U(0D01010102060000, TypeDefinitionWeakObjectReference)
U(0D01010102070000, TypeDefinitionEnumeration)
U(0D01010102080000, TypeDefinitionFixedArray)
U(0D01010102090000, TypeDefinitionVariableArray)
U(0D010101020A0000, TypeDefinitionSet)
U(0D010101020B0000, TypeDefinitionString)
U(0D010101020C0000, TypeDefinitionStream)
U(0D010101020D0000, TypeDefinitionRecord)
U(0D010101020E0000, TypeDefinitionRename)
U(0D01010102200000, TypeDefinitionExtendibleEnumeration)
U(0D01010102210000, TypeDefinitionIndirect)
U(0D01010102220000, TypeDefinitionOpaque)
U(0D01010102230000, TypeDefinitionCharacter)
U(0D01010102240000, MetaDefinition)
U(0D01010102250000, MetaDictionary)
U(0D01010102260000, ExtensionScheme)
U(0D01010102270000, PropertyAliasDefinition)
U(0D01010102280000, ExtendibleEnumerationElement)
U(0D01010103000000, Root)
//          02 - MXF File Structure
//            01 - MXF File Structure Version 1
//              01 - MXF File Structure Sets and Packs
//                05 - Primer Pack
//                10 - Index Tables
U(0D01020101100100, IndexTableSegment)
//                11 - Other MXF Packs
//          03 - Essence Container Labels
//            01 - Essence Container Labels Version 1
//              01 - Generic Container Labels - Deprecated
//              02 - Generic Container Labels
//                7E - EncryptedEssence
U(0D010301027E0100, EncryptedTriplet)
//              04 - CP-Compatible System Item
//                01 - SDTI
U(0D01030104010100, SDTISystemMetadataPack)
U(0D01030104010200, SDTIPackageMetadataSet)
U(0D01030104010300, SDTIPictureMetadataSet)
U(0D01030104010400, SDTISoundMetadataSet)
U(0D01030104010500, SDTIDataMetadataSet)
U(0D01030104010600, SDTIControlMetadataSet)
//              14 - GC-Compatible System Item
//                02 - System Scheme 1
U(0D01030114020100, SystemScheme1FirstElement)
U(0D01030114020200, SystemScheme1SubsequentElement)
U(0D01030114020300, SystemScheme1PictureItemDescriptor)
U(0D01030114020400, SystemScheme1SoundItemDescriptor)
U(0D01030114020500, SystemScheme1DataItemDescriptor)
U(0D01030114020600, SystemScheme1ControlDataSet)
U(0D01030114020700, SystemScheme1CompoundItemDescriptor)
U(0D01040000000000, DescriptiveObject)
U(0D01040100000000, DescriptiveFramework)
//              01 - DMS-1 Descriptive Metadata Scheme
//                01 - DMS-1 Frameworks
U(0D01040101010100, ProductionFramework)
U(0D01040101010200, ClipFramework)
U(0D01040101010300, SceneFramework)
//                10 - DMS-1 Title Sets
U(0D01040101100100, Titles)
//                11 - DMS-1 Identification Sets
U(0D01040101110100, DMS1Identification)
//                12 - DMS-1 Relationship Sets
U(0D01040101120100, GroupRelationship)
//                13 - DMS-1 Branding Sets
U(0D01040101130100, Branding)
//                14 - DMS-1 Publication Sets
U(0D01040101140100, DMS1Event)
U(0D01040101140200, Publication)
//                15 - DMS-1 Awards Sets
U(0D01040101150100, Award)
//                16 - DMS-1 Captions Sets
U(0D01040101160100, CaptionsDescription)
//                17 - DMS-1 Interpretive Sets
U(0D01040101170100, DMS1Annotation)
U(0D01040101170200, SettingPeriod)
U(0D01040101170300, Scripting)
U(0D01040101170400, Classification)
U(0D01040101170500, Shot)
U(0D01040101170600, Keypoint)
U(0D01040101170800, CueWords)
//                18 - DMS-1 Role Sets
U(0D01040101180100, Participant)
//                19 - DMS-1 Contact Collections
U(0D01040101190100, ContactsList)
//                1A - DMS-1 Contact Sets
U(0D010401011A0200, Person)
U(0D010401011A0300, Organization)
U(0D010401011A0400, Location)
//                1B - DMS-1 Contact Information Sets
U(0D010401011B0100, Address)
U(0D010401011B0200, Communications)
//                1C - DMS-1 Rights Sets
U(0D010401011C0100, Contract)
U(0D010401011C0200, Rights)
//                1D - DMS-1 Format Sets
U(0D010401011D0100, PictureFormat)
//                1E - DMS-1 Parametric Sets
U(0D010401011E0100, DeviceParameters)
//                1F - DMS-1 Name-Value Sets
U(0D010401011F0100, NameValue)
//                20 - DMS-1 Project Sets
U(0D01040101200100, Processing)
U(0D01040101200200, Project)
//                7F - DMS-1 Abstract Sets
U(0D010401017F0100, DMS1Framework)
U(0D010401017F0200, ProductionClipFramework)
U(0D010401017F1000, DMS1Object)
U(0D010401017F1100, TextLanguage)
U(0D010401017F1200, Thesaurus)
U(0D010401017F1A00, Contact)
//              02 - DMS-Crypto Descriptive Sets
U(0D01040102010000, CryptographicFramework)
U(0D01040102020000, CryptographicContext)
//              03 - DMS AS-03
U(0D01040103010000, DMS_AS_03_Framework)
//              04 - Text-based Descriptive Metadata Scheme
//                01 - Text-based Frameworks
U(0D01040104010100, TextBasedFramework)
//                02 - Text-based Descriptive Metadata Sets
U(0D01040104020100, GenericStreamTextBasedSet)
U(0D01040104020200, UTF8TextBasedSet)
U(0D01040104020300, UTF16TextBasedSet)
//                03 - Text-based Objects
U(0D01040104030100, TextBasedObjectGroup)
//              05 - EIDR Descriptive Metadata Scheme
U(0D01040105010000, EIDRFramework)
//          07 - AMWA Application Specifications
//            01 - Application Specifications Version 1
//              01 - Application Specifications Common
//                01 - Segmentation
U(0D01070101010100, DM_Segmentation_Framework)
//              07 - AS_07
//              0A - AS-10
//                01 - DMS AS-10 Core
U(0D0107010A010100, DMS_AS_10_Core_Framework)
//              0B - AS-11
//                01 - AS-11 Core
U(0D0107010B010100, DM_AS_11_Core_Framework)
//                02 - AS-11 Segmentation
U(0D0107010B020100, DM_AS_11_Segmentation_Framework)
//              0C - AS-12
//                01 - DMS_AS_12
U(0D0107010C010100, DMS_AS_12_Framework)
U(0D0107010C010200, AS_12_DescriptiveObject)
//          08 - AMWA Rules Based Specifications
//            01 - Rules Based Specifications Version 1
//        02 - EBU/UER
//          01 - EBUCore
U(0D02010100000000, EBUCoreMainFramework)
U(0D02010200000000, coreMetadata)
U(0D02010300000000, metadataSchemaInformation)
U(0D02010400000000, identifier)
U(0D02010500000000, title)
U(0D02010600000000, alternativeTitle)
U(0D02010800000000, subject)
U(0D02010900000000, description)
U(0D02010C00000000, date)
U(0D02010D00000000, dateType)
U(0D02010E00000000, type)
U(0D02010F00000000, objectType)
U(0D02011000000000, genre)
U(0D02011100000000, targetAudience)
U(0D02011200000000, language)
U(0D02011300000000, coverage)
U(0D02011400000000, spatial)
U(0D02011500000000, location)
U(0D02011600000000, coordinates)
U(0D02011700000000, temporal)
U(0D02011800000000, periodOfTime)
U(0D02011900000000, rights)
U(0D02011A00000000, version)
U(0D02011B00000000, rating)
U(0D02011C00000000, publicationEvent)
U(0D02011D00000000, publicationHistory)
U(0D02011E00000000, publicationChannel)
U(0D02011F00000000, publicationMedium)
U(0D02012000000000, publicationService)
U(0D02012100000000, entity)
U(0D02012200000000, contact)
U(0D02012300000000, organization)
U(0D02012400000000, department)
U(0D02012500000000, details)
U(0D02012600000000, address)
U(0D02012700000000, region)
U(0D02012800000000, compoundName)
U(0D02012900000000, role)
U(0D02012A00000000, countryType)
//            2B
U(0D02012B01000000, customRelation)
U(0D02012B02000000, basicRelation)
U(0D02012C00000000, planning)
//            2D
U(0D02012D01000000, typeGroup)
U(0D02012D02000000, formatGroup)
U(0D02012D03000000, statusGroup)
U(0D02012E00000000, textualAnnotation)
U(0D02012F00000000, basicLink)
U(0D02013000000000, format)
U(0D02013100000000, videoFormat)
U(0D02013200000000, imageFormat)
U(0D02013300000000, audioFormat)
U(0D02013400000000, track)
U(0D02013500000000, dataFormat)
U(0D02013600000000, captioning)
U(0D02013700000000, subtitling)
U(0D02013800000000, ancillaryData)
U(0D02013900000000, signingFormat)
//            3A
U(0D02013A01000000, technicalAttributeString)
U(0D02013A02000000, technicalAttributeInt8)
U(0D02013A03000000, technicalAttributeInt16)
U(0D02013A04000000, technicalAttributeInt32)
U(0D02013A05000000, technicalAttributeInt64)
U(0D02013A06000000, technicalAttributeUInt8)
U(0D02013A07000000, technicalAttributeUInt16)
U(0D02013A08000000, technicalAttributeUInt32)
U(0D02013A09000000, technicalAttributeUInt64)
U(0D02013A0A000000, technicalAttributeFloat)
U(0D02013A0B000000, technicalAttributeRational)
U(0D02013A0C000000, technicalAttributeAnyURI)
U(0D02013A0D000000, technicalAttributeBoolean)
U(0D02013B00000000, dimension)
U(0D02013C00000000, packageInfo)
U(0D02013D00000000, medium)
U(0D02013E00000000, codec)
U(0D02013F00000000, rational)
U(0D02014000000000, aspectRatio)
U(0D02014100000000, height)
U(0D02014200000000, width)
U(0D02014300000000, part)
U(0D02014400000000, partMetadata)
U(0D02014600000000, hash)
U(0D02014700000000, locator)
U(0D02014800000000, containerFormat)
U(0D02014900000000, audioFormatExtended)
U(0D02014A00000000, audioProgramme)
U(0D02014B00000000, IDRef)
U(0D02014C00000000, loudnessMetadata)
U(0D02014D00000000, audioContent)
U(0D02014E00000000, audioObject)
U(0D02014F00000000, audioPackFormat)
U(0D02015000000000, audioChannelFormat)
U(0D02015100000000, audioBlockFormat)
U(0D02015200000000, audioBlockMatrixCoefficient)
U(0D02015300000000, audioStreamFormat)
U(0D02015400000000, audioTrackFormat)
U(0D02015500000000, audioTrackUID)
U(0D02015600000000, audioMXFLookup)
U(0D02015700000000, audioBlockMatrix)
U(0D02015800000000, time)
U(0D02015900000000, metadataFormat)
U(0D02015A00000000, timecodeFormat)
U(0D02015B00000000, videoNoiseFilter)
U(0D02015C00000000, EBUCoreObject)
U(0D02015D00000000, audience)
U(0D02015E00000000, filter)
U(0D02015F00000000, filterSetting)
U(0D02016000000000, referenceScreen)
U(0D02016100000000, referenceScreenCentrePosition)
U(0D02016200000000, referenceScreenWidth)
U(0D02016300000000, audioContentDialogue)
U(0D02016400000000, audioObjectInteraction)
U(0D02016500000000, gainInteractionRange)
U(0D02016600000000, positionInteractionRange)
U(0D02016700000000, audioBlockPositionGroup)
U(0D02016800000000, audioBlockDivergence)
U(0D02016900000000, audioBlockZoneExclusion)
U(0D02016A00000000, audioBlockZone)
U(0D02016B00000000, audioBlockJumpPositionGroup)
U(0D02016C00000000, event)
U(0D02016D00000000, award)
U(0D02016E00000000, affiliation)
//        03 - Pro-MPEG Forum
//        04 - BBC
//          01 - Archive Preservation Project
//            01 - Archive Preservation Project Version 1
//              01 - APP Descriptive Frameworks
U(0D04010101010000, APP_InfaxFramework)
U(0D04010101020000, APP_PSEAnalysisFramework)
U(0D04010101030000, APP_VTRReplayErrorFramework)
U(0D04010101040000, APP_DigiBetaDropoutFramework)
U(0D04010101050000, APP_TimecodeBreakFramework)
//        05 - IRT
//        06 - ARIB
//        07 - AMIA
//        08 - PBS
//        09 - ASC
//        0A - AES
//        0B - Dutch Guild
//        0C - DPP
//          01 - DPP Schemes
//            01 - AS-11 UKDPP
//              01 - DPP Groups
U(0D0C010101010000, DM_AS_11_UKDPP_Framework)
//        0D - Ad-ID
U(0D0D010000000000, DMS_AS_12_AdID_Slate)
//        0E - LOC_Groups
//          01 - LOC_ApplicationSpecifications_Groups
//            01 - LOC_ApplicationSpecifications_Groups_V1
//              07 - AS_07_Groups
//                01 - AS_07_DMS_Groups
U(0D0E010107010100, AS_07_Core_DMS_Framework)
U(0D0E010107010200, AS_07_DMS_Device)
U(0D0E010107010300, AS_07_DMS_Identifier)
U(0D0E010107010400, AS_07_GSP_DMS_Object)
//                02 - AS_07_GSP_Groups
U(0D0E010107020100, AS_07_GSP_DMS_Framework)
U(0D0E010107020200, AS_07_GSP_BD_DMS_Framework)
U(0D0E010107020300, AS_07_GSP_TD_DMS_Framework)
//                03 - AS_07_Segmentation_Groups
U(0D0E010107030100, AS_07_Segmentation_DMS_Framework)
//                04 - AS_07_Timecode_Groups
U(0D0E010107040100, AS_07_TimecodeLabelSubdescriptor)
//        0F - Inter-Society Digital Cinema Forum
//      0E - Organizationally Registered as Private
//        01 - MISB Systems
//        02 - ASPA
//        03 - MISB Classified
//        04 - Avid Technology, Inc.
//        05 - CNN
//        06 - Sony Corporation
//        07 - IdeasUnlimited.TV
//        08 - IPV Ltd
//        09 - Dolby Laboratories Inc.
//          05 - Dolby Laboratories Inc. 05
U(0E09050200000000, ISXDDataEssenceDescriptor)
U(0E09060300000000, IADataEssenceDescriptor)
U(0E09060600000000, IADataEssenceSubDescriptor)
//            07
//              01
//                01
//                  01
U(0E09060701010103, PHDRMetadataTrackSubDescriptor)
//        0A - Snell & Wilcox
//        0B - Omneon Video Networks
//          01 - Omneon Video Networks 01
//            02 - Omneon Video Networks 0102
//              01 - Omneon Video Networks 0102.01
//                01 - Omneon Video Networks 0102.0101
U(0E0B010201010100, OmneonVideoNetworksDescriptiveMetadataLinks)
//                02 - Omneon Video Networks 0102.0101
U(0E0B010201020100, OmneonVideoNetworksDescriptiveMetadataData)
//        0C - Ascent Media Group, Inc.
//        0D - Quantel Ltd
//        0E - Panasonic
//        0F - Grass Valley, Inc.
//        10 - Doremi Labs, Inc.
//        11 - EVS Broadcast Equipment
//        12 - Turner Broadcasting System, Inc.
//        13 - NL Technology, LLC
//        14 - Harris Corporation
//        15 - Canon, Inc.
//        16 - D-BOX Technologies
//        17 - ARRI
//        18 - JVC
//        19 - 3ality Technica
//        1A - NHK
//        1B - HBO
//        1D - DTS, Inc.
//        1E - FLIR Systems, Inc.
//        1F - Barco
//        20 - Apple Inc.
//        21 - Fraunhofer
//        22 - RED
//        23 - CRIFST
//          01 - CRIFST 06
//            02 - CRIFST 0607
//              01 - CRIFST 0607.01
//                01 - CRIFST 0607.0101
U(0E23060701010103, HdrVividMetadataTrackSubDescriptor)
//      0F - Experimental
}
namespace Labels
{
U(0401020000000000, PictureCodingCharacteristics)
U(0401020100000000, UncompressedPictureCoding)
U(0401020200000000, CompressedPictureCoding)
U(0401020201000000, MPEGCompression)
U(0401020201010000, MPEG2MPML)
U(0401020201020000, MPEG2422PML)
U(0401020201030000, MPEG2MPHL)
U(0401020201040000, MPEG2422PHL)
U(0401020201050000, MPEG2MPH14)
U(0401020201060000, MPEG2HPML)
U(0401020201070000, MPEG2HPHL)
U(0401020201080000, MPEG2HPH14)
U(0401020201090000, MPEG2Other)
U(0401020201100000, MPEG1Video)
U(0401020201200000, MPEG4Part2Video)
U(0401020201300000, H264MPEG4AVCVideo)
U(0401020201310000, H264MPEG4AVCPredictiveProfiles)
U(0401020201320000, H264MPEG4AVCIntraProfiles)
U(0401020201400000, H265HEVCVideo)
U(0401020201410000, H265HEVCMainProfiles)
U(0401020201420000, H265HEVCMain422Profiles)
U(0401020201430000, H265HEVCMain444Profiles)
U(0401020201440000, H265HEVCMainIntraProfiles)
U(0401020201450000, H265HEVCMain422IntraProfiles)
U(0401020201460000, H265HEVCMain444IntraProfiles)
U(0401020202000000, DVVideoCompression)
U(0401020203000000, IndividualPictureCodingSchemes)
U(0401020203010000, JPEG2000PictureCodingScheme)
U(0401020203020000, TIFFEPPictureCodingScheme)
U(0401020203030000, VC2PictureCodingScheme)
U(0401020203040000, ACESPictureCodingSchemes)
U(0401020203050000, VC5PictureCodingScheme)
U(0401020203060000, ProResPictureCodingScheme)
U(0401020203070000, DNxUncompressedPictureCoding)
U(0401020203080000, JPEGXSPictureCodingSchemes)
U(0401020203090000, FFV1PictureCoding)
U(0401020270000000, SpecialisedCompressionSchemes)
U(0401020270010000, SMPTED11Compression)
U(0401020271000000, SMPTEVC3Compression)
U(0401020272000000, SMPTEVC1Compression)
U(0402020000000000, SoundCodingCharacteristics)
U(0402020100000000, UncompressedSoundCoding)
U(0402020101000000, SMPTE382MDefaultUncompressedSoundCoding)
U(0402020102000000, MGAAudioEssenceSoundCodingSchemes)
U(0402020102010000, MGAAudioEssenceUncompressedSoundCoding)
U(040202017E000000, AIFFUncompressedCoding)
U(040202017F000000, UndefinedSoundCoding)
U(0402020200000000, CompressedSoundCoding)
U(0402020203000000, CompressedAudioCoding)
U(0402020203010000, CompandedAudioCoding)
U(0402020203010100, ALawCodedAudioDefault)
U(0402020203011000, DVCompressedAudio)
U(0402020203020000, SMPTE338MAudioCoding)
U(0402020203020100, ATSCA52CompressedAudio)
U(0402020203020400, MPEG1Layer1CompressedAudio)
U(0402020203020500, MPEG1Layer1Or2CompressedAudio)
U(0402020203020600, MPEG2Layer1CompressedAudio)
U(0402020203021C00, DolbyECompressedAudio)
U(0402020203030000, NonSMPTE338MMPEG2Coding)
U(0402020203030100, MPEG2AACCompressedAudio)
U(0402020204000000, MPEG_Compressed_Audio_Coding)
U(0402020204010000, MPEG_1_Audio_Coding)
U(0402020204020000, MPEG_2_Audio_Coding)
U(0402020204030000, MPEG_2_Advanced_Audio_Coding)
U(0402020204040000, MPEG_4_Advanced_Audio_Coding)
U(0D01030102000000, MXFGenericContainer)
U(0D01030102010000, MXFGCSMPTED10Mappings)
U(0D01030102020000, MXFGCDVDIFMappings)
U(0D01030102030000, MXFGCSMPTED11Mappings)
U(0D01030102040000, MXFGCMPEGES)
U(0D01030102050000, MXFGCUncompressedPictures)
U(0D01030102060000, MXFGCAESBWFAudio)
U(0D01030102070000, MXFGCMPEGPES)
U(0D01030102080000, MXFGCMPEGPS)
U(0D01030102090000, MXFGCMPEGTS)
U(0D010301020A0000, MXFGCALawAudioMappings)
U(0D010301020B0000, MXFGCEncryptedDataMappings)
U(0D010301020C0000, MXFGCJPEG2000PictureMappings)
U(0D010301020D0000, MXFGCGenericVBIDataMappingUndefinedPayload)
U(0D010301020E0000, MXFGCGenericANCDataMappingUndefinedPayload)
U(0D010301020F0000, MXFGCAVCNALUnitStream)
U(0D01030102100000, MXFGCAVCByteStream)
U(0D01030102110000, MXFGCVC3Pictures)
U(0D01030102120000, MXFGCVC1Pictures)
U(0D01030102130000, MXFGCGenericData)
U(0D01030102140000, MXFGCTIFFEP)
U(0D01030102150000, MXFGCVC2Pictures)
U(0D01030102160000, MXF_GC_AAC_ADIF)
U(0D01030102170000, MXF_GC_AAC_ADTS)
U(0D01030102180000, MXF_GC_AAC_LATM_LOAS)
U(0D01030102190000, MXFGCACESPictures)
U(0D010301021A0000, MXFGCDMCVTData)
U(0D010301021B0000, MXFGCVC5EssenceContainerLabel)
U(0D010301021C0000, MXFGCEssenceContainerProResPicture)
U(0D010301021D0000, MXFGCImmersiveAudio)
U(0D010301021E0000, MXFGCEssenceContainerDNxPacked)
U(0D010301021F0000, MXFGCHEVCNALUnitStream)
U(0D01030102200000, MXFGCHEVCByteStream)
U(0D01030102210000, MXFGCJPEGXSPictures)
U(0D01030102230000, MXFGCFFV1Pictures)
U(0D01030102250000, MXFGCMGAAudioMappings)
U(0D010301027F0000, MXFGCGenericEssenceMappings)
U(0E04030102060000, AvidTechnologyIncVC3Pictures)
U(0E060D0302010000, SonyCorporationRAWSQ)
}

File_Mxf::type Mxf_Param_Type_Elements(int64u Value)
{
    switch (Value)
    {
T(0101100100000000, ISO7)
T(0101100101000000, UTF16)
T(0101100200000000, ISO7)
T(0101100201000000, UTF16)
T(0101100303000000, ISO7)
T(0101150200000000, UUID)
T(0101150300000000, AUID)
T(0101150400000000, ISO7)
T(0101151100000000, UUID)
T(0101151200000000, UUID)
T(0101151300000000, UUID)
T(0101154001010000, UUID)
T(0101154001020000, UUID)
T(0101200100000000, ISO7)
T(0101200300000000, ISO7)
T(0101200400000000, ISO7)
T(0101200700000000, ISO7)
T(0101200800000000, ISO7)
T(0101200801000000, UTF16)
T(0101200802000000, ISO7)
T(0101200C00000000, ISO7)
T(0101210100000000, ISO7)
T(0101210101000000, UTF16)
T(0101210200000000, ISO7)
T(0101210300000000, ISO7)
T(0102010100000000, ISO7)
T(0102010101000000, UTF16)
T(0102010200000000, ISO7)
T(0102010300000000, ISO7)
T(0102010400000000, ISO7)
T(0102010401000000, UTF16)
T(0102010500000000, ISO7)
T(0102010501000000, UTF16)
T(0102010600000000, ISO7)
T(0102020100000000, AUID)
T(0102020200000000, AUID)
T(0102020300000000, AUID)
T(0103010100000000, ISO7)
T(0103010200000000, ISO7)
T(0103010300000000, ISO7)
T(0103010400000000, ISO7)
T(0103010500000000, ISO7)
T(0103010600000000, ISO7)
T(0103010700000000, ISO7)
T(0103010701000000, UTF16)
T(0103010800000000, ISO7)
T(0103010801000000, UTF16)
T(0103010900000000, ISO7)
T(0103010901000000, UTF16)
T(0103020101000000, ISO7)
T(0103020201000000, ISO7)
T(0103020301010000, ISO7)
T(0103020302010000, ISO7)
T(0103030200000000, ISO7)
T(0103030201000000, UTF16)
T(0103040300000000, UI16)
T(0103040600000000, UI16)
T(0103040700000000, UI16)
T(0103040B00000000, UUID)
T(0103050100000000, ISO7)
T(0103050101000000, UTF16)
T(0103060100000000, AUID)
T(0103060300000000, AUID)
T(0103060400000000, ISO7)
T(0103060401000000, UTF16)
T(0103060500000000, ISO7)
T(0103060501000000, UTF16)
T(0103060600000000, ISO7)
T(0103070101000000, AUID)
T(0103070102000000, UTF16)
T(0103070103000000, UTF16)
T(0103070105000000, UUID)
T(0103070106000000, UUID)
T(0103070301000000, AUID)
T(0103070302000000, AUID)
T(0104010100000000, ISO7)
T(0104010101000000, UTF16)
T(0104010200000000, ISO7)
T(0104010201000000, UTF16)
T(0104010500000000, UTF16)
T(0104010600000000, UTF16)
T(0104070100000000, ISO7)
T(0104070200000000, ISO7)
T(0104070400000000, ISO7)
T(0104100100000000, ISO7)
T(0104100200000000, ISO7)
T(0104100300000000, ISO7)
T(0104100400000000, ISO7)
T(0105010000000000, ISO7)
T(0105010100000000, UTF16)
T(0105020000000000, ISO7)
T(0105020100000000, UTF16)
T(0105030000000000, ISO7)
T(0105030100000000, UTF16)
T(0105040000000000, ISO7)
T(0105040100000000, UTF16)
T(0105050000000000, ISO7)
T(0105050100000000, UTF16)
T(0105060000000000, ISO7)
T(0105060100000000, UTF16)
T(0105070000000000, UI16)
T(0105080000000000, ISO7)
T(0105080100000000, UTF16)
T(0105090000000000, ISO7)
T(0105090100000000, UTF16)
T(01050A0000000000, ISO7)
T(01050A0100000000, UTF16)
T(01050B0000000000, ISO7)
T(01050B0100000000, UTF16)
T(01050C0000000000, ISO7)
T(01050C0100000000, UTF16)
T(01050D0000000000, ISO7)
T(01050D0100000000, UTF16)
T(01050E0000000000, ISO7)
T(01050E0100000000, UTF16)
T(01050F0000000000, ISO7)
T(01050F0100000000, UTF16)
T(0105100000000000, UTF16)
T(0105110000000000, UTF16)
T(0105120000000000, UTF16)
T(0105130000000000, UTF16)
T(0107010200000000, ISO7)
T(0107010201000000, UTF16)
T(0107010203000000, ISO7)
T(0107010203010000, UTF16)
T(0107010400000000, ISO7)
T(0107010401000000, UTF16)
T(0108010000000000, ISO7)
T(010A010101000000, ISO7)
T(010A010101010000, UTF16)
T(010A010103000000, AUID)
T(010A010300000000, AUID)
T(010A020100000000, ISO7)
T(010A020101000000, UTF16)
T(0110030100000000, ISO7)
T(0110030101000000, UTF16)
T(0110030200000000, ISO7)
T(0110030201000000, UTF16)
T(0110030300000000, ISO7)
T(0110030400000000, ISO7)
T(0110030500000000, ISO7)
T(0110030600000000, ISO7)
T(0110030700000000, ISO7)
T(0201010000000000, ISO7)
T(0201010100000000, UTF16)
T(0201020000000000, ISO7)
T(0201030000000000, ISO7)
T(0201030100000000, UTF16)
T(0201040000000000, ISO7)
T(0201050000000000, ISO7)
T(0201060000000000, ISO7)
T(0201070000000000, ISO7)
T(0201080000000000, ISO7)
T(0201080100000000, UTF16)
T(0202010000000000, UI16)
T(0202020000000000, UI16)
T(0202030000000000, ISO7)
T(0202030100000000, UTF16)
T(0202040000000000, UI16)
T(0202050000000000, UI16)
T(0202060000000000, ISO7)
T(0202060100000000, UTF16)
T(0203010000000000, ISO7)
T(0203020000000000, ISO7)
T(0203040000000000, ISO7)
T(0203050000000000, ISO7)
T(0203060000000000, ISO7)
T(0203070000000000, ISO7)
T(0203080000000000, ISO7)
T(0203080100000000, UTF16)
T(0204010000000000, ISO7)
T(0204010200000000, UTF16)
T(0204020000000000, ISO7)
T(0204020100000000, UTF16)
T(0204030100000000, ISO7)
T(0204030200000000, UTF16)
T(0204040000000000, ISO7)
T(0204040100000000, UTF16)
T(0204060000000000, ISO7)
T(0204060100000000, UTF16)
T(0205010100000000, ISO7)
T(0205010101000000, UTF16)
T(0205010200000000, ISO7)
T(0205010201000000, UTF16)
T(0205020100000000, ISO7)
T(0205020101000000, UTF16)
T(0205020200000000, ISO7)
T(0205020201000000, UTF16)
T(0205030100000000, ISO7)
T(0205030101000000, UTF16)
T(0205030200000000, ISO7)
T(0205030201000000, UTF16)
T(0205030300000000, ISO7)
T(0205040100000000, UI16)
T(0205040200000000, ISO7)
T(0205040300000000, ISO7)
T(0205040301000000, UTF16)
T(0205040400000000, ISO7)
T(0205040401000000, UTF16)
T(0206010100000000, ISO7)
T(0206010101000000, ISO7)
T(0206010300000000, UI16)
T(0206020100000000, ISO7)
T(0206020200000000, ISO7)
T(0206020300000000, ISO7)
T(0206020400000000, ISO7)
T(0206020500000000, ISO7)
T(0206030100000000, ISO7)
T(0206030200000000, ISO7)
T(0206030300000000, ISO7)
T(0206030400000000, ISO7)
T(0206030500000000, ISO7)
T(0207010000000000, ISO7)
T(0208010100000000, ISO7)
T(0208010101000000, UTF16)
T(0208010200000000, ISO7)
T(0208010201000000, UTF16)
T(0208020100000000, ISO7)
T(0208020101000000, UTF16)
T(0208020200000000, ISO7)
T(0208020201000000, UTF16)
T(0208020300000000, ISO7)
T(0208020400000000, ISO7)
T(0208020500000000, ISO7)
T(0208020600000000, ISO7)
T(0208020700000000, ISO7)
T(0208020701000000, UTF16)
T(0208020800000000, ISO7)
T(0209010101000000, ISO7)
T(0209030101000000, AUID)
T(0209030102000000, UUID)
T(0209030201000000, AUID)
T(020A010000000000, ISO7)
T(020A010100000000, UTF16)
T(0210010101000000, ISO7)
T(0210010101010000, UTF16)
T(0210010102000000, ISO7)
T(0210010102010000, UTF16)
T(0210010103000000, ISO7)
T(0210010104010000, UTF16)
T(0210010105000000, ISO7)
T(0210020101000000, ISO7)
T(0210020101010000, UTF16)
T(0210020102000000, ISO7)
T(0210020102010000, UTF16)
T(0210020103000000, ISO7)
T(0210020103010000, UTF16)
T(0210020104000000, ISO7)
T(0210020104010000, UTF16)
T(0210020201000000, ISO7)
T(0210020202000000, ISO7)
T(0210020203000000, ISO7)
T(0210020204000000, ISO7)
T(0210020301000000, ISO7)
T(0210020302000000, ISO7)
T(0210020303000000, ISO7)
T(0210020304000000, ISO7)
T(0210020305000000, ISO7)
T(0210020306000000, ISO7)
T(0210020307000000, ISO7)
T(0210020308000000, ISO7)
T(0210020309000000, ISO7)
T(021002030A000000, ISO7)
T(0210020401000000, ISO7)
T(0210020402000000, ISO7)
T(0210020403000000, ISO7)
T(0210020404000000, ISO7)
T(0210020405000000, ISO7)
T(0210020406000000, ISO7)
T(0210020407000000, ISO7)
T(0210020408000000, ISO7)
T(0220010100000000, Bool)
T(0220020100000000, UI16)
T(0220020200000000, UI16)
T(0230010100000000, ISO7)
T(0230010101000000, UTF16)
T(0230010201000000, ISO7)
T(0230010201010000, UTF16)
T(0230010301000000, ISO7)
T(0230010301010000, UTF16)
T(0230020100000000, ISO7)
T(0230020101000000, UTF16)
T(0230020201000000, ISO7)
T(0230020201010000, UTF16)
T(0230020301000000, ISO7)
T(0230020301010000, UTF16)
T(0230050100000000, ISO7)
T(0230050101000000, UTF16)
T(0230050200000000, ISO7)
T(0230050201000000, UTF16)
T(0230050300000000, ISO7)
T(0230050301000000, UTF16)
T(0230060100000000, ISO7)
T(0230060101000000, UTF16)
T(0230060200000000, ISO7)
T(0230060201000000, UTF16)
T(0230060301010000, ISO7)
T(0230060301010100, UTF16)
T(0230060301020000, ISO7)
T(0230060301020100, UTF16)
T(0230060301030000, ISO7)
T(0230060301030100, UTF16)
T(0230060301040000, ISO7)
T(0230060301040100, UTF16)
T(0230060301050000, ISO7)
T(0230060301050100, UTF16)
T(0230060301060000, ISO7)
T(0230060301060100, UTF16)
T(0230060301070000, ISO7)
T(0230060301070100, UTF16)
T(0230060301080000, ISO7)
T(0230060301080100, UTF16)
T(0230060301090000, ISO7)
T(0230060301090100, UTF16)
T(02300603010A0000, ISO7)
T(02300603010A0100, UTF16)
T(02300603010B0000, ISO7)
T(02300603010B0100, UTF16)
T(02300603010C0000, ISO7)
T(02300603010C0100, UTF16)
T(02300603010D0000, ISO7)
T(02300603010D0100, UTF16)
T(02300603010E0000, ISO7)
T(02300603010E0100, UTF16)
T(0230060302010000, ISO7)
T(0230060302010100, UTF16)
T(0230060302020000, ISO7)
T(0230060302020100, UTF16)
T(0230060303010000, ISO7)
T(0230060303010100, UTF16)
T(0230060303020000, ISO7)
T(0230060303020100, UTF16)
T(0240010500000000, AUID)
T(0301010110010000, ISO7)
T(0301010110010100, UTF16)
T(0301010110020000, ISO7)
T(0301010110020100, UTF16)
T(0301010201010000, UTF16)
T(0301010202140000, UTF16)
T(0301010202150000, UTF16)
T(0301010202160000, UTF16)
T(0301010203150000, ISO7)
T(0301010210010000, ISO7)
T(0301010210010100, UTF16)
T(0301020103000000, Bool)
T(0301020106000000, UI16)
T(0301020107000000, UI16)
T(030102010A000000, Bool)
T(0301020201000000, Bool)
T(0301020202000000, Bool)
T(0301020203010000, Bool)
T(0301020302000000, Bool)
T(0301020A01000000, ISO7)
T(0301020A01010000, UTF16)
T(0301020A02000000, ISO7)
T(0301020A02010000, UTF16)
T(0301022001020000, UTF16)
T(0301022003020000, UTF16)
T(0301030101000000, ISO7)
T(0301030102000000, ISO7)
T(0301030201000000, ISO7)
T(0301030301000000, ISO7)
T(0301030302000000, ISO7)
T(0301030304000000, ISO7)
T(0302010101000000, ISO7)
T(0302010102000000, ISO7)
T(0302010103000000, ISO7)
T(0302010103010000, UTF16)
T(0302010104000000, ISO7)
T(0302010104010000, UTF16)
T(0302010110000000, ISO7)
T(0302010201000000, ISO7)
T(0302010202000000, ISO7)
T(0302010202010000, UTF16)
T(0302010203000000, ISO7)
T(0302010203010000, UTF16)
T(0302010204000000, ISO7)
T(0302010204010000, ISO7)
T(0302010204020000, UTF16)
T(0302010205000000, ISO7)
T(0302010205010000, UTF16)
T(0302010206000000, ISO7)
T(0302010207000000, ISO7)
T(0302010208000000, ISO7)
T(0302010209000000, ISO7)
T(0302010209010000, UTF16)
T(030201020A000000, ISO7)
T(030201020B000000, ISO7)
T(030201020D000000, ISO7)
T(030201020D010000, UTF16)
T(030201020E000000, ISO7)
T(030201020E010000, UTF16)
T(0302010210000000, ISO7)
T(0302010210010000, UTF16)
T(0302010211000000, ISO7)
T(0302010211010000, UTF16)
T(0302010215000000, ISO7)
T(0302010215010000, UTF16)
T(0302010220000000, UTF16)
T(0302010221000000, UTF16)
T(0302010222000000, UTF16)
T(0302010223000000, UTF16)
T(0302010224000000, UTF16)
T(0302010225000000, UTF16)
T(0302010226000000, ISO7)
T(0302010227000000, ISO7)
T(0302010228000000, ISO7)
T(0302010601000000, ISO7)
T(0302010601010000, UTF16)
T(0302010602000000, ISO7)
T(0302010602010000, UTF16)
T(0302010603000000, ISO7)
T(0302010603010000, UTF16)
T(0302010603020000, UTF16)
T(0302010604000000, ISO7)
T(0302010604010000, UTF16)
T(0302010605000000, ISO7)
T(0302010605010000, UTF16)
T(0302010606000000, ISO7)
T(0302010606010000, UTF16)
T(0302010607000000, ISO7)
T(0302010607010000, UTF16)
T(0302010608000000, ISO7)
T(0302010608010000, UTF16)
T(0302010609000000, ISO7)
T(0302010609010000, UTF16)
T(030201060A000000, ISO7)
T(030201060A010000, UTF16)
T(030201060B000000, ISO7)
T(030201060B010000, UTF16)
T(030201060C000000, ISO7)
T(030201060C010000, UTF16)
T(030201060D000000, ISO7)
T(030201060D010000, UTF16)
T(030201060E000000, ISO7)
T(030201060E010000, UTF16)
T(030201060F000000, ISO7)
T(030201060F010000, UTF16)
T(0302010610000000, ISO7)
T(0302010610010000, UTF16)
T(0302010611000000, ISO7)
T(0302010611010000, UTF16)
T(0302010701000000, ISO7)
T(0302010801000000, AUID)
T(0302020101000000, ISO7)
T(0302020102000000, ISO7)
T(0302020103000000, ISO7)
T(0302020103010000, UTF16)
T(0302020104000000, ISO7)
T(0302020104010000, UTF16)
T(0302020105000000, ISO7)
T(0302020105010000, UTF16)
T(0302020106000000, ISO7)
T(0302020106010000, UTF16)
T(0302020201000000, ISO7)
T(0302020202000000, ISO7)
T(0302020203000000, ISO7)
T(0302020204000000, ISO7)
T(0302020205000000, ISO7)
T(0302020206000000, ISO7)
T(0302020207000000, ISO7)
T(0302030101000000, ISO7)
T(0302030101010000, UTF16)
T(0302030102000000, ISO7)
T(0302030102010000, UTF16)
T(0302030201000000, ISO7)
T(0302030201010000, UTF16)
T(0302030202000000, ISO7)
T(0302030202010000, UTF16)
T(0302040101010000, ISO7)
T(0302040102000000, ISO7)
T(0302040102010000, UTF16)
T(0302050100000000, ISO7)
T(0302050101000000, UTF16)
T(0302050200000000, ISO7)
T(0302050201000000, UTF16)
T(0302050300000000, UTF16)
T(0302050400000000, UTF16)
T(0302060100000000, ISO7)
T(0303010201000000, ISO7)
T(0303010202000000, ISO7)
T(0303010206000000, ISO7)
T(0303010206010000, UTF16)
T(0303010207000000, ISO7)
T(0303010208000000, ISO7)
T(0303010209000000, ISO7)
T(0303010701000000, ISO7)
T(0303030101000000, ISO7)
T(0303030101010000, UTF16)
T(0303030102000000, ISO7)
T(0303030102010000, UTF16)
T(0303031001000000, ISO7)
T(0303031001010000, UTF16)
T(0401010102000000, ISO7)
T(0401010108000000, ISO7)
T(0401010108010000, ISO7)
T(0401010109000000, ISO7)
T(040101010A000000, ISO7)
T(0401020101010000, ISO7)
T(0401020101020000, ISO7)
T(0401020101030000, ISO7)
T(0401020101040000, ISO7)
T(0401020101050000, ISO7)
T(0401020101060000, ISO7)
T(0401020201000000, ISO7)
T(0401030102000000, UI16)
T(0401030103000000, UI16)
T(0401030107000000, UI16)
T(0401030201000000, UI16)
T(0401030202000000, UI16)
T(0401040100000000, ISO7)
T(0401050102000000, UI16)
T(0401050103000000, UI16)
T(0401050104000000, ISO7)
T(040105010F000000, ISO7)
T(0401050112000000, Bool)
T(0401050203000000, UI16)
T(0401050204000000, UI16)
T(0401050206000000, UI16)
T(0401050208000000, UI16)
T(0401050209000000, UI16)
T(040105020B000000, UI16)
T(0401050302000000, ISO7)
T(0401060100000000, AUID)
T(0401060201010000, ISO7)
T(0401060201020000, Bool)
T(0401060201030000, Bool)
T(0401060201050000, Bool)
T(0401060201060000, Bool)
T(0401060201070000, Bool)
T(0401060201080000, UI16)
T(0401060201090000, UI16)
T(0401060202020000, Bool)
T(0401060202030000, Bool)
T(0401060202050000, Bool)
T(0401060202060000, Bool)
T(0401060202070000, Bool)
T(0401060202080000, UI16)
T(0401060202090000, UI16)
T(0401060301000000, UI16)
T(040106030A000000, UI16)
T(0401060402000000, Bool)
T(0401060404000000, Bool)
T(0401060405000000, UI16)
T(0401060406000000, UI16)
T(0401060505000000, UI16)
T(0401060506000000, UI16)
T(0401060507000000, UI16)
T(0401060601030000, Bool)
T(0401060601060000, Bool)
T(0401060601070000, Bool)
T(0401060601080000, UI16)
T(0401060601090000, UI16)
T(0401060602030000, Bool)
T(0401060602060000, Bool)
T(0401060602070000, Bool)
T(0401060602080000, UI16)
T(0401060602090000, UI16)
T(04010606020C0000, UI16)
T(0401060602160000, Bool)
T(0401060706000000, Bool)
T(0401060707000000, Bool)
T(0401060801000000, UI16)
T(0401060901000000, UUID)
T(0401060902000000, UTF16)
T(0401060909000000, UUID)
T(0401060A01000000, UTF16)
T(0401060B01000000, UI16)
T(0401060B02000000, UI16)
T(0401060B03000000, UI16)
T(0401060B04000000, UI16)
T(0401060B07000000, UI16)
T(0401060B08000000, UI16)
T(0401060C02000000, Bool)
T(0401060C03000000, UI16)
T(0401060C05000000, UI16)
T(0401060C06000000, UI16)
T(0401080102000000, Bool)
T(0401080201000000, ISO7)
T(0401080202000000, ISO7)
T(04010B0100000000, ISO7)
T(0401100101000000, ISO7)
T(0401100201000000, ISO7)
T(0402010102000000, ISO7)
T(0402010105000000, AUID)
T(0402020100000000, ISO7)
T(0402030103000000, Bool)
T(0402030104000000, Bool)
T(0402030201000000, UI16)
T(0402030203000000, UI16)
T(0402030302000000, ISO7)
T(0402030303000000, ISO7)
T(0402030401000000, UI16)
T(0402030501000000, UUID)
T(0402030601000000, UUID)
T(0402030602000000, UTF16)
T(0402030603000000, UTF16)
T(0402030604000000, UTF16)
T(0402030701000000, UUID)
T(0402040100000000, ISO7)
T(0402040101000000, ISO7)
T(0402040200000000, AUID)
T(0402040201000000, ISO7)
T(0402040202000000, ISO7)
T(0402040301050000, AUID)
T(0402050201000000, ISO7)
T(0402050201010000, UTF16)
T(0402050202000000, ISO7)
T(0402050202010000, UTF16)
T(0402050203000000, ISO7)
T(0402050203010000, UTF16)
T(0402050204000000, ISO7)
T(0402050204010000, UTF16)
T(0402050205000000, ISO7)
T(0402050205010000, UTF16)
T(0402050206000000, ISO7)
T(0402050206010000, UTF16)
T(0402050207000000, ISO7)
T(0402050207010000, UTF16)
T(0402050208000000, ISO7)
T(0402050208010000, UTF16)
T(0402080100000000, ISO7)
T(0402080200000000, ISO7)
T(0402100200000000, ISO7)
T(0403010100000000, ISO7)
T(0403010101000000, UTF16)
T(0403020100000000, ISO7)
T(0403030200000000, AUID)
T(0404010101000000, ISO7)
T(0404010102060000, UI16)
T(0404010103000000, Bool)
T(0404010104000000, Bool)
T(0404010105000000, Bool)
T(0404010202000000, Bool)
T(0404010203000000, Bool)
T(0404010204000000, AUID)
T(0404020200000000, ISO7)
T(0404030100000000, ISO7)
T(0404050100000000, Bool)
T(0404050200000000, Bool)
T(0404050300000000, Bool)
T(0404050400000000, Bool)
T(0404050500000000, Bool)
T(0404050600000000, Bool)
T(0405020100000000, ISO7)
T(0406020300000000, ISO7)
T(0406020301000000, UTF16)
T(0406020600000000, Bool)
T(0406020700000000, Bool)
T(0406080100000000, ISO7)
T(0406080300000000, AUID)
T(0406080400000000, AUID)
T(0406080500000000, AUID)
T(0406080600000000, AUID)
T(0406100300000000, UTF16)
T(0407010000000000, Ref)
T(0407010100000000, AUID)
T(0409010000000000, ISO7)
T(0409010100000000, UTF16)
T(0409020000000000, ISO7)
T(0409020100000000, UTF16)
T(0409020200000000, UTF16)
T(0409030000000000, UTF16)
T(0409030100000000, ISO7)
T(0409040000000000, ISO7)
T(0409040100000000, UTF16)
T(0409050000000000, UTF16)
T(040F010000000000, ISO7)
T(040F010100000000, UTF16)
T(040F010200000000, ISO7)
T(0410010101000000, ISO7)
T(0410010102000000, ISO7)
T(0410010102010000, UTF16)
T(0410010104000000, ISO7)
T(0410010104010000, UTF16)
T(0410010105000000, ISO7)
T(0410010105010000, UTF16)
T(0410010106000000, ISO7)
T(0410010106010000, UTF16)
T(0410010301010000, ISO7)
T(0410010301040000, ISO7)
T(0410010301040100, UTF16)
T(0410010301050000, ISO7)
T(0410010301050100, UTF16)
T(0410010301060000, ISO7)
T(0410010301060100, UTF16)
T(0410010301070000, ISO7)
T(0410010301070100, UTF16)
T(0410010302010000, UI16)
T(0410010302020000, ISO7)
T(0420010101000000, ISO7)
T(0420010201010000, ISO7)
T(0420010201010100, UTF16)
T(0420010301040000, UI16)
T(0420010301050000, UI16)
T(0420010301060000, UI16)
T(04200103010A0000, UI16)
T(04200103010B0000, UI16)
T(04200103010C0000, UI16)
T(04200103010E0000, Bool)
T(0420010302020000, UI16)
T(0420010302040000, UI16)
T(0420010302060000, UI16)
T(0420020101010000, ISO7)
T(0420020101050000, ISO7)
T(0420020101070000, ISO7)
T(0420020101080100, UI16)
T(0420020101090000, ISO7)
T(04200201010A0000, UI16)
T(0420020201000000, UI16)
T(0420020204000000, Bool)
T(0420020207000000, UI16)
T(0420020208000000, UI16)
T(0420020209000000, UI16)
T(042002020A000000, UI16)
T(042002020B000000, UI16)
T(0420030100000000, ISO7)
T(0420030200000000, ISO7)
T(0430010000000000, ISO7)
T(0501010100000000, ISO7)
T(0501010101000000, UTF16)
T(0501010200000000, ISO7)
T(0501010201000000, UTF16)
T(0501010300000000, Bool)
T(0501010400000000, Bool)
T(0501010500000000, ISO7)
T(0501010600000000, ISO7)
T(0501010700000000, ISO7)
T(0501010701000000, UTF16)
T(0501020100000000, ISO7)
T(0501020401000000, ISO7)
T(0501020601000000, UTF16)
T(0501020602000000, UTF16)
T(0501020603000000, UTF16)
T(0501020604000000, UTF16)
T(0501030100000000, UI16)
T(0501030201000000, UI16)
T(0501030301000000, UI16)
T(0501030400000000, Bool)
T(0501040100000000, Bool)
T(0501040200000000, Bool)
T(0501040300000000, Bool)
T(0501040400000000, Bool)
T(0502010100000000, ISO7)
T(0502010301010000, Bool)
T(0502020100000000, ISO7)
T(0503010100000000, ISO7)
T(0503020100000000, ISO7)
T(0520010100000000, ISO7)
T(0520020100000000, ISO7)
T(0520020200000000, ISO7)
T(0520020300000000, ISO7)
T(0520030100000000, ISO7)
T(0520030200000000, ISO7)
T(0520040100000000, ISO7)
T(0520040200000000, ISO7)
T(0520040300000000, ISO7)
T(0520050100000000, ISO7)
T(0520060100000000, ISO7)
T(0520060200000000, ISO7)
T(0520060300000000, ISO7)
T(0520070101000000, AUID)
T(0520070102000000, ISO7)
T(0520070102010000, UTF16)
T(0520070103000000, ISO7)
T(0520070103010000, UTF16)
T(0520070105000000, ISO7)
T(0520070105010000, UTF16)
T(0520070106000000, ISO7)
T(0520070106010000, UTF16)
T(0520070107000000, AUID)
T(0520070108000000, AUID)
T(052007010D000000, UUID)
T(052007010E000000, UUID)
T(052007010F000000, UTF16)
T(0520070110000000, UTF16)
T(0520090200000000, AUID)
T(0520090500000000, AUID)
T(0520090800000000, AUID)
T(0520090B00000000, Bool)
T(0520090C00000000, Bool)
T(0520090E00000000, Bool)
T(0520090F00000000, AUID)
T(0530040100000000, Bool)
T(0530040400000000, ISO7)
T(0530040401000000, UTF16)
T(0530050300000000, Bool)
T(0530050900000000, Ref)
T(0530050B00000000, ISO7)
T(0530050B01000000, UTF16)
T(0530060100000000, ISO7)
T(0530060101000000, UTF16)
T(0530060200000000, ISO7)
T(0530060201000000, UTF16)
T(0531011900000000, UI16)
T(0531011A00000000, UI16)
T(0531011B00000000, Bool)
T(0531011E00000000, Bool)
T(0531013200000000, UI16)
T(0531013300000000, UI16)
T(0531013400000000, UI16)
T(0531014200000000, UI16)
T(0531014300000000, UI16)
T(0540010100000000, ISO7)
T(0540020100000000, ISO7)
T(0601010101000000, Bool)
T(0601010102000000, Bool)
T(0601010103000000, Bool)
T(0601010202000000, AUID)
T(0601010203000000, AUID)
T(0601010204000000, UTF16)
T(0601010205000000, UTF16)
T(0601010207000000, UUID)
T(0601010401010000, Ref)
T(0601010401020100, AUID)
T(0601010401030100, AUID)
T(0601010401040000, AUID)
T(0601010401070000, Ref)
T(06010104010B0000, AUID)
T(0601010602000000, UUID)
T(0601010603000000, UUID)
T(0601010701000000, Ref)
T(0601010702000000, Refs)
T(0601010703000000, Bool)
T(0601010704000000, AUID)
T(0601010705000000, UI16)
T(0601010706000000, Bool)
T(0601010709000000, Ref)
T(060101070A000000, Ref)
T(0601010713000000, AUID)
T(0601010714000000, ISO7)
T(0601010714010000, UTF16)
T(060101071B000000, AUID)
T(060101071C000000, UTF16)
T(060101071D000000, UTF16)
T(060101071E000000, UTF16)
T(0601010722000000, Ref)
T(0602010000000000, ISO7)
T(0602020000000000, ISO7)
T(0602030000000000, ISO7)
T(0603050100000000, ISO7)
T(0603050101000000, UTF16)
T(0603050200000000, ISO7)
T(0603050201000000, UTF16)
T(0608010101000000, UI16)
T(0608010201010000, UI16)
T(0608020100000000, Bool)
T(0610030000000000, ISO7)
T(0701010100000000, ISO7)
T(0701010200000000, ISO7)
T(0701010300000000, ISO7)
T(0701010400000000, ISO7)
T(0701020102300000, ISO7)
T(0701020103060000, ISO7)
T(0701020103070000, ISO7)
T(0701020103080000, ISO7)
T(0701020103090000, ISO7)
T(07010201030A0000, ISO7)
T(07010201030B0000, ISO7)
T(07010201030C0000, ISO7)
T(07010201030D0000, ISO7)
T(07010201030E0000, ISO7)
T(0701020103140000, ISO7)
T(0701020103150000, ISO7)
T(0701090401010100, UI16)
T(0701090401010200, UI16)
T(0701200101010000, ISO7)
T(0701200101010100, UTF16)
T(0701200102010000, ISO7)
T(0701200102010100, UTF16)
T(0701200102020000, ISO7)
T(0701200102030000, ISO7)
T(0701200102040000, ISO7)
T(0701200102050000, ISO7)
T(0701200102060000, ISO7)
T(0701200102070000, ISO7)
T(0701200102070100, UTF16)
T(0701200102080000, ISO7)
T(0701200102080100, UTF16)
T(0701200102090000, ISO7)
T(0701200102090100, UTF16)
T(0701200103010000, ISO7)
T(0701200103010100, UTF16)
T(0701200103020000, ISO7)
T(0701200103020100, UTF16)
T(0701200103030000, ISO7)
T(0701200103030100, UTF16)
T(0701200103040000, ISO7)
T(0701200103040100, UTF16)
T(0701200103050000, ISO7)
T(0701200103050100, UTF16)
T(0701200104010100, ISO7)
T(0701200104010101, UTF16)
T(0701200104010200, ISO7)
T(0701200104010201, UTF16)
T(0701200104010300, ISO7)
T(0701200104010301, UTF16)
T(0701200104010400, ISO7)
T(0701200104010401, UTF16)
T(0701200104010500, ISO7)
T(0701200104010501, UTF16)
T(0701200104010600, ISO7)
T(0701200104010601, UTF16)
T(0701200104010700, ISO7)
T(0701200104010701, UTF16)
T(0701200104010800, ISO7)
T(0701200104010801, UTF16)
T(0701200104011100, ISO7)
T(0701200104011101, UTF16)
T(0701200104011200, ISO7)
T(0701200104011201, UTF16)
T(0701200104011300, ISO7)
T(0701200104011301, UTF16)
T(0701200104011400, ISO7)
T(0701200104011401, UTF16)
T(0701200104011600, ISO7)
T(0701200104011601, UTF16)
T(0701200104020100, ISO7)
T(0701200104020101, UTF16)
T(0701200104020200, ISO7)
T(0701200104020201, UTF16)
T(0701200104020300, ISO7)
T(0701200104020301, UTF16)
T(0701200104020400, ISO7)
T(0701200104020401, UTF16)
T(0701200104020500, ISO7)
T(0701200104020501, UTF16)
T(0701200104020600, ISO7)
T(0701200104020601, UTF16)
T(0701200104020700, ISO7)
T(0701200104020701, UTF16)
T(0701200104020800, ISO7)
T(0701200104020801, UTF16)
T(0701200110030100, ISO7)
T(0701200110030101, UTF16)
T(0701200110030200, ISO7)
T(0701200110030201, UTF16)
T(0701200110030300, ISO7)
T(0701200110030301, UTF16)
T(0701200110030400, ISO7)
T(0701200110030500, ISO7)
T(0701200110030600, ISO7)
T(0701200110030601, UTF16)
T(0701200201000000, ISO7)
T(0701200201010000, UTF16)
T(0701200202000000, ISO7)
T(0701200202010000, UTF16)
T(0701200203000000, ISO7)
T(0701200203010000, UTF16)
T(0702010101010000, ISO7)
T(0702010101020000, ISO7)
T(0702010201010000, ISO7)
T(0702010201010100, UTF16)
T(0702010201020000, ISO7)
T(0702010201030100, UTF16)
T(0702010203010000, ISO7)
T(0702010203020000, ISO7)
T(0702010205010000, ISO7)
T(0702010205010100, UTF16)
T(0702010205020000, ISO7)
T(0702010207010000, ISO7)
T(0702010207020000, ISO7)
T(0702010207100100, ISO7)
T(0702010209010000, ISO7)
T(0702010209020000, ISO7)
T(0702010301010000, ISO7)
T(0702010302010000, ISO7)
T(0702010303010000, ISO7)
T(0702010304010000, ISO7)
T(0702010310030100, ISO7)
T(0702010310030200, ISO7)
T(0702010801000000, ISO7)
T(0702010801010000, UTF16)
T(0702010803000000, ISO7)
T(0702010803010000, UTF16)
T(0702011001010000, ISO7)
T(0702011002010000, ISO7)
T(0702020102010000, ISO7)
T(0702020103020000, ISO7)
T(0702030103010000, UI16)
T(0D01040103010100, UTF16)
T(0D01040103010200, UTF16)
T(0D01040103010300, UTF16)
T(0D01040103010400, UTF16)
T(0D01040103010500, UTF16)
T(0D01040103010600, UTF16)
T(0D01040103010700, UTF16)
T(0D01040103010800, UTF16)
T(0D01040103010900, UTF16)
T(0D0107010A010101, UTF16)
T(0D0107010A010102, UTF16)
T(0D0107010A010103, UTF16)
T(0D0107010A010104, UTF16)
T(0D0107010A010105, UTF16)
T(0D0107010A010106, UTF16)
T(0D0107010A010107, UTF16)
T(0D0107010A010108, UTF16)
T(0D0107010A01010A, UI16)
T(0D0107010B010101, UTF16)
T(0D0107010B010102, UTF16)
T(0D0107010B010103, UTF16)
T(0D0107010B010104, UTF16)
T(0D0107010B010107, Bool)
T(0D0107010B020101, UI16)
T(0D0107010B020102, UI16)
T(0D0107010C010101, UTF16)
T(0D02010101000000, UTF16)
T(0D02010102000000, UTF16)
T(0D02010301000000, UTF16)
T(0D02010302000000, UTF16)
T(0D02010303000000, UTF16)
T(0D02010304000000, UTF16)
T(0D02010305000000, UTF16)
T(0D02010401000000, UTF16)
T(0D02010402000000, UTF16)
T(0D02010501000000, UTF16)
T(0D02010502000000, UTF16)
T(0D02010504000000, UI16)
T(0D02010505000000, UTF16)
T(0D02010506000000, UTF16)
T(0D02010601000000, UTF16)
T(0D02010602000000, UTF16)
T(0D02010606000000, UI16)
T(0D02010607000000, UTF16)
T(0D02010608000000, UTF16)
T(0D02010801000000, UTF16)
T(0D02010802000000, UTF16)
T(0D02010901000000, UTF16)
T(0D02010905000000, UI16)
T(0D02010906000000, UTF16)
T(0D02010907000000, UTF16)
T(0D02010909000000, Bool)
T(0D02010C0D000000, UTF16)
T(0D02010C0F000000, UTF16)
T(0D02010E01000000, UTF16)
T(0D02011002000000, UTF16)
T(0D02011101000000, UTF16)
T(0D02011102000000, UTF16)
T(0D02011103000000, Bool)
T(0D02011104000000, Bool)
T(0D02011201000000, UTF16)
T(0D02011203000000, UTF16)
T(0D02011501000000, UTF16)
T(0D02011502000000, UTF16)
T(0D02011503000000, UTF16)
T(0D02011701000000, UTF16)
T(0D02011801000000, UTF16)
T(0D02011901000000, UTF16)
T(0D02011902000000, UTF16)
T(0D02011903000000, Bool)
T(0D02011904000000, UTF16)
T(0D0201190E000000, Bool)
T(0D02011B01000000, UTF16)
T(0D02011B02000000, UTF16)
T(0D02011B03000000, Bool)
T(0D02011B04000000, Bool)
T(0D02011B0C000000, UTF16)
T(0D02011B0D000000, UTF16)
T(0D02011B0E000000, UTF16)
T(0D02011C01000000, UTF16)
T(0D02011C02000000, UTF16)
T(0D02011C03000000, Bool)
T(0D02011C04000000, Bool)
T(0D02011C08000000, Bool)
T(0D02011C09000000, Bool)
T(0D02011C0A000000, UTF16)
T(0D02011C11000000, Bool)
T(0D02011D02000000, UTF16)
T(0D02011E01000000, UTF16)
T(0D02011E02000000, UTF16)
T(0D02011E03000000, UTF16)
T(0D02011F01000000, UTF16)
T(0D02011F02000000, UTF16)
T(0D02012001000000, UTF16)
T(0D02012002000000, UTF16)
T(0D02012004000000, UTF16)
T(0D02012101000000, UTF16)
T(0D02012201000000, UTF16)
T(0D02012202000000, UTF16)
T(0D02012203000000, UTF16)
T(0D02012204000000, UTF16)
T(0D02012205000000, UTF16)
T(0D02012206000000, UTF16)
T(0D02012207000000, UTF16)
T(0D02012208000000, Bool)
T(0D02012210000000, UTF16)
T(0D02012213000000, UTF16)
T(0D02012214000000, UTF16)
T(0D02012215000000, UTF16)
T(0D02012216000000, UTF16)
T(0D02012218000000, UTF16)
T(0D02012301000000, UTF16)
T(0D02012302000000, UTF16)
T(0D0201230A000000, UTF16)
T(0D0201230B000000, UTF16)
T(0D02012401000000, UTF16)
T(0D02012402000000, UTF16)
T(0D02012501000000, UTF16)
T(0D02012502000000, UTF16)
T(0D02012503000000, UTF16)
T(0D02012504000000, UTF16)
T(0D02012601000000, UTF16)
T(0D02012801000000, UTF16)
T(0D02012901000000, UTF16)
T(0D02012B01010000, UTF16)
T(0D02012B01020000, UTF16)
T(0D02012B01040000, Bool)
T(0D02012B01050000, UTF16)
T(0D02012B02010000, UTF16)
T(0D02012B02020000, UTF16)
T(0D02012B02030000, UTF16)
T(0D02012B02040000, UTF16)
T(0D02012B02050000, UTF16)
T(0D02012B02060000, UTF16)
T(0D02012B02070000, UTF16)
T(0D02012B02080000, UTF16)
T(0D02012B02090000, UTF16)
T(0D02012B020A0000, UTF16)
T(0D02012B020B0000, UTF16)
T(0D02012B020C0000, UTF16)
T(0D02012B020D0000, UTF16)
T(0D02012B020E0000, UTF16)
T(0D02012B020F0000, UTF16)
T(0D02012B02100000, UTF16)
T(0D02012B02110000, UTF16)
T(0D02012B02120000, UTF16)
T(0D02012B02130000, UTF16)
T(0D02012B02140000, UTF16)
T(0D02012B02150000, UTF16)
T(0D02012B02160000, UTF16)
T(0D02012B02170000, UTF16)
T(0D02012B02180000, UTF16)
T(0D02012C02000000, UTF16)
T(0D02012D01010000, UTF16)
T(0D02012D01020000, UTF16)
T(0D02012D01030000, UTF16)
T(0D02012D01040000, UTF16)
T(0D02012D01050000, UTF16)
T(0D02012D01060000, UTF16)
T(0D02012D01070000, UTF16)
T(0D02012D01080000, UTF16)
T(0D02012D02010000, UTF16)
T(0D02012D02020000, UTF16)
T(0D02012D02030000, UTF16)
T(0D02012D02040000, UTF16)
T(0D02012D02050000, UTF16)
T(0D02012D02060000, UTF16)
T(0D02012D02070000, UTF16)
T(0D02012D02080000, UTF16)
T(0D02012D03010000, UTF16)
T(0D02012D03020000, UTF16)
T(0D02012D03030000, UTF16)
T(0D02012D03040000, UTF16)
T(0D02012D03050000, UTF16)
T(0D02012D03060000, UTF16)
T(0D02012D03070000, UTF16)
T(0D02012D03080000, UTF16)
T(0D02012E01000000, UTF16)
T(0D02012E02000000, UTF16)
T(0D02012F01000000, UTF16)
T(0D02013001000000, UTF16)
T(0D02013002000000, UTF16)
T(0D02013003000000, UTF16)
T(0D02013004000000, UTF16)
T(0D02013101000000, UTF16)
T(0D02013102000000, UTF16)
T(0D02013103000000, UTF16)
T(0D02013104000000, UTF16)
T(0D02013107000000, UTF16)
T(0D02013108000000, UTF16)
T(0D02013109000000, UTF16)
T(0D0201310B000000, Bool)
T(0D0201310D000000, Bool)
T(0D02013115000000, Bool)
T(0D02013118000000, UTF16)
T(0D02013119000000, UTF16)
T(0D0201311A000000, UTF16)
T(0D02013201000000, UTF16)
T(0D02013202000000, UTF16)
T(0D02013203000000, UTF16)
T(0D02013204000000, UTF16)
T(0D02013205000000, UTF16)
T(0D0201320B000000, Bool)
T(0D0201320E000000, UTF16)
T(0D0201320F000000, UTF16)
T(0D02013210000000, UTF16)
T(0D02013301000000, UTF16)
T(0D02013302000000, UTF16)
T(0D02013303000000, UTF16)
T(0D02013304000000, UTF16)
T(0D02013305000000, UTF16)
T(0D02013306000000, UI16)
T(0D02013307000000, UTF16)
T(0D02013308000000, UI16)
T(0D0201330B000000, UTF16)
T(0D02013310000000, Bool)
T(0D02013311000000, UTF16)
T(0D02013312000000, UTF16)
T(0D02013313000000, UTF16)
T(0D02013321000000, Bool)
T(0D02013401000000, UTF16)
T(0D02013402000000, UTF16)
T(0D02013403000000, UTF16)
T(0D02013501000000, UTF16)
T(0D02013502000000, UTF16)
T(0D02013503000000, UTF16)
T(0D02013504000000, UTF16)
T(0D02013505000000, UTF16)
T(0D02013506000000, UTF16)
T(0D02013507000000, UTF16)
T(0D02013508000000, Bool)
T(0D0201350D000000, UTF16)
T(0D0201350E000000, UTF16)
T(0D0201350F000000, UTF16)
T(0D02013601000000, UTF16)
T(0D02013602000000, UTF16)
T(0D02013603000000, UTF16)
T(0D02013604000000, UTF16)
T(0D02013605000000, UTF16)
T(0D02013606000000, UTF16)
T(0D02013607000000, Bool)
T(0D0201360A000000, Bool)
T(0D0201360B000000, UTF16)
T(0D02013701000000, UTF16)
T(0D02013702000000, UTF16)
T(0D02013703000000, UTF16)
T(0D02013704000000, UTF16)
T(0D02013705000000, UTF16)
T(0D02013706000000, UTF16)
T(0D02013707000000, Bool)
T(0D0201370A000000, Bool)
T(0D0201370B000000, UTF16)
T(0D02013801000000, UTF16)
T(0D02013802000000, UTF16)
T(0D02013803000000, UTF16)
T(0D02013804000000, UTF16)
T(0D02013805000000, UI16)
T(0D02013807000000, UTF16)
T(0D02013901000000, UTF16)
T(0D02013902000000, UTF16)
T(0D02013903000000, UTF16)
T(0D02013904000000, UTF16)
T(0D02013905000000, UTF16)
T(0D02013906000000, UTF16)
T(0D02013907000000, UTF16)
T(0D0201390A000000, Bool)
T(0D02013A01010000, UTF16)
T(0D02013A02030000, UTF16)
T(0D02013A03030000, UTF16)
T(0D02013A04030000, UTF16)
T(0D02013A05030000, UTF16)
T(0D02013A06030000, UTF16)
T(0D02013A07010000, UI16)
T(0D02013A07030000, UTF16)
T(0D02013A08030000, UTF16)
T(0D02013A09030000, UTF16)
T(0D02013A0A030000, UTF16)
T(0D02013A0C010000, UTF16)
T(0D02013A0D010000, Bool)
T(0D02013B02000000, UTF16)
T(0D02013C02000000, UTF16)
T(0D02013D01000000, UTF16)
T(0D02013E01000000, UTF16)
T(0D02013E02000000, UTF16)
T(0D02013E03000000, UTF16)
T(0D02013E04000000, UTF16)
T(0D02013E05000000, UTF16)
T(0D02013E06000000, UTF16)
T(0D02014401000000, UTF16)
T(0D02014402000000, UTF16)
T(0D02014403000000, UTF16)
T(0D02014801000000, UTF16)
T(0D02014802000000, UTF16)
T(0D02014804000000, UTF16)
T(0D02014805000000, UTF16)
T(0D02014806000000, UTF16)
T(0D02014807000000, UTF16)
T(0D02014901000000, UTF16)
T(0D02014902000000, UTF16)
T(0D02014903000000, UTF16)
T(0D02014904000000, UTF16)
T(0D02014905000000, Bool)
T(0D02014A01000000, UTF16)
T(0D02014A02000000, UTF16)
T(0D02014A03000000, UTF16)
T(0D02014A04000000, UTF16)
T(0D02014A05000000, UTF16)
T(0D02014B01000000, UTF16)
T(0D02014C01000000, UTF16)
T(0D02014C07000000, UTF16)
T(0D02014C08000000, UTF16)
T(0D02014D01000000, UTF16)
T(0D02014D02000000, UTF16)
T(0D02014D03000000, UTF16)
T(0D02014D04000000, Bool)
T(0D02014E01000000, UTF16)
T(0D02014E02000000, UTF16)
T(0D02014E03000000, UTF16)
T(0D02014E04000000, UTF16)
T(0D02014E05000000, Bool)
T(0D02014E07000000, Bool)
T(0D02014E0D000000, Bool)
T(0D02014F01000000, UTF16)
T(0D02014F02000000, UTF16)
T(0D02014F05000000, UTF16)
T(0D02015001000000, UTF16)
T(0D02015002000000, UTF16)
T(0D02015101000000, UTF16)
T(0D02015102000000, UTF16)
T(0D02015103000000, UTF16)
T(0D02015104000000, UTF16)
T(0D02015108000000, Bool)
T(0D0201510C000000, Bool)
T(0D0201510D000000, Bool)
T(0D0201510E000000, UTF16)
T(0D0201510F000000, UTF16)
T(0D02015110000000, UTF16)
T(0D02015111000000, Bool)
T(0D02015114000000, Bool)
T(0D02015203000000, Bool)
T(0D02015205000000, Bool)
T(0D02015301000000, UTF16)
T(0D02015302000000, UTF16)
T(0D02015401000000, UTF16)
T(0D02015402000000, UTF16)
T(0D02015501000000, UTF16)
T(0D02015502000000, UI16)
T(0D02015801000000, UTF16)
T(0D02015802000000, UTF16)
T(0D02015803000000, UTF16)
T(0D02015804000000, UTF16)
T(0D02015901000000, UTF16)
T(0D02015902000000, UTF16)
T(0D02015903000000, UTF16)
T(0D02015904000000, UTF16)
T(0D02015A01000000, UTF16)
T(0D02015A02000000, UTF16)
T(0D02015A03000000, UTF16)
T(0D02015A04000000, UTF16)
T(0D02015B01000000, UTF16)
T(0D02015D01000000, UTF16)
T(0D02015D02000000, UTF16)
T(0D02015D03000000, Bool)
T(0D02015D04000000, Bool)
T(0D02016401000000, Bool)
T(0D02016402000000, Bool)
T(0D02016403000000, Bool)
T(0D02016502000000, Bool)
T(0D02016602000000, UTF16)
T(0D02016603000000, UTF16)
T(0D02016702000000, UTF16)
T(0D02016703000000, UTF16)
T(0D02016704000000, UTF16)
T(0D02016A01000000, UTF16)
T(0D02016B01000000, Bool)
T(0D02016C01000000, UTF16)
T(0D02016C03000000, UTF16)
T(0D02016D01000000, UTF16)
T(0D04010101010100, UTF16)
T(0D04010101010200, UTF16)
T(0D04010101010300, UTF16)
T(0D04010101010500, UTF16)
T(0D04010101010600, UTF16)
T(0D04010101010700, UTF16)
T(0D04010101010900, UTF16)
T(0D04010101010A00, UTF16)
T(0D04010101010C00, UTF16)
T(0D04010101010D00, UTF16)
T(0D04010101010E00, UTF16)
T(0D04010101010F00, UTF16)
T(0D04010101020400, Bool)
T(0D0B010100000000, UI16)
T(0D0B010200000000, UI16)
T(0D0B010300000000, UI16)
T(0D0B010400000000, UI16)
T(0D0B010500000000, UI16)
T(0D0B010600000000, UI16)
T(0D0B010700000000, UI16)
T(0D0B010800000000, UI16)
T(0D0B010900000000, UI16)
T(0D0B020100000000, UI16)
T(0D0B030100000000, UI16)
T(0D0B030200000000, UI16)
T(0D0B030300000000, UI16)
T(0D0B040100000000, UI16)
T(0D0B050100000000, UI16)
T(0D0B050200000000, UI16)
T(0D0B050300000000, UI16)
T(0D0B060100000000, UI16)
T(0D0B060200000000, UI16)
T(0D0B060300000000, UI16)
T(0D0B060400000000, UI16)
T(0D0B060500000000, UI16)
T(0D0B060600000000, UI16)
T(0D0B060700000000, UI16)
T(0D0B060800000000, UI16)
T(0D0B070100000000, UI16)
T(0D0B070200000000, UI16)
T(0D0B070300000000, UI16)
T(0D0B070400000000, UI16)
T(0D0B070500000000, UI16)
T(0D0B080100000000, UI16)
T(0D0B080200000000, UI16)
T(0D0B090100000000, UI16)
T(0D0B090200000000, UI16)
T(0D0B0A0100000000, UI16)
T(0D0B0A0200000000, UI16)
T(0D0B0A0300000000, UI16)
T(0D0B0A0400000000, UI16)
T(0D0B0A0500000000, UI16)
T(0D0B0A0600000000, UI16)
T(0D0B0A0700000000, UI16)
T(0D0B0B0100000000, UI16)
T(0D0B0B0200000000, UI16)
T(0D0C010101010100, UTF16)
T(0D0C010101010200, UTF16)
T(0D0C010101010300, UTF16)
T(0D0C010101010400, UI16)
T(0D0C010101010500, UTF16)
T(0D0C010101010600, UTF16)
T(0D0C010101010700, UTF16)
T(0D0C010101010800, UTF16)
T(0D0C010101010A00, Bool)
T(0D0C010101010C00, Bool)
T(0D0C010101010E00, UTF16)
T(0D0C010101010F00, UTF16)
T(0D0C010101011000, UTF16)
T(0D0C010101011400, UTF16)
T(0D0C010101011700, UI16)
T(0D0C010101011900, Bool)
T(0D0C010101011B00, Bool)
T(0D0C010101012100, Bool)
T(0D0C010101012200, Bool)
T(0D0C010101012400, UTF16)
T(0D0C010101012500, UTF16)
T(0D0D010100000000, UTF16)
T(0D0D010200000000, UTF16)
T(0D0D010300000000, UTF16)
T(0D0D010400000000, UTF16)
T(0D0D010500000000, UTF16)
T(0D0D010600000000, UTF16)
T(0D0D010700000000, UTF16)
T(0D0D010800000000, UTF16)
T(0D0D010900000000, UTF16)
T(0D0D010A00000000, UTF16)
T(0D0D010B00000000, UTF16)
T(0D0E010107010101, UTF16)
T(0D0E010107010103, UTF16)
T(0D0E010107010105, UTF16)
T(0D0E010107010106, UTF16)
T(0D0E010107010107, UTF16)
T(0D0E010107010108, UTF16)
T(0D0E010107010109, UTF16)
T(0D0E01010701010A, UTF16)
T(0D0E01010701010B, UTF16)
T(0D0E01010701010C, UTF16)
T(0D0E01010701010D, UTF16)
T(0D0E01010701010E, AUID)
T(0D0E01010701010F, UTF16)
T(0D0E010107010202, UTF16)
T(0D0E010107010203, UTF16)
T(0D0E010107010206, UTF16)
T(0D0E010107010302, UTF16)
T(0D0E010107010305, UTF16)
T(0D0E010107010402, UTF16)
T(0D0E010107010404, UTF16)
T(0D0E010107020301, UTF16)
T(0D0E010107020302, UTF16)
T(0D0E010107030101, UI16)
T(0D0E010107030102, UI16)
T(0D0E010107040101, UTF16)
T(0D0E010107040104, UTF16)
T(0D0E010107040300, AUID)
T(0E09050700000000, UI16)
T(0E09050800000000, UI16)
T(0E09050900000000, UUID)
    default: return {};
    }
}
// END

#undef U
#undef C

} //NameSpace

#endif //MEDIAINFO_MXF_*
