; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; XFAIL: *
; RUN: opt < %s -passes=newgvn -S | FileCheck %s

declare void @llvm.masked.scatter.v2i32.v2p0(<2 x i32> , <2 x ptr> , i32 , <2 x i1> )
declare <2 x i32> @llvm.masked.gather.v2i32.v2p0(<2 x ptr>, i32, <2 x i1>, <2 x i32>)

; This test ensures that masked scatter and gather operations, which take vectors of pointers,
; do not have pointer aliasing ignored when being processed.
; No scatter/gather calls should end up eliminated
; CHECK: llvm.masked.gather
; CHECK: llvm.masked.gather
; CHECK: llvm.masked.scatter
; CHECK: llvm.masked.gather
; CHECK: llvm.masked.scatter
; CHECK: llvm.masked.gather
define spir_kernel void @test(<2 x ptr> %in1, <2 x ptr> %in2, ptr %out) {
; CHECK-LABEL: define spir_kernel void @test(
; CHECK-SAME: <2 x ptr> [[IN1:%.*]], <2 x ptr> [[IN2:%.*]], ptr [[OUT:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP_0:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[TMP_1:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[TMP_I:%.*]] = insertelement <2 x ptr> poison, ptr [[TMP_0]], i32 0
; CHECK-NEXT:    [[TMP:%.*]] = insertelement <2 x ptr> [[TMP_I]], ptr [[TMP_1]], i32 1
; CHECK-NEXT:    [[IN1_V:%.*]] = call <2 x i32> @llvm.masked.gather.v2i32.v2p0(<2 x ptr> [[IN1]], i32 1, <2 x i1> <i1 true, i1 true>, <2 x i32> undef)
; CHECK-NEXT:    [[IN2_V:%.*]] = call <2 x i32> @llvm.masked.gather.v2i32.v2p0(<2 x ptr> [[IN2]], i32 1, <2 x i1> <i1 true, i1 true>, <2 x i32> undef)
; CHECK-NEXT:    call void @llvm.masked.scatter.v2i32.v2p0(<2 x i32> [[IN1_V]], <2 x ptr> [[TMP]], i32 1, <2 x i1> <i1 true, i1 true>)
; CHECK-NEXT:    call void @llvm.masked.scatter.v2i32.v2p0(<2 x i32> [[IN2_V]], <2 x ptr> [[TMP]], i32 1, <2 x i1> <i1 true, i1 true>)
; CHECK-NEXT:    [[TMP_V_1:%.*]] = call <2 x i32> @llvm.masked.gather.v2i32.v2p0(<2 x ptr> [[TMP]], i32 1, <2 x i1> <i1 true, i1 true>, <2 x i32> undef)
; CHECK-NEXT:    [[TMP_V_1_0:%.*]] = extractelement <2 x i32> [[TMP_V_1]], i32 0
; CHECK-NEXT:    [[TMP_V_1_1:%.*]] = extractelement <2 x i32> [[TMP_V_1]], i32 1
; CHECK-NEXT:    store i32 [[TMP_V_1_0]], ptr [[OUT]], align 4
; CHECK-NEXT:    [[OUT_1:%.*]] = getelementptr i32, ptr [[OUT]], i32 1
; CHECK-NEXT:    store i32 [[TMP_V_1_1]], ptr [[OUT_1]], align 4
; CHECK-NEXT:    ret void
;
entry:
  ; Just some temporary storage
  %tmp.0 = alloca i32
  %tmp.1 = alloca i32
  %tmp.i = insertelement <2 x ptr> poison, ptr %tmp.0, i32 0
  %tmp = insertelement <2 x ptr> %tmp.i, ptr %tmp.1, i32 1
  ; Read from in1 and in2
  %in1.v = call <2 x i32> @llvm.masked.gather.v2i32.v2p0(<2 x ptr> %in1, i32 1, <2 x i1> <i1 true, i1 true>, <2 x i32> undef) #1
  %in2.v = call <2 x i32> @llvm.masked.gather.v2i32.v2p0(<2 x ptr> %in2, i32 1, <2 x i1> <i1 true, i1 true>, <2 x i32> undef) #1
  ; Store in1 to the allocas
  call void @llvm.masked.scatter.v2i32.v2p0(<2 x i32> %in1.v, <2 x ptr> %tmp, i32 1, <2 x i1> <i1 true, i1 true>);
  ; Read in1 from the allocas
  ; This gather should alias the scatter we just saw
  %tmp.v.0 = call <2 x i32> @llvm.masked.gather.v2i32.v2p0(<2 x ptr> %tmp, i32 1, <2 x i1> <i1 true, i1 true>, <2 x i32> undef) #1
  ; Store in2 to the allocas
  call void @llvm.masked.scatter.v2i32.v2p0(<2 x i32> %in2.v, <2 x ptr> %tmp, i32 1, <2 x i1> <i1 true, i1 true>);
  ; Read in2 from the allocas
  ; This gather should alias the scatter we just saw, and not be eliminated
  %tmp.v.1 = call <2 x i32> @llvm.masked.gather.v2i32.v2p0(<2 x ptr> %tmp, i32 1, <2 x i1> <i1 true, i1 true>, <2 x i32> undef) #1
  ; Store in2 to out for good measure
  %tmp.v.1.0 = extractelement <2 x i32> %tmp.v.1, i32 0
  %tmp.v.1.1 = extractelement <2 x i32> %tmp.v.1, i32 1
  store i32 %tmp.v.1.0, ptr %out
  %out.1 = getelementptr i32, ptr %out, i32 1
  store i32 %tmp.v.1.1, ptr %out.1
  ret void
}
