; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes='loop(indvars,loop-deletion),verify<scalar-evolution>,print<scalar-evolution>' -S %s 2>&1| FileCheck %s

; Make sure the SCEV for %invar is invalidated properly when the instruction is
; moved by LoopDeletion.


define void @test_pr57837() {
; CHECK-LABEL: @test_pr57837(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    br label [[OUTER_HEADER:%.*]]
; CHECK:       outer.header:
; CHECK-NEXT:    br i1 true, label [[INNER_PH:%.*]], label [[OUTER_LATCH:%.*]]
; CHECK:       inner.ph:
; CHECK-NEXT:    [[INVAR:%.*]] = ashr i32 0, 3
; CHECK-NEXT:    br label [[INNER:%.*]]
; CHECK:       inner:
; CHECK-NEXT:    [[P:%.*]] = phi i32 [ poison, [[INNER_PH]] ], [ [[INVAR]], [[INNER]] ]
; CHECK-NEXT:    [[INNER_IV:%.*]] = phi i32 [ 1, [[INNER_PH]] ], [ [[INNER_IV_NEXT:%.*]], [[INNER]] ]
; CHECK-NEXT:    [[ADD_1:%.*]] = add i32 [[P]], 30586
; CHECK-NEXT:    call void @use(i32 [[ADD_1]])
; CHECK-NEXT:    [[INNER_IV_NEXT]] = add nuw nsw i32 [[INNER_IV]], 1
; CHECK-NEXT:    [[INVAR_ADD:%.*]] = add i32 [[INVAR]], 407
; CHECK-NEXT:    [[INNER_CMP:%.*]] = icmp ult i32 [[INNER_IV_NEXT]], [[INVAR_ADD]]
; CHECK-NEXT:    br i1 [[INNER_CMP]], label [[INNER]], label [[INNER_EXIT:%.*]]
; CHECK:       inner.exit:
; CHECK-NEXT:    [[INVAR_LCSSA:%.*]] = phi i32 [ [[INVAR]], [[INNER]] ]
; CHECK-NEXT:    br label [[OUTER_LATCH]]
; CHECK:       outer.latch:
; CHECK-NEXT:    [[MERGE:%.*]] = phi i32 [ 0, [[OUTER_HEADER]] ], [ [[INVAR_LCSSA]], [[INNER_EXIT]] ]
; CHECK-NEXT:    call void @use(i32 [[MERGE]])
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
bb:
  br label %outer.header

outer.header:                                              ; preds = %bb19, %bb
  %outer.iv = phi i32 [ 0, %bb ], [ %tmp21, %outer.latch ]
  %outer.cmp = icmp ult i32 %outer.iv, 400
  br i1 %outer.cmp, label %inner.ph, label %outer.latch

inner.ph:
  br label %inner

inner:
  %p = phi i32 [ poison, %inner.ph ], [ %invar, %inner ]
  %inner.iv = phi i32 [ 1, %inner.ph ], [ %inner.iv.next , %inner ]
  %add.1 = add i32 %p, 30586
  call void @use(i32 %add.1)
  %invar = ashr i32 0, 3
  %inner.iv.next = add nuw nsw i32 %inner.iv, 1
  %invar.add = add i32 %invar, 407
  %inner.cmp = icmp slt i32 %inner.iv.next, %invar.add
  br i1 %inner.cmp, label %inner, label %inner.exit

inner.exit:
  br label %outer.latch

outer.latch:
  %merge = phi i32 [ 0, %outer.header ], [ %invar, %inner.exit ]
  call void @use(i32 %merge)
  %tmp21 = add i32 %outer.iv, 1
  br i1 true, label %exit, label %outer.header

exit:
  ret void
}

declare void @use(i32)


define i32 @scev_invalidation_after_deleting(ptr %src) {
; CHECK-LABEL: @scev_invalidation_after_deleting(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[OUTER_HEADER:%.*]]
; CHECK:       outer.header:
; CHECK-NEXT:    [[OUTER_IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[OUTER_IV_NEXT:%.*]], [[OUTER_LATCH:%.*]] ]
; CHECK-NEXT:    br label [[INNER_1:%.*]]
; CHECK:       inner.1:
; CHECK-NEXT:    [[C_1:%.*]] = icmp eq i32 0, [[OUTER_IV]]
; CHECK-NEXT:    br i1 [[C_1]], label [[INNER_2_PREHEADER:%.*]], label [[INNER_1]]
; CHECK:       inner.2.preheader:
; CHECK-NEXT:    br label [[INNER_3_PH:%.*]]
; CHECK:       inner.3.ph:
; CHECK-NEXT:    br label [[INNER_3:%.*]]
; CHECK:       inner.3:
; CHECK-NEXT:    [[L:%.*]] = load i32, ptr [[SRC:%.*]], align 4
; CHECK-NEXT:    br i1 false, label [[OUTER_LATCH]], label [[INNER_3]]
; CHECK:       outer.latch:
; CHECK-NEXT:    [[L_LCSSA:%.*]] = phi i32 [ [[L]], [[INNER_3]] ]
; CHECK-NEXT:    [[TRUNC:%.*]] = trunc i64 0 to i32
; CHECK-NEXT:    [[OUTER_IV_NEXT]] = add nsw i32 [[L_LCSSA]], [[TRUNC]]
; CHECK-NEXT:    br label [[OUTER_HEADER]]
;
entry:
  br label %outer.header

outer.header:
  %outer.iv = phi i32 [ 0, %entry ], [ %outer.iv.next, %outer.latch ]
  br label %inner.1

inner.1:
  %c.1 = icmp eq i32 0, %outer.iv
  br i1 %c.1, label %inner.2, label %inner.1

inner.2:
  %iv.2 = phi i64 [ 0, %inner.1 ], [ %iv.2.next, %inner.2 ]
  %iv.2.next = add nuw i64 %iv.2, 1
  br i1 true, label %inner.3.ph, label %inner.2

inner.3.ph:
  %trunc = trunc i64 %iv.2 to i32
  br label %inner.3

inner.3:
  %l = load i32, ptr %src, align 4
  br i1 false, label %outer.latch, label %inner.3

outer.latch:
  %outer.iv.next = add nsw i32 %l, %trunc
  br label %outer.header
}

define void @test_pr58314() {
; CHECK-LABEL: @test_pr58314(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[OUTER_HEADER:%.*]]
; CHECK:       outer.header:
; CHECK-NEXT:    [[C:%.*]] = icmp ne i16 0, 0
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[C]], i1 false, i1 true
; CHECK-NEXT:    br label [[INNER:%.*]]
; CHECK:       inner:
; CHECK-NEXT:    br i1 true, label [[INNER]], label [[OUTER_LATCH:%.*]]
; CHECK:       outer.latch:
; CHECK-NEXT:    [[SEL_LCSSA:%.*]] = phi i1 [ [[SEL]], [[INNER]] ]
; CHECK-NEXT:    br i1 [[SEL_LCSSA]], label [[OUTER_HEADER]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %outer.header

outer.header:
  br label %inner

inner:
  %c = icmp ne i16 0, 0
  %sel = select i1 %c, i1 false, i1 true
  br i1 true, label %inner, label %outer.latch

outer.latch:
  br i1 %sel, label %outer.header, label %exit

exit:
  ret void
}
