; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; Test that the strcpy library call simplifier works correctly.
; rdar://6839935
; RUN: opt < %s -passes=instcombine -S | FileCheck %s
;
; This transformation requires the pointer size, as it assumes that size_t is
; the size of a pointer.
target datalayout = "e-p:32:32:32-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:32:64-f32:32:32-f64:32:64-v64:64:64-v128:128:128-a0:0:64-f80:128:128-n8:16:32"

@hello = constant [6 x i8] c"hello\00"
@a = common global [32 x i8] zeroinitializer, align 1
@b = common global [32 x i8] zeroinitializer, align 1

declare ptr @strcpy(ptr, ptr)

define void @test_simplify1() {
; CHECK-LABEL: @test_simplify1(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr noundef nonnull align 1 dereferenceable(6) @a, ptr noundef nonnull align 1 dereferenceable(6) @hello, i32 6, i1 false)
; CHECK-NEXT:    ret void
;


  call ptr @strcpy(ptr @a, ptr @hello)
  ret void
}

define ptr @test_simplify2() {
; CHECK-LABEL: @test_simplify2(
; CHECK-NEXT:    ret ptr @a
;


  %ret = call ptr @strcpy(ptr @a, ptr @a)
  ret ptr %ret
}


define void @test_simplify3(ptr %dst) {
; CHECK-LABEL: @test_simplify3(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr noundef nonnull align 1 dereferenceable(80) [[DST:%.*]], ptr noundef nonnull align 1 dereferenceable(6) @hello, i32 6, i1 false)
; CHECK-NEXT:    ret void
;


  call ptr @strcpy(ptr dereferenceable(80) %dst, ptr @hello)
  ret void
}

define ptr @test_no_simplify1() {
; CHECK-LABEL: @test_no_simplify1(
; CHECK-NEXT:    [[RET:%.*]] = call ptr @strcpy(ptr noundef nonnull dereferenceable(1) @a, ptr noundef nonnull dereferenceable(1) @b)
; CHECK-NEXT:    ret ptr [[RET]]
;


  %ret = call ptr @strcpy(ptr @a, ptr @b)
  ret ptr %ret
}

define ptr @test_no_simplify2(ptr %dst, ptr %src) {
; CHECK-LABEL: @test_no_simplify2(
; CHECK-NEXT:    [[RET:%.*]] = musttail call ptr @strcpy(ptr [[DST:%.*]], ptr [[SRC:%.*]])
; CHECK-NEXT:    ret ptr [[RET]]
;

  %ret = musttail call ptr @strcpy(ptr %dst, ptr %src)
  ret ptr %ret
}


define void @test_no_incompatible_attr() {
; CHECK-LABEL: @test_no_incompatible_attr(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr noundef nonnull align 1 dereferenceable(6) @a, ptr noundef nonnull align 1 dereferenceable(6) @hello, i32 6, i1 false)
; CHECK-NEXT:    ret void
;


  call dereferenceable(1) ptr @strcpy(ptr @a, ptr @hello)
  ret void
}
