; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=x86_64-linux -mcpu=skylake -mattr=+avx2 < %s | FileCheck %s

define <2 x float> @gather_v2f32_scale_512(ptr %result, <2 x i64> %idx, <2 x i1> %mask) {
; CHECK-LABEL: gather_v2f32_scale_512:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpsllq $9, %xmm0, %xmm2
; CHECK-NEXT:    vpshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; CHECK-NEXT:    vpslld $31, %xmm0, %xmm1
; CHECK-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; CHECK-NEXT:    vgatherqps %xmm1, (%rdi,%xmm2), %xmm0
; CHECK-NEXT:    retq
  %gep = getelementptr inbounds [512 x i8], ptr %result, <2 x i64> %idx
  %res = call <2 x float> @llvm.masked.gather.v2f32.v2p0(<2 x ptr> %gep, i32 0, <2 x i1> %mask, <2 x float> zeroinitializer)
  ret <2 x float> %res
}

define <2 x float> @gather_v2f32_scale_16(ptr %result, <2 x i64> %idx, <2 x i1> %mask) {
; CHECK-LABEL: gather_v2f32_scale_16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpsllq $4, %xmm0, %xmm2
; CHECK-NEXT:    vpshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; CHECK-NEXT:    vpslld $31, %xmm0, %xmm1
; CHECK-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; CHECK-NEXT:    vgatherqps %xmm1, (%rdi,%xmm2), %xmm0
; CHECK-NEXT:    retq
  %gep = getelementptr inbounds [16 x i8], ptr %result, <2 x i64> %idx
  %res = call <2 x float> @llvm.masked.gather.v2f32.v2p0(<2 x ptr> %gep, i32 0, <2 x i1> %mask, <2 x float> zeroinitializer)
  ret <2 x float> %res
}

define <2 x float> @gather_v2f32_scale_8(ptr %result, <2 x i64> %idx, <2 x i1> %mask) {
; CHECK-LABEL: gather_v2f32_scale_8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; CHECK-NEXT:    vpslld $31, %xmm1, %xmm2
; CHECK-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vgatherqps %xmm2, (%rdi,%xmm0,8), %xmm1
; CHECK-NEXT:    vmovaps %xmm1, %xmm0
; CHECK-NEXT:    retq
  %gep = getelementptr inbounds [8 x i8], ptr %result, <2 x i64> %idx
  %res = call <2 x float> @llvm.masked.gather.v2f32.v2p0(<2 x ptr> %gep, i32 0, <2 x i1> %mask, <2 x float> zeroinitializer)
  ret <2 x float> %res
}

define <2 x float> @gather_v2f32_scale_4(ptr %result, <2 x i64> %idx, <2 x i1> %mask) {
; CHECK-LABEL: gather_v2f32_scale_4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; CHECK-NEXT:    vpslld $31, %xmm1, %xmm2
; CHECK-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vgatherqps %xmm2, (%rdi,%xmm0,4), %xmm1
; CHECK-NEXT:    vmovaps %xmm1, %xmm0
; CHECK-NEXT:    retq
  %gep = getelementptr inbounds [4 x i8], ptr %result, <2 x i64> %idx
  %res = call <2 x float> @llvm.masked.gather.v2f32.v2p0(<2 x ptr> %gep, i32 0, <2 x i1> %mask, <2 x float> zeroinitializer)
  ret <2 x float> %res
}

define <2 x float> @gather_v2f32_scale_3(ptr %result, <2 x i64> %idx, <2 x i1> %mask) {
; CHECK-LABEL: gather_v2f32_scale_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpaddq %xmm0, %xmm0, %xmm2
; CHECK-NEXT:    vpaddq %xmm0, %xmm2, %xmm2
; CHECK-NEXT:    vpshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; CHECK-NEXT:    vpslld $31, %xmm0, %xmm1
; CHECK-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; CHECK-NEXT:    vgatherqps %xmm1, (%rdi,%xmm2), %xmm0
; CHECK-NEXT:    retq
  %gep = getelementptr inbounds [3 x i8], ptr %result, <2 x i64> %idx
  %res = call <2 x float> @llvm.masked.gather.v2f32.v2p0(<2 x ptr> %gep, i32 0, <2 x i1> %mask, <2 x float> zeroinitializer)
  ret <2 x float> %res
}

define <2 x float> @gather_v2f32_scale_1(ptr %result, <2 x i64> %idx, <2 x i1> %mask) {
; CHECK-LABEL: gather_v2f32_scale_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; CHECK-NEXT:    vpslld $31, %xmm1, %xmm2
; CHECK-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vgatherqps %xmm2, (%rdi,%xmm0), %xmm1
; CHECK-NEXT:    vmovaps %xmm1, %xmm0
; CHECK-NEXT:    retq
  %gep = getelementptr inbounds [1 x i8], ptr %result, <2 x i64> %idx
  %res = call <2 x float> @llvm.masked.gather.v2f32.v2p0(<2 x ptr> %gep, i32 0, <2 x i1> %mask, <2 x float> zeroinitializer)
  ret <2 x float> %res
}

declare <2 x float> @llvm.masked.gather.v2f32.v2p0(<2 x ptr>, i32 immarg, <2 x i1>, <2 x float>)
