; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown -stop-after=x86-isel -mattr=+xsave,+egpr  | FileCheck %s

define void @test_xsave(ptr %ptr, i32 %hi, i32 %lo) {
  ; CHECK-LABEL: name: test_xsave
  ; CHECK: bb.0 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $rdi, $esi, $edx
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:gr32 = COPY $edx
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:gr32 = COPY $esi
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:gr64_norex2 = COPY $rdi
  ; CHECK-NEXT:   $edx = COPY [[COPY1]]
  ; CHECK-NEXT:   $eax = COPY [[COPY]]
  ; CHECK-NEXT:   XSAVE [[COPY2]], 1, $noreg, 0, $noreg, implicit $edx, implicit $eax
  ; CHECK-NEXT:   RET 0
  call void @llvm.x86.xsave(ptr %ptr, i32 %hi, i32 %lo)
  ret void;
}
declare void @llvm.x86.xsave(ptr, i32, i32)

define void @test_xsave64(ptr %ptr, i32 %hi, i32 %lo) {
  ; CHECK-LABEL: name: test_xsave64
  ; CHECK: bb.0 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $rdi, $esi, $edx
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:gr32 = COPY $edx
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:gr32 = COPY $esi
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:gr64_norex2 = COPY $rdi
  ; CHECK-NEXT:   $edx = COPY [[COPY1]]
  ; CHECK-NEXT:   $eax = COPY [[COPY]]
  ; CHECK-NEXT:   XSAVE64 [[COPY2]], 1, $noreg, 0, $noreg, implicit $edx, implicit $eax
  ; CHECK-NEXT:   RET 0
  call void @llvm.x86.xsave64(ptr %ptr, i32 %hi, i32 %lo)
  ret void;
}
declare void @llvm.x86.xsave64(ptr, i32, i32)

define void @test_xrstor(ptr %ptr, i32 %hi, i32 %lo) {
  ; CHECK-LABEL: name: test_xrstor
  ; CHECK: bb.0 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $rdi, $esi, $edx
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:gr32 = COPY $edx
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:gr32 = COPY $esi
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:gr64_norex2 = COPY $rdi
  ; CHECK-NEXT:   $edx = COPY [[COPY1]]
  ; CHECK-NEXT:   $eax = COPY [[COPY]]
  ; CHECK-NEXT:   XRSTOR [[COPY2]], 1, $noreg, 0, $noreg, implicit $edx, implicit $eax
  ; CHECK-NEXT:   RET 0
  call void @llvm.x86.xrstor(ptr %ptr, i32 %hi, i32 %lo)
  ret void;
}
declare void @llvm.x86.xrstor(ptr, i32, i32)

define void @test_xrstor64(ptr %ptr, i32 %hi, i32 %lo) {
  ; CHECK-LABEL: name: test_xrstor64
  ; CHECK: bb.0 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $rdi, $esi, $edx
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:gr32 = COPY $edx
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:gr32 = COPY $esi
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:gr64_norex2 = COPY $rdi
  ; CHECK-NEXT:   $edx = COPY [[COPY1]]
  ; CHECK-NEXT:   $eax = COPY [[COPY]]
  ; CHECK-NEXT:   XRSTOR64 [[COPY2]], 1, $noreg, 0, $noreg, implicit $edx, implicit $eax
  ; CHECK-NEXT:   RET 0
  call void @llvm.x86.xrstor64(ptr %ptr, i32 %hi, i32 %lo)
  ret void;
}
declare void @llvm.x86.xrstor64(ptr, i32, i32)
