// RUN: llvm-mc -triple=amdgcn -mcpu=gfx900 -show-encoding %s | FileCheck %s

s_load_dword s5, s[2:3], s0
// CHECK: [0x41,0x01,0x00,0xc0,0x00,0x00,0x00,0x00]

s_load_dword s101, s[2:3], s0
// CHECK: [0x41,0x19,0x00,0xc0,0x00,0x00,0x00,0x00]

s_load_dword flat_scratch_lo, s[2:3], s0
// CHECK: [0x81,0x19,0x00,0xc0,0x00,0x00,0x00,0x00]

s_load_dword flat_scratch_hi, s[2:3], s0
// CHECK: [0xc1,0x19,0x00,0xc0,0x00,0x00,0x00,0x00]

s_load_dword vcc_lo, s[2:3], s0
// CHECK: [0x81,0x1a,0x00,0xc0,0x00,0x00,0x00,0x00]

s_load_dword vcc_hi, s[2:3], s0
// CHECK: [0xc1,0x1a,0x00,0xc0,0x00,0x00,0x00,0x00]

s_load_dword ttmp15, s[2:3], s0
// CHECK: [0xc1,0x1e,0x00,0xc0,0x00,0x00,0x00,0x00]

s_load_dword s5, s[4:5], s0
// CHECK: [0x42,0x01,0x00,0xc0,0x00,0x00,0x00,0x00]

s_load_dword s5, s[100:101], s0
// CHECK: [0x72,0x01,0x00,0xc0,0x00,0x00,0x00,0x00]

s_load_dword s5, flat_scratch, s0
// CHECK: [0x73,0x01,0x00,0xc0,0x00,0x00,0x00,0x00]

s_load_dword s5, vcc, s0
// CHECK: [0x75,0x01,0x00,0xc0,0x00,0x00,0x00,0x00]

s_load_dword s5, ttmp[14:15], s0
// CHECK: [0x7d,0x01,0x00,0xc0,0x00,0x00,0x00,0x00]

s_load_dword s5, s[2:3], s101
// CHECK: [0x41,0x01,0x00,0xc0,0x65,0x00,0x00,0x00]

s_load_dword s5, s[2:3], flat_scratch_lo
// CHECK: [0x41,0x01,0x00,0xc0,0x66,0x00,0x00,0x00]

s_load_dword s5, s[2:3], flat_scratch_hi
// CHECK: [0x41,0x01,0x00,0xc0,0x67,0x00,0x00,0x00]

s_load_dword s5, s[2:3], vcc_lo
// CHECK: [0x41,0x01,0x00,0xc0,0x6a,0x00,0x00,0x00]

s_load_dword s5, s[2:3], vcc_hi
// CHECK: [0x41,0x01,0x00,0xc0,0x6b,0x00,0x00,0x00]

s_load_dword s5, s[2:3], ttmp15
// CHECK: [0x41,0x01,0x00,0xc0,0x7b,0x00,0x00,0x00]

s_load_dword s5, s[2:3], m0
// CHECK: [0x41,0x01,0x00,0xc0,0x7c,0x00,0x00,0x00]

s_load_dword s5, s[2:3], 0x0
// CHECK: [0x41,0x01,0x02,0xc0,0x00,0x00,0x00,0x00]

s_load_dword s5, s[2:3], s7 offset:0x12345
// CHECK: [0x41,0x41,0x02,0xc0,0x45,0x23,0x01,0x0e]

s_load_dword s5, s[2:3], s0 glc
// CHECK: [0x41,0x01,0x01,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[2:3], s0
// CHECK: [0x81,0x02,0x04,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx2 s[12:13], s[2:3], s0
// CHECK: [0x01,0x03,0x04,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx2 s[100:101], s[2:3], s0
// CHECK: [0x01,0x19,0x04,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx2 flat_scratch, s[2:3], s0
// CHECK: [0x81,0x19,0x04,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx2 vcc, s[2:3], s0
// CHECK: [0x81,0x1a,0x04,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx2 ttmp[14:15], s[2:3], s0
// CHECK: [0x81,0x1e,0x04,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[4:5], s0
// CHECK: [0x82,0x02,0x04,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[100:101], s0
// CHECK: [0xb2,0x02,0x04,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], flat_scratch, s0
// CHECK: [0xb3,0x02,0x04,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], vcc, s0
// CHECK: [0xb5,0x02,0x04,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], ttmp[14:15], s0
// CHECK: [0xbd,0x02,0x04,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[2:3], s101
// CHECK: [0x81,0x02,0x04,0xc0,0x65,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[2:3], flat_scratch_lo
// CHECK: [0x81,0x02,0x04,0xc0,0x66,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[2:3], flat_scratch_hi
// CHECK: [0x81,0x02,0x04,0xc0,0x67,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[2:3], vcc_lo
// CHECK: [0x81,0x02,0x04,0xc0,0x6a,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[2:3], vcc_hi
// CHECK: [0x81,0x02,0x04,0xc0,0x6b,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[2:3], ttmp15
// CHECK: [0x81,0x02,0x04,0xc0,0x7b,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[2:3], m0
// CHECK: [0x81,0x02,0x04,0xc0,0x7c,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[2:3], 0x0
// CHECK: [0x81,0x02,0x06,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[2:3], s0 offset:0x12345
// CHECK: [0x81,0x42,0x06,0xc0,0x45,0x23,0x01,0x00]

s_load_dwordx2 s[10:11], s[2:3], s0 glc
// CHECK: [0x81,0x02,0x05,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[2:3], s0
// CHECK: [0x01,0x05,0x08,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx4 s[24:27], s[2:3], s0
// CHECK: [0x01,0x06,0x08,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx4 s[96:99], s[2:3], s0
// CHECK: [0x01,0x18,0x08,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx4 ttmp[12:15], s[2:3], s0
// CHECK: [0x01,0x1e,0x08,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[4:5], s0
// CHECK: [0x02,0x05,0x08,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[100:101], s0
// CHECK: [0x32,0x05,0x08,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], flat_scratch, s0
// CHECK: [0x33,0x05,0x08,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], vcc, s0
// CHECK: [0x35,0x05,0x08,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], ttmp[14:15], s0
// CHECK: [0x3d,0x05,0x08,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[2:3], s101
// CHECK: [0x01,0x05,0x08,0xc0,0x65,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[2:3], flat_scratch_lo
// CHECK: [0x01,0x05,0x08,0xc0,0x66,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[2:3], flat_scratch_hi
// CHECK: [0x01,0x05,0x08,0xc0,0x67,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[2:3], vcc_lo
// CHECK: [0x01,0x05,0x08,0xc0,0x6a,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[2:3], vcc_hi
// CHECK: [0x01,0x05,0x08,0xc0,0x6b,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[2:3], ttmp15
// CHECK: [0x01,0x05,0x08,0xc0,0x7b,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[2:3], m0
// CHECK: [0x01,0x05,0x08,0xc0,0x7c,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[2:3], 0x0
// CHECK: [0x01,0x05,0x0a,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[2:3], s0 offset:0x12345
// CHECK: [0x01,0x45,0x0a,0xc0,0x45,0x23,0x01,0x00]

s_load_dwordx4 s[20:23], s[2:3], s0 glc
// CHECK: [0x01,0x05,0x09,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[2:3], s0
// CHECK: [0x01,0x05,0x0c,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx8 s[24:31], s[2:3], s0
// CHECK: [0x01,0x06,0x0c,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx8 s[92:99], s[2:3], s0
// CHECK: [0x01,0x17,0x0c,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx8 ttmp[8:15], s[2:3], s0
// CHECK: [0x01,0x1d,0x0c,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[4:5], s0
// CHECK: [0x02,0x05,0x0c,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[100:101], s0
// CHECK: [0x32,0x05,0x0c,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], flat_scratch, s0
// CHECK: [0x33,0x05,0x0c,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], vcc, s0
// CHECK: [0x35,0x05,0x0c,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], ttmp[14:15], s0
// CHECK: [0x3d,0x05,0x0c,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[2:3], s101
// CHECK: [0x01,0x05,0x0c,0xc0,0x65,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[2:3], flat_scratch_lo
// CHECK: [0x01,0x05,0x0c,0xc0,0x66,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[2:3], flat_scratch_hi
// CHECK: [0x01,0x05,0x0c,0xc0,0x67,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[2:3], vcc_lo
// CHECK: [0x01,0x05,0x0c,0xc0,0x6a,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[2:3], vcc_hi
// CHECK: [0x01,0x05,0x0c,0xc0,0x6b,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[2:3], ttmp15
// CHECK: [0x01,0x05,0x0c,0xc0,0x7b,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[2:3], m0
// CHECK: [0x01,0x05,0x0c,0xc0,0x7c,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[2:3], 0x0
// CHECK: [0x01,0x05,0x0e,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[2:3], s0 offset:0x12345
// CHECK: [0x01,0x45,0x0e,0xc0,0x45,0x23,0x01,0x00]

s_load_dwordx8 s[20:27], s[2:3], s0 glc
// CHECK: [0x01,0x05,0x0d,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[2:3], s0
// CHECK: [0x01,0x05,0x10,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx16 s[24:39], s[2:3], s0
// CHECK: [0x01,0x06,0x10,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx16 s[84:99], s[2:3], s0
// CHECK: [0x01,0x15,0x10,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx16 ttmp[0:15], s[2:3], s0
// CHECK: [0x01,0x1b,0x10,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[4:5], s0
// CHECK: [0x02,0x05,0x10,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[100:101], s0
// CHECK: [0x32,0x05,0x10,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], flat_scratch, s0
// CHECK: [0x33,0x05,0x10,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], vcc, s0
// CHECK: [0x35,0x05,0x10,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], ttmp[14:15], s0
// CHECK: [0x3d,0x05,0x10,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[2:3], s101
// CHECK: [0x01,0x05,0x10,0xc0,0x65,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[2:3], flat_scratch_lo
// CHECK: [0x01,0x05,0x10,0xc0,0x66,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[2:3], flat_scratch_hi
// CHECK: [0x01,0x05,0x10,0xc0,0x67,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[2:3], vcc_lo
// CHECK: [0x01,0x05,0x10,0xc0,0x6a,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[2:3], vcc_hi
// CHECK: [0x01,0x05,0x10,0xc0,0x6b,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[2:3], ttmp15
// CHECK: [0x01,0x05,0x10,0xc0,0x7b,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[2:3], m0
// CHECK: [0x01,0x05,0x10,0xc0,0x7c,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[2:3], 0x0
// CHECK: [0x01,0x05,0x12,0xc0,0x00,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[2:3], s0 offset:0x12345
// CHECK: [0x01,0x45,0x12,0xc0,0x45,0x23,0x01,0x00]

s_load_dwordx16 s[20:35], s[2:3], s0 glc
// CHECK: [0x01,0x05,0x11,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dword s5, s[2:3], s0
// CHECK: [0x41,0x01,0x14,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dword s101, s[2:3], s0
// CHECK: [0x41,0x19,0x14,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dword flat_scratch_lo, s[2:3], s0
// CHECK: [0x81,0x19,0x14,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dword flat_scratch_hi, s[2:3], s0
// CHECK: [0xc1,0x19,0x14,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dword vcc_lo, s[2:3], s0
// CHECK: [0x81,0x1a,0x14,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dword vcc_hi, s[2:3], s0
// CHECK: [0xc1,0x1a,0x14,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dword ttmp15, s[2:3], s0
// CHECK: [0xc1,0x1e,0x14,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dword s5, s[4:5], s0
// CHECK: [0x42,0x01,0x14,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dword s5, s[100:101], s0
// CHECK: [0x72,0x01,0x14,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dword s5, flat_scratch, s0
// CHECK: [0x73,0x01,0x14,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dword s5, vcc, s0
// CHECK: [0x75,0x01,0x14,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dword s5, ttmp[14:15], s0
// CHECK: [0x7d,0x01,0x14,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dword s5, s[2:3], s101
// CHECK: [0x41,0x01,0x14,0xc0,0x65,0x00,0x00,0x00]

s_scratch_load_dword s5, s[2:3], flat_scratch_lo
// CHECK: [0x41,0x01,0x14,0xc0,0x66,0x00,0x00,0x00]

s_scratch_load_dword s5, s[2:3], flat_scratch_hi
// CHECK: [0x41,0x01,0x14,0xc0,0x67,0x00,0x00,0x00]

s_scratch_load_dword s5, s[2:3], vcc_lo
// CHECK: [0x41,0x01,0x14,0xc0,0x6a,0x00,0x00,0x00]

s_scratch_load_dword s5, s[2:3], vcc_hi
// CHECK: [0x41,0x01,0x14,0xc0,0x6b,0x00,0x00,0x00]

s_scratch_load_dword s5, s[2:3], ttmp15
// CHECK: [0x41,0x01,0x14,0xc0,0x7b,0x00,0x00,0x00]

s_scratch_load_dword s5, s[2:3], m0
// CHECK: [0x41,0x01,0x14,0xc0,0x7c,0x00,0x00,0x00]

s_scratch_load_dword s5, s[2:3], 0x0
// CHECK: [0x41,0x01,0x16,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dword s5, s[2:3], s0 offset:0x12345
// CHECK: [0x41,0x41,0x16,0xc0,0x45,0x23,0x01,0x00]

s_scratch_load_dword s5, s[2:3], s0 glc
// CHECK: [0x41,0x01,0x15,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dwordx2 s[10:11], s[2:3], s0
// CHECK: [0x81,0x02,0x18,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dwordx2 s[12:13], s[2:3], s0
// CHECK: [0x01,0x03,0x18,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dwordx2 s[100:101], s[2:3], s0
// CHECK: [0x01,0x19,0x18,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dwordx2 flat_scratch, s[2:3], s0
// CHECK: [0x81,0x19,0x18,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dwordx2 vcc, s[2:3], s0
// CHECK: [0x81,0x1a,0x18,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dwordx2 ttmp[14:15], s[2:3], s0
// CHECK: [0x81,0x1e,0x18,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dwordx2 s[10:11], s[4:5], s0
// CHECK: [0x82,0x02,0x18,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dwordx2 s[10:11], s[100:101], s0
// CHECK: [0xb2,0x02,0x18,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dwordx2 s[10:11], flat_scratch, s0
// CHECK: [0xb3,0x02,0x18,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dwordx2 s[10:11], vcc, s0
// CHECK: [0xb5,0x02,0x18,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dwordx2 s[10:11], ttmp[14:15], s0
// CHECK: [0xbd,0x02,0x18,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dwordx2 s[10:11], s[2:3], s101
// CHECK: [0x81,0x02,0x18,0xc0,0x65,0x00,0x00,0x00]

s_scratch_load_dwordx2 s[10:11], s[2:3], flat_scratch_lo
// CHECK: [0x81,0x02,0x18,0xc0,0x66,0x00,0x00,0x00]

s_scratch_load_dwordx2 s[10:11], s[2:3], flat_scratch_hi
// CHECK: [0x81,0x02,0x18,0xc0,0x67,0x00,0x00,0x00]

s_scratch_load_dwordx2 s[10:11], s[2:3], vcc_lo
// CHECK: [0x81,0x02,0x18,0xc0,0x6a,0x00,0x00,0x00]

s_scratch_load_dwordx2 s[10:11], s[2:3], vcc_hi
// CHECK: [0x81,0x02,0x18,0xc0,0x6b,0x00,0x00,0x00]

s_scratch_load_dwordx2 s[10:11], s[2:3], ttmp15
// CHECK: [0x81,0x02,0x18,0xc0,0x7b,0x00,0x00,0x00]

s_scratch_load_dwordx2 s[10:11], s[2:3], m0
// CHECK: [0x81,0x02,0x18,0xc0,0x7c,0x00,0x00,0x00]

s_scratch_load_dwordx2 s[10:11], s[2:3], 0x0
// CHECK: [0x81,0x02,0x1a,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dwordx2 s[10:11], s[2:3], s0 offset:0x12345
// CHECK: [0x81,0x42,0x1a,0xc0,0x45,0x23,0x01,0x00]

s_scratch_load_dwordx2 s[10:11], s[2:3], s0 glc
// CHECK: [0x81,0x02,0x19,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dwordx4 s[20:23], s[2:3], s0
// CHECK: [0x01,0x05,0x1c,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dwordx4 s[24:27], s[2:3], s0
// CHECK: [0x01,0x06,0x1c,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dwordx4 s[96:99], s[2:3], s0
// CHECK: [0x01,0x18,0x1c,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dwordx4 ttmp[12:15], s[2:3], s0
// CHECK: [0x01,0x1e,0x1c,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dwordx4 s[20:23], s[4:5], s0
// CHECK: [0x02,0x05,0x1c,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dwordx4 s[20:23], s[100:101], s0
// CHECK: [0x32,0x05,0x1c,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dwordx4 s[20:23], flat_scratch, s0
// CHECK: [0x33,0x05,0x1c,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dwordx4 s[20:23], vcc, s0
// CHECK: [0x35,0x05,0x1c,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dwordx4 s[20:23], ttmp[14:15], s0
// CHECK: [0x3d,0x05,0x1c,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dwordx4 s[20:23], s[2:3], s101
// CHECK: [0x01,0x05,0x1c,0xc0,0x65,0x00,0x00,0x00]

s_scratch_load_dwordx4 s[20:23], s[2:3], flat_scratch_lo
// CHECK: [0x01,0x05,0x1c,0xc0,0x66,0x00,0x00,0x00]

s_scratch_load_dwordx4 s[20:23], s[2:3], flat_scratch_hi
// CHECK: [0x01,0x05,0x1c,0xc0,0x67,0x00,0x00,0x00]

s_scratch_load_dwordx4 s[20:23], s[2:3], vcc_lo
// CHECK: [0x01,0x05,0x1c,0xc0,0x6a,0x00,0x00,0x00]

s_scratch_load_dwordx4 s[20:23], s[2:3], vcc_hi
// CHECK: [0x01,0x05,0x1c,0xc0,0x6b,0x00,0x00,0x00]

s_scratch_load_dwordx4 s[20:23], s[2:3], ttmp15
// CHECK: [0x01,0x05,0x1c,0xc0,0x7b,0x00,0x00,0x00]

s_scratch_load_dwordx4 s[20:23], s[2:3], m0
// CHECK: [0x01,0x05,0x1c,0xc0,0x7c,0x00,0x00,0x00]

s_scratch_load_dwordx4 s[20:23], s[2:3], 0x0
// CHECK: [0x01,0x05,0x1e,0xc0,0x00,0x00,0x00,0x00]

s_scratch_load_dwordx4 s[20:23], s[2:3], s0 offset:0x12345
// CHECK: [0x01,0x45,0x1e,0xc0,0x45,0x23,0x01,0x00]

s_scratch_load_dwordx4 s[20:23], s[2:3], s0 glc
// CHECK: [0x01,0x05,0x1d,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dword s5, s[4:7], s0
// CHECK: [0x42,0x01,0x20,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dword s101, s[4:7], s0
// CHECK: [0x42,0x19,0x20,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dword flat_scratch_lo, s[4:7], s0
// CHECK: [0x82,0x19,0x20,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dword flat_scratch_hi, s[4:7], s0
// CHECK: [0xc2,0x19,0x20,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dword vcc_lo, s[4:7], s0
// CHECK: [0x82,0x1a,0x20,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dword vcc_hi, s[4:7], s0
// CHECK: [0xc2,0x1a,0x20,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dword ttmp15, s[4:7], s0
// CHECK: [0xc2,0x1e,0x20,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dword s5, s[8:11], s0
// CHECK: [0x44,0x01,0x20,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dword s5, s[96:99], s0
// CHECK: [0x70,0x01,0x20,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dword s5, ttmp[12:15], s0
// CHECK: [0x7c,0x01,0x20,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dword s5, s[4:7], s101
// CHECK: [0x42,0x01,0x20,0xc0,0x65,0x00,0x00,0x00]

s_buffer_load_dword s5, s[4:7], flat_scratch_lo
// CHECK: [0x42,0x01,0x20,0xc0,0x66,0x00,0x00,0x00]

s_buffer_load_dword s5, s[4:7], flat_scratch_hi
// CHECK: [0x42,0x01,0x20,0xc0,0x67,0x00,0x00,0x00]

s_buffer_load_dword s5, s[4:7], vcc_lo
// CHECK: [0x42,0x01,0x20,0xc0,0x6a,0x00,0x00,0x00]

s_buffer_load_dword s5, s[4:7], vcc_hi
// CHECK: [0x42,0x01,0x20,0xc0,0x6b,0x00,0x00,0x00]

s_buffer_load_dword s5, s[4:7], ttmp15
// CHECK: [0x42,0x01,0x20,0xc0,0x7b,0x00,0x00,0x00]

s_buffer_load_dword s5, s[4:7], m0
// CHECK: [0x42,0x01,0x20,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_load_dword s5, s[4:7], 0x0
// CHECK: [0x42,0x01,0x22,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dword s5, s[4:7], s0 offset:0x12345
// CHECK: [0x42,0x41,0x22,0xc0,0x45,0x23,0x01,0x00]

s_buffer_load_dword s5, s[4:7], s0 glc
// CHECK: [0x42,0x01,0x21,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], s0
// CHECK: [0x82,0x02,0x24,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[12:13], s[4:7], s0
// CHECK: [0x02,0x03,0x24,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[100:101], s[4:7], s0
// CHECK: [0x02,0x19,0x24,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx2 flat_scratch, s[4:7], s0
// CHECK: [0x82,0x19,0x24,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx2 vcc, s[4:7], s0
// CHECK: [0x82,0x1a,0x24,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx2 ttmp[14:15], s[4:7], s0
// CHECK: [0x82,0x1e,0x24,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[8:11], s0
// CHECK: [0x84,0x02,0x24,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[96:99], s0
// CHECK: [0xb0,0x02,0x24,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], ttmp[12:15], s0
// CHECK: [0xbc,0x02,0x24,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], s101
// CHECK: [0x82,0x02,0x24,0xc0,0x65,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], flat_scratch_lo
// CHECK: [0x82,0x02,0x24,0xc0,0x66,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], flat_scratch_hi
// CHECK: [0x82,0x02,0x24,0xc0,0x67,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], vcc_lo
// CHECK: [0x82,0x02,0x24,0xc0,0x6a,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], vcc_hi
// CHECK: [0x82,0x02,0x24,0xc0,0x6b,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], ttmp15
// CHECK: [0x82,0x02,0x24,0xc0,0x7b,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], m0
// CHECK: [0x82,0x02,0x24,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], 0x0
// CHECK: [0x82,0x02,0x26,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], s0 offset:0x12345
// CHECK: [0x82,0x42,0x26,0xc0,0x45,0x23,0x01,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], s0 glc
// CHECK: [0x82,0x02,0x25,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], s0
// CHECK: [0x02,0x05,0x28,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[24:27], s[4:7], s0
// CHECK: [0x02,0x06,0x28,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[96:99], s[4:7], s0
// CHECK: [0x02,0x18,0x28,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx4 ttmp[12:15], s[4:7], s0
// CHECK: [0x02,0x1e,0x28,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[8:11], s0
// CHECK: [0x04,0x05,0x28,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[96:99], s0
// CHECK: [0x30,0x05,0x28,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], ttmp[12:15], s0
// CHECK: [0x3c,0x05,0x28,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], s101
// CHECK: [0x02,0x05,0x28,0xc0,0x65,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], flat_scratch_lo
// CHECK: [0x02,0x05,0x28,0xc0,0x66,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], flat_scratch_hi
// CHECK: [0x02,0x05,0x28,0xc0,0x67,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], vcc_lo
// CHECK: [0x02,0x05,0x28,0xc0,0x6a,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], vcc_hi
// CHECK: [0x02,0x05,0x28,0xc0,0x6b,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], ttmp15
// CHECK: [0x02,0x05,0x28,0xc0,0x7b,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], m0
// CHECK: [0x02,0x05,0x28,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], 0x0
// CHECK: [0x02,0x05,0x2a,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], s0 offset:0x12345
// CHECK: [0x02,0x45,0x2a,0xc0,0x45,0x23,0x01,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], s0 glc
// CHECK: [0x02,0x05,0x29,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], s0
// CHECK: [0x02,0x05,0x2c,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[24:31], s[4:7], s0
// CHECK: [0x02,0x06,0x2c,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[92:99], s[4:7], s0
// CHECK: [0x02,0x17,0x2c,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx8 ttmp[8:15], s[4:7], s0
// CHECK: [0x02,0x1d,0x2c,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[8:11], s0
// CHECK: [0x04,0x05,0x2c,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[96:99], s0
// CHECK: [0x30,0x05,0x2c,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], ttmp[12:15], s0
// CHECK: [0x3c,0x05,0x2c,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], s101
// CHECK: [0x02,0x05,0x2c,0xc0,0x65,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], flat_scratch_lo
// CHECK: [0x02,0x05,0x2c,0xc0,0x66,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], flat_scratch_hi
// CHECK: [0x02,0x05,0x2c,0xc0,0x67,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], vcc_lo
// CHECK: [0x02,0x05,0x2c,0xc0,0x6a,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], vcc_hi
// CHECK: [0x02,0x05,0x2c,0xc0,0x6b,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], ttmp15
// CHECK: [0x02,0x05,0x2c,0xc0,0x7b,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], m0
// CHECK: [0x02,0x05,0x2c,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], 0x0
// CHECK: [0x02,0x05,0x2e,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], s0 offset:0x12345
// CHECK: [0x02,0x45,0x2e,0xc0,0x45,0x23,0x01,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], s0 glc
// CHECK: [0x02,0x05,0x2d,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], s0
// CHECK: [0x02,0x05,0x30,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[24:39], s[4:7], s0
// CHECK: [0x02,0x06,0x30,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[84:99], s[4:7], s0
// CHECK: [0x02,0x15,0x30,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx16 ttmp[0:15], s[4:7], s0
// CHECK: [0x02,0x1b,0x30,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[8:11], s0
// CHECK: [0x04,0x05,0x30,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[96:99], s0
// CHECK: [0x30,0x05,0x30,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], ttmp[12:15], s0
// CHECK: [0x3c,0x05,0x30,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], s101
// CHECK: [0x02,0x05,0x30,0xc0,0x65,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], flat_scratch_lo
// CHECK: [0x02,0x05,0x30,0xc0,0x66,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], flat_scratch_hi
// CHECK: [0x02,0x05,0x30,0xc0,0x67,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], vcc_lo
// CHECK: [0x02,0x05,0x30,0xc0,0x6a,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], vcc_hi
// CHECK: [0x02,0x05,0x30,0xc0,0x6b,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], ttmp15
// CHECK: [0x02,0x05,0x30,0xc0,0x7b,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], m0
// CHECK: [0x02,0x05,0x30,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], 0x0
// CHECK: [0x02,0x05,0x32,0xc0,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], s0 offset:0x12345
// CHECK: [0x02,0x45,0x32,0xc0,0x45,0x23,0x01,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], s0 glc
// CHECK: [0x02,0x05,0x31,0xc0,0x00,0x00,0x00,0x00]

s_store_dword s1, s[4:5], s0
// CHECK: [0x42,0x00,0x40,0xc0,0x00,0x00,0x00,0x00]

s_store_dword s101, s[4:5], s0
// CHECK: [0x42,0x19,0x40,0xc0,0x00,0x00,0x00,0x00]

s_store_dword flat_scratch_lo, s[4:5], s0
// CHECK: [0x82,0x19,0x40,0xc0,0x00,0x00,0x00,0x00]

s_store_dword flat_scratch_hi, s[4:5], s0
// CHECK: [0xc2,0x19,0x40,0xc0,0x00,0x00,0x00,0x00]

s_store_dword vcc_lo, s[4:5], s0
// CHECK: [0x82,0x1a,0x40,0xc0,0x00,0x00,0x00,0x00]

s_store_dword vcc_hi, s[4:5], s0
// CHECK: [0xc2,0x1a,0x40,0xc0,0x00,0x00,0x00,0x00]

s_store_dword ttmp15, s[4:5], s0
// CHECK: [0xc2,0x1e,0x40,0xc0,0x00,0x00,0x00,0x00]

s_store_dword s1, s[6:7], s0
// CHECK: [0x43,0x00,0x40,0xc0,0x00,0x00,0x00,0x00]

s_store_dword s1, s[100:101], s0
// CHECK: [0x72,0x00,0x40,0xc0,0x00,0x00,0x00,0x00]

s_store_dword s1, flat_scratch, s0
// CHECK: [0x73,0x00,0x40,0xc0,0x00,0x00,0x00,0x00]

s_store_dword s1, vcc, s0
// CHECK: [0x75,0x00,0x40,0xc0,0x00,0x00,0x00,0x00]

s_store_dword s1, ttmp[14:15], s0
// CHECK: [0x7d,0x00,0x40,0xc0,0x00,0x00,0x00,0x00]

s_store_dword s1, s[4:5], s101
// CHECK: [0x42,0x00,0x40,0xc0,0x65,0x00,0x00,0x00]

s_store_dword s1, s[4:5], flat_scratch_lo
// CHECK: [0x42,0x00,0x40,0xc0,0x66,0x00,0x00,0x00]

s_store_dword s1, s[4:5], flat_scratch_hi
// CHECK: [0x42,0x00,0x40,0xc0,0x67,0x00,0x00,0x00]

s_store_dword s1, s[4:5], vcc_lo
// CHECK: [0x42,0x00,0x40,0xc0,0x6a,0x00,0x00,0x00]

s_store_dword s1, s[4:5], vcc_hi
// CHECK: [0x42,0x00,0x40,0xc0,0x6b,0x00,0x00,0x00]

s_store_dword s1, s[4:5], ttmp15
// CHECK: [0x42,0x00,0x40,0xc0,0x7b,0x00,0x00,0x00]

s_store_dword s1, s[4:5], m0
// CHECK: [0x42,0x00,0x40,0xc0,0x7c,0x00,0x00,0x00]

s_store_dword s1, s[4:5], 0x0
// CHECK: [0x42,0x00,0x42,0xc0,0x00,0x00,0x00,0x00]

s_store_dword s1, s[4:5], s7 offset:0x12345
// CHECK: [0x42,0x40,0x42,0xc0,0x45,0x23,0x01,0x0e]

s_store_dword s1, s[4:5], s0 glc
// CHECK: [0x42,0x00,0x41,0xc0,0x00,0x00,0x00,0x00]

s_store_dwordx2 s[2:3], s[4:5], s0
// CHECK: [0x82,0x00,0x44,0xc0,0x00,0x00,0x00,0x00]

s_store_dwordx2 s[4:5], s[4:5], s0
// CHECK: [0x02,0x01,0x44,0xc0,0x00,0x00,0x00,0x00]

s_store_dwordx2 s[100:101], s[4:5], s0
// CHECK: [0x02,0x19,0x44,0xc0,0x00,0x00,0x00,0x00]

s_store_dwordx2 flat_scratch, s[4:5], s0
// CHECK: [0x82,0x19,0x44,0xc0,0x00,0x00,0x00,0x00]

s_store_dwordx2 vcc, s[4:5], s0
// CHECK: [0x82,0x1a,0x44,0xc0,0x00,0x00,0x00,0x00]

s_store_dwordx2 ttmp[14:15], s[4:5], s0
// CHECK: [0x82,0x1e,0x44,0xc0,0x00,0x00,0x00,0x00]

s_store_dwordx2 s[2:3], s[6:7], s0
// CHECK: [0x83,0x00,0x44,0xc0,0x00,0x00,0x00,0x00]

s_store_dwordx2 s[2:3], s[100:101], s0
// CHECK: [0xb2,0x00,0x44,0xc0,0x00,0x00,0x00,0x00]

s_store_dwordx2 s[2:3], flat_scratch, s0
// CHECK: [0xb3,0x00,0x44,0xc0,0x00,0x00,0x00,0x00]

s_store_dwordx2 s[2:3], vcc, s0
// CHECK: [0xb5,0x00,0x44,0xc0,0x00,0x00,0x00,0x00]

s_store_dwordx2 s[2:3], ttmp[14:15], s0
// CHECK: [0xbd,0x00,0x44,0xc0,0x00,0x00,0x00,0x00]

s_store_dwordx2 s[2:3], s[4:5], s101
// CHECK: [0x82,0x00,0x44,0xc0,0x65,0x00,0x00,0x00]

s_store_dwordx2 s[2:3], s[4:5], flat_scratch_lo
// CHECK: [0x82,0x00,0x44,0xc0,0x66,0x00,0x00,0x00]

s_store_dwordx2 s[2:3], s[4:5], flat_scratch_hi
// CHECK: [0x82,0x00,0x44,0xc0,0x67,0x00,0x00,0x00]

s_store_dwordx2 s[2:3], s[4:5], vcc_lo
// CHECK: [0x82,0x00,0x44,0xc0,0x6a,0x00,0x00,0x00]

s_store_dwordx2 s[2:3], s[4:5], vcc_hi
// CHECK: [0x82,0x00,0x44,0xc0,0x6b,0x00,0x00,0x00]

s_store_dwordx2 s[2:3], s[4:5], ttmp15
// CHECK: [0x82,0x00,0x44,0xc0,0x7b,0x00,0x00,0x00]

s_store_dwordx2 s[2:3], s[4:5], m0
// CHECK: [0x82,0x00,0x44,0xc0,0x7c,0x00,0x00,0x00]

s_store_dwordx2 s[2:3], s[4:5], 0x0
// CHECK: [0x82,0x00,0x46,0xc0,0x00,0x00,0x00,0x00]

s_store_dwordx2 s[2:3], s[4:5], s0 glc
// CHECK: [0x82,0x00,0x45,0xc0,0x00,0x00,0x00,0x00]

s_store_dwordx4 s[4:7], s[4:5], s0
// CHECK: [0x02,0x01,0x48,0xc0,0x00,0x00,0x00,0x00]

s_store_dwordx4 s[8:11], s[4:5], s0
// CHECK: [0x02,0x02,0x48,0xc0,0x00,0x00,0x00,0x00]

s_store_dwordx4 s[96:99], s[4:5], s0
// CHECK: [0x02,0x18,0x48,0xc0,0x00,0x00,0x00,0x00]

s_store_dwordx4 ttmp[12:15], s[4:5], s0
// CHECK: [0x02,0x1e,0x48,0xc0,0x00,0x00,0x00,0x00]

s_store_dwordx4 s[4:7], s[6:7], s0
// CHECK: [0x03,0x01,0x48,0xc0,0x00,0x00,0x00,0x00]

s_store_dwordx4 s[4:7], s[100:101], s0
// CHECK: [0x32,0x01,0x48,0xc0,0x00,0x00,0x00,0x00]

s_store_dwordx4 s[4:7], flat_scratch, s0
// CHECK: [0x33,0x01,0x48,0xc0,0x00,0x00,0x00,0x00]

s_store_dwordx4 s[4:7], vcc, s0
// CHECK: [0x35,0x01,0x48,0xc0,0x00,0x00,0x00,0x00]

s_store_dwordx4 s[4:7], ttmp[14:15], s0
// CHECK: [0x3d,0x01,0x48,0xc0,0x00,0x00,0x00,0x00]

s_store_dwordx4 s[4:7], s[4:5], s101
// CHECK: [0x02,0x01,0x48,0xc0,0x65,0x00,0x00,0x00]

s_store_dwordx4 s[4:7], s[4:5], flat_scratch_lo
// CHECK: [0x02,0x01,0x48,0xc0,0x66,0x00,0x00,0x00]

s_store_dwordx4 s[4:7], s[4:5], flat_scratch_hi
// CHECK: [0x02,0x01,0x48,0xc0,0x67,0x00,0x00,0x00]

s_store_dwordx4 s[4:7], s[4:5], vcc_lo
// CHECK: [0x02,0x01,0x48,0xc0,0x6a,0x00,0x00,0x00]

s_store_dwordx4 s[4:7], s[4:5], vcc_hi
// CHECK: [0x02,0x01,0x48,0xc0,0x6b,0x00,0x00,0x00]

s_store_dwordx4 s[4:7], s[4:5], ttmp15
// CHECK: [0x02,0x01,0x48,0xc0,0x7b,0x00,0x00,0x00]

s_store_dwordx4 s[4:7], s[4:5], m0
// CHECK: [0x02,0x01,0x48,0xc0,0x7c,0x00,0x00,0x00]

s_store_dwordx4 s[4:7], s[4:5], 0x0
// CHECK: [0x02,0x01,0x4a,0xc0,0x00,0x00,0x00,0x00]

s_store_dwordx4 s[4:7], s[4:5], s0 glc
// CHECK: [0x02,0x01,0x49,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dword s1, s[4:5], s0
// CHECK: [0x42,0x00,0x54,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dword s101, s[4:5], s0
// CHECK: [0x42,0x19,0x54,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dword flat_scratch_lo, s[4:5], s0
// CHECK: [0x82,0x19,0x54,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dword flat_scratch_hi, s[4:5], s0
// CHECK: [0xc2,0x19,0x54,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dword vcc_lo, s[4:5], s0
// CHECK: [0x82,0x1a,0x54,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dword vcc_hi, s[4:5], s0
// CHECK: [0xc2,0x1a,0x54,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dword ttmp15, s[4:5], s0
// CHECK: [0xc2,0x1e,0x54,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dword s1, s[6:7], s0
// CHECK: [0x43,0x00,0x54,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dword s1, s[100:101], s0
// CHECK: [0x72,0x00,0x54,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dword s1, flat_scratch, s0
// CHECK: [0x73,0x00,0x54,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dword s1, vcc, s0
// CHECK: [0x75,0x00,0x54,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dword s1, ttmp[14:15], s0
// CHECK: [0x7d,0x00,0x54,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dword s1, s[4:5], s101
// CHECK: [0x42,0x00,0x54,0xc0,0x65,0x00,0x00,0x00]

s_scratch_store_dword s1, s[4:5], flat_scratch_lo
// CHECK: [0x42,0x00,0x54,0xc0,0x66,0x00,0x00,0x00]

s_scratch_store_dword s1, s[4:5], flat_scratch_hi
// CHECK: [0x42,0x00,0x54,0xc0,0x67,0x00,0x00,0x00]

s_scratch_store_dword s1, s[4:5], vcc_lo
// CHECK: [0x42,0x00,0x54,0xc0,0x6a,0x00,0x00,0x00]

s_scratch_store_dword s1, s[4:5], vcc_hi
// CHECK: [0x42,0x00,0x54,0xc0,0x6b,0x00,0x00,0x00]

s_scratch_store_dword s1, s[4:5], ttmp15
// CHECK: [0x42,0x00,0x54,0xc0,0x7b,0x00,0x00,0x00]

s_scratch_store_dword s1, s[4:5], m0
// CHECK: [0x42,0x00,0x54,0xc0,0x7c,0x00,0x00,0x00]

s_scratch_store_dword s1, s[4:5], 0x0
// CHECK: [0x42,0x00,0x56,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dword s1, s[4:5], s0 glc
// CHECK: [0x42,0x00,0x55,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dwordx2 s[2:3], s[4:5], s0
// CHECK: [0x82,0x00,0x58,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dwordx2 s[4:5], s[4:5], s0
// CHECK: [0x02,0x01,0x58,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dwordx2 s[100:101], s[4:5], s0
// CHECK: [0x02,0x19,0x58,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dwordx2 flat_scratch, s[4:5], s0
// CHECK: [0x82,0x19,0x58,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dwordx2 vcc, s[4:5], s0
// CHECK: [0x82,0x1a,0x58,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dwordx2 ttmp[14:15], s[4:5], s0
// CHECK: [0x82,0x1e,0x58,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dwordx2 s[2:3], s[6:7], s0
// CHECK: [0x83,0x00,0x58,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dwordx2 s[2:3], s[100:101], s0
// CHECK: [0xb2,0x00,0x58,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dwordx2 s[2:3], flat_scratch, s0
// CHECK: [0xb3,0x00,0x58,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dwordx2 s[2:3], vcc, s0
// CHECK: [0xb5,0x00,0x58,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dwordx2 s[2:3], ttmp[14:15], s0
// CHECK: [0xbd,0x00,0x58,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dwordx2 s[2:3], s[4:5], s101
// CHECK: [0x82,0x00,0x58,0xc0,0x65,0x00,0x00,0x00]

s_scratch_store_dwordx2 s[2:3], s[4:5], flat_scratch_lo
// CHECK: [0x82,0x00,0x58,0xc0,0x66,0x00,0x00,0x00]

s_scratch_store_dwordx2 s[2:3], s[4:5], flat_scratch_hi
// CHECK: [0x82,0x00,0x58,0xc0,0x67,0x00,0x00,0x00]

s_scratch_store_dwordx2 s[2:3], s[4:5], vcc_lo
// CHECK: [0x82,0x00,0x58,0xc0,0x6a,0x00,0x00,0x00]

s_scratch_store_dwordx2 s[2:3], s[4:5], vcc_hi
// CHECK: [0x82,0x00,0x58,0xc0,0x6b,0x00,0x00,0x00]

s_scratch_store_dwordx2 s[2:3], s[4:5], ttmp15
// CHECK: [0x82,0x00,0x58,0xc0,0x7b,0x00,0x00,0x00]

s_scratch_store_dwordx2 s[2:3], s[4:5], m0
// CHECK: [0x82,0x00,0x58,0xc0,0x7c,0x00,0x00,0x00]

s_scratch_store_dwordx2 s[2:3], s[4:5], 0x0
// CHECK: [0x82,0x00,0x5a,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dwordx2 s[2:3], s[4:5], s0 glc
// CHECK: [0x82,0x00,0x59,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dwordx4 s[4:7], s[4:5], s0
// CHECK: [0x02,0x01,0x5c,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dwordx4 s[8:11], s[4:5], s0
// CHECK: [0x02,0x02,0x5c,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dwordx4 s[96:99], s[4:5], s0
// CHECK: [0x02,0x18,0x5c,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dwordx4 ttmp[12:15], s[4:5], s0
// CHECK: [0x02,0x1e,0x5c,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dwordx4 s[4:7], s[6:7], s0
// CHECK: [0x03,0x01,0x5c,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dwordx4 s[4:7], s[100:101], s0
// CHECK: [0x32,0x01,0x5c,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dwordx4 s[4:7], flat_scratch, s0
// CHECK: [0x33,0x01,0x5c,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dwordx4 s[4:7], vcc, s0
// CHECK: [0x35,0x01,0x5c,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dwordx4 s[4:7], ttmp[14:15], s0
// CHECK: [0x3d,0x01,0x5c,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dwordx4 s[4:7], s[4:5], s101
// CHECK: [0x02,0x01,0x5c,0xc0,0x65,0x00,0x00,0x00]

s_scratch_store_dwordx4 s[4:7], s[4:5], flat_scratch_lo
// CHECK: [0x02,0x01,0x5c,0xc0,0x66,0x00,0x00,0x00]

s_scratch_store_dwordx4 s[4:7], s[4:5], flat_scratch_hi
// CHECK: [0x02,0x01,0x5c,0xc0,0x67,0x00,0x00,0x00]

s_scratch_store_dwordx4 s[4:7], s[4:5], vcc_lo
// CHECK: [0x02,0x01,0x5c,0xc0,0x6a,0x00,0x00,0x00]

s_scratch_store_dwordx4 s[4:7], s[4:5], vcc_hi
// CHECK: [0x02,0x01,0x5c,0xc0,0x6b,0x00,0x00,0x00]

s_scratch_store_dwordx4 s[4:7], s[4:5], ttmp15
// CHECK: [0x02,0x01,0x5c,0xc0,0x7b,0x00,0x00,0x00]

s_scratch_store_dwordx4 s[4:7], s[4:5], m0
// CHECK: [0x02,0x01,0x5c,0xc0,0x7c,0x00,0x00,0x00]

s_scratch_store_dwordx4 s[4:7], s[4:5], 0x0
// CHECK: [0x02,0x01,0x5e,0xc0,0x00,0x00,0x00,0x00]

s_scratch_store_dwordx4 s[4:7], s[4:5], s0 glc
// CHECK: [0x02,0x01,0x5d,0xc0,0x00,0x00,0x00,0x00]

s_buffer_store_dword s1, s[8:11], s0
// CHECK: [0x44,0x00,0x60,0xc0,0x00,0x00,0x00,0x00]

s_buffer_store_dword s101, s[8:11], s0
// CHECK: [0x44,0x19,0x60,0xc0,0x00,0x00,0x00,0x00]

s_buffer_store_dword flat_scratch_lo, s[8:11], s0
// CHECK: [0x84,0x19,0x60,0xc0,0x00,0x00,0x00,0x00]

s_buffer_store_dword flat_scratch_hi, s[8:11], s0
// CHECK: [0xc4,0x19,0x60,0xc0,0x00,0x00,0x00,0x00]

s_buffer_store_dword vcc_lo, s[8:11], s0
// CHECK: [0x84,0x1a,0x60,0xc0,0x00,0x00,0x00,0x00]

s_buffer_store_dword vcc_hi, s[8:11], s0
// CHECK: [0xc4,0x1a,0x60,0xc0,0x00,0x00,0x00,0x00]

s_buffer_store_dword ttmp15, s[8:11], s0
// CHECK: [0xc4,0x1e,0x60,0xc0,0x00,0x00,0x00,0x00]

s_buffer_store_dword s1, s[12:15], s0
// CHECK: [0x46,0x00,0x60,0xc0,0x00,0x00,0x00,0x00]

s_buffer_store_dword s1, s[96:99], s0
// CHECK: [0x70,0x00,0x60,0xc0,0x00,0x00,0x00,0x00]

s_buffer_store_dword s1, ttmp[12:15], s0
// CHECK: [0x7c,0x00,0x60,0xc0,0x00,0x00,0x00,0x00]

s_buffer_store_dword s1, s[8:11], s101
// CHECK: [0x44,0x00,0x60,0xc0,0x65,0x00,0x00,0x00]

s_buffer_store_dword s1, s[8:11], flat_scratch_lo
// CHECK: [0x44,0x00,0x60,0xc0,0x66,0x00,0x00,0x00]

s_buffer_store_dword s1, s[8:11], flat_scratch_hi
// CHECK: [0x44,0x00,0x60,0xc0,0x67,0x00,0x00,0x00]

s_buffer_store_dword s1, s[8:11], vcc_lo
// CHECK: [0x44,0x00,0x60,0xc0,0x6a,0x00,0x00,0x00]

s_buffer_store_dword s1, s[8:11], vcc_hi
// CHECK: [0x44,0x00,0x60,0xc0,0x6b,0x00,0x00,0x00]

s_buffer_store_dword s1, s[8:11], ttmp15
// CHECK: [0x44,0x00,0x60,0xc0,0x7b,0x00,0x00,0x00]

s_buffer_store_dword s1, s[8:11], m0
// CHECK: [0x44,0x00,0x60,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dword s1, s[8:11], 0x0
// CHECK: [0x44,0x00,0x62,0xc0,0x00,0x00,0x00,0x00]

s_buffer_store_dword s1, s[8:11], s0 glc
// CHECK: [0x44,0x00,0x61,0xc0,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx2 s[2:3], s[8:11], s0
// CHECK: [0x84,0x00,0x64,0xc0,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx2 s[4:5], s[8:11], s0
// CHECK: [0x04,0x01,0x64,0xc0,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx2 s[100:101], s[8:11], s0
// CHECK: [0x04,0x19,0x64,0xc0,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx2 flat_scratch, s[8:11], s0
// CHECK: [0x84,0x19,0x64,0xc0,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx2 vcc, s[8:11], s0
// CHECK: [0x84,0x1a,0x64,0xc0,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx2 ttmp[14:15], s[8:11], s0
// CHECK: [0x84,0x1e,0x64,0xc0,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx2 s[2:3], s[12:15], s0
// CHECK: [0x86,0x00,0x64,0xc0,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx2 s[2:3], s[96:99], s0
// CHECK: [0xb0,0x00,0x64,0xc0,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx2 s[2:3], ttmp[12:15], s0
// CHECK: [0xbc,0x00,0x64,0xc0,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx2 s[2:3], s[8:11], s101
// CHECK: [0x84,0x00,0x64,0xc0,0x65,0x00,0x00,0x00]

s_buffer_store_dwordx2 s[2:3], s[8:11], flat_scratch_lo
// CHECK: [0x84,0x00,0x64,0xc0,0x66,0x00,0x00,0x00]

s_buffer_store_dwordx2 s[2:3], s[8:11], flat_scratch_hi
// CHECK: [0x84,0x00,0x64,0xc0,0x67,0x00,0x00,0x00]

s_buffer_store_dwordx2 s[2:3], s[8:11], vcc_lo
// CHECK: [0x84,0x00,0x64,0xc0,0x6a,0x00,0x00,0x00]

s_buffer_store_dwordx2 s[2:3], s[8:11], vcc_hi
// CHECK: [0x84,0x00,0x64,0xc0,0x6b,0x00,0x00,0x00]

s_buffer_store_dwordx2 s[2:3], s[8:11], ttmp15
// CHECK: [0x84,0x00,0x64,0xc0,0x7b,0x00,0x00,0x00]

s_buffer_store_dwordx2 s[2:3], s[8:11], m0
// CHECK: [0x84,0x00,0x64,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dwordx2 s[2:3], s[8:11], 0x0
// CHECK: [0x84,0x00,0x66,0xc0,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx2 s[2:3], s[8:11], s0 glc
// CHECK: [0x84,0x00,0x65,0xc0,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx4 s[4:7], s[8:11], s0
// CHECK: [0x04,0x01,0x68,0xc0,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx4 s[8:11], s[8:11], s0
// CHECK: [0x04,0x02,0x68,0xc0,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx4 s[96:99], s[8:11], s0
// CHECK: [0x04,0x18,0x68,0xc0,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx4 ttmp[12:15], s[8:11], s0
// CHECK: [0x04,0x1e,0x68,0xc0,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx4 s[4:7], s[12:15], s0
// CHECK: [0x06,0x01,0x68,0xc0,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx4 s[4:7], s[96:99], s0
// CHECK: [0x30,0x01,0x68,0xc0,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx4 s[4:7], ttmp[12:15], s0
// CHECK: [0x3c,0x01,0x68,0xc0,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx4 s[4:7], s[8:11], s101
// CHECK: [0x04,0x01,0x68,0xc0,0x65,0x00,0x00,0x00]

s_buffer_store_dwordx4 s[4:7], s[8:11], flat_scratch_lo
// CHECK: [0x04,0x01,0x68,0xc0,0x66,0x00,0x00,0x00]

s_buffer_store_dwordx4 s[4:7], s[8:11], flat_scratch_hi
// CHECK: [0x04,0x01,0x68,0xc0,0x67,0x00,0x00,0x00]

s_buffer_store_dwordx4 s[4:7], s[8:11], vcc_lo
// CHECK: [0x04,0x01,0x68,0xc0,0x6a,0x00,0x00,0x00]

s_buffer_store_dwordx4 s[4:7], s[8:11], vcc_hi
// CHECK: [0x04,0x01,0x68,0xc0,0x6b,0x00,0x00,0x00]

s_buffer_store_dwordx4 s[4:7], s[8:11], ttmp15
// CHECK: [0x04,0x01,0x68,0xc0,0x7b,0x00,0x00,0x00]

s_buffer_store_dwordx4 s[4:7], s[8:11], m0
// CHECK: [0x04,0x01,0x68,0xc0,0x7c,0x00,0x00,0x00]

s_buffer_store_dwordx4 s[4:7], s[8:11], 0x0
// CHECK: [0x04,0x01,0x6a,0xc0,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx4 s[4:7], s[8:11], s0 glc
// CHECK: [0x04,0x01,0x69,0xc0,0x00,0x00,0x00,0x00]

s_dcache_inv
// CHECK: [0x00,0x00,0x80,0xc0,0x00,0x00,0x00,0x00]

s_dcache_wb
// CHECK: [0x00,0x00,0x84,0xc0,0x00,0x00,0x00,0x00]

s_dcache_inv_vol
// CHECK: [0x00,0x00,0x88,0xc0,0x00,0x00,0x00,0x00]

s_dcache_wb_vol
// CHECK: [0x00,0x00,0x8c,0xc0,0x00,0x00,0x00,0x00]

s_memtime s[10:11]
// CHECK: [0x80,0x02,0x90,0xc0,0x00,0x00,0x00,0x00]

s_memtime s[12:13]
// CHECK: [0x00,0x03,0x90,0xc0,0x00,0x00,0x00,0x00]

s_memtime s[100:101]
// CHECK: [0x00,0x19,0x90,0xc0,0x00,0x00,0x00,0x00]

s_memtime flat_scratch
// CHECK: [0x80,0x19,0x90,0xc0,0x00,0x00,0x00,0x00]

s_memtime vcc
// CHECK: [0x80,0x1a,0x90,0xc0,0x00,0x00,0x00,0x00]

s_memtime ttmp[14:15]
// CHECK: [0x80,0x1e,0x90,0xc0,0x00,0x00,0x00,0x00]

s_memrealtime s[10:11]
// CHECK: [0x80,0x02,0x94,0xc0,0x00,0x00,0x00,0x00]

s_memrealtime s[12:13]
// CHECK: [0x00,0x03,0x94,0xc0,0x00,0x00,0x00,0x00]

s_memrealtime s[100:101]
// CHECK: [0x00,0x19,0x94,0xc0,0x00,0x00,0x00,0x00]

s_memrealtime flat_scratch
// CHECK: [0x80,0x19,0x94,0xc0,0x00,0x00,0x00,0x00]

s_memrealtime vcc
// CHECK: [0x80,0x1a,0x94,0xc0,0x00,0x00,0x00,0x00]

s_memrealtime ttmp[14:15]
// CHECK: [0x80,0x1e,0x94,0xc0,0x00,0x00,0x00,0x00]

s_atc_probe 0x0, s[4:5], s0
// CHECK: [0x02,0x00,0x98,0xc0,0x00,0x00,0x00,0x00]

s_atc_probe 0x1, s[4:5], s0
// CHECK: [0x42,0x00,0x98,0xc0,0x00,0x00,0x00,0x00]

s_atc_probe 0x7, s[4:5], s0
// CHECK: [0xc2,0x01,0x98,0xc0,0x00,0x00,0x00,0x00]

s_atc_probe 0x0, s[6:7], s0
// CHECK: [0x03,0x00,0x98,0xc0,0x00,0x00,0x00,0x00]

s_atc_probe 0x0, s[100:101], s0
// CHECK: [0x32,0x00,0x98,0xc0,0x00,0x00,0x00,0x00]

s_atc_probe 0x0, flat_scratch, s0
// CHECK: [0x33,0x00,0x98,0xc0,0x00,0x00,0x00,0x00]

s_atc_probe 0x0, vcc, s0
// CHECK: [0x35,0x00,0x98,0xc0,0x00,0x00,0x00,0x00]

s_atc_probe 0x0, ttmp[14:15], s0
// CHECK: [0x3d,0x00,0x98,0xc0,0x00,0x00,0x00,0x00]

s_atc_probe 0x0, s[4:5], s101
// CHECK: [0x02,0x00,0x98,0xc0,0x65,0x00,0x00,0x00]

s_atc_probe 0x0, s[4:5], flat_scratch_lo
// CHECK: [0x02,0x00,0x98,0xc0,0x66,0x00,0x00,0x00]

s_atc_probe 0x0, s[4:5], flat_scratch_hi
// CHECK: [0x02,0x00,0x98,0xc0,0x67,0x00,0x00,0x00]

s_atc_probe 0x0, s[4:5], vcc_lo
// CHECK: [0x02,0x00,0x98,0xc0,0x6a,0x00,0x00,0x00]

s_atc_probe 0x0, s[4:5], vcc_hi
// CHECK: [0x02,0x00,0x98,0xc0,0x6b,0x00,0x00,0x00]

s_atc_probe 0x0, s[4:5], ttmp15
// CHECK: [0x02,0x00,0x98,0xc0,0x7b,0x00,0x00,0x00]

s_atc_probe 0x0, s[4:5], m0
// CHECK: [0x02,0x00,0x98,0xc0,0x7c,0x00,0x00,0x00]

s_atc_probe 0x0, s[4:5], 0x0
// CHECK: [0x02,0x00,0x9a,0xc0,0x00,0x00,0x00,0x00]

s_atc_probe 0x0, s[4:5], s7 offset:0x12345
// CHECK: [0x02,0x40,0x9a,0xc0,0x45,0x23,0x01,0x0e]

s_atc_probe_buffer 0x0, s[8:11], s0
// CHECK: [0x04,0x00,0x9c,0xc0,0x00,0x00,0x00,0x00]

s_atc_probe_buffer 0x1, s[8:11], s0
// CHECK: [0x44,0x00,0x9c,0xc0,0x00,0x00,0x00,0x00]

s_atc_probe_buffer 0x7, s[8:11], s0
// CHECK: [0xc4,0x01,0x9c,0xc0,0x00,0x00,0x00,0x00]

s_atc_probe_buffer 0x0, s[12:15], s0
// CHECK: [0x06,0x00,0x9c,0xc0,0x00,0x00,0x00,0x00]

s_atc_probe_buffer 0x0, s[96:99], s0
// CHECK: [0x30,0x00,0x9c,0xc0,0x00,0x00,0x00,0x00]

s_atc_probe_buffer 0x0, ttmp[12:15], s0
// CHECK: [0x3c,0x00,0x9c,0xc0,0x00,0x00,0x00,0x00]

s_atc_probe_buffer 0x0, s[8:11], s101
// CHECK: [0x04,0x00,0x9c,0xc0,0x65,0x00,0x00,0x00]

s_atc_probe_buffer 0x0, s[8:11], flat_scratch_lo
// CHECK: [0x04,0x00,0x9c,0xc0,0x66,0x00,0x00,0x00]

s_atc_probe_buffer 0x0, s[8:11], flat_scratch_hi
// CHECK: [0x04,0x00,0x9c,0xc0,0x67,0x00,0x00,0x00]

s_atc_probe_buffer 0x0, s[8:11], vcc_lo
// CHECK: [0x04,0x00,0x9c,0xc0,0x6a,0x00,0x00,0x00]

s_atc_probe_buffer 0x0, s[8:11], vcc_hi
// CHECK: [0x04,0x00,0x9c,0xc0,0x6b,0x00,0x00,0x00]

s_atc_probe_buffer 0x0, s[8:11], ttmp15
// CHECK: [0x04,0x00,0x9c,0xc0,0x7b,0x00,0x00,0x00]

s_atc_probe_buffer 0x0, s[8:11], m0
// CHECK: [0x04,0x00,0x9c,0xc0,0x7c,0x00,0x00,0x00]

s_atc_probe_buffer 0x0, s[8:11], 0x0
// CHECK: [0x04,0x00,0x9e,0xc0,0x00,0x00,0x00,0x00]

s_atc_probe_buffer 0x0, s[8:11], s7 offset:0x12345
// CHECK: [0x04,0x40,0x9e,0xc0,0x45,0x23,0x01,0x0e]

s_dcache_discard s[2:3], s0
// CHECK: [0x01,0x00,0xa0,0xc0,0x00,0x00,0x00,0x00]

s_dcache_discard s[4:5], s0
// CHECK: [0x02,0x00,0xa0,0xc0,0x00,0x00,0x00,0x00]

s_dcache_discard s[100:101], s0
// CHECK: [0x32,0x00,0xa0,0xc0,0x00,0x00,0x00,0x00]

s_dcache_discard flat_scratch, s0
// CHECK: [0x33,0x00,0xa0,0xc0,0x00,0x00,0x00,0x00]

s_dcache_discard vcc, s0
// CHECK: [0x35,0x00,0xa0,0xc0,0x00,0x00,0x00,0x00]

s_dcache_discard ttmp[14:15], s0
// CHECK: [0x3d,0x00,0xa0,0xc0,0x00,0x00,0x00,0x00]

s_dcache_discard s[2:3], s101
// CHECK: [0x01,0x00,0xa0,0xc0,0x65,0x00,0x00,0x00]

s_dcache_discard s[2:3], flat_scratch_lo
// CHECK: [0x01,0x00,0xa0,0xc0,0x66,0x00,0x00,0x00]

s_dcache_discard s[2:3], flat_scratch_hi
// CHECK: [0x01,0x00,0xa0,0xc0,0x67,0x00,0x00,0x00]

s_dcache_discard s[2:3], vcc_lo
// CHECK: [0x01,0x00,0xa0,0xc0,0x6a,0x00,0x00,0x00]

s_dcache_discard s[2:3], vcc_hi
// CHECK: [0x01,0x00,0xa0,0xc0,0x6b,0x00,0x00,0x00]

s_dcache_discard s[2:3], ttmp15
// CHECK: [0x01,0x00,0xa0,0xc0,0x7b,0x00,0x00,0x00]

s_dcache_discard s[2:3], m0
// CHECK: [0x01,0x00,0xa0,0xc0,0x7c,0x00,0x00,0x00]

s_dcache_discard s[2:3], 0x0
// CHECK: [0x01,0x00,0xa2,0xc0,0x00,0x00,0x00,0x00]

s_dcache_discard s[2:3], s7 offset:0x0
// CHECK: [0x01,0x40,0xa2,0xc0,0x00,0x00,0x00,0x0e]

s_dcache_discard_x2 s[2:3], s0
// CHECK: [0x01,0x00,0xa4,0xc0,0x00,0x00,0x00,0x00]

s_dcache_discard_x2 s[4:5], s0
// CHECK: [0x02,0x00,0xa4,0xc0,0x00,0x00,0x00,0x00]

s_dcache_discard_x2 s[100:101], s0
// CHECK: [0x32,0x00,0xa4,0xc0,0x00,0x00,0x00,0x00]

s_dcache_discard_x2 flat_scratch, s0
// CHECK: [0x33,0x00,0xa4,0xc0,0x00,0x00,0x00,0x00]

s_dcache_discard_x2 vcc, s0
// CHECK: [0x35,0x00,0xa4,0xc0,0x00,0x00,0x00,0x00]

s_dcache_discard_x2 ttmp[14:15], s0
// CHECK: [0x3d,0x00,0xa4,0xc0,0x00,0x00,0x00,0x00]

s_dcache_discard_x2 s[2:3], s101
// CHECK: [0x01,0x00,0xa4,0xc0,0x65,0x00,0x00,0x00]

s_dcache_discard_x2 s[2:3], flat_scratch_lo
// CHECK: [0x01,0x00,0xa4,0xc0,0x66,0x00,0x00,0x00]

s_dcache_discard_x2 s[2:3], flat_scratch_hi
// CHECK: [0x01,0x00,0xa4,0xc0,0x67,0x00,0x00,0x00]

s_dcache_discard_x2 s[2:3], vcc_lo
// CHECK: [0x01,0x00,0xa4,0xc0,0x6a,0x00,0x00,0x00]

s_dcache_discard_x2 s[2:3], vcc_hi
// CHECK: [0x01,0x00,0xa4,0xc0,0x6b,0x00,0x00,0x00]

s_dcache_discard_x2 s[2:3], ttmp15
// CHECK: [0x01,0x00,0xa4,0xc0,0x7b,0x00,0x00,0x00]

s_dcache_discard_x2 s[2:3], m0
// CHECK: [0x01,0x00,0xa4,0xc0,0x7c,0x00,0x00,0x00]

s_dcache_discard_x2 s[2:3], 0x0
// CHECK: [0x01,0x00,0xa6,0xc0,0x00,0x00,0x00,0x00]

s_dcache_discard_x2 s[2:3], s7 offset:0x0
// CHECK: [0x01,0x40,0xa6,0xc0,0x00,0x00,0x00,0x0e]

s_buffer_atomic_swap s5, s[4:7], s0
// CHECK: [0x42,0x01,0x00,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_swap s101, s[4:7], s0
// CHECK: [0x42,0x19,0x00,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_swap flat_scratch_lo, s[4:7], s0
// CHECK: [0x82,0x19,0x00,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_swap flat_scratch_hi, s[4:7], s0
// CHECK: [0xc2,0x19,0x00,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_swap vcc_lo, s[4:7], s0
// CHECK: [0x82,0x1a,0x00,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_swap vcc_hi, s[4:7], s0
// CHECK: [0xc2,0x1a,0x00,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_swap ttmp15, s[4:7], s0
// CHECK: [0xc2,0x1e,0x00,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_swap s5, s[8:11], s0
// CHECK: [0x44,0x01,0x00,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_swap s5, s[96:99], s0
// CHECK: [0x70,0x01,0x00,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_swap s5, ttmp[12:15], s0
// CHECK: [0x7c,0x01,0x00,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_swap s5, s[4:7], s101
// CHECK: [0x42,0x01,0x00,0xc1,0x65,0x00,0x00,0x00]

s_buffer_atomic_swap s5, s[4:7], flat_scratch_lo
// CHECK: [0x42,0x01,0x00,0xc1,0x66,0x00,0x00,0x00]

s_buffer_atomic_swap s5, s[4:7], flat_scratch_hi
// CHECK: [0x42,0x01,0x00,0xc1,0x67,0x00,0x00,0x00]

s_buffer_atomic_swap s5, s[4:7], vcc_lo
// CHECK: [0x42,0x01,0x00,0xc1,0x6a,0x00,0x00,0x00]

s_buffer_atomic_swap s5, s[4:7], vcc_hi
// CHECK: [0x42,0x01,0x00,0xc1,0x6b,0x00,0x00,0x00]

s_buffer_atomic_swap s5, s[4:7], ttmp15
// CHECK: [0x42,0x01,0x00,0xc1,0x7b,0x00,0x00,0x00]

s_buffer_atomic_swap s5, s[4:7], m0
// CHECK: [0x42,0x01,0x00,0xc1,0x7c,0x00,0x00,0x00]

s_buffer_atomic_swap s5, s[4:7], 0x0
// CHECK: [0x42,0x01,0x02,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_swap s5, s[4:7], s0 glc
// CHECK: [0x42,0x01,0x01,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_cmpswap s[10:11], s[4:7], s0
// CHECK: [0x82,0x02,0x04,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_cmpswap s[12:13], s[4:7], s0
// CHECK: [0x02,0x03,0x04,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_cmpswap s[100:101], s[4:7], s0
// CHECK: [0x02,0x19,0x04,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_cmpswap flat_scratch, s[4:7], s0
// CHECK: [0x82,0x19,0x04,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_cmpswap vcc, s[4:7], s0
// CHECK: [0x82,0x1a,0x04,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_cmpswap ttmp[14:15], s[4:7], s0
// CHECK: [0x82,0x1e,0x04,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_cmpswap s[10:11], s[8:11], s0
// CHECK: [0x84,0x02,0x04,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_cmpswap s[10:11], s[96:99], s0
// CHECK: [0xb0,0x02,0x04,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_cmpswap s[10:11], ttmp[12:15], s0
// CHECK: [0xbc,0x02,0x04,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_cmpswap s[10:11], s[4:7], s101
// CHECK: [0x82,0x02,0x04,0xc1,0x65,0x00,0x00,0x00]

s_buffer_atomic_cmpswap s[10:11], s[4:7], flat_scratch_lo
// CHECK: [0x82,0x02,0x04,0xc1,0x66,0x00,0x00,0x00]

s_buffer_atomic_cmpswap s[10:11], s[4:7], flat_scratch_hi
// CHECK: [0x82,0x02,0x04,0xc1,0x67,0x00,0x00,0x00]

s_buffer_atomic_cmpswap s[10:11], s[4:7], vcc_lo
// CHECK: [0x82,0x02,0x04,0xc1,0x6a,0x00,0x00,0x00]

s_buffer_atomic_cmpswap s[10:11], s[4:7], vcc_hi
// CHECK: [0x82,0x02,0x04,0xc1,0x6b,0x00,0x00,0x00]

s_buffer_atomic_cmpswap s[10:11], s[4:7], ttmp15
// CHECK: [0x82,0x02,0x04,0xc1,0x7b,0x00,0x00,0x00]

s_buffer_atomic_cmpswap s[10:11], s[4:7], m0
// CHECK: [0x82,0x02,0x04,0xc1,0x7c,0x00,0x00,0x00]

s_buffer_atomic_cmpswap s[10:11], s[4:7], 0x0
// CHECK: [0x82,0x02,0x06,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_cmpswap s[10:11], s[4:7], s0 glc
// CHECK: [0x82,0x02,0x05,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_add s5, s[4:7], s0
// CHECK: [0x42,0x01,0x08,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_add s101, s[4:7], s0
// CHECK: [0x42,0x19,0x08,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_add flat_scratch_lo, s[4:7], s0
// CHECK: [0x82,0x19,0x08,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_add flat_scratch_hi, s[4:7], s0
// CHECK: [0xc2,0x19,0x08,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_add vcc_lo, s[4:7], s0
// CHECK: [0x82,0x1a,0x08,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_add vcc_hi, s[4:7], s0
// CHECK: [0xc2,0x1a,0x08,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_add ttmp15, s[4:7], s0
// CHECK: [0xc2,0x1e,0x08,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_add s5, s[8:11], s0
// CHECK: [0x44,0x01,0x08,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_add s5, s[96:99], s0
// CHECK: [0x70,0x01,0x08,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_add s5, ttmp[12:15], s0
// CHECK: [0x7c,0x01,0x08,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_add s5, s[4:7], s101
// CHECK: [0x42,0x01,0x08,0xc1,0x65,0x00,0x00,0x00]

s_buffer_atomic_add s5, s[4:7], flat_scratch_lo
// CHECK: [0x42,0x01,0x08,0xc1,0x66,0x00,0x00,0x00]

s_buffer_atomic_add s5, s[4:7], flat_scratch_hi
// CHECK: [0x42,0x01,0x08,0xc1,0x67,0x00,0x00,0x00]

s_buffer_atomic_add s5, s[4:7], vcc_lo
// CHECK: [0x42,0x01,0x08,0xc1,0x6a,0x00,0x00,0x00]

s_buffer_atomic_add s5, s[4:7], vcc_hi
// CHECK: [0x42,0x01,0x08,0xc1,0x6b,0x00,0x00,0x00]

s_buffer_atomic_add s5, s[4:7], ttmp15
// CHECK: [0x42,0x01,0x08,0xc1,0x7b,0x00,0x00,0x00]

s_buffer_atomic_add s5, s[4:7], m0
// CHECK: [0x42,0x01,0x08,0xc1,0x7c,0x00,0x00,0x00]

s_buffer_atomic_add s5, s[4:7], 0x0
// CHECK: [0x42,0x01,0x0a,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_add s5, s[4:7], s0 glc
// CHECK: [0x42,0x01,0x09,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_sub s5, s[4:7], s0
// CHECK: [0x42,0x01,0x0c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_sub s101, s[4:7], s0
// CHECK: [0x42,0x19,0x0c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_sub flat_scratch_lo, s[4:7], s0
// CHECK: [0x82,0x19,0x0c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_sub flat_scratch_hi, s[4:7], s0
// CHECK: [0xc2,0x19,0x0c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_sub vcc_lo, s[4:7], s0
// CHECK: [0x82,0x1a,0x0c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_sub vcc_hi, s[4:7], s0
// CHECK: [0xc2,0x1a,0x0c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_sub ttmp15, s[4:7], s0
// CHECK: [0xc2,0x1e,0x0c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_sub s5, s[8:11], s0
// CHECK: [0x44,0x01,0x0c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_sub s5, s[96:99], s0
// CHECK: [0x70,0x01,0x0c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_sub s5, ttmp[12:15], s0
// CHECK: [0x7c,0x01,0x0c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_sub s5, s[4:7], s101
// CHECK: [0x42,0x01,0x0c,0xc1,0x65,0x00,0x00,0x00]

s_buffer_atomic_sub s5, s[4:7], flat_scratch_lo
// CHECK: [0x42,0x01,0x0c,0xc1,0x66,0x00,0x00,0x00]

s_buffer_atomic_sub s5, s[4:7], flat_scratch_hi
// CHECK: [0x42,0x01,0x0c,0xc1,0x67,0x00,0x00,0x00]

s_buffer_atomic_sub s5, s[4:7], vcc_lo
// CHECK: [0x42,0x01,0x0c,0xc1,0x6a,0x00,0x00,0x00]

s_buffer_atomic_sub s5, s[4:7], vcc_hi
// CHECK: [0x42,0x01,0x0c,0xc1,0x6b,0x00,0x00,0x00]

s_buffer_atomic_sub s5, s[4:7], ttmp15
// CHECK: [0x42,0x01,0x0c,0xc1,0x7b,0x00,0x00,0x00]

s_buffer_atomic_sub s5, s[4:7], m0
// CHECK: [0x42,0x01,0x0c,0xc1,0x7c,0x00,0x00,0x00]

s_buffer_atomic_sub s5, s[4:7], 0x0
// CHECK: [0x42,0x01,0x0e,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_sub s5, s[4:7], s0 glc
// CHECK: [0x42,0x01,0x0d,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smin s5, s[4:7], s0
// CHECK: [0x42,0x01,0x10,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smin s101, s[4:7], s0
// CHECK: [0x42,0x19,0x10,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smin flat_scratch_lo, s[4:7], s0
// CHECK: [0x82,0x19,0x10,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smin flat_scratch_hi, s[4:7], s0
// CHECK: [0xc2,0x19,0x10,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smin vcc_lo, s[4:7], s0
// CHECK: [0x82,0x1a,0x10,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smin vcc_hi, s[4:7], s0
// CHECK: [0xc2,0x1a,0x10,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smin ttmp15, s[4:7], s0
// CHECK: [0xc2,0x1e,0x10,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smin s5, s[8:11], s0
// CHECK: [0x44,0x01,0x10,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smin s5, s[96:99], s0
// CHECK: [0x70,0x01,0x10,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smin s5, ttmp[12:15], s0
// CHECK: [0x7c,0x01,0x10,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smin s5, s[4:7], s101
// CHECK: [0x42,0x01,0x10,0xc1,0x65,0x00,0x00,0x00]

s_buffer_atomic_smin s5, s[4:7], flat_scratch_lo
// CHECK: [0x42,0x01,0x10,0xc1,0x66,0x00,0x00,0x00]

s_buffer_atomic_smin s5, s[4:7], flat_scratch_hi
// CHECK: [0x42,0x01,0x10,0xc1,0x67,0x00,0x00,0x00]

s_buffer_atomic_smin s5, s[4:7], vcc_lo
// CHECK: [0x42,0x01,0x10,0xc1,0x6a,0x00,0x00,0x00]

s_buffer_atomic_smin s5, s[4:7], vcc_hi
// CHECK: [0x42,0x01,0x10,0xc1,0x6b,0x00,0x00,0x00]

s_buffer_atomic_smin s5, s[4:7], ttmp15
// CHECK: [0x42,0x01,0x10,0xc1,0x7b,0x00,0x00,0x00]

s_buffer_atomic_smin s5, s[4:7], m0
// CHECK: [0x42,0x01,0x10,0xc1,0x7c,0x00,0x00,0x00]

s_buffer_atomic_smin s5, s[4:7], 0x0
// CHECK: [0x42,0x01,0x12,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smin s5, s[4:7], s0 glc
// CHECK: [0x42,0x01,0x11,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umin s5, s[4:7], s0
// CHECK: [0x42,0x01,0x14,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umin s101, s[4:7], s0
// CHECK: [0x42,0x19,0x14,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umin flat_scratch_lo, s[4:7], s0
// CHECK: [0x82,0x19,0x14,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umin flat_scratch_hi, s[4:7], s0
// CHECK: [0xc2,0x19,0x14,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umin vcc_lo, s[4:7], s0
// CHECK: [0x82,0x1a,0x14,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umin vcc_hi, s[4:7], s0
// CHECK: [0xc2,0x1a,0x14,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umin ttmp15, s[4:7], s0
// CHECK: [0xc2,0x1e,0x14,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umin s5, s[8:11], s0
// CHECK: [0x44,0x01,0x14,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umin s5, s[96:99], s0
// CHECK: [0x70,0x01,0x14,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umin s5, ttmp[12:15], s0
// CHECK: [0x7c,0x01,0x14,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umin s5, s[4:7], s101
// CHECK: [0x42,0x01,0x14,0xc1,0x65,0x00,0x00,0x00]

s_buffer_atomic_umin s5, s[4:7], flat_scratch_lo
// CHECK: [0x42,0x01,0x14,0xc1,0x66,0x00,0x00,0x00]

s_buffer_atomic_umin s5, s[4:7], flat_scratch_hi
// CHECK: [0x42,0x01,0x14,0xc1,0x67,0x00,0x00,0x00]

s_buffer_atomic_umin s5, s[4:7], vcc_lo
// CHECK: [0x42,0x01,0x14,0xc1,0x6a,0x00,0x00,0x00]

s_buffer_atomic_umin s5, s[4:7], vcc_hi
// CHECK: [0x42,0x01,0x14,0xc1,0x6b,0x00,0x00,0x00]

s_buffer_atomic_umin s5, s[4:7], ttmp15
// CHECK: [0x42,0x01,0x14,0xc1,0x7b,0x00,0x00,0x00]

s_buffer_atomic_umin s5, s[4:7], m0
// CHECK: [0x42,0x01,0x14,0xc1,0x7c,0x00,0x00,0x00]

s_buffer_atomic_umin s5, s[4:7], 0x0
// CHECK: [0x42,0x01,0x16,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umin s5, s[4:7], s0 glc
// CHECK: [0x42,0x01,0x15,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smax s5, s[4:7], s0
// CHECK: [0x42,0x01,0x18,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smax s101, s[4:7], s0
// CHECK: [0x42,0x19,0x18,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smax flat_scratch_lo, s[4:7], s0
// CHECK: [0x82,0x19,0x18,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smax flat_scratch_hi, s[4:7], s0
// CHECK: [0xc2,0x19,0x18,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smax vcc_lo, s[4:7], s0
// CHECK: [0x82,0x1a,0x18,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smax vcc_hi, s[4:7], s0
// CHECK: [0xc2,0x1a,0x18,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smax ttmp15, s[4:7], s0
// CHECK: [0xc2,0x1e,0x18,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smax s5, s[8:11], s0
// CHECK: [0x44,0x01,0x18,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smax s5, s[96:99], s0
// CHECK: [0x70,0x01,0x18,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smax s5, ttmp[12:15], s0
// CHECK: [0x7c,0x01,0x18,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smax s5, s[4:7], s101
// CHECK: [0x42,0x01,0x18,0xc1,0x65,0x00,0x00,0x00]

s_buffer_atomic_smax s5, s[4:7], flat_scratch_lo
// CHECK: [0x42,0x01,0x18,0xc1,0x66,0x00,0x00,0x00]

s_buffer_atomic_smax s5, s[4:7], flat_scratch_hi
// CHECK: [0x42,0x01,0x18,0xc1,0x67,0x00,0x00,0x00]

s_buffer_atomic_smax s5, s[4:7], vcc_lo
// CHECK: [0x42,0x01,0x18,0xc1,0x6a,0x00,0x00,0x00]

s_buffer_atomic_smax s5, s[4:7], vcc_hi
// CHECK: [0x42,0x01,0x18,0xc1,0x6b,0x00,0x00,0x00]

s_buffer_atomic_smax s5, s[4:7], ttmp15
// CHECK: [0x42,0x01,0x18,0xc1,0x7b,0x00,0x00,0x00]

s_buffer_atomic_smax s5, s[4:7], m0
// CHECK: [0x42,0x01,0x18,0xc1,0x7c,0x00,0x00,0x00]

s_buffer_atomic_smax s5, s[4:7], 0x0
// CHECK: [0x42,0x01,0x1a,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smax s5, s[4:7], s0 glc
// CHECK: [0x42,0x01,0x19,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umax s5, s[4:7], s0
// CHECK: [0x42,0x01,0x1c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umax s101, s[4:7], s0
// CHECK: [0x42,0x19,0x1c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umax flat_scratch_lo, s[4:7], s0
// CHECK: [0x82,0x19,0x1c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umax flat_scratch_hi, s[4:7], s0
// CHECK: [0xc2,0x19,0x1c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umax vcc_lo, s[4:7], s0
// CHECK: [0x82,0x1a,0x1c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umax vcc_hi, s[4:7], s0
// CHECK: [0xc2,0x1a,0x1c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umax ttmp15, s[4:7], s0
// CHECK: [0xc2,0x1e,0x1c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umax s5, s[8:11], s0
// CHECK: [0x44,0x01,0x1c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umax s5, s[96:99], s0
// CHECK: [0x70,0x01,0x1c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umax s5, ttmp[12:15], s0
// CHECK: [0x7c,0x01,0x1c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umax s5, s[4:7], s101
// CHECK: [0x42,0x01,0x1c,0xc1,0x65,0x00,0x00,0x00]

s_buffer_atomic_umax s5, s[4:7], flat_scratch_lo
// CHECK: [0x42,0x01,0x1c,0xc1,0x66,0x00,0x00,0x00]

s_buffer_atomic_umax s5, s[4:7], flat_scratch_hi
// CHECK: [0x42,0x01,0x1c,0xc1,0x67,0x00,0x00,0x00]

s_buffer_atomic_umax s5, s[4:7], vcc_lo
// CHECK: [0x42,0x01,0x1c,0xc1,0x6a,0x00,0x00,0x00]

s_buffer_atomic_umax s5, s[4:7], vcc_hi
// CHECK: [0x42,0x01,0x1c,0xc1,0x6b,0x00,0x00,0x00]

s_buffer_atomic_umax s5, s[4:7], ttmp15
// CHECK: [0x42,0x01,0x1c,0xc1,0x7b,0x00,0x00,0x00]

s_buffer_atomic_umax s5, s[4:7], m0
// CHECK: [0x42,0x01,0x1c,0xc1,0x7c,0x00,0x00,0x00]

s_buffer_atomic_umax s5, s[4:7], 0x0
// CHECK: [0x42,0x01,0x1e,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umax s5, s[4:7], s0 glc
// CHECK: [0x42,0x01,0x1d,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_and s5, s[4:7], s0
// CHECK: [0x42,0x01,0x20,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_and s101, s[4:7], s0
// CHECK: [0x42,0x19,0x20,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_and flat_scratch_lo, s[4:7], s0
// CHECK: [0x82,0x19,0x20,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_and flat_scratch_hi, s[4:7], s0
// CHECK: [0xc2,0x19,0x20,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_and vcc_lo, s[4:7], s0
// CHECK: [0x82,0x1a,0x20,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_and vcc_hi, s[4:7], s0
// CHECK: [0xc2,0x1a,0x20,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_and ttmp15, s[4:7], s0
// CHECK: [0xc2,0x1e,0x20,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_and s5, s[8:11], s0
// CHECK: [0x44,0x01,0x20,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_and s5, s[96:99], s0
// CHECK: [0x70,0x01,0x20,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_and s5, ttmp[12:15], s0
// CHECK: [0x7c,0x01,0x20,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_and s5, s[4:7], s101
// CHECK: [0x42,0x01,0x20,0xc1,0x65,0x00,0x00,0x00]

s_buffer_atomic_and s5, s[4:7], flat_scratch_lo
// CHECK: [0x42,0x01,0x20,0xc1,0x66,0x00,0x00,0x00]

s_buffer_atomic_and s5, s[4:7], flat_scratch_hi
// CHECK: [0x42,0x01,0x20,0xc1,0x67,0x00,0x00,0x00]

s_buffer_atomic_and s5, s[4:7], vcc_lo
// CHECK: [0x42,0x01,0x20,0xc1,0x6a,0x00,0x00,0x00]

s_buffer_atomic_and s5, s[4:7], vcc_hi
// CHECK: [0x42,0x01,0x20,0xc1,0x6b,0x00,0x00,0x00]

s_buffer_atomic_and s5, s[4:7], ttmp15
// CHECK: [0x42,0x01,0x20,0xc1,0x7b,0x00,0x00,0x00]

s_buffer_atomic_and s5, s[4:7], m0
// CHECK: [0x42,0x01,0x20,0xc1,0x7c,0x00,0x00,0x00]

s_buffer_atomic_and s5, s[4:7], 0x0
// CHECK: [0x42,0x01,0x22,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_and s5, s[4:7], s0 glc
// CHECK: [0x42,0x01,0x21,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_or s5, s[4:7], s0
// CHECK: [0x42,0x01,0x24,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_or s101, s[4:7], s0
// CHECK: [0x42,0x19,0x24,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_or flat_scratch_lo, s[4:7], s0
// CHECK: [0x82,0x19,0x24,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_or flat_scratch_hi, s[4:7], s0
// CHECK: [0xc2,0x19,0x24,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_or vcc_lo, s[4:7], s0
// CHECK: [0x82,0x1a,0x24,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_or vcc_hi, s[4:7], s0
// CHECK: [0xc2,0x1a,0x24,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_or ttmp15, s[4:7], s0
// CHECK: [0xc2,0x1e,0x24,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_or s5, s[8:11], s0
// CHECK: [0x44,0x01,0x24,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_or s5, s[96:99], s0
// CHECK: [0x70,0x01,0x24,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_or s5, ttmp[12:15], s0
// CHECK: [0x7c,0x01,0x24,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_or s5, s[4:7], s101
// CHECK: [0x42,0x01,0x24,0xc1,0x65,0x00,0x00,0x00]

s_buffer_atomic_or s5, s[4:7], flat_scratch_lo
// CHECK: [0x42,0x01,0x24,0xc1,0x66,0x00,0x00,0x00]

s_buffer_atomic_or s5, s[4:7], flat_scratch_hi
// CHECK: [0x42,0x01,0x24,0xc1,0x67,0x00,0x00,0x00]

s_buffer_atomic_or s5, s[4:7], vcc_lo
// CHECK: [0x42,0x01,0x24,0xc1,0x6a,0x00,0x00,0x00]

s_buffer_atomic_or s5, s[4:7], vcc_hi
// CHECK: [0x42,0x01,0x24,0xc1,0x6b,0x00,0x00,0x00]

s_buffer_atomic_or s5, s[4:7], ttmp15
// CHECK: [0x42,0x01,0x24,0xc1,0x7b,0x00,0x00,0x00]

s_buffer_atomic_or s5, s[4:7], m0
// CHECK: [0x42,0x01,0x24,0xc1,0x7c,0x00,0x00,0x00]

s_buffer_atomic_or s5, s[4:7], 0x0
// CHECK: [0x42,0x01,0x26,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_or s5, s[4:7], s0 glc
// CHECK: [0x42,0x01,0x25,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_xor s5, s[4:7], s0
// CHECK: [0x42,0x01,0x28,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_xor s101, s[4:7], s0
// CHECK: [0x42,0x19,0x28,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_xor flat_scratch_lo, s[4:7], s0
// CHECK: [0x82,0x19,0x28,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_xor flat_scratch_hi, s[4:7], s0
// CHECK: [0xc2,0x19,0x28,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_xor vcc_lo, s[4:7], s0
// CHECK: [0x82,0x1a,0x28,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_xor vcc_hi, s[4:7], s0
// CHECK: [0xc2,0x1a,0x28,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_xor ttmp15, s[4:7], s0
// CHECK: [0xc2,0x1e,0x28,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_xor s5, s[8:11], s0
// CHECK: [0x44,0x01,0x28,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_xor s5, s[96:99], s0
// CHECK: [0x70,0x01,0x28,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_xor s5, ttmp[12:15], s0
// CHECK: [0x7c,0x01,0x28,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_xor s5, s[4:7], s101
// CHECK: [0x42,0x01,0x28,0xc1,0x65,0x00,0x00,0x00]

s_buffer_atomic_xor s5, s[4:7], flat_scratch_lo
// CHECK: [0x42,0x01,0x28,0xc1,0x66,0x00,0x00,0x00]

s_buffer_atomic_xor s5, s[4:7], flat_scratch_hi
// CHECK: [0x42,0x01,0x28,0xc1,0x67,0x00,0x00,0x00]

s_buffer_atomic_xor s5, s[4:7], vcc_lo
// CHECK: [0x42,0x01,0x28,0xc1,0x6a,0x00,0x00,0x00]

s_buffer_atomic_xor s5, s[4:7], vcc_hi
// CHECK: [0x42,0x01,0x28,0xc1,0x6b,0x00,0x00,0x00]

s_buffer_atomic_xor s5, s[4:7], ttmp15
// CHECK: [0x42,0x01,0x28,0xc1,0x7b,0x00,0x00,0x00]

s_buffer_atomic_xor s5, s[4:7], m0
// CHECK: [0x42,0x01,0x28,0xc1,0x7c,0x00,0x00,0x00]

s_buffer_atomic_xor s5, s[4:7], 0x0
// CHECK: [0x42,0x01,0x2a,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_xor s5, s[4:7], s0 glc
// CHECK: [0x42,0x01,0x29,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_inc s5, s[4:7], s0
// CHECK: [0x42,0x01,0x2c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_inc s101, s[4:7], s0
// CHECK: [0x42,0x19,0x2c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_inc flat_scratch_lo, s[4:7], s0
// CHECK: [0x82,0x19,0x2c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_inc flat_scratch_hi, s[4:7], s0
// CHECK: [0xc2,0x19,0x2c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_inc vcc_lo, s[4:7], s0
// CHECK: [0x82,0x1a,0x2c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_inc vcc_hi, s[4:7], s0
// CHECK: [0xc2,0x1a,0x2c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_inc ttmp15, s[4:7], s0
// CHECK: [0xc2,0x1e,0x2c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_inc s5, s[8:11], s0
// CHECK: [0x44,0x01,0x2c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_inc s5, s[96:99], s0
// CHECK: [0x70,0x01,0x2c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_inc s5, ttmp[12:15], s0
// CHECK: [0x7c,0x01,0x2c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_inc s5, s[4:7], s101
// CHECK: [0x42,0x01,0x2c,0xc1,0x65,0x00,0x00,0x00]

s_buffer_atomic_inc s5, s[4:7], flat_scratch_lo
// CHECK: [0x42,0x01,0x2c,0xc1,0x66,0x00,0x00,0x00]

s_buffer_atomic_inc s5, s[4:7], flat_scratch_hi
// CHECK: [0x42,0x01,0x2c,0xc1,0x67,0x00,0x00,0x00]

s_buffer_atomic_inc s5, s[4:7], vcc_lo
// CHECK: [0x42,0x01,0x2c,0xc1,0x6a,0x00,0x00,0x00]

s_buffer_atomic_inc s5, s[4:7], vcc_hi
// CHECK: [0x42,0x01,0x2c,0xc1,0x6b,0x00,0x00,0x00]

s_buffer_atomic_inc s5, s[4:7], ttmp15
// CHECK: [0x42,0x01,0x2c,0xc1,0x7b,0x00,0x00,0x00]

s_buffer_atomic_inc s5, s[4:7], m0
// CHECK: [0x42,0x01,0x2c,0xc1,0x7c,0x00,0x00,0x00]

s_buffer_atomic_inc s5, s[4:7], 0x0
// CHECK: [0x42,0x01,0x2e,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_inc s5, s[4:7], s0 glc
// CHECK: [0x42,0x01,0x2d,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_dec s5, s[4:7], s0
// CHECK: [0x42,0x01,0x30,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_dec s101, s[4:7], s0
// CHECK: [0x42,0x19,0x30,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_dec flat_scratch_lo, s[4:7], s0
// CHECK: [0x82,0x19,0x30,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_dec flat_scratch_hi, s[4:7], s0
// CHECK: [0xc2,0x19,0x30,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_dec vcc_lo, s[4:7], s0
// CHECK: [0x82,0x1a,0x30,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_dec vcc_hi, s[4:7], s0
// CHECK: [0xc2,0x1a,0x30,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_dec ttmp15, s[4:7], s0
// CHECK: [0xc2,0x1e,0x30,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_dec s5, s[8:11], s0
// CHECK: [0x44,0x01,0x30,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_dec s5, s[96:99], s0
// CHECK: [0x70,0x01,0x30,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_dec s5, ttmp[12:15], s0
// CHECK: [0x7c,0x01,0x30,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_dec s5, s[4:7], s101
// CHECK: [0x42,0x01,0x30,0xc1,0x65,0x00,0x00,0x00]

s_buffer_atomic_dec s5, s[4:7], flat_scratch_lo
// CHECK: [0x42,0x01,0x30,0xc1,0x66,0x00,0x00,0x00]

s_buffer_atomic_dec s5, s[4:7], flat_scratch_hi
// CHECK: [0x42,0x01,0x30,0xc1,0x67,0x00,0x00,0x00]

s_buffer_atomic_dec s5, s[4:7], vcc_lo
// CHECK: [0x42,0x01,0x30,0xc1,0x6a,0x00,0x00,0x00]

s_buffer_atomic_dec s5, s[4:7], vcc_hi
// CHECK: [0x42,0x01,0x30,0xc1,0x6b,0x00,0x00,0x00]

s_buffer_atomic_dec s5, s[4:7], ttmp15
// CHECK: [0x42,0x01,0x30,0xc1,0x7b,0x00,0x00,0x00]

s_buffer_atomic_dec s5, s[4:7], m0
// CHECK: [0x42,0x01,0x30,0xc1,0x7c,0x00,0x00,0x00]

s_buffer_atomic_dec s5, s[4:7], 0x0
// CHECK: [0x42,0x01,0x32,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_dec s5, s[4:7], s0 glc
// CHECK: [0x42,0x01,0x31,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_swap_x2 s[10:11], s[4:7], s0
// CHECK: [0x82,0x02,0x80,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_swap_x2 s[12:13], s[4:7], s0
// CHECK: [0x02,0x03,0x80,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_swap_x2 s[100:101], s[4:7], s0
// CHECK: [0x02,0x19,0x80,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_swap_x2 flat_scratch, s[4:7], s0
// CHECK: [0x82,0x19,0x80,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_swap_x2 vcc, s[4:7], s0
// CHECK: [0x82,0x1a,0x80,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_swap_x2 ttmp[14:15], s[4:7], s0
// CHECK: [0x82,0x1e,0x80,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_swap_x2 s[10:11], s[8:11], s0
// CHECK: [0x84,0x02,0x80,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_swap_x2 s[10:11], s[96:99], s0
// CHECK: [0xb0,0x02,0x80,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_swap_x2 s[10:11], ttmp[12:15], s0
// CHECK: [0xbc,0x02,0x80,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_swap_x2 s[10:11], s[4:7], s101
// CHECK: [0x82,0x02,0x80,0xc1,0x65,0x00,0x00,0x00]

s_buffer_atomic_swap_x2 s[10:11], s[4:7], flat_scratch_lo
// CHECK: [0x82,0x02,0x80,0xc1,0x66,0x00,0x00,0x00]

s_buffer_atomic_swap_x2 s[10:11], s[4:7], flat_scratch_hi
// CHECK: [0x82,0x02,0x80,0xc1,0x67,0x00,0x00,0x00]

s_buffer_atomic_swap_x2 s[10:11], s[4:7], vcc_lo
// CHECK: [0x82,0x02,0x80,0xc1,0x6a,0x00,0x00,0x00]

s_buffer_atomic_swap_x2 s[10:11], s[4:7], vcc_hi
// CHECK: [0x82,0x02,0x80,0xc1,0x6b,0x00,0x00,0x00]

s_buffer_atomic_swap_x2 s[10:11], s[4:7], ttmp15
// CHECK: [0x82,0x02,0x80,0xc1,0x7b,0x00,0x00,0x00]

s_buffer_atomic_swap_x2 s[10:11], s[4:7], m0
// CHECK: [0x82,0x02,0x80,0xc1,0x7c,0x00,0x00,0x00]

s_buffer_atomic_swap_x2 s[10:11], s[4:7], 0x0
// CHECK: [0x82,0x02,0x82,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_swap_x2 s[10:11], s[4:7], s0 glc
// CHECK: [0x82,0x02,0x81,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_cmpswap_x2 s[20:23], s[4:7], s0
// CHECK: [0x02,0x05,0x84,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_cmpswap_x2 s[24:27], s[4:7], s0
// CHECK: [0x02,0x06,0x84,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_cmpswap_x2 s[96:99], s[4:7], s0
// CHECK: [0x02,0x18,0x84,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_cmpswap_x2 ttmp[12:15], s[4:7], s0
// CHECK: [0x02,0x1e,0x84,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_cmpswap_x2 s[20:23], s[8:11], s0
// CHECK: [0x04,0x05,0x84,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_cmpswap_x2 s[20:23], s[96:99], s0
// CHECK: [0x30,0x05,0x84,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_cmpswap_x2 s[20:23], ttmp[12:15], s0
// CHECK: [0x3c,0x05,0x84,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_cmpswap_x2 s[20:23], s[4:7], s101
// CHECK: [0x02,0x05,0x84,0xc1,0x65,0x00,0x00,0x00]

s_buffer_atomic_cmpswap_x2 s[20:23], s[4:7], flat_scratch_lo
// CHECK: [0x02,0x05,0x84,0xc1,0x66,0x00,0x00,0x00]

s_buffer_atomic_cmpswap_x2 s[20:23], s[4:7], flat_scratch_hi
// CHECK: [0x02,0x05,0x84,0xc1,0x67,0x00,0x00,0x00]

s_buffer_atomic_cmpswap_x2 s[20:23], s[4:7], vcc_lo
// CHECK: [0x02,0x05,0x84,0xc1,0x6a,0x00,0x00,0x00]

s_buffer_atomic_cmpswap_x2 s[20:23], s[4:7], vcc_hi
// CHECK: [0x02,0x05,0x84,0xc1,0x6b,0x00,0x00,0x00]

s_buffer_atomic_cmpswap_x2 s[20:23], s[4:7], ttmp15
// CHECK: [0x02,0x05,0x84,0xc1,0x7b,0x00,0x00,0x00]

s_buffer_atomic_cmpswap_x2 s[20:23], s[4:7], m0
// CHECK: [0x02,0x05,0x84,0xc1,0x7c,0x00,0x00,0x00]

s_buffer_atomic_cmpswap_x2 s[20:23], s[4:7], 0x0
// CHECK: [0x02,0x05,0x86,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_cmpswap_x2 s[20:23], s[4:7], s0 glc
// CHECK: [0x02,0x05,0x85,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_add_x2 s[10:11], s[4:7], s0
// CHECK: [0x82,0x02,0x88,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_add_x2 s[12:13], s[4:7], s0
// CHECK: [0x02,0x03,0x88,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_add_x2 s[100:101], s[4:7], s0
// CHECK: [0x02,0x19,0x88,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_add_x2 flat_scratch, s[4:7], s0
// CHECK: [0x82,0x19,0x88,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_add_x2 vcc, s[4:7], s0
// CHECK: [0x82,0x1a,0x88,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_add_x2 ttmp[14:15], s[4:7], s0
// CHECK: [0x82,0x1e,0x88,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_add_x2 s[10:11], s[8:11], s0
// CHECK: [0x84,0x02,0x88,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_add_x2 s[10:11], s[96:99], s0
// CHECK: [0xb0,0x02,0x88,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_add_x2 s[10:11], ttmp[12:15], s0
// CHECK: [0xbc,0x02,0x88,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_add_x2 s[10:11], s[4:7], s101
// CHECK: [0x82,0x02,0x88,0xc1,0x65,0x00,0x00,0x00]

s_buffer_atomic_add_x2 s[10:11], s[4:7], flat_scratch_lo
// CHECK: [0x82,0x02,0x88,0xc1,0x66,0x00,0x00,0x00]

s_buffer_atomic_add_x2 s[10:11], s[4:7], flat_scratch_hi
// CHECK: [0x82,0x02,0x88,0xc1,0x67,0x00,0x00,0x00]

s_buffer_atomic_add_x2 s[10:11], s[4:7], vcc_lo
// CHECK: [0x82,0x02,0x88,0xc1,0x6a,0x00,0x00,0x00]

s_buffer_atomic_add_x2 s[10:11], s[4:7], vcc_hi
// CHECK: [0x82,0x02,0x88,0xc1,0x6b,0x00,0x00,0x00]

s_buffer_atomic_add_x2 s[10:11], s[4:7], ttmp15
// CHECK: [0x82,0x02,0x88,0xc1,0x7b,0x00,0x00,0x00]

s_buffer_atomic_add_x2 s[10:11], s[4:7], m0
// CHECK: [0x82,0x02,0x88,0xc1,0x7c,0x00,0x00,0x00]

s_buffer_atomic_add_x2 s[10:11], s[4:7], 0x0
// CHECK: [0x82,0x02,0x8a,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_add_x2 s[10:11], s[4:7], s0 glc
// CHECK: [0x82,0x02,0x89,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_sub_x2 s[10:11], s[4:7], s0
// CHECK: [0x82,0x02,0x8c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_sub_x2 s[12:13], s[4:7], s0
// CHECK: [0x02,0x03,0x8c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_sub_x2 s[100:101], s[4:7], s0
// CHECK: [0x02,0x19,0x8c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_sub_x2 flat_scratch, s[4:7], s0
// CHECK: [0x82,0x19,0x8c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_sub_x2 vcc, s[4:7], s0
// CHECK: [0x82,0x1a,0x8c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_sub_x2 ttmp[14:15], s[4:7], s0
// CHECK: [0x82,0x1e,0x8c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_sub_x2 s[10:11], s[8:11], s0
// CHECK: [0x84,0x02,0x8c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_sub_x2 s[10:11], s[96:99], s0
// CHECK: [0xb0,0x02,0x8c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_sub_x2 s[10:11], ttmp[12:15], s0
// CHECK: [0xbc,0x02,0x8c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_sub_x2 s[10:11], s[4:7], s101
// CHECK: [0x82,0x02,0x8c,0xc1,0x65,0x00,0x00,0x00]

s_buffer_atomic_sub_x2 s[10:11], s[4:7], flat_scratch_lo
// CHECK: [0x82,0x02,0x8c,0xc1,0x66,0x00,0x00,0x00]

s_buffer_atomic_sub_x2 s[10:11], s[4:7], flat_scratch_hi
// CHECK: [0x82,0x02,0x8c,0xc1,0x67,0x00,0x00,0x00]

s_buffer_atomic_sub_x2 s[10:11], s[4:7], vcc_lo
// CHECK: [0x82,0x02,0x8c,0xc1,0x6a,0x00,0x00,0x00]

s_buffer_atomic_sub_x2 s[10:11], s[4:7], vcc_hi
// CHECK: [0x82,0x02,0x8c,0xc1,0x6b,0x00,0x00,0x00]

s_buffer_atomic_sub_x2 s[10:11], s[4:7], ttmp15
// CHECK: [0x82,0x02,0x8c,0xc1,0x7b,0x00,0x00,0x00]

s_buffer_atomic_sub_x2 s[10:11], s[4:7], m0
// CHECK: [0x82,0x02,0x8c,0xc1,0x7c,0x00,0x00,0x00]

s_buffer_atomic_sub_x2 s[10:11], s[4:7], 0x0
// CHECK: [0x82,0x02,0x8e,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_sub_x2 s[10:11], s[4:7], s0 glc
// CHECK: [0x82,0x02,0x8d,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smin_x2 s[10:11], s[4:7], s0
// CHECK: [0x82,0x02,0x90,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smin_x2 s[12:13], s[4:7], s0
// CHECK: [0x02,0x03,0x90,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smin_x2 s[100:101], s[4:7], s0
// CHECK: [0x02,0x19,0x90,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smin_x2 flat_scratch, s[4:7], s0
// CHECK: [0x82,0x19,0x90,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smin_x2 vcc, s[4:7], s0
// CHECK: [0x82,0x1a,0x90,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smin_x2 ttmp[14:15], s[4:7], s0
// CHECK: [0x82,0x1e,0x90,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smin_x2 s[10:11], s[8:11], s0
// CHECK: [0x84,0x02,0x90,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smin_x2 s[10:11], s[96:99], s0
// CHECK: [0xb0,0x02,0x90,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smin_x2 s[10:11], ttmp[12:15], s0
// CHECK: [0xbc,0x02,0x90,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smin_x2 s[10:11], s[4:7], s101
// CHECK: [0x82,0x02,0x90,0xc1,0x65,0x00,0x00,0x00]

s_buffer_atomic_smin_x2 s[10:11], s[4:7], flat_scratch_lo
// CHECK: [0x82,0x02,0x90,0xc1,0x66,0x00,0x00,0x00]

s_buffer_atomic_smin_x2 s[10:11], s[4:7], flat_scratch_hi
// CHECK: [0x82,0x02,0x90,0xc1,0x67,0x00,0x00,0x00]

s_buffer_atomic_smin_x2 s[10:11], s[4:7], vcc_lo
// CHECK: [0x82,0x02,0x90,0xc1,0x6a,0x00,0x00,0x00]

s_buffer_atomic_smin_x2 s[10:11], s[4:7], vcc_hi
// CHECK: [0x82,0x02,0x90,0xc1,0x6b,0x00,0x00,0x00]

s_buffer_atomic_smin_x2 s[10:11], s[4:7], ttmp15
// CHECK: [0x82,0x02,0x90,0xc1,0x7b,0x00,0x00,0x00]

s_buffer_atomic_smin_x2 s[10:11], s[4:7], m0
// CHECK: [0x82,0x02,0x90,0xc1,0x7c,0x00,0x00,0x00]

s_buffer_atomic_smin_x2 s[10:11], s[4:7], 0x0
// CHECK: [0x82,0x02,0x92,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smin_x2 s[10:11], s[4:7], s0 glc
// CHECK: [0x82,0x02,0x91,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umin_x2 s[10:11], s[4:7], s0
// CHECK: [0x82,0x02,0x94,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umin_x2 s[12:13], s[4:7], s0
// CHECK: [0x02,0x03,0x94,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umin_x2 s[100:101], s[4:7], s0
// CHECK: [0x02,0x19,0x94,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umin_x2 flat_scratch, s[4:7], s0
// CHECK: [0x82,0x19,0x94,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umin_x2 vcc, s[4:7], s0
// CHECK: [0x82,0x1a,0x94,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umin_x2 ttmp[14:15], s[4:7], s0
// CHECK: [0x82,0x1e,0x94,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umin_x2 s[10:11], s[8:11], s0
// CHECK: [0x84,0x02,0x94,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umin_x2 s[10:11], s[96:99], s0
// CHECK: [0xb0,0x02,0x94,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umin_x2 s[10:11], ttmp[12:15], s0
// CHECK: [0xbc,0x02,0x94,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umin_x2 s[10:11], s[4:7], s101
// CHECK: [0x82,0x02,0x94,0xc1,0x65,0x00,0x00,0x00]

s_buffer_atomic_umin_x2 s[10:11], s[4:7], flat_scratch_lo
// CHECK: [0x82,0x02,0x94,0xc1,0x66,0x00,0x00,0x00]

s_buffer_atomic_umin_x2 s[10:11], s[4:7], flat_scratch_hi
// CHECK: [0x82,0x02,0x94,0xc1,0x67,0x00,0x00,0x00]

s_buffer_atomic_umin_x2 s[10:11], s[4:7], vcc_lo
// CHECK: [0x82,0x02,0x94,0xc1,0x6a,0x00,0x00,0x00]

s_buffer_atomic_umin_x2 s[10:11], s[4:7], vcc_hi
// CHECK: [0x82,0x02,0x94,0xc1,0x6b,0x00,0x00,0x00]

s_buffer_atomic_umin_x2 s[10:11], s[4:7], ttmp15
// CHECK: [0x82,0x02,0x94,0xc1,0x7b,0x00,0x00,0x00]

s_buffer_atomic_umin_x2 s[10:11], s[4:7], m0
// CHECK: [0x82,0x02,0x94,0xc1,0x7c,0x00,0x00,0x00]

s_buffer_atomic_umin_x2 s[10:11], s[4:7], 0x0
// CHECK: [0x82,0x02,0x96,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umin_x2 s[10:11], s[4:7], s0 glc
// CHECK: [0x82,0x02,0x95,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smax_x2 s[10:11], s[4:7], s0
// CHECK: [0x82,0x02,0x98,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smax_x2 s[12:13], s[4:7], s0
// CHECK: [0x02,0x03,0x98,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smax_x2 s[100:101], s[4:7], s0
// CHECK: [0x02,0x19,0x98,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smax_x2 flat_scratch, s[4:7], s0
// CHECK: [0x82,0x19,0x98,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smax_x2 vcc, s[4:7], s0
// CHECK: [0x82,0x1a,0x98,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smax_x2 ttmp[14:15], s[4:7], s0
// CHECK: [0x82,0x1e,0x98,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smax_x2 s[10:11], s[8:11], s0
// CHECK: [0x84,0x02,0x98,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smax_x2 s[10:11], s[96:99], s0
// CHECK: [0xb0,0x02,0x98,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smax_x2 s[10:11], ttmp[12:15], s0
// CHECK: [0xbc,0x02,0x98,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smax_x2 s[10:11], s[4:7], s101
// CHECK: [0x82,0x02,0x98,0xc1,0x65,0x00,0x00,0x00]

s_buffer_atomic_smax_x2 s[10:11], s[4:7], flat_scratch_lo
// CHECK: [0x82,0x02,0x98,0xc1,0x66,0x00,0x00,0x00]

s_buffer_atomic_smax_x2 s[10:11], s[4:7], flat_scratch_hi
// CHECK: [0x82,0x02,0x98,0xc1,0x67,0x00,0x00,0x00]

s_buffer_atomic_smax_x2 s[10:11], s[4:7], vcc_lo
// CHECK: [0x82,0x02,0x98,0xc1,0x6a,0x00,0x00,0x00]

s_buffer_atomic_smax_x2 s[10:11], s[4:7], vcc_hi
// CHECK: [0x82,0x02,0x98,0xc1,0x6b,0x00,0x00,0x00]

s_buffer_atomic_smax_x2 s[10:11], s[4:7], ttmp15
// CHECK: [0x82,0x02,0x98,0xc1,0x7b,0x00,0x00,0x00]

s_buffer_atomic_smax_x2 s[10:11], s[4:7], m0
// CHECK: [0x82,0x02,0x98,0xc1,0x7c,0x00,0x00,0x00]

s_buffer_atomic_smax_x2 s[10:11], s[4:7], 0x0
// CHECK: [0x82,0x02,0x9a,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_smax_x2 s[10:11], s[4:7], s0 glc
// CHECK: [0x82,0x02,0x99,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umax_x2 s[10:11], s[4:7], s0
// CHECK: [0x82,0x02,0x9c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umax_x2 s[12:13], s[4:7], s0
// CHECK: [0x02,0x03,0x9c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umax_x2 s[100:101], s[4:7], s0
// CHECK: [0x02,0x19,0x9c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umax_x2 flat_scratch, s[4:7], s0
// CHECK: [0x82,0x19,0x9c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umax_x2 vcc, s[4:7], s0
// CHECK: [0x82,0x1a,0x9c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umax_x2 ttmp[14:15], s[4:7], s0
// CHECK: [0x82,0x1e,0x9c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umax_x2 s[10:11], s[8:11], s0
// CHECK: [0x84,0x02,0x9c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umax_x2 s[10:11], s[96:99], s0
// CHECK: [0xb0,0x02,0x9c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umax_x2 s[10:11], ttmp[12:15], s0
// CHECK: [0xbc,0x02,0x9c,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umax_x2 s[10:11], s[4:7], s101
// CHECK: [0x82,0x02,0x9c,0xc1,0x65,0x00,0x00,0x00]

s_buffer_atomic_umax_x2 s[10:11], s[4:7], flat_scratch_lo
// CHECK: [0x82,0x02,0x9c,0xc1,0x66,0x00,0x00,0x00]

s_buffer_atomic_umax_x2 s[10:11], s[4:7], flat_scratch_hi
// CHECK: [0x82,0x02,0x9c,0xc1,0x67,0x00,0x00,0x00]

s_buffer_atomic_umax_x2 s[10:11], s[4:7], vcc_lo
// CHECK: [0x82,0x02,0x9c,0xc1,0x6a,0x00,0x00,0x00]

s_buffer_atomic_umax_x2 s[10:11], s[4:7], vcc_hi
// CHECK: [0x82,0x02,0x9c,0xc1,0x6b,0x00,0x00,0x00]

s_buffer_atomic_umax_x2 s[10:11], s[4:7], ttmp15
// CHECK: [0x82,0x02,0x9c,0xc1,0x7b,0x00,0x00,0x00]

s_buffer_atomic_umax_x2 s[10:11], s[4:7], m0
// CHECK: [0x82,0x02,0x9c,0xc1,0x7c,0x00,0x00,0x00]

s_buffer_atomic_umax_x2 s[10:11], s[4:7], 0x0
// CHECK: [0x82,0x02,0x9e,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_umax_x2 s[10:11], s[4:7], s0 glc
// CHECK: [0x82,0x02,0x9d,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_and_x2 s[10:11], s[4:7], s0
// CHECK: [0x82,0x02,0xa0,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_and_x2 s[12:13], s[4:7], s0
// CHECK: [0x02,0x03,0xa0,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_and_x2 s[100:101], s[4:7], s0
// CHECK: [0x02,0x19,0xa0,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_and_x2 flat_scratch, s[4:7], s0
// CHECK: [0x82,0x19,0xa0,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_and_x2 vcc, s[4:7], s0
// CHECK: [0x82,0x1a,0xa0,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_and_x2 ttmp[14:15], s[4:7], s0
// CHECK: [0x82,0x1e,0xa0,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_and_x2 s[10:11], s[8:11], s0
// CHECK: [0x84,0x02,0xa0,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_and_x2 s[10:11], s[96:99], s0
// CHECK: [0xb0,0x02,0xa0,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_and_x2 s[10:11], ttmp[12:15], s0
// CHECK: [0xbc,0x02,0xa0,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_and_x2 s[10:11], s[4:7], s101
// CHECK: [0x82,0x02,0xa0,0xc1,0x65,0x00,0x00,0x00]

s_buffer_atomic_and_x2 s[10:11], s[4:7], flat_scratch_lo
// CHECK: [0x82,0x02,0xa0,0xc1,0x66,0x00,0x00,0x00]

s_buffer_atomic_and_x2 s[10:11], s[4:7], flat_scratch_hi
// CHECK: [0x82,0x02,0xa0,0xc1,0x67,0x00,0x00,0x00]

s_buffer_atomic_and_x2 s[10:11], s[4:7], vcc_lo
// CHECK: [0x82,0x02,0xa0,0xc1,0x6a,0x00,0x00,0x00]

s_buffer_atomic_and_x2 s[10:11], s[4:7], vcc_hi
// CHECK: [0x82,0x02,0xa0,0xc1,0x6b,0x00,0x00,0x00]

s_buffer_atomic_and_x2 s[10:11], s[4:7], ttmp15
// CHECK: [0x82,0x02,0xa0,0xc1,0x7b,0x00,0x00,0x00]

s_buffer_atomic_and_x2 s[10:11], s[4:7], m0
// CHECK: [0x82,0x02,0xa0,0xc1,0x7c,0x00,0x00,0x00]

s_buffer_atomic_and_x2 s[10:11], s[4:7], 0x0
// CHECK: [0x82,0x02,0xa2,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_and_x2 s[10:11], s[4:7], s0 glc
// CHECK: [0x82,0x02,0xa1,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_or_x2 s[10:11], s[4:7], s0
// CHECK: [0x82,0x02,0xa4,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_or_x2 s[12:13], s[4:7], s0
// CHECK: [0x02,0x03,0xa4,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_or_x2 s[100:101], s[4:7], s0
// CHECK: [0x02,0x19,0xa4,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_or_x2 flat_scratch, s[4:7], s0
// CHECK: [0x82,0x19,0xa4,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_or_x2 vcc, s[4:7], s0
// CHECK: [0x82,0x1a,0xa4,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_or_x2 ttmp[14:15], s[4:7], s0
// CHECK: [0x82,0x1e,0xa4,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_or_x2 s[10:11], s[8:11], s0
// CHECK: [0x84,0x02,0xa4,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_or_x2 s[10:11], s[96:99], s0
// CHECK: [0xb0,0x02,0xa4,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_or_x2 s[10:11], ttmp[12:15], s0
// CHECK: [0xbc,0x02,0xa4,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_or_x2 s[10:11], s[4:7], s101
// CHECK: [0x82,0x02,0xa4,0xc1,0x65,0x00,0x00,0x00]

s_buffer_atomic_or_x2 s[10:11], s[4:7], flat_scratch_lo
// CHECK: [0x82,0x02,0xa4,0xc1,0x66,0x00,0x00,0x00]

s_buffer_atomic_or_x2 s[10:11], s[4:7], flat_scratch_hi
// CHECK: [0x82,0x02,0xa4,0xc1,0x67,0x00,0x00,0x00]

s_buffer_atomic_or_x2 s[10:11], s[4:7], vcc_lo
// CHECK: [0x82,0x02,0xa4,0xc1,0x6a,0x00,0x00,0x00]

s_buffer_atomic_or_x2 s[10:11], s[4:7], vcc_hi
// CHECK: [0x82,0x02,0xa4,0xc1,0x6b,0x00,0x00,0x00]

s_buffer_atomic_or_x2 s[10:11], s[4:7], ttmp15
// CHECK: [0x82,0x02,0xa4,0xc1,0x7b,0x00,0x00,0x00]

s_buffer_atomic_or_x2 s[10:11], s[4:7], m0
// CHECK: [0x82,0x02,0xa4,0xc1,0x7c,0x00,0x00,0x00]

s_buffer_atomic_or_x2 s[10:11], s[4:7], 0x0
// CHECK: [0x82,0x02,0xa6,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_or_x2 s[10:11], s[4:7], s0 glc
// CHECK: [0x82,0x02,0xa5,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_xor_x2 s[10:11], s[4:7], s0
// CHECK: [0x82,0x02,0xa8,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_xor_x2 s[12:13], s[4:7], s0
// CHECK: [0x02,0x03,0xa8,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_xor_x2 s[100:101], s[4:7], s0
// CHECK: [0x02,0x19,0xa8,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_xor_x2 flat_scratch, s[4:7], s0
// CHECK: [0x82,0x19,0xa8,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_xor_x2 vcc, s[4:7], s0
// CHECK: [0x82,0x1a,0xa8,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_xor_x2 ttmp[14:15], s[4:7], s0
// CHECK: [0x82,0x1e,0xa8,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_xor_x2 s[10:11], s[8:11], s0
// CHECK: [0x84,0x02,0xa8,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_xor_x2 s[10:11], s[96:99], s0
// CHECK: [0xb0,0x02,0xa8,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_xor_x2 s[10:11], ttmp[12:15], s0
// CHECK: [0xbc,0x02,0xa8,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_xor_x2 s[10:11], s[4:7], s101
// CHECK: [0x82,0x02,0xa8,0xc1,0x65,0x00,0x00,0x00]

s_buffer_atomic_xor_x2 s[10:11], s[4:7], flat_scratch_lo
// CHECK: [0x82,0x02,0xa8,0xc1,0x66,0x00,0x00,0x00]

s_buffer_atomic_xor_x2 s[10:11], s[4:7], flat_scratch_hi
// CHECK: [0x82,0x02,0xa8,0xc1,0x67,0x00,0x00,0x00]

s_buffer_atomic_xor_x2 s[10:11], s[4:7], vcc_lo
// CHECK: [0x82,0x02,0xa8,0xc1,0x6a,0x00,0x00,0x00]

s_buffer_atomic_xor_x2 s[10:11], s[4:7], vcc_hi
// CHECK: [0x82,0x02,0xa8,0xc1,0x6b,0x00,0x00,0x00]

s_buffer_atomic_xor_x2 s[10:11], s[4:7], ttmp15
// CHECK: [0x82,0x02,0xa8,0xc1,0x7b,0x00,0x00,0x00]

s_buffer_atomic_xor_x2 s[10:11], s[4:7], m0
// CHECK: [0x82,0x02,0xa8,0xc1,0x7c,0x00,0x00,0x00]

s_buffer_atomic_xor_x2 s[10:11], s[4:7], 0x0
// CHECK: [0x82,0x02,0xaa,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_xor_x2 s[10:11], s[4:7], s0 glc
// CHECK: [0x82,0x02,0xa9,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_inc_x2 s[10:11], s[4:7], s0
// CHECK: [0x82,0x02,0xac,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_inc_x2 s[12:13], s[4:7], s0
// CHECK: [0x02,0x03,0xac,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_inc_x2 s[100:101], s[4:7], s0
// CHECK: [0x02,0x19,0xac,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_inc_x2 flat_scratch, s[4:7], s0
// CHECK: [0x82,0x19,0xac,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_inc_x2 vcc, s[4:7], s0
// CHECK: [0x82,0x1a,0xac,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_inc_x2 ttmp[14:15], s[4:7], s0
// CHECK: [0x82,0x1e,0xac,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_inc_x2 s[10:11], s[8:11], s0
// CHECK: [0x84,0x02,0xac,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_inc_x2 s[10:11], s[96:99], s0
// CHECK: [0xb0,0x02,0xac,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_inc_x2 s[10:11], ttmp[12:15], s0
// CHECK: [0xbc,0x02,0xac,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_inc_x2 s[10:11], s[4:7], s101
// CHECK: [0x82,0x02,0xac,0xc1,0x65,0x00,0x00,0x00]

s_buffer_atomic_inc_x2 s[10:11], s[4:7], flat_scratch_lo
// CHECK: [0x82,0x02,0xac,0xc1,0x66,0x00,0x00,0x00]

s_buffer_atomic_inc_x2 s[10:11], s[4:7], flat_scratch_hi
// CHECK: [0x82,0x02,0xac,0xc1,0x67,0x00,0x00,0x00]

s_buffer_atomic_inc_x2 s[10:11], s[4:7], vcc_lo
// CHECK: [0x82,0x02,0xac,0xc1,0x6a,0x00,0x00,0x00]

s_buffer_atomic_inc_x2 s[10:11], s[4:7], vcc_hi
// CHECK: [0x82,0x02,0xac,0xc1,0x6b,0x00,0x00,0x00]

s_buffer_atomic_inc_x2 s[10:11], s[4:7], ttmp15
// CHECK: [0x82,0x02,0xac,0xc1,0x7b,0x00,0x00,0x00]

s_buffer_atomic_inc_x2 s[10:11], s[4:7], m0
// CHECK: [0x82,0x02,0xac,0xc1,0x7c,0x00,0x00,0x00]

s_buffer_atomic_inc_x2 s[10:11], s[4:7], 0x0
// CHECK: [0x82,0x02,0xae,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_inc_x2 s[10:11], s[4:7], s0 glc
// CHECK: [0x82,0x02,0xad,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_dec_x2 s[10:11], s[4:7], s0
// CHECK: [0x82,0x02,0xb0,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_dec_x2 s[12:13], s[4:7], s0
// CHECK: [0x02,0x03,0xb0,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_dec_x2 s[100:101], s[4:7], s0
// CHECK: [0x02,0x19,0xb0,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_dec_x2 flat_scratch, s[4:7], s0
// CHECK: [0x82,0x19,0xb0,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_dec_x2 vcc, s[4:7], s0
// CHECK: [0x82,0x1a,0xb0,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_dec_x2 ttmp[14:15], s[4:7], s0
// CHECK: [0x82,0x1e,0xb0,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_dec_x2 s[10:11], s[8:11], s0
// CHECK: [0x84,0x02,0xb0,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_dec_x2 s[10:11], s[96:99], s0
// CHECK: [0xb0,0x02,0xb0,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_dec_x2 s[10:11], ttmp[12:15], s0
// CHECK: [0xbc,0x02,0xb0,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_dec_x2 s[10:11], s[4:7], s101
// CHECK: [0x82,0x02,0xb0,0xc1,0x65,0x00,0x00,0x00]

s_buffer_atomic_dec_x2 s[10:11], s[4:7], flat_scratch_lo
// CHECK: [0x82,0x02,0xb0,0xc1,0x66,0x00,0x00,0x00]

s_buffer_atomic_dec_x2 s[10:11], s[4:7], flat_scratch_hi
// CHECK: [0x82,0x02,0xb0,0xc1,0x67,0x00,0x00,0x00]

s_buffer_atomic_dec_x2 s[10:11], s[4:7], vcc_lo
// CHECK: [0x82,0x02,0xb0,0xc1,0x6a,0x00,0x00,0x00]

s_buffer_atomic_dec_x2 s[10:11], s[4:7], vcc_hi
// CHECK: [0x82,0x02,0xb0,0xc1,0x6b,0x00,0x00,0x00]

s_buffer_atomic_dec_x2 s[10:11], s[4:7], ttmp15
// CHECK: [0x82,0x02,0xb0,0xc1,0x7b,0x00,0x00,0x00]

s_buffer_atomic_dec_x2 s[10:11], s[4:7], m0
// CHECK: [0x82,0x02,0xb0,0xc1,0x7c,0x00,0x00,0x00]

s_buffer_atomic_dec_x2 s[10:11], s[4:7], 0x0
// CHECK: [0x82,0x02,0xb2,0xc1,0x00,0x00,0x00,0x00]

s_buffer_atomic_dec_x2 s[10:11], s[4:7], s0 glc
// CHECK: [0x82,0x02,0xb1,0xc1,0x00,0x00,0x00,0x00]

s_atomic_swap s5, s[2:3], s0
// CHECK: [0x41,0x01,0x00,0xc2,0x00,0x00,0x00,0x00]

s_atomic_swap s101, s[2:3], s0
// CHECK: [0x41,0x19,0x00,0xc2,0x00,0x00,0x00,0x00]

s_atomic_swap flat_scratch_lo, s[2:3], s0
// CHECK: [0x81,0x19,0x00,0xc2,0x00,0x00,0x00,0x00]

s_atomic_swap flat_scratch_hi, s[2:3], s0
// CHECK: [0xc1,0x19,0x00,0xc2,0x00,0x00,0x00,0x00]

s_atomic_swap vcc_lo, s[2:3], s0
// CHECK: [0x81,0x1a,0x00,0xc2,0x00,0x00,0x00,0x00]

s_atomic_swap vcc_hi, s[2:3], s0
// CHECK: [0xc1,0x1a,0x00,0xc2,0x00,0x00,0x00,0x00]

s_atomic_swap ttmp15, s[2:3], s0
// CHECK: [0xc1,0x1e,0x00,0xc2,0x00,0x00,0x00,0x00]

s_atomic_swap s5, s[4:5], s0
// CHECK: [0x42,0x01,0x00,0xc2,0x00,0x00,0x00,0x00]

s_atomic_swap s5, s[100:101], s0
// CHECK: [0x72,0x01,0x00,0xc2,0x00,0x00,0x00,0x00]

s_atomic_swap s5, flat_scratch, s0
// CHECK: [0x73,0x01,0x00,0xc2,0x00,0x00,0x00,0x00]

s_atomic_swap s5, vcc, s0
// CHECK: [0x75,0x01,0x00,0xc2,0x00,0x00,0x00,0x00]

s_atomic_swap s5, ttmp[14:15], s0
// CHECK: [0x7d,0x01,0x00,0xc2,0x00,0x00,0x00,0x00]

s_atomic_swap s5, s[2:3], s101
// CHECK: [0x41,0x01,0x00,0xc2,0x65,0x00,0x00,0x00]

s_atomic_swap s5, s[2:3], flat_scratch_lo
// CHECK: [0x41,0x01,0x00,0xc2,0x66,0x00,0x00,0x00]

s_atomic_swap s5, s[2:3], flat_scratch_hi
// CHECK: [0x41,0x01,0x00,0xc2,0x67,0x00,0x00,0x00]

s_atomic_swap s5, s[2:3], vcc_lo
// CHECK: [0x41,0x01,0x00,0xc2,0x6a,0x00,0x00,0x00]

s_atomic_swap s5, s[2:3], vcc_hi
// CHECK: [0x41,0x01,0x00,0xc2,0x6b,0x00,0x00,0x00]

s_atomic_swap s5, s[2:3], ttmp15
// CHECK: [0x41,0x01,0x00,0xc2,0x7b,0x00,0x00,0x00]

s_atomic_swap s5, s[2:3], m0
// CHECK: [0x41,0x01,0x00,0xc2,0x7c,0x00,0x00,0x00]

s_atomic_swap s5, s[2:3], 0x0
// CHECK: [0x41,0x01,0x02,0xc2,0x00,0x00,0x00,0x00]

s_atomic_swap s5, s[2:3], s0 glc
// CHECK: [0x41,0x01,0x01,0xc2,0x00,0x00,0x00,0x00]

s_atomic_cmpswap s[10:11], s[2:3], s0
// CHECK: [0x81,0x02,0x04,0xc2,0x00,0x00,0x00,0x00]

s_atomic_cmpswap s[12:13], s[2:3], s0
// CHECK: [0x01,0x03,0x04,0xc2,0x00,0x00,0x00,0x00]

s_atomic_cmpswap s[100:101], s[2:3], s0
// CHECK: [0x01,0x19,0x04,0xc2,0x00,0x00,0x00,0x00]

s_atomic_cmpswap flat_scratch, s[2:3], s0
// CHECK: [0x81,0x19,0x04,0xc2,0x00,0x00,0x00,0x00]

s_atomic_cmpswap vcc, s[2:3], s0
// CHECK: [0x81,0x1a,0x04,0xc2,0x00,0x00,0x00,0x00]

s_atomic_cmpswap ttmp[14:15], s[2:3], s0
// CHECK: [0x81,0x1e,0x04,0xc2,0x00,0x00,0x00,0x00]

s_atomic_cmpswap s[10:11], s[4:5], s0
// CHECK: [0x82,0x02,0x04,0xc2,0x00,0x00,0x00,0x00]

s_atomic_cmpswap s[10:11], s[100:101], s0
// CHECK: [0xb2,0x02,0x04,0xc2,0x00,0x00,0x00,0x00]

s_atomic_cmpswap s[10:11], flat_scratch, s0
// CHECK: [0xb3,0x02,0x04,0xc2,0x00,0x00,0x00,0x00]

s_atomic_cmpswap s[10:11], vcc, s0
// CHECK: [0xb5,0x02,0x04,0xc2,0x00,0x00,0x00,0x00]

s_atomic_cmpswap s[10:11], ttmp[14:15], s0
// CHECK: [0xbd,0x02,0x04,0xc2,0x00,0x00,0x00,0x00]

s_atomic_cmpswap s[10:11], s[2:3], s101
// CHECK: [0x81,0x02,0x04,0xc2,0x65,0x00,0x00,0x00]

s_atomic_cmpswap s[10:11], s[2:3], flat_scratch_lo
// CHECK: [0x81,0x02,0x04,0xc2,0x66,0x00,0x00,0x00]

s_atomic_cmpswap s[10:11], s[2:3], flat_scratch_hi
// CHECK: [0x81,0x02,0x04,0xc2,0x67,0x00,0x00,0x00]

s_atomic_cmpswap s[10:11], s[2:3], vcc_lo
// CHECK: [0x81,0x02,0x04,0xc2,0x6a,0x00,0x00,0x00]

s_atomic_cmpswap s[10:11], s[2:3], vcc_hi
// CHECK: [0x81,0x02,0x04,0xc2,0x6b,0x00,0x00,0x00]

s_atomic_cmpswap s[10:11], s[2:3], ttmp15
// CHECK: [0x81,0x02,0x04,0xc2,0x7b,0x00,0x00,0x00]

s_atomic_cmpswap s[10:11], s[2:3], m0
// CHECK: [0x81,0x02,0x04,0xc2,0x7c,0x00,0x00,0x00]

s_atomic_cmpswap s[10:11], s[2:3], 0x0
// CHECK: [0x81,0x02,0x06,0xc2,0x00,0x00,0x00,0x00]

s_atomic_cmpswap s[10:11], s[2:3], s0 glc
// CHECK: [0x81,0x02,0x05,0xc2,0x00,0x00,0x00,0x00]

s_atomic_add s5, s[2:3], s0
// CHECK: [0x41,0x01,0x08,0xc2,0x00,0x00,0x00,0x00]

s_atomic_add s101, s[2:3], s0
// CHECK: [0x41,0x19,0x08,0xc2,0x00,0x00,0x00,0x00]

s_atomic_add flat_scratch_lo, s[2:3], s0
// CHECK: [0x81,0x19,0x08,0xc2,0x00,0x00,0x00,0x00]

s_atomic_add flat_scratch_hi, s[2:3], s0
// CHECK: [0xc1,0x19,0x08,0xc2,0x00,0x00,0x00,0x00]

s_atomic_add vcc_lo, s[2:3], s0
// CHECK: [0x81,0x1a,0x08,0xc2,0x00,0x00,0x00,0x00]

s_atomic_add vcc_hi, s[2:3], s0
// CHECK: [0xc1,0x1a,0x08,0xc2,0x00,0x00,0x00,0x00]

s_atomic_add ttmp15, s[2:3], s0
// CHECK: [0xc1,0x1e,0x08,0xc2,0x00,0x00,0x00,0x00]

s_atomic_add s5, s[4:5], s0
// CHECK: [0x42,0x01,0x08,0xc2,0x00,0x00,0x00,0x00]

s_atomic_add s5, s[100:101], s0
// CHECK: [0x72,0x01,0x08,0xc2,0x00,0x00,0x00,0x00]

s_atomic_add s5, flat_scratch, s0
// CHECK: [0x73,0x01,0x08,0xc2,0x00,0x00,0x00,0x00]

s_atomic_add s5, vcc, s0
// CHECK: [0x75,0x01,0x08,0xc2,0x00,0x00,0x00,0x00]

s_atomic_add s5, ttmp[14:15], s0
// CHECK: [0x7d,0x01,0x08,0xc2,0x00,0x00,0x00,0x00]

s_atomic_add s5, s[2:3], s101
// CHECK: [0x41,0x01,0x08,0xc2,0x65,0x00,0x00,0x00]

s_atomic_add s5, s[2:3], flat_scratch_lo
// CHECK: [0x41,0x01,0x08,0xc2,0x66,0x00,0x00,0x00]

s_atomic_add s5, s[2:3], flat_scratch_hi
// CHECK: [0x41,0x01,0x08,0xc2,0x67,0x00,0x00,0x00]

s_atomic_add s5, s[2:3], vcc_lo
// CHECK: [0x41,0x01,0x08,0xc2,0x6a,0x00,0x00,0x00]

s_atomic_add s5, s[2:3], vcc_hi
// CHECK: [0x41,0x01,0x08,0xc2,0x6b,0x00,0x00,0x00]

s_atomic_add s5, s[2:3], ttmp15
// CHECK: [0x41,0x01,0x08,0xc2,0x7b,0x00,0x00,0x00]

s_atomic_add s5, s[2:3], m0
// CHECK: [0x41,0x01,0x08,0xc2,0x7c,0x00,0x00,0x00]

s_atomic_add s5, s[2:3], 0x0
// CHECK: [0x41,0x01,0x0a,0xc2,0x00,0x00,0x00,0x00]

s_atomic_add s5, s[2:3], s7 offset:0x12345
// CHECK: [0x41,0x41,0x0a,0xc2,0x45,0x23,0x01,0x0e]

s_atomic_add s5, s[2:3], s0 glc
// CHECK: [0x41,0x01,0x09,0xc2,0x00,0x00,0x00,0x00]

s_atomic_add s5, s[2:3], s7 offset:0x12345 glc
// CHECK: [0x41,0x41,0x0b,0xc2,0x45,0x23,0x01,0x0e]

s_atomic_sub s5, s[2:3], s0
// CHECK: [0x41,0x01,0x0c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_sub s101, s[2:3], s0
// CHECK: [0x41,0x19,0x0c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_sub flat_scratch_lo, s[2:3], s0
// CHECK: [0x81,0x19,0x0c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_sub flat_scratch_hi, s[2:3], s0
// CHECK: [0xc1,0x19,0x0c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_sub vcc_lo, s[2:3], s0
// CHECK: [0x81,0x1a,0x0c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_sub vcc_hi, s[2:3], s0
// CHECK: [0xc1,0x1a,0x0c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_sub ttmp15, s[2:3], s0
// CHECK: [0xc1,0x1e,0x0c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_sub s5, s[4:5], s0
// CHECK: [0x42,0x01,0x0c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_sub s5, s[100:101], s0
// CHECK: [0x72,0x01,0x0c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_sub s5, flat_scratch, s0
// CHECK: [0x73,0x01,0x0c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_sub s5, vcc, s0
// CHECK: [0x75,0x01,0x0c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_sub s5, ttmp[14:15], s0
// CHECK: [0x7d,0x01,0x0c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_sub s5, s[2:3], s101
// CHECK: [0x41,0x01,0x0c,0xc2,0x65,0x00,0x00,0x00]

s_atomic_sub s5, s[2:3], flat_scratch_lo
// CHECK: [0x41,0x01,0x0c,0xc2,0x66,0x00,0x00,0x00]

s_atomic_sub s5, s[2:3], flat_scratch_hi
// CHECK: [0x41,0x01,0x0c,0xc2,0x67,0x00,0x00,0x00]

s_atomic_sub s5, s[2:3], vcc_lo
// CHECK: [0x41,0x01,0x0c,0xc2,0x6a,0x00,0x00,0x00]

s_atomic_sub s5, s[2:3], vcc_hi
// CHECK: [0x41,0x01,0x0c,0xc2,0x6b,0x00,0x00,0x00]

s_atomic_sub s5, s[2:3], ttmp15
// CHECK: [0x41,0x01,0x0c,0xc2,0x7b,0x00,0x00,0x00]

s_atomic_sub s5, s[2:3], m0
// CHECK: [0x41,0x01,0x0c,0xc2,0x7c,0x00,0x00,0x00]

s_atomic_sub s5, s[2:3], 0x0
// CHECK: [0x41,0x01,0x0e,0xc2,0x00,0x00,0x00,0x00]

s_atomic_sub s5, s[2:3], s0 glc
// CHECK: [0x41,0x01,0x0d,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smin s5, s[2:3], s0
// CHECK: [0x41,0x01,0x10,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smin s101, s[2:3], s0
// CHECK: [0x41,0x19,0x10,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smin flat_scratch_lo, s[2:3], s0
// CHECK: [0x81,0x19,0x10,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smin flat_scratch_hi, s[2:3], s0
// CHECK: [0xc1,0x19,0x10,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smin vcc_lo, s[2:3], s0
// CHECK: [0x81,0x1a,0x10,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smin vcc_hi, s[2:3], s0
// CHECK: [0xc1,0x1a,0x10,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smin ttmp15, s[2:3], s0
// CHECK: [0xc1,0x1e,0x10,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smin s5, s[4:5], s0
// CHECK: [0x42,0x01,0x10,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smin s5, s[100:101], s0
// CHECK: [0x72,0x01,0x10,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smin s5, flat_scratch, s0
// CHECK: [0x73,0x01,0x10,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smin s5, vcc, s0
// CHECK: [0x75,0x01,0x10,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smin s5, ttmp[14:15], s0
// CHECK: [0x7d,0x01,0x10,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smin s5, s[2:3], s101
// CHECK: [0x41,0x01,0x10,0xc2,0x65,0x00,0x00,0x00]

s_atomic_smin s5, s[2:3], flat_scratch_lo
// CHECK: [0x41,0x01,0x10,0xc2,0x66,0x00,0x00,0x00]

s_atomic_smin s5, s[2:3], flat_scratch_hi
// CHECK: [0x41,0x01,0x10,0xc2,0x67,0x00,0x00,0x00]

s_atomic_smin s5, s[2:3], vcc_lo
// CHECK: [0x41,0x01,0x10,0xc2,0x6a,0x00,0x00,0x00]

s_atomic_smin s5, s[2:3], vcc_hi
// CHECK: [0x41,0x01,0x10,0xc2,0x6b,0x00,0x00,0x00]

s_atomic_smin s5, s[2:3], ttmp15
// CHECK: [0x41,0x01,0x10,0xc2,0x7b,0x00,0x00,0x00]

s_atomic_smin s5, s[2:3], m0
// CHECK: [0x41,0x01,0x10,0xc2,0x7c,0x00,0x00,0x00]

s_atomic_smin s5, s[2:3], 0x0
// CHECK: [0x41,0x01,0x12,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smin s5, s[2:3], s0 glc
// CHECK: [0x41,0x01,0x11,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umin s5, s[2:3], s0
// CHECK: [0x41,0x01,0x14,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umin s101, s[2:3], s0
// CHECK: [0x41,0x19,0x14,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umin flat_scratch_lo, s[2:3], s0
// CHECK: [0x81,0x19,0x14,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umin flat_scratch_hi, s[2:3], s0
// CHECK: [0xc1,0x19,0x14,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umin vcc_lo, s[2:3], s0
// CHECK: [0x81,0x1a,0x14,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umin vcc_hi, s[2:3], s0
// CHECK: [0xc1,0x1a,0x14,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umin ttmp15, s[2:3], s0
// CHECK: [0xc1,0x1e,0x14,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umin s5, s[4:5], s0
// CHECK: [0x42,0x01,0x14,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umin s5, s[100:101], s0
// CHECK: [0x72,0x01,0x14,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umin s5, flat_scratch, s0
// CHECK: [0x73,0x01,0x14,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umin s5, vcc, s0
// CHECK: [0x75,0x01,0x14,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umin s5, ttmp[14:15], s0
// CHECK: [0x7d,0x01,0x14,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umin s5, s[2:3], s101
// CHECK: [0x41,0x01,0x14,0xc2,0x65,0x00,0x00,0x00]

s_atomic_umin s5, s[2:3], flat_scratch_lo
// CHECK: [0x41,0x01,0x14,0xc2,0x66,0x00,0x00,0x00]

s_atomic_umin s5, s[2:3], flat_scratch_hi
// CHECK: [0x41,0x01,0x14,0xc2,0x67,0x00,0x00,0x00]

s_atomic_umin s5, s[2:3], vcc_lo
// CHECK: [0x41,0x01,0x14,0xc2,0x6a,0x00,0x00,0x00]

s_atomic_umin s5, s[2:3], vcc_hi
// CHECK: [0x41,0x01,0x14,0xc2,0x6b,0x00,0x00,0x00]

s_atomic_umin s5, s[2:3], ttmp15
// CHECK: [0x41,0x01,0x14,0xc2,0x7b,0x00,0x00,0x00]

s_atomic_umin s5, s[2:3], m0
// CHECK: [0x41,0x01,0x14,0xc2,0x7c,0x00,0x00,0x00]

s_atomic_umin s5, s[2:3], 0x0
// CHECK: [0x41,0x01,0x16,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umin s5, s[2:3], s0 glc
// CHECK: [0x41,0x01,0x15,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smax s5, s[2:3], s0
// CHECK: [0x41,0x01,0x18,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smax s101, s[2:3], s0
// CHECK: [0x41,0x19,0x18,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smax flat_scratch_lo, s[2:3], s0
// CHECK: [0x81,0x19,0x18,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smax flat_scratch_hi, s[2:3], s0
// CHECK: [0xc1,0x19,0x18,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smax vcc_lo, s[2:3], s0
// CHECK: [0x81,0x1a,0x18,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smax vcc_hi, s[2:3], s0
// CHECK: [0xc1,0x1a,0x18,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smax ttmp15, s[2:3], s0
// CHECK: [0xc1,0x1e,0x18,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smax s5, s[4:5], s0
// CHECK: [0x42,0x01,0x18,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smax s5, s[100:101], s0
// CHECK: [0x72,0x01,0x18,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smax s5, flat_scratch, s0
// CHECK: [0x73,0x01,0x18,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smax s5, vcc, s0
// CHECK: [0x75,0x01,0x18,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smax s5, ttmp[14:15], s0
// CHECK: [0x7d,0x01,0x18,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smax s5, s[2:3], s101
// CHECK: [0x41,0x01,0x18,0xc2,0x65,0x00,0x00,0x00]

s_atomic_smax s5, s[2:3], flat_scratch_lo
// CHECK: [0x41,0x01,0x18,0xc2,0x66,0x00,0x00,0x00]

s_atomic_smax s5, s[2:3], flat_scratch_hi
// CHECK: [0x41,0x01,0x18,0xc2,0x67,0x00,0x00,0x00]

s_atomic_smax s5, s[2:3], vcc_lo
// CHECK: [0x41,0x01,0x18,0xc2,0x6a,0x00,0x00,0x00]

s_atomic_smax s5, s[2:3], vcc_hi
// CHECK: [0x41,0x01,0x18,0xc2,0x6b,0x00,0x00,0x00]

s_atomic_smax s5, s[2:3], ttmp15
// CHECK: [0x41,0x01,0x18,0xc2,0x7b,0x00,0x00,0x00]

s_atomic_smax s5, s[2:3], m0
// CHECK: [0x41,0x01,0x18,0xc2,0x7c,0x00,0x00,0x00]

s_atomic_smax s5, s[2:3], 0x0
// CHECK: [0x41,0x01,0x1a,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smax s5, s[2:3], s0 glc
// CHECK: [0x41,0x01,0x19,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umax s5, s[2:3], s0
// CHECK: [0x41,0x01,0x1c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umax s101, s[2:3], s0
// CHECK: [0x41,0x19,0x1c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umax flat_scratch_lo, s[2:3], s0
// CHECK: [0x81,0x19,0x1c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umax flat_scratch_hi, s[2:3], s0
// CHECK: [0xc1,0x19,0x1c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umax vcc_lo, s[2:3], s0
// CHECK: [0x81,0x1a,0x1c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umax vcc_hi, s[2:3], s0
// CHECK: [0xc1,0x1a,0x1c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umax ttmp15, s[2:3], s0
// CHECK: [0xc1,0x1e,0x1c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umax s5, s[4:5], s0
// CHECK: [0x42,0x01,0x1c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umax s5, s[100:101], s0
// CHECK: [0x72,0x01,0x1c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umax s5, flat_scratch, s0
// CHECK: [0x73,0x01,0x1c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umax s5, vcc, s0
// CHECK: [0x75,0x01,0x1c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umax s5, ttmp[14:15], s0
// CHECK: [0x7d,0x01,0x1c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umax s5, s[2:3], s101
// CHECK: [0x41,0x01,0x1c,0xc2,0x65,0x00,0x00,0x00]

s_atomic_umax s5, s[2:3], flat_scratch_lo
// CHECK: [0x41,0x01,0x1c,0xc2,0x66,0x00,0x00,0x00]

s_atomic_umax s5, s[2:3], flat_scratch_hi
// CHECK: [0x41,0x01,0x1c,0xc2,0x67,0x00,0x00,0x00]

s_atomic_umax s5, s[2:3], vcc_lo
// CHECK: [0x41,0x01,0x1c,0xc2,0x6a,0x00,0x00,0x00]

s_atomic_umax s5, s[2:3], vcc_hi
// CHECK: [0x41,0x01,0x1c,0xc2,0x6b,0x00,0x00,0x00]

s_atomic_umax s5, s[2:3], ttmp15
// CHECK: [0x41,0x01,0x1c,0xc2,0x7b,0x00,0x00,0x00]

s_atomic_umax s5, s[2:3], m0
// CHECK: [0x41,0x01,0x1c,0xc2,0x7c,0x00,0x00,0x00]

s_atomic_umax s5, s[2:3], 0x0
// CHECK: [0x41,0x01,0x1e,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umax s5, s[2:3], s0 glc
// CHECK: [0x41,0x01,0x1d,0xc2,0x00,0x00,0x00,0x00]

s_atomic_and s5, s[2:3], s0
// CHECK: [0x41,0x01,0x20,0xc2,0x00,0x00,0x00,0x00]

s_atomic_and s101, s[2:3], s0
// CHECK: [0x41,0x19,0x20,0xc2,0x00,0x00,0x00,0x00]

s_atomic_and flat_scratch_lo, s[2:3], s0
// CHECK: [0x81,0x19,0x20,0xc2,0x00,0x00,0x00,0x00]

s_atomic_and flat_scratch_hi, s[2:3], s0
// CHECK: [0xc1,0x19,0x20,0xc2,0x00,0x00,0x00,0x00]

s_atomic_and vcc_lo, s[2:3], s0
// CHECK: [0x81,0x1a,0x20,0xc2,0x00,0x00,0x00,0x00]

s_atomic_and vcc_hi, s[2:3], s0
// CHECK: [0xc1,0x1a,0x20,0xc2,0x00,0x00,0x00,0x00]

s_atomic_and ttmp15, s[2:3], s0
// CHECK: [0xc1,0x1e,0x20,0xc2,0x00,0x00,0x00,0x00]

s_atomic_and s5, s[4:5], s0
// CHECK: [0x42,0x01,0x20,0xc2,0x00,0x00,0x00,0x00]

s_atomic_and s5, s[100:101], s0
// CHECK: [0x72,0x01,0x20,0xc2,0x00,0x00,0x00,0x00]

s_atomic_and s5, flat_scratch, s0
// CHECK: [0x73,0x01,0x20,0xc2,0x00,0x00,0x00,0x00]

s_atomic_and s5, vcc, s0
// CHECK: [0x75,0x01,0x20,0xc2,0x00,0x00,0x00,0x00]

s_atomic_and s5, ttmp[14:15], s0
// CHECK: [0x7d,0x01,0x20,0xc2,0x00,0x00,0x00,0x00]

s_atomic_and s5, s[2:3], s101
// CHECK: [0x41,0x01,0x20,0xc2,0x65,0x00,0x00,0x00]

s_atomic_and s5, s[2:3], flat_scratch_lo
// CHECK: [0x41,0x01,0x20,0xc2,0x66,0x00,0x00,0x00]

s_atomic_and s5, s[2:3], flat_scratch_hi
// CHECK: [0x41,0x01,0x20,0xc2,0x67,0x00,0x00,0x00]

s_atomic_and s5, s[2:3], vcc_lo
// CHECK: [0x41,0x01,0x20,0xc2,0x6a,0x00,0x00,0x00]

s_atomic_and s5, s[2:3], vcc_hi
// CHECK: [0x41,0x01,0x20,0xc2,0x6b,0x00,0x00,0x00]

s_atomic_and s5, s[2:3], ttmp15
// CHECK: [0x41,0x01,0x20,0xc2,0x7b,0x00,0x00,0x00]

s_atomic_and s5, s[2:3], m0
// CHECK: [0x41,0x01,0x20,0xc2,0x7c,0x00,0x00,0x00]

s_atomic_and s5, s[2:3], 0x0
// CHECK: [0x41,0x01,0x22,0xc2,0x00,0x00,0x00,0x00]

s_atomic_and s5, s[2:3], s0 glc
// CHECK: [0x41,0x01,0x21,0xc2,0x00,0x00,0x00,0x00]

s_atomic_or s5, s[2:3], s0
// CHECK: [0x41,0x01,0x24,0xc2,0x00,0x00,0x00,0x00]

s_atomic_or s101, s[2:3], s0
// CHECK: [0x41,0x19,0x24,0xc2,0x00,0x00,0x00,0x00]

s_atomic_or flat_scratch_lo, s[2:3], s0
// CHECK: [0x81,0x19,0x24,0xc2,0x00,0x00,0x00,0x00]

s_atomic_or flat_scratch_hi, s[2:3], s0
// CHECK: [0xc1,0x19,0x24,0xc2,0x00,0x00,0x00,0x00]

s_atomic_or vcc_lo, s[2:3], s0
// CHECK: [0x81,0x1a,0x24,0xc2,0x00,0x00,0x00,0x00]

s_atomic_or vcc_hi, s[2:3], s0
// CHECK: [0xc1,0x1a,0x24,0xc2,0x00,0x00,0x00,0x00]

s_atomic_or ttmp15, s[2:3], s0
// CHECK: [0xc1,0x1e,0x24,0xc2,0x00,0x00,0x00,0x00]

s_atomic_or s5, s[4:5], s0
// CHECK: [0x42,0x01,0x24,0xc2,0x00,0x00,0x00,0x00]

s_atomic_or s5, s[100:101], s0
// CHECK: [0x72,0x01,0x24,0xc2,0x00,0x00,0x00,0x00]

s_atomic_or s5, flat_scratch, s0
// CHECK: [0x73,0x01,0x24,0xc2,0x00,0x00,0x00,0x00]

s_atomic_or s5, vcc, s0
// CHECK: [0x75,0x01,0x24,0xc2,0x00,0x00,0x00,0x00]

s_atomic_or s5, ttmp[14:15], s0
// CHECK: [0x7d,0x01,0x24,0xc2,0x00,0x00,0x00,0x00]

s_atomic_or s5, s[2:3], s101
// CHECK: [0x41,0x01,0x24,0xc2,0x65,0x00,0x00,0x00]

s_atomic_or s5, s[2:3], flat_scratch_lo
// CHECK: [0x41,0x01,0x24,0xc2,0x66,0x00,0x00,0x00]

s_atomic_or s5, s[2:3], flat_scratch_hi
// CHECK: [0x41,0x01,0x24,0xc2,0x67,0x00,0x00,0x00]

s_atomic_or s5, s[2:3], vcc_lo
// CHECK: [0x41,0x01,0x24,0xc2,0x6a,0x00,0x00,0x00]

s_atomic_or s5, s[2:3], vcc_hi
// CHECK: [0x41,0x01,0x24,0xc2,0x6b,0x00,0x00,0x00]

s_atomic_or s5, s[2:3], ttmp15
// CHECK: [0x41,0x01,0x24,0xc2,0x7b,0x00,0x00,0x00]

s_atomic_or s5, s[2:3], m0
// CHECK: [0x41,0x01,0x24,0xc2,0x7c,0x00,0x00,0x00]

s_atomic_or s5, s[2:3], 0x0
// CHECK: [0x41,0x01,0x26,0xc2,0x00,0x00,0x00,0x00]

s_atomic_or s5, s[2:3], s0 glc
// CHECK: [0x41,0x01,0x25,0xc2,0x00,0x00,0x00,0x00]

s_atomic_xor s5, s[2:3], s0
// CHECK: [0x41,0x01,0x28,0xc2,0x00,0x00,0x00,0x00]

s_atomic_xor s101, s[2:3], s0
// CHECK: [0x41,0x19,0x28,0xc2,0x00,0x00,0x00,0x00]

s_atomic_xor flat_scratch_lo, s[2:3], s0
// CHECK: [0x81,0x19,0x28,0xc2,0x00,0x00,0x00,0x00]

s_atomic_xor flat_scratch_hi, s[2:3], s0
// CHECK: [0xc1,0x19,0x28,0xc2,0x00,0x00,0x00,0x00]

s_atomic_xor vcc_lo, s[2:3], s0
// CHECK: [0x81,0x1a,0x28,0xc2,0x00,0x00,0x00,0x00]

s_atomic_xor vcc_hi, s[2:3], s0
// CHECK: [0xc1,0x1a,0x28,0xc2,0x00,0x00,0x00,0x00]

s_atomic_xor ttmp15, s[2:3], s0
// CHECK: [0xc1,0x1e,0x28,0xc2,0x00,0x00,0x00,0x00]

s_atomic_xor s5, s[4:5], s0
// CHECK: [0x42,0x01,0x28,0xc2,0x00,0x00,0x00,0x00]

s_atomic_xor s5, s[100:101], s0
// CHECK: [0x72,0x01,0x28,0xc2,0x00,0x00,0x00,0x00]

s_atomic_xor s5, flat_scratch, s0
// CHECK: [0x73,0x01,0x28,0xc2,0x00,0x00,0x00,0x00]

s_atomic_xor s5, vcc, s0
// CHECK: [0x75,0x01,0x28,0xc2,0x00,0x00,0x00,0x00]

s_atomic_xor s5, ttmp[14:15], s0
// CHECK: [0x7d,0x01,0x28,0xc2,0x00,0x00,0x00,0x00]

s_atomic_xor s5, s[2:3], s101
// CHECK: [0x41,0x01,0x28,0xc2,0x65,0x00,0x00,0x00]

s_atomic_xor s5, s[2:3], flat_scratch_lo
// CHECK: [0x41,0x01,0x28,0xc2,0x66,0x00,0x00,0x00]

s_atomic_xor s5, s[2:3], flat_scratch_hi
// CHECK: [0x41,0x01,0x28,0xc2,0x67,0x00,0x00,0x00]

s_atomic_xor s5, s[2:3], vcc_lo
// CHECK: [0x41,0x01,0x28,0xc2,0x6a,0x00,0x00,0x00]

s_atomic_xor s5, s[2:3], vcc_hi
// CHECK: [0x41,0x01,0x28,0xc2,0x6b,0x00,0x00,0x00]

s_atomic_xor s5, s[2:3], ttmp15
// CHECK: [0x41,0x01,0x28,0xc2,0x7b,0x00,0x00,0x00]

s_atomic_xor s5, s[2:3], m0
// CHECK: [0x41,0x01,0x28,0xc2,0x7c,0x00,0x00,0x00]

s_atomic_xor s5, s[2:3], 0x0
// CHECK: [0x41,0x01,0x2a,0xc2,0x00,0x00,0x00,0x00]

s_atomic_xor s5, s[2:3], s0 glc
// CHECK: [0x41,0x01,0x29,0xc2,0x00,0x00,0x00,0x00]

s_atomic_inc s5, s[2:3], s0
// CHECK: [0x41,0x01,0x2c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_inc s101, s[2:3], s0
// CHECK: [0x41,0x19,0x2c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_inc flat_scratch_lo, s[2:3], s0
// CHECK: [0x81,0x19,0x2c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_inc flat_scratch_hi, s[2:3], s0
// CHECK: [0xc1,0x19,0x2c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_inc vcc_lo, s[2:3], s0
// CHECK: [0x81,0x1a,0x2c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_inc vcc_hi, s[2:3], s0
// CHECK: [0xc1,0x1a,0x2c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_inc ttmp15, s[2:3], s0
// CHECK: [0xc1,0x1e,0x2c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_inc s5, s[4:5], s0
// CHECK: [0x42,0x01,0x2c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_inc s5, s[100:101], s0
// CHECK: [0x72,0x01,0x2c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_inc s5, flat_scratch, s0
// CHECK: [0x73,0x01,0x2c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_inc s5, vcc, s0
// CHECK: [0x75,0x01,0x2c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_inc s5, ttmp[14:15], s0
// CHECK: [0x7d,0x01,0x2c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_inc s5, s[2:3], s101
// CHECK: [0x41,0x01,0x2c,0xc2,0x65,0x00,0x00,0x00]

s_atomic_inc s5, s[2:3], flat_scratch_lo
// CHECK: [0x41,0x01,0x2c,0xc2,0x66,0x00,0x00,0x00]

s_atomic_inc s5, s[2:3], flat_scratch_hi
// CHECK: [0x41,0x01,0x2c,0xc2,0x67,0x00,0x00,0x00]

s_atomic_inc s5, s[2:3], vcc_lo
// CHECK: [0x41,0x01,0x2c,0xc2,0x6a,0x00,0x00,0x00]

s_atomic_inc s5, s[2:3], vcc_hi
// CHECK: [0x41,0x01,0x2c,0xc2,0x6b,0x00,0x00,0x00]

s_atomic_inc s5, s[2:3], ttmp15
// CHECK: [0x41,0x01,0x2c,0xc2,0x7b,0x00,0x00,0x00]

s_atomic_inc s5, s[2:3], m0
// CHECK: [0x41,0x01,0x2c,0xc2,0x7c,0x00,0x00,0x00]

s_atomic_inc s5, s[2:3], 0x0
// CHECK: [0x41,0x01,0x2e,0xc2,0x00,0x00,0x00,0x00]

s_atomic_inc s5, s[2:3], s0 glc
// CHECK: [0x41,0x01,0x2d,0xc2,0x00,0x00,0x00,0x00]

s_atomic_dec s5, s[2:3], s0
// CHECK: [0x41,0x01,0x30,0xc2,0x00,0x00,0x00,0x00]

s_atomic_dec s101, s[2:3], s0
// CHECK: [0x41,0x19,0x30,0xc2,0x00,0x00,0x00,0x00]

s_atomic_dec flat_scratch_lo, s[2:3], s0
// CHECK: [0x81,0x19,0x30,0xc2,0x00,0x00,0x00,0x00]

s_atomic_dec flat_scratch_hi, s[2:3], s0
// CHECK: [0xc1,0x19,0x30,0xc2,0x00,0x00,0x00,0x00]

s_atomic_dec vcc_lo, s[2:3], s0
// CHECK: [0x81,0x1a,0x30,0xc2,0x00,0x00,0x00,0x00]

s_atomic_dec vcc_hi, s[2:3], s0
// CHECK: [0xc1,0x1a,0x30,0xc2,0x00,0x00,0x00,0x00]

s_atomic_dec ttmp15, s[2:3], s0
// CHECK: [0xc1,0x1e,0x30,0xc2,0x00,0x00,0x00,0x00]

s_atomic_dec s5, s[4:5], s0
// CHECK: [0x42,0x01,0x30,0xc2,0x00,0x00,0x00,0x00]

s_atomic_dec s5, s[100:101], s0
// CHECK: [0x72,0x01,0x30,0xc2,0x00,0x00,0x00,0x00]

s_atomic_dec s5, flat_scratch, s0
// CHECK: [0x73,0x01,0x30,0xc2,0x00,0x00,0x00,0x00]

s_atomic_dec s5, vcc, s0
// CHECK: [0x75,0x01,0x30,0xc2,0x00,0x00,0x00,0x00]

s_atomic_dec s5, ttmp[14:15], s0
// CHECK: [0x7d,0x01,0x30,0xc2,0x00,0x00,0x00,0x00]

s_atomic_dec s5, s[2:3], s101
// CHECK: [0x41,0x01,0x30,0xc2,0x65,0x00,0x00,0x00]

s_atomic_dec s5, s[2:3], flat_scratch_lo
// CHECK: [0x41,0x01,0x30,0xc2,0x66,0x00,0x00,0x00]

s_atomic_dec s5, s[2:3], flat_scratch_hi
// CHECK: [0x41,0x01,0x30,0xc2,0x67,0x00,0x00,0x00]

s_atomic_dec s5, s[2:3], vcc_lo
// CHECK: [0x41,0x01,0x30,0xc2,0x6a,0x00,0x00,0x00]

s_atomic_dec s5, s[2:3], vcc_hi
// CHECK: [0x41,0x01,0x30,0xc2,0x6b,0x00,0x00,0x00]

s_atomic_dec s5, s[2:3], ttmp15
// CHECK: [0x41,0x01,0x30,0xc2,0x7b,0x00,0x00,0x00]

s_atomic_dec s5, s[2:3], m0
// CHECK: [0x41,0x01,0x30,0xc2,0x7c,0x00,0x00,0x00]

s_atomic_dec s5, s[2:3], 0x0
// CHECK: [0x41,0x01,0x32,0xc2,0x00,0x00,0x00,0x00]

s_atomic_dec s5, s[2:3], s0 glc
// CHECK: [0x41,0x01,0x31,0xc2,0x00,0x00,0x00,0x00]

s_atomic_swap_x2 s[10:11], s[2:3], s0
// CHECK: [0x81,0x02,0x80,0xc2,0x00,0x00,0x00,0x00]

s_atomic_swap_x2 s[12:13], s[2:3], s0
// CHECK: [0x01,0x03,0x80,0xc2,0x00,0x00,0x00,0x00]

s_atomic_swap_x2 s[100:101], s[2:3], s0
// CHECK: [0x01,0x19,0x80,0xc2,0x00,0x00,0x00,0x00]

s_atomic_swap_x2 flat_scratch, s[2:3], s0
// CHECK: [0x81,0x19,0x80,0xc2,0x00,0x00,0x00,0x00]

s_atomic_swap_x2 vcc, s[2:3], s0
// CHECK: [0x81,0x1a,0x80,0xc2,0x00,0x00,0x00,0x00]

s_atomic_swap_x2 ttmp[14:15], s[2:3], s0
// CHECK: [0x81,0x1e,0x80,0xc2,0x00,0x00,0x00,0x00]

s_atomic_swap_x2 s[10:11], s[4:5], s0
// CHECK: [0x82,0x02,0x80,0xc2,0x00,0x00,0x00,0x00]

s_atomic_swap_x2 s[10:11], s[100:101], s0
// CHECK: [0xb2,0x02,0x80,0xc2,0x00,0x00,0x00,0x00]

s_atomic_swap_x2 s[10:11], flat_scratch, s0
// CHECK: [0xb3,0x02,0x80,0xc2,0x00,0x00,0x00,0x00]

s_atomic_swap_x2 s[10:11], vcc, s0
// CHECK: [0xb5,0x02,0x80,0xc2,0x00,0x00,0x00,0x00]

s_atomic_swap_x2 s[10:11], ttmp[14:15], s0
// CHECK: [0xbd,0x02,0x80,0xc2,0x00,0x00,0x00,0x00]

s_atomic_swap_x2 s[10:11], s[2:3], s101
// CHECK: [0x81,0x02,0x80,0xc2,0x65,0x00,0x00,0x00]

s_atomic_swap_x2 s[10:11], s[2:3], flat_scratch_lo
// CHECK: [0x81,0x02,0x80,0xc2,0x66,0x00,0x00,0x00]

s_atomic_swap_x2 s[10:11], s[2:3], flat_scratch_hi
// CHECK: [0x81,0x02,0x80,0xc2,0x67,0x00,0x00,0x00]

s_atomic_swap_x2 s[10:11], s[2:3], vcc_lo
// CHECK: [0x81,0x02,0x80,0xc2,0x6a,0x00,0x00,0x00]

s_atomic_swap_x2 s[10:11], s[2:3], vcc_hi
// CHECK: [0x81,0x02,0x80,0xc2,0x6b,0x00,0x00,0x00]

s_atomic_swap_x2 s[10:11], s[2:3], ttmp15
// CHECK: [0x81,0x02,0x80,0xc2,0x7b,0x00,0x00,0x00]

s_atomic_swap_x2 s[10:11], s[2:3], m0
// CHECK: [0x81,0x02,0x80,0xc2,0x7c,0x00,0x00,0x00]

s_atomic_swap_x2 s[10:11], s[2:3], 0x0
// CHECK: [0x81,0x02,0x82,0xc2,0x00,0x00,0x00,0x00]

s_atomic_swap_x2 s[10:11], s[2:3], s0 glc
// CHECK: [0x81,0x02,0x81,0xc2,0x00,0x00,0x00,0x00]

s_atomic_cmpswap_x2 s[20:23], s[2:3], s0
// CHECK: [0x01,0x05,0x84,0xc2,0x00,0x00,0x00,0x00]

s_atomic_cmpswap_x2 s[24:27], s[2:3], s0
// CHECK: [0x01,0x06,0x84,0xc2,0x00,0x00,0x00,0x00]

s_atomic_cmpswap_x2 s[96:99], s[2:3], s0
// CHECK: [0x01,0x18,0x84,0xc2,0x00,0x00,0x00,0x00]

s_atomic_cmpswap_x2 ttmp[12:15], s[2:3], s0
// CHECK: [0x01,0x1e,0x84,0xc2,0x00,0x00,0x00,0x00]

s_atomic_cmpswap_x2 s[20:23], s[4:5], s0
// CHECK: [0x02,0x05,0x84,0xc2,0x00,0x00,0x00,0x00]

s_atomic_cmpswap_x2 s[20:23], s[100:101], s0
// CHECK: [0x32,0x05,0x84,0xc2,0x00,0x00,0x00,0x00]

s_atomic_cmpswap_x2 s[20:23], flat_scratch, s0
// CHECK: [0x33,0x05,0x84,0xc2,0x00,0x00,0x00,0x00]

s_atomic_cmpswap_x2 s[20:23], vcc, s0
// CHECK: [0x35,0x05,0x84,0xc2,0x00,0x00,0x00,0x00]

s_atomic_cmpswap_x2 s[20:23], ttmp[14:15], s0
// CHECK: [0x3d,0x05,0x84,0xc2,0x00,0x00,0x00,0x00]

s_atomic_cmpswap_x2 s[20:23], s[2:3], s101
// CHECK: [0x01,0x05,0x84,0xc2,0x65,0x00,0x00,0x00]

s_atomic_cmpswap_x2 s[20:23], s[2:3], flat_scratch_lo
// CHECK: [0x01,0x05,0x84,0xc2,0x66,0x00,0x00,0x00]

s_atomic_cmpswap_x2 s[20:23], s[2:3], flat_scratch_hi
// CHECK: [0x01,0x05,0x84,0xc2,0x67,0x00,0x00,0x00]

s_atomic_cmpswap_x2 s[20:23], s[2:3], vcc_lo
// CHECK: [0x01,0x05,0x84,0xc2,0x6a,0x00,0x00,0x00]

s_atomic_cmpswap_x2 s[20:23], s[2:3], vcc_hi
// CHECK: [0x01,0x05,0x84,0xc2,0x6b,0x00,0x00,0x00]

s_atomic_cmpswap_x2 s[20:23], s[2:3], ttmp15
// CHECK: [0x01,0x05,0x84,0xc2,0x7b,0x00,0x00,0x00]

s_atomic_cmpswap_x2 s[20:23], s[2:3], m0
// CHECK: [0x01,0x05,0x84,0xc2,0x7c,0x00,0x00,0x00]

s_atomic_cmpswap_x2 s[20:23], s[2:3], 0x0
// CHECK: [0x01,0x05,0x86,0xc2,0x00,0x00,0x00,0x00]

s_atomic_cmpswap_x2 s[20:23], s[2:3], s0 glc
// CHECK: [0x01,0x05,0x85,0xc2,0x00,0x00,0x00,0x00]

s_atomic_add_x2 s[10:11], s[2:3], s0
// CHECK: [0x81,0x02,0x88,0xc2,0x00,0x00,0x00,0x00]

s_atomic_add_x2 s[12:13], s[2:3], s0
// CHECK: [0x01,0x03,0x88,0xc2,0x00,0x00,0x00,0x00]

s_atomic_add_x2 s[100:101], s[2:3], s0
// CHECK: [0x01,0x19,0x88,0xc2,0x00,0x00,0x00,0x00]

s_atomic_add_x2 flat_scratch, s[2:3], s0
// CHECK: [0x81,0x19,0x88,0xc2,0x00,0x00,0x00,0x00]

s_atomic_add_x2 vcc, s[2:3], s0
// CHECK: [0x81,0x1a,0x88,0xc2,0x00,0x00,0x00,0x00]

s_atomic_add_x2 ttmp[14:15], s[2:3], s0
// CHECK: [0x81,0x1e,0x88,0xc2,0x00,0x00,0x00,0x00]

s_atomic_add_x2 s[10:11], s[4:5], s0
// CHECK: [0x82,0x02,0x88,0xc2,0x00,0x00,0x00,0x00]

s_atomic_add_x2 s[10:11], s[100:101], s0
// CHECK: [0xb2,0x02,0x88,0xc2,0x00,0x00,0x00,0x00]

s_atomic_add_x2 s[10:11], flat_scratch, s0
// CHECK: [0xb3,0x02,0x88,0xc2,0x00,0x00,0x00,0x00]

s_atomic_add_x2 s[10:11], vcc, s0
// CHECK: [0xb5,0x02,0x88,0xc2,0x00,0x00,0x00,0x00]

s_atomic_add_x2 s[10:11], ttmp[14:15], s0
// CHECK: [0xbd,0x02,0x88,0xc2,0x00,0x00,0x00,0x00]

s_atomic_add_x2 s[10:11], s[2:3], s101
// CHECK: [0x81,0x02,0x88,0xc2,0x65,0x00,0x00,0x00]

s_atomic_add_x2 s[10:11], s[2:3], flat_scratch_lo
// CHECK: [0x81,0x02,0x88,0xc2,0x66,0x00,0x00,0x00]

s_atomic_add_x2 s[10:11], s[2:3], flat_scratch_hi
// CHECK: [0x81,0x02,0x88,0xc2,0x67,0x00,0x00,0x00]

s_atomic_add_x2 s[10:11], s[2:3], vcc_lo
// CHECK: [0x81,0x02,0x88,0xc2,0x6a,0x00,0x00,0x00]

s_atomic_add_x2 s[10:11], s[2:3], vcc_hi
// CHECK: [0x81,0x02,0x88,0xc2,0x6b,0x00,0x00,0x00]

s_atomic_add_x2 s[10:11], s[2:3], ttmp15
// CHECK: [0x81,0x02,0x88,0xc2,0x7b,0x00,0x00,0x00]

s_atomic_add_x2 s[10:11], s[2:3], m0
// CHECK: [0x81,0x02,0x88,0xc2,0x7c,0x00,0x00,0x00]

s_atomic_add_x2 s[10:11], s[2:3], 0x0
// CHECK: [0x81,0x02,0x8a,0xc2,0x00,0x00,0x00,0x00]

s_atomic_add_x2 s[10:11], s[2:3], s0 glc
// CHECK: [0x81,0x02,0x89,0xc2,0x00,0x00,0x00,0x00]

s_atomic_sub_x2 s[10:11], s[2:3], s0
// CHECK: [0x81,0x02,0x8c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_sub_x2 s[12:13], s[2:3], s0
// CHECK: [0x01,0x03,0x8c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_sub_x2 s[100:101], s[2:3], s0
// CHECK: [0x01,0x19,0x8c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_sub_x2 flat_scratch, s[2:3], s0
// CHECK: [0x81,0x19,0x8c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_sub_x2 vcc, s[2:3], s0
// CHECK: [0x81,0x1a,0x8c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_sub_x2 ttmp[14:15], s[2:3], s0
// CHECK: [0x81,0x1e,0x8c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_sub_x2 s[10:11], s[4:5], s0
// CHECK: [0x82,0x02,0x8c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_sub_x2 s[10:11], s[100:101], s0
// CHECK: [0xb2,0x02,0x8c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_sub_x2 s[10:11], flat_scratch, s0
// CHECK: [0xb3,0x02,0x8c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_sub_x2 s[10:11], vcc, s0
// CHECK: [0xb5,0x02,0x8c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_sub_x2 s[10:11], ttmp[14:15], s0
// CHECK: [0xbd,0x02,0x8c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_sub_x2 s[10:11], s[2:3], s101
// CHECK: [0x81,0x02,0x8c,0xc2,0x65,0x00,0x00,0x00]

s_atomic_sub_x2 s[10:11], s[2:3], flat_scratch_lo
// CHECK: [0x81,0x02,0x8c,0xc2,0x66,0x00,0x00,0x00]

s_atomic_sub_x2 s[10:11], s[2:3], flat_scratch_hi
// CHECK: [0x81,0x02,0x8c,0xc2,0x67,0x00,0x00,0x00]

s_atomic_sub_x2 s[10:11], s[2:3], vcc_lo
// CHECK: [0x81,0x02,0x8c,0xc2,0x6a,0x00,0x00,0x00]

s_atomic_sub_x2 s[10:11], s[2:3], vcc_hi
// CHECK: [0x81,0x02,0x8c,0xc2,0x6b,0x00,0x00,0x00]

s_atomic_sub_x2 s[10:11], s[2:3], ttmp15
// CHECK: [0x81,0x02,0x8c,0xc2,0x7b,0x00,0x00,0x00]

s_atomic_sub_x2 s[10:11], s[2:3], m0
// CHECK: [0x81,0x02,0x8c,0xc2,0x7c,0x00,0x00,0x00]

s_atomic_sub_x2 s[10:11], s[2:3], 0x0
// CHECK: [0x81,0x02,0x8e,0xc2,0x00,0x00,0x00,0x00]

s_atomic_sub_x2 s[10:11], s[2:3], s0 glc
// CHECK: [0x81,0x02,0x8d,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smin_x2 s[10:11], s[2:3], s0
// CHECK: [0x81,0x02,0x90,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smin_x2 s[12:13], s[2:3], s0
// CHECK: [0x01,0x03,0x90,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smin_x2 s[100:101], s[2:3], s0
// CHECK: [0x01,0x19,0x90,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smin_x2 flat_scratch, s[2:3], s0
// CHECK: [0x81,0x19,0x90,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smin_x2 vcc, s[2:3], s0
// CHECK: [0x81,0x1a,0x90,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smin_x2 ttmp[14:15], s[2:3], s0
// CHECK: [0x81,0x1e,0x90,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smin_x2 s[10:11], s[4:5], s0
// CHECK: [0x82,0x02,0x90,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smin_x2 s[10:11], s[100:101], s0
// CHECK: [0xb2,0x02,0x90,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smin_x2 s[10:11], flat_scratch, s0
// CHECK: [0xb3,0x02,0x90,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smin_x2 s[10:11], vcc, s0
// CHECK: [0xb5,0x02,0x90,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smin_x2 s[10:11], ttmp[14:15], s0
// CHECK: [0xbd,0x02,0x90,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smin_x2 s[10:11], s[2:3], s101
// CHECK: [0x81,0x02,0x90,0xc2,0x65,0x00,0x00,0x00]

s_atomic_smin_x2 s[10:11], s[2:3], flat_scratch_lo
// CHECK: [0x81,0x02,0x90,0xc2,0x66,0x00,0x00,0x00]

s_atomic_smin_x2 s[10:11], s[2:3], flat_scratch_hi
// CHECK: [0x81,0x02,0x90,0xc2,0x67,0x00,0x00,0x00]

s_atomic_smin_x2 s[10:11], s[2:3], vcc_lo
// CHECK: [0x81,0x02,0x90,0xc2,0x6a,0x00,0x00,0x00]

s_atomic_smin_x2 s[10:11], s[2:3], vcc_hi
// CHECK: [0x81,0x02,0x90,0xc2,0x6b,0x00,0x00,0x00]

s_atomic_smin_x2 s[10:11], s[2:3], ttmp15
// CHECK: [0x81,0x02,0x90,0xc2,0x7b,0x00,0x00,0x00]

s_atomic_smin_x2 s[10:11], s[2:3], m0
// CHECK: [0x81,0x02,0x90,0xc2,0x7c,0x00,0x00,0x00]

s_atomic_smin_x2 s[10:11], s[2:3], 0x0
// CHECK: [0x81,0x02,0x92,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smin_x2 s[10:11], s[2:3], s0 glc
// CHECK: [0x81,0x02,0x91,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umin_x2 s[10:11], s[2:3], s0
// CHECK: [0x81,0x02,0x94,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umin_x2 s[12:13], s[2:3], s0
// CHECK: [0x01,0x03,0x94,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umin_x2 s[100:101], s[2:3], s0
// CHECK: [0x01,0x19,0x94,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umin_x2 flat_scratch, s[2:3], s0
// CHECK: [0x81,0x19,0x94,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umin_x2 vcc, s[2:3], s0
// CHECK: [0x81,0x1a,0x94,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umin_x2 ttmp[14:15], s[2:3], s0
// CHECK: [0x81,0x1e,0x94,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umin_x2 s[10:11], s[4:5], s0
// CHECK: [0x82,0x02,0x94,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umin_x2 s[10:11], s[100:101], s0
// CHECK: [0xb2,0x02,0x94,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umin_x2 s[10:11], flat_scratch, s0
// CHECK: [0xb3,0x02,0x94,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umin_x2 s[10:11], vcc, s0
// CHECK: [0xb5,0x02,0x94,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umin_x2 s[10:11], ttmp[14:15], s0
// CHECK: [0xbd,0x02,0x94,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umin_x2 s[10:11], s[2:3], s101
// CHECK: [0x81,0x02,0x94,0xc2,0x65,0x00,0x00,0x00]

s_atomic_umin_x2 s[10:11], s[2:3], flat_scratch_lo
// CHECK: [0x81,0x02,0x94,0xc2,0x66,0x00,0x00,0x00]

s_atomic_umin_x2 s[10:11], s[2:3], flat_scratch_hi
// CHECK: [0x81,0x02,0x94,0xc2,0x67,0x00,0x00,0x00]

s_atomic_umin_x2 s[10:11], s[2:3], vcc_lo
// CHECK: [0x81,0x02,0x94,0xc2,0x6a,0x00,0x00,0x00]

s_atomic_umin_x2 s[10:11], s[2:3], vcc_hi
// CHECK: [0x81,0x02,0x94,0xc2,0x6b,0x00,0x00,0x00]

s_atomic_umin_x2 s[10:11], s[2:3], ttmp15
// CHECK: [0x81,0x02,0x94,0xc2,0x7b,0x00,0x00,0x00]

s_atomic_umin_x2 s[10:11], s[2:3], m0
// CHECK: [0x81,0x02,0x94,0xc2,0x7c,0x00,0x00,0x00]

s_atomic_umin_x2 s[10:11], s[2:3], 0x0
// CHECK: [0x81,0x02,0x96,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umin_x2 s[10:11], s[2:3], s0 glc
// CHECK: [0x81,0x02,0x95,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smax_x2 s[10:11], s[2:3], s0
// CHECK: [0x81,0x02,0x98,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smax_x2 s[12:13], s[2:3], s0
// CHECK: [0x01,0x03,0x98,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smax_x2 s[100:101], s[2:3], s0
// CHECK: [0x01,0x19,0x98,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smax_x2 flat_scratch, s[2:3], s0
// CHECK: [0x81,0x19,0x98,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smax_x2 vcc, s[2:3], s0
// CHECK: [0x81,0x1a,0x98,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smax_x2 ttmp[14:15], s[2:3], s0
// CHECK: [0x81,0x1e,0x98,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smax_x2 s[10:11], s[4:5], s0
// CHECK: [0x82,0x02,0x98,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smax_x2 s[10:11], s[100:101], s0
// CHECK: [0xb2,0x02,0x98,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smax_x2 s[10:11], flat_scratch, s0
// CHECK: [0xb3,0x02,0x98,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smax_x2 s[10:11], vcc, s0
// CHECK: [0xb5,0x02,0x98,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smax_x2 s[10:11], ttmp[14:15], s0
// CHECK: [0xbd,0x02,0x98,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smax_x2 s[10:11], s[2:3], s101
// CHECK: [0x81,0x02,0x98,0xc2,0x65,0x00,0x00,0x00]

s_atomic_smax_x2 s[10:11], s[2:3], flat_scratch_lo
// CHECK: [0x81,0x02,0x98,0xc2,0x66,0x00,0x00,0x00]

s_atomic_smax_x2 s[10:11], s[2:3], flat_scratch_hi
// CHECK: [0x81,0x02,0x98,0xc2,0x67,0x00,0x00,0x00]

s_atomic_smax_x2 s[10:11], s[2:3], vcc_lo
// CHECK: [0x81,0x02,0x98,0xc2,0x6a,0x00,0x00,0x00]

s_atomic_smax_x2 s[10:11], s[2:3], vcc_hi
// CHECK: [0x81,0x02,0x98,0xc2,0x6b,0x00,0x00,0x00]

s_atomic_smax_x2 s[10:11], s[2:3], ttmp15
// CHECK: [0x81,0x02,0x98,0xc2,0x7b,0x00,0x00,0x00]

s_atomic_smax_x2 s[10:11], s[2:3], m0
// CHECK: [0x81,0x02,0x98,0xc2,0x7c,0x00,0x00,0x00]

s_atomic_smax_x2 s[10:11], s[2:3], 0x0
// CHECK: [0x81,0x02,0x9a,0xc2,0x00,0x00,0x00,0x00]

s_atomic_smax_x2 s[10:11], s[2:3], s0 glc
// CHECK: [0x81,0x02,0x99,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umax_x2 s[10:11], s[2:3], s0
// CHECK: [0x81,0x02,0x9c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umax_x2 s[12:13], s[2:3], s0
// CHECK: [0x01,0x03,0x9c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umax_x2 s[100:101], s[2:3], s0
// CHECK: [0x01,0x19,0x9c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umax_x2 flat_scratch, s[2:3], s0
// CHECK: [0x81,0x19,0x9c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umax_x2 vcc, s[2:3], s0
// CHECK: [0x81,0x1a,0x9c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umax_x2 ttmp[14:15], s[2:3], s0
// CHECK: [0x81,0x1e,0x9c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umax_x2 s[10:11], s[4:5], s0
// CHECK: [0x82,0x02,0x9c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umax_x2 s[10:11], s[100:101], s0
// CHECK: [0xb2,0x02,0x9c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umax_x2 s[10:11], flat_scratch, s0
// CHECK: [0xb3,0x02,0x9c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umax_x2 s[10:11], vcc, s0
// CHECK: [0xb5,0x02,0x9c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umax_x2 s[10:11], ttmp[14:15], s0
// CHECK: [0xbd,0x02,0x9c,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umax_x2 s[10:11], s[2:3], s101
// CHECK: [0x81,0x02,0x9c,0xc2,0x65,0x00,0x00,0x00]

s_atomic_umax_x2 s[10:11], s[2:3], flat_scratch_lo
// CHECK: [0x81,0x02,0x9c,0xc2,0x66,0x00,0x00,0x00]

s_atomic_umax_x2 s[10:11], s[2:3], flat_scratch_hi
// CHECK: [0x81,0x02,0x9c,0xc2,0x67,0x00,0x00,0x00]

s_atomic_umax_x2 s[10:11], s[2:3], vcc_lo
// CHECK: [0x81,0x02,0x9c,0xc2,0x6a,0x00,0x00,0x00]

s_atomic_umax_x2 s[10:11], s[2:3], vcc_hi
// CHECK: [0x81,0x02,0x9c,0xc2,0x6b,0x00,0x00,0x00]

s_atomic_umax_x2 s[10:11], s[2:3], ttmp15
// CHECK: [0x81,0x02,0x9c,0xc2,0x7b,0x00,0x00,0x00]

s_atomic_umax_x2 s[10:11], s[2:3], m0
// CHECK: [0x81,0x02,0x9c,0xc2,0x7c,0x00,0x00,0x00]

s_atomic_umax_x2 s[10:11], s[2:3], 0x0
// CHECK: [0x81,0x02,0x9e,0xc2,0x00,0x00,0x00,0x00]

s_atomic_umax_x2 s[10:11], s[2:3], s0 glc
// CHECK: [0x81,0x02,0x9d,0xc2,0x00,0x00,0x00,0x00]

s_atomic_and_x2 s[10:11], s[2:3], s0
// CHECK: [0x81,0x02,0xa0,0xc2,0x00,0x00,0x00,0x00]

s_atomic_and_x2 s[12:13], s[2:3], s0
// CHECK: [0x01,0x03,0xa0,0xc2,0x00,0x00,0x00,0x00]

s_atomic_and_x2 s[100:101], s[2:3], s0
// CHECK: [0x01,0x19,0xa0,0xc2,0x00,0x00,0x00,0x00]

s_atomic_and_x2 flat_scratch, s[2:3], s0
// CHECK: [0x81,0x19,0xa0,0xc2,0x00,0x00,0x00,0x00]

s_atomic_and_x2 vcc, s[2:3], s0
// CHECK: [0x81,0x1a,0xa0,0xc2,0x00,0x00,0x00,0x00]

s_atomic_and_x2 ttmp[14:15], s[2:3], s0
// CHECK: [0x81,0x1e,0xa0,0xc2,0x00,0x00,0x00,0x00]

s_atomic_and_x2 s[10:11], s[4:5], s0
// CHECK: [0x82,0x02,0xa0,0xc2,0x00,0x00,0x00,0x00]

s_atomic_and_x2 s[10:11], s[100:101], s0
// CHECK: [0xb2,0x02,0xa0,0xc2,0x00,0x00,0x00,0x00]

s_atomic_and_x2 s[10:11], flat_scratch, s0
// CHECK: [0xb3,0x02,0xa0,0xc2,0x00,0x00,0x00,0x00]

s_atomic_and_x2 s[10:11], vcc, s0
// CHECK: [0xb5,0x02,0xa0,0xc2,0x00,0x00,0x00,0x00]

s_atomic_and_x2 s[10:11], ttmp[14:15], s0
// CHECK: [0xbd,0x02,0xa0,0xc2,0x00,0x00,0x00,0x00]

s_atomic_and_x2 s[10:11], s[2:3], s101
// CHECK: [0x81,0x02,0xa0,0xc2,0x65,0x00,0x00,0x00]

s_atomic_and_x2 s[10:11], s[2:3], flat_scratch_lo
// CHECK: [0x81,0x02,0xa0,0xc2,0x66,0x00,0x00,0x00]

s_atomic_and_x2 s[10:11], s[2:3], flat_scratch_hi
// CHECK: [0x81,0x02,0xa0,0xc2,0x67,0x00,0x00,0x00]

s_atomic_and_x2 s[10:11], s[2:3], vcc_lo
// CHECK: [0x81,0x02,0xa0,0xc2,0x6a,0x00,0x00,0x00]

s_atomic_and_x2 s[10:11], s[2:3], vcc_hi
// CHECK: [0x81,0x02,0xa0,0xc2,0x6b,0x00,0x00,0x00]

s_atomic_and_x2 s[10:11], s[2:3], ttmp15
// CHECK: [0x81,0x02,0xa0,0xc2,0x7b,0x00,0x00,0x00]

s_atomic_and_x2 s[10:11], s[2:3], m0
// CHECK: [0x81,0x02,0xa0,0xc2,0x7c,0x00,0x00,0x00]

s_atomic_and_x2 s[10:11], s[2:3], 0x0
// CHECK: [0x81,0x02,0xa2,0xc2,0x00,0x00,0x00,0x00]

s_atomic_and_x2 s[10:11], s[2:3], s0 glc
// CHECK: [0x81,0x02,0xa1,0xc2,0x00,0x00,0x00,0x00]

s_atomic_or_x2 s[10:11], s[2:3], s0
// CHECK: [0x81,0x02,0xa4,0xc2,0x00,0x00,0x00,0x00]

s_atomic_or_x2 s[12:13], s[2:3], s0
// CHECK: [0x01,0x03,0xa4,0xc2,0x00,0x00,0x00,0x00]

s_atomic_or_x2 s[100:101], s[2:3], s0
// CHECK: [0x01,0x19,0xa4,0xc2,0x00,0x00,0x00,0x00]

s_atomic_or_x2 flat_scratch, s[2:3], s0
// CHECK: [0x81,0x19,0xa4,0xc2,0x00,0x00,0x00,0x00]

s_atomic_or_x2 vcc, s[2:3], s0
// CHECK: [0x81,0x1a,0xa4,0xc2,0x00,0x00,0x00,0x00]

s_atomic_or_x2 ttmp[14:15], s[2:3], s0
// CHECK: [0x81,0x1e,0xa4,0xc2,0x00,0x00,0x00,0x00]

s_atomic_or_x2 s[10:11], s[4:5], s0
// CHECK: [0x82,0x02,0xa4,0xc2,0x00,0x00,0x00,0x00]

s_atomic_or_x2 s[10:11], s[100:101], s0
// CHECK: [0xb2,0x02,0xa4,0xc2,0x00,0x00,0x00,0x00]

s_atomic_or_x2 s[10:11], flat_scratch, s0
// CHECK: [0xb3,0x02,0xa4,0xc2,0x00,0x00,0x00,0x00]

s_atomic_or_x2 s[10:11], vcc, s0
// CHECK: [0xb5,0x02,0xa4,0xc2,0x00,0x00,0x00,0x00]

s_atomic_or_x2 s[10:11], ttmp[14:15], s0
// CHECK: [0xbd,0x02,0xa4,0xc2,0x00,0x00,0x00,0x00]

s_atomic_or_x2 s[10:11], s[2:3], s101
// CHECK: [0x81,0x02,0xa4,0xc2,0x65,0x00,0x00,0x00]

s_atomic_or_x2 s[10:11], s[2:3], flat_scratch_lo
// CHECK: [0x81,0x02,0xa4,0xc2,0x66,0x00,0x00,0x00]

s_atomic_or_x2 s[10:11], s[2:3], flat_scratch_hi
// CHECK: [0x81,0x02,0xa4,0xc2,0x67,0x00,0x00,0x00]

s_atomic_or_x2 s[10:11], s[2:3], vcc_lo
// CHECK: [0x81,0x02,0xa4,0xc2,0x6a,0x00,0x00,0x00]

s_atomic_or_x2 s[10:11], s[2:3], vcc_hi
// CHECK: [0x81,0x02,0xa4,0xc2,0x6b,0x00,0x00,0x00]

s_atomic_or_x2 s[10:11], s[2:3], ttmp15
// CHECK: [0x81,0x02,0xa4,0xc2,0x7b,0x00,0x00,0x00]

s_atomic_or_x2 s[10:11], s[2:3], m0
// CHECK: [0x81,0x02,0xa4,0xc2,0x7c,0x00,0x00,0x00]

s_atomic_or_x2 s[10:11], s[2:3], 0x0
// CHECK: [0x81,0x02,0xa6,0xc2,0x00,0x00,0x00,0x00]

s_atomic_or_x2 s[10:11], s[2:3], s0 glc
// CHECK: [0x81,0x02,0xa5,0xc2,0x00,0x00,0x00,0x00]

s_atomic_xor_x2 s[10:11], s[2:3], s0
// CHECK: [0x81,0x02,0xa8,0xc2,0x00,0x00,0x00,0x00]

s_atomic_xor_x2 s[12:13], s[2:3], s0
// CHECK: [0x01,0x03,0xa8,0xc2,0x00,0x00,0x00,0x00]

s_atomic_xor_x2 s[100:101], s[2:3], s0
// CHECK: [0x01,0x19,0xa8,0xc2,0x00,0x00,0x00,0x00]

s_atomic_xor_x2 flat_scratch, s[2:3], s0
// CHECK: [0x81,0x19,0xa8,0xc2,0x00,0x00,0x00,0x00]

s_atomic_xor_x2 vcc, s[2:3], s0
// CHECK: [0x81,0x1a,0xa8,0xc2,0x00,0x00,0x00,0x00]

s_atomic_xor_x2 ttmp[14:15], s[2:3], s0
// CHECK: [0x81,0x1e,0xa8,0xc2,0x00,0x00,0x00,0x00]

s_atomic_xor_x2 s[10:11], s[4:5], s0
// CHECK: [0x82,0x02,0xa8,0xc2,0x00,0x00,0x00,0x00]

s_atomic_xor_x2 s[10:11], s[100:101], s0
// CHECK: [0xb2,0x02,0xa8,0xc2,0x00,0x00,0x00,0x00]

s_atomic_xor_x2 s[10:11], flat_scratch, s0
// CHECK: [0xb3,0x02,0xa8,0xc2,0x00,0x00,0x00,0x00]

s_atomic_xor_x2 s[10:11], vcc, s0
// CHECK: [0xb5,0x02,0xa8,0xc2,0x00,0x00,0x00,0x00]

s_atomic_xor_x2 s[10:11], ttmp[14:15], s0
// CHECK: [0xbd,0x02,0xa8,0xc2,0x00,0x00,0x00,0x00]

s_atomic_xor_x2 s[10:11], s[2:3], s101
// CHECK: [0x81,0x02,0xa8,0xc2,0x65,0x00,0x00,0x00]

s_atomic_xor_x2 s[10:11], s[2:3], flat_scratch_lo
// CHECK: [0x81,0x02,0xa8,0xc2,0x66,0x00,0x00,0x00]

s_atomic_xor_x2 s[10:11], s[2:3], flat_scratch_hi
// CHECK: [0x81,0x02,0xa8,0xc2,0x67,0x00,0x00,0x00]

s_atomic_xor_x2 s[10:11], s[2:3], vcc_lo
// CHECK: [0x81,0x02,0xa8,0xc2,0x6a,0x00,0x00,0x00]

s_atomic_xor_x2 s[10:11], s[2:3], vcc_hi
// CHECK: [0x81,0x02,0xa8,0xc2,0x6b,0x00,0x00,0x00]

s_atomic_xor_x2 s[10:11], s[2:3], ttmp15
// CHECK: [0x81,0x02,0xa8,0xc2,0x7b,0x00,0x00,0x00]

s_atomic_xor_x2 s[10:11], s[2:3], m0
// CHECK: [0x81,0x02,0xa8,0xc2,0x7c,0x00,0x00,0x00]

s_atomic_xor_x2 s[10:11], s[2:3], 0x0
// CHECK: [0x81,0x02,0xaa,0xc2,0x00,0x00,0x00,0x00]

s_atomic_xor_x2 s[10:11], s[2:3], s0 glc
// CHECK: [0x81,0x02,0xa9,0xc2,0x00,0x00,0x00,0x00]

s_atomic_inc_x2 s[10:11], s[2:3], s0
// CHECK: [0x81,0x02,0xac,0xc2,0x00,0x00,0x00,0x00]

s_atomic_inc_x2 s[12:13], s[2:3], s0
// CHECK: [0x01,0x03,0xac,0xc2,0x00,0x00,0x00,0x00]

s_atomic_inc_x2 s[100:101], s[2:3], s0
// CHECK: [0x01,0x19,0xac,0xc2,0x00,0x00,0x00,0x00]

s_atomic_inc_x2 flat_scratch, s[2:3], s0
// CHECK: [0x81,0x19,0xac,0xc2,0x00,0x00,0x00,0x00]

s_atomic_inc_x2 vcc, s[2:3], s0
// CHECK: [0x81,0x1a,0xac,0xc2,0x00,0x00,0x00,0x00]

s_atomic_inc_x2 ttmp[14:15], s[2:3], s0
// CHECK: [0x81,0x1e,0xac,0xc2,0x00,0x00,0x00,0x00]

s_atomic_inc_x2 s[10:11], s[4:5], s0
// CHECK: [0x82,0x02,0xac,0xc2,0x00,0x00,0x00,0x00]

s_atomic_inc_x2 s[10:11], s[100:101], s0
// CHECK: [0xb2,0x02,0xac,0xc2,0x00,0x00,0x00,0x00]

s_atomic_inc_x2 s[10:11], flat_scratch, s0
// CHECK: [0xb3,0x02,0xac,0xc2,0x00,0x00,0x00,0x00]

s_atomic_inc_x2 s[10:11], vcc, s0
// CHECK: [0xb5,0x02,0xac,0xc2,0x00,0x00,0x00,0x00]

s_atomic_inc_x2 s[10:11], ttmp[14:15], s0
// CHECK: [0xbd,0x02,0xac,0xc2,0x00,0x00,0x00,0x00]

s_atomic_inc_x2 s[10:11], s[2:3], s101
// CHECK: [0x81,0x02,0xac,0xc2,0x65,0x00,0x00,0x00]

s_atomic_inc_x2 s[10:11], s[2:3], flat_scratch_lo
// CHECK: [0x81,0x02,0xac,0xc2,0x66,0x00,0x00,0x00]

s_atomic_inc_x2 s[10:11], s[2:3], flat_scratch_hi
// CHECK: [0x81,0x02,0xac,0xc2,0x67,0x00,0x00,0x00]

s_atomic_inc_x2 s[10:11], s[2:3], vcc_lo
// CHECK: [0x81,0x02,0xac,0xc2,0x6a,0x00,0x00,0x00]

s_atomic_inc_x2 s[10:11], s[2:3], vcc_hi
// CHECK: [0x81,0x02,0xac,0xc2,0x6b,0x00,0x00,0x00]

s_atomic_inc_x2 s[10:11], s[2:3], ttmp15
// CHECK: [0x81,0x02,0xac,0xc2,0x7b,0x00,0x00,0x00]

s_atomic_inc_x2 s[10:11], s[2:3], m0
// CHECK: [0x81,0x02,0xac,0xc2,0x7c,0x00,0x00,0x00]

s_atomic_inc_x2 s[10:11], s[2:3], 0x0
// CHECK: [0x81,0x02,0xae,0xc2,0x00,0x00,0x00,0x00]

s_atomic_inc_x2 s[10:11], s[2:3], s0 glc
// CHECK: [0x81,0x02,0xad,0xc2,0x00,0x00,0x00,0x00]

s_atomic_dec_x2 s[10:11], s[2:3], s0
// CHECK: [0x81,0x02,0xb0,0xc2,0x00,0x00,0x00,0x00]

s_atomic_dec_x2 s[12:13], s[2:3], s0
// CHECK: [0x01,0x03,0xb0,0xc2,0x00,0x00,0x00,0x00]

s_atomic_dec_x2 s[100:101], s[2:3], s0
// CHECK: [0x01,0x19,0xb0,0xc2,0x00,0x00,0x00,0x00]

s_atomic_dec_x2 flat_scratch, s[2:3], s0
// CHECK: [0x81,0x19,0xb0,0xc2,0x00,0x00,0x00,0x00]

s_atomic_dec_x2 vcc, s[2:3], s0
// CHECK: [0x81,0x1a,0xb0,0xc2,0x00,0x00,0x00,0x00]

s_atomic_dec_x2 ttmp[14:15], s[2:3], s0
// CHECK: [0x81,0x1e,0xb0,0xc2,0x00,0x00,0x00,0x00]

s_atomic_dec_x2 s[10:11], s[4:5], s0
// CHECK: [0x82,0x02,0xb0,0xc2,0x00,0x00,0x00,0x00]

s_atomic_dec_x2 s[10:11], s[100:101], s0
// CHECK: [0xb2,0x02,0xb0,0xc2,0x00,0x00,0x00,0x00]

s_atomic_dec_x2 s[10:11], flat_scratch, s0
// CHECK: [0xb3,0x02,0xb0,0xc2,0x00,0x00,0x00,0x00]

s_atomic_dec_x2 s[10:11], vcc, s0
// CHECK: [0xb5,0x02,0xb0,0xc2,0x00,0x00,0x00,0x00]

s_atomic_dec_x2 s[10:11], ttmp[14:15], s0
// CHECK: [0xbd,0x02,0xb0,0xc2,0x00,0x00,0x00,0x00]

s_atomic_dec_x2 s[10:11], s[2:3], s101
// CHECK: [0x81,0x02,0xb0,0xc2,0x65,0x00,0x00,0x00]

s_atomic_dec_x2 s[10:11], s[2:3], flat_scratch_lo
// CHECK: [0x81,0x02,0xb0,0xc2,0x66,0x00,0x00,0x00]

s_atomic_dec_x2 s[10:11], s[2:3], flat_scratch_hi
// CHECK: [0x81,0x02,0xb0,0xc2,0x67,0x00,0x00,0x00]

s_atomic_dec_x2 s[10:11], s[2:3], vcc_lo
// CHECK: [0x81,0x02,0xb0,0xc2,0x6a,0x00,0x00,0x00]

s_atomic_dec_x2 s[10:11], s[2:3], vcc_hi
// CHECK: [0x81,0x02,0xb0,0xc2,0x6b,0x00,0x00,0x00]

s_atomic_dec_x2 s[10:11], s[2:3], ttmp15
// CHECK: [0x81,0x02,0xb0,0xc2,0x7b,0x00,0x00,0x00]

s_atomic_dec_x2 s[10:11], s[2:3], m0
// CHECK: [0x81,0x02,0xb0,0xc2,0x7c,0x00,0x00,0x00]

s_atomic_dec_x2 s[10:11], s[2:3], 0x0
// CHECK: [0x81,0x02,0xb2,0xc2,0x00,0x00,0x00,0x00]

s_atomic_dec_x2 s[10:11], s[2:3], s0 glc
// CHECK: [0x81,0x02,0xb1,0xc2,0x00,0x00,0x00,0x00]

s_load_dword s1, s[2:3] glc
// CHECK: s_load_dword s1, s[2:3], 0x0 glc ; encoding: [0x41,0x00,0x03,0xc0,0x00,0x00,0x00,0x00]
