//
// File: XML.cc
// This code was produced by the dragon parser generator
//
#include "XML.h"
#include <lfcbase/Exception.h>
#include <lfcbase/StackT.h>

XML::ScannerStateEntry::ScannerStateEntry()
{
}

XML::ScannerStateEntry::ScannerStateEntry(int state, ScannerStateType type)
{
   _state = state;
   _type = type;
}

XML::ScannerStateEntry& XML::ScannerStateEntry::operator = (const XML::ScannerStateEntry& s)
{
   _state = s._state;
   _type = s._type;
   return(*this);
}

bool XML::ScannerStateEntry::operator == (const XML::ScannerStateEntry& s)
{
   if ( _state == s._state )
      return true;
   return false;
}

XML::ScannerStateType XML::ScannerStateEntry::getType()
{
   return _type;
}
int XML::ScannerStateEntry::getState()
{
   return _state;
}


XML::ScannerTransEntry::ScannerTransEntry()
{
}

XML::ScannerTransEntry::ScannerTransEntry(int state, char c)
{
   _state = state;
   _c = c;
}

XML::ScannerTransEntry::ScannerTransEntry(int state, char c, int fstate)
{
   _state = state;
   _c = c;
   _fstate = fstate;
}

XML::ScannerTransEntry& XML::ScannerTransEntry::operator = (const XML::ScannerTransEntry& s)
{
   _state = s._state;
   _c = s._c;
   _fstate = s._fstate;
   return(*this);
}

bool XML::ScannerTransEntry::operator == (const XML::ScannerTransEntry& s)
{
   if ( _state == s._state && _c == s._c)
      return true;
   return false;
}

int XML::ScannerTransEntry::getFState()
{
   return _fstate;
}


XML::Scanner::Scanner()
{
}


XML::Scanner::Scanner(Token t)
{
   _token = t;
}

XML::Token XML::Scanner::getToken()
{
   return _token;
}

void XML::Scanner::addState(ScannerStateEntry s)
{
   _stateList.Insert(s);
}

void XML::Scanner::addTransition(ScannerTransEntry t)
{
   _transList.Insert(t);
}

bool XML::Scanner::checkPattern(const Chain& p)
{
   unsigned long state = 0;
   ScannerStateEntry* pS = _stateList.First();
   while (pS)
   {
      if (pS->getType() == START || pS->getType() == ANY)
      {
         state = pS->getState();
         pS = 0;
      }
      else
      {
         pS = _stateList.Next();
      }
   }
   unsigned long i = 0;
   ScannerTransEntry* pT = 
   _transList.Find(ScannerTransEntry(state, p[i]));
   while (pT)
   {
      ScannerStateEntry* pS = _stateList.Find(ScannerStateEntry(pT->getFState())); 
      if (pS)
      {
         if ( ( i == p.length()-2 ) && ( pS->getType() == FINAL || pS->getType() == ANY))
         {
            return true;
         }
         else
         {
            state = pT->getFState();
         }
      }
      else
      {
         return false;
      }
      i++;
      pT = _transList.Find(ScannerTransEntry(state, p[i]));
   }
   return false;
}
XML::StackEntry::StackEntry()
{
   _symbol = NONE;
}

XML::StackEntry::StackEntry(Symbol symbol, int num, int state, Chain tval)
{
   _symbol=symbol;
   _num=num;
   _state=state;
   _tval=tval;
}

XML::StackEntry& XML::StackEntry::operator = (const XML::StackEntry& se)
{
   _symbol=se._symbol;
   _num=se._num;
   _state=se._state;
   _tval=se._tval;
   return(*this);
}

int XML::StackEntry::getState()
{
   return _state;
}
XML::Symbol XML::StackEntry::getSymbol()
{
   return _symbol;
}
Chain& XML::StackEntry::getTval()
{
   return _tval;
}

XML::ActionEntry::ActionEntry()
{
   _action=NULLACTION;
}

XML::ActionEntry::ActionEntry(Action action , int num)
{
   _action=action;
   _num=num;
}

bool XML::ActionEntry::operator == (const XML::ActionEntry& ae)
{
   if (_action == ae._action && _num == ae._num)
      return true;
   return false;
}

XML::ActionEntry& XML::ActionEntry::operator = (const XML::ActionEntry& ae)
{
   _action=ae._action;
   _num=ae._num;
   return(*this);
}

XML::Action XML::ActionEntry::getAction()
{
   return _action;
}

int XML::ActionEntry::getNum()
{
   return _num;
}

XML::ProdEntry::ProdEntry()
{
}

XML::ProdEntry::ProdEntry(int id)
{
   _id = id;
}

XML::ProdEntry::ProdEntry(int id, Production prod, int numSymbol)
{
   _id = id;
   _prod = prod;
   _numSymbol = numSymbol;
}

bool XML::ProdEntry::operator == (const XML::ProdEntry& pe)
{
   if (_id == pe._id)
      return true;
   return false;
}

XML::ProdEntry& XML::ProdEntry::operator = (const XML::ProdEntry& pe)
{
   _id = pe._id;
   _prod = pe._prod;
   _numSymbol = pe._numSymbol;
   return(*this);
}


int XML::ProdEntry::getId()
{
   return _id;
}

XML::Production XML::ProdEntry::getProd()
{
   return _prod;
}

int XML::ProdEntry::getNumSymbol()
{
   return _numSymbol;
}
void XML::loadScanner()
{
   Scanner s0(EQU);
   s0.addState(ScannerStateEntry(0 ,START));
   s0.addState(ScannerStateEntry(1 ,FINAL));
   s0.addTransition(ScannerTransEntry(0 ,'=' ,1));
   _scannerList.Insert(s0);

   Scanner s1(CDATA);
   s1.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s1.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s1.addState(ScannerStateEntry(2 ,START));
   s1.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s1.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s1.addState(ScannerStateEntry(5 ,FINAL));
   s1.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s1.addTransition(ScannerTransEntry(1 ,'A' ,3));
   s1.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s1.addTransition(ScannerTransEntry(3 ,'T' ,4));
   s1.addTransition(ScannerTransEntry(4 ,'A' ,5));
   _scannerList.Insert(s1);

   Scanner s2(DOCTYPE);
   s2.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s2.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s2.addState(ScannerStateEntry(2 ,START));
   s2.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s2.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s2.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s2.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s2.addState(ScannerStateEntry(7 ,FINAL));
   s2.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s2.addTransition(ScannerTransEntry(1 ,'C' ,3));
   s2.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s2.addTransition(ScannerTransEntry(3 ,'T' ,4));
   s2.addTransition(ScannerTransEntry(4 ,'Y' ,5));
   s2.addTransition(ScannerTransEntry(5 ,'P' ,6));
   s2.addTransition(ScannerTransEntry(6 ,'E' ,7));
   _scannerList.Insert(s2);

   Scanner s3(LT);
   s3.addState(ScannerStateEntry(0 ,START));
   s3.addState(ScannerStateEntry(1 ,FINAL));
   s3.addTransition(ScannerTransEntry(0 ,'<' ,1));
   _scannerList.Insert(s3);

   Scanner s4(MT);
   s4.addState(ScannerStateEntry(0 ,START));
   s4.addState(ScannerStateEntry(1 ,FINAL));
   s4.addTransition(ScannerTransEntry(0 ,'>' ,1));
   _scannerList.Insert(s4);

   Scanner s5(LB);
   s5.addState(ScannerStateEntry(0 ,START));
   s5.addState(ScannerStateEntry(1 ,FINAL));
   s5.addTransition(ScannerTransEntry(0 ,'[' ,1));
   _scannerList.Insert(s5);

   Scanner s6(RB);
   s6.addState(ScannerStateEntry(0 ,START));
   s6.addState(ScannerStateEntry(1 ,FINAL));
   s6.addTransition(ScannerTransEntry(0 ,']' ,1));
   _scannerList.Insert(s6);

   Scanner s7(SLASH);
   s7.addState(ScannerStateEntry(0 ,START));
   s7.addState(ScannerStateEntry(1 ,FINAL));
   s7.addTransition(ScannerTransEntry(0 ,'/' ,1));
   _scannerList.Insert(s7);

   Scanner s8(QMARK);
   s8.addState(ScannerStateEntry(0 ,START));
   s8.addState(ScannerStateEntry(1 ,FINAL));
   s8.addTransition(ScannerTransEntry(0 ,'?' ,1));
   _scannerList.Insert(s8);

   Scanner s9(EMARK);
   s9.addState(ScannerStateEntry(0 ,START));
   s9.addState(ScannerStateEntry(1 ,FINAL));
   s9.addTransition(ScannerTransEntry(0 ,'!' ,1));
   _scannerList.Insert(s9);

   Scanner s10(STREAM);
   s10.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(2 ,START));
   s10.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(6 ,FINAL));
   s10.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s10.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s10.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s10.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s10.addTransition(ScannerTransEntry(4 ,'A' ,5));
   s10.addTransition(ScannerTransEntry(5 ,'M' ,6));
   _scannerList.Insert(s10);

   Scanner s11(XMLTOKEN);
   s11.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(2 ,START));
   s11.addState(ScannerStateEntry(3 ,FINAL));
   s11.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s11.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s11.addTransition(ScannerTransEntry(2 ,'x' ,0));
   _scannerList.Insert(s11);

   Scanner s12(INTVAL);
   s12.addState(ScannerStateEntry(0 ,START));
   s12.addState(ScannerStateEntry(1 ,FINAL));
   s12.addState(ScannerStateEntry(2 ,FINAL));
   s12.addTransition(ScannerTransEntry(0 ,'1' ,1));
   s12.addTransition(ScannerTransEntry(0 ,'2' ,1));
   s12.addTransition(ScannerTransEntry(0 ,'3' ,1));
   s12.addTransition(ScannerTransEntry(0 ,'4' ,1));
   s12.addTransition(ScannerTransEntry(0 ,'5' ,1));
   s12.addTransition(ScannerTransEntry(0 ,'6' ,1));
   s12.addTransition(ScannerTransEntry(0 ,'7' ,1));
   s12.addTransition(ScannerTransEntry(0 ,'8' ,1));
   s12.addTransition(ScannerTransEntry(0 ,'9' ,1));
   s12.addTransition(ScannerTransEntry(0 ,'0' ,2));
   s12.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s12.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s12.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s12.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s12.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s12.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s12.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s12.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s12.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s12.addTransition(ScannerTransEntry(1 ,'9' ,1));
   _scannerList.Insert(s12);

   Scanner s13(IDENTIFIER);
   s13.addState(ScannerStateEntry(0 ,START));
   s13.addState(ScannerStateEntry(1 ,FINAL));
   s13.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'G' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'J' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'K' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'Q' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'W' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'Z' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'g' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'j' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'k' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'q' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'z' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'-' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'.' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'A' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'B' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'C' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'D' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'E' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'F' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'G' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'H' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'I' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'J' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'K' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'L' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'M' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'N' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'O' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'P' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'Q' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'R' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'S' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'T' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'U' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'V' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'W' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'X' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'Y' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'Z' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'_' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'a' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'b' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'c' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'d' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'e' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'f' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'g' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'h' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'i' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'j' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'k' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'l' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'m' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'n' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'o' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'p' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'q' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'r' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'s' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'t' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'u' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'v' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'w' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'x' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'y' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'z' ,1));
   _scannerList.Insert(s13);

}
void XML::loadParser0()
{
   _actionMap[56][LT] = ActionEntry(REDUCE, 17);
   _actionMap[56][ENDTOKEN] = ActionEntry(REDUCE, 17);
   _actionMap[52][LT] = ActionEntry(REDUCE, 13);
   _actionMap[52][ENDTOKEN] = ActionEntry(REDUCE, 13);
   _actionMap[53][LB] = ActionEntry(REDUCE, 24);
   _actionMap[54][MT] = ActionEntry(SHIFT, 56);
   _actionMap[55][QMARK] = ActionEntry(REDUCE, 4);
   _actionMap[55][MT] = ActionEntry(REDUCE, 4);
   _actionMap[55][IDENTIFIER] = ActionEntry(REDUCE, 4);
   _actionMap[55][SLASH] = ActionEntry(REDUCE, 4);
   _actionMap[45][LT] = ActionEntry(REDUCE, 23);
   _actionMap[46][MT] = ActionEntry(SHIFT, 52);
   _actionMap[47][CDATA] = ActionEntry(SHIFT, 53);
   _actionMap[48][IDENTIFIER] = ActionEntry(SHIFT, 54);
   _actionMap[49][ENDTOKEN] = ActionEntry(REDUCE, 8);
   _actionMap[49][LT] = ActionEntry(REDUCE, 8);
   _actionMap[50][ENDTOKEN] = ActionEntry(REDUCE, 10);
   _actionMap[50][LT] = ActionEntry(REDUCE, 10);
   _actionMap[51][STRINGVAL] = ActionEntry(SHIFT, 55);
   _actionMap[31][LT] = ActionEntry(REDUCE, 22);
   _actionMap[32][DATA] = ActionEntry(SHIFT, 45);
   _actionMap[33][IDENTIFIER] = ActionEntry(SHIFT, 46);
   _actionMap[34][LB] = ActionEntry(SHIFT, 47);
   _actionMap[35][LT] = ActionEntry(REDUCE, 18);
   _actionMap[36][SLASH] = ActionEntry(SHIFT, 48);
   _actionMap[36][IDENTIFIER] = ActionEntry(SHIFT, 17);
   _actionMap[36][STREAM] = ActionEntry(SHIFT, 16);
   _actionMap[37][MT] = ActionEntry(SHIFT, 49);
   _actionMap[38][MT] = ActionEntry(SHIFT, 39);
   _actionMap[38][SLASH] = ActionEntry(SHIFT, 40);
   _actionMap[38][IDENTIFIER] = ActionEntry(SHIFT, 42);
   _jumpMap[38][Attr] = 41;
   _actionMap[39][LT] = ActionEntry(REDUCE, 12);
   _actionMap[40][MT] = ActionEntry(SHIFT, 50);
   _actionMap[41][QMARK] = ActionEntry(REDUCE, 2);
   _actionMap[41][MT] = ActionEntry(REDUCE, 2);
   _actionMap[41][IDENTIFIER] = ActionEntry(REDUCE, 2);
   _actionMap[41][SLASH] = ActionEntry(REDUCE, 2);
   _actionMap[42][EQU] = ActionEntry(SHIFT, 51);
   _actionMap[43][ENDTOKEN] = ActionEntry(REDUCE, 9);
   _actionMap[43][LT] = ActionEntry(REDUCE, 9);
   _actionMap[44][ENDTOKEN] = ActionEntry(REDUCE, 1);
   _actionMap[44][LT] = ActionEntry(REDUCE, 1);
   _actionMap[19][LT] = ActionEntry(REDUCE, 20);
   _actionMap[20][LB] = ActionEntry(SHIFT, 32);
   _jumpMap[20][DataContent] = 31;
   _actionMap[21][SLASH] = ActionEntry(SHIFT, 33);
   _actionMap[21][EMARK] = ActionEntry(SHIFT, 34);
   _actionMap[22][LT] = ActionEntry(REDUCE, 14);
   _actionMap[22][ENDTOKEN] = ActionEntry(REDUCE, 14);
}
void XML::loadParser1()
{
   _actionMap[23][LT] = ActionEntry(SHIFT, 36);
   _jumpMap[23][ElementPre] = 7;
   _jumpMap[23][Elem] = 35;
   _jumpMap[23][StreamPre] = 5;
   _actionMap[24][LT] = ActionEntry(REDUCE, 16);
   _actionMap[25][IDENTIFIER] = ActionEntry(SHIFT, 37);
   _actionMap[26][IDENTIFIER] = ActionEntry(REDUCE, 3);
   _actionMap[26][SLASH] = ActionEntry(REDUCE, 3);
   _actionMap[26][MT] = ActionEntry(REDUCE, 3);
   _jumpMap[26][AttrList] = 38;
   _actionMap[27][SLASH] = ActionEntry(SHIFT, 28);
   _actionMap[27][MT] = ActionEntry(REDUCE, 15);
   _actionMap[27][IDENTIFIER] = ActionEntry(SHIFT, 42);
   _jumpMap[27][Attr] = 41;
   _actionMap[28][MT] = ActionEntry(SHIFT, 43);
   _actionMap[29][QMARK] = ActionEntry(SHIFT, 30);
   _actionMap[29][IDENTIFIER] = ActionEntry(SHIFT, 42);
   _jumpMap[29][Attr] = 41;
   _actionMap[30][MT] = ActionEntry(SHIFT, 44);
   _actionMap[10][ENDTOKEN] = ActionEntry(REDUCE, 5);
   _actionMap[11][LT] = ActionEntry(REDUCE, 11);
   _actionMap[11][ENDTOKEN] = ActionEntry(REDUCE, 11);
   _actionMap[12][LT] = ActionEntry(SHIFT, 21);
   _jumpMap[12][DataPre] = 20;
   _jumpMap[12][Data] = 19;
   _actionMap[13][LT] = ActionEntry(REDUCE, 19);
   _jumpMap[13][ElementList] = 23;
   _jumpMap[13][ElementPost] = 22;
   _actionMap[14][CONTENT] = ActionEntry(SHIFT, 24);
   _actionMap[15][DOCTYPE] = ActionEntry(SHIFT, 25);
   _actionMap[16][IDENTIFIER] = ActionEntry(SHIFT, 26);
   _actionMap[17][IDENTIFIER] = ActionEntry(REDUCE, 3);
   _actionMap[17][SLASH] = ActionEntry(REDUCE, 3);
   _actionMap[17][MT] = ActionEntry(REDUCE, 3);
   _jumpMap[17][AttrList] = 27;
   _actionMap[18][IDENTIFIER] = ActionEntry(REDUCE, 3);
   _actionMap[18][QMARK] = ActionEntry(REDUCE, 3);
   _jumpMap[18][AttrList] = 29;
   _actionMap[3][ENDTOKEN] = ActionEntry(ACCEPT, 0);
   _actionMap[4][LT] = ActionEntry(SHIFT, 8);
   _actionMap[4][ENDTOKEN] = ActionEntry(REDUCE, 6);
   _jumpMap[4][ElementPre] = 7;
   _jumpMap[4][Elem] = 6;
   _jumpMap[4][StreamPre] = 5;
   _jumpMap[4][XMLTag] = 4;
   _jumpMap[4][XMLBody] = 10;
   _actionMap[5][LT] = ActionEntry(REDUCE, 21);
   _jumpMap[5][DataList] = 12;
   _jumpMap[5][StreamContent] = 11;
   _actionMap[6][ENDTOKEN] = ActionEntry(REDUCE, 7);
}
void XML::loadParser2()
{
   _actionMap[6][LT] = ActionEntry(REDUCE, 7);
   _actionMap[7][MT] = ActionEntry(SHIFT, 14);
   _jumpMap[7][ElementContent] = 13;
   _actionMap[8][IDENTIFIER] = ActionEntry(SHIFT, 17);
   _actionMap[8][STREAM] = ActionEntry(SHIFT, 16);
   _actionMap[8][EMARK] = ActionEntry(SHIFT, 15);
   _actionMap[9][XMLTOKEN] = ActionEntry(SHIFT, 18);
   _actionMap[1][LT] = ActionEntry(SHIFT, 8);
   _actionMap[1][ENDTOKEN] = ActionEntry(REDUCE, 6);
   _jumpMap[1][ElementPre] = 7;
   _jumpMap[1][Elem] = 6;
   _jumpMap[1][StreamPre] = 5;
   _jumpMap[1][XMLTag] = 4;
   _jumpMap[1][XMLBody] = 3;
   _actionMap[2][QMARK] = ActionEntry(SHIFT, 9);
   _actionMap[0][LT] = ActionEntry(SHIFT, 2);
   _jumpMap[0][XMLHeader] = 1;
}
void XML::loadParser3()
{
   _prodInfo.Insert(ProdEntry(24, DataPre, 4));
   _prodInfo.Insert(ProdEntry(23, DataContent, 2));
   _prodInfo.Insert(ProdEntry(22, Data, 2));
   _prodInfo.Insert(ProdEntry(21, DataList, 0));
   _prodInfo.Insert(ProdEntry(20, DataList, 2));
   _prodInfo.Insert(ProdEntry(19, ElementList, 0));
   _prodInfo.Insert(ProdEntry(18, ElementList, 2));
   _prodInfo.Insert(ProdEntry(17, ElementPost, 5));
   _prodInfo.Insert(ProdEntry(16, ElementContent, 2));
   _prodInfo.Insert(ProdEntry(15, ElementPre, 3));
   _prodInfo.Insert(ProdEntry(14, Elem, 3));
   _prodInfo.Insert(ProdEntry(13, StreamContent, 5));
   _prodInfo.Insert(ProdEntry(12, StreamPre, 5));
   _prodInfo.Insert(ProdEntry(11, Elem, 2));
   _prodInfo.Insert(ProdEntry(10, Elem, 6));
   _prodInfo.Insert(ProdEntry(9, Elem, 5));
   _prodInfo.Insert(ProdEntry(8, XMLTag, 5));
   _prodInfo.Insert(ProdEntry(7, XMLTag, 1));
   _prodInfo.Insert(ProdEntry(6, XMLBody, 0));
   _prodInfo.Insert(ProdEntry(5, XMLBody, 2));
   _prodInfo.Insert(ProdEntry(4, Attr, 3));
   _prodInfo.Insert(ProdEntry(3, AttrList, 0));
   _prodInfo.Insert(ProdEntry(2, AttrList, 2));
   _prodInfo.Insert(ProdEntry(1, XMLHeader, 6));
   _prodInfo.Insert(ProdEntry(0, Start, 2));
}

XML::XML()
{
   loadScanner();
   for ( int i=0; i < 57; i++)
   {
      int j;
      for ( j = 0; j < 18; j++)
         _actionMap[i][j] = ActionEntry();
      for ( j = 0; j < 18; j++)
         _jumpMap[i][j] = -1;
   }
   loadParser0();
   loadParser1();
   loadParser2();
   loadParser3();
   _isReserved = false;
}

XML::~XML()
{
}

void XML::parse()
{
   StackT<StackEntry> s;
   StackEntry se(NONE, 0, 0);
   s.Push(se);
   _isReserved = false;
   if ( shiftToken() == false )
   {
      Chain msg = "Parse error at token <" + Chain(_tokenVal) + ">.";
      throw Exception(EXLOC, msg);
   }
   while ( true )
   {
      Action a;
      int num;
      if ( getAction(s.getTop()->getState(), _token, a, num) )
      {
         switch (a)
         {
            case SHIFT:
            {
               StackEntry se(TOKEN, _token, num, _tokenVal);
               s.Push(se);
               if ( shiftToken() == false )
               {
                  Chain msg = "Parse error at token <" + Chain(_tokenVal) + ">.";
                  throw Exception(EXLOC, msg);
               }
               break;
            }
            case REDUCE:
            {
               _tokenList.Empty();
               ProdEntry* pPE = _prodInfo.Find(num);
               for (int i=0; i<pPE->getNumSymbol();i++)
               {
                  StackEntry se;
                  s.Pop(se);
                  if (se.getSymbol() == TOKEN)
                     _tokenList.Insert(se.getTval());
               }
               int fstate;
               if (getJump(s.getTop()->getState(), pPE->getProd(), fstate))
               {
                  StackEntry se(PROD, pPE->getId(), fstate, _tokenVal);
                  s.Push(se);
               }
               else
               {
                  Chain msg = "Cannot reduce after token <" + Chain(_tokenVal) + ">.";
                  throw Exception(EXLOC, msg);
               }
               switch (num)
               {
                  case 24:
                     preData();
                     break;
                  case 23:
                     storeData();
                     break;
                  case 22:
                     putData();
                     break;
                  case 17:
                     postElement();
                     break;
                  case 16:
                     conElement();
                     break;
                  case 15:
                     preElement();
                     break;
                  case 13:
                     postStreamData();
                     break;
                  case 12:
                     preStreamData();
                     break;
                  case 10:
                     putStreamElement();
                     break;
                  case 9:
                     putElement();
                     break;
                  case 8:
                     putDocType();
                     break;
                  case 7:
                     putBody();
                     break;
                  case 4:
                     putAttribute();
                     break;
                  case 1:
                     putPreamble();
                     break;
               }
               break;
            }
            case ACCEPT:
            {
               return;
            }
            case NULLACTION:
               break;
         }
      }
      else
      {
         Chain msg = "Parse error at token <" + Chain(_tokenVal) + ">.";
         throw Exception(EXLOC, msg);
      }
   }
}


bool XML::getAction(int state, XML::Token token, XML::Action& a, int& num)
{
    if (_actionMap[state][token].getAction() != NULLACTION )
    {
	a = _actionMap[state][token].getAction();
	num = _actionMap[state][token].getNum();
	return true;
    }
    else
    {
	return false;
    }
}

bool XML::getJump(int state, Production prod, int& fstate)
{
    if ( _jumpMap[state][prod] > 0 )
    {
       fstate = _jumpMap[state][prod];
	    return true;
    }
    else
    {
	    return false;
    }
}

bool XML::isSepSign(char c)
{
   if (c == '[') return true;
   if (c == ']') return true;
   if (c == '=') return true;
   if (c == '/') return true;
   if (c == '<') return true;
   if (c == '>') return true;
   if (c == '?') return true;
   if (c == '!') return true;
   return false;
}
bool XML::isSepIgnore(char c)
{
   if (c == '\t') return true;
   if (c == '\n') return true;
   if (c == '\r') return true;
   if (c == ' ') return true;
   return false;
}
bool XML::shiftToken()
{
   unsigned long i=0;
   char c;
   while ( isSepIgnore(c = nextChar()) && ! _isReserved );
   if ( _isReserved )
   {
      _token = _reservedToken;
      _isReserved = false;
      return true;
   }
   if (c == 0)
   {
      _token = ENDTOKEN;
      return true;
   }
   if (isSepSign(c))
   {
      _tokenVal[i]=c;
       i++;
   }
   else
   {
      while (c && ! isSepIgnore(c) && ! ( isSepSign(c) && i>0 ) )
      {
         _tokenVal[i]=c;
         i++;
         c = nextChar();
      }
      if (isSepSign(c)) backChar();
   }
   _tokenVal[i]=0;
   Scanner* pS = _scannerList.First();
   while (pS)
   {
      if (pS->checkPattern(_tokenVal))
      {
         _token = pS->getToken();
         return true;
      }
      pS=_scannerList.Next();
   }
   return false;
}
void XML::setReserved(Token t)
{
   _reservedToken = t;
   _isReserved = true;
}
