// DirectoryTest.cc
// ----------------
// directory class test module
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2013 by Bjoern Lemke                        
//
//
///////////////////////////////////////////////////////////////////////////////

#include "../src/Exception.h"
#include "../src/Directory.h"

int main(int argc, char **argv)
{


    int numCheck = 2;
    int checkCount = 1;
    
    try
    {
	
	cout << "1.." << numCheck << endl;
	
	Directory testDir;
	
	testDir.setCurrent();
	
	// cout << "Current dir is " << testDir.getName() << endl;

	if ( testDir.exists() )
	    cout << "ok " << checkCount << " - directory exists" << endl;
	else
	    cout << "not ok " << checkCount << " - directory exists" << endl;
	checkCount++;
	
	ListT<Chain> dl = testDir.list();
	Chain *de = dl.First();
	while ( de )
	{
	    // cout << "Dir Entry : " << *de << endl;
	    de = dl.Next();
	}
	cout << "ok " << checkCount << " - directory entry" << endl;
	checkCount++;

    }
    catch (Exception e)
    {
	Chain msg;
	e.pop(msg);
	cout << "not ok " << checkCount << " - " << msg << endl;
	return 1;
    }
    
    return 0;

}
  

