///////////////////////////////////////////////////////////////////////////////
//                                                         
// CmdExeTest.cc
// ---------------
// CommandExecuter class test module
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2009 by Bjoern Lemke                        
//
//
///////////////////////////////////////////////////////////////////////////////

#include "../src/Exception.h"
#include "../src/CommandExecuter.h"
#include "../src/Chain.h"

int main(int argc, char **argv)
{

    int numCheck = 2;
    int checkCount = 1;
    
    try
    {

	cout << "1.." << numCheck << endl;
	
	CommandExecuter ce;
	
	Chain r;
	int retCode = ce.execute("/bin/sleep 1 > /dev/null", 2);
	
	cout << "ok " << checkCount << " - ReturnCode = " << retCode << endl;
	checkCount++;

	Chain streamResult = ce.executeStream("echo \"hello world\" 2>&1");
	cout << "ok " << checkCount << " - Stream Result = " << streamResult << endl;
	checkCount++;
	
    }
    catch (Exception e)
    {
	Chain msg;
	e.pop(msg);
	cout << "not ok " << checkCount << " - " << msg << endl;
	return 1;
    }

    return 0;


}

