///////////////////////////////////////////////////////////////////////////////
// 
// AVLTreeTest.cc - Testing the AVLTreeT template
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2013 by Bjoern Lemke                        
//
// IMPLEMENTATION MODULE
//
// Description: Testing the AVLTreeT class
//
///////////////////////////////////////////////////////////////////////////////


#include "../src/Exception.h"
#include "../src/AVLTreeT.h"

#include <stdlib.h>
#include <unistd.h>

int main(int argc, char **argv)
{



    int numCheck = 2;
    int checkCount = 1;
    
    try {
	
	
	cout << "1.." << numCheck << endl;
	
          
	srand(42);
	
	AVLTreeT<int> bTree;
		
	unsigned long  count = 1000;
	while (count)
	{		
	    int elem = rand() % (100 * count);	  
	    bTree.Insert(elem);	          
	    count--;	
	}

	cout << "ok " << checkCount << " - avl insert" << endl;
	checkCount++;
	
	int* pI = bTree.First();
	
	while ( pI )
	{
	    // cout << "Element is " << *pI << endl;
	    pI = bTree.Next();
	}
	
	cout << "ok " << checkCount << " - avl trace" << endl;
	checkCount++;
	
	
    }
    
    catch (Exception e)
    {
	
	Chain msg;
	e.pop(msg);
	cout << "not ok " << checkCount << " - " << msg << endl;
	return 1;
    }

    return 0;
          
}



