<!---
Automatically generated by tools/codegen/core/gen_trace_flags.py
--->

gRPC Trace Flags
----------------

The `GRPC_TRACE` environment variable supports a comma-separated list of tracer
names or glob patterns that provide additional insight into how gRPC C core is
processing requests via debug logs. Available tracers include:

% for flag, settings in trace_flags.items():
% if "internal" in settings and settings["internal"]:
<% continue %>
% endif
% if "debug_only" not in settings or not settings["debug_only"]:
% if settings["description"]:
  - ${flag} - ${settings["description"]}
% else:
  - ${flag}
% endif
% endif
% endfor

The following tracers will only run in binaries built in DEBUG mode. This is
accomplished by invoking `bazel build --config=dbg <target>`
% for flag, settings in trace_flags.items():
% if "internal" in settings and settings["internal"]:
<% continue %>
% endif
% if "debug_only" in settings and settings["debug_only"]:
% if settings["description"]:
  - ${flag} - ${settings["description"]}
% else:
  - ${flag}
% endif
% endif
% endfor

Glob patterns and special cases:
  - `*` can be used to turn all traces on.
  - Individual traces can be disabled by prefixing them with `-`.
  - `*refcount*` will turn on all of the tracers for refcount debugging.
  - if `list_tracers` is present, then all of the available tracers will be
    printed when the program starts up.

Example:
export GRPC_TRACE=*,-pending_tags
