// Copyright 2025 gRPC authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "test/cpp/sleuth/tool_options.h"

#include "absl/flags/flag.h"
#include "src/core/ext/transport/chaotic_good/chaotic_good.h"
#include "test/cpp/sleuth/tool_credentials.h"

ABSL_FLAG(std::string, channelz_protocol, "h2", "Channelz protocol to use");

namespace grpc_sleuth {

Client::Options ToolClientOptions() {
  // Ensure chaotic good is linked in.
  grpc_core::chaotic_good::WireFormatPreferences();
  return Client::Options{
      ToolCredentials(),
      absl::GetFlag(FLAGS_channelz_protocol),
  };
}

}  // namespace grpc_sleuth
