"""
In the thread view, the selection should change the current thread.
"""
import GPS
from gs_utils.internal.utils import *
import re

NUMBER_COLUMN = 0


@run_test_driver
def test_driver():
    yield wait_tasks()

    buf = GPS.EditorBuffer.get(GPS.File("main.adb"))
    buf.current_view().goto(buf.at(23, 1))
    GPS.process_all_events()
    yield wait_idle()
    yield wait_until_true(
        lambda: GPS.Action("debug set line breakpoint").can_execute() == False
    )
    GPS.execute_action("debug set line breakpoint")
    yield wait_idle()

    GPS.execute_action("Build & Debug Number 1")
    yield hook("debugger_started")
    yield wait_idle()

    debug = GPS.Debugger.get()
    yield wait_until_not_busy(debug)

    # Run the debugger and wait until it reaches
    # the breakpoint
    debug.send("run")
    yield hook("debugger_location_changed")

    NAME_COLUMN = 1

    # Open the Threads view and check that we have selected
    # the right thread
    GPS.execute_action("open threads debugger window")
    yield wait_for_mdi_child("Threads")
    yield wait_until_not_busy(debug)

    view = GPS.MDI.get("Threads")
    tree = get_widgets_by_type(Gtk.TreeView, view.pywidget())[0]
    model = tree.get_model()
    yield wait_idle()
    gps_assert(
        dump_tree_model(model, NUMBER_COLUMN),
        ["1", "2", "* 3"],
        "Wrong thread selected when stopping",
    )
    gps_assert(
        dump_tree_model(model, NAME_COLUMN),
        ["main", "foo", "bar"],
        "Wrong thread name when stopping",
    )

    click_in_tree(tree, "1")
    yield wait_until_not_busy(debug)
    GPS.process_all_events()
    yield wait_idle()
    gps_assert(
        dump_tree_model(model, NUMBER_COLUMN),
        ["1", "* 2", "3"],
        "Wrong thread selected when selecting",
    )
