---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

<!--
This documentation is auto generated by a script.
Please do not edit this file directly. Run `make gen-docs` instead.
-->

# `glab token list`

List user, group, or project access tokens.

## Synopsis

List all tokens of a user, group, or project.

The output contains the token's meta information, not the actual token value. The output format
can be "JSON" or "text". The access level property is printed in human-readable form in the text
output, but displays the integer value in JSON.

Administrators can list tokens of other users.

```plaintext
glab token list [flags]
```

## Aliases

```plaintext
ls
```

## Examples

```console
List the current project's access tokens
- glab token list
- glab token list --output json

List the project access tokens of a specific project
- glab token list --repo user/my-repo

List group access tokens
- glab token list --group group/sub-group

List my personal access tokens
- glab token list --user @me

Administrators only: list the personal access tokens of another user
- glab token list --user johndoe

```

## Options

```plaintext
  -a, --active            List only the active tokens.
  -g, --group string      List group access tokens. Ignored if a user or repository argument is set.
  -F, --output string     Format output as: text, json. text provides a readable table, json outputs the tokens with metadata. (default "text")
  -R, --repo OWNER/REPO   Select another repository. Can use either OWNER/REPO or `GROUP/NAMESPACE/REPO` format. Also accepts full URL or Git URL.
  -U, --user string       List personal access tokens. Use @me for the current user.
```

## Options inherited from parent commands

```plaintext
  -h, --help   Show help for this command.
```
