/* { dg-do run { target { aarch64_sve256_hw && aarch64_sve2p1_hw } } } */
/* { dg-options "-O2 -msve-vector-bits=256" } */

#include "dupq_1.c"

#define TEST(A, B)							\
  do {									\
    typeof(B) actual_ = (A);						\
    if (__builtin_memcmp (&actual_, &(B), sizeof (actual_)) != 0)	\
      __builtin_abort ();						\
  } while (0)

int
main ()
{
  fixed_uint64_t a64 = { 0x1122, -1, 0x5566, -2 };
  fixed_int32_t a32 = { 0x1122, -0x3344, 0x5566, -0x7788,
			0x99aa, -0xbbcc, 0xddee, -0xff00 };
  fixed_uint16_t a16 = { 0x9a12, 0xbc34, 0xde56, 0xf078,
			 0x00ff, 0x11ee, 0x22dd, 0x33cc,
			 0x44bb, 0x55aa, 0x6699, 0x7788,
			 0xfe01, 0xdc23, 0xba45, 0x9867 };
  fixed_uint8_t a8 = { 0x01, 0x12, 0x23, 0x34, 0x45, 0x56, 0x67, 0x70,
		       0x89, 0x9a, 0xab, 0xbc, 0xcd, 0xde, 0xef, 0xf8,
		       0xfe, 0xed, 0xdc, 0xcb, 0xba, 0xa9, 0x98, 0x8f,
		       0x76, 0x65, 0x54, 0x43, 0x32, 0x21, 0x10, 0x07 };

  fixed_uint64_t expected1 = { 0x1122, 0x1122, 0x5566, 0x5566 };
  TEST (f1 (a64), expected1);

  fixed_uint64_t expected2 = { -1, -1, -2, -2 };
  TEST (f2 (a64), expected2);

  fixed_int32_t expected3 = { 0x1122, 0x1122, 0x1122, 0x1122,
                              0x99aa, 0x99aa, 0x99aa, 0x99aa };
  TEST (f3 (a32), expected3);

  fixed_int32_t expected4 = { -0x3344, -0x3344, -0x3344, -0x3344,
			      -0xbbcc, -0xbbcc, -0xbbcc, -0xbbcc };
  TEST (f4 (a32), expected4);

  fixed_int32_t expected5 = { 0x5566, 0x5566, 0x5566, 0x5566,
                              0xddee, 0xddee, 0xddee, 0xddee };
  TEST (f5 (a32), expected5);

  fixed_int32_t expected6 = { -0x7788, -0x7788, -0x7788, -0x7788,
			      -0xff00, -0xff00, -0xff00, -0xff00 };
  TEST (f6 (a32), expected6);

  fixed_uint16_t expected7 = { 0x9a12, 0x9a12, 0x9a12, 0x9a12,
			       0x9a12, 0x9a12, 0x9a12, 0x9a12,
			       0x44bb, 0x44bb, 0x44bb, 0x44bb,
			       0x44bb, 0x44bb, 0x44bb, 0x44bb };
  TEST (f7 (a16), expected7);

  fixed_uint16_t expected8 = { 0x11ee, 0x11ee, 0x11ee, 0x11ee,
			       0x11ee, 0x11ee, 0x11ee, 0x11ee,
			       0xdc23, 0xdc23, 0xdc23, 0xdc23,
			       0xdc23, 0xdc23, 0xdc23, 0xdc23 };
  TEST (f8 (a16), expected8);

  fixed_uint16_t expected9 = { 0x33cc, 0x33cc, 0x33cc, 0x33cc,
			       0x33cc, 0x33cc, 0x33cc, 0x33cc,
			       0x9867, 0x9867, 0x9867, 0x9867,
			       0x9867, 0x9867, 0x9867, 0x9867 };
  TEST (f9 (a16), expected9);

  fixed_uint8_t expected10 = { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
			       0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
			       0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
			       0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe };
  TEST (f10 (a8), expected10);

  fixed_uint8_t expected11 = { 0xde, 0xde, 0xde, 0xde, 0xde, 0xde, 0xde, 0xde,
			       0xde, 0xde, 0xde, 0xde, 0xde, 0xde, 0xde, 0xde,
			       0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
			       0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21 };
  TEST (f11 (a8), expected11);

  fixed_uint8_t expected12 = { 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8,
			       0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8,
			       0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
			       0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07 };
  TEST (f12 (a8), expected12);

  return 0;
}
